Ext.define('currentAlarms.controller.Main',{
	extend:'Ext.app.Controller',
	requires: ['currentAlarms.view.Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'currentalarmssummary', ref:'currentalarmssummary'},
		{selector:'acknowledgementpanel', ref:'acknowledgementpanel'},
		{selector:'alarmfilters', ref:'alarmfilters'},
	],
	init:function()
	{
		this.control(
		{
			'main':
			{
				'boxready': this.loadDefaults
			},
			'alarmfilters button[id=backButton]':
			{
				'click' : this.goBack
			},
			'currentalarmssummary':
			{
				'afterrender': this.aftercurrentalarmssummary,
			},
			'alarmfilters combo[name="showCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmfilters combo[name="filterCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmfilters combo[name="subFilterCombo"]':
			{
				'select' : this.loadAlarms
			},
			'alarmfilters combo[name="searchByCombo"]':
			{
				'select' : this.loadAlarms
			},
			'main textfield[name="searchTextBox"]':
			{
				'keyup' : this.searchAlarms
			},
			'#searchTextBox' : {
				'ontriggerclick': this.searchAlarms
			},
			'acknowledgementpanel button[id="submitBtn"]':
			{
				'click' : this.alarmAckSubmit
			},
			'acknowledgementpanel button[id="unAckBtn"]':
			{
				'click' : this.goToUnAcknowledge
			},
			'acknowledgementpanel button[id="clearBtn"]':
			{
				'click' : this.clearAckDescription
			},
			'main commonbackbutton':
			{
				'click' : function(){
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
					//window.history.back();
				}
			},
			'alarmfilters button[action=Save CSV]':{
				click : this.saveInCSVFormat
			},
			'alarmfilters button[action=Save PDF]' : {
				click : this.saveInPDFFormat
			},
		});
	},
	saveInCSVFormat : function()
	{
		if(!Ext.isEmpty(this.getCurrentalarmssummary()) && this.getCurrentalarmssummary().getStore().getCount()>0){
			try{
				var searchValue = "";
				var s_qryString = "";
				var showCombo = Ext.getCmp("showCombo");
				var filterCombo = Ext.getCmp("filterCombo");
				var subFilterCombo = Ext.getCmp("subFilterCombo");
				var equals = encodeURIComponent("|eq|");
				if(!Ext.isEmpty(showCombo))
					s_qryString += "&filterValue3="+showCombo.getFieldLabel()+equals+showCombo.getRawValue();
				if(!Ext.isEmpty(filterCombo))
					s_qryString += "&filterValue2="+filterCombo.getFieldLabel()+equals+filterCombo.getRawValue();
				if(!Ext.isEmpty(subFilterCombo)){
					var subFilterComboValue = subFilterCombo.getRawValue();
					try{
						subFilterComboValue = parent.filterEncode(subFilterComboValue);
					}
					catch (e){
						try{
							subFilterComboValue = window.opener.filterEncode(subFilterComboValue);
						}
						catch (e){
							subFilterComboValue = parent.parent.filterEncode(subFilterComboValue);
						}
					}
					s_qryString += "&filterValue1="+subFilterCombo.getFieldLabel()+equals+encodeURIComponent(subFilterComboValue);
				}
				var searchField = Ext.getCmp('searchTextBox');
				if(!Ext.isEmpty(searchField) && !Ext.isEmpty(searchField.getValue())){
					searchValue = searchField.getValue();
					try{
						searchValue = parent.filterEncode(searchValue);
					}
					catch (e){
						try{
							searchValue = window.opener.filterEncode(searchValue);
						}
						catch (e){
							searchValue = parent.parent.filterEncode(searchValue);
						}
					}
					s_qryString += "&searchValue="+encodeURIComponent(searchValue);
				}
				var soringItems = this.getCurrentalarmssummary().getStore().sorters.items;
				if(!Ext.isEmpty(soringItems)){
					var prop = soringItems[0].property;
					try
					{
  						prop= prop.substring(prop.indexOf("_")+1);
  						if(prop != null && prop >= 10)
  							prop-=3
					}catch (e)
					{
            			prop= prop.substring(prop.length-1);
					}
					s_qryString += "&sortingDirection="+soringItems[0].direction+"&sortingColumn="+prop;
				}
				if(!Ext.isEmpty(searchValue) || !Ext.isEmpty(soringItems)){
					Ext.Ajax.request({
						url : '/final/monitor/currentAlarmsPdf.jsp?loadCSV=true'+s_qryString,
						scope:this,
						success: function(response){
							var jsonText = response.responseText;
							window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes&searchSorting=true"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
						},
						failure:function(){
							window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
						}
					});
				}
				else
					window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
			catch (e){
				window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?currentAlarms=Yes"+s_qryString,"CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'ALERT',
				msg: "No Alarm Found",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
	},
	saveInPDFFormat : function()
	{
		var s_qryString = "/final/servlet/com.eg.EgPdfDownloadC?from=currentAlarm";
		if(!Ext.isEmpty(this.getCurrentalarmssummary()) && this.getCurrentalarmssummary().getStore().getCount()>0)
		{
			try
			{
				var showCombo = Ext.getCmp("showCombo");
				var filterCombo = Ext.getCmp("filterCombo");
				var subFilterCombo = Ext.getCmp("subFilterCombo");
				if(!Ext.isEmpty(showCombo))
					s_qryString += "&filterValue3="+showCombo.getFieldLabel()+" : "+showCombo.getRawValue();
				if(!Ext.isEmpty(filterCombo))
					s_qryString += "&filterValue2="+filterCombo.getFieldLabel()+" : "+filterCombo.getRawValue();
				if(!Ext.isEmpty(subFilterCombo)){
					var subFilterComboValue = subFilterCombo.getRawValue();
					try{
						subFilterComboValue = parent.filterEncode(subFilterComboValue);
					}
					catch (e){
						try{
							subFilterComboValue = window.opener.filterEncode(subFilterComboValue);
						}
						catch (e){
							subFilterComboValue = parent.parent.filterEncode(subFilterComboValue);
						}
					}
					s_qryString += "&filterValue1="+subFilterCombo.getFieldLabel()+" : "+encodeURIComponent(subFilterComboValue);
				}
				var searchField = Ext.getCmp('searchTextBox');
				var searchValue = "";
				if(!Ext.isEmpty(searchField) && !Ext.isEmpty(searchField.getValue()))
				{
					searchValue = searchField.getValue();
					try{
						searchValue = parent.filterEncode(searchValue);
					}
					catch (e){
						try{
							searchValue = window.opener.filterEncode(searchValue);
						}
						catch (e){
							searchValue = parent.parent.filterEncode(searchValue);
						}
					}
					s_qryString += "&searchValue="+encodeURIComponent(searchValue);
				}
				var soringItems = this.getCurrentalarmssummary().getStore().sorters.items;
				if(!Ext.isEmpty(soringItems))
				{
					var prop = soringItems[0].property;
					var index="";
					try
					{
  						index = parseInt(prop.substring(prop.indexOf("_")+1));
  						if(index != null && index >= 10)
  							index-=3
					}catch (e)
					{
						index = parseInt(prop.substring(prop.length-1));
					}
					var showCombo = Ext.getCmp("showCombo").getValue();
					if(!Ext.isEmpty(showCombo) && showCombo == "CurrentUnknown")
						  index += 1;
					s_qryString += "&sortingDirection="+soringItems[0].direction+"&sortingColumn="+index;
				}
				var  progressBar= Ext.MessageBox.progress({
					title: 'Downloading',
					value: 5,
					width: 350,
					increment: 15,
					closable: false,
					progressText: 'Connecting..',
					wait: true,
					waitConfig: {
						interval: 200
					},
					msg: '<b>Downloading, please wait...</b>',
					scope: this,
					handler: function () {
						this.updateText('Done!');
					}
				});
				var iFrameExists = Ext.query("#pdfIframe");
				if(Ext.isEmpty(iFrameExists))
				{
					Ext.DomHelper.append(document.body, {
						tag: 'iframe',
						frameBorder: 0,
						width: 0,
						height: 0,
						css: 'display:none;visibility:hidden;height:1px;',
						src: s_qryString,
						id: 'pdfIframe'
					});
				}
				else
				{
					Ext.select('#pdfIframe').set( { src :  s_qryString });
				}
				Ext.Ajax.request({
					url : '/final/monitor/EgSaveStatus.jsp?downloadFile=true',
					scope:this,
					//timeout:5000,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData))
						{
							var downloadStatus = jsonData.downloadStatus;
							try
							{
								if(downloadStatus.toUpperCase() == 'DONE')
								{
									progressBar.hide();
								}
							}
							catch (e)
							{
								progressBar.hide();
							}
						}
					},
					failure:function(response){
						progressBar.hide();
					}
				});
			}
			catch (e)
			{
				progressBar.hide();
				console.log(e)
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'ALERT',
				msg: "No Alarm Found",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
	},
	aftercurrentalarmssummary: function()
	{	
		if(isPopupWindow!=null && isPopupWindow=="true")
		{
			
		}
		else
		{
			Ext.getCmp('currentAlarmsGrid').setHeight(570);
			Ext.getCmp('currentAlarmsGrid').doLayout();
			Ext.getCmp('currentAlarmsGrid').doComponentLayout();
			Ext.getCmp('currentalarmsmain').doLayout();
			Ext.getCmp('currentalarmsmain').doComponentLayout();
		}
	},
	checkSpecialCharacter: function (name) {
        var splChar = "=\"";
        for (var i = 0; i < name.length; i++) {
            check_char = splChar.indexOf(name.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
        return false;
    },
	clearAckDescription : function()
	{
		Ext.getCmp('textaraObj').setValue('');
	},
	goToUnAcknowledge : function()
	{
		var des = Ext.getCmp('textaraObj').getValue();

		if(!checkblankVal(des))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				//msg: unAckAlertMsg,
				msg: unAckDescriptionAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			Ext.MessageBox.confirm('Confirm', unAckDeleteConfirmAlert,this.unAcknowledgeAlarm,this);
		}
	},
	unAcknowledgeAlarm : function(btn)
	{
		if(btn=="yes")
		{
			var des = Ext.getCmp('textaraObj').getValue();
			/*var ackAlarmIDs = alarmAckHiddenParams['ackAlarmIDs'];

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}
		//	EgAckForm.hiddesc.value=des;
			while(ackAlarmIDs.indexOf("+")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("+","|plus|");
			}
			while(ackAlarmIDs.indexOf("&")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("&","|amp|");
			}
			while(ackAlarmIDs.indexOf("%")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("%","|pct|");
			}*/
			var userAck = alarmAckHiddenParams['userAck'];
			var alarmId = alarmAckHiddenParams['alarmId'];
			var vmfromAlarm = alarmAckHiddenParams['vmfromAlarm'];
			var ackAlarmDB = "Unacknowledge";
			try
			{
				des = window.opener.filterEncode(des);
			}
			catch (e)
			{
				des = parent.filterEncode(des);
			}
			//var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmIDs=" +encodeURI(ackAlarmIDs)+ "&ackAlarmDB="+ackAlarmDB;
			var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" + userId + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmDB="+ackAlarmDB+"&ackAlarmIDs="+encodeURIComponent(vmfromAlarm);

			Ext.getCmp('ackWindowObj').destroy();
			var meController = this;
			var emtText = Ext.get("emptyTextTb");
			try
			{
				if(emtText != null)
				Ext.get("emptyTextTb").hide();
			}
			catch (e)
			{
			}
			alarmLoadMask.show();
			var browser=get_browser_info();
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: QStr+'&doAlarmAcknowledgementEvent=true&acknowledgementEvent=unAcknowledge&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&isFromQuickLink="+isFromQuickLink,
				scope:this,
				success: function(response)
				{
					//var jsonText = response.responseText;
					//console.log(jsonText);
					//var jsonData=Ext.decode(jsonText);
					var jsonData = JSON.parse( response.responseText );
					var acknowledge = jsonData['unacknowledge'];

					alarmLoadMask.hide();
					if(ttIntegrationenabled!=null && ttIntegrationenabled=="Yes" || ttIntegrationenabled=="true")
					{
						var queryStr = "sendTTAcknowledgement=true&desc="+encodeURIComponent(des)+"&alarm_Id=" + alarmId;
						Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgCurrentAlarmsC',
							method : 'POST',
							params: queryStr,
							scope:this,
							success: function(response)
							{
								var jsonData = JSON.parse( response.responseText );
							}
						});
					}
					meController.loadAlarms(null);

				}
			});
		}
		else
		{
			return false;
		}
	},
	alarmAckSubmit : function(buttonObj)
	{
		var alarmAckEvent =  alarmAckHiddenParams['alarmAckEvent'];

		if(alarmAckEvent!=null)
		{
			if(alarmAckEvent=="Delete_Alarm")
			{
				this.alarmDelete(buttonObj);
			}
			else if(alarmAckEvent=="AckOrUnack")
			{
				this.alarmAcknowledge(buttonObj);
			}
		}
	},
	alarmAcknowledge : function(buttonObj)
	{
		var des = Ext.getCmp('textaraObj').getValue();
		var description=true;
		if(isDoubleByteEnabled=="false")
			description = validateSingleByte(des);
		if(!checkblankVal(des))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: ackDescriptionAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else if (this.checkSpecialCharacter(des)) {
                Ext.Msg.show({
                    title: "Alert",
                    msg: ackDescriptionSplCharAlert,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
		}
		else if(!description)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: ackdbyteAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			if(isDoubleByteEnabled && isOracleDB)
			{
				if(des!=null && des!='' && des.length>1024)
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: maxAcknowledgeDescForDByte,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			else if(des!=null && des!='' && des.length>2048)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: maxAcknowledgeDescForSByte,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}

			if(des==null || des=='')
				des = "-";

			/*var ackAlarmIDs = alarmAckHiddenParams['ackAlarmIDs'];

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}
		//	EgAckForm.hiddesc.value=des;
			while(ackAlarmIDs.indexOf("+")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("+","|plus|");
			}
			while(ackAlarmIDs.indexOf("&")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("&","|amp|");
			}
			while(ackAlarmIDs.indexOf("%")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("%","|pct|");
			}*/
			var userAck = alarmAckHiddenParams['userAck'];
			var alarmId = alarmAckHiddenParams['alarmId'];
			var ackAlarmDB = alarmAckHiddenParams['ackAlarmDB'];
			var vmfromAlarm = alarmAckHiddenParams['vmfromAlarm'];
			
			try
			{
				des = window.opener.filterEncode(des);
			}
			catch (e)
			{
				des = parent.filterEncode(des);
			}
			
			//var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmIDs=" +encodeURI(ackAlarmIDs)+ "&ackAlarmDB="+ackAlarmDB;
			var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" + userId + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmDB="+ackAlarmDB+"&ackAlarmIDs="+encodeURIComponent(vmfromAlarm);
			Ext.getCmp('ackWindowObj').destroy();
			var meController = this;
			var emtText = Ext.get("emptyTextTb");
			try
			{
				if(emtText != null)
				Ext.get("emptyTextTb").hide();
			}
			catch (e)
			{
			}
			alarmLoadMask.show();

			var browser=get_browser_info();
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: QStr+'&doAlarmAcknowledgementEvent=true&acknowledgementEvent=acknowledge&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&isFromQuickLink="+isFromQuickLink,
				scope:this,
				success: function(response)
				{
					//var jsonText = response.responseText;
					//console.log(jsonText);
					//var jsonData=Ext.decode(jsonText);
					var jsonData = JSON.parse( response.responseText );
					var acknowledge = jsonData['acknowledge'];
					alarmLoadMask.hide();
					if(ttIntegrationenabled!=null && ttIntegrationenabled=="Yes" || ttIntegrationenabled=="true")
					{
						var queryStr = "sendTTAcknowledgement=true&desc="+encodeURIComponent(des)+"&alarm_Id=" + alarmId;
						Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgCurrentAlarmsC',
							method : 'POST',
							params: queryStr,
							scope:this,
							success: function(response)
							{
								var jsonData = JSON.parse( response.responseText );
							}
						});
					}

					//meController.loadAlarms(buttonObj);
					var searchField = Ext.getCmp('searchTextBox');
					if(!Ext.isEmpty(searchField.getValue()))
					{
						this.searchAlarms(searchField,'fire');
					}
					else
					{
						searchField.setValue('');
						meController.loadAlarms(buttonObj);
					}
				}
			});
		}
	},
	alarmDelete : function(button)
	{
		var des = Ext.getCmp('textaraObj').getValue();

		var description=true;

		if(isDoubleByteEnabled=="false")
			description = validateSingleByte(des);


		if (this.checkSpecialCharacter(des)) {
                Ext.Msg.show({
                    title: "Alert",
                    msg: ackDescriptionSplCharAlert,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
		}
		else if(!description)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: ackdbyteAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			if(isDoubleByteEnabled && isOracleDB)
			{
				if(des!=null && des!='' && des.length>1024)
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: maxAcknowledgeDescForDByte,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			else if(des!=null && des!='' && des.length>2048)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: maxAcknowledgeDescForSByte,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}

			if(des==null || des=='')
				des = "-";
			
			try
			{
				des = window.opener.filterEncode(des);
			}
			catch (e)
			{
				des = parent.filterEncode(des);
			}
			publicJson['hiddenParams']['userID'] = alarmAckHiddenParams['userId'];
			publicJson['hiddenParams']['alarmID'] = alarmAckHiddenParams['alarmId'];
			publicJson['hiddenParams']['desc'] = des;
			//publicJson['hiddenParams']['delAlarmIDs'] = alarmAckHiddenParams['ackAlarmIDs'];
			publicJson['hiddenParams']['isDelAlarms'] = "true";
			publicJson['hiddenParams']['ackAlarmDbDelete'] = alarmAckHiddenParams['ackdelAlarmDb'];
			publicJson['hiddenParams']['delAlarmIDs'] = '';
			var strDeleteView=alarmAckHiddenParams['ackdelAlarmDb'];
			if(eventDeleteFlag && !Ext.isEmpty(strDeleteView) && strDeleteView!=undefined && strDeleteView!='undefined' && strDeleteView=='Delete Alarm')
			{
				var optionVal=Ext.getCmp('option').getValue();
				if(!Ext.isEmpty(optionVal) && optionVal!=undefined && optionVal=='All')
				{
					publicJson['hiddenParams']['deleteOptions'] = optionVal;
				}
				else if(!Ext.isEmpty(optionVal) && optionVal!=undefined && optionVal=='Selected')
				{
					publicJson['hiddenParams']['deleteOptions'] = optionVal;

					var selectedInfos = '';
					var descriptorsObj=null;
					if(eventGrpDeleteFlag)
					{
						descriptorsObj = Ext.getCmp('selEventDescriptors');
					}
					else
					{
						descriptorsObj = Ext.getCmp('selDescriptors');
					}

					if(!Ext.isEmpty(descriptorsObj))
					{
						var splitDescriptorsNames=descriptorsObj.getValue();
						var store_data=descriptorsObj.getStore();
						if(!Ext.isEmpty(store_data) && !Ext.isEmpty(splitDescriptorsNames))
						{
							for(var m=0;m<splitDescriptorsNames.length;m++)
							{
								var selected_info=splitDescriptorsNames[m];
								for(var k=0;k<store_data.getCount();k++)
								{
									var store_info=store_data.getAt(k).data.value;
									if(store_info==selected_info)
									{
										if(selectedInfos=="")
										{
											selectedInfos=selected_info;
										}
										else
										{
											selectedInfos=selectedInfos+"~!~"+selected_info;
										}
									}
								}
							}
						}
					}
					publicJson['hiddenParams']['deleteSelectedInfos'] = selectedInfos;
				}
			}

			var QStr = this.updateQueryString(button.getId());
			Ext.getCmp('ackWindowObj').destroy();
			var meController = this;
			var emtText = Ext.get("emptyTextTb");
			try
			{
				if(emtText != null)
				Ext.get("emptyTextTb").hide();
			}
			catch (e)
			{
			}
			alarmLoadMask.show();
			var browser=get_browser_info();
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&isFromQuickLink="+isFromQuickLink,
				scope:this,
				success: function(response)
				{
					//var jsonText = response.responseText;
					//var jsonData=Ext.decode(jsonText);
					var jsonData = JSON.parse( response.responseText );
					publicJson = jsonData;
					alarmLoadMask.hide();
					if(ttIntegrationenabled!=null && ttIntegrationenabled=="Yes" || ttIntegrationenabled=="true")
					{
						var alarmId = alarmAckHiddenParams['alarmId'];
						var queryStr = "sendTTAcknowledgement=true&desc="+encodeURIComponent(des)+"&alarm_Id=" + alarmId;
						Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgCurrentAlarmsC',
							method : 'POST',
							params: queryStr,
							scope:this,
							success: function(response)
							{
								var jsonData = JSON.parse( response.responseText );
							}
						});
					}

					meController.loadDefaults(true);
					publicJson['hiddenParams']['alarmID'] = '';
					publicJson['hiddenParams']['desc'] = '';
					publicJson['hiddenParams']['delAlarmIDs'] = '';
					publicJson['hiddenParams']['isDelAlarms'] = "false";
					publicJson['hiddenParams']['ackAlarmDbDelete'] = '';
					publicJson['hiddenParams']['deleteOptions'] = '';
					publicJson['hiddenParams']['deleteSelectedInfos'] = '';
				}
			});
		}
	},
	loadDefaults : function(fromAjax){
		if((Ext.isEmpty(publicJson['Current_Alarms']) || publicJson['Current_Alarms']=='undefined')&& (Ext.isEmpty(publicJson['History_Alarms']) || publicJson['History_Alarms']=='undefined'))
		{
			var meC=this;
			var dataAvailable = publicJson['dataAvailable'];
			var mainView = this.getMain();
			if(fromAjax)
				mainView.removeAll();

			var alarmsUICompsArr=new Array();
			if(!isUED)
			{
				alarmsUICompsArr.push(				
						{
						xtype : 'alarmfilters'
						}
					);
			}
			var alarmsGrdHei=575;	
			if(isPopupWindow!=null && isPopupWindow=="true")
			{		
				alarmsGrdHei=335;
			}

			if(dataAvailable!=null && dataAvailable=='true')
			{
				alarmsUICompsArr.push({
						xtype: 'currentalarmssummary',
						height : alarmsGrdHei
					}
				);
				//Ext.getCmp('currentAlarmsGrid').getHeight();
			}
			else
			{
				var errorMsg = publicJson['errorMsg'];
				if(!Ext.isEmpty(errorMsg))
				{
						alarmsUICompsArr.push({
						xtype:'currentalarmssummary',
						height : alarmsGrdHei,
						emptyText : '<table width="100%" id="emptyTextTb"><tr><td align="center" valign="middle"><div class="iconNoalarms" style="margin:12% auto 0% auto"></div>'+errorMsg+'</td></tr></table>'

					});
				}
			}
			var soundTag = publicJson['soundTag'];
			if(soundTag==null || soundTag=="undefined")
				soundTag="";

			alarmsUICompsArr.push({
					xtype : 'container',
					cls:'x-hidden',
					id : 'currentAlarmsSoundAlertDiv',
					name : 'currentAlarmsSoundAlertDiv',
					html : soundTag
			});
			var showDeleteBtn = publicJson['pageParams']['showDeleteBtn'];
			var showAcknowledgeBtn = publicJson['pageParams']['showAcknowledgeBtn'];	
			if((showDeleteBtn!=null && showDeleteBtn=='true') || (showAcknowledgeBtn!=null && showAcknowledgeBtn=='true'))
			{				
						alarmsUICompsArr.push({
						xtype : 'acknowledgementoptions'
						}
				);
			}		
			mainView.add(alarmsUICompsArr);
			mainView.doLayout();
			this.getCurrentalarmssummary().loadData();
			metaRefreshUrl = publicJson['pageParams']['metaRefreshUrl'];
			metaRefreshUrl = metaRefreshUrl+'&isFromDashBoard='+!hideBackButton;
			metaRefreshUrl = urlParamReplace(metaRefreshUrl);
		}
	},
	ajaxCall: function(metaRefreshUrl,browser,showCombo,filterCombo,subFilterCombo,currentAlarmsSoundAlertDiv,currentAlmsGrid,mainView1){
		Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: metaRefreshUrl,
				scope:this,
				success: function(response)
				{
					var loadedPage = 1;

					var jsonData = window.JSON && window.JSON.parse ? window.JSON.parse( response.responseText ) : (new Function("return " + response.responseText))();
					publicJson = jsonData;
					Ext.destroy(alarmLoadMask);

					try
					{
						loadedPage = currentAlmsGrid.getStore().currentPage;						
					}
					catch (er){}
					
					if(disablerefresh || loadedPage > 1)
						return;

					var meApp = this;
					if(isPopupWindow!=null && isPopupWindow=="true")
					{
						AlarmsMainTitle='';
					}

					var pageParams = publicJson['pageParams'];
					if(!Ext.isEmpty(showCombo) && !Ext.isEmpty(pageParams) && !Ext.isEmpty(pageParams['selectedShowOption']))
					{
						showCombo.getStore().loadRawData([]);
						showCombo.getStore().loadRawData(publicJson['showOptionsJson']);
						showCombo.setValue(pageParams['selectedShowOption']);
					}
					if(!Ext.isEmpty(filterCombo) && !Ext.isEmpty(pageParams) && !Ext.isEmpty(pageParams['selectedFilterOption']))
					{
						filterCombo.clearValue();
						filterCombo.applyEmptyText();
						filterCombo.getStore().loadRawData(publicJson['filterOptions']);
						filterCombo.setValue(pageParams['selectedFilterOption']);
					}
					if(!Ext.isEmpty(subFilterCombo) && !Ext.isEmpty(pageParams) && !Ext.isEmpty(pageParams['selectedSubFilterOption']))
					{
						subFilterCombo.getStore().loadRawData(publicJson['optionsForFilterSelection']);
						subFilterCombo.clearValue();
						subFilterCombo.applyEmptyText();
						subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
					}

					if(!Ext.isEmpty(subFilterCombo) && (Ext.isEmpty(subFilterCombo.getValue()) || subFilterCombo.getValue()==undefined || subFilterCombo.getValue()==null))
					{
						subFilterCombo.setValue(subFilterCombo.getStore().getAt(0).get('valueField'));
					}
					var showDeleteBtn = pageParams['showDeleteBtn'];
					var showAcknowledgeBtn = pageParams['showAcknowledgeBtn'];
					if((showDeleteBtn!=null && showDeleteBtn=='true') || (showAcknowledgeBtn!=null && showAcknowledgeBtn=='true'))
					{
						//Ext.getCmp('ackOptionsContainer').show();
					}
					
					
					var dataAvailable = publicJson['dataAvailable'];
					if(dataAvailable!=null && dataAvailable=='true')
					{
						var soundTag = publicJson['soundTag'];
						if(soundTag!=null && soundTag!="undefined")
						{
							if(!Ext.isEmpty(currentAlarmsSoundAlertDiv))
							{
								currentAlarmsSoundAlertDiv.update(soundTag);
							}
							currentAlarmsSoundAlertDiv=null;
							delete currentAlarmsSoundAlertDiv;
						}
						if(showDeleteBtn!=null && showDeleteBtn=='true' && !Ext.isEmpty(showCombo) && showCombo.getValue()!="CurrentUnknown")
						{
							if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
							{
								mainView1.add({xtype:'acknowledgementoptions'});
							}
							Ext.getCmp('ackOptionsid').show();
							Ext.getCmp('AlarmDeleteBtn').show();
						}
						else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && !Ext.isEmpty(showCombo) && showCombo.getValue()=="CurrentUnknown")
						{
							Ext.getCmp('ackOptionsid').hide();
						}
						if(showAcknowledgeBtn!=null && showAcknowledgeBtn=='true' && !Ext.isEmpty(showCombo)  && showCombo.getValue()!="CurrentUnknown")
						{
							if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
							{
								mainView1.add({xtype:'acknowledgementoptions'});
							}
							Ext.getCmp('ackOptionsid').show();
							Ext.getCmp('AlarmAcknowledgeBtn').show();
						}
						else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && !Ext.isEmpty(showCombo) && showCombo.getValue()=="CurrentUnknown")
						{
							Ext.getCmp('ackOptionsid').hide();
						}
						currentAlmsGrid.getView().refresh();
					}
					else
					{
						if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')))
						{
							//meme.getCurrentalarmssummary().getView().emptyText=emptText;
							Ext.getCmp('ackOptionsid').hide();
						}
						if(showDeleteBtn!=null && showDeleteBtn=='true' && !Ext.isEmpty(showCombo)  && showCombo.getValue()!="CurrentUnknown")
						{
							Ext.getCmp('AlarmDeleteBtn').hide();
						}
						if(!Ext.isEmpty(showAcknowledgeBtn) && showAcknowledgeBtn!=null && showAcknowledgeBtn=='true' && !Ext.isEmpty(showCombo) && showCombo.getValue()!="CurrentUnknown")
						{
							Ext.getCmp('AlarmAcknowledgeBtn').hide();
						}
						currentAlmsGrid.getView().refresh();
					}
					currentAlmsGrid.generateAlarmGrid();
					var searchField = Ext.getCmp('searchTextBox');
					if(searchAck)
					{
						if(!Ext.isEmpty(searchField.getValue())){
							this.searchAlarms(searchField,'fire');
						}
					}
					else
					{
						if(!Ext.isEmpty(searchField))
							searchField.setValue('');
					}
				}				
			});
	},
	refreshAlarms : function(refreshUrl)
	{
		try
		{
			var isPopAvail= Ext.getCmp('ackWindowObj');
			if(isPopAvail != undefined || !Ext.isEmpty(isPopAvail))
				return;
		}
		catch (e)
		{
		}
		refreshUrl = refreshUrl.substring(refreshUrl.indexOf("?")+1);
		var meC=this;
		var currentAlmsGrid=this.getCurrentalarmssummary();

		var emtText = Ext.get("emptyTextTb");
		try
		{
			if(emtText != null)
			Ext.get("emptyTextTb").hide();
		}
		catch (e)
		{
		}
		alarmLoadMask.show();		
		var browser=get_browser_info();
		if(sortbyalarm!=null && sortbyalarm!="")
		{
			refreshUrl = refreshUrl.replace(/(arrangeAlarms=)[^\&]+/, '$1' +sortbyalarm );
		}
		if(orderbyalarm!=null && orderbyalarm!="")
		{
			if(refreshUrl.indexOf("arrangeOrderBy=")>-1)
				refreshUrl = refreshUrl.replace(/(arrangeOrderBy=)[^\&]+/, '$1' +orderbyalarm );
			else
				refreshUrl = refreshUrl+"&arrangeOrderBy="+orderbyalarm;
		}

		try
		{
			if(isCitrix)
			{
				if(loadUnknown)
					refreshUrl = ctx_defaultParams+"&state=UNKNOWN";
				else{
					var state_sel = Ext.getCmp('subFilterCombo').getValue();
					if(!Ext.isEmpty(state_sel) && state_sel!=null && state_sel!=undefined && state_sel.indexOf('&')!=-1)
						state_sel= state_sel.replace(/&/g, '|amp|');
					refreshUrl = ctx_defaultParams+"&state="+encodeURIComponent(state_sel);
				}
			}
		}
		catch (ee)
		{
		}
		var showCombo = Ext.getCmp('showCombo');
		var filterCombo = Ext.getCmp('filterCombo');
		var subFilterCombo = Ext.getCmp('subFilterCombo');	
		var currentAlarmsSoundAlertDiv=Ext.getCmp('currentAlarmsSoundAlertDiv');
		var mainView1 = this.getMain();
		
		meC.ajaxCall(refreshUrl,browser,showCombo,filterCombo,subFilterCombo,currentAlarmsSoundAlertDiv,currentAlmsGrid,mainView1);	
		metaRefreshUrl = refreshUrl;
		
		var deferId = null;

		Ext.Ajax.on('requestcomplete', function(connection,options)
		{	
			if(!Ext.isEmpty(deferId))
				clearTimeout(deferId);

			deferId = Ext.defer(function(){
				if(metaRefreshUrl.indexOf("?") > -1)
					  metaRefreshUrl = metaRefreshUrl.substring(metaRefreshUrl.indexOf("?")+1);
				meC.ajaxCall(metaRefreshUrl,browser,showCombo,filterCombo,subFilterCombo,currentAlarmsSoundAlertDiv,currentAlmsGrid,mainView1);   
			},refreshFreq);
		});
	},
	searchAlarms:function(field, event ){
		var isTrigger = false;
		if(!Ext.isEmpty(event) && !Ext.isEmpty(event.type) && event.type!=null && event.type!=undefined && event.type=='click')
			isTrigger = true;
		else if(!Ext.isEmpty(event) && event=='fire')
			isTrigger = true;

		searchAck=false;
		 
		var alarmType = publicJson['pageParams']['alarmType'];
		var showDeleteBtn = publicJson['pageParams']['showDeleteBtn'];
		var showAcknowledgeBtn = publicJson['pageParams']['showAcknowledgeBtn'];
		var emptText= '';
		if(alarmType!=null && ( alarmType=='CurrentAlarms' ||alarmType=='longestAlarms' ) )
		{
			//emptText='<table width="100%" id="emptyTextTb" style="font-size:11px"><tr><td align="center" valign="middle"><div class="iconNoalarms" style="margin:10% auto 0% auto"></div>No alarms found</td></tr></table>';
			emptText ='<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconNoalarms" style="margin:0px auto"></div><div style="text-align:center">No alarms found</div></div></div>';
		}
		else if(alarmType!=null && alarmType=='unAcknowledged')
		{
			//emptText='<table width="100%" id="emptyTextTb" style="font-size:11px"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:10% auto 0% auto"></div>No UnAcknowledged alarms found</td></tr></table>';
			emptText ='<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No UnAcknowledged alarms found</div></div></div>';
		}
		else if(alarmType!=null && alarmType=='Acknowledged')
		{
			//emptText='<table width="100%" id="emptyTextTb" style="font-size:11px"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:10% auto 0% auto"></div>No Acknowledged alarms found</td></tr></table>';
			emptText ='<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">No Acknowledged alarms found</div></div></div>';
		}
		else
			emptText = '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconNoalarms" style="margin:0px auto"></div><div style="text-align:center">No unknowns found</div></div></div>';

			if((showDeleteBtn!=null && showDeleteBtn=='true') || (showAcknowledgeBtn!=null && showAcknowledgeBtn=='true'))
			{
				if(showDeleteBtn!=null && showDeleteBtn=='true' && alarmType!="CurrentUnknown")
				{
					Ext.getCmp('AlarmDeleteBtn').show();
				}
				else if((showDeleteBtn==undefined || showDeleteBtn==null || showDeleteBtn=='false') && alarmType=="CurrentUnknown")
				{
					Ext.getCmp('AlarmDeleteBtn').hide();
				}
				if(showAcknowledgeBtn!=null && showAcknowledgeBtn=='true' && alarmType!="CurrentUnknown")
				{
					Ext.getCmp('AlarmAcknowledgeBtn').show();
				}
				else if((showAcknowledgeBtn==undefined || showAcknowledgeBtn==null || showAcknowledgeBtn=='false') && alarmType=="CurrentUnknown")
				{
					Ext.getCmp('AlarmAcknowledgeBtn').hide();
				}
			}
		if( isTrigger || event.getKey() == event.ENTER  ){
			if(field == null || field == undefined || field.value == null || field.value == undefined)
				return;
			if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
			{
				this.getCurrentalarmssummary().getView().emptyText='';
				if(field.value == '*')
				{
					this.getCurrentalarmssummary().getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().loadPage(1);
					
				}
				else if(field.value == '(' || field.value == ')' || field.value == '\\' || field.value == '?' || field.value == '[')
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Please enter the valid search pattern',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					this.getCurrentalarmssummary().getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().clearFilter();
					Ext.getCmp('pagingtoolbarid').getStore().loadPage(1);
					
				}
				else
				{
					var showCombo = Ext.getCmp('showCombo').getValue();
					
					//field.value = field.value.replace(".","\\.");
					field.value = field.value.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
					var regex = RegExp(field.value,'i');
					
					var cGrid = this.getCurrentalarmssummary().getStore();
					var pagingData=[];
					cGrid.clearFilter(true);
					cGrid.filter(new Ext.util.Filter({
						caseSensitive:true,
						filterFn: function (object) {
							var match = false;
							Ext.Object.each(object.data, function (property, value) {								
								if(showCombo != "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4))) || regex.test(String(object.data.COLUMN_5)) || regex.test(String(object.data.COLUMN_11));
								else if(showCombo == "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_1)) || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4))) || regex.test(String(object.data.COLUMN_11));
								//match = match || regex.test(String(value));
							});
							if(true)
							{
								searchAck=true;
								pagingData.push(object.data);
							}
							return match;
						}
					}));
					
					//Filtering based on user input for pagination
					var pagingData = Ext.getCmp('pagingtoolbarid').getStore();
					pagingData.clearFilter(true);
					pagingData.filter(new Ext.util.Filter({
						caseSensitive:true,
						filterFn: function (object){
							var match = false;
							Ext.Object.each(object.data, function (property, value){								
								if(showCombo != "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4))) || regex.test(String(object.data.COLUMN_5)) || regex.test(String(object.data.COLUMN_11));
								else if(showCombo == "CurrentUnknown")
									match = match || regex.test(String(object.data.COLUMN_1)) || regex.test(String(object.data.COLUMN_2)) || regex.test(String(object.data.COLUMN_3)) || regex.test(String(parseWrdfrHtml(object.data.COLUMN_4))) || regex.test(String(object.data.COLUMN_11));
								//match = match || regex.test(String(value));
							});		
							searchAck=true;
							return match;
						}
					
					}));
					pagingData.loadPage(1);
					var meme = this;
					Ext.defer(function(){
						if(cGrid!=null && cGrid.data.length>0)
						{
							$('.x-grid-view').css('height','auto');
							if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')))
							{
								Ext.getCmp('ackOptionsid').show();
								meme.getCurrentalarmssummary().getView().emptyText='';
							}
							else
								meme.getCurrentalarmssummary().getView().emptyText='';
						}
						else
						{
							$('.x-grid-view').css('height','100%');
							if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')))
							{
								meme.getCurrentalarmssummary().getView().emptyText=emptText;
								Ext.getCmp('ackOptionsid').hide();
							}
							else
								meme.getCurrentalarmssummary().getView().emptyText=emptText;							

							meme.getCurrentalarmssummary().getView().refresh();
						}
					},10);
				}
			}
			else
			{
				this.getCurrentalarmssummary().getView().emptyText='';
				this.getCurrentalarmssummary().getStore().clearFilter();
				Ext.getCmp('pagingtoolbarid').getStore().clearFilter();
				Ext.getCmp('pagingtoolbarid').getStore().loadPage(1);
				
				if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')))
				{
					Ext.getCmp('ackOptionsid').show();
					this.getCurrentalarmssummary().getView().emptyText=emptText;
				}
				var cGrid = this.getCurrentalarmssummary().getStore();
				Ext.defer(function(){
					if(!Ext.isEmpty(cGrid) && cGrid.data.length > 0)
						$('.x-grid-view').css('height','auto');
					else
						$('.x-grid-view').css('height','100%');
				},10);
			}
		}
		field.focus();
	},
	updateQueryString : function(objId)
	{
		var filterCombo = Ext.getCmp('filterCombo').getValue();
		var showCombo = Ext.getCmp('showCombo').getValue();
		var subFilterCombo = Ext.getCmp('subFilterCombo').getValue();
	//	var searchByCombo = Ext.getCmp('searchByCombo').getValue();
	//	var searchText = Ext.getCmp('searchTextBox').getValue();

		var QStr = '';// "&compsearch="+searchText+"&selectedSearchByOption="+searchByCombo;


		/* if(filterCombo!=null && filterCombo=='componentTypes')
		{
		console.log('--');
			//Ext.getCmp('subFilterCombo').setWidth(250);
			Ext.getCmp('subFilterCombo').labelWidth= 150;
			Ext.getCmp('subFilterCombo').setWidth(250);
		} */

		var defaultAllAlarmsVal=publicJson['pageParams']['AllAlarmsOptVal'];
		if(defaultAllAlarmsVal!=null && !Ext.isEmpty(defaultAllAlarmsVal))
		{
			while (defaultAllAlarmsVal.indexOf("&")>-1)
			{
				defaultAllAlarmsVal=defaultAllAlarmsVal.replace('&','|amp|');
			}
		}
		/*if(defaultAllAlarmsVal!=null && (defaultAllAlarmsVal=='' || defaultAllAlarmsVal=='undefined' || defaultAllAlarmsVal=='null'))
		{
			defaultAllAlarmsVal='HIGH|amp|INTERMEDIATE|amp|LOW';
		}
		if((Ext.isEmpty(defaultAllAlarmsVal) || defaultAllAlarmsVal==undefined || defaultAllAlarmsVal=='undefined' || defaultAllAlarmsVal == null || defaultAllAlarmsVal=='null') && filterCombo!=null && (filterCombo=='componentTypes' || filterCombo=='services' || filterCombo=='segments' || filterCombo=='zones' || filterCombo=='States'))
		{
			defaultAllAlarmsVal='HIGH|amp|INTERMEDIATE|amp|LOW';
		}*/
		if(objId!=null && objId!='filterCombo') // if clicked combo is not filtercombo box
		{
			if((filterCombo!=null && filterCombo=='States')) // if priority is selected in filter combo box
			{
				if(objId!=null && objId=='subFilterCombo')  // if clicked combo is subfilter combo
				{
					showAlarms = subFilterCombo; // set priority value for alarms
					do{
						showAlarms=showAlarms.replace('&','|amp|');
					}
					while(showAlarms.indexOf('&')>0);
					QStr = QStr+"&selectedSubFilterOption="+encodeURIComponent(showAlarms);	// encode and add subfilter combo value to query string
				}
				else if(objId!=null && objId=='searchByCombo') // if clicked combo is searchby combo
				{
					showAlarms = defaultAllAlarmsVal; // change priority value to all by default
					QStr = QStr+"&selectedSubFilterOption="+encodeURIComponent(showAlarms);	 	// encode and add subfilter combo value to query string
				}
				else
				{
					//QStr = QStr+"&selectedSubFilterOption="+subFilterCombo; // add selected subfilter combo value to query string
					showAlarms = subFilterCombo; // set priority value for alarms
					do {
						showAlarms = showAlarms.replace('&','|amp|');
					}
					while(showAlarms.indexOf('&') > 0);
					QStr = QStr + "&selectedSubFilterOption=" + encodeURIComponent(showAlarms);
				
				}
			}
			else
			{
				QStr = QStr+"&selectedSubFilterOption="+subFilterCombo;	 // add selected subfilter combo value to query string
			}
		}
		else // if clicked combo is filter combo, then don't send subfiltercombo value
		{
			showAlarms = defaultAllAlarmsVal;
			QStr = QStr+"&selectedSubFilterOption="; // add empty value for subfilter combo in query string
		}
		if(showCombo!=null && ( showCombo=='CurrentAlarms' || showCombo=='Acknowledged' || showCombo=='unAcknowledged' ) )
		{
			QStr = QStr + "&showAlarms="+encodeURIComponent(showAlarms); // encode and add priority value to query string
		}

		QStr = QStr +'&alarmType='+showCombo;


		var hidQstr = '';
		var hiddenParams = publicJson['hiddenParams'];
		for(var hid in hiddenParams)
		{
			var hidVal = hiddenParams[hid];

			if(hidVal!=null)
				hidQstr = hidQstr+'&'+hid+'='+encodeURIComponent(hidVal);
			else
				hidQstr = hidQstr+'&'+hid+'='+hidVal;
		}
		QStr = QStr+"&selectedFilterOption="+filterCombo+hidQstr;
		QStr = QStr+"&isFromDashBoard="+!hideBackButton;

		return QStr;
	},
	loadAlarms : function(combo)
	{
		var combId = '';
		var mainView1 = this.getMain();
		if(combo!=null)
			combId = combo.getId();
		var QStr = this.updateQueryString(combId);
		var currentAlmsGrid=this.getCurrentalarmssummary();
		var showCombo = Ext.getCmp('showCombo');
		var tmpQStr = '';
		if(!Ext.isEmpty(QStr) && QStr!=null && QStr!=undefined && QStr.indexOf('zoneDashboard')!=-1 && QStr.indexOf('zoneName')!=-1)
			tmpQStr = QStr;
		if(combId!=null && combId=='showCombo')
		{
			if((!Ext.isEmpty(showCombo) && showCombo!=null && showCombo!=undefined && showCombo.getValue()=='CurrentAlarms'))
			{
				QStr='currentMainPage=NotAlarms';
				if(!Ext.isEmpty(tmpQStr))
					QStr+=tmpQStr;
			}
		}
		if((!Ext.isEmpty(showCombo) && showCombo!=null && showCombo!=undefined) && showCombo.getValue()!='CurrentAlarms' && (isPopupWindow!=null && isPopupWindow=="true"))
		{
			QStr +="&isPopupWindow="+true;
		}
		if(!Ext.isEmpty(longestAlarms) && longestAlarms!=null && longestAlarms!=undefined)
			QStr +="&maxDurationAlarmIds="+longestAlarms;
		
		var emtText = Ext.get("emptyTextTb");
		try
		{
			if(emtText != null)
			Ext.get("emptyTextTb").hide();
		}
		catch (e)
		{
		}

		try
		{
			if(isCitrix)
			{
				if(loadUnknown)
					QStr = ctx_defaultParams+"&state=UNKNOWN";
				else{
					var state_sel = Ext.getCmp('subFilterCombo').getValue();
					if(!Ext.isEmpty(state_sel) && state_sel!=null && state_sel!=undefined && state_sel.indexOf('&')!=-1)
						state_sel= state_sel.replace(/&/g, '|amp|');
					QStr = ctx_defaultParams+"&state="+encodeURIComponent(state_sel);
				}
			}
		}
		catch (ee)
		{
		}
		alarmLoadMask.show();
		var browser=get_browser_info();
		Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name,
				scope:this,
				success: function(response)
				{
					//var jsonText = response.responseText;
					//console.log(jsonText);
					//var jsonData=Ext.decode(jsonText);
					var jsonData = JSON.parse( response.responseText );
					publicJson = jsonData;
					alarmLoadMask.hide();
					var meApp = this;
					if(isPopupWindow!=null && isPopupWindow=="true")
					{
						AlarmsMainTitle='';
					}

					metaRefreshUrl = publicJson['pageParams']['metaRefreshUrl'];
					metaRefreshUrl = urlParamReplace(metaRefreshUrl);
					var pageParams = publicJson['pageParams'];
					var showCombo = Ext.getCmp('showCombo');
					showCombo.getStore().loadRawData();
					showCombo.getStore().loadRawData(publicJson['showOptionsJson']);
					showCombo.setValue(pageParams['selectedShowOption']);

					var filterCombo = Ext.getCmp('filterCombo');
					filterCombo.getStore().loadRawData();
					filterCombo.getStore().loadRawData(publicJson['filterOptions']);
					filterCombo.setValue(pageParams['selectedFilterOption']);


					var subFilterCombo = Ext.getCmp('subFilterCombo');
					subFilterCombo.getStore().loadRawData();
					subFilterCombo.getStore().loadRawData(publicJson['optionsForFilterSelection']);
					var totalCount = subFilterCombo.getStore().getCount();
					var lastVal = subFilterCombo.getStore().getAt(totalCount-1).get('valueField');

					if(combId!=null && combId !='subFilterCombo'){
						if(pageParams.hasOwnProperty('selectedSubFilterOption') && !Ext.isEmpty(pageParams['selectedSubFilterOption']))
							subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
						else
							subFilterCombo.setValue(lastVal);
					}else{
						subFilterCombo.setValue(pageParams['selectedSubFilterOption']);
					}
					if(!Ext.isEmpty(subFilterCombo) && Ext.isEmpty(subFilterCombo.getValue()) || subFilterCombo.getValue()==undefined || subFilterCombo.getValue()==null)
					{
						subFilterCombo.setValue(subFilterCombo.getStore().getAt(0).get('valueField'));
					}

					subFilterCombo.setFieldLabel(filterCombo.getRawValue());
					var zoneNameTxt = publicJson['hiddenParams']['zoneName'];
					var isZoneDash = false;
					if(!Ext.isEmpty(zoneNameTxt)&& zoneNameTxt!=null && zoneNameTxt!=undefined && zoneNameTxt!='null' && zoneNameTxt!='undefined')
						isZoneDash = true;
					if((publicJson['pageParams']['alarmType']!='longestAlarms'))
					{
						if(!isZoneDash)
						{
							if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
								Ext.getCmp('filterCombo').show();
							if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
								Ext.getCmp('subFilterCombo').show();
							if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
								Ext.getCmp('searchTextBox').show();
						}
						else
						{
							if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
								Ext.getCmp('filterCombo').hide();
							if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
								Ext.getCmp('subFilterCombo').hide();
							if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
								Ext.getCmp('searchTextBox').hide();
						}
					}
					else if(publicJson['pageParams']['alarmType']=='longestAlarms')
					{
						if(!Ext.isEmpty(filterCombo) &&filterCombo!=null && filterCombo!=undefined)
							Ext.getCmp('filterCombo').hide();
						if(!Ext.isEmpty(subFilterCombo) && subFilterCombo!=null && subFilterCombo!=undefined)
							Ext.getCmp('subFilterCombo').hide();
						if(!Ext.isEmpty(Ext.getCmp('searchTextBox')) && Ext.getCmp('searchTextBox')!=null && Ext.getCmp('searchTextBox')!=undefined)
							Ext.getCmp('searchTextBox').hide();
						disablerefresh = true;
					}

					var showDeleteBtn = pageParams['showDeleteBtn'];
					var showAcknowledgeBtn = pageParams['showAcknowledgeBtn'];
					if((showDeleteBtn!=null && showDeleteBtn=='true') || (showAcknowledgeBtn!=null && showAcknowledgeBtn=='true'))
					{
						//Ext.getCmp('ackOptionsContainer').show();
					}
					if(showDeleteBtn!=null && showDeleteBtn=='true' && showCombo.getValue()!="CurrentUnknown")
					{						
						if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
						{							
							mainView1.add({xtype:'acknowledgementoptions'});							
						}
						Ext.getCmp('ackOptionsid').show();	
						Ext.getCmp('AlarmDeleteBtn').show();
					}
					else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && showCombo.getValue()=="CurrentUnknown")
					{	
						Ext.getCmp('ackOptionsid').hide();						
					}
					if(showAcknowledgeBtn!=null && showAcknowledgeBtn=='true' && showCombo.getValue()!="CurrentUnknown")
					{
						if(Ext.isEmpty(Ext.getCmp('ackOptionsid')))
						{							
							mainView1.add({xtype:'acknowledgementoptions'});
						}
						Ext.getCmp('ackOptionsid').show();	
						Ext.getCmp('AlarmAcknowledgeBtn').show();
					}
					else if(!Ext.isEmpty(Ext.getCmp('ackOptionsid')) && showCombo.getValue()=="CurrentUnknown")
					{
						Ext.getCmp('ackOptionsid').hide();						
					}
					currentAlmsGrid.generateAlarmGrid();

					var searchField = Ext.getCmp('searchTextBox');					
					if(searchAck)
					{
						if(!Ext.isEmpty(searchField.getValue())){
							this.searchAlarms(searchField,'fire');
						}
					}
					else
					{
						searchField.setValue('');
						
					}					
					
					get_row = document.getElementsByClassName('x-grid-row');								//autoscroll hide/show functionality
					row_hei = Math.round(get_row.length * $('.x-grid-row').height());
					if(row_hei > $('#currentAlarmsGrid-body').height()){
						//Ext.getCmp('iconAutomaticScrollRun').show();
						Ext.getCmp('removeLineForTvMode').show();
						//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
					}else{
						Ext.getCmp('iconAutomaticScrollRun').hide();
						Ext.getCmp('removeLineForTvMode').hide();
						Ext.getCmp('iconAutomaticScrollJumpToTop').hide()
					}				
					Ext.getCmp('iconAutomaticScrollStop').hide();

					try
					{
						if(isCitrix)
						{
							showCombo.hide();
							filterCombo.hide();
							Ext.getCmp('AlarmDeleteBtn').hide();
							Ext.getCmp('AlarmAcknowledgeBtn').hide();	
						}
					}
					catch (e)
					{
					}
					clearTimeout(scrolldelay);
				}
			});
//		document.location = '/final/monitor/EgAlarms.jsp?'+QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height);
	},
	changeAlarmType : function(combo)
	{
		var combId = '';
		if(combo!=null)
			combId = combo.getId();

		var QStr = this.updateQueryString(combId);

		if(isPopupWindow!=null && isPopupWindow=="true")
		{
			QStr +="&isPopupWindow="+true;
		}

		document.location = '/final/monitor/EgAlarms.jsp?'+QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height);
	},
	goBack :function()
	{
		var treeSession=requestParams.treeSession;
		var thisPageSession=requestParams.thisPageSession;
		treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
		thisPageSession=(!Ext.isEmpty(thisPageSession))? thisPageSession:"";
		if( FromDashBoard != null && FromDashBoard != undefined && FromDashBoard =='true')
		{
			document.location = '/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
		}
		else if(thisPageSession != null && thisPageSession != undefined && arrangeAlarms != null && arrangeAlarms != undefined)
			document.location = thisPageSession;
		else
			window.history.back();
	}
});