			var stmin = '';
			var enmin = '';
			var mgr_stmin = '';
			var mgr_enmin = '';
Ext.define('historyack.controller.Main', {
    extend: 'Ext.app.Controller',
    requires:['historyack.view.HistoryAckDetails','Ext.ux.data.PagingMemoryProxy'],
    
    views:['historyack.view.Main' , 'historyack.view.HistoryAckFiltersCategory'],
    stores:['historyack.store.HistoryAckSummary','historyack.store.HistoryAckDetail'],
    
    refs:[
		{
    	ref:'historyacksummary',
		selector:'historyacksummary'
    }, 
		{
    	ref:'historyackfilters',
    	selector:'historyackfilters'
    },{
    	ref:'Main',
    	selector:'main'
    },
	{
    	ref:'HistoryAckFiltersCategory',
    	selector:'historyackfilterscategory'
    },
		{
    	ref:'HistoryAckFiltersTimeline',
		selector:'historyackfilterstimeline'
    },
	{
    	ref:'HistoryAckFiltersOthers',
		selector:'historyackfiltersothers'
    }],
    init: function() {
    	this.control({
					
					'historyackfilters button[id="showAlarm"]' : {
						click : this.showAlarms
					}, 
					'main' : {
						'afterrender': this.afterCompoRendered
					},
					'historyackfilters button[action=Save CSV]':{
						click : this.saveInCSVFormat
					},
					'historyackfilters button[action=Save PDF]' : {
						click : this.saveInPDFFormat
					},
					'historyackfilterstimeline':
					{
						'afterrender': this.afterSettingsRendered
					},
						
					'historyackfilterstimeline combo[id="eg_timeline"]' :{
							select : this.onSelectTimelineValues 
						},
					'historyackfiltersothers ' :{
								'afterrender': this.afterOtherSettingsRendered
							},
					'historyackfilterscategory combo[id=type]' : {
								select : this.onSelectComboValues 
					}

				});
	},
		
		
		onSelectTimelineValues : function(obj){
			 var timelineObj = Ext.getCmp("eg_timeline");
			 if (timelineObj.getValue() == 'Any') {
                    Ext.getCmp('er_enddate').setDisabled(false);
                    Ext.getCmp('er_endhr').setDisabled(false);
                    Ext.getCmp('er_sthr').setDisabled(false);
                    Ext.getCmp('er_stdate').setDisabled(false);
                } else {
                    Ext.getCmp('er_enddate').setDisabled(true);
                    Ext.getCmp('er_endhr').setDisabled(true);
                    Ext.getCmp('er_sthr').setDisabled(true);
                    Ext.getCmp('er_stdate').setDisabled(true);
		}

                    var timeline = Ext.getCmp("eg_timeline").getValue();
                    var strtdt = Ext.getCmp("er_stdate").getValue();
                    var enddt = Ext.getCmp("er_enddate").getValue();
                    var strthour = Ext.getCmp("er_sthr").getValue();
                    var endhr = Ext.getCmp("er_endhr").getValue();

                    strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
                    enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
                    
                    var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
                    var param = "F=getTime&C=id" + no_params;
                    Ext.Ajax.request({
                        url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
                        params: param,
                        scope: this,
                        method: 'POST',
                        success: function (response) {
                            var jsontext = response.responseText;
                            var jsonData = Ext.decode(jsontext);
                            if (!Ext.isEmpty(jsonData)) {
                                var timedata = jsonData.timeline;
                                Ext.getCmp("er_stdate").setValue(timedata[6]);
                                Ext.getCmp("er_stdate").dataArray = timedata[0];
                                Ext.getCmp("er_enddate").setValue(timedata[7]);
                                Ext.getCmp("er_enddate").dataArray = timedata[1];
                                Ext.getCmp("er_sthr").setValue(timedata[8]);
                                Ext.getCmp("er_sthr").dataArray = timedata[2];
                                Ext.getCmp("er_endhr").setValue(timedata[9]);
                                Ext.getCmp("er_endhr").dataArray = timedata[3];
                                stmin = timedata[10];
                                enmin = timedata[11];								
                                mgr_stmin = timedata[4];								
                                mgr_enmin = timedata[5];
                            }
                        }
                    });
                
	
		},


afterCompoRendered: function()
	{
		var me=this;
		Ext.getCmp('iconCSV').disable();
		Ext.getCmp('iconPDF').disable();
		var acknowledge=publicJson['comboValues'];
		acknowledge=acknowledge['Acknowledge'];
		if(acknowledge=="Acknowledgement"){
		Ext.getCmp('historyackfilters').setTitle(AcknowldgementTitle);
		}
		else{
		Ext.getCmp('historyackfilters').setTitle(DeletionTitle);
		}
		b=screenLabels;
	    Ext.getCmp('type').setFieldLabel(b['monitor.history.Type']);
	    Ext.getCmp('component').setFieldLabel(b['monitor.common.Component']);
	    Ext.getCmp('USER').setFieldLabel(b['monitor.common.User']);

     	var TypeCmpVals = publicJson['comboValues'];
		if(!Ext.isEmpty(TypeCmpVals))
		{
			var CmpValues = TypeCmpVals['typesAll'];
			var ctypeComboObj=Ext.getCmp('type');
			ctypeComboObj.getStore().loadRawData(CmpValues);
			ctypeComboObj.setValue(TypeCmpVals['CmpTypeDefult']);
			var CompTyNameValues = TypeCmpVals['CompTypeNamAll'];
			var compComboObj = Ext.getCmp('component');
			compComboObj.getStore().loadRawData(CompTyNameValues);
			if(TypeCmpVals!=null && TypeCmpVals.hasOwnProperty('CompTypeNamAll'))
			{
				compComboObj.setValue(TypeCmpVals['CompTypeNamAll'][0]['valueField']);
			}
			else
			{
				compComboObj.setValue(TypeCmpVals['CompNamDefault']);
			}
			
			var UserValues = TypeCmpVals['UserAll'];
			var ackUserComboObj = Ext.getCmp('USER');
			ackUserComboObj.getStore().loadRawData(UserValues);
			if(TypeCmpVals!=null && TypeCmpVals.hasOwnProperty('UserAll'))
			{
				ackUserComboObj.setValue(TypeCmpVals['UserAll'][0]['valueField']);
			}
			
			Ext.getCmp('showAlarm').fireEvent('click',Ext.getCmp('showAlarm'));		

		if ( !Ext.isEmpty(isSubmit) && isSubmit == 'true' )
		{
			this.showAlarms();
		}
		 var timelineObj = Ext.getCmp("eg_timeline");
		 if (timelineObj.getValue() == 'Any') {
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_stdate').setDisabled(false);
			} else {
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_stdate').setDisabled(true);
			}
		}
/*		 setInterval(function()
		{
			me.showAlarms(); to avoid refresh

		},refreshFreq);	*/	
	},

	afterOtherSettingsRendered: function(){

		b=screenLabels;
	    Ext.getCmp('type').setFieldLabel(b['monitor.history.Type']);
	    Ext.getCmp('component').setFieldLabel(b['monitor.common.Component']);
	    Ext.getCmp('USER').setFieldLabel(b['monitor.common.User']);
		Ext.getCmp('AlaramType').setFieldLabel(b['monitor.Ack.Alarm type']);
		Ext.getCmp('RecordsPage').setFieldLabel(b['monitor.Ack.Records per page']);

		var TypeCmpVals = publicJson['comboValues'];
		var AlaramVals = TypeCmpVals['AlramVal'];
		var selectedValues = TypeCmpVals['AlramSelectedVal'];
		var AckorDelete_MainTitle=	TypeCmpVals['AckorDelete_MainTitle'];	

		if(AckorDelete_MainTitle=="Acknowledgement"){
			Ext.getCmp('AlaramType').getStore().loadRawData(AlaramVals);
			Ext.getCmp('AlaramType').setValue(selectedValues);

		}
		else
		{
			Ext.getCmp('AlaramType').hide();
		}
		var RecordsPerPage=TypeCmpVals['RecordsPerPage'];
		Ext.getCmp('RecordsPage').getStore().loadRawData(RecordsPerPage);
		Ext.getCmp('RecordsPage').setValue(TypeCmpVals['RecordsPerPageValue']);
		
		},

	afterSettingsRendered: function()
	{
		b=screenLabels;
	    Ext.getCmp('eg_timeline').setFieldLabel(b['monitor.common.Timeline']);
		Ext.getCmp('er_stdate').setFieldLabel(b['monitor.common.From']);
	    Ext.getCmp('er_sthr').setFieldLabel(b['monitor.common.Hr']);
		Ext.getCmp('er_enddate').setFieldLabel(b['monitor.common.To']);
		Ext.getCmp('er_endhr').setFieldLabel(b['monitor.common.Hr']);

		var timelineVals = publicJson['timelinedetails'];
		var selectedValues = timelineVals['timelineSelections'];
		var getTimelineComboVals = timelineVals['timeline'];
		var getHourComboVals = timelineVals['hour'];
		var getMinsComboVals = timelineVals['mins'];

		Ext.getCmp('eg_timeline').getStore().loadRawData(getTimelineComboVals);
		Ext.getCmp('eg_timeline').setValue(selectedValues['selectedTimeline']);
		Ext.getCmp('er_stdate').setValue(selectedValues['selectedStartDate']);
		Ext.getCmp('er_stdate').dataArray = selectedValues['selectedStartDate'];
		Ext.getCmp('er_sthr').getStore().loadRawData(getHourComboVals);
		Ext.getCmp('er_sthr').setValue(selectedValues['selectedStartHour']);
		Ext.getCmp('er_sthr').dataArray = selectedValues['selectedStartHour'];
		Ext.getCmp('er_enddate').setValue(selectedValues['selectedEndDate']);
		Ext.getCmp('er_enddate').dataArray = selectedValues['selectedEndDate'];
		Ext.getCmp('er_endhr').getStore().loadRawData(getHourComboVals);
		Ext.getCmp('er_endhr').setValue(selectedValues['selectedEndHour']);
		Ext.getCmp('er_endhr').dataArray = selectedValues['selectedEndHour'];

	},

	onSelectComboValues : function(){
			
			var selectedCompType=Ext.getCmp('type').getValue();
			if(selectedCompType!="-1")
			{
				
			var paramsForRc = 'C=true&F=getComponentsForType&P0={' + selectedCompType + '}&calljson=true';
			var arrComp=new Array();
		
			Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonRemoteScriptingServlet',
            method: 'POST',
			
            params: paramsForRc + '&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
            success: function (response) {
				
                var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var  jsonArr=new Array();
				if (jsonText != null && jsonText != '') {
						jsonArr = jsonData['compOptsJson'];		
						 var componentCombo = Ext.getCmp('component');
                        componentCombo.getStore().loadRawData(jsonData['compOptsJson']);
						
						if(Ext.getCmp('component').getStore().getCount()>1){
							var value = componentCombo.getStore().getAt(0).get('valueField');
							componentCombo.setValue(value);
							/*var TypeCmpVals = publicJson['comboValues'];
							console.log(TypeCmpVals)
							var CompTyNameValues = TypeCmpVals['CompTypeNamAll'];
							console.log(CompTyNameValues)
							Ext.getCmp('component').setValue(TypeCmpVals['CompTypeNamAll'][0]['valueField']);
							*/
						}
						else{
							componentCombo.setValue(jsonData['compOptsJson'][0]['valueField']);
						}
                }
            },
            failure: function () {
				console.log("request component failure");
            }
        });
			}
			else{
				var TypeCmpVals = publicJson['comboValues'];
				var CompTyNameValues = TypeCmpVals['CompTypeNamAll'];
				Ext.getCmp('component').getStore().loadRawData(CompTyNameValues);
				Ext.getCmp('component').setValue(TypeCmpVals['CompTypeNamAll'][0]['valueField']);
			}
	},

	genQueryString: function( objectArr )
		{
			var genQStr = '';
			for ( var key in objectArr )
			{
				genQStr += key+'='+encodeURIComponent(objectArr[key])+'&';
			}
			return genQStr;
		},

	showAlarms : function(z, K, r){
		Ext.getCmp('iconCSV').enable();
		Ext.getCmp('iconPDF').enable();
		M=this.getMain();
		var n = new Ext.LoadMask(M, {
		msg: "Loading..."
		});
		n.show();
		var me = this;
		var timelineVals = publicJson['timelinedetails'];
		var selectedTimelineVal=timelineVals['timelineSelections'];
		var stMins = selectedTimelineVal['selectedStartMin'];
		var endMins = selectedTimelineVal['selectedEndMin'];
		
		var acknowledge=publicJson['comboValues'];
		acknowledge=acknowledge['Acknowledge'];
		var w = Ext.getCmp("more-filter-options-panel").getForm();
        var l = this;
      
		var x = this.getHistoryackfilters().getForm();
		var typeCmp = x.findField("type").getValue();
        var selCmp = x.findField("component").getValue();
        var user = x.findField("USER").getValue();
        var alaramType = w.findField("AlaramType").getValue();
        var timeline = w.findField("eg_timeline").getValue();
        var stdate = w.findField("er_stdate").getRawValue();
        var enddate = w.findField("er_enddate").getRawValue();
        var sthr = w.findField("er_sthr").getValue();
        var endhr = w.findField("er_endhr").getValue();
		var eventsPerPage = w.findField("RecordsPage").getValue();
		var strtdt = Ext.Date.dateFormat(stdate, mgrDateFormat);
        var enddt = Ext.Date.dateFormat(enddate, mgrDateFormat);
		if (eventsPerPage == "All") {
			if(Ext.isEmpty(Ext.getCmp('customgrid')))
				eventsPerPage = 0;
			else
				eventsPerPage = Ext.getCmp('customgrid').getStore().totalCount;
		}
		if(new Date(strtdt + " " + sthr) > new Date(enddt + " " + endhr))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: "Start date should be lesser than end date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			n.hide();
			return false;
		}
		if(new Date(strtdt).valueOf() == new Date(enddt).valueOf())
		{	
			if(sthr > endhr)
			{
				Ext.MessageBox.show({
				title: 'Alert',
				msg: "Start date should be lesser than end date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				n.hide();
				return false;
			}
		}
		
		var today = new Date(mgrDateTime);
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(today < new Date(strtdt+ " " + sthr) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: "From and To Date should be lesser than Current date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				n.hide();
				return false;
		}
	    var s=null;
		var qStrArr = new Array();
		
		qStrArr['compTypeList'] = typeCmp;
		qStrArr['compNameList'] = selCmp;
		qStrArr['ackUser'] = user;
		qStrArr['alarmOption'] = alaramType;
		qStrArr['timeline'] = timeline;
		qStrArr['acknowledge'] = acknowledge;
		qStrArr['eventsPerPage'] = eventsPerPage;
		qStrArr['newAlarms'] = true;
		qStrArr['isSubmit'] = 'true';		
		qStrArr['eventsCount'] = '0';
		
		var qStr = this.genQueryString( qStrArr );
		
		if (timeline == "Any") {
			//var stdate=	 formatDate(new Date(getDateFromFormat(w.findField('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
			//var enddate= formatDate(new Date(getDateFromFormat(w.findField('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");

			var stdate=	w.findField('er_stdate').dataArray;
			var enddate=	w.findField('er_enddate').dataArray;
			var sthr=	w.findField('er_sthr').dataArray;
			var endhr=	w.findField('er_endhr').dataArray;
			//var stmin=	w.findField('er_stmin').dataArray;
			//var endmin=	w.findField('er_endmin').dataArray;
			

			var qStrArrTm = new Array();
			qStrArrTm['eg_stdate'] = stdate;
			qStrArrTm['eg_enddate'] = enddate;
			qStrArrTm['starthr'] = sthr;
			qStrArrTm['endhr'] = endhr;
			qStrArrTm['stmin']=stmin;
			qStrArrTm['endmin']=enmin;
			qStrArrTm['eg_tbound'] = 'Any';
			var qStrTm = this.genQueryString( qStrArrTm );

			qStr=qStr+qStrTm;
			
		}else{
			qStr=qStr+'eg_tbound=Fixed';
		}
		
	    Ext.Ajax.request({
			
           url: '/final/servlet/com.egurkha.monitor.alarms.AckowledgeHistoryServlet',
		    method:'POST',
			params:qStr,
            success: function ( response ) 
			{
			   n.hide();
			   var resultObj = me.getHistoryacksummary();
				jsonText=response.responseText;

				if (response.status == 200 && !Ext.isEmpty(jsonText)) 
				{
					var gridData = Ext.decode(jsonText);
					var main_Title=gridData['gridDetails']['MAIN_TITLE'];
					var gridColumns=gridData['gridDetails']['COLUMN_VALUES'];
					var gridDataVal=gridData['gridDetails']['GRID_VALUES'];
					var PdfDetails=gridData['PDFDetails']['html'];
					eventsPerPage = gridData['gridDetails']['eventsPerPage'];
					var timeline = gridData['gridDetails']['Timeline'];
				//	Ext.getCmp('customgrid').pageSize = eventsPerPage;
					var columnArr = new Array();
				if(gridDataVal!=null)
				{
					var fieldModel = new Array();
					var COLUMN_ = new Array();
					var flexVal;
					fieldModel = gridData['gridDetails']['GRID_MODEL'];
					COLUMN_=gridDataVal;
					var columnMappingVal = new Array();
					var i = 0;
					for ( var key in gridColumns)
					{
						columnMappingVal[i++] = gridColumns[key];
					}

					var columns = new Array();
					i = 0;
					for ( var key in fieldModel )
					{
							if(i==0)
							   {
								 flexVal=.5;
							   }
							   if(columnMappingVal[key]=="User")
							   {
								 flexVal=2;
							   }
							   if(columnMappingVal[key]=="Acknowledgement")
							   {
								 flexVal=2.2;
							   } 
								if(columnMappingVal[key]=="Ack Time")
							   {
								 flexVal=3;
							   }
							   if(columnMappingVal[key]=="Comp Type")
							   {
								 flexVal=3;
							   }
							   if(columnMappingVal[key]=="Comp Name/VM Name")
							   {
								 flexVal=4;
							   }
							   if(columnMappingVal[key]=="Description")
							   {
								 flexVal=5;
							   }
							   if(columnMappingVal[key]=="Test")
							   {
								 flexVal=2;
							   }
							   if(columnMappingVal[key]=="Deleted Time")
							   {
								 flexVal=3;
							   }
							   if(columnMappingVal[key]=="Reason for Deletion")
							   {
								 flexVal=3;
							   }
							   if(columnMappingVal[key]=="StTime")
							   {
								 flexVal=2;
							   }
							   if(columnMappingVal[key]=="Duration")
							   {
								 flexVal=2;
							   }
							   if(columnMappingVal[key]=="mgrid")
							   {
								 flexVal=2;
							   }

							columns.push({
							header: columnMappingVal[key],
							dataIndex: fieldModel[i],
							align: 'left',
							flex:flexVal,
							sortable: true,
							menuDisabled : true,
							renderer:function( value, metaData, record, row, col, store, gridView )
							{
								if ( col == 0 )
								{
									var acknowledge=publicJson['comboValues'];
								acknowledge=acknowledge['Acknowledge'];
								if(acknowledge=='Acknowledgement')
									{
										return '<div class="'+value+'" style="border:0px solid red;margin:0px;margin-top:-2px;margin-left:-3px;padding:0px;cursorointer"></div>';
									}
									else
									{
										return '<div class="'+value+'" style="border:0px solid red;margin:0px;margin-top:-2px;margin-left:2px;padding:0px;cursorointer"></div>';
									}
									
								}
								else
								{
									metaData.tdAttr = 'data-qtip="'+value+'" data-qclass=yellowTip ';
									return value;
								}
							}});
						i++;
					}

				var ackStore = Ext.create('Ext.data.Store', {
					fields: fieldModel,
					data: gridDataVal,
					height:500,
					
					autoLoad:true,
				//	remoteSort:true,
					proxy:{
						type:'pagingmemory',
						reader:{
							type:'json'
						}
					},
					pageSize:eventsPerPage
				});

				resultObj.removeAll();
				var dockedItemsArr = new Array();
				dockedItemsArr.push({
					xtype:'toolbar',
					dock:'top',
					align:'right',
					height: 30,
					items:[
						'->',{
							xtype: 'label',
							id: 'timeline',
							cls: 'f11-bold',
							margin:'0 10 0 0',
							html:timeline
						}]
				},{
					xtype:"pagingtoolbar",
					//cls:"pagingtoolbar pagingtoolbartop",
					cls:'newPagination',
					dock:"bottom",
					id:"ackPagingToolBar",
					name:"ackPagingToolBar",
					pageSize:this.eventsPerPage,
					store: ackStore,
					displayInfo:true,
					displayMsg:"Displaying {0} - {1} of {2}",
					emptyMsg:"No topics to display",
					listeners:{
						change:function(pagetool, pageData, eOpts){
							//	Ext.getCmp('customgrid').getStore().loadPage(pageData.currentPage);
						}
					}
				});
				var tempColumnDataIndex= (Ext.decode(Ext.util.Cookies.get('HaatempColumnDataIndex')));
				var tempColumnObj= (Ext.decode(Ext.util.Cookies.get('HaatempColumnObj')));
				for(var b=0;b<columns.length;b++)
				{
					if(tempColumnDataIndex != null && tempColumnDataIndex.indexOf(columns[b].dataIndex) != -1)
					{
						var indVal = [];
						for (var c=0; c<tempColumnDataIndex.length; c++) 
						{
							if(tempColumnDataIndex[c] == columns[b].dataIndex) 
							{
								indVal.push(c);
							}
						}
						for(var p=0;p<indVal.length;p++)
						{
							if(tempColumnObj[indVal[p]] != undefined && tempColumnObj[indVal[p]] != 'undefined' && tempColumnObj[indVal[p]] != null && tempColumnObj[indVal[p]].dashboardName == acknowledge && tempColumnObj[indVal[p]].measureOrgName == columns[b].header)
							{
								columns[b].flex=tempColumnObj[indVal[p]].width;
								columns[b].width=tempColumnObj[indVal[p]].width;
							}
						}
					}
				}
				resultObj.add({
					xtype: 'grid',
					//cls:'gridSkin',
					ui:'newGridPanel',
					//border:false,
					margin:10,
					id:'customgrid',
					name:'customgrid',
					store: ackStore,
				//	height:200,
				//	width:800,
					flex : 1,
					autoScroll:true,
					scroll:true,
					dockedItems : dockedItemsArr,
					columns: columns,
					//viewConfig: {
					//	 cls: 'MyGridView'
					//},
					listeners:{
						'columnresize':function( ct, column, width, eOpts )
						{
							try
							{
								var tempColumnDataIndex= (Ext.decode(Ext.util.Cookies.get('HaatempColumnDataIndex')));
								var tempColumnObj= (Ext.decode(Ext.util.Cookies.get('HaatempColumnObj')));
								if(tempColumnDataIndex == undefined || tempColumnDataIndex == null)
									tempColumnDataIndex = [];
								if(tempColumnObj == undefined || tempColumnObj == null)
									tempColumnObj = [];
							}
							catch (er)
							{
								var tempColumnDataIndex=[];
								var tempColumnObj=[];
							}
							if(tempColumnDataIndex.indexOf(column.dataIndex) != -1)
							{
								var indexVal = [];
								for (var c=0; c<tempColumnDataIndex.length; c++) 
								{
									if(tempColumnDataIndex[c] == column.dataIndex) 
									{
										indexVal.push(c);
									}
								}
								for(var r=0;r<indexVal.length;r++){
									if(tempColumnObj[indexVal[r]] != undefined && tempColumnObj[indexVal[r]] != 'undefined' && tempColumnObj[indexVal[r]] != null && tempColumnObj[indexVal[r]].dataIndex == column.dataIndex && tempColumnObj[indexVal[r]].dashboardName == acknowledge)
									{
										tempColumnDataIndex.splice(indexVal[r], 1);
										tempColumnObj.splice(indexVal[r], 1);
									}
								}
								tempColumnDataIndex.push(column.dataIndex);
								tempColumnObj.push({
									"dataIndex":column.dataIndex,
									"measureOrgName":column.text,
									"dashboardName":acknowledge,
									//"compType":compType,
									"width":width
								});
							}
							else
							{
								tempColumnDataIndex.push(column.dataIndex);
								tempColumnObj.push({
									"dataIndex":column.dataIndex,
									"measureOrgName":column.text,
									"dashboardName":acknowledge,
									//"compType":compType,
									"width":width
								});
							}
							//Ext.util.Cookies.clear('tempColumnObj');
							//Ext.util.Cookies.clear('tempColumnDataIndex');
							Ext.util.Cookies.set('HaatempColumnObj',Ext.encode(tempColumnObj));
							Ext.util.Cookies.set('HaatempColumnDataIndex',Ext.encode(tempColumnDataIndex));
						}
					},
					//  This listeners added for scroll. Need to do generic.
					/*listeners:{
					afterlayout:function(){
								var insideCon = $('#'+this.el.child('.x-grid-body').id+' .jspPane');
								$('#'+this.view.id).appendTo(insideCon); 
								this.getView().refresh();
								//	$('#'+this.el.child('.x-grid-body').id).css({'overflow':'auto'});
								$('#'+this.el.child('.x-grid-body').id+' .jspContainer').css({'height': $('.x-grid-table').height()+'px'});
								$('#'+this.el.child('.x-grid-body').id+' .jspPane').css({'height': $('.x-grid-table').height()+'px'});
								$('#'+this.el.child('.x-grid-body').id+' .MyGridView ').css({'height': $('.x-grid-table').height()+'px'});
								$('#'+this.el.child('.x-grid-body').id).jScrollPane().data('jsp');
							}
					},*/
					
				});
					resultObj.doLayout();
				}

			   else
				{
				   if(acknowledge=="Acknowledgement"){
					resultObj.removeAll();
					resultObj.add({
							xtype: 'panel',
							id:'errorpanel',
							name:'errorpanel',
							width: '100%',
							border:true,
							margin:'10 10 0 10',
							cls:'darkborder_monitor',
							html:'<table width="100%" height="300px" class="histryackfont" style="margin: 5% auto;"><tr><td align="center" valign="middle"><div class="iconInformation"></div>'+acknowledgements+'</td></tr></table>'
						});
						resultObj.doLayout();
				   }
				   else {
					resultObj.removeAll();
					resultObj.add({
							xtype: 'panel',
							id:'errorpanel',
							name:'errorpanel',
							width: '100%',
							margin:'10 10 0 10',
							border:true,
							cls:'darkborder_monitor',
							html:'<table width="100%" height="300px" class="histryackfont" style="margin: 5% auto;"><tr><td align="center" valign="middle"><div class="iconInformation"></div>'+Deleted+'</td></tr></table>'
						});
						resultObj.doLayout();
				   }
					}
				}
		    },
            failure: function ()
			{
                //alert(' failure hitting...');
				 
            }
        });
	},
	saveInCSVFormat: function () {

			var acknowledge=publicJson['comboValues'];
			acknowledge=acknowledge['Acknowledge'];
			var gridData = Ext.decode(jsonText);
			var gridDataVal=gridData['gridDetails']['GRID_VALUES'];
			
			var me=this;
			if(gridDataVal!=null) 
				 {
					window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?acknowledgementhistory=Yes","CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
				 }
			 else
				{
					if(acknowledge=="Acknowledgement")
					{
							Ext.MessageBox.show({
							title: 'Alert',
							msg: acknowledgements,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
//						alert(acknowledgements);
						return false;
					}
					else if(acknowledge=="Unacknowledgement")
					{
							Ext.MessageBox.show({
							title: 'Alert',
							msg: unacknowledgement,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						//alert(unacknowledgement);
						return false;
					}
					else{
							Ext.MessageBox.show({
							title: 'Alert',
							msg: Deleted,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						//alert(Deleted);
						return false;
					}
				}
    },
	saveInPDFFormat:function()
	{
			var acknowledge=publicJson['comboValues'];
			acknowledge=acknowledge['Acknowledge'];
			var gridData = Ext.decode(jsonText);
			var gridDataVal=gridData['gridDetails']['GRID_VALUES'];
			var w = Ext.getCmp("more-filter-options-panel").getForm();
			var l = this;
		  
			var x = this.getHistoryackfilters().getForm();
			var typeCmp = x.findField("type").getValue();
			var selCmp = x.findField("component").getValue();
			var user = x.findField("USER").getValue();
			var alaramType = w.findField("AlaramType").getValue();
			var timeline = w.findField("eg_timeline").getValue();
			var stdate = w.findField("er_stdate").getRawValue();
			var enddate = w.findField("er_enddate").getRawValue();
			var sthr = w.findField("er_sthr").getValue();
			var endhr = w.findField("er_endhr").getValue();
			var eventsPerPage = w.findField("RecordsPage").getValue();
			if (eventsPerPage == "All") {
				if(Ext.isEmpty(Ext.getCmp('customgrid')))
					eventsPerPage = 0;
				else
					eventsPerPage = Ext.getCmp('customgrid').getStore().totalCount;
			}
		
			var s=null;
			var qStrArr = new Array();
			
			qStrArr['compTypeList'] = typeCmp;
			qStrArr['compNameList'] = selCmp;
			qStrArr['ackUser'] = user;
			qStrArr['alarmOption'] = alaramType;
			qStrArr['timeline'] = timeline;
			qStrArr['acknowledge'] = acknowledge;
			qStrArr['eventsPerPage'] = eventsPerPage;
			qStrArr['newAlarms'] = true;
			qStrArr['isSubmit'] = 'true';		
			qStrArr['eventsCount'] = '0';
			
			var qStr = this.genQueryString( qStrArr );
			
			if (timeline == "Any") {
				var stdate=	 formatDate(new Date(getDateFromFormat(w.findField('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
				var enddate= formatDate(new Date(getDateFromFormat(w.findField('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
				var sthr=	w.findField('er_sthr').dataArray;
				var endhr=	w.findField('er_endhr').dataArray;

				var qStrArrTm = new Array();
				qStrArrTm['eg_stdate'] = stdate;
				qStrArrTm['eg_enddate'] = enddate;
				qStrArrTm['starthr'] = sthr;
				qStrArrTm['endhr'] = endhr;
				qStrArrTm['stmin']='00';
				qStrArrTm['endmin']='00';
				qStrArrTm['eg_tbound'] = 'Any';
				var qStrTm = this.genQueryString( qStrArrTm );

				qStr=qStr+qStrTm;
				if(qStr != null && qStr.endsWith("&"))
				{
					qStr= qStr.substring(0,qStr.lastIndexOf("&"));
				}
				
			}else{
				qStr=qStr+'eg_tbound=Fixed';
			}

			 if (gridDataVal!=null)
				 {
					var a = "";
					//var b = "/final/servlet/com.eg.EgPdfController?acknowledgementhistory=Yes";
					var b = "/final/servlet/com.eg.EgPdfDownloadC?acknowledgementhistory=Yes";
					if(qStr!=null)
						b= b +"&"+qStr;
					
					var d = Ext.MessageBox.progress({
						title: "Downloading",
						value: 5,
						width: 350,
						increment: 15,
						closable: false,
						progressText: "Connecting..",
						wait: true,
						waitConfig: {
							interval: 200
						},
						msg: "<b>Downloading, please wait...</b>",
						scope: this,
						handler: function () {
							this.updateText("Done!");
						}
					});
					var c = Ext.query("#pdfIframe");
					if (Ext.isEmpty(c)) {
						
						Ext.DomHelper.append(document.body, {
							tag: "iframe",
							frameBorder: 0,
							width: 0,
							height: 0,
							css: "display:none;visibility:hidden;height:1px;",
							src: b,
							id: "pdfIframe"
						});
					} else {
						
						Ext.select("#pdfIframe").set({
							src: b
						});
					}
					Ext.Ajax.request({
						url: "/final/monitor/EgSaveStatus.jsp?downloadFile=true",
						scope: this,
						success: function (e) {
							var g = e.responseText;
							var f = Ext.decode(g);
							if (!Ext.isEmpty(f)) {
								var h = f.downloadStatus;
								if (h == "done") {
									d.hide();
								}
							}
						}
					});
				}
			 else
				{
				 if(acknowledge=="Acknowledgement"){
						Ext.MessageBox.show({
							title: 'Alert',
							msg: acknowledgements,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
					//	alert(acknowledgements);
						return false;
						}
				else if(acknowledge=="Unacknowledgement"){
							Ext.MessageBox.show({
							title: 'Alert',
							msg: unacknowledgement,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
					//	alert(unacknowledgement);
						return false;
					}
					else{
						Ext.MessageBox.show({
							title: 'Alert',
							msg: Deleted,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
					//	alert(Deleted);
						return false;
					}
				}
		
	}
});