Ext.define('userSchedules.controller.main',{
	extend:'Ext.app.Controller',
	views:['Main','userScheduleGrid','ResultPanel','OptionUserCombo','ActivityLogGrid'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'scheduleUsersGrid',ref:'scheduleUsersGrid'},
		{selector:'optionsUsersCombo',ref:'optionsUsersCombo'},
	//	{selector:'emptypanel', ref:'emptypanel'},
		{select:'resultpanel', ref:'resultpanel'}
	],
	searchTask: new Ext.util.DelayedTask(function(){
		appConstants.appObj.getController(appConstants.appController).doFilter();
	}),
	init:function(){
		this.control(
		{
			'main':
			{
				'boxready':this.afterMainRender
			},
			'optionsUsersCombo combo[name="userCombo"]' :
			{
				select : this.onSelectUsers
			},
			'optionsUsersCombo combo[name="logCombo"]' :
			{
				select : this.onSelectLogs
			},
			'optionsUsersCombo combo[name="activityLogCombo"]' :
			{
				select : this.onSelectLogDate
			},
			'scheduleUsersGrid textfield[name="livesearch"]':
			{
					change:this.typewatch
			},
			'activityLogGrid textfield[name="livesearch"]':
			{
					change:this.typewatch
			},
			'scheduleUsersGrid':
			{
				'afterrender':this.getHei
			},
			'activityLogGrid':
			{
				'afterrender':this.getActivityLogGrid
			},
			'bookletgrid':
			{
				'afterrender':this.getBindedSchedule
			},
			'scheduleUsersGrid button[id="GroupIt"]':
			{
				'click' : this.groupIt
			},
			'customwindow button[id="updateInPopup"]':
			{
				'click' : this.updatePopupInfo
			}
		});
	},
	getHei:function(grid)
	{
		Ext.getCmp('scheduleConfigGrid').setHeight(Ext.getCmp('userScheduleConfig').body.getHeight()-100);
		this.registeredDeleteEvent(grid);
	},
	getActivityLogGrid:function(grid)
	{
		Ext.getCmp('activityLogGrid').setHeight(Ext.getCmp('userScheduleConfig').body.getHeight()-100);
		this.registeredDeleteEvent(grid);
	},
	onSelectUsers:function()
	{
		var userForm = this.getOptionsUsersCombo().getForm();
		var users = Ext.getCmp('userCombo').getValue();
		var logType = Ext.getCmp('logCombo').getValue();
		var params = 'cmd=View&er_users='+users+'&scheduleFrom=showUsersSch&er_type='+logType;

		Ext.Ajax.request ({
			url:'/final/servlet/com.eg.ErSchedulerC',
			params:params,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					var rootJson = jsonData['rootJson'];
					var scheduleListData = rootJson['scheduleListJson'];
					var recordsPerPage = rootJson['recordsPerPage'];
					var screenLabels = rootJson['screenLabels'];
					var resultPanel = Ext.getCmp('resultPanel');
					if(!Ext.isEmpty(scheduleListData))
					{
						resultPanel.removeAll();
						resultPanel.add ({
							xtype :'scheduleUsersGrid',
							dataArray :scheduleListData,
							pageLimit :recordsPerPage,
							screenLabels :screenLabels,
							padding :10
						});
					}
					else
					{
						resultPanel.removeAll();
						var h = Ext.getBody().getViewSize().height-70;
						var errorMsg = rootJson.screenLabels['errorMsg'];
						if(!Ext.isEmpty(errorMsg))
						{
							resultPanel.add({
								xtype:'container',
								height:h,
								margin:10,
								ui:'newContainer',
								style:{'display':'flex','justify-content':'center','align-items':'center'},
								html:'<div style="display:block"><div class = "iconSuccess" style="margin:0 auto"></div><div style="margin:0 auto">'+errorMsg+'</div></div>'
							});
						}
					}
				}
			}
		});
	},
	onSelectLogDate : function()
	{
		var optionComboForm = this.getOptionsUsersCombo().getForm();

		var logType = Ext.getCmp('logCombo').getValue();
		var params = 'cmd=View&scheduleFrom=showUsersSch&er_type='+logType+'&er_scheduleDate='+Ext.getCmp('activityLogCombo').getValue()+'&er_users='+Ext.getCmp('userCombo').getValue();

		Ext.Ajax.request ({
			url : '/final/servlet/com.eg.ErSchedulerC',
			params : params,
			success : function(response)
			{
				if(response.responseText == 200 || !Ext.isEmpty(response.responseText))
				{
					var resp = response.responseText;
					var jsonData = Ext.decode(resp);
						//console.log('jsonData ',jsonData)
					var resultpanel = Ext.getCmp('resultPanel');

					if(!Ext.isEmpty(jsonData))
					{
						var rootJson = jsonData['rootJson'];
						var screenLabels = rootJson['screenLabels'];

						var logTypeCombo = optionComboForm.findField('logCombo');
						logTypeCombo.getStore().loadRawData(rootJson['gridTypeArray']);
						logTypeCombo.setValue(rootJson['pageParams']['selectedGridType']);

						var userCombo = optionComboForm.findField('userCombo');
						userCombo.setFieldLabel('USERS');
						userCombo.getStore().loadRawData(rootJson['userArray']);
						userCombo.setValue(rootJson['pageParams']['selectedUserType']);

						var activityLog = optionComboForm.findField('activityLogCombo');
						activityLog.setFieldLabel('Schedules date');
						activityLog.getStore().loadRawData(rootJson['activityLogArr']);
						
						if(!Ext.isEmpty(rootJson['pageParams']['selectedScheduleDate']))
						{
							activityLog.setValue(rootJson['pageParams']['selectedScheduleDate']);
						}else
						{
							activityLog.setValue(activityLog.getStore().getAt(0).get('valueField'));
						}


						if(!Ext.isEmpty(rootJson['scheduleLogGridArr']))
						{
							var scheduleGridData = rootJson['scheduleLogGridArr'];
							if(!Ext.isEmpty(scheduleGridData))
							{
								var recordsPerPage =rootJson['recordsPerPage'];
								recordsPerPage = 17;
								resultpanel.removeAll();
								resultpanel.add({
									xtype: 'activityLogGrid',
									dataArray :scheduleGridData,
									pageLimit : recordsPerPage,
									screenLabels : screenLabels,
									margin:'10 10 10 10',
									padding:10
								});
								//Ext.getCmp('livesearch').focus(true, 500);
							}
							else
							{
								var h = Ext.getBody().getViewSize().height-70;
								var errorMsg = screenLabels['erorrMsg'];
								if(!Ext.isEmpty(errorMsg))
								{
									resultpanel.add({
										xtype:'container',
										height:h,
										margin:10,
										ui:'newContainer',
										style:{'display':'flex','justify-content':'center','align-items':'center'},
										html:'<div style="display:block"><div class = "iconSuccess" style="margin:0 auto"></div><div style="margin:0 auto">'+errorMsg+'</div></div>'
									});
								}
							}
							userCombo.hide();
							activityLog.show();
						}
						resultpanel.show();
						resultpanel.doLayout();
					}
				}
			}
		});
	},
	onSelectLogs : function()
	{
		var optionComboForm = this.getOptionsUsersCombo().getForm();
		
		var logType = Ext.getCmp('logCombo').getValue();
		var params = 'cmd=View&scheduleFrom=showUsersSch&er_type='+logType+'&er_scheduleDate='+Ext.getCmp('activityLogCombo').getValue()+'&er_users='+Ext.getCmp('userCombo').getValue();

		Ext.Ajax.request ({
			
			url : '/final/servlet/com.eg.ErSchedulerC',
			params : params,
			success : function(response)
			{
				if(response.responseText == 200 || !Ext.isEmpty(response.responseText))
				{
					var resp = response.responseText;
					var jsonData = Ext.decode(resp);
						//console.log('jsonData ',jsonData)
					var resultpanel = Ext.getCmp('resultPanel');

					if(!Ext.isEmpty(jsonData))
					{
						var rootJson = jsonData['rootJson'];
						var screenLabels = rootJson['screenLabels'];

						var logTypeCombo = optionComboForm.findField('logCombo');
						logTypeCombo.getStore().loadRawData(rootJson['gridTypeArray']);
						logTypeCombo.setValue(rootJson['pageParams']['selectedGridType']);

						var userCombo = optionComboForm.findField('userCombo');
						userCombo.setFieldLabel('USERS');
						userCombo.getStore().loadRawData(rootJson['userArray']);
						userCombo.setValue(rootJson['pageParams']['selectedUserType']);

						var activityLog = optionComboForm.findField('activityLogCombo');
						activityLog.setFieldLabel('Schedules date');
						activityLog.getStore().loadRawData(rootJson['activityLogArr']);
						
						if(!Ext.isEmpty(rootJson['pageParams']['selectedScheduleDate']))
						{
							activityLog.setValue(rootJson['pageParams']['selectedScheduleDate']);
						}else
						{
							activityLog.setValue(activityLog.getStore().getAt(0).get('valueField'));
						}
						
						if(rootJson['pageParams']['selectedGridType']!=undefined && rootJson['pageParams']['selectedGridType'] == 'usersLog')
						{
							userCombo.show();
							activityLog.hide();
							var scheduleGridData = rootJson['scheduleListJson'];
							if(!Ext.isEmpty(scheduleGridData))
							{
								var recordsPerPage =rootJson['recordsPerPage'];
								recordsPerPage = 17;
								resultpanel.removeAll();
								resultpanel.add({
									xtype: 'scheduleUsersGrid',
									dataArray :scheduleGridData,
									pageLimit : recordsPerPage,
									screenLabels : screenLabels,
									padding:10
								});
								Ext.getCmp('livesearch').focus(true, 500);
								
							}
							else
							{
								var h = Ext.getBody().getViewSize().height-70;
								var errorMsg = screenLabels['errorMsg'];
								if(!Ext.isEmpty(errorMsg))
								{
									resultpanel.add({
										xtype:'container',
										height:h,
										margin:10,
										ui:'newContainer',
										style:{'display':'flex','justify-content':'center','align-items':'center'},
										html:'<div style="display:block"><div class = "iconSuccess" style="margin:0 auto"></div><div style="margin:0 auto">'+errorMsg+'</div></div>'
									});
								}
							}
						}else
						{
							userCombo.hide();
							activityLog.show();
							
							var scheduleGridData = rootJson['scheduleLogGridArr'];
							if(!Ext.isEmpty(scheduleGridData))
							{
								var recordsPerPage =rootJson['recordsPerPage'];
								recordsPerPage = 17;
								resultpanel.removeAll();
								resultpanel.add({
									xtype: 'activityLogGrid',
									dataArray :scheduleGridData,
									pageLimit : recordsPerPage,
									screenLabels : screenLabels,
									margin:'10 10 10 10',
									padding:10
								});
								//Ext.getCmp('livesearch').focus(true, 500);
							}
							else
							{
								var h = Ext.getBody().getViewSize().height-70;
								var errorMsg = screenLabels['errorMsg'];
								if(!Ext.isEmpty(errorMsg))
								{
									resultpanel.add({
										xtype:'container',
										height:h,
										margin:10,
										ui:'newContainer',
										style:{'display':'flex','justify-content':'center','align-items':'center'},
										html:'<div style="display:block"><div class = "iconSuccess" style="margin:0 auto"></div><div style="margin:0 auto">'+errorMsg+'</div></div>'
									});
								}
							}
						}
						resultpanel.show();
						resultpanel.doLayout();
					}
				}
			}
		});

	},
	registeredDeleteEvent:function(grid)
	{
		var me = this;
		var gridId=grid.getId();
		var msgInfo='Are you sure you want to remove the selected schedule(s)?';
		var removeIconId='';
		if (gridId=='bookletgridID')
		{
			removeIconId='#removeAllSchedule';
		}
		else if (gridId=='scheduleUsersGrid')
			removeIconId='#removeAll';
		else
			return;
		grid.mon(Ext.select(removeIconId), 'click', function()
		{
			var needDeleteWinRec = false;
			var selected =grid.getView().getSelectionModel().getSelection();
			var bookletGridStore = grid.getStore();
			var noOfrecords = bookletGridStore.getCount();
            var selectionModelObj = grid.getSelectionModel();
			if (noOfrecords > 0)
			{
				var reportSelected = false;
				if (selectionModelObj.getSelection().length > 0)
					reportSelected = true;
				if (reportSelected)
				{
					if (selectionModelObj.getSelection().length == noOfrecords)
						needDeleteWinRec= true;
					Ext.Msg.show({
						title: 'Alert',
						msg: msgInfo,
						buttons: Ext.Msg.YESNO,
						icon: Ext.Msg.QUESTION,
						fn: function(buttonId)
						{
							if (buttonId == "yes")
							{
								if(removeIconId=='#removeAllSchedule')
								{
									var sID = "";
									Ext.each(selected, function(item) {
										sID += item.data.sID + ',';
										grid.getStore().remove(item);
									});
									sID = sID.substring(0, (sID.length - 1));

									var params ='cmd=delete&deleteIDs='+sID;

									Ext.Ajax.request({
										 url: '../servlet/com.eg.ErScheduleBookletModifyC',
										method: 'POST',
										params: params,
										success: function(response) {

											try {
												if (response.status == 200) {

													Ext.MessageBox.show({
														title: 'Schedule',
														msg: 'Schedules are deleted successfuly',
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.INFO,
														fn:function(b){
															me.gridRefresh(needDeleteWinRec);
														}
													});
												}
											}
											catch (e)
											{
												alert(e);
											}
										}
									});
								}
								else if(removeIconId=='#removeAll')
								{
									var sch_id="";
									var sch_name="";
									var mid = "";

									var selectedData = selectionModelObj.getSelection();

									if(selectedData.length>0)
									{
										for(var i=0;i<selectedData.length;i++)
										{
											if(i!=0)
											{
												 sch_name+=",";
													 sch_id += ",";
											}
											var recOrg = selectedData[i];
											sch_id += recOrg.get('sch_id');
											mid +='&mid='+encodeURIComponent(recOrg.get('sch_id'));
											sch_name += recOrg.get('scheduleName');
											grid.store.remove(recOrg);
										}
									}
									document.location = "/final/servlet/com.eg.ErSchedulerC?fromNavLink="+fromNavLink+"&cmd=Delete&id="+encodeURIComponent(sch_id)+"&sch_name="+encodeURIComponent(sch_name)+mid;
								}
							}
						}
					});
				}
				else
				{
					Ext.Msg.show({
						title:'Alert',
						msg: scheduleAlertMsg,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
				}
			}
		});
		if(gridId=='bookletgridID')
		{
			grid.mon(Ext.select('#removeAllBinder'), 'click', function() {

				var needDeleteWinRec = false;
				var selected = grid.getView().getSelectionModel().getSelection();
				var bookletGridStore = grid.getStore();
				var noOfrecords = bookletGridStore.getCount();
				var selectionModelObj = grid.getSelectionModel();
				if (noOfrecords > 0)
				{
					var reportSelected = false;
					if(selectionModelObj.getSelection().length > 0)
						reportSelected = true;
					if(reportSelected)
					{
						if (selectionModelObj.getSelection().length == noOfrecords)
							needDeleteWinRec = true;
						Ext.Msg.show({
							title: 'Alert',
							msg: 'Are you sure you want to remove the selected schedule(s)?',
							buttons: Ext.Msg.YESNO,
							icon: Ext.Msg.QUESTION,
							fn: function(buttonId) {
								if (buttonId == "yes") {
									var sID = "";
									Ext.each(selected, function(item){
										sID += item.data.sID + ',';
										grid.getStore().remove(item);
									});

									sID = sID.substring(0, (sID.length - 1));

									var params ='cmd=remove&removeIDs='+sID;
									Ext.Ajax.request({
										url: '../servlet/com.eg.ErScheduleBookletModifyC',
										method: 'POST',
										params: params,
										success: function(response)
										{
											try
											{
												if (response.status == 200)
												{
													me.gridRefresh(needDeleteWinRec);
												}
											}
											catch (e)
											{
												alert(e);
											}
										}
									});
								}
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title: 'Alert',
							msg: 'Please select the report',
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING
						});
						return;
					}
				}
			});
		}
	},
	typewatch:function(field, event)
	{
  		 this.searchTask.delay(1000);
	},
	doFilter:function()
	{
		var field=Ext.getCmp('livesearch');
		var gridId = 'scheduleConfigGrid';
		if(Ext.getCmp(gridId)==undefined)
		{
			gridId = 'activityLogGrid';
		}
		var dummyArray=Ext.getCmp(gridId).dummyArray;
		var dataArray=Ext.getCmp(gridId).dataArray;
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			Ext.getCmp(gridId).getStore().removeAll();
			var regex = RegExp(field.value, 'i');

			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				//var value=obj.ReportName;
					Ext.Object.each(obj, function (property, value) {
						match =match || regex.test(String(value));
					});
				if(match)
					dataArray.push(obj);
			}
			Ext.getCmp(gridId).getStore().load();
		}
		else
		{
			Ext.getCmp(gridId).getStore().removeAll();
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			Ext.getCmp(gridId).getStore().loadRawData(dataArray);
			Ext.getCmp(gridId).getStore().load();
		}
		field.focus();
		field.toggleTriggger();
	},
	loadMask: function()
	{
		initLoadMask.show();
	},
	gridRefresh:function(needDeleteWinRec)
	{
		var me = this;
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.ErSchedulerC',
			method: 'POST',
			params: defaultQStr,
			success: function(response)
			{
				try
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						if ( !Ext.isEmpty( jsonText ) )
						{
							var jsonData = Ext.decode( jsonText );
							publicJsonData = jsonData;
							me.afterMainRender();
							if(needDeleteWinRec)
								me.deleteWindowRec();
						}
					}
				}
				catch(e)
				{
					alert(e)
				}
			}
		});
	},
	afterMainRender:function()
	{
		var me = this;

		if ( !Ext.isEmpty( publicJsonData ) )
		{
			var optionComboForm = this.getOptionsUsersCombo().getForm();
			try
			{
				var rootJson = publicJsonData['rootJson'];
				var screenLabels = rootJson['screenLabels'];
				//console.log('screenLabels__111__ ',screenLabels)
				me.getMain().setTitle(screenLabels['reporter.common.SCHEDULES']);
				var resultpanel = Ext.getCmp("resultPanel");

				var logTypeCombo = optionComboForm.findField('logCombo');
				logTypeCombo.getStore().loadRawData(rootJson['gridTypeArray']);
				logTypeCombo.setValue(rootJson['pageParams']['selectedGridType']);

				var userCombo = optionComboForm.findField('userCombo');
				userCombo.setFieldLabel('USERS');
				userCombo.getStore().loadRawData(rootJson['userArray']);
				userCombo.setValue(rootJson['pageParams']['selectedUserType']);

				var activityLog = optionComboForm.findField('activityLogCombo');
				activityLog.setFieldLabel('Schedules date');
				activityLog.getStore().loadRawData(rootJson['activityLogArr']);
				
				if(!Ext.isEmpty(rootJson['pageParams']['selectedScheduleDate']))
				{
					activityLog.setValue(rootJson['pageParams']['selectedScheduleDate']);
				}else
				{
					activityLog.setValue(activityLog.getStore().getAt(0).get('valueField'));
				}
				
				if(rootJson['pageParams']['selectedGridType']!=undefined && rootJson['pageParams']['selectedGridType'] == 'usersLog')
				{
					userCombo.show();
					activityLog.hide();
				}else
				{
					userCombo.hide();
					activityLog.show();
				}

				if(!Ext.isEmpty(rootJson['scheduleListJson']))
				{
					var scheduleGridData = rootJson['scheduleListJson'];
					var recordsPerPage =rootJson['recordsPerPage'];
					recordsPerPage = 17;
					resultpanel.removeAll();
					resultpanel.add({
						xtype: 'scheduleUsersGrid',
						dataArray :scheduleGridData,
						pageLimit : recordsPerPage,
						screenLabels : screenLabels,
						padding:10
					});
					Ext.getCmp('livesearch').focus(true, 500);
				}else if(!Ext.isEmpty(rootJson['scheduleLogGridArr']))
				{
					var scheduleGridData = rootJson['scheduleLogGridArr'];
					//console.log('screenLabels ',screenLabels)
					/*var recordsPerPage =rootJson['recordsPerPage'];
					recordsPerPage = 17;*/
					resultpanel.removeAll();
					resultpanel.add({
						xtype: 'activityLogGrid',
						dataArray :scheduleGridData,
						//pageLimit : recordsPerPage,
						screenLabels : screenLabels,
						padding:10
					});
				}else
				{
					var h = Ext.getBody().getViewSize().height-70;
					var errorMsg = screenLabels['errorMsg'];
					//console.log('errorMsg _________ ',errorMsg)
					if(!Ext.isEmpty(errorMsg))
					{
						resultpanel.add({
							xtype:'container',
							height:h,
							margin:10,
							ui:'newContainer',
							style:{'display':'flex','justify-content':'center','align-items':'center'},
							html:'<div style="display:block"><div class = "iconSuccess" style="margin:0 auto"></div><div style="margin:0 auto">'+errorMsg+'</div></div>'
						});
					}
				}
				resultpanel.show();
				resultpanel.doLayout();
			}
			catch (e)
			{
				alert('Error in afterMainRender---->'+e);
			}
		}
	},
	groupIt:function()
	{
		var me = this;
		var grid = Ext.getCmp("scheduleUsersGrid");
		var favoriteListGridStore = grid.getStore();
		var selectionModelObj = grid.getSelectionModel();
		var selected = selectionModelObj.getSelection();
		var noOfRec = selectionModelObj.getSelection().length;
		var sch_id = "";
		var isBindedSchedule = false;
		if (noOfRec > 0)
		{
			for (var i = 0; i < noOfRec; i++)
			{
				var recOrg = selected[i];
				sch_id += recOrg.get('sch_id');
				var hrefUrl = recOrg.get('scheduleUrl');
				if(hrefUrl.indexOf('ErScheduleBookletView.jsp')>-1)
				{
					isBindedSchedule = true;
					break;
				}
				if(i < noOfRec-1)
				{
					sch_id +=',';
				}
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'Schedule',
				msg: 'Please choose one or more schedule(s)',
				buttons: Ext.MessageBox.OK,
				icon: Ext.Msg.WARNING
			});
			return;
		}
		if(isBindedSchedule)
		{
			Ext.MessageBox.show({
				title: 'Schedule',
				msg: 'Cannot combine the binded schedule(s)',
				buttons: Ext.MessageBox.OK,
				icon: Ext.Msg.WARNING
			});
			return;
		}
		Ext.Ajax.request({
			url: '/final/reporter/ErScheduleBookletResponse.jsp',
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonData = Ext.decode(jsonText);
				var bookletSchduleID = Ext.getCmp("bookletSchduleID");
				if (bookletSchduleID != undefined)
				{
					bookletSchduleID.removeAll()
				}
				var isNew = (jsonData.isNew=='true') ? true:false;

				Ext.create('Ext.window.Window', {
					id:'scheduleWindow',
					width: 500,
					border:false,
					modal: true,
					resizable: false,
					ui:'newPopupWindow',
					style:{
						'background':'transparent !important'
					},
					bodyStyle:{
						'background':'transparent !important'
					},
					closeAction: 'destroy',
					//bodyPadding:10,
					header:false,
					layout: 'fit',
							items: [
								{
									bodyPadding:'0 10 10 10',
									title:'Combine Schedules',
									ui:'newFormFieldsInPopup popupHeaderBottomBorder',
									margin:5,
									xtype: 'panel',
									border:false,
									layout: 'column',
									defaults:
									{
										labelSeparator:'',
										labelAlign:'top',
									},
									tools:[
									{
										xtype: 'container',
										margin: '0 1px 0 1px',
										cls: 'iconBg close',
										itemId:'closeTool',
										items: [{
											xtype: 'button',
											iconCls: 'iconCloseNew',
											//tooltip: '<b>Close</b>',
											style: {
												background: 'none',
												border: '0px'
											},
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html: 'Close'
													});
												},
												click:function(){
													Ext.getCmp('scheduleWindow').doClose();
												}
											}
										}]
									}],
									items: [
										{
											xtype : 'radiogroup',
											fieldLabel : 'Add to',
											columnWidth:1.0,
											margin:'5 0 10 -4',
											id : 'fieldID',
											hidden: isNew,
											layout : 'column',
											defaults:
											{
												cls:'radiobt',
												noWrap:true
											},
											items : [
												{
													boxLabel:'New Schedule Booklet', id:'newBinderId', name:'binderType' ,inputValue:'newBinderId',
													margin : '0 15 0 0',
												},
												{
													boxLabel:'Existing Schedule Booklet', id:'extgBinderId' ,name:'binderType',inputValue:'extgBinderId',
												}
											],
											listeners :
											{
												'change' : function()
												{
													var newBookValue = Ext.getCmp('newBinderId').getValue();
													var extgBookValue = Ext.getCmp('extgBinderId').getValue();
													if( newBookValue)
													{
														Ext.getCmp('oldScheduleContainer').show();
														Ext.getCmp('saveBookScheduleTool').show();
														Ext.getCmp('merge_type').show();
														Ext.getCmp('old_sch_name').hide();
														Ext.getCmp('saveBookSchedule1').hide();
													}
													else if(extgBookValue)
													{
														Ext.getCmp('oldScheduleContainer').hide();
														Ext.getCmp('saveBookScheduleTool').hide();
														Ext.getCmp('merge_type').hide();
														Ext.getCmp('old_sch_name').show();
														Ext.getCmp('saveBookSchedule1').show();
													}
													Ext.getCmp('scheduleWindow').doComponentLayout();
													Ext.getCmp('scheduleWindow').doLayout();
													Ext.getCmp('scheduleWindow').center();
												}
											}
										},
										{
											xtype: 'scrollcombo',
											cls: 'dropdown',
											margin:'10 0 10 0',
											columnWidth:.4,
											fieldLabel: 'Schedule Booklet Name',
											id: 'old_sch_name',
											name: 'old_sch_name',
											store: new Ext.data.Store({
												fields: ['displayField', 'valueField'],
												data: []
											}),
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											listeners: {
												'afterrender':function()
												{
													var scheduleCombo = Ext.getCmp('old_sch_name');
													scheduleCombo.getStore().loadRawData(jsonData.sBookletInfoJSON);
													if(jsonData.sBookletInfoJSON != null && jsonData.sBookletInfoJSON.length>0)
													{
														scheduleCombo.setValue(jsonData.sBookletInfoJSON[0]['valueField']);		
													}
												}
											}
										},
										{
											xtype: 'button',
											text: 'Add & Close',
											id: 'saveBookSchedule1',
											name: 'saveBookSchedule1',
											ui:'newButtonSmall',
											hidden:isNew,
											margin:'30 5 0 10',
											padding:'2 10 0 10',
											listeners: {
												'click': function()
												{
													me.addOrUpdateBooklet(sch_id);
												}
											}
										},
										{
											xtype:'container',
											layout:'column',
											margin:'10 0 0 0',
											hidden:!isNew,
											id:'oldScheduleContainer',
											columnWidth:1.0,
											defaults:{
												labelSeparator:'',
												labelAlign:'top',
												margin: '0 10 20 0',
											},
											items:[
												{
													xtype: 'textfield',
													name: 'scheduleBName',
													id: 'scheduleBName',
													fieldLabel: 'Schedule Booklet Name',
													cls: 'textbox',
													columnWidth:.4,
												},
												{
													xtype: 'scrollcombo',
													cls: 'dropdown',
													width: 130,
													fieldLabel: 'Mail Frequency',
													id: 'mail_f',
													name: 'mail_f',
													editable: false,
													columnWidth:.3,
													store: new Ext.data.Store({
														fields: ['displayField', 'valueField'],
														data: []
													}),
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local',
													listeners: {
														'afterrender':function()
														{
															this.getStore().loadRawData(jsonData.mailFreqJSON);
															this.setValue(jsonData.mailFreqJSON[0]['valueField']);
														},
														'select': function()
														{
															var weekly = this.getValue();
															var mailOn = Ext.getCmp('mail_on1')
															if (weekly === 'Weekly')
															{
																Ext.getCmp('mailOnContainer').hide();
																mailOn.show();
																mailOn.getStore().removeAll();
																mailOn.getStore().loadRawData(jsonData.mailOnWeekJSON);
																mailOn.setValue(jsonData.mailOnWeekJSON[0]['valueField']);
															}
															else if (weekly === 'Monthly')
															{
																Ext.getCmp('mailOnContainer').hide();
																mailOn.show();
																mailOn.getStore().removeAll();
																mailOn.getStore().loadRawData(jsonData.mailOnMonthJSON);
																mailOn.setValue(jsonData.mailOnMonthJSON[0]['valueField']);
															}
															else if (weekly === 'Days_of_the_week')
															{
																Ext.getCmp('mailOnContainer').show();
																mailOn.hide();
																daysOfWeekData = jsonData.mailOnWeekJSON;
																Ext.getCmp('mailOnTf').setValue(jsonData.mailOnWeekJSON[0]['valueField']);

															}
															else
															{
																Ext.getCmp('mailOnContainer').hide();
																mailOn.hide();
															}
															Ext.getCmp('scheduleWindow').doComponentLayout();
															Ext.getCmp('scheduleWindow').doLayout();
														}
													}
												},
												{
													xtype: 'fieldcontainer',
													fieldLabel:'Mail on',
													layout: 'column',
													id:'mailOnContainer',
													hidden:true,
													margin: '0 0 20 0',
													columnWidth:0.3,
													items:
													[
														{
															xtype: 'textfield',
															cls: 'textbox',
															columnWidth:.75,
															value:'',
															margin:'0 3 0 0',
															maskRe: /[A-Za-z0-9 .,]/,
															readOnly:true,
															id: 'mailOnTf',
															name:'mailOnTf',
															fieldValues:'',
														},
														{
															xtype: 'button',
															iconCls: 'iconOneClickMultiselectExpand',
															id: 'mailOnExpand',
															margin:'0 10 0 0',
															tooltip: '<b>Days of week</b>',
															columnWidth:.25,
															style:
															{
																 background: 'none',
																 border: '0px'
															 },
															 handler:function(obj)
															 {
																appConstants.appObj.getController(appConstants.appController).openOverPopup('DAYS OF WEEK','mailOnTf', daysOfWeekData,true);
															 }
														}
													]
												},
												{
													xtype: 'scrollcombo',
													editable: false,
													cls: 'dropdown',
													columnWidth:.3,
													id: 'mail_on1',
													name: 'mail_on1',
													fieldLabel: 'Mail On',
													displayField: 'displayField',
													valueField: 'valueField',
													editable: false,
													queryMode: 'local',
													hidden: true,
													store: new Ext.data.Store({
														fields: ['displayField', 'valueField'],
														data: []
													})
												},
												{
													xtype: 'textfield',
													cls: 'textbox',
													id: 'mail_id1',
													name: 'mail_id1',
													columnWidth:.4,
													fieldLabel: 'Mail Id',
													maxLength:512,
													enforceMaxLength: true,
													vtype:'mail_id_validation',
													msgTarget: 'side',
												},
												{
													xtype: 'scrollcombo',
													editable: false,
													cls: 'dropdown',
													columnWidth:.3,
													id: 'schedule_held_on1',
													name: 'schedule_held_on1',
													displayField: 'displayField',
													valueField: 'valueField',
													fieldLabel: 'Schedule Type',
													editable: false,
													queryMode: 'local',
													store: new Ext.data.Store({
														fields: ['displayField', 'valueField'],
														data: []
													}),
													listeners: {
														'afterrender':function()
														{
															this.getStore().loadRawData(jsonData.scheduleTypeJson);
															this.setValue(jsonData.scheduleTypeJson[0]['valueField']);
														},
														'select': function() {
															var value = this.getValue();
															if (value == 'AnyTime')
															{
																Ext.getCmp('fromHours1').show();
																Ext.getCmp('fromMinutes1').show();
															}
															else
															{
																Ext.getCmp('fromHours1').hide();
																Ext.getCmp('fromMinutes1').hide();
															}
															Ext.getCmp('scheduleWindow').doComponentLayout();
															Ext.getCmp('scheduleWindow').doLayout();
														}
													}
												},
												{
													xtype: 'scrollcombo',
													fieldLabel: 'HR',
													cls: 'dropdown',
													editable: false,
													labelWidth: 25,
													columnWidth:.15,
													id: 'fromHours1',
													name: 'fromHours1',
													displayField: 'displayField',
													valueField: 'valueField',
													editable: false,
													queryMode: 'local',
													hidden: true,
													store: new Ext.data.Store({
														fields: ['displayField', 'valueField'],
														data: []
													}),
													listeners:
													{
														'afterrender':function()
														{
															this.getStore().loadRawData(jsonData.hrsComboJSON);
															this.setValue(jsonData.hrsComboJSON[0]['valueField']);
														}
													}
												},
												{
													xtype: 'scrollcombo',
													fieldLabel: 'Mins',
													editable: false,
													cls: 'dropdown',
													labelWidth: 30,
													columnWidth:.15,
													id: 'fromMinutes1',
													name: 'fromMinutes1',
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local',
													hidden: true,
													store: new Ext.data.Store({
														fields: ['displayField', 'valueField'],
														data: []
													}),
													listeners:
													{
														'afterrender':function()
														{
															this.getStore().loadRawData(jsonData.minsComboJSON);
															this.setValue(jsonData.minsComboJSON[0]['valueField']);
														}
													}
												},
												{
													xtype:'scrollcombo',
													hidden:true,
													id:'merge_type',
													name:'merge_type',
													columnWidth:.3,
													fieldLabel:'Need to Merge',
													displayField: 'displayField',
													valueField: 'valueField',
													editable:false,
													queryMode: 'local',
													value:'no',
													store:new Ext.data.Store(
													{
														fields: ['displayField','valueField'],
														data: [{'displayField': 'Yes','valueField': 'yes'}, {'displayField': 'No','valueField': 'no'}]
													})

												}
											]
										}
									],
									dockedItems:[
										{
											xtype: 'toolbar',
											id:'saveBookScheduleTool',
											dock: 'bottom',
											//cls:'dockedBottomToolbarTopBorder',
											ui:'footer',
											padding:0,
											margin:'0 0 20 0',
											hidden:true,
											items:[
												'->',
												{
													xtype: 'button',
													text: 'Add & Close',
													id: 'saveBookSchedule',
													name: 'saveBookSchedule',
													margin:'0 0 0 0',
													buttonAlign : 'center',
													width:90,
													ui:'newButtonSmall',
													listeners: {
														'click': function()
														{
															me.addOrUpdateBooklet(sch_id);
														}
													}
												},'->'
											]
										}
									]
								}
							]
				}).show();
				if (isNew)
				{
					Ext.getCmp('newBinderId').setValue(true);
				}
				else
				{
					Ext.getCmp('extgBinderId').setValue(true);
				}
				Ext.getCmp('scheduleWindow').center();
			}
		});
	},
	getScheduleGroupQry:function(sch_id)
	{
		var isNewBinder=Ext.getCmp('newBinderId').getValue();
		var oldSchID = Ext.getCmp('old_sch_name').getValue();
		var params = '';
		var scheduleIDs = sch_id;
		if(isNewBinder)
		{
			var scheduleBookletName = Ext.getCmp('scheduleBName').getValue();
			var mailFreq = Ext.getCmp('mail_f').getValue();
			var dayOfWeek = Ext.getCmp('mailOnTf').getValue();
			var mailOn = Ext.getCmp('mail_on1').getValue();
			var mailID = Ext.getCmp('mail_id1').getValue();
			var scheduleHeldOn =  Ext.getCmp("schedule_held_on1").getValue();
			var needToMerge =  Ext.getCmp('merge_type').getValue();
			params+='sIDs='+scheduleIDs;
			params+='&needToMerge='+needToMerge;
			if(scheduleBookletName=='')
			{
				Ext.Msg.show({
							title: 'SCHEDULE BOOKLETS',
							msg: 'Please enter the Schedule Booklet Name',
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING
						});
				return false;
			}
			//prakash
			if(!checkspecial(scheduleBookletName,"<>|:\"*?\\/$!@#%^&*()~+={}[];',."))
			{
				Ext.Msg.show({
					title:'SCHEDULE BOOKLETS',
					msg:alertTxt,
					buttons:Ext.Msg.OK,
					icon:Ext.Msg.WARNING
				});
				return false;
			} 
			params+='&sBookletName=' + scheduleBookletName
			if(mailFreq == 'Days_of_the_week')
			{
				if(dayOfWeek.length == 0)
				{
					Ext.Msg.show({
							title: 'SCHEDULE BOOKLETS',
							msg: 'Please choose mail on details',
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING
						});
					return false;
				}
				params+='&dayOfWeek=' + dayOfWeek;
			}
			else if(mailFreq === 'Weekly' || mailFreq === 'Monthly')
			{
				params+= '&mailOn='+ mailOn;
			}
			params+='&mailFreq=' + mailFreq;
			if(mailID == '')
			{
				Ext.Msg.show({
							title: 'SCHEDULE BOOKLETS',
							msg: 'Please enter the mail id',
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING
						});
					return false;
			}
			else if((isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="false") && !checkmultiplemailid(mailID,false))
			{
				Ext.Msg.show({
					title:'SCHEDULE BOOKLETS',
					msg: mailAlertTxt,
					buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
				});
				return false;
			}
			else if((isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false") && !validateSingleByte(mailID))
			{
				Ext.Msg.show({
					title:'SCHEDULE BOOKLETS',
					msg: mailID_DBLerror_msg,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				return false;
			}
			params+='&mailID=' + mailID;
			params+='&scheduleHeldOn='+ scheduleHeldOn;
			if(scheduleHeldOn == 'AnyTime')
			{
				params+='&hr='+Ext.getCmp('fromHours1').getValue();
				params+='&min='+Ext.getCmp('fromMinutes1').getValue();
			}
		}
		else
		{
			params = 'oldSchID='+oldSchID+'&sIDs='+scheduleIDs;
		}
		//console.log(params)
		return params;

	},
	addOrUpdateBooklet:function(sch_id)
	{
		var queryStr = this.getScheduleGroupQry(sch_id);
		if(!queryStr)
		{
			return false;
		}
		else
		{
			Ext.Ajax.request({
				url: '../servlet/com.eg.ErScheduleBookletC',
				method: 'POST',
				params: queryStr,
				success: function(response)
				{
					var responseText = response.responseText;
					
					if(responseText.indexOf('bNmeExits')>-1)
					{
						Ext.Msg.show({
							title: 'Alert',
							msg: 'Booklet schedule is already exist',
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING
						});
					}
					else
					{
						Ext.Msg.show({
							title: 'Alert',
							msg: 'Booklet schedule saved successfully',
							buttons: Ext.Msg.OK,
							icon: 'iconSuccess',
							fn : function(buttonValue, inputText, showConfig)
							{
								Ext.getCmp('scheduleWindow').close();
								location.href='/final/reporter/ErViewSchedule.jsp?cmd=View&fromNavLink=true&menuForVM=true';
							},
						});
					}
				}
			});
		}
	},
	getBindedSchedule:function(grid)
	{
		var me = this;
		Ext.Ajax.request({
            url: '../reporter/ErShowScheduleBookletJSON.jsp?sbID='+appConstants.scheduleBookletID+'&sbNme='+appConstants.sbNme,
            method: 'POST',
            success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.loadData = jsonData;
					me.loadDefaultData(jsonData);
				}
            }
        });
		//this.registeredDeleteEvent(grid)
	},
    loadDefaultData: function(jsonData)
	{
        var bookletStore = Ext.getCmp('bookletgridID');
        var schName = Ext.getCmp('sch_booklet_name_pop');
        var mailID = Ext.getCmp('mail_id_pop');
        var mailFrq = Ext.getCmp('mail_freq_pop');
        var schHeld = Ext.getCmp('schedule_held_on_pop');
        var fmHr = Ext.getCmp('fromHours_pop');
        var fmMin = Ext.getCmp('fromMinutes_pop');

        bookletStore.getStore().loadRawData(jsonData.scheduleArr);
        schName.setValue(jsonData.sbNme);
        mailID.setValue(jsonData.mailID);
        mailFrq.getStore().loadRawData(jsonData.mailFreqJSON);
		mailFrq.setValue(jsonData.mailFreq);
        schHeld.getStore().loadRawData(jsonData.scheduleTypeJson);
        schHeld.setValue(jsonData.scheduleType);
        fmHr.getStore().loadRawData(jsonData.hrsComboJSON);
        fmMin.getStore().loadRawData(jsonData.minsComboJSON);

		if(jsonData.scheduleType =='AnyTime')
		{
			fmHr.setValue(jsonData.mailHr);
			fmMin.setValue(jsonData.mailMin);
		}
		this.showDetailForMail(jsonData.mailFreq,false);
	},
    showDetailForMail: function(mailVal,byOnChange)
	{
        var mailOn_pop = Ext.getCmp('mail_on_pop');
        var jsonData = appConstants.loadData;
		Ext.getCmp('mailOnContainer_pop').hide();
        if (mailVal === 'Weekly') 
		{
            mailOn_pop.getStore().removeAll();
            mailOn_pop.getStore().loadRawData(jsonData.mailOnWeekJSON);
           if(byOnChange || jsonData.mailDay==undefined || jsonData.mailDay=='')
				mailOn_pop.setValue(jsonData.mailOnWeekJSON[0]['valueField']);
			else 
				mailOn_pop.setValue(jsonData.mailDay);
            mailOn_pop.show();
        } else if (mailVal === 'Monthly') {

			mailOn_pop.getStore().removeAll();
            mailOn_pop.getStore().loadRawData(jsonData.mailOnMonthJSON);
            if(byOnChange || jsonData.mailDay==undefined || jsonData.mailDay=='')
				mailOn_pop.setValue(jsonData.mailOnMonthJSON[0]['valueField']);
			else
				mailOn_pop.setValue(jsonData.mailDay);
            mailOn_pop.show();

        } else if (mailVal === 'Days_of_the_week') {
           	daysOfWeekData = jsonData.mailOnWeekJSON;
			if(byOnChange || jsonData.mailDay==undefined || jsonData.mailDay=='')
				Ext.getCmp('mailOnTf_pop').setValue('Sunday');
			else
				Ext.getCmp('mailOnTf_pop').setValue(jsonData.mailDay);
            Ext.getCmp('mail_on_pop').hide();
			Ext.getCmp('mailOnContainer_pop').show();
        }
		else
		{
            Ext.getCmp('mail_on_pop').hide();
        }
		this.getCustomwindow().doComponentLayout();
		this.getCustomwindow().doLayout();
	},
	updatePopupInfo:function()
	{
		var me = this;
		var viewStoreObj = Ext.getCmp('bookletgridID');
		var reportGridIDStore = viewStoreObj.getStore();
		var lengthReport = reportGridIDStore.data.length;
		var scheduleFmt  = '';
		var scheduleName  = '';
		var sbIDs        = '';
		var needToMerge = Ext.getCmp('merge_type_pop').getValue();
		var containSpl = -1;
		for (var iR = 0; iR < lengthReport; iR++) 
		{
			scheduleFmt += '&sF'+ reportGridIDStore.getAt(iR).get('sID')+'=';
			scheduleFmt += reportGridIDStore.getAt(iR).get('scheduleMailFormat');

			scheduleName += '&sName'+ reportGridIDStore.getAt(iR).get('sID')+'=';
			var eachSchName = reportGridIDStore.getAt(iR).get('scheduleNme');
			if(!checkspecial(eachSchName,"`~!@#$%^&*()+={}[]|\\:;\"'<>,?/"))
			{
				containSpl = iR;
				break;
				Ext.Msg.show({
						title: 'Schedule Booklets',
						msg: 'Special characters are not allowed in Schedule Name',
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
				return false;
			}
			scheduleName += eachSchName;
			sbIDs       +='&sbIDs='+reportGridIDStore.getAt(iR).get('sID');
		}
		if(containSpl > -1)
		{
			Ext.MessageBox.show({
				title: 'Booklets',
				msg: 'Special characters are not allowed in Schedule name',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING,
				fn : function()
				{
					var data = reportGridIDStore.data.items[containSpl].data.scheduleNme;
					var rowIndex = reportGridIDStore.find("scheduleNme",data);
					cellEditing.startEdit(rowIndex,1);
				}
			});
			return ;
		}

		var scheduleBookletNme = Ext.getCmp('sch_booklet_name_pop').getValue();

		var mailID   = Ext.getCmp('mail_id_pop').getValue();
		var mailFreq = Ext.getCmp('mail_freq_pop').getValue();
		var dayOfWeek = Ext.getCmp('mailOnTf_pop');
		//var mailOn   = Ext.getCmp('mailon');

		if (mailFreq === 'Weekly' || mailFreq === 'Monthly')
		{
			mailFreq += '#' + Ext.getCmp('mail_on_pop').getValue();
		}
		if(scheduleBookletNme == '')
		{
			Ext.Msg.show({
					title: 'Schedule Booklets',
					msg: 'Schedule Booklet name cannot be blank!',
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
			return false;
		}
		if(!checkspecial(scheduleBookletNme,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
		{
			Ext.Msg.show({
					title: 'Schedule Booklets',
					msg: 'Special characters are not allowed',
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
			return false;
		}
		if(mailID == '')
		{
			Ext.Msg.show({
					title: 'Schedule Booklets',
					msg: 'Please enter the mail id',
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
			return false;
		}
		else if((isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="false") && !checkmultiplemailid(mailID,false))
		{
			Ext.Msg.show({
				title:'Schedule Booklets',
				msg: _checkmail,
				buttons: Ext.Msg.OK,
			icon: Ext.Msg.WARNING
			});
			return false;
		}
		else if((isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false") && !validateSingleByte(mailID))
		{
			Ext.Msg.show({
				title:'Schedule Booklets',
				msg: mailID_DBLerror_msg,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			return false;
		}
		if(mailFreq == 'Days_of_the_week')
		{
			if(dayOfWeek.getValue().length == 0)
			{
				Ext.Msg.show({
						title: 'Schedule Booklets',
						msg: 'Please choose mail on details',
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
				return false;
			}
			mailFreq += '#' + dayOfWeek.getValue();
		}

		var scheduleHeldOn  = Ext.getCmp('schedule_held_on_pop').getValue();
		if (scheduleHeldOn=='AnyTime')
		{
			mailFreq += '#' + Ext.getCmp('fromHours_pop').getValue() + ':' + Ext.getCmp('fromMinutes_pop').getValue()
		}
		var params = 'cmd=update&sbID='+appConstants.scheduleBookletID+'&sBookletName=' + scheduleBookletNme + '&mailFreq=' + mailFreq + '&mailID=' +mailID+'&sHeldOn='+scheduleHeldOn+scheduleFmt+sbIDs+scheduleName;
		params+='&needToMerge='+needToMerge;

		Ext.Ajax.request({
			url: '../servlet/com.eg.ErScheduleBookletModifyC',
			method: 'POST',
			params: params,
			success: function(response)
			{	
				var responseText = response.responseText;
				
				if(responseText.indexOf('bNmeExits')>-1)
				{
					Ext.MessageBox.show({
						title: 'Schedule',
						msg: 'Schedule Booklet Name is already exist',
						buttons: Ext.MessageBox.OK,
						icon: Ext.Msg.WARNING
					});
					return;
				}
					
				var responseStr = Ext.decode(response.responseText);
				var errorMsg = responseStr.errorMsg
				if(errorMsg!=undefined && errorMsg!= 'undefined')
				{
					Ext.Msg.show({
						title: 'Schedule Booklets',
						msg: errorMsg,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
					});
				}
				else
				{
					Ext.MessageBox.show({
						title: 'Schedule Booklets',
						msg: 'Booklet is updated successfuly',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.INFO,
						fn:function(b)
						{
							me.gridRefresh(false);
						}
					});
				}
			}
		});
	},
	deleteWindowRec:function()
	{
		var mid ='&mid='+encodeURIComponent(windowRec.data.sch_id);
		document.location = "/final/servlet/com.eg.ErSchedulerC?fromNavLink="+fromNavLink+"&cmd=Delete&id="+encodeURIComponent(windowRec.data.sch_id)+"&sch_name="+encodeURIComponent(windowRec.data.scheduleName)+mid;
	},
	openOverPopup:function(title,txtFieldID,comboInfo,needMultiSelect)
	{
		var selectedDaysInfoArray=new Array();
		var ddTxtValue=Ext.getCmp(txtFieldID).getValue();
		selectedDaysInfoArray=ddTxtValue.split(",");
		Ext.create('utilities.GenericWindow',{
			title:title,
			width:200,
			ui:'newPopupWindow',
			id:'builderSubWindow',
			border:false,
			frame:false,
			modal: true,
			ghost: false,
			style:{
				'background':'transparent !important'
			},
			bodyStyle:{
				'background':'transparent !important'
			},
			closeAction: 'destroy',
			height:250,
			header:false,
			//padding:'0 10 5 10',
			buttonAlign:'center',
			listeners:
			{
				afterrender: function () {
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items:[{
				xtype:'panel',
				layout: 'column',
				title:title,
			//	ui:'newFormFieldsInPopup popupHeaderBottomBorder',
				ui:'newFormFieldsInPopup',
				buttonAlign:'center',
				bodyPadding:'0 10 0 10',
				margin:5,
				tools:[
				{
					xtype: 'container',
					margin: '0 1px 0 1px',
					cls: 'iconBg close',
					itemId:'closeTool',
					items: [{
						xtype: 'button',
						iconCls: 'iconCloseNew',
						//tooltip: '<b>Close</b>',
						style: {
							background: 'none',
							border: '0px'
						},
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Close'
								});
							},
							click:function(){
								Ext.getCmp('builderSubWindow').doClose();
							}
						}
					}]
				}],
				items:[
					{
						xtype: 'multiselect',
						width:'100%',
						height:160,
						layout: 'fit',
						border : 0,
						autoScroll:false,
						scroll:false,
						labelAlign:'left',
						baseCls: 'egmultiselect',
						multiSelect: needMultiSelect,
						id: 'componentsClone',
						name: 'componentsClone',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						value: [],
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners:{
							afterrender: function ()
							{
								this.getStore().loadRawData(comboInfo);
								this.setValue(selectedDaysInfoArray);
							}
						},
					}
				],
				buttons:[
					{
						text:'Select',
						id: 'expand',
						ui:'newButtonSmall',
						margin:10,
						name: 'expand',
						handler: function()
						{
							if ( Ext.getCmp('componentsClone').getValue() != '')
							{

								var comboVal= Ext.getCmp('componentsClone').getValue();

								Ext.getCmp(txtFieldID).setValue(comboVal);
								this.up('window').destroy();
							}
							else
							{
								 Ext.MessageBox.show({
									title: 'Alert',
									msg: 'Please Choose the Day(s)',
									buttons: Ext.MessageBox.OK,
									icon: Ext.MessageBox.WARNING
								});
								return;
							}
						}
					}
				]
			}]
		}).show();
	}
});

