var processServlet = '';
var appJsonPage = '';
var appPrintPage = '';
var backgroundControllerUrl = 'ErStartBackGroundReportC';
var additionalParams = '';
var RUN_URL_PARAM = '';
Ext.define('TemplateReportApp.controller.TemplateController', {
	extend:'Ext.app.Controller',
	views:['TemplateReportApp.view.Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'mainform', ref:'mainform'},
		{selector:'drilldownmainform', ref:'drilldownmainform'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'moresettings', ref:'moresettings'},
		{selector:'ReporterSettings',ref:'ReporterSettings'}
	],
	searchTask: new Ext.util.DelayedTask(function(){
	appConstants.appObj.getController(appConstants.appController).doFilter();
	}),
	init: function () {

		this.control({			
			'moresettings':{
 				'afterrender':this.loadMoreSetting
			},
			'mainform':{
 				'afterrender':this.loadForm
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'moresettings combo[name="reportGeneration"]':{
				'select': this.onChangeReportGeneration
			},
			'moresettings button[name="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'moresettings button[name="submitViaSetting"]':{
				'click': this.closeSettingAndSubmit
			},
			'mainform button[name="submit"]':{
 				'click':this.submitReport
			},
			'drilldownmainform button[name="submit"]':{
 				'click':this.submitReport
			},
			'mainform button[name="save"]':{
 				'click':this.exportFunctions
			},
			'newUtilities > #saveTool > button':{
					'click': this.exportFunctions
			},
			'newUtilities > #printTool > button':
			{
				'click':this.exportFunctions
			},
			'newUtilities > #mailTool > button':{
					'click':this.exportFunctions
			},
			'newUtilities > #csvTool > button':{
					'click':this.exportFunctions
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.exportFunctions
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.exportFunctions
			},
		})
	},
	changeEventProcess:function(obj)
	{
		var me = this;
		if(appConstants.templateFor!=null && appConstants.templateFor!='EG_TABLE_COMSUME')
		{
		  Ext.getCmp('resultPanel').hide();
		}
		this.disableTools();
		if(obj.eventSide=='server')
		{
			var param = me.getChangeEventQueryStr(obj.id);
			if(param != undefined && param.length>0)
			{
				appConstants.initLdgMask.show();
				Ext.Ajax.request(
				{
					url :'/final/reporter/'+appJsonPage,
					params :param+'&templateFor='+appConstants.templateFor ,
					method :'POST',
					scope:this,
					async :true,
					success: function(response)
					{
						appConstants.processJson = Ext.decode(response.responseText);
						me.loadChangeEventSucess(obj,appConstants.processJson);
						appConstants.initLdgMask.hide();
					}
				});
			}
		}
		else if(obj.eventSide=='local')
		{
			this.setVisibilityById(obj.id);
		}
	},
	loadChangeEventSucess:function(obj,jsonData)
	{
		var me = this;
		if(jsonData.isCsvEnabled!=undefined && jsonData.isCsvEnabled)
		{
			isCsvEnabled = true;
		}
		else
		{
			isCsvEnabled = false;
		}
		isPreloadReort = jsonData.isPreloadReort;
		me.loadFormOnEventChange(obj.id,jsonData);
		me.laodMoreSettingData(jsonData);
		this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.processJson,false,null,true);
	},
	setVisibilityById:function(fieldId)
	{
		if(appConstants.processJson!=undefined)
		{
			var hiddenvalueMap = appConstants.processJson.hiddenvalueMap;
			if(hiddenvalueMap!=undefined)
			{
				var valuesById = hiddenvalueMap[fieldId];
				if(valuesById!=undefined)
				{
					var fieldIdObj = Ext.getCmp(fieldId);
					var fieldIdValue  = fieldIdObj.getValue();
					if(fieldIdObj.xtype=='radiogroup')
					{
						fieldIdValue = fieldIdValue[fieldId];
					}
					for(var value in valuesById)
					{
						var idList = valuesById[value];
						if(value==fieldIdValue)
						{
							for(var i in idList)
							{
								Ext.getCmp(idList[i]).hide();
							}
							break;
						}
						else
						{
							for(var i in idList)
							{
								Ext.getCmp(idList[i]).show();
							}
						}
					}
				}
			}
		}
	},
	typewatch:function(field, event)
	{
		 this.searchTask.delay(500);
	},
	expandMe:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var btnId = btn.id;
		var formId = btnId.substring(0,btnId.indexOf('_expand'));
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp(formId),Ext.getCmp(formId+'_TxtField').getFieldLabel(),btn);
	},
	filterMultiselect:function(obj)
	{
		var fieldId = obj.id;
		var formId = fieldId.substring(0,fieldId.indexOf('_trigger'));
		var store = obj.possibleData;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(formId),store);
		obj.toggleTriggger();
	},
	loadResultPanel:function(resultJson)
	{
		var custom_resultPanel = resultJson.resultPanelName;
		var RESULTS = resultJson.RESULTS;
		var reportGeneration;
		if(resultJson.selectedFields!=undefined)
		{
			reportGeneration = resultJson.selectedFields.reportGenerationSelected;
		}
		if(reportGeneration!=undefined && (reportGeneration == 'background' || reportGeneration=='background-csv'))
		{
			var backGroundPanel = Ext.getCmp('backGroundPanel');
			this.getNomeasurepanel().hide();
			Ext.getCmp('resultPanel').hide();
			var backgroundReportStatus=resultJson.labelFields.bgStatus;
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=resultJson.labelFields.bgResponseText;
				var backgroundAnchor=resultJson.labelFields.bgAnchor;
				var bgroundReportsURL=resultJson.urlFields.bgUrl;
				var sub = backgroundAnchor;
 			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=resultJson.labelFields.bgResponseText;
				var backgroundAnchor=resultJson.labelFields.bgAnchor;
				var bgroundReportsURL=resultJson.urlFields.bgUrl;
				var sub = backgroundAnchor;
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
			else
			{
				var bgroundResponseTxt=resultJson.labelFields.bgResponseText;
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'</a></div></td></tr></table></td></tr></table>');
			}
			backGroundPanel.show();
		}
		else if(custom_resultPanel!=undefined)
		{
			Ext.getCmp('backGroundPanel').hide();
			var resultPanelObj = Ext.getCmp('resultPanel');
			if(resultJson.NO_DATA)
			{
				this.getNomeasurepanel().show();
				resultPanelObj.hide();
				this.disableTools();
			}
			else
			{
				if(appConstants.showMainForm=='yes')
				{
					if(RESULTS.selectionDetails!=undefined)
					{
						Ext.getCmp('selectionDetails').setSelectionDetailsData(RESULTS.selectionDetails);
					}
				}
				resultPanelObj.removeAll();
				resultPanelObj.add(
				{
					xtype:custom_resultPanel.toLowerCase(),
					data:resultJson
				});
				this.getNomeasurepanel().hide();
				resultPanelObj.show();
				this.enableTools();
			}
		}
		else 
		{
			this.disableTools();
			alert('Problem in getting result panel');
		}
	},
	loadResultPanel_old:function(resultJson)
	{
		var resultPanel = resultJson.resultPanelName;
		var resultPanelId = resultPanel.toLowerCase()+'_id';
		if(resultPanel!=undefined)
		{
			var resultPanelObj = Ext.getCmp(resultPanelId);
			if(resultJson.NO_DATA)
			{
				this.getNomeasurepanel().show();
				if(resultPanelObj!=undefined)
				{
					resultPanelObj.hide();
				}
			}
			else
			{
				this.getNomeasurepanel().hide();
				if(resultPanelObj!=undefined)
				{
					resultPanelObj.show();
					resultPanelObj.setData(resultJson);
				}
				else
				{
					this.getMain().add(
					{
						xtype:resultPanel.toLowerCase(),
						data:resultJson
					});
					resultPanelObj.show();
				}
			}
		}
		else
		{
			alert('Result panel is not configured')
		}
	},
	getChangeEventQueryStr:function(id)
	{
		var eventQuery = '';
		var totalIdsForReport = appConstants.publicJsonData.totalIdsForReport;
		var specialCharEncodeLst = appConstants.publicJsonData.specialCharEncodeLst;
		var status = true;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");
		try
		{
			for(var index in totalIdsForReport)
			{
				var formId = totalIdsForReport[index];
				var idComponent = Ext.getCmp(formId);
				var visiblityComponent = Ext.getCmp(formId);
				var xtype = idComponent.xtype;
				var fieldLabel = '';
				if(xtype!=undefined && xtype=='multiselectfield')
				{
					visiblityComponent = Ext.getCmp(formId+'_container');
					if(visiblityComponent == undefined || visiblityComponent == 'undefined')
					{
						visiblityComponent = Ext.getCmp(formId+'_expMultiSelect');
					}
          else
					{
						fieldLabel = Ext.getCmp(formId+'_TxtField').getFieldLabel();
					}
					if(!visiblityComponent.isVisible()&&visiblityComponent.hidden)
					{
						idComponent = Ext.getCmp(formId+'_TxtField');
						visiblityComponent = Ext.getCmp(formId+'_TxtField');
					}
				}
				else if(xtype!=undefined && xtype=='scrollcombo')
				{
					fieldLabel = idComponent.getFieldLabel();
				}
				else if(xtype!=undefined && xtype=='radiogroup')
				{
					fieldLabel = idComponent.getFieldLabel();
				}
				else if(xtype!=undefined && xtype=='textfield')
				{
					fieldLabel = idComponent.getFieldLabel();
				}
				if(idComponent!=undefined && visiblityComponent!=undefined && (visiblityComponent.isVisible()||!visiblityComponent.hidden))
				{
					var filedVal = idComponent.getValue();
					if(visiblityComponent.type == 'expMultiselect')
					{
						filedVal = visiblityComponent.fieldValue;
						filedVal = filedVal.split(",");
					}
					if(filedVal instanceof Array)
					{
						if(filedVal!=undefined && filedVal.length==0)
						{
							status = this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Choose a Valid '+fieldLabel);
						}
						if(idComponent.id=='er_component' && Ext.Array.contains(filedVal,'all') && filedVal.length>1)
						{
							Ext.MessageBox.show({
								title: 'Alert',
								msg:  'Individual and All components should not be selected simultaneously',
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							status = false;
						}
						for(var i in filedVal)
						{
							if(filedVal[i]!=undefined && (filedVal[i]=='-1' || filedVal[i]==''))
							{
								status = this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Choose a Valid '+fieldLabel);
								break;
							}
							if(specialCharEncodeLst.indexOf(formId)>-1)
							{
								eventQuery+=formId+'='+appConstants.erUtils.specialCharEncode(filedVal[i])+'&';
							}
							else
							{
								eventQuery+=formId+'='+filedVal[i]+'&';
							}
						}
					}
					else
					{
						if(filedVal!=undefined && (filedVal=='-1' || filedVal==''))
						{
							status = this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Choose a Valid '+fieldLabel);
						}
						if(specialCharEncodeLst.indexOf(formId)>-1)
						{
							eventQuery+=formId+'='+appConstants.erUtils.specialCharEncode(filedVal)+'&';
						}
						else
						{
							eventQuery+=formId+'='+filedVal+'&';
						}
					}
					if(!status || id==formId)
					{
						break;
					}
				}
			}
			if(Ext.getCmp('er_leastActiveUserDays') != undefined)
			{
				var er_leastActiveUserDays=Ext.getCmp('er_leastActiveUserDays').getValue();
				if(er_leastActiveUserDays != undefined)
				{
					if(er_leastActiveUserDays=='all' || er_leastActiveUserDays == 'All' || er_leastActiveUserDays == 'ALL')
          {
					}
					else if(!/^[0-9]+$/.test(er_leastActiveUserDays))
          {
						status = this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Choose an Inactive Users');
					}
				}
			}
		}
		catch (e)
		{
			console.log(e)
		}
		if(eventQuery.length>0)
		{
			eventQuery = eventQuery.substring(0,eventQuery.length-1);
			var hiddenvalueParams = appConstants.publicJsonData.hiddenvalueParams;
			if(hiddenvalueParams!=undefined)
			{
				for(var key in hiddenvalueParams)
				{
					var value = hiddenvalueParams[key];
					eventQuery+='&'+key+'='+value;
				}
			}
			if(id=='submit')
			{
				eventQuery+='&isSubmit=true';
			}
			eventQuery+='&showMainForm='+appConstants.showMainForm;
			eventQuery+='&drillDown='+appConstants.drillDown;
			eventQuery+=additionalParams;
		}
		if(!status)
		{
			eventQuery='';
		}
		return eventQuery;
	},
	getTimelineQuery:function()
	{
		var queryParam = '';
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var tmpStDate = Ext.getCmp('er_stdate').getValue();
		if(tmpStDate != null)
		{
			tmpStDate.setHours(Ext.getCmp('er_sthr').getValue());
			var tmpEnDate = Ext.getCmp('er_enddate').getValue();
			if(tmpEnDate != null)
				tmpEnDate.setHours(Ext.getCmp('er_endhr').getValue());
			var result = checkDateTime(tmpStDate, tmpEnDate);
			if (!result) 
			{
				return '';
			}
		}
		queryParam+='er_timeline='+Ext.getCmp('er_timeline').getValue();
		queryParam+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
		queryParam+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
		queryParam+='&er_sthr='+Ext.getCmp('er_sthr').dataArray;
		queryParam+='&er_endhr='+Ext.getCmp('er_endhr').dataArray;
		queryParam+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;
		queryParam+='&startdate='+Ext.getCmp('er_stdate').dataArray;
		queryParam+='&enddate='+Ext.getCmp('er_enddate').dataArray;
		queryParam+='&starthr='+Ext.getCmp('er_sthr').dataArray;
		queryParam+='&endhr='+Ext.getCmp('er_endhr').dataArray;
		queryParam+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		if(appConstants.templateFor=='USER_LATENCY')
		{
			queryParam+='&pageWidthProces=1100';
		}

		return queryParam;
	},
	getMoreOptionsQuery:function()
	{
		var queryParam = '';
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		var generationType = Ext.getCmp('reportGeneration').getValue();
		var specialCharEncodeLst = appConstants.publicJsonData.specialCharEncodeLst;
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto))
		{
			return '';
		}
		queryParam+='timefrom='+Ext.getCmp('timefrom').getValue();
		queryParam+='&timeto='+Ext.getCmp('timeto').getValue();
		queryParam+='&minfrom='+Ext.getCmp('minfrom').getValue();
		queryParam+='&minto='+Ext.getCmp('minto').getValue();
		if(generationType!='foreground')
		{
			var bgReportName = Ext.getCmp('bgReportName').getValue();
			if(bgReportName.trim()=='')
			{
				this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Provide a Background Name');
				return '';
			}
			queryParam+='&bg_reportname='+encodeURIComponent(bgReportName);
		}
		queryParam+='&er_reportgenration='+generationType;
		var moreOptionIds = appConstants.publicJsonData.moreOptionIds;
		var status = true;
		for(var index in moreOptionIds)
		{
			var formId = moreOptionIds[index];
			var idComponent = Ext.getCmp(formId);
			var visiblityComponent = Ext.getCmp(formId);
			var xtype = idComponent.xtype;
			var fieldLabel = '';
			if(xtype!=undefined && xtype=='multiselectfield')
			{
				visiblityComponent = Ext.getCmp(formId+'_container'); 
				if(!visiblityComponent.isVisible())
				{
					idComponent = Ext.getCmp(formId+'_TxtField');
					visiblityComponent = Ext.getCmp(formId+'_TxtField');
				}
				fieldLabel = Ext.getCmp(formId+'_TxtField').getFieldLabel();
			}
			else if(xtype!=undefined && xtype=='scrollcombo')
			{
				fieldLabel = idComponent.getRawValue();
			}
			else if(xtype!=undefined && xtype=='radiogroup')
			{
				fieldLabel = idComponent.getFieldLabel();
			}
			else if(xtype!=undefined && xtype=='numberfield')
			{
				fieldLabel = idComponent.getFieldLabel()+' value';
			}
			else if(xtype!=undefined && xtype=='textfield')
			{
				fieldLabel = idComponent.getFieldLabel()+' value';
			}
			if(idComponent!=undefined && visiblityComponent!=undefined && visiblityComponent.isVisible())
			{
				var filedVal = idComponent.getValue();
				if(filedVal instanceof Array)
				{
					if(filedVal!=undefined && filedVal.length==0)
					{
						status = this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Choose a Valid '+fieldLabel);
					}
					for(var i in filedVal)
					{
						if(filedVal[i]==undefined || (filedVal[i]=='-1' || filedVal[i]==''))
						{
							status = this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Choose a Valid '+fieldLabel);
							break;
						}

						if(specialCharEncodeLst.indexOf(formId)>-1)
						{
							queryParam+='&'+formId+'='+appConstants.erUtils.specialCharEncode(filedVal[i]);
						}
						else
						{
							queryParam+='&'+formId+'='+filedVal[i];
						}
					}
				}
				else
				{
					if(filedVal==undefined || (filedVal=='-1' || filedVal==''))
					{
						status = this.getMessageBox(Ext.get(this.getMain().header.id+'_hd-textEl').dom.innerHTML,'Please Choose a Valid '+fieldLabel);
					}

					if(specialCharEncodeLst.indexOf(formId)>-1)
					{
						queryParam+='&'+formId+'='+appConstants.erUtils.specialCharEncode(filedVal);
					}
					else
					{
						queryParam+='&'+formId+'='+filedVal;
					}
				}
				if(!status)
				{
					break;
				}
			}
		}
		if(!status)
		{
			return '';
		}
		return queryParam;
	},
	loadFormOnEventChange:function(id,jsonData)
	{
		var totalIdsForReport = appConstants.publicJsonData.totalIdsForReport;
		var formAryObj = jsonData.formObj;
		var startSetValue = false;
		if(id=='')// need to set all the value of form
		{
			startSetValue = true;
		}
		for(var index in totalIdsForReport)
		{
			var formId = totalIdsForReport[index];
			if(startSetValue)
			{
				var idComponent = Ext.getCmp(formId);
				var componentDetails = formAryObj[formId];
				if(idComponent!=undefined && componentDetails!=undefined)
				{
					if(componentDetails.type=='multiselect')
					{
						var idComponent_multi = Ext.getCmp(formId+'_container');
						//var idComponent_textField = Ext.getCmp(formId+'_TxtField');
						if(idComponent_multi.hidden!=undefined && componentDetails.hidden)
						{
							idComponent_multi.hide();
						}
						else
						{
							idComponent_multi.show();
						}
					}
					else
					{
						if(componentDetails.hidden!=undefined && componentDetails.hidden)
						{
							idComponent.hide();
						}
						else
						{
							idComponent.show();
						}
					}
					if(componentDetails.type=='combo' || componentDetails.type=='multiselect')
					{
						var rawData = componentDetails.possibleData
						var dispName = componentDetails.dispName
						var selectedVal = componentDetails.selectedVal;
						idComponent.getStore().loadRawData(rawData);
						idComponent.setValue(selectedVal);
						if(dispName!=undefined && componentDetails.type=='combo')
						{
							idComponent.setFieldLabel(dispName);
						}
						if(componentDetails.type=='multiselect')
						{
							Ext.getCmp(formId+'_trigger').possibleData=rawData;
						}
					}
					else if(componentDetails.type=='expMultiselect')
					{
						var idComponent_multi = Ext.getCmp(formId+'_expMultiSelect');
						if(idComponent_multi.hidden!=undefined && componentDetails.hidden)
						{
							idComponent_multi.hide();
						}
						else
						{
							idComponent_multi.show();
						}
						var rawData = componentDetails.possibleData
						var dispName = componentDetails.dispName
						var selectedVal = componentDetails.selectedVal;
						var er_server = Ext.getCmp(componentDetails.id)
						er_server.fieldValue= selectedVal;
						er_server.storeData = rawData;
					}
					else if(componentDetails.type=='textfield')
					{
						var selectedVal = componentDetails.selectedVal;
						var dispName = componentDetails.dispName
						idComponent.setValue(selectedVal);
						idComponent.setFieldLabel(dispName);
					}
				}
			}
			if(id==formId)
			{
				startSetValue = true;
			}
		}
	},
	submitReport:function(obj)
	{
		additionalParams = '';
		Ext.getCmp('er_timeline').fireEvent('forceSelect',Ext.getCmp('er_timeline'));
		//this.showResult(Ext.getCmp('submit'));
	},
	showResult:function(obj)
	{
		var me = this;
		var queryParams = me.getChangeEventQueryStr(obj.id);
		var timelineParams = '';
		if(queryParams!='')
		{
			timelineParams = me.getTimelineQuery();
		}
		var settingParams = '';
		if(timelineParams!='')
		{
			settingParams = me.getMoreOptionsQuery();
		}
		var URL_SERVLET = processServlet;
		var reportGeneration = Ext.getCmp('reportGeneration').getValue();
		if(reportGeneration!=undefined && reportGeneration != 'foreground')
		{
			URL_SERVLET = backgroundControllerUrl;
			settingParams+='&savereport=save&servletName=com.eg.'+processServlet
			if(reportGeneration == 'background-csv')
			{
				settingParams+='&SaveFormat=CSV&isBackgroundCSV=Yes';
			}
		}
		if(queryParams!='' && timelineParams!='' && settingParams!='')
		{
			if(isPreloadReort!=undefined && isPreloadReort=='yes' && reportGeneration!=undefined && reportGeneration == 'foreground')
			{
				if(appConstants.showMainForm=='no')
				{
					Ext.getCmp('mainform').hide();
				}
				Ext.getCmp('backGroundPanel').hide();
				var resultPanelObj = Ext.getCmp('resultPanel');
				resultPanelObj.removeAll();
				resultPanelObj.add(
				{
					xtype:resultpanel.toLowerCase(),
					params:'templateFor='+appConstants.templateFor+'&'+queryParams+'&'+timelineParams+'&'+settingParams
				});
				this.getNomeasurepanel().hide();
				resultPanelObj.show();
			}
			else
			{
				RUN_URL_PARAM = 'templateFor='+appConstants.templateFor+'&'+queryParams+'&'+timelineParams+'&'+settingParams
				appConstants.initLdgMask.show();
				Ext.Ajax.request(
				{
					url :'../../final/servlet/com.eg.'+URL_SERVLET,
					params :RUN_URL_PARAM,
					method :'POST',
					scope:this,
					async :true,
					success: function(response)
					{
						try
						{
							if(appConstants.showMainForm=='no')
							{
								Ext.getCmp('mainform').hide();
							}
							var resultJson = Ext.decode(response.responseText);
							appConstants.initLdgMask.hide();
							me.loadResultPanel(resultJson);
						}
						catch(e)
						{
							console.log(e)
						}
					}
				});
			}
		}
		else
		{
			console.log('Error in Form Selections');
		}
	},
	exportFunctions:function(obj)
	{
		var me = this;
		var queryParams = me.getChangeEventQueryStr('submit');
		var timelineParams = '';
		if(queryParams!='')
		{
			timelineParams = me.getTimelineQuery();
		}
		var settingParams = '';
		if(timelineParams!='')
		{
			settingParams = me.getMoreOptionsQuery();
		}
		if(queryParams!='' && timelineParams!='' && settingParams!='')
		{
			var btnId = obj.isContained.id
			var saveID = obj.id;
			var hiddenFields=appConstants.publicJsonData.hiddenFields;
			var from_schedule = hiddenFields["fromSchedule"];
			var totalParams = 'templateFor='+appConstants.templateFor+'&'+queryParams+'&'+timelineParams+'&'+settingParams;
			if(appConstants.templateFor=='Events_Overview')
			{
				totalParams+='&pageWidthProces=9999';
			}
			if(appConstants.templateFor=='mailDeliverability')
			{
				totalParams+='&pageWidthProces=1200';
			}
			if(btnId=='saveTool')
			{
				this.saveReportAsPDF(totalParams);
			}
			else if(btnId=='printTool')
			{
				this.printFile(totalParams);
			}
			else if(btnId=='mailTool')
			{
				this.sendMail(totalParams);
			}
			else if(btnId=='favoriteTool')
			{
				this.saveFavorite(totalParams,obj);
			}
			else if(btnId=='scheduleTool')
			{
				this.saveSchedule(totalParams,obj);
			}
			else if(btnId=='csvTool')
			{
				this.saveCsv(totalParams);
			}
			else if(saveID=='save')
			{
				if ((from_schedule != null && from_schedule == "Yes"))
				{
					this.saveSchedule(totalParams,obj);
				}
				else
				{
					this.saveFavorite(totalParams,obj);
				}
			}
		}
	},
	saveCsv:function(params)
	{
		if(appConstants.templateFor=='Sql_Report')
		{
			appConstants.initLdgMask.hide();
			Ext.Ajax.request(
			{
				url :'../../final/servlet/com.eg.'+processServlet,
				params:'templateFor='+appConstants.templateFor+'&requestFor=setCsvData&csvKeys=forSqlUrls&csvKeys=forSqlExecution&csvKeys=forSqlError',
				scope:this,
				success: function(response)
				{
					appConstants.initLdgMask.hide();
					window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
				}
			});
		}
		else if(appConstants.templateFor=='APPLICATION_PERF_WVD')
		{
			appConstants.initLdgMask.hide();
			Ext.Ajax.request(
			{
				url :'../../final/servlet/com.eg.'+processServlet,
				params:'templateFor='+appConstants.templateFor+'&option=csv&'+params,
				scope:this,
				success: function(response)
				{
					appConstants.initLdgMask.hide();
					window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
				}
			});
		}
		else
		{
			window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
		}
	},
	saveReportAsPDF:function(params)
	{
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+params;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	printFile:function(params)
	{
		if(params==undefined)
		{
			params = this.bookletQuery();
		}
		var s_qryString = '/final/reporter/'+appPrintPage+'?'+params+"&er_view=PRINT&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(params)
	{
		Ext.widget('sendmail').show();
	},
	saveFavorite:function(params,obj)
	{
		var target="";
		
		if (obj.getId()=='save')
		{
			this.isNewFav=false;
			target="/final/reporter/ErSaveFavorite.jsp?"+params+"&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			
			if(target!=undefined && target.indexOf("FavoriteId")==-1)
				target+='&FavoriteId='+appConstants.FavoriteId;
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewFav=true;
			target="../servlet/com.eg.ErFavoriteC?"+params+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	saveSchedule:function(params,obj)
	{
		
 		if(Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title: alert_text,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var target="/final/reporter/ErSaveSchedule.jsp?"+params+"&option=data&com.eg.CSRF_NONCE="+csrfToken;
 		if (obj.getId()=='save')
		{
			if(target!=undefined && target.indexOf("schedule_id")==-1)
			{
				target+='&schedule_id='+appConstants.schedule_id;
			}
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	bookletQuery: function(obj)
	{
		var me = this;
		var queryParams = me.getChangeEventQueryStr('submit');
		var timelineParams = '';
		if(queryParams!='')
		{
			timelineParams = me.getTimelineQuery();
		}
		var settingParams = '';
		if(timelineParams!='')
		{
			settingParams = me.getMoreOptionsQuery();
		}
		var s_qryString = '';
		if(queryParams!='' && timelineParams!='' && settingParams!='')
		{
			s_qryString = 'templateFor='+appConstants.templateFor+'&'+queryParams+'&'+timelineParams+'&'+settingParams
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var me = this;
		var queryParams = me.getChangeEventQueryStr('submit');
		var timelineParams = '';
		if(queryParams!='')
		{
			timelineParams = me.getTimelineQuery();
		}
		var settingParams = '';
		if(timelineParams!='')
		{
			settingParams = me.getMoreOptionsQuery();
		}
		var bookletquery = '';
		if(queryParams!='' && timelineParams!='' && settingParams!='')
		{
			bookletquery = 'templateFor='+appConstants.templateFor+'&'+queryParams+'&'+timelineParams+'&'+settingParams
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	loadForm:function()
	{
		var me = this;
		if(appConstants.publicJsonData.isCsvEnabled!=undefined && appConstants.publicJsonData.isCsvEnabled)
		{
			isCsvEnabled = true;
		}
		else
		{
			isCsvEnabled = false;
		}
		isPreloadReort = appConstants.publicJsonData.isPreloadReort;
		var mainformObj = Ext.getCmp('mainform');
		var templateformObj = Ext.getCmp('templateform');
		var drilldownmainformObj = Ext.getCmp('drilldownmainform');
		var formAryObj = appConstants.publicJsonData.formObj;
		processServlet = appConstants.publicJsonData.processServlet;
		appJsonPage = appConstants.publicJsonData.processJson;
		appPrintPage = appConstants.publicJsonData.processPrintPage;
		var reportName = appConstants.publicJsonData.reportName;
		appConstants.er_RmDispName = reportName;
		var isHorizonEvents = appConstants.publicJsonData.reportName;
		if(!appConstants.hideBackButton){
			Ext.getCmp('templateform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					margin:'0',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		this.getMain().setTitle(reportName);
		var haveMultiSelectField = false;
		if(formAryObj!=undefined)
		{
			for(var formObjIndex in formAryObj)
			{
				var formObj = formAryObj[formObjIndex];
				var type = formObj.type;
				var selectedVal = formObj.selectedVal;
				var position = formObj.position;
				var id = formObj.id;
				var dispName = formObj.dispName;
				var possibleData = formObj.possibleData;
				var eventSide = formObj.eventSide;
				var isHidden = false;
				if(formObj.hidden!=undefined)
				{
					isHidden = formObj.hidden;
				}
				if(type=='combo')
				{
					var width = 140;
					if(formObj.width!=undefined && formObj.width!='')
					{
						width = formObj.width;
					}
					templateformObj.add({
						xtype:'scrollcombo',
						fieldLabel:dispName,
						labelSeparator : '',
						labelAlign:position,
						hidden:isHidden,
						cls: 'dropdown',
						width:width,
						eventSide:eventSide,
						id: id,
						name: id,
						editable:true,
						store: Ext.data.Store
						(
							{
								fields: ['displayField','valueField','groupField'],
								data: possibleData
							}
						),
						displayField: 'displayField',
						valueField: 'valueField',
						groupField: 'groupField',
						value:selectedVal,
						queryMode: 'local',
						listConfig: 
						{
							tpl: Ext.create('Ext.XTemplate',
							 '<ul><tpl for=".">',
								'<tpl if="this.validate(values)">',
									'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
										'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
									'</tpl>',
									'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0 && values.valueField==\'all\'"><tpl else >padding-left:12px</tpl>">{displayField}</li>',
								'<tpl else>',
									'<li role="option" class="x-boundlist-item">{displayField}</li>',
								'</tpl>',
							  '</tpl>' +
							  '</ul>',
							{
								getGroupLabel:function(values) 
								{
									return values.groupField;
								},
								validate:function(values) 
								{
									if(!showUnmanagedCompUI)
									{
										return false;
									}
									else
									{
										if(values.groupField==undefined || values.groupField.length==0)
										{
											return false;
										}
										else
										{
											return true;
										}
									}
								}
							})
						},
						listeners:
						{
							'select':function(obj)
							{
								if(this.eventSide=='')
								{
									return;
								}
								else
								{
									me.changeEventProcess(obj)
								}
							}
						}
					});
				}
				else if(type=='multiselect')
				{
					var width = 220;
					if(formObj.width!=undefined && formObj.width!='')
					{
						width = formObj.width;
					}
					haveMultiSelectField = true;
					var hideMultiSelect = false;
					var hideTextField = true;
					if(possibleData.length>10000)
					{
						possibleData = [];
						selectedVal = [];
						hideMultiSelect = true;
						hideTextField = false;
					}
					if(isHidden)
					{
						hideMultiSelect = true;
						hideTextField = true;
					}
					mainformObj.add({
						xtype:'fieldcontainer',
						layout:'vbox',
						margin:'0 0 0 10',
						hidden:hideMultiSelect,
						id:id+'_container',
						items:[
						{
							xtype:'label',
							text:dispName,
							margins: '0 0 5 0'
						},
						{
							xtype:'container',
							layout:'hbox',
							items:[
							{
								xtype:'container',
								width : width,
								margin:'0px 0px 0px 0px',
								cls:'multiselectcontainer',
								items:[
								{
									xype:'container',
									cls:'multisearchlist',
									items:[
										{
											xtype: 'customtrigger',
											emptyText:'Search',
											id:id+'_trigger',
											width:width-12,
											possibleData:possibleData,
											listeners:
											{
												'change':function(obj)
												{
													me.filterMultiselect(obj);
												}
											}
										}
									]
								},
								{
									width: width,
									xtype: 'multiselectfield',
									autoScroll:false,
									scroll:false,
									height:90,
									labelAlign:'left',
									allowBlank: false,
									id: id,
									name: id,
									eventSide:eventSide,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField','groupField'],
										data : possibleData
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									groupField: 'groupField',
									value:selectedVal,
									queryMode: 'local',
									listConfig: 
									{
										tpl: Ext.create('Ext.XTemplate',
										 '<ul><tpl for=".">',
											'<tpl if="this.validate(values)">',
												'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
													'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
												'</tpl>',
												'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0 && values.valueField==\'all\'"><tpl else >padding-left:12px</tpl>">{displayField}</li>',
											'<tpl else>',
												'<li role="option" class="x-boundlist-item">{displayField}</li>',
											'</tpl>',
										  '</tpl>' +
										  '</ul>',
										{
											getGroupLabel:function(values) 
											{
												return values.groupField;
											},
											validate:function(values) 
											{
												if(!showUnmanagedCompUI)
												{
													return false;
												}
												else
												{
													if(values.groupField==undefined || values.groupField.length==0)
													{
														return false;
													}
													else
													{
														return true;
													}
												}
											}
										})
									},
									listeners:
									{
										'change':function(obj, newValue, oldValue, eOpts)
										{
											if(this.eventSide=='')
											{
												return;
											}
											else
											{
												var proceed = false;
												if(newValue!=undefined && newValue.length>0 && newValue[0]!='-1')
												{
													proceed = true;
												}
												if(proceed)
												{
													if(obj.id=='er_component' && Ext.Array.contains(newValue,'all') && newValue.length>1)
													{
														Ext.MessageBox.show({
															title: 'Alert',
															msg:  'Individual and All components should not be selected simultaneously',
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
														});
														return;
													}
													me.changeEventProcess(obj);
												}
											}
										}
									}
								}]
							},
							{
								xtype : 'container',
								margin :  '10px 0 0 5px',
								items : [
								{
									xtype : 'button',
									iconCls : 'iconMultiselectExpand',
									id:id+'_expand',
									listeners: 
									{
										afterrender:function()
										{
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: dispName
											});
										},
										click:function(obj)
										{
											me.expandMe(obj)
										}
									},
									style:
									{
										background : 'none',
										border : '0px'
									}
								}]
							}]
						}]
					});
					mainformObj.add({
						xtype:'textfield',
						fieldLabel:dispName,
						labelAlign:'top',
						margin:'0 0 0 10',
						width:210,
						hidden:hideTextField,
						labelSeparator:'',
						cls:'textbox',
						id:id+'_TxtField',
						name:id+'_TxtField',
					});
				}
				else if(type == 'expMultiselect')
				{
					var width = 200;
					if(formObj.width!=undefined && formObj.width!='')
					{
						width = formObj.width;
					}
					templateformObj.add({
						xtype:'fieldcontainer',
						layout:'column',
						id:id+'_expMultiSelect',
						width:width,
						items:[
						{
							xtype: 'textfield',
							cls: 'textbox',
							columnWidth:.85,
							fieldLabel:dispName,
							labelAlign:position,
							margin:'0 5 0 0',
							fieldValue:selectedVal,
							readOnly:true,
							eventSide:eventSide,
							storeData:possibleData,
							dispName:dispName,
							type:type,
							id: id,
							name:id,
							listeners:
							{
								afterrender: function ()
								{
									var slctdVal = this.fieldValue;
									if (slctdVal == 'all')
									{
										slctdVal = "All "+this.dispName;
									}
									this.setValue(slctdVal);
								},
							}
						},
						{
							xtype: 'button',
							margin :  '20px 0 0 5px',
							iconCls: 'iconMultiselectExpand',
							tooltip: '<b>'+dispName+'</b>',
							columnWidth:.15,
							fieldId:id,
							style:
							{
								 background: 'none',
								 border: '0px'
							},
							handler:function(obj)
							{
								var id = obj.fieldId;
								var ddTxtValueStr=Ext.getCmp(id).fieldValue;
								if(ddTxtValueStr.length==0)
								{
									ddTxtValueStr = 'all';
								}
								console.log('ddTxtValueStr ___ ',ddTxtValueStr)
								var ddTxtValue = ddTxtValueStr.split(',');
								var storeData = Ext.getCmp(id).storeData;
								var eventSide = Ext.getCmp(id).eventSide;
								var displayName= Ext.getCmp(id).dispName;
								Ext.create('Ext.window.Window',{
									title:displayName,
									autoScroll:false,
									scroll:false,
									id:'expMuSelectId',
									border:false,
									frame:false,
									modal: true,
									ghost: false,
									header:false,
									style:{
										'background':'transparent !important'
									},
									bodyStyle:{
										'background':'transparent !important'
									},
									ui:'newPopupWindow',
									padding:'0 10 5 10',
									buttonAlign:'center',
									listeners: {
										show: function (win) {
											if (this.modal) {
												var dom = Ext.dom.Query.select('.x-mask');
												for (var y = 0; y < dom.length; y++) {
													var el = Ext.fly(dom[y]);
												}
											el.addCls('windowModalNoBg');
											}
										},
										hide: function (win) {
											var dom = Ext.dom.Query.select('.x-mask');
											if (this.modal) {
												var el = Ext.fly(dom[0]);
												el.removeCls('windowModalNoBg');
											}
										},
										afterrender: function () {
											Ext.EventManager.onWindowResize(function () {
												var me = this;
												me.center();
											}, this);
										}
									},
									doClose: function() {
										var me = this;
										if (me.hidden) {
											me.fireEvent('close', me);
											if (me.closeAction == 'destroy') {
												this.destroy();
											}
										} else {
											me.hide(me.animateTarget, me.doClose, me);
										}
									},
									buttonAlign:'center',
									items:[
									{
										xtype:'panel',
										title:displayName,
										margin:5,
										layout:{
											type:'vbox',
											pack:'center',
											align:'stretch'
										},
										buttonAlign:'center',
										ui:'newFormFieldsInPopup',
										items:[
											{
												xtype: 'container',
												width: width,
												margin: '0 10 0 10',
												items: [
												{
													xype: 'container',
													cls:'multisearchlist',
													items: [
													{
														xtype: 'customtrigger', 
														emptyText: 'Search '+displayName,
														id: 'userSearch',
														possibleData:possibleData,
														listeners:
														{
															change:function(obj)
															{
																obj.toggleTriggger();
																if (Ext.isEmpty(appConstants.erUtils))
																	appConstants.erUtils = Ext.widget("erutils");
																appConstants.erUtils.filterComboStore(obj,Ext.getCmp(id+'_expMultipleSelect'),storeData);
															}
														}
													}],
												}]
											},
											{
												xtype: 'multiselectfield',
												width: 250,
												height:200,
												border : 0,
												margin: '0 10 0 10',
												autoScroll:true,
												//maxSelections:1,
												scroll:false,
												selModel:
												{
													mode:'SIMPLE'
												},
												labelAlign:'left',
												baseCls: 'egmultiselect',
												multiSelect: false,
												id: id+'_expMultipleSelect',
												name: id+'_expMultipleSelect',
												eventSide:eventSide,
												store: new Ext.data.Store({
													fields: ['displayField', 'valueField','groupField'],
													data: storeData
												}),
												displayField: 'displayField',
												valueField: 'valueField',
												groupField: 'groupField',
												queryMode: 'local',
												listeners:
												{
													afterrender: function ()
													{
														this.getStore().loadRawData(storeData);
														this.setValue(ddTxtValue);
													},
												},
												listConfig: 
												{
													tpl: Ext.create('Ext.XTemplate',
													 '<ul><tpl for=".">',
														'<tpl if="this.validate(values)">',
															'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
																'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
															'</tpl>',
															'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0 && values.valueField==\'all\'"><tpl else >padding-left:12px</tpl>">{displayField}</li>',
														'<tpl else>',
															'<li role="option" class="x-boundlist-item">{displayField}</li>',
														'</tpl>',
													  '</tpl>' +
													  '</ul>',
													{
														getGroupLabel:function(values) 
														{
															return values.groupField;
														},
														validate:function(values) 
														{
															if(!showUnmanagedCompUI)
															{
																return false;
															}
															else
															{
																if(values.groupField==undefined || values.groupField.length==0)
																{
																	return false;
																}
																else
																{
																	return true;
																}
															}
														}
													})
												},
											}
										],
										buttons:[
											{
												text:'Select',
												id: 'expand',
												margin:'0 10 10 10',
												ui:'newButtonSmall',
												name: 'expand',
												handler: function()
												{
													console.log('valiue ',Ext.getCmp(id+'_expMultipleSelect').getValue())
													if (Ext.getCmp(id+'_expMultipleSelect').getValue() != '-1' && Ext.getCmp(id+'_expMultipleSelect').getValue() != '' && (Ext.getCmp(id+'_expMultipleSelect').getValue()).length>0 )
													{
														var comboValAry = new Array()
														comboValAry= Ext.getCmp(id+'_expMultipleSelect').getValue();
														if(comboValAry[0] == 'all' && comboValAry.length>1)
														{
															 Ext.MessageBox.show({
																title: 'Alert',
																msg: 'Individual and All components should not be selected simultaneously',
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return;
														}
														var comboVal = '';
														var comboValUi = '';
														for (var key in comboValAry)
														{
															var vals = comboValAry[key];
															var valsUI = vals;
															if(valsUI.indexOf(":")>-1)
															{
																valsUI.substring(0, valsUI.lastIndexOf(":"));
															}
															if(valsUI.indexOf(":NULL")>-1)
															{
																valsUI= vals.substring(0, valsUI.indexOf(":"));
															}
															if(valsUI=='all')
															{
																valsUI = 'All '+displayName;
															}
															if(comboVal.length==0)
															{
																comboVal+=vals;
																comboValUi+=valsUI;
															}
															else
															{
																comboVal+=','+vals;
																comboValUi+=','+valsUI;
															}
														}
														Ext.getCmp(id).setValue(comboValUi);
														Ext.getCmp(id).fieldValue = comboVal;
														var isSvrReNeed = Ext.getCmp(id).eventSide;
														if(isSvrReNeed!= '' && isSvrReNeed=='server')
														{
															var textFieldObj = Ext.getCmp(id);
															me.changeEventProcess(textFieldObj);
														}
														this.up('window').destroy();
													}
													else
													{
														 Ext.MessageBox.show({
															title: 'Alert',
															msg: 'Please Choose'+displayName,
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
														});
														return;
													}
												}
											}
										],
										tools:[
										{
											xtype:'button',
											iconCls: 'iconCloseNew',
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html: close
													});
												},
												click:function(){
													Ext.getCmp('expMuSelectId').doClose();
												}
											},
											style: {
												background: 'none',
												border: '0px'
											}
										}]	
								}]
							}).show();
							}
						}]
					});
				}
				else if(type=='radio')
				{
					var buttonLabel = formObj.buttonLabel;
					var needChangeEvent = 'No';
					var radioAry = new Array();
					var width = 100;
					if(formObj.width!=undefined && formObj.width!='')
					{
						width = formObj.width;
					}
					if(formObj.needChangeEvent!=undefined && formObj.needChangeEvent!='')
					{
						needChangeEvent = formObj.needChangeEvent;
					}
					for(var i in possibleData)
					{
						var checked = false;
						if(selectedVal==possibleData[i])
						{
							checked = true;
						}
						radioAry.push({
							xtype: 'radiofield',
							boxLabel: buttonLabel[possibleData[i]],
							name: id,
							id: possibleData[i],
							inputValue: possibleData[i],
							checked:checked
						});
					}
					templateformObj.add({
						xtype: 'radiogroup',
						width: width,
						hidden:isHidden,
						fieldLabel: dispName,
						id: id,
						cls:'radiobt',
						eventSide:eventSide,
						height:47,
						items: radioAry,
						listeners:
						{
							'change':function()
							{
								if(this.eventSide=='')
								{
									return;
								}
								else
								{
									me.changeEventProcess(this)
								}
							}
						}
					});
				}
				else if(type=='textfield')
				{
					var width = 140;
					if(formObj.width!=undefined && formObj.width!='')
					{
						width = formObj.width;
					}
					var tooltipTxt='';
					if(formObj.tooltipTxt!=undefined && formObj.tooltipTxt!='')
					{
						tooltipTxt = formObj.tooltipTxt;
					}
					templateformObj.add({
						xtype:'textfield',
						fieldLabel:dispName,
						labelAlign:'top',
						width:width,
						hidden:isHidden,
						labelSeparator:'',
						value:selectedVal,
						cls:'textbox',
						id:id,
						name:id,
						listeners: {
							render: function(c) {
								if(tooltipTxt==undefined || tooltipTxt.length==0)
									return;
								new Ext.ToolTip({
									target: c.getEl(),
									html:tooltipTxt,									
								});
							}
						},
					});
				}
			}
		}
		if(appConstants.showMainForm=='yes')
		{
			var noNeedTimeLine=appConstants.publicJsonData.noNeedTimeLine;
			templateformObj.add({
				xtype:timeLine.toLowerCase(),
				id:'timeline',
				hidden:noNeedTimeLine,
				margin:0
			});
			if(haveMultiSelectField)
			{
				if(isHorizonEvents == 'Horizon Events')
				{
					templateformObj.add({
						xtype:'button',
						text: submitValue,
						margin: '20 10 10 0',
						//cls: 'button20',
						ui:'newButtonSmall',
						id: 'submit',
						name: 'submit'
					});
				}
				else
				{
					mainformObj.add({
						xtype:'button',
						text: submitValue,
						margin: '120 10 10 0',
						//cls: 'button20',
						ui:'newButtonSmall',
						id: 'submit',
						name: 'submit'
					});
				}
			}
			else
			{
				templateformObj.add({
					xtype:'button',
					text: submitValue,
					margin: '20 10 10 0',
					//cls: 'button20',
					ui:'newButtonSmall',
					id: 'submit',
					name: 'submit'
				});
			}
		}
		else
		{
			drilldownmainformObj.add({
				xtype:timeLine.toLowerCase(),
				margin:0
			});
			drilldownmainformObj.add({
				xtype:'button',
				text: submitValue,
				margin: '20 10 10 0',
				//cls: 'button20',
				ui:'newButtonSmall',
				id: 'submit',
				name: 'submit'
			});
			drilldownmainformObj.show();
		}
		mainformObj.add({
			xtype:'button',
			text: "Save",
			//cls: 'button20',
			ui:'newButtonSmall',
			id: "save",
			name: "save",
			margin: '120 10 10 0'
		});
		mainformObj.add({
			xtype:'button',
			cls:'iconPanelUpArrow',
			id:'panelinsidetoggle',
			border:false,
			bodyStyle:{'background':'none'},
			hidden:true
		});
		this.loadComboField('er_timeline','timelineCombo','','selectedTimeline',appConstants.publicJsonData,false,null,false);
		var date = appConstants.publicJsonData.selectedFields.startDateForDisplay;
		var component = Ext.getCmp('er_stdate');
		component.setValue(date);
		component.dataArray = appConstants.publicJsonData.selectedFields.startDate;
		date = appConstants.publicJsonData.selectedFields.endDateForDisplay;
		component = Ext.getCmp('er_enddate');
		component.setValue(date);
		component.dataArray = appConstants.publicJsonData.selectedFields.endDate;
	
		Ext.getCmp('er_sthr').setValue(appConstants.publicJsonData.selectedFields.startHourForDisplay);
		Ext.getCmp('er_endhr').setValue(appConstants.publicJsonData.selectedFields.endHourForDisplay);
		Ext.getCmp('er_sthr').dataArray = appConstants.publicJsonData.selectedFields.startHour;
		Ext.getCmp('er_endhr').dataArray = appConstants.publicJsonData.selectedFields.endHour;
		stmin = appConstants.publicJsonData.selectedFields.startMinForDisplay;
		enmin = appConstants.publicJsonData.selectedFields.endMinForDisplay;
		mgr_stmin = appConstants.publicJsonData.selectedFields.startmin;
		mgr_enmin = appConstants.publicJsonData.selectedFields.endmin;
		if(timeLine=='TimeLineNew')
		{
			Ext.getCmp('er_stmin').setValue(stmin);
			Ext.getCmp('er_endmin').setValue(enmin);
		}
		if(appConstants.publicJsonData.selectedFields.timeformat_trend=='Yes')
		{
			isTrend = true;
		}

		me.loadTools();
		this.showConfigDropdown();
		
		if(appConstants.showMainForm=='no')
		{
			this.getReporterSettings().hide();
		}
		var from_schedule = appConstants.frmSchModify;
		var fromFavoriteModify = appConstants.frmFavModify;
		if(appConstants.templateFor!=null && appConstants.templateFor=='EG_TABLE_COMSUME')
		{
			Ext.getCmp('mainform').hide();
		}
		if (from_schedule == "Yes" || fromFavoriteModify == "Yes")
		{
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			if(appConstants.showMainForm=='yes')
			{
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);
			}
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
			if(appConstants.isSubmit==true)
			{
				me.submitReport();
			}
		}
		if(appConstants.templateFor!=null && appConstants.templateFor=='HORIZON_LICENCE')
		{
			Ext.getCmp('timeline').hide();
		}
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPaneId,isSetLabel)
	{
		 var component = Ext.ComponentManager.get(comboId);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
 				var rawData = parentJsonProperty.combo[comboProperty];
				component.getStore().clearFilter(true); 
 				component.getStore().loadRawData(rawData);
			 
				if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
  						component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
 				else
					component.setValue(rawData[0].valueField);
				if (isSetLabel)
				{
					 if(parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect)
							component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
 						else
							Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
					 }
				}
				if(!isMultiSelect)
				{
					if(component.isHidden())
					component.show();
				}
				else
				{
					var m=Ext.ComponentManager.get(multiSelectPaneId);
					if(m.isHidden())
					m.show();
				}
 		 }
		 else
		 {
			if(!isMultiSelect)
			{
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(!m.isHidden())
				m.hide();
			}
		 }
 	},
	laodMoreSettingData:function(jsonData)
	{
		var moreOptionsGroupObj = jsonData.moreOptionsGroupObj;
		for(var moreOptionIndex in moreOptionsGroupObj)
		{
			var formAryObj = moreOptionsGroupObj[moreOptionIndex]
			var moreOptionIds = jsonData.moreOptionIds;
			for(var index in moreOptionIds)
			{
				var formId = moreOptionIds[index];
				var idComponent = Ext.getCmp(formId);
				var componentDetails = formAryObj[formId];
				if(idComponent!=undefined && componentDetails!=undefined)
				{
					if(componentDetails.hidden!=undefined && componentDetails.hidden)
					{
						idComponent.hide();
					}
					else
					{
						idComponent.show();
					}
					if(componentDetails.type=='combo' || componentDetails.type=='multiselect')
					{
						var rawData = componentDetails.possibleData
						var selectedVal = componentDetails.selectedVal;
						idComponent.getStore().loadRawData(rawData);
						idComponent.setValue(selectedVal);
						if(componentDetails.type=='multiselect')
						{
							Ext.getCmp(formId+'_trigger').possibleData=possibleData;
						}
					}
					else if(componentDetails.type=='textfield' || componentDetails.type=='numberfield')
					{
						var selectedVal = componentDetails.selectedVal;
						idComponent.setValue(selectedVal);
					}
				}
			}
		}
	},
	loadMoreSetting:function()
	{
		var me = this;
		var moreOptionsGroupObj = appConstants.publicJsonData.moreOptionsGroupObj;
		var noNeedTimePeriod = appConstants.publicJsonData.noNeedTimePeriod;
		var configModWidth = appConstants.publicJsonData.configModWidth;
		if(configModWidth==undefined)
		{
			configModWidth = 636;
		}
		Ext.getCmp('configMod').setWidth(configModWidth);
		var groupFieldMainContainer = new Array();
		var groupFieldMainContainerTemp = new Array();
		if(moreOptionsGroupObj!=undefined)
		{
			for(var formObjIndex in moreOptionsGroupObj)
			{
				var formGroupObj = moreOptionsGroupObj[formObjIndex];
				var groupFieldContainer = new Array();
				
				var groupContainer = new Array();
				for(var index in formGroupObj)
				{
					var formObj = formGroupObj[index];
					var type = formObj.type;
					var selectedVal = formObj.selectedVal;
					var position = formObj.position;
					var id = formObj.id;
					var dispName = formObj.dispName;
					var serverId = formObj.serverId;
					var possibleData = formObj.possibleData;
					var eventSide = formObj.eventSide;
					var isHidden = false;
					var labelWidth = formObj.labelWidth;
					if(formObj.hidden!=undefined)
					{
						isHidden = formObj.hidden;
					}
					if(type=='combo')
					{
						var width = 140;
						if(labelWidth==undefined)
						{
							labelWidth = 140;
						}
						if(formObj.width!=undefined && formObj.width!='')
						{
							width = formObj.width;
							labelWidth = width;
						}
						if(formObj.labelWidth!=undefined && formObj.labelWidth!='')
						{
							labelWidth = formObj.labelWidth;
							width = null;
						}
						groupContainer.push({
							xtype:'scrollcombo',
							fieldLabel:dispName,
							labelSeparator : '',
							width:width,
							labelWidth:220,
							labelAlign:position,
							cls: 'dropdown',
							hidden:isHidden,
							id: id,
							name: id,
							serverId:serverId,
							eventSide:eventSide,
							editable:true,
							store: Ext.data.Store
							(
								{
									fields: ['displayField','valueField'],
									data: possibleData
								}
							),
							displayField: 'displayField',
							valueField: 'valueField',
							value:selectedVal,
							queryMode: 'local',
							listeners:
							{
								'select':function(obj)
								{
									if(this.eventSide=='')
									{
										return;
									}
									else
									{
										obj.id=this.serverId;
										me.changeEventProcess(obj);
									}
								}
							}
						});
					}
					else if(type=='multiselect')
					{
						var hideMultiSelect = false;
						var hideTextField = true;
						if(possibleData.length>10000)
						{
							possibleData = [];
							selectedVal = [];
							hideMultiSelect = true;
							hideTextField = false;
						}
						if(isHidden)
						{
							hideMultiSelect = true;
							hideTextField = true;
						}
						groupContainer.push({
							xtype:'fieldcontainer',
							layout:'vbox',
							margin:'0 0 0 10',
							hidden:hideMultiSelect,
							id:id+'_container',
							items:[
							{
								xtype:'label',
								text:dispName,
								margins: '0 0 5 0'
							},
							{
								xtype:'container',
								layout:'hbox',
								items:[
								{
									xtype:'container',
									width : 220,
									margin:'0px 0px 0px 0px',
									cls:'multiselectcontainer',
									items:[
									{
										xype:'container',
										cls:'multisearchlist',
										items:[
											{
												xtype: 'customtrigger',
												emptyText:'Search',
												id:id+'_trigger',
												possibleData:possibleData,
												listeners:
												{
													'change':function(obj)
													{
														me.filterMultiselect(obj);
													}
												}
											}
										]
									},
									{
										width: 220,
										xtype: 'multiselectfield',
										autoScroll:false,
										scroll:false,
										height:90,
										labelAlign:'left',
										allowBlank: false,
										id: id,
										name: id,
										store: new Ext.data.Store({
											fields : ['displayField', 'valueField'],
											data : possibleData
										}),
										displayField: 'displayField',
										valueField: 'valueField',
										value:selectedVal,
										queryMode: 'local'
									}]
								},
								{
									xtype : 'container',
									margin :  '10px 0 0 5px',
									items : [
									{
										xtype : 'button',
										iconCls : 'iconMultiselectExpand',
										id:id+'_expand',
										listeners: 
										{
											afterrender:function()
											{
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html: dispName
												});
											},
											click:function(obj)
											{
												me.expandMe(obj)
											}
										},
										style:
										{
											background : 'none',
											border : '0px'
										}
									}]
								}]
							}]
						});
						groupContainer.push({
							xtype:'textfield',
							fieldLabel:dispName,
							labelAlign:'top',
							margin:'0 0 0 10',
							width:210,
							hidden:hideTextField,
							labelSeparator:'',
							cls:'textbox',
							id:id+'_TxtField',
							name:id+'_TxtField',
						});
					}
					else if(type=='radio')
					{
						var buttonLabel = formObj.buttonLabel;
						var needChangeEvent = 'No';
						var radioAry = new Array();
						var width = 100;
						if(formObj.width!=undefined && formObj.width!='')
						{
							width = formObj.width;
						}
						if(formObj.needChangeEvent!=undefined && formObj.needChangeEvent!='')
						{
							needChangeEvent = formObj.needChangeEvent;
						}
						for(var i in possibleData)
						{
							var checked = false;
							if(selectedVal==possibleData[i])
							{
								checked = true;
							}
							radioAry.push({
								xtype: 'radiofield',
								boxLabel: buttonLabel[possibleData[i]],
								name: id,
								id: possibleData[i],
								inputValue: possibleData[i],
								checked:checked
							});
						}
						groupContainer.push({
							xtype: 'radiogroup',
							width: width,
							fieldLabel: dispName,
							id: id,
							hidden:isHidden,
							eventSide:eventSide,
							needChangeEvent:needChangeEvent,
							cls:'radiobt',
							height:47,
							items: radioAry,
							listeners:
							{
								'change':function()
								{
									if(this.eventSide=='')
									{
										return;
									}
									else
									{
										me.changeEventProcess(this)
									}
								}
							}
						});
					}
					else if(type=='numberfield')
					{
						if(formObj.width!=undefined && formObj.width!='')
						{
							width = formObj.width;
						}
						var cls_ = '';
						if(formObj.cls!=undefined && formObj.cls!='')
						{
							cls_ = formObj.cls;
						}
						var margins = '10 10 0 0';
						if(appConstants.templateFor=='mailDeliverability')
						{
							dispName = '<div class="iconStateThin12_'+dispName+'" style="padding-left:15px;">'+dispName+'</div>';
							margins = '3 10 0 0';
							cls_ = 'textbox';
							position='top';
						}
						groupFieldContainer.push(
						{
							fieldLabel:dispName,
							xtype:'numberfield',
							allowNegative: false,
							allowBlank:false,
							labelAlign:position,
							minValue: 1,
							decimalPrecision:3,
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							labelSeparator: '',
							margin: margins,
							labelWidth:labelWidth,
							id: id,
							name: id,
							width: width,
							cls: cls_,
							value:selectedVal
						});
						if(formObj.id != null && formObj.id.indexOf("Minor") < 0 && formObj.id.indexOf("minor") < 0)
						{
							groupFieldContainer.push(
							{
								xtype: 'container',
								height:30,
								cls:'newLineRight',
								margin:'5 20 9 10'
							});
						}
					}
					else if(type=='numberfieldWithColor')
					{
						if(formObj.width!=undefined && formObj.width!='')
						{
							width = formObj.width;
						}
						groupFieldMainContainerTemp.push({
							xtype: 'fieldcontainer',
							layout: 'column',
							margin: '0 20 0 0',
							fieldLabel: dispName,
							labelAlign: 'top',
							labelSeparator: '',
							items: [{
									fieldLabel: ' ',
									xtype: 'numberfield',
									allowNegative: false,
									labelAlign: 'right',
									minValue: 1,
									hideTrigger: true,
									keyNavEnabled: false,
									mouseWheelEnabled: false,
									labelSeparator: '',
									margin: '0 10 0 0',
									labelWidth:25,
									cls: 'textboxHigh',
									id: id,
									name: id,
									width: 90,
									value:selectedVal
								}]
						});
					}
					else if(type=='textfield')
					{
						var width = 140;
						if(formObj.width!=undefined && formObj.width!='')
						{
							width = formObj.width;
						}
						var tooltipTxt='';
						if(formObj.tooltipTxt!=undefined && formObj.tooltipTxt!='')
						{
							tooltipTxt = formObj.tooltipTxt;
						}
						groupContainer.push({
							xtype:'textfield',
							fieldLabel:dispName,
							labelAlign:'top',
							width:width,
							hidden:isHidden,
							labelSeparator:'',
							value:selectedVal,
							cls:'textbox',
							id:id,
							name:id,
							listeners: {
								render: function(c) {
									if(tooltipTxt==undefined || tooltipTxt.length==0)
										return;
									new Ext.ToolTip({
										target: c.getEl(),
										html:tooltipTxt,									
									});
								}
							},
						});
					}
					var columnWidth = 1.0;
					if(appConstants.templateFor=='mailDeliverability')
					{
						columnWidth = 0.5;
					}
					if(formObjIndex.indexOf('#')>-1)
					{
						var d_lablel = formObjIndex.substring(formObjIndex.indexOf('#')+1);
						groupFieldMainContainer.push({
							xtype:'container',
							layout:{
								type:'column',
								pack:'center',
								align:'center'
							},
							cls:'divFieldSet',
							id:d_lablel,
							height:56,
							columnWidth:columnWidth,
							padding:'10 0 10 25',
							margin:'20 10 0 10',
							html:'<div class="divFieldSetHeader">'+d_lablel+'</div>',
							items:groupFieldContainer
						});
					}
				}
				if(groupContainer.length==0)
				{
					continue;
				}
				this.getMoresettings().add({
					xtype:'container',
					layout:'hbox',
					columnWidth:1.0,
					margin:'10 5 10 0',
					defaults:
					{
						margin:'0 10 0 0'
					},
					items:groupContainer
				})
				this.getMoresettings().add({
					xtype: 'splitter',
					height: 2,
					columnWidth:1.0,
					margin: '2px 0px 0px 2px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				});
			}
		}

		this.getMoresettings().add({xtype:'timeperiod', columnWidth:1.0, margin: '10 15 10 0',hidden:noNeedTimePeriod});
		this.getMoresettings().add({
			xtype: 'splitter',
			hidden:noNeedTimePeriod,
			height: 2,
			columnWidth:1.0,
			margin: '2px 0px 0px 2px',
			draggable:false,
			style: {
				'cursor': 'default'
			}
		});
		if(groupFieldMainContainer!=undefined && groupFieldMainContainer.length>1)
		{
			this.getMoresettings().add({
				xtype:'container',
				columnWidth:1.0,
				layout:{
					type:'column',
					pack:'center',
					align:'center'
				},
				padding:'0 0 10 0',
				margin:0,
				cls:'rumSettingsBg',
				items:groupFieldMainContainer
			});
			this.getMoresettings().add({
				xtype: 'splitter',
				height: 2,
				columnWidth:1.0,
				margin: '2px 0px 0px 2px',
				draggable:false,
				style: {
					'cursor': 'default'
				}
			});
		}
    if(groupFieldMainContainerTemp !=undefined && groupFieldMainContainerTemp.length>0)
		{
			this.getMoresettings().add({
				xtype:'container',
				columnWidth:1.0,
				padding:'10 0 10 0',
				margin:0,
				items: groupFieldMainContainerTemp
			});
			this.getMoresettings().add({
				xtype: 'splitter',
				height: 2,
				columnWidth:1.0,
				margin: '2px 0px 0px 2px',
				draggable:false,
				style: {
					'cursor': 'default'
				}
			});
		}
		this.getMoresettings().add({xtype:'reportgeneration', columnWidth:1.0,margin: '10 15 10 0'});
		// set Data
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
		var FavoriteId =hiddenFields["FavoriteId"];
		if(!Ext.isEmpty(FavoriteId))
		{
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.publicJsonData,false,null,true);
		
		var selectedFields = appConstants.publicJsonData.selectedFields;
		Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
 		Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
 		Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
 		Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
		if(selectedFields.hasOwnProperty('reportNameSelected'))
		{
 			Ext.getCmp('bgReportName').setValue(selectedFields.reportNameSelected);
		}
		selectedFields =null;delete selectedFields;
		Ext.getCmp('moreOptionCloseId').show();

		this.getMoresettings().doComponentLayout();
		this.getMoresettings().doLayout();
	},
	showConfigDropdown : function() 
	{
		isSettingsEnabled = true;
		var thisController = this;
		var configModWidth = appConstants.publicJsonData.configModWidth;
		configModWidth = configModWidth-209;
		var tpl = new Ext.XTemplate('<div style="float:left;margin: 0px 0px 0px 0px;">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		if(appConstants.templateFor == 'mailDeliverability')
		{
			tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div><div style="float:right;height:20px;margin:0px 10px" class="userProfileSeparator"></div><div style="text-align:right;float:right;width:56px;padding:0px 0px 0px 0px;margin:0px 0px 0px 0px;vertical-align:middle" id="resetSetting" class="mouse"><div style="float:right;margin:2px 0px 0px 5px" class="iconRefresh" ></div><div style="float:right;" class="f11-normal" >RESET</div></div>');
		}
		Ext.create('Ext.container.Container',{
		width:600,
		id:'configMod',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				id:'popupArrow',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':configModWidth+'px'}
			},
			{
				xtype:'container',
				html: tpl.apply(),
				style:{'top':'0px','margin':'0px'},
				cls:'containerHeader',
			},
			{
				xtype:'moresettings',
				parent:this
			}
		],
		renderTo:'templatereportmain-body'
		});
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		if(Ext.get('closeSettings') != null)
		{
			var thisController = this;
			Ext.get('closeSettings').on('click',function(){
				thisController.validateAndCloseSettings();
			});
		}
		if(Ext.get('resetSetting') != null)
		{
			var thisController = this;
			Ext.get('resetSetting').on('click',function(){
				  thisController.resetSettings();
			});
		}
	},
	resetSettings:function()
	{
		this.fillSettingFieldsForActivity(appConstants.publicJsonData);
	},
	fillSettingFieldsForActivity:function(jsonData)
	{
		if(jsonData != undefined)
		{
			var moreOptionsGroupObj = jsonData.moreOptionsGroupObj;
			for(var formObjIndex in moreOptionsGroupObj)
			{
				var formGroupObj = moreOptionsGroupObj[formObjIndex];
				for(var index in formGroupObj)
				{
					var formObj = formGroupObj[index];
					var selectedVal = formObj.selectedVal;
					var id = formObj.id;
					Ext.getCmp(id).setValue(selectedVal);
				}
			}
		}
		var selectedFields = jsonData.selectedFields;
		Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
 		Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
 		Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
 		Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
 		Ext.getCmp('reportGeneration').setValue(selectedFields.reportGenerationSelected);
		Ext.getCmp('bgReportName').setValue('');
		Ext.getCmp('bgReportName').hide();
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			if(appConstants.templateFor!=null && appConstants.templateFor=='EG_TABLE_COMSUME')
			{
				this.submitReport();
			}
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	validateSettings:function()
	{
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
 		stDate.setHours(startHour);
 		enDate.setHours(endHour);
		if(reportgen!=null && reportgen != 'foreground' )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				isSettingsOk = false;
			}
		}
		return isSettingsOk;
	},
	loadTools : function()
	{
		if(appConstants.showMainForm=='no')
		{
			this.getNewUtilities().loadIcon(true, true, true, false, true, false, false, false, false, false, false);
		}
		else
		{
 			this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false, true);
			Ext.getCmp("favoriteTool").setDisabled(false);
			Ext.getCmp("scheduleTool").setDisabled(false);
		}
 	},
	disableTools: function()
	{
		if(appConstants.showMainForm=='yes')
		{
			Ext.getCmp("bookletTool").setDisabled(true);
		}
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	enableTools: function()
	{
		if(appConstants.showMainForm=='yes')
		{
			Ext.getCmp("bookletTool").setDisabled(false);
		}
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		if(isCsvEnabled)
		{
			Ext.getCmp("csvTool").setDisabled(false);
		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	onChangeReportGeneration:function()
	{
		var resultPanelObj = Ext.getCmp((resultpanel.toLowerCase())+'_id');
		if(resultPanelObj!=undefined && appConstants.templateFor!='EG_TABLE_COMSUME')
		{
			resultPanelObj.hide();
		}
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if(reportGenType== 'background')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(reportGenType== 'background-csv')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('bgReportName').hide();
		}
	}
});