Ext.define('TemplateReportApp.view.ResourceUasgeResult',{
	extend:'Ext.container.Container',
	alias:'widget.resourceuasgeresult',
	layout:'column',
	columnWidth:1.0,
	id:'resourceuasgeresult_id',
	margin: '10 0 10 0',
	items:[],
	listeners:
	{
		//boxready:function(obj)
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var me = this;
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		var thisWidth=mainDivWidth-52;
		try
		{
			if(resultJson!=undefined&& resultJson.RESULTS!=undefined)
			{
				var datas = resultJson.RESULTS;
				var summaryList = datas.summaryList;
				var avgChartMp = datas.avgChartMp;
				var avgUsedChartMp = datas.avgUsedChartMp;
				var grapMp = datas.remarksAndChart.grapMp;
				var gridData = datas.gridData;
				var gridColumn = datas.gridColumn;
				var summaryDataAry = new Array();
				for(var key in summaryList)
				{
					var summaryVal = summaryList[key];
					var unit = '';
					if(summaryVal.unit!=undefined)
					{
						unit = '<span class="newFont_normal13">&nbsp;'+summaryVal.unit+'</span>';
					}
					var html = '<table width="100%" align="center"><tbody>';
					html+='<tr></tr>';
					html+='<tr><td align="center" style="padding:5px 5px 0px 5px"><span class="f36-light">'+summaryVal.value+'</span>'+unit+'</td></tr>';
					html+='<tr><td align="center" colspan="2" style="padding:10px 5px 5px 5px"><span class="newFont_normal13">'+summaryVal.disp+'</span></td></tr>';
					html+='</tbody></table>';

					if(summaryList.length-1 != key)
					{
						summaryDataAry.push(
						{
							xtype:'container',
							bodyPadding:'0 10 10 10',
							columnWidth:1/summaryList.length,
							margin:'0 0 10 0',
							cls:'',
							layout:'fit',
							html:html
						},{
							xtype:'container',
							height:100,
							width:1,
							cls:'borderRightForFlexBox',
							margin:'0 0 15 5',
						});
					}
					else
					{
						summaryDataAry.push(
						{
							xtype:'container',
							bodyPadding:'0 10 10 10',
							columnWidth:1/summaryList.length,
							margin:'0 0 10 0',
							cls:'',
							layout:'fit',
							html:html
						},{
							xtype:'container',
							height:100,
							width:1,
							cls:'borderRightForFlexBox last',
							margin:'0 0 15 5',						
						});
					}
				}
				this.add(
				{
					xtype:'panel',
					ui:'newGraphPanel',
					title:'Summary',
					columnWidth:1,
					layout:'column',
					margin:'0 2 0 0',
					header:{
						style:{
							"padding":"13px 0px 15px 18px"
						}
					},
					items:summaryDataAry
				});
				this.add(
				{
					xtype:'panel',
					ui:'newGraphPanel',
					margin:'10 0 10 0',
					title:avgChartMp.title,
					padding:'0 0 10 0',
					columnWidth:1,
					layout:'column',
					items:[
					{
						xtype:'container',
						id:'roc_GraphPanel',
						height:357,
						columnWidth:1,
						html:'<div id="roc" style="height:357px"></div>',
						listeners:
						{
							boxready:function()
							{
								var lineChart = {};
								lineChart = jQuery.extend(true, {}, getHighChartsInstance('roc',"230","200"), lineChart);
								lineChart.setData(avgChartMp,appConstants.currentDateFormat,'');
								lineChart.drawChart();
							}
						}
					},
					{
						xtype:'container',
						columnWidth:1,
						id:'roc_legendPanel',
						height:53,
						style: 
						{
							'overflow': 'hidden',
							'padding-right':'10px'
						}
					}]
				});
				if(grapMp!=undefined)
				{
					this.add(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 0 10 0',
						title:grapMp.title,
						padding:'0 0 10 0',
						columnWidth:1,
						layout:'column',
						items:[
						{
							xtype:'container',
							id:'predict_GraphPanel',
							height:357,
							columnWidth:1,
							html:'<div id="predict" style="height:357px"></div>',
							listeners:
							{
								boxready:function()
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsInstance('predict',"230","200"), lineChart);
									lineChart.setData(grapMp,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						},
						{
							xtype:'container',
							columnWidth:1,
							id:'predict_legendPanel',
							height:53,
							style: 
							{
								'overflow': 'hidden',
								'padding-right':'10px'
							}
						}]
					});
				}
				if(avgUsedChartMp!=undefined)
				{
					this.add(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 0 10 0',
						title:avgUsedChartMp.title,
						padding:'0 0 10 0',
						columnWidth:1,
						layout:'column',
						items:[
						{
							xtype:'container',
							id:'coreUsage_GraphPanel',
							height:357,
							columnWidth:1,
							html:'<div id="coreUsage" style="height:357px"></div>',
							listeners:
							{
								boxready:function()
								{
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighChartsInstance('coreUsage',"230","200"), lineChart);
									lineChart.setData(avgUsedChartMp,appConstants.currentDateFormat,'');
									lineChart.drawChart();
								}
							}
						},
						{
							xtype:'container',
							columnWidth:1,
							id:'coreUsage_legendPanel',
							height:53,
							style: 
							{
								'overflow': 'hidden',
								'padding-right':'10px'
							}
						}]
					});
				}
				if(gridColumn!=undefined)
				{
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var count = 0;
					for (var key in gridColumn)
					{
						var align = 'center';
						var colName = gridColumn[key];
						if(colName instanceof Array)
						{
							var subColumnArray = new Array();
							for (var k in colName)
							{
								fieldsToStore.push(count+'');
								subColumnArray.push({
									header: colName[k],
									sortable: true,
									align:'center',
									dataIndex:count+'',
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										if(value.startsWith('-') && value!='-')
										{
											value='<table data-qtip="'+value.substring(1)+'" style="border:0px" align="center"><tbody><tr style="width:100%;border:0px;background:none"><td style="width:16px;border:0px;padding:0px"><div class="iconPanelDownArrow"></div></td><td style="border:0px;padding: 0px 0px 0px 3px;"><div style="text-align:left">'+value.substring(1)+'</div></td></tr></tbody></table>';
										}
										else
										{
											metaData.tdAttr = 'data-qtip="' + value + '"';
										}
										return value;
									},
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
														v1= isNaN(v1) ? 0 : v1;
														v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
								});
								count++;
							}
							mainColArray.push({
								header: key,
								sortable: true,
								width:110,
								columns:subColumnArray
							});
						}
						else
						{
							fieldsToStore.push(count+'');
							mainColArray.push({
								header: colName,
								sortable: true,
								resizable :true,
								align:'left',
								dataIndex: count+'',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttsr = 'data-qtip="' + value + '"';
									return value;
								},
								doSort: function(state) 
								{
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2)
										{
											v1 = v1.get(field);
											v2 = v2.get(field);
											
											if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
													v1= isNaN(v1) ? 0 : v1;
													v2= isNaN(v2) ? 0 : v2;
												}
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
							});
							count++;
						}
					}
					var isPagingHidden=false;
					 if (gridData!=undefined && gridData.length<=gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data : gridData,
						},
						//sorters: { property: fieldsToStore[3], direction : 'ASC' },
						pageSize:gridPageSize,
						autoLoad : true,
						remoteSort:true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 2 0 0',
						columnWidth:1.0,
						title:'Details',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							margin:'0 10 10 10',
							sortableColumns:true,
							ui:'newGridPanel',
							border:true,
							forceFit:true,
							id:'gridId',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							scroll:true,
							autoScroll:true,
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}
								}
							}],
							listeners:
							{
								render:function(obj)
								{
									Ext.defer(function() 
									{
										if(!Ext.isEmpty(obj.columns[1]))
										{
											//console.log('obj.columns  ',obj.columns);
											//obj.columns[7].items.items[0].doSort('DESC');
										}
									},100);
								}
							}
						}]
					});
				}
			}
		}
		catch (e)
		{
			console.log(e);
		}
	}
});
