Ext.define('TemplateReportApp.view.TopQueries',{
	extend:'Ext.container.Container',
	alias:'widget.topqueries',
	layout:'column',
	columnWidth:1.0,
	id:'topqueries_id',
	margin: '10 0 2 0',
	items:[],
	listeners:
	{
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		try
		{
			if(resultJson != undefined && resultJson.RESULTS != undefined)
			{
				var resultObj = resultJson.RESULTS;
				var panelObj = resultObj.panelObj;
				if(panelObj != undefined)
				{
					var cnt = 1;
					for(var index in panelObj)
					{
						var graphData = panelObj[index];
						var margin='0 0 10 0';
						if(cnt == 1 || cnt == 3)
						{
							margin='0 10 10 0';
						}
						else if(cnt == 2 || cnt == 4)
						{
							margin='0 2 10 0';
						}
						cnt++;
						if(graphData != undefined)
						{
							var graphId = graphData.graphId;
							this.add({
								xtype:'panel',
								ui:'newGraphPanel',
								margin:margin,
								height: 340,
								columnWidth:1/2,
								bodyPadding:'0 0 0 0',
								title:graphData.chartTitle,
								items:[
								{
									xtype:'container',
									columnWidth:1.0,
									id:graphId+'_GraphPanel',
									graphId:graphId,
									graphData:graphData,
									html:'<div id="'+graphId+'" style="height:230px"></div>',
									listeners:
									{
										'boxready':function()
										{
											{
												var lineChart = {};
												lineChart = jQuery.extend(true, {}, getHighChartsInstance(this.graphId,230,330), lineChart);
												lineChart.setData(this.graphData,this.graphData.currentDateFormat,'');
												lineChart.drawChart();
											}
										}
									}
								},
								{
									xtype:'container',
									margin:'10 10 10 0',
									id:graphId+'_legendPanel',
									height:52,
									style: {
										'overflow': 'hidden',
										'padding-bottom':'20px',
									}
								}]
							});
						}
						else
						{
							this.add({
								xtype:'panel',
								ui:'newGraphPanel',
								layout:'column',
								margin:margin,
								padding:'0 10 10 0',
								height: 350,
								columnWidth:1/2,
								title:graphData.chartTitle,
								items:[{
									xtype:'container',
									columnWidth:1.0,
									id:''+graphId+'_GraphPanel',
									html:'<div id='+graphId+' style="height:330px"><table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/Light/nomeasures_custom.png" /></td></tr></table></div>',
								}]
							});
						}
					}
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var tableData = resultJson.RESULTS.memUsageGridDataAry;
					var tableHeaderAry = resultJson.RESULTS.memUsageTableHeaderAry;
					var tableTitle = resultJson.RESULTS.memUsageTitle;
					for (var key in tableHeaderAry)
					{
						var align = 'left';
						var width=135;
						var headerCol = tableHeaderAry[key];
						if(key == 2)
						{
							align = 'center';
							width=115;
							headerCol = headerCol +  "<br>"+"(AVG)";
						}
						if(key == 1)
						{
							width = 500;
						}
						fieldsToStore.push(key);
						var flexVal = 1;
						mainColArray.push({
							header: headerCol,
							sortable: true,
							resizable :true,
							align:align,
							width:width,
							dataIndex: key,
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								var displayVal = value;
								var indexId = 'trace-mem-'+row;
								if(col == 1 && displayVal.length > 300)
								{
									displayVal = displayVal.substring(0,300)+'...&nbsp;<span style="text-decoration-line:underline;cursor:pointer;" onclick="javascript:expandMore(\''+appConstants.erUtils.specialCharEncode(displayVal)+'\',\'trace-mem-'+row+'\',\'more\',\'grid_mem_usage\')">more</span>';
								}
								if(col == 0)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								if(col==1)
									value = '<div id="'+indexId+'" style="white-space: normal;word-wrap:break-word">'+displayVal+'</div>';
								else
									value = '<div style="white-space: normal;">'+displayVal+'</div>';
								return value;
							},
						});
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data : tableData,
						},
						sorters: { property: fieldsToStore[3], direction : 'DESC' },
						pageSize:gridPageSize,
						autoLoad : true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:tableTitle,
						margin:'0 2 10 0',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:false,
							ui:'newGridPanel',
							border:true,
							id:'grid_mem_usage',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							bodyStyle:{'border-bottom-width':'0px'},
							scroll:true,
							autoScroll:true,
							listeners:{
								render:function(obj){
									Ext.defer(function() {
										obj.columns[2].doSort("DESC");
									},100);
								}
							},
						}]
					});
					//
					mainColArray=new Array();
					fieldsToStore=new Array();
					tableData = resultJson.RESULTS.cpuTimeGridDataAry;
					tableHeaderAry = resultJson.RESULTS.cpuUsageTableHeaderAry;
					tableTitle = resultJson.RESULTS.cpuUsageTitle;
					for (var key in tableHeaderAry)
					{
						var align = 'left';
						var width=135;
						var headerCol = tableHeaderAry[key];
						if(key == 2)
						{
							align = 'center';
							width=115;
							headerCol = headerCol +  "<br>"+"(AVG)";
						}
						if(key == 1)
						{
							width = 500;
						}
						fieldsToStore.push(key);
						var flexVal = 1;
						mainColArray.push({
							header: headerCol,
							sortable: true,
							resizable :true,
							align:align,
							width:width,
							dataIndex: key,
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								var displayVal = value;
								var indexId = 'trace-cpu-'+row;
								if(col == 1 && displayVal.length > 300)
								{
									displayVal = displayVal.substring(0,300)+'...&nbsp;<span style="text-decoration-line:underline;cursor:pointer;" onclick="javascript:expandMore(\''+appConstants.erUtils.specialCharEncode(displayVal)+'\',\'trace-cpu-'+row+'\',\'more\',\'grid_cpu_time\')">more</span>';
								}
								if(col == 0)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								if(col==1)
									value = '<div id="'+indexId+'" style="white-space: normal;word-wrap:break-word">'+displayVal+'</div>';
								else
									value = '<div style="white-space: normal;">'+displayVal+'</div>';
								return value;
							},
						});
					}
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data : tableData,
						},
						sorters: { property: fieldsToStore[3], direction : 'DESC' },
						pageSize:gridPageSize,
						autoLoad : true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:tableTitle,
						margin:'0 2 10 0',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:false,
							ui:'newGridPanel',
							border:true,
							id:'grid_cpu_time',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							bodyStyle:{'border-bottom-width':'0px'},
							scroll:true,
							autoScroll:true,
							listeners:{
								render:function(obj){
									Ext.defer(function() {
										obj.columns[2].doSort("DESC");
									},100);
								}
							},
						}]
					});
					//
					mainColArray=new Array();
					fieldsToStore=new Array();
					tableData = resultJson.RESULTS.waitTimeGridDataAry;
					tableHeaderAry = resultJson.RESULTS.waitTimeTableHeaderAry;
					tableTitle = resultJson.RESULTS.waitTimeTitle;
					for (var key in tableHeaderAry)
					{
						var align = 'left';
						var width=135;
						var headerCol = tableHeaderAry[key];
						if(key == 2)
						{
							align = 'center';
							width=115;
							headerCol = headerCol +  "<br>"+"(AVG)";
						}
						if(key == 1)
						{
							width = 500;
						}
						fieldsToStore.push(key);
						var flexVal = 1;
						mainColArray.push({
							header: headerCol,
							sortable: true,
							resizable :true,
							align:align,
							width:width,
							dataIndex: key,
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								var displayVal = value;
								var indexId = 'trace-wait-'+row;
								if(col == 1 && displayVal.length > 300)
								{
									displayVal = displayVal.substring(0,300)+'...&nbsp;<span style="text-decoration-line:underline;cursor:pointer;" onclick="javascript:expandMore(\''+appConstants.erUtils.specialCharEncode(displayVal)+'\',\'trace-wait-'+row+'\',\'more\',\'wait_time_grid\')">more</span>';
								}
								if(col == 0)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								if(col==1)
									value = '<div id="'+indexId+'" style="white-space: normal;word-wrap:break-word">'+displayVal+'</div>';
								else
									value = '<div style="white-space: normal;">'+displayVal+'</div>';
								return value;
							},
						});
					}
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data : tableData,
						},
						sorters: { property: fieldsToStore[3], direction : 'DESC' },
						pageSize:gridPageSize,
						autoLoad : true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:tableTitle,
						margin:'0 2 0 0',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:false,
							ui:'newGridPanel',
							border:true,
							id:'wait_time_grid',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							bodyStyle:{'border-bottom-width':'0px'},
							scroll:true,
							autoScroll:true,
							listeners:{
								render:function(obj){
									Ext.defer(function() {
										obj.columns[2].doSort("DESC");
									},100);
								}
							},
						}]
					});
					//observation
					var observationsAry = resultObj.observationsAry;
					var ObservationTitle = resultObj.ObservationTitle;
					var observationHtml = '';
					if (observationsAry != undefined && observationsAry.length > 0) 
					{
						observationHtml = '<div style="padding:11px 0px 10px 0px" class="font_bold15">' + ObservationTitle +'</div><div style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table  style="width: 100%;margin-bottom:10px; "><tbody>';
						for (var index = 0; index < observationsAry.length; index ++) 
						{
							var observationAryObj = observationsAry[index];
							observationHtml += '<tr style="padding-bottom:10px;">';
							if (observationAryObj != undefined) 
							{
								
								observationHtml += '<td width="50%" class="jvmHeaptable"><table><tr>';
								if(index>0 && index<observationsAry.length-1)
								{
									observationHtml  += '<td width="10px">&nbsp;</td>';
									observationHtml+='<td width="10px" style="vertical-align:top;padding-top:6px;"><div style="background-color:#707070;height:8px;width:8px;border-radius: 50%; border:1px solid #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + observationAryObj + '</td>';	
								}							
								if(index==0 || index==observationsAry.length-1)
								{
									observationHtml+='<td width="10px" style="vertical-align:top;padding-top:6px;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:1px solid #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + observationAryObj + '</td>';	
									observationHtml  += '<td></td>';
								}	
								observationHtml+='</tr></table></td>';
							}
							observationHtml += '</tr>';
						}
						observationHtml += '</tbody></table></div></td>';
						this.add(
						{
							xtype:'panel',
							ui:'newGraphPanel',
							padding:'0 0 0 0',
							columnWidth:1,
							margin:'10 2 0 0',
							items:[
							{
								xtype: 'container',
								padding: '0 10 0 10',
								margin: '10 10 10 10',
								cls: 'jvmObservPanelBox',
								columnWidth: 1.0,
								items: [
								{
									xtype: 'container',
									ui: 'newGraphPanel noShadow ',
									margin: '0 0 0 0',
									bodyPadding: '10px 0px 0px 10px',
									layout: 'column',
									items: [
									{
										xtype: 'container',
										columnWidth: 1.0,
										html:observationHtml
									}]
								}
								]
							}]
						});
					}
				}
			}
		}
		catch(e)
		{
			console.log(e);
		}
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'container',
			columnWidth:1.0,
			margin:10,
			height:height,
			html:'<div class="egFlexCenterByColumnWise" style="height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'!</div> </div>'
		}
	}
});


