Ext.define('TemplateReportApp.view.Waits',{
	extend:'Ext.container.Container',
	alias:'widget.waits',
	layout:'column',
	columnWidth:1.0,
	id:'waits_id',
	margin: '10 0 2 0',
	items:[],
	listeners:
	{
		afterrender:function(obj)
		{
			this.setData(this.data);
		}
	},
	setData:function(resultJson)
	{
		this.removeAll();
		var mainDivWidth=document.getElementById("templatereportmain").offsetWidth;
		try
		{
			var chartData = resultJson.RESULTS.panelObj.chartData;
			var contentHTML="";
			var gridTitle = resultJson.RESULTS.gridTitle;
			if(chartData != undefined)
			{
				if(chartData.gridData != undefined && chartData.gridData.length > 0)
				{
					var gridColHeader = chartData.gridColHeader;
					var tableDataAry = chartData.gridData;
					var drillDownQryStr = chartData.drillDownQryStr;
					var measureMap = chartData.measureMap;
					var mainColArray=new Array();
					var fieldsToStore=new Array();
					var count=0;
					for (var key in gridColHeader)
					{
						var subColArrJson=gridColHeader[key];
						var align = "left";
						if(key.indexOf('Wait Type') < 0)
						{
							align = "center";
						}
						var measureParam = measureMap[key];
						if (subColArrJson.length>0) 
						{
							var subColArray = new Array();
							for (var subKey in subColArrJson)
							{
								var subcol = subColArrJson[subKey];
								var dataind=count+'';
								fieldsToStore.push({name: dataind});
								subColArray.push({ 
									header: subcol,
									dataIndex: dataind,
									align:align,
									sortable:false,
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										return value;
									}
								});
								count++;
							}
							var graphIcon = '<img src="/final/images/clear.png" class="iconLineChart" onClick="javascript:loadUrlInDrillDown(\''+drillDownQryStr+measureParam+'\');"  style="cursor:pointer;display:inline-block;vertical-align:middle;margin-right:5px"/>';
							graphIcon = graphIcon + '<span>'+key+'</span>';
							mainColArray.push({ 
								header: graphIcon,
								dataIndex: key,
								width:200,
								align:align,
								columns:subColArray
							});
						}
						else
						{
							var index=count;
							fieldsToStore.push({name: count+''});
							var graphIcon = '<img src="/final/images/clear.png" class="iconLineChart" onClick="javascript:loadUrlInDrillDown(\''+drillDownQryStr+measureParam+'\');"  style="cursor:pointer;display:inline-block;vertical-align:middle;margin-right:5px"/>';
							if(key.indexOf('Wait Type') > -1)
							{
								graphIcon = key;
							}
							else
							{
								graphIcon = graphIcon + '<span>'+key+'</span>';
							}
							if(key.indexOf('Wait Type') < 0 && key.indexOf('Waiting Tasks') < 0)
							{
								graphIcon = graphIcon + "<br>"+"<span style='font-size:11px'>(AVG)</span>";
							}
							mainColArray.push({
								header: graphIcon,
								sortable: true,
								resizable :true,
								align:align,
								dataIndex: index,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
									return value;
								},
								doSort: function(state) 
								{
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											v1 = v1.get(field);
											v2 = v2.get(field);
											if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
												}
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								}
							});
							count++;
						}
					}
					fieldsToStore.push('app');
					var isPagingHidden=false;
					var gridPageSize=15;
					 if (tableDataAry!=undefined && tableDataAry.length<=gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data : tableDataAry,
						},
						pageSize:gridPageSize,
						remoteSort:true,
						autoLoad : true
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:1.0,
						title:gridTitle,
						margin:'0 2 0 0',
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:false,
							ui:'newGridPanel headerTextWrap',
							border:true,
							id:'grid_id',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							bodyStyle:{'border-bottom-width':'0px'},
							scroll:true,
							autoScroll:true,
							listeners:{
								render:function(obj){
									Ext.defer(function() {
										obj.columns[2].doSort("DESC");
									},100);
								}
							},
							dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: 
								{
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params))
											activePage = params.currentPage;
										else
											activePage=1;
									}
								}
							}]
						}]
					});
				}
				for(var q=0;q<2;q++)
				{
					var graphVar = 'graph'+q;
					var graph = resultJson.RESULTS[graphVar];
					var graphId = 'graphId'+q;
					var title = 'Blocked Process by Wait Type';
					var margin = '10 2 0 0'
					if(q==0)
					{
						title = 'Suspended Process by Wait Type';
						margin = '10 10 0 0';
					}
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:margin,
						height: 340,
						columnWidth:1/2,
						bodyPadding:'0 0 0 0',
						title:title,
						items:[
						{
							xtype:'container',
							columnWidth:1.0,
							id:graphId+'_GraphPanel',
							graphData:graph,
							graphId:graphId,
							html:'<div id="'+graphId+'" style="height:230px"></div>',
							listeners:
							{
								'boxready':function()
								{
									{
										var lineChart = {};
										lineChart = jQuery.extend(true, {}, getHighChartsInstance(this.graphId,230,330), lineChart);
										lineChart.setData(this.graphData,this.graphData.currentDateFormat,'');
										lineChart.drawChart();
									}
								}
							}
						},
						{
							xtype:'container',
							margin:'10 10 10 0',
							id:graphId+'_legendPanel',
							height:52,
							columnWidth:1.0,
							style: {
								'overflow': 'hidden',
								'padding-bottom':'20px',
							}
						}]
					});
				}
				var pieChartObj = resultJson.RESULTS.pieChartObj;
				var pieHtml = '';
				var dataSet = pieChartObj.DataSet;
				var pieTitle = resultJson.RESULTS.pieTitle;
				var data = dataSet[0].data;
				pieHtml+='<table height="100%" width="100%" border="0px" style="table-layout: fixed;"><tr><td valign="middle" style="vertical-align:middle" height="100%"><table cellspacing="0" cellpadding="0" valign="middle" width="100%"><tbody>';
				for(var index in data)
				{
					pieHtml+='<tr><td nowrap style="padding-top:2px;padding-right:0px;width:10px;vertical-align:top"><div style="background-color:'+data[index].color+';" class="legend"></div></td>';
					pieHtml+='<td nowrap class="font_normal11" style="text-overflow: ellipsis;width:40px;vertical-align:top">'+data[index].name+'</td>';
					pieHtml+='<td></td><td class="font_normal11" style="vertical-align:top;"><div id="pieLegendId" data-qtip="'+data[index].y+'" style="text-overflow: ellipsis; overflow:hidden;">'+data[index].y+'</div></td></tr>';
				}
				pieHtml+='</tbody></table></td></tr></table>';
				this.add({
					xtype:'panel',
					columnWidth:0.5,
					ui:'newGraphPanel',
					title:pieTitle,
					layout:{
						type:'hbox',
						align:'stretch',
					},
					margin:'10 10 0 0',
					height:350,
					items:[
					{
						xtype:'container',
						flex:0.55,
						layout:'fit',
						height:330,
						html:'<div id="pieChartWaits" style="height:300px;"> </div>',
						listeners:{
							'boxready':function(c){
								try
								{
									var pieChart = {};
									pieChart = jQuery.extend(true, {}, getHighChartsBarInstance('pieChartWaits',200,200), pieChart);
									pieChart.setData(pieChartObj,appConstants.currentDateFormat,'');
									pieChart.drawChart();
								}
								catch (e)
								{
									console.log(e);
								}
							},
						},
					},
					{
						xtype:'container',
						border:true,
						flex:.45,
						height:350,
						cls:'legendWithValue',
						style:{'top':'0px','left':'100px'},
						layout:{
							type:'fit',
							align:'center',
							pack:'center'
						},
						html:pieHtml
					}],
					
				});
				var mainColArray=new Array();
				var fieldsToStore=new Array();
				var tableData = resultJson.RESULTS.topTenData;
				var gridColumnAry = resultJson.RESULTS.gridColumnAry;
				var tableTitle = resultJson.RESULTS.topWaitTypeTitile;
				if(tableData != undefined && tableData.length > 0)
				{
					for (var key in gridColumnAry)
					{
						var align = 'left';
						var width=135;
						var headerCol = gridColumnAry[key];
						if(key == 2)
						{
							align = 'center';
							width=115;
						}
						if(key == 1)
						{
							width = 500;
						}
						fieldsToStore.push(key);
						var flexVal = 1;
						mainColArray.push({
							header: headerCol,
							sortable: true,
							resizable :true,
							align:align,
							//width:width,
							dataIndex: key,
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								var displayVal = value;
								var indexId = 'trace-mem-'+row;
								if(col == 1 && displayVal.length > 300)
								{
									displayVal = displayVal.substring(0,300)+'...&nbsp;<span style="text-decoration-line:underline;cursor:pointer;" onclick="javascript:expandMore(\''+appConstants.erUtils.specialCharEncode(displayVal)+'\',\'trace-mem-'+row+'\',\'more\',\'grid_top_ten\')">more</span>';
								}
								if(col == 0)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
								}
								if(col==1)
									value = '<div id="'+indexId+'" style="white-space: normal;word-wrap:break-word">'+displayVal+'</div>';
								else
									value = '<div style="white-space: normal;">'+displayVal+'</div>';
								return value;
							},
						});
					}
					var isPagingHidden=false;
					var gridPageSize=10;
					var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'json', root : 'data', totalProperty : 'total'
							},
							data : tableData,
						},
						pageSize:gridPageSize,
						autoLoad : true,
					});
					var activePage=1;
					this.add({
						xtype:'panel',
						ui:'newGraphPanel',
						columnWidth:0.5,
						title:tableTitle,
						margin:'10 2 10 0',
						height:350,
						autoScroll:true,
						items:[{
							xtype:'customgrid',
							store:storeObj,
							forceFit:true,
							needtoFixColumn:true,
							columnWidth:1.0,
							margin:'0 10 10 10',
							sortableColumns:false,
							ui:'newGridPanel',
							border:true,
							id:'grid_top_ten',
							columns:mainColArray,
							popUpData:false,
							style:
							{
								'box-shadow':'none !important',
							},
							bodyStyle:{'border-bottom-width':'0px'},
							scroll:true,
							autoScroll:true,
							listeners:{
								render:function(obj){
									Ext.defer(function() {
										obj.columns[2].doSort("DESC");
									},100);
								}
							},
						}]
					});
				}
				else
				{
					this.add({
						xtype:'panel',
						height:320,
						ui:'newGraphPanel',
						align:'center',
						title:tableTitle,
						margin:'10 2 10 0',
						columnWidth:1.0,
						html:'<div><table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/Light/nomeasures_custom.png"/></td></tr></table></div>',
					});
				}
				if(chartData.observationsAry != undefined && chartData.observationsAry.length > 0)
				{
					var observationsAry = chartData.observationsAry;
					var ObservationTitle = chartData.ObservationTitle;
					var observationHtml = '';
					observationHtml = '<div style="padding:11px 0px 10px 0px" class="font_bold15 newLineBottom">' + ObservationTitle +'</div><div style="margin:10px 0px 0px 0px; padding: 0 20px 0 0;" ><table  style="width: 100%;margin-bottom:0px; "><tbody>';
					for (var index = 0; index < observationsAry.length; index ++) 
					{
						var observationAryObj = observationsAry[index];
						observationHtml += '<tr style="padding-bottom:10px;">';
						if (observationAryObj != undefined) 
						{
							observationHtml += '<td width="50%" class="jvmHeaptable"><table><tr><td width="10px" style="vertical-align:top;padding-top:6px;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:1px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + observationAryObj + '</td></tr></table></td>';
						}
						observationHtml += '</tr>';
					}
					observationHtml += '</tbody></table></div></td>';
					this.add(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						padding:'0 0 0 0',
						columnWidth:1,
						margin:'0 2 0 0',
						items:[
						{
							xtype: 'container',
							padding: '0 10 0 10',
							margin: '10 10 10 10',
							cls: 'jvmObservPanelBox',
							columnWidth: 1.0,
							items: [
							{
								xtype: 'container',
								ui: 'newGraphPanel noShadow ',
								margin: '0 0 0 0',
								bodyPadding: '10px 0px 0px 10px',
								layout: 'column',
								items: [
								{
									xtype: 'container',
									columnWidth: 1.0,
									html:observationHtml
								}]
							}
							]
						}]
					});
				}
			}
			else
			{
				this.add(this.getNoMeasure(450,'iconInformation','There were no waits on the SQL database server.'));
			}
		}
		catch(e)
		{
			console.log(e);
		}
	},
	getNoMeasure:function(height,icon,msg)
	{
		return {
			xtype:'panel',
			columnWidth:1.0,
			height:height,
			margin:'0 2 0 0',
			ui:"newGraphPanel",
			flex:1,
			html:'<div class="egFlexCenterByColumnWise" style="padding-bottom:15px;height:100%"> <div class="'+icon+'"></div> <div class="commonErrorMsgText">'+msg+'</div> </div>'
		}
	}
});


