Ext.define("thinclientapplicationreports.controller.ThinclientApplicationReports", {
	extend: "Ext.app.Controller",
	gridColStateParam:'ASC',//deafult 1 for ascending
	gridColIndexParam:-1,//added for updating sort by option
	views: ["Main"],
	refs: [{
			selector: "main",
			ref: "main"
		},{
			selector: "newUtilities",
			ref: "newUtilities"
		},
		{
			selector: 'thinclientapplicationform',
			ref: 'thinclientapplicationform'
		},
		{
			selector: 'egcomponent',
			ref: 'egcomponent'
		},
		{
			selector: 'mainform',
			ref: 'mainform'
		},
		{
			selector: 'thinclientapplicationsettings',
			ref: 'thinclientapplicationsettings'
		},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'},
		{selector:'ReporterSettings', ref:'ReporterSettings'}],
	init: function() {
		this.control({
			"main": {
				"boxready": this.afterMainRender
			},
			"mainform": {
				"afterrender": this.loadFormElements
			},
			"thinclientapplicationsettings": {
				"afterrender": this.loadSettingsElements
			},
			"newUtilities": {
				"afterrender": this.loadTools
			},
			"newUtilities > #printTool > button": {
				"click": this.printReport
			},
			"newUtilities > #saveTool > button": {
				"click": this.saveReportAsPDF
			},
			"newUtilities > #mailTool > button": {
				"click": this.sendMail
			},
			"newUtilities > #csvTool > button": {
				"click": this.saveCsv
			},
			"newUtilities > #favoriteTool > button": {
				"click": this.saveFavorite
			},
			"newUtilities > #scheduleTool > button": {
				"click": this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
			 'select': this.changeEr_mode
			},
			'mainform combo[name="select_farm"]': {
				"select": this.zoneOnChange
			},
			'mainform combo[name="report_category"]': {
				"select": this.reportCatChange
			},
			'mainform combo[name="er_type"]': {
				"select": this.reportTypeOnChange
			},
			'mainform multiselect[name="er_server"]': {
				'change': this.serverOnChange
			},
			'mainform multiselect[name="er_server_graph"]': {
				'change': this.serverOnChange
			},
			'mainform button[id="expandAppln"]': {
				"click": this.expandAppln
			},
			'mainform combo[name="er_compType"]': {
				"select": this.compTypeOnChange
			},
			'mainform combo[name="er_workgrpname"]': {
				"select": this.workerGroupOnChange
			},
			/*'thinclientapplicationsettings combo[name="er_excwe"]': {
				"select": this.weekendOnChange
			}, */
			'thinclientapplicationsettings combo[name="reportGeneration"]': {
				"select": this.reportGenChange
			},
			'thinclientapplicationsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'thinclientapplicationsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},	
			'thinclientapplicationsettings textfield[name="exeAppTxtField"]': {
				"change": this.excludeAppChange
			},
			'mainform button[name="submit"]': {
				"click": this.showResult
			},
			'mainform button[name="save"]': {
				"click": this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform button[id="expandSelectorActivity"]': {
				"click": this.expandMeActivity
			},
			'mainform button[id="expandSelectorActivity_graph"]': {
				"click": this.expandMeActivity
			},
			'mainform button[id="expandSelectorUsage"]': {
				"click": this.expandMeUsage
			},
			'mainform trigger[id="compSearch"]':
			{
			'change': this.filterMultiselect
			},
			'mainform trigger[id="compSearch_graph"]':
			{
			'change': this.filterMultiselect
			},
			'mainform trigger[id="appSearch"]':
			{
			'change': this.filterMultiselect
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
		});
	},
	onSelectAnalysisBy: function (obj) {
		var er_option=obj.getValue();
		var params='er_option='+er_option+'&er_type='+Ext.getCmp('er_type').getValue();
		var urlstr='';

		if(targetType == 'Application Usage')
			{
				urlstr = "/final/reporter/ErAppUsageReportJson.jsp";
			}
		else
			{
				urlstr = "/final/reporter/ErCtxApplicationReportJson.jsp";
			}
		if(WVD_report)
		{
			params+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			params+="&onlyCompTpye="+onlyCompTpye;
		}
		 Ext.Ajax.request({
			url: urlstr,
			params: params,
			success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var component;
				if(targetType == 'Application Usage')
				{
					if (er_option=='Zone')
					{
						Ext.getCmp('er_site').hide();
						component=Ext.getCmp('select_farm');
						component.getStore().clearFilter(true); 
						component.getStore().loadRawData(jsonData.zoneCombo);
						component.setFieldLabel(screenLabels["reporter.consolidated.Zone"]);
						component.setValue(jsonData.selectedZone);
						component.show();
					}
					else if (er_option=='Component') 
					{
						Ext.getCmp('select_farm').hide();
						Ext.getCmp('er_site').hide();
					}
					else 
					{
						Ext.getCmp('select_farm').hide();
						component=Ext.getCmp('er_site');
						component.getStore().clearFilter(true); 
						component.getStore().loadRawData(jsonData.siteCombo);
						component.setFieldLabel(jsonData.siteComboLabel);
						component.setValue(jsonData.selectedSiteCombo);
						component.show();
					}
					component=Ext.getCmp('er_application_usage');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.applnCombo);
					component.setValue(jsonData.selectedAppln);
					component=Ext.getCmp('er_compType');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.compTypeCombo);
					component.setValue(jsonData.selectedCompType);
					component=Ext.getCmp('er_server');
					component.getStore().loadRawData(jsonData.componentCombo);
					component.setValue(jsonData.selectedComponents);
				}
				else
				{
					if (er_option=='Zone')
					{
						Ext.getCmp('er_site').hide();
						component=Ext.getCmp('select_farm');
						component.getStore().clearFilter(true); 
						component.getStore().loadRawData(jsonData.zoneCombo);
						component.setValue(jsonData.selectedZone);
						component.show();
					}
					else if (er_option=='Component') 
					{
						Ext.getCmp('select_farm').hide();
						Ext.getCmp('er_site').hide();
					}
					else 
					{
						Ext.getCmp('select_farm').hide();
						component=Ext.getCmp('er_site');
						component.getStore().clearFilter(true); 
						component.getStore().loadRawData(jsonData.siteCombo);
						component.setFieldLabel(jsonData.siteComboLabel);
						component.setValue(jsonData.selectedSiteCombo);
						component.show();
					}
				component=Ext.getCmp('er_compType');
				component.getStore().clearFilter(true); 
				component.getStore().loadRawData(jsonData.componentTypeCombo);
				component.setValue(jsonData.selectedComponentType);
				
				var er_type=Ext.getCmp('er_type').getValue();
				if (er_type=='Yes')
				{
					component=Ext.getCmp('select_testmes');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.measureCombo);
					component.setValue(jsonData.selectedMeasure);
					component.show();
					Ext.getCmp('egcomponent').hide();
					if(WVD_report)
					{
						Ext.getCmp('egservers').show();
						Ext.getCmp('wvdserver').show();
						comboRawData = jsonData.serverCombo;
						selectedComboOption = jsonData.selectedServer;
						comboObject = Ext.getCmp("er_server_graph");
						var objLabel = Ext.getCmp("multiSelectLabel_graph");
						objLabel.setText(jsonData.screenLabels["reporter.common.Server"]);
						var objTool = Ext.getCmp('expandSelectorActivity_graph');
						objTool.setTooltip('<b>'+jsonData.screenLabels["reporter.common.Server"]+'</b>');
						 appConstants.rawDataForComponents=comboRawData;
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						var component = Ext.getCmp("er_WVDserver");
						component.storeData = jsonData.WVDserverCombo;
						component.setValue(jsonData.selectedWVDserverUI);
						component.fieldValue = jsonData.selectedWVDserver;
					}
					else
					{
						Ext.getCmp('wvdserver').hide();
						Ext.getCmp('egservers').hide();
					}
 
				}
				else
				{
					Ext.getCmp('select_testmes').hide();
					component = Ext.getCmp("er_server");
					component.getStore().loadRawData(jsonData.serverCombo);
					component.setValue(jsonData.selectedServer);
					comboRawData = jsonData.serverCombo;
					appConstants.rawDataForComponents = comboRawData;
					component = Ext.getCmp("er_application");
					component.getStore().loadRawData(jsonData.applnCombo);
					component.setValue(jsonData.selectedAppln);
					Ext.getCmp('egcomponent').show();
					comboRawData = jsonData.applnCombo;
					appConstants.rawDataForApplication=comboRawData;

					if(WVD_report)
					{
						Ext.getCmp('wvdserver').show();
						component = Ext.getCmp("er_WVDserver");
						component.storeData = jsonData.WVDserverCombo;
						component.setValue(jsonData.selectedWVDserverUI);
						component.fieldValue = jsonData.selectedWVDserver;
					}
				}
				}
			}
		 });
	},
	er_siteOnChange: function (obj) {
		var er_site=obj.getValue();
		var params;
		var urlstr='';
		if(targetType == 'Application Usage')
		{
			urlstr = "/final/reporter/ErAppUsageReportJson.jsp";
			params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+encodeURIComponent(er_site);
		}
		else
		{
			urlstr = "/final/reporter/ErCtxApplicationReportJson.jsp";
			params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+encodeURIComponent(er_site)+'&er_type='+Ext.getCmp('er_type').getValue();
		}
		if(WVD_report)
		{
			params+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			params+="&onlyCompTpye="+onlyCompTpye;
		}
		 Ext.Ajax.request({
			url: urlstr,
			params: params,
			method: "GET",
			success: function(response) {
				var component;
				var jsonData=Ext.decode(response.responseText);
				if(targetType == 'Application Usage')
				{
					component=Ext.getCmp('er_compType');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.compTypeCombo);
					component.setValue(jsonData.selectedCompType);

					component=Ext.getCmp('er_application_usage');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.applnCombo);
					component.setValue(jsonData.selectedAppln);

					component=Ext.getCmp('er_server');
					component.getStore().loadRawData(jsonData.componentCombo);
					component.setValue(jsonData.selectedComponents);
				}
				else
				{
					component=Ext.getCmp('er_compType');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.componentTypeCombo);
					component.setValue(jsonData.selectedComponentType);
					var er_type=Ext.getCmp('er_type').getValue();
					if (er_type=='Yes')
					{
						component=Ext.getCmp('select_testmes');
						component.getStore().clearFilter(true); 
						component.getStore().loadRawData(jsonData.measureCombo);
						component.setValue(jsonData.selectedMeasure);
						component.show();
						Ext.getCmp('egcomponent').hide();
						if(WVD_report)
						{
							Ext.getCmp('egservers').show();
							Ext.getCmp('wvdserver').show();
							comboRawData = jsonData.serverCombo;
							selectedComboOption = jsonData.selectedServer;
							comboObject = Ext.getCmp("er_server_graph");
							var objLabel = Ext.getCmp("multiSelectLabel_graph");
							objLabel.setText(jsonData.screenLabels["reporter.common.Server"]);
							var objTool = Ext.getCmp('expandSelectorActivity_graph');
							objTool.setTooltip('<b>'+jsonData.screenLabels["reporter.common.Server"]+'</b>');
							 appConstants.rawDataForComponents=comboRawData;
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								comboObject.setValue(comboRawData[0].valueField);
							}
							var component = Ext.getCmp("er_WVDserver");
							component.storeData = jsonData.WVDserverCombo;
							component.setValue(jsonData.selectedWVDserverUI);
							component.fieldValue = jsonData.selectedWVDserver;
						}
						else
						{
							Ext.getCmp('wvdserver').hide();
							Ext.getCmp('egservers').hide();
						}
					}
					else
					{
						Ext.getCmp('select_testmes').hide();
						component = Ext.getCmp("er_server");
						component.getStore().loadRawData(jsonData.serverCombo);
						component.setValue(jsonData.selectedServer);
						component = Ext.getCmp("er_application");
						component.getStore().loadRawData(jsonData.applnCombo);
						component.setValue(jsonData.selectedAppln);
						Ext.getCmp('egcomponent').show();
						if(WVD_report)
						{
							Ext.getCmp('wvdserver').show();
							component = Ext.getCmp("er_WVDserver");
							component.storeData = jsonData.WVDserverCombo;
							component.setValue(jsonData.selectedWVDserverUI);
							component.fieldValue = jsonData.selectedWVDserver;
						}
					}
				}
			}
		});
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var compId = obj.getId();
		if(compId=='compSearch')
		{
			compStore = appConstants.rawDataForComponents;
			compName='er_server';
		}
		else if(compId=='compSearch_graph')
		{
			compStore = appConstants.rawDataForComponents;
			compName='er_server_graph';
		}else if(compId=='appSearch')
		{
			compStore = appConstants.rawDataForApplication;
			compName='er_application';
		}
		obj.toggleTriggger();
	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
	},
	changeEr_mode: function (combo) {
		var from_schModify='';
		var favorite_id='';
		if(targetType == 'Application Usage')
		{
			favorite_id=appConstants.publicjsonDataUsage['hiddenfields']["favorite_id"];
			from_schModify=appConstants.publicjsonDataUsage['hiddenfields']["fromScheduleModify"];
		}
		else
		{
			favorite_id=appConstants.publicjsonDataActivity['hiddenfields']["favorite_id"];
			from_schModify=appConstants.publicjsonDataActivity['hiddenfields']["fromScheduleModify"];
		}
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
			duration: 250,
			to: {
				y: -530
			}
		});
		this.showResult();
	 },
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  '';
		if(targetType == 'Application Usage'){
			hiddenFields=appConstants.publicjsonDataUsage['hiddenfields'];
		}else{
			hiddenFields=appConstants.publicjsonDataActivity['hiddenfields'];
		}
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			this.saveFavorite();
		}
	},
	workerGroupOnChange: function() {
		Ext.getCmp("resultPanel").hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var Qstring = "&er_zone=" + mainForm.findField("select_farm").getValue() + "&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_workgrpname=" + mainForm.findField("er_workgrpname").getValue();
		if(WVD_report)
		{
			Qstring+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			Qstring+="&onlyCompTpye="+onlyCompTpye;
		}
		Ext.Ajax.request({
			url: "/final/reporter/ErAppUsageReportJson.jsp",
			params: Qstring,
			scope: this,
			method: "GET",
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;

				comboRawData = appConstants.publicjsonDataUsage.componentCombo;
				selectedComboOption = appConstants.publicjsonDataUsage.selectedComponents;
				comboObject = Ext.getCmp("er_server");
				appConstants.rawDataForComponents = comboRawData;
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject.resumeEvents();
				comboRawData = appConstants.publicjsonDataUsage.applnCombo;
				selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
				comboObject = mainForm.findField("er_application_usage");
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
			}
		});
	},
	compTypeOnChange: function() {
		Ext.getCmp("resultPanel").hide();
		var url;
		var report_category = Ext.getCmp("report_category").getValue();        
		var er_option=Ext.getCmp('er_option').getValue();
		var params='er_option='+er_option+'&er_compType='+Ext.getCmp('er_compType').getValue();
		var mainForm =Ext.getCmp('mainform').getForm();
		if(targetType == 'Application Usage')
		{
			var zoneval=mainForm.findField("select_farm").getValue();
			if (er_option=='Zone')
			{
				params+="&er_zone="+encodeURIComponent(zoneval);
			}
			else
			{
				params+="&er_site="+encodeURIComponent(Ext.getCmp("er_site").getValue());
			}
		}
		else
		{
			if (er_option=='Zone')
			{
				params+="&select_farm=" + encodeURIComponent(Ext.getCmp("select_farm").getValue());
			}
			else
			{
				params+="&er_site="+encodeURIComponent(Ext.getCmp("er_site").getValue());
			}
		}
		if (report_category == "application_usage")
		{
			url = "/final/reporter/ErAppUsageReportJson.jsp";
		}
		else 
		{
			url = "/final/reporter/ErCtxApplicationReportJson.jsp";
			params+='&er_type='+Ext.getCmp('er_type').getValue();
		}
		if(WVD_report)
		{
			params+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			params+="&onlyCompTpye="+onlyCompTpye;
		}
	   Ext.Ajax.request({
			url: url,
			params: params,
			scope: this,
			method: "GET",
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				if (report_category == "application_usage")
				{
					var component;
					component=Ext.getCmp('er_server');
					component.getStore().loadRawData(jsonData.componentCombo);
					component.setValue(jsonData.selectedComponents);
					if (appConstants.publicjsonDataUsage.hasOwnProperty('workerGroupCombo'))
					{
						comboRawData = appConstants.publicjsonDataUsage.workerGroupCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedWorkergroup;
						comboObject = mainForm.findField("er_workgrpname");
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.resumeEvents();
						comboObject.show();
					}
					else
					{
						comboObject = mainForm.findField("er_workgrpname");
						comboObject.hide();
					}
					comboRawData = appConstants.publicjsonDataUsage.componentCombo;
					selectedComboOption = appConstants.publicjsonDataUsage.selectedComponents;
					comboObject = Ext.getCmp("er_server");
					appConstants.rawDataForComponents = comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.resumeEvents();
					comboRawData = appConstants.publicjsonDataUsage.applnCombo;
					selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
					comboObject = mainForm.findField("er_application_usage");
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				else
				{
					if (mainForm.findField("er_type").getValue() == "No")
					{
						if (appConstants.publicjsonDataUsage.hasOwnProperty('workerGroupCombo'))
						{
							comboRawData = appConstants.publicjsonDataUsage.workerGroupCombo;
							selectedComboOption = appConstants.publicjsonDataUsage.selectedWorkergroup;
							comboObject = mainForm.findField("er_workgrpname");
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								comboObject.setValue(comboRawData[0].valueField);
							}
							comboObject.resumeEvents();
							comboObject.show();
						}
						else
						{
							comboObject = mainForm.findField("er_workgrpname");
							comboObject.hide();
						}
						comboRawData = appConstants.publicjsonDataUsage.serverCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedServer;
						comboObject = Ext.getCmp("er_server");
						comboObject.getStore().loadRawData(comboRawData);
						appConstants.rawDataForComponents = comboRawData;
						 if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}

						comboRawData = appConstants.publicjsonDataUsage.applnCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
						comboObject = Ext.getCmp("er_application");
						appConstants.rawDataForApplication=comboRawData;
						comboObject.getStore().loadRawData(comboRawData);
						var appLabel = Ext.getCmp('appLabel');
						appLabel.setText(jsonData.screenLabels['reporter.thin.Application']);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
					}
					else
					{
						if (appConstants.publicjsonDataUsage.hasOwnProperty('workerGroupCombo'))
						{
							comboRawData = appConstants.publicjsonDataUsage.workerGroupCombo;
							selectedComboOption = appConstants.publicjsonDataUsage.selectedWorkergroup;
							comboObject = mainForm.findField("er_workgrpname");
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								comboObject.setValue(comboRawData[0].valueField);
							}
							comboObject.resumeEvents();
							comboObject.show();
						}
						else
						{
							comboObject = mainForm.findField("er_workgrpname");
							comboObject.hide();
						}

						comboRawData = appConstants.publicjsonDataUsage.measureCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedMeasure;
						comboObject = mainForm.findField("select_testmes");
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
					}
				}
			}
		});
	},
	zoneOnChange: function() {
		Ext.getCmp("resultPanel").hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var report_category = mainForm.findField("report_category").getValue();
		var url;
		var zoneval=mainForm.findField("select_farm").getValue();
		var er_optionVal=mainForm.findField("er_option").getValue();
		if(zoneval!='-1')
		{
			if (report_category == "application_usage") {
				url = "/final/reporter/ErAppUsageReportJson.jsp?er_zone="+encodeURIComponent(zoneval);
			} else {
				if (mainForm.findField("er_type").getValue() != null) {
					url = "/final/reporter/ErCtxApplicationReportJson.jsp?select_farm=" + encodeURIComponent(zoneval) + "&er_type=" + mainForm.findField("er_type").getValue()+"&er_option="+er_optionVal;
				} else {
					return;
				}
			}
			if(WVD_report)
			{
				url+="&WVD_reports=yes";
			}
			if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
			{
				url+="&onlyCompTpye="+onlyCompTpye;
			}
			Ext.Ajax.request({
				url: url,
				scope: this,
				method: "GET",
				success: function(response) {
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicjsonDataUsage=jsonData;
					var globalScreenLabel = appConstants.publicjsonDataUsage.screenLabels;
					if (report_category == "application_usage") 
					{
						comboRawData = appConstants.publicjsonDataUsage.compTypeCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedCompType;
						comboObject = mainForm.findField("er_compType");
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboRawData = appConstants.publicjsonDataUsage.componentCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedComponents;
						comboObject = Ext.getCmp("er_server");
						appConstants.rawDataForComponents = comboRawData;
						comboObject.getStore().loadRawData(comboRawData);

						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboRawData = appConstants.publicjsonDataUsage.applnCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
						comboObject = mainForm.findField("er_application_usage");
						appConstants.rawDataForApplication=comboRawData;
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
					} else {
				comboRawData = appConstants.publicjsonDataUsage.componentTypeCombo;
				selectedComboOption = appConstants.publicjsonDataUsage.selectedComponentType;
				comboObject = mainForm.findField("er_compType");
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
				var component;
				component=Ext.getCmp('select_testmes');
				comboObject.getStore().clearFilter(true); 
				component.getStore().loadRawData(jsonData.measureCombo);
				component.setValue(jsonData.selectedMeasure);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				var rtype=mainForm.findField('er_type').getValue();
				if(rtype == 'No'){
					comboRawData = appConstants.publicjsonDataUsage.serverCombo;
					selectedComboOption = appConstants.publicjsonDataUsage.selectedServer;
					comboObject = Ext.getCmp("er_server");
					var objLabel = Ext.getCmp("multiSelectLabel");
					objLabel.setText(globalScreenLabel["reporter.common.Server"]);
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					 comboRawData = appConstants.publicjsonDataUsage.applnCombo;
					 selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
					comboObject = Ext.getCmp("er_application");
					appConstants.rawDataForApplication=comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					var appLabel = Ext.getCmp('appLabel');
					appLabel.setText(jsonData.screenLabels['reporter.thin.Application']);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				else
				{
					if(WVD_report)
					{
						var comboRawDatas = appConstants.publicjsonDataUsage.serverCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedServer;
						comboObject = Ext.getCmp("er_server_graph");
						var objLabel = Ext.getCmp("multiSelectLabel_graph");
						objLabel.setText(globalScreenLabel["reporter.common.Server"]);
						comboObject.getStore().loadRawData(comboRawDatas);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawDatas[0].valueField);
						}
					}
				}
				if(WVD_report)
				{
					Ext.getCmp('wvdserver').show();
					component = Ext.getCmp("er_WVDserver");
					component.storeData = jsonData.WVDserverCombo;
					component.setValue(jsonData.selectedWVDserverUI);
					component.fieldValue = jsonData.selectedWVDserver;
				}
				}
				}
			});
		}
	}, 
	serverOnChange: function(obj, newValue, oldValue, eOpts) {
		if (Ext.isEmpty(newValue))
		{
			return;
		}
	var mainForm =Ext.getCmp('mainform').getForm();
	// for single server selection-hide the accoss server
	var compArr;
	if(Ext.getCmp('egservers').isVisible())
		compArr = Ext.getCmp("er_server_graph").getValue();
	else
		compArr = Ext.getCmp("er_server").getValue();
	var erType = mainForm.findField("er_type").getValue();
	if(targetType != 'Application Usage')
	{
		if(erType == null || erType==undefined)
		return;
	}
	if(WVD_report && mainForm.findField("er_type").getValue()!='Yes')
	{
		var ddTxtValueStr=Ext.getCmp('er_WVDserver').fieldValue;
		if(ddTxtValueStr!=undefined)
		{
			compArr = ddTxtValueStr.split(',');
		}
	}
	if(compArr==null || compArr=='' || compArr.length==0)
		return;
	else {
		if(compArr ==undefined || compArr=="-1" || compArr.indexOf("All")>-1 || compArr.indexOf("all")>-1 || compArr.length>1) {
			if(Ext.getCmp("er_perserver")!=undefined)
				Ext.getCmp("er_perserver").show();
		}else{
			if(Ext.getCmp("er_perserver")!=undefined)
				Ext.getCmp("er_perserver").hide();
		}
	 }
		var zoneval=mainForm.findField("select_farm").getValue();
		var er_site=mainForm.findField("er_site").getValue();
		var er_option=mainForm.findField("er_option").getValue();
		var urlstr="/final/reporter/ErAppUsageReportJson.jsp?er_compType="+Ext.getCmp('er_compType').getValue()+"&er_server="+Ext.getCmp('er_server').getValue();
		if(targetType == 'Application Usage')
		{
			this.updateQStringUsage();
			if(er_option=='Zone')
			{
				urlstr+="&er_zone=" +zoneval;
			}
			else if(er_option=='Group' || er_option=='Segment' || er_option=='Service')
			{
				urlstr+='&er_site='+er_site;
			}
			else if (er_option=='Component')
			{
				urlstr+='&er_option='+er_option;
			}
		}
		else{
			this.updateQStringActivity();
			 urlstr = "/final/reporter/ErCtxApplicationReportJson.jsp?select_farm=" + Ext.getCmp("select_farm").getValue() + "&er_type=" + Ext.getCmp("er_type").getValue() + "&er_server=" + compArr;
		}
		if(WVD_report)
		{
			urlstr+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			urlstr+="&onlyCompTpye="+onlyCompTpye;
		}
		Ext.Ajax.request({
			url: urlstr,
			params: appConstants.queryStringActivity,
			scope: this, 
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var component;
				if(targetType == 'Application Usage')
				{
					component=Ext.getCmp('er_application_usage');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.applnCombo);
					component.setValue(jsonData.selectedAppln);
				}
				else if(erType!='Yes')
				{
					var comboRawData = jsonData.applnCombo;
					selectedComboOption = jsonData.selectedAppln;
					comboObject = Ext.getCmp("er_application");
					appConstants.rawDataForApplication=comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
						}
				}
				if(WVD_report)
				{
					Ext.getCmp('wvdserver').show();
					component = Ext.getCmp("er_WVDserver");
					component.storeData = jsonData.WVDserverCombo;
					component.setValue(jsonData.selectedWVDserverUI);
					component.fieldValue = jsonData.selectedWVDserver;
					console.log('jsonData.selectedWVDserver  ',jsonData.selectedWVDserver);
					if(WVD_report && mainForm.findField("er_type").getValue()!='Yes')
					{
						if(jsonData.selectedWVDserver !=undefined &&  jsonData.selectedWVDserver.length>1 && (jsonData.selectedWVDserver.indexOf("All")>-1 || jsonData.selectedWVDserver.indexOf("all")>-1 )) {
							if(Ext.getCmp("er_perserver")!=undefined)
								Ext.getCmp("er_perserver").show();
						}else{
							if(Ext.getCmp("er_perserver")!=undefined)
								Ext.getCmp("er_perserver").hide();
						}
					}
				}
			}
		});
	},
	reportTypeOnChange: function() {
		Ext.getCmp("resultPanel").hide();
		this.getNomeasurepanel().hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var report_type = mainForm.findField("er_type").getValue();
		var url = "/final/reporter/ErCtxApplicationReportJson.jsp?&er_type=" + mainForm.findField("er_type").getValue() + "&er_compType=" + mainForm.findField("er_compType").getValue()+"&er_trgttype="+targetType;
		var er_option=mainForm.findField("er_option").getValue();
		url+="&er_option=" + er_option;
		if (er_option=='Zone')
		{
			url+="&select_farm=" + mainForm.findField("select_farm").getValue();
		}
		else
		{
			url+="&er_site=" + mainForm.findField("er_site").getValue();
		}
		if(WVD_report)
		{
			url+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			url+="&onlyCompTpye="+onlyCompTpye;
		}
		Ext.Ajax.request({
			url: url,
			scope: this,
			method: "GET",
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels = jsonData.screenLabels;
				appConstants.publicjsonDataActivity = jsonData;
				if (report_type == "No") {
					 mainForm.findField("select_testmes").hide();
					mainForm.findField("er_mode").hide();
					if (jsonData.hasOwnProperty('componentTypeCombo'))
					{
						comboRawData = jsonData.componentTypeCombo;
						selectedComboOption = jsonData.selectedComponentType;

						comboObject = mainForm.findField("er_compType");
						comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					if (jsonData.hasOwnProperty('workerGroupCombo'))
					{
						comboRawData = jsonData.workerGroupCombo;
						selectedComboOption = jsonData.selectedWorkergroup;
						comboObject = mainForm.findField("er_workgrpname");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Worker Group"]);
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					else
					{
						mainForm.findField("er_workgrpname").hide();
					}
					comboRawData = jsonData.serverCombo;
					selectedComboOption = jsonData.selectedServer;
					comboObject = Ext.getCmp("er_server");
					var objLabel = Ext.getCmp("multiSelectLabel");
					objLabel.setText(screenLabels["reporter.common.Server"]);
					var objTool = Ext.getCmp('expandSelectorActivity');
					objTool.setTooltip('<b>'+screenLabels["reporter.common.Server"]+'</b>');
					 appConstants.rawDataForComponents=comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					if(WVD_report && mainForm.findField("er_type").getValue()!='Yes')
					{
						var ddTxtValueStr=jsonData.selectedWVDserver;
						if(ddTxtValueStr!=undefined)
						{
							selectedComboOption = ddTxtValueStr.split(',');
						}
					}
					if(selectedComboOption!=null && selectedComboOption!=undefined)
					{
						if (selectedComboOption.indexOf("All") > -1 || selectedComboOption.indexOf("all") > -1 ||selectedComboOption.length > 1) {
							if(Ext.getCmp("er_perserver")!=undefined)
								Ext.getCmp("er_perserver").show();
						}
					}
					comboRawData = jsonData.applnCombo;
					selectedComboOption = jsonData.selectedAppln;
					comboObject = Ext.getCmp("er_application");
					comboObject.setValue(jsonData.selectedAppln);
					appConstants.rawDataForApplication=comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					var appLabel = Ext.getCmp('appLabel');
					appLabel.setText(screenLabels['reporter.thin.Application']);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
					 Ext.getCmp("egcomponent").show();
				
					var sortCombo=Ext.getCmp('sort_by');
					if ( !Ext.isEmpty(sortCombo) )
					{
						sortCombo.show();
					}
					if(WVD_report)
					{
						Ext.getCmp('wvdserver').show();
						var component = Ext.getCmp("er_WVDserver");
						component.storeData = jsonData.WVDserverCombo;
						component.setValue(jsonData.selectedWVDserverUI);
						component.fieldValue = jsonData.selectedWVDserver;
						Ext.getCmp('egservers').hide();
					}
				
				 } 
				else 
				{
					var sortCombo=Ext.getCmp('sort_by');
					if ( !Ext.isEmpty(sortCombo) )
						sortCombo.hide();
					
					 if (jsonData.hasOwnProperty('componentTypeCombo'))
					{
						comboRawData = jsonData.componentTypeCombo;
						selectedComboOption = jsonData.selectedComponentType;
						comboObject = mainForm.findField("er_compType");
						comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					if (jsonData.hasOwnProperty('workerGroupCombo'))
					{
						comboRawData = jsonData.workerGroupCombo;
						selectedComboOption = jsonData.selectedWorkergroup;
						comboObject = mainForm.findField("er_workgrpname");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Worker Group"]);
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					else
					{
						mainForm.findField("er_workgrpname").hide();
					}
					// for graph measure load via reports by segemnts data to graph
					var component=Ext.getCmp('select_testmes');
					component.getStore().clearFilter(true);
					component.getStore().loadRawData(jsonData.measureCombo);
					component.setValue(jsonData.selectedMeasure);
					Ext.getCmp("egcomponent").hide();
					if(WVD_report)
					{
						Ext.getCmp('egservers').show();
						Ext.getCmp('wvdserver').show();
						comboRawData = jsonData.serverCombo;
						selectedComboOption = jsonData.selectedServer;
						comboObject = Ext.getCmp("er_server_graph");
						var objLabel = Ext.getCmp("multiSelectLabel_graph");
						objLabel.setText(screenLabels["reporter.common.Server"]);
						var objTool = Ext.getCmp('expandSelectorActivity_graph');
						objTool.setTooltip('<b>'+screenLabels["reporter.common.Server"]+'</b>');
						 appConstants.rawDataForComponents=comboRawData;
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						var component = Ext.getCmp("er_WVDserver");
						component.storeData = jsonData.WVDserverCombo;
						component.setValue(jsonData.selectedWVDserverUI);
						component.fieldValue = jsonData.selectedWVDserver;
					}
					else
					{
						Ext.getCmp('wvdserver').hide();
						Ext.getCmp('egservers').hide();
					}
					if(Ext.getCmp("er_perserver")!=undefined)
					 Ext.getCmp("er_perserver").hide();
						mainForm.findField("er_mode").hide();
					mainForm.findField("select_testmes").show();
				}
				if (isSettingsEnabled)
				{
					var reportGenCombo=jsonData.reportGenerationCombo;
					var selreportGeneration=jsonData.reportGeneration;
					var reportGen=Ext.getCmp('reportGeneration');
					reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
					reportGen.getStore().loadRawData(reportGenCombo);
					reportGen.setValue(selreportGeneration);
					var reportNameObj = Ext.getCmp('bgReportName');
					if(selreportGeneration!=undefined && selreportGeneration!=null && selreportGeneration=='foreground')
					{
						reportNameObj.hide();
					}
					else
					{
						reportNameObj.show();
					}
				}
			}
		});
	 },

   reportCatChange: function(b) {
		Ext.getCmp("resultPanel").hide();
		var report_category = Ext.getCmp("report_category").getValue();
		if (report_category == "application_usage") {
			this.LoadFieldsForUsage();
		} else {
			this.LoadFieldsForActivity();
		}
	},

	LoadFieldsForActivity: function() {
		var url = "/final/reporter/ErCtxApplicationReportJson.jsp?";
		if(WVD_report)
		{
			url+="WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			url+="&onlyCompTpye="+onlyCompTpye;
		}
		var mainForm =Ext.getCmp('mainform').getForm();
		Ext.Ajax.request({
			url: url,
			scope: this,
			method: "POST",
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity = jsonData;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForActivity(jsonData);
				mainForm.findField("er_type").show();
				mainForm.findField("select_testmes").show();
				mainForm.findField("er_mode").show();
				if(Ext.getCmp("er_excwe")!=undefined)
					Ext.getCmp("er_excwe").show();
				mainForm.findField("er_type").setValue("Yes");

				mainForm.findField("er_compType").show();
				if (jsonData.hasOwnProperty('workerGroupCombo'))
				{
					mainForm.findField("er_workgrpname").show();
				}
				else
				{
					mainForm.findField("er_workgrpname").hide();
				}
				mainForm.findField("componentMultiSelect").hide();
				Ext.getCmp("er_application").hide();
			 }
		});
	},
	LoadFieldsForUsage: function() {
		var url = "/final/reporter/ErAppUsageReportJson.jsp?";
		if(WVD_report)
		{
			url+="WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			url+="&onlyCompTpye="+onlyCompTpye;
		}
		Ext.Ajax.request({
			url: url,
			scope: this,
			method: "POST",
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage = jsonData;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForUsage(jsonData);
			}
		});
	},
	fillFormFieldsForUsage: function(jsonData) {
		var mainForm =Ext.getCmp('mainform').getForm();
			mainForm.findField("er_type").hide();
			mainForm.findField("select_testmes").hide();
			mainForm.findField("er_mode").hide();
		if(Ext.getCmp("sh_timeinuse")!=undefined)
			Ext.getCmp("sh_timeinuse").hide();
		if(Ext.getCmp("er_perserver")!=undefined)
			Ext.getCmp("er_perserver").hide();
		if(Ext.getCmp("er_excwe")!=undefined)
			Ext.getCmp("er_excwe").hide();
		Ext.getCmp("egcomponent").show();
		Ext.getCmp("er_server").show();
		mainForm.findField("er_compType").show();
		mainForm.findField("er_workgrpname").show();
		mainForm.findField("er_application_usage").show();
		var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		} else {
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var screenLabels = jsonData.screenLabels;
		comboRawData = jsonData.viewApplnCombo;
		selectedComboOption = jsonData.selectedViewAppln;
		comboObject = mainForm.findField("report_category");
		comboObject.setFieldLabel(screenLabels["reporter.common.View Application"]);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		var selectedAnalysisByCombo='';
		if (jsonData.hasOwnProperty('selectedAnalysisByCombo'))
		{
			selectedAnalysisByCombo=jsonData.selectedAnalysisByCombo;
		}
		if(selectedAnalysisByCombo=='Zone' || Ext.isEmpty(selectedAnalysisByCombo))
		{
			Ext.getCmp('er_site').hide();
			comboRawData = jsonData.zoneCombo;
			selectedComboOption = jsonData.selectedZone;
			comboObject = mainForm.findField("select_farm");
			comboObject.setFieldLabel(screenLabels["reporter.common.Zone"]);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		}
		else if(selectedAnalysisByCombo=='Segment')
		{
			Ext.getCmp('select_farm').hide();
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Segment');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) 
			{
				comboObject.setValue(selectedComboOption);
			} 
			else 
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Group')
		{
			Ext.getCmp('select_farm').hide();
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Group');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) 
			{
				comboObject.setValue(selectedComboOption);
			} 
			else 
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
			}
			else if(selectedAnalysisByCombo=='Service')
			{
				Ext.getCmp('select_farm').hide();
				comboRawData = jsonData.siteCombo;
				selectedComboOption = jsonData.selectedSiteCombo;
				comboObject = mainForm.findField("er_site");
				comboObject.setFieldLabel('Service');
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
			comboObject.show();
			}
			else if(selectedAnalysisByCombo=='Component')
			{
				Ext.getCmp('select_farm').hide();
				Ext.getCmp('er_site').hide();
			}
		comboRawData = jsonData.compTypeCombo;
		selectedComboOption = jsonData.selectedCompType;
		comboObject = mainForm.findField("er_compType");
		comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		if (jsonData.hasOwnProperty('workerGroupCombo'))
		{
			comboRawData = jsonData.workerGroupCombo;
			selectedComboOption = jsonData.selectedWorkergroup;
			comboObject = mainForm.findField("er_workgrpname");
			comboObject.setFieldLabel(screenLabels["reporter.thin.Worker Group"]);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		else
		{
			mainForm.findField("er_workgrpname").hide();
		}
		comboRawData = jsonData.componentCombo;
		selectedComboOption = jsonData.selectedComponents;
		comboObject = Ext.getCmp("er_server");
		Ext.getCmp("egcomponent").show();
		comboObject.getStore().loadRawData(comboRawData);
		appConstants.rawDataForComponents = comboRawData;
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.applnCombo;
		selectedComboOption = jsonData.selectedAppln;
		comboObject = mainForm.findField("er_application_usage");
		 comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		if(WVD_report)
		{
			Ext.getCmp('wvdserver').show();
			var component = Ext.getCmp("er_WVDserver");
			component.storeData = jsonData.WVDserverCombo;
			component.setValue(jsonData.selectedWVDserverUI);
			component.fieldValue = jsonData.selectedWVDserver;
		}
		else
		{
			Ext.getCmp('wvdserver').hide();
		}
	 },
	saveReportAsPDF:function(){
		var saveQString;
		var report_cat = Ext.getCmp('report_category').getValue();
		if(report_cat == 'application_usage'){
			saveQString=appConstants.publicjsonDataUsage.saveQString;
			saveQString+="&pageWidthProces=1024&er_option=graph&pdfPrint=yes";
		}
		else{
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&pageWidthProces=1024&er_view=PRINT";
		}
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString+"&isPdf=yes";
		var islegendEnabled = false;
		if(Ext.getCmp('showLegend')!=undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(s_qryString.indexOf(setLegendVal)==-1){
					if(s_qryString.indexOf("&showLegend=")>-1){
						if(islegendEnabled.toString() =='true'){
							s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
						}else{
							s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
						}
					}else
						s_qryString+=setLegendVal;
				}
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		  s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString;
		var report_cat = Ext.getCmp('report_category').getValue();
		if(report_cat == 'application_usage'){
			saveQString=appConstants.publicjsonDataUsage.saveQString;
			saveQString+="&pageWidthProces=1024&er_option=graph&pdfPrint=yes";
		}
		else{
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&pageWidthProces=1024&er_view=PRINT";
		}
		var s_qryString = saveQString+"&isPdf=yes";
		var islegendEnabled = false;
		if(Ext.getCmp('showLegend')!=undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(s_qryString.indexOf(setLegendVal)==-1){
					if(s_qryString.indexOf("&showLegend=")>-1){
						if(islegendEnabled.toString() =='true'){
							s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
						}else{
							s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
						}
					}else
						s_qryString+=setLegendVal;
				}
			}
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var mainForm =Ext.getCmp('mainform').getForm();
		var report_cat = Ext.getCmp('report_category').getValue();
		if(report_cat == 'application_activity'){
			this.updateQStringActivity();
			var rtype=mainForm.findField('er_type').getValue();
			if(rtype == 'Yes'){
				bookletquery=appConstants.queryStringActivity;
				bookletquery+="&er_server=-1&er_application=-1&er_sortby=-1&er_perserver=Yes&showTopusers="+appConstants.publicjsonDataActivity.showTopusers;
			}
			else{
				bookletquery=appConstants.queryStringActivity+"&showTopusers="+appConstants.publicjsonDataActivity.showTopusers;
			}
		}
		else if(report_cat == 'application_usage'){
			this.updateQStringUsage();
			bookletquery=appConstants.queryStringUsage;
		}
		bookletquery = bookletquery+"&isPdf=yes";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);
			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		var sortState='1';
		if (this.gridColStateParam=='ASC')
			sortState='1';
		else
			sortState='0';
		return query+'&orderBy='+sortState;
	},
	printReport:function(){
		var report_cat = Ext.getCmp('report_category').getValue();
		var s_qryString;
		if(report_cat == 'application_usage')
		{
			var saveQString=appConstants.publicjsonDataUsage.saveQString;
			s_qryString = "/final/reporter/ErAppUsageReportPrint.jsp?"+saveQString+"&pdfPrint=yes&isChartRequest=true&er_width=450&er_height=250&er_option=graph";
		}
		else{
			var saveQString=appConstants.publicjsonDataActivity.saveQString;
			s_qryString = "../servlet/com.eg.ErCtxServerReportC?"+saveQString
				+"printGraph=yes&pdfPrint=yes";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				s_qryString+="&er_view=PRINT";
		}
		var islegendEnabled = false;
		if(Ext.getCmp('showLegend')!=undefined){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined')
		{
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled.toString() =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
					
				}else
					s_qryString+=setLegendVal;
			}
		}
		  s_qryString=this.getGridColSortParam(s_qryString);
		}
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(){
		var mainForm =Ext.getCmp('mainform').getForm();
		var report_cat = mainForm.findField('report_category').getValue();
		var isValid = this.validateMainForm(false);
		if( isValid && mainForm.findField('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		if(isValid){
			var s_qryString;
			if(report_cat == 'application_activity'){
				this.updateQStringActivity();
				var rtype=mainForm.findField('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
					s_qryString+="&er_server=-1&er_application=-1&er_sortby=-1&er_perserver=Yes&showTopusers="+appConstants.publicjsonDataActivity.showTopusers;
				}
				else{
					s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity+"&showTopusers="+appConstants.publicjsonDataActivity.showTopusers;
				}
			}
			else if(report_cat == 'application_usage'){
				this.updateQStringUsage();
				s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringUsage;
			}
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
		if (appConstants.formButtonId=='save')
		{
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return
	},
	saveFavorite:function(){
		var isValid = this.validateMainForm(false);
		var mainForm =Ext.getCmp('mainform').getForm();
		/* if(isValid && mainForm.findField('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid=false;
		} */
		if(isValid)
		{
			var s_qryString;
			var report_cat = mainForm.findField('report_category').getValue();
			if(report_cat == 'application_activity'){
				this.updateQStringActivity();
				var rtype=mainForm.findField('er_type').getValue();
				if(rtype == 'Yes'){
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&er_perserver=yes&er_sortby=-1&er_server=-1&er_application=-1&cmd=client";
				}
				else{
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
				}
			}
			else if(report_cat == 'application_usage'){
				this.updateQStringUsage();
				var hiddenFields = appConstants.publicjsonDataUsage['hiddenfields'];
				var favorite_id = hiddenFields["favorite_id"];
				s_qryString="../servlet/com.eg.ErFavoriteC?"+appConstants.queryStringUsage+"&er_view=GRAPH&cmd=client";//&FavoriteId="+favorite_id;
			}

			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				if((favorite_id=="null" ||  favorite_id=="undefined" || favorite_id==undefined) && appConstants.favorite_id!="null")
					favorite_id=appConstants.favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return;
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
			var reportType=mainForm.findField('er_type').getValue();
			var reporFor=mainForm.findField('report_category').getValue();
		if(reporFor == 'application_activity'){
			if(reportType == 'No'){
				var server=mainForm.findField('er_server');
				var application=mainForm.findField('er_application');
				if( server.getValue() == '-1'){
					Ext.MessageBox.show({
					title: appConstants.er_RmDispName,
					msg: server.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				var applicationDisplayField=application.getStore().getAt(0).get('displayField');
				if( applicationDisplayField=='Not Applicable'){
					Ext.MessageBox.show({
						title: appConstants.er_RmDispName,
						msg: applicationDisplayField,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}else{
			var er_measure=mainForm.findField('select_testmes');
			if(er_measure.getValue()=='-1'){
					Ext.MessageBox.show({
						title:appConstants.er_RmDispName,
						msg:er_measure.getStore().getAt(0).get('displayField'),
						buttons:Ext.MessageBox.OK,
						icon:Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		}
		else
		{
				var compType=mainForm.findField('er_compType');
				var component=mainForm.findField('er_server');
				var application=mainForm.findField('er_application_usage');
				if( compType.getValue() == '-1'){
					Ext.MessageBox.show({
						title: appConstants.er_RmDispName,
						msg: compType.getStore().getAt(0).get('displayField'),
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if( component.getValue() == '-1'){
					Ext.MessageBox.show({
						title: appConstants.er_RmDispName,
						msg: component.getStore().getAt(0).get('displayField'),
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if( application.getValue() == '-1'){
					Ext.MessageBox.show({
						title: appConstants.er_RmDispName,
						msg: application.getStore().getAt(0).get('displayField'),
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
		}
		var jsonData;
		if(targetType == 'Application Usage')
			jsonData = appConstants.publicjsonDataUsage
		else
			jsonData = appConstants.publicjsonDataActivity;
		var isSettingsOk = true;

		var hiddenFields = jsonData['hiddenfields'];

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen=this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty( hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate))
		{
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: appConstants.er_RmDispName+' settings',
				msg:  appConstants.userTimelineErrorMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			var limitforbg = hiddenFields["limitforbg"];

			if(!Ext.isEmpty(limitforbg))
			{
				if(flag)
				{
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm(confirmMsg, appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else{
			var reportName = thinclientSettingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}

		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}else
		return false;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
		var starthr = mainForm.findField('er_sthr').getValue();
		startdate.setHours(starthr);
		var enddate = mainForm.findField('er_enddate').getValue();
		var endhr = mainForm.findField('er_endhr').getValue();
		enddate.setHours(endhr);
		var result = checkDateTime(startdate, enddate);
		if (!result) {
			return;
		}
		var isValid = this.validateMainForm(true);

		if(isValid)
			this.submitReport();
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv') )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			this.submitReport();
		}else{
			this.getReporterSettings().down('button').fireHandler();
			var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
			var reportGenType=thinclientSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			if(WVD_report)
			{
				URL+="&WVD_reports=yes";
			}
			if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
			{
				URL+="&onlyCompTpye="+onlyCompTpye;
			}
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	loadGrid:function(GridArrays){
		var resultPanelObj=Ext.getCmp('resultPanel');
		var mainForm =Ext.getCmp('mainform').getForm();
		var itemsArray=new Array();
		var me = this;
		if ( !Ext.isEmpty( GridArrays ) ){
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = me.getThinclientapplicationsettings().getForm();
		for(var i in GridArrays){
			var gridDataObj=GridArrays[i];
			var columnDetails=gridDataObj.columns;
			var units= gridDataObj.data_units;
			var dataArraytoStore=gridDataObj.dataArray;
			var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
			var fieldstoStore =  {};
			var cnt=0;
			var mainColumnsObjArray	=  new Array();
			var colCount=0;
			var forceFit=true;
			for( var key in columnDetails ){
				var mainColumn=key;
				var subColumns=new Array();
				var subColObjArray=new Array();
				subColumns=columnDetails[key];
				if(subColumns!=undefined && !Ext.isEmpty(subColumns)){
					for(var j in subColumns)
					{
						colCount++;
						var tmp=subColumns[j]+" (" + units[mainColumn]+ ")";
						fieldstoStore[cnt]=mainColumn+"_"+tmp;
						subColObjArray.push({
							header: tmp,
							sortable:true,
							dataIndex:cnt,
							align:'center',
								doSort: function(state) {
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											v1 = v1.get(field);
											v2 = v2.get(field);
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								if(value != undefined && value.indexOf('~')>-1)
								{
									var text = value.substring( 0, value.indexOf('~') );
									var url = value.substring( value.indexOf('~') + 1 );
									var compArray=mainForm.findField('er_server').getValue();
									var s_compType=mainForm.findField('er_compType').getValue();
									url+="&er_compType="+s_compType;
									if(compArray!=null && compArray!='undefined' && compArray.length>0){
										for(var k=0;compArray.length>k;k++)
										{
											url+="&er_workgroupserver="+compArray[k];
										}
									}
									var toolValue = text;
									if(text!=null && text=="top.gif")
									{
										text='iconArrowUp';
										value = '<div align="center"><a href="javascript:void(0);" onclick="showDrillDownData(\''+url+'\')" ><div class="'+text+'"></div></a></div>';
										toolValue = '';
									}
									else
									{
										value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onclick="showDrillDownData(\''+url+'\')" >'+text+'</a></div>';
									}
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+toolValue+'"';
								}
								else
								{
									if (value != undefined && value.indexOf('.exe') > -1)
									{
										value=replaceAll(value,'.exe','');
									}
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = Ext.getCmp('appGrid_0').getDecimalAlignFormat(value);
								}
									
								return value;
							}
						});
						cnt++;
					}
					mainColumnsObjArray.push(
					{
						header: mainColumn,
						locked:false,
						sortable:true,
						columns: subColObjArray
					});
				}
				else
				{
					
					var isLocked = false;
					if(cnt==0)
						isLocked = true;
					colCount++;
					var align='center';
					if (key=='Application' ||key=='Session Host')
					{ 
						align='left';
					}
					fieldstoStore[cnt]=mainColumn;
						mainColumnsObjArray.push({
							header: mainColumn,
							sortable:true,
							dataIndex: cnt,
							//width:115,
							minWidth:115,
							width:115,
							flex:1,
							locked:isLocked,
							align:align,
							doSort: function(state) {
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2){
										v1 = v1.get(field);
										v2 = v2.get(field);
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										if (state=='ASC')
										{
											v1= isNaN(v1) ? 999999 : v1;
											v2= isNaN(v2) ? 999999 : v2;
										}
										else
										{
											v1= isNaN(v1) ? 0 : v1;
											v2= isNaN(v2) ? 0 : v2;
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
							renderer: function(value, metaData, record, row, col, store, gridView)
							{
								if( value != undefined && value.indexOf('~')>-1)
								{
									var text = value.substring(0,value.indexOf('~'));
									var url = value.substring(value.indexOf('~')+1);
									url+="&er_perserver="+me.getSettingsFieldValue(thinclientSettingsForm,'er_perserver',isSettingsEnabled,'selectedAgg');
									var compArray=mainForm.findField('er_server').getValue();
									var s_compType=mainForm.findField('er_compType').getValue();
									url+="&er_compType="+s_compType;
									if(compArray!=null && compArray!='undefined' && compArray.length>0)
									{
										for(var k=0;compArray.length>k;k++)
										{
											url+="&er_workgroupserver="+compArray[k];
										}
									}
									if(text!=null && text=="top.gif")
									{
										text='iconArrowUp';
										value = '<div align="center"><a href="javascript:void(0);" onclick="showDrillDownData(\''+url+'\')" ><div class="'+text+'"></div></a></div>';
									}
									else
									{
										value = '<div align="center"><a class="anchorLinkDefault" href="javascript:void(0);" onclick="showDrillDownData(\''+url+'\')" >'+text+'</a></div>';
									}
								}
								else
								{
									if (value != undefined && value.indexOf('.exe') > -1)
									{
										value=value.replace('.exe','');
									}
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = Ext.getCmp('appGrid_0').getDecimalAlignFormat(value);
								}
									
								return value;
							}
						});
						cnt++;
				}
			}
			if(colCount>10)
				forceFit=false;
			var isPagingHidden;
			if (dataArraytoStore.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var fields=[];
			for(var key in dataArraytoStore[0])
			{
				fields.push(key);
			}
			var index = 0;
			if(Ext.getCmp('sort_by')!=undefined)
			{
				index = Ext.getCmp('sort_by').getValue();
			}
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fields,
				proxy : {
					type : 'pagingmemory',
					data:dataArraytoStore,
					reader : {
						type: 'json'
					},
				},
				pageSize:gridPageSize,//gridPageSize is added in ErTracker.jsp
				remoteSort : true,
				autoLoad : true,
				sorters: { property: fields[index], direction : 'ASC' }// vengat
			});
			var pages;
			var total;
			var activePage=1;
			var groupingFeature = Ext.create('Ext.grid.feature.Grouping',{
				groupHeaderTpl: '{application} ({rows.length} Item{[values.rows.length > 1 ? "s" : ""]})'
			});
				itemsArray.push(
					{
						xtype:'panel',
						margin:'10',
						ui:'newGraphPanel',
						title:gridDataObj.gridTitle,
						items:[
							{
								xtype:'customgrid',
								store:storeObj,
								ui:'newGridPanel',
								sortableColumns:true,
								needtoFixColumn:true,
								columns:mainColumnsObjArray,
								id:'appGrid_'+i,
								//bodyPadding:'0 0 0 0',
								margin:10,
								border:true,
								scroll:true,
								lockedGridConfig: {
									//emptyText: '',
									collapsible: false,
									forceFit: true,
									flex:1/5,
								},
								features: [groupingFeature],
								autoScroll:true,
								forceFit:forceFit,
								listeners:{
									sortchange:function(ct, column, e, t, eOpts ){
										me.gridColIndexParam=column.getIndex();
										me.gridColStateParam=column.sortState;
										 this.getStore().load();
									},
									render:function(obj){
										Ext.defer(function() {
											//obj.columns[0].setSortState("ASC",true,true);
										},100);
									}
								},
								dockedItems:[
								{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{           
											pages = params.pageCount;
											total = params.total;
											activePage = params.currentPage;
										}
									 }
								}]
							}
						]
					}
				);
			}
			resultPanelObj.removeAll();
			resultPanelObj.add(itemsArray);
			resultPanelObj.show();
			resultPanelObj.doLayout();
		}
	},
	loadReportData:function(jsonData){
		var reportFor = Ext.getCmp('report_category').getValue();
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var me=this;
		var reportData=jsonData.reportData;
		var dataAvailable=false;
		var chartType = jsonData['chartType'];
		if(reportFor == 'application_activity')
		{
			if(jsonData.hasOwnProperty('reportData'))
			{
				var reportType=jsonData.selectedreportType;
				if(reportType=='Yes')
				{
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					var chartUrlArray =new Array();
					var itemsArray =new Array();
					chartUrlArray=reportData.chartUrls;
					noOfchart=chartUrlArray.length;
					for(var i=0;noOfchart>i;i++)
					{
						var url = chartUrlArray[i];
						var chartProperties=this.getXmlForUrl(url);
						if (!Ext.isEmpty( chartProperties ) && chartProperties.hasOwnProperty('XML') )
						{
							dataAvailable=true;
							var margin,flex;
							if (i==0)
							{
								margin='5 10 10 10';
								flex=0.65;
							}
							else
							{
								margin='5 10 10 0';
								flex=1;
							}
							var chartbox={
								xtype:'panel',
								data: chartProperties,
								//cls:'containerShadow',
								flex:flex,
								ui:'newGraphPanel',
								title:chartProperties.chartTitle,
								margin:margin,
								id: 'fusion'+i
							};
							itemsArray.push(chartbox);
						}
					}
					if(dataAvailable)
					{
						//resultPanelObj.setTitle("<span class='newfont_bold15'>"+reportData.title+"</span>");
						resultPanelObj.add({
							//xtype:'container',
							xtype:'panel',
							ui:'multiGraphPanel',
							margin:'10',
							title:reportData.title,
							layout:{type:'hbox',align:'stretch'},
							items:itemsArray
						});
						resultPanelObj.show();
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						for (var i = 0; i < noOfchart; i++)
						{
							var containerObj=Ext.getCmp('fusion'+i);
							var data = containerObj.data;
							var reportData=data.reportData;
							if (!Ext.isEmpty( data ) && data.hasOwnProperty('XML'))
							{
								var innerHtml=data.innerHtml;
								var chartFor =data.chartFor;
								var chartHight =data.chartHight;
								if(chartFor =='Top')
								{
									appConstants.erUtils.updateBarChart(appConstants.chartType,null,data.XML,data.swfpath,data,data.chartHeight-20,data.chartWidth,containerObj);
								}
								else if(chartFor =='distribution')
								{
									appConstants.erUtils.updatePieChart(appConstants.chartType,data,'pieColors','urlLinks','pieLabels',null,data.XML,data.swfpath,data,containerObj);
								}
							}
							else
							{
								containerObj.update('<div><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
							}
						}
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					}
					else
					{
						this.disableTools();
						resultPanelObj.hide();
						this.getNomeasurepanel().doLayout();
						this.getNomeasurepanel().show();
					}
				}
				else if(reportType == 'No')
				{
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);
					appConstants.publicGridData=reportData.gridArray;
					this.loadGrid(appConstants.publicGridData);
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
			}
			else
			{
				this.disableTools();
				resultPanelObj.hide();
				this.getNomeasurepanel().doLayout();
				this.getNomeasurepanel().show();
			}
		}
		else if(reportFor == 'application_usage')
		{
			var er_graphViews;
			var thinclientSettingsForm =null;
			if(isSettingsEnabled)
				er_graphViews = Ext.getCmp("graphViews").getValue();
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			//resultPanelObj.setTitle("<span class='font_bold'>"+reportData.title+"</span>");
			var height = 385;
			var showLegends = Ext.getCmp('showLegend').getValue();
			if(showLegends)
			{
				height = 440;
			}
			if(chartType == 'highchart')
			{
				resultPanelObj.add({
					xtype:'panel',
					ui:'newGraphPanel',
					//width:'100%',
					//layout:'fit',
					margin:'10 10 10 10',
					title:reportData.title,
					height:height,
					style:{
						'text-align':'center',
					},
					/*layout:{
						type : 'vbox',
						align : 'stretch',
					},*/

					items:[{
						xtype:'container',
						height:335,
						//flex:1,
						id:'highChart_GraphPanel',
						html:'<div id="highChart" style="width:100%;height:100%;"></div>'
					},
					{
						xtype:'panel',
						height:55,
						id:'highChart_legendPanel',
						margin: '5 10 10 0',
						style:{
							'overflow' : 'hidden',
						}
					}]
				});
			}
			else
			{
				resultPanelObj.add({
					xtype:'panel',
					margin:'10 10 10 10',
					ui:'newGraphPanel',
					title:reportData.title,
					style:
					{
						'text-align':'center'
					},
					items:[
						{
							xtype:'image',
							src:reportData.imageUrl,
							width:900,
							height:580
						}
					]
				});
			}
			resultPanelObj.show();
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			if(isSettingsEnabled)
			{
				thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
				er_graphViews=this.getSettingsFieldValue(thinclientSettingsForm,'graphViews',isSettingsEnabled,'er_graphViews');
				reportData.imageUrl+="&er_graphViews="+jsonData.er_graphViews;
			}
			if(chartType == 'highchart')
				reportHighStockChart(reportData.imageUrl+"&chartType="+chartType,"highChart",380,90,"");
			Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
		}
	},
	submitReport:function(){
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var url;
		var backgroundUrl;
		var csvbackgroundUrl;
		var Qstring;
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportFor = mainForm.findField('report_category').getValue();
		appConstants.report_for=reportFor;
		if(reportFor == 'application_activity'){
			var rtype=mainForm.findField('er_type').getValue();
			if(rtype == 'Yes'){
				url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&er_server=-1&er_application=-1&er_sortby=-1&er_perserver=Yes&responseType=json"
				backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&er_server=-1&er_application=-1&er_sortby=-1&er_perserver=Yes&responseType=json"
			}
			else{
				url="../servlet/com.eg.ErCtxServerReportC?isSubmit=true&responseType=json";
				backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";
				csvbackgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				appConstants.queryStringActivity+="&er_server="+mainForm.findField('er_server').getValue();
			}
			this.updateQStringActivity();
			Qstring=appConstants.queryStringActivity;
		}
		else{
			this.updateQStringUsage();
			var setLegendVal='';
			if(isSettingsEnabled){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined')
				 setLegendVal = "&showLegend="+islegendEnabled;
			}
			else
				 setLegendVal = "&showLegend=true";
			Qstring=appConstants.queryStringUsage+setLegendVal;
			url="../servlet/com.eg.ErAppUsageReportC?isSubmit=true&responseType=json";
			backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";
		}
		backgroundUrl += "&isPdf=yes"
		var resultPanelObj=Ext.getCmp('resultPanel');
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		var reportGeneration=this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var reportType='';
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		//by karthikeyan
		Qstring += '&er_RmDispName='+appConstants.er_RmDispName;
		if(WVD_report)
		{
			Qstring+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			Qstring+="&onlyCompTpye="+onlyCompTpye;
		}
		if(reportGeneration == 'foreground'){
			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					if(reportFor == 'application_usage'){
						appConstants.publicjsonDataUsage=jsonData;
					}else{
						appConstants.publicjsonDataActivity=jsonData;
					}
					this.loadReportData(jsonData);
				}
			});
		}
		else if(reportGeneration == 'background')
		{
			resultPanelObj.hide();
			var htmlStr = '';
			var me=this;
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					publicjsonData=jsonData;
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					var bgGroundMsg=jsonData.bgGroundMsg;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							//var statusCssClass='iconSuccess';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'|| (bgGroundMsg!=null))
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgGroundMsg+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							//var statusCssClass = 'iconExists';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'</div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<span>ErroR In BackGround Generation</span>';
					}
					me.getBackGroundPanel().update(htmlStr);
					me.getBackGroundPanel().show();
				}
			});
		}
		else if(reportGeneration == 'background-csv'){
			resultPanelObj.hide();
			var htmlStr = '';
			var me=this;
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :csvbackgroundUrl,
				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					publicjsonData=jsonData;
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					var bgGroundMsg=jsonData.bgGroundMsg;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							//var statusCssClass='iconSuccess';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'|| (bgGroundMsg!=null))
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgGroundMsg+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							//var statusCssClass = 'iconExists';
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<span>ErroR In BackGround Generation</span>';
					}
					me.getBackGroundPanel().update(htmlStr);
					me.getBackGroundPanel().show();
				}
			});
		}
	},
	excludeAppChange:function(){
		var jsonData;
		if(targetType == 'Application Usage')
			jsonData = appConstants.publicjsonDataUsage
		else
			jsonData = appConstants.publicjsonDataActivity;
		var comboVal= Ext.getCmp('exeAppTxtField').getValue();
		var repType= Ext.getCmp('er_type').getValue();
		if(jsonData.selectedExcludeApp != comboVal && repType != undefined && repType=='No'){
			this.updateQStringActivity();
			var compArr = Ext.getCmp("er_server").getValue();

			if(compArr==null || compArr=='' || compArr.length==0)
				return;

			var urlstr = "/final/reporter/ErCtxApplicationReportJson.jsp?select_farm=" + Ext.getCmp("select_farm").getValue() + "&er_type=" + Ext.getCmp("er_type").getValue() + "&er_server=" + compArr;
			if(WVD_report)
			{
				urlstr+="&WVD_reports=yes";
			}
			if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
			{
				urlstr+="&onlyCompTpye="+onlyCompTpye;
			}
			Ext.Ajax.request({
				url: urlstr,
				params: appConstants.queryStringActivity,
				scope: this, 
				success: function(response) {
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var component;

					comboRawData = jsonData.applnCombo;
					selectedComboOption = jsonData.selectedAppln;
					comboObject = Ext.getCmp("er_application");
					appConstants.rawDataForApplication=comboRawData;
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					//this.refreshReportData(appConstants.publicjsonDataActivity);
				}
			//
			
			
			});
		}	
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		var reportGenType=thinclientSettingsForm.findField('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if(reportGenType== 'background')
		{
			thinclientSettingsForm.findField('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(reportGenType== 'background-csv')
		{
			thinclientSettingsForm.findField('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	timeLineOnChange:function() {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startDateObj=mainForm.findField('er_stdate');
		var startHrObj=mainForm.findField('er_sthr');
		var endDateObj=mainForm.findField('er_enddate');
		var endHrObj=mainForm.findField('er_endhr');
		var timelineObj=mainForm.findField('er_timeline');
		if(timelineObj.getValue() == 'Any'){
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else{
		timelineObj.suspendEvents(true);
		this.updateQStringActivity();
		var url_='';
		if(WVD_report)
		{
			url_+="&WVD_reports=yes";
		}
		if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
		{
			url_+="&onlyCompTpye="+onlyCompTpye;
		}
		Ext.Ajax.request(
		{
			url : '/final/reporter/ErCtxApplicationReportJson.jsp',
			params : appConstants.queryStringActivity+url_,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				var start_hour=jsonData.startHour;
				var end_hour=jsonData.endHour;
				var start_date=jsonData.startDate;
				var end_date=jsonData.endDate;
				startDateObj.setDisabled(true);
				startHrObj.setDisabled(true);
				endDateObj.setDisabled(true);
				endHrObj.setDisabled(true);
				startDateObj.setValue(start_date);
				startHrObj.setValue(start_hour);
				endDateObj.setValue(end_date);
				endHrObj.setValue(end_hour);
			}
		});
		timelineObj.resumeEvents();
		}
	},
	/*weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},*/
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringActivity:function(){
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();

		var er_excludeAppVal = this.getSettingsFieldValue(thinclientSettingsForm,'exeAppTxtField',isSettingsEnabled,'selectedExcludeApp');
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}

		var reportType = mainForm.findField('er_type').getValue();
		FormParams="select_farm="+mainForm.findField('select_farm').getValue()
					+"&er_type="+reportType+"&er_excludeApp="+ appConstants.erUtils.specialCharEncode(er_excludeAppVal)
					+"&er_excwe="+this.getSettingsFieldValue(thinclientSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var erOption=Ext.getCmp('er_option');
		if(erOption!=undefined)
		{
			FormParams+="&er_option="+erOption.getValue();
			if (erOption.getValue()=='Group'||erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
			{
				var erSite=Ext.getCmp('er_site');
				FormParams+="&er_site="+erSite.getValue();
			}
		}
		if(reportType == 'Yes')
		{
			FormParams+="&select_testmes=" + mainForm.findField("select_testmes").getValue() + "&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_mode=" + mainForm.findField("er_mode").getValue() + "&sh_timeinuse=No";
			if(WVD_report)
			{
				var compArray=mainForm.findField('er_server_graph').getValue();
				if(compArray!=null && compArray!='undefined' && compArray.length>0){
					for(var k=0;compArray.length>k;k++)
					{
						FormParams+="&er_workgroupserver="+compArray[k];
					}
				}
			}
		}
		else
		{
			var s_server=mainForm.findField('er_server').getValue();
			var compArray=mainForm.findField('er_server').getValue();
			var appArray=mainForm.findField('er_application').getValue();
			if(compArray!=null && compArray!='undefined' && compArray.length>0){
				for(var k=0;compArray.length>k;k++)
				{
					FormParams+="&er_workgroupserver="+compArray[k];
				}
			}
			if(appArray!=null && appArray!='undefined' && appArray.length>0){
				for(var k=0;appArray.length>k;k++)
				{
					FormParams+="&er_application="+encodeURIComponent(appArray[k]);
				}
			}
			var sort_by=-1;
			var sortCombo=Ext.getCmp('sort_by');
			if ( !Ext.isEmpty(sortCombo) )
				 sort_by=Ext.getCmp('sort_by').getValue();
			this.gridColStateParam='ASC';
			this.gridColIndexParam=sort_by;
				
			FormParams+="&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_sortby="+sort_by + "&sh_timeinuse=" + this.getSettingsFieldValue(thinclientSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');

			if(compArray ==undefined || compArray=="-1" || compArray.indexOf("All")>-1 || compArray.length>0)
				FormParams+="&er_perserver="+this.getSettingsFieldValue(thinclientSettingsForm,'er_perserver',isSettingsEnabled,'selectedAgg')+"&er_server="+mainForm.findField('er_server').getValue();;
		}
		var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		if(WVD_report && Ext.getCmp('wvdserver').isVisible())
		{
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			var serverArrayStr = Ext.getCmp('er_WVDserver').fieldValue;
			var serverArray = serverArrayStr.split(',')
			if(serverArray!=null && serverArray!='undefined' && serverArray.length>0)
			{
				for(var k=0;serverArray.length>k;k++)
				{
					FormParams+="&WVD_server="+appConstants.erUtils.specialCharEncode(serverArray[k]);
				}
			}
		}
		var workgroup;
		if (appConstants.publicjsonDataActivity.hasOwnProperty("selectedWorkergroup"))
		{
			workgroup = "&er_workgrpname=" + appConstants.publicjsonDataActivity.selectedWorkergroup;
			appConstants.queryStringActivity = FormParams+timelineParams+hiddenfieldQString+timperiodParams + workgroup;
		}
		else
		{
		   appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
		}
	},
	updateQStringUsage:function()
	{
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var compArray=new Array();
		var er_graphViews;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
		{
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
			er_graphViews = Ext.getCmp("graphViews").getValue();
		}
		compArray=Ext.getCmp("er_server").getValue();
		FormParams="&er_compType=" + mainForm.findField("er_compType").getValue() + "&er_application=" + encodeURIComponent(mainForm.findField("er_application_usage").getValue()) + "&er_reportgenration=" + this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		if(isSettingsEnabled)
			FormParams+='&er_graphViews='+er_graphViews.cType;
		var erOption=Ext.getCmp('er_option');
		if(erOption!=undefined)
		{
			FormParams+="&er_option="+erOption.getValue();
			if(erOption.getValue()=='Zone')
			{
				var zoneval=mainForm.findField("select_farm").getValue();
				FormParams+="&er_zone="+zoneval;
			}
			else if (erOption.getValue()=='Group'||erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
			{
				var erSite=Ext.getCmp('er_site');
				FormParams+="&er_site="+erSite.getValue();
			}
		}
		if(Ext.get('showLegend')!=null)
			FormParams=FormParams+"&showLegend="+ mainForm.findField('showLegend').getValue();
		for(var k=0;compArray.length>k;k++)
		{
			FormParams+="&er_component="+compArray[k];
		}
		if(WVD_report && Ext.getCmp('wvdserver').isVisible())
		{
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			var serverArrayStr = Ext.getCmp('er_WVDserver').fieldValue;
			var serverArray = serverArrayStr.split(',')
			if(serverArray!=null && serverArray!='undefined' && serverArray.length>0)
			{
				for(var k=0;serverArray.length>k;k++)
				{
					FormParams+="&WVD_server="+appConstants.erUtils.specialCharEncode(serverArray[k]);
				}
			}
		}
		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
		var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
		if(appConstants.publicjsonDataUsage.hasOwnProperty('hiddenfields')){
			var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		var workgroup;
		if (appConstants.publicjsonDataUsage.hasOwnProperty("selectedWorkergroup"))
		{
			workgroup = "&er_workgrpname=" + appConstants.publicjsonDataActivity.selectedWorkergroup;
			appConstants.queryStringUsage=FormParams+timelineParams+hiddenfieldQString+timperiodParams+workgroup;
		}
		else
		{
		   appConstants.queryStringUsage=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
		}
	},
	afterMainRender:function(){
		var thisController = this;
		if(targetType == 'Application Usage'){
			this.refreshReportData(appConstants.publicjsonDataUsage);
		}else{
			this.refreshReportData(appConstants.publicjsonDataActivity);
		}
	},
	loadFormElements:function() {
		registerAjaxEvents();
		var mainForm =Ext.getCmp('mainform').getForm();
		if(targetType == 'Application Activity')
			Ext.getCmp('showLegend').hide();
		else if (Ext.getCmp('showLegend') != undefined){
			if( appConstants.isshowLegend != undefined && appConstants.isshowLegend != null && appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
				  Ext.getCmp('showLegend').setValue(true);
		}

		if(targetType == 'Application Usage'){
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
				this.getMain().setTitle(appConstants.er_RmDispName);
			else
				this.getMain().setTitle(appConstants.publicjsonDataUsage.reportTitle);
			this.fillFormFieldsForUsage(appConstants.publicjsonDataUsage);
			Ext.getCmp('egcomponent').show();
			if(!hideBackButton){
				Ext.getCmp('thinclientapplicationform').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicjsonDataUsage['ID']
					}
				);
			}
		}
		else{
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
				this.getMain().setTitle(appConstants.er_RmDispName);
			else
				this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
			this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
			if(!hideBackButton){
				Ext.getCmp('thinclientapplicationform').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicjsonDataActivity['ID']
					}
				);
			}
		}
		var report_type = mainForm.findField("er_type").getValue();
		if(targetType == 'Application Activity' || targetType == 'Application Report')
		{
			if(report_type=='Yes')
			{
				Ext.getCmp('egcomponent').hide();
				if(WVD_report)
				{
					Ext.getCmp('egservers').show();
					Ext.getCmp('wvdserver').show();
				}
				else
				{
					Ext.getCmp('wvdserver').hide();
					Ext.getCmp('egservers').hide();
				}
			}
			else
			{
				Ext.getCmp('egcomponent').show();
				if(WVD_report)
				{
					Ext.getCmp('wvdserver').show();
				}
				Ext.getCmp('egservers').hide();
			}
		}
		else
		{
			Ext.getCmp("multiselectpanel1").hide();
		}
		if(targetType == 'Application Usage')
			jsonData = appConstants.publicjsonDataUsage
		else
			jsonData = appConstants.publicjsonDataActivity;
		var screenLabels = jsonData.screenLabels;
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData))
		{
			if ( !Ext.isEmpty(selectedTimeline))
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		var er_option=mainForm.findField('er_option');
		er_option.getStore().loadRawData(jsonData.analysisByCombo);
		er_option.setFieldLabel(screenLabels['reporter.thin.Report By']);
		if (!Ext.isEmpty(jsonData.selectedAnalysisByCombo))
		{
			er_option.setValue(jsonData.selectedAnalysisByCombo);
		}
		else
		{
			if(jsonData.analysisByCombo!=undefined)
				er_option.setValue(jsonData.analysisByCombo[0].valueField);
		}
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = mainForm.findField('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = mainForm.findField('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = mainForm.findField('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = mainForm.findField('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
	},
	refreshReportData:function(jsonData){
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.gridColStateParam='ASC';
			this.gridColIndexParam=jsonData.selectedSort;
			this.loadReportData(jsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity: function(jsonData)
	{
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var mainForm =Ext.getCmp('mainform').getForm();
		if (jsonData.hasOwnProperty("isSubmit"))
		{
			var isSubmitted = jsonData.isSubmit;
		}
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		 var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		 if (from_schedule != null && from_schedule == "Yes" || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		} else {
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var screenLabels = jsonData.screenLabels;
		appConstants.globalScreenLabels = jsonData.screenLabels;
		var selectedAnalysisByCombo='';
		if (jsonData.hasOwnProperty('selectedAnalysisByCombo'))
		{
			selectedAnalysisByCombo=jsonData.selectedAnalysisByCombo;
		}
		if(selectedAnalysisByCombo=='Zone')
		{
			Ext.getCmp('er_site').hide();
			comboRawData = jsonData.zoneCombo;
			selectedComboOption = jsonData.selectedZone;
			comboObject = mainForm.findField("select_farm");
			comboObject.setFieldLabel(screenLabels["reporter.consolidated.Zone"]);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption))
			{
				comboObject.setValue(selectedComboOption);
			} 
			else
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		else if(selectedAnalysisByCombo=='Segment')
		{
			Ext.getCmp('select_farm').hide();
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Segment');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) 
			{
				comboObject.setValue(selectedComboOption);
			} 
			else 
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Group')
		{
			Ext.getCmp('select_farm').hide();
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Group');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) 
			{
				comboObject.setValue(selectedComboOption);
			} 
			else 
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Service')
		{
			Ext.getCmp('select_farm').hide();
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Service');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Component')
		{
			Ext.getCmp('select_farm').hide();
			Ext.getCmp('er_site').hide();
		}
		else
		{
			if (jsonData.hasOwnProperty('zoneCombo')){
				comboRawData = jsonData.zoneCombo;
				 var selectedZone = jsonData.selectedZone;
				 comboObject = mainForm.findField("select_farm");
				 comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedZone)) {
					comboObject.setValue(selectedZone);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
					comboObject.show();
			}
		}
		if (jsonData.hasOwnProperty('componentTypeCombo'))
		{
			comboRawData = jsonData.componentTypeCombo;
			selectedComboOption = jsonData.selectedComponentType;
			comboObject = mainForm.findField("er_compType");
			comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		if (jsonData.hasOwnProperty('workerGroupCombo'))
		{
			comboRawData = jsonData.workerGroupCombo;
			selectedComboOption = jsonData.selectedWorkergroup;
			e = mainForm.findField("er_workgrpname");
			e.setFieldLabel(screenLabels["reporter.thin.Worker Group"]);
			e.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				e.setValue(selectedComboOption);
			} else {
				e.setValue(comboRawData[0].valueField);
			}
			e.show();
		}
		else
		{
			mainForm.findField("er_workgrpname").hide();
		}
		comboRawData = jsonData.viewApplnCombo;
		selectedComboOption = jsonData.selectedViewAppln;
		comboObject = mainForm.findField("report_category");
		comboObject.setFieldLabel(screenLabels["reporter.common.View Application"]);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.reportTypeCombo;
		selectedComboOption = jsonData.selectedreportType;
		comboObject = mainForm.findField("er_type");
		comboObject.setFieldLabel(screenLabels["reporter.thin.Report Type"]);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		if (selectedComboOption == "No") 
		{
			Ext.getCmp("select_testmes").hide();
			Ext.getCmp("er_mode").hide();
			comboRawData = jsonData.serverCombo;
			selectedComboOption = jsonData.selectedServer;
			comboObject = Ext.getCmp("er_server");
			var objLabel = Ext.getCmp("multiSelectLabel");
			objLabel.setText(screenLabels["reporter.common.Server"]);
			var objTool = Ext.getCmp('expandSelectorActivity');
			objTool.setTooltip('<b>'+screenLabels["reporter.common.Server"]+'</b>');
			var objField =Ext.getCmp("egcomponent");
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			objField.show();
			if(WVD_report)
			{
				Ext.getCmp('wvdserver').show();
				var component = Ext.getCmp("er_WVDserver");
				component.storeData = jsonData.WVDserverCombo;
				component.setValue(jsonData.selectedWVDserverUI);
				component.fieldValue = jsonData.selectedWVDserver;
				if(mainForm.findField("er_type").getValue()!='Yes')
				{
					var ddTxtValueStr=jsonData.selectedWVDserver;
					if(ddTxtValueStr!=undefined)
					{
						selectedComboOption = ddTxtValueStr.split(',');
					}
				}
			}
			if(selectedComboOption!=null && selectedComboOption!='undefined')
			{
				if (selectedComboOption.indexOf("All") > -1 || selectedComboOption.indexOf("all") > -1 || selectedComboOption.length > 1) {
					if(Ext.getCmp("er_perserver")!=undefined)
						Ext.getCmp("er_perserver").show();
				}
			}
			comboRawData = jsonData.applnCombo;
			selectedComboOption = jsonData.selectedAppln;
			comboObject = Ext.getCmp("er_application");
			appConstants.rawDataForApplication=comboRawData;
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		} else {
			comboRawData = jsonData.measureCombo;
			selectedComboOption = jsonData.selectedMeasure;
			comboObject = mainForm.findField("select_testmes");
			comboObject.setFieldLabel(screenLabels["reporter.thin.Criteria"]);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			if(WVD_report)
			{
				comboRawData = jsonData.serverCombo;
				selectedComboOption = jsonData.selectedServer;
				comboObject = Ext.getCmp("er_server_graph");
				var objLabel = Ext.getCmp("multiSelectLabel_graph");
				objLabel.setText(screenLabels["reporter.common.Server"]);
				var objTool = Ext.getCmp('expandSelectorActivity_graph');
				objTool.setTooltip('<b>'+screenLabels["reporter.common.Server"]+'</b>');
				 appConstants.rawDataForComponents=comboRawData;
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				var component = Ext.getCmp("er_WVDserver");
				component.storeData = jsonData.WVDserverCombo;
				component.setValue(jsonData.selectedWVDserverUI);
				component.fieldValue = jsonData.selectedWVDserver;
			}
		}
		mainForm.findField("er_option").show();

	},
	loadSettingsElements: function() {
		var hiddenFields =  '';
		var favorite_id='';
		if(targetType == 'Application Usage')
		{
			hiddenFields=appConstants.publicjsonDataUsage['hiddenfields'];
			favorite_id=hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id))
			{
				Ext.getCmp('reportGeneration').setDisabled(true);
			}
		}
		else
		{
			hiddenFields=appConstants.publicjsonDataActivity['hiddenfields'];
			favorite_id=hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id))
			{
				Ext.getCmp('reportGeneration').setDisabled(true);
			}
		}
		Ext.getCmp('moreOptionCloseId').show();
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		if(targetType == 'Application Usage')
			jsonData = appConstants.publicjsonDataUsage
		else
			jsonData = appConstants.publicjsonDataActivity;
		var screenLabels=jsonData.screenLabels;

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		updatingAppSettings();
		if (targetType == 'Application Activity' || targetType == 'Application Report'){
			comboRawData = jsonData.excludeWeekCombo;
			selectedComboOption = jsonData.excludeWeek;
			comboObject = thinclientSettingsForm.findField("er_excwe");
			comboObject.setFieldLabel(screenLabels["reporter.common.Exclude weekends"]);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			//..for exclude application
			comboRawData= jsonData.excludeAppArry;
			selectedComboOption= jsonData.selectedExcludeApp;
			comboObject = thinclientSettingsForm.findField("exeAppTxtField");
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			var fieldLabelObj = Ext.getCmp('excludeApplication');
			fieldLabelObj.setFieldLabel(screenLabels['reporter.thin.Exclude Applications']);
			//..
			comboRawData = jsonData.weightedAvgCombo;
			selectedComboOption = jsonData.weightedAvg;
			comboObject = thinclientSettingsForm.findField("sh_timeinuse");
			comboObject.setFieldLabel(screenLabels["reporter.comparison.Weighted Average"]);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboRawData = jsonData.aggbasedOn;
			selectedComboOption = jsonData.selectedAgg;
			comboObject = thinclientSettingsForm.findField("er_perserver");
			//comboObject.setFieldLabel("Aggregate across servers");
			comboObject.setFieldLabel(screenLabels['reporter.thin.Aggregate across servers']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			var reportType=jsonData.selectedreportType;
			comboObject = thinclientSettingsForm.findField("sort_by");
			 if(reportType!=undefined && reportType == 'No'){
				selectedComboOption=jsonData.selectedSort;
				comboRawData=jsonData.sortComboArr;
				comboObject.getStore().loadRawData(comboRawData);
				comboObject.setFieldLabel(screenLabels['reporter.thin.Sort By']);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject.show();
			}
			else
			{
				selectedComboOption=jsonData.selectedSort;
				comboRawData=jsonData.sortComboArr;
				comboObject.getStore().loadRawData(comboRawData);
				comboObject.setFieldLabel(screenLabels['reporter.thin.Sort By']);
				if (!Ext.isEmpty(selectedComboOption)) 
				{
					comboObject.setValue(selectedComboOption);
				} 
				else 
				{
					comboObject.setValue(comboRawData[0].valueField);
				}
				 comboObject.hide();
			}
		}
		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
		if(targetType == 'Application Usage')
		{
			var comboObject=Ext.getCmp('graphViews');
			var selectedComboOption=jsonData.er_graphViews;
			comboObject=Ext.getCmp('lineView');
			if(!Ext.isEmpty(selectedComboOption))
			{
				if(selectedComboOption=="Area")
				comboObject=Ext.getCmp('areaView');
			}
			comboObject.setValue(true);
		}
		var thisController = this;
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings();
		});
		if (targetType == 'Application Activity' || targetType == 'Application Report'){
			thinclientSettingsForm.findField("sh_timeinuse").show();
			thinclientSettingsForm.findField("er_excwe").show();
			thinclientSettingsForm.findField("er_perserver").hide();
		// for single server selection-hide the accoss server
		var mainForm =Ext.getCmp('mainform').getForm();
		var compArr = Ext.getCmp("er_server").getValue();
		if(mainForm.findField("er_type").getValue() == null || mainForm.findField("er_type").getValue()==undefined)
		return;
		if(WVD_report && mainForm.findField("er_type").getValue()!='Yes')
		{
			var ddTxtValueStr=Ext.getCmp('er_WVDserver').fieldValue;
			if(ddTxtValueStr!=undefined)
			{
				compArr = ddTxtValueStr.split(',');
			}
		}
		if(compArr==null || compArr=='' || compArr.length==0)
		return;
		else {
		if(compArr ==undefined || compArr=="-1" || compArr.indexOf("All")>-1 || compArr.indexOf("all")>-1 || compArr.length>1) {
			if(Ext.getCmp("er_perserver")!=undefined)
				Ext.getCmp("er_perserver").show();
		}else{
			if(Ext.getCmp("er_perserver")!=undefined)
				Ext.getCmp("er_perserver").hide();
		}
		}
		}else {
			thinclientSettingsForm.findField("sh_timeinuse").hide();
			thinclientSettingsForm.findField("er_excwe").hide();
			thinclientSettingsForm.findField("er_perserver").hide();
		}
	},
	validateAndCloseSettings:function()
	{
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+strMoreOptions+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
			Ext.create('Ext.container.Container',{
				width:565,
				//padding:5,
				id:'configMod',
				//cls:'configMode_popup',
				ui:'settingsWindowContainer',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'355px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						cls:'containerHeader',
						style:{'top':'0px','margin':'0px'}
					},
					{
						xtype : 'thinclientapplicationsettings',
						parent:this
					}
				],
				renderTo:'thinclientapplication'
		});
	},
	LoadDrillDownData:function( url){
	var paramsForDrillDown = url.substring(url.indexOf("?")+1);
	var controller = url.substring(0,url.indexOf("?"));
	var resultPanelObj = Ext.getCmp('resultPanel');
	var meController = this;
	if(WVD_report)
	{
		paramsForDrillDown+="&WVD_reports=yes";
	}
	if(onlyCompTpye != undefined && onlyCompTpye != null && onlyCompTpye != 'null')
	{
		paramsForDrillDown+="&onlyCompTpye="+onlyCompTpye;
	}
	Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown,
			method :'POST',
			margin:'0 10 10 10',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(jsonData.hasOwnProperty('DrillDownData')){
					resultPanelObj.removeAll();
					var DrillDownData = jsonData['DrillDownData'];
					var columnDetails = DrillDownData['columnDetails'];
					var dataAvailable = DrillDownData['dataAvailable'];
					var dataArray = DrillDownData['dataArray'];
					if(!Ext.isEmpty(dataArray))
					{
						var tabledata = '<div class="newTable" style="padding:0px 10px 10px 10px" >'+'<table cellspacing="0" cellpadding="0" border="0" width="100%">'+'<thead>'+'<tr>';
						for( var k in columnDetails)
						{
							tabledata+='<th>'+'<div>'+columnDetails[k]+'</div>'+'</th>';
						}
						tabledata+='</tr>'+'</thead>'+'<tbody>'+'<tpl for=".">';
						for(var j in dataArray)
						{
							var realdata=dataArray[j];
							tabledata+='<tr>';
							for(var l in realdata){
								tabledata+='<td>'+'<div>'+realdata[l]+'</div>'
								+'</td>'
							}
							tabledata+='</tr>';
						}
						tabledata+='</tpl>'
						+'</tbody>'+'</table>'+'</div>';
					}
					if(dataAvailable)
					{
						resultPanelObj.add({
							xtype:'panel',
							title:DrillDownData.title,
							ui:'newGraphPanel',
							margin:'10 10 0 10',
							border:true,
							tools:[
							{
								xtype:'button',
								//text:backText,
								text:backText,
								cls:'backbutton',
								iconCls:'iconBack',
								margin:'0px 5px 0px 0px',
								id:'thiClientbckButton',
								name:'thiClientbckButton',
								listeners:{
									'click':function()
									{
										meController.submitReport();
									}
								}
							}],
							html:tabledata
						});
					}
					else
					{
						resultPanelObj.removeAll();
						resultPanelObj.add({
						xtype:'panel',
						ui:'newGraphPanel',
						tools:[
						{
							xtype:'button',
							text:backText,
							cls:'backbutton',
							listeners:{
								'click':function()
								{
									meController.submitReport();
								}
							}
						}],
						items:[
						{
							xtype:'container',
							style:
							{
								'height':'200px'
							},
							html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText"> No Measures Available</div></td></tr></table>'
						
						}]
						});
						Ext.getCmp('printTool').setDisabled(true);
						Ext.getCmp('mailTool').setDisabled(true);
					}
				}
			}
		});
	},
	expandAppln: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'),Ext.getCmp('appLabel').text,btn);
	},
	expandMeUsage:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('systemLabel').text,btn);
	},
	expandMeActivity:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		if(btn.id=='expandSelectorActivity_graph')
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server_graph'),Ext.getCmp('multiSelectLabel').text,btn);
		else
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('multiSelectLabel').text,btn);
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var publicJsonData=null;
		if(targetType == 'Application Usage')
			publicJsonData = appConstants.publicjsonDataUsage
		else
			publicJsonData = appConstants.publicjsonDataActivity;

		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}
		return value;
	}
});
