var t = 0;

function plotFlowChart(dom,flowChartData){
	var flowChartMargin = {
		top: 10,
		right: 0,
		bottom: 10,
		left: 0
	},
	flowChartWidth = 620,
	flowChartHeight = 220;

	if(dom.offsetWidth > flowChartWidth){
		flowChartWidth = dom.offsetWidth
	}

	var flowid = dom;

	var svgg = d3.select(flowid).append("svg")
		.attr("viewBox", "0 0 "+flowChartWidth+" "+flowChartHeight+"")
		.attr("preserveAspectRatio" , "xMidYMid meet")
		.attr("width", flowChartWidth + flowChartMargin.left + flowChartMargin.right)
		.attr("height", flowChartHeight + flowChartMargin.top + flowChartMargin.bottom)
		.attr("id", "flowId")
		.append("g")
		.attr("transform", "translate(" + 0 + "," + flowChartMargin.top + ")");

	var treee = d3.layout.tree()
		.separation(function(a, b) { return ((a.parent == flowChartData) && (b.parent == flowChartData)) ? 5:6.2; })
		.size([flowChartWidth, flowChartHeight-50]);

	var nodes = treee.nodes(flowChartData);
	var linkss = treee.links(nodes);

	svgg.append("svg:defs").append("svg:marker")
		.attr("id", "triangle")
		.attr("refX", function(s){
			return -10
		})
		.attr("refY", 6)
		.attr("markerWidth", 12)
		.attr("markerHeight", 12)
		.attr("markerUnits","userSpaceOnUse")
	   // .attr("orient", "auto-start-reverse")
		.attr("orient", 90)
		.append("path")
		.attr("class","markerColor")
		.attr("d", "M2,2 L2,12 L7,6 L2,1");
		  

	svgg.selectAll(".linkCls")
		.data(linkss)
		.enter().append("path")
		.attr("class", "linkCls")
		//.attr("marker-mid", function(d){
		//	return "url(#triangle)";
		//})
		.attr("stroke-width","1px")
		.attr("d", elbow);

	var nodes = svgg.selectAll(".node")
		.data(nodes)
		.enter()
		.append("svg:a")
		//.attr("xlink:href", function(d){return d.urlLink;});
		.attr("onclick", function(d){
			return d.method;
		});

	var nameSize = 8.5;
	var valSize = 12.5;

	var totalWidth = function(d){
		var valWidth = Math.round(d.value.length*valSize);
		var nameWidth = Math.round(d.name.length*nameSize);
		var tWidth = valWidth + nameWidth;
		return tWidth;
	}

	var valWidth = function(d){
		var valWidth = Math.round(d.value.length*valSize);
		return valWidth;
	}

	var nameWidth = function(d){
		var nameWidth = Math.round(d.name.length*nameSize);
		return nameWidth;
	}

	var rect = nodes.append("rect")
		.attr("class", "node")
		.attr("width", totalWidth)
		.attr("class","rectColor")
		.attr("stroke-width","1px")
		.attr("height", 38)
		.style("cursor", function(d){
			return d.handSymbol
		})
		.attr("rx", 5)
		.attr("ry", 5)
		.attr("id", function (d) {
			return d.id;
		})
		.attr("display", function (d) {
			if (d.hidden) {
				return "none"
			} else {
				return ""
			};
		})
		.attr("x", function(d){           
			var totalWidth = (nameWidth(d) +  valWidth(d));
			var dx = Math.round(d.x) - Math.round(totalWidth/2);
			return dx;
		})
		.attr("y",  function(d){
			return d.y
		});

	var gr = nodes.append("g")

	gr.append("text")
		.text(function (d) {
			return d.value;
		})
		.classed("valueText", true)
		//.classed("textAlign", true)
		.attr("x", function(d){
				return d.x - Math.round((totalWidth(d)/2)-10)
		})
		.style("cursor", function(d){
			return d.handSymbol
		})
		.attr("y",  function(d){
				return d.y + 26
		});

	gr.append("line")
		.classed("seperatorLine", true)
		.attr("stroke-width","1px")
		//.classed("textAlign", true)
		.attr("x1", function(d){  
			return d.x - Math.round((totalWidth(d)/2)-((valWidth(d)+15)))  
		})
		.style("cursor", function(d){
			return d.handSymbol
		})
		.attr("y1", function(d){
			return d.y+8
		})
		.attr("x2", function(d){
			return d.x - Math.round((totalWidth(d)/2)-((valWidth(d)+15)))  
		})
		.attr("y2",  function(d){
			return d.y+29
		})

	 gr.append("text")
		.text(function (d) {
			return d.name;
		})
		.classed("nameText", true)
		.style("cursor", function(d){
			return d.handSymbol
		})
	   // .classed("textAlignL", true)
		.attr("x", function(d){
		   //return d.x - ((nameWidth(d)/2)-((valWidth(d)+25)))
		   return d.x - Math.round((totalWidth(d)/2)-((valWidth(d))+25))
		})
	   // .call(wrap, 150)
		.attr("y",  function(d){
				return d.y + 23
		});

	function elbow(d, i) {
		if (d.target.no_parent) {
			return "M0,0L0,0";
		}

		var ydiff = d.source.y - (d.target.y);
		//0.40 defines the point from where you need the line to break out change is as per your choice.
		//var ny = d.target.y + diff * 0.35;
		var ny = d.target.y + ydiff * 0.30;
		linedata = [{
			x: Math.round(d.target.x),
			y: Math.round(d.target.y),
		}, {
			x: Math.round(d.target.x),
			y: ny
		}, {
			x: Math.round(d.source.x),
			y: Math.round(d.source.y)
		}];

		var fun = d3.svg.line()
			.x(function (d) {
				return Math.round(d.x);
			})
			.y(function (d) {
				return d.y;
			})
			.interpolate("step-after");

		return fun(linedata);
	}
}
Ext.define('UxHistoryModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'duration', type:'string' },
        { name:'Avg', type:'string' },
        { name:'Max', type:'string' },
        { name:'Sum', type:'string' },
		//{ name:'count', type:'string' },
		//{ name:'counttext', type:'string' },
		{ name:'func', type:'string' },
		{ name:'functext', type:'string' },
		//{ name:'logonstext', type:'string' }
    ]
});

Ext.define('BandWidthUsageModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'linkUrl', type:'string' },
		{ name:'changeTabView', type:'string' },
		{ name:'linkurl', type:'string' },
		{ name:'test_org', type:'string' },
		{ name:'measure_org', type:'string' },
		{ name:'handSymbol', type:'string' },
		//{ name:'sessions' },
		{ name:'DataSet' },
		{ name:'data' },
		{ name:'graphID', type:'string' }
    ]
}); 
 
 Ext.define('widgets.ChartPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.chartpanel',
	//cls:'animation_box',
	border: true,
    flex: 1,
	ui: 'eg-x-panel',
    margin: '0 1 1 0',
    bodyPadding: '0 0 0 0',
	//style:{'border':'1px solid blue'},
	id:'',
	legendPosition: 'bottom', // top,left, bottom and right
    chartType: 'area', // pie,line,column,area -  chart type
    layout: {
		type: 'vbox',
		align: 'stretch'
	},
    config: {
		data: null
    },
	showMaxMin:true,
	data:[],
	items:[],
	isOdd:false,
     constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
	addChartHistory:function(){
		var me = this,historyItems=[];
		var historyTpl = '';
		if(!me.ifUx)
		{	
				historyTpl=new Ext.XTemplate(
						'<div class="widgetholders">',
						'<tpl for=".">',
						'<tpl if="xindex % 2 === 0">',
							'<div class="b_box " style="border:0px solid red;width:50%;padding:0 0 0 0;float:left;">',
						'<tpl else>',
							'<div class="b_box " style="border:0px solid red;width:50%;padding:0 25px 0 0 !important;float:left;">',
						'</tpl>',
						  '<div class="font_normal9 fontStyleRobotRegular grayColor" style="padding:0px 0px 5px 0px"><span>{duration}</ span></div>',
							'<div style="height:65px;width:100%" class="chartminmax"><div class="ctxSerRes_m_top" style="margin-top:8px;width:48%;float:left;text-align:center">',
							'<div class="font_normal20" style="padding:7px 0 0 0">{Avg}</div><div class="font_normal11" style="margin-top:3px;">avg</div></div>',
							'<div class="grayBoxDivider" style="float:left;height:44px;width:1px;float:left;margin-top:12px;float:left"></div>',
							'<div class="ctxSerRes_m_top" style="margin-top:8px;width:48%;float:right;text-align:center"><div class="font_normal20" style="padding:7px 0 0 0">{Max}</div><div class="font_normal11" style="margin-top:3px;">max</div></div></div>',
						'</div>',
					'</tpl>',
					'</div>'			
				);
		 }else{
				historyTpl=new Ext.XTemplate(
					'<div class="widgetholders">',
						'<tpl for=".">',
							'<tpl if="xindex % 2 === 0">',
								'<div class="b_box " style="border:0px solid red;width:50%;padding:0 0 0 0;float:left;">',
							'<tpl else>',
								'<div class="b_box " style="border:0px solid blue;width:50%;padding:0 25 0 0 !important;float:left;">',
							'</tpl>',
							 // '<div class="font_normal9 fontStyleRobotRegular grayColor"><span>{duration}</ span></div>',
							  '<div class="font_normal9 fontStyleRobotRegular grayColor" style="padding:0px 0px 5px 0px"><span>{duration}</ span></div>',
								'<tpl if="func != &quot;-&quot;">',
									'<div style="height:65px;width:100%" class="chartminmax">',
										'<div class="ctx_m_top" style="width:49%;float:left;text-align:center;padding-top:10px" ><div class="font_normal23">{func}</div>',
											'<div class="crl">',
										'</div>',
										'<div class="font_normal12"style="margin-top:-4px">{functext}</div></div>',
										'<div class="chartLegendDivider" style="width:1px;float:left;margin-top:12px"></div>',
										'<div style="width:49%;float:left;">',
											'<div style="margin:4px auto;display:table">',
												'<div class="font_normal20" style="padding:3px 0 0 0">{Avg}<span class="font_normal11 d_m_l5">avg</span></div>',
												'<div class="crl"></div>',
												'<div class="font_normal20" style="padding:0px 0 0 0">{Max}<span class="font_normal11 d_m_l5">max</span></div>',
											'</div>',
											'</div>',
										'</div>',
									'<tpl else>',
										'<div style="height:65px;width:100%" class="chartminmax">',
											'<div class="font_normal23" style="margin:7px auto;width:25px">{count}</div>',
										'</div>',
									'</tpl>',
								'</div>',
						'</tpl>',
					'</div>'
				);
		 }
		if(!Ext.isEmpty(me.data) && !Ext.isEmpty(me.data.maxmin))
		 {
			me.data.maxmin.map(function(data){
				Object.keys(data).map(function(key){
					if(typeof data[key] == 'string' && data[key].toUpperCase() == 'NAN')
						data[key] = "0";
				})
			})
			var historyContainer = {
				xtype:'dataview',
				border:false,
				id:me.id+"_history_grid_id",
				store: Ext.create('Ext.data.Store', {
					id:me.id+"_history_store_id",
					model: 'UxHistoryModel',
					autoLoad:true,
					data:me.data.maxmin
				}),
				tpl:historyTpl
			};
			return historyContainer;
		 }
	 },
	 addgridview:function(){
		var me = this;

		var isAllerts = false;
		if(me.isAlerts != undefined && me.isAlerts != null && me.isAlerts)
			isAllerts = true;
		
		var isBrro = false;
		if(me.ifBro != undefined && me.ifBro != null && me.ifBro)
			isBrro = true;
		
		var heigth = 181;
		var emptyTextHeight = 175;
		var ifLLogOn = false;
		var paddingh = '0px';
		var marginVal = '0 15 15 15';
		var paddingVal = '0 5 5 5';

		if(me.ifLogOn != undefined && me.ifLogOn != null && me.ifLogOn){
			ifLLogOn = true;
			heigth = 210;
			emptyTextHeight=190;
			marginVal = '0 15 0 15';
			paddingVal = '0 5 0 5';
		}
		if(isBrro)
		{
			marginVal = 0;
			paddingVal = 0;
			emptyTextHeight = 190;
		}
		var gridPanel = new Ext.Panel (
			{
				xtype:'dataview',
				padding:paddingVal,
				layout:'fit',
				height:emptyTextHeight,
				items:[{
					xtype:'container',
					layout:'fit',					
					items:[
						{
							xtype:'commongrid',
							id:me.id+'_Grid',
							alignR:true,
							data:me.data,
							border:true,
							frame:false,
							layout:'fit',
							scroll:false,
							//width:'100%',
							autoScroll:true,
							iSAlerts:isAllerts,
							iSLogon:ifLLogOn,
							iSBrro:isBrro,
							margin:marginVal,
							height:heigth
						}	
					]
					
				}]
			}
		 );
		 //t++;
		 return gridPanel;
	 },
	 addpieview:function(){
		var me = this;
		var AlertsTpl = '';
		var strSkinclr = ( strSkin == 'Dark' )?'#6a6a6a':'#cdcdcd';
		if(me.ifUx)
		 {	
			AlertsTpl = new Ext.XTemplate(
				'<tpl for=".">',
				'<div class="widgetholders {handSymbol}" style="border:0px solid red">',
					'<div class="b_box1">',
					  '<div class="font_bold14"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',
						 //'<div  style="text-align:center;width:60px;height:60px;float:left" id="establishedsession-graph"></div>',
						 '<div  style="border:0px solid red;text-align:center;width:200px;margin:auto;height:188px;" id="'+me.id+'_bgDonut"></div>',
						 '</div>',
						'<div class="sessions_legends" style="margin-top:15px !important">',
						'<table style="margin:auto;width:50%"><tr>',
						'<tpl for="DataSet">',
							'<tpl for="data">',
							 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
								'<td class="{handSymbol}" onclick=\"loadView(\'{changeTabView}\',\'{linkUrl}\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\');\" style="padding:8px;text-align:center"><div style="margin-left: 15px;" class="font_normal25">{value}</div><div class="crl"></div><div style="margin:auto;display:inline"><div style="display:table-cell;margin-top:-8px;margin-right:5px;color:{colorCode}"><h3 style="position:relative;top:-2px">.</h3></div><div  style="display:table-cell;" class="font_normal12">{text}</div></div></td><td class="font_normal11"></td>',
							 '</tpl>',
							'</tpl>',
						'</tpl>',
						'</tr></table>',
						'</div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
		 }
		 else if(me.ifLogOn)
		 {
			AlertsTpl = new Ext.XTemplate(
				'<tpl for=".">',
				'<div class="widgetholders">',
					'<div class="b_box1" style="margin:auto;display:flex">',
					  '<div class="font_bold14"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',
						 //'<div  style="text-align:center;width:60px;height:60px;float:left" id="establishedsession-graph"></div>',
						 '<div  style="border:0px solid blue;margin-left: 20px;margin-top:0px;text-align:center;width:220px;height:200px;margin:auto auto" id="'+me.id+'_bgDonut"></div>',
						 //'</div>',
						'<div style="height:200px;border:0px solid red;display:flex;overflow:auto;margin:auto auto auto 0px">',
							'<div style="display:flex;flex-direction:column;margin:auto auto auto 0px">',
							'<tpl for="DataSet">',
								'<tpl for="data">',
								 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
										'<div onclick=\"loadView(\'{changeTabView}\',\'{linkUrl}\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\');\" style="padding:0px 0px 9px 0px !important;"><div style="display:table-cell;margin-top:-10px;margin-right:5px;color:{colorCode}"><h3 style="position:relative;top:-2px;width:11px">.</h3></div><div  style="display:table-cell;" class="font_normal11"><div class="widgetholders {handSymbol}">{text}&nbsp;({value})</div></div></div></td><td class="font_normal11">',
								 '</tpl>',
								'</tpl>',
							'</tpl>',
							'</div>',
						'</div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
		 }
		 else
		 {
			AlertsTpl = new Ext.XTemplate(
				'<tpl for=".">',
				//'<div class="widgetholders {handSymbol}" style="margin-top:15px;border:0px solid blue !important">',				
				'<div class="widgetholders" style="margin-top:5px;border:0px solid blue !important">',				
					'<div class="b_box1" style="margin:auto;width:525px">',
					  '<div class="font_bold14"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span></ span></div>',
						 //'<div  style="text-align:center;width:60px;height:60px;float:left" id="establishedsession-graph"></div>',
						 '<div  style="border:0px solid blue;margin-top:-12px;text-align:center;width:200px;height:170px;float:left" id="'+me.id+'_bgDonut"></div>',
						 //'</div>',
						'<div class="sessions_legends" style="float:left;margin-top:45px !important">',
						'<table style="margin-right:0px;width:300px;"><tr>',
						'<tpl for="DataSet">',
							'<tpl for="data">',
							 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
								'<td style="padding:8px;text-align:center"><div class="widgetholders {handSymbol}" onclick=\"loadView(\'{changeTabView}\',\'{linkUrl}\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\');\"><div class="font_normal25">{value}</div><div class="crl"></div><div style="margin:auto;display:inline"><div style="display:table-cell;margin-top:-8px;margin-right:5px;color:{colorCode}"><h3 style="position:relative;top:-2px;margin-left:0px !important">.</h3></div><div  style="display:table-cell;" class="font_normal12">{text}</div></div></td><td class="font_normal11"><div></td>',
							 '</tpl>',
							'</tpl>',
						'</tpl>',
						'</tr></table>',
						'</div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
		 }
		var pieContainer =
		{
			xtype:'dataview',
			padding:5,
			layout:{type:'vbox',pack:'center'},
			tpl: AlertsTpl,
			listeners:{
				viewready:function(){
					$('#'+me.id+"_bgDonut").highcharts(me.chartConfig(me.data,me.chartType));
				}
			},
			store: Ext.create('Ext.data.Store', {
				id:'BandWidthUsageModel_model_id',
				model: 'BandWidthUsageModel',
				autoLoad:true,
				data:me.data				
			}),			
		};
		return pieContainer;
	 },
	 addGraphtextPanel:function(obj,id,a,removewidclass){
		 
		var panelCls='separator_measure';
		if (a==0)
		{
			panelCls='';
		}
		var dafault_colr='#35c8c2';
		if(obj.colorValue != undefined)
			dafault_colr = obj.colorValue; 
		
		var graphtextclass = 'widgetcon_line font_bold12';
		if(!Ext.isEmpty(removewidclass) && removewidclass)
			graphtextclass = 'font_bold12';

		var container = {
			xtype:'panel',
			baseCls:'panelHeader',
			margin:'0 0 0 0',
			bodyPadding:'13 0 0 0',
			autoScroll:true,
			flex:0.7,
			minWidth:165,
			items:[
				{
					xtype:'graphtext',
					cls:graphtextclass,
					data:obj,
					id:id,
					num:id,
				}
			],
		};

		return container;
	 },
	 initComponent: function() {
		var me = this;

		 me.mon(me, 'boxready', me.loadChart, me);
			
		if(me.data.showMaxMin)
		{
			 var pRight=""; /*-----panel margin right in maxmin*/
			 var pLeft=""; /*-----panel margin left in maxmin*/
			 var pTop=""; /*-----panel margin top in maxmin*/
			 var marginVal = "0 0 0 0";/*-----panel margin top in maxmin*/
			 //var bor="0px";
			
			if (me.isOdd==true)
			{
				pRight="20px";
				//bor = "1px"
			}
			if (me.isOdd==false)
			{
				pLeft="20px";
				//bor = "4px"
			}
			if(me.indexVal != undefined && me.indexVal != null && (me.indexVal == 0 || me.indexVal == 1))
			{
				pTop ="0px";
				//marginVal = "0 0 0 0"
			}
			else
			{
				pTop ="0px";
				//marginVal = "0 0 0 0"
			}
			if(me.ifUx)	
				me.style ={'padding':'20px 20px 20px 20px'};
			else
				me.style ={'box-shadow':'none !important','border':'0px solid green !important','margin':marginVal+' !important','padding-bottom':''+pTop+'','padding-right':''+pRight+'','padding-left':''+pLeft+''};
			
			var chartholderHeight = 195;
			if(me.isSAP){
				chartholderHeight=175;
			}
			me.items =[
				me.addChartHistory(),
				{
					xtype:'container',
					cls:'chartholder',
					padding:'10 0 0 0',
					id:me.id+"_inner",
					//height:chartholderHeight-15,/*V*/
					height:chartholderHeight,/*V*/
					layout:{
						type:'vbox',
						align:'stretch'
					},
				}
			]
		}
		else if(me.ifBro != undefined && me.ifBro != null && me.ifBro)
	    {
			var pRight="0px"; /*-----panel margin right in maxmin*/
			var pLeft="0px"; /*-----panel margin left in maxmin*/
			var pTop="0px"; /*-----panel margin top in maxmin*/
			var marginVal = "0 0 0 0";/*-----panel margin top in maxmin*/
			//var bor="0px";
			
			if(me.chartType == "GroupGrid")
			{
				pLeft = "0px";
				pRight = "5px";
				marginVal = "0 5 0 0";
				if(me.indexVal == 1)
					marginVal = "0 0 0 5";

			}

			if(me.indexVal != undefined && me.indexVal != null && (me.indexVal == 0 || me.indexVal == 1 || me.indexVal == 2))
			{
				pTop ="0px";
				marginVal = "0 0 0 0"
			}
			else
			{
				pTop ="10px";
				marginVal = "0 0 0 0"
			}
			if(me.ifUx)	
				me.style ={'padding':'20px 20px 20px 20px'};
			else
			{
				me.style ={'box-shadow':'none !important','border':'0px solid green !important','margin':marginVal+' !important','padding-top':''+pTop+'','padding-right':''+pRight+'','padding-left':''+pLeft+''};
			}
	    }
		
		if(me.chartType != undefined && me.chartType != null && me.chartType == "donut"){
			var nameObjT = me.data.heading;
			if(nameObjT != undefined && nameObjT != null && (nameObjT.indexOf("(") != -1 && nameObjT.indexOf(")") != -1))
			{
				var tempnameObjT = '';
				tempnameObjT = nameObjT.substring(nameObjT.indexOf("("),nameObjT.indexOf(")")+1);
				nameObjT = nameObjT.replace(tempnameObjT,"<span class='font_normal12 fontStyleRobotRegular'>"+tempnameObjT+"</span>")
			}
			me.title=nameObjT;
			if(me.ifUx)
				me.padding="20px 20px 20px 20px";
			else
				me.padding="0px 0px 0px 0px";
			me.items =[
				me.addpieview()
			]
		}
		
		if(me.chartType != undefined && me.chartType != null && (me.chartType == "grid" || me.chartType == "TopNGrid" || me.chartType == "GroupGrid")){
			//me.title=me.title;
			me.items = [
				me.addgridview()
			]
		}
		if(me.chartType != undefined && me.chartType != null && me.chartType == "GraphText")
		{
			var nameObjT = me.data.heading;
			if(nameObjT != undefined && nameObjT != null && (nameObjT.indexOf("(") != -1 && nameObjT.indexOf(")") != -1))
			{
				var tempnameObjT = '';
				tempnameObjT = nameObjT.substring(nameObjT.indexOf("("),nameObjT.indexOf(")")+1);
				nameObjT = nameObjT.replace(tempnameObjT,"<span class='font_normal12 fontStyleRobotRegular'>"+tempnameObjT+"</span>")
			}
			me.title=nameObjT;
			var me = this;
			var sparkData = me.data;
			var removeWid = false;
			var chartTyppe = sparkData['chart'];
			if(chartTyppe != undefined && chartTyppe != null && chartTyppe == "GraphText"){
				var chartData = sparkData.data;
				var itemsArray = [];
				for(var a in chartData){
					var chartDatatype = chartData[a]['chart'];
					if(chartDatatype != undefined && chartDatatype != null && chartDatatype == "GraphText"){
						var id=chartDatatype+'_GraphText_'+a;
						if(a == (chartData.length - 1))
							removeWid = true;
						var graphtextPanel = me.addGraphtextPanel(chartData[a],id,a,removeWid);
						itemsArray.push(graphtextPanel);						
					}					
				}
				var panelContainer = {
					xtype:'container',
					height:235,
					layout: {
						 type: 'hbox',
						align: 'stretch'
					 },
					items:itemsArray,					
				};
				me.items=panelContainer;
			}
		}

		me.callParent(arguments);
		me.mon(me, 'resize', me.resizePanel, me);
		me.mon(me, 'removed', me.destroyChart, me);		
	},
     updateChart: function(el,data,chartType) {
		 var me = this;
		 if(data.showMaxMin)
		 {
			if(data.maxmin!=null && data.maxmin!=undefined)
			 {
				me.items.items[0].store.loadRawData(data.maxmin);
			 }

			 try
			 {
				 var error = data.DataSet[0].data[0];	
				 if(error.hasOwnProperty("Error") && !Ext.isEmpty(error.Error)){
					Ext.getCmp(me.id+"_inner").update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+error.Error+'</div></div></div>');
				}
				else
				{
					$('#'+me.id+"_inner").highcharts(me.chartConfig(data,chartType));
					$('#'+me.id+'-body').width('100%');					
				}				
			 }
			 catch (er)
			 {
				 Ext.getCmp(me.id+"_inner").update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data Found!</div></div></div>');
			}
		}
		 else if(data.chartType == 'GraphText')
		 {
			try
			{
				var chartData = data.data;
				for(var a in chartData){
					var chartDatatype = chartData[a]['chart'];
					if(chartDatatype != undefined && chartDatatype != null && chartDatatype == "GraphText"){
						var id=chartDatatype+'_GraphText_'+a;
						var graphtextComp = Ext.getCmp(id);
						graphtextComp.updateData(chartData[a]);
					}
				}
			}
			catch (ec)
			{
			}

		 }
		 else if(data.chartType == 'grid' || data.chartType == "TopNGrid" || data.chartType == "GroupGrid")
		 {	
			try{
			if(data!=null && data!=undefined)
			 {
				Ext.getCmp(me.id+'_Grid').data = data;
				Ext.getCmp(me.id+'_Grid').loadData(data);
			 }
			}catch(rt){
			}
		 }
		 else if(data.chartType == 'donut')
		 {
			 if(data!=null && data!=undefined)
			 {
				me.items.items[0].store.loadRawData(data);
			 }
			 try
			 {
				$('#'+me.id+"_bgDonut").highcharts(me.chartConfig(data,data.chartType));
			 }
			 catch (et)
			 {
			 }

		 }
		 else if(data.hasOwnProperty("type") && data.type == "groupText")
		 {
			var dataArray = data.groupArr;
			for(var t=0;t<dataArray.length;t++)
			{
				if(!Ext.isEmpty(dataArray[t].changeTabView))
					dataArray[t]["handSymbol"] = "pointer";
				else
					dataArray[t]["handSymbol"] = "default";
			}
			
			// Flow chart d3-design start here...

			var flowChartData = {
				name: dataArray[0].footer,
				value: dataArray[0].value,
				handSymbol: dataArray[0]["handSymbol"],
				method:"loadView('"+dataArray[0].changeTabView+"','','','"+dataArray[0].test_org+"','"+dataArray[0].measure_org+"','"+dataArray[0].linkurl+"');",
				children: [{
					name: dataArray[1].footer,
					value:dataArray[1].value,
					handSymbol: dataArray[1]["handSymbol"],
					method:"loadView('"+dataArray[1].changeTabView+"','','','"+dataArray[1].test_org+"','"+dataArray[1].measure_org+"','"+dataArray[1].linkurl+"');",
					children: [{
						name: dataArray[4].footer,
						handSymbol: dataArray[4]["handSymbol"],
						method:"loadView('"+dataArray[4].changeTabView+"','','','"+dataArray[4].test_org+"','"+dataArray[4].measure_org+"','"+dataArray[4].linkurl+"');",
						value:dataArray[4].value,
						id: 12,
			
					},{
						name: dataArray[5].footer,
						handSymbol: dataArray[5]["handSymbol"],
						method:"loadView('"+dataArray[5].changeTabView+"','','','"+dataArray[5].test_org+"','"+dataArray[5].measure_org+"','"+dataArray[5].linkurl+"');",
						value:dataArray[5].value,
						id: 3
					}]
				}, {
					name: dataArray[2].footer,
					handSymbol: dataArray[2]["handSymbol"],
					method:"loadView('"+dataArray[2].changeTabView+"','','','"+dataArray[2].test_org+"','"+dataArray[2].measure_org+"','"+dataArray[2].linkurl+"');",
					value:dataArray[2].value,
					id: 10,
				},{
					name: dataArray[3].footer,
					handSymbol: dataArray[3]["handSymbol"],
					method:"loadView('"+dataArray[3].changeTabView+"','','','"+dataArray[3].test_org+"','"+dataArray[3].measure_org+"','"+dataArray[3].linkurl+"');",
					value:dataArray[3].value,
					id: 10,
				}]
			}
			
			Ext.getCmp(me.id).removeAll(true);
			Ext.getCmp(me.id).add([{
					xtype:'container',
					id:'d3flowChart',
					scroll:true,
					autoScroll:true,
					flex:1,
					layout:'fit',
					listeners:{
						'resize':function(){
							var me = this;
							$("#flowId").remove();
							me.removeAll(true);
							plotFlowChart(me.el.dom,flowChartData);
						}
					}
			}]);
			Ext.getCmp(me.id).setTitle("Hosts by Status");
			//Ext.getCmp(me.id).update(htmlText);
			//Ext.getCmp(me.id).update(flowchartContainer);
		 }
		 else
		 {
			try
			{
				var error = data.DataSet[0].data[0];
				if(error.hasOwnProperty("Error") && !Ext.isEmpty(error.Error))
					Ext.getCmp(me.id).update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+error.Error+'</div></div></div>');
				else{
					$('#' + me.body.id).highcharts(me.chartConfig(data,data.chartType));
				}
			}
			catch(ert)
			{
				Ext.getCmp(me.id).update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data Found!</div></div></div>');
			}
		}
		me.doLayout();
		me.doComponentLayout();
     },
	 destroyChart:function(){
		 try
		 {
			var me = this,chartObj = $('#'+me.body.id).highcharts();
			if(!Ext.isEmpty(chartObj)){
				chartObj.destroy();
			}	
		 }
		 catch (e)
		 {
		 }		
	 },
	 resizePanel:function(){
		var me = this,chartObj = $('#' + me.body.id).highcharts();
		if(!Ext.isEmpty(chartObj)){
			chartObj.reflow();
		}
	 },
     loadChart: function() {
        var me = this;
		if(me.data.showMaxMin == undefined || me.data.showMaxMin == null)
			me.data.showMaxMin = false;
		if(me.data.showMaxMin)
		 {
			try
			{
				var error = me.data.DataSet[0].data[0];
				if(error.hasOwnProperty("Error") && !Ext.isEmpty(error.Error))
				{
					Ext.getCmp(me.id+"_inner").update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+error.Error+'</div></div></div>');
				}
				else
				{
					$('#'+me.id+"_inner").highcharts(me.chartConfig(me.data,me.chartType));
				}
			}
			catch (er)
			{
				Ext.getCmp(me.id+"_inner").update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data Found!</div></div></div>');
			}
		 }
		 else if(me.chartType == 'GraphText')
		 {}
		 else if(me.chartType == 'grid' || me.chartType == "TopNGrid" || me.chartType == "GroupGrid")
		 {}
		 else if(me.chartType == 'donut')
		 {}
		 else if(me.data.hasOwnProperty("type") && me.data.type == "groupText")
		 {			 
			var dataArray = me.data.groupArr;
			for(var t=0;t<dataArray.length;t++)
			{
				if(!Ext.isEmpty(dataArray[t].changeTabView))
					dataArray[t]["handSymbol"] = "pointer";
				else
					dataArray[t]["handSymbol"] = "default";
			}
			
			// Flow chart d3-design start here...

			var flowChartData = {
				name: dataArray[0].footer,
				value: dataArray[0].value,
				handSymbol: dataArray[0]["handSymbol"],
				method:"loadView('"+dataArray[0].changeTabView+"','','','"+dataArray[0].test_org+"','"+dataArray[0].measure_org+"','"+dataArray[0].linkurl+"');",
				children: [{
					name: dataArray[1].footer,
					value:dataArray[1].value,
					handSymbol: dataArray[1]["handSymbol"],
					method:"loadView('"+dataArray[1].changeTabView+"','','','"+dataArray[1].test_org+"','"+dataArray[1].measure_org+"','"+dataArray[1].linkurl+"');",
					children: [{
						name: dataArray[4].footer,
						handSymbol: dataArray[4]["handSymbol"],
						method:"loadView('"+dataArray[4].changeTabView+"','','','"+dataArray[4].test_org+"','"+dataArray[4].measure_org+"','"+dataArray[4].linkurl+"');",
						value:dataArray[4].value,
						id: 12,
			
					},{
						name: dataArray[5].footer,
						handSymbol: dataArray[5]["handSymbol"],
						method:"loadView('"+dataArray[5].changeTabView+"','','','"+dataArray[5].test_org+"','"+dataArray[5].measure_org+"','"+dataArray[5].linkurl+"');",
						value:dataArray[5].value,
						id: 3
					}]
				}, {
					name: dataArray[2].footer,
					handSymbol: dataArray[2]["handSymbol"],
					method:"loadView('"+dataArray[2].changeTabView+"','','','"+dataArray[2].test_org+"','"+dataArray[2].measure_org+"','"+dataArray[2].linkurl+"');",
					value:dataArray[2].value,
					id: 10,
				},{
					name: dataArray[3].footer,
					handSymbol: dataArray[3]["handSymbol"],
					method:"loadView('"+dataArray[3].changeTabView+"','','','"+dataArray[3].test_org+"','"+dataArray[3].measure_org+"','"+dataArray[3].linkurl+"');",
					value:dataArray[3].value,
					id: 10,
				}]
			}
			
			Ext.getCmp(me.id).removeAll(true);
			Ext.getCmp(me.id).add([{
					xtype:'container',
					id:'d3flowChart',
					scroll:true,
					autoScroll:true,
					flex:1,
					layout:'fit',
					listeners:{
						'resize':function(){
							var me = this;
							$("#flowId").remove();
							me.removeAll(true);
							plotFlowChart(me.el.dom,flowChartData);
					}
				}
			}]);



			Ext.getCmp(me.id).setTitle("Hosts by Status");
			//Ext.getCmp(me.id).update(htmlText);
			//Ext.getCmp(me.id).update(flowchartContainer);
		 }
		 else
		 {
			try
			{
				var error = me.data.DataSet[0].data[0];
				if(error.hasOwnProperty("Error") && !Ext.isEmpty(error.Error))
					Ext.getCmp(me.id).update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+error.Error+'</div></div></div>');
				else{
					$('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType));
				}
			}
			catch(ert)
			{
				Ext.getCmp(me.id).update('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data Found!</div></div></div>');
			}
		 }
		me.doLayout();
		me.doComponentLayout();
	},

     chartLegendAlignment: function(obj) {
         var me = this,
				alignment, 
				verticalAlign = me.legendPosition;
         switch (verticalAlign) {
             case "top":
                 alignment = "center";
                 verticalAlign = "top";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "bottom":
                 alignment = "center";
                 verticalAlign = "bottom";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "left":
                 alignment = "left";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });

                 break;
             case "right":
                 alignment = "right";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });
                 break;
         }

     },
	chartConfig: function(data,chartType)
	{
		var me = this;
		//chartType = me.chartType;
		var jsonData = null;

		if(chartType == "Bar")
		{
			try{
				var barChart = {};
				if(!Ext.isEmpty(me.body) || !Ext.isEmpty(me.body.id))
					barChart = jQuery.extend(true, {}, createBarforCtx(me.body.id,null,null), barChart);
				else					
					barChart = jQuery.extend(true, {}, createBarforCtx(me.id,null,null), barChart);
				
				if(data.hasOwnProperty("yAxisLabel") && data["yAxisLabel"].indexOf("%") > -1)
					data["MaxValue"] = 99;

				if(data.hasOwnProperty("yAxisLabel") && data["yAxisLabel"].toLowerCase().indexOf("mbps") > -1)
				{
					var dataObject = data.DataSet[0].data;
					var maxValue = 0;
					for(var a=0;a<dataObject.length;a++)
					{
						if(maxValue < dataObject[a].y)
							maxValue = dataObject[a].y;
					}
					if(maxValue > 0)
					{
						if(maxValue > 1)
							data["MaxValue"] = maxValue;
						else
							data["MaxValue"] = 1;
					}

					//data['tick'] = false;
				}

				barChart.setData(data,'','','bar');
				jsonData = barChart.highchart;
			}catch(eo){
			}
		}else if(chartType == "donut"){
			try
			{
				var pieChart = {};
				var dontCheck = true;
				if (me.ifLogOn)
				{
					dontCheck = false;
					data['outersize']='110%';
					data['innersize']='47%';
					data['setTitle']=true;
					data['useHtml']=true;
				}
				else
				{
					dontCheck = false;
					data['outersize']='115%';
					data['innersize']='30%';
					data['borderWidth']='0'
				}

				if(me.ifUx)
					data['innersize']='30%';
				else if(dontCheck)
					 data['innersize']='42%';

				pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,null,null), pieChart);
				pieChart.setData(data,'','','bgdonut');
				jsonData = pieChart.highchart;
			}
			catch (er)
			{
			}
		}
		else if(chartType == "combinationchart"){
			try
			{
				data['tick']=false;
				data['isStateBar']=false;
				data['ifLogonDashboard']=true;
				var combinationChart = {};							
				combinationChart = jQuery.extend(true, {}, getCombinationChartforCitrixDashboard(data,null,null), combinationChart);
				combinationChart.setData(data,mgrDateFormat,'','','right');
				jsonData = combinationChart.highchart;
			}
			catch (er)
			{
			}

		}
		else if(chartType == "StackedColumn"){
			try
			{
				data['isStateBar']=false;
				data['isStackingNeeded']=false;
				data['isStackedColumnLeg']=true;
				data['showLegend']=true;
				data['labelsNeeded']=true;
				data['ignoreHiddenSeriesFlag']=false;
				data['tick']=true;
				data['showYaxis']=true;
				data['ifLogonDashboard']=true;
				var barChart = {};							
				barChart = jQuery.extend(true, {}, createBar1(this.id,null,null), barChart);
				barChart.setData(data,mgrDateFormat,'','stackedColumn');
				jsonData = barChart.highchart;
			}
			catch (er)
			{
			}
		}
		return jsonData;
	}    
 });
 