DROP TABLE ODBFileActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBFileActTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR(128) NOT NULL,
	Operation_Count		VARCHAR(128) NOT NULL,
	User_ID			VARCHAR(128) NOT NULL,
	Client_IP		VARCHAR(128) NOT NULL,
	Site_GUID		VARCHAR(128) NOT NULL,
	Site_URL		VARCHAR(128) NOT NULL,
	Item_Type		VARCHAR(128) NOT NULL,
	Destination_URL		VARCHAR(128) NOT NULL,
	User_Agent		VARCHAR(128) NOT NULL,
	Number_of_operations	VARCHAR(128) NOT NULL,
	Operations_performed	VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBFileActTest_DDD ADD CONSTRAINT PK_ODBFileActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBFileActTest_DDD ON ODBFileActTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ODBFolderActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBFolderActTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR(128) NOT NULL,
	Operation_Count		VARCHAR(128) NOT NULL,
	User_ID			VARCHAR(128) NOT NULL,
	Client_IP		VARCHAR(128) NOT NULL,
	Site_GUID		VARCHAR(128) NOT NULL,
	Site_URL		VARCHAR(128) NOT NULL,
	Item_Type		VARCHAR(128) NOT NULL,
	Destination_URL		VARCHAR(128) NOT NULL,
	User_Agent		VARCHAR(128) NOT NULL,
	Number_of_operations	VARCHAR(128) NOT NULL,
	Operations_performed	VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBFolderActTest_DDD ADD CONSTRAINT PK_ODBFolderActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBFolderActTest_DDD ON ODBFolderActTest_DDD
(
 	MSMT_TIME
);


DROP TABLE ODBFileInteractnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBFileInteractnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat		        VARCHAR(128) NOT NULL,
	Usr_Name		VARCHAR(128) NOT NULL,
	Tot_FCnt		VARCHAR(128) NOT NULL,
	Vwd_r_Edtd_FCnt		VARCHAR(128) NOT NULL,
	Syncd_FCnt		VARCHAR(128) NOT NULL,
	Shard_Intrn_FCnt	VARCHAR(128) NOT NULL,
	Shard_Extrn_FCnt	VARCHAR(128) NOT NULL,
	Asgnd_Prdcts		VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBFileInteractnTest_DDD ADD CONSTRAINT PK_ODBFileInteractnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBFileInteractnTest_DDD ON ODBFileInteractnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ODBFileUsageTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBFileUsageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat		        VARCHAR(128) NOT NULL,
	St_url			VARCHAR(128) NOT NULL,
	Ownr_Name		VARCHAR(128) NOT NULL,
	Tot_Files		VARCHAR(128) NOT NULL,
	Actv_Files		VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBFileUsageTest_DDD ADD CONSTRAINT PK_ODBFileUsageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBFileUsageTest_DDD ON ODBFileUsageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ODBSAdminActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBSAdminActTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR(128) NOT NULL,
	Operation_Count		VARCHAR(128) NOT NULL,
	User_ID			VARCHAR(128) NOT NULL,
	Client_IP		VARCHAR(128) NOT NULL,
	Site_GUID		VARCHAR(128) NOT NULL,
	Site_URL		VARCHAR(128) NOT NULL,
	Item_Type		VARCHAR(128) NOT NULL,
	Destination_URL		VARCHAR(128) NOT NULL,
	User_Agent		VARCHAR(128) NOT NULL,
	Number_of_operations	VARCHAR(128) NOT NULL,
	Operations_performed	VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBSAdminActTest_DDD ADD CONSTRAINT PK_ODBSAdminActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBSAdminActTest_DDD ON ODBSAdminActTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ODBSharngActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBSharngActTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR(128) NOT NULL,
	Operation_Count		VARCHAR(128) NOT NULL,
	User_ID			VARCHAR(128) NOT NULL,
	Client_IP		VARCHAR(128) NOT NULL,
	Site_GUID		VARCHAR(128) NOT NULL,
	Site_URL		VARCHAR(128) NOT NULL,
	Item_Type		VARCHAR(128) NOT NULL,
	Destination_URL		VARCHAR(128) NOT NULL,
	User_Agent		VARCHAR(128) NOT NULL,
	Number_of_operations	VARCHAR(128) NOT NULL,
	Operations_performed	VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBSharngActTest_DDD ADD CONSTRAINT PK_ODBSharngActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBSharngActTest_DDD ON ODBSharngActTest_DDD
(
 	MSMT_TIME
);


DROP TABLE ODBSyncActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBSyncActTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR(128) NOT NULL,
	Operation_Count		VARCHAR(128) NOT NULL,
	User_ID			VARCHAR(128) NOT NULL,
	Client_IP		VARCHAR(128) NOT NULL,
	Site_GUID		VARCHAR(128) NOT NULL,
	Site_URL		VARCHAR(128) NOT NULL,
	Item_Type		VARCHAR(128) NOT NULL,
	Destination_URL		VARCHAR(128) NOT NULL,
	User_Agent		VARCHAR(128) NOT NULL,
	Number_of_operations	VARCHAR(128) NOT NULL,
	Operations_performed	VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBSyncActTest_DDD ADD CONSTRAINT PK_ODBSyncActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBSyncActTest_DDD ON ODBSyncActTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ODBSiteUsageTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBSiteUsageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat			VARCHAR(128) NOT NULL,
	St_url			VARCHAR(128) NOT NULL,
	Ownr_Name		VARCHAR(128) NOT NULL,
	Tot_Files		VARCHAR(128) NOT NULL,
	Actv_Files		VARCHAR(128) NOT NULL,
	Strge_usd		VARCHAR(128) NOT NULL,
	Strg_alctd		VARCHAR(128) NOT NULL,
	Orphnd_sites		VARCHAR(256) NOT NULL
);
ALTER TABLE  ODBSiteUsageTest_DDD ADD CONSTRAINT PK_ODBSiteUsageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBSiteUsageTest_DDD ON ODBSiteUsageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ODBSrvcHlhTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBSrvcHlhTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Incident_Id		VARCHAR(128) NOT NULL,
	Title			VARCHAR(128) NOT NULL,
	Affected_Tenant_Count	VARCHAR(128) NOT NULL,
	Srvce_Nme		VARCHAR(128) NOT NULL,
	Start_Tme	        VARCHAR(128) NOT NULL,
	End_Tme 	        VARCHAR(128) NOT NULL,
	Lst_Updtd		VARCHAR(128) NOT NULL,
	Messge			VARCHAR(2000) NOT NULL,
	Feature_Nme		VARCHAR(128) NOT NULL
);
ALTER TABLE  ODBSrvcHlhTest_DDD ADD CONSTRAINT PK_ODBSrvcHlhTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBSrvcHlhTest_DDD ON ODBSrvcHlhTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ODBMsgCenTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ODBMsgCenTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Msgs_ID		        VARCHAR(128) NOT NULL,
	Act_by		        VARCHAR(128) NOT NULL,
	Msg_title		VARCHAR(128) NOT NULL,
	Msgs		        VARCHAR(2000) NOT NULL,
	Published               VARCHAR(128) NOT NULL,
	Actn_DT		        VARCHAR(128) NOT NULL,
	Actn_Typ		VARCHAR(128) NOT NULL,
        Extnl_Link		VARCHAR(2000) NOT NULL,
	Urgency_Lvl             VARCHAR(2000) NOT NULL
);
ALTER TABLE  ODBMsgCenTest_DDD ADD CONSTRAINT PK_ODBMsgCenTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ODBMsgCenTest_DDD ON ODBMsgCenTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SPOSitUsageSumTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SPOSitUsageSumTest_DDD
(	
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	ReportRefreshDat	VARCHAR2(256) NOT NULL,
	SiteURL			VARCHAR2(256) NOT NULL,
	OwnerDisplayName	VARCHAR2(256) NOT NULL,
	IsDeleted		VARCHAR2(256) NOT NULL,
	LastActivityDat 	VARCHAR2(256) NOT NULL,
	FileCount	        VARCHAR2(256) NOT NULL,
	ActiveFileCount		VARCHAR2(256) NOT NULL,
	PageViewCount		VARCHAR2(256) NOT NULL,
	VisitedPageCount	VARCHAR2(256) NOT NULL,
	StorageUsed		VARCHAR2(256) NOT NULL,
	StorageAllocated	VARCHAR2(256) NOT NULL,
	StorageUsedPercent	VARCHAR2(256) NOT NULL,
	RootWebTemplate		VARCHAR2(256) NOT NULL
	);

ALTER TABLE  SPOSitUsageSumTest_DDD ADD constraint Pk_SPOSitUsgSumTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOSitUsgSumTest_DDD ON SPOSitUsageSumTest_DDD
(
 	MSMT_TIME
);



DROP TABLE MTMSrvPrvStats_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMSrvPrvStats_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	USER_LICENSE	VARCHAR2(128) NOT NULL,
	SERVICE_NAME	VARCHAR2(128) NOT NULL,
	USER_PRINCIPAL_NAME	VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMSrvPrvStats_DDD ADD CONSTRAINT PK_MTMSrvPrvStats_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMSrvPrvStats_DDD ON MTMSrvPrvStats_DDD
(
 	MSMT_TIME
);



DROP TABLE MTMAudioStrmsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMAudioStrmsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat			VARCHAR2(128) NOT NULL,
	Hur			VARCHAR2(128) NOT NULL,
	cunt			VARCHAR2(128) NOT NULL,
	firstIPaddress		VARCHAR2(128) NOT NULL,
	secondIPaddress		VARCHAR2(128) NOT NULL,
	conferenceID		VARCHAR2(128) NOT NULL
	
);
ALTER TABLE  MTMAudioStrmsTest_DDD ADD CONSTRAINT PK_MTMAudioStrmsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMAudioStrmsTest_DDD ON MTMAudioStrmsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MTMFeedBckSmryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMFeedBckSmryTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat			VARCHAR2(128) NOT NULL,
	Hur			VARCHAR2(128) NOT NULL,
	cunt			VARCHAR2(128) NOT NULL,
	firstIPaddress		VARCHAR2(128) NOT NULL,
	secondIPaddress		VARCHAR2(128) NOT NULL,
	conferenceID		VARCHAR2(128) NOT NULL
	
);
ALTER TABLE  MTMFeedBckSmryTest_DDD ADD CONSTRAINT PK_MTMFeedBckSmryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMFeedBckSmryTest_DDD ON MTMFeedBckSmryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MTMNtwkQtySmyTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMNtwkQtySmyTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat			VARCHAR2(128) NOT NULL,
	Hur			VARCHAR2(128) NOT NULL,
	Frstnwrk		VARCHAR2(128) NOT NULL,
	Scndnwrk		VARCHAR2(128) NOT NULL,
	Avgjter			VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMNtwkQtySmyTest_DDD ADD CONSTRAINT PK_MTMNtwkQtySmyTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMNtwkQtySmyTest_DDD ON MTMNtwkQtySmyTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MTMVBSSStrmsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMVBSSStrmsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat			VARCHAR2(128) NOT NULL,
	Hur			VARCHAR2(128) NOT NULL,
	firstIPaddress		VARCHAR2(128) NOT NULL,
	secondIPaddress		VARCHAR2(128) NOT NULL,
	conferenceID		VARCHAR2(128) NOT NULL,
	cunt			VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMVBSSStrmsTest_DDD ADD CONSTRAINT PK_MTMVBSSStrmsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMVBSSStrmsTest_DDD ON MTMVBSSStrmsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MTMVideoStreamsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMVideoStreamsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat			VARCHAR2(128) NOT NULL,
	Hur			VARCHAR2(128) NOT NULL,
	firstIPaddress		VARCHAR2(128) NOT NULL,
	secondIPaddress		VARCHAR2(128) NOT NULL,
	conferenceID		VARCHAR2(128) NOT NULL,
	cunt			VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMVideoStreamsTest_DDD ADD CONSTRAINT PK_MTMVideoStreamsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMVideoStreamsTest_DDD ON MTMVideoStreamsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MTMAppShrngStrmsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMAppShrngStrmsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat			VARCHAR2(128) NOT NULL,
	Hur			VARCHAR2(128) NOT NULL,
	firstIPaddress		VARCHAR2(128) NOT NULL,
	secondIPaddress		VARCHAR2(128) NOT NULL,
	conferenceID		VARCHAR2(128) NOT NULL,
	cunt			VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMAppShrngStrmsTest_DDD ADD CONSTRAINT PK_MTMAppShrngStrmsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMAppShrngStrmsTest_DDD ON MTMAppShrngStrmsTest_DDD
(
 	MSMT_TIME
);



DROP TABLE MTMSrvPrvStats_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMSrvPrvStats_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	USER_LICENSE	VARCHAR2(128) NOT NULL,
	SERVICE_NAME	VARCHAR2(128) NOT NULL,
	USER_PRINCIPAL_NAME	VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMSrvPrvStats_DDD ADD CONSTRAINT PK_MTMSrvPrvStats_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMSrvPrvStats_DDD ON MTMSrvPrvStats_DDD
(
 	MSMT_TIME
);


DROP TABLE MTMUsrActvitiesTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMUsrActvitiesTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	UsrPricNam		VARCHAR2(128) NOT NULL,
	LstActDte		VARCHAR2(128) NOT NULL,
	TemChatMsgcnt		VARCHAR2(128) NOT NULL,
	PrvChtMsgcnt		VARCHAR2(128) NOT NULL,
	CallCount		VARCHAR2(128) NOT NULL,
	MetingCount		VARCHAR2(128) NOT NULL,
	HsOthrAct		VARCHAR2(128) NOT NULL,
	IsDeltd			VARCHAR2(128) NOT NULL,
	DltedDat		VARCHAR2(128) NOT NULL,
	AsigdProds		VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMUsrActvitiesTest_DDD ADD CONSTRAINT PK_MTMUsrActvitiesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMUsrActvitiesTest_DDD ON MTMUsrActvitiesTest_DDD
(
 	MSMT_TIME
);



DROP TABLE MTMTeamsInvTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMTeamsInvTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	temname		        VARCHAR2(128) NOT NULL,
	crtedDte		VARCHAR2(128) NOT NULL,
	memCnt			VARCHAR2(128) NOT NULL,
	temOwnr		        VARCHAR2(128) NOT NULL,
	chnlCnt		        VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMTeamsInvTest_DDD ADD CONSTRAINT PK_MTMTeamsInvTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMTeamsInvTest_DDD ON MTMTeamsInvTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MTMtemsOAMactTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMtemsOAMactTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	CrtnTme		        VARCHAR2(128) NOT NULL,
	TemNam		        VARCHAR2(128) NOT NULL,
	DiplyNme		VARCHAR2(1028) NOT NULL,
	Role		        VARCHAR2(128) NOT NULL,
	UPNs			VARCHAR2(128) NOT NULL,
	UsrId		        VARCHAR2(128) NOT NULL,
	UserTyp			VARCHAR2(128) NOT NULL,
        TemGuid			VARCHAR2(128) NOT NULL,
	chnlguid		VARCHAR2(128) NOT NULL
);

ALTER TABLE  MTMtemsOAMactTest_DDD ADD CONSTRAINT PK_MTMtemsOAMactTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMtemsOAMactTest_DDD ON MTMtemsOAMactTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MTMtmChnlOperTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMtmChnlOperTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	CrtnTme		        VARCHAR2(128) NOT NULL,
	TemNam		        VARCHAR2(128) NOT NULL,
	ChnelNme		VARCHAR2(128) NOT NULL,
	AdOnNme		        VARCHAR2(128) NOT NULL,
	UsrId			VARCHAR2(128) NOT NULL,
	UsrType		        VARCHAR2(128) NOT NULL,
	TemGuid			VARCHAR2(128) NOT NULL,
        ChnelGuid		VARCHAR2(128) NOT NULL,
	AddOnGuid		VARCHAR2(128) NOT NULL,
	OldAdOnGid		VARCHAR2(128) NOT NULL,
	OldTabTyp		VARCHAR2(128) NOT NULL

);

ALTER TABLE  MTMtmChnlOperTest_DDD ADD CONSTRAINT PK_MTMtmChnlOperTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MTMtmChnlOperTest_DDD ON MTMtmChnlOperTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MTMMsgCentTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMMsgCentTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Msgs_ID		        VARCHAR2(128) NOT NULL,
	Act_by		        VARCHAR2(128) NOT NULL,
	Msg_title		VARCHAR2(128) NOT NULL,
	Msgs		        VARCHAR2(2000) NOT NULL,
	Published               VARCHAR2(128) NOT NULL,
	Actn_DT		        VARCHAR2(128) NOT NULL,
	Actn_Typ		VARCHAR2(128) NOT NULL,
        Extnl_Link		VARCHAR2(2000) NOT NULL,
	Urgency_Lvl             VARCHAR2(2000) NOT NULL

);

ALTER TABLE  MTMMsgCentTest_DDD ADD CONSTRAINT PK_MTMMsgCentTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MTMMsgCentTest_DDD ON MTMMsgCentTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MTMSrvcHlhTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMSrvcHlhTest_DDD
(	
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Incident_Id		VARCHAR2(128) NOT NULL,
	Title			VARCHAR2(128) NOT NULL,
	Affected_Tenant_Count	VARCHAR2(128) NOT NULL,
	Srvce_Nme		VARCHAR2(128) NOT NULL,
	Start_Tme	        VARCHAR2(128) NOT NULL,
	End_Tme 	        VARCHAR2(128) NOT NULL,
	Lst_Updtd		VARCHAR2(128) NOT NULL,
	Messge			VARCHAR2(2000) NOT NULL,
	Feature_Nme		VARCHAR2(128) NOT NULL
	);

ALTER TABLE  MTMSrvcHlhTest_DDD ADD constraint Pk_MTMSrvcHlhTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMSrvcHlhTest_DDD ON MTMSrvcHlhTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MTMUsrLoginsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MTMUsrLoginsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	User_id		VARCHAR2(128) NOT NULL,
	log_crteTime	VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMUsrLoginsTest_DDD ADD CONSTRAINT PK_MTMUsrLoginsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMUsrLoginsTest_DDD ON MTMUsrLoginsTest_DDD
(
 	MSMT_TIME
);



DROP TABLE MTMCalSumryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE MTMCalSumryTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Dat		        VARCHAR2(128) NOT NULL,
	Hrs             VARCHAR2(128) NOT NULL,
	Frst_IP_Adrs	VARCHAR2(128) NOT NULL,
	Sec_IP_Adrs		VARCHAR2(128) NOT NULL,
	Cnfrnc_ID   	VARCHAR2(128) NOT NULL,
	Cnt             VARCHAR2(128) NOT NULL
);
ALTER TABLE  MTMCalSumryTest_DDD ADD CONSTRAINT PK_MTMCalSumryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MTMCalSumryTest_DDD ON MTMCalSumryTest_DDD
(
 	MSMT_TIME
);



DROP TABLE O365GrpsActsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365GrpsActsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	GrupDisplyName		VARCHAR2(128) NOT NULL,
	OwerDisplyName		VARCHAR2(128) NOT NULL,
	LstActvDat		VARCHAR2(128) NOT NULL,
	GrpType			VARCHAR2(128) NOT NULL,
	CntStrage		VARCHAR2(128) NOT NULL
);
ALTER TABLE  O365GrpsActsTest_DDD ADD CONSTRAINT PK_O365GrpsActsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_O365GrpsActsTest_DDD ON O365GrpsActsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE O365FailedLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365FailedLoginTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Log_time                VARCHAR2(256) NOT NULL,
	client_IP		VARCHAR2(256) NOT NULL,
	User_Id			VARCHAR2(256) NOT NULL,
	Workload		VARCHAR2(256) NOT NULL
);
ALTER TABLE  O365FailedLoginTest_DDD ADD CONSTRAINT PK_O365FailedLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_O365FailedLoginTest_DDD ON O365FailedLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SBOUsersTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOUsersTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Display_Name	VARCHAR2(128) NOT NULL,
	Userprincipal_Name	VARCHAR2(128) NOT NULL,
	ACP_Name		VARCHAR2(128) NOT NULL,
	ACP_DomainName		VARCHAR2(128) NOT NULL,
	ACP_PPcode		VARCHAR2(128) NOT NULL,
	ACP_tollNumber		VARCHAR2(128) NOT NULL
);
ALTER TABLE  SBOUsersTest_DDD ADD CONSTRAINT PK_SBOUsersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SBOUsersTest_DDD ON SBOUsersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SBOSrvPrvStats_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOSrvPrvStats_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USER_LICENSE	VARCHAR2(128) NOT NULL,
	SERVICE_NAME	VARCHAR2(128) NOT NULL,
	USER_PRINCIPAL_NAME	VARCHAR2(128) NOT NULL
);
ALTER TABLE  SBOSrvPrvStats_DDD ADD CONSTRAINT PK_SBOSrvPrvStats_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SBOSrvPrvStats_DDD ON SBOSrvPrvStats_DDD
(
 	MSMT_TIME
);


DROP TABLE SBOCallConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOCallConnTest_DDD
(	
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	CallStartTim    	VARCHAR2(256) NOT NULL,
	PacketLossRate		VARCHAR2(256) NOT NULL,
	RoundTripLatency	VARCHAR2(256) NOT NULL,
	PacketsSent		VARCHAR2(256) NOT NULL,
	PacketsReceived 	VARCHAR2(256) NOT NULL,
	AverageJitter	        VARCHAR2(256) NOT NULL,
	PacketReorderRatio	VARCHAR2(256) NOT NULL,
	CallsFailed		VARCHAR2(256) NOT NULL,
	ConnChecksFailed	VARCHAR2(256) NOT NULL
	);

ALTER TABLE  SBOCallConnTest_DDD ADD constraint Pk_SBOCallConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SBOCallConnTest_DDD ON SBOCallConnTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SBOSesDomainsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOSesDomainsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	domain			VARCHAR2(128) NOT NULL

);

ALTER TABLE  SBOSesDomainsTest_DDD ADD CONSTRAINT PK_SBOSesDomainsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SBOSesDomainsTest_DDD ON SBOSesDomainsTest_DDD
(
 	MSMT_TIME
);




DROP TABLE SBOAppshrngQltyTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOAppshrngQltyTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Strt_Time		VARCHAR2(256) NOT NULL,
	End_Time		VARCHAR2(256) NOT NULL,
	Med_Durt_min		VARCHAR2(256) NOT NULL,
	Med_Type		VARCHAR2(256) NOT NULL,
	Frm_Uri			VARCHAR2(64) NOT NULL,
	Frm_Clint_ver		VARCHAR2(128) NOT NULL,
	From_OS			VARCHAR2(128) NOT NULL,
	Frm_Render_Dev		VARCHAR2(128) NOT NULL,
	Frm_Netwrk		VARCHAR2(128) NOT NULL,
	Frm_ip			VARCHAR2(128) NOT NULL,
	From_TelNum		VARCHAR2(64) NOT NULL,
	To_Uri			VARCHAR2(64) NOT NULL,
	To_Client_ver		VARCHAR2(128) NOT NULL,
	To_OS			VARCHAR2(128) NOT NULL,
	To_Render_Dev		VARCHAR2(128) NOT NULL,
	To_Netwrk		VARCHAR2(128) NOT NULL,
	To_ip			VARCHAR2(128) NOT NULL,
	To_TelNum		VARCHAR2(64) NOT NULL,
	Spltileperc		VARCHAR2(64) NOT NULL,
	Rdpltcyperc		VARCHAR2(64) NOT NULL,
	RltivOnwayAvg		VARCHAR2(64) NOT NULL,
	ErrorReprt		VARCHAR2(1024) NOT NULL

);

ALTER TABLE  SBOAppshrngQltyTest_DDD ADD CONSTRAINT PK_SBOAppshrngQltyTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SBOAppshrngQltyTest_DDD ON SBOAppshrngQltyTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SBOImFileSesnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOImFileSesnTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Frm_Uri			VARCHAR2(128) NOT NULL,
	To_Uri			VARCHAR2(128) NOT NULL,
	cnt			VARCHAR2(128) NOT NULL,
	Strt_Time		VARCHAR2(128) NOT NULL,
	End_Time		VARCHAR2(128) NOT NULL,
	Med_Type		VARCHAR2(128) NOT NULL

);

ALTER TABLE  SBOImFileSesnTest_DDD ADD CONSTRAINT PK_SBOImFileSesnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SBOImFileSesnTest_DDD ON SBOImFileSesnTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SBOVidCalQlityTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOVidCalQlityTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Strt_Time		VARCHAR2(256) NOT NULL,
	End_Time		VARCHAR2(256) NOT NULL,
	Med_Durt_min		VARCHAR2(256) NOT NULL,
	Med_Type		VARCHAR2(256) NOT NULL,
	Frm_Uri			VARCHAR2(64) NOT NULL,
	Frm_Clint_ver		VARCHAR2(128) NOT NULL,
	From_OS			VARCHAR2(128) NOT NULL,
	Frm_Render_Dev		VARCHAR2(128) NOT NULL,
	Frm_Netwrk		VARCHAR2(128) NOT NULL,
	Frm_Ip			VARCHAR2(128) NOT NULL,
	From_TelNum		VARCHAR2(64) NOT NULL,
	To_Uri			VARCHAR2(64) NOT NULL,
	To_Client_ver		VARCHAR2(128) NOT NULL,
	To_OS			VARCHAR2(128) NOT NULL,
	To_Render_Dev		VARCHAR2(128) NOT NULL,
	To_Netwrk		VARCHAR2(128) NOT NULL,
	To_Ip			VARCHAR2(128) NOT NULL,
	To_TelNum		VARCHAR2(64) NOT NULL,
	vidLcFrmLs		VARCHAR2(64) NOT NULL,
	vidfrmRte		VARCHAR2(64) NOT NULL,
	VidpstLR		VARCHAR2(64) NOT NULL,
	ErrorReprt		VARCHAR2(1024) NOT NULL

);

ALTER TABLE  SBOVidCalQlityTest_DDD ADD CONSTRAINT PK_SBOVidCalQlityTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SBOVidCalQlityTest_DDD ON SBOVidCalQlityTest_DDD
(
 	MSMT_TIME
);




DROP TABLE SBOAudCalQltyTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOAudCalQltyTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Strt_Time		VARCHAR2(256) NOT NULL,
	End_Time		VARCHAR2(256) NOT NULL,
	Med_Durt_min		VARCHAR2(256) NOT NULL,
	Med_Type		VARCHAR2(256) NOT NULL,
	Frm_Uri			VARCHAR2(64) NOT NULL,
	Frm_Clint_ver		VARCHAR2(128) NOT NULL,
	From_OS			VARCHAR2(128) NOT NULL,
	Frm_Render_Dev		VARCHAR2(128) NOT NULL,
	Frm_Netwrk		VARCHAR2(128) NOT NULL,
	frm_Ip			VARCHAR2(128) NOT NULL,
	From_TelNum		VARCHAR2(64) NOT NULL,
	Otb_jitrIntArv		VARCHAR2(64) NOT NULL,
	Otb_pactLsRte		VARCHAR2(64) NOT NULL,
	Otb_Rundtrip		VARCHAR2(64) NOT NULL,
	Otb_SampAvg		VARCHAR2(64) NOT NULL,
	Otb_DegAvg		VARCHAR2(64) NOT NULL,
	To_Uri			VARCHAR2(64) NOT NULL,
	To_Client_ver		VARCHAR2(128) NOT NULL,
	To_OS			VARCHAR2(128) NOT NULL,
	To_Render_Dev		VARCHAR2(128) NOT NULL,
	To_Netwrk		VARCHAR2(128) NOT NULL,
	To_Ip			VARCHAR2(128) NOT NULL,
	To_TelNum		VARCHAR2(64) NOT NULL,
	In_jitrIntArv		VARCHAR2(64) NOT NULL,
	In_pactLsRte		VARCHAR2(64) NOT NULL,
	In_Rundtrip		VARCHAR2(64) NOT NULL,
	In_SampAvg		VARCHAR2(64) NOT NULL,
	In_DegAvg		VARCHAR2(64) NOT NULL,
	ErrorReprt		VARCHAR2(1024) NOT NULL
);
ALTER TABLE  SBOAudCalQltyTest_DDD ADD CONSTRAINT PK_SBOAudCalQltyTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SBOAudCalQltyTest_DDD ON SBOAudCalQltyTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SBOFeedBackTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOFeedBackTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	FromUri		        VARCHAR2(128) NOT NULL,
	ToUri		        VARCHAR2(128) NOT NULL,
	FromIPAddr	        VARCHAR2(128) NOT NULL,
	ToIPAddr	        VARCHAR2(128) NOT NULL,
	MediaType	        VARCHAR2(128) NOT NULL,
	MediaStartTime	        VARCHAR2(128) NOT NULL,
	MediaEndTime	        VARCHAR2(128) NOT NULL,
	MediaDurationInSeconds  VARCHAR2(128) NOT NULL
);

ALTER TABLE  SBOFeedBackTest_DDD ADD CONSTRAINT PK_SBOFeedBackTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SBOFeedBackTest_DDD ON SBOFeedBackTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SBOMsgCentTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOMsgCentTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Msgs_ID		        VARCHAR2(128) NOT NULL,
	Act_by		        VARCHAR2(128) NOT NULL,
	Msg_title		VARCHAR2(128) NOT NULL,
	Msgs		        VARCHAR2(2000) NOT NULL,
	Published               VARCHAR2(128) NOT NULL,
	Actn_DT		        VARCHAR2(128) NOT NULL,
	Actn_Typ		VARCHAR2(128) NOT NULL,
        Extnl_Link		VARCHAR2(2000) NOT NULL,
	Urgency_Lvl             VARCHAR2(2000) NOT NULL

);

ALTER TABLE  SBOMsgCentTest_DDD ADD CONSTRAINT PK_SBOMsgCentTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SBOMsgCentTest_DDD ON SBOMsgCentTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SBOConcStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOConcStatusTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Updte_time		VARCHAR2(64) NOT NULL,
	Strt_time		VARCHAR2(64) NOT NULL,
	End_time		VARCHAR2(64) NOT NULL,
	Descrption		VARCHAR2(1028) NOT NULL,
	Aftd_servs		VARCHAR2(128) NOT NULL,
	Aftd_prdcts		VARCHAR2(1028) NOT NULL,
	Aftd_cntrs		VARCHAR2(1028) NOT NULL
);
ALTER TABLE  SBOConcStatusTest_DDD ADD CONSTRAINT PK_SBOConcStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SBOConcStatusTest_DDD ON SBOConcStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SBOSrvcHlhTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SBOSrvcHlhTest_DDD(
SITE_NAME		VARCHAR2(64) NOT NULL,
TRGT_HOST		VARCHAR2(32) NOT NULL,
PORT_NO			VARCHAR2(32)NOT NULL,
TEST_NAME		VARCHAR2(64) NOT NULL,
MEASURE			VARCHAR2(64) NOT NULL,
INFO			VARCHAR2(128) NOT NULL,
STATE			VARCHAR2(32) NOT NULL,
MSMT_HOST		VARCHAR2(32) NOT NULL,
MSMT_TIME		DATE NOT NULL,
SEQ_NO			NUMBER(16) NOT NULL,
Incident_Id		VARCHAR2(128) NOT NULL,
Title			VARCHAR2(128) NOT NULL,
Affected_Tenant_Count	VARCHAR2(128) NOT NULL,
Srvce_Nme		VARCHAR2(128) NOT NULL,
Start_Tme	        VARCHAR2(128) NOT NULL,
End_Tme 	        VARCHAR2(128) NOT NULL,
Lst_Updtd		VARCHAR2(128) NOT NULL,
Messge			VARCHAR2(2000) NOT NULL,
Feature_Nme		VARCHAR2(128) NOT NULL );
ALTER TABLE  SBOSrvcHlhTest_DDD ADD constraint Pk_SBOSrvcHlhTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SBOSrvcHlhTest_DDD ON SBOSrvcHlhTest_DDD(MSMT_TIME );


DROP TABLE SAASNETWORKTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE SAASNETWORKTEST_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	HOPCOUNT	NUMBER(16) NOT NULL,
	ROUTER		VARCHAR2(2000) NOT NULL,
	HOPDELAYS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE SAASNETWORKTEST_DDD ADD constraint Pk_SAASNETWORKTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SAASNETWORKTEST_DDD ON SAASNETWORKTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE O365SecurityGrpsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365SecurityGrpsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Display_Name     VARCHAR2(128) NOT NULL,
	Membercunt	VARCHAR2(64) NOT NULL
	
);

ALTER TABLE  O365SecurityGrpsTest_DDD ADD CONSTRAINT PK_O365SecurityGrpsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_O365SecurityGrpsTest_DDD ON O365SecurityGrpsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE O365UnfiedgrpsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365UnfiedgrpsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Display_Name            VARCHAR2(256) NOT NULL,
	EMAIL			VARCHAR2(256) NOT NULL,
	Alias_Name                   VARCHAR2(256) NOT NULL,
	Stats              VARCHAR2(256) NOT NULL,
	Membercunt           VARCHAR2(256) NOT NULL,
        CHANGED		        VARCHAR2(256) NOT NULL,
	CREATED                 VARCHAR2(256) NOT NULL	
);

ALTER TABLE  O365UnfiedgrpsTest_DDD ADD CONSTRAINT PK_O365UnfiedgrpsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_O365UnfiedgrpsTest_DDD ON O365UnfiedgrpsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE O365DistbnGrpsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365DistbnGrpsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Display_Name            VARCHAR2(256) NOT NULL,
	EMAIL                   VARCHAR2(256) NOT NULL,
	Alias_Name              VARCHAR2(256) NOT NULL,
	Stats			VARCHAR2(256) NOT NULL,
	Membercunt		VARCHAR2(32) NOT NULL,
        CHANGED		        VARCHAR2(256) NOT NULL,
	CREATED                 VARCHAR2(256) NOT NULL	
);

ALTER TABLE  O365DistbnGrpsTest_DDD ADD CONSTRAINT PK_O365DistbnGrpsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_O365DistbnGrpsTest_DDD ON O365DistbnGrpsTest_DDD
(
 	MSMT_TIME
);





DROP TABLE O365DomainTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365DomainTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Domain_NAME     VARCHAR2(128) NOT NULL
);

ALTER TABLE  O365DomainTest_DDD ADD CONSTRAINT PK_O365DomainTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365DomainTest_DDD ON O365DomainTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365DomainTest_DDD ON O365DomainTest_DDD(MSMT_TIME);



DROP TABLE O365SRVPRVSTATS_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365SRVPRVSTATS_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USER_LICENSE	VARCHAR2(128) NOT NULL,
	SERVICE_NAME	VARCHAR2(128) NOT NULL,
	USER_PRINCIPAL_NAME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  O365SRVPRVSTATS_DDD ADD CONSTRAINT PK_O365SRVPRVSTATS_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365SRVPRVSTATS_DDD ON O365SRVPRVSTATS_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365SRVPRVSTATS_DDD ON O365SRVPRVSTATS_DDD(MSMT_TIME);

DROP TABLE O365UserActivTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365UserActivTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_Category           VARCHAR2(256) NOT NULL,
        User_Operation		VARCHAR2(1000) NOT NULL,
	Number_of_operations    VARCHAR2(1000) NOT NULL
);

ALTER TABLE  O365UserActivTest_DDD ADD CONSTRAINT PK_O365UserActivTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365UserActivTest_DDD ON O365UserActivTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365UserActivTest_DDD ON O365UserActivTest_DDD(MSMT_TIME);

DROP TABLE O365LicnsUsgTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365LicnsUsgTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	O365DT_CREATED          VARCHAR2(128) NOT NULL,
	O365SKUID		VARCHAR2(128) NOT NULL,
        O365_NextLifecycle      VARCHAR2(128) NOT NULL
);

ALTER TABLE  O365LicnsUsgTest_DDD ADD CONSTRAINT PK_O365LicnsUsgTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365LicnsUsgTest_DDD ON O365LicnsUsgTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365LicnsUsgTest_DDD ON O365LicnsUsgTest_DDD(MSMT_TIME);

DROP TABLE O365UserLogtest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365UserLogtest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_Prinicpal_Name     VARCHAR2(256) NOT NULL,
	User_SignIn_Name        VARCHAR2(256) NOT NULL,
	User_Passexp            VARCHAR2(256) NOT NULL,
	Usage_Location          VARCHAR2(256) NOT NULL,
	User_License            VARCHAR2(256) NOT NULL,
	Display_name            VARCHAR2(256) NOT NULL,
        Is_Licensed             VARCHAR2(256) NOT NULL
);

ALTER TABLE  O365UserLogtest_DDD ADD CONSTRAINT PK_O365UserLogtest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365UserLogtest_DDD ON O365UserLogtest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365UserLogtest_DDD ON O365UserLogtest_DDD(MSMT_TIME);


DROP TABLE O365SpfAdtLgTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365SpfAdtLgTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Messages		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  O365SpfAdtLgTest_DDD ADD CONSTRAINT PK_O365SpfAdtLgTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365SpfAdtLgTest_DDD ON O365SpfAdtLgTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365SpfAdtLgTest_DDD ON O365SpfAdtLgTest_DDD(MSMT_TIME);


DROP TABLE O365DycDistbGrpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365DycDistbGrpTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Display_Name            VARCHAR2(256) NOT NULL,
	EMAIL                   VARCHAR2(256) NOT NULL,
	Alias_Name              VARCHAR2(256) NOT NULL,
	Stats			VARCHAR2(256) NOT NULL,
	Membercunt		VARCHAR2(32) NOT NULL,
        CHANGED		        VARCHAR2(256) NOT NULL,
	CREATED                 VARCHAR2(256) NOT NULL	
);

ALTER TABLE  O365DycDistbGrpTest_DDD ADD CONSTRAINT PK_O365DycDistbGrpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_O365DycDistbGrpTest_DDD ON O365DycDistbGrpTest_DDD
(
 	MSMT_TIME
);




DROP TABLE O365MsgCenTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365MsgCenTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Message_ID		VARCHAR2(128) NOT NULL,
	Act_by		        VARCHAR2(128) NOT NULL,
	Message_title		VARCHAR2(128) NOT NULL,
	Message		        VARCHAR2(2000) NOT NULL,
	Published               VARCHAR2(128) NOT NULL,
	Action_Required_By_Dt	VARCHAR2(128) NOT NULL,
	Action_Type		VARCHAR2(128) NOT NULL,
        External_Link           VARCHAR2(2000) NOT NULL,
	Urgency_Level           VARCHAR2(2000) NOT NULL
);

ALTER TABLE  O365MsgCenTest_DDD ADD CONSTRAINT PK_O365MsgCenTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365MsgCenTest_DDD ON O365MsgCenTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365MsgCenTest_DDD ON O365MsgCenTest_DDD(MSMT_TIME);


DROP TABLE O365SrvHealTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  O365SrvHealTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Incident_Id		VARCHAR2(128) NOT NULL,
	Title			VARCHAR2(128) NOT NULL,
	Affected_Tenant_Count	VARCHAR2(128) NOT NULL,
	Srvce_Nme		VARCHAR2(128) NOT NULL,
	Start_Tme	        VARCHAR2(128) NOT NULL,
	End_Tme 	        VARCHAR2(128) NOT NULL,
	Lst_Updtd		VARCHAR2(128) NOT NULL,
	Messge			VARCHAR2(2000) NOT NULL,
	Feature_Nme		VARCHAR2(128) NOT NULL
);

ALTER TABLE  O365SrvHealTest_DDD ADD CONSTRAINT PK_O365SrvHealTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_O365SrvHealTest_DDD ON O365SrvHealTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_O365SrvHealTest_DDD ON O365SrvHealTest_DDD(MSMT_TIME);


DROP TABLE SPOSiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Templates	VARCHAR2(128) NOT NULL,
	Title		VARCHAR2(128) NOT NULL,
	Owner		VARCHAR2(128) NOT NULL,
	LockIssue	VARCHAR2(128) NOT NULL,
	DisplayName	VARCHAR2(128) NOT NULL,
	Email		VARCHAR2(128) NOT NULL,
	WhenCreated	VARCHAR2(128) NOT NULL,
	InvitedBy	VARCHAR2(128) NOT NULL,
	AcceptedAs	VARCHAR2(128) NOT NULL);

ALTER TABLE  SPOSiteTest_DDD ADD constraint Pk_SPOSiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOSiteTest_DDD ON SPOSiteTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SPOSiteHealthCheckTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteHealthCheckTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	RuleName	VARCHAR2(128) NOT NULL,
	RuleId		VARCHAR2(128) NOT NULL);

ALTER TABLE  SPOSiteHealthCheckTest_DDD ADD constraint Pk_SPOSiteHealthCheckTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOSiteHealthCheckTest_DDD ON SPOSiteHealthCheckTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SPOServiceTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOServiceTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID			VARCHAR2(128) NOT NULL,
	Title			VARCHAR2(128) NOT NULL,
	AffectedTenantCount	VARCHAR2(128) NOT NULL,
	ServiceName		VARCHAR2(128) NOT NULL,
	StartTime		VARCHAR2(128) NOT NULL,
	EndTime			VARCHAR2(128) NOT NULL,
	LastUpdated		VARCHAR2(128) NOT NULL,
	Message			VARCHAR2(2000) NOT NULL,
	FeatureName		VARCHAR2(128) NOT NULL);

ALTER TABLE  SPOServiceTest_DDD ADD constraint Pk_SPOServiceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOServiceTest_DDD ON SPOServiceTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SPOTenantTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOTenantTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	URL			VARCHAR2(128) NOT NULL,
	Status			VARCHAR2(128) NOT NULL,
	DeletionTime		VARCHAR2(128) NOT NULL,
	DaysRemaining		VARCHAR2(128) NOT NULL,
	DeletedStorageQuota	VARCHAR2(128) NOT NULL,
	DeletedResourceQuota	VARCHAR2(128) NOT NULL,
	Name_AppInfo		VARCHAR2(128) NOT NULL,
	Productid		VARCHAR2(128) NOT NULL,
	Source			VARCHAR2(128) NOT NULL,
	Name_WebTemp		VARCHAR2(128) NOT NULL,
	LocaleId		VARCHAR2(128) NOT NULL,
	CompatibilityLevel	VARCHAR2(128) NOT NULL,
	Title			VARCHAR2(128) NOT NULL,
	DisplayCategory		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL);

ALTER TABLE  SPOTenantTest_DDD ADD constraint Pk_SPOTenantTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOTenantTest_DDD ON SPOTenantTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SPOMsgCommTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOMsgCommTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Message_ID		VARCHAR2(128) NOT NULL,
	Act_by		        VARCHAR2(128) NOT NULL,
	Message_title		VARCHAR2(128) NOT NULL,
	Message		        VARCHAR2(2000) NOT NULL,
	Published               VARCHAR2(128) NOT NULL,
	Action_Required_By_Dt	VARCHAR2(128) NOT NULL,
	Action_Type		VARCHAR2(128) NOT NULL,
        External_Link           VARCHAR2(2000) NOT NULL,
	Urgency_Level           VARCHAR2(2000) NOT NULL);

ALTER TABLE  SPOMsgCommTest_DDD ADD constraint Pk_SPOMsgCommTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOMsgCommTest_DDD ON SPOMsgCommTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SPOFileActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOFileActTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR2(128) NOT NULL,
	Operation_Count		VARCHAR2(128) NOT NULL,
	User_ID			VARCHAR2(128) NOT NULL,
	Client_IP		VARCHAR2(128) NOT NULL,
	Site_GUID		VARCHAR2(128) NOT NULL,
	Site_URL		VARCHAR2(128) NOT NULL,
	Item_Type		VARCHAR2(128) NOT NULL,
	Destination_URL		VARCHAR2(128) NOT NULL,
	User_Agent		VARCHAR2(128) NOT NULL,
	Number_of_operations	VARCHAR2(128) NOT NULL,
	Operations_performed	VARCHAR2(256) NOT NULL
);

ALTER TABLE  SPOFileActTest_DDD ADD constraint Pk_SPOFileActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOFileActTest_DDD ON SPOFileActTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SPOFolderActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOFolderActTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR2(128) NOT NULL,
	Operation_Count		VARCHAR2(128) NOT NULL,
	User_ID			VARCHAR2(128) NOT NULL,
	Client_IP		VARCHAR2(128) NOT NULL,
	Site_GUID		VARCHAR2(128) NOT NULL,
	Site_URL		VARCHAR2(128) NOT NULL,
	Item_Type		VARCHAR2(128) NOT NULL,
	Destination_URL		VARCHAR2(128) NOT NULL,
	User_Agent		VARCHAR2(128) NOT NULL,
	Number_of_operations	VARCHAR2(128) NOT NULL,
	Operations_performed	VARCHAR2(256) NOT NULL
);

ALTER TABLE  SPOFolderActTest_DDD ADD constraint Pk_SPOFolderActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOFolderActTest_DDD ON SPOFolderActTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SPOSharngActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOSharngActTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR2(128) NOT NULL,
	Operation_Count		VARCHAR2(128) NOT NULL,
	User_ID			VARCHAR2(128) NOT NULL,
	Client_IP		VARCHAR2(128) NOT NULL,
	Site_GUID		VARCHAR2(128) NOT NULL,
	Site_URL		VARCHAR2(128) NOT NULL,
	Item_Type		VARCHAR2(128) NOT NULL,
	Destination_URL		VARCHAR2(128) NOT NULL,
	User_Agent		VARCHAR2(128) NOT NULL,
	Number_of_operations	VARCHAR2(128) NOT NULL,
	Operations_performed	VARCHAR2(256) NOT NULL
);

ALTER TABLE  SPOSharngActTest_DDD ADD constraint Pk_SPOSharngActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOSharngActTest_DDD ON SPOSharngActTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SPOSyncActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOSyncActTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR2(128) NOT NULL,
	Operation_Count		VARCHAR2(128) NOT NULL,
	User_ID			VARCHAR2(128) NOT NULL,
	Client_IP		VARCHAR2(128) NOT NULL,
	Site_GUID		VARCHAR2(128) NOT NULL,
	Site_URL		VARCHAR2(128) NOT NULL,
	Item_Type		VARCHAR2(128) NOT NULL,
	Destination_URL		VARCHAR2(128) NOT NULL,
	User_Agent		VARCHAR2(128) NOT NULL,
	Number_of_operations	VARCHAR2(128) NOT NULL,
	Operations_performed	VARCHAR2(256) NOT NULL
);

ALTER TABLE  SPOSyncActTest_DDD ADD constraint Pk_SPOSyncActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOSyncActTest_DDD ON SPOSyncActTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SPOSAdminActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPOSAdminActTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Operation_Name		VARCHAR2(128) NOT NULL,
	Operation_Count		VARCHAR2(128) NOT NULL,
	User_ID			VARCHAR2(128) NOT NULL,
	Client_IP		VARCHAR2(128) NOT NULL,
	Site_GUID		VARCHAR2(128) NOT NULL,
	Site_URL		VARCHAR2(128) NOT NULL,
	Item_Type		VARCHAR2(128) NOT NULL,
	Destination_URL		VARCHAR2(128) NOT NULL,
	User_Agent		VARCHAR2(128) NOT NULL,
	Number_of_operations	VARCHAR2(128) NOT NULL,
	Operations_performed	VARCHAR2(256) NOT NULL
);

ALTER TABLE  SPOSAdminActTest_DDD ADD constraint Pk_SPOSAdminActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPOSAdminActTest_DDD ON SPOSAdminActTest_DDD
(
 	MSMT_TIME
);





DROP TABLE EXOUsersTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOUsersTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Idntity		varchar2(256) NOT NULL,
	Truste		varchar2(256) NOT NULL,
	AcsCntrlTyp	varchar2(256) NOT NULL,
	IsInherit	varchar2(256) NOT NULL,
	InheritanceTyp	varchar2(256) NOT NULL,
	IsVald		varchar2(256) NOT NULL
);
ALTER TABLE  EXOUsersTest_DDD ADD constraint Pk_EXOUsersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOUsersTest_DDD ON EXOUsersTest_DDD
(
 	MSMT_TIME
);


DROP TABLE EXOMailBoxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOMailBoxTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Display_Name	varchar2(128) NOT NULL, 
	User_Principal_Name	varchar2(128) NOT NULL, 
	Number_of_Items    	varchar2(128) NOT NULL, 
	Mailbox_Size    	varchar2(128) NOT NULL,
	Warning_Quota    	varchar2(128) NOT NULL,	
	Prohibit_Send_Quota   	varchar2(128) NOT NULL,
	Prohibit_Send_or_Receive_Quota   	varchar2(128) NOT NULL,
	Primary_SMTP_Address   	varchar2(128) NOT NULL,
	When_Soft_Deleted      varchar2(128) NOT NULL

);
ALTER TABLE  EXOMailBoxTest_DDD ADD constraint Pk_EXOMailBoxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOMailBoxTest_DDD ON EXOMailBoxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOMailBoxStatsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOMailBoxStatsTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Display_Name	varchar2(128) NOT NULL, 
	User_Principal_Name	varchar2(128) NOT NULL, 
	Number_of_Items    	varchar2(128) NOT NULL, 
	Mailbox_Size    	varchar2(128) NOT NULL,
	Warning_Quota    	varchar2(128) NOT NULL,	
	Prohibit_Send_Quota   	varchar2(128) NOT NULL,
	Prohibit_Send_or_Receive_Quota   	varchar2(128) NOT NULL,
	Primary_SMTP_Address   	varchar2(128) NOT NULL,
	When_Soft_Deleted      varchar2(128) NOT NULL

);
ALTER TABLE  EXOMailBoxStatsTest_DDD ADD constraint Pk_EXOMailBoxStatsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOMailBoxStatsTest_DDD ON EXOMailBoxStatsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOMailTrfcStatisTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOMailTrfcStatisTest_DDD
(
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	Address			varchar2(256) NOT NULL, 
	Inbound			varchar2(256) NOT NULL, 
	Outbound		varchar2(256) NOT NULL, 
	InboundSize		varchar2(256) NOT NULL, 
	OutboundSize		varchar2(256) NOT NULL,
	IpAdrs			varchar2(256) NOT NULL
);

ALTER TABLE  EXOMailTrfcStatisTest_DDD ADD CONSTRAINT PK_EXOMailTrfcStatisTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOMailTrfcStatisTest_DDD ON EXOMailTrfcStatisTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOUserMAPIConTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOUserMAPIConTest_DDD
(
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	Server		        varchar2(256) NOT NULL, 
	Databse		        varchar2(256) NOT NULL, 
	Mailbox			varchar2(256) NOT NULL, 
	Reslt	                varchar2(256) NOT NULL, 
	Latncy			varchar2(256) NOT NULL, 
	Error			varchar2(1024) NOT NULL
);

ALTER TABLE  EXOUserMAPIConTest_DDD ADD CONSTRAINT PK_EXOUserMAPIConTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOUserMAPIConTest_DDD ON EXOUserMAPIConTest_DDD
(
 	MSMT_TIME
);



DROP TABLE EXODevicConTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXODevicConTest_DDD
(
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	TypeName			varchar2(256) NOT NULL, 
	DeviceorTime			varchar2(256) NOT NULL
);

ALTER TABLE  EXODevicConTest_DDD ADD CONSTRAINT PK_EXODevicConTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXODevicConTest_DDD ON EXODevicConTest_DDD
(
 	MSMT_TIME
);



DROP TABLE EXOSrvcHlhTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOSrvcHlhTest_DDD
(	
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	Incident_Id		varchar2(128) NOT NULL,
	Title			varchar2(128) NOT NULL,
	Affected_Tenant_Count	varchar2(128) NOT NULL,
	Srvce_Nme		varchar2(128) NOT NULL,
	Start_Tme	        varchar2(128) NOT NULL,
	End_Tme 	        varchar2(128) NOT NULL,
	Lst_Updtd		varchar2(128) NOT NULL,
	Messge			varchar2(2000) NOT NULL,
	Feature_Nme		varchar2(128) NOT NULL
	);

ALTER TABLE  EXOSrvcHlhTest_DDD ADD constraint Pk_EXOSrvcHlhTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOSrvcHlhTest_DDD ON EXOSrvcHlhTest_DDD
(
 	MSMT_TIME
);





DROP TABLE EXOMailBoxLocTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOMailBoxLocTest_DDD
(
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
        Location           varchar2(2000) NOT NULL,
	TotalMailcnt           varchar2(2000) NOT NULL

);

ALTER TABLE  EXOMailBoxLocTest_DDD ADD CONSTRAINT PK_EXOMailBoxLocTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EXOMailBoxLocTest_DDD ON EXOMailBoxLocTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOMalwareTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOMalwareTest_DDD
(	
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	SendAdd			VARCHAR2(128) NOT NULL, 
	MsgeSiz			VARCHAR2(128) NOT NULL, 
	Malware_Cnt		VARCHAR2(128) NOT NULL, 
	ReciAdd			VARCHAR2(128) NOT NULL, 
	FileName		VARCHAR2(128) NOT NULL);

ALTER TABLE  EXOMalwareTest_DDD ADD constraint Pk_EXOMalwareTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOMalwareTest_DDD ON EXOMalwareTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOSpamTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOSpamTest_DDD
(	
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	SendAdd			varchar2(128) NOT NULL, 
	MsgeSiz			varchar2(128) NOT NULL, 
	Spam_Cnt		varchar2(128) NOT NULL,
	RecvAdd			VARCHAR2(128) NOT NULL);

ALTER TABLE  EXOSpamTest_DDD ADD constraint Pk_EXOSpamTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOSpamTest_DDD ON EXOSpamTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXONonOwnerActivtsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXONonOwnerActivtsTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	CretionTime		varchar2(128) NOT NULL,
	Ide			varchar2(128) NOT NULL,
	Opertion		varchar2(128) NOT NULL,
	ResultStatu		varchar2(128) NOT NULL,
	UserTypee		varchar2(128) NOT NULL,
	UserIde			varchar2(128) NOT NULL,
	ClientIPAddres		varchar2(128) NOT NULL,
	ClientInfoString	varchar2(256) NOT NULL,
	ExternalAccess		varchar2(128) NOT NULL,
	MailboxOwnerUPN		varchar2(128) NOT NULL,
	OrganizationName	varchar2(128) NOT NULL,
	OriginatingServer	varchar2(128) NOT NULL,
	Itm 			varchar2(256) NOT NULL,
	SendOnBhfOfUsrMb	varchar2(128) NOT NULL,
	SendOnBfOfUsrSmtp	varchar2(128) NOT NULL,
	SendAsUsrMb		varchar2(128) NOT NULL,
	SendAsSmtp		varchar2(128) NOT NULL
);

ALTER TABLE  EXONonOwnerActivtsTest_DDD ADD constraint Pk_EXONonOwnerActivtsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXONonOwnerActivtsTest_DDD ON EXONonOwnerActivtsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXODlpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXODlpTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	CretionTime	varchar2(128) NOT NULL,
	Opertion	varchar2(128) NOT NULL,
	BCC		varchar2(512) NOT NULL,
	CC		varchar2(512) NOT NULL,
	Sendfrom	varchar2(128) NOT NULL,
	Sendto		varchar2(512) NOT NULL,
	Recip_Cnt	varchar2(128) NOT NULL,
	Snt		varchar2(128) NOT NULL,
	Subj		varchar2(128) NOT NULL,
	Usr_Typ		varchar2(128) NOT NULL,
	Polic_Name	varchar2(128) NOT NULL,
	Rul_Act 	varchar2(128) NOT NULL,
	IsRuleMatc	varchar2(128) NOT NULL,
	Sens_Confi	varchar2(128) NOT NULL,
	Sens_Cnt	varchar2(128) NOT NULL,
	Sens_Loc	varchar2(128) NOT NULL,
	Sens_Typ	varchar2(128) NOT NULL,
	Sens_Uniq_Cnt	varchar2(128) NOT NULL,
	Rul_Mode 	varchar2(128) NOT NULL,
	Rul_Name	varchar2(512) NOT NULL,
	Sevrity		varchar2(128) NOT NULL,
	UsrID		varchar2(128) NOT NULL,
	Uniq_snd	varchar2(2056) NOT NULL,
	Uniq_rec	varchar2(2056) NOT NULL,
	Msg_ID		varchar2(512) NOT NULL
);
ALTER TABLE  EXODlpTest_DDD ADD constraint Pk_EXODlpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXODlpTest_DDD ON EXODlpTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOTranRuleTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOTranRuleTest_DDD
(	
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	Dte			varchar2(128) NOT NULL, 
	Domin			varchar2(128) NOT NULL, 
	TransRul		varchar2(128) NOT NULL, 
	Subj			varchar2(512) NOT NULL, 
	MsgeSize		varchar2(128) NOT NULL,
	SnderAdd		varchar2(1024) NOT NULL, 
	RecipAdd		varchar2(1024) NOT NULL, 
	Actn			varchar2(128) NOT NULL,
	MsgeId			varchar2(128) NOT NULL
	);

ALTER TABLE  EXOTranRuleTest_DDD ADD constraint Pk_EXOTranRuleTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOTranRuleTest_DDD ON EXOTranRuleTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOownerActivtsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOownerActivtsTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	LastAccessed			varchar2(2560) NOT NULL,
	OperationResult			varchar2(128) NOT NULL,
	LogonUserDisplayName		varchar2(128) NOT NULL,
	MailboxOwnerUPN			varchar2(256) NOT NULL,
	ExternalAccess			varchar2(128) NOT NULL,
	DestFolderId			varchar2(256) NOT NULL,
	DestFolderPathName		varchar2(256) NOT NULL,
	FolderId			varchar2(256) NOT NULL,
	FolderPathName			varchar2(256) NOT NULL,
	ClientIPAddress			varchar2(128) NOT NULL,
	ClientMachineName		varchar2(256) NOT NULL,
	ClientProcessName		varchar2(256) NOT NULL,
	ClientInfoString		varchar2(512) NOT NULL,
	ClientVersion			varchar2(128) NOT NULL,
	DestMailboxOwnerUPN		varchar2(256) NOT NULL,
	CrossMailboxOperation		varchar2(256) NOT NULL,
	SourceItems			varchar2(256) NOT NULL,
	SourceFolders			varchar2(256) NOT NULL,
	SourceItemIdsList		varchar2(256) NOT NULL,
	SourceItemSubjectsList		varchar2(256) NOT NULL,
	SourceItemAttachmentsList	varchar2(256) NOT NULL,
	SourceItemFolderPathNamesList	varchar2(256) NOT NULL,
	SourceFolderPathNamesList	varchar2(256) NOT NULL,
	ItemSubject			varchar2(256) NOT NULL,
	ItemAttachments			varchar2(256) NOT NULL,
	DirtyProperties			varchar2(256) NOT NULL,
	OriginatingServer		varchar2(256) NOT NULL
);
ALTER TABLE  EXOownerActivtsTest_DDD ADD constraint Pk_EXOownerActivtsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EXOownerActivtsTest_DDD ON EXOownerActivtsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EXOMsgCenTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOMsgCenTest_DDD
(
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	Msgs_ID		        varchar2(128) NOT NULL,
	Act_by		        varchar2(128) NOT NULL,
	Msg_title		varchar2(128) NOT NULL,
	Msgs		        varchar2(2000) NOT NULL,
	Published               varchar2(128) NOT NULL,
	Actn_DT		        varchar2(128) NOT NULL,
	Actn_Typ		varchar2(128) NOT NULL,
        Extnl_Link		varchar2(2000) NOT NULL,
	Urgency_Lvl             varchar2(2000) NOT NULL

);

ALTER TABLE  EXOMsgCenTest_DDD ADD CONSTRAINT PK_EXOMsgCenTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EXOMsgCenTest_DDD ON EXOMsgCenTest_DDD
(
 	MSMT_TIME
);


DROP TABLE EXOAdminActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EXOAdminActTest_DDD
(
	SITE_NAME		varchar2(64) NOT NULL,
	TRGT_HOST		varchar2(32) NOT NULL,
	PORT_NO			varchar2(32)NOT NULL,
	TEST_NAME		varchar2(64) NOT NULL,
	MEASURE			varchar2(64) NOT NULL,
	INFO			varchar2(128) NOT NULL,
	STATE			varchar2(32) NOT NULL,
	MSMT_HOST		varchar2(32) NOT NULL,
	MSMT_TIME		date NOT NULL,
	SEQ_NO			Number(16) NOT NULL,
	CREATIONTIME		varchar2(256) NOT NULL,
	OPERATION		varchar2(256) NOT NULL,
	CLIENTIP		varchar2(2000) NOT NULL,
	USERID			varchar2(256) NOT NULL,
	ORIGINATINGSERVER	varchar2(256) NOT NULL,
	PARAMETERS		varchar2(2000) NOT NULL,
	OPERATIONNAME		varchar2(512) NOT NULL,
	OPERATIONCOUNT		varchar2(256) NOT NULL,
	NUMBEROFOPERATIONS	varchar2(256) NOT NULL,
	OPERATIONSUNIQUE	varchar2(256) NOT NULL,
	OPERATIONSPERFORMED	varchar2(256) NOT NULL


);

ALTER TABLE  EXOAdminActTest_DDD ADD CONSTRAINT PK_EXOAdminActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EXOAdminActTest_DDD ON EXOAdminActTest_DDD
(
 	MSMT_TIME
);



DROP TABLE XMAppNameTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMAppNameTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Log_time                VARCHAR2(256) NOT NULL,
	Action		        VARCHAR2(256) NOT NULL,
	user_Name		VARCHAR2(256) NOT NULL,
	device_Id		VARCHAR2(256) NOT NULL,
	client_IP		VARCHAR2(256) NOT NULL,
	App_user_name           VARCHAR2(256) NOT NULL,
	application_Name	VARCHAR2(256) NOT NULL,
	receiver		VARCHAR2(256) NOT NULL,
	details			VARCHAR2(4000) NOT NULL
);

ALTER TABLE  XMAppNameTest_DDD ADD CONSTRAINT PK_XMAppNameTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XMAppNameTest_DDD ON XMAppNameTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XMAppLaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMAppLaunchTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Log_time                VARCHAR2(256) NOT NULL,
	Action		        VARCHAR2(256) NOT NULL,
	USER_NAME		VARCHAR2(256) NOT NULL,
	DEVICE_ID		VARCHAR2(256) NOT NULL,
	CLIENT_IP		VARCHAR2(256) NOT NULL,
	APP_USER_NAME           VARCHAR2(256) NOT NULL,
	APPLICATION_NAME	VARCHAR2(256) NOT NULL,
	RECEIVER		VARCHAR2(256) NOT NULL,
	DETAILS			VARCHAR2(4000) NOT NULL
);

ALTER TABLE  XMAppLaunchTest_DDD ADD CONSTRAINT PK_XMAppLaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMAppLaunchTest_DDD ON XMAppLaunchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AsAbapCenProcTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapCenProcTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Description	VARCHAR2(256) NOT NULL,
	Start_Time	 	VARCHAR2(256) NOT NULL,
	Elapsed_Time	VARCHAR2(256) NOT NULL);
ALTER TABLE  AsAbapCenProcTest_DDD ADD constraint Pk_AsAbapCenProcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapCenProcTest_DDD ON AsAbapCenProcTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EgSysLogAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EgSysLogAppTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVT_INFO	VARCHAR2(128) NOT NULL,
	EVT_HOST	VARCHAR2(128) NOT NULL,
	EVT_PROGRAM	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  EgSysLogAppTest_DDD ADD constraint Pk_EgSysLogAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


DROP TABLE EgSysLogSvrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EgSysLogSvrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVT_INFO	VARCHAR2(128) NOT NULL,
	EVT_HOST	VARCHAR2(128) NOT NULL,
	EVT_PROGRAM	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  EgSysLogSvrTest_DDD ADD constraint Pk_EgSysLogSvrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


DROP TABLE EgSyslogFilterTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EgSyslogFilterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVT_INFO	VARCHAR2(128) NOT NULL,
	EVT_HOST	VARCHAR2(128) NOT NULL,
	EVT_PROGRAM	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  EgSyslogFilterTest_DDD ADD constraint Pk_EgSyslogFilterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);



DROP TABLE EgSyslogFilterSvrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EgSyslogFilterSvrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVT_INFO	VARCHAR2(128) NOT NULL,
	EVT_HOST	VARCHAR2(128) NOT NULL,
	EVT_PROGRAM	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  EgSyslogFilterSvrTest_DDD ADD constraint Pk_EgSyslogFilterSvrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE JvmUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  JvmUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL
);

ALTER TABLE  JvmUptimeTest_DDD ADD constraint Pk_JvmUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_JvmUptimeTest_DDD ON JvmUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SHUT_JvmUptimeTest_DDD ON JvmUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REBOOT_JvmUptimeTest_DDD ON JvmUptimeTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE EventLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EventLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  EventLogTest_DDD ADD constraint Pk_EventLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EventLogTest_DDD ON EventLogTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_EventLogTest_DDD ON EventLogTest_DDD
(
 	EVENT_DATE
);

CREATE  INDEX IDX2_EventLogTest_DDD ON EventLogTest_DDD
(
 	EVENT_SOURCE
);

CREATE  INDEX IDX3_EventLogTest_DDD ON EventLogTest_DDD
(
 	EVENT_USER
);


DROP TABLE SecurityLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SecurityLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SecurityLogTest_DDD ADD constraint Pk_SecurityLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_SecurityLogTest_DDD ON SecurityLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_SecurityLogTest_DDD ON SecurityLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_SecurityLogTest_DDD ON SecurityLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_SecurityLogTest_DDD ON SecurityLogTest_DDD ( EVENT_USER );

DROP TABLE CtxLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CtxLoginTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	CLIENT_NAME	VARCHAR2(128) NOT NULL,
	CLIENT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	CLIENT_VERSION	VARCHAR2(128) NOT NULL,
	CLIENT_ID	VARCHAR2(128) NOT NULL,
	CLIENT_TYPE	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL);

ALTER TABLE  CtxLoginTest_DDD ADD constraint Pk_CtxLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxLoginTest_DDD ON CtxLoginTest_DDD
(
 	MSMT_TIME
);
CREATE INDEX IDX1_CTXLOGINTEST_DDD ON CTXLOGINTEST_DDD(DURATION, USERNAME);

DROP TABLE CtxAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxAppTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	CPU_UTIL	NUMBER(20,4) NOT NULL,
	MEMORY_UTIL	NUMBER(20,4) NOT NULL,
	PARENT_PID	NUMBER(16) NOT NULL,
	CLIENT_NAME	VARCHAR2(128) NOT NULL,
	VIRTUAL_MEMORY	NUMBER(20,4) NOT NULL,
	HANDLE_COUNT	NUMBER(20,4) NOT NULL,
	THREAD_COUNT	NUMBER(20,4) NOT NULL,
	DATA_IO 	NUMBER(20,4) NOT NULL,
	IO_OPERATIONS 	NUMBER(20,4) NOT NULL,
	IO_READS	NUMBER(20,4) NOT NULL,
	IO_WRITES	NUMBER(20,4) NOT NULL,
	PAGE_FAULTS	NUMBER(20,4) NOT NULL,
	IMAGE_PATH	VARCHAR2(2000) NOT NULL,
	WEBSITE_TITLE	VARCHAR2(2000) NOT NULL,
	WEBSITE_URL	VARCHAR2(2000) NOT NULL,
	WEBSITE_DOMAIN	VARCHAR2(2000) NOT NULL,
	MEMORY_USED	NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxAppTest_DDD ADD constraint Pk_CtxAppTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxAppTest_DDD ON CtxAppTest_DDD
(
 	MSMT_TIME,USERNAME,TRGT_HOST,PORT_NO
);

DROP TABLE CtxSessionTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CtxSessionTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME VARCHAR2(128) NOT NULL,
	SESSIONNAME VARCHAR2(128) NOT NULL,
	ID NUMBER(16) NOT NULL,
	CTX_STATE VARCHAR2(32) NOT NULL,
	IDLE_TIME VARCHAR2(32) NOT NULL,
	LOGON_TIME VARCHAR2(32) NOT NULL,
	CLIENT_NAME VARCHAR2(128) NOT NULL,
	CLIENT_IPADDRESS VARCHAR2(256) NOT NULL,
	CLIENT_VERSION VARCHAR2(128) NOT NULL,
	CLIENT_ID VARCHAR2(128) NOT NULL,
	CLIENT_TYPE VARCHAR2(256) NOT NULL,
	ASSOCIATE_GROUP VARCHAR2(256) NOT NULL,
	ENCRYPTION_LEVEL VARCHAR2(256) NOT NULL,
	CLIENT_COLOR_DEPTH VARCHAR2(256) NOT NULL,
	CLIENT_RESOLUTION VARCHAR2(256) NOT NULL
);

ALTER TABLE  CtxSessionTest_DDD ADD constraint Pk_CtxSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSessionTest_DDD ON CtxSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXpUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXpUserTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID				NUMBER(16) NOT NULL,
	ProcName		VARCHAR2(128) NOT NULL,
	Cpu_util			NUMBER(20,4) NOT NULL,
	Memory_util	NUMBER(20,4) NOT NULL,
	IO_reads 	NUMBER(20,4) NOT NULL,
	IO_writes	NUMBER (20,4) NOT NULL,
	Page_faults	NUMBER (20,4) NOT NULL,
	Virtual_memory	NUMBER (20,4) NOT NULL,
	Handles		NUMBER (20,4) NOT NULL,
	Published_dname VARCHAR2(256) NOT NULL,
	Parent_PID	NUMBER(16) NOT NULL,
	Username	VARCHAR2(64) NOT NULL,
	Image_path	VARCHAR2(2000) NOT NULL,
	Website_title	VARCHAR2(2000) NOT NULL,
	Website_url	VARCHAR2(2000) NOT NULL,
	Website_domain	VARCHAR2(2000) NOT NULL,
	Cpu_time	NUMBER(20,4) NOT NULL,
	Memory_used	NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxXpUserTest_DDD ADD constraint Pk_CtxXpUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXpUserTest_DDD ON CtxXpUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SystemEvtTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SystemEvtTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SystemEvtTest_DDD ADD constraint Pk_SystemEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SystemEvtTest_DDD ON SystemEvtTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_SystemEvtTest_DDD ON SystemEvtTest_DDD
(
 	EVENT_DATE
);

CREATE  INDEX IDX2_SystemEvtTest_DDD ON SystemEvtTest_DDD
(
 	EVENT_SOURCE
);

CREATE  INDEX IDX3_SystemEvtTest_DDD ON SystemEvtTest_DDD
(
 	EVENT_USER
);

DROP TABLE AppEvtTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppEvtTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppEvtTest_DDD ADD constraint Pk_AppEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AppEvtTest_DDD ON AppEvtTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_AppEvtTest_DDD ON AppEvtTest_DDD
(
 	EVENT_DATE
);

CREATE  INDEX IDX2_AppEvtTest_DDD ON AppEvtTest_DDD
(
 	EVENT_SOURCE
);

CREATE  INDEX IDX3_AppEvtTest_DDD ON AppEvtTest_DDD
(
 	EVENT_USER
);

DROP TABLE SystemEvtLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SystemEvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SystemEvtLogTest_DDD ADD constraint Pk_SystemEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_SystemEvtLogTest_DDD ON SystemEvtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_SystemEvtLogTest_DDD ON SystemEvtLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_SystemEvtLogTest_DDD ON SystemEvtLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_SystemEvtLogTest_DDD ON SystemEvtLogTest_DDD ( EVENT_USER );
 
DROP TABLE AppEvtLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppEvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppEvtLogTest_DDD ADD constraint Pk_AppEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_AppEvtLogTest_DDD ON AppEvtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_AppEvtLogTest_DDD ON AppEvtLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_AppEvtLogTest_DDD ON AppEvtLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_AppEvtLogTest_DDD ON AppEvtLogTest_DDD ( EVENT_USER );
CREATE INDEX IDX5_APPEVTLOGTEST_DDD ON APPEVTLOGTEST_DDD ( TRGT_HOST, MSMT_TIME);

DROP TABLE TermLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TermLoginTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  TermLoginTest_DDD ADD constraint Pk_TermLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TermLoginTest_DDD ON TermLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TermAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TermAppTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	CPU_UTIL	NUMBER(20,4) NOT NULL,
	MEMORY_UTIL	NUMBER(20,4) NOT NULL,
	WEBSITE_TITLE	VARCHAR2(2000) NOT NULL,
	WEBSITE_URL	VARCHAR2(2000) NOT NULL,
	WEBSITE_DOMAIN	VARCHAR2(2000) NOT NULL,
	VIRTUAL_MEMORY	NUMBER(20,4) NOT NULL,
	HANDLE_COUNT	NUMBER(20,4) NOT NULL,
	THREAD_COUNT	NUMBER(20,4) NOT NULL,
	DATA_IO 	NUMBER(20,4) NOT NULL,
	IO_OPERATIONS 	NUMBER(20,4) NOT NULL,
	IO_READS	NUMBER(20,4) NOT NULL,
	IO_WRITES	NUMBER(20,4) NOT NULL,
	PAGE_FAULTS	NUMBER(20,4) NOT NULL,
	MEMORY_USED	NUMBER(20,4) NOT NULL,
	Parent_pid		NUMBER(16) NOT NULL,
	PROCESS_INPUT_DELAY	NUMBER(20,4) NOT NULL,
	Image_path		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  TermAppTest_DDD ADD constraint Pk_TermAppTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TermAppTest_DDD ON TermAppTest_DDD
(
 	MSMT_TIME,USERNAME,TRGT_HOST,PORT_NO
);

DROP TABLE TermSessionTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TermSessionTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME VARCHAR2(128) NOT NULL,
	SESSIONNAME VARCHAR2(128) NOT NULL,
	ID NUMBER(16) NOT NULL,
	TERM_STATE VARCHAR2(32) NOT NULL,
	IDLE_TIME VARCHAR2(32) NOT NULL,
	LOGON_TIME VARCHAR2(32) NOT NULL
);

ALTER TABLE  TermSessionTest_DDD ADD constraint Pk_TermSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TermSessionTest_DDD ON TermSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TermUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TermUserTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	ProcName	VARCHAR2(128) NOT NULL,
	Cpu_util	NUMBER(20,4) NOT NULL,
	Memory_util	NUMBER(20,4) NOT NULL,
	IO_reads 	NUMBER(20,4) NOT NULL,	
	IO_writes	NUMBER (20,4) NOT NULL,
	Page_faults	NUMBER (20,4) NOT NULL,
	Virtual_memory	NUMBER (20,4) NOT NULL,
	Handles		NUMBER (20,4) NOT NULL,
	WEBSITE_TITLE	VARCHAR2(2000) NOT NULL,
	WEBSITE_URL	VARCHAR2(2000) NOT NULL,
	WEBSITE_DOMAIN	VARCHAR2(2000) NOT NULL,
	CPU_TIME	NUMBER(20,4) NOT NULL,
	Parent_pid		NUMBER(16) NOT NULL,
	Memory_used		NUMBER(20,4) NOT NULL,
	PROCESS_INPUT_DELAY	NUMBER(20,4) NOT NULL,
	Image_path		VARCHAR2(2000) NOT NULL
);
ALTER TABLE  TermUserTest_DDD ADD constraint Pk_TermUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TermUserTest_DDD ON TermUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  VmLoginTest_DDD ADD constraint Pk_VmLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmLoginTest_DDD ON VmLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  EsxLoginTest_DDD ADD constraint Pk_EsxLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxLoginTest_DDD ON EsxLoginTest_DDD
(
 	MSMT_TIME
);
create index idx1_EsxLoginTest_ddd on EsxLoginTest_ddd(measure);

DROP TABLE JvmThreadTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  JvmThreadTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Thread_name	VARCHAR2(512) NOT NULL,
	ThreadID	VARCHAR2(32) NOT NULL,
	Thread_state	VARCHAR2(256) NOT NULL,
	Thread_cpu_time VARCHAR2(32) NOT NULL,
	Pct_thread_cpu_time VARCHAR2(32) NOT NULL,
	Blocked_count	VARCHAR2(32) NOT NULL,
	Blocked_time	VARCHAR2(32) NOT NULL,
	Pct_blocked_time VARCHAR2(32) NOT NULL,
	Waited		VARCHAR2(32) NOT NULL,
	Waited_time	VARCHAR2(32) NOT NULL,
	Pct_waited_time VARCHAR2(32) NOT NULL,
	Stacktrace	VARCHAR2(2048) NOT NULL
);

ALTER TABLE  JvmThreadTest_DDD ADD constraint Pk_JvmThreadTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_JvmThreadTest_DDD ON JvmThreadTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxGuestStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxGuestStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL,
	USER_NAME	VARCHAR2(128) NOT NULL,
	NETSCALER_RPTNAME VARCHAR2(256) NOT NULL,
	NETSCALER_IP_ADDRESS VARCHAR2(128) NOT NULL,
	CONNECTED_IP_ADDRESS VARCHAR2(128) NOT NULL,
	ENDPOINT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	COUNTRY_NAME VARCHAR2(256) NOT NULL,
	COUNTRY_CODE VARCHAR2(256) NOT NULL,
	REGION VARCHAR2(256) NOT NULL,
	CITY VARCHAR2(256) NOT NULL,
	LATITUDE VARCHAR2(64) NOT NULL,
	LONGITUDE VARCHAR2(64) NOT NULL
);

ALTER TABLE  EsxGuestStatusTest_DDD ADD constraint Pk_EsxGuestStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxGuestStatusTest_DDD ON EsxGuestStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmGuestStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmGuestStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL,
	USER_NAME		VARCHAR2(128) NOT NULL
);

ALTER TABLE  VmGuestStatusTest_DDD ADD constraint Pk_VmGuestStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmGuestStatusTest_DDD ON VmGuestStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XenGuestStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XenGuestStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL,
	USERS           VARCHAR2(128) NOT NULL,
	NETSCALER_RPTNAME VARCHAR2(256) NOT NULL,
	NETSCALER_IP_ADDRESS VARCHAR2(128) NOT NULL,
	CONNECTED_IP_ADDRESS VARCHAR2(128) NOT NULL,
	ENDPOINT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	COUNTRY_NAME VARCHAR2(256) NOT NULL,
	COUNTRY_CODE VARCHAR2(256) NOT NULL,
	REGION VARCHAR2(256) NOT NULL,
	CITY VARCHAR2(256) NOT NULL,
	LATITUDE VARCHAR2(64) NOT NULL,
	LONGITUDE VARCHAR2(64) NOT NULL
);

ALTER TABLE  XenGuestStatusTest_DDD ADD constraint Pk_XenGuestStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenGuestStatusTest_DDD ON XenGuestStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE LdomsStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE LdomsStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  LdomsStatusTest_DDD ADD constraint Pk_LdomsStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_LdomsStatusTest_DDD ON LdomsStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VsGuestStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VsGuestStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  VsGuestStatusTest_DDD ADD constraint Pk_VsGuestStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VsGuestStatusTest_DDD ON VsGuestStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HvGuestStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE HvGuestStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL,
	USER_NAME 	VARCHAR2(128) NOT NULL,
	NETSCALER_RPTNAME VARCHAR2(256) NOT NULL,
	NETSCALER_IP_ADDRESS VARCHAR2(128) NOT NULL,
	CONNECTED_IP_ADDRESS VARCHAR2(128) NOT NULL,
	ENDPOINT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	COUNTRY_NAME VARCHAR2(256) NOT NULL,
	COUNTRY_CODE VARCHAR2(256) NOT NULL,
	REGION VARCHAR2(256) NOT NULL,
	CITY VARCHAR2(256) NOT NULL,
	LATITUDE VARCHAR2(64) NOT NULL,
	LONGITUDE VARCHAR2(64) NOT NULL
);

ALTER TABLE  HvGuestStatusTest_DDD ADD constraint Pk_HvGuestStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


CREATE  INDEX IDX_HvGuestStatusTest_DDD ON HvGuestStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VCHostsStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VCHostsStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL,
	HOSTNAME	VARCHAR2(128) NOT NULL,
	HOST_IP		VARCHAR2(128) NOT NULL
	);

ALTER TABLE  VCHostsStatusTest_DDD ADD constraint Pk_VCHostsStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCHostsStatusTest_DDD ON VCHostsStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ClusterResPoolTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  ClusterResPoolTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	HOSTNAME	VARCHAR2(128) NOT NULL,
	HOST_IP 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  ClusterResPoolTest_DDD ADD constraint Pk_ClusterResPoolTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ClusterResPoolTest_DDD ON ClusterResPoolTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VCClusterTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VCClusterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	HOSTNAME	VARCHAR2(128) NOT NULL,
	HOST_IP 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  VCClusterTest_DDD ADD constraint Pk_VCClusterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCClusterTest_DDD ON VCClusterTest_DDD
(
 	MSMT_TIME
);



DROP TABLE VCDataStoreTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VCDataStoreTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	HOSTNAME	VARCHAR2(4000) NOT NULL,
	HOST_IP 	VARCHAR2(4000) NOT NULL,
	CAPACITY	VARCHAR2(4000) NOT NULL,
	LUN_TARGET	VARCHAR2(128) NOT NULL
);

ALTER TABLE  VCDataStoreTest_DDD ADD constraint Pk_VCDataStoreTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCDataStoreTest_DDD ON VCDataStoreTest_DDD
(
 	MSMT_TIME
);




DROP TABLE VCDataCenterTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VCDataCenterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	HOSTNAME	VARCHAR2(128) NOT NULL,
	HOST_IP 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  VCDataCenterTest_DDD ADD constraint Pk_VCDataCenterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCDataCenterTest_DDD ON VCDataCenterTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WyseTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  WyseTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SystemName 	VARCHAR2(128) NOT NULL,
	SystemDesc 	VARCHAR2(256) NOT NULL,
	SerialNo 	VARCHAR2(128) NOT NULL,
	IP	 	VARCHAR2(128) NOT NULL,
	MAC	 	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  WyseTest_DDD ADD constraint Pk_WyseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_WyseTest_DDD ON WyseTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VCTaskEvtTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VCTaskEvtTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	TASKTYPE	VARCHAR2(128) NOT NULL,
	TASKNAME	VARCHAR2(128) NOT NULL,
	TARGET		VARCHAR2(128) NOT NULL,
	STATUS		VARCHAR2(2000) NOT NULL,
	INITIATEDBY	VARCHAR2(128) NOT NULL,
	TASKTIME	DATE NOT NULL,
	STARTTIME	VARCHAR2(128) NOT NULL,
	COMPLETEDTIME	VARCHAR2(128) NOT NULL
	);

ALTER TABLE  VCTaskEvtTest_DDD ADD constraint Pk_VCTaskEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCTaskEvtTest_DDD ON VCTaskEvtTest_DDD
(
 	MSMT_TIME,TASKTYPE,TASKNAME,TARGET
);

DROP TABLE VCEventsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VCEventsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENTTYPE	VARCHAR2(128) NOT NULL,
	DESCRIPTION	VARCHAR2(2000) NOT NULL,
	EVENTTIME	DATE NOT NULL,
	USERNAME		VARCHAR2(128) NOT NULL,
	DATACENTERNAME		VARCHAR2(128) NOT NULL,
	COMPUTERESOURCENAME	VARCHAR2(128) NOT NULL,
	ESXHOSTNAME	VARCHAR2(128) NOT NULL,
	VMNAME	VARCHAR2(128) NOT NULL
	);

ALTER TABLE  VCEventsTest_DDD ADD constraint Pk_VCEventsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCEventsTest_DDD ON VCEventsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VCVMotionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VCVMotionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENTTYPE	VARCHAR2(128) NOT NULL,
	DESCRIPTION	VARCHAR2(2000) NOT NULL,
	EVENTTIME	DATE NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL,
	SOURCEHOST	VARCHAR2(128) NOT NULL,
	DESTINATIONHOST	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	DATACENTERNAME	VARCHAR2(128) NOT NULL,
	SOURCECLUSTER	VARCHAR2(128) NOT NULL,
	TARGETCLUSTER	VARCHAR2(128) NOT NULL,
	DURATION	VARCHAR2(128) NOT NULL,
	SOURCEDATASTORE VARCHAR2(128) NOT NULL,
	TARGETDATASTORE VARCHAR2(128) NOT NULL
);

ALTER TABLE  VCVMotionTest_DDD ADD constraint Pk_VCVMotionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCVMotionTest_DDD ON VCVMotionTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_VCVMotionTest_DDD ON VCVMotionTest_DDD
(
 	EVENTTIME
);

DROP TABLE XenLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XenLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XenLoginTest_DDD ADD constraint Pk_XenLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenLoginTest_DDD ON XenLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  UptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  UptimeTest_DDD ADD constraint Pk_UptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UptimeTest_DDD ON UptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SHUT_UptimeTest_DDD ON UptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REBOOT_UptimeTest_DDD ON UptimeTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE DeviceUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  DeviceUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  DeviceUptimeTest_DDD ADD constraint Pk_DeviceUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DeviceUptimeTest_DDD ON DeviceUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SHUT_DeviceUptimeTest_DDD ON DeviceUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REBOT_DeviceUptimeTest_DDD ON DeviceUptimeTest_DDD
(
 	REBOOTEDDATE
);


DROP TABLE JvmMemoryDetailsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  JvmMemoryDetailsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CLASS_NAME 	VARCHAR2(128) NOT NULL,	
	INSTANCE_COUNT 	VARCHAR2(32) NOT NULL,	
	INSTANCE_PERCENTAGE 	VARCHAR2(32) NOT NULL,	
	MEMORY_USED 	VARCHAR2(32) NOT NULL,	
	PERCENTAGE_MEMORY_USED 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  JvmMemoryDetailsTest_DDD ADD constraint Pk_JvmMemoryDetailsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_JvmMemoryDetailsTest_DDD ON JvmMemoryDetailsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmgUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  VmgUptimeTest_DDD ADD constraint Pk_VmgUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgUptimeTest_DDD ON VmgUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SHUT_VmgUptimeTest_DDD ON VmgUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REBOOT_VmgUptimeTest_DDD ON VmgUptimeTest_DDD
(
 	REBOOTEDDATE
);

CREATE  INDEX IDX_INFO_VmgUptimeTest_DDD ON VmgUptimeTest_DDD
(
 	INFO
);

DROP TABLE XenFarmTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  XenFarmTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CONTROLLER_NAME	VARCHAR2(128) NOT NULL,
	IP_ADDRESS	VARCHAR2(128) NOT NULL,
	GROUP_NAME	VARCHAR2(128) NOT NULL,
	ASSINGN_BEHAVIOR VARCHAR2(128) NOT NULL,
	PRO_IPADDRESS	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	PROVIDER	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XenFarmTest_DDD ADD constraint Pk_XenFarmTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenFarmTest_DDD ON XenFarmTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VDLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VDLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  VDLoginTest_DDD ADD constraint Pk_VDLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VDLoginTest_DDD ON VDLoginTest_DDD
(
 	MSMT_TIME
);


DROP TABLE FarmDesktopsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FarmDesktopsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DESKTOP_NAME	VARCHAR2(128) NOT NULL,
	GROUP_NAME	VARCHAR2(128) NOT NULL,
	ASSIGNED_USER 	VARCHAR2(256) NOT NULL,
	LOGIN_USER 	VARCHAR2(128) NOT NULL,
	STATUS	 	VARCHAR2(128) NOT NULL	

);

ALTER TABLE  FarmDesktopsTest_DDD ADD constraint Pk_FarmDesktopsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FarmDesktopsTest_DDD ON FarmDesktopsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE DesktopGroupsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  DesktopGroupsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DESKTOP_NAME	VARCHAR2(128) NOT NULL,
	GROUP_NAME	VARCHAR2(128) NOT NULL,
	ASSIGNED_USER 	VARCHAR2(256) NOT NULL,
	LOGIN_USER 	VARCHAR2(128) NOT NULL,
	STATUS	 	VARCHAR2(128) NOT NULL	

);

ALTER TABLE  DesktopGroupsTest_DDD ADD constraint Pk_DesktopGroupsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DesktopGroupsTest_DDD ON DesktopGroupsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  EsxUptimeTest_DDD ADD constraint Pk_EsxUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxUptimeTest_DDD ON EsxUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SHUT_EsxUptimeTest_DDD ON EsxUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REBOOT_EsxUptimeTest_DDD ON EsxUptimeTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE CtxFarmUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxFarmUserTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID				NUMBER(16) NOT NULL,
	ProcName		VARCHAR2(128) NOT NULL,
	Cpu_util			NUMBER(20,4) NOT NULL,
	Memory_util	NUMBER(20,4) NOT NULL,
	IO_reads 	NUMBER(20,4) NOT NULL,
	IO_writes	NUMBER (20,4) NOT NULL,
	Page_faults	NUMBER (20,4) NOT NULL,
	Virtual_memory	NUMBER (20,4) NOT NULL,
	Handles		NUMBER (20,4) NOT NULL,
	Published_dname VARCHAR2(64) NOT NULL,
	Parent_PID	NUMBER(16) NOT NULL,
	Username	VARCHAR2(64) NOT NULL,
	Image_path	VARCHAR2(2000) NOT NULL,
	Website_title	VARCHAR2(2000) NOT NULL,
	Website_url	VARCHAR2(2000) NOT NULL,
	Website_domain	VARCHAR2(2000) NOT NULL,
	Cpu_time	NUMBER(20,4) NOT NULL,
	Memory_used	NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxFarmUserTest_DDD ADD constraint Pk_CtxFarmUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxFarmUserTest_DDD ON CtxFarmUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XenUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  XenUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  XenUptimeTest_DDD ADD constraint Pk_XenUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenUptimeTest_DDD ON XenUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_XenUptimeTest_DDD ON XenUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX2_XenUptimeTest_DDD ON XenUptimeTest_DDD
(
 	REBOOTEDDATE
);


DROP TABLE SybUserProcsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybUserProcsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LOGINNAME	VARCHAR2(128) NOT NULL,
	STATUSCOUNT	VARCHAR2(32) NOT NULL,
	STATUS		VARCHAR2(32) NOT NULL,
	PROGRAMNAME	VARCHAR2(30) NOT NULL,
	HOSTNAME	VARCHAR2(64) NOT NULL	
);

ALTER TABLE  SybUserProcsTest_DDD ADD constraint Pk_SybUserProcsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybUserProcsTest_DDD ON SybUserProcsTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SybLongRunQueryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybLongRunQueryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPID		VARCHAR2(128) NOT NULL,
	KPID		VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	APPLICATION	VARCHAR2(128) NOT NULL,
	BATCHID		VARCHAR2(64) NOT NULL,
	PROCEDUREID	VARCHAR2(128) NOT NULL,
	STARTTIME	VARCHAR2(128) NOT NULL,
	ELAPSEDTIME	VARCHAR2(64) NOT NULL,
	QUERY		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  SybLongRunQueryTest_DDD ADD constraint Pk_SybLongRunQueryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybLongRunQueryTest_DDD ON SybLongRunQueryTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SybStmtStatsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybStmtStatsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DBNAME		VARCHAR2(128) NOT NULL,
	BATCHID		VARCHAR2(64) NOT NULL,
	PROCEDUREID	VARCHAR2(128) NOT NULL,
	CPUTIME		VARCHAR2(64) NOT NULL,
	LOGICALREADS	VARCHAR2(64) NOT NULL,
	PHYSICALREADS	VARCHAR2(64) NOT NULL,
	PAGESMODIFIED	VARCHAR2(64) NOT NULL,
	WAITTIME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SybStmtStatsTest_DDD ADD constraint Pk_SybStmtStatsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybStmtStatsTest_DDD ON SybStmtStatsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SybMonDataCacheTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybMonDataCacheTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CACHEID		VARCHAR2(64) NOT NULL,
	OBJECTID	VARCHAR2(128) NOT NULL,
	INDEXID		VARCHAR2(64) NOT NULL,
	OWNERUSERID	VARCHAR2(64) NOT NULL,
	CACHEDMEMORY	VARCHAR2(256) NOT NULL,
	CACHENAME	VARCHAR2(128) NOT NULL,
	DBNAME		VARCHAR2(128) NOT NULL,
	OWNER		VARCHAR2(64) NOT NULL,
	OBJECT		VARCHAR2(64) NOT NULL,
	PROCESSESACCESSING	VARCHAR2(64) NOT NULL
);

ALTER TABLE  SybMonDataCacheTest_DDD ADD constraint Pk_SybMonDataCacheTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybMonDataCacheTest_DDD ON SybMonDataCacheTest_DDD
(
 	MSMT_TIME
);



DROP TABLE SybMonProcCacheTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybMonProcCacheTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	OBJECTID	VARCHAR2(128) NOT NULL,
	OWNERUID	VARCHAR2(64) NOT NULL,
	DBNAME		VARCHAR2(128) NOT NULL,
	MEMORYUSAGE	VARCHAR2(256) NOT NULL,
	OBJECT		VARCHAR2(128) NOT NULL,
	OBJECTTYPE	VARCHAR2(128) NOT NULL,
	OWNER		VARCHAR2(128) NOT NULL
);

ALTER TABLE  SybMonProcCacheTest_DDD ADD constraint Pk_SybMonProcCacheTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybMonProcCacheTest_DDD ON SybMonProcCacheTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SybProcessWaitTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybProcessWaitTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPID		VARCHAR2(64) NOT NULL,
	KPID		VARCHAR2(128) NOT NULL,
	LOGINNAME	VARCHAR2(128) NOT NULL,
	DBNAME		VARCHAR2(128) NOT NULL,
	WAITEVENTID	VARCHAR2(64) NOT NULL,
	DESCRIPTION	VARCHAR2(256) NOT NULL,
	TOTALTIMEWAITS	VARCHAR2(128) NOT NULL,
	TOTALWAITS	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SybProcessWaitTest_DDD ADD constraint Pk_SybProcessWaitTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybProcessWaitTest_DDD ON SybProcessWaitTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SybDeadLockTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybDeadLockTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DEADLOCKID	VARCHAR2(64) NOT NULL,
	VICTIM_KPID	VARCHAR2(128) NOT NULL,
	RESOLVETIME	VARCHAR2(128) NOT NULL,
	OBJECT_DBID	VARCHAR2(64) NOT NULL,
	OBJECT		VARCHAR2(128) NOT NULL,
	ROWNUMBER	VARCHAR2(64) NOT NULL,
	HELD_SPID	VARCHAR2(64) NOT NULL,
	HELD_KPID	VARCHAR2(128) NOT NULL,
	HELDUSERNAME	VARCHAR2(128) NOT NULL,
	HELDCOMMAND	VARCHAR2(128) NOT NULL,
	HELDLOCKTYPE	VARCHAR2(128) NOT NULL,
	WAIT_SPID	VARCHAR2(64) NOT NULL,
	WAIT_KPID	VARCHAR2(128) NOT NULL,
	WAITUSERNAME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SybDeadLockTest_DDD ADD constraint Pk_SybDeadLockTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybDeadLockTest_DDD ON SybDeadLockTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SybLockWaitTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybLockWaitTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPID		VARCHAR2(64) NOT NULL,
	KPID		VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	DBNAME		VARCHAR2(128) NOT NULL,
	LOCKID		VARCHAR2(64) NOT NULL,
	OBJECTID	VARCHAR2(128) NOT NULL,
	OBJECT		VARCHAR2(128) NOT NULL,
	LOCKSTATE	VARCHAR2(64) NOT NULL,
	LOCKTYPE	VARCHAR2(64) NOT NULL,
	LOCKLEVEL	VARCHAR2(64) NOT NULL,
	WAITTIME	VARCHAR2(64) NOT NULL,
	PAGENUMBER	VARCHAR2(64) NOT NULL,
	ROWNUMBER	VARCHAR2(64) NOT NULL
);

ALTER TABLE  SybLockWaitTest_DDD ADD constraint Pk_SybLockWaitTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybLockWaitTest_DDD ON SybLockWaitTest_DDD
(
 	MSMT_TIME
);


DROP TABLE SybErrorLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SybErrorLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPID		VARCHAR2(64) NOT NULL,
	KPID		VARCHAR2(64) NOT NULL,
	ENGINENUMBER	VARCHAR2(64) NOT NULL,
	ERRORNUMBER	VARCHAR2(64) NOT NULL,
	SEVERITY	VARCHAR2(64) NOT NULL,
	ERRORSTATE	VARCHAR2(64) NOT NULL,
	ERRORTIME	VARCHAR2(64) NOT NULL,
	ERRORMESSAGE	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SybErrorLogTest_DDD ADD constraint Pk_SybErrorLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybErrorLogTest_DDD ON SybErrorLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxPortGroupTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxPortGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL
);

ALTER TABLE  EsxPortGroupTest_DDD ADD constraint Pk_EsxPortGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxPortGroupTest_DDD ON EsxPortGroupTest_DDD
(
 	MSMT_TIME
);


DROP TABLE LparStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  LparStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  LparStatusTest_DDD ADD constraint Pk_LparStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_LparStatusTest_DDD ON LparStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgApplicationTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmgApplicationTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID		NUMBER(20,4) NOT NULL,
	CPU_UTIL	NUMBER(20,4) NOT NULL,
	MEMORY_UTIL	NUMBER(20,4) NOT NULL,
	PATH		VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	VM_NAME		VARCHAR2(128) NOT NULL,
	VM_IPADDRESS	VARCHAR2(2000) NOT NULL,
	CPU_USED_MHZ	NUMBER(20,4) NOT NULL,
	IO_READ		NUMBER(20,4) NOT NULL,
	IO_WRITE	NUMBER(20,4) NOT NULL,
	IO_READ_OPE	NUMBER(20,4) NOT NULL,
	IO_WRITE_OPE	NUMBER(20,4) NOT NULL);

ALTER TABLE  VmgApplicationTest_DDD ADD constraint Pk_VmgApplicationTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgApplicationTest_DDD ON VmgApplicationTest_DDD
(
 	MSMT_TIME,USERNAME,TRGT_HOST,PORT_NO
);


DROP TABLE HvLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvLoginTest_DDD ADD constraint Pk_HvLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HvLoginTest_DDD ON HvLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxFarmTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxFarmTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	FARM_NAME	VARCHAR2(128) NOT NULL,
	ZONE_NAME	VARCHAR2(128) NOT NULL,
	SERVER_NAME	VARCHAR2(128) NOT NULL,
	SERVER_IP_ADDRESS	VARCHAR2(256) NOT NULL
);

ALTER TABLE CtxFarmTest_DDD ADD constraint Pk_CtxFarmTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX_CtxFarmTest_DDD ON CtxFarmTest_DDD
(
 	MSMT_TIME
);


DROP TABLE CtxZonesTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxZonesTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	FARM_NAME	VARCHAR2(128) NOT NULL,
	ZONE_NAME	VARCHAR2(128) NOT NULL,
	SERVER_NAME	VARCHAR2(128) NOT NULL,
	SERVER_IP_ADDRESS	VARCHAR2(256) NOT NULL
);

ALTER TABLE CtxZonesTest_DDD ADD constraint Pk_CtxZonesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxZonesTest_DDD ON CtxZonesTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlSessionStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlSessionStTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SESSION_ID		VARCHAR2(32) NOT NULL,
	LOGIN_NAME		VARCHAR2(64) NOT NULL,
	STATUS			VARCHAR2(64) NOT NULL,
	ELAPSED_TIME		VARCHAR2(32) NOT NULL,
	CPU_TIME		VARCHAR2(32) NOT NULL,
	OPEN_TRANSACTION_COUNT	VARCHAR2(32) NOT NULL,
	OPEN_CURSOR_COUNT	VARCHAR2(32) NOT NULL,
	ACTIVE_REQUEST_COUNT	VARCHAR2(32) NOT NULL,
	BLOCKING_REQUEST_COUNT	VARCHAR2(32) NOT NULL,
	OPEN_RESULTSET_COUNT	VARCHAR2(32) NOT NULL,
	BLOCKED_REQUEST_COUNT	VARCHAR2(32) NOT NULL,
	NUMDISKREADS		VARCHAR2(32) NOT NULL,
	NUMDISKWRITES		VARCHAR2(32) NOT NULL,
	LOGICAL_READS		VARCHAR2(32) NOT NULL,
	ROW_COUNT		VARCHAR2(32) NOT NULL
);

ALTER TABLE  MsSqlSessionStTest_DDD ADD constraint Pk_MsSqlSessionStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlSessionStTest_DDD ON MsSqlSessionStTest_DDD
(
 	MSMT_TIME
);


DROP TABLE  MsSqlAppLCursorTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  MsSqlAppLCursorTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SESSION_ID		VARCHAR2(32) NOT NULL,
	LOGIN_NAME		VARCHAR2(64) NOT NULL,
	CURSOR_NAME		VARCHAR2(64) NOT NULL,	
	CREATION_TIME		VARCHAR2(64) NOT NULL,
	CURSOR_ELAPSED_TIME	VARCHAR2(64) NOT NULL,
	IS_OPEN			VARCHAR2(32) NOT NULL,
	WORKER_TIME		VARCHAR2(32) NOT NULL,
	NUM_DISK_READS		VARCHAR2(32) NOT NULL,
	NUM_DISK_WRITES		VARCHAR2(32) NOT NULL
);

ALTER TABLE  MsSqlAppLCursorTest_DDD ADD constraint Pk_MsSqlAppLCursorTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlAppLCursorTest_DDD ON MsSqlAppLCursorTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlQueryWaitTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlQueryWaitTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SESSION_ID		VARCHAR2(64) NOT NULL,
	LOGIN_NAME		VARCHAR2(64) NOT NULL,
	HOST_NAME		VARCHAR2(128) NOT NULL,
	PROGRAM_NAME		VARCHAR2(256) NOT NULL,
	WAIT_TIME		VARCHAR2(64) NOT NULL,
	TRANSACTION_ID		VARCHAR2(64) NOT NULL,
	Query_Text		VARCHAR2(1000) NOT NULL
);
ALTER TABLE  MsSqlQueryWaitTest_DDD ADD constraint Pk_MsSqlQueryWaitTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MsSqlQueryWaitTest_DDD ON MsSqlQueryWaitTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlLongRunQryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlLongRunQryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DBID		VARCHAR2(32) NOT NULL,		
	SESSION_ID	VARCHAR2(32) NOT NULL,
	LOGIN_NAME	VARCHAR2(64) NOT NULL,
	HOST_NAME	VARCHAR2(128) NOT NULL,
	PROGRAM_NAME	VARCHAR2(256) NOT NULL,
	AVGELAPSEDTIME  VARCHAR2(32) NOT NULL,
	TOTALELAPSEDTIME VARCHAR2(32) NOT NULL,
	CPUTIME		VARCHAR2(32) NOT NULL,
	CLIENT		VARCHAR2(32) NOT NULL,
	EXECUTE_COUNT	VARCHAR2(32) NOT NULL,
	LASTEXECUTIONTIME VARCHAR2(32) NOT NULL,
	STATEMENT	 VARCHAR2(2000) NOT NULL
);
ALTER TABLE  MsSqlLongRunQryTest_DDD ADD constraint Pk_MsSqlLongRunQryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MsSqlLongRunQryTest_DDD ON MsSqlLongRunQryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UserEnviron2008Test_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UserEnviron2008Test_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  UserEnviron2008Test_DDD ADD constraint Pk_UserEnviron2008Test_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UserEnviron2008Test_DDD ON UserEnviron2008Test_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_UserEnviron2008Test_DDD ON UserEnviron2008Test_DDD
(
 	EVENT_DATE
);

CREATE  INDEX IDX2_UserEnviron2008Test_DDD ON UserEnviron2008Test_DDD
(
 	EVENT_SOURCE
);

CREATE  INDEX IDX3_UserEnviron2008Test_DDD ON UserEnviron2008Test_DDD
(
 	EVENT_USER
);

DROP TABLE NetworkTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE NetworkTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	HOPCOUNT	NUMBER(16) NOT NULL,
	ROUTER		VARCHAR2(2000) NOT NULL,
	HOPDELAYS	VARCHAR2(2000) NOT NULL
);

ALTER TABLE NetworkTest_DDD ADD constraint Pk_NetworkTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NetworkTest_DDD ON NetworkTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DiskActivityTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE DiskActivityTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PROCESS_ID	NUMBER(16) NOT NULL,
	ProcessName	VARCHAR2(2000) NOT NULL,
	IO_RATE 	NUMBER(20,4) NOT NULL,
	IOREAD		NUMBER(20,4) NOT NULL,
	IOREADOPS	NUMBER(20,4) NOT NULL,
	IOWRITE		NUMBER(20,4) NOT NULL,
	IOWRITEOPS	NUMBER(20,4) NOT NULL,
	DeviceName	VARCHAR2(64) NOT NULL,
	Operation	VARCHAR2(64) NOT NULL,
	InputOutput	VARCHAR2(64) NOT NULL,
	Application_Name	VARCHAR2(2000) NOT NULL
);

ALTER TABLE DiskActivityTest_DDD ADD constraint Pk_DiskActivityTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DiskActivityTest_DDD ON DiskActivityTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OsHandleTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE OsHandleTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Process_Name	VARCHAR2(2000) NOT NULL,
	Handles_used	NUMBER(16) NOT NULL,
	Process_ID	NUMBER(16) NOT NULL,
	Parent_PID	NUMBER(16) NOT NULL,
	Sub_handles	VARCHAR2(2000) NOT NULL,
	Application_Name	VARCHAR2(2000) NOT NULL
);

ALTER TABLE OsHandleTest_DDD ADD constraint Pk_OsHandleTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OsHandleTest_DDD ON OsHandleTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OSMemoryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE OSMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Process_ID	NUMBER(16) NOT NULL,
	Mem		NUMBER(20,4) NOT NULL,
	Args		VARCHAR2(2000) NOT NULL,
	Users		VARCHAR2(2000) NOT NULL,
	Application_Name	VARCHAR2(2000) NOT NULL
);

ALTER TABLE OSMemoryTest_DDD ADD constraint Pk_OSMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OSMemoryTest_DDD ON OSMemoryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SystemTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE SystemTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Process_ID	NUMBER(16) NOT NULL,
	Util		NUMBER(20,4) NOT NULL,
	Args		VARCHAR2(2000) NOT NULL,
	Users		VARCHAR2(2000) NOT NULL,
	Application_Name	VARCHAR2(2000) NOT NULL
);

ALTER TABLE SystemTest_DDD ADD constraint Pk_SystemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SystemTest_DDD ON SystemTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CitrixLicenseTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CitrixLicenseTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Product_name		VARCHAR2(128) NOT NULL,
	Hostname		VARCHAR2(128) NOT NULL,
	Checkedout_product	VARCHAR2(128) NOT NULL,
	Client			VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	License_server_details	VARCHAR2(256) NOT NULL,
	License_handle		VARCHAR2(128) NOT NULL,
	Checkout_time		VARCHAR2(128) NOT NULL,
	Users_devices		VARCHAR2(2000) NOT NULL
);

ALTER TABLE CitrixLicenseTest_DDD ADD constraint Pk_CitrixLicenseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CitrixLicenseTest_DDD ON CitrixLicenseTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XDSiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE XDSiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SiteName		VARCHAR2(128) NOT NULL,
	License_Server_Name	VARCHAR2(128) NOT NULL,
	License_Server_Port 	VARCHAR2(64) NOT NULL
);

ALTER TABLE  XDSiteTest_DDD ADD constraint Pk_XDSiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDSiteTest_DDD ON XDSiteTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDControllerTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDControllerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Last_Access_Time	VARCHAR2(64) NOT NULL,
	Last_Start_Time		VARCHAR2(64) NOT NULL,
	Active_Site_Services 	VARCHAR2(1000) NOT NULL
);

ALTER TABLE  XDControllerTest_DDD ADD constraint Pk_XDControllerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDControllerTest_DDD ON XDControllerTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDHypervisorTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDHypervisorTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Hypervisor_IP_Address	VARCHAR2(256) NOT NULL
);

ALTER TABLE  XDHypervisorTest_DDD ADD constraint Pk_XDHypervisorTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDHypervisorTest_DDD ON XDHypervisorTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDCatalogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDCatalogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PVS_IP_Address	VARCHAR2(256) NOT NULL,
	PVS_Domain_Name	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDCatalogTest_DDD ADD constraint Pk_XDCatalogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDCatalogTest_DDD ON XDCatalogTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDBrokerMachineTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDBrokerMachineTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Catalog_Name			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	Hosted_Machine_Name		VARCHAR2(128) NOT NULL,
	Hypervisor_Connection_Name	VARCHAR2(128) NOT NULL,
	Last_Hosting_Update_Time	VARCHAR2(64) NOT NULL
);

ALTER TABLE  XDBrokerMachineTest_DDD ADD constraint Pk_XDBrokerMachineTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDBrokerMachineTest_DDD ON XDBrokerMachineTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XDGroupTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name 			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	Desktop_Kind			VARCHAR2(128) NOT NULL,
	OS_Type 			VARCHAR2(128) NOT NULL,
	Desktop_Group_Name 		VARCHAR2(128) NOT NULL,
	Catalog_Name			VARCHAR2(128) NOT NULL,
	Hosted_Machine_Name		VARCHAR2(128) NOT NULL,
	Hosted_Server_Name		VARCHAR2(128) NOT NULL,
	Hypervisor_Connection_Name	VARCHAR2(128) NOT NULL,
	Last_conn_reason		VARCHAR2(128) NOT NULL,
	Last_conn_time			VARCHAR2(128) NOT NULL,
	Last_connection_user		VARCHAR2(128) NOT NULL,
	Associated_user			VARCHAR2(128) NOT NULL,
	Power_state			VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDGroupTest_DDD ADD constraint Pk_XDGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDGroupTest_DDD ON XDGroupTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XDVDTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDVDTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	OS_Type				VARCHAR2(128) NOT NULL,
	Desktop_Group_Name 		VARCHAR2(128) NOT NULL,
	Hosted_Machine_Name 		VARCHAR2(128) NOT NULL,
	Hosted_Server_Name		VARCHAR2(128) NOT NULL,
	Hypervisor_Connection_Name	VARCHAR2(128) NOT NULL,
	User_Name			VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDVDTest_DDD ADD constraint Pk_XDVDTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDVDTest_DDD ON XDVDTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDVDLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDVDLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	Os_Type				VARCHAR2(128) NOT NULL,
	Brokering_Username		VARCHAR2(128) NOT NULL,
	Client_IP_Address 		VARCHAR2(128) NOT NULL,
	Client_Name			VARCHAR2(128) NOT NULL,
	Client_Version			VARCHAR2(128) NOT NULL,
	Connected_Via_Hostname		VARCHAR2(128) NOT NULL,
	Protocol			VARCHAR2(128) NOT NULL,
	Session_State			VARCHAR2(128) NOT NULL,
	Session_Start_Time		VARCHAR2(128) NOT NULL,
	Session_Brokering_Time		VARCHAR2(128) NOT NULL,
	Duration			NUMBER(20,4) NOT NULL,
	Desktop_License_ID		VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDVDLoginTest_DDD ADD constraint Pk_XDVDLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDVDLoginTest_DDD ON XDVDLoginTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDVDDisconnectTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDVDDisconnectTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	Client_IP_Address 		VARCHAR2(128) NOT NULL,
	Client_Name			VARCHAR2(128) NOT NULL,
	Session_State			VARCHAR2(128) NOT NULL,
	Session_Start_Time		VARCHAR2(128) NOT NULL,
	Duration			NUMBER(20,4) NOT NULL
);

ALTER TABLE  XDVDDisconnectTest_DDD ADD constraint Pk_XDVDDisconnectTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDVDDisconnectTest_DDD ON XDVDDisconnectTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDVDApplicationTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDVDApplicationTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name		VARCHAR2(128) NOT NULL,
	Executable_Path		VARCHAR2(1000) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Client_IP_Address 	VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_State		VARCHAR2(128) NOT NULL,
	Session_Start_Time	VARCHAR2(128) NOT NULL,
	Brokering_Time		VARCHAR2(128) NOT NULL,
	Catalog_Name		VARCHAR2(128) NOT NULL,
	Desktop_License_ID	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDVDApplicationTest_DDD ADD constraint Pk_XDVDApplicationTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDVDApplicationTest_DDD ON XDVDApplicationTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WinProcessTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE WinProcessTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(2000) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	HandleCount	NUMBER(16) NOT NULL,
	ThreadCount	NUMBER(16) NOT NULL,
	VirtualMemory	NUMBER(20,4) NOT NULL,
	Data_IO 	NUMBER(20,4) NOT NULL,
	IO_Operations 	NUMBER(20,4) NOT NULL,
	IO_Reads	NUMBER(20,4) NOT NULL,
	IO_Writes	 NUMBER(20,4) NOT NULL,
	PageFaults	 NUMBER(20,4) NOT NULL,
	WorkingSet	 NUMBER(20,4) NOT NULL,
	Parent_PID	 NUMBER(16) NOT NULL,
	Users		VARCHAR2(2000) NOT NULL
);

ALTER TABLE WinProcessTest_DDD ADD constraint Pk_WinProcessTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_WinProcessTest_DDD ON WinProcessTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PVSDeviceTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  PVSDeviceTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DEVICE_NAME	VARCHAR2(128) NOT NULL,
	DEVICE_MAC	VARCHAR2(128) NOT NULL,
	BOOT_FROM 	VARCHAR2(256) NOT NULL,
	DISK_LOC_NAME 	VARCHAR2(128) NOT NULL,
	IP_ADDRESS 	VARCHAR2(256) NOT NULL,
	SERVER_NAME 	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  PVSDeviceTest_DDD ADD constraint Pk_PVSDeviceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PVSDeviceTest_DDD ON PVSDeviceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmHostdLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmHostdLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NO_OF_LINES	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VmHostdLogTest_DDD ADD constraint Pk_VmHostdLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmHostdLogTest_DDD ON VmHostdLogTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmKernelTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmKernelTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NO_OF_LINES	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VmKernelTest_DDD ADD constraint Pk_VmKernelTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmKernelTest_DDD ON VmKernelTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmKWarningTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmKWarningTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NO_OF_LINES	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VmKWarningTest_DDD ADD constraint Pk_VmKWarningTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmKWarningTest_DDD ON VmKWarningTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmMessagesLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmMessagesLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NO_OF_LINES	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VmMessagesLogTest_DDD ADD constraint Pk_VmMessagesLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmMessagesLogTest_DDD ON VmMessagesLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxDiskUsageTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxDiskUsageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	FOLDER		VARCHAR2(128) NOT NULL,
	FILENAME	VARCHAR2(128) NOT NULL,
	FILESIZE 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  EsxDiskUsageTest_DDD ADD constraint Pk_EsxDiskUsageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxDiskUsageTest_DDD ON EsxDiskUsageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxGuestDvcStTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxGuestDvcStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DEVICENAME	VARCHAR2(128) NOT NULL,
	CONNSTATUS 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  EsxGuestDvcStTest_DDD ADD constraint Pk_EsxGuestDvcStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxGuestDvcStTest_DDD ON EsxGuestDvcStTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxVSwitchTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxVSwitchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME	VARCHAR2(128) NOT NULL,
	PHYNAME 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  EsxVSwitchTest_DDD ADD constraint Pk_EsxVSwitchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxVSwitchTest_DDD ON EsxVSwitchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxLunsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxLunsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL,
	VM_STATISTICS 	VARCHAR2(256) NOT NULL,
	LUN_NUMBER	VARCHAR2(128) NOT NULL,
	LUN_TYPE 	VARCHAR2(128) NOT NULL,
	LUN_HWACCELERATON	VARCHAR2(128) NOT NULL
);

ALTER TABLE  EsxLunsTest_DDD ADD constraint Pk_EsxLunsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxLunsTest_DDD ON EsxLunsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE EsxMemoryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL,
	VM_STATISTICS 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  EsxMemoryTest_DDD ADD constraint Pk_EsxMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxMemoryTest_DDD ON EsxMemoryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmNetTrafficTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmNetTrafficTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL,
	VM_STATISTICS 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  VmNetTrafficTest_DDD ADD constraint Pk_VmNetTrafficTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmNetTrafficTest_DDD ON VmNetTrafficTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgDiskActivityTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmgDiskActivityTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PROCESS_ID	NUMBER(16) NOT NULL,
	ProcessName	VARCHAR2(2000) NOT NULL,
	IO_RATE 	NUMBER(20,4) NOT NULL,
	IOREAD		NUMBER(20,4) NOT NULL,
	IOREADOPS	NUMBER(20,4) NOT NULL,
	IOWRITE		NUMBER(20,4) NOT NULL,
	IOWRITEOPS	NUMBER(20,4) NOT NULL
);

ALTER TABLE VmgDiskActivityTest_DDD ADD constraint Pk_VmgDiskActivityTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgDiskActivityTest_DDD ON VmgDiskActivityTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmgOsHandleTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmgOsHandleTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Process_Name	VARCHAR2(2000) NOT NULL,
	Handles_used	NUMBER(16) NOT NULL,
	Process_ID	NUMBER(16) NOT NULL,
	Parent_PID	NUMBER(16) NOT NULL
);

ALTER TABLE VmgOsHandleTest_DDD ADD constraint Pk_VmgOsHandleTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgOsHandleTest_DDD ON VmgOsHandleTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmgSystemTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmgSystemTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	CPU		NUMBER(20,4) NOT NULL,
	Memory_used	NUMBER(20,4) NOT NULL,
	Args		VARCHAR2(2000) NOT NULL
);

ALTER TABLE VmgSystemTest_DDD ADD constraint Pk_VmgSystemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgSystemTest_DDD ON VmgSystemTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmgWinServiceTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmgWinServiceTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Service_name	VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(64) NOT NULL,
	Startup_type	VARCHAR2(64) NOT NULL,
	ProcessID	NUMBER(16) NOT NULL,
	Path_to_executable	VARCHAR2(2000) NOT NULL
);

ALTER TABLE VmgWinServiceTest_DDD ADD constraint Pk_VmgWinServiceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgWinServiceTest_DDD ON VmgWinServiceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgOSMemoryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmgOSMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	Memory_used	NUMBER(20,4) NOT NULL,
	Args		VARCHAR2(2000) NOT NULL
);

ALTER TABLE VmgOSMemoryTest_DDD ADD constraint Pk_VmgOSMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgOSMemoryTest_DDD ON VmgOSMemoryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MsSqlSysProcsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE MsSqlSysProcsTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPID		VARCHAR2(32) NOT NULL,
	USER_NAME	VARCHAR2(128) NOT NULL,
	DB_NAME		VARCHAR2(128) NOT NULL,
	HOST_NAME	VARCHAR2(128) NOT NULL,
	PROGRAM_NAME	VARCHAR2(256) NOT NULL,
	LOGIN_TIME	VARCHAR2(32) NOT NULL,
	LAST_EXE_TIME	VARCHAR2(32) NOT NULL,
	WAIT_TIME	VARCHAR2(32) NOT NULL,
	WAIT_TYPE	VARCHAR2(32) NOT NULL,
	BLOCKING_SPID	VARCHAR2(32) NOT NULL,
	OPEN_TRANS	VARCHAR2(32) NOT NULL,
	PHYSICAL_IO	VARCHAR2(32) NOT NULL,
	MEM_USAGE	VARCHAR2(32) NOT NULL,
	IDLE_TIME	VARCHAR2(32) NOT NULL,
	COMMAND		VARCHAR2(2048) NOT NULL
);


ALTER TABLE  MsSqlSysProcsTest_DDD ADD constraint Pk_MsSqlSysProcsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlSysProcsTest_DDD ON MsSqlSysProcsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MsSqlConnsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE MsSqlConnsTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPID		VARCHAR2(32) NOT NULL,
	DB_NAME		VARCHAR2(128) NOT NULL,
	HOST_NAME	VARCHAR2(128) NOT NULL,
	PROGRAM_NAME	VARCHAR2(256) NOT NULL,
	LOGIN_TIME	VARCHAR2(32) NOT NULL,
	LAST_EXE_TIME	VARCHAR2(32) NOT NULL,
	WAIT_TIME	VARCHAR2(32) NOT NULL,
	WAIT_TYPE	VARCHAR2(32) NOT NULL,
	BLOCKING_SPID	VARCHAR2(32) NOT NULL,
	OPEN_TRANS	VARCHAR2(32) NOT NULL,
	PHYSICAL_IO	VARCHAR2(32) NOT NULL,
	MEM_USAGE	VARCHAR2(32) NOT NULL,
	IDLE_TIME	VARCHAR2(32) NOT NULL,
	COMMAND		VARCHAR2(2048) NOT NULL
);


ALTER TABLE  MsSqlConnsTest_DDD ADD constraint Pk_MsSqlConnsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlConnsTest_DDD ON MsSqlConnsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSInstUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AWSInstUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  AWSInstUptimeTest_DDD ADD constraint Pk_AWSInstUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSInstUptimeTest_DDD ON AWSInstUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SHUT_AWSInstUptimeTest_DDD ON AWSInstUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REB_AWSInstUptimeTest_DDD ON AWSInstUptimeTest_DDD
(
 	REBOOTEDDATE
);

CREATE  INDEX IDX_INFO_AWSInstUptimeTest_DDD ON AWSInstUptimeTest_DDD
(
 	INFO
);


DROP TABLE AWSEc2VmUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AWSEc2VmUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  AWSEc2VmUptimeTest_DDD ADD constraint Pk_AWSEc2VmUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSEc2VmUptimeTest_DDD ON AWSEc2VmUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SH_AWSEc2VmUptimeTest_DDD ON AWSEc2VmUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REB_AWSEc2VmUptimeTest_DDD ON AWSEc2VmUptimeTest_DDD
(
 	REBOOTEDDATE
);

CREATE  INDEX IDX_IN_AWSEc2VmUptimeTest_DDD ON AWSEc2VmUptimeTest_DDD
(
 	INFO
);

DROP TABLE AWSInstanceStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSInstanceStatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	INSTANCE_NAME	VARCHAR2(128) NOT NULL,
	INSTANCE_ID	VARCHAR2(128) NOT NULL,
	AMI_ID		VARCHAR2(128) NOT NULL,
	IP_ADDRESS      VARCHAR2(128) NOT NULL,
	OS		VARCHAR2(128) NOT NULL,
	TYPE 		VARCHAR2(128) NOT NULL,
	ZONE		VARCHAR2(128) NOT NULL,
	MONITORING	VARCHAR2(128) NOT NULL,
	PRIVT_IP	VARCHAR2(128) NOT NULL,
	PRVATE_DNS	VARCHAR2(128) NOT NULL,
	PUBLIC_DNS      VARCHAR2(128) NOT NULL,
	SECURITY_GRP	VARCHAR2(512) NOT NULL,
	VPC_ID 		VARCHAR2(128) NOT NULL,
	DEVICE_TYPE	VARCHAR2(128) NOT NULL,
	SUBNET_ID	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AWSInstanceStatTest_DDD ADD constraint Pk_AWSInstanceStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSInstanceStatTest_DDD ON AWSInstanceStatTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSChassisTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSChassisTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSChassisTest_DDD ADD constraint Pk_UCSChassisTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSChassisTest_DDD ON UCSChassisTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSChassisFanTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSChassisFanTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Module		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Tray		VARCHAR2(32) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSChassisFanTest_DDD ADD constraint Pk_UCSChassisFanTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSChassisFanTest_DDD ON UCSChassisFanTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSCsIOModuleTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSCsIOModuleTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Side		VARCHAR2(32) NOT NULL,
	Chassis_Id	VARCHAR2(32) NOT NULL,
	Fabric_Id	VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSCsIOModuleTest_DDD ADD constraint Pk_UCSCsIOModuleTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsIOModuleTest_DDD ON UCSCsIOModuleTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSCsIOMBPTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSCsIOMBPTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Slot_Id		VARCHAR2(32) NOT NULL,
	Chassis_Id	VARCHAR2(32) NOT NULL,
	Fabric_Id	VARCHAR2(32) NOT NULL,
	Port_type	VARCHAR2(32) NOT NULL,
	Role_type	VARCHAR2(32) NOT NULL,
	Network_type	VARCHAR2(32) NOT NULL,
	Transport_type	VARCHAR2(32) NOT NULL,
	Peer		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSCsIOMBPTest_DDD ADD constraint Pk_UCSCsIOMBPTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsIOMBPTest_DDD ON UCSCsIOMBPTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSCsIOMFPTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSCsIOMFPTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Slot_Id		VARCHAR2(32) NOT NULL,
	Chassis_Id	VARCHAR2(32) NOT NULL,
	Fabric_Id	VARCHAR2(32) NOT NULL,
	Port_type	VARCHAR2(32) NOT NULL,
	Role_type	VARCHAR2(32) NOT NULL,
	Network_type	VARCHAR2(32) NOT NULL,
	Transport_type	VARCHAR2(32) NOT NULL,
	Peer		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSCsIOMFPTest_DDD ADD constraint Pk_UCSCsIOMFPTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsIOMFPTest_DDD ON UCSCsIOMFPTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSCsPSUsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSCsPSUsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSCsPSUsTest_DDD ADD constraint Pk_UCSCsPSUsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsPSUsTest_DDD ON UCSCsPSUsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSCsServerTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSCsServerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	SoltId		VARCHAR2(32) NOT NULL,
	ChassisId	VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	uuid		VARCHAR2(128) NOT NULL,
	Profile		VARCHAR2(128) NOT NULL,
	OrgUuid		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSCsServerTest_DDD ADD constraint Pk_UCSCsServerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsServerTest_DDD ON UCSCsServerTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSCsFanModuleTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSCsFanModuleTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Tray		VARCHAR2(32) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSCsFanModuleTest_DDD ADD constraint Pk_UCSCsFanModuleTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsFanModuleTest_DDD ON UCSCsFanModuleTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSFIConnsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSFIConnsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSFIConnsTest_DDD ADD constraint Pk_UCSFIConnsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSFIConnsTest_DDD ON UCSFIConnsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSFIConnsFanTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSFIConnsFanTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Module		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Tray		VARCHAR2(32) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSFIConnsFanTest_DDD ADD constraint Pk_UCSFIConnsFanTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSFIConnsFanTest_DDD ON UCSFIConnsFanTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSFIConnsPSUsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSFIConnsPSUsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSFIConnsPSUsTest_DDD ADD constraint Pk_UCSFIConnsPSUsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSFIConnsPSUsTest_DDD ON UCSFIConnsPSUsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSFIConnsFCPTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSFIConnsFCPTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Slot_ID		VARCHAR2(32) NOT NULL,
	Port_Type	VARCHAR2(32) NOT NULL,
	Network_Type	VARCHAR2(32) NOT NULL,
	Transport_Type	VARCHAR2(64) NOT NULL,
	WWPN		VARCHAR2(32) NOT NULL,
	Mode_Type	VARCHAR2(32) NOT NULL
);

ALTER TABLE UCSFIConnsFCPTest_DDD ADD constraint Pk_UCSFIConnsFCPTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSFIConnsFCPTest_DDD ON UCSFIConnsFCPTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSFIConnsEthPTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSFIConnsEthPTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Slot_ID		VARCHAR2(32) NOT NULL,
	Port_Type	VARCHAR2(32) NOT NULL,
	Role_Type	VARCHAR2(32) NOT NULL,
	Transport_Type	VARCHAR2(32) NOT NULL,
	Network_Type	VARCHAR2(32) NOT NULL,
	MAC		VARCHAR2(32) NOT NULL,
	Mode_Type	VARCHAR2(32) NOT NULL
);

ALTER TABLE UCSFIConnsEthPTest_DDD ADD constraint Pk_UCSFIConnsEthPTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSFIConnsEthPTest_DDD ON UCSFIConnsEthPTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgDiskAlignTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmgDiskAlignTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Caption		VARCHAR2(128) NOT NULL,
	Device_id	VARCHAR2(128) NOT NULL,
	Log_par_name	VARCHAR2(128) NOT NULL,
	Block_size	VARCHAR2(128) NOT NULL
);

ALTER TABLE VmgDiskAlignTest_DDD ADD constraint Pk_VmgDiskAlignTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgDiskAlignTest_DDD ON VmgDiskAlignTest_DDD
(
 	MSMT_TIME
);
DROP TABLE BBerryAgtConTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BBerryAgtConTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USER_NAME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  BBerryAgtConTest_DDD ADD constraint Pk_BBerryAgtConTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_BBerryAgtConTest_DDD ON BBerryAgtConTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Apps2xTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Apps2xTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	CPU_UTIL	NUMBER(20,4) NOT NULL,
	MEMORY_UTIL	NUMBER(20,4) NOT NULL,
	PARENT_PID	NUMBER(16) NOT NULL	
);

ALTER TABLE  Apps2xTest_DDD ADD constraint Pk_Apps2xTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Apps2xTest_DDD ON Apps2xTest_DDD
(
 	MSMT_TIME,USERNAME,TRGT_HOST,PORT_NO
);

DROP TABLE VDCtrlLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VDCtrlLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  VDCtrlLoginTest_DDD ADD constraint Pk_VDCtrlLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VDCtrlLoginTest_DDD ON VDCtrlLoginTest_DDD
(
 	MSMT_TIME
);


DROP TABLE DGsCtrlTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  DGsCtrlTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DESKTOP_NAME	VARCHAR2(128) NOT NULL,
	GROUP_NAME	VARCHAR2(128) NOT NULL,
	ASSIGNED_USER 	VARCHAR2(256) NOT NULL,
	LOGIN_USER 	VARCHAR2(128) NOT NULL,
	STATUS	 	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  DGsCtrlTest_DDD ADD constraint Pk_DGsCtrlTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DGsCtrlTest_DDD ON DGsCtrlTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XDCtrlGroupTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE XDCtrlGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name 			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	Desktop_Kind			VARCHAR2(128) NOT NULL,
	OS_Type 			VARCHAR2(128) NOT NULL,
	Desktop_Group_Name 		VARCHAR2(128) NOT NULL,
	Catalog_Name			VARCHAR2(128) NOT NULL,
	Hosted_Machine_Name		VARCHAR2(128) NOT NULL,
	Hosted_Server_Name		VARCHAR2(128) NOT NULL,
	Hypervisor_Connection_Name	VARCHAR2(128) NOT NULL,
	Controller_Name			VARCHAR2(128) NOT NULL,
	Last_conn_reason		VARCHAR2(128) NOT NULL,
	Last_conn_time			VARCHAR2(128) NOT NULL,
	Last_connection_user		VARCHAR2(128) NOT NULL,
	Associated_user			VARCHAR2(128) NOT NULL,
	Power_state			VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDCtrlGroupTest_DDD ADD constraint Pk_XDCtrlGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDCtrlGroupTest_DDD ON XDCtrlGroupTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XDCtrlVDTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDCtrlVDTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	OS_Type				VARCHAR2(128) NOT NULL,
	Desktop_Group_Name 		VARCHAR2(128) NOT NULL,
	Hosted_Machine_Name 		VARCHAR2(128) NOT NULL,
	Hosted_Server_Name		VARCHAR2(128) NOT NULL,
	Hypervisor_Connection_Name	VARCHAR2(128) NOT NULL,
	User_Name			VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDCtrlVDTest_DDD ADD constraint Pk_XDCtrlVDTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDCtrlVDTest_DDD ON XDCtrlVDTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDVDCtrlLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDVDCtrlLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	Os_Type				VARCHAR2(128) NOT NULL,
	Brokering_Username		VARCHAR2(128) NOT NULL,
	Client_IP_Address 		VARCHAR2(128) NOT NULL,
	Client_Name			VARCHAR2(128) NOT NULL,
	Client_Version			VARCHAR2(128) NOT NULL,
	Connected_Via_Hostname		VARCHAR2(128) NOT NULL,
	Protocol			VARCHAR2(128) NOT NULL,
	Session_State			VARCHAR2(128) NOT NULL,
	Session_Start_Time		VARCHAR2(128) NOT NULL,
	Session_Brokering_Time		VARCHAR2(128) NOT NULL,
	Duration			NUMBER(20,4) NOT NULL,
	Desktop_License_ID		VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDVDCtrlLoginTest_DDD ADD constraint Pk_XDVDCtrlLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDVDCtrlLoginTest_DDD ON XDVDCtrlLoginTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XDVDCtrlDisconTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDVDCtrlDisconTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	Client_IP_Address 		VARCHAR2(128) NOT NULL,
	Client_Name			VARCHAR2(128) NOT NULL,
	Session_State			VARCHAR2(128) NOT NULL,
	Session_Start_Time		VARCHAR2(128) NOT NULL,
	Duration			NUMBER(20,4) NOT NULL,
	User_name			VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDVDCtrlDisconTest_DDD ADD constraint Pk_XDVDCtrlDisconTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDVDCtrlDisconTest_DDD ON XDVDCtrlDisconTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SybSysProcessTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE SybSysProcessTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPID		VARCHAR2(32) NOT NULL,
	STATUS		VARCHAR2(128) NOT NULL,
	USER_NAME	VARCHAR2(128) NOT NULL,
	DB_NAME		VARCHAR2(128) NOT NULL,
	HOST_NAME	VARCHAR2(128) NOT NULL,
	PROGRAM_NAME	VARCHAR2(30) NOT NULL,
	BLOCKING_SPID	VARCHAR2(32) NOT NULL,
	TIME_BLOCKED	VARCHAR2(32) NOT NULL,
	CPU		VARCHAR2(32) NOT NULL,
	PHYSICAL_IO	VARCHAR2(32) NOT NULL,
	MEM_USAGE	VARCHAR2(32) NOT NULL,
	COMMAND		VARCHAR2(2048) NOT NULL
);

ALTER TABLE  SybSysProcessTest_DDD ADD constraint Pk_SybSysProcessTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SybSysProcessTest_DDD ON SybSysProcessTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SlowTransTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SlowTransTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	TIMESTAMP 	VARCHAR2(32) NOT NULL,
	URL	  	VARCHAR2(1000) NOT NULL,
	USERNAME 	VARCHAR2(32) NOT NULL,
	CLIENTIP 	VARCHAR2(32) NOT NULL,
	RESTIME 	VARCHAR2(32) NOT NULL,
	DATATRANS 	VARCHAR2(32) NOT NULL		
);

ALTER TABLE  SlowTransTest_DDD ADD constraint Pk_SlowTransTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX_SlowTransTest_DDD ON SlowTransTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NetFlowTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE NetFlowTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	InputIfaceName			VARCHAR2(128) NOT NULL,
	InputSpeed			Number(20,4) NOT NULL,
	OutputIfaceName			VARCHAR2(128) NOT NULL,
	OutputSpeed 			Number(20,4) NOT NULL);

ALTER TABLE  NetFlowTest_DDD ADD constraint Pk_NetFlowTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NetFlowTest_DDD ON NetFlowTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TopSrcFlowTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE TopSrcFlowTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SrcHost			VARCHAR2(128) NOT NULL,
	SrcPort			VARCHAR2(128) NOT NULL,
	DstHost			VARCHAR2(128) NOT NULL,
	DstPort 		VARCHAR2(128) NOT NULL,
	FlowData 		Number(20,4) NOT NULL,
	FlowPackets 		Number(20,4) NOT NULL);

ALTER TABLE  TopSrcFlowTest_DDD ADD constraint Pk_TopSrcFlowTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TopSrcFlowTest_DDD ON TopSrcFlowTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TopDstFlowTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE TopDstFlowTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SrcHost			VARCHAR2(128) NOT NULL,
	SrcPort			VARCHAR2(128) NOT NULL,
	DstHost			VARCHAR2(128) NOT NULL,
	DstPort 		VARCHAR2(128) NOT NULL,
	FlowData 		Number(20,4) NOT NULL,
	FlowPackets 		Number(20,4) NOT NULL);

ALTER TABLE  TopDstFlowTest_DDD ADD constraint Pk_TopDstFlowTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TopDstFlowTest_DDD ON TopDstFlowTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraSessionTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE OraSessionTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	SID             VARCHAR2(32)    NOT NULL,
	SERIAL          VARCHAR2(32)    NOT NULL,
	USER_NAME       VARCHAR2(128)   NOT NULL,
	OS_USER         VARCHAR2(128)   NOT NULL,
	MACHINE_NAME    VARCHAR2(128)   NOT NULL,
	TERMINAL_NAME   VARCHAR2(128)   NOT NULL,
	PROGRAM_NAME    VARCHAR2(64)   NOT NULL,
	MODULE          VARCHAR2(128)   NOT NULL,
	LAST_CALL       VARCHAR2(32)    NOT NULL,
	BLOCKING_SPID   VARCHAR2(32)    NOT NULL,
	COMMAND         VARCHAR2(2048)  NOT NULL
);

ALTER TABLE  OraSessionTest_DDD ADD constraint Pk_OraSessionTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraSessionTest_DDD ON OraSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraConnectionsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE OraConnectionsTest_DDD
(
	SITE_NAME       VARCHAR2(64)   NOT NULL,
	TRGT_HOST       VARCHAR2(32)   NOT NULL,
	PORT_NO         VARCHAR2(32)   NOT NULL,
	TEST_NAME       VARCHAR2(64)   NOT NULL,
	MEASURE         VARCHAR2(64)   NOT NULL,
	INFO            VARCHAR2(128)  NOT NULL,
	STATE           VARCHAR2(32)   NOT NULL,
	MSMT_HOST       VARCHAR2(32)   NOT NULL,
	MSMT_TIME       DATE           NOT NULL,
	SEQ_NO          NUMBER(16)     NOT NULL,
	SID             VARCHAR2(32)   NOT NULL,
	SERIAL          VARCHAR2(32)   NOT NULL,
	OS_USER         VARCHAR2(128)  NOT NULL,
	MACHINE_NAME    VARCHAR2(128)  NOT NULL,
	TERMINAL_NAME   VARCHAR2(128)  NOT NULL,
	PROGRAM_NAME    VARCHAR2(64)  NOT NULL,
	MODULE          VARCHAR2(128)  NOT NULL,
	LAST_CALL       VARCHAR2(32)   NOT NULL,
	BLOCKING_SPID   VARCHAR2(32)   NOT NULL,
	COMMAND         VARCHAR2(2048) NOT NULL
);

ALTER TABLE  OraConnectionsTest_DDD ADD constraint Pk_OraConnectionsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraConnectionsTest_DDD ON OraConnectionsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NetworkInterfaceTest_DDD CASCADE CONSTRAINTS;
 
CREATE TABLE NetworkInterfaceTest_DDD
(
 SITE_NAME  VARCHAR2(64) NOT NULL,
 TRGT_HOST  VARCHAR2(32) NOT NULL,
 PORT_NO   VARCHAR2(32) NOT NULL,
 TEST_NAME  VARCHAR2(64) NOT NULL,
 MEASURE        VARCHAR2(64) NOT NULL,
 INFO           VARCHAR2(128) NOT NULL,
 STATE          VARCHAR2(32) NOT NULL,
 MSMT_HOST      VARCHAR2(32) NOT NULL,
 MSMT_TIME      DATE NOT NULL,
 SEQ_NO    NUMBER(16) NOT NULL,
 SrcHost   VARCHAR2(128) NOT NULL,
 DstHost   VARCHAR2(128) NOT NULL,
 FlowData   Number(20,4) NOT NULL,
 FlowPackets   Number(20,4) NOT NULL,
 PCTFlow  Number(20,4) NOT NULL,
 Direction VARCHAR2(128) NOT NULL
);
 
ALTER TABLE  NetworkInterfaceTest_DDD ADD constraint Pk_NetworkInterfaceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
 
CREATE  INDEX IDX_NetworkInterfaceTest_DDD ON NetworkInterfaceTest_DDD
(
  MSMT_TIME
);

DROP TABLE OraScanTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraScanTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SQL_ID			VARCHAR2(32) NOT NULL,
	HASH_VALUE		VARCHAR2(64) NOT NULL,
	ADDRESS			VARCHAR2(64) NOT NULL,
	SQL_QUERY		VARCHAR2(1000) NOT NULL,
	ACCESS_MODE		VARCHAR2(64) NOT NULL,
	OBJECT_NAME		VARCHAR2(64) NOT NULL,
	OBJECT_OWNER		VARCHAR2(128) NOT NULL,
	EXECUTIONS		VARCHAR2(64) NOT NULL
);

ALTER TABLE  OraScanTest_DDD ADD constraint Pk_OraScanTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraScanTest_DDD ON OraScanTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSEc2VmStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AWSEc2VmStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	INSTANCE_NAME	VARCHAR2(128) NOT NULL,
	INSTANCE_ID	VARCHAR2(128) NOT NULL,
	AMI_ID		VARCHAR2(128) NOT NULL,
	IP_ADDRESS      VARCHAR2(128) NOT NULL,
	PRIV_IP_ADDR    VARCHAR2(128) NOT NULL,
	OS		VARCHAR2(128) NOT NULL,
	TYPE 		VARCHAR2(128) NOT NULL,
	ZONE		VARCHAR2(128) NOT NULL,
	MONITORING	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AWSEc2VmStatusTest_DDD ADD constraint Pk_AWSEc2VmStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSEc2VmStatusTest_DDD ON AWSEc2VmStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OraVBoxStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraVBoxStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  OraVBoxStatusTest_DDD ADD constraint Pk_OraVBoxStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraVBoxStatusTest_DDD ON OraVBoxStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OraVdiPoolTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraVdiPoolTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID_NAME		VARCHAR2(128) NOT NULL,
	DESKTOPNAME	VARCHAR2(128) NOT NULL,
	USER_NAME 	VARCHAR2(128) NOT NULL,
	DOMAIN	 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  OraVdiPoolTest_DDD ADD constraint Pk_OraVdiPoolTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraVdiPoolTest_DDD ON OraVdiPoolTest_DDD
(
 	MSMT_TIME
);



DROP TABLE OraVdiDeskStaTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraVdiDeskStaTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID_NAME		VARCHAR2(128) NOT NULL,
	DESKTOPNAME	VARCHAR2(128) NOT NULL,
	USER_NAME 	VARCHAR2(128) NOT NULL,
	DOMAIN	 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  OraVdiDeskStaTest_DDD ADD constraint Pk_OraVdiDeskStaTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraVdiDeskStaTest_DDD ON OraVdiDeskStaTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraVBoxLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraVBoxLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  OraVBoxLoginTest_DDD ADD constraint Pk_OraVBoxLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraVBoxLoginTest_DDD ON OraVBoxLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE vCldOrgTaskStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  vCldOrgTaskStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	TASK		VARCHAR2(128) NOT NULL,
	TARGET		VARCHAR2(128) NOT NULL,
	STATUS		VARCHAR2(2000) NOT NULL,
	INITIATEDBY	VARCHAR2(128) NOT NULL,
	STARTTIME	VARCHAR2(128) NOT NULL,
	COMPLETEDTIME	VARCHAR2(128) NOT NULL,
	DURATION	VARCHAR2(128) NOT NULL,
	DESCRIPTION	VARCHAR2(128) NOT NULL
	);

ALTER TABLE  vCldOrgTaskStTest_DDD ADD constraint Pk_vCldOrgTaskStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_vCldOrgTaskStTest_DDD ON vCldOrgTaskStTest_DDD
(
 	MSMT_TIME,TASK,TARGET
);

DROP TABLE vCldOrgDetailsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  vCldOrgDetailsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_NAME		VARCHAR2(128) NOT NULL,
	IP_ADD		VARCHAR2(128) NOT NULL,
	OS	 	VARCHAR2(256) NOT NULL,
	VM_STATE 	VARCHAR2(128) NOT NULL,
	CPU		VARCHAR2(128) NOT NULL,
	MEMORY_SIZE	VARCHAR2(128) NOT NULL,
	HARDDISK_SIZE	VARCHAR2(128) NOT NULL
);

ALTER TABLE  vCldOrgDetailsTest_DDD ADD constraint Pk_vCldOrgDetailsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_vCldOrgDetailsTest_DDD ON vCldOrgDetailsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE vCldProviderVdcTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  vCldProviderVdcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ORG_NAME	VARCHAR2(128) NOT NULL,
	VDC_NAME	VARCHAR2(128) NOT NULL,
	RESOURCES 	VARCHAR2(128) NOT NULL
	);

ALTER TABLE  vCldProviderVdcTest_DDD ADD constraint Pk_vCldProviderVdcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_vCldProviderVdcTest_DDD ON vCldProviderVdcTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlIndexFragTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  MsSqlIndexFragTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	OBJECT_ID	NUMBER(16) NOT NULL,
	OBJECT_NAME	VARCHAR2(64) NOT NULL,
	INDEX_ID	NUMBER(16) NOT NULL,
	INDEX_NAME	VARCHAR2(64) NOT NULL,
	AVG_FRAGMENTATION NUMBER(20,4) NOT NULL
);

ALTER TABLE  MsSqlIndexFragTest_DDD ADD constraint Pk_MsSqlIndexFragTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlIndexFragTest_DDD ON MsSqlIndexFragTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraIndexFragTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraIndexFragTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	OWNER			VARCHAR2(64) NOT NULL,
	TABLE_NAME		VARCHAR2(64) NOT NULL,
	INDEX_NAME		VARCHAR2(64) NOT NULL,
	FRAGMENTATION_INFO	NUMBER(20,4) NOT NULL
);

ALTER TABLE  OraIndexFragTest_DDD ADD constraint Pk_OraIndexFragTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraIndexFragTest_DDD ON OraIndexFragTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RHEVMDataCenTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RHEVMDataCenTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Host_name	VARCHAR2(128) NOT NULL,
	Host_address 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  RHEVMDataCenTest_DDD ADD constraint Pk_RHEVMDataCenTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RHEVMDataCenTest_DDD ON RHEVMDataCenTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RHEVMStorageTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RHEVMStorageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Host_name	VARCHAR2(128) NOT NULL,
	Host_address 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  RHEVMStorageTest_DDD ADD constraint Pk_RHEVMStorageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RHEVMStorageTest_DDD ON RHEVMStorageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RHEVMClusterTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RHEVMClusterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_name		VARCHAR2(128) NOT NULL,
	VM_state 	VARCHAR2(256) NOT NULL,
	Host_name	VARCHAR2(256) NOT NULL,
	Host_ip 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  RHEVMClusterTest_DDD ADD constraint Pk_RHEVMClusterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RHEVMClusterTest_DDD ON RHEVMClusterTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RHEVVMStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RHEVVMStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL,
	USER_NAME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  RHEVVMStatusTest_DDD ADD constraint Pk_RHEVVMStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RHEVVMStatusTest_DDD ON RHEVVMStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RHEVHostProcTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RHEVHostProcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VmName		VARCHAR2(128) NOT NULL,
	CpuUtil 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  RHEVHostProcTest_DDD ADD constraint Pk_RHEVHostProcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RHEVHostProcTest_DDD ON RHEVHostProcTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RHEVHostMemTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RHEVHostMemTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VmName		VARCHAR2(128) NOT NULL,
	ConfigMem 	VARCHAR2(256) NOT NULL,
	UsedMem 	VARCHAR2(256) NOT NULL,
	MemUtil 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  RHEVHostMemTest_DDD ADD constraint Pk_RHEVHostMemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RHEVHostMemTest_DDD ON RHEVHostMemTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UCSCsSrvNicsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE UCSCsSrvNicsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	ID		VARCHAR2(32) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL,
	vNIC		VARCHAR2(128) NOT NULL,
	PCIe_Address	VARCHAR2(128) NOT NULL,
	MAC		VARCHAR2(64) NOT NULL,
	Original_MAC	VARCHAR2(64) NOT NULL,
	Purpose		VARCHAR2(64) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Type		VARCHAR2(64) NOT NULL
);

ALTER TABLE UCSCsSrvNicsTest_DDD ADD constraint Pk_UCSCsSrvNicsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsSrvNicsTest_DDD ON UCSCsSrvNicsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UCSLanCloudPcTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSLanCloudPcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	ID		VARCHAR2(32) NOT NULL,
	Fabric_Id	VARCHAR2(64) NOT NULL,
	Type		VARCHAR2(64) NOT NULL,
	Port_Type	VARCHAR2(64) NOT NULL,
	Transport	VARCHAR2(64) NOT NULL,
	Flow_Control_Policy	VARCHAR2(64) NOT NULL,
	Name		VARCHAR2(64) NOT NULL
);

ALTER TABLE UCSLanCloudPcTest_DDD ADD constraint Pk_UCSLanCloudPcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSLanCloudPcTest_DDD ON UCSLanCloudPcTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UCSLanCloudPcEpTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSLanCloudPcEpTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	ID		VARCHAR2(32) NOT NULL,
	Slot_Id		VARCHAR2(32) NOT NULL,
	Fabric_Id	VARCHAR2(64) NOT NULL,
	Membership	VARCHAR2(64) NOT NULL,
	Type		VARCHAR2(64) NOT NULL,
	IfRole		VARCHAR2(64) NOT NULL,
	IfType		VARCHAR2(64) NOT NULL,
	Transport	VARCHAR2(64) NOT NULL,
	Port		VARCHAR2(64) NOT NULL,
	Locale		VARCHAR2(64) NOT NULL,
	Name		VARCHAR2(64) NOT NULL
);

ALTER TABLE UCSLanCloudPcEpTest_DDD ADD constraint Pk_UCSLanCloudPcEpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSLanCloudPcEpTest_DDD ON UCSLanCloudPcEpTest_DDD
(
 	MSMT_TIME
);

DROP TABLE JavaTransactionsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  JavaTransactionsTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	REQUEST_TIME	DATE NOT NULL,
	URI		VARCHAR2(512) NOT NULL,
	REMOTE_HOST	VARCHAR2(256) NOT NULL,
	TOT_RESP_TIME	NUMBER(20,4) NOT NULL,
	SUBCOMP_DETAILS	VARCHAR2(1024) NOT NULL,
	URL_TREE	VARCHAR2(4000) NOT NULL
);


ALTER TABLE  JavaTransactionsTest_DDD ADD constraint Pk_JavaTransactionsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_JavaTransactionsTest_DDD ON JavaTransactionsTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_JavaTransactionsTest_DDD ON JavaTransactionsTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_JavaTransactionsTest_DDD ON JavaTransactionsTest_DDD
(
 	MSMT_TIME,SEQ_NO
);

CREATE  INDEX IDX3_JavaTransactionsTest_DDD ON JavaTransactionsTest_DDD
(
     REQUEST_TIME
);


DROP TABLE NAUSDConsoleLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NAUSDConsoleLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MSG		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NAUSDConsoleLogTest_DDD ADD constraint Pk_NAUSDConsoleLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NAUSDConsoleLogTest_DDD ON NAUSDConsoleLogTest_DDD
(
	MSMT_TIME
);

DROP TABLE MsSqlTabSizeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  MsSqlTabSizeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,

	TABLE_NAME	 VARCHAR2(128) NOT NULL,
	ROW_COUNTS       NUMBER(16) NOT NULL,
	TOTAL_SPACE_GB   NUMBER(20,4) NOT NULL,
	USED_SPACE_GB    NUMBER(20,4) NOT NULL,
	UNUSED_SPACE_GB  NUMBER(20,4) NOT NULL
);

ALTER TABLE  MsSqlTabSizeTest_DDD ADD constraint Pk_MsSqlTabSizeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlTabSizeTest_DDD ON MsSqlTabSizeTest_DDD
(
 	MSMT_TIME
);


CREATE  INDEX IDX_USED_MsSqlTabSizeTest_DDD ON  MsSqlTabSizeTest_DDD
(
	USED_SPACE_GB
);


DROP TABLE CtxNsUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CtxNsUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  CtxNsUptimeTest_DDD ADD constraint Pk_CtxNsUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsUptimeTest_DDD ON CtxNsUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_CtxNsUptimeTest_DDD ON CtxNsUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX2_CtxNsUptimeTest_DDD ON CtxNsUptimeTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE CtxNsServiceTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxNsServiceTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Primary_ip_address	VARCHAR2(128) NOT NULL,
	Primary_port		VARCHAR2(32) NOT NULL,
	Service_type		VARCHAR2(32) NOT NULL
);

ALTER TABLE CtxNsServiceTest_DDD ADD constraint Pk_CtxNsServiceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsServiceTest_DDD ON CtxNsServiceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsSvcGMemTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxNsSvcGMemTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Service_type		VARCHAR2(32) NOT NULL,
	Primary_ip_address	VARCHAR2(128) NOT NULL,
	Primary_port		VARCHAR2(32) NOT NULL,
	Member_ip_address	VARCHAR2(128) NOT NULL,
	Member_port		VARCHAR2(32) NOT NULL,
	Weight			VARCHAR2(32) NOT NULL,
	Server_id		VARCHAR2(32) NOT NULL,
	Hash_id			VARCHAR2(32) NOT NULL
);

ALTER TABLE CtxNsSvcGMemTest_DDD ADD constraint Pk_CtxNsSvcGMemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsSvcGMemTest_DDD ON CtxNsSvcGMemTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsSvcGroupTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxNsSvcGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Service_type		VARCHAR2(32) NOT NULL
);

ALTER TABLE CtxNsSvcGroupTest_DDD ADD constraint Pk_CtxNsSvcGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsSvcGroupTest_DDD ON CtxNsSvcGroupTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsLBTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxNsLBTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Primary_ip_address	VARCHAR2(128) NOT NULL,
	Primary_port		VARCHAR2(32) NOT NULL,
	Type			VARCHAR2(128) NOT NULL,
	Name			VARCHAR2(128) NOT NULL,
	Bound_state		VARCHAR2(128) NOT NULL,
	Service_group_name	VARCHAR2(128) NOT NULL
);

ALTER TABLE CtxNsLBTest_DDD ADD constraint Pk_CtxNsLBTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsLBTest_DDD ON CtxNsLBTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsVsAuthTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxNsVsAuthTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Primary_ip_address	VARCHAR2(128) NOT NULL,
	Primary_port		VARCHAR2(32) NOT NULL,
	Service_type		VARCHAR2(32) NOT NULL
);

ALTER TABLE CtxNsVsAuthTest_DDD ADD constraint Pk_CtxNsVsAuthTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsVsAuthTest_DDD ON CtxNsVsAuthTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SchedulTaskTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SchedulTaskTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	FOLDERNAME      VARCHAR2(256) NOT NULL,
	TASKNAME 	VARCHAR2(256) NOT NULL,
	STATUSRES 	VARCHAR2(128) NOT NULL,
	LASTRUNTIME  	VARCHAR2(128) NOT NULL,
	NEXTRUNTIME  	VARCHAR2(128) NOT NULL,
	LASTRESULT  	VARCHAR2(128) NOT NULL,
	TASKSTATE  	VARCHAR2(128) NOT NULL,
	TASKTORUN  	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  SchedulTaskTest_DDD ADD constraint Pk_SchedulTaskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SchedulTaskTest_DDD ON SchedulTaskTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlMissingIdxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlMissingIdxTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DATABASE_ID        VARCHAR2(32) NOT NULL,
	OBJECT_ID	   VARCHAR2(32) NOT NULL,
	USER_SEEKS_COUNT   VARCHAR2(32) NOT NULL,
	USER_SCANS_COUNT   VARCHAR2(32) NOT NULL,
	AVG_USER_IMPACT    VARCHAR2(32) NOT NULL,
	EQUALITY_COLUMNS   VARCHAR2(2048) NOT NULL,
	INEQUALITY_COLUMNS VARCHAR2(2048) NOT NULL,
	INCLUDED_COLUMNS   VARCHAR2(2048) NOT NULL,
	STATEMENT	   VARCHAR2(2048) NOT NULL	
);

ALTER TABLE  MsSqlMissingIdxTest_DDD ADD constraint Pk_MsSqlMissingIdxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlMissingIdxTest_DDD ON MsSqlMissingIdxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlUnusedIdxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlUnusedIdxTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DATABASE_ID		VARCHAR2(32) NOT NULL,
	INDEX_ID		VARCHAR2(32) NOT NULL,
	INDEX_NAME		VARCHAR2(256) NOT NULL,
	TABLE_ID		VARCHAR2(32) NOT NULL,
	TABLE_NAME		VARCHAR2(128) NOT NULL,
	INDEX_TYPE		VARCHAR2(32) NOT NULL,
	USER_SEEK_COUNT		VARCHAR2(32) NOT NULL,
	USER_SCANS_COUNT	VARCHAR2(32) NOT NULL,
	USER_LOOKUPS_COUNT	VARCHAR2(32) NOT NULL,
	USER_UPDATES_COUNT	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  MsSqlUnusedIdxTest_DDD ADD constraint Pk_MsSqlUnusedIdxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MsSqlUnusedIdxTest_DDD ON MsSqlUnusedIdxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PANLicenseTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE PANLicenseTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	License_name	VARCHAR2(128) NOT NULL,
	Total_license		VARCHAR2(32) NOT NULL,
	Socket_count		VARCHAR2(32) NOT NULL
);

ALTER TABLE PANLicenseTest_DDD ADD constraint Pk_PANLicenseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PANLicenseTest_DDD ON PANLicenseTest_DDD
(
 	MSMT_TIME
);


DROP TABLE PANVSwitchTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE PANVSwitchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Name			VARCHAR2(128) NOT NULL,
	Pser_name		VARCHAR2(32) NOT NULL,
	VSwitch_name		VARCHAR2(32) NOT NULL
);

ALTER TABLE PANVSwitchTest_DDD ADD constraint Pk_PANVSwitchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PANVSwitchTest_DDD ON PANVSwitchTest_DDD
(
 	MSMT_TIME
);


DROP TABLE PANLpanInfoTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE PANLpanInfoTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Name			VARCHAR2(128) NOT NULL,
	Num_pnodes		VARCHAR2(32) NOT NULL,
	Pser_can_boot		VARCHAR2(32) NOT NULL,
	Lpan_name		VARCHAR2(32) NOT NULL
);

ALTER TABLE PANLpanInfoTest_DDD ADD constraint Pk_PANLpanInfoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PANLpanInfoTest_DDD ON PANLpanInfoTest_DDD
(
 	MSMT_TIME
);


DROP TABLE ZoneStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE ZoneStatusTest_DDD
(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    ZONE_NAME    VARCHAR2(128) NOT NULL,
    ZONE_IP        VARCHAR2(2000) NOT NULL,
    ZONE_OS     VARCHAR2(128) NOT NULL
);
 
ALTER TABLE  ZoneStatusTest_DDD ADD constraint Pk_ZoneStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
 
CREATE  INDEX IDX_ZoneStatusTest_DDD ON ZoneStatusTest_DDD
(
     MSMT_TIME
);


DROP TABLE CtxNsGslbSrvTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsGslbSrvTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Primary_ip_address	VARCHAR2(128) NOT NULL,
	Primary_port		VARCHAR2(32) NOT NULL,
	Service_type		VARCHAR2(32) NOT NULL
);

ALTER TABLE CtxNsGslbSrvTest_DDD ADD constraint Pk_CtxNsGslbSrvTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsGslbSrvTest_DDD ON CtxNsGslbSrvTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsGslbSiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsGslbSiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Site_type	VARCHAR2(32) NOT NULL,
	Site_Ip		VARCHAR2(128) NOT NULL,
	Site_public_Ip	VARCHAR2(128) NOT NULL
);

ALTER TABLE CtxNsGslbSiteTest_DDD ADD constraint Pk_CtxNsGslbSiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsGslbSiteTest_DDD ON CtxNsGslbSiteTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsGslbVsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE CtxNsGslbVsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Protocol_type	VARCHAR2(32) NOT NULL
);

ALTER TABLE CtxNsGslbVsTest_DDD ADD constraint Pk_CtxNsGslbVsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsGslbVsTest_DDD ON CtxNsGslbVsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsVpnVsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsVpnVsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Primary_ip_address	VARCHAR2(128) NOT NULL,
	Primary_port		VARCHAR2(32) NOT NULL,
	Service_type		VARCHAR2(32) NOT NULL
);

ALTER TABLE CtxNsVpnVsTest_DDD ADD constraint Pk_CtxNsVpnVsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsVpnVsTest_DDD ON CtxNsVpnVsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlSesResTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlSesResTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DB_DBNAME VARCHAR2(128) NOT NULL,
	DB_SESSION_ID VARCHAR2(32) NOT NULL,
	DB_HOST_NAME VARCHAR2(128) NOT NULL,
	DB_LOGIN_NAME VARCHAR2(128) NOT NULL,
	DB_REQUEST_START_TIME VARCHAR2(128) NOT NULL,
	DB_STATUS VARCHAR2(128) NOT NULL,
	DB_WAIT_TYPE VARCHAR2(128) NOT NULL,
	DB_WAIT_TIME_MILLSECS VARCHAR2(32) NOT NULL,
	DB_CPU_TIME_MILLSECS VARCHAR2(32) NOT NULL,
	DB_TOTAL_ELPSD_TIME_MILLSECS VARCHAR2(32) NOT NULL,
	DB_READS VARCHAR2(32) NOT NULL,
	DB_WRITES VARCHAR2(32) NOT NULL,
	DB_LOGICAL_READS VARCHAR2(32) NOT NULL,
	DB_MEMORY_USAGE_KB VARCHAR2(32) NOT NULL,
	DB_LOGIN_TIME VARCHAR2(128) NOT NULL,
	DB_CONNECT_TOTAL_TIME_SECS VARCHAR2(32) NOT NULL,
	DB_SQL_TEXT VARCHAR2(2048) NOT NULL
);
ALTER TABLE  MsSqlSesResTest_DDD ADD constraint Pk_MsSqlSesResTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MsSqlSesResTest_DDD ON MsSqlSesResTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VCVMDistributTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VCVMDistributTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME	VARCHAR2(128) NOT NULL,
	SOURCEHOST	VARCHAR2(128) NOT NULL,
	TARGETHOST 	VARCHAR2(128) NOT NULL,
	SOURCECLUSTER	VARCHAR2(128) NOT NULL,
	TARGETCLUSTER	VARCHAR2(128) NOT NULL,
	SOURCERP	VARCHAR2(128) NOT NULL,
	TARGETRP	VARCHAR2(128) NOT NULL,
	CPU		VARCHAR2(128) NOT NULL,
	MEMORY_ALLOCATED	VARCHAR2(128) NOT NULL,
	DISK_CAPACITY	VARCHAR2(128) NOT NULL,
	DATASTORE	VARCHAR2(128) NOT NULL
);

ALTER TABLE  VCVMDistributTest_DDD ADD constraint Pk_VCVMDistributTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VCVMDistributTest_DDD ON VCVMDistributTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraSesResourceTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraSesResourceTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(64) NOT NULL,
	SID		VARCHAR2(32) NOT NULL,
	OS_PID		VARCHAR2(64) NOT NULL,
	CPU_UTIL	VARCHAR2(64) NOT NULL,
	CPU_USAGE	VARCHAR2(64) NOT NULL,
	MEMORY_UTIL	VARCHAR2(64) NOT NULL,
	MEMORY_USAGE	VARCHAR2(64) NOT NULL,
	PROGRAM		VARCHAR2(64) NOT NULL,
	MACHINE_NAME	VARCHAR2(64) NOT NULL,
	SQL_ID		VARCHAR2(64) NOT NULL,
	SQL_ADDRESS	VARCHAR2(64) NOT NULL,
	SQL_HASH	VARCHAR2(64) NOT NULL,
	ARGUMENTS	VARCHAR2(1024) NOT NULL,
	SQL_TEXT	VARCHAR2(1000) NOT NULL
);

ALTER TABLE  OraSesResourceTest_DDD ADD constraint OraSesResourceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraSesResourceTest_DDD ON OraSesResourceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PVSRamCacheTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE PVSRamCacheTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	COLLECTION_NAME	 VARCHAR2(256) NOT NULL
);

ALTER TABLE PVSRamCacheTest_DDD ADD constraint Pk_PVSRamCacheTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PVSRamCacheTest_DDD ON PVSRamCacheTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HvVmHeartbeatTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE HvVmHeartbeatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	VM_Name		VARCHAR2(128) NOT NULL
);

ALTER TABLE HvVmHeartbeatTest_DDD ADD constraint Pk_HvVmHeartbeatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HvVmHeartbeatTest_DDD ON HvVmHeartbeatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XenToolStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XenToolStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Os_Name		VARCHAR2(128) NOT NULL,
	IP_Address	VARCHAR2(2000) NOT NULL,
	Xen_Tools_Info	VARCHAR2(512) NOT NULL
);

ALTER TABLE XenToolStatusTest_DDD ADD constraint Pk_XenToolStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenToolStatusTest_DDD ON XenToolStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE XenSnapshotTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XenSnapshotTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Type		VARCHAR2(128) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Created_on	VARCHAR2(128) NOT NULL,
	Protection_policy VARCHAR2(128) NOT NULL,
	Tags		VARCHAR2(128) NOT NULL,
	Description	VARCHAR2(128) NOT NULL,
	Parent		VARCHAR2(128) NOT NULL,
	Snapshot_size	VARCHAR2(128) NOT NULL,
	Snapshot_age	VARCHAR2(32) NOT NULL
);

ALTER TABLE XenSnapshotTest_DDD ADD constraint Pk_XenSnapshotTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenSnapshotTest_DDD ON XenSnapshotTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VDIBoxDesktopTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VDIBoxDesktopTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Template_name	VARCHAR2(128) NOT NULL,
	Server_ip	VARCHAR2(128) NOT NULL,
	VM_name		VARCHAR2(128) NOT NULL,
	IP_address	VARCHAR2(128) NOT NULL,
	Client_address	VARCHAR2(128) NOT NULL,
	Login_time	VARCHAR2(128) NOT NULL,
	Duration	VARCHAR2(32) NOT NULL
);

ALTER TABLE  VDIBoxDesktopTest_DDD ADD constraint VDIBoxDesktopTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VDIBoxDesktopTest_DDD ON VDIBoxDesktopTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VDIBoxTempSumTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VDIBoxTempSumTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Template_name	VARCHAR2(128) NOT NULL,
	Server_ip	VARCHAR2(128) NOT NULL,
	VM_name		VARCHAR2(128) NOT NULL,
	IP_address	VARCHAR2(128) NOT NULL,
	Client_address	VARCHAR2(128) NOT NULL,
	Login_time	VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VDIBoxTempSumTest_DDD ADD constraint VDIBoxTempSumTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VDIBoxTempSumTest_DDD ON VDIBoxTempSumTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VDIBoxTempDetTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VDIBoxTempDetTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Description	VARCHAR2(128) NOT NULL,
	Fast_Refresh	VARCHAR2(128) NOT NULL,
	Desktop_type	VARCHAR2(64) NOT NULL,
	Policy_type	VARCHAR2(256) NOT NULL,
	Serial_ports	VARCHAR2(64) NOT NULL,
	Disk_drives	VARCHAR2(64) NOT NULL,
	Printers	VARCHAR2(64) NOT NULL,
	Smart_cards	VARCHAR2(32) NOT NULL
);

ALTER TABLE  VDIBoxTempDetTest_DDD ADD constraint VDIBoxTempDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VDIBoxTempDetTest_DDD ON VDIBoxTempDetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VDIBoxImageTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VDIBoxImageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Image_desc	VARCHAR2(128) NOT NULL,
	Desktop_agent	VARCHAR2(128) NOT NULL,
	OS		VARCHAR2(128) NOT NULL,
	Prep_type	VARCHAR2(64) NOT NULL,
	Created_date	VARCHAR2(128) NOT NULL,
	Modified_date	VARCHAR2(128) NOT NULL
);

ALTER TABLE  VDIBoxImageTest_DDD ADD constraint VDIBoxImageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VDIBoxImageTest_DDD ON VDIBoxImageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VDIBoxLicenseTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VDIBoxLicenseTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Product_name	VARCHAR2(128) NOT NULL,
	Hostname	VARCHAR2(128) NOT NULL,
	Checkedout_product	VARCHAR2(128) NOT NULL,
	Client		VARCHAR2(128) NOT NULL,
	Client_version	VARCHAR2(128) NOT NULL,
	License_server_details	VARCHAR2(256) NOT NULL,
	License_handle	VARCHAR2(128) NOT NULL,
	Checkout_time	VARCHAR2(128) NOT NULL
);

ALTER TABLE VDIBoxLicenseTest_DDD ADD constraint Pk_VDIBoxLicenseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VDIBoxLicenseTest_DDD ON VDIBoxLicenseTest_DDD
(
 	MSMT_TIME
);

DROP TABLE JvmMemoryLeakTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  JvmMemoryLeakTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE	 NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CLASS_NAME 	VARCHAR2(128) NOT NULL,
	INSTANCE_COUNT	VARCHAR2(32) NOT NULL,
	INSTANCE_SIZE	VARCHAR2(32) NOT NULL,
	RETAINED_SIZE	VARCHAR2(32) NOT NULL,
	PERCENTAGE	VARCHAR2(32) NOT NULL
);

ALTER TABLE  JvmMemoryLeakTest_DDD ADD constraint Pk_JvmMemoryLeakTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_JvmMemoryLeakTest_DDD ON JvmMemoryLeakTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HanaExpensStmtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HanaExpensStmtTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HOST	        VARCHAR2(32) NOT NULL,
	PORT            VARCHAR2(32) NOT NULL,
	CONNECTIONID    VARCHAR2(32) NOT NULL,
	TRANSACTIONID	VARCHAR2(32) NOT NULL,
	STATEMENTID	VARCHAR2(256) NOT NULL,
	DBUSERNAME	VARCHAR2(256) NOT NULL,
	APPUSER		VARCHAR2(256) NOT NULL,
	STARTTIME	VARCHAR2(32) NOT NULL,
	STRDURATIONMICROSEC  VARCHAR2(32) NOT NULL,
	OBJECTNAME	VARCHAR2(2000) NOT NULL,
	RECORDS		VARCHAR2(32) NOT NULL,
	STATEMENTSTRING  VARCHAR2(2048) NOT NULL	
);
ALTER TABLE  HanaExpensStmtTest_DDD ADD constraint Pk_HanaExpensStmtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HanaExpensStmtTest_DDD ON HanaExpensStmtTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HanaBlockTransTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HanaBlockTransTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,		       
	HOST			VARCHAR2(32) NOT NULL,
	PORT			 VARCHAR2(32) NOT NULL,
	BLOCKEDTRANSID		 VARCHAR2(32) NOT NULL,
	LOCKOWNERTRANSID	 VARCHAR2(32) NOT NULL,
	BLOCKEDTIME		 VARCHAR2(32) NOT NULL,
	WAITINGRECORDID		 VARCHAR2(256) NOT NULL,
	WAITINGSCHEMANAME	 VARCHAR2(256) NOT NULL,
	WAITINGTABLENAME	 VARCHAR2(256) NOT NULL,
	LOCKTYPE		 VARCHAR2(32) NOT NULL,
	LOCKMODE		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  HanaBlockTransTest_DDD ADD constraint Pk_HanaBlockTransTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HanaBlockTransTest_DDD ON HanaBlockTransTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HanaTransactTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HanaTransactTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HOST			VARCHAR2(32) NOT NULL,
	PORT			VARCHAR2(32) NOT NULL,
	CONNECTIONID	        VARCHAR2(32) NOT NULL,
	TRANSACTIONID	        VARCHAR2(32) NOT NULL,
	TRANSACTIONSTATUS	VARCHAR2(128) NOT NULL,
	TRANSACTIONTYPE	        VARCHAR2(128) NOT NULL,
	STARTTIME	        VARCHAR2(32) NOT NULL,
	ENDTIME			VARCHAR2(32) NOT NULL,
	TRANSACTNDURATION	VARCHAR2(32) NOT NULL,
	EXECUTEDSTMTCOUNT	VARCHAR2(32) NOT NULL,
	ACTIVESTMTCOUNT	        VARCHAR2(32) NOT NULL,
	ACQUIREDLOCKCOUNT	VARCHAR2(32) NOT NULL,
	CURRENTSTMTID	        VARCHAR2(256) NOT NULL,
	ALLOCMEMSIZEBYTES	VARCHAR2(32) NOT NULL,
	REDOLOGAMTBYTES	        VARCHAR2(32) NOT NULL,
	UNDOLOGAMTBYTES	        VARCHAR2(32) NOT NULL
);
ALTER TABLE  HanaTransactTest_DDD ADD constraint Pk_HanaTransactTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HanaTransactTest_DDD ON HanaTransactTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ExcSRMailTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  ExcSRMailTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EMAIL		VARCHAR2(2000) NOT NULL,
	COUNT		VARCHAR2(32) NOT NULL,
	TOTAL		VARCHAR2(32) NOT NULL
);

ALTER TABLE  ExcSRMailTest_DDD ADD constraint Pk_ExcSRMailTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ExcSRMailTest_DDD ON ExcSRMailTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ADAcMgmtEvtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ADAcMgmtEvtTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  ADAcMgmtEvtTest_DDD ADD constraint Pk_ADAcMgmtEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_ADAcMgmtEvtTest_DDD ON ADAcMgmtEvtTest_DDD ( MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_ADAcMgmtEvtTest_DDD ON ADAcMgmtEvtTest_DDD ( EVENT_TYPE );
CREATE INDEX IDX3_ADAcMgmtEvtTest_DDD ON ADAcMgmtEvtTest_DDD ( EVENT_SOURCE );
CREATE INDEX IDX4_ADAcMgmtEvtTest_DDD ON ADAcMgmtEvtTest_DDD ( EVENT_USER );


DROP TABLE FRSEvtlogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FRSEvtlogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  FRSEvtlogTest_DDD ADD constraint Pk_FRSEvtlogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_FRSEvtlogTest_DDD ON FRSEvtlogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_FRSEvtlogTest_DDD ON FRSEvtlogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_FRSEvtlogTest_DDD ON FRSEvtlogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_FRSEvtlogTest_DDD ON FRSEvtlogTest_DDD ( EVENT_USER );

DROP TABLE ADAMEvtlogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  ADAMEvtlogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  ADAMEvtlogTest_DDD ADD constraint Pk_ADAMEvtlogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_ADAMEvtlogTest_DDD ON ADAMEvtlogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_ADAMEvtlogTest_DDD ON ADAMEvtlogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_ADAMEvtlogTest_DDD ON ADAMEvtlogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_ADAMEvtlogTest_DDD ON ADAMEvtlogTest_DDD ( EVENT_USER );

DROP TABLE CustEvtLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CustEvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CustEvtLogTest_DDD ADD constraint Pk_CustEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_CustEvtLogTest_DDD ON CustEvtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_CustEvtLogTest_DDD ON CustEvtLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_CustEvtLogTest_DDD ON CustEvtLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_CustEvtLogTest_DDD ON CustEvtLogTest_DDD ( EVENT_USER );

DROP TABLE MsSqlUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  MsSqlUptimeTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	SHUTDOWNDATE			DATE NOT NULL,
	REBOOTEDDATE			DATE NOT NULL,
	DURATION			NUMBER(20,4) NOT NULL,
	MAINTENANCE			VARCHAR2(32) NOT NULL
);

ALTER TABLE  MsSqlUptimeTest_DDD ADD constraint Pk_MsSqlUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlUptimeTest_DDD ON MsSqlUptimeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlIOTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlIOTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	DBNAME			VARCHAR2(128) NOT NULL,
	SESSION_ID		VARCHAR2(32) NOT NULL,
	LOGIN_NAME		VARCHAR2(128) NOT NULL,
	REQUEST_START_TIME	VARCHAR2(128) NOT NULL,
	STATUS			VARCHAR2(128) NOT NULL,
	WAIT_TYPE		VARCHAR2(128) NOT NULL,
	WAIT_TIME_MILLSECS	VARCHAR2(32) NOT NULL,
	PHYSICAL_READS		VARCHAR2(32) NOT NULL,
	PHYSICAL_WRITES		VARCHAR2(32) NOT NULL,
	LOGICAL_READS		VARCHAR2(32) NOT NULL,
	CPU_TIME_MILLSECS	VARCHAR2(32) NOT NULL,
	TOTAL_ELPSD_TIME_MILLSECS VARCHAR2(32) NOT NULL,
	MEMORY_USAGE_KB		VARCHAR2(32) NOT NULL,
	LOGIN_TIME		VARCHAR2(128) NOT NULL,
	CONNECT_TOTAL_TIME_SECS VARCHAR2(32) NOT NULL,
	SQL_TEXT		VARCHAR2(2048) NOT NULL

);

ALTER TABLE  MsSqlIOTest_DDD ADD constraint Pk_MsSqlIOTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlIOTest_DDD ON MsSqlIOTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlMemoryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlMemoryTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SESSION_ID		VARCHAR2(128) NOT NULL,
	LOGIN_NAME		VARCHAR2(128) NOT NULL,
	PROGRAM_NAME		VARCHAR2(256) NOT NULL,
	HOST_NAME		VARCHAR2(128) NOT NULL,
	REQUEST_TIME		DATE NOT NULL,
	GRANT_TIME		DATE NOT NULL,
	REQUIRED_MEMORY		VARCHAR2(128) NOT NULL,
	USED_MEMORY		VARCHAR2(32) NOT NULL,
	MAX_USED_MEMORY		VARCHAR2(32) NOT NULL,
	WAIT_ORDER		VARCHAR2(32) NOT NULL,
	WAIT_TIME		VARCHAR2(32) NOT NULL,
	SQL_TEXT		VARCHAR2(2048) NOT NULL

);

ALTER TABLE  MsSqlMemoryTest_DDD ADD constraint Pk_MsSqlMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlMemoryTest_DDD ON MsSqlMemoryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XenPoolStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE XenPoolStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Pool_desc	VARCHAR2(128) NOT NULL,
	Server_name	VARCHAR2(128) NOT NULL,
	Server_desc	VARCHAR2(128) NOT NULL,
	Server_hostname VARCHAR2(128) NOT NULL,
	Server_ip	VARCHAR2(128) NOT NULL
);

ALTER TABLE XenPoolStatusTest_DDD ADD constraint Pk_XenPoolStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenPoolStatusTest_DDD ON XenPoolStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE HpP2kCtlEPortStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kCtlEPortStTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,EXPANDER_PORT	   VARCHAR2(64) NOT NULL,HEALTH	   VARCHAR2(256) NOT NULL );
ALTER TABLE  HpP2kCtlEPortStTest_DDD ADD constraint Pk_HpP2kCtlEPortStTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kCtlEPortStTest_DDD ON HpP2kCtlEPortStTest_DDD(MSMT_TIME );

DROP TABLE HpP2kCtrlNetStsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kCtrlNetStsTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,MANAGEMENT_PORT  VARCHAR2(64) NOT NULL,HEALTH	   VARCHAR2(256) NOT NULL );
ALTER TABLE  HpP2kCtrlNetStsTest_DDD ADD constraint Pk_HpP2kCtrlNetStsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kCtrlNetStsTest_DDD ON HpP2kCtrlNetStsTest_DDD(MSMT_TIME );

DROP TABLE HpP2kCtrlPortStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kCtrlPortStTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,HOSTPORT	VARCHAR2(64) NOT NULL,HEALTH	   VARCHAR2(256) NOT NULL );
ALTER TABLE  HpP2kCtrlPortStTest_DDD ADD constraint Pk_HpP2kCtrlPortStTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kCtrlPortStTest_DDD ON HpP2kCtrlPortStTest_DDD(MSMT_TIME );

DROP TABLE HpP2kCtrlrStsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kCtrlrStsTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,CONTROLLER_NAME  VARCHAR2(64) NOT NULL,DETAILS	   VARCHAR2(256) NOT NULL );
ALTER TABLE  HpP2kCtrlrStsTest_DDD ADD constraint Pk_HpP2kCtrlrStsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kCtrlrStsTest_DDD ON HpP2kCtrlrStsTest_DDD(MSMT_TIME );

DROP TABLE HpP2kDiskStsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kDiskStsTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,DRIVE_NAME  VARCHAR2(64) NOT NULL,HEALTH	   VARCHAR2(256) NOT NULL );
ALTER TABLE  HpP2kDiskStsTest_DDD ADD constraint Pk_HpP2kDiskStsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kDiskStsTest_DDD ON HpP2kDiskStsTest_DDD(MSMT_TIME );

DROP TABLE HpP2kExpandStsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kExpandStsTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,PHY_TYPE 	   VARCHAR2(64) NOT NULL,ELEMREASON	   VARCHAR2(1024) NOT NULL );
ALTER TABLE  HpP2kExpandStsTest_DDD ADD constraint Pk_HpP2kExpandStsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kExpandStsTest_DDD ON HpP2kExpandStsTest_DDD(MSMT_TIME );

DROP TABLE HpP2kVDiskStsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kVDiskStsTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,VDISK_NAME  VARCHAR2(64) NOT NULL,HEALTH	   VARCHAR2(256) NOT NULL );
ALTER TABLE  HpP2kVDiskStsTest_DDD ADD constraint Pk_HpP2kVDiskStsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kVDiskStsTest_DDD ON HpP2kVDiskStsTest_DDD(MSMT_TIME );

DROP TABLE HpP2kVolumeStsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HpP2kVolumeStsTest_DDD(SITE_NAME	VARCHAR2(64) NOT NULL,TRGT_HOST	VARCHAR2(32) NOT NULL,PORT_NO		VARCHAR2(32) NOT NULL,TEST_NAME	VARCHAR2(64) NOT NULL,MEASURE		VARCHAR2(64) NOT NULL,INFO		VARCHAR2(128) NOT NULL,STATE		VARCHAR2(32) NOT NULL,MSMT_HOST	VARCHAR2(32) NOT NULL,MSMT_TIME	DATE NOT NULL,SEQ_NO 		NUMBER(16) NOT NULL,VOLUME_NAME VARCHAR2(64) NOT NULL,HEALTH	   VARCHAR2(256) NOT NULL );
ALTER TABLE  HpP2kVolumeStsTest_DDD ADD constraint Pk_HpP2kVolumeStsTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HpP2kVolumeStsTest_DDD ON HpP2kVolumeStsTest_DDD(MSMT_TIME );

DROP TABLE EsxDisVSwitchTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxDisVSwitchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME	VARCHAR2(128) NOT NULL,
	PHYNAME 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  EsxDisVSwitchTest_DDD ADD constraint Pk_EsxDisVSwitchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxDisVSwitchTest_DDD ON EsxDisVSwitchTest_DDD
(
 	MSMT_TIME
);


DROP TABLE EsxDisPortGrpTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxDisPortGrpTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL
);

ALTER TABLE  EsxDisPortGrpTest_DDD ADD constraint Pk_EsxDisPortGrpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxDisPortGrpTest_DDD ON EsxDisPortGrpTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MsSqlQryStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MsSqlQryStatTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	EXECUTION_COUNT			VARCHAR2(32) NOT NULL,
	TOTAL_LOGICAL_READS		VARCHAR2(32) NOT NULL,
	LOGICAL_READS_PER_EXEC		VARCHAR2(32) NOT NULL,
	LAST_LOGICAL_READS		VARCHAR2(32) NOT NULL,
	TOTAL_PHYSICAL_READS		VARCHAR2(32) NOT NULL,
	PHYSICAL_READS_PER_EXEC		VARCHAR2(32) NOT NULL,
	LAST_PHYSICAL_READS		VARCHAR2(32) NOT NULL,
	TOTAL_LOGICAL_WRITES		VARCHAR2(32) NOT NULL,
	LOGICAL_WRITES_PER_SEC		VARCHAR2(32) NOT NULL,
	LAST_LOGICAL_WRITES		VARCHAR2(32) NOT NULL,
	TOTAL_ELAPSED_TIME		VARCHAR2(32) NOT NULL,
	ELAPSED_TIME_PER_EXEC		VARCHAR2(32) NOT NULL,
	LAST_ELAPSED_TIME		VARCHAR2(32) NOT NULL,
	TOTAL_CPU_TIME			VARCHAR2(32) NOT NULL,
	CPU_TIME_PER_EXEC		VARCHAR2(32) NOT NULL,
	LAST_CPU_TIME			VARCHAR2(32) NOT NULL,
	STATEMENT			VARCHAR2(2048) NOT NULL

);

ALTER TABLE  MsSqlQryStatTest_DDD ADD constraint Pk_MsSqlQryStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlQryStatTest_DDD ON MsSqlQryStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraWaitClassTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE OraWaitClassTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	SID             VARCHAR2(32)    NOT NULL,
	SERIAL          VARCHAR2(32)    NOT NULL,
	USER_NAME       VARCHAR2(128)   NOT NULL,
	OS_USER         VARCHAR2(128)   NOT NULL,
	MACHINE_NAME    VARCHAR2(128)   NOT NULL,
	PROGRAM_NAME    VARCHAR2(64)   NOT NULL,
	EVENT		VARCHAR2(128)   NOT NULL,
	SECONDS_IN_WAIT	VARCHAR2(128)   NOT NULL,
	SQL_ID		VARCHAR2(32)    NOT NULL,
	SQL_TEXT	VARCHAR2(2048)    NOT NULL
);

ALTER TABLE  OraWaitClassTest_DDD ADD constraint Pk_OraWaitClassTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraWaitClassTest_DDD ON OraWaitClassTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SiteName		VARCHAR2(128) NOT NULL,
	License_server_name	VARCHAR2(128) NOT NULL,
	License_server_port 	VARCHAR2(128) NOT NULL,
	Desktop_lic_edition	VARCHAR2(128) NOT NULL,
	Desktop_lic_model	VARCHAR2(128) NOT NULL,
	App_lic_edition		VARCHAR2(128) NOT NULL,
	App_lic_model		VARCHAR2(128) NOT NULL,
	Req_sa_date		VARCHAR2(128) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSiteTest_DDD ADD constraint Pk_CtxXcXDSiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSiteTest_DDD ON CtxXcXDSiteTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDHypTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDHypTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Connection_name		VARCHAR2(128) NOT NULL,
	Connection_type		VARCHAR2(128) NOT NULL,
	Hypervisor_address 	VARCHAR2(2000) NOT NULL,
	Preferred_controller	VARCHAR2(128) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDHypTest_DDD ADD constraint Pk_CtxXcXDHypTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDHypTest_DDD ON CtxXcXDHypTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDBrokerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDBrokerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Dns_name		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Broker_version		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Last_active_time	VARCHAR2(128) NOT NULL,
	Last_start_time		VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDBrokerTest_DDD ADD constraint Pk_CtxXcXDBrokerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDBrokerTest_DDD ON CtxXcXDBrokerTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDCatalogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCatalogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Machine_type		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	User_data		VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Pvs_address		VARCHAR2(128) NOT NULL,
	Pvs_domain		VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCatalogTest_DDD ADD constraint Pk_CtxXcXDCatalogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCatalogTest_DDD ON CtxXcXDCatalogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDBrMachTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDBrMachTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Desktop_group_name	VARCHAR2(128) NOT NULL,
	Desktop_kind		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Measure_state		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Session_username	VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Published_applications	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxXcXDBrMachTest_DDD ADD constraint Pk_CtxXcXDBrMachTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDBrMachTest_DDD ON CtxXcXDBrMachTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDGroupTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Desktop_kind		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Session_username	VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Published_applications	VARCHAR2(2000) NOT NULL,
	Published_name		VARCHAR2(128) NOT NULL,
	Reason			VARCHAR2(256) NOT NULL,
	D_and_t			VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDGroupTest_DDD ADD constraint Pk_CtxXcXDGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDGroupTest_DDD ON CtxXcXDGroupTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDAppTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Application_name	VARCHAR2(128) NOT NULL,
	Display_name		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Application_type	VARCHAR2(128) NOT NULL,
	Program			VARCHAR2(1024) NOT NULL,
	Working_directory	VARCHAR2(1024) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	catalog_name		VARCHAR2(128) NOT NULL,
	Id			VARCHAR2(128) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Session_start_time	VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL,
	Tags			VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxXcXDAppTest_DDD ADD constraint Pk_CtxXcXDAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDAppTest_DDD ON CtxXcXDAppTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSessionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSessionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL
);

ALTER TABLE  CtxXcXDSessionTest_DDD ADD constraint Pk_CtxXcXDSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSessionTest_DDD ON CtxXcXDSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL,
	Login_duration		NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxXcXDLoginTest_DDD ADD constraint Pk_CtxXcXDLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDLoginTest_DDD ON CtxXcXDLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDCBrMachTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCBrMachTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Desktop_group_name	VARCHAR2(128) NOT NULL,
	Desktop_kind		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Measure_state		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Session_username	VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Published_applications	VARCHAR2(2000) NOT NULL,
	VM_tools_state		VARCHAR2(128) NOT NULL,
	Windows_connection_settings	VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCBrMachTest_DDD ADD constraint Pk_CtxXcXDCBrMachTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCBrMachTest_DDD ON CtxXcXDCBrMachTest_DDD
(
 	MSMT_TIME
);


DROP TABLE CtxXcXDCGroupTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Desktop_kind		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Session_username	VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Published_applications	VARCHAR2(2000) NOT NULL,
	Published_name		VARCHAR2(128) NOT NULL,
	Reason			VARCHAR2(256) NOT NULL,
	D_and_t			VARCHAR2(128) NOT NULL,
	Delivery_Type		VARCHAR2(128) NOT NULL,
	AppDisk_Names		VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL,
	Tags			VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxXcXDCGroupTest_DDD ADD constraint Pk_CtxXcXDCGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCGroupTest_DDD ON CtxXcXDCGroupTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDCSessionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCSessionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL,
	Client_platform		VARCHAR2(128) NOT NULL,
	Session_type		VARCHAR2(128) NOT NULL,
	Session_key		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCSessionTest_DDD ADD constraint Pk_CtxXcXDCSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCSessionTest_DDD ON CtxXcXDCSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDCLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL,
	Login_duration		NUMBER(20,4) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL,
	Client_platform		VARCHAR2(128) NOT NULL,
	Session_type		VARCHAR2(128) NOT NULL,
	Session_key		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCLoginTest_DDD ADD constraint Pk_CtxXcXDCLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCLoginTest_DDD ON CtxXcXDCLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXDLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDLogTest_DDD ADD constraint Pk_CtxXcXDLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_CtxXcXDLogTest_DDD ON CtxXcXDLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_CtxXcXDLogTest_DDD ON CtxXcXDLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_CtxXcXDLogTest_DDD ON CtxXcXDLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_CtxXcXDLogTest_DDD ON CtxXcXDLogTest_DDD ( EVENT_USER );

DROP TABLE CtxSFLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxSFLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxSFLogTest_DDD ADD constraint Pk_CtxSFLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_CtxSFLogTest_DDD ON CtxSFLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_CtxSFLogTest_DDD ON CtxSFLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_CtxSFLogTest_DDD ON CtxSFLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_CtxSFLogTest_DDD ON CtxSFLogTest_DDD ( EVENT_USER );

DROP TABLE CtxXcXAUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAUserTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	Parent_PID	NUMBER(16) NOT NULL,
	ProcName	VARCHAR2(128) NOT NULL,
	Cpu_util	NUMBER(20,4) NOT NULL,
	Memory_util	NUMBER(20,4) NOT NULL,
	IO_reads 	NUMBER(20,4) NOT NULL,
	IO_writes	NUMBER (20,4) NOT NULL,
	Page_faults	NUMBER (20,4) NOT NULL,
	Virtual_memory	NUMBER (20,4) NOT NULL,
	Handles		NUMBER (20,4) NOT NULL,
	Published_dname VARCHAR2(256) NOT NULL,
	Image_path	VARCHAR2(2000) NOT NULL,
	Website_title	VARCHAR2(2000) NOT NULL,
	Website_url	VARCHAR2(2000) NOT NULL,
	Website_domain	VARCHAR2(2000) NOT NULL,
	Cpu_time	NUMBER(20,4) NOT NULL,
	Memory_used	NUMBER(20,4) NOT NULL,
	Bandwidth	NUMBER(20,4) NOT NULL,
	Latency		NUMBER(20,4) NOT NULL,
	Ica_RTT		NUMBER(20,4) NOT NULL,
	Bandwidth_status VARCHAR2(256) NOT NULL,
	Latency_status	VARCHAR2(256) NOT NULL,
	Ica_RTT_status	VARCHAR2(256) NOT NULL,
	Session_name	VARCHAR2(128) NOT NULL,
	Session_id	NUMBER(16) NOT NULL,
	Session_key	VARCHAR2(256) NOT NULL,
	Client_type	VARCHAR2(256) NOT NULL,
	Client_category	VARCHAR2(256) NOT NULL,
	Process_input_delay NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxXcXAUserTest_DDD ADD constraint Pk_CtxXcXAUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXAUserTest_DDD ON CtxXcXAUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXAAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAAppTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	PARENT_PID	NUMBER(16) NOT NULL,
	CPU_UTIL	NUMBER(20,4) NOT NULL,
	MEMORY_UTIL	NUMBER(20,4) NOT NULL,
	VIRTUAL_MEMORY	NUMBER(20,4) NOT NULL,
	HANDLE_COUNT	NUMBER(20,4) NOT NULL,
	THREAD_COUNT	NUMBER(20,4) NOT NULL,
	DATA_IO 	NUMBER(20,4) NOT NULL,
	IO_OPERATIONS 	NUMBER(20,4) NOT NULL,
	IO_READS	NUMBER(20,4) NOT NULL,
	IO_WRITES	NUMBER(20,4) NOT NULL,
	PAGE_FAULTS	NUMBER(20,4) NOT NULL,
	IMAGE_PATH	VARCHAR2(2000) NOT NULL,
	WEBSITE_TITLE	VARCHAR2(2000) NOT NULL,
	WEBSITE_URL	VARCHAR2(2000) NOT NULL,
	WEBSITE_DOMAIN	VARCHAR2(2000) NOT NULL,
	MEMORY_USED	NUMBER(20,4) NOT NULL,
	PROCESS_INPUT_DELAY NUMBER(20,4) NOT NULL);

ALTER TABLE CtxXcXAAppTest_DDD ADD constraint Pk_CtxXcXAAppTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxXcXAAppTest_DDD ON CtxXcXAAppTest_DDD
(
 	MSMT_TIME,USERNAME,TRGT_HOST,PORT_NO
);

DROP TABLE CtxXcXALoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXALoginTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	SESSION_NAME	VARCHAR2(128) NOT NULL,
	SESSION_ID	NUMBER(16) NOT NULL,
	CLIENT_NAME	VARCHAR2(128) NOT NULL,
	CLIENT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	CLIENT_VERSION	VARCHAR2(128) NOT NULL,
	CLIENT_ID	VARCHAR2(128) NOT NULL,
	CLIENT_TYPE	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL,
	SESSION_KEY	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXALoginTest_DDD ADD constraint Pk_CtxXcXALoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXALoginTest_DDD ON CtxXcXALoginTest_DDD
(
 	MSMT_TIME
);
CREATE INDEX IDX1_CtxXcXALoginTest_DDD ON CtxXcXALoginTest_DDD (TRGT_HOST,PORT_NO,MEASURE,INFO);
CREATE INDEX IDX2_CtxXcXALoginTest_DDD ON CtxXcXALoginTest_DDD (TRGT_HOST,MSMT_TIME);

DROP TABLE CtxXcXASessionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXASessionTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME VARCHAR2(128) NOT NULL,
	SESSIONNAME VARCHAR2(128) NOT NULL,
	ID NUMBER(16) NOT NULL,
	CTX_STATE VARCHAR2(32) NOT NULL,
	IDLE_TIME VARCHAR2(32) NOT NULL,
	LOGON_TIME VARCHAR2(32) NOT NULL,
	CLIENT_NAME VARCHAR2(128) NOT NULL,
	CLIENT_IPADDRESS VARCHAR2(256) NOT NULL,
	CLIENT_VERSION VARCHAR2(128) NOT NULL,
	CLIENT_ID VARCHAR2(128) NOT NULL,
	CLIENT_TYPE VARCHAR2(256) NOT NULL,
	CLIENT_CATEGORY VARCHAR2(256) NOT NULL,
	SESSION_KEY VARCHAR2(256) NOT NULL,
	HDX_DISPLAY_MODE VARCHAR2(256) NOT NULL,
	HDX_ACTIVE_ENCODER VARCHAR2(256) NOT NULL,
	HDX_PROTOCOL VARCHAR2(256) NOT NULL,
	ENCRYPTION_LEVEL VARCHAR2(256) NOT NULL,
	NETSCALER_RPTNAME VARCHAR2(256) NOT NULL,
	NETSCALER_IP_ADDRESS VARCHAR2(128) NOT NULL,
	XENAPP_IP_ADDRESS VARCHAR2(128) NOT NULL,
	ENDPOINT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	COUNTRY_NAME VARCHAR2(256) NOT NULL,
	COUNTRY_CODE VARCHAR2(256) NOT NULL,
	REGION VARCHAR2(256) NOT NULL,
	CITY VARCHAR2(256) NOT NULL,
	LATITUDE VARCHAR2(64) NOT NULL,
	LONGITUDE VARCHAR2(64) NOT NULL);

ALTER TABLE  CtxXcXASessionTest_DDD ADD constraint Pk_CtxXcXASessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXASessionTest_DDD ON CtxXcXASessionTest_DDD
(
 	MSMT_TIME
);

CREATE INDEX idx1_CtxXcXASessionTest_DDD ON CtxXcXASessionTest_DDD (TRGT_HOST,PORT_NO,MEASURE,USERNAME,CLIENT_IPADDRESS,CLIENT_VERSION);
CREATE INDEX IDX2_CtxXcXASessionTest_DDD ON CtxXcXASessionTest_DDD(MEASURE, MSMT_TIME, TRGT_HOST, USERNAME, LOGON_TIME);

DROP TABLE UserEnvironTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UserEnvironTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	Login_name		VARCHAR2(2000) NOT NULL,
	Session_ID		VARCHAR2(128) NOT NULL,
	Profile_load_duration	VARCHAR2(128) NOT NULL,
	Policy_time		VARCHAR2(128) NOT NULL,
	Discovery_time		VARCHAR2(128) NOT NULL,
	CSE_elapsed_time	VARCHAR2(128) NOT NULL,
	Error_code		VARCHAR2(512) NOT NULL,
	CSE_extension_name	VARCHAR2(512) NOT NULL,
	CSE_extension_id	VARCHAR2(512) NOT NULL,
	Profile_time		VARCHAR2(128) NOT NULL,
	Login_time		VARCHAR2(512) NOT NULL,
	Time_duration		VARCHAR2(128) NOT NULL,
	CSE_Display_name	VARCHAR2(512) NOT NULL
);

ALTER TABLE  UserEnvironTest_DDD ADD constraint Pk_UserEnvironTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UserEnvironTest_DDD ON UserEnvironTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgBrowsActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VmgBrowsActTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PROCESSID       VARCHAR2(256) NOT NULL,
	CPUUTIL 	VARCHAR2(256) NOT NULL,
	MEMUTIL 	VARCHAR2(128) NOT NULL,
	HANDLESCOUNT  	VARCHAR2(128) NOT NULL,
	DISKIOREAD  	VARCHAR2(128) NOT NULL,
	DISKIOWRITE  	VARCHAR2(128) NOT NULL,
	DISKIOPS  	VARCHAR2(128) NOT NULL,
	PAGEFAULTS  	VARCHAR2(128) NOT NULL,
	BROWSERTITLE    VARCHAR2(2000) NOT NULL,
	ACTIVEURL       VARCHAR2(2000) NOT NULL,
	WEBSITETITLE    VARCHAR2(2000) NOT NULL,
	WEBSITEURL      VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VmgBrowsActTest_DDD ADD constraint Pk_VmgBrowsActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgBrowsActTest_DDD ON VmgBrowsActTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CronLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CronLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Username	VARCHAR2(256) NOT NULL,
	ProcessId	VARCHAR2(32) NOT NULL,
	Command_issued	VARCHAR2(256) NOT NULL,
	Job_start_time	VARCHAR2(32) NOT NULL,
	Duration_of_job VARCHAR2(32) NOT NULL,
	Job_time	VARCHAR2(32) NOT NULL
);

ALTER TABLE  CronLogTest_DDD ADD constraint Pk_CronLogTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CronLogTest_DDD ON CronLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VeeamJobSumDetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VeeamJobSumDetTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	JOB_NAME		VARCHAR2(128) NOT NULL,
	TYPE			VARCHAR2(32) NOT NULL,
	TOTAL_SIZE		VARCHAR2(128) NOT NULL,
	START_TIME		VARCHAR2(128) NOT NULL,
	FINISH_TIME		VARCHAR2(128) NOT NULL,
	DURATION		VARCHAR2(128) NOT NULL,
	AGE			VARCHAR2(32) NOT NULL,
	NEXT_RUN_TIME		VARCHAR2(32) NOT NULL,
	MESSAGE			VARCHAR2(32) NOT NULL
);

ALTER TABLE  VeeamJobSumDetTest_DDD ADD constraint Pk_VeeamJobSumDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VeeamJobSumDetTest_DDD ON VeeamJobSumDetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PoolsUsageTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE PoolsUsageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(2000) NOT NULL,
	Pool_id		VARCHAR2(2000) NOT NULL,
	Start_time	VARCHAR2(2000) NOT NULL,
	DNS_name	VARCHAR2(2000) NOT NULL,
	Duration	VARCHAR2(2000) NOT NULL,
	Status		VARCHAR2(2000) NOT NULL,
	Protocol	VARCHAR2(2000) NOT NULL,
	Session_by	VARCHAR2(2000) NOT NULL
);

ALTER TABLE PoolsUsageTest_DDD ADD constraint Pk_PoolsUsageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PoolsUsageTest_DDD ON PoolsUsageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XchgASyncUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XchgASyncUserTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Device_name 	VARCHAR2(32) NOT NULL,
	Device_ID 	VARCHAR2(32) NOT NULL,
	Hits	 	VARCHAR2(32) NOT NULL,
	Bytes_sent 	VARCHAR2(32) NOT NULL,
	Bytes_rec 	VARCHAR2(32) NOT NULL,
	Email_sent 	VARCHAR2(32) NOT NULL,
	Email_rec 	VARCHAR2(32) NOT NULL,
	Calander_sent 	VARCHAR2(32) NOT NULL,
	Calander_rec 	VARCHAR2(32) NOT NULL,
	Contacts_sent 	VARCHAR2(32) NOT NULL,
	Contacts_rec 	VARCHAR2(32) NOT NULL,
	Task_sent 	VARCHAR2(32) NOT NULL,
	Task_rec 	VARCHAR2(32) NOT NULL,
	Notes_sent 	VARCHAR2(32) NOT NULL,
	Notes_rec 	VARCHAR2(32) NOT NULL,
	Oof_msg_set 	VARCHAR2(32) NOT NULL,
	Oof_msg_retr 	VARCHAR2(32) NOT NULL,
	Searches_req 	VARCHAR2(32) NOT NULL,
	Share_accs	VARCHAR2(32) NOT NULL,
	Unc_access 	VARCHAR2(32) NOT NULL,
	Atment_down 	VARCHAR2(32) NOT NULL,
	Atment_size 	VARCHAR2(32) NOT NULL,
	Cmpt_policy 	VARCHAR2(32) NOT NULL);

ALTER TABLE  XchgASyncUserTest_DDD ADD constraint Pk_XchgASyncUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XchgASyncUserTest_DDD ON XchgASyncUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ADComputersTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE ADComputersTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Distinguished_name	VARCHAR2(256) NOT NULL,
	Age			VARCHAR2(32) NOT NULL,
	Last_logon		VARCHAR2(32) NOT NULL,
	Created_on		VARCHAR2(32) NOT NULL
);

ALTER TABLE ADComputersTest_DDD ADD constraint Pk_ADComputersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ADComputersTest_DDD ON ADComputersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ADUsersTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE ADUsersTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Distinguished_name	VARCHAR2(256) NOT NULL,
	Age			VARCHAR2(32) NOT NULL,
	Last_logon		VARCHAR2(32) NOT NULL,
	Created_on		VARCHAR2(32) NOT NULL
);

ALTER TABLE ADUsersTest_DDD ADD constraint Pk_ADUsersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ADUsersTest_DDD ON ADUsersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ADDCSummaryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE ADDCSummaryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Domain_controller_name VARCHAR2(256) NOT NULL
);

ALTER TABLE ADDCSummaryTest_DDD ADD constraint Pk_ADDCSummaryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ADDCSummaryTest_DDD ON ADDCSummaryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ADGCAvailTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE ADGCAvailTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	GC_name		VARCHAR2(2000) NOT NULL
);

ALTER TABLE ADGCAvailTest_DDD ADD constraint Pk_ADGCAvailTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ADGCAvailTest_DDD ON ADGCAvailTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DNSHealthTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE DNSHealthTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Details		VARCHAR2(2000) NOT NULL
);

ALTER TABLE DNSHealthTest_DDD ADD constraint Pk_DNSHealthTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DNSHealthTest_DDD ON DNSHealthTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DSEvtLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DSEvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  DSEvtLogTest_DDD ADD constraint Pk_DSEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_DSEvtLogTest_DDD ON DSEvtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_DSEvtLogTest_DDD ON DSEvtLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_DSEvtLogTest_DDD ON DSEvtLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_DSEvtLogTest_DDD ON DSEvtLogTest_DDD ( EVENT_USER );

DROP TABLE FsmoRolesTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE FsmoRolesTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Domain_name	VARCHAR2(128) NOT NULL
);

ALTER TABLE FsmoRolesTest_DDD ADD constraint Pk_FsmoRolesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FsmoRolesTest_DDD ON FsmoRolesTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NTPTimeServerTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE NTPTimeServerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Client_timestamp VARCHAR2(128) NOT NULL,
	Server_timestamp VARCHAR2(128) NOT NULL,
	Clock_offset_of_client VARCHAR2(128) NOT NULL
);

ALTER TABLE NTPTimeServerTest_DDD ADD constraint Pk_NTPTimeServerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NTPTimeServerTest_DDD ON NTPTimeServerTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DNSEvtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DNSEvtTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  DNSEvtTest_DDD ADD constraint Pk_DNSEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_DNSEvtTest_DDD ON DNSEvtTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_DNSEvtTest_DDD ON DNSEvtTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_DNSEvtTest_DDD ON DNSEvtTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_DNSEvtTest_DDD ON DNSEvtTest_DDD ( EVENT_USER );

DROP TABLE XDMCSTaskTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDMCSTaskTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO				NUMBER(16) NOT NULL,
	Task_status			VARCHAR2(128) NOT NULL,
	Task_id				VARCHAR2(128) NOT NULL,
	Started_time			VARCHAR2(128) NOT NULL,
	Active_status			VARCHAR2(64) NOT NULL,
	Task_type			VARCHAR2(128) NOT NULL,
	Task_progress			VARCHAR2(32) NOT NULL,
	Master_image			VARCHAR2(256) NOT NULL,
	Provisioning_scheme_name	VARCHAR2(128) NOT NULL,
	Task_state			VARCHAR2(128) NOT NULL
);

ALTER TABLE XDMCSTaskTest_DDD ADD constraint Pk_XDMCSTaskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDMCSTaskTest_DDD ON XDMCSTaskTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraRacConnTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE OraRacConnTest_DDD
(
	SITE_NAME       VARCHAR2(64)   NOT NULL,
	TRGT_HOST       VARCHAR2(32)   NOT NULL,
	PORT_NO         VARCHAR2(32)   NOT NULL,
	TEST_NAME       VARCHAR2(64)   NOT NULL,
	MEASURE         VARCHAR2(64)   NOT NULL,
	INFO            VARCHAR2(128)  NOT NULL,
	STATE           VARCHAR2(32)   NOT NULL,
	MSMT_HOST       VARCHAR2(32)   NOT NULL,
	MSMT_TIME       DATE           NOT NULL,
	SEQ_NO          NUMBER(16)     NOT NULL,
	INST_ID         VARCHAR2(32)   NOT NULL,
	SID             VARCHAR2(32)   NOT NULL,
	SERIAL          VARCHAR2(32)   NOT NULL,
	OS_USER         VARCHAR2(128)  NOT NULL,
	MACHINE_NAME    VARCHAR2(128)  NOT NULL,
	TERMINAL_NAME   VARCHAR2(128)  NOT NULL,
	PROGRAM_NAME    VARCHAR2(64)  NOT NULL,
	MODULE          VARCHAR2(128)  NOT NULL,
	LAST_CALL       VARCHAR2(32)   NOT NULL,
	BLOCKING_SPID   VARCHAR2(32)   NOT NULL,
	COMMAND         VARCHAR2(2048) NOT NULL
);

ALTER TABLE  OraRacConnTest_DDD ADD constraint Pk_OraRacConnTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraRacConnTest_DDD ON OraRacConnTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OraRacWaitClassTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE OraRacWaitClassTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	SID             VARCHAR2(32)    NOT NULL,
	SERIAL          VARCHAR2(32)    NOT NULL,
	USER_NAME       VARCHAR2(128)   NOT NULL,
	OS_USER         VARCHAR2(128)   NOT NULL,
	MACHINE_NAME    VARCHAR2(128)   NOT NULL,
	PROGRAM_NAME    VARCHAR2(64)   NOT NULL,
	EVENT		VARCHAR2(128)   NOT NULL,
	SECONDS_IN_WAIT	VARCHAR2(128)   NOT NULL,
	SQL_ID		VARCHAR2(32)    NOT NULL,
	SQL_TEXT	VARCHAR2(2048)    NOT NULL
);

ALTER TABLE  OraRacWaitClassTest_DDD ADD constraint Pk_OraRacWaitClassTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraRacWaitClassTest_DDD ON OraRacWaitClassTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OraRacUptimeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraRacUptimeTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	SHUTDOWNDATE			DATE NOT NULL,
	REBOOTEDDATE			DATE NOT NULL,
	DURATION			NUMBER(20,4) NOT NULL,
	MAINTENANCE			VARCHAR2(32) NOT NULL
);

ALTER TABLE  OraRacUptimeTest_DDD ADD constraint Pk_OraRacUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraRacUptimeTest_DDD ON OraRacUptimeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgPervDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VmgPervDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Mount_point	VARCHAR2(128) NOT NULL,
	Recompose_status_text	VARCHAR2(1024) NOT NULL
);
ALTER TABLE VmgPervDiskTest_DDD ADD constraint Pk_VmgPervDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VmgPervDiskTest_DDD ON VmgPervDiskTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraRacClstrStTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OraRacClstrStTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	INSTANCE_ID			VARCHAR2(32) NOT NULL,
	INSTANCE_NAME			VARCHAR2(32) NOT NULL,
	HOST_NAME			VARCHAR2(32) NOT NULL,
	INSTANCE_STATUS			VARCHAR2(32) NOT NULL,
	STARTUP_TIME			DATE NOT NULL
);

ALTER TABLE  OraRacClstrStTest_DDD ADD constraint Pk_OraRacClstrStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OraRacClstrStTest_DDD ON OraRacClstrStTest_DDD
(
 	MSMT_TIME
);

DROP TABLE QVDNodeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE QVDNodeTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	HOST_ID         VARCHAR2(256)   NOT NULL,
	HOST_IP         VARCHAR2(256)   NOT NULL,
	HKD             VARCHAR2(256)   NOT NULL,
	IP_ADDRESS      VARCHAR2(256)   NOT NULL,
	DESKTOP_ID      VARCHAR2(256)   NOT NULL,
	DESKTOP_NAME    VARCHAR2(256)   NOT NULL,
	USER_NAME       VARCHAR2(256)   NOT NULL,
	OSF             VARCHAR2(256)   NOT NULL,
	DISK_IMAGE_TAG  VARCHAR2(256)   NOT NULL,
	DISK_IMAGE      VARCHAR2(256)   NOT NULL,
	STATUS          VARCHAR2(256)   NOT NULL,
	IS_BLOCKED      VARCHAR2(256)   NOT NULL
);

ALTER TABLE  QVDNodeTest_DDD ADD constraint Pk_QVDNodeTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_QVDNodeTest_DDD ON QVDNodeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE QVDDiskImageTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE QVDDiskImageTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	ID              VARCHAR2(256)   NOT NULL,
	OSF             VARCHAR2(256)   NOT NULL,
	VERSION         VARCHAR2(256)   NOT NULL,
	PATH            VARCHAR2(256)   NOT NULL,
	TAGS            VARCHAR2(256)   NOT NULL
);

ALTER TABLE  QVDDiskImageTest_DDD ADD constraint Pk_QVDDiskImageTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_QVDDiskImageTest_DDD ON QVDDiskImageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE QVDVmStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE QVDVmStatusTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	DESKTOP_ID      VARCHAR2(256)   NOT NULL,
	DESKTOP_NAME    VARCHAR2(256)   NOT NULL,
	USER_NAME       VARCHAR2(256)   NOT NULL,
	IP_ADDRESS      VARCHAR2(256)   NOT NULL,
	OSF             VARCHAR2(256)   NOT NULL,
	DISK_IMAGE_TAG  VARCHAR2(256)   NOT NULL,
	DISK_IMAGE      VARCHAR2(256)   NOT NULL,
	STATUS          VARCHAR2(256)   NOT NULL
);

ALTER TABLE  QVDVmStatusTest_DDD ADD constraint Pk_QVDVmStatusTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_QVDVmStatusTest_DDD ON QVDVmStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE QVDLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE QVDLoginTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	GUESTNAME	VARCHAR2(128)   NOT NULL,
	USERNAME	VARCHAR2(128)   NOT NULL,
	LOGIN_TIME 	VARCHAR2(256)   NOT NULL,
	DURATION 	VARCHAR2(128)   NOT NULL
);

ALTER TABLE  QVDLoginTest_DDD ADD constraint Pk_QVDLoginTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_QVDLoginTest_DDD ON QVDLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE QVDNodeSummaryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE QVDNodeSummaryTest_DDD
(
	SITE_NAME       VARCHAR2(64)    NOT NULL,
	TRGT_HOST       VARCHAR2(32)    NOT NULL,
	PORT_NO         VARCHAR2(32)    NOT NULL,
	TEST_NAME       VARCHAR2(64)    NOT NULL,
	MEASURE         VARCHAR2(64)    NOT NULL,
	INFO            VARCHAR2(128)   NOT NULL,
	STATE           VARCHAR2(32)    NOT NULL,
	MSMT_HOST       VARCHAR2(32)    NOT NULL,
	MSMT_TIME       DATE            NOT NULL,
	SEQ_NO          NUMBER(16)      NOT NULL,
	HOST_ID         VARCHAR2(256)   NOT NULL,
	HOST_NAME       VARCHAR2(256)   NOT NULL,
	HOST_IP         VARCHAR2(256)   NOT NULL,
	HKD             VARCHAR2(256)   NOT NULL,
	NO_OF_VM_ASSG   VARCHAR2(256)   NOT NULL,
	IS_BLOCKED      VARCHAR2(256)   NOT NULL,
	HOST_STATE      VARCHAR2(256)   NOT NULL
);

ALTER TABLE  QVDNodeSummaryTest_DDD ADD constraint Pk_QVDNodeSummaryTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_QVDNodeSummaryTest_DDD ON QVDNodeSummaryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgQVDClientTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VmgQVDClientTest_DDD
(
	SITE_NAME           VARCHAR2(64)    NOT NULL,
	TRGT_HOST           VARCHAR2(32)    NOT NULL,
	PORT_NO             VARCHAR2(32)    NOT NULL,
	TEST_NAME           VARCHAR2(64)    NOT NULL,
	MEASURE             VARCHAR2(64)    NOT NULL,
	INFO                VARCHAR2(128)   NOT NULL,
	STATE               VARCHAR2(32)    NOT NULL,
	MSMT_HOST           VARCHAR2(32)    NOT NULL,
	MSMT_TIME           DATE            NOT NULL,
	SEQ_NO              NUMBER(16)      NOT NULL,
	USER_NAME           VARCHAR2(128)    NOT NULL,
	CLIENT_IP_ADDRESS   VARCHAR2(128)    NOT NULL,
	DESKTOP_NAME        VARCHAR2(128)    NOT NULL,
	DESKTOP_IP_ADDRESS  VARCHAR2(128)    NOT NULL
);

ALTER TABLE  VmgQVDClientTest_DDD ADD constraint VmgQVDClientTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VmgQVDClientTest_DDD ON VmgQVDClientTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AsAbapUsrLgnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapUsrLgnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Terminal_ID		 VARCHAR2(32) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	Username		 VARCHAR2(32) NOT NULL,
	TCode		 VARCHAR2(32) NOT NULL,
	Last_Active_Time		 VARCHAR2(32) NOT NULL,
	Status		 VARCHAR2(32) NOT NULL,
	Login_Time		 VARCHAR2(32) NOT NULL,
	Duration_Mins		 VARCHAR2(32) NOT NULL,
	UserTerm		VARCHAR2(32) NOT NULL,
	UserType		VARCHAR2(32) NOT NULL,
	isActive		VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapUsrLgnTest_DDD ADD constraint Pk_AsAbapUsrLgnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapUsrLgnTest_DDD ON AsAbapUsrLgnTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapTrfcTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapTrfcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Host		 VARCHAR2(32) NOT NULL,
	PID		 VARCHAR2(32) NOT NULL,
	Datecol		 VARCHAR2(32) NOT NULL,
	Timecol		 VARCHAR2(32) NOT NULL,
	Destination		 VARCHAR2(32) NOT NULL,
	Functioncol		 VARCHAR2(128) NOT NULL,
	Username		 VARCHAR2(32) NOT NULL,
	Retries		 VARCHAR2(32) NOT NULL,
	Transactioncol		 VARCHAR2(32) NOT NULL,
	Message		 VARCHAR2(128) NOT NULL,
	Details		 VARCHAR2(256) NOT NULL,
	Duration	VARCHAR2(32) NOT NULL,
	TRFCID		 VARCHAR2(64) NOT NULL,
	LUWCNT		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapTrfcTest_DDD ADD constraint Pk_AsAbapTrfcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapTrfcTest_DDD ON AsAbapTrfcTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapQrfcTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapQrfcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	Q_Name		 VARCHAR2(32) NOT NULL,
	Destination		 VARCHAR2(64) NOT NULL,
	Queue_depth		 VARCHAR2(32) NOT NULL,
	Q_Lock_count		 VARCHAR2(32) NOT NULL,
	Q_RFC_User		 VARCHAR2(32) NOT NULL,
	Q_RFC_Name		 VARCHAR2(64) NOT NULL,
	First_Date_Time		 VARCHAR2(32) NOT NULL,
	Last_Date_Time		 VARCHAR2(32) NOT NULL,
	Retry_No		 VARCHAR2(32) NOT NULL,
	Error_Messages		 VARCHAR2(128) NOT NULL,
	Long_ready_duration		 VARCHAR2(32) NOT NULL,
	Long_running_duration		 VARCHAR2(32) NOT NULL,
	Q_State		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapQrfcTest_DDD ADD constraint Pk_AsAbapQrfcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapQrfcTest_DDD ON AsAbapQrfcTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapWorkTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapWorkTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Pid		 VARCHAR2(32) NOT NULL,
	CPU_busy		 VARCHAR2(32) NOT NULL,
	dumps		 VARCHAR2(32) NOT NULL,
	Username		 VARCHAR2(32) NOT NULL,
	Report		 VARCHAR2(32) NOT NULL,
	Action		 VARCHAR2(32) NOT NULL,
	Tablename		 VARCHAR2(32) NOT NULL,
	Elapsed_time		 VARCHAR2(32) NOT NULL,
	Status		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapWorkTest_DDD ADD constraint Pk_AsAbapWorkTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapWorkTest_DDD ON AsAbapWorkTest_DDD
(
	MSMT_TIME
);


DROP TABLE AsAbapEvtLnkTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapEvtLnkTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	Object_Type		 VARCHAR2(32) NOT NULL,
	Event		 VARCHAR2(64) NOT NULL,
	Receiver_Type		 VARCHAR2(32) NOT NULL,
	Receiver_FM		 VARCHAR2(128) NOT NULL,
	Check_FM		 VARCHAR2(32) NOT NULL,
	ReceiverType_FM		 VARCHAR2(32) NOT NULL,
	Global_Active		 VARCHAR2(32) NOT NULL,
	Logical_RFC_Dest		 VARCHAR2(32) NOT NULL,
	QEnabled		 VARCHAR2(32) NOT NULL,
	Receiver_Error_Behaviour		 VARCHAR2(32) NOT NULL,
	In_Active_Linkage		 VARCHAR2(32) NOT NULL,
	Error_Linkage		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapEvtLnkTest_DDD ADD constraint Pk_AsAbapEvtLnkTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapEvtLnkTest_DDD ON AsAbapEvtLnkTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapIcmTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapIcmTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Protocol		 VARCHAR2(32) NOT NULL,
	KeepAlive		 VARCHAR2(32) NOT NULL,
	Proc_Timeout		 VARCHAR2(32) NOT NULL,
	Service		 VARCHAR2(32) NOT NULL,
	Hostname		 VARCHAR2(64) NOT NULL,
	ExtBind		 VARCHAR2(64) NOT NULL,
	ThreadID		 VARCHAR2(64) NOT NULL,
	WaitReason		 VARCHAR2(128) NOT NULL
);
ALTER TABLE  AsAbapIcmTest_DDD ADD constraint Pk_AsAbapIcmTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapIcmTest_DDD ON AsAbapIcmTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapBatchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapBatchTest_DDD(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	GROUPID		 VARCHAR2(32) NOT NULL,
	QID		 VARCHAR2(32) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	Username	 VARCHAR2(32) NOT NULL,
	BatchStart	 VARCHAR2(32) NOT NULL,
	BatchEnd		 VARCHAR2(32) NOT NULL,
	Typecol		 VARCHAR2(32) NOT NULL,
	Program		 VARCHAR2(32) NOT NULL,
	isErase		 VARCHAR2(32) NOT NULL,
	Transactions	 VARCHAR2(32) NOT NULL,
	Messages	 VARCHAR2(128) NOT NULL,
	ErrTransactions	 VARCHAR2(64) NOT NULL,
	ErrMsgs		 VARCHAR2(128) NOT NULL,
	DeletedTransactions	 VARCHAR2(128) NOT NULL,
	DeletedMsgs		 VARCHAR2(128) NOT NULL,
	FinishedTrans		 VARCHAR2(128) NOT NULL,
	FinishedMsgs		 VARCHAR2(128) NOT NULL 
);
ALTER TABLE  AsAbapBatchTest_DDD ADD constraint Pk_AsAbapBatchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapBatchTest_DDD ON AsAbapBatchTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapEnqStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapEnqStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Table_name		 VARCHAR2(32) NOT NULL,
	Lock_mode		 VARCHAR2(32) NOT NULL,
	LUW_Id		 VARCHAR2(128) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	User_name		 VARCHAR2(32) NOT NULL,
	Transction_code		 VARCHAR2(32) NOT NULL,
	Host		 VARCHAR2(32) NOT NULL,
	Work_process		 VARCHAR2(32) NOT NULL,
	System_Number		 VARCHAR2(32) NOT NULL,
	LockDt		 VARCHAR2(32) NOT NULL,
	Lock_duration		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapEnqStTest_DDD ADD constraint Pk_AsAbapEnqStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapEnqStTest_DDD ON AsAbapEnqStTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapSpoReqTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapSpoReqTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Request_number		 VARCHAR2(32) NOT NULL,
	Format_type		 VARCHAR2(32) NOT NULL,
	Num_of_output_request		 VARCHAR2(32) NOT NULL,
	Output_request_processed		 VARCHAR2(32) NOT NULL,
	Output_device		 VARCHAR2(32) NOT NULL,
	Output_request_problem		 VARCHAR2(32) NOT NULL,
	Output_request_noprintout_err		 VARCHAR2(32) NOT NULL,
	Title		 VARCHAR2(32) NOT NULL,
	Recipient		 VARCHAR2(32) NOT NULL,
	Department		 VARCHAR2(32) NOT NULL,
	Datecol		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapSpoReqTest_DDD ADD constraint Pk_AsAbapSpoReqTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapSpoReqTest_DDD ON AsAbapSpoReqTest_DDD
(
	MSMT_TIME
);



DROP TABLE AsAbapBGJobTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapBGJobTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Job_name		 VARCHAR2(32) NOT NULL,
	Job_count		 VARCHAR2(32) NOT NULL,
	Internal_report_name		 VARCHAR2(32) NOT NULL,
	Initiator		 VARCHAR2(32) NOT NULL,
	Released_by		 VARCHAR2(32) NOT NULL,
	Planned_start_date		 VARCHAR2(32) NOT NULL,
	Planned_start_time		 VARCHAR2(32) NOT NULL,
	Start_date		 VARCHAR2(32) NOT NULL,
	Start_time		 VARCHAR2(32) NOT NULL,
	End_date		 VARCHAR2(32) NOT NULL,
	End_time		 VARCHAR2(32) NOT NULL,
	Priority		 VARCHAR2(32) NOT NULL,
	Periodic		 VARCHAR2(32) NOT NULL,
	Emergency_job_operation_ind		 VARCHAR2(32) NOT NULL,
	Log_lines		 VARCHAR2(512) NOT NULL,
	Duration		 VARCHAR2(32) NOT NULL,
	Delay			 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapBGJobTest_DDD ADD constraint Pk_AsAbapBGJobTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapBGJobTest_DDD ON AsAbapBGJobTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapSyslgTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapSyslgTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	Username		 VARCHAR2(32) NOT NULL,
	Terminal_Name		 VARCHAR2(32) NOT NULL,
	Severity		 VARCHAR2(32) NOT NULL,
	Alert_Category		 VARCHAR2(32) NOT NULL,
	Datecol		 VARCHAR2(32) NOT NULL,
	Timecol		 VARCHAR2(32) NOT NULL,
	Program_Name		 VARCHAR2(32) NOT NULL,
	Text_Message		 VARCHAR2(512) NOT NULL,
	dumpType		 VARCHAR2(64) NOT NULL
);
ALTER TABLE  AsAbapSyslgTest_DDD ADD constraint Pk_AsAbapSyslgTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapSyslgTest_DDD ON AsAbapSyslgTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapStdJobTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapStdJobTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Start_date		 VARCHAR2(32) NOT NULL,
	Start_time		 VARCHAR2(32) NOT NULL,
	End_date		 VARCHAR2(32) NOT NULL,
	End_time		 VARCHAR2(32) NOT NULL,
	Report		 VARCHAR2(32) NOT NULL,
	Jobcount		 VARCHAR2(32) NOT NULL,
	WPnumber		 VARCHAR2(32) NOT NULL,
	Job_class		 VARCHAR2(32) NOT NULL,
	log_lines		 VARCHAR2(512) NOT NULL
);
ALTER TABLE  AsAbapStdJobTest_DDD ADD constraint Pk_AsAbapStdJobTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapStdJobTest_DDD ON AsAbapStdJobTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapCtsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapCtsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Datecol		 VARCHAR2(32) NOT NULL,
	Timecol		 VARCHAR2(32) NOT NULL,
	Request		 VARCHAR2(32) NOT NULL,
	Target_system		 VARCHAR2(32) NOT NULL,
	Source_client		 VARCHAR2(32) NOT NULL,
	Step		 VARCHAR2(32) NOT NULL,
	Project		 VARCHAR2(32) NOT NULL,
	Username		 VARCHAR2(32) NOT NULL,
	Admincol		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapCtsTest_DDD ADD constraint Pk_AsAbapCtsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapCtsTest_DDD ON AsAbapCtsTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapUpdReqTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapUpdReqTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	VBKey		 VARCHAR2(32) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	Username		 VARCHAR2(32) NOT NULL,
	Report		 VARCHAR2(32) NOT NULL,
	Tcode		 VARCHAR2(32) NOT NULL,
	Return_code		 VARCHAR2(32) NOT NULL,
	Statecol		 VARCHAR2(32) NOT NULL,
	RequestDt		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapUpdReqTest_DDD ADD constraint Pk_AsAbapUpdReqTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapUpdReqTest_DDD ON AsAbapUpdReqTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapIdocStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapIdocStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	Idoc_Number		 VARCHAR2(32) NOT NULL,
	Status		 VARCHAR2(128) NOT NULL,
	Recipient_address		 VARCHAR2(32) NOT NULL,
	EDI_message_type		 VARCHAR2(32) NOT NULL,
	Sender_address		 VARCHAR2(64) NOT NULL,
	Creation_date		 VARCHAR2(32) NOT NULL,
	Last_changed_date		 VARCHAR2(32) NOT NULL,
	Data_records		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapIdocStTest_DDD ADD constraint Pk_AsAbapIdocStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapIdocStTest_DDD ON AsAbapIdocStTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapTaskLdTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapTaskLdTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Username		 VARCHAR2(64) NOT NULL,
	Tcode		 VARCHAR2(64) NOT NULL,
	ResponseTime		 VARCHAR2(32) NOT NULL,
	WaitTime		 VARCHAR2(32) NOT NULL,
	Memory		 VARCHAR2(32) NOT NULL,
	DBRequestTime		 VARCHAR2(32) NOT NULL,
	LoadGenTime	 VARCHAR2(32) NOT NULL,
	GuiTime		 VARCHAR2(32) NOT NULL,
	GuiNetTime	 VARCHAR2(32) NOT NULL,
	ProcessTime	 VARCHAR2(32) NOT NULL,
	RollTime	 VARCHAR2(32) NOT NULL,
	Startdate		 VARCHAR2(32) NOT NULL,
	Starttime		 VARCHAR2(32) NOT NULL,
	Enddate		 VARCHAR2(32) NOT NULL,
	Endtime		 VARCHAR2(32) NOT NULL,
	WorkprocessID		 VARCHAR2(32) NOT NULL,
	Report		 VARCHAR2(64) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	CUAProgram	VARCHAR2(64) NOT NULL,
	TerminalID	VARCHAR2(64) NOT NULL,
	StepRespTime	 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapTaskLdTest_DDD ADD constraint Pk_AsAbapTaskLdTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapTaskLdTest_DDD ON AsAbapTaskLdTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapTranLdTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapTranLdTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Username		 VARCHAR2(64) NOT NULL,
	Tasktype		 VARCHAR2(64) NOT NULL,
	ResponseTime		 VARCHAR2(32) NOT NULL,
	WaitTime		 VARCHAR2(32) NOT NULL,
	Memory		 VARCHAR2(32) NOT NULL,
	DBRequestTime		 VARCHAR2(32) NOT NULL,
	LoadGenTime	 VARCHAR2(32) NOT NULL,
	GuiTime		 VARCHAR2(32) NOT NULL,
	GuiNetTime	 VARCHAR2(32) NOT NULL,
	ProcessTime	 VARCHAR2(32) NOT NULL,
	RollTime	 VARCHAR2(32) NOT NULL,
	Startdate		 VARCHAR2(32) NOT NULL,
	Starttime		 VARCHAR2(32) NOT NULL,
	Enddate		 VARCHAR2(32) NOT NULL,
	Endtime		 VARCHAR2(32) NOT NULL,
	WorkprocessID		 VARCHAR2(32) NOT NULL,
	Report		 VARCHAR2(64) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	CUAProgram		 VARCHAR2(64) NOT NULL,
	TerminalID	 VARCHAR2(32) NOT NULL,
	StepRespTime	 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapTranLdTest_DDD ADD constraint Pk_AsAbapTranLdTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapTranLdTest_DDD ON AsAbapTranLdTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapUsrLdTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapUsrLdTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Username		 VARCHAR2(64) NOT NULL,
	Tasktype		 VARCHAR2(64) NOT NULL,
	ResponseTime		 VARCHAR2(32) NOT NULL,
	WaitTime		 VARCHAR2(32) NOT NULL,
	Memory		 VARCHAR2(32) NOT NULL,
	DBRequestTime		 VARCHAR2(32) NOT NULL,
	LoadGenTime	 VARCHAR2(32) NOT NULL,
	GuiTime		 VARCHAR2(32) NOT NULL,
	GuiNetTime	 VARCHAR2(32) NOT NULL,
	ProcessTime	 VARCHAR2(32) NOT NULL,
	RollTime	 VARCHAR2(32) NOT NULL,
	Startdate		 VARCHAR2(32) NOT NULL,
	Starttime		 VARCHAR2(32) NOT NULL,
	Enddate		 VARCHAR2(32) NOT NULL,
	Endtime		 VARCHAR2(32) NOT NULL,
	WorkprocessID		 VARCHAR2(32) NOT NULL,
	Report		 VARCHAR2(64) NOT NULL,
	Client		 VARCHAR2(32) NOT NULL,
	CUAProgram		 VARCHAR2(64) NOT NULL,
	TerminalID	 VARCHAR2(32) NOT NULL,
	StepRespTime	 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapUsrLdTest_DDD ADD constraint Pk_AsAbapUsrLdTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapUsrLdTest_DDD ON AsAbapUsrLdTest_DDD
(
	MSMT_TIME
);

DROP TABLE FgFnSslVpnTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FgFnSslVpnTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL);

ALTER TABLE  FgFnSslVpnTest_DDD ADD constraint Pk_FgFnSslVpnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FgFnSslVpnTest_DDD ON FgFnSslVpnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE FgFnRegUsersTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FgFnRegUsersTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL);

ALTER TABLE  FgFnRegUsersTest_DDD ADD constraint Pk_FgFnRegUsersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FgFnRegUsersTest_DDD ON FgFnRegUsersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE FCCluNodeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FCCluNodeTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	INTERFACENAME   VARCHAR2(256) NOT NULL,
	INTERFACESTATE  VARCHAR2(256) NOT NULL,
	NETWORK 	VARCHAR2(128) NOT NULL,
	ADAPTER    	VARCHAR2(128) NOT NULL,
	ADAPTERID  	VARCHAR2(128) NOT NULL,
	ADDRESS  	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  FCCluNodeTest_DDD ADD constraint Pk_FCCluNodeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FCCluNodeTest_DDD ON FCCluNodeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE FCCluDiskTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FCCluDiskTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PATH            VARCHAR2(256) NOT NULL,
	VOLUMELABEL  	VARCHAR2(256) NOT NULL,
	OWNERNODE 	VARCHAR2(128) NOT NULL,
	RESOURCETYPE    VARCHAR2(128) NOT NULL,
	RESOURCEGROUP  	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  FCCluDiskTest_DDD ADD constraint Pk_FCCluDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FCCluDiskTest_DDD ON FCCluDiskTest_DDD
(
 	MSMT_TIME
);

DROP TABLE FCCluStoragTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FCCluStoragTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	OWNERNODE       VARCHAR2(256) NOT NULL,
	PATH    	VARCHAR2(256) NOT NULL
);

ALTER TABLE  FCCluStoragTest_DDD ADD constraint Pk_FCCluStoragTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FCCluStoragTest_DDD ON FCCluStoragTest_DDD
(
 	MSMT_TIME
);

DROP TABLE FCCluDiskSumTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  FCCluDiskSumTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NAME            VARCHAR2(256) NOT NULL,
	STATUS  	VARCHAR2(256) NOT NULL,
	ISSHAREDVOLUME 	VARCHAR2(128) NOT NULL,
	PATH    	VARCHAR2(128) NOT NULL,
	VOLUMELABEL  	VARCHAR2(128) NOT NULL,
	TOTALSIZE  	VARCHAR2(128) NOT NULL,
	FREESPACE  	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  FCCluDiskSumTest_DDD ADD constraint Pk_FCCluDiskSumTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FCCluDiskSumTest_DDD ON FCCluDiskSumTest_DDD
(
 	MSMT_TIME
);

DROP TABLE KVMGuestStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  KVMGuestStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(64) NOT NULL,
	GUEST_IP	VARCHAR2(64) NOT NULL,
	GUEST_OS	VARCHAR2(64) NOT NULL,
	USER_NAME	VARCHAR2(64) NOT NULL
);

ALTER TABLE  KVMGuestStatusTest_DDD ADD constraint Pk_KVMGuestStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


CREATE  INDEX IDX_KVMGuestStatusTest_DDD ON KVMGuestStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE KVMGuestTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  KVMGuestTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_name		VARCHAR2(256) NOT NULL,
	Username	VARCHAR2(256) NOT NULL,
	OS		VARCHAR2(256) NOT NULL,
	IO_OPERATIONS	NUMBER(20,4) NOT NULL
);

ALTER TABLE  KVMGuestTest_DDD ADD constraint Pk_KVMGuestTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_KVMGuestTest_DDD ON KVMGuestTest_DDD
(
 	MSMT_TIME
);

DROP TABLE KVMMemoryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  KVMMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Process_id	VARCHAR2(32) NOT NULL,
	Memory		VARCHAR2(64) NOT NULL,
	Arguments	VARCHAR2(2000) NOT NULL,
	Username	VARCHAR2(64) NOT NULL
);

ALTER TABLE  KVMMemoryTest_DDD ADD constraint Pk_KVMMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


CREATE  INDEX IDX_KVMMemoryTest_DDD ON KVMMemoryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE KVMLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  KVMLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  KVMLoginTest_DDD ADD constraint Pk_KVMLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_KVMLoginTest_DDD ON KVMLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxSFSvrGroupTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CtxSFSvrGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	BASEURL 	VARCHAR2(256) NOT NULL,
	SERVERNAME 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  CtxSFSvrGroupTest_DDD ADD constraint Pk_CtxSFSvrGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSFSvrGroupTest_DDD ON CtxSFSvrGroupTest_DDD
(
 	MSMT_TIME
);



DROP TABLE CtxSFSvrDetailTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CtxSFSvrDetailTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SYNCSTARTTIME 	VARCHAR2(256) NOT NULL,
	SYNCENDTIME 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  CtxSFSvrDetailTest_DDD ADD constraint Pk_CtxSFSvrDetailTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSFSvrDetailTest_DDD ON CtxSFSvrDetailTest_DDD
(
 	MSMT_TIME
);


DROP TABLE CtxSFStoresTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CtxSFStoresTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	BASEURL 	VARCHAR2(256) NOT NULL,
	SITE_ID 	VARCHAR2(128) NOT NULL,
	V_DIRECTORY 	VARCHAR2(128) NOT NULL,
	SITE_N 		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxSFStoresTest_DDD ADD constraint Pk_CtxSFStoresTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSFStoresTest_DDD ON CtxSFStoresTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxUserDeviceTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  CtxUserDeviceTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SERVER_NAME VARCHAR2(128) NOT NULL,
	SESSION_NAME VARCHAR2(128) NOT NULL,
	SESSION_ID VARCHAR2(128) NOT NULL,
	APPLICATION_NAME VARCHAR2(256) NOT NULL,
	CONNECTED_USER VARCHAR2(128) NOT NULL,
	CLIENT_NAME VARCHAR2(128) NOT NULL,
	CLIENT_IPADDRESS VARCHAR2(256) NOT NULL,
	CLIENT_VERSION VARCHAR2(128) NOT NULL,
	CLIENT_ID VARCHAR2(128) NOT NULL,
	CLIENT_TYPE VARCHAR2(256) NOT NULL,
	ASSOCIATE_GROUP VARCHAR2(256) NOT NULL
);

ALTER TABLE  CtxUserDeviceTest_DDD ADD constraint Pk_CtxUserDeviceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxUserDeviceTest_DDD ON CtxUserDeviceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDFMachTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDFMachTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Associated_username	VARCHAR2(1024) NOT NULL,
	Last_deregistered_reason VARCHAR2(128) NOT NULL,
	Last_deregistered_date	VARCHAR2(128) NOT NULL,
	Failure_date		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL,
	Is_assigned		VARCHAR2(128) NOT NULL,
	Is_in_maintenance_mode	VARCHAR2(128) NOT NULL,
	Power_state		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDFMachTest_DDD ADD constraint Pk_CtxXcXDFMachTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDFMachTest_DDD ON CtxXcXDFMachTest_DDD
(
 	MSMT_TIME
);
CREATE INDEX IDX1_CTXXCXDFMACHTEST_DDD ON CTXXCXDFMACHTEST_DDD (TRGT_HOST, MSMT_TIME);

DROP TABLE CtxXcXDCFMachTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCFMachTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Associated_username	VARCHAR2(1024) NOT NULL,
	Last_deregistered_reason VARCHAR2(128) NOT NULL,
	Last_deregistered_date	VARCHAR2(128) NOT NULL,
	Failure_date		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL,
	Is_assigned		VARCHAR2(128) NOT NULL,
	Is_in_maintenance_mode	VARCHAR2(128) NOT NULL,
	Power_state		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCFMachTest_DDD ADD constraint Pk_CtxXcXDCFMachTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCFMachTest_DDD ON CtxXcXDCFMachTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDFConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDFConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Failure_reason		VARCHAR2(128) NOT NULL,
	Failure_time		VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDFConnTest_DDD ADD constraint Pk_CtxXcXDFConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDFConnTest_DDD ON CtxXcXDFConnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDCFConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCFConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Failure_reason		VARCHAR2(128) NOT NULL,
	Failure_time		VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCFConnTest_DDD ADD constraint Pk_CtxXcXDCFConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCFConnTest_DDD ON CtxXcXDCFConnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDLogonTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDLogonTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Logon_start_time	VARCHAR2(128) NOT NULL,
	Logon_duration		NUMBER(20,4) NOT NULL,
	Brokering 		NUMBER(20,4) NOT NULL,
	Vm_start 		NUMBER(20,4) NOT NULL,
	HDX_connection 		NUMBER(20,4) NOT NULL,
	Authentication 		NUMBER(20,4) NOT NULL,
	Gpos 			NUMBER(20,4) NOT NULL,
	Logon_scripts 		NUMBER(20,4) NOT NULL,
	Profile_load 		NUMBER(20,4) NOT NULL,
	Interactive_session 	NUMBER(20,4) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Delivery_group		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Is_Reconnect		VARCHAR2(128) NOT NULL,
	Session_Key		VARCHAR2(128) NOT NULL,
	Pre_userinit 		NUMBER(20,4) NOT NULL,
	Userinit  		NUMBER(20,4) NOT NULL,
	Shell_duration 		NUMBER(20,4) NOT NULL,
	Delay_duration 		NUMBER(20,4) NOT NULL);

ALTER TABLE  CtxXcXDLogonTest_DDD ADD constraint Pk_CtxXcXDLogonTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDLogonTest_DDD ON CtxXcXDLogonTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDCLogonTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCLogonTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Logon_duration		NUMBER(20,4) NOT NULL,
	Brokering 		NUMBER(20,4) NOT NULL,
	Vm_start 		NUMBER(20,4) NOT NULL,
	HDX_connection 		NUMBER(20,4) NOT NULL,
	Authentication 		NUMBER(20,4) NOT NULL,
	Gpos 			NUMBER(20,4) NOT NULL,
	Logon_scripts 		NUMBER(20,4) NOT NULL,
	Profile_load 		NUMBER(20,4) NOT NULL,
	Interactive_session 	NUMBER(20,4) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCLogonTest_DDD ADD constraint Pk_CtxXcXDCLogonTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCLogonTest_DDD ON CtxXcXDCLogonTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDUserTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Logon_start_time	VARCHAR2(128) NOT NULL,
	Logon_duration		NUMBER(20,4) NOT NULL,
	Brokering 		NUMBER(20,4) NOT NULL,
	Vm_start 		NUMBER(20,4) NOT NULL,
	HDX_connection 		NUMBER(20,4) NOT NULL,
	Authentication 		NUMBER(20,4) NOT NULL,
	Gpos 			NUMBER(20,4) NOT NULL,
	Logon_scripts 		NUMBER(20,4) NOT NULL,
	Profile_load 		NUMBER(20,4) NOT NULL,
	Interactive_session 	NUMBER(20,4) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Delivery_group		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Is_Reconnect		VARCHAR2(128) NOT NULL,
	Session_Key		VARCHAR2(128) NOT NULL,
	Pre_userinit 		NUMBER(20,4) NOT NULL,
	Userinit  		NUMBER(20,4) NOT NULL,
	Shell_duration 		NUMBER(20,4) NOT NULL,
	Delay_duration 		NUMBER(20,4) NOT NULL);

ALTER TABLE  CtxXcXDUserTest_DDD ADD constraint Pk_CtxXcXDUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDUserTest_DDD ON CtxXcXDUserTest_DDD
(
 	MSMT_TIME
);
CREATE INDEX IDX1_CTXXCXDUSERTEST_DDD ON CTXXCXDUSERTEST_DDD (TRGT_HOST,MSMT_TIME);
CREATE INDEX IDX2_CtxXcXDUserTest_DDD ON CtxXcXDUserTest_DDD (TRGT_HOST,MSMT_TIME,LOGON_DURATION);


DROP TABLE CtxXcXDCUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCUserTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Logon_duration		NUMBER(20,4) NOT NULL,
	Brokering 		NUMBER(20,4) NOT NULL,
	Vm_start 		NUMBER(20,4) NOT NULL,
	HDX_connection 		NUMBER(20,4) NOT NULL,
	Authentication 		NUMBER(20,4) NOT NULL,
	Gpos 			NUMBER(20,4) NOT NULL,
	Logon_scripts 		NUMBER(20,4) NOT NULL,
	Profile_load 		NUMBER(20,4) NOT NULL,
	Interactive_session 	NUMBER(20,4) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCUserTest_DDD ADD constraint Pk_CtxXcXDCUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCUserTest_DDD ON CtxXcXDCUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDLoadIdxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDLoadIdxTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Sessions		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Total			VARCHAR2(128) NOT NULL,
	Cpu			VARCHAR2(128) NOT NULL,
	Memory			VARCHAR2(128) NOT NULL,
	Disk			VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDLoadIdxTest_DDD ADD constraint Pk_CtxXcXDLoadIdxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDLoadIdxTest_DDD ON CtxXcXDLoadIdxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDCLoadIdxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDCLoadIdxTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Sessions		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Total			VARCHAR2(128) NOT NULL,
	Cpu			VARCHAR2(128) NOT NULL,
	Memory			VARCHAR2(128) NOT NULL,
	Disk			VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDCLoadIdxTest_DDD ADD constraint Pk_CtxXcXDCLoadIdxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDCLoadIdxTest_DDD ON CtxXcXDCLoadIdxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSessionsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSessionsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Session_start_time	VARCHAR2(128) NOT NULL,
	Session_change_time	VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Session_key		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSessionsTest_DDD ADD constraint Pk_CtxXcXDSessionsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSessionsTest_DDD ON CtxXcXDSessionsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDDesktopsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDDesktopsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name	VARCHAR2(128) NOT NULL,
	Dns_name	VARCHAR2(128) NOT NULL,
	Ip_address	VARCHAR2(128) NOT NULL,
	Os		VARCHAR2(128) NOT NULL,
	Vda_version	VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Failure_type	VARCHAR2(128) NOT NULL,
	Failure_reason	VARCHAR2(128) NOT NULL,
	Failure_time	VARCHAR2(128) NOT NULL,
	Is_assigned	VARCHAR2(128) NOT NULL,
	Maintenance_mode	VARCHAR2(128) NOT NULL,
	Pending_image_update	VARCHAR2(128) NOT NULL,
	Is_preparing		VARCHAR2(128) NOT NULL,
	Registration_state	VARCHAR2(128) NOT NULL,
	Power_state		VARCHAR2(128) NOT NULL,
	Sessions		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Delivery_group		VARCHAR2(128) NOT NULL,
	Catalog			VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Allocation_type		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDDesktopsTest_DDD ADD constraint Pk_CtxXcXDDesktopsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDDesktopsTest_DDD ON CtxXcXDDesktopsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDServersTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDServersTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name	VARCHAR2(128) NOT NULL,
	Dns_name	VARCHAR2(128) NOT NULL,
	Ip_address	VARCHAR2(128) NOT NULL,
	Os		VARCHAR2(128) NOT NULL,
	Vda_version	VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Failure_type		VARCHAR2(128) NOT NULL,
	Failure_reason		VARCHAR2(128) NOT NULL,
	Failure_time		VARCHAR2(128) NOT NULL,
	Maintenance_mode	VARCHAR2(128) NOT NULL,
	Pending_image_update	VARCHAR2(128) NOT NULL,
	Registration_state	VARCHAR2(128) NOT NULL,
	Power_state		VARCHAR2(128) NOT NULL,
	Sessions		VARCHAR2(128) NOT NULL,
	Effective_load_index	VARCHAR2(128) NOT NULL,
	Cpu			VARCHAR2(128) NOT NULL,
	Memory			VARCHAR2(128) NOT NULL,
	Disk			VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL,
	Windows_connection_setting	VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Delivery_group		VARCHAR2(128) NOT NULL,
	Catalog			VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Allocation_type		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDServersTest_DDD ADD constraint Pk_CtxXcXDServersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDServersTest_DDD ON CtxXcXDServersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Failure_type		VARCHAR2(128) NOT NULL,
	Failure_reason		VARCHAR2(128) NOT NULL,
	Failure_time		VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Secure_ica		VARCHAR2(128) NOT NULL,
	Reconnect		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDConnTest_DDD ADD constraint Pk_CtxXcXDConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDConnTest_DDD ON CtxXcXDConnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSiteSiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSiteSiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SiteName		VARCHAR2(128) NOT NULL,
	License_server_name	VARCHAR2(128) NOT NULL,
	License_server_port 	VARCHAR2(128) NOT NULL,
	License_edition		VARCHAR2(128) NOT NULL,
	License_model		VARCHAR2(128) NOT NULL,
	Os			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Req_sa_date		VARCHAR2(128) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSiteSiteTest_DDD ADD constraint Pk_CtxXcXDSiteSiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSiteSiteTest_DDD ON CtxXcXDSiteSiteTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSiteHypTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSiteHypTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Connection_name		VARCHAR2(128) NOT NULL,
	Connection_type		VARCHAR2(128) NOT NULL,
	Hypervisor_address 	VARCHAR2(2000) NOT NULL,
	Preferred_controller	VARCHAR2(128) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSiteHypTest_DDD ADD constraint Pk_CtxXcXDSiteHypTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSiteHypTest_DDD ON CtxXcXDSiteHypTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSiteCtrlTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSiteCtrlTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Dns_name		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Broker_version		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Last_active_time	VARCHAR2(128) NOT NULL,
	Last_start_time		VARCHAR2(128) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSiteCtrlTest_DDD ADD constraint Pk_CtxXcXDSiteCtrlTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSiteCtrlTest_DDD ON CtxXcXDSiteCtrlTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSiteClogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSiteClogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Machine_type		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	User_data		VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Pvs_address		VARCHAR2(128) NOT NULL,
	Pvs_domain		VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSiteClogTest_DDD ADD constraint Pk_CtxXcXDSiteClogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSiteClogTest_DDD ON CtxXcXDSiteClogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSHypTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSHypTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Connection_name		VARCHAR2(128) NOT NULL,
	Connection_type		VARCHAR2(128) NOT NULL,
	Hypervisor_address 	VARCHAR2(256) NOT NULL,
	Preferred_controller	VARCHAR2(128) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSHypTest_DDD ADD constraint Pk_CtxXcXDSHypTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSHypTest_DDD ON CtxXcXDSHypTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSAppTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Application_name	VARCHAR2(128) NOT NULL,
	Display_name		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Application_type	VARCHAR2(128) NOT NULL,
	Program			VARCHAR2(1024) NOT NULL,
	Working_directory	VARCHAR2(1024) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	catalog_name		VARCHAR2(128) NOT NULL,
	Id			VARCHAR2(128) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Session_start_time	VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSAppTest_DDD ADD constraint Pk_CtxXcXDSAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSAppTest_DDD ON CtxXcXDSAppTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSSiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSSiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SiteName		VARCHAR2(128) NOT NULL,
	License_server_name	VARCHAR2(128) NOT NULL,
	License_server_port 	VARCHAR2(128) NOT NULL,
	Desktop_lic_edition	VARCHAR2(128) NOT NULL,
	Desktop_lic_model	VARCHAR2(128) NOT NULL,
	App_lic_edition		VARCHAR2(128) NOT NULL,
	App_lic_model		VARCHAR2(128) NOT NULL,
	Req_sa_date		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSSiteTest_DDD ADD constraint Pk_CtxXcXDSSiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSSiteTest_DDD ON CtxXcXDSSiteTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSBrokerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSBrokerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Dns_name		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Broker_version		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Last_active_time	VARCHAR2(128) NOT NULL,
	Last_start_time		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSBrokerTest_DDD ADD constraint Pk_CtxXcXDSBrokerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSBrokerTest_DDD ON CtxXcXDSBrokerTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSGroupTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Desktop_kind		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Session_username	VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Published_applications	VARCHAR2(2000) NOT NULL,
	Published_name		VARCHAR2(128) NOT NULL,
	Reason			VARCHAR2(256) NOT NULL,
	D_and_t			VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSGroupTest_DDD ADD constraint Pk_CtxXcXDSGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSGroupTest_DDD ON CtxXcXDSGroupTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSBrMachTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSBrMachTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Desktop_group_name	VARCHAR2(128) NOT NULL,
	Desktop_kind		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Measure_state		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Session_username	VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Published_applications	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxXcXDSBrMachTest_DDD ADD constraint Pk_CtxXcXDSBrMachTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSBrMachTest_DDD ON CtxXcXDSBrMachTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSSessionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSSessionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL
);

ALTER TABLE  CtxXcXDSSessionTest_DDD ADD constraint Pk_CtxXcXDSSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSSessionTest_DDD ON CtxXcXDSSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL,
	Login_duration		NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxXcXDSLoginTest_DDD ADD constraint Pk_CtxXcXDSLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSLoginTest_DDD ON CtxXcXDSLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSLoadIdxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSLoadIdxTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Sessions		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Total			VARCHAR2(128) NOT NULL,
	Cpu			VARCHAR2(128) NOT NULL,
	Memory			VARCHAR2(128) NOT NULL,
	Disk			VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSLoadIdxTest_DDD ADD constraint Pk_CtxXcXDSLoadIdxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSLoadIdxTest_DDD ON CtxXcXDSLoadIdxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSFMachTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSFMachTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Associated_username	VARCHAR2(1024) NOT NULL,
	Last_deregistered_reason VARCHAR2(128) NOT NULL,
	Last_deregistered_date	VARCHAR2(128) NOT NULL,
	Failure_date		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL,
	Is_assigned		VARCHAR2(128) NOT NULL,
	Is_in_maintenance_mode	VARCHAR2(128) NOT NULL,
	Power_state		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSFMachTest_DDD ADD constraint Pk_CtxXcXDSFMachTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSFMachTest_DDD ON CtxXcXDSFMachTest_DDD
(
 	MSMT_TIME
);


DROP TABLE CtxXcXDSFConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSFConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Failure_reason		VARCHAR2(128) NOT NULL,
	Failure_time		VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSFConnTest_DDD ADD constraint Pk_CtxXcXDSFConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSFConnTest_DDD ON CtxXcXDSFConnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSLogonTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSLogonTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Logon_duration		NUMBER(20,4) NOT NULL,
	Brokering 		NUMBER(20,4) NOT NULL,
	Vm_start 		NUMBER(20,4) NOT NULL,
	HDX_connection 		NUMBER(20,4) NOT NULL,
	Authentication 		NUMBER(20,4) NOT NULL,
	Gpos 			NUMBER(20,4) NOT NULL,
	Logon_scripts 		NUMBER(20,4) NOT NULL,
	Profile_load 		NUMBER(20,4) NOT NULL,
	Interactive_session 	NUMBER(20,4) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSLogonTest_DDD ADD constraint Pk_CtxXcXDSLogonTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSLogonTest_DDD ON CtxXcXDSLogonTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSUserTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Associated_username	VARCHAR2(128) NOT NULL,
	Logon_duration		NUMBER(20,4) NOT NULL,
	Brokering 		NUMBER(20,4) NOT NULL,
	Vm_start 		NUMBER(20,4) NOT NULL,
	HDX_connection 		NUMBER(20,4) NOT NULL,
	Authentication 		NUMBER(20,4) NOT NULL,
	Gpos 			NUMBER(20,4) NOT NULL,
	Logon_scripts 		NUMBER(20,4) NOT NULL,
	Profile_load 		NUMBER(20,4) NOT NULL,
	Interactive_session 	NUMBER(20,4) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address	VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSUserTest_DDD ADD constraint Pk_CtxXcXDSUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXDSUserTest_DDD ON CtxXcXDSUserTest_DDD
(
 	MSMT_TIME
);


DROP TABLE JavaExceptionsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE JavaExceptionsTest_DDD
(
SITE_NAME		VARCHAR2(64) NOT NULL,
TRGT_HOST		VARCHAR2(32) NOT NULL,
PORT_NO			VARCHAR2(32) NOT NULL,
TEST_NAME		VARCHAR2(64) NOT NULL,
MEASURE			VARCHAR2(64) NOT NULL,
INFO			VARCHAR2(256) NOT NULL,
STATE			VARCHAR2(32) NOT NULL,
MSMT_HOST		VARCHAR2(32) NOT NULL,
MSMT_TIME		DATE NOT NULL,
SEQ_NO			NUMBER(16) NOT NULL,
EG_GUID			VARCHAR2(64) NOT NULL,
NODE_ORDER		VARCHAR2(16) NOT NULL,
REQ_TYPE		VARCHAR2(64) NOT NULL,
BUSINESS_TRANSACTION	VARCHAR2(128) NOT NULL,
EXCEPTION_MSG		VARCHAR2(2048) NOT NULL,
CAUSE1			VARCHAR2(256) NOT NULL,
CAUSE1_MSG		VARCHAR2(2048) NOT NULL,
CAUSE2			VARCHAR2(256) NOT NULL,
CAUSE2_MSG		VARCHAR2(2048) NOT NULL,
CAUSE3			VARCHAR2(256) NOT NULL,
CAUSE3_MSG		VARCHAR2(2048) NOT NULL,
CAUSE_NM2		VARCHAR2(256) NOT NULL,
CAUSE_NM2_MSG		VARCHAR2(2048) NOT NULL,
CAUSE_NM1		VARCHAR2(256) NOT NULL,
CAUSE_NM1_MSG		VARCHAR2(2048) NOT NULL,
CAUSE_N			VARCHAR2(256) NOT NULL,
CAUSE_N_MSG		VARCHAR2(2048) NOT NULL);

ALTER TABLE  JavaExceptionsTest_DDD ADD constraint Pk_JavaExceptionsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_JavaExceptionsTest_DDD ON JavaExceptionsTest_DDD
(
	EG_GUID
);

CREATE  INDEX IDX1_JavaExceptionsTest_DDD ON JavaExceptionsTest_DDD
(
	MSMT_TIME
);

CREATE  INDEX IDX2_JavaExceptionsTest_DDD ON JavaExceptionsTest_DDD
(
	INFO
);

CREATE  INDEX IDX3_JavaExceptionsTest_DDD ON JavaExceptionsTest_DDD
(
	BUSINESS_TRANSACTION
);

DROP TABLE BusinessTransTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE BusinessTransTest_DDD
(
SITE_NAME		VARCHAR2(64) NOT NULL,
TRGT_HOST		VARCHAR2(32) NOT NULL,
PORT_NO			VARCHAR2(32) NOT NULL,
TEST_NAME		VARCHAR2(64) NOT NULL,
MEASURE			VARCHAR2(64) NOT NULL,
INFO			VARCHAR2(128) NOT NULL,
STATE			VARCHAR2(32) NOT NULL,
MSMT_HOST		VARCHAR2(32) NOT NULL,
MSMT_TIME		DATE NOT NULL,
SEQ_NO 			NUMBER(16) NOT NULL,
EG_GUID			VARCHAR2(64) NOT NULL,
NODE_ORDER		VARCHAR2(512) NOT NULL,
APPLICATION_NAME	VARCHAR2(64) NOT NULL,
CONTEXT_NAME		VARCHAR2(64) NOT NULL,
REQUEST_TIME		DATE NOT NULL,
THREAD_GUID		VARCHAR2(64) NOT NULL,
URI			VARCHAR2(512) NOT NULL,
RESPONSE_TIME		NUMBER(20,4) NOT NULL,
TIME_ZONE		VARCHAR2(32) NOT NULL,
REMOTE_HOST		VARCHAR2(256) NOT NULL,
REQUEST_TYPE		VARCHAR2(16) NOT NULL,
TRANSACTION_TYPE	VARCHAR2(16) NOT NULL,
SLOW_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
STALLED_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
URL_PARAMS		VARCHAR2(1024) NOT NULL,
SESSION_ID		VARCHAR2(128) NOT NULL,
THREAD_ID		VARCHAR2(512) NOT NULL,
DEVICE			VARCHAR2(64) NOT NULL,
OS			VARCHAR2(64) NOT NULL,
BROWSER			VARCHAR2(64) NOT NULL,
REFERER			VARCHAR2(2000) NOT NULL,
COUNTRY			VARCHAR2(32) NOT NULL,
LOCATION		VARCHAR2(32) NOT NULL,
POSITION		VARCHAR2(32) NOT NULL,
TRACE_DETAILS		BLOB NOT NULL,
PRE_PROCESSOR_TIME	NUMBER(20,4) NOT NULL,
METHOD_TYPE		VARCHAR2(32) NOT NULL,
STATUS_CODE		VARCHAR2(32) NOT NULL,
COOKIES		VARCHAR2(2000) NOT NULL,
HEADER		VARCHAR2(2000) NOT NULL,
USERNAME		VARCHAR2(2000) NOT NULL,
BUSINESS_CONTEXT	VARCHAR2(2000) NOT NULL,
CPU_TIME		NUMBER(20,4) NOT NULL,
WAIT_TIME 		NUMBER(20,4) NOT NULL,
BLOCK_TIME		NUMBER(20,4) NOT NULL,
USER_AGENT		VARCHAR2(2000) NOT NULL,
BROWSER_VERSION		VARCHAR2(64) NOT NULL,
REGION			VARCHAR2(64) NOT NULL,
CITY			VARCHAR2(128) NOT NULL,
GATEWAY_IP		VARCHAR2(256) NOT NULL,
EXCEPTION_NAME		VARCHAR2(256) NOT NULL,
COMPONENT_ID		VARCHAR2(128) NOT NULL,
UTC_DATE		DATE NOT NULL,
constraint Pk_BusinessTransTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO))
organization index compress overflow;

CREATE  INDEX IDX0_BusinessTransTest_DDD ON BusinessTransTest_DDD
(
	MSMT_TIME,TRGT_HOST,PORT_NO
);

CREATE  INDEX IDX1_BusinessTransTest_DDD ON BusinessTransTest_DDD
(
	RESPONSE_TIME DESC
);

CREATE  INDEX IDX2_BusinessTransTest_DDD ON BusinessTransTest_DDD
(
	MSMT_TIME,SEQ_NO
);

CREATE  INDEX IDX3_BusinessTransTest_DDD ON BusinessTransTest_DDD
(
	EG_GUID
);
CREATE  INDEX IDX4_BusinessTransTest_DDD ON BusinessTransTest_DDD
(
	MSMT_TIME
);
CREATE  INDEX IDX5_BusinessTransTest_DDD ON BusinessTransTest_DDD
(
	REQUEST_TYPE
);
CREATE INDEX idx6_businesstranstest_ddd ON BusinessTransTest_DDD (NODE_ORDER,TRGT_HOST,PORT_NO,MSMT_TIME);
CREATE INDEX IDX7_BusinessTransTest_DDD ON BusinessTransTest_DDD (REQUEST_TIME DESC);

DROP TABLE KBusinessTransTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE KBusinessTransTest_DDD
(
SITE_NAME		VARCHAR2(64) NOT NULL,
TRGT_HOST		VARCHAR2(32) NOT NULL,
PORT_NO			VARCHAR2(32) NOT NULL,
TEST_NAME		VARCHAR2(64) NOT NULL,
MEASURE			VARCHAR2(64) NOT NULL,
INFO			VARCHAR2(128) NOT NULL,
STATE			VARCHAR2(32) NOT NULL,
MSMT_HOST		VARCHAR2(32) NOT NULL,
MSMT_TIME		DATE NOT NULL,
SEQ_NO 			NUMBER(16) NOT NULL,
EG_GUID			VARCHAR2(64) NOT NULL,
NODE_ORDER		VARCHAR2(512) NOT NULL,
APPLICATION_NAME	VARCHAR2(64) NOT NULL,
CONTEXT_NAME		VARCHAR2(64) NOT NULL,
REQUEST_TIME		DATE NOT NULL,
THREAD_GUID		VARCHAR2(64) NOT NULL,
URI			VARCHAR2(512) NOT NULL,
RESPONSE_TIME		NUMBER(20,4) NOT NULL,
TIME_ZONE		VARCHAR2(32) NOT NULL,
REMOTE_HOST		VARCHAR2(256) NOT NULL,
REQUEST_TYPE		VARCHAR2(16) NOT NULL,
TRANSACTION_TYPE	VARCHAR2(16) NOT NULL,
SLOW_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
STALLED_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
URL_PARAMS		VARCHAR2(1024) NOT NULL,
SESSION_ID		VARCHAR2(128) NOT NULL,
THREAD_ID		VARCHAR2(512) NOT NULL,
DEVICE			VARCHAR2(64) NOT NULL,
OS			VARCHAR2(64) NOT NULL,
BROWSER			VARCHAR2(64) NOT NULL,
REFERER			VARCHAR2(2000) NOT NULL,
COUNTRY			VARCHAR2(32) NOT NULL,
LOCATION		VARCHAR2(32) NOT NULL,
POSITION		VARCHAR2(32) NOT NULL,
TRACE_DETAILS		BLOB NOT NULL,
PRE_PROCESSOR_TIME	NUMBER(20,4) NOT NULL,
METHOD_TYPE		VARCHAR2(32) NOT NULL,
STATUS_CODE		VARCHAR2(32) NOT NULL,
COOKIES			VARCHAR2(2000) NOT NULL,
HEADER			VARCHAR2(2000) NOT NULL,
USERNAME		VARCHAR2(2000) NOT NULL,
BUSINESS_CONTEXT	VARCHAR2(2000) NOT NULL,
CPU_TIME		NUMBER(20,4) NOT NULL,
WAIT_TIME 		NUMBER(20,4) NOT NULL,
BLOCK_TIME		NUMBER(20,4) NOT NULL,
USER_AGENT		VARCHAR2(2000) NOT NULL,
BROWSER_VERSION		VARCHAR2(64) NOT NULL,
REGION			VARCHAR2(64) NOT NULL,
CITY			VARCHAR2(128) NOT NULL,
GATEWAY_IP		VARCHAR2(256) NOT NULL,
EXCEPTION_NAME		VARCHAR2(256) NOT NULL,
COMPONENT_ID		VARCHAR2(128) NOT NULL,
UTC_DATE		DATE NOT NULL,
constraint Pk_KBusinessTransTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO))
organization index compress overflow;

CREATE  INDEX IDX_KBusinessTransTest_DDD ON KBusinessTransTest_DDD
(
	EG_GUID
);

CREATE  INDEX IDX1_KBusinessTransTest_DDD ON KBusinessTransTest_DDD
(
	MSMT_TIME
);

DROP TABLE NetCluQuotaTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NetCluQuotaTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	QUOTA_TYPE		VARCHAR2(128) NOT NULL,
	QUOTA_TARGET		VARCHAR2(128) NOT NULL,
	VOLUME			VARCHAR2(64) NOT NULL,
	QTREE			VARCHAR2(64) NOT NULL,
	PCT_DISK_LIMIT		VARCHAR2(64) NOT NULL,
	PCT_FILE_LIMIT		VARCHAR2(64) NOT NULL,
	WINDOWS_USERS		VARCHAR2(32) NOT NULL,
	UNIX_USERS		VARCHAR2(32) NOT NULL,
	UNIX_GROUPS_USERS	VARCHAR2(32) NOT NULL
);

ALTER TABLE  NetCluQuotaTest_DDD ADD constraint Pk_NetCluQuotaTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NetCluQuotaTest_DDD ON NetCluQuotaTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NetCluJobTypeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NetCluJobTypeTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	VSERVER			VARCHAR2(128) NOT NULL,
	JOB_NAME		VARCHAR2(128) NOT NULL,
	JOB_PRIORITY		VARCHAR2(128) NOT NULL,
	JOB_DESCRIPTION		VARCHAR2(128) NOT NULL,
	JOB_PROGRESS		VARCHAR2(128) NOT NULL
);

ALTER TABLE  NetCluJobTypeTest_DDD ADD constraint Pk_NetCluJobTypeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NetCluJobTypeTest_DDD ON NetCluJobTypeTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NetCluCfTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NetCluCfTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	PARTNER_NAME			VARCHAR2(128) NOT NULL,
	PARTNER_SYSTEM_ID		VARCHAR2(128) NOT NULL,
	PARTNER_LAST_STATUS_UPDATE	VARCHAR2(128) NOT NULL
);

ALTER TABLE  NetCluCfTest_DDD ADD constraint Pk_NetCluCfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NetCluCfTest_DDD ON NetCluCfTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AppVVAppsLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppVVAppsLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppVVAppsLogTest_DDD ADD constraint Pk_AppVVAppsLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_AppVVAppsLogTest_DDD ON AppVVAppsLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_AppVVAppsLogTest_DDD ON AppVVAppsLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_AppVVAppsLogTest_DDD ON AppVVAppsLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_AppVVAppsLogTest_DDD ON AppVVAppsLogTest_DDD ( EVENT_USER );

DROP TABLE AppVOperLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppVOperLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppVOperLogTest_DDD ADD constraint Pk_AppVOperLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_AppVOperLogTest_DDD ON AppVOperLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_AppVOperLogTest_DDD ON AppVOperLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_AppVOperLogTest_DDD ON AppVOperLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_AppVOperLogTest_DDD ON AppVOperLogTest_DDD ( EVENT_USER );

DROP TABLE AppVAdminLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppVAdminLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppVAdminLogTest_DDD ADD constraint Pk_AppVAdminLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_AppVAdminLogTest_DDD ON AppVAdminLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_AppVAdminLogTest_DDD ON AppVAdminLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_AppVAdminLogTest_DDD ON AppVAdminLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_AppVAdminLogTest_DDD ON AppVAdminLogTest_DDD ( EVENT_USER );

DROP TABLE AppVAdmLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppVAdmLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppVAdmLogTest_DDD ADD constraint Pk_AppVAdmLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_AppVAdmLogTest_DDD ON AppVAdmLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_AppVAdmLogTest_DDD ON AppVAdmLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_AppVAdmLogTest_DDD ON AppVAdmLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_AppVAdmLogTest_DDD ON AppVAdmLogTest_DDD ( EVENT_USER );

DROP TABLE AppVOptLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppVOptLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppVOptLogTest_DDD ADD constraint Pk_AppVOptLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_AppVOptLogTest_DDD ON AppVOptLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_AppVOptLogTest_DDD ON AppVOptLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_AppVOptLogTest_DDD ON AppVOptLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_AppVOptLogTest_DDD ON AppVOptLogTest_DDD ( EVENT_USER );

DROP TABLE AppVMgmtLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  AppVMgmtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppVMgmtLogTest_DDD ADD constraint Pk_AppVMgmtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_AppVMgmtLogTest_DDD ON AppVMgmtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_AppVMgmtLogTest_DDD ON AppVMgmtLogTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_AppVMgmtLogTest_DDD ON AppVMgmtLogTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_AppVMgmtLogTest_DDD ON AppVMgmtLogTest_DDD ( EVENT_USER );

DROP TABLE AppVAppsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE AppVAppsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Users		VARCHAR2(512) NOT NULL,
	PID		VARCHAR2(512) NOT NULL,
	Handle_count	VARCHAR2(512) NOT NULL,
	Thread_count	VARCHAR2(2000) NOT NULL,
	Virtual_memory	VARCHAR2(128) NOT NULL,
	Data_IO 	VARCHAR2(128) NOT NULL,
	IO_operations 	VARCHAR2(128) NOT NULL,
	IO_reads	VARCHAR2(128) NOT NULL,
	IO_writes	VARCHAR2(128) NOT NULL,
	Page_faults	VARCHAR2(128) NOT NULL,
	Working_set	VARCHAR2(128) NOT NULL,
	Parent_PID	VARCHAR2(128) NOT NULL,
	Path		VARCHAR2(2000) NOT NULL
);

ALTER TABLE AppVAppsTest_DDD ADD constraint Pk_AppVAppsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AppVAppsTest_DDD ON AppVAppsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXAAudioLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAAudioLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXAAudioLogTest_DDD ADD constraint Pk_CtxXcXAAudioLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_CtxXcXAAudioLogTest_DDD ON CtxXcXAAudioLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_CtxXcXAAudioLogTest_DDD ON CtxXcXAAudioLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_CtxXcXAAudioLogTest_DDD ON CtxXcXAAudioLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_CtxXcXAAudioLogTest_DDD ON CtxXcXAAudioLogTest_DDD ( EVENT_USER );

DROP TABLE CtxXcXAFlashLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAFlashLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXAFlashLogTest_DDD ADD constraint Pk_CtxXcXAFlashLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_CtxXcXAFlashLogTest_DDD ON CtxXcXAFlashLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_CtxXcXAFlashLogTest_DDD ON CtxXcXAFlashLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_CtxXcXAFlashLogTest_DDD ON CtxXcXAFlashLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_CtxXcXAFlashLogTest_DDD ON CtxXcXAFlashLogTest_DDD ( EVENT_USER );

DROP TABLE CtxXcXARaveLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXARaveLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXARaveLogTest_DDD ADD constraint Pk_CtxXcXARaveLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_CtxXcXARaveLogTest_DDD ON CtxXcXARaveLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_CtxXcXARaveLogTest_DDD ON CtxXcXARaveLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_CtxXcXARaveLogTest_DDD ON CtxXcXARaveLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_CtxXcXARaveLogTest_DDD ON CtxXcXARaveLogTest_DDD ( EVENT_USER );

DROP TABLE XDUnRegDesktopTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE XDUnRegDesktopTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_Name 			VARCHAR2(128) NOT NULL,
	DNS_Name			VARCHAR2(128) NOT NULL,
	IP_Address			VARCHAR2(128) NOT NULL,
	OS_Type 			VARCHAR2(128) NOT NULL,
	Power_State			VARCHAR2(128) NOT NULL,
	Summary_State			VARCHAR2(128) NOT NULL,
	Desktop_Group_Name 		VARCHAR2(128) NOT NULL,
	Desktop_Kind			VARCHAR2(128) NOT NULL,
	Hosted_Machine_Name		VARCHAR2(128) NOT NULL,
	Hosted_Server_Name		VARCHAR2(128) NOT NULL,
	Hypervisor_Connection_Name	VARCHAR2(128) NOT NULL,
	Catalog_Name			VARCHAR2(128) NOT NULL,
	Last_Connection_Failed_Reason	VARCHAR2(128) NOT NULL,
	Last_Connection_Time		VARCHAR2(128) NOT NULL,
	Last_Connection_User		VARCHAR2(128) NOT NULL,
	Associated_User			VARCHAR2(128) NOT NULL,
	Pending_Update			VARCHAR2(128) NOT NULL
);

ALTER TABLE  XDUnRegDesktopTest_DDD ADD constraint Pk_XDUnRegDesktopTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XDUnRegDesktopTest_DDD ON XDUnRegDesktopTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RUMAppTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMAppTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMAppTest_DDD ADD constraint Pk_RUMAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMAppTest_DDD ON RUMAppTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMAppTest_DDD ON RUMAppTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMAppTest_DDD ON RUMAppTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMAppTest_DDD ON RUMAppTest_DDD(GUID);



DROP TABLE RUMPageTypeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMPageTypeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMPageTypeTest_DDD ADD constraint Pk_RUMPageTypeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMPageTypeTest_DDD ON RUMPageTypeTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMPageTypeTest_DDD ON RUMPageTypeTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMPageTypeTest_DDD ON RUMPageTypeTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMPageTypeTest_DDD ON RUMPageTypeTest_DDD(GUID);


DROP TABLE RUMBrowserTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMBrowserTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMBrowserTest_DDD ADD constraint Pk_RUMBrowserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMBrowserTest_DDD ON RUMBrowserTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMBrowserTest_DDD ON RUMBrowserTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMBrowserTest_DDD ON RUMBrowserTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMBrowserTest_DDD ON RUMBrowserTest_DDD(GUID);


DROP TABLE RUMDeviceTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMDeviceTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMDeviceTest_DDD ADD constraint Pk_RUMDeviceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMDeviceTest_DDD ON RUMDeviceTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMDeviceTest_DDD ON RUMDeviceTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMDeviceTest_DDD ON RUMDeviceTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMDeviceTest_DDD ON RUMDeviceTest_DDD(GUID);

DROP TABLE RUMGrpTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMGrpTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMGrpTest_DDD ADD constraint Pk_RUMGrpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMGrpTest_DDD ON RUMGrpTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMGrpTest_DDD ON RUMGrpTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMGrpTest_DDD ON RUMGrpTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMGrpTest_DDD ON RUMGrpTest_DDD(GUID);


DROP TABLE RUMLocationTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMLocationTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMLocationTest_DDD ADD constraint Pk_RUMLocationTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMLocationTest_DDD ON RUMLocationTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMLocationTest_DDD ON RUMLocationTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMLocationTest_DDD ON RUMLocationTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMLocationTest_DDD ON RUMLocationTest_DDD(GUID);


DROP TABLE RUMCityTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMCityTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMCityTest_DDD ADD constraint Pk_RUMCityTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMCityTest_DDD ON RUMCityTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMCityTest_DDD ON RUMCityTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMCityTest_DDD ON RUMCityTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMCityTest_DDD ON RUMCityTest_DDD(GUID);


DROP TABLE RUMCountryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMCountryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMCountryTest_DDD ADD constraint Pk_RUMCountryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMCountryTest_DDD ON RUMCountryTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMCountryTest_DDD ON RUMCountryTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMCountryTest_DDD ON RUMCountryTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMCountryTest_DDD ON RUMCountryTest_DDD(GUID);

DROP TABLE RUMRegionTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMRegionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMRegionTest_DDD ADD constraint Pk_RUMRegionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMRegionTest_DDD ON RUMRegionTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMRegionTest_DDD ON RUMRegionTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMRegionTest_DDD ON RUMRegionTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMRegionTest_DDD ON RUMRegionTest_DDD(GUID);

DROP TABLE RUMKeyTransactionTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  RUMKeyTransactionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUID VARCHAR2(128) NOT NULL
);

ALTER TABLE  RUMKeyTransactionTest_DDD ADD constraint Pk_RUMKeyTransactionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX0_RUMKeyTransactionTest_DDD ON RUMKeyTransactionTest_DDD(MSMT_TIME,TRGT_HOST,PORT_NO);
CREATE  INDEX IDX1_RUMKeyTransactionTest_DDD ON RUMKeyTransactionTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_RUMKeyTransactionTest_DDD ON RUMKeyTransactionTest_DDD(MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX3_RUMKeyTransactionTest_DDD ON RUMKeyTransactionTest_DDD(GUID);

DROP TABLE SyntheticTransTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SyntheticTransTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Har_Info	VARCHAR2(2000) NOT NULL,
	Transaction_Url	VARCHAR2(1000) NOT NULL,
	pageId		VARCHAR2(64) NOT NULL,
	Screenshot_Id	VARCHAR2(64) NOT NULL,
	Status_Code	VARCHAR2(16) NOT NULL,
	Status_Message	VARCHAR2(128) NOT NULL,
	Error_Url	VARCHAR2(1000) NOT NULL,
	Request_Method	VARCHAR2(32) NOT NULL,
	Script_Name	VARCHAR2(32) NOT NULL
);

ALTER TABLE  SyntheticTransTest_DDD ADD constraint Pk_SyntheticTransTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SyntheticTransTest_DDD ON SyntheticTransTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ConfluIndexTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ConfluIndexTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	LASTREINDEXINGTASKNAME	VARCHAR2(128) NOT NULL
);
ALTER TABLE  ConfluIndexTest_DDD ADD constraint Pk_ConfluIndexTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ConfluIndexTest_DDD ON ConfluIndexTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CitraTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CitraTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Trans_ID	NUMBER(16) NOT NULL,
	Screenshot_Id	VARCHAR2(64) NOT NULL
);
ALTER TABLE  CitraTest_DDD ADD constraint Pk_CitraTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CitraTest_DDD ON CitraTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013DBRepTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013DBRepTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MAILBOXSERVER   VARCHAR2(128) NOT NULL,
	ACTIVEDBCOPY    VARCHAR2(128) NOT NULL,
	WORKERPROCESSID VARCHAR2(128) NOT NULL,
	DBVOLMOUNTPOINT VARCHAR2(128) NOT NULL	
);

ALTER TABLE  Exc2013DBRepTest_DDD ADD constraint Pk_Exc2013DBRepTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013DBRepTest_DDD ON Exc2013DBRepTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013DCConTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013DCConTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	INSTANCENO      VARCHAR2(128) NOT NULL,
	LDAPREADCAL     VARCHAR2(128) NOT NULL,
	LDAPREADTIM     VARCHAR2(128) NOT NULL,
	LDAPSRCHCAL     VARCHAR2(128) NOT NULL,
	LDAPSRCHTIM     VARCHAR2(128) NOT NULL,
	LDAPTIMERR      VARCHAR2(128) NOT NULL,
	LDAPWRITECALL   VARCHAR2(128) NOT NULL,
	LDAPWRITETIME   VARCHAR2(128) NOT NULL,
	LDAPOPERATIONS  VARCHAR2(128) NOT NULL,
	OUTSTANDREQUEST VARCHAR2(128) NOT NULL
);

ALTER TABLE  Exc2013DCConTest_DDD ADD constraint Pk_Exc2013DCConTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013DCConTest_DDD ON Exc2013DCConTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013EvtLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  Exc2013EvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DATES           DATE NOT NULL,
	SUBJECT         VARCHAR2(2000) NOT NULL,
	MESSAGE         VARCHAR2(2000) NOT NULL	
);

ALTER TABLE  Exc2013EvtLogTest_DDD ADD constraint Pk_Exc2013EvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013EvtLogTest_DDD ON Exc2013EvtLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013MailboxTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013MailboxTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LASTLOGOFFTIME  VARCHAR2(128) NOT NULL,
	LASTLOGONTIME   VARCHAR2(128) NOT NULL
);

ALTER TABLE  Exc2013MailboxTest_DDD ADD constraint Pk_Exc2013MailboxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013MailboxTest_DDD ON Exc2013MailboxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013OWAPerTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013OWAPerTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID             VARCHAR2(128) NOT NULL,
	IMAGENAME       VARCHAR2(128) NOT NULL,
	APPPOOLNAME     VARCHAR2(128) NOT NULL	
);

ALTER TABLE  Exc2013OWAPerTest_DDD ADD constraint Pk_Exc2013OWAPerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013OWAPerTest_DDD ON Exc2013OWAPerTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013QueStaTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013QueStaTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VELOCITY        VARCHAR2(128) NOT NULL,
	DELIVERYTYPE    VARCHAR2(128) NOT NULL,
	NEXTHOPDOMAIN   VARCHAR2(128) NOT NULL,
	IDENTITY_NAME   VARCHAR2(128) NOT NULL
);

ALTER TABLE  Exc2013QueStaTest_DDD ADD constraint Pk_Exc2013QueStaTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013QueStaTest_DDD ON Exc2013QueStaTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013RepHeltTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013RepHeltTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ERROR           VARCHAR2(128) NOT NULL
);

ALTER TABLE  Exc2013RepHeltTest_DDD ADD constraint Pk_Exc2013RepHeltTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013RepHeltTest_DDD ON Exc2013RepHeltTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013SrchMonTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013SrchMonTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ERROR           VARCHAR2(128) NOT NULL
);

ALTER TABLE  Exc2013SrchMonTest_DDD ADD constraint Pk_Exc2013SrchMonTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013SrchMonTest_DDD ON Exc2013SrchMonTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013StoreTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  Exc2013StoreTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DATABASENAME    VARCHAR2(128) NOT NULL,
	DISPLAYNAME     VARCHAR2(128) NOT NULL,
	LASTLOGONTIME   VARCHAR2(128) NOT NULL,
	ITEMCOUNT       VARCHAR2(128) NOT NULL	
);

ALTER TABLE  Exc2013StoreTest_DDD ADD constraint Pk_Exc2013StoreTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013StoreTest_DDD ON Exc2013StoreTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxDSCheckTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxDSCheckTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ERROR_DESCRIPTION VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxDSCheckTest_DDD ADD constraint Pk_CtxDSCheckTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxDSCheckTest_DDD ON CtxDSCheckTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsVpnICATest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsVpnICATest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Domain_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_port		VARCHAR2(128) NOT NULL,
	Cps_ip_address		VARCHAR2(128) NOT NULL,
	Cps_port		VARCHAR2(128) NOT NULL,
	Intranet_ip_address	VARCHAR2(128) NOT NULL,
	Netmask_ip_addresss	VARCHAR2(128) NOT NULL,
	Group_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxNsVpnICATest_DDD ADD constraint Pk_CtxNsVpnICATest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsVpnICATest_DDD ON CtxNsVpnICATest_DDD
(
 	MSMT_TIME
);

DROP TABLE NetlogonFileTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE NetlogonFileTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(2000) NOT NULL
);

ALTER TABLE NetlogonFileTest_DDD ADD constraint Pk_NetlogonFileTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NetlogonFileTest_DDD ON NetlogonFileTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HvGuestTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvGuestTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_STATE	VARCHAR2(128) NOT NULL,
	PROCESS_ID	VARCHAR2(128) NOT NULL,
	OPER_STATUS	VARCHAR2(128) NOT NULL,
	IS_VERSION	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvGuestTest_DDD ADD constraint Pk_HvGuestTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HvGuestTest_DDD ON HvGuestTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HvProcessorTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HvProcessorTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	VM_NAME		VARCHAR2(128) NOT NULL,
	CPU_UTIL	VARCHAR2(32) NOT NULL
);

ALTER TABLE HvProcessorTest_DDD ADD constraint Pk_HvProcessorTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HvProcessorTest_DDD ON HvProcessorTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HvOSMemoryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HvOSMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	VM_NAME		VARCHAR2(128) NOT NULL,
	MEM_USED	VARCHAR2(32) NOT NULL,
	USED_PER	VARCHAR2(32) NOT NULL
);

ALTER TABLE HvOSMemoryTest_DDD ADD constraint Pk_HvOSMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HvOSMemoryTest_DDD ON HvOSMemoryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HvVMMSAdminLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvVMMSAdminLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvVMMSAdminLogTest_DDD ADD constraint Pk_HvVMMSAdminLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_HvVMMSAdminLogTest_DDD ON HvVMMSAdminLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_HvVMMSAdminLogTest_DDD ON HvVMMSAdminLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_HvVMMSAdminLogTest_DDD ON HvVMMSAdminLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_HvVMMSAdminLogTest_DDD ON HvVMMSAdminLogTest_DDD ( EVENT_USER );

DROP TABLE HvVMMSStoreLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvVMMSStoreLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvVMMSStoreLogTest_DDD ADD constraint Pk_HvVMMSStoreLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_HvVMMSStoreLogTest_DDD ON HvVMMSStoreLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_HvVMMSStoreLogTest_DDD ON HvVMMSStoreLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_HvVMMSStoreLogTest_DDD ON HvVMMSStoreLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_HvVMMSStoreLogTest_DDD ON HvVMMSStoreLogTest_DDD ( EVENT_USER );

DROP TABLE HvWorkerAdmLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvWorkerAdmLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvWorkerAdmLogTest_DDD ADD constraint Pk_HvWorkerAdmLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_HvWorkerAdmLogTest_DDD ON HvWorkerAdmLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_HvWorkerAdmLogTest_DDD ON HvWorkerAdmLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_HvWorkerAdmLogTest_DDD ON HvWorkerAdmLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_HvWorkerAdmLogTest_DDD ON HvWorkerAdmLogTest_DDD ( EVENT_USER );

DROP TABLE HvConfigAdmLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvConfigAdmLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvConfigAdmLogTest_DDD ADD constraint Pk_HvConfigAdmLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_HvConfigAdmLogTest_DDD ON HvConfigAdmLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_HvConfigAdmLogTest_DDD ON HvConfigAdmLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_HvConfigAdmLogTest_DDD ON HvConfigAdmLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_HvConfigAdmLogTest_DDD ON HvConfigAdmLogTest_DDD ( EVENT_USER );

DROP TABLE HvHAAdminLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvHAAdminLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvHAAdminLogTest_DDD ADD constraint Pk_HvHAAdminLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_HvHAAdminLogTest_DDD ON HvHAAdminLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_HvHAAdminLogTest_DDD ON HvHAAdminLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_HvHAAdminLogTest_DDD ON HvHAAdminLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_HvHAAdminLogTest_DDD ON HvHAAdminLogTest_DDD ( EVENT_USER );

DROP TABLE HvIntgratAdmLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HvIntgratAdmLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  HvIntgratAdmLogTest_DDD ADD constraint Pk_HvIntgratAdmLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_HvIntgratAdmLogTest_DDD ON HvIntgratAdmLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_HvIntgratAdmLogTest_DDD ON HvIntgratAdmLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_HvIntgratAdmLogTest_DDD ON HvIntgratAdmLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_HvIntgratAdmLogTest_DDD ON HvIntgratAdmLogTest_DDD ( EVENT_USER );

DROP TABLE HvVMSnapshotTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HvVMSnapshotTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	NAME		VARCHAR2(128) NOT NULL,
	SNAPSHOTTYPE	VARCHAR2(128) NOT NULL,
	CREATED_ON	VARCHAR2(128) NOT NULL,
	PATH		VARCHAR2(256) NOT NULL,
	SNAPSHOT_SIZE	VARCHAR2(128) NOT NULL,
	ISDELETED	VARCHAR2(128) NOT NULL,
	ISCLUSTERED	VARCHAR2(128) NOT NULL,
	PARENT		VARCHAR2(128) NOT NULL,
	NOTES		VARCHAR2(128) NOT NULL,
	SNAPSHOT_AGE	VARCHAR2(32) NOT NULL
);

ALTER TABLE HvVMSnapshotTest_DDD ADD constraint Pk_HvVMSnapshotTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HvVMSnapshotTest_DDD ON HvVMSnapshotTest_DDD
(
 	MSMT_TIME
);

DROP TABLE LSUserConTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  LSUserConTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Client_Version	VARCHAR2(128) NOT NULL,
	Agent_Name	VARCHAR2(128) NOT NULL,
	Connections 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  LSUserConTest_DDD ADD constraint Pk_LSUserConTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_LSUserConTest_DDD ON LSUserConTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ApacheNSStatTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  ApacheNSStatTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CHILDSERVER     VARCHAR2(128) NOT NULL,
	PROCESSID       VARCHAR2(128) NOT NULL,
	ACCESSES        VARCHAR2(128) NOT NULL,
	MODES            VARCHAR2(128) NOT NULL,
	CPUUSAGE        VARCHAR2(128) NOT NULL,
	RECENTREQUEST   VARCHAR2(128) NOT NULL,
	NOOFREQUEST     VARCHAR2(128) NOT NULL,
	CONNECTION      VARCHAR2(128) NOT NULL,
	CHILD           VARCHAR2(128) NOT NULL,
	SLOT            VARCHAR2(128) NOT NULL,
	CLIENT          VARCHAR2(128) NOT NULL,
	VHOST           VARCHAR2(128) NOT NULL,
	REQUEST         VARCHAR2(128) NOT NULL
);

ALTER TABLE  ApacheNSStatTest_DDD ADD constraint Pk_ApacheNSStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ApacheNSStatTest_DDD ON ApacheNSStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XchgASyncDeviceTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XchgASyncDeviceTest_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	USERNAME         VARCHAR2(128) NOT NULL,
	DISPLAYNAME      VARCHAR2(128) NOT NULL,
	DEVICETYPE       VARCHAR2(128) NOT NULL,
	DEVICEMODEL      VARCHAR2(128) NOT NULL,
	VERSION          VARCHAR2(128) NOT NULL,
	DEVICEID         VARCHAR2(128) NOT NULL,
	DEVICEPOLAPPLIED VARCHAR2(128) NOT NULL,
	DEVICEAPPSTATUS  VARCHAR2(128) NOT NULL,
	LASTSUCSYNC      VARCHAR2(128) NOT NULL,
	LASTATTSYNC      VARCHAR2(128) NOT NULL,
	LASTUPDATEDTIME  VARCHAR2(128) NOT NULL,
	FIRSTSYNCTIME    VARCHAR2(128) NOT NULL
);

ALTER TABLE  XchgASyncDeviceTest_DDD ADD constraint Pk_XchgASyncDeviceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XchgASyncDeviceTest_DDD ON XchgASyncDeviceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DDomainEventLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DDomainEventLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TIME	VARCHAR2(128) NOT NULL,
	EVENT_STATUS	VARCHAR2(128) NOT NULL,
	EVENT_MESSAGE 	VARCHAR2(256) NOT NULL	
);
ALTER TABLE  DDomainEventLogTest_DDD ADD constraint Pk_DDomainEventLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_DDomainEventLogTest_DDD ON DDomainEventLogTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OVMGuestStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OVMGuestStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  OVMGuestStatusTest_DDD ADD constraint Pk_OVMGuestStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OVMGuestStatusTest_DDD ON OVMGuestStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OVMMemoryTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OVMMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	MEMORY_CONSUMED	VARCHAR2(128) NOT NULL,
	MEMORY_UTILIZED VARCHAR2(128) NOT NULL
);

ALTER TABLE  OVMMemoryTest_DDD ADD constraint Pk_OVMMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OVMMemoryTest_DDD ON OVMMemoryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OVMCpuDetailsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OVMCpuDetailsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	CPU_UTILIZED	VARCHAR2(128) NOT NULL
);

ALTER TABLE  OVMCpuDetailsTest_DDD ADD constraint Pk_OVMCpuDetailsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OVMCpuDetailsTest_DDD ON OVMCpuDetailsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE OVMMgrEventTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OVMMgrEventTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	TIMESTAMP	VARCHAR2(128) NOT NULL,
	MODIFYTIME	VARCHAR2(128) NOT NULL,
	EVT_TYPE	VARCHAR2(128) NOT NULL,
	SUMMARY		VARCHAR2(128) NOT NULL,
	ACKNOWLEDGED	VARCHAR2(128) NOT NULL,
	USER_ACKNOWLEDGE VARCHAR2(128) NOT NULL
);

ALTER TABLE  OVMMgrEventTest_DDD ADD constraint Pk_OVMMgrEventTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OVMMgrEventTest_DDD ON OVMMgrEventTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OVMMgrJobTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OVMMgrJobTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	JOBNAME		VARCHAR2(128) NOT NULL,
	STATUS		VARCHAR2(128) NOT NULL,
	PROGRESS	VARCHAR2(128) NOT NULL,
	STARTTIME	VARCHAR2(128) NOT NULL,
	COMPLETEDTIME	VARCHAR2(128) NOT NULL,
	DURATION	VARCHAR2(128) NOT NULL,
	CREATEDBY	VARCHAR2(128) NOT NULL,
	DESCRIPTION	VARCHAR2(128) NOT NULL
);

ALTER TABLE  OVMMgrJobTest_DDD ADD constraint Pk_OVMMgrJobTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OVMMgrJobTest_DDD ON OVMMgrJobTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OVMPoolTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  OVMPoolTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL,
	HOSTNAME	VARCHAR2(128) NOT NULL,
	HOST_IP		VARCHAR2(128) NOT NULL
);

ALTER TABLE  OVMPoolTest_DDD ADD constraint Pk_OVMPoolTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OVMPoolTest_DDD ON OVMPoolTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HPILOEventTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HPILOEventTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_ID	VARCHAR2(128) NOT NULL,
	EVENT_CLASS	VARCHAR2(128) NOT NULL,
	EVENT_OCCURED_COUNT	VARCHAR2(128) NOT NULL,
	EVENT_MESSAGE 	VARCHAR2(256) NOT NULL	
);
ALTER TABLE  HPILOEventTest_DDD ADD constraint Pk_HPILOEventTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HPILOEventTest_DDD ON HPILOEventTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IBMIMMEventLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IBMIMMEventLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TIME	VARCHAR2(128) NOT NULL,
	EVENT_MESSAGE 	VARCHAR2(256) NOT NULL	
);
ALTER TABLE  IBMIMMEventLogTest_DDD ADD constraint Pk_IBMIMMEventLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IBMIMMEventLogTest_DDD ON IBMIMMEventLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MsSqlCluProcsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE MsSqlCluProcsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(2000) NOT NULL,
	PID		NUMBER(20,4) NOT NULL,
	CPU		NUMBER(20,4) NOT NULL,
	HandleCount	NUMBER(20,4) NOT NULL,
	Data_IO 	NUMBER(20,4) NOT NULL,
	IO_Operations 	NUMBER(20,4) NOT NULL,
	IO_Reads	NUMBER(20,4) NOT NULL,
	IO_Writes	NUMBER(20,4) NOT NULL,
	PageFaults	NUMBER(20,4) NOT NULL,
	ThreadCount	NUMBER(20,4) NOT NULL,
	VirtualMemory	NUMBER(20,4) NOT NULL,
	PrivateMemory	NUMBER(20,4) NOT NULL,
	PoolPaged	NUMBER(20,4) NOT NULL,
	NonPoolPaged	NUMBER(20,4) NOT NULL,
	WorkingSet	NUMBER(20,4) NOT NULL,
	Parent_PID	NUMBER(20,4) NOT NULL
);

ALTER TABLE MsSqlCluProcsTest_DDD ADD constraint Pk_MsSqlCluProcsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MsSqlCluProcsTest_DDD ON MsSqlCluProcsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WinSockEvtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WinSockEvtTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  WinSockEvtTest_DDD ADD constraint Pk_WinSockEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_WinSockEvtTest_DDD ON WinSockEvtTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_WinSockEvtTest_DDD ON WinSockEvtTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_WinSockEvtTest_DDD ON WinSockEvtTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_WinSockEvtTest_DDD ON WinSockEvtTest_DDD ( EVENT_USER );

DROP TABLE VTLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VTLoginTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	LOGIN_TIME 	VARCHAR2(256) NOT NULL,
	DURATION 	VARCHAR2(128) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL);
);

ALTER TABLE  VTLoginTest_DDD ADD constraint Pk_VTLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VTLoginTest_DDD ON VTLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VTAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VTAppTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	CPU_UTIL	NUMBER(20,4) NOT NULL,
	MEMORY_UTIL	NUMBER(20,4) NOT NULL,	
	WEBSITE_TITLE	VARCHAR2(2000) NOT NULL,
	WEBSITE_URL	VARCHAR2(2000) NOT NULL,
	WEBSITE_DOMAIN	VARCHAR2(2000) NOT NULL,
	VIRTUAL_MEMORY	NUMBER(20,4) NOT NULL,
	HANDLE_COUNT	NUMBER(20,4) NOT NULL,
	THREAD_COUNT	NUMBER(20,4) NOT NULL,
	DATA_IO 	NUMBER(20,4) NOT NULL,
	IO_OPERATIONS 	NUMBER(20,4) NOT NULL,
	IO_READS	NUMBER(20,4) NOT NULL,
	IO_WRITES	NUMBER(20,4) NOT NULL,
	PAGE_FAULTS	NUMBER(20,4) NOT NULL,
	MEMORY_USED	NUMBER(20,4) NOT NULL,
	Parent_pid		NUMBER(16) NOT NULL,
	PROCESS_INPUT_DELAY	NUMBER(20,4) NOT NULL,
	Image_path		VARCHAR2(2000) NOT NULL);

ALTER TABLE  VTAppTest_DDD ADD constraint Pk_VTAppTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VTAppTest_DDD ON VTAppTest_DDD
(
 	MSMT_TIME,USERNAME,TRGT_HOST,PORT_NO
);

DROP TABLE VTSessionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VTSessionTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USERNAME VARCHAR2(128) NOT NULL,
	SESSIONNAME VARCHAR2(128) NOT NULL,
	ID NUMBER(16) NOT NULL,
	TERM_STATE VARCHAR2(32) NOT NULL,
	IDLE_TIME VARCHAR2(32) NOT NULL,
	LOGON_TIME VARCHAR2(32) NOT NULL
);

ALTER TABLE  VTSessionTest_DDD ADD constraint Pk_VTSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VTSessionTest_DDD ON VTSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VTUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VTUserTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	ProcName	VARCHAR2(128) NOT NULL,
	Cpu_util	NUMBER(20,4) NOT NULL,
	Memory_util	NUMBER(20,4) NOT NULL,
	IO_reads 	NUMBER(20,4) NOT NULL,
	IO_writes	NUMBER (20,4) NOT NULL,
	Page_faults	NUMBER (20,4) NOT NULL,
	Virtual_memory	NUMBER (20,4) NOT NULL,
	Handles		NUMBER (20,4) NOT NULL,
	CPU_time	NUMBER(20,4) NOT NULL,
	WEBSITE_TITLE	VARCHAR2(2000) NOT NULL,
	WEBSITE_URL	VARCHAR2(2000) NOT NULL,
	WEBSITE_DOMAIN	VARCHAR2(2000) NOT NULL,
	Parent_pid		NUMBER(16) NOT NULL,
	Memory_used		NUMBER(20,4) NOT NULL,
	PROCESS_INPUT_DELAY	NUMBER(20,4) NOT NULL,
	Image_path		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VTUserTest_DDD ADD constraint Pk_VTUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VTUserTest_DDD ON VTUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgUserEnvTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE VmgUserEnvTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	Login_name		VARCHAR2(128) NOT NULL,
	Session_ID		VARCHAR2(128) NOT NULL,
	Profile_load_duration	VARCHAR2(128) NOT NULL,
	Policy_time		VARCHAR2(128) NOT NULL,
	Discovery_time		VARCHAR2(128) NOT NULL,
	CSE_elapsed_time	VARCHAR2(128) NOT NULL,
	Error_code		VARCHAR2(512) NOT NULL,
	CSE_extension_name	VARCHAR2(512) NOT NULL,
	CSE_extension_id	VARCHAR2(512) NOT NULL,
	Profile_time		VARCHAR2(128) NOT NULL,
	Login_time		VARCHAR2(512) NOT NULL,
	Time_duration		VARCHAR2(128) NOT NULL
);

ALTER TABLE  VmgUserEnvTest_DDD ADD constraint Pk_VmgUserEnvTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgUserEnvTest_DDD ON VmgUserEnvTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxAppLaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxAppLaunchTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SESSION_NAME VARCHAR2(128) NOT NULL,
	SESSION_ID VARCHAR2(128) NOT NULL,
	APPLICATION_NAME VARCHAR2(256) NOT NULL,
	USERNAME VARCHAR2(128) NOT NULL,
	CLIENT_NAME VARCHAR2(128) NOT NULL,
	CLIENT_IPADDRESS VARCHAR2(256) NOT NULL,
	CLIENT_VERSION VARCHAR2(128) NOT NULL,
	CLIENT_ID VARCHAR2(128) NOT NULL,
	CLIENT_TYPE VARCHAR2(256) NOT NULL,
	ASSOCIATE_GROUP VARCHAR2(256) NOT NULL,
	LOGON_TIMESTAMP VARCHAR2(256) NOT NULL,
	CONNECT_TIMESTAMP VARCHAR2(256) NOT NULL,
	TIMESTAMP VARCHAR2(256) NOT NULL
);

ALTER TABLE  CtxAppLaunchTest_DDD ADD constraint Pk_CtxAppLaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxAppLaunchTest_DDD ON CtxAppLaunchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ACApplicationTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ACApplicationTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	APPDATETIME	VARCHAR2(128) NOT NULL,
	USERNAME	VARCHAR2(128) NOT NULL, 
	SOURCE		VARCHAR2(128) NOT NULL, 
	CLIENT_RECEIVER VARCHAR2(256) NOT NULL
);


ALTER TABLE  ACApplicationTest_DDD ADD constraint Pk_ACApplicationTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ACApplicationTest_DDD ON ACApplicationTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ACUserSysTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ACUserSysTest_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	LOGIN_TIME		VARCHAR2(128) NOT NULL, 
	SOURCE			VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(256) NOT NULL,
	CLIENT_RECEIVER		VARCHAR2(256) NOT NULL
);

ALTER TABLE ACUserSysTest_DDD ADD constraint Pk_ACUserSysTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ACUserSysTest_DDD ON ACUserSysTest_DDD
(
 	MSMT_TIME
);


DROP TABLE ACLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ACLoginTest_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	LOGIN_TIME		VARCHAR2(128) NOT NULL, 
	LOGOUT_DATE_TIME	VARCHAR2(128) NOT NULL, 
	USERNAME		VARCHAR2(128) NOT NULL, 
	SOURCE			VARCHAR2(128) NOT NULL, 
	CLIENT_RECEIVER		VARCHAR2(256) NOT NULL, 
	DURATION_IN_MIN		VARCHAR2(128) NOT NULL
);


ALTER TABLE  ACLoginTest_DDD ADD constraint Pk_ACLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ACLoginTest_DDD ON ACLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ACOperateTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ACOperateTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	OPRDATETIME	VARCHAR2(128) NOT NULL,
	APPCUSER	VARCHAR2(128) NOT NULL,
	SOURCE		VARCHAR2(128) NOT NULL,
	CLIENT_RECEIVER	VARCHAR2(256) NOT NULL
);

ALTER TABLE  ACOperateTest_DDD ADD constraint Pk_ACOperateTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ACOperateTest_DDD ON ACOperateTest_DDD
(
 	MSMT_TIME
);


DROP TABLE BobiProcLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiProcLogTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32) NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		number(16) NOT NULL,
	Location	varchar2(512) NOT NULL,
	Message_time	 varchar2(64) NOT NULL,
	Trace		 varchar2(32) NOT NULL,
	Server		 varchar2(128) NOT NULL,
	Message		 varchar2(256) NOT NULL,
	Details		 varchar2(512) NOT NULL,	
	Exception	varchar2(32) NOT NULL,
	PID		varchar2(32) NOT NULL,
	Caller_name	varchar2(128) NOT NULL,
	Callee_name	varchar2(128) NOT NULL,
	Importance	varchar2(32) NOT NULL,
	Severity	varchar2(32) NOT NULL
);
ALTER TABLE  BobiProcLogTest_DDD ADD constraint Pk_BobiProcLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiProcLogTest_DDD ON BobiProcLogTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiDbdLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiDbdLogTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32) NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		number(16) NOT NULL,
	Location	varchar2(512) NOT NULL,
	Message_time	 varchar2(64) NOT NULL,
	Trace		 varchar2(32) NOT NULL,
	Server		 varchar2(128) NOT NULL,
	Message		 varchar2(256) NOT NULL,
	Details		 varchar2(512) NOT NULL,	
	Exception	varchar2(32) NOT NULL,
	PID		varchar2(32) NOT NULL,
	Caller_name	varchar2(128) NOT NULL,
	Callee_name	varchar2(128) NOT NULL,
	Importance	varchar2(32) NOT NULL,
	Severity	varchar2(32) NOT NULL
);
ALTER TABLE  BobiDbdLogTest_DDD ADD constraint Pk_BobiDbdLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiDbdLogTest_DDD ON BobiDbdLogTest_DDD
(
	MSMT_TIME
);


DROP TABLE BobiRptLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiRptLogTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32) NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		number(16) NOT NULL,
	Location	varchar2(512) NOT NULL,
	Message_time	 varchar2(64) NOT NULL,
	Trace		 varchar2(32) NOT NULL,
	Server		 varchar2(128) NOT NULL,
	Message		 varchar2(256) NOT NULL,
	Details		 varchar2(512) NOT NULL,	
	Exception	varchar2(32) NOT NULL,
	PID		varchar2(32) NOT NULL,
	Caller_name	varchar2(128) NOT NULL,
	Callee_name	varchar2(128) NOT NULL,
	Importance	varchar2(32) NOT NULL,
	Severity	varchar2(32) NOT NULL
);
ALTER TABLE  BobiRptLogTest_DDD ADD constraint Pk_BobiRptLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiRptLogTest_DDD ON BobiRptLogTest_DDD
(
	MSMT_TIME
);


DROP TABLE BobiCommLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiCommLogTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32) NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		number(16) NOT NULL,
	Location	varchar2(512) NOT NULL,
	Message_time	 varchar2(64) NOT NULL,
	Trace		 varchar2(32) NOT NULL,
	Server		 varchar2(128) NOT NULL,
	Message		 varchar2(256) NOT NULL,
	Details		 varchar2(512) NOT NULL,	
	Exception	varchar2(32) NOT NULL,
	PID		varchar2(32) NOT NULL,
	Caller_name	varchar2(128) NOT NULL,
	Callee_name	varchar2(128) NOT NULL,
	Importance	varchar2(32) NOT NULL,
	Severity	varchar2(32) NOT NULL
);
ALTER TABLE  BobiCommLogTest_DDD ADD constraint Pk_BobiCommLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiCommLogTest_DDD ON BobiCommLogTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiCMSAuditTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiCMSAuditTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Auditing_DB_connection		 VARCHAR2(32) NOT NULL,
	name		 VARCHAR2(32) NOT NULL,
	Auditing_DB_user		 VARCHAR2(32) NOT NULL,
	Auditing_DB_last_update_time		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiCMSAuditTest_DDD ADD constraint Pk_BobiCMSAuditTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiCMSAuditTest_DDD ON BobiCMSAuditTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiCMSStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiCMSStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Resource_Version		 VARCHAR2(32) NOT NULL,
	PID		 VARCHAR2(16) NOT NULL
);
ALTER TABLE  BobiCMSStTest_DDD ADD constraint Pk_BobiCMSStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiCMSStTest_DDD ON BobiCMSStTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiConnSvrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiConnSvrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	healthState		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiConnSvrTest_DDD ADD constraint Pk_BobiConnSvrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiConnSvrTest_DDD ON BobiConnSvrTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiEventSvrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiEventSvrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	healthState		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiEventSvrTest_DDD ADD constraint Pk_BobiEventSvrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiEventSvrTest_DDD ON BobiEventSvrTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiAPSStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiAPSStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		 VARCHAR2(16) NOT NULL,
	JVM_DEBUG_INFO		 VARCHAR2(32) NOT NULL,
	Trace_Flags		 VARCHAR2(32) NOT NULL,
	JVM_Version		 VARCHAR2(256) NOT NULL,
	Hosted_services		 VARCHAR2(1024) NOT NULL
);
ALTER TABLE  BobiAPSStTest_DDD ADD constraint Pk_BobiAPSStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiAPSStTest_DDD ON BobiAPSStTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiWACSvrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiWACSvrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		 VARCHAR2(16) NOT NULL,
	Running_WACS_Connectors		 VARCHAR2(256) NOT NULL
);
ALTER TABLE  BobiWACSvrTest_DDD ADD constraint Pk_BobiWACSvrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiWACSvrTest_DDD ON BobiWACSvrTest_DDD
(
	MSMT_TIME
);


DROP TABLE BobiAJSvrStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiAJSvrStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	healthState		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiAJSvrStTest_DDD ADD constraint Pk_BobiAJSvrStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiAJSvrStTest_DDD ON BobiAJSvrStTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiCRPSStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiCRPSStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		 VARCHAR2(16) NOT NULL,
	OBJ_DII_NM	VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiCRPSStTest_DDD ADD constraint Pk_BobiCRPSStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiCRPSStTest_DDD ON BobiCRPSStTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiWISStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiWISStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	healthState		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiWISStTest_DDD ADD constraint Pk_BobiWISStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiWISStTest_DDD ON BobiWISStTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiDPSvrStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiDPSvrStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		 VARCHAR2(16) NOT NULL,
	OBJ_DII_NM	VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiDPSvrStTest_DDD ADD constraint Pk_BobiDPSvrStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiDPSvrStTest_DDD ON BobiDPSvrStTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiDCSvrStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiDCSvrStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		 VARCHAR2(16) NOT NULL,
	OBJ_DII_NM	VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiDCSvrStTest_DDD ADD constraint Pk_BobiDCSvrStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiDCSvrStTest_DDD ON BobiDCSvrStTest_DDD
(
	MSMT_TIME
);

DROP TABLE BobiRptApSvrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BobiRptApSvrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	healthState		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  BobiRptApSvrTest_DDD ADD constraint Pk_BobiRptApSvrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BobiRptApSvrTest_DDD ON BobiRptApSvrTest_DDD
(
	MSMT_TIME
);

DROP TABLE WDispAvailTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WDispAvailTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	ERROR_MSG	VARCHAR2(128) NOT NULL
	
		
);
ALTER TABLE  WDispAvailTest_DDD ADD constraint Pk_WDispAvailTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WDispAvailTest_DDD ON WDispAvailTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WDispThreadTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WDispThreadTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	THREAD_ID	VARCHAR2(128) NOT NULL,
	REQUEST_TYPE 	VARCHAR2(128) NOT NULL
	
		
);
ALTER TABLE  WDispThreadTest_DDD ADD constraint Pk_WDispThreadTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WDispThreadTest_DDD ON WDispThreadTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WDispSecLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE WDispSecLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	MESSAGES	VARCHAR2(256) NOT NULL
	
		
);
ALTER TABLE  WDispSecLogTest_DDD ADD constraint Pk_WDispSecLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WDispSecLogTest_DDD ON WDispSecLogTest_DDD
(
 	MSMT_TIME
);
DROP TABLE WebDispTraceLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WebDispTraceLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	MESSAGES	VARCHAR2(256) NOT NULL
	
		
);
ALTER TABLE  WebDispTraceLogTest_DDD ADD constraint Pk_WebDispTraceLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WebDispTraceLogTest_DDD ON WebDispTraceLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WDispHttpLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WDispHttpLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	MESSAGES	VARCHAR2(300) NOT NULL
	
		
);
ALTER TABLE  WDispHttpLogTest_DDD ADD constraint Pk_WDispHttpLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WDispHttpLogTest_DDD ON WDispHttpLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WDispCacheTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WDispCacheTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CACHE_NAME	VARCHAR2(256) NOT NULL,
	CACHE_SIZE 	VARCHAR2(128) NOT NULL,
	CREATION_TIME VARCHAR2(128) NOT NULL,
	CACHE_URL VARCHAR2(256) NOT NULL
		
);
ALTER TABLE  WDispCacheTest_DDD ADD constraint Pk_WDispCacheTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WDispCacheTest_DDD ON WDispCacheTest_DDD
(
 	MSMT_TIME
);
DROP TABLE WDispConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WDispConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CON_ID		VARCHAR2(128) NOT NULL,
	ROLE_NAME 	VARCHAR2(128) NOT NULL	,
	REQUEST_TYPE VARCHAR2(128) NOT NULL,
	PEER_ADDRESS VARCHAR2(128) NOT NULL,
	PEER_PORT VARCHAR2(128) NOT NULL,
	LOCAL_ADDRESS VARCHAR2(128) NOT NULL,
	LOCAL_PORT VARCHAR2(128) NOT NULL,
	PROCESS_TIMEOUT VARCHAR2(128) NOT NULL,
	KEEPALIVE_TIMEOUT VARCHAR2(128) NOT NULL,
	CONNECTION_TIME VARCHAR2(128) NOT NULL,
	NIHDL VARCHAR2(128) NOT NULL,
	RUNNING_TIME_IN_MINS VARCHAR2(126) NOT NULL
	

);
ALTER TABLE  WDispConnTest_DDD ADD constraint Pk_WDispConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WDispConnTest_DDD ON WDispConnTest_DDD
(
 	
 	MSMT_TIME
);
DROP TABLE WDispConfigTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE WDispConfigTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	ERROR_MESSAGE	VARCHAR2(256) NOT NULL
	
		
);
ALTER TABLE  WDispConfigTest_DDD ADD constraint Pk_WDispConfigTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WDispConfigTest_DDD ON WDispConfigTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PepPrsStatusTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  PepPrsStatusTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PROCESS_INSTANCE       VARCHAR2(64) NOT NULL,
	PROCESS_TYPE 	VARCHAR2(64) NOT NULL,
	PROCESS_NAME 	VARCHAR2(64) NOT NULL,
	SERVER_NAME  	VARCHAR2(64) NOT NULL,
	USER_NAME  	VARCHAR2(64) NOT NULL,
	RUN_DATE_TIME  	VARCHAR2(64) NOT NULL,
	LAST_UPDATED_TIME  	VARCHAR2(64) NOT NULL
);

ALTER TABLE  PepPrsStatusTest_DDD ADD constraint Pk_PepPrsStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PepPrsStatusTest_DDD ON PepPrsStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VMViewPoolDetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VMViewPoolDetTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	User_name		VARCHAR2(512) NOT NULL,
	Pool_id			VARCHAR2(512) NOT NULL,
	Start_time		VARCHAR2(512) NOT NULL,
	DNS_name		VARCHAR2(512) NOT NULL,
	Duration		VARCHAR2(512) NOT NULL,
	Status			VARCHAR2(512) NOT NULL,
	Protocol		VARCHAR2(512) NOT NULL,
	Session_details		VARCHAR2(1024) NOT NULL,
	Mac_ID			VARCHAR2(512) NOT NULL,
	Ip_details		VARCHAR2(512) NOT NULL,
	Pool_type		VARCHAR2(128) NOT NULL,
	Session_id		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VMViewPoolDetTest_DDD ADD constraint Pk_VMViewPoolDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VMViewPoolDetTest_DDD ON VMViewPoolDetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VMViewFarmsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VMViewFarmsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	User_name		VARCHAR2(512) NOT NULL,
	Pool_id			VARCHAR2(512) NOT NULL,
	Start_time		VARCHAR2(512) NOT NULL,
	DNS_name		VARCHAR2(512) NOT NULL,
	Duration		VARCHAR2(512) NOT NULL,
	Status			VARCHAR2(512) NOT NULL,
	Protocol		VARCHAR2(512) NOT NULL,
	Session_details		VARCHAR2(1024) NOT NULL,
	Mac_ID			VARCHAR2(512) NOT NULL
);

ALTER TABLE  VMViewFarmsTest_DDD ADD constraint Pk_VMViewFarmsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VMViewFarmsTest_DDD ON VMViewFarmsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VMViewRDSHostsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VMViewRDSHostsTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	User_name		VARCHAR2(512) NOT NULL,
	Pool_id			VARCHAR2(512) NOT NULL,
	Start_time		VARCHAR2(512) NOT NULL,
	DNS_name		VARCHAR2(512) NOT NULL,
	Duration		VARCHAR2(512) NOT NULL,
	Status			VARCHAR2(512) NOT NULL,
	Protocol		VARCHAR2(512) NOT NULL,
	Session_details		VARCHAR2(1024) NOT NULL,
	Mac_ID			VARCHAR2(512) NOT NULL
);

ALTER TABLE  VMViewRDSHostsTest_DDD ADD constraint Pk_VMViewRDSHostsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VMViewRDSHostsTest_DDD ON VMViewRDSHostsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PoolsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE PoolsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Local_User_Name	VARCHAR2(256) NOT NULL,
	Pool_name	VARCHAR2(256) NOT NULL,
	Start_time	VARCHAR2(128) NOT NULL,
	DNS_name	VARCHAR2(256) NOT NULL,
	Duration	VARCHAR2(256) NOT NULL,
	Status		VARCHAR2(256) NOT NULL,
	Protocol	VARCHAR2(256) NOT NULL,
	Session_by	VARCHAR2(1024) NOT NULL
);

ALTER TABLE PoolsTest_DDD ADD constraint Pk_PoolsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PoolsTest_DDD ON PoolsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ConBrokerEveTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE ConBrokerEveTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Eventid		VARCHAR2(2000) NOT NULL,
	Time		VARCHAR2(2000) NOT NULL,
	EventType	VARCHAR2(2000) NOT NULL,
	ModuleAndEventText	VARCHAR2(2000) NOT NULL,
	Source		VARCHAR2(2000) NOT NULL,
	Node		VARCHAR2(2000) NOT NULL,
	Usersid		VARCHAR2(2000) NOT NULL,
	Desktopid	VARCHAR2(2000) NOT NULL,
	Machineid	VARCHAR2(2000) NOT NULL,
	Strvalue	VARCHAR2(2000) NOT NULL
);

ALTER TABLE ConBrokerEveTest_DDD ADD constraint Pk_ConBrokerEveTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ConBrokerEveTest_DDD ON ConBrokerEveTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AgentEventsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AgentEventsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Eventid		VARCHAR2(2000) NOT NULL,
	Time		VARCHAR2(2000) NOT NULL,
	EventType	VARCHAR2(2000) NOT NULL,
	ModuleAndEventText	VARCHAR2(2000) NOT NULL,
	Source		VARCHAR2(2000) NOT NULL,
	Node		VARCHAR2(2000) NOT NULL,
	Usersid		VARCHAR2(2000) NOT NULL,
	Desktopid	VARCHAR2(2000) NOT NULL,
	Machineid	VARCHAR2(2000) NOT NULL,
	Strvalue	VARCHAR2(2000) NOT NULL
);

ALTER TABLE AgentEventsTest_DDD ADD constraint Pk_AgentEventsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AgentEventsTest_DDD ON AgentEventsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AdminEventsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AdminEventsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Eventid		VARCHAR2(2000) NOT NULL,
	Time		VARCHAR2(2000) NOT NULL,
	EventType	VARCHAR2(2000) NOT NULL,
	ModuleAndEventText	VARCHAR2(2000) NOT NULL,
	Source		VARCHAR2(2000) NOT NULL,
	Node		VARCHAR2(2000) NOT NULL,
	Usersid		VARCHAR2(2000) NOT NULL,
	Desktopid	VARCHAR2(2000) NOT NULL,
	Machineid	VARCHAR2(2000) NOT NULL,
	Strvalue	VARCHAR2(2000) NOT NULL
);

ALTER TABLE AdminEventsTest_DDD ADD constraint Pk_AdminEventsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AdminEventsTest_DDD ON AdminEventsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TransferEventsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TransferEventsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Eventid		VARCHAR2(2000) NOT NULL,
	Time		VARCHAR2(2000) NOT NULL,
	EventType	VARCHAR2(2000) NOT NULL,
	ModuleAndEventText	VARCHAR2(2000) NOT NULL,
	Source		VARCHAR2(2000) NOT NULL,
	Node		VARCHAR2(2000) NOT NULL,
	Usersid		VARCHAR2(2000) NOT NULL,
	Desktopid	VARCHAR2(2000) NOT NULL,
	Machineid	VARCHAR2(2000) NOT NULL,
	Strvalue	VARCHAR2(2000) NOT NULL
);

ALTER TABLE TransferEventsTest_DDD ADD constraint Pk_TransferEventsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TransferEventsTest_DDD ON TransferEventsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CyberFwLicenseTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CyberFwLicenseTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LIC_EXPIRY_DATE		VARCHAR2(128) NOT NULL	
);
ALTER TABLE  CyberFwLicenseTest_DDD ADD constraint Pk_CyberFwLicenseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CyberFwLicenseTest_DDD ON CyberFwLicenseTest_DDD
(
 	MSMT_TIME
);


DROP TABLE CyberAVAlertTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CyberAVAlertTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,	
	TRAP_TIME	VARCHAR2(128) NOT NULL,	
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,	
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL	
);
ALTER TABLE  CyberAVAlertTest_DDD ADD constraint Pk_CyberAVAlertTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CyberAVAlertTest_DDD ON CyberAVAlertTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsIcaDevTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsIcaDevTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Ip_address	VARCHAR2(128) NOT NULL,
	Total_session_launches	NUMBER(20,4) NOT NULL,
	Total_applications	NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxNsIsIcaDevTest_DDD ADD constraint Pk_CtxNsIsIcaDevTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsIcaDevTest_DDD ON CtxNsIsIcaDevTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsHdxVdiTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsHdxVdiTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxNsIsHdxVdiTest_DDD ADD constraint Pk_CtxNsIsHdxVdiTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsHdxVdiTest_DDD ON CtxNsIsHdxVdiTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsHdxVdiUTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsHdxVdiUTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VDI_name	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxNsIsHdxVdiUTest_DDD ADD constraint Pk_CtxNsIsHdxVdiUTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsHdxVdiUTest_DDD ON CtxNsIsHdxVdiUTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsHdxVdiUATest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsHdxVdiUATest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name		VARCHAR2(256) NOT NULL,
	Vdi_image_name		VARCHAR2(256) NOT NULL,
	Id			VARCHAR2(256) NOT NULL,
	Start_time		VARCHAR2(256) NOT NULL,
	Session_duration	VARCHAR2(256) NOT NULL,
	Client_ip_address	VARCHAR2(256) NOT NULL,
	Server_ip_address	VARCHAR2(256) NOT NULL,
	NetScaler_ip_address	VARCHAR2(256) NOT NULL,
	Client_type		VARCHAR2(256) NOT NULL,
	Client_version		VARCHAR2(256) NOT NULL,
	Client_side_cb		VARCHAR2(256) NOT NULL,
	Server_side_cb		VARCHAR2(256) NOT NULL,
	Session_state		VARCHAR2(256) NOT NULL,
	Session_euem		NUMBER(20,4) NOT NULL,
	Msi			VARCHAR2(256) NOT NULL,
	Session_reconnects	NUMBER(20,4) NOT NULL,
	Acr_counts		NUMBER(20,4) NOT NULL,
	User_account_type	VARCHAR2(256) NOT NULL,
	Country			VARCHAR2(256) NOT NULL,
	Region			VARCHAR2(256) NOT NULL,
	City			VARCHAR2(256) NOT NULL,
	Latitude		NUMBER(20,4) NOT NULL,
	Longitude		NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxNsIsHdxVdiUATest_DDD ADD constraint Pk_CtxNsIsHdxVdiUATest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsHdxVdiUATest_DDD ON CtxNsIsHdxVdiUATest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsIcaAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsIcaAppTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	App_name	VARCHAR2(128) NOT NULL,
	App_launch_count NUMBER(20,4) NOT NULL,
	Session_launch_count NUMBER(20,4) NOT NULL,
	Session_duration NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxNsIsIcaAppTest_DDD ADD constraint Pk_CtxNsIsIcaAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsIcaAppTest_DDD ON CtxNsIsIcaAppTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsIcaUserATest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsIcaUserATest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name		VARCHAR2(256) NOT NULL,
	Id			VARCHAR2(256) NOT NULL,
	Start_time		VARCHAR2(256) NOT NULL,
	Session_duration	VARCHAR2(256) NOT NULL,
	Client_side_cb		VARCHAR2(256) NOT NULL,
	Server_side_cb		VARCHAR2(256) NOT NULL,
	Client_ip_address	VARCHAR2(256) NOT NULL,
	Server_ip_address	VARCHAR2(256) NOT NULL,
	NetScaler_ip_address	VARCHAR2(256) NOT NULL,
	Client_type		VARCHAR2(256) NOT NULL,
	Client_version		VARCHAR2(256) NOT NULL,
	Session_state		VARCHAR2(256) NOT NULL,
	Session_euem		NUMBER(20,4) NOT NULL,
	Msi			VARCHAR2(256) NOT NULL,
	Session_reconnects	NUMBER(20,4) NOT NULL,
	Acr_counts		NUMBER(20,4) NOT NULL,
	User_account_type	VARCHAR2(256) NOT NULL,
	Country			VARCHAR2(256) NOT NULL,
	Region			VARCHAR2(256) NOT NULL,
	City			VARCHAR2(256) NOT NULL,
	Latitude		NUMBER(20,4) NOT NULL,
	Longitude		NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxNsIsIcaUserATest_DDD ADD constraint Pk_CtxNsIsIcaUserATest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsIcaUserATest_DDD ON CtxNsIsIcaUserATest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsIcaLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsIcaLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name		VARCHAR2(256) NOT NULL,
	Id			VARCHAR2(256) NOT NULL,
	Start_time		VARCHAR2(256) NOT NULL,
	Session_duration	VARCHAR2(256) NOT NULL,
	WAN_latency		VARCHAR2(256) NOT NULL,
	DC_latency		VARCHAR2(256) NOT NULL,
	RTT			VARCHAR2(256) NOT NULL,
	Bandwidth		VARCHAR2(256) NOT NULL,
	Client_ip_address	VARCHAR2(256) NOT NULL,
	Server_ip_address	VARCHAR2(256) NOT NULL,
	NetScaler_ip_address	VARCHAR2(256) NOT NULL,
	Client_type		VARCHAR2(256) NOT NULL,
	Client_version		VARCHAR2(256) NOT NULL,
	Total_bytes		VARCHAR2(256) NOT NULL
);

ALTER TABLE  CtxNsIsIcaLoginTest_DDD ADD constraint Pk_CtxNsIsIcaLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsIcaLoginTest_DDD ON CtxNsIsIcaLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsHdxLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsHdxLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name		VARCHAR2(256) NOT NULL,
	Id			VARCHAR2(256) NOT NULL,
	Start_time		VARCHAR2(256) NOT NULL,
	Session_duration	VARCHAR2(256) NOT NULL,
	WAN_latency		VARCHAR2(256) NOT NULL,
	DC_latency		VARCHAR2(256) NOT NULL,
	RTT			VARCHAR2(256) NOT NULL,
	Bandwidth		VARCHAR2(256) NOT NULL,
	Client_ip_address	VARCHAR2(256) NOT NULL,
	Server_ip_address	VARCHAR2(256) NOT NULL,
	NetScaler_ip_address	VARCHAR2(256) NOT NULL,
	Total_bytes		VARCHAR2(256) NOT NULL
);

ALTER TABLE  CtxNsIsHdxLoginTest_DDD ADD constraint Pk_CtxNsIsHdxLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsHdxLoginTest_DDD ON CtxNsIsHdxLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsIcaUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsIcaUserTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Application_name VARCHAR2(2000) NOT NULL,
	User_name		VARCHAR2(256) NOT NULL,
	Vdi_image_name		VARCHAR2(256) NOT NULL,
	Id			VARCHAR2(256) NOT NULL,
	Start_time		VARCHAR2(256) NOT NULL,
	Session_duration	VARCHAR2(256) NOT NULL,
	Client_ip_address	VARCHAR2(256) NOT NULL,
	Server_ip_address	VARCHAR2(256) NOT NULL,
	NetScaler_ip_address	VARCHAR2(256) NOT NULL,
	Client_type		VARCHAR2(256) NOT NULL,
	Client_version		VARCHAR2(256) NOT NULL,
	Client_side_cb		VARCHAR2(256) NOT NULL,
	Server_side_cb		VARCHAR2(256) NOT NULL,
	Session_state		VARCHAR2(256) NOT NULL,
	Session_euem		NUMBER(20,4) NOT NULL,
	Msi			VARCHAR2(256) NOT NULL,
	Session_reconnects	NUMBER(20,4) NOT NULL,
	Acr_counts		NUMBER(20,4) NOT NULL,
	User_account_type	VARCHAR2(256) NOT NULL,
	Country			VARCHAR2(256) NOT NULL,
	Region			VARCHAR2(256) NOT NULL,
	City			VARCHAR2(256) NOT NULL,
	Latitude		NUMBER(20,4) NOT NULL,
	Longitude		NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxNsIsIcaUserTest_DDD ADD constraint Pk_CtxNsIsIcaUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsIcaUserTest_DDD ON CtxNsIsIcaUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebSrvTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebSrvTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Server_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebSrvTest_DDD ADD constraint Pk_CtxNsIsWebSrvTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebSrvTest_DDD ON CtxNsIsWebSrvTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebCtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebCtTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Client_ip_address	VARCHAR2(512) NOT NULL,
	Server_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebCtTest_DDD ADD constraint Pk_CtxNsIsWebCtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebCtTest_DDD ON CtxNsIsWebCtTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebUrlTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebUrlTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Url_name		VARCHAR2(2000) NOT NULL,
	Server_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebUrlTest_DDD ADD constraint Pk_CtxNsIsWebUrlTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebUrlTest_DDD ON CtxNsIsWebUrlTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebAppTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Application_name	VARCHAR2(2000) NOT NULL,
	Server_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebAppTest_DDD ADD constraint Pk_CtxNsIsWebAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebAppTest_DDD ON CtxNsIsWebAppTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebDevTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebDevTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebDevTest_DDD ADD constraint Pk_CtxNsIsWebDevTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebDevTest_DDD ON CtxNsIsWebDevTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebHReqTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebHReqTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Method_name		VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebHReqTest_DDD ADD constraint Pk_CtxNsIsWebHReqTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebHReqTest_DDD ON CtxNsIsWebHReqTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebHResTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebHResTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Response_status		VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebHResTest_DDD ADD constraint Pk_CtxNsIsWebHResTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebHResTest_DDD ON CtxNsIsWebHResTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebOSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebOSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Client_os_name		VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebOSTest_DDD ADD constraint Pk_CtxNsIsWebOSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebOSTest_DDD ON CtxNsIsWebOSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebUATest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebUATest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_agent_name		VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebUATest_DDD ADD constraint Pk_CtxNsIsWebUATest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebUATest_DDD ON CtxNsIsWebUATest_DDD
(
 	MSMT_TIME
);

DROP TABLE LHStrRaidCtrlTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  LHStrRaidCtrlTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DISK_NAME	VARCHAR2(128) NOT NULL,
	LUN_NAME 	VARCHAR2(256) NOT NULL	
);
ALTER TABLE  LHStrRaidCtrlTest_DDD ADD constraint Pk_LHStrRaidCtrlTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_LHStrRaidCtrlTest_DDD ON LHStrRaidCtrlTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Off365ClntConTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  Off365ClntConTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USER_NAME VARCHAR2(128) NOT NULL,
	WINDOWS_LIVEID VARCHAR2(128) NOT NULL
	
);

ALTER TABLE  Off365ClntConTest_DDD ADD constraint Pk_Off365ClntConTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Off365ClntConTest_DDD ON Off365ClntConTest_DDD
(
 	MSMT_TIME
);


DROP TABLE Off365MBoxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  Off365MBoxTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Windows_liveID	VARCHAR2(128) NOT NULL,
	Last_login	VARCHAR2(128) NOT NULL,
	Days_inactive	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  Off365MBoxTest_DDD ADD constraint Pk_Off365MBoxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Off365MBoxTest_DDD ON Off365MBoxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SfUserSessTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SfUserSessTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_Name	VARCHAR2(256) NOT NULL,
	Session_Type  	VARCHAR2(256) NOT NULL,
	User_Type 	VARCHAR2(256) NOT NULL,
	Login_Type 	VARCHAR2(256) NOT NULL,
	Created 	VARCHAR2(256) NOT NULL,
	Updated 	VARCHAR2(256) NOT NULL,
	Valid_Until 	VARCHAR2(256) NOT NULL,
	Source_IP 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  SfUserSessTest_DDD ADD constraint Pk_SfUserSessTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SfUserSessTest_DDD ON SfUserSessTest_DDD (MSMT_TIME);

DROP TABLE SfUserTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SfUserTest_DDD
(
	SITE_NAME	  	VARCHAR2(64) NOT NULL,
	TRGT_HOST	   	VARCHAR2(32) NOT NULL,
	PORT_NO		      	VARCHAR2(32) NOT NULL,
	TEST_NAME	    	VARCHAR2(64) NOT NULL,
	MEASURE		      	VARCHAR2(64) NOT NULL,
	INFO	         	VARCHAR2(128) NOT NULL,
	STATE	        	VARCHAR2(32) NOT NULL,
	MSMT_HOST	    	VARCHAR2(32) NOT NULL,
	MSMT_TIME	    	DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Email			VARCHAR2(256) NOT NULL,
	Employee_Number  	VARCHAR2(256) NOT NULL,
	Last_Name	 	VARCHAR2(256) NOT NULL,
	First_Name	 	VARCHAR2(256) NOT NULL,
	Company_Name	 	VARCHAR2(256) NOT NULL,
	Last_Login_Date 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  SfUserTest_DDD ADD constraint Pk_SfUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SfUserTest_DDD ON SfUserTest_DDD (MSMT_TIME);


DROP TABLE SfUserLoginTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SfUserLoginTest_DDD
(
	SITE_NAME	  	VARCHAR2(64) NOT NULL,
	TRGT_HOST	    	VARCHAR2(32) NOT NULL,
	PORT_NO		      	VARCHAR2(32) NOT NULL,
	TEST_NAME	    	VARCHAR2(64) NOT NULL,
	MEASURE		      	VARCHAR2(64) NOT NULL,
	INFO	        	VARCHAR2(128) NOT NULL,
	STATE	        	VARCHAR2(32) NOT NULL,
	MSMT_HOST	    	VARCHAR2(32) NOT NULL,
	MSMT_TIME	    	DATE NOT NULL,
	SEQ_NO	 		NUMBER(16) NOT NULL,
	User_Name		VARCHAR2(256) NOT NULL,
	Source_IP		VARCHAR2(256) NOT NULL,
	Login_Type 		VARCHAR2(256) NOT NULL,
	Login_Time		VARCHAR2(256) NOT NULL,
	Status			VARCHAR2(256) NOT NULL,
	Browser 		VARCHAR2(256) NOT NULL,
	Platform		VARCHAR2(256) NOT NULL,
	Application		VARCHAR2(256) NOT NULL,
	Client_Version		VARCHAR2(256) NOT NULL,
	API_Type 		VARCHAR2(256) NOT NULL,
	API_Version 		VARCHAR2(256) NOT NULL,
	Login_URL 		VARCHAR2(256) NOT NULL,
	First_Name		VARCHAR2(256) NOT NULL,
	Last_Name		VARCHAR2(256) NOT NULL,
	Email			VARCHAR2(256) NOT NULL,
	Country 		VARCHAR2(256) NOT NULL,
	User_Type 		VARCHAR2(256) NOT NULL,
	Session_Type 		VARCHAR2(256) NOT NULL,
	Created			VARCHAR2(256) NOT NULL,
	Updated			VARCHAR2(256) NOT NULL,
	Valid_Until		VARCHAR2(256) NOT NULL
);

ALTER TABLE  SfUserLoginTest_DDD ADD constraint Pk_SfUserLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SfUserLoginTest_DDD ON SfUserLoginTest_DDD (MSMT_TIME);

DROP TABLE TOPSOURCETEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TOPSOURCETEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SOURCE_HOST	VARCHAR2(128) NOT NULL,
	SOURCE_PORT	VARCHAR2(128) NOT NULL,
	DESTINATION_HOST	VARCHAR2(128) NOT NULL,
	DESTINATION_PORT	VARCHAR2(128) NOT NULL,
	DATA_RECEIVED	        NUMBER(20,4) NOT NULL,
	DATA_SENT	        NUMBER(20,4) NOT NULL,
	PACKETS_RECEIVED 	NUMBER(20,4) NOT NULL,
	PACKETS_SENT		NUMBER(20,4) NOT NULL
);

ALTER TABLE  TOPSOURCETEST_DDD ADD CONSTRAINT PK_TOPSOURCETEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TOPSOURCETEST_DDD ON TOPSOURCETEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_TOPSOURCETEST_DDD ON TOPSOURCETEST_DDD(MSMT_TIME);

DROP TABLE TOPDESTTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TOPDESTTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SOURCE_HOST	VARCHAR2(128) NOT NULL,
	SOURCE_PORT	VARCHAR2(128) NOT NULL,
	DESTINATION_HOST	VARCHAR2(128) NOT NULL,
	DESTINATION_PORT	VARCHAR2(128) NOT NULL,
	DATA_RECEIVED	        NUMBER(20,4) NOT NULL,
	DATA_SENT	        NUMBER(20,4) NOT NULL,
	PACKETS_RECEIVED 	NUMBER(20,4) NOT NULL,
	PACKETS_SENT		NUMBER(20,4) NOT NULL
);

ALTER TABLE  TOPDESTTEST_DDD ADD CONSTRAINT PK_TOPDESTTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TOPDESTTEST_DDD ON TOPDESTTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_TOPDESTTEST_DDD ON TOPDESTTEST_DDD(MSMT_TIME);

DROP TABLE TOPCONVERTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TOPCONVERTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SOURCE_HOST	VARCHAR2(128) NOT NULL,
	SOURCE_PORT	VARCHAR2(128) NOT NULL,
	DESTINATION_HOST	VARCHAR2(128) NOT NULL,
	DESTINATION_PORT	VARCHAR2(128) NOT NULL,
	DATA_RECEIVED	        NUMBER(20,4) NOT NULL,
	DATA_SENT	        NUMBER(20,4) NOT NULL,
	PACKETS_RECEIVED 	NUMBER(20,4) NOT NULL,
	PACKETS_SENT		NUMBER(20,4) NOT NULL
);

ALTER TABLE  TOPCONVERTEST_DDD ADD CONSTRAINT PK_TOPCONVERTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TOPCONVERTEST_DDD ON TOPCONVERTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_TOPCONVERTEST_DDD ON TOPCONVERTEST_DDD(MSMT_TIME);

DROP TABLE TOPAPPLICATIONTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TOPAPPLICATIONTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SOURCE_HOST	VARCHAR2(128) NOT NULL,
	DESTINATION_HOST	VARCHAR2(128) NOT NULL,
	DATA_RECEIVED	        NUMBER(20,4) NOT NULL,
	DATA_SENT	        NUMBER(20,4) NOT NULL,
	PACKETS_RECEIVED 	NUMBER(20,4) NOT NULL,
	PACKETS_SENT		NUMBER(20,4) NOT NULL
);

ALTER TABLE  TOPAPPLICATIONTEST_DDD ADD CONSTRAINT PK_TOPAPPLICATIONTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TOPAPPLICATIONTEST_DDD ON TOPAPPLICATIONTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_TOPAPPLICATIONTEST_DDD ON TOPAPPLICATIONTEST_DDD(MSMT_TIME);


DROP TABLE TOPSITESTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TOPSITESTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SOURCE_HOST	VARCHAR2(128) NOT NULL,
	SOURCE_PORT	VARCHAR2(128) NOT NULL,
	DESTINATION_HOST	VARCHAR2(128) NOT NULL,
	DESTINATION_PORT	VARCHAR2(128) NOT NULL,
	DATA_RECEIVED	        NUMBER(20,4) NOT NULL,
	DATA_SENT	        NUMBER(20,4) NOT NULL
);

ALTER TABLE  TOPSITESTEST_DDD ADD CONSTRAINT PK_TOPSITESTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TOPSITESTEST_DDD ON TOPSITESTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_TOPSITESTEST_DDD ON TOPSITESTEST_DDD(MSMT_TIME);

DROP TABLE SPECIFICSRCTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SPECIFICSRCTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SOURCE_HOST	VARCHAR2(128) NOT NULL,
	SOURCE_PORT	VARCHAR2(128) NOT NULL,
	DESTINATION_HOST	VARCHAR2(128) NOT NULL,
	DESTINATION_PORT	VARCHAR2(128) NOT NULL,
	DATA_RECEIVED	        NUMBER(20,4) NOT NULL,
	DATA_SENT	        NUMBER(20,4) NOT NULL,
	PACKETS_RECEIVED 	NUMBER(20,4) NOT NULL,
	PACKETS_SENT		NUMBER(20,4) NOT NULL
);

ALTER TABLE  SPECIFICSRCTEST_DDD ADD CONSTRAINT PK_SPECIFICSRCTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SPECIFICSRCTEST_DDD ON SPECIFICSRCTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_SPECIFICSRCTEST_DDD ON SPECIFICSRCTEST_DDD(MSMT_TIME);

DROP TABLE SPECIFICDESTTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SPECIFICDESTTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SOURCE_HOST	VARCHAR2(128) NOT NULL,
	SOURCE_PORT	VARCHAR2(128) NOT NULL,
	DESTINATION_HOST	VARCHAR2(128) NOT NULL,
	DESTINATION_PORT	VARCHAR2(128) NOT NULL,
	DATA_RECEIVED	        NUMBER(20,4) NOT NULL,
	DATA_SENT	        NUMBER(20,4) NOT NULL,
	PACKETS_RECEIVED 	NUMBER(20,4) NOT NULL,
	PACKETS_SENT		NUMBER(20,4) NOT NULL
);

ALTER TABLE  SPECIFICDESTTEST_DDD ADD CONSTRAINT PK_SPECIFICDESTTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SPECIFICDESTTEST_DDD ON SPECIFICDESTTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_SPECIFICDESTTEST_DDD ON SPECIFICDESTTEST_DDD(MSMT_TIME);

DROP TABLE LyncSynMonTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE LyncSynMonTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ERROR		VARCHAR2(512) NOT NULL
);

ALTER TABLE  LyncSynMonTest_DDD ADD constraint Pk_LyncSynMonTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_LyncSynMonTest_DDD ON LyncSynMonTest_DDD
(
 	MSMT_TIME
);


DROP TABLE WinNewProcTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE WinNewProcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(2000) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	HandleCount	NUMBER(16) NOT NULL,
	ThreadCount	NUMBER(16) NOT NULL,
	VirtualMemory	NUMBER(20,4) NOT NULL,
	Data_IO 	NUMBER(20,4) NOT NULL,
	IO_Operations 	NUMBER(20,4) NOT NULL,
	IO_Reads	NUMBER(20,4) NOT NULL,
	IO_Writes	 NUMBER(20,4) NOT NULL,
	PageFaults	 NUMBER(20,4) NOT NULL,
	WorkingSet	 NUMBER(20,4) NOT NULL,
	Parent_PID	 NUMBER(16) NOT NULL,
	Users		VARCHAR2(2000) NOT NULL,
	Uptime		NUMBER(16) NOT NULL,
	Session_id	NUMBER(16) NOT NULL
);

ALTER TABLE WinNewProcTest_DDD ADD constraint Pk_WinNewProcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_WinNewProcTest_DDD ON WinNewProcTest_DDD
(
 	MSMT_TIME
);


DROP TABLE WinNewSvcTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE WinNewSvcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(2000) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	HandleCount	NUMBER(16) NOT NULL,
	ThreadCount	NUMBER(16) NOT NULL,
	VirtualMemory	NUMBER(20,4) NOT NULL,
	Data_IO 	NUMBER(20,4) NOT NULL,
	IO_Operations 	NUMBER(20,4) NOT NULL,
	IO_Reads	NUMBER(20,4) NOT NULL,
	IO_Writes	 NUMBER(20,4) NOT NULL,
	PageFaults	 NUMBER(20,4) NOT NULL,
	WorkingSet	 NUMBER(20,4) NOT NULL,
	Parent_PID	 NUMBER(16) NOT NULL,
	Users		VARCHAR2(2000) NOT NULL,
	Uptime		NUMBER(16) NOT NULL,
	Session_id	NUMBER(16) NOT NULL
);

ALTER TABLE WinNewSvcTest_DDD ADD constraint Pk_WinNewSvcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_WinNewSvcTest_DDD ON WinNewSvcTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXAEuemTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAEuemTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id	VARCHAR2(128) NOT NULL,
	Session_name	VARCHAR2(128) NOT NULL,
	Username	VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(2000) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Launch_type		VARCHAR2(128) NOT NULL,
	C_session_lookup	VARCHAR2(128) NOT NULL,
	C_session_creation	VARCHAR2(128) NOT NULL,
	S_session_creation_start VARCHAR2(128) NOT NULL,
	S_session_creation_end	VARCHAR2(128) NOT NULL,
	Session_key		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXAEuemTest_DDD ADD constraint Pk_CtxXcXAEuemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXAEuemTest_DDD ON CtxXcXAEuemTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HTTPErrorLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HTTPErrorLogTest_DDD
(
	SITE_NAME  	  VARCHAR2(64) NOT NULL,
	TRGT_HOST    	  VARCHAR2(32) NOT NULL,
	PORT_NO      	  VARCHAR2(32) NOT NULL,
	TEST_NAME    	  VARCHAR2(64) NOT NULL,
	MEASURE      	  VARCHAR2(64) NOT NULL,
	INFO         	  VARCHAR2(128) NOT NULL,
	STATE        	  VARCHAR2(32) NOT NULL,
	MSMT_HOST    	  VARCHAR2(32) NOT NULL,
	MSMT_TIME    	  DATE NOT NULL,
	SEQ_NO 		  NUMBER(16) NOT NULL,
	DATES              VARCHAR2(128) NOT NULL,
	TIMES              VARCHAR2(128) NOT NULL,
	CLIENT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	CLIENT_PORT       VARCHAR2(128) NOT NULL,
	SERVER_IP_ADDRESS VARCHAR2(128) NOT NULL,
	SERVER_PORT       VARCHAR2(128) NOT NULL,
	PROTOCOL_VERSION  VARCHAR2(128) NOT NULL,
	VERB              VARCHAR2(128) NOT NULL,
	URL               VARCHAR2(2000) NOT NULL,
	STATUS_CODE       VARCHAR2(128) NOT NULL,
	SITE_ID           VARCHAR2(128) NOT NULL,
	REASON            VARCHAR2(128) NOT NULL,
	QUEUE_NAME        VARCHAR2(128) NOT NULL
);

ALTER TABLE  HTTPErrorLogTest_DDD ADD constraint Pk_HTTPErrorLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HTTPErrorLogTest_DDD ON HTTPErrorLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE Exc2013MailDBTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  Exc2013MailDBTest_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	EDPFILEPATH      VARCHAR2(128) NOT NULL,
	MOUNTTEDONSERVER VARCHAR2(128) NOT NULL,
	WORKERPROCESSID  VARCHAR2(128) NOT NULL,
	RPCCLIACCSERVER  VARCHAR2(128) NOT NULL,
	MAILBOXNAME      VARCHAR2(128) NOT NULL,
	EMAILID		 VARCHAR2(128) NOT NULL,
	ASYNCENABLED     VARCHAR2(128) NOT NULL,
	OWAENABLED       VARCHAR2(128) NOT NULL,
	OMAENABLED       VARCHAR2(128) NOT NULL,
	POPENABLED       VARCHAR2(128) NOT NULL,
	IMAPENABLED      VARCHAR2(128) NOT NULL,
	MAPIENABLED      VARCHAR2(128) NOT NULL
);

ALTER TABLE  Exc2013MailDBTest_DDD ADD constraint Pk_Exc2013MailDBTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_Exc2013MailDBTest_DDD ON Exc2013MailDBTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NimFanTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NimFanTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NimFanTrapTest_DDD ADD constraint Pk_NimFanTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NimFanTrapTest_DDD ON NimFanTrapTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NimPSupplyTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NimPSupplyTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NimPSupplyTrapTest_DDD ADD constraint Pk_NimPSupplyTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NimPSupplyTrapTest_DDD ON NimPSupplyTrapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NimTempTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NimTempTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NimTempTrapTest_DDD ADD constraint Pk_NimTempTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NimTempTrapTest_DDD ON NimTempTrapTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NimDiskTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NimDiskTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NimDiskTrapTest_DDD ADD constraint Pk_NimDiskTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NimDiskTrapTest_DDD ON NimDiskTrapTest_DDD
(
 	MSMT_TIME
);



DROP TABLE NimCntrlTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NimCntrlTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NimCntrlTrapTest_DDD ADD constraint Pk_NimCntrlTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NimCntrlTrapTest_DDD ON NimCntrlTrapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AppLaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AppLaunchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Username	VARCHAR2(256) NOT NULL,
	Session_name	VARCHAR2(256) NOT NULL,
	Session_id	VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Application_name VARCHAR2(2000) NOT NULL,
	Launch_duration  NUMBER(20,4) NOT NULL,
	Client_name	VARCHAR2(128) NOT NULL,
	Client_version	VARCHAR2(128) NOT NULL,
	Client_ip_address VARCHAR2(128) NOT NULL,
	Client_id	VARCHAR2(128) NOT NULL,
	Client_type	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppLaunchTest_DDD ADD constraint Pk_AppLaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AppLaunchTest_DDD ON AppLaunchTest_DDD
(
 	MSMT_TIME
);
CREATE INDEX IDX1_APPLAUNCHTEST_DDD ON APPLAUNCHTEST_DDD (TRGT_HOST, MSMT_TIME);

DROP TABLE TermAppLaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TermAppLaunchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Username	VARCHAR2(256) NOT NULL,
	Session_name	VARCHAR2(256) NOT NULL,
	Session_id	VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Application_name VARCHAR2(2000) NOT NULL,
	Launch_duration  NUMBER(20,4) NOT NULL
);

ALTER TABLE  TermAppLaunchTest_DDD ADD constraint Pk_TermAppLaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TermAppLaunchTest_DDD ON TermAppLaunchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXAApLaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAApLaunchTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SESSION_NAME VARCHAR2(128) NOT NULL,
	SESSION_ID VARCHAR2(128) NOT NULL,
	APPLICATION_NAME VARCHAR2(256) NOT NULL,
	USERNAME VARCHAR2(128) NOT NULL,
	CLIENT_NAME VARCHAR2(128) NOT NULL,
	CLIENT_IPADDRESS VARCHAR2(256) NOT NULL,
	CLIENT_VERSION VARCHAR2(128) NOT NULL,
	CLIENT_ID VARCHAR2(128) NOT NULL,
	CLIENT_TYPE VARCHAR2(256) NOT NULL
);

ALTER TABLE  CtxXcXAApLaunchTest_DDD ADD constraint Pk_CtxXcXAApLaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXAApLaunchTest_DDD ON CtxXcXAApLaunchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NSUSERSTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSUSERSTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	START_TIME	VARCHAR2(128) NOT NULL,
	TYPE		VARCHAR2(128) NOT NULL,
	CLIENT_IP	VARCHAR2(128) NOT NULL,
	CLIENT_TYPE	VARCHAR2(128) NOT NULL,
	VSERVER_IP	VARCHAR2(128) NOT NULL,
	VSERVER_PORT 	VARCHAR2(128) NOT NULL,
	BROWSER_TYPE 	VARCHAR2(200) NOT NULL,
	USER_NAME 	VARCHAR2(128) NOT NULL,
	SOURCE		VARCHAR2(128) NOT NULL,
	DESTINATION	VARCHAR2(128) NOT NULL,
	APPLICATION_NAME VARCHAR2(128) NOT NULL,
	END_TIME 	VARCHAR2(128) NOT NULL,
	DURATION	VARCHAR2(128) NOT NULL,
	REMOTE_HOST 	VARCHAR2(128) NOT NULL,
	DENIED_URL 	VARCHAR2(128) NOT NULL,
	DENIED_BY_POLICY 	VARCHAR2(128) NOT NULL,
	TOTAL_BYTES_SEND 	VARCHAR2(128) NOT NULL,
	TOTAL_BYTES_RECEIVED 	VARCHAR2(128) NOT NULL,
	LOGOUT_METHOD VARCHAR2(128) NOT NULL
);

ALTER TABLE  NSUSERSTEST_DDD ADD CONSTRAINT PK_NSUSERSTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NSUSERSTEST_DDD ON NSUSERSTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_NSUSERSTEST_DDD ON NSUSERSTEST_DDD(MSMT_TIME);

DROP TABLE NSSSLLOGSTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSSSLLOGSTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CLIENT_IP	VARCHAR2(128) NOT NULL,
	CLIENT_PORT	VARCHAR2(128) NOT NULL,
	VSERVER_IP	VARCHAR2(128) NOT NULL,
	VSERVER_PORT 	VARCHAR2(128) NOT NULL,
	CLIENT_VERSION 	VARCHAR2(128) NOT NULL,
	CERTIFICATE 	VARCHAR2(128) NOT NULL,
	DAYS_TO_EXPIRE 	VARCHAR2(128) NOT NULL,
	CRL_NAME 	VARCHAR2(128) NOT NULL,
	METHOD 		VARCHAR2(128) NOT NULL,
	LICENSE_LIMIT 	VARCHAR2(128) NOT NULL
	
);

ALTER TABLE  NSSSLLOGSTEST_DDD ADD CONSTRAINT PK_NSSSLLOGSTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NSSSLLOGSTEST_DDD ON NSSSLLOGSTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_NSSSLLOGSTEST_DDD ON NSSSLLOGSTEST_DDD(MSMT_TIME);

DROP TABLE NSAPPFWTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSAPPFWTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE_DATE_TIME	VARCHAR2(128) NOT NULL,
	MESSAGE_HOST_NAME	VARCHAR2(128) NOT NULL,
	MESSAGE			VARCHAR2(128) NOT NULL,
	SOURCE 			VARCHAR2(128) NOT NULL,
	REQUEST 		VARCHAR2(128) NOT NULL,
	ACTION 			VARCHAR2(128) NOT NULL
	
);

ALTER TABLE  NSAPPFWTEST_DDD ADD CONSTRAINT PK_NSAPPFWTEST_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NSAPPFWTEST_DDD ON NSAPPFWTEST_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_NSAPPFWTEST_DDD ON NSAPPFWTEST_DDD(MSMT_TIME);

DROP TABLE NSDEVTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NSDEVTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSDEVTEST_DDD ADD CONSTRAINT PK_NSDEVTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSDEVTEST_DDD ON NSDEVTEST_DDD(MSMT_TIME);

DROP TABLE NSDHCPTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NSDHCPTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSDHCPTEST_DDD ADD CONSTRAINT PK_NSDHCPTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSDHCPTEST_DDD ON NSDHCPTEST_DDD(MSMT_TIME);

DROP TABLE NSINTRTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NSINTRTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSINTRTEST_DDD ADD CONSTRAINT PK_NSINTRTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSINTRTEST_DDD ON NSINTRTEST_DDD(MSMT_TIME);

DROP TABLE NSMEMTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NSMEMTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSMEMTEST_DDD ADD CONSTRAINT PK_NSMEMTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSMEMTEST_DDD ON NSMEMTEST_DDD(MSMT_TIME);

DROP TABLE NSHATEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NSHATEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSHATEST_DDD ADD CONSTRAINT PK_NSHATEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSHATEST_DDD ON NSHATEST_DDD(MSMT_TIME);

DROP TABLE NSMONTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NSMONTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSMONTEST_DDD ADD CONSTRAINT PK_NSMONTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSMONTEST_DDD ON NSMONTEST_DDD(MSMT_TIME);

DROP TABLE NSSSLVPNTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSSSLVPNTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL,
	CLIENT_IP	VARCHAR2(256) NOT NULL,
	NAT_IP		VARCHAR2(256) NOT NULL,
	VSERVER		VARCHAR2(256) NOT NULL,
	SOURCE		VARCHAR2(256) NOT NULL,
	DESTINATION	VARCHAR2(256) NOT NULL,
	TOTL_BYTS_SND	VARCHAR2(256) NOT NULL,
	TOTL_BYTS_RCV	VARCHAR2(256) NOT NULL,
	DEND_BY_PLCY	VARCHAR2(256) NOT NULL,
	GROUPS		VARCHAR2(256) NOT NULL,
	CLIENTSEC_EXPR		VARCHAR2(256) NOT NULL,
	EVALUTEDTO		VARCHAR2(256) NOT NULL,
	REMOTEHOST		VARCHAR2(256) NOT NULL,
	DENIEDURL		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSSSLVPNTEST_DDD ADD CONSTRAINT PK_NSSSLVPNTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSSSLVPNTEST_DDD ON NSSSLVPNTEST_DDD(MSMT_TIME);

DROP TABLE NSTOPSCRTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSTOPSCRTEST_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SOURCE_IP		VARCHAR2(256) NOT NULL,
	DESTINATION_IP  	VARCHAR2(256) NOT NULL,
	START_TIME 		VARCHAR2(256) NOT NULL,
	END_TIME 		VARCHAR2(256) NOT NULL,
	TOTAL_BYTE_SENT 	VARCHAR2(256) NOT NULL,
	TOTAL_BYTE_RECEIVED 	VARCHAR2(256) NOT NULL,
	USR			VARCHAR2(256) NOT NULL,
	CLIENTIP		VARCHAR2(256) NOT NULL,
	NAT_IP			VARCHAR2(256) NOT NULL,
	VSERVER			VARCHAR2(256) NOT NULL,
	DURATION		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSTOPSCRTEST_DDD ADD CONSTRAINT PK_NSTOPSCRTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSTOPSCRTEST_DDD ON NSTOPSCRTEST_DDD (MSMT_TIME);

DROP TABLE NSTOPDESTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSTOPDESTEST_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SOURCE_IP		VARCHAR2(256) NOT NULL,
	DESTINATION_IP  	VARCHAR2(256) NOT NULL,
	START_TIME 		VARCHAR2(256) NOT NULL,
	END_TIME 		VARCHAR2(256) NOT NULL,
	TOTAL_BYTE_SENT 	VARCHAR2(256) NOT NULL,
	TOTAL_BYTE_RECEIVED 	VARCHAR2(256) NOT NULL,
	USR			VARCHAR2(256) NOT NULL,
	CLIENTIP		VARCHAR2(256) NOT NULL,
	NAT_IP			VARCHAR2(256) NOT NULL,
	VSERVER			VARCHAR2(256) NOT NULL,
	DURATION		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSTOPDESTEST_DDD ADD CONSTRAINT PK_NSTOPDESTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_NSTOPDESTEST_DDD ON NSTOPDESTEST_DDD(MSMT_TIME);

DROP TABLE NSDELINKTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSDELINKTEST_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SOURCE			VARCHAR2(256) NOT NULL,
	DESTINATION  		VARCHAR2(256) NOT NULL,
	NAT_IP 			VARCHAR2(256) NOT NULL,
	VSERVER 		VARCHAR2(256) NOT NULL,
	DELINK_TIME 		VARCHAR2(256) NOT NULL,
	START_TIME 		VARCHAR2(256) NOT NULL,
	END_TIME 		VARCHAR2(256) NOT NULL,
	TOTAL_BYTES_SENT 	VARCHAR2(256) NOT NULL,
	TOTAL_BYTES_RECEIVED 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSDELINKTEST_DDD ADD CONSTRAINT PK_NSDELINKTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_NSDELINKTEST_DDD ON NSDELINKTEST_DDD(MSMT_TIME);

DROP TABLE PITBOSSTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  PITBOSSTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  PITBOSSTEST_DDD ADD CONSTRAINT PK_PITBOSSTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_PITBOSSTEST_DDD ON PITBOSSTEST_DDD (MSMT_TIME);

DROP TABLE NSROUTTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSROUTTEST_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NSROUTTEST_DDD ADD CONSTRAINT PK_NSROUTTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_NSROUTTEST_DDD ON NSROUTTEST_DDD (MSMT_TIME);


DROP TABLE TransactionFlowTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TransactionFlowTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EG_GUID		VARCHAR2(64) NOT NULL,
	REQUEST_TIME	DATE NOT NULL,
	TIME_ZONE	VARCHAR2(32) NOT NULL,
	TRANS_NAME	VARCHAR2(512) NOT NULL,
	URL		VARCHAR2(512) NOT NULL,
	COUNT		NUMBER(20,4) NOT NULL,
	TOT_RESP_TIME	NUMBER(20,4) NOT NULL,
	DETAILS		BLOB NOT NULL
);


ALTER TABLE  TransactionFlowTest_DDD ADD constraint Pk_TransactionFlowTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_TransactionFlowTest_DDD ON TransactionFlowTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_TransactionFlowTest_DDD ON TransactionFlowTest_DDD(MSMT_TIME);
CREATE  INDEX IDX2_TransactionFlowTest_DDD ON TransactionFlowTest_DDD
(
 	MSMT_TIME,SEQ_NO
);


DROP TABLE XMDEVICESTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMDEVICESTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	SERIAL_NO		VARCHAR2(128) NOT NULL,
	MODEL			VARCHAR2(128) NOT NULL,
	OS_NAME			VARCHAR2(128) NOT NULL,
	OS_VERSION		VARCHAR2(128) NOT NULL,
	OS_BUILD		VARCHAR2(128) NOT NULL,
	LAST_USER		VARCHAR2(128) NOT NULL,
	FIRST_CONNECTION_TIME	VARCHAR2(128) NOT NULL,
	LAST_AUTHENDICATION_TIME	VARCHAR2(128) NOT NULL,
	INACTIVE_FOR			VARCHAR2(128) NOT NULL,
	WIPE_ENABLED		VARCHAR2(128) NOT NULL,
	SDCARD_WIPE_ENABLED	VARCHAR2(128) NOT NULL,
	BATTERY_PERCENT		VARCHAR2(128) NOT NULL
);

ALTER TABLE  XMDEVICESTEST_DDD ADD CONSTRAINT PK_XMDEVICESTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMDEVICESTEST_DDD ON XMDEVICESTEST_DDD
(
 	MSMT_TIME
);



DROP TABLE XMDEVICEACTIONSTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMDEVICEACTIONSTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	SERIAL_NO		VARCHAR2(128) NOT NULL,
	MODEL			VARCHAR2(128) NOT NULL,
	OS_NAME			VARCHAR2(128) NOT NULL,
	OS_VERSION		VARCHAR2(128) NOT NULL,
	OS_BUILD		VARCHAR2(128) NOT NULL,
	ACTION_COMPLETED_TIME		VARCHAR2(128) NOT NULL,
	ACTION_REQUESTED_TIME		VARCHAR2(128) NOT NULL,
	ACTION_FAILED_TIME		VARCHAR2(128) NOT NULL,
	FIRST_CONNECTION_TIME		VARCHAR2(128) NOT NULL,
	LAST_AUTHENTICATION_TIME	VARCHAR2(128) NOT NULL,
	INACTIVE_FOR			VARCHAR2(128) NOT NULL,
	WIPE_ENABLED		VARCHAR2(128) NOT NULL,
	SDCARD_WIPE_ENABLED	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XMDEVICEACTIONSTEST_DDD ADD CONSTRAINT PK_XMDEVICEACTIONSTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMDEVICEACTIONSTEST_DDD ON XMDEVICEACTIONSTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMLOGINTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMLOGINTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	START_TIME		VARCHAR2(128) NOT NULL,
	USER_NAME		VARCHAR2(128) NOT NULL,
	CLIENT_IP		VARCHAR2(128) NOT NULL,
	DURATION		VARCHAR2(128) NOT NULL,
	BROWSER_TYPE		VARCHAR2(384) NOT NULL,
	DETAILS			VARCHAR2(256) NOT NULL
);

ALTER TABLE  XMLOGINTEST_DDD ADD CONSTRAINT PK_XMLOGINTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMLOGINTEST_DDD ON XMLOGINTEST_DDD
(
 	MSMT_TIME
);



DROP TABLE XMLICENSETEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMLICENSETEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	NOTICE			VARCHAR2(128) NOT NULL,
	SERIAL_NUMBER		VARCHAR2(128) NOT NULL,
	EXPIRATION_DATE		VARCHAR2(128) NOT NULL,
	LICENSE_TYPE		VARCHAR2(128) NOT NULL,
	IS_SERVER_CONFIGURED	VARCHAR2(128) NOT NULL,
	LOCAL_PORT		VARCHAR2(128) NOT NULL,
	REMOTE_PORT		VARCHAR2(128) NOT NULL,
	SERVER_ADDRESS		VARCHAR2(128) NOT NULL,
	NOTIFICATION_ENABLED	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XMLICENSETEST_DDD ADD CONSTRAINT PK_XMLICENSETEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMLICENSETEST_DDD ON XMLICENSETEST_DDD
(
 	MSMT_TIME
);


DROP TABLE XMDELIVERYGROUPTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMDELIVERYGROUPTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	SERIAL_NO		VARCHAR2(128) NOT NULL,
	MODEL			VARCHAR2(128) NOT NULL,
	OS_NAME			VARCHAR2(128) NOT NULL,
	OS_VERSION		VARCHAR2(128) NOT NULL,
	OS_BUILD		VARCHAR2(128) NOT NULL,
	FIRST_CONNECTION_TIME	VARCHAR2(128) NOT NULL,
	LAST_AUTHENDICATION_TIME	VARCHAR2(128) NOT NULL,
	INACTIVE_FOR			VARCHAR2(128) NOT NULL,
	WIPE_ENABLED		VARCHAR2(128) NOT NULL,
	SDCARD_WIPE_ENABLED	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XMDELIVERYGROUPTEST_DDD ADD CONSTRAINT PK_XMDELIVERYGROUPTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMDELIVERYGROUPTEST_DDD ON XMDELIVERYGROUPTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMPOLICYTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMPOLICYTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	SERIAL_NO		VARCHAR2(128) NOT NULL,
	MODEL			VARCHAR2(128) NOT NULL,
	OS_NAME			VARCHAR2(128) NOT NULL,
	OS_VERSION		VARCHAR2(128) NOT NULL,
	OS_BUILD		VARCHAR2(128) NOT NULL,
	FIRST_CONNECTION_TIME	VARCHAR2(128) NOT NULL,
	LAST_AUTHENDICATION_TIME	VARCHAR2(128) NOT NULL,
	INACTIVE_FOR			VARCHAR2(128) NOT NULL,
	WIPE_ENABLED		VARCHAR2(128) NOT NULL,
	SDCARD_WIPE_ENABLED	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XMPOLICYTEST_DDD ADD CONSTRAINT PK_XMPOLICYTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMPOLICYTEST_DDD ON XMPOLICYTEST_DDD
(
 	MSMT_TIME
);


DROP TABLE XMCERTIFICATETEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMCERTIFICATETEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	ISSUER_NAME		VARCHAR2(2000) NOT NULL,
	SUBJECT_NAME		VARCHAR2(2000) NOT NULL,
	VALID_FROM		VARCHAR2(128) NOT NULL,
	VALID_TO		VARCHAR2(128) NOT NULL,
	DESCRIPTION		VARCHAR2(2000) NOT NULL,
	PRIVATE_KEY		VARCHAR2(128) NOT NULL
);

ALTER TABLE  XMCERTIFICATETEST_DDD ADD CONSTRAINT PK_XMCERTIFICATETEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMCERTIFICATETEST_DDD ON XMCERTIFICATETEST_DDD
(
 	MSMT_TIME
);


DROP TABLE XMCONNCHECKSTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMCONNCHECKSTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	NAME		VARCHAR2(128) NOT NULL,
	MESSAGES			VARCHAR2(128) NOT NULL
	
);

ALTER TABLE  XMCONNCHECKSTEST_DDD ADD CONSTRAINT PK_XMCONNCHECKSTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMCONNCHECKSTEST_DDD ON XMCONNCHECKSTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMCLUSTERTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMCLUSTERTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	ROLE		VARCHAR2(128) NOT NULL,
	NEXT_CHECKIN			VARCHAR2(128) NOT NULL,
	FIRST_CHECKIN			VARCHAR2(128) NOT NULL
	
);

ALTER TABLE  XMCLUSTERTEST_DDD ADD CONSTRAINT PK_XMCLUSTERTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMCLUSTERTEST_DDD ON XMCLUSTERTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMHIBCACHETEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMHIBCACHETEST_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME 	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	CATEGORY_NAME	VARCHAR2(2000) NOT NULL,
	VALUE		VARCHAR2(128) NOT NULL,
	QUERY		VARCHAR2(750) NOT NULL
);
ALTER TABLE  XMHIBCACHETEST_DDD ADD CONSTRAINT PK_XMHIBCACHETEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XMHIBCACHETEST_DDD ON XMHIBCACHETEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMTHRDDUMPTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMTHRDDUMPTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	ID			VARCHAR2(128) NOT NULL,
	NAME			VARCHAR2(128) NOT NULL,
	THREAD_STATE		VARCHAR2(128) NOT NULL,
	CPU_TIME		VARCHAR2(128) NOT NULL,
	USER_TIME		VARCHAR2(128) NOT NULL,
	BLOCKED_COUNT		VARCHAR2(128) NOT NULL,
	WAITED_COUNT		VARCHAR2(128) NOT NULL,
	DEPTH_COUNT		VARCHAR2(128) NOT NULL,
	STACKTRACE		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  XMTHRDDUMPTEST_DDD ADD CONSTRAINT PK_XMTHRDDUMPTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMTHRDDUMPTEST_DDD ON XMTHRDDUMPTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMSESSMGRTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMSESSMGRTEST_DDD
(
                SITE_NAME               VARCHAR2(64) NOT NULL,
                TRGT_HOST               VARCHAR2(32) NOT NULL,
                PORT_NO                 VARCHAR2(32) NOT NULL,
                TEST_NAME               VARCHAR2(64) NOT NULL,
                MEASURE                 VARCHAR2(64) NOT NULL,
                INFO                    VARCHAR2(128) NOT NULL,
                STATE                   VARCHAR2(32) NOT NULL,
                MSMT_HOST               VARCHAR2(32) NOT NULL,
                MSMT_TIME               DATE NOT NULL,
                SEQ_NO                  NUMBER(16) NOT NULL,
                XM_USER                 VARCHAR2(128) NOT NULL,
                DEVICE_ID               VARCHAR2(128) NOT NULL,
                SERIAL_NUMBER           VARCHAR2(128) NOT NULL,
                CONN_DETAILS            VARCHAR2(2000) NOT NULL
);
 
ALTER TABLE  XMSESSMGRTEST_DDD ADD CONSTRAINT PK_XMSESSMGRTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
 
CREATE  INDEX IDX_XMSESSMGRTEST_DDD ON XMSESSMGRTEST_DDD
(
               MSMT_TIME
);


DROP TABLE XMMSGTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMMSGTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	MSG_TO			VARCHAR2(128) NOT NULL,
	REFERENCE_ID		VARCHAR2(128) NOT NULL,
	MSG_STATUS		VARCHAR2(128) NOT NULL,
	CONN_TIME		VARCHAR2(128) NOT NULL
);

ALTER TABLE  XMMSGTEST_DDD ADD CONSTRAINT PK_XMMSGTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMMSGTEST_DDD ON XMMSGTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMCONSOLOPERTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMCONSOLOPERTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	DATE_TIME		VARCHAR2(128) NOT NULL,
	USER_NAME		VARCHAR2(128) NOT NULL,
	CLIENT_IP		VARCHAR2(128) NOT NULL,
	DETAILS			VARCHAR2(2000) NOT NULL
);

ALTER TABLE  XMCONSOLOPERTEST_DDD ADD CONSTRAINT PK_XMCONSOLOPERTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMCONSOLOPERTEST_DDD ON XMCONSOLOPERTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMOPERATIONTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMOPERATIONTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	DATE_TIME		VARCHAR2(128) NOT NULL,
	USER_NAME		VARCHAR2(128) NOT NULL,
	DEVICE_ID		VARCHAR2(128) NOT NULL,
	CLIENT_IP		VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(128) NOT NULL,
	RECEIVER		VARCHAR2(128) NOT NULL,
	DETAILS			VARCHAR2(2000) NOT NULL
);

ALTER TABLE  XMOPERATIONTEST_DDD ADD CONSTRAINT PK_XMOPERATIONTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMOPERATIONTEST_DDD ON XMOPERATIONTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMCONNECTIONTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMCONNECTIONTEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	DEVICE_ID		VARCHAR2(128) NOT NULL,
	LAST_CONNECTED		VARCHAR2(128) NOT NULL
	
);

ALTER TABLE  XMCONNECTIONTEST_DDD ADD CONSTRAINT PK_XMCONNECTIONTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMCONNECTIONTEST_DDD ON XMCONNECTIONTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE XMSCHEDULETEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XMSCHEDULETEST_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	STATE_DATE		VARCHAR2(128) NOT NULL,
	TASK			VARCHAR2(128) NOT NULL,
	DELAY_AMOUNT		VARCHAR2(128) NOT NULL,
	DELAY_UNIT		VARCHAR2(128) NOT NULL,
	PRIORITY		VARCHAR2(128) NOT NULL,
	REPEAT_DELAY_AMOUNT	VARCHAR2(128) NOT NULL
	
);

ALTER TABLE  XMSCHEDULETEST_DDD ADD CONSTRAINT PK_XMSCHEDULETEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XMSCHEDULETEST_DDD ON XMSCHEDULETEST_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgRdpClientTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VmgRdpClientTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Client_ip_address VARCHAR2(128) NOT NULL
);

ALTER TABLE  VmgRdpClientTest_DDD ADD constraint Pk_VmgRdpClientTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgRdpClientTest_DDD ON VmgRdpClientTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxNetworkTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  EsxNetworkTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VMNAME		VARCHAR2(128) NOT NULL,
	VM_STATISTICS 	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  EsxNetworkTest_DDD ADD constraint Pk_EsxNetworkTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxNetworkTest_DDD ON EsxNetworkTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AppChecksumTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AppChecksumTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Old_checksum	VARCHAR2(128) NOT NULL,
	Modified_checksum	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AppChecksumTest_DDD ADD constraint Pk_AppChecksumTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AppChecksumTest_DDD ON AppChecksumTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OSChecksumTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE OSChecksumTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Old_checksum	VARCHAR2(128) NOT NULL,
	Modified_checksum	VARCHAR2(128) NOT NULL
);

ALTER TABLE  OSChecksumTest_DDD ADD constraint Pk_OSChecksumTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_OSChecksumTest_DDD ON OSChecksumTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VMMonitoringTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VMMonitoringTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Physical_Server		VARCHAR2(128) NOT NULL,
	VMs_Name		VARCHAR2(200) NOT NULL,
	VMs_IP_Address		VARCHAR2(200) NOT NULL,
	VMs_Failed_Reasons	VARCHAR2(200) NOT NULL,	
	DNS_Name		VARCHAR2(200) NOT NULL,
	Connection_State	VARCHAR2(200) NOT NULL,
	Power_State		VARCHAR2(200) NOT NULL,
	OS		 	VARCHAR2(200) NOT NULL,
	VM_Tools_State	 	VARCHAR2(200) NOT NULL
);

ALTER TABLE VMMonitoringTest_DDD ADD constraint Pk_VMMonitoringTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VMMonitoringTest_DDD ON VMMonitoringTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EgTestOverviewTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE EgTestOverviewTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name_Of_Components		VARCHAR2(2000) NOT NULL	
);

ALTER TABLE EgTestOverviewTest_DDD ADD constraint Pk_EgTestOverviewTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EgTestOverviewTest_DDD ON EgTestOverviewTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AsAbapProcessTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapProcessTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Description	VARCHAR2(256) NOT NULL,
	Start_Time	 	VARCHAR2(256) NOT NULL,
	Elapsed_Time	VARCHAR2(256) NOT NULL);
ALTER TABLE  AsAbapProcessTest_DDD ADD constraint Pk_AsAbapProcessTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapProcessTest_DDD ON AsAbapProcessTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MultiHttpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MultiHttpTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	URL			VARCHAR2(128) NOT NULL,
	URL_Value		VARCHAR2(128) NOT NULL,
	Avaialbility		VARCHAR2(128) NOT NULL,
	TCP			VARCHAR2(128) NOT NULL,
	DNS			VARCHAR2(128) NOT NULL
);


ALTER TABLE  MultiHttpTest_DDD ADD constraint Pk_MultiHttpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MultiHttpTest_DDD ON MultiHttpTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MultiPortStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MultiPortStatTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Host_Ip			VARCHAR2(128) NOT NULL,
	Port_number		VARCHAR2(128) NOT NULL,
	Availability		VARCHAR2(128) NOT NULL,
	Response_Time		VARCHAR2(128) NOT NULL
);

ALTER TABLE  MultiPortStatTest_DDD ADD constraint Pk_MultiPortStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MultiPortStatTest_DDD ON MultiPortStatTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MultiHostNetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MultiHostNetTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Host_Ip			VARCHAR2(128) NOT NULL,
	Net_Availability	VARCHAR2(128) NOT NULL,
	Packet_Loss		VARCHAR2(128) NOT NULL
);

ALTER TABLE  MultiHostNetTest_DDD ADD constraint Pk_MultiHostNetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_MultiHostNetTest_DDD ON MultiHostNetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DFSEvtLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DFSEvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  DFSEvtLogTest_DDD ADD constraint Pk_DFSEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_DFSEvtLogTest_DDD ON DFSEvtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_DFSEvtLogTest_DDD ON DFSEvtLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_DFSEvtLogTest_DDD ON DFSEvtLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_DFSEvtLogTest_DDD ON DFSEvtLogTest_DDD ( EVENT_USER );

DROP TABLE KeyMgmtEvtLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  KeyMgmtEvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  KeyMgmtEvtLogTest_DDD ADD constraint Pk_KeyMgmtEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_KeyMgmtEvtLogTest_DDD ON KeyMgmtEvtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_KeyMgmtEvtLogTest_DDD ON KeyMgmtEvtLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_KeyMgmtEvtLogTest_DDD ON KeyMgmtEvtLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_KeyMgmtEvtLogTest_DDD ON KeyMgmtEvtLogTest_DDD ( EVENT_USER );

DROP TABLE CtxNsLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Client_port		VARCHAR2(128) NOT NULL,
	Server_ip_address	VARCHAR2(128) NOT NULL,
	Server_port		VARCHAR2(128) NOT NULL,
	Sesssion_start_time	VARCHAR2(128) NOT NULL,
	Session_end_time	VARCHAR2(128) NOT NULL,
	Session_duration	VARCHAR2(128) NOT NULL,
	Intranet_ip_address	VARCHAR2(128) NOT NULL,
	Netmask_ip_addresss	VARCHAR2(128) NOT NULL,
	Group_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxNsLoginTest_DDD ADD constraint Pk_CtxNsLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsLoginTest_DDD ON CtxNsLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SapWasComponentTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SapWasComponentTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Start_up_mode	VARCHAR2(256) NOT NULL,
	details	 	VARCHAR2(256) NOT NULL);
ALTER TABLE  SapWasComponentTest_DDD ADD constraint Pk_SapWasComponentTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SapWasComponentTest_DDD ON SapWasComponentTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXAUserDevTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAUserDevTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Xenapp_server	VARCHAR2(128) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Session_name	VARCHAR2(128) NOT NULL,
	Session_id	VARCHAR2(128) NOT NULL,
	Client_name	VARCHAR2(128) NOT NULL,
	Client_version	VARCHAR2(128) NOT NULL,
	Client_ip_address VARCHAR2(128) NOT NULL,
	Client_id	VARCHAR2(128) NOT NULL,
	Client_type	VARCHAR2(128) NOT NULL,
	Published_applications VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxXcXAUserDevTest_DDD ADD constraint Pk_CtxXcXAUserDevTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXAUserDevTest_DDD ON CtxXcXAUserDevTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXACountryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXACountryTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SESSIONNAME VARCHAR2(128) NOT NULL,
	ID NUMBER(16) NOT NULL,
	SESSION_KEY VARCHAR2(256) NOT NULL);

ALTER TABLE  CtxXcXACountryTest_DDD ADD constraint Pk_CtxXcXACountryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXACountryTest_DDD ON CtxXcXACountryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXARegionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXARegionTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SESSIONNAME VARCHAR2(128) NOT NULL,
	ID NUMBER(16) NOT NULL,
	SESSION_KEY VARCHAR2(256) NOT NULL);

ALTER TABLE  CtxXcXARegionTest_DDD ADD constraint Pk_CtxXcXARegionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXARegionTest_DDD ON CtxXcXARegionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXACityTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXACityTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SESSIONNAME VARCHAR2(128) NOT NULL,
	ID NUMBER(16) NOT NULL,
	SESSION_KEY VARCHAR2(256) NOT NULL);

ALTER TABLE  CtxXcXACityTest_DDD ADD constraint Pk_CtxXcXACityTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXACityTest_DDD ON CtxXcXACityTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXAInfoTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXAInfoTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ASSIGNMENT_TYPE VARCHAR2(128) NOT NULL,
	BROKER_SITE_NAME VARCHAR2(128) NOT NULL,
	DELIVERY_GROUP_NAME VARCHAR2(128) NOT NULL,
	CATALOG_NAME VARCHAR2(128) NOT NULL,
	DELIVERY_CONTROLLER_NAME VARCHAR2(128) NOT NULL,
	DELIVERY_CONTROLLER_TIME VARCHAR2(128) NOT NULL,
	LICENSE_SERVER_NAME VARCHAR2(128) NOT NULL,
	LICENSE_SERVER_PORT VARCHAR2(128) NOT NULL,
	LICENSE_SERVER_MODEL VARCHAR2(128) NOT NULL,
	LICENSE_PRODUCT_EDT VARCHAR2(128) NOT NULL,
	LICENSE_PRODUCT_NAME VARCHAR2(128) NOT NULL,
	PROVISIONING_TYPE VARCHAR2(128) NOT NULL,
	PERSISTENT_DATA_LOCATION VARCHAR2(256) NOT NULL,
	PERSONAL_VDISK_DRIVE VARCHAR2(128) NOT NULL);

ALTER TABLE  CtxXcXAInfoTest_DDD ADD constraint Pk_CtxXcXAInfoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXAInfoTest_DDD ON CtxXcXAInfoTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DockContainerStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DockContainerStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Names	VARCHAR2(128) NOT NULL,
	Container_IP	VARCHAR2(128) NOT NULL,
	Container_ID	VARCHAR2(128) NOT NULL,
	Images	VARCHAR2(128) NOT NULL,
	Created	VARCHAR2(128) NOT NULL,
	Status VARCHAR2(128) NOT NULL,
	Cont_Size	VARCHAR2(128) NOT NULL,
	App_Port	VARCHAR2(128) NOT NULL,
	Pod_Name	VARCHAR2(128) NOT NULL,
	Pod_IP		VARCHAR2(128) NOT NULL
);

ALTER TABLE  DockContainerStTest_DDD ADD constraint Pk_DockContainerStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DockContainerStTest_DDD ON DockContainerStTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DockContImgTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DockContImgTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Images_Name	VARCHAR2(128) NOT NULL,
	Images_ID	VARCHAR2(128) NOT NULL,
	Containers_Name	VARCHAR2(2000) NOT NULL,
	Created		VARCHAR2(128) NOT NULL,
	Img_Size	VARCHAR2(128) NOT NULL
);

ALTER TABLE  DockContImgTest_DDD ADD constraint Pk_DockContImgTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DockContImgTest_DDD ON DockContImgTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DockerEventsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DockerEventsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Event_Time	VARCHAR2(128) NOT NULL,
	Container_ID	VARCHAR2(128) NOT NULL,
	Container_Name	VARCHAR2(128) NOT NULL,
	Image_Name	VARCHAR2(128) NOT NULL,
	Event_Type	VARCHAR2(128) NOT NULL,
	Categories	VARCHAR2(128) NOT NULL
);

ALTER TABLE  DockerEventsTest_DDD ADD constraint Pk_DockerEventsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DockerEventsTest_DDD ON DockerEventsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DockContUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DockContUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  DockContUptimeTest_DDD ADD constraint Pk_DockContUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DockContUptimeTest_DDD ON DockContUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_DockContUptimeTest_DDD ON DockContUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX2_DockContUptimeTest_DDD ON DockContUptimeTest_DDD
(
 	REBOOTEDDATE
);

CREATE  INDEX IDX3_DockContUptimeTest_DDD ON DockContUptimeTest_DDD
(
 	INFO
);



DROP TABLE DockContPerfTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  DockContPerfTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID		VARCHAR2(128) NOT NULL,
	Usage		VARCHAR2(128) NOT NULL,
	Command		VARCHAR2(2000) NOT NULL,
	User_Type	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  DockContPerfTest_DDD ADD constraint Pk_DockContPerfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DockContPerfTest_DDD ON DockContPerfTest_DDD
(
 	MSMT_TIME
);


DROP TABLE DockImgPerfTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  DockImgPerfTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Cont_Name	VARCHAR2(128) NOT NULL,
	CPU_util	VARCHAR2(128) NOT NULL,
	Memory_used	VARCHAR2(128) NOT NULL,
	Memory_util	VARCHAR2(128) NOT NULL
);

ALTER TABLE DockImgPerfTest_DDD ADD constraint Pk_DockImgPerfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DockImgPerfTest_DDD ON DockImgPerfTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VMViewEventsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VMViewEventsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Event_id	VARCHAR2(512) NOT NULL,
	Time		VARCHAR2(128) NOT NULL,
	Module		VARCHAR2(128) NOT NULL,
	Event_type	VARCHAR2(512) NOT NULL,
	Message		VARCHAR2(2000) NOT NULL,
	Source		VARCHAR2(1000) NOT NULL,
	Node		VARCHAR2(1000) NOT NULL,
	Users_id	VARCHAR2(512) NOT NULL,
	Desktop_id	VARCHAR2(512) NOT NULL,
	Machine_id	VARCHAR2(512) NOT NULL,
	Pool_id		VARCHAR2(512) NOT NULL
);

ALTER TABLE VMViewEventsTest_DDD ADD constraint Pk_VMViewEventsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VMViewEventsTest_DDD ON VMViewEventsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE GPUTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE GPUTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		VARCHAR2(128) NOT NULL,
	Process_name	VARCHAR2(2000) NOT NULL,
	Used_GPU_memory		VARCHAR2(128) NOT NULL
);

ALTER TABLE GPUTest_DDD ADD constraint Pk_GPUTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_GPUTest_DDD ON GPUTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XenGPUStatsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE XenGPUStatsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		VARCHAR2(128) NOT NULL,
	Process_name	VARCHAR2(128) NOT NULL,
	Used_GPU_memory		VARCHAR2(128) NOT NULL,
	Used_frame_memory	VARCHAR2(128) NOT NULL
);

ALTER TABLE XenGPUStatsTest_DDD ADD constraint Pk_XenGPUStatsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XenGPUStatsTest_DDD ON XenGPUStatsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgGPUTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VmgGPUTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		VARCHAR2(128) NOT NULL,
	Process_name	VARCHAR2(2000) NOT NULL,
	Used_GPU_memory	VARCHAR2(128) NOT NULL,
	GPU_util	VARCHAR2(128) NOT NULL,
	Memory_used	VARCHAR2(128) NOT NULL,
	Memory_util	VARCHAR2(128) NOT NULL,
	Encoder_util	VARCHAR2(128) NOT NULL,
	Decoder_util	VARCHAR2(128) NOT NULL
);
ALTER TABLE VmgGPUTest_DDD ADD constraint Pk_VmgGPUTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VmgGPUTest_DDD ON VmgGPUTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxGPUStatsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE EsxGPUStatsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	PID		VARCHAR2(128) NOT NULL,
	Process_name	VARCHAR2(128) NOT NULL,
	Used_GPU_memory		VARCHAR2(128) NOT NULL,
	Used_frame_memory	VARCHAR2(128) NOT NULL
);

ALTER TABLE EsxGPUStatsTest_DDD ADD constraint Pk_EsxGPUStatsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxGPUStatsTest_DDD ON EsxGPUStatsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AsAbapMultLgnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapMultLgnTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	TID				VARCHAR2(256) NOT NULL,
	SAPUSER	VARCHAR2(256) NOT NULL,
	CLIENT	VARCHAR2(256) NOT NULL,
	TERMINAL	VARCHAR2(256) NOT NULL,
	HOST_ADDRESS	VARCHAR2(256) NOT NULL,
	INSTANCE_NO	VARCHAR2(256) NOT NULL,
	TCODE	VARCHAR2(256) NOT NULL,
	LAST_REQUEST_TIME	VARCHAR2(256) NOT NULL,
	MASTER	 VARCHAR2(256) NOT NULL,
	TRACE	VARCHAR2(256) NOT NULL,
	EXTERNAL_SESSIONS	VARCHAR2(256) NOT NULL,
	INTERNAL_SESSIONS		VARCHAR2(256) NOT NULL,
	SAPSTATE		VARCHAR2(256) NOT NULL,
	PROTOCOL		VARCHAR2(256) NOT NULL,
	GUI_VERSION		VARCHAR2(256) NOT NULL,
	ACTIVE_STATUS		VARCHAR2(256) NOT NULL,
	OVERALL_SESSIONS		VARCHAR2(256) NOT NULL,
	ACTIVE_SESSIONS		VARCHAR2(256) NOT NULL);
ALTER TABLE  AsAbapMultLgnTest_DDD ADD constraint Pk_AsAbapMultLgnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapMultLgnTest_DDD ON AsAbapMultLgnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SapWasAcsPntTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SapWasAcsPntTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Ip_Address	VARCHAR2(256) NOT NULL,
	Port	 	VARCHAR2(256) NOT NULL
);
ALTER TABLE  SapWasAcsPntTest_DDD ADD constraint Pk_SapWasAcsPntTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SapWasAcsPntTest_DDD ON SapWasAcsPntTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SapWasCachesTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SapWasCachesTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	TYPE			VARCHAR2(256) NOT NULL,
	UPDATE_TIME	VARCHAR2(256) NOT NULL,
	PUTS			VARCHAR2(256) NOT NULL,
	GETS			VARCHAR2(256) NOT NULL,
	ATTR_SIZE		VARCHAR2(256) NOT NULL,
	KEYS_SIZE		VARCHAR2(256) NOT NULL,
	CACHED_OBJECTS	VARCHAR2(256) NOT NULL,
	USED_OBJECTS		VARCHAR2(256) NOT NULL,
	CHANGES			VARCHAR2(256) NOT NULL,
	REMOVES			VARCHAR2(256) NOT NULL,
	EVICTIONS			VARCHAR2(256) NOT NULL
);
ALTER TABLE  SapWasCachesTest_DDD ADD constraint Pk_SapWasCachesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SapWasCachesTest_DDD ON SapWasCachesTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SapWasAliasesTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SapWasAliasesTest_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Application_Name	VARCHAR2(256) NOT NULL,
	Ignore_Cookie	 	VARCHAR2(256) NOT NULL
);
ALTER TABLE  SapWasAliasesTest_DDD ADD constraint Pk_SapWasAliasesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SapWasAliasesTest_DDD ON SapWasAliasesTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraDgTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE OraDgTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DB_NAME		VARCHAR2(64) NOT NULL,
	PREVIOUS_DB_MODE VARCHAR2(128) NOT NULL,
	CURRENT_DB_MODE	VARCHAR2(128) NOT NULL,
	SWITCHOVER_TIME_STAMP	VARCHAR2(128) NOT NULL	
);
ALTER TABLE  OraDgTest_DDD ADD constraint Pk_OraDgTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_OraDgTest_DDD ON OraDgTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraDgLogStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE OraDgLogStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ERROR		VARCHAR2(64) NOT NULL
	
);
ALTER TABLE  OraDgLogStatusTest_DDD ADD constraint Pk_OraDgLogStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_OraDgLogStatusTest_DDD ON OraDgLogStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraDgLogGapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE OraDgLogGapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SYNCHRONIZATION_STATUS		VARCHAR2(64) NOT NULL
	
);
ALTER TABLE  OraDgLogGapTest_DDD ADD constraint Pk_OraDgLogGapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_OraDgLogGapTest_DDD ON OraDgLogGapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraDgErrorTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE OraDgErrorTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DEST_ID		VARCHAR2(64) NOT NULL,
	LOG_FACILITY	VARCHAR2(64) NOT NULL,
	MESSAGE_NUMBER	VARCHAR2(64) NOT NULL,
	ERROR_CODE	VARCHAR2(64) NOT NULL,
	MESSAGE_DESCRIPTION VARCHAR2(128) NOT NULL
);
ALTER TABLE  OraDgErrorTest_DDD ADD constraint Pk_OraDgErrorTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_OraDgErrorTest_DDD ON OraDgErrorTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureSubcripTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureSubcripTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(128) NOT NULL
);
ALTER TABLE AzureSubcripTest_DDD ADD constraint Pk_AzureSubcripTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureSubcripTest_DDD ON AzureSubcripTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureVirNetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureVirNetTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(128) NOT NULL,
	Location	VARCHAR2(128) NOT NULL,
	Subnet_name	VARCHAR2(128) NOT NULL,
	Subnet_address	VARCHAR2(128) NOT NULL,
	Address_prefix	VARCHAR2(128) NOT NULL,
	ID		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureVirNetTest_DDD ADD constraint Pk_AzureVirNetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureVirNetTest_DDD ON AzureVirNetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureStorageTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureStorageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Location	VARCHAR2(128) NOT NULL,
	Account_Creat	VARCHAR2(128) NOT NULL,
	Account_Type	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureStorageTest_DDD ADD constraint Pk_AzureStorageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureStorageTest_DDD ON AzureStorageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureDBDetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureDBDetTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Server_name	VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(128) NOT NULL,
	Location	VARCHAR2(128) NOT NULL,
	Edition		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureDBDetTest_DDD ADD constraint Pk_AzureDBDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureDBDetTest_DDD ON AzureDBDetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureDBStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureDBStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DB_name		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureDBStatusTest_DDD ADD constraint Pk_AzureDBStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureDBStatusTest_DDD ON AzureDBStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureCloudTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureCloudTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Role_name	VARCHAR2(128) NOT NULL,
	Instance_name	VARCHAR2(128) NOT NULL,
	Instance_status	VARCHAR2(128) NOT NULL,
	Instance_size	VARCHAR2(128) NOT NULL,
	Ip_Address	VARCHAR2(128) NOT NULL,
	Power_status	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureCloudTest_DDD ADD constraint Pk_AzureCloudTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureCloudTest_DDD ON AzureCloudTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureVmPerfTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureVmPerfTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Location	VARCHAR2(128) NOT NULL,
	OS_name		VARCHAR2(128) NOT NULL,
	Role_size	VARCHAR2(128) NOT NULL,
	Virtual_disk	VARCHAR2(128) NOT NULL,
	Host_cache	VARCHAR2(128) NOT NULL,
	Media_link	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureVmPerfTest_DDD ADD constraint Pk_AzureVmPerfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureVmPerfTest_DDD ON AzureVmPerfTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureVMStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureVMStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_name		VARCHAR2(128) NOT NULL,
	Location	VARCHAR2(128) NOT NULL,
	Os_name		VARCHAR2(128) NOT NULL,
	Internal_ip	VARCHAR2(128) NOT NULL,
	Public_ip	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureVMStatusTest_DDD ADD constraint Pk_AzureVMStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureVMStatusTest_DDD ON AzureVMStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureWebsiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureWebsiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Webspace_name	VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(128) NOT NULL,
	Avail_status	VARCHAR2(128) NOT NULL,
	Region		VARCHAR2(128) NOT NULL,
	Location	VARCHAR2(128) NOT NULL,
	Url		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AzureWebsiteTest_DDD ADD constraint Pk_AzureWebsiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureWebsiteTest_DDD ON AzureWebsiteTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureWebAuditTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureWebAuditTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Username		VARCHAR2(512) NOT NULL,
	Id		VARCHAR2(512) NOT NULL,
	User_address	VARCHAR2(512) NOT NULL,
	Levels		VARCHAR2(512) NOT NULL,
	Logged_in_time	VARCHAR2(512) NOT NULL,
	Messages	VARCHAR2(1000) NOT NULL
);
ALTER TABLE  AzureWebAuditTest_DDD ADD constraint Pk_AzureWebAuditTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureWebAuditTest_DDD ON AzureWebAuditTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureWADDInfTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureWADDInfTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Role_name	VARCHAR2(128) NOT NULL,
	Pid		VARCHAR2(128) NOT NULL,
	Messages	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  AzureWADDInfTest_DDD ADD constraint Pk_AzureWADDInfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureWADDInfTest_DDD ON AzureWADDInfTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzureWEvtLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzureWEvtLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Event_Id	VARCHAR2(128) NOT NULL,
	Provider_Name	VARCHAR2(128) NOT NULL,
	Time_created	VARCHAR2(128) NOT NULL,
	Event_Rec_ID	VARCHAR2(128) NOT NULL,
	Messages	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  AzureWEvtLogTest_DDD ADD constraint Pk_AzureWEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzureWEvtLogTest_DDD ON AzureWEvtLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AsAbapSessMemTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapSessMemTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Handle		 VARCHAR2(32) NOT NULL,
	IP		 VARCHAR2(32) NOT NULL,
	Terminal		 VARCHAR2(32) NOT NULL,
	Tcode		 VARCHAR2(32) NOT NULL,
	Overall_memory		 VARCHAR2(32) NOT NULL,
	Total_memory		 VARCHAR2(32) NOT NULL,
	Roll_memory		 VARCHAR2(32) NOT NULL,
	Page_memory		 VARCHAR2(32) NOT NULL,
	Priv_memory		 VARCHAR2(32) NOT NULL,
	Is_attached		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapSessMemTest_DDD ADD constraint Pk_AsAbapSessMemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapSessMemTest_DDD ON AsAbapSessMemTest_DDD
(
	MSMT_TIME
);

DROP TABLE AsAbapRfcDnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsAbapRfcDnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Hostname	VARCHAR2(32) NOT NULL,
	IP		VARCHAR2(32) NOT NULL,
	Communication_message	VARCHAR2(256) NOT NULL,
	System_message 	VARCHAR2(256) NOT NULL,
	SID		VARCHAR2(32) NOT NULL,
	Database_system		VARCHAR2(32) NOT NULL,
	Version		VARCHAR2(32) NOT NULL
);
ALTER TABLE  AsAbapRfcDnTest_DDD ADD constraint Pk_AsAbapRfcDnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsAbapRfcDnTest_DDD ON AsAbapRfcDnTest_DDD
(
	MSMT_TIME
);

DROP TABLE IfxSessionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IfxSessionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	SID		VARCHAR2(32) NOT NULL,
	USERNAME	VARCHAR2(64) NOT NULL,
	DBNAME		VARCHAR2(64) NOT NULL,
	HOSTNAME	VARCHAR2(64) NOT NULL,
	START_TIME	VARCHAR2(64) NOT NULL,
	REASON		VARCHAR2(64) NOT NULL,
	NUMWAITS	VARCHAR2(64) NOT NULL,
	WAIT_TIME	VARCHAR2(64) NOT NULL
	
);
ALTER TABLE  IfxSessionTest_DDD ADD constraint Pk_IfxSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IfxSessionTest_DDD ON IfxSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SPFARMTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE SPFARMTEST_DDD (
        SITE_NAME                  varchar2(64)  NOT NULL,
        TRGT_HOST                  varchar2(32)  NOT NULL,
        PORT_NO                    varchar2(32)  NOT NULL,
        TEST_NAME                  varchar2(64)  NOT NULL,
        MEASURE                    varchar2(64)  NOT NULL,
        INFO                       varchar2(128) NOT NULL,
        STATE                      varchar2(32)  NOT NULL,
        MSMT_HOST                  varchar2(32)  NOT NULL,
        MSMT_TIME                  date          NOT NULL,
        SEQ_NO                     number(16)    NOT NULL,
        SERVER_NAME                varchar2(128) NOT NULL,
        SERVER_DISPLAY_NAME        varchar2(128) NOT NULL,
        SERVER_STATUS              varchar2(128) NOT NULL,
        SERVER_ROLE                varchar2(128) NOT NULL,
        CAN_UPGRADE                varchar2(128) NOT NULL,
        NEEDS_UPGRADE              varchar2(128) NOT NULL,
        SERVICE_INSTANCE_TYPE_NAME varchar2(384) NOT NULL
    );

ALTER TABLE SPFARMTEST_DDD ADD CONSTRAINT PK_SPFARMTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPFARMTEST_DDD ON SPFARMTEST_DDD
(
MSMT_TIME
);



DROP TABLE SPULSLOGTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE SPULSLOGTEST_DDD (
        SITE_NAME      varchar2(64)   NOT NULL,
        TRGT_HOST      varchar2(32)   NOT NULL,
        PORT_NO        varchar2(32)   NOT NULL,
        TEST_NAME      varchar2(64)   NOT NULL,
        MEASURE        varchar2(64)   NOT NULL,
        INFO           varchar2(128)  NOT NULL,
        STATE          varchar2(32)   NOT NULL,
        MSMT_HOST      varchar2(32)   NOT NULL,
        MSMT_TIME      date           NOT NULL,
        SEQ_NO         number(16)     NOT NULL,
        timestamp      varchar2(128)  NOT NULL,
        PROCESS        varchar2(128)  NOT NULL,
        CORRELATION_ID varchar2(128)  NOT NULL,
        EVENT_ID       varchar2(128)  NOT NULL,
        MESSAGE        varchar2(2000) NOT NULL
    );

ALTER TABLE SPULSLOGTEST_DDD ADD CONSTRAINT PK_SPULSLOGTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPULSLOGTEST_DDD ON SPULSLOGTEST_DDD
(
MSMT_TIME
);


DROP TABLE SPBACKUPTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE SPBACKUPTEST_DDD (
        SITE_NAME                 varchar2(64)  NOT NULL,
        TRGT_HOST                 varchar2(32)  NOT NULL,
        PORT_NO                   varchar2(32)  NOT NULL,
        TEST_NAME                 varchar2(64)  NOT NULL,
        MEASURE                   varchar2(64)  NOT NULL,
        INFO                      varchar2(128) NOT NULL,
        STATE                     varchar2(32)  NOT NULL,
        MSMT_HOST                 varchar2(32)  NOT NULL,
        MSMT_TIME                 date          NOT NULL,
        SEQ_NO                    number(16)    NOT NULL,
        BACKUPMETHOD              varchar2(64)  NOT NULL,
        RESTOREMETHOD             varchar2(64)  NOT NULL,
        ISBACKUPCONFIGURATIONONLY varchar2(64)  NOT NULL,
        FAILUREMESSAGE            varchar2(64)  NOT NULL,
        STARTTIME                 varchar2(64)  NOT NULL,
        ENDTIME                   varchar2(64)  NOT NULL,
        SELFID                    varchar2(64)  NOT NULL,
        RESTOREID                 varchar2(64)  NOT NULL,
        PARENTID                  varchar2(64)  NOT NULL,
        NAME                      varchar2(64)  NOT NULL,
        TOPCOMPONENT              varchar2(64)  NOT NULL,
        TOPCOMPONENTID            varchar2(64)  NOT NULL,
        DIRECTORY                 varchar2(64)  NOT NULL,
        DIRECTORYNAME             varchar2(64)  NOT NULL,
        REQUESTEDBY               varchar2(64)  NOT NULL,
        WARNINGCOUNT              varchar2(64)  NOT NULL,
        ERRORCOUNT                varchar2(64)  NOT NULL,
        S                         varchar2(64)  NOT NULL,
        METHOD                    varchar2(64)  NOT NULL

    );

ALTER TABLE SPBACKUPTEST_DDD ADD CONSTRAINT PK_SPBACKUPTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPBACKUPTEST_DDD ON SPBACKUPTEST_DDD
(
MSMT_TIME
);



DROP TABLE SPWEBAPPTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE SPWEBAPPTEST_DDD (
        SITE_NAME varchar2(64)  NOT NULL,
        TRGT_HOST varchar2(32)  NOT NULL,
        PORT_NO   varchar2(32)  NOT NULL,
        TEST_NAME varchar2(64)  NOT NULL,
        MEASURE   varchar2(64)  NOT NULL,
        INFO      varchar2(128) NOT NULL,
        STATE     varchar2(32)  NOT NULL,
        MSMT_HOST varchar2(32)  NOT NULL,
        MSMT_TIME date          NOT NULL,
        SEQ_NO    number(16)    NOT NULL,
        DB_NAMES  varchar2(128) NOT NULL

    );

ALTER TABLE SPWEBAPPTEST_DDD ADD CONSTRAINT PK_SPWEBAPPTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPWEBAPPTEST_DDD ON SPWEBAPPTEST_DDD
(
MSMT_TIME
);



DROP TABLE SPHEALTHTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE SPHEALTHTEST_DDD (
        SITE_NAME            varchar2(64)  NOT NULL,
        TRGT_HOST            varchar2(32)  NOT NULL,
        PORT_NO              varchar2(32)  NOT NULL,
        TEST_NAME            varchar2(64)  NOT NULL,
        MEASURE              varchar2(64)  NOT NULL,
        INFO                 varchar2(128) NOT NULL,
        STATE                varchar2(32)  NOT NULL,
        MSMT_HOST            varchar2(32)  NOT NULL,
        MSMT_TIME            date          NOT NULL,
        SEQ_NO               number(16)    NOT NULL,
        TITLE                varchar2(500) NOT NULL,
        FAILING_SERVER       varchar2(128) NOT NULL,
        FAILING_SERVICES     varchar2(128) NOT NULL,
        MODIFIED_INFORMATION varchar2(128) NOT NULL

    );

ALTER TABLE SPHEALTHTEST_DDD ADD CONSTRAINT PK_SPHEALTHTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPHEALTHTEST_DDD ON SPHEALTHTEST_DDD
(
MSMT_TIME
);

DROP TABLE SPWEBAPPANALYTICTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPWEBAPPANALYTICTEST_DDD (
        SITE_NAME              VARCHAR2(64)  NOT NULL,
        TRGT_HOST              VARCHAR2(32)  NOT NULL,
        PORT_NO                VARCHAR2(32)  NOT NULL,
        TEST_NAME              VARCHAR2(64)  NOT NULL,
        MEASURE                VARCHAR2(64)  NOT NULL,
        INFO                   VARCHAR2(128) NOT NULL,
        STATE                  VARCHAR2(32)  NOT NULL,
        MSMT_HOST              VARCHAR2(32)  NOT NULL,
        MSMT_TIME              DATE     NOT NULL,
        SEQ_NO                 NUMBER(16)  NOT NULL,
	LOG_TIME               VARCHAR2(128) NOT NULL,
        USER_ADDRESS           VARCHAR2(128) NOT NULL,
	USER_LOGIN             VARCHAR2(128) NOT NULL,
        SITE_URL               VARCHAR2(4000) NOT NULL,
	REFERRER_URL           VARCHAR2(4000) NOT NULL,
	PAGE_LOAD_TIME         VARCHAR2(128) NOT NULL,
        MACHINE_NAME           VARCHAR2(128) NOT NULL,
        BROWSER                VARCHAR2(128) NOT NULL,
        REQUEST_COUNT          VARCHAR2(128) NOT NULL,
        QUERY_COUNT            VARCHAR2(128) NOT NULL,
        REQUEST_TYPE           VARCHAR2(128) NOT NULL,
        BYTES_CONSUMED         VARCHAR2(128) NOT NULL,
        HTTP_STATUS            VARCHAR2(128) NOT NULL,
        HITS_TO_THIS_URL       VARCHAR2(128) NOT NULL,
        HITS_FROM_THIS_URL     VARCHAR2(128) NOT NULL,
        USER_AGENT_STRING      VARCHAR2(512) NOT NULL,
        HITS_FROM_THIS_BROWSER VARCHAR2(128) NOT NULL
    );
ALTER TABLE SPWEBAPPANALYTICTEST_DDD ADD CONSTRAINT PK_SPWEBAPPANALYTICTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPWEBAPPANALYTICTEST_DDD ON SPWEBAPPANALYTICTEST_DDD
(
MSMT_TIME
);

DROP TABLE SPSITEANALYTICTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPSITEANALYTICTEST_DDD (
        SITE_NAME              VARCHAR2(64)  NOT NULL,
        TRGT_HOST              VARCHAR2(32)  NOT NULL,
        PORT_NO                VARCHAR2(32)  NOT NULL,
        TEST_NAME              VARCHAR2(64)  NOT NULL,
        MEASURE                VARCHAR2(64)  NOT NULL,
        INFO                   VARCHAR2(128) NOT NULL,
        STATE                  VARCHAR2(32)  NOT NULL,
        MSMT_HOST              VARCHAR2(32)  NOT NULL,
        MSMT_TIME              DATE     NOT NULL,
        SEQ_NO                 NUMBER(16)  NOT NULL,
	LOG_TIME               VARCHAR2(128) NOT NULL,
        USER_ADDRESS           VARCHAR2(128) NOT NULL,
	USER_LOGIN             VARCHAR2(128) NOT NULL,
        SITE_URL               VARCHAR2(4000) NOT NULL,
	REFERRER_URL           VARCHAR2(4000) NOT NULL,
	PAGE_LOAD_TIME         VARCHAR2(128) NOT NULL,
        MACHINE_NAME           VARCHAR2(128) NOT NULL,
        BROWSER                VARCHAR2(128) NOT NULL,
        REQUEST_COUNT          VARCHAR2(128) NOT NULL,
        QUERY_COUNT            VARCHAR2(128) NOT NULL,
        REQUEST_TYPE           VARCHAR2(128) NOT NULL,
        BYTES_CONSUMED         VARCHAR2(128) NOT NULL,
        HTTP_STATUS            VARCHAR2(128) NOT NULL,
        HITS_TO_THIS_URL       VARCHAR2(128) NOT NULL,
        HITS_FROM_THIS_URL     VARCHAR2(128) NOT NULL,
        USER_AGENT_STRING      VARCHAR2(512) NOT NULL,
        HITS_FROM_THIS_BROWSER VARCHAR2(128) NOT NULL,
	Web_url                VARCHAR2(4000) NOT NULL
    );
ALTER TABLE SPSITEANALYTICTEST_DDD ADD CONSTRAINT PK_SPSITEANALYTICTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPSITEANALYTICTEST_DDD ON SPSITEANALYTICTEST_DDD
(
MSMT_TIME
);

DROP TABLE SPBROWSEANALYTICTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPBROWSEANALYTICTEST_DDD (
        SITE_NAME              VARCHAR2(64)  NOT NULL,
        TRGT_HOST              VARCHAR2(32)  NOT NULL,
        PORT_NO                VARCHAR2(32)  NOT NULL,
        TEST_NAME              VARCHAR2(64)  NOT NULL,
        MEASURE                VARCHAR2(64)  NOT NULL,
        INFO                   VARCHAR2(128) NOT NULL,
        STATE                  VARCHAR2(32)  NOT NULL,
        MSMT_HOST              VARCHAR2(32)  NOT NULL,
        MSMT_TIME              DATE     NOT NULL,
        SEQ_NO                 NUMBER(16)  NOT NULL,
	LOG_TIME               VARCHAR2(128) NOT NULL,
        USER_ADDRESS           VARCHAR2(128) NOT NULL,
	USER_LOGIN             VARCHAR2(128) NOT NULL,
        SITE_URL               VARCHAR2(4000) NOT NULL,
	REFERRER_URL           VARCHAR2(4000) NOT NULL,
	PAGE_LOAD_TIME         VARCHAR2(128) NOT NULL,
        MACHINE_NAME           VARCHAR2(128) NOT NULL,
        BROWSER                VARCHAR2(128) NOT NULL,
        REQUEST_COUNT          VARCHAR2(128) NOT NULL,
        QUERY_COUNT            VARCHAR2(128) NOT NULL,
        REQUEST_TYPE           VARCHAR2(128) NOT NULL,
        BYTES_CONSUMED         VARCHAR2(128) NOT NULL,
        HTTP_STATUS            VARCHAR2(128) NOT NULL,
        HITS_TO_THIS_URL       VARCHAR2(128) NOT NULL,
        HITS_FROM_THIS_URL     VARCHAR2(128) NOT NULL
    );
ALTER TABLE SPBROWSEANALYTICTEST_DDD ADD CONSTRAINT PK_SPBROWSEANALYTICTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPBROWSEANALYTICTEST_DDD ON SPBROWSEANALYTICTEST_DDD
(
MSMT_TIME
);

DROP TABLE SPDCTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPDCTEST_DDD (
        SITE_NAME    VARCHAR2(64)  NOT NULL,
        TRGT_HOST    VARCHAR2(32)  NOT NULL,
        PORT_NO      VARCHAR2(32)  NOT NULL,
        TEST_NAME    VARCHAR2(64)  NOT NULL,
        MEASURE      VARCHAR2(64)  NOT NULL,
        INFO         VARCHAR2(128) NOT NULL,
        STATE        VARCHAR2(32)  NOT NULL,
        MSMT_HOST    VARCHAR2(32)  NOT NULL,
        MSMT_TIME    DATE     NOT NULL,
        SEQ_NO       NUMBER(16)  NOT NULL,
	USERADDRESS  VARCHAR2(128) NOT NULL,
        SITE_ADDRESS VARCHAR2(4000) NOT NULL,
        BROWSER      VARCHAR2(128) NOT NULL,
        USERAGENT    VARCHAR2(512) NOT NULL      
    );
ALTER TABLE SPDCTEST_DDD ADD CONSTRAINT PK_SPDCTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPDCTEST_DDD ON SPDCTEST_DDD
(
MSMT_TIME
);

DROP TABLE SPTIMERJOBTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPTIMERJOBTEST_DDD (
        SITE_NAME            varchar2(64)  NOT NULL,
        TRGT_HOST            varchar2(32)  NOT NULL,
        PORT_NO              varchar2(32)  NOT NULL,
        TEST_NAME            varchar2(64)  NOT NULL,
        MEASURE              varchar2(64)  NOT NULL,
        INFO                 varchar2(128) NOT NULL,
        STATE                varchar2(32)  NOT NULL,
        MSMT_HOST            varchar2(32)  NOT NULL,
        MSMT_TIME            date          NOT NULL,
        SEQ_NO               number(16)    NOT NULL,
        JOB_DEFINITION_TITLE varchar2(300) NOT NULL,
        SERVER_NAME          varchar2(128) NOT NULL,
        START_INFO           varchar2(128) NOT NULL,
        END_INFO             varchar2(128) NOT NULL

    );

ALTER TABLE SPTIMERJOBTEST_DDD ADD CONSTRAINT PK_SPTIMERJOBTEST_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPTIMERJOBTEST_DDD ON SPTIMERJOBTEST_DDD
(
MSMT_TIME
);

DROP TABLE SPUserAnalyticTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SPUserAnalyticTest_DDD (
        SITE_NAME              VARCHAR2(64)  NOT NULL,
        TRGT_HOST              VARCHAR2(32)  NOT NULL,
        PORT_NO                VARCHAR2(32)  NOT NULL,
        TEST_NAME              VARCHAR2(64)  NOT NULL,
        MEASURE                VARCHAR2(64)  NOT NULL,
        INFO                   VARCHAR2(128) NOT NULL,
        STATE                  VARCHAR2(32)  NOT NULL,
        MSMT_HOST              VARCHAR2(32)  NOT NULL,
        MSMT_TIME              DATE     NOT NULL,
        SEQ_NO                 NUMBER(16)  NOT NULL,
	LOG_TIME               VARCHAR2(128) NOT NULL,
        USER_ADDRESS           VARCHAR2(128) NOT NULL,
	USER_LOGIN             VARCHAR2(128) NOT NULL,
        SITE_URL               VARCHAR2(4000) NOT NULL,
	REFERRER_URL           VARCHAR2(4000) NOT NULL,
	PAGE_LOAD_TIME         VARCHAR2(128) NOT NULL,
        MACHINE_NAME           VARCHAR2(128) NOT NULL,
        BROWSER                VARCHAR2(128) NOT NULL,
        REQUEST_COUNT          VARCHAR2(128) NOT NULL,
        QUERY_COUNT            VARCHAR2(128) NOT NULL,
        REQUEST_TYPE           VARCHAR2(128) NOT NULL,
        BYTES_CONSUMED         VARCHAR2(128) NOT NULL,
        HTTP_STATUS            VARCHAR2(128) NOT NULL,
        HITS_TO_THIS_URL       VARCHAR2(128) NOT NULL,
        HITS_FROM_THIS_URL     VARCHAR2(128) NOT NULL,
        USER_AGENT_STRING      VARCHAR2(512) NOT NULL,
        HITS_FROM_THIS_BROWSER VARCHAR2(128) NOT NULL
    );
ALTER TABLE SPUserAnalyticTest_DDD ADD CONSTRAINT PK_SPUserAnalyticTest_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);

CREATE INDEX IDX_SPUserAnalyticTest_DDD ON SPUserAnalyticTest_DDD
(
MSMT_TIME
);

DROP TABLE HrznLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HrznLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Session_id	VARCHAR2(128) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	logout_time	VARCHAR2(128) NOT NULL,
	Duration	VARCHAR2(128) NOT NULL,
	User_SID	VARCHAR2(128) NOT NULL,
	Client_ip	VARCHAR2(128) NOT NULL
);
ALTER TABLE HrznLoginTest_DDD ADD constraint Pk_HrznLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznLoginTest_DDD ON HrznLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HrznAppLaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HrznAppLaunchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Session_id	VARCHAR2(128) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Launch_time	VARCHAR2(128) NOT NULL,
	Machine_id	VARCHAR2(128) NOT NULL,
	Server_add	VARCHAR2(128) NOT NULL,
	Server_port	VARCHAR2(128) NOT NULL,
	Ser_protocol	VARCHAR2(128) NOT NULL,
	Client_ip	VARCHAR2(128) NOT NULL
);
ALTER TABLE HrznAppLaunchTest_DDD ADD constraint Pk_HrznAppLaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznAppLaunchTest_DDD ON HrznAppLaunchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HrznDesktopTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HrznDesktopTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Session_id	VARCHAR2(128) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Launch_time	VARCHAR2(128) NOT NULL,
	Machine_id	VARCHAR2(128) NOT NULL,
	Server_add	VARCHAR2(128) NOT NULL,
	Server_port	VARCHAR2(128) NOT NULL,
	Ser_protocol	VARCHAR2(128) NOT NULL,
	Client_ip	VARCHAR2(128) NOT NULL
);
ALTER TABLE HrznDesktopTest_DDD ADD constraint Pk_HrznDesktopTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznDesktopTest_DDD ON HrznDesktopTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UserLogOnDetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UserLogOnDetTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(2000) NOT NULL,
	CSE_name	VARCHAR2(2000) NOT NULL,
	CSE_time 	VARCHAR2(2000) NOT NULL,
	CSE_id		VARCHAR2(2000) NOT NULL,
	Net_trim 	VARCHAR2(2000) NOT NULL,
	User_trim	VARCHAR2(2000) NOT NULL,
	GP_trim 	VARCHAR2(2000) NOT NULL,
	GPS_trim	VARCHAR2(2000) NOT NULL,
	Preshell_trim 	VARCHAR2(2000) NOT NULL,
	Shell_trim 	VARCHAR2(2000) NOT NULL,
	CSE_disp_name	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  UserLogOnDetTest_DDD ADD constraint Pk_UserLogOnDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UserLogOnDetTest_DDD ON UserLogOnDetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SybSpinContnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SybSpinContnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SPINLOCKSLOTID 	VARCHAR2(32) NOT NULL,
	OWNERPID	VARCHAR2(32) NOT NULL,
	LASTOWNERPID	VARCHAR2(32) NOT NULL,
	SPID		VARCHAR2(32) NOT NULL,
	LOGIN_NAME	VARCHAR2(64) NOT NULL,
	STATUS		VARCHAR2(32) NOT NULL,
	HOST_NAME	VARCHAR2(64) NOT NULL,
	PROGRAM_NAME	VARCHAR2(64) NOT NULL,
	COMMAND		VARCHAR2(64) NOT NULL
);
ALTER TABLE  SybSpinContnTest_DDD ADD constraint Pk_SybSpinContnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SybSpinContnTest_DDD ON SybSpinContnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MongoUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MongoUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE 	VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION		NUMBER(20,4) NOT NULL,
	MAINTENANCE		VARCHAR2(32) NOT NULL
);
ALTER TABLE  MongoUptimeTest_DDD ADD constraint Pk_MongoUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MongoUptimeTest_DDD ON MongoUptimeTest_DDD
(
               MSMT_TIME
);

DROP TABLE MongoTopCollTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MongoTopCollTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	COLLECTION_NAME	VARCHAR2(32) NOT NULL,
	READ_LOCK_TIME 	VARCHAR2(32) NOT NULL,
	READ_LOCKS_COUNT VARCHAR2(32) NOT NULL,
	WRITE_LOCK_TIME VARCHAR2(32) NOT NULL,
	WRITE_LOCKS_COUNT VARCHAR2(32) NOT NULL,
	QUERY_TIME	VARCHAR2(32) NOT NULL,
	QUERY_COUNT	VARCHAR2(32) NOT NULL,
	GETMORE_TIME	VARCHAR2(32) NOT NULL,
	GETMORE_COUNT	VARCHAR2(32) NOT NULL,
	INSERT_TIME	VARCHAR2(32) NOT NULL,
	INSERT_COUNT	VARCHAR2(32) NOT NULL,
	UPDATE_TIME	VARCHAR2(32) NOT NULL,
	UPDATE_COUNT	VARCHAR2(32) NOT NULL,
	DELETE_TIME	VARCHAR2(32) NOT NULL,
	DELETE_COUNT	VARCHAR2(32) NOT NULL,
	COMMAND_TIME	VARCHAR2(32) NOT NULL,
	COMMAND_COUNT	VARCHAR2(32) NOT NULL,
	EXECUTION_RATE VARCHAR2(32) NOT NULL
);
ALTER TABLE  MongoTopCollTest_DDD ADD constraint Pk_MongoTopCollTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MongoTopCollTest_DDD ON MongoTopCollTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MongoLargeCollTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MongoLargeCollTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	COLLECTION_NAME	VARCHAR2(32) NOT NULL,
	OBJECT_COUNT 	VARCHAR2(32) NOT NULL,
	DATA_SIZE	VARCHAR2(32) NOT NULL,
	AVG_OBJECT_SIZE VARCHAR2(32) NOT NULL,
	STORAGE_SIZE	VARCHAR2(32) NOT NULL,
	INDEX_COUNT	VARCHAR2(32) NOT NULL,
	LAST_EXTEND_SIZE VARCHAR2(32) NOT NULL,
	TOTAL_INDEX_SIZE VARCHAR2(32) NOT NULL
);
ALTER TABLE  MongoLargeCollTest_DDD ADD constraint Pk_MongoLargeCollTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MongoLargeCollTest_DDD ON MongoLargeCollTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MongoRepStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MongoRepStatusTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	PREVIOUS_NODE			VARCHAR2(32) NOT NULL,
	CURRENT_NODE			VARCHAR2(32) NOT NULL,
	CURRENT_NODE_START_TIME		VARCHAR2(32) NOT NULL
);
ALTER TABLE  MongoRepStatusTest_DDD ADD constraint Pk_MongoRepStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MongoRepStatusTest_DDD ON MongoRepStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgCtxXcXAEuemTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VmgCtxXcXAEuemTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Username	VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(2000) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Launch_type		VARCHAR2(128) NOT NULL,
	C_session_lookup	VARCHAR2(128) NOT NULL,
	C_session_creation	VARCHAR2(128) NOT NULL,
	S_session_creation_start VARCHAR2(128) NOT NULL,
	S_session_creation_end	VARCHAR2(128) NOT NULL,
	Session_key		VARCHAR2(128) NOT NULL,
	CSE_extension_name	VARCHAR2(128) NOT NULL,
	CSE_elapsed_time	VARCHAR2(128) NOT NULL,
	CSE_status			VARCHAR2(128) NOT NULL,
	CSE_extension_id		VARCHAR2(2000) NOT NULL,
	CSE_error_code		VARCHAR2(128) NOT NULL
);

ALTER TABLE  VmgCtxXcXAEuemTest_DDD ADD constraint Pk_VmgCtxXcXAEuemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgCtxXcXAEuemTest_DDD ON VmgCtxXcXAEuemTest_DDD
(
 	MSMT_TIME
);


DROP TABLE AWSAmazonEBSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSAmazonEBSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Volume_Type	VARCHAR2(2000) NOT NULL,
	Creation_Time	VARCHAR2(2000) NOT NULL,
	Availability_Zone	VARCHAR2(2000) NOT NULL
);

ALTER TABLE AWSAmazonEBSTest_DDD ADD constraint Pk_AWSAmazonEBSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSAmazonEBSTest_DDD ON AWSAmazonEBSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSAmazonEC2Test_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSAmazonEC2Test_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Volume_ID	VARCHAR2(256) NOT NULL,
	Vol_Region	VARCHAR2(128) NOT NULL
);

ALTER TABLE AWSAmazonEC2Test_DDD ADD constraint Pk_AWSAmazonEC2Test_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSAmazonEC2Test_DDD ON AWSAmazonEC2Test_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSRegionEBSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSRegionEBSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Volume_Type	VARCHAR2(2000) NOT NULL,
	Creation_Time	VARCHAR2(2000) NOT NULL,
	Availability_Zone	VARCHAR2(2000) NOT NULL
);

ALTER TABLE AWSRegionEBSTest_DDD ADD constraint Pk_AWSRegionEBSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSRegionEBSTest_DDD ON AWSRegionEBSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSRegionEC2Test_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSRegionEC2Test_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	total_volume	VARCHAR2(2000) NOT NULL
);

ALTER TABLE AWSRegionEC2Test_DDD ADD constraint Pk_AWSRegionEC2Test_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSRegionEC2Test_DDD ON AWSRegionEC2Test_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSServiceUsgTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSServiceUsgTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	s3_create	VARCHAR2(128) NOT NULL
);

ALTER TABLE AWSServiceUsgTest_DDD ADD constraint Pk_AWSServiceUsgTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSServiceUsgTest_DDD ON AWSServiceUsgTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSRegionUsgTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSRegionUsgTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Name	VARCHAR2(128) NOT NULL
);

ALTER TABLE AWSRegionUsgTest_DDD ADD constraint Pk_AWSRegionUsgTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSRegionUsgTest_DDD ON AWSRegionUsgTest_DDD
(
 	MSMT_TIME
);


DROP TABLE STRMPROCESSEVENTTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  STRMPROCESSEVENTTEST_DDD 
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_INFO 	VARCHAR2(32) NOT NULL,
	DEVICE_NAME  	VARCHAR2(32) NOT NULL,
	TARGET_IP  	VARCHAR2(32) NOT NULL,
	TARGET_PORT 	VARCHAR2(32) NOT NULL,
	BOOT_TIME 	VARCHAR2(32) NOT NULL,
	IP 		VARCHAR2(32) NOT NULL,
	PORT 		VARCHAR2(32) NOT NULL
	
);

ALTER TABLE  STRMPROCESSEVENTTEST_DDD ADD CONSTRAINT PK_STRMPROCESSEVENTTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_STRMPROCESSEVENTTEST_DDD ON STRMPROCESSEVENTTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE SPERRORTEST_DDD CASCADE CONSTRAINTS;

CREATE TABLE  SPERRORTEST_DDD 
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_INFO  	VARCHAR2(32) NOT NULL,
	ERROR_DESC 	VARCHAR2(2000) NOT NULL
		
);

ALTER TABLE  SPERRORTEST_DDD ADD CONSTRAINT PK_SPERRORTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SPERRORTEST_DDD ON SPERRORTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE SPWebPartsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SPWebPartsTest_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	Correlation_ID		VARCHAR2(256) NOT NULL,
	ScopeID			VARCHAR2(256) NOT NULL,
	Start_Time		VARCHAR2(4000) NOT NULL,
	End_Time		VARCHAR2(4000) NOT NULL,
	Managed_Memory		VARCHAR2(256) NOT NULL,
	Username		VARCHAR2(256) NOT NULL,
	Page_Checkout_level	VARCHAR2(256) NOT NULL,
	Server_Name		VARCHAR2(256) NOT NULL,
	Client_Address		VARCHAR2(256) NOT NULL,
	Name			VARCHAR2(256) NOT NULL,
	Count                   VARCHAR2(256) NOT NULL,
	Duration		VARCHAR2(256) NOT NULL,
	Reads			VARCHAR2(256) NOT NULL,
	Writes			VARCHAR2(256) NOT NULL,
	SQL_CPU			VARCHAR2(256) NOT NULL,
	SQL_Duration		VARCHAR2(256) NOT NULL,
	SPRequests_URL		VARCHAR2(256) NOT NULL,
	Service_Call_URL	VARCHAR2(256) NOT NULL
);
ALTER TABLE  SPWebPartsTest_DDD ADD constraint Pk_SPWebPartsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPWebPartsTest_DDD ON SPWebPartsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SPWebPartOpenTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SPWebPartOpenTest_DDD
(
	SITE_NAME  		varchar2(64) NOT NULL,
	TRGT_HOST    		varchar2(32) NOT NULL,
	PORT_NO      		varchar2(32) NOT NULL,
	TEST_NAME    		varchar2(64) NOT NULL,
	MEASURE      		varchar2(64) NOT NULL,
	INFO         		varchar2(128) NOT NULL,
	STATE        		varchar2(32) NOT NULL,
	MSMT_HOST    		varchar2(32) NOT NULL,
	MSMT_TIME    		date NOT NULL,
	SEQ_NO 			number(16) NOT NULL,
	Site_URL		varchar2(256) NOT NULL,
	DisplayTitle		varchar2(256) NOT NULL,
	Type			varchar2(256) NOT NULL
);

ALTER TABLE  SPWebPartOpenTest_DDD ADD constraint Pk_SPWebPartOpenTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPWebPartOpenTest_DDD ON SPWebPartOpenTest_DDD
(
 	MSMT_TIME
);



DROP TABLE CrashEventTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CrashEventTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	appName	VARCHAR2(2000) NOT NULL,
	appVersion	VARCHAR2(128) NOT NULL,
	modName	VARCHAR2(128) NOT NULL,
	modVersion	VARCHAR2(128) NOT NULL,
	code	VARCHAR2(128) NOT NULL,
	ID	VARCHAR2(128) NOT NULL,
	appPath	VARCHAR2(2000) NOT NULL,
	modPath	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  CrashEventTest_DDD ADD constraint Pk_CrashEventTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CrashEventTest_DDD ON CrashEventTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VmgCrashEventTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  VmgCrashEventTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	appName	VARCHAR2(2000) NOT NULL,
	appVersion	VARCHAR2(128) NOT NULL,
	modName	VARCHAR2(128) NOT NULL,
	modVersion	VARCHAR2(128) NOT NULL,
	code	VARCHAR2(128) NOT NULL,
	ID	VARCHAR2(128) NOT NULL,
	appPath	VARCHAR2(2000) NOT NULL,
	modPath	VARCHAR2(2000) NOT NULL
);

ALTER TABLE  VmgCrashEventTest_DDD ADD constraint Pk_VmgCrashEventTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgCrashEventTest_DDD ON VmgCrashEventTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AFHDXLOGINSTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFHDXLOGINSTEST_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	USER_NAME		VARCHAR2(128) NOT NULL,
	SESSION_GUID		VARCHAR2(128) NOT NULL,
	CLIENT_ADDRESS		VARCHAR2(128) NOT NULL,
	DESTINATION_ADDRESS	VARCHAR2(128) NOT NULL,
	SESSION_START_TIME	VARCHAR2(128) NOT NULL,
	SESSION_END_TIME	VARCHAR2(128) NOT NULL,
	UP_TIME			VARCHAR2(128) NOT NULL,
	WAN_LATENCY		VARCHAR2(128) NOT NULL,
	DC_LATENCY		VARCHAR2(128) NOT NULL,
	RTT			VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL,
	CLIENT_TYPE		VARCHAR2(128) NOT NULL,
	CLIENT_VERSION		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFHDXLOGINSTEST_DDD ADD CONSTRAINT PK_AFHDXLOGINSTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFHDXLOGINSTEST_DDD ON AFHDXLOGINSTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE AFHDXUsersTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFHDXUsersTest_DDD
(
	SITE_NAME  	 		VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 		VARCHAR2(32) NOT NULL,
	PORT_NO      	 		VARCHAR2(32) NOT NULL,
	TEST_NAME    	 		VARCHAR2(64) NOT NULL,
	MEASURE      	 		VARCHAR2(64) NOT NULL,
	INFO         	 		VARCHAR2(128) NOT NULL,
	STATE        	 		VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 		VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 		DATE NOT NULL,
	SEQ_NO 		 		NUMBER(16) NOT NULL,
	application_Name		VARCHAR2(128) NOT NULL,
	application_Process_Id		VARCHAR2(128) NOT NULL,
	application_startup_time	VARCHAR2(128) NOT NULL,
	application_startup_duration	VARCHAR2(128) NOT NULL,
	application_termination_time	VARCHAR2(128) NOT NULL,
	application_used_duration	VARCHAR2(128) NOT NULL,
	session_guid			VARCHAR2(128) NOT NULL,
	connection_Id			VARCHAR2(128) NOT NULL,
	Session_type			VARCHAR2(128) NOT NULL,
	source_Address			VARCHAR2(128) NOT NULL,
	destination_Address		VARCHAR2(128) NOT NULL,
	client_type			VARCHAR2(128) NOT NULL,
	client_Version			VARCHAR2(128) NOT NULL,
	domain				VARCHAR2(128) NOT NULL,
	VDI_Image_Name			VARCHAR2(128) NOT NULL,
	Desktop_startup_time		VARCHAR2(128) NOT NULL,
	up_time				VARCHAR2(128) NOT NULL,
	application_module_path		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFHDXUsersTest_DDD ADD CONSTRAINT PK_AFHDXUsersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFHDXUsersTest_DDD ON AFHDXUsersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AFHDXActUsersTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFHDXActUsersTest_DDD
(
	SITE_NAME  	 		VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 		VARCHAR2(32) NOT NULL,
	PORT_NO      	 		VARCHAR2(32) NOT NULL,
	TEST_NAME    	 		VARCHAR2(64) NOT NULL,
	MEASURE      	 		VARCHAR2(64) NOT NULL,
	INFO         	 		VARCHAR2(128) NOT NULL,
	STATE        	 		VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 		VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 		DATE NOT NULL,
	SEQ_NO 		 		NUMBER(16) NOT NULL,
	application_Name		VARCHAR2(128) NOT NULL,
	application_Process_Id		VARCHAR2(128) NOT NULL,
	application_startup_time	VARCHAR2(128) NOT NULL,
	application_termination_time	VARCHAR2(128) NOT NULL,
	application_used_duration	VARCHAR2(128) NOT NULL,
	application_startup_duration	VARCHAR2(128) NOT NULL,
	user_name			VARCHAR2(128) NOT NULL,
	session_guid			VARCHAR2(128) NOT NULL,
	connection_Id			VARCHAR2(128) NOT NULL,
	Session_type			VARCHAR2(128) NOT NULL,
	VDI_Image_Name			VARCHAR2(128) NOT NULL,
	client_ip_Address		VARCHAR2(128) NOT NULL,
	server_ip_Address		VARCHAR2(128) NOT NULL,
	start_time			VARCHAR2(128) NOT NULL,
	up_time				VARCHAR2(128) NOT NULL,
	application_module_path		VARCHAR2(128) NOT NULL,
	client_type			VARCHAR2(128) NOT NULL,
	client_Version			VARCHAR2(128) NOT NULL,
	domain				VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFHDXActUsersTest_DDD ADD CONSTRAINT PK_AFHDXActUsersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFHDXActUsersTest_DDD ON AFHDXActUsersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AFHDXAppsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFHDXAppsTest_DDD
(
	SITE_NAME  	 		VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 		VARCHAR2(32) NOT NULL,
	PORT_NO      	 		VARCHAR2(32) NOT NULL,
	TEST_NAME    	 		VARCHAR2(64) NOT NULL,
	MEASURE      	 		VARCHAR2(64) NOT NULL,
	INFO         	 		VARCHAR2(128) NOT NULL,
	STATE        	 		VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 		VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 		DATE NOT NULL,
	SEQ_NO 		 		NUMBER(16) NOT NULL,
	user_name			VARCHAR2(128) NOT NULL,
	session_guid			VARCHAR2(128) NOT NULL,
	connection_Id			VARCHAR2(128) NOT NULL,
	application_process_id		VARCHAR2(128) NOT NULL,
	client_address			VARCHAR2(128) NOT NULL,
	server_address			VARCHAR2(128) NOT NULL,
	start_time			VARCHAR2(128) NOT NULL,
	up_time				VARCHAR2(128) NOT NULL,
	client_Version			VARCHAR2(128) NOT NULL,
	Ica_Client_Type			VARCHAR2(128) NOT NULL,
	application_module_path		VARCHAR2(128) NOT NULL
	);

ALTER TABLE  AFHDXAppsTest_DDD ADD CONSTRAINT PK_AFHDXAppsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFHDXAppsTest_DDD ON AFHDXAppsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AFHDXDsktpLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFHDXDsktpLoginTest_DDD
(
	SITE_NAME  	 	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 	VARCHAR2(32) NOT NULL,
	PORT_NO      	 	VARCHAR2(32) NOT NULL,
	TEST_NAME    	 	VARCHAR2(64) NOT NULL,
	MEASURE      	 	VARCHAR2(64) NOT NULL,
	INFO         	 	VARCHAR2(128) NOT NULL,
	STATE        	 	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 	DATE NOT NULL,
	SEQ_NO 		 	NUMBER(16) NOT NULL,
	user_name		VARCHAR2(128) NOT NULL,
	session_guid		VARCHAR2(128) NOT NULL,
	client_address		VARCHAR2(128) NOT NULL,
	destination_address	VARCHAR2(128) NOT NULL,
	session_start_time	VARCHAR2(128) NOT NULL,
	session_end_time	VARCHAR2(128) NOT NULL,
	session_duration	VARCHAR2(128) NOT NULL,
	WAN_latency		VARCHAR2(128) NOT NULL,
	DC_latency		VARCHAR2(128) NOT NULL,
	RTT			VARCHAR2(128) NOT NULL,
	bandwidth		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFHDXDsktpLoginTest_DDD ADD CONSTRAINT PK_AFHDXDsktpLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFHDXDsktpLoginTest_DDD ON AFHDXDsktpLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AFHDXDsktpUsersTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFHDXDsktpUsersTest_DDD
(
	SITE_NAME  	 	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 	VARCHAR2(32) NOT NULL,
	PORT_NO      	 	VARCHAR2(32) NOT NULL,
	TEST_NAME    	 	VARCHAR2(64) NOT NULL,
	MEASURE      	 	VARCHAR2(64) NOT NULL,
	INFO         	 	VARCHAR2(128) NOT NULL,
	STATE        	 	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 	DATE NOT NULL,
	SEQ_NO 		 	NUMBER(16) NOT NULL,
	VDI_Image_Name		VARCHAR2(128) NOT NULL,
	session_guid		VARCHAR2(128) NOT NULL,
	connection_Id		VARCHAR2(128) NOT NULL,
	source_Address		VARCHAR2(128) NOT NULL,
	destination_Address	VARCHAR2(128) NOT NULL,
	Desktop_startup_time	VARCHAR2(128) NOT NULL,
	up_time			VARCHAR2(128) NOT NULL,
	client_type		VARCHAR2(128) NOT NULL,
	client_Version		VARCHAR2(128) NOT NULL,
	domain			VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFHDXDsktpUsersTest_DDD ADD CONSTRAINT PK_AFHDXDsktpUsersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFHDXDsktpUsersTest_DDD ON AFHDXDsktpUsersTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AFHDXActDsktpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFHDXActDsktpTest_DDD
(
	SITE_NAME  	 	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 	VARCHAR2(32) NOT NULL,
	PORT_NO      	 	VARCHAR2(32) NOT NULL,
	TEST_NAME    	 	VARCHAR2(64) NOT NULL,
	MEASURE      	 	VARCHAR2(64) NOT NULL,
	INFO         	 	VARCHAR2(128) NOT NULL,
	STATE        	 	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 	DATE NOT NULL,
	SEQ_NO 		 	NUMBER(16) NOT NULL,
	user_name		VARCHAR2(128) NOT NULL,
	VDI_Image_Name		VARCHAR2(128) NOT NULL,
	session_guid		VARCHAR2(128) NOT NULL,
	connection_Id		VARCHAR2(128) NOT NULL,
	source_Address		VARCHAR2(128) NOT NULL,
	destination_Address	VARCHAR2(128) NOT NULL,
	Desktop_startup_time	VARCHAR2(128) NOT NULL,
	session_duration	VARCHAR2(128) NOT NULL,
	client_Version		VARCHAR2(128) NOT NULL,
	domain			VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFHDXActDsktpTest_DDD ADD CONSTRAINT PK_AFHDXActDsktpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFHDXActDsktpTest_DDD ON AFHDXActDsktpTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AppPoolWorkerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AppPoolWorkerTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID	 	VARCHAR2(32) NOT NULL,
	CPU		VARCHAR2(128) NOT NULL,
	Context_switch	VARCHAR2(128) NOT NULL,
	Thread_ID	VARCHAR2(64) NOT NULL,
	Thread_state	VARCHAR2(128) NOT NULL,
	Reason		VARCHAR2(2000) NOT NULL,
	Url		VARCHAR2(2000) NOT NULL,
	Verb		VARCHAR2(2000) NOT NULL,
	AppPoolState	VARCHAR2(128) NOT NULL,
	Stage		VARCHAR2(2000) NOT NULL,
	Module_name	VARCHAR2(2000) NOT NULL,
	Time_elasped	VARCHAR2(128) NOT NULL,
	Client		VARCHAR2(128) NOT NULL,
	Websites	VARCHAR2(2000) NOT NULL,
	Worker_process_id	VARCHAR2(64) NOT NULL,
	Memory		VARCHAR2(128) NOT NULL,
	Threads		VARCHAR2(128) NOT NULL,
	Handles		VARCHAR2(128) NOT NULL,
	Page_faults	VARCHAR2(128) NOT NULL,
	Private_data	VARCHAR2(128) NOT NULL,
	Pool_paged	VARCHAR2(128) NOT NULL,
	Pool_non_paged	VARCHAR2(128) NOT NULL,
	IO_reads	VARCHAR2(128) NOT NULL,
	IO_read_ops	VARCHAR2(128) NOT NULL,
	IO_writes	VARCHAR2(128) NOT NULL,
	IO_write_ops	VARCHAR2(128) NOT NULL,
	Command_line	VARCHAR2(2000) NOT NULL,
	Stopped_app_pool	VARCHAR2(2000) NOT NULL
);

ALTER TABLE AppPoolWorkerTest_DDD ADD constraint Pk_AppPoolWorkerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE WinSystemTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE WinSystemTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Process_Name 	VARCHAR2(2000) NOT NULL,
	Process_Count	NUMBER(16) NOT NULL
);

ALTER TABLE WinSystemTest_DDD ADD constraint Pk_WinSystemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE TcpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TcpTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Foreign_Address		VARCHAR2(128) NOT NULL,
	noOfCurrentConn		NUMBER(16) NOT NULL
);

ALTER TABLE TcpTest_DDD ADD constraint Pk_TcpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE PVSFarmTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE PVSFarmTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Server_name	VARCHAR2(128) NOT NULL,
	Server_ip	VARCHAR2(128) NOT NULL,
	Server_Status	VARCHAR2(128) NOT NULL
);

ALTER TABLE PVSFarmTest_DDD ADD constraint Pk_PVSFarmTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE PVSServersTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE PVSServersTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Target_device	VARCHAR2(128) NOT NULL,
	vDisk		VARCHAR2(128) NOT NULL,
	Target_ip	VARCHAR2(128) NOT NULL,
	Server_ip	VARCHAR2(128) NOT NULL,
	Server_port	VARCHAR2(128) NOT NULL,
	Retries		VARCHAR2(128) NOT NULL
);

ALTER TABLE PVSServersTest_DDD ADD constraint Pk_PVSServersTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE PVSSitesTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE PVSSitesTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Server_name	VARCHAR2(128) NOT NULL,
	Server_ip	VARCHAR2(128) NOT NULL
);

ALTER TABLE PVSSitesTest_DDD ADD constraint Pk_PVSSitesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE SANRAIDDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SANRAIDDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  SANRAIDDiskTest_DDD ADD constraint Pk_SANRAIDDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SANRAIDDiskTest_DDD ON SANRAIDDiskTest_DDD
(
	MSMT_TIME
);

DROP TABLE SANRAIDLUNTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SANRAIDLUNTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  SANRAIDLUNTest_DDD ADD constraint Pk_SANRAIDLUNTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SANRAIDLUNTest_DDD ON SANRAIDLUNTest_DDD
(
	MSMT_TIME
);

DROP TABLE SANRAIDILEDTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SANRAIDILEDTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	indicatedConditions		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  SANRAIDILEDTest_DDD ADD constraint Pk_SANRAIDILEDTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SANRAIDILEDTest_DDD ON SANRAIDILEDTest_DDD
(
	MSMT_TIME
);

DROP TABLE TPDDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TPDDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  TPDDiskTest_DDD ADD constraint Pk_TPDDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TPDDiskTest_DDD ON TPDDiskTest_DDD
(
	MSMT_TIME
);

DROP TABLE TPDLUNTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TPDLUNTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  TPDLUNTest_DDD ADD constraint Pk_TPDLUNTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TPDLUNTest_DDD ON TPDLUNTest_DDD
(
	MSMT_TIME
);

DROP TABLE DelCmplDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DelCmplDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  DelCmplDiskTest_DDD ADD constraint Pk_DelCmplDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_DelCmplDiskTest_DDD ON DelCmplDiskTest_DDD
(
	MSMT_TIME
);

DROP TABLE DelCmplLUNTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DelCmplLUNTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  DelCmplLUNTest_DDD ADD constraint Pk_DelCmplLUNTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_DelCmplLUNTest_DDD ON DelCmplLUNTest_DDD
(
	MSMT_TIME
);

DROP TABLE EMCRAIDDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EMCRAIDDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  EMCRAIDDiskTest_DDD ADD constraint Pk_EMCRAIDDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EMCRAIDDiskTest_DDD ON EMCRAIDDiskTest_DDD
(
	MSMT_TIME
);

DROP TABLE EMCRAIDLUNTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EMCRAIDLUNTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,	
	capacity		 VARCHAR2(32) NOT NULL
);
ALTER TABLE  EMCRAIDLUNTest_DDD ADD constraint Pk_EMCRAIDLUNTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EMCRAIDLUNTest_DDD ON EMCRAIDLUNTest_DDD
(
	MSMT_TIME
);

DROP TABLE EsxGuestTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EsxGuestTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_Name		VARCHAR2(256) NOT NULL,
	Configured_Memory	VARCHAR2(256) NOT NULL,
	Memory_Limit	VARCHAR2(256) NOT NULL
);

ALTER TABLE  EsxGuestTest_DDD ADD constraint Pk_EsxGuestTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EsxGuestTest_DDD ON EsxGuestTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TSLicenseUtilTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TSLicenseUtilTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	KeyPac_ID	VARCHAR2(256) NOT NULL,
	Licens_ID	VARCHAR2(256) NOT NULL,
	HW_ID	VARCHAR2(256) NOT NULL,
	Isued_To	VARCHAR2(256) NOT NULL,
	Isued_On	VARCHAR2(256) NOT NULL,
	Expire_On	VARCHAR2(256) NOT NULL,
	Stat	VARCHAR2(256) NOT NULL,
	Licens_Program	VARCHAR2(256) NOT NULL
);
ALTER TABLE  TSLicenseUtilTest_DDD ADD constraint Pk_TSLicenseUtilTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TSLicenseUtilTest_DDD ON TSLicenseUtilTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EsxStorageAdapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  EsxStorageAdapTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Storage_Path	VARCHAR2(256) NOT NULL,
	Esx_Statistics	VARCHAR2(256) NOT NULL,
	Path_Target	VARCHAR2(256) NOT NULL
);
ALTER TABLE  EsxStorageAdapTest_DDD ADD constraint Pk_EsxStorageAdapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_EsxStorageAdapTest_DDD ON EsxStorageAdapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmDataStoreTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VmDataStoreTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Virtual_disk	VARCHAR2(256) NOT NULL,
	Controller	VARCHAR2(256) NOT NULL
);
ALTER TABLE  VmDataStoreTest_DDD ADD constraint Pk_VmDataStoreTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VmDataStoreTest_DDD ON VmDataStoreTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ESKMPowerSupplyTrap_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ESKMPowerSupplyTrap_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,	
	TRAP_TIME	VARCHAR2(128) NOT NULL,	
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,	
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL	
);
ALTER TABLE  ESKMPowerSupplyTrap_DDD ADD constraint Pk_ESKMPowerSupplyTrap_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ESKMPowerSupplyTrap_DDD ON ESKMPowerSupplyTrap_DDD
(
 	MSMT_TIME
);

DROP TABLE ESKMFanTrap_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ESKMFanTrap_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  ESKMFanTrap_DDD ADD constraint Pk_ESKMFanTrap_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ESKMFanTrap_DDD ON ESKMFanTrap_DDD
(
 	MSMT_TIME
);

DROP TABLE ESKMDiskTrap_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ESKMDiskTrap_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  ESKMDiskTrap_DDD ADD constraint Pk_ESKMDiskTrap_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ESKMDiskTrap_DDD ON ESKMDiskTrap_DDD
(
 	MSMT_TIME
);

DROP TABLE NSAuthTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NSAuthTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	START_TIME	VARCHAR2(128) NOT NULL,
	USER_NAME	VARCHAR2(128) NOT NULL,
	CLIENT_IP	VARCHAR2(128) NOT NULL,
	FAILED_REASON   VARCHAR2(200) NOT NULL,
	BROWSER_TYPE 	VARCHAR2(200) NOT NULL
);

ALTER TABLE  NSAuthTest_DDD ADD CONSTRAINT PK_NSAuthTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NSAuthTest_DDD ON NSAuthTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_NSAuthTest_DDD ON NSAuthTest_DDD(MSMT_TIME);

DROP TABLE CtxNsSslCertTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsSslCertTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Certificate_File_Name	VARCHAR2(128) NOT NULL,
	Key_File_Name		VARCHAR2(128) NOT NULL,
	File_Format		VARCHAR2(128) NOT NULL,
	Notification_period	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxNsSslCertTest_DDD ADD constraint Pk_CtxNsSslCertTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsSslCertTest_DDD ON CtxNsSslCertTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SfInstanceTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SfInstanceTest_DDD
(
	SITE_NAME  			varchar2(64) NOT NULL,
	TRGT_HOST    			varchar2(32) NOT NULL,
	PORT_NO      			varchar2(32) NOT NULL,
	TEST_NAME    			varchar2(64) NOT NULL,
	MEASURE      			varchar2(64) NOT NULL,
	INFO         			varchar2(128) NOT NULL,
	STATE        			varchar2(32) NOT NULL,
	MSMT_HOST    			varchar2(32) NOT NULL,
	MSMT_TIME    			date NOT NULL,
	SEQ_NO 				Number(16) NOT NULL,
	Name				varchar2(128) NOT NULL,
	Maintenance_Start		varchar2(128) NOT NULL,
	Maintenance_End			varchar2(128) NOT NULL,
	Message				varchar2(2000) NOT NULL
);

ALTER TABLE  SfInstanceTest_DDD ADD CONSTRAINT PK_SfInstanceTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SfInstanceTest_DDD ON SfInstanceTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);
CREATE  INDEX IDX1_SfInstanceTest_DDD ON SfInstanceTest_DDD(MSMT_TIME);

DROP TABLE SfSchdJobTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SfSchdJobTest_DDD
(
	SITE_NAME  			varchar2(64) NOT NULL,
	TRGT_HOST    			varchar2(32) NOT NULL,
	PORT_NO      			varchar2(32) NOT NULL,
	TEST_NAME    			varchar2(64) NOT NULL,
	MEASURE      			varchar2(64) NOT NULL,
	INFO         			varchar2(128) NOT NULL,
	STATE        			varchar2(32) NOT NULL,
	MSMT_HOST    			varchar2(32) NOT NULL,
	MSMT_TIME    			date NOT NULL,
	SEQ_NO 				Number(16) NOT NULL,
	Created_By			varchar2(128) NOT NULL,
	Start_duartion			varchar2(128) NOT NULL,
	End_duartion			varchar2(128) NOT NULL,
	Next_Fire_duration		varchar2(2000) NOT NULL,
	Times_Triggered			varchar2(2000) NOT NULL,
	Time_Zone			varchar2(2000) NOT NULL
);

ALTER TABLE  SfSchdJobTest_DDD ADD CONSTRAINT PK_SfSchdJobTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_SfSchdJobTest_DDD ON SfSchdJobTest_DDD
(
 	MSMT_TIME,TRGT_HOST,PORT_NO
);

DROP TABLE Off365SvcStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  Off365SvcStatTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Incident_id	VARCHAR2(128) NOT NULL,
	Start_time	VARCHAR2(128) NOT NULL,
	Update_time	VARCHAR2(128) NOT NULL	
);
ALTER TABLE  Off365SvcStatTest_DDD ADD constraint Pk_Off365SvcStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_Off365SvcStatTest_DDD ON Off365SvcStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XenGPUOverviewTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE XenGPUOverviewTest_DDD 
(
	SITE_NAME VARCHAR2(64)  NOT NULL,
	TRGT_HOST VARCHAR2(32)  NOT NULL,
	PORT_NO   VARCHAR2(32)  NOT NULL,
	TEST_NAME VARCHAR2(64)  NOT NULL,
	MEASURE   VARCHAR2(64)  NOT NULL,
	INFO      VARCHAR2(128) NOT NULL,
	STATE     VARCHAR2(32)  NOT NULL,
	MSMT_HOST VARCHAR2(32)  NOT NULL,
	MSMT_TIME DATE          NOT NULL,
	SEQ_NO    NUMBER(16)    NOT NULL,
	Resolution VARCHAR2(128) NOT NULL
);

ALTER TABLE XenGPUOverviewTest_DDD ADD CONSTRAINT PK_XenGPUOverviewTest_DDD
PRIMARY KEY (SITE_NAME, TRGT_HOST, PORT_NO, TEST_NAME, MEASURE, INFO, MSMT_HOST, MSMT_TIME, SEQ_NO);
CREATE INDEX IDX_XenGPUOverviewTest_DDD ON XenGPUOverviewTest_DDD
(
	MSMT_TIME
);

DROP TABLE DropQueueTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE DropQueueTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Domains		VARCHAR2(128) NOT NULL,
	Total		VARCHAR2(128) NOT NULL,
	Less_than_5_min	VARCHAR2(128) NOT NULL,
	Bet_5_10_min	VARCHAR2(128) NOT NULL,
	Bet_10_20_min	VARCHAR2(128) NOT NULL,
	Bet_20_40_min	VARCHAR2(128) NOT NULL,
	Bet_40_80_min	VARCHAR2(128) NOT NULL,
	Bet_80_160_min	VARCHAR2(128) NOT NULL,
	Bet_160_320_min	VARCHAR2(128) NOT NULL,
	Bet_320_640_min	VARCHAR2(128) NOT NULL,
	Bet_640_1280_min	VARCHAR2(128) NOT NULL,
	Great_1280_min	VARCHAR2(128) NOT NULL
);
ALTER TABLE DropQueueTest_DDD ADD constraint Pk_DropQueueTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_DropQueueTest_DDD ON DropQueueTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HoldQueueTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HoldQueueTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Domains		VARCHAR2(128) NOT NULL,
	Total		VARCHAR2(128) NOT NULL,
	Less_than_5_min	VARCHAR2(128) NOT NULL,
	Bet_5_10_min	VARCHAR2(128) NOT NULL,
	Bet_10_20_min	VARCHAR2(128) NOT NULL,
	Bet_20_40_min	VARCHAR2(128) NOT NULL,
	Bet_40_80_min	VARCHAR2(128) NOT NULL,
	Bet_80_160_min	VARCHAR2(128) NOT NULL,
	Bet_160_320_min	VARCHAR2(128) NOT NULL,
	Bet_320_640_min	VARCHAR2(128) NOT NULL,
	Bet_640_1280_min	VARCHAR2(128) NOT NULL,
	Great_1280_min	VARCHAR2(128) NOT NULL
);
ALTER TABLE HoldQueueTest_DDD ADD constraint Pk_HoldQueueTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HoldQueueTest_DDD ON HoldQueueTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IncomingQueueTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IncomingQueueTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Domains		VARCHAR2(128) NOT NULL,
	Total		VARCHAR2(128) NOT NULL,
	Less_than_5_min	VARCHAR2(128) NOT NULL,
	Bet_5_10_min	VARCHAR2(128) NOT NULL,
	Bet_10_20_min	VARCHAR2(128) NOT NULL,
	Bet_20_40_min	VARCHAR2(128) NOT NULL,
	Bet_40_80_min	VARCHAR2(128) NOT NULL,
	Bet_80_160_min	VARCHAR2(128) NOT NULL,
	Bet_160_320_min	VARCHAR2(128) NOT NULL,
	Bet_320_640_min	VARCHAR2(128) NOT NULL,
	Bet_640_1280_min	VARCHAR2(128) NOT NULL,
	Great_1280_min	VARCHAR2(128) NOT NULL
);
ALTER TABLE IncomingQueueTest_DDD ADD constraint Pk_IncomingQueueTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IncomingQueueTest_DDD ON IncomingQueueTest_DDD
(
 	MSMT_TIME
);


DROP TABLE ActiveQueueTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE ActiveQueueTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Domains		VARCHAR2(128) NOT NULL,
	Total		VARCHAR2(128) NOT NULL,
	Less_than_5_min	VARCHAR2(128) NOT NULL,
	Bet_5_10_min	VARCHAR2(128) NOT NULL,
	Bet_10_20_min	VARCHAR2(128) NOT NULL,
	Bet_20_40_min	VARCHAR2(128) NOT NULL,
	Bet_40_80_min	VARCHAR2(128) NOT NULL,
	Bet_80_160_min	VARCHAR2(128) NOT NULL,
	Bet_160_320_min	VARCHAR2(128) NOT NULL,
	Bet_320_640_min	VARCHAR2(128) NOT NULL,
	Bet_640_1280_min	VARCHAR2(128) NOT NULL,
	Great_1280_min	VARCHAR2(128) NOT NULL
);
ALTER TABLE ActiveQueueTest_DDD ADD constraint Pk_ActiveQueueTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ActiveQueueTest_DDD ON ActiveQueueTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DeferredQueueTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE DeferredQueueTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Domains		VARCHAR2(128) NOT NULL,
	Total		VARCHAR2(128) NOT NULL,
	Less_than_5_min	VARCHAR2(128) NOT NULL,
	Bet_5_10_min	VARCHAR2(128) NOT NULL,
	Bet_10_20_min	VARCHAR2(128) NOT NULL,
	Bet_20_40_min	VARCHAR2(128) NOT NULL,
	Bet_40_80_min	VARCHAR2(128) NOT NULL,
	Bet_80_160_min	VARCHAR2(128) NOT NULL,
	Bet_160_320_min	VARCHAR2(128) NOT NULL,
	Bet_320_640_min	VARCHAR2(128) NOT NULL,
	Bet_640_1280_min	VARCHAR2(128) NOT NULL,
	Great_1280_min	VARCHAR2(128) NOT NULL
);
ALTER TABLE DeferredQueueTest_DDD ADD constraint Pk_DeferredQueueTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_DeferredQueueTest_DDD ON DeferredQueueTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TrexIndexTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TrexIndexTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	logIdxTyp	VARCHAR2(64) NOT NULL, 
	CreationTime	VARCHAR2(32) NOT NULL,
	ModificationTime	VARCHAR2(32) NOT NULL,
	Languages	VARCHAR2(128) NOT NULL
);

ALTER TABLE  TrexIndexTest_DDD ADD constraint Pk_TrexIndexTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


DROP TABLE TrexQueueTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TrexQueueTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DocKey		VARCHAR2(64) NOT NULL, 
	Retries		VARCHAR2(32) NOT NULL,
	DocAction	VARCHAR2(32) NOT NULL,
	QueueName	VARCHAR2(128) NOT NULL,
	QueueState	VARCHAR2(64) NOT NULL,
	LastIndexTime	VARCHAR2(32) NOT NULL,
	DocsToPreprocess VARCHAR2(32) NOT NULL,
	PreprocessingDocs VARCHAR2(32) NOT NULL,
	PreprocessFailedDocs VARCHAR2(32) NOT NULL,
	DocsToTransmit	VARCHAR2(32) NOT NULL,
	TransmittingDocs VARCHAR2(32) NOT NULL,
	TransmitFailedDocs VARCHAR2(32) NOT NULL,
	DocsToSynchronize VARCHAR2(32) NOT NULL,
	SynchronizingFailedDocs VARCHAR2(32) NOT NULL,
	SynchronizeFailedDocs VARCHAR2(32) NOT NULL,
	DelayedDocs VARCHAR2(32) NOT NULL
);

ALTER TABLE  TrexQueueTest_DDD ADD constraint Pk_TrexQueueTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
DROP TABLE TrexThreadsTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TrexThreadsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HostCol		VARCHAR2(64) NOT NULL, 
	portCol		VARCHAR2(32) NOT NULL,
	ServiceCol		VARCHAR2(32) NOT NULL,
	Thread_ID	VARCHAR2(32) NOT NULL,
	Thread_type	VARCHAR2(32) NOT NULL,
	MethodCol		VARCHAR2(32) NOT NULL,
	Details		VARCHAR2(256) NOT NULL,
	Duration	VARCHAR2(32) NOT NULL,
	Caller		VARCHAR2(32) NOT NULL,
	Called		VARCHAR2(32) NOT NULL,
	UserCol		VARCHAR2(32) NOT NULL
);

ALTER TABLE  TrexThreadsTest_DDD ADD constraint Pk_TrexThreadsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE TrexWebTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TrexWebTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HttpStatus 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  TrexWebTest_DDD ADD constraint Pk_TrexWebTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE TrexRfcTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TrexRfcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	errorMsg 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  TrexRfcTest_DDD ADD constraint Pk_TrexRfcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


DROP TABLE TrexAlertLogTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  TrexAlertLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Message_details 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  TrexAlertLogTest_DDD ADD constraint Pk_TrexAlertLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE TrexConfChkExtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TrexConfChkExtTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	indexInfo 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  TrexConfChkExtTest_DDD ADD constraint Pk_TrexConfChkExtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE TrexFsiChkTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TrexFsiChkTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	indexInfo 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  TrexFsiChkTest_DDD ADD constraint Pk_TrexFsiChkTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE ADWSEvtLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ADWSEvtLogTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  ADWSEvtLogTest_DDD ADD constraint Pk_ADWSEvtLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_ADWSEvtLogTest_DDD ON ADWSEvtLogTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
CREATE INDEX IDX2_ADWSEvtLogTest_DDD ON ADWSEvtLogTest_DDD (  EVENT_TYPE );
CREATE INDEX IDX3_ADWSEvtLogTest_DDD ON ADWSEvtLogTest_DDD (  EVENT_SOURCE );
CREATE INDEX IDX4_ADWSEvtLogTest_DDD ON ADWSEvtLogTest_DDD ( EVENT_USER );

DROP TABLE GrpAppHealthTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  GrpAppHealthTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  GrpAppHealthTest_DDD ADD constraint Pk_GrpAppHealthTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_GrpAppHealthTest_DDD ON GrpAppHealthTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );
 
CREATE INDEX IDX2_GrpAppHealthTest_DDD ON GrpAppHealthTest_DDD (  EVENT_TYPE );
 
CREATE INDEX IDX3_GrpAppHealthTest_DDD ON GrpAppHealthTest_DDD (  EVENT_SOURCE );
 
CREATE INDEX IDX4_GrpAppHealthTest_DDD ON GrpAppHealthTest_DDD ( EVENT_USER );


DROP TABLE GrpPolyUpdateTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE GrpPolyUpdateTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	STATUS_INFO	VARCHAR2(2000) NOT NULL
	
);

ALTER TABLE GrpPolyUpdateTest_DDD ADD constraint Pk_GrpPolyUpdateTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE AFNSWEBCLIENTTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFNSWEBCLIENTTEST_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	VIRTUAL_SERVER_IP		VARCHAR2(128) NOT NULL,
	SERVER_IP		VARCHAR2(128) NOT NULL,
	CLIENT_OS		VARCHAR2(200) NOT NULL,
	USER_AGENT		VARCHAR2(128) NOT NULL,
	REQUEST_METHOD	VARCHAR2(128) NOT NULL,
	REQUEST_URL	VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(128) NOT NULL,
	RESPONSE_STATUS		VARCHAR2(128) NOT NULL,
	HITS		VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL,
	RENDER_TIME	VARCHAR2(128) NOT NULL,
	CLIENT_AVG_LATENCY		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFNSWEBCLIENTTEST_DDD ADD CONSTRAINT PK_AFNSWEBCLIENTTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFNSWEBCLIENTTEST_DDD ON AFNSWEBCLIENTTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE AFNSWEBVIPTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFNSWEBVIPTEST_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	CLIENT_IP		VARCHAR2(128) NOT NULL,
	SERVER_IP		VARCHAR2(200) NOT NULL,
	CLIENT_OS		VARCHAR2(128) NOT NULL,
	USER_AGENT		VARCHAR2(128) NOT NULL,
	REQUEST_METHOD		VARCHAR2(128) NOT NULL,
	REQUEST_URL		VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(128) NOT NULL,
	RESPONSE_STATUS		VARCHAR2(128) NOT NULL,
	HITS			VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL,
	RENDER_TIME		VARCHAR2(128) NOT NULL,
	VIP_AVG_LATENCY		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFNSWEBVIPTEST_DDD ADD CONSTRAINT PK_AFNSWEBVIPTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFNSWEBVIPTEST_DDD ON AFNSWEBVIPTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE AFNSWEBSERVERSTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFNSWEBSERVERSTEST_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	CLIENT_IP		VARCHAR2(128) NOT NULL,
	VIRTUAL_SERVER_IP	VARCHAR2(128) NOT NULL,
	CLIENT_OS		VARCHAR2(128) NOT NULL,
	USER_AGENT		VARCHAR2(200) NOT NULL,
	REQUEST_METHOD		VARCHAR2(128) NOT NULL,
	REQUEST_URL		VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(128) NOT NULL,
	RESPONSE_STATUS		VARCHAR2(128) NOT NULL,
	HITS			VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL,
	SERVER_PROCESSING_TIME	VARCHAR2(128) NOT NULL,
	SERVER_AVG_LATENCY	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFNSWEBSERVERSTEST_DDD ADD CONSTRAINT PK_AFNSWEBSERVERSTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFNSWEBSERVERSTEST_DDD ON AFNSWEBSERVERSTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE AFNSWEBAPPTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFNSWEBAPPTEST_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	CLIENT_IP		VARCHAR2(128) NOT NULL,
	VIRTUAL_SERVER_IP	VARCHAR2(128) NOT NULL,
	SERVER_IP		VARCHAR2(128) NOT NULL,
	CLIENT_OS		VARCHAR2(128) NOT NULL,
	USER_AGENT		VARCHAR2(128) NOT NULL,
	REQUEST_METHOD		VARCHAR2(128) NOT NULL,
	RESPONSE_STATUS		VARCHAR2(128) NOT NULL,
	HITS			VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL,
	RESPONSE_TIME		VARCHAR2(128) NOT NULL,
	SERVER_PROCESSING_TIME	VARCHAR2(128) NOT NULL,
	CLIENT_AVG_LATENCY	VARCHAR2(128) NOT NULL,
	SERVER_AVG_LATENCY	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFNSWEBAPPTEST_DDD ADD CONSTRAINT PK_AFNSWEBAPPTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFNSWEBAPPTEST_DDD ON AFNSWEBAPPTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE AFNSWEBPROTTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFNSWEBPROTTEST_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	CLIENT_IP		VARCHAR2(128) NOT NULL,
	VIRTUAL_SERVER_IP	VARCHAR2(128) NOT NULL,
	SERVER_IP		VARCHAR2(128) NOT NULL,
	CLIENT_OS		VARCHAR2(128) NOT NULL,
	USER_AGENT		VARCHAR2(128) NOT NULL,
	REQUEST_METHOD		VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(128) NOT NULL,
	RESPONSE_STATUS		VARCHAR2(128) NOT NULL,
	HITS			VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL,
	RESPONSE_TIME		VARCHAR2(128) NOT NULL,
	SERVER_PROCESSING_TIME	VARCHAR2(128) NOT NULL,
	CLIENT_AVG_LATENCY	VARCHAR2(128) NOT NULL,
	SERVER_AVG_LATENCY	VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFNSWEBPROTTEST_DDD ADD CONSTRAINT PK_AFNSWEBPROTTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFNSWEBPROTTEST_DDD ON AFNSWEBPROTTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE AFNSWEBURLSTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFNSWEBURLSTEST_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	CLIENT_IP		VARCHAR2(200) NOT NULL,
	VIRTUAL_SERVER_IP	VARCHAR2(128) NOT NULL,
	SERVER_IP		VARCHAR2(128) NOT NULL,
	CLIENT_OS		VARCHAR2(128) NOT NULL,
	USER_AGENT		VARCHAR2(128) NOT NULL,
	REQUEST_METHOD		VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(128) NOT NULL,
	RESPONSE_STATUS		VARCHAR2(128) NOT NULL,
	HITS			VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL,
	RENDER_TIME		VARCHAR2(128) NOT NULL,
	LOAD_TIME		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFNSWEBURLSTEST_DDD ADD CONSTRAINT PK_AFNSWEBURLSTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFNSWEBURLSTEST_DDD ON AFNSWEBURLSTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE AFNSWEBHTTPRESPTEST_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AFNSWEBHTTPRESPTEST_DDD
(
	SITE_NAME  	 VARCHAR2(64) NOT NULL,
	TRGT_HOST    	 VARCHAR2(32) NOT NULL,
	PORT_NO      	 VARCHAR2(32) NOT NULL,
	TEST_NAME    	 VARCHAR2(64) NOT NULL,
	MEASURE      	 VARCHAR2(64) NOT NULL,
	INFO         	 VARCHAR2(128) NOT NULL,
	STATE        	 VARCHAR2(32) NOT NULL,
	MSMT_HOST    	 VARCHAR2(32) NOT NULL,
	MSMT_TIME    	 DATE NOT NULL,
	SEQ_NO 		 NUMBER(16) NOT NULL,
	CLIENT_IP		VARCHAR2(200) NOT NULL,
	VIRTUAL_SERVER_IP	VARCHAR2(128) NOT NULL,
	SERVER_IP		VARCHAR2(128) NOT NULL,
	CLIENT_OS		VARCHAR2(128) NOT NULL,
	USER_AGENT		VARCHAR2(128) NOT NULL,
	REQUEST_METHOD		VARCHAR2(128) NOT NULL,
	REQUEST_URL		VARCHAR2(128) NOT NULL,
	APPLICATION_NAME	VARCHAR2(128) NOT NULL,
	RESPONSE_CODE		VARCHAR2(128) NOT NULL,
	HITS			VARCHAR2(128) NOT NULL,
	BANDWIDTH		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AFNSWEBHTTPRESPTEST_DDD ADD CONSTRAINT PK_AFNSWEBHTTPRESPTEST_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AFNSWEBHTTPRESPTEST_DDD ON AFNSWEBHTTPRESPTEST_DDD
(
 	MSMT_TIME
);

DROP TABLE FCCluNetwrkTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  FCCluNetwrkTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	INTERFACENAME   VARCHAR2(256) NOT NULL,
	INTERFACESTATE  VARCHAR2(256) NOT NULL,
	NETWORK 	VARCHAR2(128) NOT NULL,
	ADAPTER    	VARCHAR2(128) NOT NULL,
	ADAPTERID  	VARCHAR2(128) NOT NULL,
	ADDRESS  	VARCHAR2(128) NOT NULL	
);

ALTER TABLE  FCCluNetwrkTest_DDD ADD constraint Pk_FCCluNetwrkTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FCCluNetwrkTest_DDD ON FCCluNetwrkTest_DDD
(
 	MSMT_TIME
);

DROP TABLE FCCluNwConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  FCCluNwConnTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NETWORK 	VARCHAR2(128) NOT NULL,
	ADAPTER    	VARCHAR2(128) NOT NULL,
	ADAPTERID  	VARCHAR2(128) NOT NULL,
	ADDRESS  	VARCHAR2(128) NOT NULL,
	NODE		VARCHAR2(128) NOT NULL
);

ALTER TABLE  FCCluNwConnTest_DDD ADD constraint Pk_FCCluNwConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FCCluNwConnTest_DDD ON FCCluNwConnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE FCCluCoreResTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  FCCluCoreResTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	OWNERNODE   VARCHAR2(256) NOT NULL,
	RESOURCETYPE  VARCHAR2(256) NOT NULL,
	GROUP_NAME 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  FCCluCoreResTest_DDD ADD constraint Pk_FCCluCoreResTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_FCCluCoreResTest_DDD ON FCCluCoreResTest_DDD
(
 	MSMT_TIME
);

DROP TABLE BSGFailOverTrap_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BSGFailOverTrap_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  BSGFailOverTrap_DDD ADD constraint Pk_BSGFailOverTrap_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BSGFailOverTrap_DDD ON BSGFailOverTrap_DDD
(
 	MSMT_TIME
);

DROP TABLE BSGDiskTrap_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BSGDiskTrap_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  BSGDiskTrap_DDD ADD constraint Pk_BSGDiskTrap_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BSGDiskTrap_DDD ON BSGDiskTrap_DDD
(
 	MSMT_TIME
);

DROP TABLE BSGSensorTrap_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BSGSensorTrap_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  BSGSensorTrap_DDD ADD constraint Pk_BSGSensorTrap_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BSGSensorTrap_DDD ON BSGSensorTrap_DDD
(
 	MSMT_TIME
);

DROP TABLE CisIpSlaOperStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CisIpSlaOperStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ADMIN_TAG_NAME	VARCHAR2(256) NOT NULL,
	SOURCE_IP_ADDRESS 	VARCHAR2(256) NOT NULL,
	TARGET_IP_ADDRESS VARCHAR2(256) NOT NULL,
	OPERATION_STATUS VARCHAR2(256) NOT NULL,
	OPERATION_TYPE VARCHAR2(256) NOT NULL,
	ROUND_TRIPTIME NUMBER(16) NOT NULL
		
);
ALTER TABLE  CisIpSlaOperStTest_DDD ADD constraint Pk_CisIpSlaOperStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CisIpSlaOperStTest_DDD ON CisIpSlaOperStTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebMTypeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebMTypeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Media_type		VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebMTypeTest_DDD ADD constraint Pk_CtxNsIsWebMTypeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebMTypeTest_DDD ON CtxNsIsWebMTypeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsWebCTypeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsWebCTypeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Content_type		VARCHAR2(512) NOT NULL,
	Netscaler_ip_address	VARCHAR2(512) NOT NULL,
	Netscaler_hostname	VARCHAR2(512) NOT NULL
);

ALTER TABLE  CtxNsIsWebCTypeTest_DDD ADD constraint Pk_CtxNsIsWebCTypeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsWebCTypeTest_DDD ON CtxNsIsWebCTypeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNsIsIcaDevATest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNsIsIcaDevATest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(128) NOT NULL,
	Ip_address	VARCHAR2(128) NOT NULL,
	Active_session_count	NUMBER(20,4) NOT NULL,
	Active_app_count	NUMBER(20,4) NOT NULL,
	Active_desktop_count	NUMBER(20,4) NOT NULL
);

ALTER TABLE  CtxNsIsIcaDevATest_DDD ADD constraint Pk_CtxNsIsIcaDevATest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxNsIsIcaDevATest_DDD ON CtxNsIsIcaDevATest_DDD
(
 	MSMT_TIME
);


DROP TABLE NetworkTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE NetworkTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(32) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NetworkTrapTest_DDD ADD constraint Pk_NetworkTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NetworkTrapTest_DDD ON NetworkTrapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AppTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AppTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(32) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  AppTrapTest_DDD ADD constraint Pk_AppTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AppTrapTest_DDD ON AppTrapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraInstStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE OraInstStatusTest_DDD
(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    MESSAGE    VARCHAR2(2000) NOT NULL
    
);
 
ALTER TABLE  OraInstStatusTest_DDD ADD constraint Pk_OraInstStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
 
CREATE  INDEX IDX_OraInstStatusTest_DDD ON OraInstStatusTest_DDD
(
     MSMT_TIME
);

DROP TABLE XchgMsgTrackTest_DDD CASCADE CONSTRAINTS;;
CREATE TABLE XchgMsgTrackTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE	     NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Timestamp	VARCHAR2(128) NOT NULL,
	ClientIp	VARCHAR2(128) NOT NULL,
	ServerIp	VARCHAR2(128) NOT NULL,
	Source		VARCHAR2(128) NOT NULL,
	EventID		VARCHAR2(128) NOT NULL,
	Sender		VARCHAR2(128) NOT NULL,
	Receiver	VARCHAR2(2000) NOT NULL,
	TotalBytes	VARCHAR2(128) NOT NULL
);

ALTER TABLE  XchgMsgTrackTest_DDD ADD constraint Pk_XchgMsgTrackTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XchgMsgTrackTest_DDD ON XchgMsgTrackTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DOTNETMonitorTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE DOTNETMonitorTest_DDD
(
SITE_NAME		VARCHAR2(64) NOT NULL,
TRGT_HOST		VARCHAR2(32) NOT NULL,
PORT_NO			VARCHAR2(32) NOT NULL,
TEST_NAME		VARCHAR2(64) NOT NULL,
MEASURE			VARCHAR2(64) NOT NULL,
INFO			VARCHAR2(128) NOT NULL,
STATE			VARCHAR2(32) NOT NULL,
MSMT_HOST		VARCHAR2(32) NOT NULL,
MSMT_TIME		DATE NOT NULL,
SEQ_NO 			NUMBER(16) NOT NULL,
EG_GUID			VARCHAR2(64) NOT NULL,
NODE_ORDER		VARCHAR2(512) NOT NULL,
APPLICATION_NAME	VARCHAR2(64) NOT NULL,
CONTEXT_NAME		VARCHAR2(64) NOT NULL,
REQUEST_TIME		DATE NOT NULL,
THREAD_GUID		VARCHAR2(64) NOT NULL,
URI			VARCHAR2(512) NOT NULL,
RESPONSE_TIME		NUMBER(20,4) NOT NULL,
TIME_ZONE		VARCHAR2(32) NOT NULL,
REMOTE_HOST		VARCHAR2(256) NOT NULL,
REQUEST_TYPE		VARCHAR2(16) NOT NULL,
TRANSACTION_TYPE	VARCHAR2(16) NOT NULL,
SLOW_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
STALLED_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
URL_PARAMS		VARCHAR2(1024) NOT NULL,
SESSION_ID		VARCHAR2(128) NOT NULL,
THREAD_ID		VARCHAR2(512) NOT NULL,
DEVICE			VARCHAR2(64) NOT NULL,
OS			VARCHAR2(64) NOT NULL,
BROWSER			VARCHAR2(64) NOT NULL,
REFERER			VARCHAR2(2000) NOT NULL,
COUNTRY			VARCHAR2(32) NOT NULL,
LOCATION		VARCHAR2(32) NOT NULL,
POSITION		VARCHAR2(32) NOT NULL,
TRACE_DETAILS		BLOB NOT NULL,
PRE_PROCESSOR_TIME	NUMBER(20,4) NOT NULL,
METHOD_TYPE		VARCHAR2(32) NOT NULL,
STATUS_CODE		VARCHAR2(32) NOT NULL,
COOKIES			VARCHAR2(2000) NOT NULL,
HEADER			VARCHAR2(2000) NOT NULL,
USERNAME		VARCHAR2(2000) NOT NULL,
BUSINESS_CONTEXT	VARCHAR2(2000) NOT NULL,
CPU_TIME		NUMBER(20,4) NOT NULL,
WAIT_TIME 		NUMBER(20,4) NOT NULL,
BLOCK_TIME		NUMBER(20,4) NOT NULL,
USER_AGENT		VARCHAR2(2000) NOT NULL,
BROWSER_VERSION		VARCHAR2(64) NOT NULL,
REGION			VARCHAR2(64) NOT NULL,
CITY			VARCHAR2(128) NOT NULL,
GATEWAY_IP		VARCHAR2(256) NOT NULL,
EXCEPTION_NAME		VARCHAR2(256) NOT NULL,
COMPONENT_ID		VARCHAR2(128) NOT NULL,
UTC_DATE		DATE NOT NULL,
constraint Pk_DOTNETMonitorTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO))
organization index compress overflow;

CREATE  INDEX IDX_DOTNETMonitorTest_DDD ON DOTNETMonitorTest_DDD
(
	EG_GUID
);

CREATE  INDEX IDX1_DOTNETMonitorTest_DDD ON DOTNETMonitorTest_DDD
(
	MSMT_TIME
);

DROP TABLE CtxLicenseStatsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxLicenseStatsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Evt_Date	DATE NOT NULL,
	Description	VARCHAR2(2000) NOT NULL,
	Evt_User	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxLicenseStatsTest_DDD ADD constraint Pk_CtxLicenseStatsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE SecGrpMgntTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SecGrpMgntTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Evt_Date	DATE NOT NULL,
	Description	VARCHAR2(2000) NOT NULL,
	Evt_User	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE SecGrpMgntTest_DDD ADD constraint Pk_SecGrpMgntTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE RegistryMgntTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE RegistryMgntTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Evt_Date	DATE NOT NULL,
	Description	VARCHAR2(2000) NOT NULL,
	Evt_User	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE RegistryMgntTest_DDD ADD constraint Pk_RegistryMgntTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE ExtMediaDetectTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE ExtMediaDetectTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Date_Time	DATE NOT NULL,
	Evt_Date	VARCHAR2(128) NOT NULL,
	Description	VARCHAR2(2000) NOT NULL,
	Evt_User	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE ExtMediaDetectTest_DDD ADD constraint Pk_ExtMediaDetectTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE WinFirewallTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE WinFirewallTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Evt_Date	DATE NOT NULL,
	Description	VARCHAR2(2000) NOT NULL,
	Evt_User	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE WinFirewallTest_DDD ADD constraint Pk_WinFirewallTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE SftServInstTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE SftServInstTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Evt_Date	DATE NOT NULL,
	Description	VARCHAR2(2000) NOT NULL,
	Evt_User	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE SftServInstTest_DDD ADD constraint Pk_SftServInstTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

DROP TABLE EvntLogClearTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE EvntLogClearTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Evt_Date	DATE NOT NULL,
	Description	VARCHAR2(2000) NOT NULL,
	Evt_User	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE EvntLogClearTest_DDD ADD constraint Pk_EvntLogClearTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);


DROP TABLE ProConnectionsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE ProConnectionsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	CONNECTION_PID	VARCHAR2(512) NOT NULL,
	CLIENT_IP_ADDRESS	VARCHAR2(1000) NOT NULL,
	CONNECTION_CLIENT_TYPE	VARCHAR2(128) NOT NULL,
	CONNECTION_TYPE	VARCHAR2(128) NOT NULL,
	CONNECTIONN_TIME	VARCHAR2(256) NOT NULL
);
ALTER TABLE ProConnectionsTest_DDD ADD constraint Pk_ProConnectionsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ProConnectionsTest_DDD ON ProConnectionsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ProUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ProUptimeTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	SHUTDOWNDATE			DATE NOT NULL,
	REBOOTEDDATE			DATE NOT NULL,
	DURATION			NUMBER(20,4) NOT NULL,
	MAINTENANCE			VARCHAR2(32) NOT NULL
);
ALTER TABLE  ProUptimeTest_DDD ADD constraint Pk_ProUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ProUptimeTest_DDD ON ProUptimeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VMLaunchErrorTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VMLaunchErrorTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Event_id	VARCHAR2(512) NOT NULL,
	Event_Time	VARCHAR2(128) NOT NULL,
	Module		VARCHAR2(128) NOT NULL,
	Event_type	VARCHAR2(512) NOT NULL,
	Message		VARCHAR2(2000) NOT NULL,
	Source		VARCHAR2(1000) NOT NULL,
	Node		VARCHAR2(1000) NOT NULL,
	Users_id	VARCHAR2(512) NOT NULL,
	Desktop_id	VARCHAR2(512) NOT NULL,
	Machine_id	VARCHAR2(512) NOT NULL,
	Pool_id		VARCHAR2(512) NOT NULL
);

ALTER TABLE VMLaunchErrorTest_DDD ADD constraint Pk_VMLaunchErrorTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VMLaunchErrorTest_DDD ON VMLaunchErrorTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VMPrvsningErrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VMPrvsningErrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Event_id	VARCHAR2(512) NOT NULL,
	Event_Time	VARCHAR2(128) NOT NULL,
	Module		VARCHAR2(128) NOT NULL,
	Event_type	VARCHAR2(512) NOT NULL,
	Message		VARCHAR2(2000) NOT NULL,
	Source		VARCHAR2(1000) NOT NULL,
	Node		VARCHAR2(1000) NOT NULL,
	Users_id	VARCHAR2(512) NOT NULL,
	Desktop_id	VARCHAR2(512) NOT NULL,
	Machine_id	VARCHAR2(512) NOT NULL,
	Pool_id		VARCHAR2(512) NOT NULL
);

ALTER TABLE VMPrvsningErrTest_DDD ADD constraint Pk_VMPrvsningErrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VMPrvsningErrTest_DDD ON VMPrvsningErrTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VTPcoipSessTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VTPcoipSessTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	ProcName	VARCHAR2(128) NOT NULL,
	Image_path	VARCHAR2(2000) NOT NULL,
	Cpu_util	NUMBER(20,4) NOT NULL,
	CPU_time	NUMBER(20,4) NOT NULL,
	Memory_util	NUMBER(20,4) NOT NULL,
	IO_reads 	NUMBER(20,4) NOT NULL,
	IO_writes	NUMBER (20,4) NOT NULL,
	Page_faults	NUMBER (20,4) NOT NULL,
	Virtual_memory	NUMBER (20,4) NOT NULL,
	Handles		NUMBER (20,4) NOT NULL
);
ALTER TABLE  VTPcoipSessTest_DDD ADD constraint Pk_VTPcoipSessTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VTPcoipSessTest_DDD ON VTPcoipSessTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VTBlastTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VTBlastTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	PID		NUMBER(16) NOT NULL,
	ProcName	VARCHAR2(128) NOT NULL,
	Image_path	VARCHAR2(2000) NOT NULL,
	Cpu_util	NUMBER(20,4) NOT NULL,
	CPU_time	NUMBER(20,4) NOT NULL,
	Memory_util	NUMBER(20,4) NOT NULL,
	IO_reads 	NUMBER(20,4) NOT NULL,
	IO_writes	NUMBER (20,4) NOT NULL,
	Page_faults	NUMBER (20,4) NOT NULL,
	Virtual_memory	NUMBER (20,4) NOT NULL,
	Handles		NUMBER (20,4) NOT NULL
);
ALTER TABLE  VTBlastTest_DDD ADD constraint Pk_VTBlastTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VTBlastTest_DDD ON VTBlastTest_DDD
(
 	MSMT_TIME
);


DROP TABLE MsSqlJobBackUpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE MsSqlJobBackUpTest_DDD
(
	SITE_NAME       VARCHAR2(64)   NOT NULL,
	TRGT_HOST       VARCHAR2(32)   NOT NULL,
	PORT_NO         VARCHAR2(32)   NOT NULL,
	TEST_NAME       VARCHAR2(64)   NOT NULL,
	MEASURE         VARCHAR2(64)   NOT NULL,
	INFO            VARCHAR2(128)  NOT NULL,
	STATE           VARCHAR2(32)   NOT NULL,
	MSMT_HOST       VARCHAR2(32)   NOT NULL,
	MSMT_TIME       DATE     NOT NULL,
	SEQ_NO          NUMBER(16)   NOT NULL,
	BACKUP_NAME     VARCHAR2(128)   NOT NULL,
	BACKUP_TYPE	VARCHAR2(32)   NOT NULL,
	USERNAME	VARCHAR2(64)  NOT NULL,
	SERVER_NAME	VARCHAR2(128)  NOT NULL,
	LAST_SUCCESSFULL_BACKUPDATE   VARCHAR2(128)  NOT NULL,
	BACKUP_STARTTIME	VARCHAR2(128)  NOT NULL,
	BACKUP_ENDTIME		VARCHAR2(128)  NOT NULL
);
ALTER TABLE  MsSqlJobBackUpTest_DDD ADD constraint Pk_MsSqlJobBackUpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MsSqlJobBackUpTest_DDD ON MsSqlJobBackUpTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RZDApInfoTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RZDApInfoTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	RADIOTYPE       VARCHAR2(128) NOT NULL
	
	
);
ALTER TABLE  RZDApInfoTest_DDD ADD constraint Pk_RZDApInfoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RZDApInfoTest_DDD ON RZDApInfoTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RZDDevInfoTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RZDDevInfoTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ACCESSPOINTNAME VARCHAR2(128) NOT NULL
	
);
ALTER TABLE  RZDDevInfoTest_DDD ADD constraint Pk_RZDDevInfoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RZDDevInfoTest_DDD ON RZDDevInfoTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RZDRogueInfoTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RZDRogueInfoTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MACID           VARCHAR2(128) NOT NULL,
	SSID            VARCHAR2(128) NOT NULL
	
);
ALTER TABLE  RZDRogueInfoTest_DDD ADD constraint Pk_RZDRogueInfoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RZDRogueInfoTest_DDD ON RZDRogueInfoTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RZDUserInfoTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RZDUserInfoTest_DDD
(
	SITE_NAME  	   VARCHAR2(64) NOT NULL,
	TRGT_HOST    	    VARCHAR2(32) NOT NULL,
	PORT_NO      	    VARCHAR2(32) NOT NULL,
	TEST_NAME    	    VARCHAR2(64) NOT NULL,
	MEASURE      	    VARCHAR2(64) NOT NULL,
	INFO         	    VARCHAR2(128) NOT NULL,
	STATE        	    VARCHAR2(32) NOT NULL,
	MSMT_HOST    	    VARCHAR2(32) NOT NULL,
	MSMT_TIME    	    DATE NOT NULL,
	SEQ_NO 		    NUMBER(16) NOT NULL,
	ACCESSPOINT_MACID   VARCHAR2(128) NOT NULL,
	SSID                VARCHAR2(128) NOT NULL
	
);
ALTER TABLE  RZDUserInfoTest_DDD ADD constraint Pk_RZDUserInfoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RZDUserInfoTest_DDD ON RZDUserInfoTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PVSStoreTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  PVSStoreTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DEVICE_NAME	VARCHAR2(128) NOT NULL,
	INTERNAL_NAME	VARCHAR2(128) NOT NULL,
	ORIGINAL_FILE 	VARCHAR2(256) NOT NULL,
	DESCRIPTION 	VARCHAR2(256) NOT NULL,
	SERVER_NAME	VARCHAR2(256) NOT NULL
);

ALTER TABLE  PVSStoreTest_DDD ADD constraint Pk_PVSStoreTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_PVSStoreTest_DDD ON PVSStoreTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HrznReplTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HrznReplTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO		 	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name_space	VARCHAR2(128) NOT NULL,
	Site			VARCHAR2(128) NOT NULL,
	Server_name	VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(4000) NOT NULL
);
ALTER TABLE  HrznReplTest_DDD ADD constraint Pk_HrznReplTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznReplTest_DDD ON HrznReplTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CisSGSensorTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CisSGSensorTest_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32) NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	SENSOR_TYPE		VARCHAR2(128) NOT NULL,
	SENSOR_STATUS		VARCHAR2(128) NOT NULL);

ALTER TABLE  CisSGSensorTest_DDD ADD constraint Pk_CisSGSensorTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CisSGSensorTest_DDD ON CisSGSensorTest_DDD
(
 	MSMT_TIME
);

DROP TABLE McfeeTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE McfeeTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL);
ALTER TABLE  McfeeTrapTest_DDD ADD constraint Pk_McfeeTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_McfeeTrapTest_DDD ON McfeeTrapTest_DDD
(
 	MSMT_TIME
);




DROP TABLE NutAHVVmStatusTest_DDD  CASCADE CONSTRAINTS;

CREATE TABLE  NutAHVVmStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GUESTNAME	VARCHAR2(128) NOT NULL,
	GUEST_IP	VARCHAR2(2000) NOT NULL,
	GUEST_OS 	VARCHAR2(128) NOT NULL,
	USER_NAME	VARCHAR2(128) NOT NULL,
	NETSCALER_RPTNAME VARCHAR2(256) NOT NULL,
	NETSCALER_IP_ADDRESS VARCHAR2(128) NOT NULL,
	CONNECTED_IP_ADDRESS VARCHAR2(128) NOT NULL,
	ENDPOINT_IP_ADDRESS VARCHAR2(128) NOT NULL,
	COUNTRY_NAME VARCHAR2(256) NOT NULL,
	COUNTRY_CODE VARCHAR2(256) NOT NULL,
	REGION VARCHAR2(256) NOT NULL,
	CITY VARCHAR2(256) NOT NULL,
	LATITUDE VARCHAR2(64) NOT NULL,
	LONGITUDE VARCHAR2(64) NOT NULL
);

ALTER TABLE  NutAHVVmStatusTest_DDD ADD constraint Pk_NutAHVVmStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutAHVVmStatusTest_DDD ON NutAHVVmStatusTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NutAHVDiskTest_DDD  CASCADE CONSTRAINTS;

CREATE TABLE  NutAHVDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Disk_Uuid	VARCHAR2(256) NOT NULL,
	Storagepool_Uuid	VARCHAR2(2000) NOT NULL,
	Cluster_Uuid 	VARCHAR2(256) NOT NULL
);

ALTER TABLE  NutAHVDiskTest_DDD ADD constraint Pk_NutAHVDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutAHVDiskTest_DDD ON NutAHVDiskTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NutClusVMsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NutClusVMsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Virtual_Disk	VARCHAR2(256) NOT NULL,
	Total_capacity	VARCHAR2(256) NOT NULL,
	Physical_usage	VARCHAR2(256) NOT NULL,
	Read_IOPS	VARCHAR2(256) NOT NULL,
	Write_IOPS	VARCHAR2(256) NOT NULL,
	Total_IOPS	VARCHAR2(256) NOT NULL,
	Read_IO_latency	VARCHAR2(256) NOT NULL,
	Write_IO_latency	VARCHAR2(256) NOT NULL,
	Total_IO_latency	VARCHAR2(256) NOT NULL,
	Read_IO_bandwidth	VARCHAR2(256) NOT NULL,
	Write_IO_bandwidth	VARCHAR2(256) NOT NULL,
	Total_IO_bandwidth	VARCHAR2(256) NOT NULL	
);

ALTER TABLE  NutClusVMsTest_DDD ADD constraint Pk_NutClusVMsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutClusVMsTest_DDD ON NutClusVMsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NutAhvComputeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NutAhvComputeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Vm_Name		VARCHAR2(256) NOT NULL,
	CPU_Usage	VARCHAR2(256) NOT NULL
);

ALTER TABLE  NutAhvComputeTest_DDD ADD constraint Pk_NutAhvComputeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutAhvComputeTest_DDD ON NutAhvComputeTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NutCluContainerTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NutCluContainerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(256) NOT NULL
);

ALTER TABLE  NutCluContainerTest_DDD ADD constraint Pk_NutCluContainerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutCluContainerTest_DDD ON NutCluContainerTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NutClusComputeTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NutClusComputeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Host_Name	VARCHAR2(256) NOT NULL,
	Host_IP		VARCHAR2(256) NOT NULL,
	Host_Type	VARCHAR2(256) NOT NULL,	
	Hypervisor_Name	VARCHAR2(256) NOT NULL
);

ALTER TABLE  NutClusComputeTest_DDD ADD constraint Pk_NutClusComputeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutClusComputeTest_DDD ON NutClusComputeTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NutClusStrPoolTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE  NutClusStrPoolTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Disk_UUID	VARCHAR2(256) NOT NULL,
	Status		VARCHAR2(256) NOT NULL,
	Host_Name	VARCHAR2(256) NOT NULL
);

ALTER TABLE  NutClusStrPoolTest_DDD ADD constraint Pk_NutClusStrPoolTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutClusStrPoolTest_DDD ON NutClusStrPoolTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NutLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE NutLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GuestName	VARCHAR2(256) NOT NULL,
	UserName	VARCHAR2(256) NOT NULL,
	Login_Time	VARCHAR2(256) NOT NULL,
	Duration	VARCHAR2(256) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL
);

ALTER TABLE  NutLoginTest_DDD ADD constraint Pk_NutLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutLoginTest_DDD ON NutLoginTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VTAppLaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VTAppLaunchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Username		VARCHAR2(256) NOT NULL,
	Session_name	VARCHAR2(256) NOT NULL,
	Session_id		VARCHAR2(32) NOT NULL,
	Pid			VARCHAR2(32) NOT NULL,
	Application_name VARCHAR2(2000) NOT NULL,
	Launch_duration  NUMBER(20,4) NOT NULL
);

ALTER TABLE  VTAppLaunchTest_DDD ADD constraint Pk_VTAppLaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VTAppLaunchTest_DDD ON VTAppLaunchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgApplaunchTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VmgApplaunchTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(256) NOT NULL,
	Execution_time	VARCHAR2(256) NOT NULL,
	Process_id	VARCHAR2(32) NOT NULL,
	Application_name VARCHAR2(2000) NOT NULL,
	Launch_duration  NUMBER(20,4) NOT NULL
);

ALTER TABLE  VmgApplaunchTest_DDD ADD constraint Pk_VmgApplaunchTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgApplaunchTest_DDD ON VmgApplaunchTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXALogonSimTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxXcXALogonSimTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Messages	VARCHAR2(2000) NOT NULL,
	Published_resources	VARCHAR2(2000) NOT NULL,
	Screenshot_Id	VARCHAR2(256) NOT NULL
);
ALTER TABLE  CtxXcXALogonSimTest_DDD ADD constraint Pk_CtxXcXALogonSimTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxXcXALogonSimTest_DDD ON CtxXcXALogonSimTest_DDD
(
 	MSMT_TIME
);

DROP TABLE EgDBDatafile_DDD CASCADE CONSTRAINTS;
CREATE TABLE EgDBDatafile_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	FILE_LOCATION		VARCHAR2(256) NOT NULL
);

ALTER TABLE EgDBDatafile_DDD ADD constraint Pk_EgDBDatafile_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_EgDBDatafile_DDD ON EgDBDatafile_DDD
(
 	MSMT_TIME
);

DROP TABLE BTSendPortsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE BTSendPortsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Port_name	VARCHAR2(1000) NOT NULL,
	Url		VARCHAR2(1000) NOT NULL,
	Transport_type	VARCHAR2(128) NOT NULL
);

ALTER TABLE BTSendPortsTest_DDD ADD constraint Pk_BTSendPortsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_BTSendPortsTest_DDD ON BTSendPortsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE BTReceivePortsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE BTReceivePortsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Adapter_name	VARCHAR2(1000) NOT NULL,
	Location_name	VARCHAR2(1000) NOT NULL,
	Url		VARCHAR2(1000) NOT NULL
);

ALTER TABLE BTReceivePortsTest_DDD ADD constraint Pk_BTReceivePortsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_BTReceivePortsTest_DDD ON BTReceivePortsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SapWasEnqRepTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SapWasEnqRepTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Msg	VARCHAR2(256) NOT NULL);

ALTER TABLE  SapWasEnqRepTest_DDD ADD constraint Pk_SapWasEnqRepTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SapWasEnqRepTest_DDD ON SapWasEnqRepTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SapWasGCTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SapWasGCTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Reason		VARCHAR2(128) NOT NULL,
	startTime	VARCHAR2(32) NOT NULL,
	duration	VARCHAR2(32) NOT NULL,
	cpuUtil		VARCHAR2(32) NOT NULL,
	objFreed	VARCHAR2(32) NOT NULL,
	objMem		VARCHAR2(32) NOT NULL,
	clsFreed	VARCHAR2(32) NOT NULL,
	clsMem		VARCHAR2(32) NOT NULL,
	heapSize	VARCHAR2(32) NOT NULL,
	unloadClass	VARCHAR2(32) NOT NULL
);

ALTER TABLE  SapWasGCTest_DDD ADD constraint Pk_SapWasGCTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SapWasGCTest_DDD ON SapWasGCTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ClientNetworkTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE ClientNetworkTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	HOPCOUNT	NUMBER(16) NOT NULL,
	ROUTER		VARCHAR2(2000) NOT NULL,
	HOPDELAYS	VARCHAR2(2000) NOT NULL
);

ALTER TABLE ClientNetworkTest_DDD ADD constraint Pk_CTNetworkTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CTNetworkTest_DDD ON ClientNetworkTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IBMWASEgJMSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IBMWASEgJMSTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE_TYPE	VARCHAR2(128) NOT NULL,
	JMS_TYPE	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE_ID	VARCHAR2(128) NOT NULL,
	JMS_DESTINATION	VARCHAR2(128) NOT NULL,
	JMS_REDELIVERED_ENABLED	VARCHAR2(128) NOT NULL,
	JMS_MSG_QUEUE_DURATION_MINS	VARCHAR2(128) NOT NULL,
	JMS_DELIVERY_MODE	VARCHAR2(128) NOT NULL,
	JMS_TIMETOLIVE		VARCHAR2(128) NOT NULL,
	JMS_PRIORITY		VARCHAR2(128) NOT NULL,
	JMX_APP_ID		VARCHAR2(128) NOT NULL,
	JMS_XDELIVERY_COUNT	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE		VARCHAR2(1024) NOT NULL);
ALTER TABLE  IBMWASEgJMSTest_DDD ADD constraint Pk_IBMWASEgJMSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IBMWASEgJMSTest_DDD ON IBMWASEgJMSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE JBossEgJMSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  JBossEgJMSTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE_TYPE	VARCHAR2(128) NOT NULL,
	JMS_TYPE	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE_ID	VARCHAR2(128) NOT NULL,
	JMS_DESTINATION	VARCHAR2(128) NOT NULL,
	JMS_REDELIVERED_ENABLED	VARCHAR2(128) NOT NULL,
	JMS_MSG_QUEUE_DURATION_MINS	VARCHAR2(128) NOT NULL,
	JMS_DELIVERY_MODE	VARCHAR2(128) NOT NULL,
	JMS_TIMETOLIVE		VARCHAR2(128) NOT NULL,
	JMS_PRIORITY		VARCHAR2(128) NOT NULL,
	JMX_APP_ID		VARCHAR2(128) NOT NULL,
	JMS_XDELIVERY_COUNT	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE		VARCHAR2(1024) NOT NULL);
ALTER TABLE  JBossEgJMSTest_DDD ADD constraint Pk_JBossEgJMSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_JBossEgJMSTest_DDD ON JBossEgJMSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WLEgJMSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WLEgJMSTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE_TYPE	VARCHAR2(128) NOT NULL,
	JMS_TYPE	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE_ID	VARCHAR2(128) NOT NULL,
	JMS_DESTINATION	VARCHAR2(128) NOT NULL,
	JMS_REDELIVERED_ENABLED	VARCHAR2(128) NOT NULL,
	JMS_MSG_QUEUE_DURATION_MINS	VARCHAR2(128) NOT NULL,
	JMS_DELIVERY_MODE	VARCHAR2(128) NOT NULL,
	JMS_TIMETOLIVE		VARCHAR2(128) NOT NULL,
	JMS_PRIORITY		VARCHAR2(128) NOT NULL,
	JMX_APP_ID		VARCHAR2(128) NOT NULL,
	JMS_XDELIVERY_COUNT	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE		VARCHAR2(1024) NOT NULL);
ALTER TABLE  WLEgJMSTest_DDD ADD constraint Pk_WLEgJMSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WLEgJMSTest_DDD ON WLEgJMSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IBMWMQEgJMSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IBMWMQEgJMSTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE_TYPE	VARCHAR2(128) NOT NULL,
	JMS_TYPE	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE_ID	VARCHAR2(128) NOT NULL,
	JMS_DESTINATION	VARCHAR2(128) NOT NULL,
	JMS_REDELIVERED_ENABLED	VARCHAR2(128) NOT NULL,
	JMS_MSG_QUEUE_DURATION_MINS	VARCHAR2(128) NOT NULL,
	JMS_DELIVERY_MODE	VARCHAR2(128) NOT NULL,
	JMS_TIMETOLIVE		VARCHAR2(128) NOT NULL,
	JMS_PRIORITY		VARCHAR2(128) NOT NULL,
	JMX_APP_ID		VARCHAR2(128) NOT NULL,
	JMS_XDELIVERY_COUNT	VARCHAR2(128) NOT NULL,
	JMS_MESSAGE		VARCHAR2(1024) NOT NULL);
ALTER TABLE  IBMWMQEgJMSTest_DDD ADD constraint Pk_IBMWMQEgJMSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IBMWMQEgJMSTest_DDD ON IBMWMQEgJMSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NimArrayTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NimArrayTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NimArrayTrapTest_DDD ADD constraint Pk_NimArrayTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NimArrayTrapTest_DDD ON NimArrayTrapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NimRaidTrapTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NimRaidTrapTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SENDER		VARCHAR2(128) NOT NULL,
	TRAP_TIME	VARCHAR2(128) NOT NULL,
	TRAP_TYPE	VARCHAR2(1500) NOT NULL,
	TRAP_DETAILS	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NimRaidTrapTest_DDD ADD constraint Pk_NimRaidTrapTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NimRaidTrapTest_DDD ON NimRaidTrapTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxSFToDDCConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxSFToDDCConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SERVER_NAME	VARCHAR2(256) NOT NULL,
	XML_PORT	VARCHAR2(128) NOT NULL,
	SSL_RELAY_PORT 	VARCHAR2(128) NOT NULL,
	LOAD_BALANCE 	VARCHAR2(256) NOT NULL,
	FARM_TYPE	VARCHAR2(256) NOT NULL
);

ALTER TABLE  CtxSFToDDCConnTest_DDD ADD constraint Pk_CtxSFToDDCConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSFToDDCConnTest_DDD ON CtxSFToDDCConnTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PsUserEventTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  PsUserEventTest_DDD
(
	SITE_NAME  	   VARCHAR2(64) NOT NULL,
	TRGT_HOST    	    VARCHAR2(32) NOT NULL,
	PORT_NO      	    VARCHAR2(32) NOT NULL,
	TEST_NAME    	    VARCHAR2(64) NOT NULL,
	MEASURE      	    VARCHAR2(64) NOT NULL,
	INFO         	    VARCHAR2(128) NOT NULL,
	STATE        	    VARCHAR2(32) NOT NULL,
	MSMT_HOST    	    VARCHAR2(32) NOT NULL,
	MSMT_TIME    	    DATE NOT NULL,
	SEQ_NO 		    NUMBER(16) NOT NULL,
	REGID               VARCHAR2(128) NOT NULL,
	EVENTDATE           VARCHAR2(128) NOT NULL,
	VARIABLEVALUE       VARCHAR2(128) NOT NULL,
	THRESHOLDVALUE      VARCHAR2(128) NOT NULL,
	DAYCOUNT            VARCHAR2(128) NOT NULL
);
ALTER TABLE  PsUserEventTest_DDD ADD constraint Pk_PsUserEventTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_PsUserEventTest_DDD ON PsUserEventTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SPFileTypeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SPFileTypeTest_DDD
(
	SITE_NAME  		VARCHAR2(64) NOT NULL,
	TRGT_HOST    		VARCHAR2(32) NOT NULL,
	PORT_NO      		VARCHAR2(32)NOT NULL,
	TEST_NAME    		VARCHAR2(64) NOT NULL,
	MEASURE      		VARCHAR2(64) NOT NULL,
	INFO         		VARCHAR2(128) NOT NULL,
	STATE        		VARCHAR2(32) NOT NULL,
	MSMT_HOST    		VARCHAR2(32) NOT NULL,
	MSMT_TIME    		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	Extension		VARCHAR2(256) NOT NULL,
	Document_type		VARCHAR2(256) NOT NULL,
	Files_Count		VARCHAR2(256) NOT NULL,
	File_Size		VARCHAR2(256) NOT NULL,
	Percentage		VARCHAR2(256) NOT NULL
);

ALTER TABLE  SPFileTypeTest_DDD ADD constraint Pk_SPFileTypeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SPFileTypeTest_DDD ON SPFileTypeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SysTimeChangeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SysTimeChangeTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_TYPE 	VARCHAR2(32) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_SOURCE 	VARCHAR2(256) NOT NULL,
	EVENT_CATEGORY 	VARCHAR2(32) NOT NULL,
	EVENT_ID 	NUMBER(16) NOT NULL,
	EVENT_DESC 	VARCHAR2(2000),
	EVENT_USER 	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER 	VARCHAR2(128) NOT NULL
);

ALTER TABLE  SysTimeChangeTest_DDD ADD constraint Pk_SysTimeChangeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE INDEX IDX1_SysTimeChangeTest_DDD ON SysTimeChangeTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );

DROP TABLE MSExchngeAvailTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MSExchngeAvailTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVENT_DATE  	DATE NOT NULL,
	EVENT_LEVEL	VARCHAR2(32) NOT NULL,
	EVENT_USER	VARCHAR2(128) NOT NULL,
	EVENT_COMPUTER	VARCHAR2(128) NOT NULL,
	EVENT_DESCRIPTION	VARCHAR2(2000),
	ACTION_CATEGORY		VARCHAR2(128) NOT NULL,
	ACTION_REASON	VARCHAR2(128) NOT NULL,
	AM_ROLE		VARCHAR2(128) NOT NULL
);

ALTER TABLE  MSExchngeAvailTest_DDD ADD constraint MSExchngeAvailTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX1_MSExchngeAvailTest_DDD ON MSExchngeAvailTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDAppDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDAppDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Hypervisor_conn_name		VARCHAR2(128) NOT NULL,
	Visual_disk_id			VARCHAR2(128) NOT NULL,
	Package_name		VARCHAR2(1000) NOT NULL,
	Package_manufacture	VARCHAR2(128) NOT NULL,
	Package_version		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDAppDiskTest_DDD ADD constraint Pk_CtxXcXDAppDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxXcXDAppDiskTest_DDD ON CtxXcXDAppDiskTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDZoneTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDZoneTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DNS_Name		VARCHAR2(128) NOT NULL,
	Machine_Name		VARCHAR2(128) NOT NULL,
	Controller_Version	VARCHAR2(128) NOT NULL,
	OS_Type			VARCHAR2(128) NOT NULL,
	OS_Version		VARCHAR2(128) NOT NULL,
	Last_Activity_Time	VARCHAR2(128) NOT NULL,
	Last_Start_Time		VARCHAR2(128) NOT NULL,
	Catalog_Name		VARCHAR2(128) NOT NULL,
	Delivery_Group_Name	VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Session_Support		VARCHAR2(128) NOT NULL,
	Allocation_Type		VARCHAR2(128) NOT NULL,
	Machines_Are_Physical	VARCHAR2(128) NOT NULL,
	Persist_User_Changes	VARCHAR2(128) NOT NULL,
	Provisioning_Type	VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL,
	Enabled			VARCHAR2(128) NOT NULL,
	In_Maintenance_Mode	VARCHAR2(128) NOT NULL,
	Total_machines		VARCHAR2(128) NOT NULL,
	DesktopKind		VARCHAR2(128) NOT NULL,
	Secure_Ica_Required	VARCHAR2(128) NOT NULL,
	Shutdown_After_Use	VARCHAR2(128) NOT NULL,
	AppDisk_Names		VARCHAR2(128) NOT NULL,
	Current_Primary_Zone	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDZoneTest_DDD ADD constraint Pk_CtxXcXDZoneTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxXcXDZoneTest_DDD ON CtxXcXDZoneTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDLicenseTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDLicenseTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Event_Date	VARCHAR2(128) NOT NULL,
	Message		VARCHAR2(2000) NOT NULL,
	User_name	VARCHAR2(128) NOT NULL,
	Computer	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDLicenseTest_DDD ADD constraint Pk_CtxXcXDLicenseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxXcXDLicenseTest_DDD ON CtxXcXDLicenseTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXDSiteZoneTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXDSiteZoneTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DNS_Name		VARCHAR2(128) NOT NULL,
	Machine_Name		VARCHAR2(128) NOT NULL,
	Controller_Version	VARCHAR2(128) NOT NULL,
	OS_Type			VARCHAR2(128) NOT NULL,
	OS_Version		VARCHAR2(128) NOT NULL,
	Last_Activity_Time	VARCHAR2(128) NOT NULL,
	Last_Start_Time		VARCHAR2(128) NOT NULL,
	Catalog_Name		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Allocation_Type		VARCHAR2(128) NOT NULL,
	Session_Support		VARCHAR2(128) NOT NULL,
	Machines_Are_Physical	VARCHAR2(128) NOT NULL,
	Persist_User_Changes	VARCHAR2(128) NOT NULL,
	Provisioning_Type	VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL,
	Current_Primary_Zone	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXDSiteZoneTest_DDD ADD constraint Pk_CtxXcXDSiteZoneTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxXcXDSiteZoneTest_DDD ON CtxXcXDSiteZoneTest_DDD
(
 	MSMT_TIME
);


DROP TABLE NutClusStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE NutClusStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	VM_NAME 	VARCHAR2(256) NOT NULL,
	VM_IP		VARCHAR2(256) NOT NULL,
	VM_OS		VARCHAR2(256) NOT NULL,
	HOST_NAME		VARCHAR2(256) NOT NULL
);

ALTER TABLE NutClusStatusTest_DDD ADD constraint Pk_NutClusStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NutClusStatusTest_DDD ON NutClusStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MongoLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE MongoLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Error_time 	VARCHAR2(32) NOT NULL,	
	Component 	VARCHAR2(32) NOT NULL,	
	Context		VARCHAR2(32) NOT NULL,
	Message		VARCHAR2(1000) NOT NULL
);
ALTER TABLE MongoLogTest_DDD ADD constraint Pk_MongoLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MongoLogTest_DDD ON MongoLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PrintJobStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE PrintJobStatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Owner		VARCHAR2(128) NOT NULL,
	Document_name		VARCHAR2(1000) NOT NULL,
	Name			VARCHAR2(1000) NOT NULL,
	Job_id			VARCHAR2(128) NOT NULL,
	Total_pages		VARCHAR2(128) NOT NULL,
	Pages_printed		VARCHAR2(128) NOT NULL,
	Print_size		VARCHAR2(128) NOT NULL,
	Driver_name		VARCHAR2(128) NOT NULL,
	Host_print_queue	VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(1000) NOT NULL,
	Time_submitted		VARCHAR2(128) NOT NULL,
	Job_status		VARCHAR2(128) NOT NULL
);

ALTER TABLE  PrintJobStatTest_DDD ADD constraint Pk_PrintJobStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_PrintJobStatTest_DDD ON PrintJobStatTest_DDD
(
 	MSMT_TIME
);


DROP TABLE ShareFileBWTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ShareFileBWTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	NAME			VARCHAR2(128) NOT NULL,
	EMAIL			VARCHAR2(128) NOT NULL,
	DATA_TRANSFERRED_MB	VARCHAR2(128) NOT NULL,
	LAST_LOGIN		VARCHAR2(128) NOT NULL,
	COMPANY			VARCHAR2(128) NOT NULL,
	IS_EMPLOYEE		VARCHAR2(128) NOT NULL

);

ALTER TABLE  ShareFileBWTest_DDD ADD constraint Pk_ShareFileBWTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ShareFileBWTest_DDD ON ShareFileBWTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CompsrLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CompsrLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO		 	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Error_Time		VARCHAR2(256) NOT NULL,
	Error_Message	VARCHAR2(4000) NOT NULL
);

ALTER TABLE CompsrLogTest_DDD ADD constraint Pk_CompsrLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CompsrLogTest_DDD ON CompsrLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HMCManagSerDetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HMCManagSerDetTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO		 	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	REFERENCE_CODE	 	VARCHAR2(256) NOT NULL,
	STATUS			VARCHAR2(256) NOT NULL,
	MESSAGE			VARCHAR2(1000) NOT NULL,
	LAST_CREATION_TIME	VARCHAR2(256) NOT NULL
);

ALTER TABLE HMCManagSerDetTest_DDD ADD constraint Pk_HMCManagSerDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HMCManagSerDetTest_DDD ON HMCManagSerDetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIODAEContrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIODAEContrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LED_Status	VARCHAR2(100) NOT NULL,
	SAS_Port1_Rate  VARCHAR2(100) NOT NULL,
	SAS_Port2_Rate  VARCHAR2(100) NOT NULL,
	Failure_Reason  VARCHAR2(100) NOT NULL,
	Firmware_Version_Error   VARCHAR2(100) NOT NULL,
	FRU_Replace_Fail_Reason  VARCHAR2(100) NOT NULL
);

ALTER TABLE  XIODAEContrTest_DDD ADD constraint Pk_XIODAEContrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XIODAEContrTest_DDD ON XIODAEContrTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIODAEPSUSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIODAEPSUSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LED_Status	VARCHAR2(100) NOT NULL,
	FRU_Replace_Fail_Reason VARCHAR2(100) NOT NULL,
	Firmware_Version_Error  VARCHAR2(100) NOT NULL,
	Power_Failure		VARCHAR2(100) NOT NULL
);

ALTER TABLE  XIODAEPSUSTest_DDD ADD constraint Pk_XIODAEPSUSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XIODAEPSUSTest_DDD ON XIODAEPSUSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIODAEsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIODAEsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Status_LED	VARCHAR2(100) NOT NULL,
	FRU_Replace_Fail_Reason  VARCHAR2(100) NOT NULL
);

ALTER TABLE  XIODAEsTest_DDD ADD constraint Pk_XIODAEsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XIODAEsTest_DDD ON XIODAEsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOInfiSwTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOInfiSwTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LED_Status	VARCHAR2(100) NOT NULL,
	FRU_Replace_Fail_Reason	VARCHAR2(100) NOT NULL,
	Firmware_Version_Error	VARCHAR2(100) NOT NULL,
	Fan1_RPM	VARCHAR2(100) NOT NULL,
	Fan2_RPM	VARCHAR2(100) NOT NULL,
	Fan3_RPM	VARCHAR2(100) NOT NULL,
	Fan4_RPM	VARCHAR2(100) NOT NULL,
	Is_Wrong_Connection_Detected	VARCHAR2(100) NOT NULL
);

ALTER TABLE  XIOInfiSwTest_DDD ADD constraint Pk_XIOInfiSwTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XIOInfiSwTest_DDD ON XIOInfiSwTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOLocalDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOLocalDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Node_ID		VARCHAR2(100) NOT NULL,
	LED_Status	VARCHAR2(100) NOT NULL,
	Disk_Expected_Type	VARCHAR2(100) NOT NULL,
	Disk_Purpose		VARCHAR2(100) NOT NULL,
	Disks_Type	VARCHAR2(100) NOT NULL,
	Encryption_Status	VARCHAR2(100) NOT NULL,
	Firmware_Version_Error	VARCHAR2(100) NOT NULL,
	FRU_Replace_Fail_Reason	VARCHAR2(100) NOT NULL
);

ALTER TABLE  XIOLocalDiskTest_DDD ADD constraint Pk_XIOLocalDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XIOLocalDiskTest_DDD ON XIOLocalDiskTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOSCNodeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOSCNodeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NMConnection_Error_Reason VARCHAR2(100) NOT NULL,
	Node_Stop_Reason	VARCHAR2(100) NOT NULL
);

ALTER TABLE  XIOSCNodeTest_DDD ADD constraint Pk_XIOSCNodeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XIOSCNodeTest_DDD ON XIOSCNodeTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOSCPSUSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOSCPSUSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LED_Status	VARCHAR2(32) NOT NULL,
	FRU_Replace_Fail_Reason	VARCHAR2(32) NOT NULL,
	Firmware_Version_Error	VARCHAR2(32) NOT NULL,
	Power_Failure	VARCHAR2(32) NOT NULL
);

ALTER TABLE  XIOSCPSUSTest_DDD ADD constraint Pk_XIOSCPSUSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XIOSCPSUSTest_DDD ON XIOSCPSUSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOSCSIPMITest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOSCSIPMITest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IPMI_Connection_Error_Reason  VARCHAR2(100) NOT NULL
);

ALTER TABLE XIOSCSIPMITest_DDD ADD constraint Pk_XIOSCSIPMITest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XIOSCSIPMITest_DDD ON XIOSCSIPMITest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOSlotsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOSlotsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Error_Reason	VARCHAR2(100) NOT NULL,
	Failure_Reason	VARCHAR2(100) NOT NULL
);

ALTER TABLE XIOSlotsTest_DDD ADD constraint Pk_XIOSlotsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XIOSlotsTest_DDD ON XIOSlotsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOXMSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOXMSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID		NUMBER(16) NOT NULL,
	IP_Version	VARCHAR2(100) NOT NULL,
	RestAPI_Version	VARCHAR2(100) NOT NULL,
	Software_Version	VARCHAR2(100) NOT NULL,
	Version		VARCHAR2(100) NOT NULL,
	Gateway		VARCHAR2(100) NOT NULL,
	IP		VARCHAR2(100) NOT NULL,
	IP_SubNetMask	VARCHAR2(100) NOT NULL,
	User_Inactive_TimeOut	VARCHAR2(100) NOT NULL
);

ALTER TABLE XIOXMSTest_DDD ADD constraint Pk_XIOXMSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_XIOXMSTest_DDD ON XIOXMSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XIOBBUsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XIOBBUsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Serial_Number	NUMBER(16) NOT NULL,
	FRU_Replace_Fail_Reason	VARCHAR2(64) NOT NULL,
	Status_LED		VARCHAR2(64) NOT NULL,
	Input_Frequency		VARCHAR2(64) NOT NULL,
	UPS_Voltage		VARCHAR2(64) NOT NULL,
	UPS_Status		VARCHAR2(64) NOT NULL,
	UPS_Alarm		VARCHAR2(64) NOT NULL,	
	Is_Low_Battery_Input		VARCHAR2(64) NOT NULL,
	Is_Low_Battery_No_Input		VARCHAR2(64) NOT NULL
);

ALTER TABLE XIOBBUsTest_DDD ADD constraint Pk_XIOBBUsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XIOBBUsTest_DDD ON XIOBBUsTest_DDD
(
 	MSMT_TIME
);
DROP TABLE WifiAvailTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WifiAvailTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	INTERFACE_DESC		VARCHAR2(128) NOT NULL,
	INTERFACE_PHY_ADD	VARCHAR2(128) NOT NULL,
	WIFI_STATE		VARCHAR2(128) NOT NULL,
	BSSID			VARCHAR2(128) NOT NULL,
	NETWORK_TYPE		VARCHAR2(128) NOT NULL,
	RADIO_TYPE		VARCHAR2(128) NOT NULL,
	AUTHETICATION		VARCHAR2(128) NOT NULL,
	CONNECTION_MODE		VARCHAR2(128) NOT NULL,
	CHANNEL 		VARCHAR2(128) NOT NULL);

ALTER TABLE  WifiAvailTest_DDD ADD constraint WifiAvailTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX1_WifiAvailTest_DDD ON WifiAvailTest_DDD (  MSMT_TIME,INFO,TRGT_HOST );

DROP TABLE HrznThinRepoTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HrznThinRepoTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Repository_Path       VARCHAR2(256) NOT NULL
);
ALTER TABLE  HrznThinRepoTest_DDD ADD constraint Pk_HrznThinRepoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznThinRepoTest_DDD ON HrznThinRepoTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HrznThinAppsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HrznThinAppsTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Host_Names	VARCHAR2(256) NOT NULL
);
ALTER TABLE  HrznThinAppsTest_DDD ADD constraint Pk_HrznThinAppsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznThinAppsTest_DDD ON HrznThinAppsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OraPdbStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  OraPdbStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWN_TIME	DATE NOT NULL,
	RESTART_TIME	DATE NOT NULL,
	DOWN_TIME_DURATION NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);
ALTER TABLE  OraPdbStatusTest_DDD ADD constraint Pk_OraPdbStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_OraPdbStatusTest_DDD ON OraPdbStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE GFireMStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  GFireMStatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID	VARCHAR2(128) NOT NULL,
	Host	VARCHAR2(128) NOT NULL,
	Process_ID	VARCHAR2(128) NOT NULL,
	Connected_Gateway_Senders	VARCHAR2(128) NOT NULL,
	Connected_Gateway_Receivers	VARCHAR2(128) NOT NULL
);

ALTER TABLE  GFireMStatTest_DDD ADD constraint Pk_GFireMStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_GFireMStatTest_DDD ON GFireMStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgTcpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VmgTcpTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Foreign_Address	VARCHAR2(32) NOT NULL,	
	noOfCurrentConn	VARCHAR2(32) NOT NULL
);

ALTER TABLE  VmgTcpTest_DDD ADD constraint Pk_VmgTcpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgTcpTest_DDD ON VmgTcpTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgLogOnDetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VmgLogOnDetTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	User_name	VARCHAR2(2000) NOT NULL,
	CSE_name	VARCHAR2(2000) NOT NULL,
	CSE_time 	VARCHAR2(2000) NOT NULL,
	CSE_id		VARCHAR2(2000) NOT NULL,
	Net_trim 	VARCHAR2(2000) NOT NULL,
	User_trim	VARCHAR2(2000) NOT NULL,
	GP_trim 	VARCHAR2(2000) NOT NULL,
	GPS_trim	VARCHAR2(2000) NOT NULL,
	Preshell_trim 	VARCHAR2(2000) NOT NULL,
	Shell_trim 	VARCHAR2(2000) NOT NULL,
	CSE_disp_name	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  VmgLogOnDetTest_DDD ADD constraint Pk_VmgLogOnDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VmgLogOnDetTest_DDD ON VmgLogOnDetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IsiCluStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IsiCluStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NAME		VARCHAR2(256) NOT NULL,
	ONLINE_NODE	VARCHAR2(128) NOT NULL,
	OFFLINE_NODE	VARCHAR2(128) NOT NULL	
);
ALTER TABLE  IsiCluStatusTest_DDD ADD constraint Pk_IsiCluStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IsiCluStatusTest_DDD ON IsiCluStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IsiNodeDrvStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IsiNodeDrvStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	BAY_NAME	VARCHAR2(32) NOT NULL,
	SIZES		NUMBER(20,4) NOT NULL
);
ALTER TABLE  IsiNodeDrvStTest_DDD ADD constraint Pk_IsiNodeDrvStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IsiNodeDrvStTest_DDD ON IsiNodeDrvStTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IsiStrPoolStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IsiStrPoolStatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NAME		VARCHAR2(128) NOT NULL,
	STATUS		VARCHAR2(128) NOT NULL,
	TYPE		VARCHAR2(128) NOT NULL
);
ALTER TABLE  IsiStrPoolStatTest_DDD ADD constraint Pk_IsiStrPoolStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IsiStrPoolStatTest_DDD ON IsiStrPoolStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UEBTotalBackupTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UEBTotalBackupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID			VARCHAR2(128) NOT NULL,
	CLIENT			VARCHAR2(128) NOT NULL,
	BACKEDUP_TIME		VARCHAR2(128) NOT NULL,
	TOTAL_BACKEDUP_FILES	VARCHAR2(128) NOT NULL
);
ALTER TABLE  UEBTotalBackupTest_DDD ADD constraint Pk_UEBTotalBackupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UEBTotalBackupTest_DDD ON UEBTotalBackupTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UEBTotalArchivTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UEBTotalArchivTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	STATUS		VARCHAR2(256) NOT NULL,
	ARCHIVED_TIME	VARCHAR2(128) NOT NULL,
	ERROR_MESSAGE	VARCHAR2(128) NOT NULL	
);
ALTER TABLE  UEBTotalArchivTest_DDD ADD constraint Pk_UEBTotalArchivTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UEBTotalArchivTest_DDD ON UEBTotalArchivTest_DDD
(
 	MSMT_TIME
);

DROP TABLE SapJ2eeThrdTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  SapJ2eeThrdTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Process_name	VARCHAR2(32) NOT NULL,
	Start_time		VARCHAR2(32) NOT NULL,
	update_time		VARCHAR2(32) NOT NULL,
	task_update_time	VARCHAR2(32) NOT NULL,
	Subtask_update_time	VARCHAR2(32) NOT NULL,
	task			VARCHAR2(32) NOT NULL,
	subtask			VARCHAR2(32) NOT NULL,
	name			VARCHAR2(64) NOT NULL,
	classname		VARCHAR2(64) NOT NULL,
	Username		VARCHAR2(64) NOT NULL,
	pool			VARCHAR2(64) NOT NULL

);
ALTER TABLE  SapJ2eeThrdTest_DDD ADD constraint Pk_SapJ2eeThrdTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_SapJ2eeThrdTest_DDD ON SapJ2eeThrdTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrResGrpTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrResGrpTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Name		VARCHAR2(512) NOT NULL,
	Type		VARCHAR2(128) NOT NULL,
	Location	VARCHAR2(512) NOT NULL
);
ALTER TABLE  AzrResGrpTest_DDD ADD constraint Pk_AzrResGrpTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AzrResGrpTest_DDD ON AzrResGrpTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrDBServerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrDBServerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Location	VARCHAR2(256) NOT NULL,
	Version		VARCHAR2(256) NOT NULL,
	Fully_Qual_DN		VARCHAR2(256) NOT NULL
);

ALTER TABLE  AzrDBServerTest_DDD ADD constraint Pk_AzrDBServerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrDBServerTest_DDD ON AzrDBServerTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrDatabaseTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrDatabaseTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Db_location	VARCHAR2(512) NOT NULL,
	Db_edition	VARCHAR2(512) NOT NULL,
	Db_service	VARCHAR2(512) NOT NULL,
	Db_collation	VARCHAR2(512) NOT NULL,
	Db_creation_date VARCHAR2(512) NOT NULL,
	Db_default_ss  VARCHAR2(512) NOT NULL
);

ALTER TABLE  AzrDatabaseTest_DDD ADD constraint Pk_AzrDatabaseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrDatabaseTest_DDD ON AzrDatabaseTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrVmTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrVmTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IP_Address	VARCHAR2(256) NOT NULL,
	OS_Type		VARCHAR2(256) NOT NULL,
	Disk_Size_Type	VARCHAR2(256) NOT NULL,
	Geo_Location	VARCHAR2(256) NOT NULL,
	Longitude	VARCHAR2(256) NOT NULL,
	Latitude	VARCHAR2(256) NOT NULL
);

ALTER TABLE  AzrVmTest_DDD ADD constraint Pk_AzrVmTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrVmTest_DDD ON AzrVmTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrWebsiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrWebsiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Website_URL	VARCHAR2(512) NOT NULL,
	Service_Plan	VARCHAR2(512) NOT NULL,
	Web_Space	VARCHAR2(512) NOT NULL,
	Tier		VARCHAR2(512) NOT NULL,
	Geo_Location	VARCHAR2(512) NOT NULL,
	Out_Bound_IP	VARCHAR2(512) NOT NULL,
	Longitude	VARCHAR2(256) NOT NULL,
	Latitude	VARCHAR2(256) NOT NULL
);

ALTER TABLE  AzrWebsiteTest_DDD ADD constraint Pk_AzrWebsiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrWebsiteTest_DDD ON AzrWebsiteTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrSubcripTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrSubcripTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ResGrp_name	VARCHAR2(256) NOT NULL,
	Resource_name	VARCHAR2(256) NOT NULL,
	Resource_type	VARCHAR2(256) NOT NULL,
	Location	VARCHAR2(256) NOT NULL,
	Longitude	VARCHAR2(512) NOT NULL,
	Latitude	VARCHAR2(512) NOT NULL,
	Status		VARCHAR2(256) NOT NULL
);

ALTER TABLE  AzrSubcripTest_DDD ADD constraint Pk_AzrSubcripTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrSubcripTest_DDD ON AzrSubcripTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrProviderTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrProviderTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Provider_Name	VARCHAR2(256) NOT NULL
);

ALTER TABLE  AzrProviderTest_DDD ADD constraint Pk_AzrProviderTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrProviderTest_DDD ON AzrProviderTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrVmStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrVmStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_Name		VARCHAR2(256) NOT NULL,
	VM_Status	VARCHAR2(256) NOT NULL,
	Location	VARCHAR2(256) NOT NULL,
	OS_Type		VARCHAR2(256) NOT NULL,
	IP_Address	VARCHAR2(256) NOT NULL
	
);

ALTER TABLE  AzrVmStatusTest_DDD ADD constraint Pk_AzrVmStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrVmStatusTest_DDD ON AzrVmStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AS400PrinterTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AS400PrinterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Device_Name	VARCHAR2(512) NOT NULL,
	Device_Class	VARCHAR2(512) NOT NULL,
	Device_Type	VARCHAR2(128) NOT NULL,
	Job_Name	VARCHAR2(512) NOT NULL,
	Job_Number		VARCHAR2(128) NOT NULL,
	Job_Status		VARCHAR2(128) NOT NULL,
	Started_By	VARCHAR2(128) NOT NULL,
	Spooled_File_Name	VARCHAR2(128) NOT NULL,
	Spooled_File_Number		VARCHAR2(128) NOT NULL,
	Output_Queue_Name		VARCHAR2(128) NOT NULL,
	Output_Queue_Status	VARCHAR2(512) NOT NULL
);
ALTER TABLE  AS400PrinterTest_DDD ADD constraint Pk_AS400PrinterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AS400PrinterTest_DDD ON AS400PrinterTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AS400SubSystemTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AS400SubSystemTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SubSystem_Name	VARCHAR2(512) NOT NULL,
	No_Of_CurrActiveJobs	VARCHAR2(512) NOT NULL,
	Library	VARCHAR2(128) NOT NULL,
	No_Of_MaximumActiveJobs	VARCHAR2(512) NOT NULL,
	Status		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AS400SubSystemTest_DDD ADD constraint Pk_AS400SubSystemTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AS400SubSystemTest_DDD ON AS400SubSystemTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AS400JobContTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AS400JobContTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Job_Name	VARCHAR2(512) NOT NULL,
	User_Name	VARCHAR2(512) NOT NULL,
	Job_Number	VARCHAR2(128) NOT NULL,
	Job_Type	VARCHAR2(512) NOT NULL,
	Status		VARCHAR2(128) NOT NULL,
	Pool		VARCHAR2(128) NOT NULL,
	Function_Name	VARCHAR2(128) NOT NULL,
	Priority	VARCHAR2(128) NOT NULL,
	Threads		VARCHAR2(128) NOT NULL,
	Queue		VARCHAR2(128) NOT NULL,
	Subsystem	VARCHAR2(512) NOT NULL,
	CPU_Used	VARCHAR2(128) NOT NULL,
	Uptime		VARCHAR2(512) NOT NULL
);
ALTER TABLE  AS400JobContTest_DDD ADD constraint Pk_AS400JobContTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AS400JobContTest_DDD ON AS400JobContTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AS400JobTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AS400JobTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Job_Name	VARCHAR2(512) NOT NULL,
	Job_Status	VARCHAR2(512) NOT NULL,
	Cpu_Used	VARCHAR2(128) NOT NULL,
	Pct_Cpu_Used	VARCHAR2(512) NOT NULL,
	Auxilary_IO	VARCHAR2(128) NOT NULL,
	User_Name	VARCHAR2(128) NOT NULL,
	Job_Type	VARCHAR2(128) NOT NULL,
	Job_Description	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AS400JobTest_DDD ADD constraint Pk_AS400JobTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AS400JobTest_DDD ON AS400JobTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AS400MessageTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AS400MessageTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Message_id	VARCHAR2(512) NOT NULL,
	Severity		VARCHAR2(128) NOT NULL,
	Type		VARCHAR2(128) NOT NULL,
	Message		VARCHAR2(1000) NOT NULL,
	Creation_date		VARCHAR2(128) NOT NULL,
	Default_reply		VARCHAR2(128) NOT NULL,
	Help		VARCHAR2(4000) NOT NULL
);
ALTER TABLE  AS400MessageTest_DDD ADD constraint Pk_AS400MessageTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AS400MessageTest_DDD ON AS400MessageTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AS400JobMntrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AS400JobMntrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Job_Name	VARCHAR2(512) NOT NULL,
	User_Name	VARCHAR2(512) NOT NULL,
	Job_number	VARCHAR2(128) NOT NULL,
	Job_type	VARCHAR2(512) NOT NULL,
	Status		VARCHAR2(128) NOT NULL,
	Pool		VARCHAR2(128) NOT NULL,
	Function_Name	VARCHAR2(128) NOT NULL,
	Priority	VARCHAR2(128) NOT NULL,
	Threads		VARCHAR2(128) NOT NULL,
	Queue		VARCHAR2(128) NOT NULL,
	Subsystem	VARCHAR2(512) NOT NULL,
	CPU_Used	VARCHAR2(128) NOT NULL,
	Uptime		VARCHAR2(512) NOT NULL
);
ALTER TABLE  AS400JobMntrTest_DDD ADD constraint Pk_AS400JobMntrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AS400JobMntrTest_DDD ON AS400JobMntrTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AS400SpFileTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AS400SpFileTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Spool_Name	 VARCHAR2(128) NOT NULL,
	Spool_Number	VARCHAR2(128) NOT NULL,
	Job_Name	VARCHAR2(128) NOT NULL,
	Job_Number	 VARCHAR2(128) NOT NULL,
	Job_Owner	VARCHAR2(128) NOT NULL,
	Status		VARCHAR2(128) NOT NULL,
	Printer_Name	VARCHAR2(512) NOT NULL,
	Total_Pages	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AS400SpFileTest_DDD ADD constraint Pk_AS400SpFileTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AS400SpFileTest_DDD ON AS400SpFileTest_DDD
(
 	MSMT_TIME
);

DROP TABLE MariaLongRunQryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MariaLongRunQryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID		VARCHAR2(16) NOT NULL,
	USER_NAME	VARCHAR2(32) NOT NULL,
	HOST		VARCHAR2(64) NOT NULL,
	DB_NAME		VARCHAR2(32) NOT NULL,
	DURATION 	VARCHAR2(20) NOT NULL,
	STATUS		VARCHAR2(32) NOT NULL,
	QUERY_TEXT	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  MariaLongRunQryTest_DDD ADD constraint Pk_MariaLongRunQryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaLongRunQryTest_DDD ON MariaLongRunQryTest_DDD(MSMT_TIME);

DROP TABLE MariaStatsTest_DDD  CASCADE CONSTRAINTS;
CREATE TABLE  MariaStatsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	THREAD_ID	VARCHAR2(32) NOT NULL,
	EVENT_ID	VARCHAR2(32) NOT NULL,
	EVENT_NAME	VARCHAR2(32) NOT NULL,
	START_TIME	VARCHAR2(32) NOT NULL,
	END_TIME	VARCHAR2(32) NOT NULL,
	DURATION	VARCHAR2(32) NOT NULL,
	SQL_STATEMENT	VARCHAR2(2048) NOT NULL
);
ALTER TABLE  MariaStatsTest_DDD ADD constraint Pk_MariaStatsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaStatsTest_DDD ON MariaStatsTest_DDD(MSMT_TIME);

DROP TABLE MariaWaitEvtTest_DDD  CASCADE CONSTRAINTS;
CREATE TABLE  MariaWaitEvtTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	THREAD_ID	VARCHAR2(32) NOT NULL,
	EVENT_ID	VARCHAR2(32) NOT NULL,
	EVENT_NAME	VARCHAR2(32) NOT NULL,
	START_TIME	VARCHAR2(32) NOT NULL,
	END_TIME	VARCHAR2(32) NOT NULL,
	DURATION	VARCHAR2(32) NOT NULL,
	SOURCE		VARCHAR2(256) NOT NULL,
	OPERATION	VARCHAR2(256) NOT NULL
	
);
ALTER TABLE  MariaWaitEvtTest_DDD ADD constraint Pk_MariaWaitEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaWaitEvtTest_DDD ON MariaWaitEvtTest_DDD(MSMT_TIME);

DROP TABLE MariaEvtStmtTest_DDD  CASCADE CONSTRAINTS;
CREATE TABLE  MariaEvtStmtTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	THREAD_ID	VARCHAR2(32) NOT NULL,
	EVENT_ID	VARCHAR2(32) NOT NULL,
	EVENT_NAME	VARCHAR2(32) NOT NULL,
	START_TIME	VARCHAR2(32) NOT NULL,
	END_TIME	VARCHAR2(32) NOT NULL,
	DURATION	VARCHAR2(32) NOT NULL,
	LOCK_TIME	VARCHAR2(32) NOT NULL,
	SQL_STATEMENT	VARCHAR2(2048) NOT NULL
	
);
ALTER TABLE  MariaEvtStmtTest_DDD ADD constraint Pk_MariaEvtStmtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaEvtStmtTest_DDD ON MariaEvtStmtTest_DDD(MSMT_TIME);

DROP TABLE MariaEvtStgTest_DDD  CASCADE CONSTRAINTS;
CREATE TABLE  MariaEvtStgTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	THREAD_ID	VARCHAR2(32) NOT NULL,
	EVENT_ID	VARCHAR2(32) NOT NULL,
	EVENT_NAME	VARCHAR2(32) NOT NULL,
	START_TIME	VARCHAR2(32) NOT NULL,
	END_TIME	VARCHAR2(32) NOT NULL,
	DURATION	VARCHAR2(32) NOT NULL,
	SOURCE		VARCHAR2(256) NOT NULL
	
);
ALTER TABLE  MariaEvtStgTest_DDD ADD constraint Pk_MariaEvtStgTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaEvtStgTest_DDD ON MariaEvtStgTest_DDD(MSMT_TIME);

DROP TABLE MariaUsrProcTest_DDD  CASCADE CONSTRAINTS;
CREATE TABLE  MariaUsrProcTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID		VARCHAR2(16) NOT NULL,
	USER_NAME	VARCHAR2(32) NOT NULL,
	HOST		VARCHAR2(64) NOT NULL,
	DB_NAME		VARCHAR2(32) NOT NULL,
	TIME	 	VARCHAR2(20) NOT NULL,
	STATUS		VARCHAR2(32) NOT NULL,
	QUERY_TEXT	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  MariaUsrProcTest_DDD ADD constraint Pk_MariaUsrProcTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaUsrProcTest_DDD ON MariaUsrProcTest_DDD(MSMT_TIME);

DROP TABLE MariaConStatTest_DDD  CASCADE CONSTRAINTS;
CREATE TABLE  MariaConStatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IP		VARCHAR2(16) NOT NULL,
	HOST		VARCHAR2(64) NOT NULL,
	FIRST_SEEN	VARCHAR2(32) NOT NULL,
	LAST_SEEN	VARCHAR2(32) NOT NULL,
	FIRST_ERROR_SEEN VARCHAR2(32) NOT NULL,
	LAST_ERROR_SEEN	VARCHAR2(32) NOT NULL
);
ALTER TABLE  MariaConStatTest_DDD ADD constraint Pk_MariaConStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaConStatTest_DDD ON MariaConStatTest_DDD(MSMT_TIME);

DROP TABLE MariaSqlNetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE MariaSqlNetTest_DDD
(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    MESSAGE    VARCHAR2(2000) NOT NULL
    
); 
ALTER TABLE  MariaSqlNetTest_DDD ADD constraint Pk_MariaSqlNetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO); 
CREATE  INDEX IDX_MariaSqlNetTest_DDD ON MariaSqlNetTest_DDD(MSMT_TIME);

DROP TABLE MariaUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  MariaUptimeTest_DDD
(
	SITE_NAME			VARCHAR2(64) NOT NULL,
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	TEST_NAME			VARCHAR2(64) NOT NULL,
	MEASURE				VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	STATE				VARCHAR2(32) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	SEQ_NO 				NUMBER(16) NOT NULL,
	SHUTDOWNDATE			DATE NOT NULL,
	REBOOTEDDATE			DATE NOT NULL,
	DURATION			NUMBER(20,4) NOT NULL,
	MAINTENANCE			VARCHAR2(32) NOT NULL
);
ALTER TABLE  MariaUptimeTest_DDD ADD constraint Pk_MariaUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_MariaUptimeTest_DDD ON MariaUptimeTest_DDD(MSMT_TIME);

DROP TABLE HrznLogonSimTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HrznLogonSimTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Messages	VARCHAR2(2000) NOT NULL,
	Published_resources	VARCHAR2(2000) NOT NULL,
	Screenshot_Id       VARCHAR2(256) NOT NULL
);
ALTER TABLE  HrznLogonSimTest_DDD ADD constraint Pk_HrznLogonSimTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznLogonSimTest_DDD ON HrznLogonSimTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DeviceSyslogMsgs_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DeviceSyslogMsgs_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	EVT_INFO	VARCHAR2(256) NOT NULL,
	EVT_HOST	VARCHAR2(256) NOT NULL,
	EVT_PROGRAM	VARCHAR2(2000) NOT NULL);
ALTER TABLE  DeviceSyslogMsgs_DDD ADD constraint Pk_DeviceSyslogMsgs_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_DeviceSyslogMsgs_DDD ON DeviceSyslogMsgs_DDD
(
 	MSMT_TIME
);

DROP TABLE UCSCsFaultTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSCsFaultTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Affected_object		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Fault_ID		VARCHAR2(128) NOT NULL,
	Fault_Code	VARCHAR2(128) NOT NULL,
	Fault_Cause		VARCHAR2(128) NOT NULL,
	Fault_Type		VARCHAR2(128) NOT NULL,
	Fault_Tags		VARCHAR2(128) NOT NULL,
	Fault_Rule		VARCHAR2(128) NOT NULL,
	Created_Time		VARCHAR2(128) NOT NULL,
	Last_Transition	VARCHAR2(128) NOT NULL,
	Original_Severity	VARCHAR2(128) NOT NULL,
	Severity		VARCHAR2(128) NOT NULL,
	Previous_Severity		VARCHAR2(128) NOT NULL,
	Highest_Severity		VARCHAR2(128) NOT NULL,
	Occurrence		VARCHAR2(128) NOT NULL,
	Acknowledge	VARCHAR2(128) NOT NULL,
	Change_Set	VARCHAR2(128) NOT NULL,
	Line_Cards	VARCHAR2(128) NOT NULL);

ALTER TABLE UCSCsFaultTest_DDD ADD constraint Pk_UCSCsFaultTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSCsFaultTest_DDD ON UCSCsFaultTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UCSFIConnsFanMTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE UCSFIConnsFanMTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Id		VARCHAR2(32) NOT NULL,
	Pid		VARCHAR2(32) NOT NULL,
	Revision	VARCHAR2(32) NOT NULL,
	Serial_No	VARCHAR2(64) NOT NULL,
	Tray		VARCHAR2(32) NOT NULL,
	Vendor		VARCHAR2(128) NOT NULL
);

ALTER TABLE UCSFIConnsFanMTest_DDD ADD constraint Pk_UCSFIConnsFanMTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_UCSFIConnsFanMTest_DDD ON UCSFIConnsFanMTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ZingJvmMemoryUsage_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ZingJvmMemoryUsage_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO 			NUMBER(16) NOT NULL,
	PID			NUMBER(16) NOT NULL,
	USERNAME		VARCHAR2(128) NOT NULL,
	LINUX_MEM_USED		NUMBER(20,4) NOT NULL,
	ZING_MEM_USED		NUMBER(20,4) NOT NULL,
	XMX_VALUE		NUMBER(20,4) NOT NULL,
	CONTINGENCY_MEM_USED	NUMBER(20,4) NOT NULL,
	PAUSE_PRE_MEM_USED	NUMBER(20,4) NOT NULL,
	JAVA_SYSTEM_MEM_USED	NUMBER(20,4) NOT NULL,
	COMMAND			VARCHAR2(2048) NOT NULL
);
ALTER TABLE  ZingJvmMemoryUsage_DDD ADD constraint Pk_ZingJvmMemoryUsage_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ZingJvmMemoryUsage_DDD ON ZingJvmMemoryUsage_DDD
(
 	MSMT_TIME
);

DROP TABLE CloudVmStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CloudVmStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VM_NAME			VARCHAR2(128) NOT NULL,
	VM_IPADDRESS		VARCHAR2(128) NOT NULL,
	VM_OSNAME		VARCHAR2(128) NOT NULL,
	VM_USER			VARCHAR2(128) NOT NULL
);
ALTER TABLE  CloudVmStatusTest_DDD ADD constraint Pk_CloudVmStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CloudVmStatusTest_DDD ON CloudVmStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE PrntrQMntrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  PrntrQMntrTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Queue_name	VARCHAR2(256) NOT NULL,
	Device_name	VARCHAR2(256) NOT NULL,
	Status		VARCHAR2(256) NOT NULL,
	Job_number	VARCHAR2(256) NOT NULL,
	File_name	VARCHAR2(512) NOT NULL,
	User_name	VARCHAR2(256) NOT NULL,
	Pages_printed	VARCHAR2(256) NOT NULL,
	Job_printed	VARCHAR2(256) NOT NULL,
	Blocks		VARCHAR2(256) NOT NULL,
	No_of_copies	VARCHAR2(256) NOT NULL,
	Printing_order	VARCHAR2(256) NOT NULL 
);

ALTER TABLE  PrntrQMntrTest_DDD ADD constraint Pk_PrntrQMntrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_PrntrQMntrTest_DDD ON PrntrQMntrTest_DDD
(
	MSMT_TIME 
);

DROP TABLE VmgOutlookAddinTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VmgOutlookAddinTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DESCRIPTION			varchar2(2000) NOT NULL,
	PROGRAM_ID			varchar2(512) NOT NULL,
	ADDIN_GUID			varchar2(128) NOT NULL,
	LOAD_BEHAVIOUR		varchar2(64) NOT NULL,
	LOCATION	varchar2(2000) NOT NULL
);
ALTER TABLE  VmgOutlookAddinTest_DDD ADD constraint Pk_VmgOutlookAddinTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VmgOutlookAddinTest_DDD ON VmgOutlookAddinTest_DDD
(
 	MSMT_TIME
);

DROP TABLE OutlookAddinTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  OutlookAddinTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DESCRIPTION			varchar2(2000) NOT NULL,
	PROGRAM_ID			varchar2(512) NOT NULL,
	ADDIN_GUID			varchar2(128) NOT NULL,
	LOAD_BEHAVIOUR		varchar2(64) NOT NULL,
	LOCATION	varchar2(2000) NOT NULL
);
ALTER TABLE  OutlookAddinTest_DDD ADD constraint Pk_OutlookAddinTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_OutlookAddinTest_DDD ON OutlookAddinTest_DDD
(
 	MSMT_TIME
);

DROP TABLE BWProcChainTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BWProcChainTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Log_id			VARCHAR2(128) NOT NULL,
	Process_name		VARCHAR2(128) NOT NULL,
	Process_status		VARCHAR2(32) NOT NULL,
	Duration		VARCHAR2(32) NOT NULL,
	Start_time		VARCHAR2(32) NOT NULL,
	End_time		VARCHAR2(32) NOT NULL,
	Batch_time		VARCHAR2(32) NOT NULL,
	Job_ID			VARCHAR2(32) NOT NULL,
	Error_log		VARCHAR2(2000) NOT NULL
);
ALTER TABLE  BWProcChainTest_DDD ADD constraint Pk_BWProcChainTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BWProcChainTest_DDD ON BWProcChainTest_DDD
(
 	MSMT_TIME
);






DROP TABLE BWOHDStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BWOHDStatTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Infospoke		VARCHAR2(32) NOT NULL,
	Infospoke_version	VARCHAR2(32) NOT NULL,
	Request_state		VARCHAR2(32) NOT NULL,
	Response_time		VARCHAR2(32) NOT NULL,
	Start_time		VARCHAR2(32) NOT NULL,
	End_time		VARCHAR2(32) NOT NULL,
	Lines_read		VARCHAR2(32) NOT NULL,
	Data_source		VARCHAR2(128) NOT NULL,
	Destination_type	VARCHAR2(128) NOT NULL,
	Destination		VARCHAR2(32) NOT NULL,  
	Job			VARCHAR2(32) NOT NULL,  
	Log_ID			VARCHAR2(128) NOT NULL,		
	Request_ID		VARCHAR2(128) NOT NULL,  
	Update_mode		VARCHAR2(64) NOT NULL
	
);				
ALTER TABLE  BWOHDStatTest_DDD ADD constraint Pk_BWOHDStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BWOHDStatTest_DDD ON BWOHDStatTest_DDD
(
 	MSMT_TIME
);



DROP TABLE BWQueryStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BWQueryStatTest_DDD
(
	SITE_NAME				VARCHAR2(64) NOT NULL,
	TRGT_HOST				VARCHAR2(32) NOT NULL,
	PORT_NO					VARCHAR2(32)NOT NULL,
	TEST_NAME				VARCHAR2(64) NOT NULL,
	MEASURE					VARCHAR2(64) NOT NULL,
	INFO					VARCHAR2(128) NOT NULL,
	STATE					VARCHAR2(32) NOT NULL,
	MSMT_HOST				VARCHAR2(32) NOT NULL,
	MSMT_TIME				DATE NOT NULL,
	SEQ_NO					NUMBER(16) NOT NULL,
	User_name				VARCHAR2(64) NOT NULL,
	Infoprovider				VARCHAR2(128) NOT NULL,
	Start_time				VARCHAR2(64) NOT NULL,
	Selected_records			VARCHAR2(32) NOT NULL,
	Transported_records			VARCHAR2(32) NOT NULL,
	Response_time				VARCHAR2(64) NOT NULL,
	OLAP_time				VARCHAR2(64) NOT NULL,
	OLAP_cache_time				VARCHAR2(64) NOT NULL,
	Data_manager_time			VARCHAR2(32) NOT NULL,
	OLAP_authorization_time			VARCHAR2(32) NOT NULL,
	OLAP_input_help_time			VARCHAR2(32) NOT NULL,
	OLAP_services_time			VARCHAR2(32) NOT NULL,
	Query_Generation_time			VARCHAR2(32) NOT NULL,
	Data_read_time				VARCHAR2(32) NOT NULL,
	Data_selection_time			VARCHAR2(32) NOT NULL,
	Front_end_data_transfer_time		VARCHAR2(64) NOT NULL,
	Read_texts_time				VARCHAR2(32) NOT NULL,
	Badi_compute_time			VARCHAR2(32) NOT NULL,
	Other_events_time			VARCHAR2(32) NOT NULL,
	Properties				VARCHAR2(32) NOT NULL,
	Session_ID				VARCHAR2(128) NOT NULL,
	Step_ID					VARCHAR2(128) NOT NULL,
	Handle_ID				VARCHAR2(32) NOT NULL

	
);				
ALTER TABLE  BWQueryStatTest_DDD ADD constraint Pk_BWQueryStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BWQueryStatTest_DDD ON BWQueryStatTest_DDD
(
 	MSMT_TIME
);



DROP TABLE BWTempStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BWTempStatTest_DDD
(
	SITE_NAME				VARCHAR2(64) NOT NULL,
	TRGT_HOST				VARCHAR2(32) NOT NULL,
	PORT_NO					VARCHAR2(32)NOT NULL,
	TEST_NAME				VARCHAR2(64) NOT NULL,
	MEASURE					VARCHAR2(64) NOT NULL,
	INFO					VARCHAR2(128) NOT NULL,
	STATE					VARCHAR2(32) NOT NULL,
	MSMT_HOST				VARCHAR2(32) NOT NULL,
	MSMT_TIME				DATE NOT NULL,
	SEQ_NO					NUMBER(16) NOT NULL,
	User_name				VARCHAR2(128) NOT NULL,
	Start_time				VARCHAR2(64) NOT NULL,
	Info_provider				VARCHAR2(128) NOT NULL,
	Response_time				VARCHAR2(32) NOT NULL,
	Load_time				VARCHAR2(64) NOT NULL,
	Query_time				VARCHAR2(64) NOT NULL,
	Web_item_rendering_time			VARCHAR2(64) NOT NULL,
	Web_reporting_time			VARCHAR2(64) NOT NULL,
	Closing_time				VARCHAR2(32) NOT NULL,
	Queries					VARCHAR2(32) NOT NULL,
	OLAP_time				VARCHAR2(32) NOT NULL,
	Data_manager_time			VARCHAR2(32) NOT NULL,
	Number_of_web_items			VARCHAR2(32) NOT NULL,
	Session_ID				VARCHAR2(128) NOT NULL,
	Step_ID					VARCHAR2(128) NOT NULL,
	Handle_ID				VARCHAR2(32) NOT NULL,
	Object_properties			VARCHAR2(32) NOT NULL,
	Query_name				VARCHAR2(128) NOT NULL,
	Selected_records			VARCHAR2(32) NOT NULL,
	Transported_records			VARCHAR2(32) NOT NULL,
	OLAP_cache_time				VARCHAR2(32) NOT NULL,
	OLAP_authorization_time			VARCHAR2(32) NOT NULL,
	OLAP_input_help_time			VARCHAR2(32) NOT NULL,
	OLAP_services_time			VARCHAR2(32) NOT NULL,
	Query_Generation_time			VARCHAR2(32) NOT NULL,
	Data_read_time				VARCHAR2(32) NOT NULL,
	Data_selection_time			VARCHAR2(32) NOT NULL,
	Front_end_data_transfer_time		VARCHAR2(32) NOT NULL,
	Read_texts_time				VARCHAR2(32) NOT NULL,
	Badi_compute_time			VARCHAR2(32) NOT NULL,
	Other_events_time			VARCHAR2(32) NOT NULL
 

);				
ALTER TABLE  BWTempStatTest_DDD ADD constraint Pk_BWTempStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BWTempStatTest_DDD ON BWTempStatTest_DDD
(
 	MSMT_TIME
);


					

DROP TABLE BWWorkBkStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  BWWorkBkStatTest_DDD
(
	SITE_NAME				VARCHAR2(64) NOT NULL,
	TRGT_HOST				VARCHAR2(32) NOT NULL,
	PORT_NO					VARCHAR2(32)NOT NULL,
	TEST_NAME				VARCHAR2(64) NOT NULL,
	MEASURE					VARCHAR2(64) NOT NULL,
	INFO					VARCHAR2(128) NOT NULL,
	STATE					VARCHAR2(32) NOT NULL,
	MSMT_HOST				VARCHAR2(32) NOT NULL,
	MSMT_TIME				DATE NOT NULL,
	SEQ_NO					NUMBER(16) NOT NULL,
	User_name				VARCHAR2(64) NOT NULL,
	Start_time				VARCHAR2(64) NOT NULL,
	Info_provider				VARCHAR2(64) NOT NULL,
	Response_time				VARCHAR2(32) NOT NULL,
	Loading_or_generation_time		VARCHAR2(32) NOT NULL,
	Query_time				VARCHAR2(64) NOT NULL,
	Serialize_deserialize_time		VARCHAR2(64) NOT NULL,
	Read_time				VARCHAR2(64) NOT NULL,
	Front_end_transfer_time			VARCHAR2(64) NOT NULL,
	Processing_time				VARCHAR2(32) NOT NULL,
	Rendering_time				VARCHAR2(32) NOT NULL,
	Other_event_time			VARCHAR2(32) NOT NULL,
	Queries					VARCHAR2(32) NOT NULL,
	OLAP_time				VARCHAR2(32) NOT NULL,
	Data_manager_time			VARCHAR2(32) NOT NULL,
	Object_properties			VARCHAR2(128) NOT NULL,
	Session_ID				VARCHAR2(128) NOT NULL,
	Step_ID					VARCHAR2(128) NOT NULL,
	Handle_ID				VARCHAR2(32) NOT NULL,
	Query_name				VARCHAR2(128) NOT NULL,
	Selected_records			VARCHAR2(32) NOT NULL,
	Transported_records			VARCHAR2(32) NOT NULL,
	OLAP_cache_time				VARCHAR2(32) NOT NULL,
	OLAP_authorization_time			VARCHAR2(32) NOT NULL,
	OLAP_input_help_time			VARCHAR2(32) NOT NULL,
	OLAP_services_time			VARCHAR2(32) NOT NULL,
	Query_Generation_time			VARCHAR2(32) NOT NULL,
	Data_read_time				VARCHAR2(32) NOT NULL,
	Data_selection_time			VARCHAR2(32) NOT NULL,
	Front_end_data_transfer_time		VARCHAR2(32) NOT NULL,
	Read_texts_time				VARCHAR2(32) NOT NULL,
	Badi_compute_time			VARCHAR2(32) NOT NULL,
	Other_events_time			VARCHAR2(32) NOT NULL


);				
ALTER TABLE  BWWorkBkStatTest_DDD ADD constraint Pk_BWWorkBkStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_BWWorkBkStatTest_DDD ON BWWorkBkStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IfxResponseTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IfxResponseTest_DDD(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    MESSAGE    VARCHAR2(2000) NOT NULL);
 
ALTER TABLE  IfxResponseTest_DDD ADD constraint Pk_IfxResponseTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IfxResponseTest_DDD ON IfxResponseTest_DDD( MSMT_TIME);

DROP TABLE IfxUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IfxUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL);

ALTER TABLE IfxUptimeTest_DDD ADD constraint Pk_IfxUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IfxUptimeTest_DDD ON IfxUptimeTest_DDD(MSMT_TIME);

DROP TABLE IfxUnUsedIdxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IfxUnUsedIdxTest_DDD(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	TABLE_NAME	VARCHAR2(32) NOT NULL,
	INDEX_NAME	VARCHAR2(32) NOT NULL,
	INDEX_SIZE 	VARCHAR2(32) NOT NULL);

ALTER TABLE IfxUnUsedIdxTest_DDD ADD constraint Pk_IfxUnUsedIdxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_IfxUnUsedIdxTest_DDD ON IfxUnUsedIdxTest_DDD(	MSMT_TIME);

DROP TABLE IfxWorkloadTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IfxWorkloadTest_DDD(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	USER_NAME	VARCHAR2(32) NOT NULL,
	DB_NAME 	VARCHAR2(32) NOT NULL,
	PHYSICAL_READS 	VARCHAR2(32) NOT NULL,
	BUFFER_READS	VARCHAR2(32) NOT NULL,
	ELAPSED_TIME	VARCHAR2(32) NOT NULL,
	LOCKS_COUNT 	VARCHAR2(32) NOT NULL,	
	LOCK_WAITS	VARCHAR2(32) NOT NULL,
	LOCK_WAIT_TIME	VARCHAR2(32) NOT NULL,
	IO_WAIT_TIME 	VARCHAR2(32) NOT NULL,	
	EXECUTIONS	VARCHAR2(32) NOT NULL,	
	SQL_TEXT 	VARCHAR2(2000) NOT NULL);

ALTER TABLE IfxWorkloadTest_DDD ADD constraint Pk_IfxWorkloadTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IfxWorkloadTest_DDD ON IfxWorkloadTest_DDD(MSMT_TIME);

DROP TABLE IfxNetworkIoTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IfxNetworkIoTest_DDD(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SID		VARCHAR2(32) NOT NULL,
	USER_NAME	VARCHAR2(32) NOT NULL,
	CLIENT_NAME 	VARCHAR2(32) NOT NULL,
	CLIENT_PROTOCOL	VARCHAR2(32) NOT NULL,
	READ_COUNT	VARCHAR2(32) NOT NULL,
	READ_SIZE 	VARCHAR2(32) NOT NULL,	
	WRITE_COUNT	VARCHAR2(32) NOT NULL,
	WRITE_SIZE	VARCHAR2(32) NOT NULL);

ALTER TABLE IfxNetworkIoTest_DDD ADD constraint Pk_IfxNetworkIoTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IfxNetworkIoTest_DDD ON IfxNetworkIoTest_DDD(	MSMT_TIME);

DROP TABLE IfxLngRunQryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IfxLngRunQryTest_DDD(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SQL_ID		VARCHAR2(32) NOT NULL,
	SESSION_ID 	VARCHAR2(32) NOT NULL,
	USER_NAME 	VARCHAR2(32) NOT NULL,
	DB_NAME		VARCHAR2(32) NOT NULL,
	SQL_AVERAGE_TIME VARCHAR2(32) NOT NULL,		
	SQL_RUN_TIME	VARCHAR2(32) NOT NULL,
	EXECUTIONS	VARCHAR2(32) NOT NULL,
	SQL_STATEMENT 	VARCHAR2(32) NOT NULL,		
	SQL_TEXT 	VARCHAR2(2000) NOT NULL);

ALTER TABLE IfxLngRunQryTest_DDD ADD constraint Pk_IfxLngRunQryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_IfxLngRunQryTest_DDD ON IfxLngRunQryTest_DDD(	MSMT_TIME);

DROP TABLE VNXeLUNTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeLUNTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LUN_ID	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	LUN_ACCESS_HOST	VARCHAR2(100) NOT NULL,
	THIN_PROVISIONING	VARCHAR2(32) NOT NULL,
	SNAPSHOT_COUNT	VARCHAR2(32) NOT NULL,
	REPLICATION_DESTINATION	VARCHAR2(32) NOT NULL,
	WWN	VARCHAR2(100) NOT NULL,
	CREATION_TIME	VARCHAR2(32) NOT NULL,
	LAST_MODIFIED_TIME	VARCHAR2(32) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL,
	QUEUE_LENGTH	VARCHAR2(32) NOT NULL,
	RESPONSE_TIME	VARCHAR2(32) NOT NULL
);
ALTER TABLE  VNXeLUNTest_DDD ADD constraint Pk_VNXeLUNTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeLUNTest_DDD ON VNXeLUNTest_DDD
(
 	MSMT_TIME
);



DROP TABLE VNXeEnetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeEnetTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	PROTOCOLS	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MTU_SIZE	VARCHAR2(32) NOT NULL,
	REQUESTED_MTU_SIZE	VARCHAR2(32) NOT NULL,
	AVALIABLE_MTU_SIZE	VARCHAR2(32) NOT NULL,
	SPEED	VARCHAR2(32) NOT NULL,
	REQUESTED_SPEED	VARCHAR2(32) NOT NULL,
	AVALIBLE_SPEED	VARCHAR2(32) NOT NULL,
	AGGREGATED_PORT_ID	VARCHAR2(32) NOT NULL,
	CONNECTOR_TYPE	VARCHAR2(32) NOT NULL,
	MAC_ADDRESS	VARCHAR2(32) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	BYTES_IN	VARCHAR2(32) NOT NULL,
	BYTES_OUT	VARCHAR2(32) NOT NULL,
	PACKETS_IN	VARCHAR2(32) NOT NULL,
	PACKETS_OUT	VARCHAR2(32) NOT NULL
	
);
ALTER TABLE  VNXeEnetTest_DDD ADD constraint Pk_VNXeEnetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeEnetTest_DDD ON VNXeEnetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VNXeDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL,
	SERVICE_TIME	VARCHAR2(32) NOT NULL,
	RESPONSE_TIME	VARCHAR2(32) NOT NULL
	
	
);
ALTER TABLE  VNXeDiskTest_DDD ADD constraint Pk_VNXeDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeDiskTest_DDD ON VNXeDiskTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeFibreTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeFibreTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	SPEED	VARCHAR2(32) NOT NULL,
	REQUESTED_SPEED	VARCHAR2(32) NOT NULL,
	AVALIABLE_SPEED	VARCHAR2(32) NOT NULL,
	CONNECTOR_TYPE	VARCHAR2(32) NOT NULL,
	WWN	VARCHAR2(100) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
		
	
);
ALTER TABLE  VNXeFibreTest_DDD ADD constraint Pk_VNXeFibreTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeFibreTest_DDD ON VNXeFibreTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeiSCSITest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeiSCSITest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
	
		
	
);
ALTER TABLE  VNXeiSCSITest_DDD ADD constraint Pk_VNXeiSCSITest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeiSCSITest_DDD ON VNXeiSCSITest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeCacheTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeCacheTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_HITS	VARCHAR2(32) NOT NULL,
	READ_MISSES	VARCHAR2(32) NOT NULL,
	WRITE_HITS	VARCHAR2(32) NOT NULL,
	WRITE_MISSES	VARCHAR2(32) NOT NULL,
	DIRTY_CACHE_SIZE	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  VNXeCacheTest_DDD ADD constraint Pk_VNXeCacheTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeCacheTest_DDD ON VNXeCacheTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeCIFSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeCIFSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  VNXeCIFSTest_DDD ADD constraint Pk_VNXeCIFSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeCIFSTest_DDD ON VNXeCIFSTest_DDD
(
 	MSMT_TIME
);




DROP TABLE VNXeNFSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeNFSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
);
ALTER TABLE  VNXeNFSTest_DDD ADD constraint Pk_VNXeNFSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeNFSTest_DDD ON VNXeNFSTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeBatteryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeBatteryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAIL	VARCHAR2(32) NOT NULL,
	MANUFACTURER	VARCHAR2(32) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL
	
);
ALTER TABLE  VNXeBatteryTest_DDD ADD constraint Pk_VNXeBatteryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeBatteryTest_DDD ON VNXeBatteryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeDPETest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeDPETest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HEALTH_DETAIL	VARCHAR2(32) NOT NULL,
	MANUFACTURER	VARCHAR2(32) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	PRESENT_POWER	VARCHAR2(32) NOT NULL,
	POWER_ROLLING_AVERAGE	VARCHAR2(32) NOT NULL,
	TEMPERATURE	VARCHAR2(32) NOT NULL
	
	
);
ALTER TABLE  VNXeDPETest_DDD ADD constraint Pk_VNXeDPETest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeDPETest_DDD ON VNXeDPETest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeSPTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeSPTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_NAME	VARCHAR2(32) NOT NULL,
	HEALTH_DETAIL	VARCHAR2(500) NOT NULL,
	DPE	VARCHAR2(32) NOT NULL,
	MODES	VARCHAR2(32) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	UTILIZATION	VARCHAR2(32) NOT NULL
	
	
);
ALTER TABLE  VNXeSPTest_DDD ADD constraint Pk_VNXeSPTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeSPTest_DDD ON VNXeSPTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VNXeHostTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeHostTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ADDRESS	VARCHAR2(1024) NOT NULL,
	OS_TYPE	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(1024) NOT NULL
);
ALTER TABLE  VNXeHostTest_DDD ADD constraint Pk_VNXeHostTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeHostTest_DDD ON VNXeHostTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VNXeInitiTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeInitiTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HOST	VARCHAR2(32) NOT NULL,
	UID_NO	VARCHAR2(100) NOT NULL,
	INITITATOR_TYPE	VARCHAR2(32) NOT NULL,
	PORT_LOGIN	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL
	
	
);
ALTER TABLE  VNXeInitiTest_DDD ADD constraint Pk_VNXeInitiTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeInitiTest_DDD ON VNXeInitiTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VNXeSASTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeSASTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SAS_ID	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	CONNECTOR_TYPE	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL
		
);
ALTER TABLE  VNXeSASTest_DDD ADD constraint Pk_VNXeSASTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeSASTest_DDD ON VNXeSASTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeFanTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeFanTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	FAN_ID	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  VNXeFanTest_DDD ADD constraint Pk_VNXeFanTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeFanTest_DDD ON VNXeFanTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXePowerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXePowerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	POWER_SUPPLY_ID	VARCHAR2(32) NOT NULL,
	SP	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MANUFACTURER	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  VNXePowerTest_DDD ADD constraint Pk_VNXePowerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXePowerTest_DDD ON VNXePowerTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeIOTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeIOTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IO_ID	VARCHAR2(32) NOT NULL,
	SP	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  VNXeIOTest_DDD ADD constraint Pk_VNXeIOTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeIOTest_DDD ON VNXeIOTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeMemoryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MEMORY_ID	VARCHAR2(32) NOT NULL,
	SP	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  VNXeMemoryTest_DDD ADD constraint Pk_VNXeMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeMemoryTest_DDD ON VNXeMemoryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeStrPoolsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeStrPoolsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	STORAGE_POOL_ID	VARCHAR2(32) NOT NULL,
	DESCRIPTION	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	ALERT_THRESHOLD	VARCHAR2(32) NOT NULL,
	RAID_LEVEL	VARCHAR2(32) NOT NULL,
	FAST_CACHE_ENABLED	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  VNXeStrPoolsTest_DDD ADD constraint Pk_VNXeStrPoolsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeStrPoolsTest_DDD ON VNXeStrPoolsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeDiskConfTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeDiskConfTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DISK_ID	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	DISK_TYPE	VARCHAR2(32) NOT NULL,
	ROTATIONAL_SPEED	VARCHAR2(32) NOT NULL,
	CURRENT_SPEED	VARCHAR2(32) NOT NULL,
	MAXIMUM_SPEED	VARCHAR2(32) NOT NULL,
	WWN	VARCHAR2(100) NOT NULL
		
);
ALTER TABLE  VNXeDiskConfTest_DDD ADD constraint Pk_VNXeDiskConfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeDiskConfTest_DDD ON VNXeDiskConfTest_DDD
(
 	MSMT_TIME
);


DROP TABLE VNXeEvtLogsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VNXeEvtLogsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE_ID	VARCHAR2(32) NOT NULL,
	DESCRIPTION	VARCHAR2(500) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	NODE	VARCHAR2(500) NOT NULL,
	PROCESS	VARCHAR2(32) NOT NULL,
	CATEGORY	VARCHAR2(32) NOT NULL,
	ACCOUNT	VARCHAR2(32) NOT NULL,
	COMPONENT	VARCHAR2(32) NOT NULL,
	PRODUCT	VARCHAR2(32) NOT NULL
	
		
);
ALTER TABLE  VNXeEvtLogsTest_DDD ADD constraint Pk_VNXeEvtLogsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VNXeEvtLogsTest_DDD ON VNXeEvtLogsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HPSwUserStateTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HPSwUserStateTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NAME		VARCHAR2(256) NOT NULL,
	PRIVILEGE_LEVEL	VARCHAR2(128) NOT NULL	
);
ALTER TABLE  HPSwUserStateTest_DDD ADD constraint Pk_HPSwUserStateTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HPSwUserStateTest_DDD ON HPSwUserStateTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxSDXXenUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxSDXXenUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  CtxSDXXenUptimeTest_DDD ADD constraint Pk_CtxSDXXenUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSDXXenUptimeTest_DDD ON CtxSDXXenUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_CtxSDXXenUptimeTest_DDD ON CtxSDXXenUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX2_CtxSDXXenUptimeTest_DDD ON CtxSDXXenUptimeTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE CtxSDXMPSUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxSDXMPSUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  CtxSDXMPSUptimeTest_DDD ADD constraint Pk_CtxSDXMPSUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSDXMPSUptimeTest_DDD ON CtxSDXMPSUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_CtxSDXMPSUptimeTest_DDD ON CtxSDXMPSUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX2_CtxSDXMPSUptimeTest_DDD ON CtxSDXMPSUptimeTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE CtxSDXInstancesTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxSDXInstancesTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  CtxSDXInstancesTest_DDD ADD constraint Pk_CtxSDXInstancesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSDXInstancesTest_DDD ON CtxSDXInstancesTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX1_CtxSDXInstancesTest_DDD ON CtxSDXInstancesTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX2_CtxSDXInstancesTest_DDD ON CtxSDXInstancesTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE CtxSDXXenCPUCorTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxSDXXenCPUCorTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Core_number	VARCHAR2(128) NOT NULL,
	Pyscial_cpu	VARCHAR2(128) NOT NULL,
	Hyper_threads	VARCHAR2(128) NOT NULL,
	Instances	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxSDXXenCPUCorTest_DDD ADD constraint Pk_CtxSDXXenCPUCorTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxSDXXenCPUCorTest_DDD ON CtxSDXXenCPUCorTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CTXSDXVPXStatusTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CTXSDXVPXStatusTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Instance_Name	VARCHAR2(128) NOT NULL,
	Host_Name	VARCHAR2(128) NOT NULL,
	IP_Address	VARCHAR2(128) NOT NULL,
	Gateway		VARCHAR2(128) NOT NULL,
	Netmask		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CTXSDXVPXStatusTest_DDD ADD constraint Pk_CTXSDXVPXStatusTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CTXSDXVPXStatusTest_DDD ON CTXSDXVPXStatusTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VCDisvSwitPortTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  VCDisvSwitPortTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Connectee		VARCHAR2(128) NOT NULL,
	Runtime_MAC_Address	VARCHAR2(128) NOT NULL,
	Vlan_Id			VARCHAR2(128) NOT NULL);
ALTER TABLE  VCDisvSwitPortTest_DDD ADD constraint Pk_VCDisvSwitPortTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_VCDisvSwitPortTest_DDD ON VCDisvSwitPortTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CassSqlNetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CassSqlNetTest_DDD
(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    MESSAGE    VARCHAR2(2000) NOT NULL
    
);
 
ALTER TABLE  CassSqlNetTest_DDD ADD constraint Pk_CassSqlNetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO); 
CREATE  INDEX IDX_CassSqlNetTest_DDD ON CassSqlNetTest_DDD(MSMT_TIME);

DROP TABLE CassNodeDetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CassNodeDetTest_DDD
(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    NODE_IP_DETAILS    VARCHAR2(200) NOT NULL
    
);
 
ALTER TABLE  CassNodeDetTest_DDD ADD constraint Pk_CassNodeDetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO); 
CREATE  INDEX IDX_CassNodeDetTest_DDD ON CassNodeDetTest_DDD(MSMT_TIME);

DROP TABLE CassKeySpaceTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CassKeySpaceTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	TABLE_NAME      VARCHAR2(32) NOT NULL,
	BLOOM_FILTER_SIZE VARCHAR2(32) NOT NULL,
	RECENT_FALSE_POSITIVE VARCHAR2(32) NOT NULL,
	RECENT_FALSE_POSITIVE_RATE VARCHAR2(32) NOT NULL,
	LIVE_SS_TABLE_SIZE VARCHAR2(32) NOT NULL,
	LIVE_SS_TABLE_COUNT VARCHAR2(32) NOT NULL,
	MEMTABLE_SIZE    VARCHAR2(32) NOT NULL,
	MEMTABLE_OFFHEAP_SIZE  VARCHAR2(32) NOT NULL,
	MEMTABLE_ONHEAP_SIZE  VARCHAR2(32) NOT NULL,
	READ_REQUESTS   VARCHAR2(32) NOT NULL,
	READ_LATENCY   VARCHAR2(32) NOT NULL,
	WRITE_REQUESTS  VARCHAR2(32) NOT NULL,
	WRITE_LATENCY  VARCHAR2(32) NOT NULL
);
ALTER TABLE  CassKeySpaceTest_DDD ADD constraint Pk_CassKeySpaceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CassKeySpaceTest_DDD ON CassKeySpaceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE XchgLogonSimTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  XchgLogonSimTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Messages	VARCHAR2(2000) NOT NULL,
	Published_resources	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  XchgLogonSimTest_DDD ADD constraint Pk_XchgLogonSimTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_XchgLogonSimTest_DDD ON XchgLogonSimTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ADDfsRepTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE ADDfsRepTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Replication_groups	VARCHAR2(2000) NOT NULL,
	Replication_folders	VARCHAR2(2000) NOT NULL,
	Servers		 	VARCHAR2(2000) NOT NULL,
	Sending_server		VARCHAR2(2000) NOT NULL,
	Receiving_server	VARCHAR2(2000) NOT NULL,
	Backlogs		VARCHAR2(2000) NOT NULL
);

ALTER TABLE ADDfsRepTest_DDD ADD constraint Pk_ADDfsRepTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ADDfsRepTest_DDD ON ADDfsRepTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSDynamoDBTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSDynamoDBTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	OPERATION		VARCHAR2(128) NOT NULL,
	MEASURE_VALUE		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AWSDynamoDBTest_DDD ADD constraint Pk_AWSDynamoDBTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSDynamoDBTest_DDD ON AWSDynamoDBTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSBillingTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSBillingTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Service_name		VARCHAR2(128) NOT NULL,
	service_cost		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AWSBillingTest_DDD ADD constraint Pk_AWSBillingTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSBillingTest_DDD ON AWSBillingTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSRegionBillTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSRegionBillTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Service_name		VARCHAR2(128) NOT NULL,
	service_cost		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AWSRegionBillTest_DDD ADD constraint Pk_AWSRegionBillTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSRegionBillTest_DDD ON AWSRegionBillTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSCldTrailEvtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSCldTrailEvtTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Event_Name	VARCHAR2(128) NOT NULL,
	Event_Type	VARCHAR2(128) NOT NULL,
	Event_Source	VARCHAR2(128) NOT NULL,
	Event_Time	VARCHAR2(128) NOT NULL,
	Source_IP 	VARCHAR2(128) NOT NULL,
	Account_ID	VARCHAR2(128) NOT NULL,
	Region_Name	VARCHAR2(128) NOT NULL,
	User_Name	VARCHAR2(128) NOT NULL,
	User_Type	VARCHAR2(128) NOT NULL,
	User_AccessKey  VARCHAR2(128) NOT NULL,
	User_Agent	VARCHAR2(256) NOT NULL,
	Error_Code	VARCHAR2(128) NOT NULL,
	Error_Msg	VARCHAR2(256) NOT NULL
);

ALTER TABLE  AWSCldTrailEvtTest_DDD ADD constraint Pk_AWSCldTrailEvtTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSCldTrailEvtTest_DDD ON AWSCldTrailEvtTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSFlowLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSFlowLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Account_ID	VARCHAR2(128) NOT NULL,
	Version		VARCHAR2(128) NOT NULL,
	Source_Address	VARCHAR2(128) NOT NULL,
	Source_Port	 VARCHAR2(128) NOT NULL,
	Destination_Address	VARCHAR2(128) NOT NULL,
	Destination_Port	VARCHAR2(128) NOT NULL,
	Packets		VARCHAR2(128) NOT NULL,
	Data		VARCHAR2(128) NOT NULL,
	Log_Status	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AWSFlowLogTest_DDD ADD constraint Pk_AWSFlowLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSFlowLogTest_DDD ON AWSFlowLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSFlwLogSourceTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSFlwLogSourceTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Account_ID	VARCHAR2(128) NOT NULL,
	Version		VARCHAR2(128) NOT NULL,
	Source_Address	VARCHAR2(128) NOT NULL,
	Source_Port	 VARCHAR2(128) NOT NULL,
	Destination_Address	VARCHAR2(128) NOT NULL,
	Destination_Port	VARCHAR2(128) NOT NULL,
	Packets		VARCHAR2(128) NOT NULL,
	Data		VARCHAR2(128) NOT NULL,
	Log_Status	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AWSFlwLogSourceTest_DDD ADD constraint Pk_AWSFlwLogSourceTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSFlwLogSourceTest_DDD ON AWSFlwLogSourceTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSFlwLogDestTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSFlwLogDestTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Account_ID	VARCHAR2(128) NOT NULL,
	Version		VARCHAR2(128) NOT NULL,
	Source_Address	VARCHAR2(128) NOT NULL,
	Source_Port	 VARCHAR2(128) NOT NULL,
	Destination_Address	VARCHAR2(128) NOT NULL,
	Destination_Port	VARCHAR2(128) NOT NULL,
	Packets		VARCHAR2(128) NOT NULL,
	Data		VARCHAR2(128) NOT NULL,
	Log_Status	VARCHAR2(128) NOT NULL
);
ALTER TABLE  AWSFlwLogDestTest_DDD ADD constraint Pk_AWSFlwLogDestTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSFlwLogDestTest_DDD ON AWSFlwLogDestTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ANLBRSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ANLBRSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IPADDRESS	VARCHAR2(32) NOT NULL,
	PORT	        VARCHAR2(32) NOT NULL,
	STATUS		VARCHAR2(32) NOT NULL,
	HEALTHCHECKTYPE	VARCHAR2(32) NOT NULL,
	TOTALHITS       VARCHAR2(32) NOT NULL,
	CURHITS	        VARCHAR2(32) NOT NULL
);
ALTER TABLE  ANLBRSTest_DDD ADD constraint Pk_ANLBRSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ANLBRSTest_DDD ON ANLBRSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ANLBVSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ANLBVSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NAME	        VARCHAR2(32) NOT NULL,
	METHOD	        VARCHAR2(32) NOT NULL,
	HITS		VARCHAR2(32) NOT NULL,
	SESSIONCOUNT	VARCHAR2(32) NOT NULL,
	STATICSESSION   VARCHAR2(32) NOT NULL,
	REALSERVICENAME	VARCHAR2(32) NOT NULL,
	IPADDRESS	VARCHAR2(32) NOT NULL,
	PORT	        VARCHAR2(32) NOT NULL,
	STATUS	        VARCHAR2(32) NOT NULL
);
ALTER TABLE  ANLBVSTest_DDD ADD constraint Pk_ANLBVSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_ANLBVSTest_DDD ON ANLBVSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE TriComUserStateTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  TriComUserStateTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NAME		VARCHAR2(256) NOT NULL,
	PRIVILEGE_LEVEL	VARCHAR2(128) NOT NULL	
);
ALTER TABLE  TriComUserStateTest_DDD ADD constraint Pk_TriComUserStateTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TriComUserStateTest_DDD ON TriComUserStateTest_DDD
(
 	MSMT_TIME
);

DROP TABLE WAPEventLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WAPEventLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LOGGED_ON	VARCHAR2(128) NOT NULL,
	FILE_LOCATION	VARCHAR2(128) NOT NULL,
	MESSAGE		VARCHAR2(256) NOT NULL
);
ALTER TABLE  WAPEventLogTest_DDD ADD constraint Pk_WAPEventLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WAPEventLogTest_DDD ON WAPEventLogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSSSLTLSCertTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSSSLTLSCertTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Cert_issuer             VARCHAR2(128) NOT NULL,
	Cert_type	        VARCHAR2(128) NOT NULL,
	Cert_created		VARCHAR2(128) NOT NULL,
	Cert_expired		VARCHAR2(128) NOT NULL,
	Cert_domain		VARCHAR2(256) NOT NULL,
	Cert_usedBy	        VARCHAR2(2000) NOT NULL
);
ALTER TABLE  AWSSSLTLSCertTest_DDD ADD constraint Pk_AWSSSLTLSCertTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSSSLTLSCertTest_DDD ON AWSSSLTLSCertTest_DDD
(
 	MSMT_TIME
);

DROP TABLE DomainExpiryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  DomainExpiryTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Domain_id               VARCHAR2(32) NOT NULL,
	WHOIS_server		VARCHAR2(32) NOT NULL,
	URL			VARCHAR2(32) NOT NULL,
	Dmn_updte		VARCHAR2(32) NOT NULL,
	Dmn_create		VARCHAR2(32) NOT NULL,
	Dmn_expiry		VARCHAR2(32) NOT NULL,
	Dmn_registrar		VARCHAR2(32) NOT NULL,
	IANA_id			VARCHAR2(32) NOT NULL,
	Contact_mail		VARCHAR2(32) NOT NULL,
	Dmn_status		VARCHAR2(2000) NOT NULL,
	nme_server		VARCHAR2(2000) NOT NULL
);

ALTER TABLE  DomainExpiryTest_DDD ADD CONSTRAINT PK_DomainExpiryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_DomainExpiryTest_DDD ON DomainExpiryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxXcXAEDTTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxXcXAEDTTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_Id	VARCHAR2(128) NOT NULL,
	XenApp_Address		VARCHAR2(128) NOT NULL,
	Remote_Address		VARCHAR2(128) NOT NULL,
	Client_Address		VARCHAR2(128) NOT NULL,
	Bandwidth		VARCHAR2(128) NOT NULL,
	RTT			VARCHAR2(128) NOT NULL,
	Flow_Window		VARCHAR2(128) NOT NULL,
	Congestion_Window	VARCHAR2(128) NOT NULL,
	Sent_Bytes		VARCHAR2(128) NOT NULL,
	Received_Bytes		VARCHAR2(128) NOT NULL,
	Retransmitted_Bytes	VARCHAR2(128) NOT NULL,
	Lost_Sent		VARCHAR2(128) NOT NULL,
	Lost_Received		VARCHAR2(128) NOT NULL,
	Sent_ACKs		VARCHAR2(128) NOT NULL,
	Sent_NAKs		VARCHAR2(128) NOT NULL,
	Received_ACKs		VARCHAR2(128) NOT NULL,
	Received_NAKs		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxXcXAEDTTest_DDD ADD constraint Pk_CtxXcXAEDTTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxXcXAEDTTest_DDD ON CtxXcXAEDTTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxSFUserTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CtxSFUserTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ACCOUNT_DOMAIN	VARCHAR2(128) NOT NULL,
	ACCOUNT_NAME	VARCHAR2(128) NOT NULL,
	SECURITY_ID	VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxSFUserTest_DDD ADD constraint Pk_CtxSFUserTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxSFUserTest_DDD ON CtxSFUserTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HrznWLogonSimTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HrznWLogonSimTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Messages	VARCHAR2(2000) NOT NULL,
	Published_resources	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  HrznWLogonSimTest_DDD ADD constraint Pk_HrznWLogonSimTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_HrznWLogonSimTest_DDD ON HrznWLogonSimTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSAmazon24HrS3Test_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSAmazon24HrS3Test_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	STORAGE_TYPE		VARCHAR2(128) NOT NULL,
	BUCKET_SIZES		VARCHAR2(128) NOT NULL
);
ALTER TABLE  AWSAmazon24HrS3Test_DDD ADD constraint Pk_AWSAmazon24HrS3Test_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSAmazon24HrS3Test_DDD ON AWSAmazon24HrS3Test_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSAmazonECSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSAmazonECSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,	
	EC2_Instance		VARCHAR2(128) NOT NULL,
	Ins_Region		VARCHAR2(128) NOT NULL,
	Instance_Status		VARCHAR2(128) NOT NULL,
	Registered_CPU		VARCHAR2(128) NOT NULL,
	Remain_CPU		VARCHAR2(128) NOT NULL,
	Registered_Memory	VARCHAR2(128) NOT NULL,
	Remain_Memory		VARCHAR2(128) NOT NULL,
	Running_Task		VARCHAR2(128) NOT NULL,
	Pending_Task		VARCHAR2(128) NOT NULL,
	is_Connected		VARCHAR2(128) NOT NULL,
	Doker_Version		VARCHAR2(128) NOT NULL
);

ALTER TABLE  AWSAmazonECSTest_DDD ADD constraint Pk_AWSAmazonECSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSAmazonECSTest_DDD ON AWSAmazonECSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AWSAmazonRDSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AWSAmazonRDSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	DB_InstanceName	VARCHAR2(128) NOT NULL,
	Instance_Class	VARCHAR2(128) NOT NULL,
	Instance_Engine	VARCHAR2(128) NOT NULL,
	Storage_Type	VARCHAR2(128) NOT NULL
);

ALTER TABLE AWSAmazonRDSTest_DDD ADD constraint Pk_AWSAmazonRDSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AWSAmazonRDSTest_DDD ON AWSAmazonRDSTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HrznAccGateTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE HrznAccGateTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO		NUMBER(16) NOT NULL,
	Reachable	VARCHAR2(128) NOT NULL,
	Broker_Reason	VARCHAR2(128) NOT NULL,
	Backend_Reason	VARCHAR2(128) NOT NULL
);

ALTER TABLE HrznAccGateTest_DDD ADD constraint Pk_HrznAccGateTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HrznAccGateTest_DDD ON HrznAccGateTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AsSysDiaActTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsSysDiaActTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Instance_name			VARCHAR2(128) NOT NULL,
	Utilization		VARCHAR2(32) NOT NULL,
	Max_response_time		VARCHAR2(32) NOT NULL,
	Number_of_dialog_work_process		VARCHAR2(32) NOT NULL,
	Queue_length		VARCHAR2(32) NOT NULL,
	Long_runners		VARCHAR2(32) NOT NULL,
	Dialog_steps		VARCHAR2(32) NOT NULL,
	Users_logged_in		VARCHAR2(32) NOT NULL

);
ALTER TABLE  AsSysDiaActTest_DDD ADD constraint Pk_AsSysDiaActTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsSysDiaActTest_DDD ON AsSysDiaActTest_DDD
(
 	MSMT_TIME
);



DROP TABLE AsSysUpdPerfTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AsSysUpdPerfTest_DDD
(
	SITE_NAME		VARCHAR2(64) NOT NULL,
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32)NOT NULL,
	TEST_NAME		VARCHAR2(64) NOT NULL,
	MEASURE			VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	STATE			VARCHAR2(32) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	SEQ_NO			NUMBER(16) NOT NULL,
	Instance_name			VARCHAR2(128) NOT NULL,
	Response_time		VARCHAR2(128) NOT NULL,
	Queue_time		VARCHAR2(32) NOT NULL,
	Utilization		VARCHAR2(32) NOT NULL,
	Work_process_error_rate		VARCHAR2(32) NOT NULL,
	Update_work_processes		VARCHAR2(32) NOT NULL
	
);
ALTER TABLE  AsSysUpdPerfTest_DDD ADD constraint Pk_AsSysUpdPerfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AsSysUpdPerfTest_DDD ON AsSysUpdPerfTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RabMQQueSumTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RabMQQueSumTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NODE			VARCHAR2(100) NOT NULL,
	VHOST			VARCHAR2(100) NOT NULL,
	QUEUE_NAME		VARCHAR2(100) NOT NULL,
	QUEUE_STATE		VARCHAR2(100) NOT NULL,
	READY_MEASSAGE		VARCHAR2(100) NOT NULL,
	ACKNOWLEDGED_MESSAGE	VARCHAR2(100) NOT NULL,
	TOTAL_MESSAGE		VARCHAR2(100) NOT NULL,
	PUBLISH_MESSAGES	VARCHAR2(100) NOT NULL,
	CONFIRM_MESSAGES	VARCHAR2(100) NOT NULL,
	DELIVER_NO_ACK_MESSAGES VARCHAR2(100) NOT NULL,
	DELIVERED_MESSAGES	VARCHAR2(100) NOT NULL,
	CONSUMER_ACK		VARCHAR2(100) NOT NULL,
	REDELIVER		VARCHAR2(100) NOT NULL,
	GET_NO_ACK		VARCHAR2(100) NOT NULL,
	GET			VARCHAR2(100) NOT NULL,
	RETURN_VALUE		VARCHAR2(100) NOT NULL,
	DISK_READS		VARCHAR2(100) NOT NULL,
	DISK_WRITES	VARCHAR2(100) NOT NULL,
	MEMORY		VARCHAR2(100) NOT NULL,
	CONSUMERS	VARCHAR2(100) NOT NULL
);

ALTER TABLE  RabMQQueSumTest_DDD ADD constraint Pk_RabMQQueSumTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RabMQQueSumTest_DDD ON RabMQQueSumTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RabMQNodeStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RabMQNodeStTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	NODE_NAME	VARCHAR2(100) NOT NULL,
	NODE_STATE	VARCHAR2(100) NOT NULL
);

ALTER TABLE  RabMQNodeStTest_DDD ADD constraint Pk_RabMQNodeStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RabMQNodeStTest_DDD ON RabMQNodeStTest_DDD
(
 	MSMT_TIME
);



DROP TABLE RabMQClusterTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RabMQClusterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MANAGEMENT_VERSION VARCHAR2(100) NOT NULL,
	RABBITMQ_VERSION   VARCHAR2(100) NOT NULL,	
	ERLANG_VERSION     VARCHAR2(100) NOT NULL
);

ALTER TABLE  RabMQClusterTest_DDD ADD constraint Pk_RabMQClusterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RabMQClusterTest_DDD ON RabMQClusterTest_DDD
(
 	MSMT_TIME
);



DROP TABLE RabMQAppConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RabMQAppConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CONNECTION_STATE	VARCHAR2(100) NOT NULL,	
	CONNECTION_NAME		VARCHAR2(100) NOT NULL,			
	REDUCTIONS		VARCHAR2(100) NOT NULL,
	DATA_READS		VARCHAR2(100) NOT NULL,
	DATA_WRITES		VARCHAR2(100) NOT NULL,
	PLATFORM		VARCHAR2(100) NOT NULL,
	CONNECTED_USER		VARCHAR2(100) NOT NULL,
	PROTOCOL		VARCHAR2(100) NOT NULL,
	CONNECTED_AT		VARCHAR2(100) NOT NULL,	
	AUTHENTICATION		VARCHAR2(100) NOT NULL,
	CONNECTION_TIMEOUT	VARCHAR2(100) NOT NULL,
	FRAME_MAX		VARCHAR2(100) NOT NULL,
	CHANNEL_LIMIT		VARCHAR2(100) NOT NULL
);

ALTER TABLE  RabMQAppConnTest_DDD ADD constraint Pk_RabMQAppConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RabMQAppConnTest_DDD ON RabMQAppConnTest_DDD
(
 	MSMT_TIME
);


DROP TABLE RabMQCliConnTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RabMQCliConnTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CONNECTION_STATE	VARCHAR2(100) NOT NULL,	
	CONNECTION_NAME		VARCHAR2(100) NOT NULL,			
	REDUCTIONS		VARCHAR2(100) NOT NULL,
	DATA_READS		VARCHAR2(100) NOT NULL,
	DATA_WRITES		VARCHAR2(100) NOT NULL,
	PLATFORM		VARCHAR2(100) NOT NULL,
	CONNECTED_USER		VARCHAR2(100) NOT NULL,
	PROTOCOL		VARCHAR2(100) NOT NULL,
	CONNECTED_AT		VARCHAR2(100) NOT NULL,	
	AUTHENTICATION		VARCHAR2(100) NOT NULL,
	CONNECTION_TIMEOUT	VARCHAR2(100) NOT NULL,
	FRAME_MAX		VARCHAR2(100) NOT NULL,
	CHANNEL_LIMIT		VARCHAR2(100) NOT NULL
);

ALTER TABLE  RabMQCliConnTest_DDD ADD constraint Pk_RabMQCliConnTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RabMQCliConnTest_DDD ON RabMQCliConnTest_DDD
(
 	MSMT_TIME
);



DROP TABLE RabMQChannelTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RabMQChannelTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	CONNECTION_STATE	VARCHAR2(100) NOT NULL,	
	CONNECTION_NAME		VARCHAR2(100) NOT NULL,			
	REDUCTIONS		VARCHAR2(100) NOT NULL,
	PREFETCHED		VARCHAR2(100) NOT NULL,
	GLOBAL_PREFETCHED	VARCHAR2(100) NOT NULL,
	MESSAGE_UNACKNOWLEDGED	VARCHAR2(100) NOT NULL,
	MESSAGE_UNCONFIRMED	VARCHAR2(100) NOT NULL,
	MESSAGE_UNCOMMITTED	VARCHAR2(100) NOT NULL,
	ACKNOWLEGDE_UNCOMMITTED	VARCHAR2(100) NOT NULL
);

ALTER TABLE  RabMQChannelTest_DDD ADD constraint Pk_RabMQChannelTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RabMQChannelTest_DDD ON RabMQChannelTest_DDD
(
 	MSMT_TIME
);


DROP TABLE CloudLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  CloudLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GuestName	VARCHAR2(256) NOT NULL,
	UserName	VARCHAR2(256) NOT NULL,
	Login_Time	VARCHAR2(256) NOT NULL,
	Duration	VARCHAR2(256) NOT NULL,
	IDLE_TIME	VARCHAR2(128) NOT NULL,
	PCT_IDLE_TIME	VARCHAR2(128) NOT NULL
);
ALTER TABLE  CloudLoginTest_DDD ADD constraint Pk_CloudLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CloudLoginTest_DDD ON CloudLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdAppTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Application_name	VARCHAR2(128) NOT NULL,
	Display_name		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Application_type	VARCHAR2(128) NOT NULL,
	Program			VARCHAR2(1024) NOT NULL,
	Working_directory	VARCHAR2(1024) NOT NULL,
	No_of_instance		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	catalog_name		VARCHAR2(128) NOT NULL,
	Id			VARCHAR2(128) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_ip_address	VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Session_start_time	VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL,
	Tags			VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxCdAppTest_DDD ADD constraint Pk_CtxCdAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdAppTest_DDD ON CtxCdAppTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdBrokerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdBrokerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Dns_name		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Broker_version		VARCHAR2(128) NOT NULL,
	Lic_grace_state		VARCHAR2(128) NOT NULL,
	Lic_server_state	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Last_active_time	VARCHAR2(128) NOT NULL,
	Last_start_time		VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdBrokerTest_DDD ADD constraint Pk_CtxCdBrokerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdBrokerTest_DDD ON CtxCdBrokerTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdCatalogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdCatalogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Machine_type		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	User_data		VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Pvs_address		VARCHAR2(128) NOT NULL,
	Pvs_domain		VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdCatalogTest_DDD ADD constraint Pk_CtxCdCatalogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdCatalogTest_DDD ON CtxCdCatalogTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdAppGroupTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdAppGroupTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Application_name VARCHAR2(2000) NOT NULL,
	Application_groups VARCHAR2(2000) NOT NULL,
	Delivery_groups VARCHAR2(2000) NOT NULL,
	Tag		VARCHAR2(2000) NOT NULL,
	Machine_names	VARCHAR2(2000) NOT NULL,
	User_names	VARCHAR2(2000) NOT NULL,
	Restricted_tag	VARCHAR2(2000) NOT NULL);

ALTER TABLE  CtxCdAppGroupTest_DDD ADD constraint Pk_CtxCdAppGroupTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdAppGroupTest_DDD ON CtxCdAppGroupTest_DDD
(
 	MSMT_TIME
);


DROP TABLE CtxCdDGTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdDGTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Desktop_kind		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Session_username	VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Persist_user_changes	VARCHAR2(128) NOT NULL,
	Provisioning_type	VARCHAR2(128) NOT NULL,
	Published_applications	VARCHAR2(2000) NOT NULL,
	Published_name		VARCHAR2(128) NOT NULL,
	Reason			VARCHAR2(256) NOT NULL,
	D_and_t			VARCHAR2(128) NOT NULL,
	Delivery_Type		VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL,
	Established_session	VARCHAR2(128) NOT NULL,
	Pending_session		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	VM_tool_state		VARCHAR2(128) NOT NULL,
	Windows_conn_settings	VARCHAR2(128) NOT NULL,
	Tags			VARCHAR2(2000) NOT NULL
);

ALTER TABLE  CtxCdDGTest_DDD ADD constraint Pk_CtxCdDGTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdDGTest_DDD ON CtxCdDGTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdHypTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdHypTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Connection_name		VARCHAR2(128) NOT NULL,
	Connection_type		VARCHAR2(128) NOT NULL,
	Hypervisor_address 	VARCHAR2(2000) NOT NULL,
	Preferred_controller	VARCHAR2(128) NOT NULL,
	Username		VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdHypTest_DDD ADD constraint Pk_CtxCdHypTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdHypTest_DDD ON CtxCdHypTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdLoginTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdLoginTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL,
	Login_duration		NUMBER(20,4) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL,
	Client_platform		VARCHAR2(128) NOT NULL,
	Session_type		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdLoginTest_DDD ADD constraint Pk_CtxCdLoginTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdLoginTest_DDD ON CtxCdLoginTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdLoadIdxTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdLoadIdxTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_dns_name	VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Os_version		VARCHAR2(128) NOT NULL,
	Sessions		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(1024) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Hosted_machine_name	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	Total			VARCHAR2(128) NOT NULL,
	Cpu			VARCHAR2(128) NOT NULL,
	Memory			VARCHAR2(128) NOT NULL,
	Disk			VARCHAR2(128) NOT NULL,
	Session_count		VARCHAR2(128) NOT NULL,
	Zone_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdLoadIdxTest_DDD ADD constraint Pk_CtxCdLoadIdxTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdLoadIdxTest_DDD ON CtxCdLoadIdxTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdSessionTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdSessionTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_id		VARCHAR2(128) NOT NULL,
	Machine_name		VARCHAR2(128) NOT NULL,
	Machine_fqdn		VARCHAR2(128) NOT NULL,
	Ip_address		VARCHAR2(128) NOT NULL,
	Os_type			VARCHAR2(128) NOT NULL,
	Catalog_name		VARCHAR2(128) NOT NULL,
	Delivery_group_name	VARCHAR2(128) NOT NULL,
	Hosted_machine_name 	VARCHAR2(128) NOT NULL,
	Hosting_server_name	VARCHAR2(128) NOT NULL,
	Hypervisor_conn_name	VARCHAR2(128) NOT NULL,
	User_name		VARCHAR2(128) NOT NULL,
	Client_address 		VARCHAR2(128) NOT NULL,
	Client_name		VARCHAR2(128) NOT NULL,
	Client_version		VARCHAR2(128) NOT NULL,
	Connected_via_hostname	VARCHAR2(128) NOT NULL,
	Connected_via_ip_address VARCHAR2(128) NOT NULL,
	Launched_via_hostname	VARCHAR2(128) NOT NULL,
	Launched_via_ip_address VARCHAR2(128) NOT NULL,
	Protocol		VARCHAR2(128) NOT NULL,
	Session_state		VARCHAR2(128) NOT NULL,
	Brokering_duration	VARCHAR2(128) NOT NULL,
	Establishment_duration	VARCHAR2(128) NOT NULL,
	Establishment_time	VARCHAR2(128) NOT NULL,
	Session_state_change_time VARCHAR2(128) NOT NULL,
	Start_time		VARCHAR2(128) NOT NULL,
	Brokering_time		VARCHAR2(128) NOT NULL,
	License_id		VARCHAR2(128) NOT NULL,
	Hidden			VARCHAR2(128) NOT NULL,
	Autonomously_brokered	VARCHAR2(128) NOT NULL,
	Device_id		VARCHAR2(128) NOT NULL,
	Hardware_id		VARCHAR2(128) NOT NULL,
	Agent_version		VARCHAR2(128) NOT NULL,
	Session_support		VARCHAR2(128) NOT NULL,
	Controller_name		VARCHAR2(128) NOT NULL,
	Applications_in_use	VARCHAR2(1024) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL,
	Client_platform		VARCHAR2(128) NOT NULL,
	Session_type		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdSessionTest_DDD ADD constraint Pk_CtxCdSessionTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdSessionTest_DDD ON CtxCdSessionTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdSiteTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdSiteTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SiteName		VARCHAR2(128) NOT NULL,
	License_server_name	VARCHAR2(128) NOT NULL,
	License_server_port 	VARCHAR2(128) NOT NULL,
	Desktop_lic_edition	VARCHAR2(128) NOT NULL,
	Desktop_lic_model	VARCHAR2(128) NOT NULL,
	App_lic_edition		VARCHAR2(128) NOT NULL,
	App_lic_model		VARCHAR2(128) NOT NULL,
	Req_sa_date		VARCHAR2(128) NOT NULL,
	Zone_Name		VARCHAR2(128) NOT NULL,
	Connector_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdSiteTest_DDD ADD constraint Pk_CtxCdSiteTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_CtxCdSiteTest_DDD ON CtxCdSiteTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxCdZoneTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxCdZoneTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DNS_Name		VARCHAR2(128) NOT NULL,
	Machine_Name		VARCHAR2(128) NOT NULL,
	Controller_Version	VARCHAR2(128) NOT NULL,
	OS_Type			VARCHAR2(128) NOT NULL,
	OS_Version		VARCHAR2(128) NOT NULL,
	Last_Activity_Time	VARCHAR2(128) NOT NULL,
	Last_Start_Time		VARCHAR2(128) NOT NULL,
	Catalog_Name		VARCHAR2(128) NOT NULL,
	Delivery_Group_Name	VARCHAR2(128) NOT NULL,
	Description		VARCHAR2(128) NOT NULL,
	Session_Support		VARCHAR2(128) NOT NULL,
	Allocation_Type		VARCHAR2(128) NOT NULL,
	Machines_Are_Physical	VARCHAR2(128) NOT NULL,
	Persist_User_Changes	VARCHAR2(128) NOT NULL,
	Provisioning_Type	VARCHAR2(128) NOT NULL,
	Scopes			VARCHAR2(128) NOT NULL,
	Enabled			VARCHAR2(128) NOT NULL,
	In_Maintenance_Mode	VARCHAR2(128) NOT NULL,
	Total_machines		VARCHAR2(128) NOT NULL,
	DesktopKind		VARCHAR2(128) NOT NULL,
	Secure_Ica_Required	VARCHAR2(128) NOT NULL,
	Shutdown_After_Use	VARCHAR2(128) NOT NULL,
	Current_Primary_Zone	VARCHAR2(128) NOT NULL,
	Connector_name		VARCHAR2(128) NOT NULL
);

ALTER TABLE  CtxCdZoneTest_DDD ADD constraint Pk_CtxCdZoneTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_CtxCdZoneTest_DDD ON CtxCdZoneTest_DDD
(
 	MSMT_TIME
);

DROP TABLE VmgEDTTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE VmgEDTTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Session_Id	VARCHAR2(128) NOT NULL,
	Desktop_Address		VARCHAR2(128) NOT NULL,
	Remote_Address		VARCHAR2(128) NOT NULL,
	Client_Address		VARCHAR2(128) NOT NULL,
	Bandwidth		VARCHAR2(128) NOT NULL,
	RTT			VARCHAR2(128) NOT NULL,
	Flow_Window		VARCHAR2(128) NOT NULL,
	Congestion_Window	VARCHAR2(128) NOT NULL,
	Sent_Bytes		VARCHAR2(128) NOT NULL,
	Received_Bytes		VARCHAR2(128) NOT NULL,
	Retransmitted_Bytes	VARCHAR2(128) NOT NULL,
	Lost_Sent		VARCHAR2(128) NOT NULL,
	Lost_Received		VARCHAR2(128) NOT NULL,
	Sent_ACKs		VARCHAR2(128) NOT NULL,
	Sent_NAKs		VARCHAR2(128) NOT NULL,
	Received_ACKs		VARCHAR2(128) NOT NULL,
	Received_NAKs		VARCHAR2(128) NOT NULL
);

ALTER TABLE  VmgEDTTest_DDD ADD constraint Pk_VmgEDTTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_VmgEDTTest_DDD ON VmgEDTTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrRedisCacheTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrRedisCacheTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Host_Name	varchar2(256) NOT NULL,
	Redis_Port	varchar2(256) NOT NULL,
	Version		varchar2(256) NOT NULL
);

ALTER TABLE  AzrRedisCacheTest_DDD ADD constraint Pk_AzrRedisCacheTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrRedisCacheTest_DDD ON AzrRedisCacheTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrBatAccTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrBatAccTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Account_end_point			varchar2(128) NOT NULL,
	Pool_allocation_mode			varchar2(128) NOT NULL,
	Location				varchar2(128) NOT NULL,
	Dedicated_core_quota			varchar2(128) NOT NULL,
	Low_priority_core_quota			varchar2(128) NOT NULL,
	Pool_quota				varchar2(128) NOT NULL,
	Actv_and_schdl_quota			varchar2(128) NOT NULL
);

ALTER TABLE  AzrBatAccTest_DDD ADD constraint Pk_AzrBatAccTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrBatAccTest_DDD ON AzrBatAccTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrEvtHubTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrEvtHubTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Location			varchar2(128) NOT NULL,
	Pricing_tier			varchar2(128) NOT NULL,
	Throughput_units		varchar2(128) NOT NULL,
	CreatedAt			varchar2(128) NOT NULL
);

ALTER TABLE  AzrEvtHubTest_DDD ADD constraint Pk_AzrEvtHubTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrEvtHubTest_DDD ON AzrEvtHubTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AzrLogicAppTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrLogicAppTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	Location			varchar2(128) NOT NULL,
	Version				varchar2(128) NOT NULL,
	Access_End_point		varchar2(128) NOT NULL,
	Outgoing_IpAddresses		varchar2(128) NOT NULL,
	Access_End_Point_IpAddresses	varchar2(128) NOT NULL

);

ALTER TABLE AzrLogicAppTest_DDD ADD constraint Pk_AzrLogicAppTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX_AzrLogicAppTest_DDD ON AzrLogicAppTest_DDD
(
 	MSMT_TIME
);


DROP TABLE AzrIoTHubTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrIoTHubTest_DDD
(
	SITE_NAME	varchar2(64) NOT NULL,
	TRGT_HOST	varchar2(32) NOT NULL,
	PORT_NO		varchar2(32)NOT NULL,
	TEST_NAME	varchar2(64) NOT NULL,
	MEASURE		varchar2(64) NOT NULL,
	INFO		varchar2(128) NOT NULL,
	STATE		varchar2(32) NOT NULL,
	MSMT_HOST	varchar2(32) NOT NULL,
	MSMT_TIME	date NOT NULL,
	SEQ_NO 		Number(16) NOT NULL,
	location		varchar2(128) NOT NULL,
	skuname			varchar2(128) NOT NULL,
	tier			varchar2(128) NOT NULL,
	capacity		varchar2(128) NOT NULL
);

ALTER TABLE  AzrIoTHubTest_DDD ADD constraint Pk_AzrIoTHubTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrIoTHubTest_DDD ON AzrIoTHubTest_DDD
(
 	MSMT_TIME
);

DROP TABLE HAPUptimeTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  HAPUptimeTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SHUTDOWNDATE	DATE NOT NULL,
	REBOOTEDDATE	DATE NOT NULL,
	DURATION 	NUMBER(20,4) NOT NULL,
	MAINTENANCE 	VARCHAR2(32) NOT NULL	
);

ALTER TABLE  HAPUptimeTest_DDD ADD constraint Pk_HAPUptimeTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_HAPUptimeTest_DDD ON HAPUptimeTest_DDD
(
 	MSMT_TIME
);

CREATE  INDEX IDX_SHUT_HAPUptimeTest_DDD ON HAPUptimeTest_DDD
(
 	SHUTDOWNDATE
);

CREATE  INDEX IDX_REBOOT_HAPUptimeTest_DDD ON HAPUptimeTest_DDD
(
 	REBOOTEDDATE
);

DROP TABLE AWSLogonSimTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  AWSLogonSimTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32) NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Messages	VARCHAR2(2000) NOT NULL,
	Published_resources	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  AWSLogonSimTest_DDD ADD constraint Pk_AWSLogonSimTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_AWSLogonSimTest_DDD ON AWSLogonSimTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NodeErrorTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NodeErrorTest_DDD
(
	SITE_NAME	VARCHAR2(64)   NOT NULL,
	TRGT_HOST	VARCHAR2(32)   NOT NULL,
	PORT_NO		VARCHAR2(32)   NOT NULL,
	TEST_NAME	VARCHAR2(64)   NOT NULL,
	MEASURE		VARCHAR2(64)   NOT NULL,
	INFO		VARCHAR2(128)  NOT NULL,
	STATE		VARCHAR2(32)   NOT NULL,
	MSMT_HOST	VARCHAR2(32)   NOT NULL,
	MSMT_TIME	DATE 	       NOT NULL,
	SEQ_NO 		NUMBER(16)     NOT NULL,
	PROCESS_ID	VARCHAR2(128)  NOT NULL,
   	Error_Time 	VARCHAR2(128)  NOT NULL,
	Message    	VARCHAR2(256)  NOT NULL,
	StackTrace	VARCHAR2(2000) NOT NULL
);
ALTER TABLE  NodeErrorTest_DDD ADD constraint Pk_NodeErrorTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_NodeErrorTest_DDD ON NodeErrorTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NodeCPUTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NodeCPUTest_DDD
(
	SITE_NAME		VARCHAR2(64) 	NOT NULL,
	TRGT_HOST		VARCHAR2(32) 	NOT NULL,
	PORT_NO			VARCHAR2(32)	NOT NULL,
	TEST_NAME		VARCHAR2(64) 	NOT NULL,
	MEASURE			VARCHAR2(64) 	NOT NULL,
	INFO			VARCHAR2(128) 	NOT NULL,
	STATE			VARCHAR2(32) 	NOT NULL,
	MSMT_HOST		VARCHAR2(32)	NOT NULL,
	MSMT_TIME		DATE  		NOT NULL,
	SEQ_NO 			NUMBER(16) 	NOT NULL,
	PROCESS_ID		NUMBER(20,4)	NOT NULL,
	User_CPU		NUMBER(20,4)	NOT NULL,
	System_CPU		NUMBER(20,4)	NOT NULL,
	User_CPU_Time		NUMBER(20,4)	NOT NULL,
	System_CPU_Time		NUMBER(20,4)	NOT NULL,
	Dumpfile_ID		VARCHAR2(64)	NOT NULL
);

ALTER TABLE  NodeCPUTest_DDD ADD constraint Pk_NodeCPUTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NodeCPUTest_DDD ON NodeCPUTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NodeMemoryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NodeMemoryTest_DDD
(
	SITE_NAME			 VARCHAR2(64)   NOT NULL,
	TRGT_HOST			 VARCHAR2(32)   NOT NULL,
	PORT_NO				 VARCHAR2(32)   NOT NULL,
	TEST_NAME			 VARCHAR2(64)   NOT NULL,
	MEASURE				 VARCHAR2(64)   NOT NULL,
	INFO				 VARCHAR2(128)  NOT NULL,
	STATE				 VARCHAR2(32)   NOT NULL,
	MSMT_HOST			 VARCHAR2(32)   NOT NULL,
	MSMT_TIME			 DATE 		NOT NULL,
	SEQ_NO 				 NUMBER(16) 	NOT NULL,
	PROCESS_ID			 NUMBER(20,4)	NOT NULL,
	Physical_Memory			 NUMBER(20,4)	NOT NULL,
	Maximum_Heap			 NUMBER(20,4)	NOT NULL,
	Heap_Used			 NUMBER(20,4)	NOT NULL,
	Heap_Free			 NUMBER(20,4)	NOT NULL,
	Heap_Used_Percentage		 NUMBER(20,4)	NOT NULL,
	Non_Heap_Used			 NUMBER(20,4)	NOT NULL,
	Dumpfile_ID			VARCHAR2(64) 	NOT NULL
);

ALTER TABLE  NodeMemoryTest_DDD ADD constraint Pk_NodeMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NodeMemoryTest_DDD ON NodeMemoryTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NodeGCtest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NodeGCtest_DDD
(
	SITE_NAME		 VARCHAR2(64)   NOT NULL,
	TRGT_HOST		 VARCHAR2(32)   NOT NULL,
	PORT_NO		     	 VARCHAR2(32)   NOT NULL,
	TEST_NAME		 VARCHAR2(64)   NOT NULL,
	MEASURE			 VARCHAR2(64) 	NOT NULL,
	INFO			 VARCHAR2(128)  NOT NULL,
	STATE			 VARCHAR2(32)   NOT NULL,
	MSMT_HOST		 VARCHAR2(32)   NOT NULL,
	MSMT_TIME		 DATE 		NOT NULL,
	SEQ_NO 	       	  	 NUMBER(16) 	NOT NULL,
	PROCESS_ID		 NUMBER(20,4)	NOT NULL,
	Full_GC   		 NUMBER(20,4)	NOT NULL,
	Minor_GC   		 NUMBER(20,4)	NOT NULL,
	Inc_GC     		 NUMBER(20,4)	NOT NULL,
	Full_GC_Time   		 NUMBER(20,4)	NOT NULL,
	Inc_GC_Time   		 NUMBER(20,4)	NOT NULL,
	Minor_GC_Time   	 NUMBER(20,4)	NOT NULL,
	GC_Time    		 NUMBER(20,4)	NOT NULL,
	GC_Tick    		 NUMBER(20,4)	NOT NULL,
	GC_Released_Mem  	 NUMBER(20,4)	NOT NULL
);

ALTER TABLE  NodeGCtest_DDD ADD constraint Pk_NodeGCtest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NodeGCtest_DDD ON NodeGCtest_DDD
(
 	MSMT_TIME
);

DROP TABLE NodeELTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  NodeELTest_DDD
(
	SITE_NAME			VARCHAR2(64) 	NOT NULL,
	TRGT_HOST			VARCHAR2(32) 	NOT NULL,
	PORT_NO				VARCHAR2(32)	NOT NULL,
	TEST_NAME			VARCHAR2(64) 	NOT NULL,
	MEASURE				VARCHAR2(64) 	NOT NULL,
	INFO				VARCHAR2(128) 	NOT NULL,
	STATE				VARCHAR2(32) 	NOT NULL,
	MSMT_HOST			VARCHAR2(32) 	NOT NULL,
	MSMT_TIME			DATE 		NOT NULL,
	SEQ_NO 				NUMBER(16) 	NOT NULL,
	PROCESS_ID			NUMBER(20,4)	NOT NULL,
	MIN 	    			NUMBER(20,4)	NOT NULL,
	MAX     			NUMBER(20,4)	NOT NULL,
	SUM 	   			NUMBER(20,4)	NOT NULL,
	TICK     			NUMBER(20,4)	NOT NULL,
	AVG 	   			NUMBER(20,4)	NOT NULL,
	LAG 	    			NUMBER(20,4)	NOT NULL,
	Duration 			VARCHAR2(128)	NOT NULL,
	Event_Loop_Duration		VARCHAR2(128)	NOT NULL,
	Stacktrace			VARCHAR2(2048)  NOT NULL
);

ALTER TABLE  NodeELTest_DDD ADD constraint Pk_NodeELTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_NodeELTest_DDD ON NodeELTest_DDD
(
 	MSMT_TIME
);

DROP TABLE NodeTransTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE NodeTransTest_DDD
(
SITE_NAME		VARCHAR2(64) NOT NULL,
TRGT_HOST		VARCHAR2(32) NOT NULL,
PORT_NO			VARCHAR2(32) NOT NULL,
TEST_NAME		VARCHAR2(64) NOT NULL,
MEASURE			VARCHAR2(64) NOT NULL,
INFO			VARCHAR2(128) NOT NULL,
STATE			VARCHAR2(32) NOT NULL,
MSMT_HOST		VARCHAR2(32) NOT NULL,
MSMT_TIME		DATE NOT NULL,
SEQ_NO 			NUMBER(16) NOT NULL,
EG_GUID			VARCHAR2(64) NOT NULL,
NODE_ORDER		VARCHAR2(512) NOT NULL,
APPLICATION_NAME	VARCHAR2(64) NOT NULL,
CONTEXT_NAME		VARCHAR2(64) NOT NULL,
REQUEST_TIME		DATE NOT NULL,
THREAD_GUID		VARCHAR2(64) NOT NULL,
URI			VARCHAR2(512) NOT NULL,
RESPONSE_TIME		NUMBER(20,4) NOT NULL,
TIME_ZONE		VARCHAR2(32) NOT NULL,
REMOTE_HOST		VARCHAR2(256) NOT NULL,
REQUEST_TYPE		VARCHAR2(16) NOT NULL,
TRANSACTION_TYPE	VARCHAR2(16) NOT NULL,
SLOW_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
STALLED_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
URL_PARAMS		VARCHAR2(1024) NOT NULL,
SESSION_ID		VARCHAR2(128) NOT NULL,
THREAD_ID		VARCHAR2(512) NOT NULL,
DEVICE			VARCHAR2(64) NOT NULL,
OS			VARCHAR2(64) NOT NULL,
BROWSER			VARCHAR2(64) NOT NULL,
REFERER			VARCHAR2(2000) NOT NULL,
COUNTRY			VARCHAR2(32) NOT NULL,
LOCATION		VARCHAR2(32) NOT NULL,
POSITION		VARCHAR2(32) NOT NULL,
TRACE_DETAILS		BLOB NOT NULL,
PRE_PROCESSOR_TIME	NUMBER(20,4) NOT NULL,
METHOD_TYPE		VARCHAR2(32) NOT NULL,
STATUS_CODE		VARCHAR2(32) NOT NULL,
COOKIES		VARCHAR2(2000) NOT NULL,
HEADER		VARCHAR2(2000) NOT NULL,
USERNAME		VARCHAR2(2000) NOT NULL,
BUSINESS_CONTEXT	VARCHAR2(2000) NOT NULL,
CPU_TIME		NUMBER(20,4) NOT NULL,
WAIT_TIME 		NUMBER(20,4) NOT NULL,
BLOCK_TIME		NUMBER(20,4) NOT NULL,
USER_AGENT		VARCHAR2(2000) NOT NULL,
BROWSER_VERSION		VARCHAR2(64) NOT NULL,
REGION			VARCHAR2(64) NOT NULL,
CITY			VARCHAR2(128) NOT NULL,
GATEWAY_IP		VARCHAR2(256) NOT NULL,
EXCEPTION_NAME		VARCHAR2(256) NOT NULL,
COMPONENT_ID		VARCHAR2(128) NOT NULL,
constraint Pk_NodeTransTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO))
organization index compress overflow;

CREATE  INDEX IDX_NodeTransTest_DDD ON NodeTransTest_DDD
(
	EG_GUID
);

CREATE  INDEX IDX1_NodeTransTest_DDD ON NodeTransTest_DDD
(
	MSMT_TIME
);


DROP TABLE KNodeTransTest_DDD CASCADE CONSTRAINTS;

CREATE TABLE KNodeTransTest_DDD
(
SITE_NAME		VARCHAR2(64) NOT NULL,
TRGT_HOST		VARCHAR2(32) NOT NULL,
PORT_NO			VARCHAR2(32) NOT NULL,
TEST_NAME		VARCHAR2(64) NOT NULL,
MEASURE			VARCHAR2(64) NOT NULL,
INFO			VARCHAR2(128) NOT NULL,
STATE			VARCHAR2(32) NOT NULL,
MSMT_HOST		VARCHAR2(32) NOT NULL,
MSMT_TIME		DATE NOT NULL,
SEQ_NO 			NUMBER(16) NOT NULL,
EG_GUID			VARCHAR2(64) NOT NULL,
NODE_ORDER		VARCHAR2(512) NOT NULL,
APPLICATION_NAME	VARCHAR2(64) NOT NULL,
CONTEXT_NAME		VARCHAR2(64) NOT NULL,
REQUEST_TIME		DATE NOT NULL,
THREAD_GUID		VARCHAR2(64) NOT NULL,
URI			VARCHAR2(512) NOT NULL,
RESPONSE_TIME		NUMBER(20,4) NOT NULL,
TIME_ZONE		VARCHAR2(32) NOT NULL,
REMOTE_HOST		VARCHAR2(256) NOT NULL,
REQUEST_TYPE		VARCHAR2(16) NOT NULL,
TRANSACTION_TYPE	VARCHAR2(16) NOT NULL,
SLOW_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
STALLED_URL_THRESHOLD	NUMBER(20,4) NOT NULL,
URL_PARAMS		VARCHAR2(1024) NOT NULL,
SESSION_ID		VARCHAR2(128) NOT NULL,
THREAD_ID		VARCHAR2(512) NOT NULL,
DEVICE			VARCHAR2(64) NOT NULL,
OS			VARCHAR2(64) NOT NULL,
BROWSER			VARCHAR2(64) NOT NULL,
REFERER			VARCHAR2(2000) NOT NULL,
COUNTRY			VARCHAR2(32) NOT NULL,
LOCATION		VARCHAR2(32) NOT NULL,
POSITION		VARCHAR2(32) NOT NULL,
TRACE_DETAILS		BLOB NOT NULL,
PRE_PROCESSOR_TIME	NUMBER(20,4) NOT NULL,
METHOD_TYPE		VARCHAR2(32) NOT NULL,
STATUS_CODE		VARCHAR2(32) NOT NULL,
COOKIES			VARCHAR2(2000) NOT NULL,
HEADER			VARCHAR2(2000) NOT NULL,
USERNAME		VARCHAR2(2000) NOT NULL,
BUSINESS_CONTEXT	VARCHAR2(2000) NOT NULL,
CPU_TIME		NUMBER(20,4) NOT NULL,
WAIT_TIME 		NUMBER(20,4) NOT NULL,
BLOCK_TIME		NUMBER(20,4) NOT NULL,
USER_AGENT		VARCHAR2(2000) NOT NULL,
BROWSER_VERSION		VARCHAR2(64) NOT NULL,
REGION			VARCHAR2(64) NOT NULL,
CITY			VARCHAR2(128) NOT NULL,
GATEWAY_IP		VARCHAR2(256) NOT NULL,
EXCEPTION_NAME		VARCHAR2(256) NOT NULL,
COMPONENT_ID		VARCHAR2(128) NOT NULL,
constraint Pk_KNodeTransTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO))
organization index compress overflow;

CREATE  INDEX IDX_KNodeTransTest_DDD ON KNodeTransTest_DDD
(
	EG_GUID
);

CREATE  INDEX IDX1_KNodeTransTest_DDD ON KNodeTransTest_DDD
(
	MSMT_TIME
);

DROP TABLE AzrRecvrySrvTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AzrRecvrySrvTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Location	VARCHAR2(256) NOT NULL,
	Service_Type	VARCHAR2(256) NOT NULL,
	Tier		VARCHAR2(256) NOT NULL
);

ALTER TABLE  AzrRecvrySrvTest_DDD ADD constraint Pk_AzrRecvrySrvTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AzrRecvrySrvTest_DDD ON AzrRecvrySrvTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RADLBRSStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RADLBRSStatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IPADDRESS	VARCHAR2(256) NOT NULL
);
ALTER TABLE  RADLBRSStatTest_DDD ADD constraint Pk_RADLBRSStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RADLBRSStatTest_DDD ON RADLBRSStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RADLBVSStatTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RADLBVSStatTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	GROUPNAME	VARCHAR2(256) NOT NULL,
	RSNAME	        VARCHAR2(256) NOT NULL,
	RSGROUPNAME	VARCHAR2(256) NOT NULL
);
ALTER TABLE  RADLBVSStatTest_DDD ADD constraint Pk_RADLBVSStatTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RADLBVSStatTest_DDD ON RADLBVSStatTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RADLBRSDetailsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RADLBRSDetailsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	RSNAME	        VARCHAR2(256) NOT NULL,
	GROUPNAME	VARCHAR2(256) NOT NULL,
	VSNAME	        VARCHAR2(256) NOT NULL,
	RSSTATUS	VARCHAR2(256) NOT NULL
);
ALTER TABLE  RADLBRSDetailsTest_DDD ADD constraint Pk_RADLBRSDetailsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_RADLBRSDetailsTest_DDD ON RADLBRSDetailsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IISWebSiteReqTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  IISWebSiteReqTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Url 		VARCHAR2(2000) NOT NULL,
	Verb		VARCHAR2(128) NOT NULL,
	Stage		VARCHAR2(256) NOT NULL,
	Module_name	VARCHAR2(256) NOT NULL,
	Time_elasped	VARCHAR2(256) NOT NULL,
	Client		VARCHAR2(128) NOT NULL,
	Wp_id		VARCHAR2(128) NOT NULL,
	AppPool_name	VARCHAR2(128) NOT NULL,
	Website_name	VARCHAR2(128) NOT NULL,
	Total_request	VARCHAR2(128) NOT NULL,
	Slow_request	VARCHAR2(128) NOT NULL
);

ALTER TABLE  IISWebSiteReqTest_DDD ADD constraint Pk_IISWebSiteReqTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_IISWebSiteReqTest_DDD ON IISWebSiteReqTest_DDD
(
 	MSMT_TIME
);

DROP TABLE IISWebSitesTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE IISWebSitesTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	APP_NAME	VARCHAR2(256) NOT NULL,
	APPPOOL_NAME	VARCHAR2(128) NOT NULL,
	CLR_VERSION	VARCHAR2(256) NOT NULL,
	MANAGED_MODE	VARCHAR2(256) NOT NULL,
	POOL_STATUS	VARCHAR2(256) NOT NULL
);

ALTER TABLE IISWebSitesTest_DDD ADD constraint Pk_IISWebSitesTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE INDEX IDX_IISWebSitesTest_DDD ON IISWebSitesTest_DDD
(
 	MSMT_TIME
);

DROP TABLE AspDotNetClrTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE AspDotNetClrTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	WORKER_PROCESS		VARCHAR2(32) NOT NULL,
	PROCESS_ID		VARCHAR2(32) NOT NULL,
	COMMAND_LINE		VARCHAR2(2000) NOT NULL,
	START_TIME		VARCHAR2(128) NOT NULL,
	END_TIME		VARCHAR2(128) NOT NULL,
	GC_INDUCED_TYPE		VARCHAR2(128) NOT NULL,
	COLLECTED_GEN		VARCHAR2(128) NOT NULL,
	CLASS_ID		VARCHAR2(128) NOT NULL,
	NAMESPACE		VARCHAR2(256) NOT NULL,
	CLASS_NAME		VARCHAR2(256) NOT NULL,
	CLASS_SIZE		VARCHAR2(128) NOT NULL,
	NUMBER_OF_INSTANCE	VARCHAR2(128) NOT NULL,
	MODULE_ID		VARCHAR2(128) NOT NULL,
	MODULE_NAME		VARCHAR2(2000) NOT NULL,
	APPDOMAIN_ID		VARCHAR2(128) NOT NULL,
	APPDOMAIN_NAME		VARCHAR2(256) NOT NULL,
	ASSEMBLY_ID		VARCHAR2(128) NOT NULL,
	ASSEMBLY_NAME		VARCHAR2(256) NOT NULL,
	MODULE_TYPE		VARCHAR2(128) NOT NULL,
	THREAD_ID		VARCHAR2(128) NOT NULL,
	THREAD_NAME		VARCHAR2(256) NOT NULL,
	CREATION_TIME		VARCHAR2(128) NOT NULL,
	RUNNING_TIME		VARCHAR2(128) NOT NULL,
	USER_TIME		VARCHAR2(128) NOT NULL,
	KERNEL_TIME		VARCHAR2(128) NOT NULL,
	CLASS_TYPE		VARCHAR2(128) NOT NULL,
	CPU_TIME		VARCHAR2(128) NOT NULL,
	CPU_USAGE		VARCHAR2(128) NOT NULL,
	OBJECT_GRAPH		BLOB NOT NULL
);

ALTER TABLE AspDotNetClrTest_DDD ADD constraint Pk_AspDotNetClrTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_AspDotNetClrTest_DDD ON AspDotNetClrTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ESIndexingTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ESIndexingTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Index_Name	VARCHAR2(128) NOT NULL
);

ALTER TABLE  ESIndexingTest_DDD ADD constraint Pk_ESIndexingTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ESIndexingTest_DDD ON ESIndexingTest_DDD
(
 	MSMT_TIME
);

DROP TABLE ESClusterTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  ESClusterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Message	VARCHAR2(128) NOT NULL
);

ALTER TABLE  ESClusterTest_DDD ADD constraint Pk_ESClusterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_ESClusterTest_DDD ON ESClusterTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RedisClientTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RedisClientTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ID	VARCHAR2(128)NOT NULL,
	Name	VARCHAR2(128) NOT NULL,
	IP_Address	VARCHAR2(128) NOT NULL,
	Port_Numb	VARCHAR2(128) NOT NULL,
	FD	VARCHAR2(128)NOT NULL,
	DB_ID	VARCHAR2(128) NOT NULL,
	Age	VARCHAR2(128) NOT NULL,
	Ideal_Time	VARCHAR2(128) NOT NULL,
	Client_Flag VARCHAR2(128) NOT NULL,
	Channel_Sub	VARCHAR2(128) NOT NULL,
	Pattern_Sub	VARCHAR2(128) NOT NULL,
	Multi	VARCHAR2(128) NOT NULL,
	Query_Buf_Len	VARCHAR2(128) NOT NULL,
	Ouery_Buf_Free	VARCHAR2(128) NOT NULL,
	Output_Buf_Len	VARCHAR2(128) NOT NULL,
	Output_list_len	VARCHAR2(128) NOT NULL,
	Output_Buf_Mem	VARCHAR2(128) NOT NULL,
	Events	VARCHAR2(128) NOT NULL,
	Last_Command	VARCHAR2(128) NOT NULL

);

ALTER TABLE  RedisClientTest_DDD ADD constraint Pk_RedisClientTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_RedisClientTest_DDD ON RedisClientTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RedisReplicaTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RedisReplicaTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Slave	VARCHAR2(128) NOT NULL,
	IP	VARCHAR2(128) NOT NULL,
	Port	VARCHAR2(128) NOT NULL,
	Slave_State	VARCHAR2(128) NOT NULL,
	Offset	VARCHAR2(128) NOT NULL,
	Lag	VARCHAR2(128) NOT NULL

);

ALTER TABLE  RedisReplicaTest_DDD ADD constraint Pk_RedisReplicaTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_RedisReplicaTest_DDD ON RedisReplicaTest_DDD
(
 	MSMT_TIME
);

DROP TABLE RedisClusterTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RedisClusterTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Node_ID	VARCHAR2(128) NOT NULL,
	IP	VARCHAR2(128) NOT NULL,
	Port	VARCHAR2(128) NOT NULL,
	Flags		VARCHAR2(128) NOT NULL,
	Master_Node_ID		VARCHAR2(128) NOT NULL,
	Ping_Sent	VARCHAR2(128) NOT NULL,
	Pong_Received	VARCHAR2(128) NOT NULL,
	Config_Epoch	VARCHAR2(128) NOT NULL,
	Link_State	VARCHAR2(128) NOT NULL,
	Slot	VARCHAR2(128) NOT NULL

);

ALTER TABLE  RedisClusterTest_DDD ADD constraint Pk_RedisClusterTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_RedisClusterTest_DDD ON RedisClusterTest_DDD
(
 	MSMT_TIME
);
DROP TABLE RedisSlowLogTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  RedisSlowLogTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32) NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Start_Time	VARCHAR2(128) NOT NULL,
	Execution_Duration	VARCHAR2(128) NOT NULL,
	Command_Arguments	VARCHAR2(128) NOT NULL

);

ALTER TABLE  RedisSlowLogTest_DDD ADD constraint Pk_RedisSlowLogTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  INDEX IDX_RedisSlowLogTest_DDD ON RedisSlowLogTest_DDD
(
 	MSMT_TIME
);


DROP TABLE TibSqlNetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TibSqlNetTest_DDD
(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    MESSAGE    VARCHAR2(2000) NOT NULL    
); 
ALTER TABLE  TibSqlNetTest_DDD ADD constraint Pk_TibSqlNetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO); 
CREATE  INDEX IDX_TibSqlNetTest_DDD ON TibSqlNetTest_DDD(MSMT_TIME);

DROP TABLE TibLngRunQryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TibLngRunQryTest_DDD
(
    SITE_NAME    VARCHAR2(64) NOT NULL,
    TRGT_HOST    VARCHAR2(32) NOT NULL,
    PORT_NO        VARCHAR2(32) NOT NULL,
    TEST_NAME    VARCHAR2(64) NOT NULL,
    MEASURE          VARCHAR2(64) NOT NULL,
    INFO             VARCHAR2(128) NOT NULL,
    STATE            VARCHAR2(32) NOT NULL,
    MSMT_HOST        VARCHAR2(32) NOT NULL,
    MSMT_TIME        DATE NOT NULL,
    SEQ_NO         NUMBER(16) NOT NULL,
    SERIALNO     VARCHAR2(32) NOT NULL,
    SID          VARCHAR2(32) NOT NULL,
    TERMINAL     VARCHAR2(32) NOT NULL,
    USER_NAME         VARCHAR2(32) NOT NULL,
    OSUSER       VARCHAR2(32) NOT NULL,
    MACHINE       VARCHAR2(32) NOT NULL,
    PROGRAM_NAME  VARCHAR2(32) NOT NULL,
    ELAPSED_TIME  VARCHAR2(32) NOT NULL,
    EXECUTION_COUNT VARCHAR2(32) NOT NULL,
    AVG_TIME_PERECUTION VARCHAR2(32) NOT NULL,
    WLOCK_WAIT   VARCHAR2(32) NOT NULL,
    WAIT_EVENT   VARCHAR2(32) NOT NULL,
    WAIT_TIME    VARCHAR2(32) NOT NULL,
    SQL_TEXT     VARCHAR2(2000) NOT NULL    
); 
ALTER TABLE  TibLngRunQryTest_DDD ADD constraint Pk_TibLngRunQryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO); 
CREATE  INDEX IDX_TibLngRunQryTest_DDD ON TibLngRunQryTest_DDD(MSMT_TIME);

DROP TABLE TibConTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TibConTest_DDD
(
	SITE_NAME       VARCHAR2(64)   NOT NULL,
	TRGT_HOST       VARCHAR2(32)   NOT NULL,
	PORT_NO         VARCHAR2(32)   NOT NULL,
	TEST_NAME       VARCHAR2(64)   NOT NULL,
	MEASURE         VARCHAR2(64)   NOT NULL,
	INFO            VARCHAR2(128)  NOT NULL,
	STATE           VARCHAR2(32)   NOT NULL,
	MSMT_HOST       VARCHAR2(32)   NOT NULL,
	MSMT_TIME       DATE      NOT NULL,
	SEQ_NO          NUMBER(16)   NOT NULL,
	SID             VARCHAR2(32)   NOT NULL,
	SERIAL          VARCHAR2(32)   NOT NULL,
	OS_USER         VARCHAR2(128)  NOT NULL,
	HOST    VARCHAR2(128)  NOT NULL,
	TERMINAL_NAME   VARCHAR2(128)  NOT NULL,
	PROGRAM_NAME    VARCHAR2(64)  NOT NULL,
	MODULE_NAME      VARCHAR2(128)  NOT NULL,
	ELAPSED_TIME    VARCHAR2(32)   NOT NULL,	
	SQL_TEXT       VARCHAR2(2048) NOT NULL
);
ALTER TABLE  TibConTest_DDD ADD constraint Pk_TibConTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TibConTest_DDD ON TibConTest_DDD(MSMT_TIME);


DROP TABLE TibSessWaitTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TibSessWaitTest_DDD
(
	SITE_NAME       VARCHAR2(64)   NOT NULL,
	TRGT_HOST       VARCHAR2(32)   NOT NULL,
	PORT_NO         VARCHAR2(32)   NOT NULL,
	TEST_NAME       VARCHAR2(64)   NOT NULL,
	MEASURE         VARCHAR2(64)   NOT NULL,
	INFO            VARCHAR2(128)  NOT NULL,
	STATE           VARCHAR2(32)   NOT NULL,
	MSMT_HOST       VARCHAR2(32)   NOT NULL,
	MSMT_TIME       DATE      NOT NULL,
	SEQ_NO          NUMBER(16)   NOT NULL,
	SPID             VARCHAR2(32)   NOT NULL,
	USERNAME          VARCHAR2(32)   NOT NULL,
	TOTAL_WAITS         VARCHAR2(64)  NOT NULL,
	TOTAL_WAITS_TIMEDOUT    VARCHAR2(64)  NOT NULL,
	TOTAL_TIME_WAITED   VARCHAR2(64)  NOT NULL,
	MAX_TIME_WAITED    VARCHAR2(64)  NOT NULL
);
ALTER TABLE  TibSessWaitTest_DDD ADD constraint Pk_TibSessWaitTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TibSessWaitTest_DDD ON TibSessWaitTest_DDD(MSMT_TIME);

DROP TABLE TibSysWtEvtTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE TibSysWtEvtTest_DDD
(
	SITE_NAME       VARCHAR2(64)   NOT NULL,
	TRGT_HOST       VARCHAR2(32)   NOT NULL,
	PORT_NO         VARCHAR2(32)   NOT NULL,
	TEST_NAME       VARCHAR2(64)   NOT NULL,
	MEASURE         VARCHAR2(64)   NOT NULL,
	INFO            VARCHAR2(128)  NOT NULL,
	STATE           VARCHAR2(32)   NOT NULL,
	MSMT_HOST       VARCHAR2(32)   NOT NULL,
	MSMT_TIME       DATE      NOT NULL,
	SEQ_NO          NUMBER(16)   NOT NULL,
	EVENT_ID             VARCHAR2(32)   NOT NULL,
	EVENT_NAME          VARCHAR2(32)   NOT NULL,
	TOTAL_WAITS         VARCHAR2(64)  NOT NULL,
	TOTAL_TIMEWAITS    VARCHAR2(64)  NOT NULL,
	AVG_TIME_PER_WAIT   VARCHAR2(64)  NOT NULL
);
ALTER TABLE  TibSysWtEvtTest_DDD ADD constraint Pk_TibSysWtEvtTest_DDD PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_TibSysWtEvtTest_DDD ON TibSysWtEvtTest_DDD(MSMT_TIME);




DROP TABLE WbtobProcStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WbtobProcStTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Process_ID	 	VARCHAR2(64) NOT NULL,
	Status 			VARCHAR2(64)   NOT NULL,
	Number_of_request 	VARCHAR2(128) NOT NULL,
	Average_response_time   VARCHAR2(128) NOT NULL
);
ALTER TABLE  WbtobProcStTest_DDD ADD constraint Pk_WbtobProcStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WbtobProcStTest_DDD ON WbtobProcStTest_DDD
(
 	MSMT_TIME
);


DROP TABLE WbtobHndlrStTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  WbtobHndlrStTest_DDD
(
	SITE_NAME  	VARCHAR2(64) NOT NULL,
	TRGT_HOST    	VARCHAR2(32) NOT NULL,
	PORT_NO      	VARCHAR2(32)NOT NULL,
	TEST_NAME    	VARCHAR2(64) NOT NULL,
	MEASURE      	VARCHAR2(64) NOT NULL,
	INFO         	VARCHAR2(128) NOT NULL,
	STATE        	VARCHAR2(32) NOT NULL,
	MSMT_HOST    	VARCHAR2(32) NOT NULL,
	MSMT_TIME    	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	Client_status	 	 VARCHAR2(64) NOT NULL,
	Requests_sent_by_client  VARCHAR2(64)   NOT NULL,
	Client_idle_time 	 VARCHAR2(128) NOT NULL,
	Server_IP_and_PORT       VARCHAR2(128) NOT NULL,
	Client_IP_and_PORT       VARCHAR2(128) NOT NULL
);
ALTER TABLE  WbtobHndlrStTest_DDD ADD constraint Pk_WbtobHndlrStTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_WbtobHndlrStTest_DDD ON WbtobHndlrStTest_DDD
(
 	MSMT_TIME
);





DROP TABLE UnityLUNTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityLUNTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	LUN_ID	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	LUN_ACCESS_HOST	VARCHAR2(100) NOT NULL,
	THIN_PROVISIONING	VARCHAR2(32) NOT NULL,
	SNAPSHOT_COUNT	VARCHAR2(32) NOT NULL,
	REPLICATION_DESTINATION	VARCHAR2(32) NOT NULL,
	WWN	VARCHAR2(100) NOT NULL,
	CREATION_TIME	VARCHAR2(32) NOT NULL,
	LAST_MODIFIED_TIME	VARCHAR2(32) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL,
	QUEUE_LENGTH	VARCHAR2(32) NOT NULL,
	RESPONSE_TIME	VARCHAR2(32) NOT NULL
);
ALTER TABLE  UnityLUNTest_DDD ADD constraint Pk_UnityLUNTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityLUNTest_DDD ON UnityLUNTest_DDD
(
 	MSMT_TIME
);



DROP TABLE UnityEnetTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityEnetTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	PROTOCOLS	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MTU_SIZE	VARCHAR2(32) NOT NULL,
	REQUESTED_MTU_SIZE	VARCHAR2(32) NOT NULL,
	AVALIABLE_MTU_SIZE	VARCHAR2(32) NOT NULL,
	SPEED	VARCHAR2(32) NOT NULL,
	REQUESTED_SPEED	VARCHAR2(32) NOT NULL,
	AVALIBLE_SPEED	VARCHAR2(32) NOT NULL,
	AGGREGATED_PORT_ID	VARCHAR2(32) NOT NULL,
	CONNECTOR_TYPE	VARCHAR2(32) NOT NULL,
	MAC_ADDRESS	VARCHAR2(32) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	BYTES_IN	VARCHAR2(32) NOT NULL,
	BYTES_OUT	VARCHAR2(32) NOT NULL,
	PACKETS_IN	VARCHAR2(32) NOT NULL,
	PACKETS_OUT	VARCHAR2(32) NOT NULL
	
);
ALTER TABLE  UnityEnetTest_DDD ADD constraint Pk_UnityEnetTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityEnetTest_DDD ON UnityEnetTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UnityDiskTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityDiskTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL,
	SERVICE_TIME	VARCHAR2(32) NOT NULL,
	RESPONSE_TIME	VARCHAR2(32) NOT NULL
	
	
);
ALTER TABLE  UnityDiskTest_DDD ADD constraint Pk_UnityDiskTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityDiskTest_DDD ON UnityDiskTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityFibreTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityFibreTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	SPEED	VARCHAR2(32) NOT NULL,
	REQUESTED_SPEED	VARCHAR2(32) NOT NULL,
	AVALIABLE_SPEED	VARCHAR2(32) NOT NULL,
	CONNECTOR_TYPE	VARCHAR2(32) NOT NULL,
	WWN	VARCHAR2(100) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
		
	
);
ALTER TABLE  UnityFibreTest_DDD ADD constraint Pk_UnityFibreTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityFibreTest_DDD ON UnityFibreTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityiSCSITest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityiSCSITest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
	
		
	
);
ALTER TABLE  UnityiSCSITest_DDD ADD constraint Pk_UnityiSCSITest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityiSCSITest_DDD ON UnityiSCSITest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityCacheTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityCacheTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_HITS	VARCHAR2(32) NOT NULL,
	READ_MISSES	VARCHAR2(32) NOT NULL,
	WRITE_HITS	VARCHAR2(32) NOT NULL,
	WRITE_MISSES	VARCHAR2(32) NOT NULL,
	DIRTY_CACHE_SIZE	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  UnityCacheTest_DDD ADD constraint Pk_UnityCacheTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityCacheTest_DDD ON UnityCacheTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityCIFSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityCIFSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  UnityCIFSTest_DDD ADD constraint Pk_UnityCIFSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityCIFSTest_DDD ON UnityCIFSTest_DDD
(
 	MSMT_TIME
);




DROP TABLE UnityNFSTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityNFSTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	READ_IOPS	VARCHAR2(32) NOT NULL,
	WRITE_IOPS	VARCHAR2(32) NOT NULL,
	TOTAL_IOPS	VARCHAR2(32) NOT NULL,
	DATA_READS	VARCHAR2(32) NOT NULL,
	DATA_WRITES	VARCHAR2(32) NOT NULL
);
ALTER TABLE  UnityNFSTest_DDD ADD constraint Pk_UnityNFSTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityNFSTest_DDD ON UnityNFSTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityBatteryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityBatteryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAIL	VARCHAR2(32) NOT NULL,
	MANUFACTURER	VARCHAR2(32) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL
	
);
ALTER TABLE  UnityBatteryTest_DDD ADD constraint Pk_UnityBatteryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityBatteryTest_DDD ON UnityBatteryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityDPETest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityDPETest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HEALTH_DETAIL	VARCHAR2(32) NOT NULL,
	MANUFACTURER	VARCHAR2(32) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	PRESENT_POWER	VARCHAR2(32) NOT NULL,
	POWER_ROLLING_AVERAGE	VARCHAR2(32) NOT NULL,
	TEMPERATURE	VARCHAR2(32) NOT NULL
	
	
);
ALTER TABLE  UnityDPETest_DDD ADD constraint Pk_UnityDPETest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityDPETest_DDD ON UnityDPETest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnitySPTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnitySPTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SP_NAME	VARCHAR2(32) NOT NULL,
	HEALTH_DETAIL	VARCHAR2(500) NOT NULL,
	DPE	VARCHAR2(32) NOT NULL,
	MODES	VARCHAR2(32) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	UTILIZATION	VARCHAR2(32) NOT NULL
	
	
);
ALTER TABLE  UnitySPTest_DDD ADD constraint Pk_UnitySPTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnitySPTest_DDD ON UnitySPTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UnityHostTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityHostTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	ADDRESS	VARCHAR2(1024) NOT NULL,
	OS_TYPE	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(1024) NOT NULL
	
	
);
ALTER TABLE  UnityHostTest_DDD ADD constraint Pk_UnityHostTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityHostTest_DDD ON UnityHostTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UnityInitiTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityInitiTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	HOST	VARCHAR2(32) NOT NULL,
	UID_NO	VARCHAR2(100) NOT NULL,
	INITITATOR_TYPE	VARCHAR2(32) NOT NULL,
	PORT_LOGIN	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL
);
ALTER TABLE  UnityInitiTest_DDD ADD constraint Pk_UnityInitiTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityInitiTest_DDD ON UnityInitiTest_DDD
(
 	MSMT_TIME
);

DROP TABLE UnitySASTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnitySASTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	SAS_ID	VARCHAR2(32) NOT NULL,
	SP_OWNER	VARCHAR2(32) NOT NULL,
	CONNECTOR_TYPE	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL
		
);
ALTER TABLE  UnitySASTest_DDD ADD constraint Pk_UnitySASTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnitySASTest_DDD ON UnitySASTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityFanTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityFanTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	FAN_ID	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  UnityFanTest_DDD ADD constraint Pk_UnityFanTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityFanTest_DDD ON UnityFanTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityPowerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityPowerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	POWER_SUPPLY_ID	VARCHAR2(32) NOT NULL,
	SP	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MANUFACTURER	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  UnityPowerTest_DDD ADD constraint Pk_UnityPowerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityPowerTest_DDD ON UnityPowerTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityIOTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityIOTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IO_ID	VARCHAR2(32) NOT NULL,
	SP	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  UnityIOTest_DDD ADD constraint Pk_UnityIOTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityIOTest_DDD ON UnityIOTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityMemoryTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityMemoryTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MEMORY_ID	VARCHAR2(32) NOT NULL,
	SP	VARCHAR2(32) NOT NULL,
	SLOT	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	MODEL	VARCHAR2(32) NOT NULL,
	SERIAL_NO	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  UnityMemoryTest_DDD ADD constraint Pk_UnityMemoryTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityMemoryTest_DDD ON UnityMemoryTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityStrPoolsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityStrPoolsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	STORAGE_POOL_ID	VARCHAR2(32) NOT NULL,
	DESCRIPTION	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	ALERT_THRESHOLD	VARCHAR2(32) NOT NULL,
	RAID_LEVEL	VARCHAR2(32) NOT NULL,
	FAST_CACHE_ENABLED	VARCHAR2(32) NOT NULL
		
);
ALTER TABLE  UnityStrPoolsTest_DDD ADD constraint Pk_UnityStrPoolsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityStrPoolsTest_DDD ON UnityStrPoolsTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityDiskConfTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityDiskConfTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	DISK_ID	VARCHAR2(32) NOT NULL,
	HEALTH_DETAILS	VARCHAR2(500) NOT NULL,
	DISK_TYPE	VARCHAR2(32) NOT NULL,
	ROTATIONAL_SPEED	VARCHAR2(32) NOT NULL,
	CURRENT_SPEED	VARCHAR2(32) NOT NULL,
	MAXIMUM_SPEED	VARCHAR2(32) NOT NULL,
	WWN	VARCHAR2(100) NOT NULL
		
);
ALTER TABLE  UnityDiskConfTest_DDD ADD constraint Pk_UnityDiskConfTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityDiskConfTest_DDD ON UnityDiskConfTest_DDD
(
 	MSMT_TIME
);


DROP TABLE UnityEvtLogsTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE  UnityEvtLogsTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	MESSAGE_ID	VARCHAR2(32) NOT NULL,
	DESCRIPTION	VARCHAR2(500) NOT NULL,
	VNX_TIME	VARCHAR2(32) NOT NULL,
	NODE	VARCHAR2(500) NOT NULL,
	PROCESS	VARCHAR2(32) NOT NULL,
	CATEGORY	VARCHAR2(32) NOT NULL,
	ACCOUNT	VARCHAR2(32) NOT NULL,
	COMPONENT	VARCHAR2(32) NOT NULL,
	PRODUCT	VARCHAR2(32) NOT NULL
	
		
);
ALTER TABLE  UnityEvtLogsTest_DDD ADD constraint Pk_UnityEvtLogsTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);
CREATE  INDEX IDX_UnityEvtLogsTest_DDD ON UnityEvtLogsTest_DDD
(
 	MSMT_TIME
);

DROP TABLE CtxNSCSVServerTest_DDD CASCADE CONSTRAINTS;
CREATE TABLE CtxNSCSVServerTest_DDD
(
	SITE_NAME	VARCHAR2(64) NOT NULL,
	TRGT_HOST	VARCHAR2(32) NOT NULL,
	PORT_NO		VARCHAR2(32)NOT NULL,
	TEST_NAME	VARCHAR2(64) NOT NULL,
	MEASURE		VARCHAR2(64) NOT NULL,
	INFO		VARCHAR2(128) NOT NULL,
	STATE		VARCHAR2(32) NOT NULL,
	MSMT_HOST	VARCHAR2(32) NOT NULL,
	MSMT_TIME	DATE NOT NULL,
	SEQ_NO 		NUMBER(16) NOT NULL,
	IP_ADDRESS	VARCHAR2(256) NOT NULL,
	SERVER_PORT	VARCHAR2(256) NOT NULL,
	PROTOCOL_TYPE	VARCHAR2(256) NOT NULL,
	TRAFFIC_DOMAIN	VARCHAR2(256) NOT NULL,
	TARGET_TYPE	VARCHAR2(256) NOT NULL
);

ALTER TABLE CtxNSCSVServerTest_DDD ADD constraint Pk_CtxNSCSVServerTest_DDD
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,MSMT_HOST,MSMT_TIME,SEQ_NO);

CREATE  IND