DROP TABLE SPOUsrDtlsTest;
CREATE TABLE SPOUsrDtlsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Active_Usrs DECIMAL(20,4) NOT NULL,
Active_Usrs_ST varchar(32) NOT NULL,
InActive_Usrs DECIMAL(20,4) NOT NULL,
InActive_Usrs_ST varchar(32) NOT NULL);
CREATE INDEX IDX_SPOUsrDtlsTest ON SPOUsrDtlsTest(MSMT_TIME);
ALTER TABLE SPOUsrDtlsTest ADD constraint PK_SPOUsrDtlsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE SPOUsrDtlsTest_TREND;
CREATE TABLE SPOUsrDtlsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Active_Usrs_MIN DECIMAL(20,4) NOT NULL,
Active_Usrs_MAX DECIMAL(20,4) NOT NULL,
Active_Usrs_STCNT varchar(32) NOT NULL,
InActive_Usrs_MIN DECIMAL(20,4) NOT NULL,
InActive_Usrs_MAX DECIMAL(20,4) NOT NULL,
InActive_Usrs_STCNT varchar(32) NOT NULL);
ALTER TABLE SPOUsrDtlsTest_TREND ADD constraint PK_SPOUsrDtlsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE SPOUsrDtlsTest_THRESH;
CREATE TABLE SPOUsrDtlsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Active_Usrs_MIN VARCHAR(256) NOT NULL,
Active_Usrs_MAX VARCHAR(256) NOT NULL,
InActive_Usrs_MIN VARCHAR(256) NOT NULL,
InActive_Usrs_MAX VARCHAR(256) NOT NULL);
ALTER TABLE SPOUsrDtlsTest_THRESH ADD constraint PK_SPOUsrDtlsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOUsrDtlsTest_THRESH ON SPOUsrDtlsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOUsrDtlsTest ON SPOUsrDtlsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOUsrDtlsTest ON SPOUsrDtlsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBSiteConnvtyTest;
CREATE TABLE ODBSiteConnvtyTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
WEB_AVAILABILITY DECIMAL(20,4) NOT NULL,
WEB_AVAILABILITY_ST varchar(32) NOT NULL,
RESPONSE_CODE DECIMAL(20,4) NOT NULL,
RESPONSE_CODE_ST varchar(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBSiteConnvtyTest ON ODBSiteConnvtyTest(MSMT_TIME);
ALTER TABLE ODBSiteConnvtyTest ADD constraint PK_ODBSiteConnvtyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSiteConnvtyTest_TREND;
CREATE TABLE ODBSiteConnvtyTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
WEB_AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
WEB_AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
WEB_AVAILABILITY_STCNT varchar(32) NOT NULL,
RESPONSE_CODE_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_CODE_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_CODE_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBSiteConnvtyTest_TREND ADD constraint PK_ODBSiteConnvtyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSiteConnvtyTest_THRESH;
CREATE TABLE ODBSiteConnvtyTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
WEB_AVAILABILITY_MIN VARCHAR(256) NOT NULL,
WEB_AVAILABILITY_MAX VARCHAR(256) NOT NULL,
RESPONSE_CODE_MIN VARCHAR(256) NOT NULL,
RESPONSE_CODE_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBSiteConnvtyTest_THRESH ADD constraint PK_ODBSiteConnvtyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSiteConnvtyTest_THRESH ON ODBSiteConnvtyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSiteConnvtyTest ON ODBSiteConnvtyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSiteConnvtyTest ON ODBSiteConnvtyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBUsrsByServTest;
CREATE TABLE ODBUsrsByServTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Active_Usrs DECIMAL(20,4) NOT NULL,
Active_Usrs_ST varchar(32) NOT NULL,
InActive_Usrs DECIMAL(20,4) NOT NULL,
InActive_Usrs_ST varchar(32) NOT NULL);
CREATE INDEX IDX_ODBUsrsByServTest ON ODBUsrsByServTest(MSMT_TIME);
ALTER TABLE ODBUsrsByServTest ADD constraint PK_ODBUsrsByServTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ODBUsrsByServTest_TREND;
CREATE TABLE ODBUsrsByServTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Active_Usrs_MIN DECIMAL(20,4) NOT NULL,
Active_Usrs_MAX DECIMAL(20,4) NOT NULL,
Active_Usrs_STCNT varchar(32) NOT NULL,
InActive_Usrs_MIN DECIMAL(20,4) NOT NULL,
InActive_Usrs_MAX DECIMAL(20,4) NOT NULL,
InActive_Usrs_STCNT varchar(32) NOT NULL);
ALTER TABLE ODBUsrsByServTest_TREND ADD constraint PK_ODBUsrsByServTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE ODBUsrsByServTest_THRESH;
CREATE TABLE ODBUsrsByServTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Active_Usrs_MIN VARCHAR(256) NOT NULL,
Active_Usrs_MAX VARCHAR(256) NOT NULL,
InActive_Usrs_MIN VARCHAR(256) NOT NULL,
InActive_Usrs_MAX VARCHAR(256) NOT NULL);
ALTER TABLE ODBUsrsByServTest_THRESH ADD constraint PK_ODBUsrsByServTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBUsrsByServTest_THRESH ON ODBUsrsByServTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBUsrsByServTest ON ODBUsrsByServTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBUsrsByServTest ON ODBUsrsByServTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBFileActTest;
CREATE TABLE ODBFileActTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USERS DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_ST varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
	UNIQUE_SITES DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_ST varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
	FILE_ACCESSES DECIMAL(20,4) NOT NULL,
	FILE_ACCESSES_ST varchar(32) NOT NULL,
	FILE_CHECK_INS DECIMAL(20,4) NOT NULL,
	FILE_CHECK_INS_ST varchar(32) NOT NULL,
	FILE_CHECKOUTS DECIMAL(20,4) NOT NULL,
	FILE_CHECKOUTS_ST varchar(32) NOT NULL,
	FILE_COPIES DECIMAL(20,4) NOT NULL,
	FILE_COPIES_ST varchar(32) NOT NULL,
	FILE_DELETES DECIMAL(20,4) NOT NULL,
	FILE_DELETES_ST varchar(32) NOT NULL,
	FILE_DELETES_FRM_I_STAGE DECIMAL(20,4) NOT NULL,
	FILE_DELETES_FRM_I_STAGE_ST varchar(32) NOT NULL,
	FILE_DELETES_FRM_II_STAG DECIMAL(20,4) NOT NULL,
	FILE_DELETES_FRM_II_STAG_ST varchar(32) NOT NULL,
	FILE_CHECKOUT_DISCARDS DECIMAL(20,4) NOT NULL,
	FILE_CHECKOUT_DISCARDS_ST varchar(32) NOT NULL,
	FILE_DOWNLOADS DECIMAL(20,4) NOT NULL,
	FILE_DOWNLOADS_ST varchar(32) NOT NULL,
	FILE_MODIFICATIONS DECIMAL(20,4) NOT NULL,
	FILE_MODIFICATIONS_ST varchar(32) NOT NULL,
	FILE_MOVES DECIMAL(20,4) NOT NULL,
	FILE_MOVES_ST varchar(32) NOT NULL,
	FILE_RENAMES DECIMAL(20,4) NOT NULL,
	FILE_RENAMES_ST varchar(32) NOT NULL,
	FILE_RESTORES DECIMAL(20,4) NOT NULL,
	FILE_RESTORES_ST varchar(32) NOT NULL,
	FILE_UPLOADS DECIMAL(20,4) NOT NULL,
	FILE_UPLOADS_ST varchar(32) NOT NULL,
	PAGE_VIEWS DECIMAL(20,4) NOT NULL,
	PAGE_VIEWS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBFileActTest ON ODBFileActTest(MSMT_TIME);
ALTER TABLE ODBFileActTest ADD constraint PK_ODBFileActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileActTest_TREND;
CREATE TABLE ODBFileActTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_STCNT varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
	UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_STCNT varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
	FILE_ACCESSES_MIN DECIMAL(20,4) NOT NULL,
	FILE_ACCESSES_MAX DECIMAL(20,4) NOT NULL,
	FILE_ACCESSES_STCNT varchar(32) NOT NULL,
	FILE_CHECK_INS_MIN DECIMAL(20,4) NOT NULL,
	FILE_CHECK_INS_MAX DECIMAL(20,4) NOT NULL,
	FILE_CHECK_INS_STCNT varchar(32) NOT NULL,
	FILE_CHECKOUTS_MIN DECIMAL(20,4) NOT NULL,
	FILE_CHECKOUTS_MAX DECIMAL(20,4) NOT NULL,
	FILE_CHECKOUTS_STCNT varchar(32) NOT NULL,
	FILE_COPIES_MIN DECIMAL(20,4) NOT NULL,
	FILE_COPIES_MAX DECIMAL(20,4) NOT NULL,
	FILE_COPIES_STCNT varchar(32) NOT NULL,
	FILE_DELETES_MIN DECIMAL(20,4) NOT NULL,
	FILE_DELETES_MAX DECIMAL(20,4) NOT NULL,
	FILE_DELETES_STCNT varchar(32) NOT NULL,
	FILE_DELETES_FRM_I_STAGE_MIN DECIMAL(20,4) NOT NULL,
	FILE_DELETES_FRM_I_STAGE_MAX DECIMAL(20,4) NOT NULL,
	FILE_DELETES_FRM_I_STAGE_STCNT varchar(32) NOT NULL,
	FILE_DELETES_FRM_II_STAG_MIN DECIMAL(20,4) NOT NULL,
	FILE_DELETES_FRM_II_STAG_MAX DECIMAL(20,4) NOT NULL,
	FILE_DELETES_FRM_II_STAG_STCNT varchar(32) NOT NULL,
	FILE_CHECKOUT_DISCARDS_MIN DECIMAL(20,4) NOT NULL,
	FILE_CHECKOUT_DISCARDS_MAX DECIMAL(20,4) NOT NULL,
	FILE_CHECKOUT_DISCARDS_STCNT varchar(32) NOT NULL,
	FILE_DOWNLOADS_MIN DECIMAL(20,4) NOT NULL,
	FILE_DOWNLOADS_MAX DECIMAL(20,4) NOT NULL,
	FILE_DOWNLOADS_STCNT varchar(32) NOT NULL,
	FILE_MODIFICATIONS_MIN DECIMAL(20,4) NOT NULL,
	FILE_MODIFICATIONS_MAX DECIMAL(20,4) NOT NULL,
	FILE_MODIFICATIONS_STCNT varchar(32) NOT NULL,
	FILE_MOVES_MIN DECIMAL(20,4) NOT NULL,
	FILE_MOVES_MAX DECIMAL(20,4) NOT NULL,
	FILE_MOVES_STCNT varchar(32) NOT NULL,
	FILE_RENAMES_MIN DECIMAL(20,4) NOT NULL,
	FILE_RENAMES_MAX DECIMAL(20,4) NOT NULL,
	FILE_RENAMES_STCNT varchar(32) NOT NULL,
	FILE_RESTORES_MIN DECIMAL(20,4) NOT NULL,
	FILE_RESTORES_MAX DECIMAL(20,4) NOT NULL,
	FILE_RESTORES_STCNT varchar(32) NOT NULL,
	FILE_UPLOADS_MIN DECIMAL(20,4) NOT NULL,
	FILE_UPLOADS_MAX DECIMAL(20,4) NOT NULL,
	FILE_UPLOADS_STCNT varchar(32) NOT NULL,
	PAGE_VIEWS_MIN DECIMAL(20,4) NOT NULL,
	PAGE_VIEWS_MAX DECIMAL(20,4) NOT NULL,
	PAGE_VIEWS_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBFileActTest_TREND ADD constraint PK_ODBFileActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileActTest_THRESH;
CREATE TABLE ODBFileActTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
	FILE_ACCESSES_MIN VARCHAR(256) NOT NULL,
	FILE_ACCESSES_MAX VARCHAR(256) NOT NULL,
	FILE_CHECK_INS_MIN VARCHAR(256) NOT NULL,
	FILE_CHECK_INS_MAX VARCHAR(256) NOT NULL,
	FILE_CHECKOUTS_MIN VARCHAR(256) NOT NULL,
	FILE_CHECKOUTS_MAX VARCHAR(256) NOT NULL,
	FILE_COPIES_MIN VARCHAR(256) NOT NULL,
	FILE_COPIES_MAX VARCHAR(256) NOT NULL,
	FILE_DELETES_MIN VARCHAR(256) NOT NULL,
	FILE_DELETES_MAX VARCHAR(256) NOT NULL,
	FILE_DELETES_FRM_I_STAGE_MIN VARCHAR(256) NOT NULL,
	FILE_DELETES_FRM_I_STAGE_MAX VARCHAR(256) NOT NULL,
	FILE_DELETES_FRM_II_STAG_MIN VARCHAR(256) NOT NULL,
	FILE_DELETES_FRM_II_STAG_MAX VARCHAR(256) NOT NULL,
	FILE_CHECKOUT_DISCARDS_MIN VARCHAR(256) NOT NULL,
	FILE_CHECKOUT_DISCARDS_MAX VARCHAR(256) NOT NULL,
	FILE_DOWNLOADS_MIN VARCHAR(256) NOT NULL,
	FILE_DOWNLOADS_MAX VARCHAR(256) NOT NULL,
	FILE_MODIFICATIONS_MIN VARCHAR(256) NOT NULL,
	FILE_MODIFICATIONS_MAX VARCHAR(256) NOT NULL,
	FILE_MOVES_MIN VARCHAR(256) NOT NULL,
	FILE_MOVES_MAX VARCHAR(256) NOT NULL,
	FILE_RENAMES_MIN VARCHAR(256) NOT NULL,
	FILE_RENAMES_MAX VARCHAR(256) NOT NULL,
	FILE_RESTORES_MIN VARCHAR(256) NOT NULL,
	FILE_RESTORES_MAX VARCHAR(256) NOT NULL,
	FILE_UPLOADS_MIN VARCHAR(256) NOT NULL,
	FILE_UPLOADS_MAX VARCHAR(256) NOT NULL,
	PAGE_VIEWS_MIN VARCHAR(256) NOT NULL,
	PAGE_VIEWS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBFileActTest_THRESH ADD constraint PK_ODBFileActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileActTest_THRESH ON ODBFileActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileActTest ON ODBFileActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileActTest ON ODBFileActTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ODBFolderActTest;
CREATE TABLE ODBFolderActTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USERS DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_ST varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
	UNIQUE_SITES DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_ST varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
	FOLDER_COPIES DECIMAL(20,4) NOT NULL,
	FOLDER_COPIES_ST varchar(32) NOT NULL,
	FOLDER_CREATIONS DECIMAL(20,4) NOT NULL,
	FOLDER_CREATIONS_ST varchar(32) NOT NULL,
	FOLDER_DELETIONS DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_ST varchar(32) NOT NULL,
	FOLDER_DELETIONS_I_BIN DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_I_BIN_ST varchar(32) NOT NULL,
	FOLDER_DELETIONS_II_BIN DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_II_BIN_ST varchar(32) NOT NULL,
	FOLDER_MODIFICATIONS DECIMAL(20,4) NOT NULL,
	FOLDER_MODIFICATIONS_ST varchar(32) NOT NULL,
	FOLDER_MOVES DECIMAL(20,4) NOT NULL,
	FOLDER_MOVES_ST varchar(32) NOT NULL,
	FOLDER_RENAMES DECIMAL(20,4) NOT NULL,
	FOLDER_RENAMES_ST varchar(32) NOT NULL,
	FOLDER_RESTORES DECIMAL(20,4) NOT NULL, 
	FOLDER_RESTORES_ST varchar(32) NOT NULL);
		
CREATE INDEX IDX_ODBFolderActTest ON ODBFolderActTest(MSMT_TIME);
 ALTER TABLE ODBFolderActTest ADD constraint PK_ODBFolderActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
		 
DROP TABLE ODBFolderActTest_TREND;
CREATE TABLE ODBFolderActTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_STCNT varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
	UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_STCNT varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
	FOLDER_COPIES_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_COPIES_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_COPIES_STCNT varchar(32) NOT NULL,
	FOLDER_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_CREATIONS_STCNT varchar(32) NOT NULL,
	FOLDER_DELETIONS_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_STCNT varchar(32) NOT NULL,
	FOLDER_DELETIONS_I_BIN_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_I_BIN_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_I_BIN_STCNT varchar(32) NOT NULL,
	FOLDER_DELETIONS_II_BIN_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_II_BIN_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_DELETIONS_II_BIN_STCNT varchar(32) NOT NULL,
	FOLDER_MODIFICATIONS_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_MODIFICATIONS_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_MODIFICATIONS_STCNT varchar(32) NOT NULL,
	FOLDER_MOVES_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_MOVES_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_MOVES_STCNT varchar(32) NOT NULL,
	FOLDER_RENAMES_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_RENAMES_MAX DECIMAL(20,4) NOT NULL,
	FOLDER_RENAMES_STCNT varchar(32) NOT NULL,
	FOLDER_RESTORES_MIN DECIMAL(20,4) NOT NULL,
	FOLDER_RESTORES_MAX DECIMAL(20,4) NOT NULL, 
	FOLDER_RESTORES_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBFolderActTest_TREND ADD constraint PK_ODBFolderActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFolderActTest_THRESH;
CREATE TABLE ODBFolderActTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
	FOLDER_COPIES_MIN VARCHAR(256) NOT NULL,
	FOLDER_COPIES_MAX VARCHAR(256) NOT NULL,
	FOLDER_CREATIONS_MIN VARCHAR(256) NOT NULL,
	FOLDER_CREATIONS_MAX VARCHAR(256) NOT NULL,
	FOLDER_DELETIONS_MIN VARCHAR(256) NOT NULL,
	FOLDER_DELETIONS_MAX VARCHAR(256) NOT NULL,
	FOLDER_DELETIONS_I_BIN_MIN VARCHAR(256) NOT NULL,
	FOLDER_DELETIONS_I_BIN_MAX VARCHAR(256) NOT NULL,
	FOLDER_DELETIONS_II_BIN_MIN VARCHAR(256) NOT NULL,
	FOLDER_DELETIONS_II_BIN_MAX VARCHAR(256) NOT NULL,
	FOLDER_MODIFICATIONS_MIN VARCHAR(256) NOT NULL,
	FOLDER_MODIFICATIONS_MAX VARCHAR(256) NOT NULL,
	FOLDER_MOVES_MIN VARCHAR(256) NOT NULL,
	FOLDER_MOVES_MAX VARCHAR(256) NOT NULL,
	FOLDER_RENAMES_MIN VARCHAR(256) NOT NULL,
	FOLDER_RENAMES_MAX VARCHAR(256) NOT NULL,
	FOLDER_RESTORES_MIN VARCHAR(256) NOT NULL, 
	FOLDER_RESTORES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBFolderActTest_THRESH ADD constraint PK_ODBFolderActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFolderActTest_THRESH ON ODBFolderActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFolderActTest ON ODBFolderActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFolderActTest ON ODBFolderActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileInteractnTest;
CREATE TABLE ODBFileInteractnTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Total_operations DECIMAL(20,4) NOT NULL,
Total_operations_ST varchar(32) NOT NULL,
File_vieworedit DECIMAL(20,4) NOT NULL,
File_vieworedit_ST varchar(32) NOT NULL,
File_synced DECIMAL(20,4) NOT NULL,
File_synced_ST varchar(32) NOT NULL,
File_shared_intern DECIMAL(20,4) NOT NULL,
File_shared_intern_ST varchar(32) NOT NULL,
File_shared_extern DECIMAL(20,4) NOT NULL,
File_shared_extern_ST varchar(32) NOT NULL,
Usr_vieworedit DECIMAL(20,4) NOT NULL,
Usr_vieworedit_ST varchar(32) NOT NULL,
Usr_synced DECIMAL(20,4) NOT NULL,
Usr_synced_ST varchar(32) NOT NULL,
Usr_shared_intern DECIMAL(20,4) NOT NULL,
Usr_shared_intern_ST varchar(32) NOT NULL,
Usr_shared_extern DECIMAL(20,4) NOT NULL,
Usr_shared_extern_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBFileInteractnTest ON ODBFileInteractnTest(MSMT_TIME);
ALTER TABLE ODBFileInteractnTest ADD constraint PK_ODBFileInteractnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileInteractnTest_TREND;
CREATE TABLE ODBFileInteractnTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Total_operations_MIN DECIMAL(20,4) NOT NULL,
Total_operations_MAX DECIMAL(20,4) NOT NULL,
Total_operations_STCNT varchar(32) NOT NULL,
File_vieworedit_MIN DECIMAL(20,4) NOT NULL,
File_vieworedit_MAX DECIMAL(20,4) NOT NULL,
File_vieworedit_STCNT varchar(32) NOT NULL,
File_synced_MIN DECIMAL(20,4) NOT NULL,
File_synced_MAX DECIMAL(20,4) NOT NULL,
File_synced_STCNT varchar(32) NOT NULL,
File_shared_intern_MIN DECIMAL(20,4) NOT NULL,
File_shared_intern_MAX DECIMAL(20,4) NOT NULL,
File_shared_intern_STCNT varchar(32) NOT NULL,
File_shared_extern_MIN DECIMAL(20,4) NOT NULL,
File_shared_extern_MAX DECIMAL(20,4) NOT NULL,
File_shared_extern_STCNT varchar(32) NOT NULL,
Usr_vieworedit_MIN DECIMAL(20,4) NOT NULL,
Usr_vieworedit_MAX DECIMAL(20,4) NOT NULL,
Usr_vieworedit_STCNT varchar(32) NOT NULL,
Usr_synced_MIN DECIMAL(20,4) NOT NULL,
Usr_synced_MAX DECIMAL(20,4) NOT NULL,
Usr_synced_STCNT varchar(32) NOT NULL,
Usr_shared_intern_MIN DECIMAL(20,4) NOT NULL,
Usr_shared_intern_MAX DECIMAL(20,4) NOT NULL,
Usr_shared_intern_STCNT varchar(32) NOT NULL,
Usr_shared_extern_MIN DECIMAL(20,4) NOT NULL,
Usr_shared_extern_MAX DECIMAL(20,4) NOT NULL,
Usr_shared_extern_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBFileInteractnTest_TREND ADD constraint PK_ODBFileInteractnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileInteractnTest_THRESH;
CREATE TABLE ODBFileInteractnTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Total_operations_MIN VARCHAR(256) NOT NULL,
Total_operations_MAX VARCHAR(256) NOT NULL,
File_vieworedit_MIN VARCHAR(256) NOT NULL,
File_vieworedit_MAX VARCHAR(256) NOT NULL,
File_synced_MIN VARCHAR(256) NOT NULL,
File_synced_MAX VARCHAR(256) NOT NULL,
File_shared_intern_MIN VARCHAR(256) NOT NULL,
File_shared_intern_MAX VARCHAR(256) NOT NULL,
File_shared_extern_MIN VARCHAR(256) NOT NULL,
File_shared_extern_MAX VARCHAR(256) NOT NULL,
Usr_vieworedit_MIN VARCHAR(256) NOT NULL,
Usr_vieworedit_MAX VARCHAR(256) NOT NULL,
Usr_synced_MIN VARCHAR(256) NOT NULL,
Usr_synced_MAX VARCHAR(256) NOT NULL,
Usr_shared_intern_MIN VARCHAR(256) NOT NULL,
Usr_shared_intern_MAX VARCHAR(256) NOT NULL,
Usr_shared_extern_MIN VARCHAR(256) NOT NULL,
Usr_shared_extern_MAX VARCHAR(256) NOT NULL);
ALTER TABLE ODBFileInteractnTest_THRESH ADD constraint PK_ODBFileInteractnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileInteractnTest_THRESH ON ODBFileInteractnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileInteractnTest ON ODBFileInteractnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileInteractnTest ON ODBFileInteractnTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBFileOperatnsTest;
CREATE TABLE ODBFileOperatnsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
File_upload_status DECIMAL(20,4) NOT NULL,
File_upload_status_ST varchar(32) NOT NULL,
File_upload_time DECIMAL(20,4) NOT NULL,
File_upload_time_ST varchar(32) NOT NULL,
File_download_status DECIMAL(20,4) NOT NULL,
File_download_status_ST varchar(32) NOT NULL,
File_download_time DECIMAL(20,4) NOT NULL,
File_download_time_ST varchar(32) NOT NULL,
File_deletion_status DECIMAL(20,4) NOT NULL,
File_deletion_status_ST varchar(32) NOT NULL,
File_deletion_time DECIMAL(20,4) NOT NULL,
File_deletion_time_ST varchar(32) NOT NULL);
CREATE INDEX IDX_ODBFileOperatnsTest ON ODBFileOperatnsTest(MSMT_TIME);
ALTER TABLE ODBFileOperatnsTest ADD constraint PK_ODBFileOperatnsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ODBFileOperatnsTest_TREND;
CREATE TABLE ODBFileOperatnsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
File_upload_status_MIN DECIMAL(20,4) NOT NULL,
File_upload_status_MAX DECIMAL(20,4) NOT NULL,
File_upload_status_STCNT varchar(32) NOT NULL,
File_upload_time_MIN DECIMAL(20,4) NOT NULL,
File_upload_time_MAX DECIMAL(20,4) NOT NULL,
File_upload_time_STCNT varchar(32) NOT NULL,
File_download_status_MIN DECIMAL(20,4) NOT NULL,
File_download_status_MAX DECIMAL(20,4) NOT NULL,
File_download_status_STCNT varchar(32) NOT NULL,
File_download_time_MIN DECIMAL(20,4) NOT NULL,
File_download_time_MAX DECIMAL(20,4) NOT NULL,
File_download_time_STCNT varchar(32) NOT NULL,
File_deletion_status_MIN DECIMAL(20,4) NOT NULL,
File_deletion_status_MAX DECIMAL(20,4) NOT NULL,
File_deletion_status_STCNT varchar(32) NOT NULL,
File_deletion_time_MIN DECIMAL(20,4) NOT NULL,
File_deletion_time_MAX DECIMAL(20,4) NOT NULL,
File_deletion_time_STCNT varchar(32) NOT NULL);
ALTER TABLE ODBFileOperatnsTest_TREND ADD constraint PK_ODBFileOperatnsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE ODBFileOperatnsTest_THRESH;
CREATE TABLE ODBFileOperatnsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
File_upload_status_MIN VARCHAR(256) NOT NULL,
File_upload_status_MAX VARCHAR(256) NOT NULL,
File_upload_time_MIN VARCHAR(256) NOT NULL,
File_upload_time_MAX VARCHAR(256) NOT NULL,
File_download_status_MIN VARCHAR(256) NOT NULL,
File_download_status_MAX VARCHAR(256) NOT NULL,
File_download_time_MIN VARCHAR(256) NOT NULL,
File_download_time_MAX VARCHAR(256) NOT NULL,
File_deletion_status_MIN VARCHAR(256) NOT NULL,
File_deletion_status_MAX VARCHAR(256) NOT NULL,
File_deletion_time_MIN VARCHAR(256) NOT NULL,
File_deletion_time_MAX VARCHAR(256) NOT NULL);
ALTER TABLE ODBFileOperatnsTest_THRESH ADD constraint PK_ODBFileOperatnsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileOperatnsTest_THRESH ON ODBFileOperatnsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileOperatnsTest ON ODBFileOperatnsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileOperatnsTest ON ODBFileOperatnsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBFileUsageTest;
CREATE TABLE ODBFileUsageTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Total_file DECIMAL(20,4) NOT NULL,
Total_file_ST varchar(32) NOT NULL,
Active_file DECIMAL(20,4) NOT NULL,
Active_file_ST varchar(32) NOT NULL,
Active_file_percent DECIMAL(20,4) NOT NULL,
Active_file_percent_ST varchar(32) NOT NULL,
File_growth_rate DECIMAL(20,4) NOT NULL,
File_growth_rate_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_ODBFileUsageTest ON ODBFileUsageTest(MSMT_TIME);
ALTER TABLE ODBFileUsageTest ADD constraint PK_ODBFileUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileUsageTest_TREND;
CREATE TABLE ODBFileUsageTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Total_file_MIN DECIMAL(20,4) NOT NULL,
Total_file_MAX DECIMAL(20,4) NOT NULL,
Total_file_STCNT varchar(32) NOT NULL,
Active_file_MIN DECIMAL(20,4) NOT NULL,
Active_file_MAX DECIMAL(20,4) NOT NULL,
Active_file_STCNT varchar(32) NOT NULL,
Active_file_percent_MIN DECIMAL(20,4) NOT NULL,
Active_file_percent_MAX DECIMAL(20,4) NOT NULL,
Active_file_percent_STCNT varchar(32) NOT NULL,
File_growth_rate_MIN DECIMAL(20,4) NOT NULL,
File_growth_rate_MAX DECIMAL(20,4) NOT NULL,
File_growth_rate_STCNT varchar(32) NOT NULL
);


ALTER TABLE ODBFileUsageTest_TREND ADD constraint PK_ODBFileUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileUsageTest_THRESH;
CREATE TABLE ODBFileUsageTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Total_file_MIN VARCHAR(256) NOT NULL,
Total_file_MAX VARCHAR(256) NOT NULL,
Active_file_MIN VARCHAR(256) NOT NULL,
Active_file_MAX VARCHAR(256) NOT NULL,
Active_file_percent_MIN VARCHAR(256) NOT NULL,
Active_file_percent_MAX VARCHAR(256) NOT NULL,
File_growth_rate_MIN VARCHAR(256) NOT NULL,
File_growth_rate_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE ODBFileUsageTest_THRESH ADD constraint PK_ODBFileUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileUsageTest_THRESH ON ODBFileUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileUsageTest ON ODBFileUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileUsageTest ON ODBFileUsageTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBSAdminActTest;
CREATE TABLE ODBSAdminActTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USERS DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_ST varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
	UNIQUE_SITES DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_ST varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
	USR_AGENT_EXMPT_ADDITION DECIMAL(20,4) NOT NULL,
	USR_AGENT_EXMPT_ADDITION_ST varchar(32) NOT NULL,
	USR_AGENT_EXMPT_MODIFITN DECIMAL(20,4) NOT NULL,
	USR_AGENT_EXMPT_MODIFITN_ST varchar(32) NOT NULL,
	SIT_COLLECTN_ADMIN_ADDTN DECIMAL(20,4) NOT NULL,
	SIT_COLLECTN_ADMIN_ADDTN_ST varchar(32) NOT NULL,
	USER_GROUP_ADDITIONS DECIMAL(20,4) NOT NULL,
	USER_GROUP_ADDITIONS_ST varchar(32) NOT NULL,
	ADD_USERGROUP_PERMITS DECIMAL(20,4) NOT NULL,
	ADD_USERGROUP_PERMITS_ST varchar(32) NOT NULL,
	SHARING_POLICY_MODIFCTN DECIMAL(20,4) NOT NULL,
	SHARING_POLICY_MODIFCTN_ST varchar(32) NOT NULL,
	GROUP_ADDITIONS DECIMAL(20,4) NOT NULL,
	GROUP_ADDITIONS_ST varchar(32) NOT NULL,
	SEND_TO_CONN_CREATION DECIMAL(20,4) NOT NULL,
	SEND_TO_CONN_CREATION_ST varchar(32) NOT NULL,
	SITE_COLLECTION_CREATION DECIMAL(20,4) NOT NULL,
	SITE_COLLECTION_CREATION_ST varchar(32) NOT NULL,
	GROUP_DELETES DECIMAL(20,4) NOT NULL,
	GROUP_DELETES_ST varchar(32) NOT NULL,
	SEND_TO_CONN_DELETES DECIMAL(20,4) NOT NULL,
	SEND_TO_CONN_DELETES_ST varchar(32) NOT NULL,
	SITE_DELETES DECIMAL(20,4) NOT NULL,
	SITE_DELETES_ST varchar(32) NOT NULL,
	DOCUMENT_PREVIEW_PERMITS DECIMAL(20,4) NOT NULL,
	DOCUMENT_PREVIEW_PERMITS_ST varchar(32) NOT NULL,
	WORKFLOW_TASK_CONTNT DECIMAL(20,4) NOT NULL,
	WORKFLOW_TASK_CONTNT_ST varchar(32) NOT NULL,
	OFFICE_ONDEMAND_PERMITS DECIMAL(20,4) NOT NULL,
	OFFICE_ONDEMAND_PERMITS_ST varchar(32) NOT NULL,
	NEWS_FEED_PERMITS DECIMAL(20,4) NOT NULL,
	NEWS_FEED_PERMITS_ST varchar(32) NOT NULL,
	SITE_PERMISSN_MODIFICTN DECIMAL(20,4) NOT NULL,
	SITE_PERMISSN_MODIFICTN_ST varchar(32) NOT NULL,
	REMOVALS_FROM_GROUP DECIMAL(20,4) NOT NULL,
	REMOVALS_FROM_GROUP_ST varchar(32) NOT NULL,
	SITE_RENAMES DECIMAL(20,4) NOT NULL,
	SITE_RENAMES_ST varchar(32) NOT NULL,
	SITE_ADMIN_REQUESTS DECIMAL(20,4) NOT NULL,
	SITE_ADMIN_REQUESTS_ST varchar(32) NOT NULL,
	HOST_SITE_CHANGES DECIMAL(20,4) NOT NULL,
	HOST_SITE_CHANGES_ST varchar(32) NOT NULL,
	GROUP_SETTINGS_CHANGES DECIMAL(20,4) NOT NULL, 
	GROUP_SETTINGS_CHANGES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBSAdminActTest ON ODBSAdminActTest(MSMT_TIME);
ALTER TABLE ODBSAdminActTest ADD constraint PK_ODBSAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSAdminActTest_TREND;
CREATE TABLE ODBSAdminActTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_STCNT varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
	UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_STCNT varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
	USR_AGENT_EXMPT_ADDITION_MIN DECIMAL(20,4) NOT NULL,
	USR_AGENT_EXMPT_ADDITION_MAX DECIMAL(20,4) NOT NULL,
	USR_AGENT_EXMPT_ADDITION_STCNT varchar(32) NOT NULL,
	USR_AGENT_EXMPT_MODIFITN_MIN DECIMAL(20,4) NOT NULL,
	USR_AGENT_EXMPT_MODIFITN_MAX DECIMAL(20,4) NOT NULL,
	USR_AGENT_EXMPT_MODIFITN_STCNT varchar(32) NOT NULL,
	SIT_COLLECTN_ADMIN_ADDTN_MIN DECIMAL(20,4) NOT NULL,
	SIT_COLLECTN_ADMIN_ADDTN_MAX DECIMAL(20,4) NOT NULL,
	SIT_COLLECTN_ADMIN_ADDTN_STCNT varchar(32) NOT NULL,
	USER_GROUP_ADDITIONS_MIN DECIMAL(20,4) NOT NULL,
	USER_GROUP_ADDITIONS_MAX DECIMAL(20,4) NOT NULL,
	USER_GROUP_ADDITIONS_STCNT varchar(32) NOT NULL,
	ADD_USERGROUP_PERMITS_MIN DECIMAL(20,4) NOT NULL,
	ADD_USERGROUP_PERMITS_MAX DECIMAL(20,4) NOT NULL,
	ADD_USERGROUP_PERMITS_STCNT varchar(32) NOT NULL,
	SHARING_POLICY_MODIFCTN_MIN DECIMAL(20,4) NOT NULL,
	SHARING_POLICY_MODIFCTN_MAX DECIMAL(20,4) NOT NULL,
	SHARING_POLICY_MODIFCTN_STCNT varchar(32) NOT NULL,
	GROUP_ADDITIONS_MIN DECIMAL(20,4) NOT NULL,
	GROUP_ADDITIONS_MAX DECIMAL(20,4) NOT NULL,
	GROUP_ADDITIONS_STCNT varchar(32) NOT NULL,
	SEND_TO_CONN_CREATION_MIN DECIMAL(20,4) NOT NULL,
	SEND_TO_CONN_CREATION_MAX DECIMAL(20,4) NOT NULL,
	SEND_TO_CONN_CREATION_STCNT varchar(32) NOT NULL,
	SITE_COLLECTION_CREATION_MIN DECIMAL(20,4) NOT NULL,
	SITE_COLLECTION_CREATION_MAX DECIMAL(20,4) NOT NULL,
	SITE_COLLECTION_CREATION_STCNT varchar(32) NOT NULL,
	GROUP_DELETES_MIN DECIMAL(20,4) NOT NULL,
	GROUP_DELETES_MAX DECIMAL(20,4) NOT NULL,
	GROUP_DELETES_STCNT varchar(32) NOT NULL,
	SEND_TO_CONN_DELETES_MIN DECIMAL(20,4) NOT NULL,
	SEND_TO_CONN_DELETES_MAX DECIMAL(20,4) NOT NULL,
	SEND_TO_CONN_DELETES_STCNT varchar(32) NOT NULL,
	SITE_DELETES_MIN DECIMAL(20,4) NOT NULL,
	SITE_DELETES_MAX DECIMAL(20,4) NOT NULL,
	SITE_DELETES_STCNT varchar(32) NOT NULL,
	DOCUMENT_PREVIEW_PERMITS_MIN DECIMAL(20,4) NOT NULL,
	DOCUMENT_PREVIEW_PERMITS_MAX DECIMAL(20,4) NOT NULL,
	DOCUMENT_PREVIEW_PERMITS_STCNT varchar(32) NOT NULL,
	WORKFLOW_TASK_CONTNT_MIN DECIMAL(20,4) NOT NULL,
	WORKFLOW_TASK_CONTNT_MAX DECIMAL(20,4) NOT NULL,
	WORKFLOW_TASK_CONTNT_STCNT varchar(32) NOT NULL,
	OFFICE_ONDEMAND_PERMITS_MIN DECIMAL(20,4) NOT NULL,
	OFFICE_ONDEMAND_PERMITS_MAX DECIMAL(20,4) NOT NULL,
	OFFICE_ONDEMAND_PERMITS_STCNT varchar(32) NOT NULL,
	NEWS_FEED_PERMITS_MIN DECIMAL(20,4) NOT NULL,
	NEWS_FEED_PERMITS_MAX DECIMAL(20,4) NOT NULL,
	NEWS_FEED_PERMITS_STCNT varchar(32) NOT NULL,
	SITE_PERMISSN_MODIFICTN_MIN DECIMAL(20,4) NOT NULL,
	SITE_PERMISSN_MODIFICTN_MAX DECIMAL(20,4) NOT NULL,
	SITE_PERMISSN_MODIFICTN_STCNT varchar(32) NOT NULL,
	REMOVALS_FROM_GROUP_MIN DECIMAL(20,4) NOT NULL,
	REMOVALS_FROM_GROUP_MAX DECIMAL(20,4) NOT NULL,
	REMOVALS_FROM_GROUP_STCNT varchar(32) NOT NULL,
	SITE_RENAMES_MIN DECIMAL(20,4) NOT NULL,
	SITE_RENAMES_MAX DECIMAL(20,4) NOT NULL,
	SITE_RENAMES_STCNT varchar(32) NOT NULL,
	SITE_ADMIN_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
	SITE_ADMIN_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
	SITE_ADMIN_REQUESTS_STCNT varchar(32) NOT NULL,
	HOST_SITE_CHANGES_MIN DECIMAL(20,4) NOT NULL,
	HOST_SITE_CHANGES_MAX DECIMAL(20,4) NOT NULL,
	HOST_SITE_CHANGES_STCNT varchar(32) NOT NULL,
	GROUP_SETTINGS_CHANGES_MIN DECIMAL(20,4) NOT NULL,
	GROUP_SETTINGS_CHANGES_MAX DECIMAL(20,4) NOT NULL, 
	GROUP_SETTINGS_CHANGES_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBSAdminActTest_TREND ADD constraint PK_ODBSAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSAdminActTest_THRESH;
CREATE TABLE ODBSAdminActTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
	USR_AGENT_EXMPT_ADDITION_MIN VARCHAR(256) NOT NULL,
	USR_AGENT_EXMPT_ADDITION_MAX VARCHAR(256) NOT NULL,
	USR_AGENT_EXMPT_MODIFITN_MIN VARCHAR(256) NOT NULL,
	USR_AGENT_EXMPT_MODIFITN_MAX VARCHAR(256) NOT NULL,
	SIT_COLLECTN_ADMIN_ADDTN_MIN VARCHAR(256) NOT NULL,
	SIT_COLLECTN_ADMIN_ADDTN_MAX VARCHAR(256) NOT NULL,
	USER_GROUP_ADDITIONS_MIN VARCHAR(256) NOT NULL,
	USER_GROUP_ADDITIONS_MAX VARCHAR(256) NOT NULL,
	ADD_USERGROUP_PERMITS_MIN VARCHAR(256) NOT NULL,
	ADD_USERGROUP_PERMITS_MAX VARCHAR(256) NOT NULL,
	SHARING_POLICY_MODIFCTN_MIN VARCHAR(256) NOT NULL,
	SHARING_POLICY_MODIFCTN_MAX VARCHAR(256) NOT NULL,
	GROUP_ADDITIONS_MIN VARCHAR(256) NOT NULL,
	GROUP_ADDITIONS_MAX VARCHAR(256) NOT NULL,
	SEND_TO_CONN_CREATION_MIN VARCHAR(256) NOT NULL,
	SEND_TO_CONN_CREATION_MAX VARCHAR(256) NOT NULL,
	SITE_COLLECTION_CREATION_MIN VARCHAR(256) NOT NULL,
	SITE_COLLECTION_CREATION_MAX VARCHAR(256) NOT NULL,
	GROUP_DELETES_MIN VARCHAR(256) NOT NULL,
	GROUP_DELETES_MAX VARCHAR(256) NOT NULL,
	SEND_TO_CONN_DELETES_MIN VARCHAR(256) NOT NULL,
	SEND_TO_CONN_DELETES_MAX VARCHAR(256) NOT NULL,
	SITE_DELETES_MIN VARCHAR(256) NOT NULL,
	SITE_DELETES_MAX VARCHAR(256) NOT NULL,
	DOCUMENT_PREVIEW_PERMITS_MIN VARCHAR(256) NOT NULL,
	DOCUMENT_PREVIEW_PERMITS_MAX VARCHAR(256) NOT NULL,
	WORKFLOW_TASK_CONTNT_MIN VARCHAR(256) NOT NULL,
	WORKFLOW_TASK_CONTNT_MAX VARCHAR(256) NOT NULL,
	OFFICE_ONDEMAND_PERMITS_MIN VARCHAR(256) NOT NULL,
	OFFICE_ONDEMAND_PERMITS_MAX VARCHAR(256) NOT NULL,
	NEWS_FEED_PERMITS_MIN VARCHAR(256) NOT NULL,
	NEWS_FEED_PERMITS_MAX VARCHAR(256) NOT NULL,
	SITE_PERMISSN_MODIFICTN_MIN VARCHAR(256) NOT NULL,
	SITE_PERMISSN_MODIFICTN_MAX VARCHAR(256) NOT NULL,
	REMOVALS_FROM_GROUP_MIN VARCHAR(256) NOT NULL,
	REMOVALS_FROM_GROUP_MAX VARCHAR(256) NOT NULL,
	SITE_RENAMES_MIN VARCHAR(256) NOT NULL,
	SITE_RENAMES_MAX VARCHAR(256) NOT NULL,
	SITE_ADMIN_REQUESTS_MIN VARCHAR(256) NOT NULL,
	SITE_ADMIN_REQUESTS_MAX VARCHAR(256) NOT NULL,
	HOST_SITE_CHANGES_MIN VARCHAR(256) NOT NULL,
	HOST_SITE_CHANGES_MAX VARCHAR(256) NOT NULL,
	GROUP_SETTINGS_CHANGES_MIN VARCHAR(256) NOT NULL, 
	GROUP_SETTINGS_CHANGES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBSAdminActTest_THRESH ADD constraint PK_ODBSAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSAdminActTest_THRESH ON ODBSAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSAdminActTest ON ODBSAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSAdminActTest ON ODBSAdminActTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ODBSharngActTest;
CREATE TABLE ODBSharngActTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USERS DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_ST varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
	UNIQUE_SITES DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_ST varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
	ACCESS_REQ_ACCEPTANCE DECIMAL(20,4) NOT NULL,
	ACCESS_REQ_ACCEPTANCE_ST varchar(32) NOT NULL,
	SHARNG_INVITATN_ACCEPTNC DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_ACCEPTNC_ST varchar(32) NOT NULL,
	SHARNG_INVITATN_BLOCKED DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_BLOCKED_ST varchar(32) NOT NULL,
	COMPANY_LINK_CREATIONS DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_CREATIONS_ST varchar(32) NOT NULL,
	ACCESS_REQUEST_CREATIONS DECIMAL(20,4) NOT NULL,
	ACCESS_REQUEST_CREATIONS_ST varchar(32) NOT NULL,
	ANONYMOUS_LINK_CREATIONS DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_CREATIONS_ST varchar(32) NOT NULL,
	SHARNG_INVITATN_CREATION DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_CREATION_ST varchar(32) NOT NULL,
	ACCESS_REQUEST_DENIALS DECIMAL(20,4) NOT NULL,
	ACCESS_REQUEST_DENIALS_ST varchar(32) NOT NULL,
	COMPANY_LINK_REMOVALS DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_REMOVALS_ST varchar(32) NOT NULL,
	ANONYMOUS_LINK_REMOVALS DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_REMOVALS_ST varchar(32) NOT NULL,
	FILE_FOLDER_SITE_SHARE DECIMAL(20,4) NOT NULL,
	FILE_FOLDER_SITE_SHARE_ST varchar(32) NOT NULL,
	ANONYMOUS_LINK_UPDATES DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_UPDATES_ST varchar(32) NOT NULL,
	ANONYMOUS_LINK_USAGE DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_USAGE_ST varchar(32) NOT NULL,
	SHARING_REVOKES DECIMAL(20,4) NOT NULL,
	SHARING_REVOKES_ST varchar(32) NOT NULL,
	COMPANY_LINK_USAGE DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_USAGE_ST varchar(32) NOT NULL,
	SHARNG_INVITATN_WITHDRW DECIMAL(20,4) NOT NULL, 
	SHARNG_INVITATN_WITHDRW_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBSharngActTest ON ODBSharngActTest(MSMT_TIME);
ALTER TABLE ODBSharngActTest ADD constraint PK_ODBSharngActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSharngActTest_TREND;
CREATE TABLE ODBSharngActTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_STCNT varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
	UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_STCNT varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
	ACCESS_REQ_ACCEPTANCE_MIN DECIMAL(20,4) NOT NULL,
	ACCESS_REQ_ACCEPTANCE_MAX DECIMAL(20,4) NOT NULL,
	ACCESS_REQ_ACCEPTANCE_STCNT varchar(32) NOT NULL,
	SHARNG_INVITATN_ACCEPTNC_MIN DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_ACCEPTNC_MAX DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_ACCEPTNC_STCNT varchar(32) NOT NULL,
	SHARNG_INVITATN_BLOCKED_MIN DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_BLOCKED_MAX DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_BLOCKED_STCNT varchar(32) NOT NULL,
	COMPANY_LINK_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_CREATIONS_STCNT varchar(32) NOT NULL,
	ACCESS_REQUEST_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
	ACCESS_REQUEST_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
	ACCESS_REQUEST_CREATIONS_STCNT varchar(32) NOT NULL,
	ANONYMOUS_LINK_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_CREATIONS_STCNT varchar(32) NOT NULL,
	SHARNG_INVITATN_CREATION_MIN DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_CREATION_MAX DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_CREATION_STCNT varchar(32) NOT NULL,
	ACCESS_REQUEST_DENIALS_MIN DECIMAL(20,4) NOT NULL,
	ACCESS_REQUEST_DENIALS_MAX DECIMAL(20,4) NOT NULL,
	ACCESS_REQUEST_DENIALS_STCNT varchar(32) NOT NULL,
	COMPANY_LINK_REMOVALS_MIN DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_REMOVALS_MAX DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_REMOVALS_STCNT varchar(32) NOT NULL,
	ANONYMOUS_LINK_REMOVALS_MIN DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_REMOVALS_MAX DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_REMOVALS_STCNT varchar(32) NOT NULL,
	FILE_FOLDER_SITE_SHARE_MIN DECIMAL(20,4) NOT NULL,
	FILE_FOLDER_SITE_SHARE_MAX DECIMAL(20,4) NOT NULL,
	FILE_FOLDER_SITE_SHARE_STCNT varchar(32) NOT NULL,
	ANONYMOUS_LINK_UPDATES_MIN DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_UPDATES_MAX DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_UPDATES_STCNT varchar(32) NOT NULL,
	ANONYMOUS_LINK_USAGE_MIN DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_USAGE_MAX DECIMAL(20,4) NOT NULL,
	ANONYMOUS_LINK_USAGE_STCNT varchar(32) NOT NULL,
	SHARING_REVOKES_MIN DECIMAL(20,4) NOT NULL,
	SHARING_REVOKES_MAX DECIMAL(20,4) NOT NULL,
	SHARING_REVOKES_STCNT varchar(32) NOT NULL,
	COMPANY_LINK_USAGE_MIN DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_USAGE_MAX DECIMAL(20,4) NOT NULL,
	COMPANY_LINK_USAGE_STCNT varchar(32) NOT NULL,
	SHARNG_INVITATN_WITHDRW_MIN DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_WITHDRW_MAX DECIMAL(20,4) NOT NULL,
	SHARNG_INVITATN_WITHDRW_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBSharngActTest_TREND ADD constraint PK_ODBSharngActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSharngActTest_THRESH;
CREATE TABLE ODBSharngActTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
	ACCESS_REQ_ACCEPTANCE_MIN VARCHAR(256) NOT NULL,
	ACCESS_REQ_ACCEPTANCE_MAX VARCHAR(256) NOT NULL,
	SHARNG_INVITATN_ACCEPTNC_MIN VARCHAR(256) NOT NULL,
	SHARNG_INVITATN_ACCEPTNC_MAX VARCHAR(256) NOT NULL,
	SHARNG_INVITATN_BLOCKED_MIN VARCHAR(256) NOT NULL,
	SHARNG_INVITATN_BLOCKED_MAX VARCHAR(256) NOT NULL,
	COMPANY_LINK_CREATIONS_MIN VARCHAR(256) NOT NULL,
	COMPANY_LINK_CREATIONS_MAX VARCHAR(256) NOT NULL,
	ACCESS_REQUEST_CREATIONS_MIN VARCHAR(256) NOT NULL,
	ACCESS_REQUEST_CREATIONS_MAX VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_CREATIONS_MIN VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_CREATIONS_MAX VARCHAR(256) NOT NULL,
	SHARNG_INVITATN_CREATION_MIN VARCHAR(256) NOT NULL,
	SHARNG_INVITATN_CREATION_MAX VARCHAR(256) NOT NULL,
	ACCESS_REQUEST_DENIALS_MIN VARCHAR(256) NOT NULL,
	ACCESS_REQUEST_DENIALS_MAX VARCHAR(256) NOT NULL,
	COMPANY_LINK_REMOVALS_MIN VARCHAR(256) NOT NULL,
	COMPANY_LINK_REMOVALS_MAX VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_REMOVALS_MIN VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_REMOVALS_MAX VARCHAR(256) NOT NULL,
	FILE_FOLDER_SITE_SHARE_MIN VARCHAR(256) NOT NULL,
	FILE_FOLDER_SITE_SHARE_MAX VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_UPDATES_MIN VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_UPDATES_MAX VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_USAGE_MIN VARCHAR(256) NOT NULL,
	ANONYMOUS_LINK_USAGE_MAX VARCHAR(256) NOT NULL,
	SHARING_REVOKES_MIN VARCHAR(256) NOT NULL,
	SHARING_REVOKES_MAX VARCHAR(256) NOT NULL,
	COMPANY_LINK_USAGE_MIN VARCHAR(256) NOT NULL,
	COMPANY_LINK_USAGE_MAX VARCHAR(256) NOT NULL,
	SHARNG_INVITATN_WITHDRW_MIN VARCHAR(256) NOT NULL, 
	SHARNG_INVITATN_WITHDRW_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBSharngActTest_THRESH ADD constraint PK_ODBSharngActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSharngActTest_THRESH ON ODBSharngActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSharngActTest ON ODBSharngActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSharngActTest ON ODBSharngActTest_TREND (MSMT_TIME,PERIOD);
	 
DROP TABLE ODBSyncActTest;
CREATE TABLE ODBSyncActTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USERS DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_ST varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
	UNIQUE_SITES DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_ST varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
	FILE_SYNC_PERMITS DECIMAL(20,4) NOT NULL,
	FILE_SYNC_PERMITS_ST varchar(32) NOT NULL,
	FILE_SYNC_BLOCKS DECIMAL(20,4) NOT NULL,
	FILE_SYNC_BLOCKS_ST varchar(32) NOT NULL,
	FILE_DOWNLOADS DECIMAL(20,4) NOT NULL,
	FILE_DOWNLOADS_ST varchar(32) NOT NULL,
	FILE_CHANGES_DOWNLOADS DECIMAL(20,4) NOT NULL,
	FILE_CHANGES_DOWNLOADS_ST varchar(32) NOT NULL,
	FILE_UPLOADS DECIMAL(20,4) NOT NULL,
	FILE_UPLOADS_ST varchar(32) NOT NULL,
	FILE_CHANGES_UPLOADS DECIMAL(20,4) NOT NULL, 
	FILE_CHANGES_UPLOADS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBSyncActTest ON ODBSyncActTest(MSMT_TIME);
ALTER TABLE ODBSyncActTest ADD constraint PK_ODBSyncActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSyncActTest_TREND;
CREATE TABLE ODBSyncActTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USERS_STCNT varchar(32) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
	UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_SITES_STCNT varchar(32) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
	AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
	UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
	UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
	UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
	FILE_SYNC_PERMITS_MIN DECIMAL(20,4) NOT NULL,
	FILE_SYNC_PERMITS_MAX DECIMAL(20,4) NOT NULL,
	FILE_SYNC_PERMITS_STCNT varchar(32) NOT NULL,
	FILE_SYNC_BLOCKS_MIN DECIMAL(20,4) NOT NULL,
	FILE_SYNC_BLOCKS_MAX DECIMAL(20,4) NOT NULL,
	FILE_SYNC_BLOCKS_STCNT varchar(32) NOT NULL,
	FILE_DOWNLOADS_MIN DECIMAL(20,4) NOT NULL,
	FILE_DOWNLOADS_MAX DECIMAL(20,4) NOT NULL,
	FILE_DOWNLOADS_STCNT varchar(32) NOT NULL,
	FILE_CHANGES_DOWNLOADS_MIN DECIMAL(20,4) NOT NULL,
	FILE_CHANGES_DOWNLOADS_MAX DECIMAL(20,4) NOT NULL,
	FILE_CHANGES_DOWNLOADS_STCNT varchar(32) NOT NULL,
	FILE_UPLOADS_MIN DECIMAL(20,4) NOT NULL,
	FILE_UPLOADS_MAX DECIMAL(20,4) NOT NULL,
	FILE_UPLOADS_STCNT varchar(32) NOT NULL,
	FILE_CHANGES_UPLOADS_MIN DECIMAL(20,4) NOT NULL,
	FILE_CHANGES_UPLOADS_MAX DECIMAL(20,4) NOT NULL, 
	FILE_CHANGES_UPLOADS_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBSyncActTest_TREND ADD constraint PK_ODBSyncActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSyncActTest_THRESH;
CREATE TABLE ODBSyncActTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
	UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
	AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
	UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
	FILE_SYNC_PERMITS_MIN VARCHAR(256) NOT NULL,
	FILE_SYNC_PERMITS_MAX VARCHAR(256) NOT NULL,
	FILE_SYNC_BLOCKS_MIN VARCHAR(256) NOT NULL,
	FILE_SYNC_BLOCKS_MAX VARCHAR(256) NOT NULL,
	FILE_DOWNLOADS_MIN VARCHAR(256) NOT NULL,
	FILE_DOWNLOADS_MAX VARCHAR(256) NOT NULL,
	FILE_CHANGES_DOWNLOADS_MIN VARCHAR(256) NOT NULL,
	FILE_CHANGES_DOWNLOADS_MAX VARCHAR(256) NOT NULL,
	FILE_UPLOADS_MIN VARCHAR(256) NOT NULL,
	FILE_UPLOADS_MAX VARCHAR(256) NOT NULL,
	FILE_CHANGES_UPLOADS_MIN VARCHAR(256) NOT NULL, 
	FILE_CHANGES_UPLOADS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBSyncActTest_THRESH ADD constraint PK_ODBSyncActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSyncActTest_THRESH ON ODBSyncActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSyncActTest ON ODBSyncActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSyncActTest ON ODBSyncActTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBSiteUsageTest;
CREATE TABLE ODBSiteUsageTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Total_sites DECIMAL(20,4) NOT NULL,
Total_sites_ST varchar(32) NOT NULL,
Active_sites DECIMAL(20,4) NOT NULL,
Active_sites_ST varchar(32) NOT NULL,
Active_site_percent DECIMAL(20,4) NOT NULL,
Active_site_percent_ST varchar(32) NOT NULL,
Inactiv_sites DECIMAL(20,4) NOT NULL,
Inactiv_sites_ST varchar(32) NOT NULL,
Strgusd_site DECIMAL(20,4) NOT NULL,
Strgusd_site_ST varchar(32) NOT NULL,
Strgalctd_site DECIMAL(20,4) NOT NULL,
Strgalctd_site_ST varchar(32) NOT NULL,
Strg_used DECIMAL(20,4) NOT NULL,
Strg_used_ST varchar(32) NOT NULL,
Strg_limit DECIMAL(20,4) NOT NULL,
Strg_limit_ST varchar(32) NOT NULL,
Orph_sites DECIMAL(20,4) NOT NULL,
Orph_sites_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_ODBSiteUsageTest ON ODBSiteUsageTest(MSMT_TIME);
ALTER TABLE ODBSiteUsageTest ADD constraint PK_ODBSiteUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSiteUsageTest_TREND;
CREATE TABLE ODBSiteUsageTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Total_sites_MIN DECIMAL(20,4) NOT NULL,
Total_sites_MAX DECIMAL(20,4) NOT NULL,
Total_sites_STCNT varchar(32) NOT NULL,
Active_sites_MIN DECIMAL(20,4) NOT NULL,
Active_sites_MAX DECIMAL(20,4) NOT NULL,
Active_sites_STCNT varchar(32) NOT NULL,
Active_site_percent_MIN DECIMAL(20,4) NOT NULL,
Active_site_percent_MAX DECIMAL(20,4) NOT NULL,
Active_site_percent_STCNT varchar(32) NOT NULL,
Inactiv_sites_MIN DECIMAL(20,4) NOT NULL,
Inactiv_sites_MAX DECIMAL(20,4) NOT NULL,
Inactiv_sites_STCNT varchar(32) NOT NULL,
Strgusd_site_MIN DECIMAL(20,4) NOT NULL,
Strgusd_site_MAX DECIMAL(20,4) NOT NULL,
Strgusd_site_STCNT varchar(32) NOT NULL,
Strgalctd_site_MIN DECIMAL(20,4) NOT NULL,
Strgalctd_site_MAX DECIMAL(20,4) NOT NULL,
Strgalctd_site_STCNT varchar(32) NOT NULL,
Strg_used_MIN DECIMAL(20,4) NOT NULL,
Strg_used_MAX DECIMAL(20,4) NOT NULL,
Strg_used_STCNT varchar(32) NOT NULL,
Strg_limit_MIN DECIMAL(20,4) NOT NULL,
Strg_limit_MAX DECIMAL(20,4) NOT NULL,
Strg_limit_STCNT varchar(32) NOT NULL,
Orph_sites_MIN DECIMAL(20,4) NOT NULL,
Orph_sites_MAX DECIMAL(20,4) NOT NULL,
Orph_sites_STCNT varchar(32) NOT NULL
);


ALTER TABLE ODBSiteUsageTest_TREND ADD constraint PK_ODBSiteUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSiteUsageTest_THRESH;
CREATE TABLE ODBSiteUsageTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Total_sites_MIN VARCHAR(256) NOT NULL,
Total_sites_MAX VARCHAR(256) NOT NULL,
Active_sites_MIN VARCHAR(256) NOT NULL,
Active_sites_MAX VARCHAR(256) NOT NULL,
Active_site_percent_MIN VARCHAR(256) NOT NULL,
Active_site_percent_MAX VARCHAR(256) NOT NULL,
Inactiv_sites_MIN VARCHAR(256) NOT NULL,
Inactiv_sites_MAX VARCHAR(256) NOT NULL,
Strgusd_site_MIN VARCHAR(256) NOT NULL,
Strgusd_site_MAX VARCHAR(256) NOT NULL,
Strgalctd_site_MIN VARCHAR(256) NOT NULL,
Strgalctd_site_MAX VARCHAR(256) NOT NULL,
Strg_used_MIN VARCHAR(256) NOT NULL,
Strg_used_MAX VARCHAR(256) NOT NULL,
Strg_limit_MIN VARCHAR(256) NOT NULL,
Strg_limit_MAX VARCHAR(256) NOT NULL,
Orph_sites_MIN VARCHAR(256) NOT NULL,
Orph_sites_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE ODBSiteUsageTest_THRESH ADD constraint PK_ODBSiteUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSiteUsageTest_THRESH ON ODBSiteUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSiteUsageTest ON ODBSiteUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSiteUsageTest ON ODBSiteUsageTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ODBSrvcHlhTest;
CREATE TABLE ODBSrvcHlhTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVICE_INCIDENTS DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar(32) NOT NULL,
MAINTENANCE_EVENTS DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar(32) NOT NULL,
SERVICE_STATUS DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBSrvcHlhTest ON ODBSrvcHlhTest(MSMT_TIME);
ALTER TABLE ODBSrvcHlhTest ADD constraint PK_ODBSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSrvcHlhTest_TREND;
CREATE TABLE ODBSrvcHlhTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVICE_INCIDENTS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar(32) NOT NULL,
MAINTENANCE_EVENTS_MIN DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar(32) NOT NULL,
SERVICE_STATUS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBSrvcHlhTest_TREND ADD constraint PK_ODBSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSrvcHlhTest_THRESH;
CREATE TABLE ODBSrvcHlhTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVICE_INCIDENTS_MIN VARCHAR(256) NOT NULL,
SERVICE_INCIDENTS_MAX VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MIN VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MAX VARCHAR(256) NOT NULL,
SERVICE_STATUS_MIN VARCHAR(256) NOT NULL,
SERVICE_STATUS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBSrvcHlhTest_THRESH ADD constraint PK_ODBSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSrvcHlhTest_THRESH ON ODBSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSrvcHlhTest ON ODBSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSrvcHlhTest ON ODBSrvcHlhTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ODBMsgCenTest;
CREATE TABLE ODBMsgCenTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MsgCenterCommunication DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_ST varchar(32) NOT NULL);

CREATE INDEX IDX_ODBMsgCenTest ON ODBMsgCenTest(MSMT_TIME);
ALTER TABLE ODBMsgCenTest ADD constraint PK_ODBMsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBMsgCenTest_TREND;
CREATE TABLE ODBMsgCenTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MsgCenterCommunication_MIN DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_MAX DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar(32) NOT NULL);

ALTER TABLE ODBMsgCenTest_TREND ADD constraint PK_ODBMsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBMsgCenTest_THRESH;
CREATE TABLE ODBMsgCenTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MsgCenterCommunication_MIN VARCHAR(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR(256) NOT NULL);

ALTER TABLE ODBMsgCenTest_THRESH ADD constraint PK_ODBMsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBMsgCenTest_THRESH ON ODBMsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBMsgCenTest ON ODBMsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBMsgCenTest ON ODBMsgCenTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EXOUsrConByAppTest;
CREATE TABLE EXOUsrConByAppTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
usrcount DECIMAL(20,4) NOT NULL,
usrcount_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_EXOUsrConByAppTest ON EXOUsrConByAppTest(MSMT_TIME);
ALTER TABLE EXOUsrConByAppTest ADD constraint PK_EXOUsrConByAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsrConByAppTest_TREND;
CREATE TABLE EXOUsrConByAppTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
usrcount_MIN DECIMAL(20,4) NOT NULL,
usrcount_MAX DECIMAL(20,4) NOT NULL,
usrcount_STCNT varchar(32) NOT NULL
);

ALTER TABLE EXOUsrConByAppTest_TREND ADD constraint PK_EXOUsrConByAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsrConByAppTest_THRESH;
CREATE TABLE EXOUsrConByAppTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
usrcount_MIN VARCHAR(256) NOT NULL,
usrcount_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE EXOUsrConByAppTest_THRESH ADD constraint PK_EXOUsrConByAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsrConByAppTest_THRESH ON EXOUsrConByAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsrConByAppTest ON EXOUsrConByAppTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsrConByAppTest ON EXOUsrConByAppTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOUsrLyncVersnTest;
CREATE TABLE EXOUsrLyncVersnTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
usrcount DECIMAL(20,4) NOT NULL,
usrcount_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest(MSMT_TIME);
ALTER TABLE EXOUsrLyncVersnTest ADD constraint PK_EXOUsrLyncVersnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsrLyncVersnTest_TREND;
CREATE TABLE EXOUsrLyncVersnTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
usrcount_MIN DECIMAL(20,4) NOT NULL,
usrcount_MAX DECIMAL(20,4) NOT NULL,
usrcount_STCNT varchar(32) NOT NULL
);

ALTER TABLE EXOUsrLyncVersnTest_TREND ADD constraint PK_EXOUsrLyncVersnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsrLyncVersnTest_THRESH;
CREATE TABLE EXOUsrLyncVersnTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
usrcount_MIN VARCHAR(256) NOT NULL,
usrcount_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE EXOUsrLyncVersnTest_THRESH ADD constraint PK_EXOUsrLyncVersnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsrLyncVersnTest_THRESH ON EXOUsrLyncVersnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE SPOSitUsageSumTest;
CREATE TABLE SPOSitUsageSumTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_SITES DECIMAL(20,4) NOT NULL,
TOTAL_SITES_ST varchar(32) NOT NULL,
ACTIVE_SITES DECIMAL(20,4) NOT NULL,
ACTIVE_SITES_ST varchar(32) NOT NULL,
TOTAL_FILES DECIMAL(20,4) NOT NULL,
TOTAL_FILES_ST varchar(32) NOT NULL,
ACTIVE_FILES DECIMAL(20,4) NOT NULL,
ACTIVE_FILES_ST varchar(32) NOT NULL,
ACTIVE_FILES_PERCENT DECIMAL(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_ST varchar(32) NOT NULL,
PAGE_VIEWS DECIMAL(20,4) NOT NULL,
PAGE_VIEWS_ST varchar(32) NOT NULL,
VISITED_PAGES DECIMAL(20,4) NOT NULL,
VISITED_PAGES_ST varchar(32) NOT NULL,
SITE_CONSUMING DECIMAL(20,4) NOT NULL,
SITE_CONSUMING_ST varchar(32) NOT NULL,
STORAGE_USED DECIMAL(20,4) NOT NULL,
STORAGE_USED_ST varchar(32) NOT NULL,
STORAGE_ALLOCATED DECIMAL(20,4) NOT NULL,
STORAGE_ALLOCATED_ST varchar(32) NOT NULL,
STORAGE_USED_PERCENT DECIMAL(20,4) NOT NULL,
STORAGE_USED_PERCENT_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOSitUsageSumTest ON SPOSitUsageSumTest(MSMT_TIME);
ALTER TABLE SPOSitUsageSumTest ADD constraint PK_SPOSitUsageSumTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSitUsageSumTest_TREND;
CREATE TABLE SPOSitUsageSumTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_SITES_MIN DECIMAL(20,4) NOT NULL,
TOTAL_SITES_MAX DECIMAL(20,4) NOT NULL,
TOTAL_SITES_STCNT varchar(32) NOT NULL,
ACTIVE_SITES_MIN DECIMAL(20,4) NOT NULL,
ACTIVE_SITES_MAX DECIMAL(20,4) NOT NULL,
ACTIVE_SITES_STCNT varchar(32) NOT NULL,
TOTAL_FILES_MIN DECIMAL(20,4) NOT NULL,
TOTAL_FILES_MAX DECIMAL(20,4) NOT NULL,
TOTAL_FILES_STCNT varchar(32) NOT NULL,
ACTIVE_FILES_MIN DECIMAL(20,4) NOT NULL,
ACTIVE_FILES_MAX DECIMAL(20,4) NOT NULL,
ACTIVE_FILES_STCNT varchar(32) NOT NULL,
ACTIVE_FILES_PERCENT_MIN DECIMAL(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_MAX DECIMAL(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_STCNT varchar(32) NOT NULL,
PAGE_VIEWS_MIN DECIMAL(20,4) NOT NULL,
PAGE_VIEWS_MAX DECIMAL(20,4) NOT NULL,
PAGE_VIEWS_STCNT varchar(32) NOT NULL,
VISITED_PAGES_MIN DECIMAL(20,4) NOT NULL,
VISITED_PAGES_MAX DECIMAL(20,4) NOT NULL,
VISITED_PAGES_STCNT varchar(32) NOT NULL,
SITE_CONSUMING_MIN DECIMAL(20,4) NOT NULL,
SITE_CONSUMING_MAX DECIMAL(20,4) NOT NULL,
SITE_CONSUMING_STCNT varchar(32) NOT NULL,
STORAGE_USED_MIN DECIMAL(20,4) NOT NULL,
STORAGE_USED_MAX DECIMAL(20,4) NOT NULL,
STORAGE_USED_STCNT varchar(32) NOT NULL,
STORAGE_ALLOCATED_MIN DECIMAL(20,4) NOT NULL,
STORAGE_ALLOCATED_MAX DECIMAL(20,4) NOT NULL,
STORAGE_ALLOCATED_STCNT varchar(32) NOT NULL,
STORAGE_USED_PERCENT_MIN DECIMAL(20,4) NOT NULL,
STORAGE_USED_PERCENT_MAX DECIMAL(20,4) NOT NULL,
STORAGE_USED_PERCENT_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOSitUsageSumTest_TREND ADD constraint PK_SPOSitUsgSumTst_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSitUsageSumTest_THRESH;
CREATE TABLE SPOSitUsageSumTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_SITES_MIN VARCHAR(256) NOT NULL,
TOTAL_SITES_MAX VARCHAR(256) NOT NULL,
ACTIVE_SITES_MIN VARCHAR(256) NOT NULL,
ACTIVE_SITES_MAX VARCHAR(256) NOT NULL,
TOTAL_FILES_MIN VARCHAR(256) NOT NULL,
TOTAL_FILES_MAX VARCHAR(256) NOT NULL,
ACTIVE_FILES_MIN VARCHAR(256) NOT NULL,
ACTIVE_FILES_MAX VARCHAR(256) NOT NULL,
ACTIVE_FILES_PERCENT_MIN VARCHAR(256) NOT NULL,
ACTIVE_FILES_PERCENT_MAX VARCHAR(256) NOT NULL,
PAGE_VIEWS_MIN VARCHAR(256) NOT NULL,
PAGE_VIEWS_MAX VARCHAR(256) NOT NULL,
VISITED_PAGES_MIN VARCHAR(256) NOT NULL,
VISITED_PAGES_MAX VARCHAR(256) NOT NULL,
SITE_CONSUMING_MIN VARCHAR(256) NOT NULL,
SITE_CONSUMING_MAX VARCHAR(256) NOT NULL,
STORAGE_USED_MIN VARCHAR(256) NOT NULL,
STORAGE_USED_MAX VARCHAR(256) NOT NULL,
STORAGE_ALLOCATED_MIN VARCHAR(256) NOT NULL,
STORAGE_ALLOCATED_MAX VARCHAR(256) NOT NULL,
STORAGE_USED_PERCENT_MIN VARCHAR(256) NOT NULL,
STORAGE_USED_PERCENT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOSitUsageSumTest_THRESH ADD constraint PK_SPOSitUsgSumTst_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSitUsSumTst_THRESH ON SPOSitUsageSumTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSitUsgSumTst ON SPOSitUsageSumTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSitUsgSumTst ON SPOSitUsageSumTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMAudioStrmsTest;
CREATE TABLE MTMAudioStrmsTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AStrm DECIMAL(20,4) NOT NULL,
AStrm_ST varchar(32) NOT NULL,
APrStm DECIMAL(20,4) NOT NULL,
APrStm_ST varchar(32) NOT NULL,
AGdStm DECIMAL(20,4) NOT NULL,
AGdStm_ST varchar(32) NOT NULL,
AUcfStm DECIMAL(20,4) NOT NULL,
AUcfStm_ST varchar(32) NOT NULL,
APrPrct DECIMAL(20,4) NOT NULL,
APrPrct_ST varchar(32) NOT NULL,
APrDJtr DECIMAL(20,4) NOT NULL,
APrDJtr_ST varchar(32) NOT NULL,
APrDPktLs DECIMAL(20,4) NOT NULL,
APrDPktLs_ST varchar(32) NOT NULL,
APrDDgdtn DECIMAL(20,4) NOT NULL,
APrDDgdtn_ST varchar(32) NOT NULL,
APrDRndTp DECIMAL(20,4) NOT NULL,
APrDRndTp_ST varchar(32) NOT NULL,
APrDCnclRt DECIMAL(20,4) NOT NULL,
APrDCnclRt_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_MTMAudioStrmsTest ON MTMAudioStrmsTest(MSMT_TIME);
ALTER TABLE MTMAudioStrmsTest ADD constraint PK_MTMAudioStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMAudioStrmsTest_TREND;
CREATE TABLE MTMAudioStrmsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AStrm_MIN DECIMAL(20,4) NOT NULL,
AStrm_MAX DECIMAL(20,4) NOT NULL,
AStrm_STCNT varchar(32) NOT NULL,
APrStm_MIN DECIMAL(20,4) NOT NULL,
APrStm_MAX DECIMAL(20,4) NOT NULL,
APrStm_STCNT varchar(32) NOT NULL,
AGdStm_MIN DECIMAL(20,4) NOT NULL,
AGdStm_MAX DECIMAL(20,4) NOT NULL,
AGdStm_STCNT varchar(32) NOT NULL,
AUcfStm_MIN DECIMAL(20,4) NOT NULL,
AUcfStm_MAX DECIMAL(20,4) NOT NULL,
AUcfStm_STCNT varchar(32) NOT NULL,
APrPrct_MIN DECIMAL(20,4) NOT NULL,
APrPrct_MAX DECIMAL(20,4) NOT NULL,
APrPrct_STCNT varchar(32) NOT NULL,
APrDJtr_MIN DECIMAL(20,4) NOT NULL,
APrDJtr_MAX DECIMAL(20,4) NOT NULL,
APrDJtr_STCNT varchar(32) NOT NULL,
APrDPktLs_MIN DECIMAL(20,4) NOT NULL,
APrDPktLs_MAX DECIMAL(20,4) NOT NULL,
APrDPktLs_STCNT varchar(32) NOT NULL,
APrDDgdtn_MIN DECIMAL(20,4) NOT NULL,
APrDDgdtn_MAX DECIMAL(20,4) NOT NULL,
APrDDgdtn_STCNT varchar(32) NOT NULL,
APrDRndTp_MIN DECIMAL(20,4) NOT NULL,
APrDRndTp_MAX DECIMAL(20,4) NOT NULL,
APrDRndTp_STCNT varchar(32) NOT NULL,
APrDCnclRt_MIN DECIMAL(20,4) NOT NULL,
APrDCnclRt_MAX DECIMAL(20,4) NOT NULL,
APrDCnclRt_STCNT varchar(32) NOT NULL
);

ALTER TABLE MTMAudioStrmsTest_TREND ADD constraint PK_MTMAudioStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMAudioStrmsTest_THRESH;
CREATE TABLE MTMAudioStrmsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AStrm_MIN VARCHAR(256) NOT NULL,
AStrm_MAX VARCHAR(256) NOT NULL,
APrStm_MIN VARCHAR(256) NOT NULL,
APrStm_MAX VARCHAR(256) NOT NULL,
AGdStm_MIN VARCHAR(256) NOT NULL,
AGdStm_MAX VARCHAR(256) NOT NULL,
AUcfStm_MIN VARCHAR(256) NOT NULL,
AUcfStm_MAX VARCHAR(256) NOT NULL,
APrPrct_MIN VARCHAR(256) NOT NULL,
APrPrct_MAX VARCHAR(256) NOT NULL,
APrDJtr_MIN VARCHAR(256) NOT NULL,
APrDJtr_MAX VARCHAR(256) NOT NULL,
APrDPktLs_MIN VARCHAR(256) NOT NULL,
APrDPktLs_MAX VARCHAR(256) NOT NULL,
APrDDgdtn_MIN VARCHAR(256) NOT NULL,
APrDDgdtn_MAX VARCHAR(256) NOT NULL,
APrDRndTp_MIN VARCHAR(256) NOT NULL,
APrDRndTp_MAX VARCHAR(256) NOT NULL,
APrDCnclRt_MIN VARCHAR(256) NOT NULL,
APrDCnclRt_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE MTMAudioStrmsTest_THRESH ADD constraint PK_MTMAudioStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMAudioStrmsTest_THRESH ON MTMAudioStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMAudioStrmsTest ON MTMAudioStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMAudioStrmsTest ON MTMAudioStrmsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMNtwkQtySmyTest;
CREATE TABLE MTMNtwkQtySmyTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AvgAudDgtn DECIMAL(20,4) NOT NULL,
AvgAudDgtn_ST varchar(32) NOT NULL,
AvgJitter DECIMAL(20,4) NOT NULL,
AvgJitter_ST varchar(32) NOT NULL,
MxmJitter DECIMAL(20,4) NOT NULL,
MxmJitter_ST varchar(32) NOT NULL,
AvgPtLsRt DECIMAL(20,4) NOT NULL,
AvgPtLsRt_ST varchar(32) NOT NULL,
MxPtLsRte DECIMAL(20,4) NOT NULL,
MxPtLsRte_ST varchar(32) NOT NULL,
AvgSdLnMOS DECIMAL(20,4) NOT NULL,
AvgSdLnMOS_ST varchar(32) NOT NULL,
OrlAvgNtMOS DECIMAL(20,4) NOT NULL,
OrlAvgNtMOS_ST varchar(32) NOT NULL,
CnldSmplAvg DECIMAL(20,4) NOT NULL,
CnldSmplAvg_ST varchar(32) NOT NULL,
AvgRtStchSpl DECIMAL(20,4) NOT NULL,
AvgRtStchSpl_ST varchar(32) NOT NULL,
AvgRndTrip DECIMAL(20,4) NOT NULL,
AvgRndTrip_ST varchar(32) NOT NULL,
AvgRndTripMx DECIMAL(20,4) NOT NULL,
AvgRndTripMx_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest(MSMT_TIME);
ALTER TABLE MTMNtwkQtySmyTest ADD constraint PK_MTMNtwkQtySmyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMNtwkQtySmyTest_TREND;
CREATE TABLE MTMNtwkQtySmyTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AvgAudDgtn_MIN DECIMAL(20,4) NOT NULL,
AvgAudDgtn_MAX DECIMAL(20,4) NOT NULL,
AvgAudDgtn_STCNT varchar(32) NOT NULL,
AvgJitter_MIN DECIMAL(20,4) NOT NULL,
AvgJitter_MAX DECIMAL(20,4) NOT NULL,
AvgJitter_STCNT varchar(32) NOT NULL,
MxmJitter_MIN DECIMAL(20,4) NOT NULL,
MxmJitter_MAX DECIMAL(20,4) NOT NULL,
MxmJitter_STCNT varchar(32) NOT NULL,
AvgPtLsRt_MIN DECIMAL(20,4) NOT NULL,
AvgPtLsRt_MAX DECIMAL(20,4) NOT NULL,
AvgPtLsRt_STCNT varchar(32) NOT NULL,
MxPtLsRte_MIN DECIMAL(20,4) NOT NULL,
MxPtLsRte_MAX DECIMAL(20,4) NOT NULL,
MxPtLsRte_STCNT varchar(32) NOT NULL,
AvgSdLnMOS_MIN DECIMAL(20,4) NOT NULL,
AvgSdLnMOS_MAX DECIMAL(20,4) NOT NULL,
AvgSdLnMOS_STCNT varchar(32) NOT NULL,
OrlAvgNtMOS_MIN DECIMAL(20,4) NOT NULL,
OrlAvgNtMOS_MAX DECIMAL(20,4) NOT NULL,
OrlAvgNtMOS_STCNT varchar(32) NOT NULL,
CnldSmplAvg_MIN DECIMAL(20,4) NOT NULL,
CnldSmplAvg_MAX DECIMAL(20,4) NOT NULL,
CnldSmplAvg_STCNT varchar(32) NOT NULL,
AvgRtStchSpl_MIN DECIMAL(20,4) NOT NULL,
AvgRtStchSpl_MAX DECIMAL(20,4) NOT NULL,
AvgRtStchSpl_STCNT varchar(32) NOT NULL,
AvgRndTrip_MIN DECIMAL(20,4) NOT NULL,
AvgRndTrip_MAX DECIMAL(20,4) NOT NULL,
AvgRndTrip_STCNT varchar(32) NOT NULL,
AvgRndTripMx_MIN DECIMAL(20,4) NOT NULL,
AvgRndTripMx_MAX DECIMAL(20,4) NOT NULL,
AvgRndTripMx_STCNT varchar(32) NOT NULL
);

ALTER TABLE MTMNtwkQtySmyTest_TREND ADD constraint PK_MTMNtwkQtySmyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMNtwkQtySmyTest_THRESH;
CREATE TABLE MTMNtwkQtySmyTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AvgAudDgtn_MIN VARCHAR(256) NOT NULL,
AvgAudDgtn_MAX VARCHAR(256) NOT NULL,
AvgJitter_MIN VARCHAR(256) NOT NULL,
AvgJitter_MAX VARCHAR(256) NOT NULL,
MxmJitter_MIN VARCHAR(256) NOT NULL,
MxmJitter_MAX VARCHAR(256) NOT NULL,
AvgPtLsRt_MIN VARCHAR(256) NOT NULL,
AvgPtLsRt_MAX VARCHAR(256) NOT NULL,
MxPtLsRte_MIN VARCHAR(256) NOT NULL,
MxPtLsRte_MAX VARCHAR(256) NOT NULL,
AvgSdLnMOS_MIN VARCHAR(256) NOT NULL,
AvgSdLnMOS_MAX VARCHAR(256) NOT NULL,
OrlAvgNtMOS_MIN VARCHAR(256) NOT NULL,
OrlAvgNtMOS_MAX VARCHAR(256) NOT NULL,
CnldSmplAvg_MIN VARCHAR(256) NOT NULL,
CnldSmplAvg_MAX VARCHAR(256) NOT NULL,
AvgRtStchSpl_MIN VARCHAR(256) NOT NULL,
AvgRtStchSpl_MAX VARCHAR(256) NOT NULL,
AvgRndTrip_MIN VARCHAR(256) NOT NULL,
AvgRndTrip_MAX VARCHAR(256) NOT NULL,
AvgRndTripMx_MIN VARCHAR(256) NOT NULL,
AvgRndTripMx_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE MTMNtwkQtySmyTest_THRESH ADD constraint PK_MTMNtwkQtySmyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMNtwkQtySmyTest_THRESH ON MTMNtwkQtySmyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMVideoStreamsTest;
CREATE TABLE MTMVideoStreamsTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Strmcnt DECIMAL(20,4) NOT NULL,
Strmcnt_ST varchar(32) NOT NULL,
ViPstFclr DECIMAL(20,4) NOT NULL,
ViPstFclr_ST varchar(32) NOT NULL,
ViLFrPrAg DECIMAL(20,4) NOT NULL,
ViLFrPrAg_ST varchar(32) NOT NULL,
ViFrRteAg DECIMAL(20,4) NOT NULL,
ViFrRteAg_ST varchar(32) NOT NULL,
PrStrmcnt DECIMAL(20,4) NOT NULL,
PrStrmcnt_ST varchar(32) NOT NULL,
GdStrmCnt DECIMAL(20,4) NOT NULL,
GdStrmCnt_ST varchar(32) NOT NULL,
UncfdSmCnt DECIMAL(20,4) NOT NULL,
UncfdSmCnt_ST varchar(32) NOT NULL,
PrPercent DECIMAL(20,4) NOT NULL,
PrPercent_ST varchar(32) NOT NULL,
AvPsFECPLR DECIMAL(20,4) NOT NULL,
AvPsFECPLR_ST varchar(32) NOT NULL,
AvLclFmLs DECIMAL(20,4) NOT NULL,
AvLclFmLs_ST varchar(32) NOT NULL,
AvRcvFmRtAg DECIMAL(20,4) NOT NULL,
AvRcvFmRtAg_ST varchar(32) NOT NULL,
AvLwFmRtCPt DECIMAL(20,4) NOT NULL,
AvLwFmRtCPt_ST varchar(32) NOT NULL,
AvPktLsRt DECIMAL(20,4) NOT NULL,
AvPktLsRt_ST varchar(32) NOT NULL,
AvDycCpyPnt DECIMAL(20,4) NOT NULL,
AvDycCpyPnt_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMVideoStreamsTest ON MTMVideoStreamsTest(MSMT_TIME);
ALTER TABLE MTMVideoStreamsTest ADD constraint PK_MTMVideoStreamsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMVideoStreamsTest_TREND;
CREATE TABLE MTMVideoStreamsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Strmcnt_MIN DECIMAL(20,4) NOT NULL,
Strmcnt_MAX DECIMAL(20,4) NOT NULL,
Strmcnt_STCNT varchar(32) NOT NULL,
ViPstFclr_MIN DECIMAL(20,4) NOT NULL,
ViPstFclr_MAX DECIMAL(20,4) NOT NULL,
ViPstFclr_STCNT varchar(32) NOT NULL,
ViLFrPrAg_MIN DECIMAL(20,4) NOT NULL,
ViLFrPrAg_MAX DECIMAL(20,4) NOT NULL,
ViLFrPrAg_STCNT varchar(32) NOT NULL,
ViFrRteAg_MIN DECIMAL(20,4) NOT NULL,
ViFrRteAg_MAX DECIMAL(20,4) NOT NULL,
ViFrRteAg_STCNT varchar(32) NOT NULL,
PrStrmcnt_MIN DECIMAL(20,4) NOT NULL,
PrStrmcnt_MAX DECIMAL(20,4) NOT NULL,
PrStrmcnt_STCNT varchar(32) NOT NULL,
GdStrmCnt_MIN DECIMAL(20,4) NOT NULL,
GdStrmCnt_MAX DECIMAL(20,4) NOT NULL,
GdStrmCnt_STCNT varchar(32) NOT NULL,
UncfdSmCnt_MIN DECIMAL(20,4) NOT NULL,
UncfdSmCnt_MAX DECIMAL(20,4) NOT NULL,
UncfdSmCnt_STCNT varchar(32) NOT NULL,
PrPercent_MIN DECIMAL(20,4) NOT NULL,
PrPercent_MAX DECIMAL(20,4) NOT NULL,
PrPercent_STCNT varchar(32) NOT NULL,
AvPsFECPLR_MIN DECIMAL(20,4) NOT NULL,
AvPsFECPLR_MAX DECIMAL(20,4) NOT NULL,
AvPsFECPLR_STCNT varchar(32) NOT NULL,
AvLclFmLs_MIN DECIMAL(20,4) NOT NULL,
AvLclFmLs_MAX DECIMAL(20,4) NOT NULL,
AvLclFmLs_STCNT varchar(32) NOT NULL,
AvRcvFmRtAg_MIN DECIMAL(20,4) NOT NULL,
AvRcvFmRtAg_MAX DECIMAL(20,4) NOT NULL,
AvRcvFmRtAg_STCNT varchar(32) NOT NULL,
AvLwFmRtCPt_MIN DECIMAL(20,4) NOT NULL,
AvLwFmRtCPt_MAX DECIMAL(20,4) NOT NULL,
AvLwFmRtCPt_STCNT varchar(32) NOT NULL,
AvPktLsRt_MIN DECIMAL(20,4) NOT NULL,
AvPktLsRt_MAX DECIMAL(20,4) NOT NULL,
AvPktLsRt_STCNT varchar(32) NOT NULL,
AvDycCpyPnt_MIN DECIMAL(20,4) NOT NULL,
AvDycCpyPnt_MAX DECIMAL(20,4) NOT NULL,
AvDycCpyPnt_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMVideoStreamsTest_TREND ADD constraint PK_MTMVideoStreamsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMVideoStreamsTest_THRESH;
CREATE TABLE MTMVideoStreamsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Strmcnt_MIN VARCHAR(256) NOT NULL,
Strmcnt_MAX VARCHAR(256) NOT NULL,
ViPstFclr_MIN VARCHAR(256) NOT NULL,
ViPstFclr_MAX VARCHAR(256) NOT NULL,
ViLFrPrAg_MIN VARCHAR(256) NOT NULL,
ViLFrPrAg_MAX VARCHAR(256) NOT NULL,
ViFrRteAg_MIN VARCHAR(256) NOT NULL,
ViFrRteAg_MAX VARCHAR(256) NOT NULL,
PrStrmcnt_MIN VARCHAR(256) NOT NULL,
PrStrmcnt_MAX VARCHAR(256) NOT NULL,
GdStrmCnt_MIN VARCHAR(256) NOT NULL,
GdStrmCnt_MAX VARCHAR(256) NOT NULL,
UncfdSmCnt_MIN VARCHAR(256) NOT NULL,
UncfdSmCnt_MAX VARCHAR(256) NOT NULL,
PrPercent_MIN VARCHAR(256) NOT NULL,
PrPercent_MAX VARCHAR(256) NOT NULL,
AvPsFECPLR_MIN VARCHAR(256) NOT NULL,
AvPsFECPLR_MAX VARCHAR(256) NOT NULL,
AvLclFmLs_MIN VARCHAR(256) NOT NULL,
AvLclFmLs_MAX VARCHAR(256) NOT NULL,
AvRcvFmRtAg_MIN VARCHAR(256) NOT NULL,
AvRcvFmRtAg_MAX VARCHAR(256) NOT NULL,
AvLwFmRtCPt_MIN VARCHAR(256) NOT NULL,
AvLwFmRtCPt_MAX VARCHAR(256) NOT NULL,
AvPktLsRt_MIN VARCHAR(256) NOT NULL,
AvPktLsRt_MAX VARCHAR(256) NOT NULL,
AvDycCpyPnt_MIN VARCHAR(256) NOT NULL,
AvDycCpyPnt_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMVideoStreamsTest_THRESH ADD constraint PK_MTMVideoStreamsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMVideoStreamsTest_THRESH ON MTMVideoStreamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMVideoStreamsTest ON MTMVideoStreamsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMVideoStreamsTest ON MTMVideoStreamsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMAppShrngStrmsTest;
CREATE TABLE MTMAppShrngStrmsTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
StreamCount DECIMAL(20,4) NOT NULL,
StreamCount_ST varchar(32) NOT NULL,
PDSpldTlePrTlCt DECIMAL(20,4) NOT NULL,
PDSpldTlePrTlCt_ST varchar(32) NOT NULL,
PDRlOnWyAvgCnt  DECIMAL(20,4) NOT NULL,
PDRlOnWyAvgCnt_ST varchar(32) NOT NULL,
PDRDPTlPngLyAgCt  DECIMAL(20,4) NOT NULL,
PDRDPTlPngLyAgCt_ST varchar(32) NOT NULL,
PoorStreamCount DECIMAL(20,4) NOT NULL,
PoorStreamCount_ST varchar(32) NOT NULL,
GoodStreamCount DECIMAL(20,4) NOT NULL,
GoodStreamCount_ST varchar(32) NOT NULL,
UnclasfedStmCnt DECIMAL(20,4) NOT NULL,
UnclasfedStmCnt_ST varchar(32) NOT NULL,
PoorPercentage DECIMAL(20,4) NOT NULL,
PoorPercentage_ST varchar(32) NOT NULL,
SpldTlPrcntTtl DECIMAL(20,4) NOT NULL,
SpldTlPrcntTtl_ST varchar(32) NOT NULL,
RDPTlPcngLtncy DECIMAL(20,4) NOT NULL,
RDPTlPcngLtncy_ST varchar(32) NOT NULL,
AvReltveOneWy DECIMAL(20,4) NOT NULL,
AvReltveOneWy_ST varchar(32) NOT NULL,
AvRltvOneWyMx DECIMAL(20,4) NOT NULL,
AvRltvOneWyMx_ST varchar(32) NOT NULL);
CREATE INDEX IDX_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest(MSMT_TIME);
ALTER TABLE MTMAppShrngStrmsTest ADD constraint PK_MTMAppShrngStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMAppShrngStrmsTest_TREND;
CREATE TABLE MTMAppShrngStrmsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
StreamCount_MIN DECIMAL(20,4) NOT NULL,
StreamCount_MAX DECIMAL(20,4) NOT NULL,
StreamCount_STCNT varchar(32) NOT NULL,
PDSpldTlePrTlCt_MIN DECIMAL(20,4) NOT NULL,
PDSpldTlePrTlCt_MAX DECIMAL(20,4) NOT NULL,
PDSpldTlePrTlCt_STCNT varchar(32) NOT NULL,
PDRlOnWyAvgCnt_MIN DECIMAL(20,4) NOT NULL,
PDRlOnWyAvgCnt_MAX DECIMAL(20,4) NOT NULL,
PDRlOnWyAvgCnt_STCNT varchar(32) NOT NULL,
PDRDPTlPngLyAgCt_MIN DECIMAL(20,4) NOT NULL,
PDRDPTlPngLyAgCt_MAX DECIMAL(20,4) NOT NULL,
PDRDPTlPngLyAgCt_STCNT varchar(32) NOT NULL,
PoorStreamCount_MIN DECIMAL(20,4) NOT NULL,
PoorStreamCount_MAX DECIMAL(20,4) NOT NULL,
PoorStreamCount_STCNT varchar(32) NOT NULL,
GoodStreamCount_MIN DECIMAL(20,4) NOT NULL,
GoodStreamCount_MAX DECIMAL(20,4) NOT NULL,
GoodStreamCount_STCNT varchar(32) NOT NULL,
UnclasfedStmCnt_MIN DECIMAL(20,4) NOT NULL,
UnclasfedStmCnt_MAX DECIMAL(20,4) NOT NULL,
UnclasfedStmCnt_STCNT varchar(32) NOT NULL,
PoorPercentage_MIN DECIMAL(20,4) NOT NULL,
PoorPercentage_MAX DECIMAL(20,4) NOT NULL,
PoorPercentage_STCNT varchar(32) NOT NULL,
SpldTlPrcntTtl_MIN DECIMAL(20,4) NOT NULL,
SpldTlPrcntTtl_MAX DECIMAL(20,4) NOT NULL,
SpldTlPrcntTtl_STCNT varchar(32) NOT NULL,
RDPTlPcngLtncy_MIN DECIMAL(20,4) NOT NULL,
RDPTlPcngLtncy_MAX DECIMAL(20,4) NOT NULL,
RDPTlPcngLtncy_STCNT varchar(32) NOT NULL,
AvReltveOneWy_MIN DECIMAL(20,4) NOT NULL,
AvReltveOneWy_MAX DECIMAL(20,4) NOT NULL,
AvReltveOneWy_STCNT varchar(32) NOT NULL,
AvRltvOneWyMx_MIN DECIMAL(20,4) NOT NULL,
AvRltvOneWyMx_MAX DECIMAL(20,4) NOT NULL,
AvRltvOneWyMx_STCNT varchar(32) NOT NULL);
ALTER TABLE MTMAppShrngStrmsTest_TREND ADD constraint PK_MTMAppShrngStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMAppShrngStrmsTest_THRESH;
CREATE TABLE MTMAppShrngStrmsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
StreamCount_MIN VARCHAR(256) NOT NULL,
StreamCount_MAX VARCHAR(256) NOT NULL,
PDSpldTlePrTlCt_MIN VARCHAR(256) NOT NULL,
PDSpldTlePrTlCt_MAX VARCHAR(256) NOT NULL,
PDRlOnWyAvgCnt_MIN VARCHAR(256) NOT NULL,
PDRlOnWyAvgCnt_MAX VARCHAR(256) NOT NULL,
PDRDPTlPngLyAgCt_MIN VARCHAR(256) NOT NULL,
PDRDPTlPngLyAgCt_MAX VARCHAR(256) NOT NULL,
PoorStreamCount_MIN VARCHAR(256) NOT NULL,
PoorStreamCount_MAX VARCHAR(256) NOT NULL,
GoodStreamCount_MIN VARCHAR(256) NOT NULL,
GoodStreamCount_MAX VARCHAR(256) NOT NULL,
UnclasfedStmCnt_MIN VARCHAR(256) NOT NULL,
UnclasfedStmCnt_MAX VARCHAR(256) NOT NULL,
PoorPercentage_MIN VARCHAR(256) NOT NULL,
PoorPercentage_MAX VARCHAR(256) NOT NULL,
SpldTlPrcntTtl_MIN VARCHAR(256) NOT NULL,
SpldTlPrcntTtl_MAX VARCHAR(256) NOT NULL,
RDPTlPcngLtncy_MIN VARCHAR(256) NOT NULL,
RDPTlPcngLtncy_MAX VARCHAR(256) NOT NULL,
AvReltveOneWy_MIN VARCHAR(256) NOT NULL,
AvReltveOneWy_MAX VARCHAR(256) NOT NULL,
AvRltvOneWyMx_MIN VARCHAR(256) NOT NULL,
AvRltvOneWyMx_MAX VARCHAR(256) NOT NULL);
ALTER TABLE MTMAppShrngStrmsTest_THRESH ADD constraint PK_MTMAppShngStrmTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMAppShngStrmTest_THRESH ON MTMAppShrngStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMFeedBckSmryTest;
CREATE TABLE MTMFeedBckSmryTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
FFbckRgAv DECIMAL(20,4) NOT NULL,
FFbckRgAv_ST varchar(32) NOT NULL,
SFbckRgAv DECIMAL(20,4) NOT NULL,
SFbckRgAv_ST varchar(32) NOT NULL,
FFbckRg DECIMAL(20,4) NOT NULL,
FFbckRg_ST varchar(32) NOT NULL,
SFbckRg DECIMAL(20,4) NOT NULL,
SFbckRg_ST varchar(32) NOT NULL,
FFbkRgPrCt DECIMAL(20,4) NOT NULL,
FFbkRgPrCt_ST varchar(32) NOT NULL,
SFbkRgPrCt DECIMAL(20,4) NOT NULL,
SFbkRgPrCt_ST varchar(32) NOT NULL,
FFbkRgPrPt DECIMAL(20,4) NOT NULL,
FFbkRgPrPt_ST varchar(32) NOT NULL,
SFbkRgPrPt DECIMAL(20,4) NOT NULL,
SFbkRgPrPt_ST varchar(32) NOT NULL,
FFbkTnAdCt DECIMAL(20,4) NOT NULL,
FFbkTnAdCt_ST varchar(32) NOT NULL,
SFbkTnAdCt DECIMAL(20,4) NOT NULL,
SFbkTnAdCt_ST varchar(32) NOT NULL,
FFbkTnVdCt DECIMAL(20,4) NOT NULL,
FFbkTnVdCt_ST varchar(32) NOT NULL,
SFbkTnVdCt DECIMAL(20,4) NOT NULL,
SFbkTnVdCt_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_MTMFeedBckSmryTest ON MTMFeedBckSmryTest(MSMT_TIME);
ALTER TABLE MTMFeedBckSmryTest ADD constraint PK_MTMFeedBckSmryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMFeedBckSmryTest_TREND;
CREATE TABLE MTMFeedBckSmryTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
FFbckRgAv_MIN DECIMAL(20,4) NOT NULL,
FFbckRgAv_MAX DECIMAL(20,4) NOT NULL,
FFbckRgAv_STCNT varchar(32) NOT NULL,
SFbckRgAv_MIN DECIMAL(20,4) NOT NULL,
SFbckRgAv_MAX DECIMAL(20,4) NOT NULL,
SFbckRgAv_STCNT varchar(32) NOT NULL,
FFbckRg_MIN DECIMAL(20,4) NOT NULL,
FFbckRg_MAX DECIMAL(20,4) NOT NULL,
FFbckRg_STCNT varchar(32) NOT NULL,
SFbckRg_MIN DECIMAL(20,4) NOT NULL,
SFbckRg_MAX DECIMAL(20,4) NOT NULL,
SFbckRg_STCNT varchar(32) NOT NULL,
FFbkRgPrCt_MIN DECIMAL(20,4) NOT NULL,
FFbkRgPrCt_MAX DECIMAL(20,4) NOT NULL,
FFbkRgPrCt_STCNT varchar(32) NOT NULL,
SFbkRgPrCt_MIN DECIMAL(20,4) NOT NULL,
SFbkRgPrCt_MAX DECIMAL(20,4) NOT NULL,
SFbkRgPrCt_STCNT varchar(32) NOT NULL,
FFbkRgPrPt_MIN DECIMAL(20,4) NOT NULL,
FFbkRgPrPt_MAX DECIMAL(20,4) NOT NULL,
FFbkRgPrPt_STCNT varchar(32) NOT NULL,
SFbkRgPrPt_MIN DECIMAL(20,4) NOT NULL,
SFbkRgPrPt_MAX DECIMAL(20,4) NOT NULL,
SFbkRgPrPt_STCNT varchar(32) NOT NULL,
FFbkTnAdCt_MIN DECIMAL(20,4) NOT NULL,
FFbkTnAdCt_MAX DECIMAL(20,4) NOT NULL,
FFbkTnAdCt_STCNT varchar(32) NOT NULL,
SFbkTnAdCt_MIN DECIMAL(20,4) NOT NULL,
SFbkTnAdCt_MAX DECIMAL(20,4) NOT NULL,
SFbkTnAdCt_STCNT varchar(32) NOT NULL,
FFbkTnVdCt_MIN DECIMAL(20,4) NOT NULL,
FFbkTnVdCt_MAX DECIMAL(20,4) NOT NULL,
FFbkTnVdCt_STCNT varchar(32) NOT NULL,
SFbkTnVdCt_MIN DECIMAL(20,4) NOT NULL,
SFbkTnVdCt_MAX DECIMAL(20,4) NOT NULL,
SFbkTnVdCt_STCNT varchar(32) NOT NULL
);

ALTER TABLE MTMFeedBckSmryTest_TREND ADD constraint PK_MTMFeedBckSmryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMFeedBckSmryTest_THRESH;
CREATE TABLE MTMFeedBckSmryTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
FFbckRgAv_MIN VARCHAR(256) NOT NULL,
FFbckRgAv_MAX VARCHAR(256) NOT NULL,
SFbckRgAv_MIN VARCHAR(256) NOT NULL,
SFbckRgAv_MAX VARCHAR(256) NOT NULL,
FFbckRg_MIN VARCHAR(256) NOT NULL,
FFbckRg_MAX VARCHAR(256) NOT NULL,
SFbckRg_MIN VARCHAR(256) NOT NULL,
SFbckRg_MAX VARCHAR(256) NOT NULL,
FFbkRgPrCt_MIN VARCHAR(256) NOT NULL,
FFbkRgPrCt_MAX VARCHAR(256) NOT NULL,
SFbkRgPrCt_MIN VARCHAR(256) NOT NULL,
SFbkRgPrCt_MAX VARCHAR(256) NOT NULL,
FFbkRgPrPt_MIN VARCHAR(256) NOT NULL,
FFbkRgPrPt_MAX VARCHAR(256) NOT NULL,
SFbkRgPrPt_MIN VARCHAR(256) NOT NULL,
SFbkRgPrPt_MAX VARCHAR(256) NOT NULL,
FFbkTnAdCt_MIN VARCHAR(256) NOT NULL,
FFbkTnAdCt_MAX VARCHAR(256) NOT NULL,
SFbkTnAdCt_MIN VARCHAR(256) NOT NULL,
SFbkTnAdCt_MAX VARCHAR(256) NOT NULL,
FFbkTnVdCt_MIN VARCHAR(256) NOT NULL,
FFbkTnVdCt_MAX VARCHAR(256) NOT NULL,
SFbkTnVdCt_MIN VARCHAR(256) NOT NULL,
SFbkTnVdCt_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE MTMFeedBckSmryTest_THRESH ADD constraint PK_MTMFeedBckSmryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMFeedBckSmryTest_THRESH ON MTMFeedBckSmryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMFeedBckSmryTest ON MTMFeedBckSmryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMFeedBckSmryTest ON MTMFeedBckSmryTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMVBSSStrmsTest;
CREATE TABLE MTMVBSSStrmsTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
VBSStms DECIMAL(20,4) NOT NULL,
VBSStms_ST varchar(32) NOT NULL,
VBSStmPrVpF DECIMAL(20,4) NOT NULL,
VBSStmPrVpF_ST varchar(32) NOT NULL,
VBSPrVLsAv DECIMAL(20,4) NOT NULL,
VBSPrVLsAv_ST varchar(32) NOT NULL,
VBSPrVFmeAv DECIMAL(20,4) NOT NULL,
VBSPrVFmeAv_ST varchar(32) NOT NULL,
VBSPrStm DECIMAL(20,4) NOT NULL,
VBSPrStm_ST varchar(32) NOT NULL,
VBSGdStm DECIMAL(20,4) NOT NULL,
VBSGdStm_ST varchar(32) NOT NULL,
VBSUclfdStm DECIMAL(20,4) NOT NULL,
VBSUclfdStm_ST varchar(32) NOT NULL,
VBSPrPrcnt DECIMAL(20,4) NOT NULL,
VBSPrPrcnt_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_MTMVBSSStrmsTest ON MTMVBSSStrmsTest(MSMT_TIME);
ALTER TABLE MTMVBSSStrmsTest ADD constraint PK_MTMVBSSStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMVBSSStrmsTest_TREND;
CREATE TABLE MTMVBSSStrmsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
VBSStms_MIN DECIMAL(20,4) NOT NULL,
VBSStms_MAX DECIMAL(20,4) NOT NULL,
VBSStms_STCNT varchar(32) NOT NULL,
VBSStmPrVpF_MIN DECIMAL(20,4) NOT NULL,
VBSStmPrVpF_MAX DECIMAL(20,4) NOT NULL,
VBSStmPrVpF_STCNT varchar(32) NOT NULL,
VBSPrVLsAv_MIN DECIMAL(20,4) NOT NULL,
VBSPrVLsAv_MAX DECIMAL(20,4) NOT NULL,
VBSPrVLsAv_STCNT varchar(32) NOT NULL,
VBSPrVFmeAv_MIN DECIMAL(20,4) NOT NULL,
VBSPrVFmeAv_MAX DECIMAL(20,4) NOT NULL,
VBSPrVFmeAv_STCNT varchar(32) NOT NULL,
VBSPrStm_MIN DECIMAL(20,4) NOT NULL,
VBSPrStm_MAX DECIMAL(20,4) NOT NULL,
VBSPrStm_STCNT varchar(32) NOT NULL,
VBSGdStm_MIN DECIMAL(20,4) NOT NULL,
VBSGdStm_MAX DECIMAL(20,4) NOT NULL,
VBSGdStm_STCNT varchar(32) NOT NULL,
VBSUclfdStm_MIN DECIMAL(20,4) NOT NULL,
VBSUclfdStm_MAX DECIMAL(20,4) NOT NULL,
VBSUclfdStm_STCNT varchar(32) NOT NULL,
VBSPrPrcnt_MIN DECIMAL(20,4) NOT NULL,
VBSPrPrcnt_MAX DECIMAL(20,4) NOT NULL,
VBSPrPrcnt_STCNT varchar(32) NOT NULL
);

ALTER TABLE MTMVBSSStrmsTest_TREND ADD constraint PK_MTMVBSSStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMVBSSStrmsTest_THRESH;
CREATE TABLE MTMVBSSStrmsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
VBSStms_MIN VARCHAR(256) NOT NULL,
VBSStms_MAX VARCHAR(256) NOT NULL,
VBSStmPrVpF_MIN VARCHAR(256) NOT NULL,
VBSStmPrVpF_MAX VARCHAR(256) NOT NULL,
VBSPrVLsAv_MIN VARCHAR(256) NOT NULL,
VBSPrVLsAv_MAX VARCHAR(256) NOT NULL,
VBSPrVFmeAv_MIN VARCHAR(256) NOT NULL,
VBSPrVFmeAv_MAX VARCHAR(256) NOT NULL,
VBSPrStm_MIN VARCHAR(256) NOT NULL,
VBSPrStm_MAX VARCHAR(256) NOT NULL,
VBSGdStm_MIN VARCHAR(256) NOT NULL,
VBSGdStm_MAX VARCHAR(256) NOT NULL,
VBSUclfdStm_MIN VARCHAR(256) NOT NULL,
VBSUclfdStm_MAX VARCHAR(256) NOT NULL,
VBSPrPrcnt_MIN VARCHAR(256) NOT NULL,
VBSPrPrcnt_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE MTMVBSSStrmsTest_THRESH ADD constraint PK_MTMVBSSStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMVBSSStrmsTest_THRESH ON MTMVBSSStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMVBSSStrmsTest ON MTMVBSSStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMVBSSStrmsTest ON MTMVBSSStrmsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMCalSumryTest;
CREATE TABLE MTMCalSumryTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TotStrmCt DECIMAL(20,4) NOT NULL,
TotStrmCt_ST varchar(32) NOT NULL,
CDRAvlblstrmCt DECIMAL(20,4) NOT NULL,
CDRAvlblstrmCt_ST varchar(32) NOT NULL,
MedFldStrmCt DECIMAL(20,4) NOT NULL,
MedFldStrmCt_ST varchar(32) NOT NULL,
ClSupFldStrmCt DECIMAL(20,4) NOT NULL,
ClSupFldStrmCt_ST varchar(32) NOT NULL,
ClDrpdStrmCt DECIMAL(20,4) NOT NULL,
ClDrpdStrmCt_ST varchar(32) NOT NULL,
MedSudedStrmCt DECIMAL(20,4) NOT NULL,
MedSudedStrmCt_ST varchar(32) NOT NULL,
ClSupSudStrmCt DECIMAL(20,4) NOT NULL,
ClSupSudStrmCt_ST varchar(32) NOT NULL,
ClSupFlrPer DECIMAL(20,4) NOT NULL,
ClSupFlrPer_ST varchar(32) NOT NULL,
ClDrpdFlrPer DECIMAL(20,4) NOT NULL,
ClDrpdFlrPer_ST varchar(32) NOT NULL,
AnsSeiRatio DECIMAL(20,4) NOT NULL,
AnsSeiRatio_ST varchar(32) NOT NULL,
ShrtCalPer DECIMAL(20,4) NOT NULL,
ShrtCalPer_ST varchar(32) NOT NULL,
MedFlrPer DECIMAL(20,4) NOT NULL,
MedFlrPer_ST varchar(32) NOT NULL,
AvgCalDurtn DECIMAL(20,4) NOT NULL,
AvgCalDurtn_ST varchar(32) NOT NULL,
MedFldFWStrmCt DECIMAL(20,4) NOT NULL,
MedFldFWStrmCt_ST varchar(32) NOT NULL,
FWMedFlrPer DECIMAL(20,4) NOT NULL,
FWMedFlrPer_ST varchar(32) NOT NULL,
FWIPBldStrmCt DECIMAL(20,4) NOT NULL,
FWIPBldStrmCt_ST varchar(32) NOT NULL,
FWIPBldMFlrPer DECIMAL(20,4) NOT NULL,
FWIPBldMFlrPer_ST varchar(32) NOT NULL,
MFldOtrStrmCnt DECIMAL(20,4) NOT NULL,
MFldOtrStrmCnt_ST varchar(32) NOT NULL,
OtrMedFlrPer DECIMAL(20,4) NOT NULL,
OtrMedFlrPer_ST varchar(32) NOT NULL
);
CREATE INDEX IDX_MTMCalSumryTest ON MTMCalSumryTest(MSMT_TIME);
ALTER TABLE MTMCalSumryTest ADD constraint PK_MTMCalSumryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MTMCalSumryTest_TREND;
CREATE TABLE MTMCalSumryTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TotStrmCt_MIN DECIMAL(20,4) NOT NULL,
TotStrmCt_MAX DECIMAL(20,4) NOT NULL,
TotStrmCt_STCNT varchar(32) NOT NULL,
CDRAvlblstrmCt_MIN DECIMAL(20,4) NOT NULL,
CDRAvlblstrmCt_MAX DECIMAL(20,4) NOT NULL,
CDRAvlblstrmCt_STCNT varchar(32) NOT NULL,
MedFldStrmCt_MIN DECIMAL(20,4) NOT NULL,
MedFldStrmCt_MAX DECIMAL(20,4) NOT NULL,
MedFldStrmCt_STCNT varchar(32) NOT NULL,
ClSupFldStrmCt_MIN DECIMAL(20,4) NOT NULL,
ClSupFldStrmCt_MAX DECIMAL(20,4) NOT NULL,
ClSupFldStrmCt_STCNT varchar(32) NOT NULL,
ClDrpdStrmCt_MIN DECIMAL(20,4) NOT NULL,
ClDrpdStrmCt_MAX DECIMAL(20,4) NOT NULL,
ClDrpdStrmCt_STCNT varchar(32) NOT NULL,
MedSudedStrmCt_MIN DECIMAL(20,4) NOT NULL,
MedSudedStrmCt_MAX DECIMAL(20,4) NOT NULL,
MedSudedStrmCt_STCNT varchar(32) NOT NULL,
ClSupSudStrmCt_MIN DECIMAL(20,4) NOT NULL,
ClSupSudStrmCt_MAX DECIMAL(20,4) NOT NULL,
ClSupSudStrmCt_STCNT varchar(32) NOT NULL,
ClSupFlrPer_MIN DECIMAL(20,4) NOT NULL,
ClSupFlrPer_MAX DECIMAL(20,4) NOT NULL,
ClSupFlrPer_STCNT varchar(32) NOT NULL,
ClDrpdFlrPer_MIN DECIMAL(20,4) NOT NULL,
ClDrpdFlrPer_MAX DECIMAL(20,4) NOT NULL,
ClDrpdFlrPer_STCNT varchar(32) NOT NULL,
AnsSeiRatio_MIN DECIMAL(20,4) NOT NULL,
AnsSeiRatio_MAX DECIMAL(20,4) NOT NULL,
AnsSeiRatio_STCNT varchar(32) NOT NULL,
ShrtCalPer_MIN DECIMAL(20,4) NOT NULL,
ShrtCalPer_MAX DECIMAL(20,4) NOT NULL,
ShrtCalPer_STCNT varchar(32) NOT NULL,
MedFlrPer_MIN DECIMAL(20,4) NOT NULL,
MedFlrPer_MAX DECIMAL(20,4) NOT NULL,
MedFlrPer_STCNT varchar(32) NOT NULL,
AvgCalDurtn_MIN DECIMAL(20,4) NOT NULL,
AvgCalDurtn_MAX DECIMAL(20,4) NOT NULL,
AvgCalDurtn_STCNT varchar(32) NOT NULL,
MedFldFWStrmCt_MIN DECIMAL(20,4) NOT NULL,
MedFldFWStrmCt_MAX DECIMAL(20,4) NOT NULL,
MedFldFWStrmCt_STCNT varchar(32) NOT NULL,
FWMedFlrPer_MIN DECIMAL(20,4) NOT NULL,
FWMedFlrPer_MAX DECIMAL(20,4) NOT NULL,
FWMedFlrPer_STCNT varchar(32) NOT NULL,
FWIPBldStrmCt_MIN DECIMAL(20,4) NOT NULL,
FWIPBldStrmCt_MAX DECIMAL(20,4) NOT NULL,
FWIPBldStrmCt_STCNT varchar(32) NOT NULL,
FWIPBldMFlrPer_MIN DECIMAL(20,4) NOT NULL,
FWIPBldMFlrPer_MAX DECIMAL(20,4) NOT NULL,
FWIPBldMFlrPer_STCNT varchar(32) NOT NULL,
MFldOtrStrmCnt_MIN DECIMAL(20,4) NOT NULL,
MFldOtrStrmCnt_MAX DECIMAL(20,4) NOT NULL,
MFldOtrStrmCnt_STCNT varchar(32) NOT NULL,
OtrMedFlrPer_MIN DECIMAL(20,4) NOT NULL,
OtrMedFlrPer_MAX DECIMAL(20,4) NOT NULL,
OtrMedFlrPer_STCNT varchar(32) NOT NULL
);
ALTER TABLE MTMCalSumryTest_TREND ADD constraint PK_MTMCalSumryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MTMCalSumryTest_THRESH;
CREATE TABLE MTMCalSumryTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TotStrmCt_MIN VARCHAR(256) NOT NULL,
TotStrmCt_MAX VARCHAR(256) NOT NULL,
CDRAvlblstrmCt_MIN VARCHAR(256) NOT NULL,
CDRAvlblstrmCt_MAX VARCHAR(256) NOT NULL,
MedFldStrmCt_MIN VARCHAR(256) NOT NULL,
MedFldStrmCt_MAX VARCHAR(256) NOT NULL,
ClSupFldStrmCt_MIN VARCHAR(256) NOT NULL,
ClSupFldStrmCt_MAX VARCHAR(256) NOT NULL,
ClDrpdStrmCt_MIN VARCHAR(256) NOT NULL,
ClDrpdStrmCt_MAX VARCHAR(256) NOT NULL,
MedSudedStrmCt_MIN VARCHAR(256) NOT NULL,
MedSudedStrmCt_MAX VARCHAR(256) NOT NULL,
ClSupSudStrmCt_MIN VARCHAR(256) NOT NULL,
ClSupSudStrmCt_MAX VARCHAR(256) NOT NULL,
ClSupFlrPer_MIN VARCHAR(256) NOT NULL,
ClSupFlrPer_MAX VARCHAR(256) NOT NULL,
ClDrpdFlrPer_MIN VARCHAR(256) NOT NULL,
ClDrpdFlrPer_MAX VARCHAR(256) NOT NULL,
AnsSeiRatio_MIN VARCHAR(256) NOT NULL,
AnsSeiRatio_MAX VARCHAR(256) NOT NULL,
ShrtCalPer_MIN VARCHAR(256) NOT NULL,
ShrtCalPer_MAX VARCHAR(256) NOT NULL,
MedFlrPer_MIN VARCHAR(256) NOT NULL,
MedFlrPer_MAX VARCHAR(256) NOT NULL,
AvgCalDurtn_MIN VARCHAR(256) NOT NULL,
AvgCalDurtn_MAX VARCHAR(256) NOT NULL,
MedFldFWStrmCt_MIN VARCHAR(256) NOT NULL,
MedFldFWStrmCt_MAX VARCHAR(256) NOT NULL,
FWMedFlrPer_MIN VARCHAR(256) NOT NULL,
FWMedFlrPer_MAX VARCHAR(256) NOT NULL,
FWIPBldStrmCt_MIN VARCHAR(256) NOT NULL,
FWIPBldStrmCt_MAX VARCHAR(256) NOT NULL,
FWIPBldMFlrPer_MIN VARCHAR(256) NOT NULL,
FWIPBldMFlrPer_MAX VARCHAR(256) NOT NULL,
MFldOtrStrmCnt_MIN VARCHAR(256) NOT NULL,
MFldOtrStrmCnt_MAX VARCHAR(256) NOT NULL,
OtrMedFlrPer_MIN VARCHAR(256) NOT NULL,
OtrMedFlrPer_MAX VARCHAR(256) NOT NULL
);
ALTER TABLE MTMCalSumryTest_THRESH ADD constraint PK_MTMCalSumryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMCalSumryTest_THRESH ON MTMCalSumryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMCalSumryTest ON MTMCalSumryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMCalSumryTest ON MTMCalSumryTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMSrvPrvStats;
CREATE TABLE MTMSrvPrvStats(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PNDING_ACTVTION DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_ST VARCHAR(32) NOT NULL,
PNDING_PRVISION DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_ST VARCHAR(32) NOT NULL,
PNDING_INPUT DECIMAL(20,4) NOT NULL,
PNDING_INPUT_ST VARCHAR(32) NOT NULL,
SUCCESS DECIMAL(20,4) NOT NULL,
SUCCESS_ST VARCHAR(32) NOT NULL,
DISABLED DECIMAL(20,4) NOT NULL,
DISABLED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_MTMSrvPrvStats ON MTMSrvPrvStats(MSMT_TIME);
ALTER TABLE MTMSrvPrvStats ADD CONSTRAINT PK_MTMSrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMSrvPrvStats_TREND;
CREATE TABLE MTMSrvPrvStats_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
PNDING_ACTVTION_MIN DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_MAX DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_STCNT VARCHAR(32) NOT NULL,
PNDING_PRVISION_MIN DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_MAX DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_STCNT VARCHAR(32) NOT NULL,
PNDING_INPUT_MIN DECIMAL(20,4) NOT NULL,
PNDING_INPUT_MAX DECIMAL(20,4) NOT NULL,
PNDING_INPUT_STCNT VARCHAR(32) NOT NULL,
SUCCESS_MIN DECIMAL(20,4) NOT NULL,
SUCCESS_MAX DECIMAL(20,4) NOT NULL,
SUCCESS_STCNT VARCHAR(32) NOT NULL,
DISABLED_MIN DECIMAL(20,4) NOT NULL,
DISABLED_MAX DECIMAL(20,4) NOT NULL,
DISABLED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE MTMSrvPrvStats_TREND ADD CONSTRAINT PK_MTMSrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMSrvPrvStats_THRESH;
CREATE TABLE MTMSrvPrvStats_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
PNDING_ACTVTION_MIN VARCHAR(256) NOT NULL,
PNDING_ACTVTION_MAX VARCHAR(256) NOT NULL,
PNDING_PRVISION_MIN VARCHAR(256) NOT NULL,
PNDING_PRVISION_MAX VARCHAR(256) NOT NULL,
PNDING_INPUT_MIN VARCHAR(256) NOT NULL,
PNDING_INPUT_MAX VARCHAR(256) NOT NULL,
SUCCESS_MIN VARCHAR(256) NOT NULL,
SUCCESS_MAX VARCHAR(256) NOT NULL,
DISABLED_MIN VARCHAR(256) NOT NULL,
DISABLED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMSrvPrvStats_THRESH ADD CONSTRAINT PK_MTMSrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMSrvPrvStats_THRESH ON MTMSrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMSrvPrvStats ON MTMSrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMSrvPrvStats ON MTMSrvPrvStats_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMUsrActvitiesTest;
CREATE TABLE MTMUsrActvitiesTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
uuteamchat DECIMAL(20,4) NOT NULL,
uuteamchat_ST varchar(32) NOT NULL,
uuprvchat DECIMAL(20,4) NOT NULL,
uuprvchat_ST varchar(32) NOT NULL,
uucalls DECIMAL(20,4) NOT NULL,
uucalls_ST varchar(32) NOT NULL,
uumetings DECIMAL(20,4) NOT NULL,
uumetings_ST varchar(32) NOT NULL,
uuothrAct DECIMAL(20,4) NOT NULL,
uuothrAct_ST varchar(32) NOT NULL,
teamchat DECIMAL(20,4) NOT NULL,
teamchat_ST varchar(32) NOT NULL,
privchat DECIMAL(20,4) NOT NULL,
privchat_ST varchar(32) NOT NULL,
calls DECIMAL(20,4) NOT NULL,
calls_ST varchar(32) NOT NULL,
meetings DECIMAL(20,4) NOT NULL,
meetings_ST varchar(32) NOT NULL,
otherAct DECIMAL(20,4) NOT NULL,
otherAct_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMUsrActvitiesTest ON MTMUsrActvitiesTest(MSMT_TIME);
ALTER TABLE MTMUsrActvitiesTest ADD constraint PK_MTMUsrActvitiesTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMUsrActvitiesTest_TREND;
CREATE TABLE MTMUsrActvitiesTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
uuteamchat_MIN DECIMAL(20,4) NOT NULL,
uuteamchat_MAX DECIMAL(20,4) NOT NULL,
uuteamchat_STCNT varchar(32) NOT NULL,
uuprvchat_MIN DECIMAL(20,4) NOT NULL,
uuprvchat_MAX DECIMAL(20,4) NOT NULL,
uuprvchat_STCNT varchar(32) NOT NULL,
uucalls_MIN DECIMAL(20,4) NOT NULL,
uucalls_MAX DECIMAL(20,4) NOT NULL,
uucalls_STCNT varchar(32) NOT NULL,
uumetings_MIN DECIMAL(20,4) NOT NULL,
uumetings_MAX DECIMAL(20,4) NOT NULL,
uumetings_STCNT varchar(32) NOT NULL,
uuothrAct_MIN DECIMAL(20,4) NOT NULL,
uuothrAct_MAX DECIMAL(20,4) NOT NULL,
uuothrAct_STCNT varchar(32) NOT NULL,
teamchat_MIN DECIMAL(20,4) NOT NULL,
teamchat_MAX DECIMAL(20,4) NOT NULL,
teamchat_STCNT varchar(32) NOT NULL,
privchat_MIN DECIMAL(20,4) NOT NULL,
privchat_MAX DECIMAL(20,4) NOT NULL,
privchat_STCNT varchar(32) NOT NULL,
calls_MIN DECIMAL(20,4) NOT NULL,
calls_MAX DECIMAL(20,4) NOT NULL,
calls_STCNT varchar(32) NOT NULL,
meetings_MIN DECIMAL(20,4) NOT NULL,
meetings_MAX DECIMAL(20,4) NOT NULL,
meetings_STCNT varchar(32) NOT NULL,
otherAct_MIN DECIMAL(20,4) NOT NULL,
otherAct_MAX DECIMAL(20,4) NOT NULL,
otherAct_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMUsrActvitiesTest_TREND ADD constraint PK_MTMUsrActvitiesTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMUsrActvitiesTest_THRESH;
CREATE TABLE MTMUsrActvitiesTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
uuteamchat_MIN VARCHAR(256) NOT NULL,
uuteamchat_MAX VARCHAR(256) NOT NULL,
uuprvchat_MIN VARCHAR(256) NOT NULL,
uuprvchat_MAX VARCHAR(256) NOT NULL,
uucalls_MIN VARCHAR(256) NOT NULL,
uucalls_MAX VARCHAR(256) NOT NULL,
uumetings_MIN VARCHAR(256) NOT NULL,
uumetings_MAX VARCHAR(256) NOT NULL,
uuothrAct_MIN VARCHAR(256) NOT NULL,
uuothrAct_MAX VARCHAR(256) NOT NULL,
teamchat_MIN VARCHAR(256) NOT NULL,
teamchat_MAX VARCHAR(256) NOT NULL,
privchat_MIN VARCHAR(256) NOT NULL,
privchat_MAX VARCHAR(256) NOT NULL,
calls_MIN VARCHAR(256) NOT NULL,
calls_MAX VARCHAR(256) NOT NULL,
meetings_MIN VARCHAR(256) NOT NULL,
meetings_MAX VARCHAR(256) NOT NULL,
otherAct_MIN VARCHAR(256) NOT NULL,
otherAct_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMUsrActvitiesTest_THRESH ADD constraint PK_MTMUsrActvitiesTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMUsrActvitiesTest_THRESH ON MTMUsrActvitiesTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMUsrActvitiesTest ON MTMUsrActvitiesTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMUsrActvitiesTest ON MTMUsrActvitiesTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMTeamsInvTest;
CREATE TABLE MTMTeamsInvTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
teamscount DECIMAL(20,4) NOT NULL,
teamscount_ST varchar(32) NOT NULL,
publictems DECIMAL(20,4) NOT NULL,
publictems_ST varchar(32) NOT NULL,
privtetems DECIMAL(20,4) NOT NULL,
privtetems_ST varchar(32) NOT NULL,
chanlsCnt DECIMAL(20,4) NOT NULL,
chanlsCnt_ST varchar(32) NOT NULL,
activetems DECIMAL(20,4) NOT NULL,
activetems_ST varchar(32) NOT NULL,
inactivtems DECIMAL(20,4) NOT NULL,
inactivtems_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMTeamsInvTest ON MTMTeamsInvTest(MSMT_TIME);
ALTER TABLE MTMTeamsInvTest ADD constraint PK_MTMTeamsInvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMTeamsInvTest_TREND;
CREATE TABLE MTMTeamsInvTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
teamscount_MIN DECIMAL(20,4) NOT NULL,
teamscount_MAX DECIMAL(20,4) NOT NULL,
teamscount_STCNT varchar(32) NOT NULL,
publictems_MIN DECIMAL(20,4) NOT NULL,
publictems_MAX DECIMAL(20,4) NOT NULL,
publictems_STCNT varchar(32) NOT NULL,
privtetems_MIN DECIMAL(20,4) NOT NULL,
privtetems_MAX DECIMAL(20,4) NOT NULL,
privtetems_STCNT varchar(32) NOT NULL,
chanlsCnt_MIN DECIMAL(20,4) NOT NULL,
chanlsCnt_MAX DECIMAL(20,4) NOT NULL,
chanlsCnt_STCNT varchar(32) NOT NULL,
activetems_MIN DECIMAL(20,4) NOT NULL,
activetems_MAX DECIMAL(20,4) NOT NULL,
activetems_STCNT varchar(32) NOT NULL,
inactivtems_MIN DECIMAL(20,4) NOT NULL,
inactivtems_MAX DECIMAL(20,4) NOT NULL,
inactivtems_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMTeamsInvTest_TREND ADD constraint PK_MTMTeamsInvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMTeamsInvTest_THRESH;
CREATE TABLE MTMTeamsInvTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
teamscount_MIN VARCHAR(256) NOT NULL,
teamscount_MAX VARCHAR(256) NOT NULL,
publictems_MIN VARCHAR(256) NOT NULL,
publictems_MAX VARCHAR(256) NOT NULL,
privtetems_MIN VARCHAR(256) NOT NULL,
privtetems_MAX VARCHAR(256) NOT NULL,
chanlsCnt_MIN VARCHAR(256) NOT NULL,
chanlsCnt_MAX VARCHAR(256) NOT NULL,
activetems_MIN VARCHAR(256) NOT NULL,
activetems_MAX VARCHAR(256) NOT NULL,
inactivtems_MIN VARCHAR(256) NOT NULL,
inactivtems_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMTeamsInvTest_THRESH ADD constraint PK_MTMTeamsInvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMTeamsInvTest_THRESH ON MTMTeamsInvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMTeamsInvTest ON MTMTeamsInvTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMTeamsInvTest ON MTMTeamsInvTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMtemsOAMactTest;
CREATE TABLE MTMtemsOAMactTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MemAdtions DECIMAL(20,4) NOT NULL,
MemAdtions_ST varchar(32) NOT NULL,
MemRolChgd DECIMAL(20,4) NOT NULL,
MemRolChgd_ST varchar(32) NOT NULL,
TemStgsChgd DECIMAL(20,4) NOT NULL,
TemStgsChgd_ST varchar(32) NOT NULL,
temdelcnt DECIMAL(20,4) NOT NULL,
temdelcnt_ST varchar(32) NOT NULL,
MembrRmvdCnt DECIMAL(20,4) NOT NULL,
MembrRmvdCnt_ST varchar(32) NOT NULL,
CnlStgsCngCnt DECIMAL(20,4) NOT NULL,
CnlStgsCngCnt_ST varchar(32) NOT NULL,
TmtentStgMds DECIMAL(20,4) NOT NULL,
TmtentStgMds_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMtemsOAMactTest ON MTMtemsOAMactTest(MSMT_TIME);
ALTER TABLE MTMtemsOAMactTest ADD constraint PK_MTMtemsOAMactTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMtemsOAMactTest_TREND;
CREATE TABLE MTMtemsOAMactTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MemAdtions_MIN DECIMAL(20,4) NOT NULL,
MemAdtions_MAX DECIMAL(20,4) NOT NULL,
MemAdtions_STCNT varchar(32) NOT NULL,
MemRolChgd_MIN DECIMAL(20,4) NOT NULL,
MemRolChgd_MAX DECIMAL(20,4) NOT NULL,
MemRolChgd_STCNT varchar(32) NOT NULL,
TemStgsChgd_MIN DECIMAL(20,4) NOT NULL,
TemStgsChgd_MAX DECIMAL(20,4) NOT NULL,
TemStgsChgd_STCNT varchar(32) NOT NULL,
temdelcnt_MIN DECIMAL(20,4) NOT NULL,
temdelcnt_MAX DECIMAL(20,4) NOT NULL,
temdelcnt_STCNT varchar(32) NOT NULL,
MembrRmvdCnt_MIN DECIMAL(20,4) NOT NULL,
MembrRmvdCnt_MAX DECIMAL(20,4) NOT NULL,
MembrRmvdCnt_STCNT varchar(32) NOT NULL,
CnlStgsCngCnt_MIN DECIMAL(20,4) NOT NULL,
CnlStgsCngCnt_MAX DECIMAL(20,4) NOT NULL,
CnlStgsCngCnt_STCNT varchar(32) NOT NULL,
TmtentStgMds_MIN DECIMAL(20,4) NOT NULL,
TmtentStgMds_MAX DECIMAL(20,4) NOT NULL,
TmtentStgMds_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMtemsOAMactTest_TREND ADD constraint PK_MTMtemsOAMactTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMtemsOAMactTest_THRESH;
CREATE TABLE MTMtemsOAMactTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MemAdtions_MIN VARCHAR(256) NOT NULL,
MemAdtions_MAX VARCHAR(256) NOT NULL,
MemRolChgd_MIN VARCHAR(256) NOT NULL,
MemRolChgd_MAX VARCHAR(256) NOT NULL,
TemStgsChgd_MIN VARCHAR(256) NOT NULL,
TemStgsChgd_MAX VARCHAR(256) NOT NULL,
temdelcnt_MIN VARCHAR(256) NOT NULL,
temdelcnt_MAX VARCHAR(256) NOT NULL,
MembrRmvdCnt_MIN VARCHAR(256) NOT NULL,
MembrRmvdCnt_MAX VARCHAR(256) NOT NULL,
CnlStgsCngCnt_MIN VARCHAR(256) NOT NULL,
CnlStgsCngCnt_MAX VARCHAR(256) NOT NULL,
TmtentStgMds_MIN VARCHAR(256) NOT NULL,
TmtentStgMds_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMtemsOAMactTest_THRESH ADD constraint PK_MTMtemsOAMactTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMtemsOAMactTest_THRESH ON MTMtemsOAMactTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMtemsOAMactTest ON MTMtemsOAMactTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMtemsOAMactTest ON MTMtemsOAMactTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMtmChnlOperTest;
CREATE TABLE MTMtmChnlOperTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
botsAdditnCnt DECIMAL(20,4) NOT NULL,
botsAdditnCnt_ST varchar(32) NOT NULL,
botsRemvedCnt DECIMAL(20,4) NOT NULL,
botsRemvedCnt_ST varchar(32) NOT NULL,
chanlsAdtCnt DECIMAL(20,4) NOT NULL,
chanlsAdtCnt_ST varchar(32) NOT NULL,
chanlsDelCnt DECIMAL(20,4) NOT NULL,
chanlsDelCnt_ST varchar(32) NOT NULL,
temCreatCnt DECIMAL(20,4) NOT NULL,
temCreatCnt_ST varchar(32) NOT NULL,
CnctAdtsClCnt DECIMAL(20,4) NOT NULL,
CnctAdtsClCnt_ST varchar(32) NOT NULL,
TabAddtoClCnt DECIMAL(20,4) NOT NULL,
TabAddtoClCnt_ST varchar(32) NOT NULL,
CnctrRmdClCnt DECIMAL(20,4) NOT NULL,
CnctrRmdClCnt_ST varchar(32) NOT NULL,
TabRmdClCnt DECIMAL(20,4) NOT NULL,
TabRmdClCnt_ST varchar(32) NOT NULL,
CnctMfInClCnt DECIMAL(20,4) NOT NULL,
CnctMfInClCnt_ST varchar(32) NOT NULL,
TabMfInClCnt DECIMAL(20,4) NOT NULL,
TabMfInClCnt_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMtmChnlOperTest ON MTMtmChnlOperTest(MSMT_TIME);
ALTER TABLE MTMtmChnlOperTest ADD constraint PK_MTMtmChnlOperTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMtmChnlOperTest_TREND;
CREATE TABLE MTMtmChnlOperTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
botsAdditnCnt_MIN DECIMAL(20,4) NOT NULL,
botsAdditnCnt_MAX DECIMAL(20,4) NOT NULL,
botsAdditnCnt_STCNT varchar(32) NOT NULL,
botsRemvedCnt_MIN DECIMAL(20,4) NOT NULL,
botsRemvedCnt_MAX DECIMAL(20,4) NOT NULL,
botsRemvedCnt_STCNT varchar(32) NOT NULL,
chanlsAdtCnt_MIN DECIMAL(20,4) NOT NULL,
chanlsAdtCnt_MAX DECIMAL(20,4) NOT NULL,
chanlsAdtCnt_STCNT varchar(32) NOT NULL,
chanlsDelCnt_MIN DECIMAL(20,4) NOT NULL,
chanlsDelCnt_MAX DECIMAL(20,4) NOT NULL,
chanlsDelCnt_STCNT varchar(32) NOT NULL,
temCreatCnt_MIN DECIMAL(20,4) NOT NULL,
temCreatCnt_MAX DECIMAL(20,4) NOT NULL,
temCreatCnt_STCNT varchar(32) NOT NULL,
CnctAdtsClCnt_MIN DECIMAL(20,4) NOT NULL,
CnctAdtsClCnt_MAX DECIMAL(20,4) NOT NULL,
CnctAdtsClCnt_STCNT varchar(32) NOT NULL,
TabAddtoClCnt_MIN DECIMAL(20,4) NOT NULL,
TabAddtoClCnt_MAX DECIMAL(20,4) NOT NULL,
TabAddtoClCnt_STCNT varchar(32) NOT NULL,
CnctrRmdClCnt_MIN DECIMAL(20,4) NOT NULL,
CnctrRmdClCnt_MAX DECIMAL(20,4) NOT NULL,
CnctrRmdClCnt_STCNT varchar(32) NOT NULL,
TabRmdClCnt_MIN DECIMAL(20,4) NOT NULL,
TabRmdClCnt_MAX DECIMAL(20,4) NOT NULL,
TabRmdClCnt_STCNT varchar(32) NOT NULL,
CnctMfInClCnt_MIN DECIMAL(20,4) NOT NULL,
CnctMfInClCnt_MAX DECIMAL(20,4) NOT NULL,
CnctMfInClCnt_STCNT varchar(32) NOT NULL,
TabMfInClCnt_MIN DECIMAL(20,4) NOT NULL,
TabMfInClCnt_MAX DECIMAL(20,4) NOT NULL,
TabMfInClCnt_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMtmChnlOperTest_TREND ADD constraint PK_MTMtmChnlOperTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMtmChnlOperTest_THRESH;
CREATE TABLE MTMtmChnlOperTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
botsAdditnCnt_MIN VARCHAR(256) NOT NULL,
botsAdditnCnt_MAX VARCHAR(256) NOT NULL,
botsRemvedCnt_MIN VARCHAR(256) NOT NULL,
botsRemvedCnt_MAX VARCHAR(256) NOT NULL,
chanlsAdtCnt_MIN VARCHAR(256) NOT NULL,
chanlsAdtCnt_MAX VARCHAR(256) NOT NULL,
chanlsDelCnt_MIN VARCHAR(256) NOT NULL,
chanlsDelCnt_MAX VARCHAR(256) NOT NULL,
temCreatCnt_MIN VARCHAR(256) NOT NULL,
temCreatCnt_MAX VARCHAR(256) NOT NULL,
CnctAdtsClCnt_MIN VARCHAR(256) NOT NULL,
CnctAdtsClCnt_MAX VARCHAR(256) NOT NULL,
TabAddtoClCnt_MIN VARCHAR(256) NOT NULL,
TabAddtoClCnt_MAX VARCHAR(256) NOT NULL,
CnctrRmdClCnt_MIN VARCHAR(256) NOT NULL,
CnctrRmdClCnt_MAX VARCHAR(256) NOT NULL,
TabRmdClCnt_MIN VARCHAR(256) NOT NULL,
TabRmdClCnt_MAX VARCHAR(256) NOT NULL,
CnctMfInClCnt_MIN VARCHAR(256) NOT NULL,
CnctMfInClCnt_MAX VARCHAR(256) NOT NULL,
TabMfInClCnt_MIN VARCHAR(256) NOT NULL,
TabMfInClCnt_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMtmChnlOperTest_THRESH ADD constraint PK_MTMtmChnlOperTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMtmChnlOperTest_THRESH ON MTMtmChnlOperTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMtmChnlOperTest ON MTMtmChnlOperTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMtmChnlOperTest ON MTMtmChnlOperTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMUsrLoginsTest;
CREATE TABLE MTMUsrLoginsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
UsrloginsCnt DECIMAL(20,4) NOT NULL,
UsrloginsCnt_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMUsrLoginsTest ON MTMUsrLoginsTest(MSMT_TIME);
ALTER TABLE MTMUsrLoginsTest ADD constraint PK_MTMUsrLoginsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMUsrLoginsTest_TREND;
CREATE TABLE MTMUsrLoginsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
UsrloginsCnt_MIN DECIMAL(20,4) NOT NULL,
UsrloginsCnt_MAX DECIMAL(20,4) NOT NULL,
UsrloginsCnt_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMUsrLoginsTest_TREND ADD constraint PK_MTMUsrLoginsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMUsrLoginsTest_THRESH;
CREATE TABLE MTMUsrLoginsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
UsrloginsCnt_MIN VARCHAR(256) NOT NULL,
UsrloginsCnt_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMUsrLoginsTest_THRESH ADD constraint PK_MTMUsrLoginsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMUsrLoginsTest_THRESH ON MTMUsrLoginsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMUsrLoginsTest ON MTMUsrLoginsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMUsrLoginsTest ON MTMUsrLoginsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMMsgCentTest;
CREATE TABLE MTMMsgCentTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MsgCenterCommunication DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMMsgCentTest ON MTMMsgCentTest(MSMT_TIME);
ALTER TABLE MTMMsgCentTest ADD constraint PK_MTMMsgCentTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMMsgCentTest_TREND;
CREATE TABLE MTMMsgCentTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MsgCenterCommunication_MIN DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_MAX DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMMsgCentTest_TREND ADD constraint PK_MTMMsgCentTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMMsgCentTest_THRESH;
CREATE TABLE MTMMsgCentTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MsgCenterCommunication_MIN VARCHAR(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMMsgCentTest_THRESH ADD constraint PK_MTMMsgCentTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMMsgCentTest_THRESH ON MTMMsgCentTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMMsgCentTest ON MTMMsgCentTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMMsgCentTest ON MTMMsgCentTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMConneChecksTest;
CREATE TABLE MTMConneChecksTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Connection_Status DECIMAL(20,4) NOT NULL,
Connection_Status_ST varchar(32) NOT NULL,
Time_taken_to_connect DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMConneChecksTest ON MTMConneChecksTest(MSMT_TIME);
ALTER TABLE MTMConneChecksTest ADD constraint PK_MTMConneChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMConneChecksTest_TREND;
CREATE TABLE MTMConneChecksTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Connection_Status_MIN DECIMAL(20,4) NOT NULL,
Connection_Status_MAX DECIMAL(20,4) NOT NULL,
Connection_Status_STCNT varchar(32) NOT NULL,
Time_taken_to_connect_MIN DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_MAX DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMConneChecksTest_TREND ADD constraint PK_MTMConneChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMConneChecksTest_THRESH;
CREATE TABLE MTMConneChecksTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Connection_Status_MIN VARCHAR(256) NOT NULL,
Connection_Status_MAX VARCHAR(256) NOT NULL,
Time_taken_to_connect_MIN VARCHAR(256) NOT NULL,
Time_taken_to_connect_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMConneChecksTest_THRESH ADD constraint PK_MTMConneChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMConneChecksTest_THRESH ON MTMConneChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMConneChecksTest ON MTMConneChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMConneChecksTest ON MTMConneChecksTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMCallConnTest;
CREATE TABLE MTMCallConnTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CALLS_INITIATED DECIMAL(20,4) NOT NULL,
CALLS_INITIATED_ST varchar(32) NOT NULL,
CALLS_COMPLETED DECIMAL(20,4) NOT NULL,
CALLS_COMPLETED_ST varchar(32) NOT NULL,
CALLS_FAILED DECIMAL(20,4) NOT NULL,
CALLS_FAILED_ST varchar(32) NOT NULL,
CONN_CHECKS_STATUS DECIMAL(20,4) NOT NULL,
CONN_CHECKS_STATUS_ST varchar(32) NOT NULL,
PACKT_LOSS_RATE DECIMAL(20,4) NOT NULL,
PACKT_LOSS_RATE_ST varchar(32) NOT NULL,
RTT_LATENCY DECIMAL(20,4) NOT NULL,
RTT_LATENCY_ST varchar(32) NOT NULL,
JITTER DECIMAL(20,4) NOT NULL,
JITTER_ST varchar(32) NOT NULL,
PACKT_REORDER_RATIO DECIMAL(20,4) NOT NULL,
PACKT_REORDER_RATIO_ST varchar(32) NOT NULL,
MOS_SCORE DECIMAL(20,4) NOT NULL,
MOS_SCORE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMCallConnTest ON MTMCallConnTest(MSMT_TIME);
ALTER TABLE MTMCallConnTest ADD constraint PK_MTMCallConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMCallConnTest_TREND;
CREATE TABLE MTMCallConnTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CALLS_INITIATED_MIN DECIMAL(20,4) NOT NULL,
CALLS_INITIATED_MAX DECIMAL(20,4) NOT NULL,
CALLS_INITIATED_STCNT varchar(32) NOT NULL,
CALLS_COMPLETED_MIN DECIMAL(20,4) NOT NULL,
CALLS_COMPLETED_MAX DECIMAL(20,4) NOT NULL,
CALLS_COMPLETED_STCNT varchar(32) NOT NULL,
CALLS_FAILED_MIN DECIMAL(20,4) NOT NULL,
CALLS_FAILED_MAX DECIMAL(20,4) NOT NULL,
CALLS_FAILED_STCNT varchar(32) NOT NULL,
CONN_CHECKS_STATUS_MIN DECIMAL(20,4) NOT NULL,
CONN_CHECKS_STATUS_MAX DECIMAL(20,4) NOT NULL,
CONN_CHECKS_STATUS_STCNT varchar(32) NOT NULL,
PACKT_LOSS_RATE_MIN DECIMAL(20,4) NOT NULL,
PACKT_LOSS_RATE_MAX DECIMAL(20,4) NOT NULL,
PACKT_LOSS_RATE_STCNT varchar(32) NOT NULL,
RTT_LATENCY_MIN DECIMAL(20,4) NOT NULL,
RTT_LATENCY_MAX DECIMAL(20,4) NOT NULL,
RTT_LATENCY_STCNT varchar(32) NOT NULL,
JITTER_MIN DECIMAL(20,4) NOT NULL,
JITTER_MAX DECIMAL(20,4) NOT NULL,
JITTER_STCNT varchar(32) NOT NULL,
PACKT_REORDER_RATIO_MIN DECIMAL(20,4) NOT NULL,
PACKT_REORDER_RATIO_MAX DECIMAL(20,4) NOT NULL,
PACKT_REORDER_RATIO_STCNT varchar(32) NOT NULL,
MOS_SCORE_MIN DECIMAL(20,4) NOT NULL,
MOS_SCORE_MAX DECIMAL(20,4) NOT NULL,
MOS_SCORE_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMCallConnTest_TREND ADD constraint PK_MTMCallConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMCallConnTest_THRESH;
CREATE TABLE MTMCallConnTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CALLS_INITIATED_MIN VARCHAR(256) NOT NULL,
CALLS_INITIATED_MAX VARCHAR(256) NOT NULL,
CALLS_COMPLETED_MIN VARCHAR(256) NOT NULL,
CALLS_COMPLETED_MAX VARCHAR(256) NOT NULL,
CALLS_FAILED_MIN VARCHAR(256) NOT NULL,
CALLS_FAILED_MAX VARCHAR(256) NOT NULL,
CONN_CHECKS_STATUS_MIN VARCHAR(256) NOT NULL,
CONN_CHECKS_STATUS_MAX VARCHAR(256) NOT NULL,
PACKT_LOSS_RATE_MIN VARCHAR(256) NOT NULL,
PACKT_LOSS_RATE_MAX VARCHAR(256) NOT NULL,
RTT_LATENCY_MIN VARCHAR(256) NOT NULL,
RTT_LATENCY_MAX VARCHAR(256) NOT NULL,
JITTER_MIN VARCHAR(256) NOT NULL,
JITTER_MAX VARCHAR(256) NOT NULL,
PACKT_REORDER_RATIO_MIN VARCHAR(256) NOT NULL,
PACKT_REORDER_RATIO_MAX VARCHAR(256) NOT NULL,
MOS_SCORE_MIN VARCHAR(256) NOT NULL,
MOS_SCORE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMCallConnTest_THRESH ADD constraint PK_MTMCallConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMCallConnTest_THRESH ON MTMCallConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMCallConnTest ON MTMCallConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMCallConnTest ON MTMCallConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMDeviceUsrDtlsTest;
CREATE TABLE MTMDeviceUsrDtlsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Unique_users DECIMAL(20,4) NOT NULL,
Unique_users_ST varchar(32) NOT NULL);

CREATE INDEX IDX_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest(MSMT_TIME);
ALTER TABLE MTMDeviceUsrDtlsTest ADD constraint PK_MTMDeviceUsrDtlsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMDeviceUsrDtlsTest_TREND;
CREATE TABLE MTMDeviceUsrDtlsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Unique_users_MIN DECIMAL(20,4) NOT NULL,
Unique_users_MAX DECIMAL(20,4) NOT NULL,
Unique_users_STCNT varchar(32) NOT NULL);

ALTER TABLE MTMDeviceUsrDtlsTest_TREND ADD constraint PK_MTMDeviceUsrDtlsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMDeviceUsrDtlsTest_THRESH;
CREATE TABLE MTMDeviceUsrDtlsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Unique_users_MIN VARCHAR(256) NOT NULL,
Unique_users_MAX VARCHAR(256) NOT NULL);

ALTER TABLE MTMDeviceUsrDtlsTest_THRESH ADD constraint PK_MTMDevicUsrDtlTst_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMDevicUsrDtlTst_THRESH ON MTMDeviceUsrDtlsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMSrvcHlhTest;
CREATE TABLE MTMSrvcHlhTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVICE_INCIDENTS DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar(32) NOT NULL,
MAINTENANCE_EVENTS DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar(32) NOT NULL,
SERVICE_STATUS DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_MTMSrvcHlhTest ON MTMSrvcHlhTest(MSMT_TIME);
ALTER TABLE MTMSrvcHlhTest ADD constraint PK_MTMSrvcHlhTest PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMSrvcHlhTest_TREND;
CREATE TABLE MTMSrvcHlhTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVICE_INCIDENTS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar(32) NOT NULL,
MAINTENANCE_EVENTS_MIN DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar(32) NOT NULL,
SERVICE_STATUS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE MTMSrvcHlhTest_TREND ADD constraint PK_MTMSrvcHlhTest_TREND PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMSrvcHlhTest_THRESH;
CREATE TABLE MTMSrvcHlhTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVICE_INCIDENTS_MIN VARCHAR(256) NOT NULL,
SERVICE_INCIDENTS_MAX VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MIN VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MAX VARCHAR(256) NOT NULL,
SERVICE_STATUS_MIN VARCHAR(256) NOT NULL,
SERVICE_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE MTMSrvcHlhTest_THRESH ADD constraint PK_MTMSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMSrvcHlhTest_THRESH ON MTMSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMSrvcHlhTest ON MTMSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMSrvcHlhTest ON MTMSrvcHlhTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE O365GrpsActsTest;
CREATE TABLE O365GrpsActsTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
mbstrgeusdbyGrps DECIMAL(20,4) NOT NULL,
mbstrgeusdbyGrps_ST varchar(32) NOT NULL,
mbItemsinGrps DECIMAL(20,4) NOT NULL,
mbItemsinGrps_ST varchar(32) NOT NULL,
ShrePointfilsCnt DECIMAL(20,4) NOT NULL,
ShrePointfilsCnt_ST varchar(32) NOT NULL,
ShrePointSteStgeUsd DECIMAL(20,4) NOT NULL,
ShrePointSteStgeUsd_ST varchar(32) NOT NULL,
ShrePntActfilsCnt DECIMAL(20,4) NOT NULL,
ShrePntActfilsCnt_ST varchar(32) NOT NULL,
mailRcvdCnt DECIMAL(20,4) NOT NULL,
mailRcvdCnt_ST varchar(32) NOT NULL,
ymmerPstedMsgCnt DECIMAL(20,4) NOT NULL,
ymmerPstedMsgCnt_ST varchar(32) NOT NULL,
ymlReadmsgCnt DECIMAL(20,4) NOT NULL,
ymlReadmsgCnt_ST varchar(32) NOT NULL,
ymrlikedMsgCnt DECIMAL(20,4) NOT NULL,
ymrlikedMsgCnt_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365GrpsActsTest ON O365GrpsActsTest(MSMT_TIME);
ALTER TABLE O365GrpsActsTest ADD constraint PK_O365GrpsActsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365GrpsActsTest_TREND;
CREATE TABLE O365GrpsActsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
mbstrgeusdbyGrps_MIN DECIMAL(20,4) NOT NULL,
mbstrgeusdbyGrps_MAX DECIMAL(20,4) NOT NULL,
mbstrgeusdbyGrps_STCNT varchar(32) NOT NULL,
mbItemsinGrps_MIN DECIMAL(20,4) NOT NULL,
mbItemsinGrps_MAX DECIMAL(20,4) NOT NULL,
mbItemsinGrps_STCNT varchar(32) NOT NULL,
ShrePointfilsCnt_MIN DECIMAL(20,4) NOT NULL,
ShrePointfilsCnt_MAX DECIMAL(20,4) NOT NULL,
ShrePointfilsCnt_STCNT varchar(32) NOT NULL,
ShrePointSteStgeUsd_MIN DECIMAL(20,4) NOT NULL,
ShrePointSteStgeUsd_MAX DECIMAL(20,4) NOT NULL,
ShrePointSteStgeUsd_STCNT varchar(32) NOT NULL,
ShrePntActfilsCnt_MIN DECIMAL(20,4) NOT NULL,
ShrePntActfilsCnt_MAX DECIMAL(20,4) NOT NULL,
ShrePntActfilsCnt_STCNT varchar(32) NOT NULL,
mailRcvdCnt_MIN DECIMAL(20,4) NOT NULL,
mailRcvdCnt_MAX DECIMAL(20,4) NOT NULL,
mailRcvdCnt_STCNT varchar(32) NOT NULL,
ymmerPstedMsgCnt_MIN DECIMAL(20,4) NOT NULL,
ymmerPstedMsgCnt_MAX DECIMAL(20,4) NOT NULL,
ymmerPstedMsgCnt_STCNT varchar(32) NOT NULL,
ymlReadmsgCnt_MIN DECIMAL(20,4) NOT NULL,
ymlReadmsgCnt_MAX DECIMAL(20,4) NOT NULL,
ymlReadmsgCnt_STCNT varchar(32) NOT NULL,
ymrlikedMsgCnt_MIN DECIMAL(20,4) NOT NULL,
ymrlikedMsgCnt_MAX DECIMAL(20,4) NOT NULL,
ymrlikedMsgCnt_STCNT varchar(32) NOT NULL);

ALTER TABLE O365GrpsActsTest_TREND ADD constraint PK_O365GrpsActsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365GrpsActsTest_THRESH;
CREATE TABLE O365GrpsActsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
mbstrgeusdbyGrps_MIN VARCHAR(256) NOT NULL,
mbstrgeusdbyGrps_MAX VARCHAR(256) NOT NULL,
mbItemsinGrps_MIN VARCHAR(256) NOT NULL,
mbItemsinGrps_MAX VARCHAR(256) NOT NULL,
ShrePointfilsCnt_MIN VARCHAR(256) NOT NULL,
ShrePointfilsCnt_MAX VARCHAR(256) NOT NULL,
ShrePointSteStgeUsd_MIN VARCHAR(256) NOT NULL,
ShrePointSteStgeUsd_MAX VARCHAR(256) NOT NULL,
ShrePntActfilsCnt_MIN VARCHAR(256) NOT NULL,
ShrePntActfilsCnt_MAX VARCHAR(256) NOT NULL,
mailRcvdCnt_MIN VARCHAR(256) NOT NULL,
mailRcvdCnt_MAX VARCHAR(256) NOT NULL,
ymmerPstedMsgCnt_MIN VARCHAR(256) NOT NULL,
ymmerPstedMsgCnt_MAX VARCHAR(256) NOT NULL,
ymlReadmsgCnt_MIN VARCHAR(256) NOT NULL,
ymlReadmsgCnt_MAX VARCHAR(256) NOT NULL,
ymrlikedMsgCnt_MIN VARCHAR(256) NOT NULL,
ymrlikedMsgCnt_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365GrpsActsTest_THRESH ADD constraint PK_O365GrpsActsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365GrpsActsTest_THRESH ON O365GrpsActsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365GrpsActsTest ON O365GrpsActsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365GrpsActsTest ON O365GrpsActsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UsrStusBySrvTest;
CREATE TABLE O365UsrStusBySrvTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Active_Usrs DECIMAL(20,4) NOT NULL,
Active_Usrs_ST varchar(32) NOT NULL,
InActive_Usrs DECIMAL(20,4) NOT NULL,
InActive_Usrs_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365UsrStusBySrvTest ON O365UsrStusBySrvTest(MSMT_TIME);
ALTER TABLE O365UsrStusBySrvTest ADD constraint PK_O365UsrStusBySrvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UsrStusBySrvTest_TREND;
CREATE TABLE O365UsrStusBySrvTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Active_Usrs_MIN DECIMAL(20,4) NOT NULL,
Active_Usrs_MAX DECIMAL(20,4) NOT NULL,
Active_Usrs_STCNT varchar(32) NOT NULL,
InActive_Usrs_MIN DECIMAL(20,4) NOT NULL,
InActive_Usrs_MAX DECIMAL(20,4) NOT NULL,
InActive_Usrs_STCNT varchar(32) NOT NULL);

ALTER TABLE O365UsrStusBySrvTest_TREND ADD constraint PK_O365UsrStusBySrvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UsrStusBySrvTest_THRESH;
CREATE TABLE O365UsrStusBySrvTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Active_Usrs_MIN VARCHAR(256) NOT NULL,
Active_Usrs_MAX VARCHAR(256) NOT NULL,
InActive_Usrs_MIN VARCHAR(256) NOT NULL,
InActive_Usrs_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365UsrStusBySrvTest_THRESH ADD constraint PK_O365UsrStusBySrvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UsrStuBySrvTest_THRESH ON O365UsrStusBySrvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UsrStusBySrvTest ON O365UsrStusBySrvTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UsrStusBySrvTest ON O365UsrStusBySrvTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365FailedLoginTest;
CREATE TABLE O365FailedLoginTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SUCCESS_LOG DECIMAL(20,4) NOT NULL,
SUCCESS_LOG_ST varchar(32) NOT NULL,
FAILED_LOG DECIMAL(20,4) NOT NULL,
FAILED_LOG_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365FailedLoginTest ON O365FailedLoginTest(MSMT_TIME);
ALTER TABLE O365FailedLoginTest ADD constraint PK_O365FailedLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365FailedLoginTest_TREND;
CREATE TABLE O365FailedLoginTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SUCCESS_LOG_MIN DECIMAL(20,4) NOT NULL,
SUCCESS_LOG_MAX DECIMAL(20,4) NOT NULL,
SUCCESS_LOG_STCNT varchar(32) NOT NULL,
FAILED_LOG_MIN DECIMAL(20,4) NOT NULL,
FAILED_LOG_MAX DECIMAL(20,4) NOT NULL,
FAILED_LOG_STCNT varchar(32) NOT NULL);

ALTER TABLE O365FailedLoginTest_TREND ADD constraint PK_O365FailedLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365FailedLoginTest_THRESH;
CREATE TABLE O365FailedLoginTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SUCCESS_LOG_MIN VARCHAR(256) NOT NULL,
SUCCESS_LOG_MAX VARCHAR(256) NOT NULL,
FAILED_LOG_MIN VARCHAR(256) NOT NULL,
FAILED_LOG_MAX VARCHAR(256) NOT NULL);
ALTER TABLE O365FailedLoginTest_THRESH ADD constraint PK_O365FailedLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365FailedLoginTest_THRESH ON O365FailedLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365FailedLoginTest ON O365FailedLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365FailedLoginTest ON O365FailedLoginTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SBOUsersTest;
CREATE TABLE SBOUsersTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTALUSERS DECIMAL(20,4) NOT NULL,
TOTALUSERS_ST varchar(32) NOT NULL,
UNASSIGNED DECIMAL(20,4) NOT NULL,
UNASSIGNED_ST varchar(32) NOT NULL,
DIALUPCONF DECIMAL(20,4) NOT NULL,
DIALUPCONF_ST varchar(32) NOT NULL,
CREATEDUSERS DECIMAL(20,4) NOT NULL,
CREATEDUSERS_ST varchar(32) NOT NULL,
MODIFIEDUSERS DECIMAL(20,4) NOT NULL,
MODIFIEDUSERS_ST varchar(32) NOT NULL,
SOFTDELETEUSERS DECIMAL(20,4) NOT NULL,
SOFTDELETEUSERS_ST varchar(32) NOT NULL,
ACTIVEUSERS DECIMAL(20,4) NOT NULL,
ACTIVEUSERS_ST varchar(32) NOT NULL,
INACTIVEUSERS DECIMAL(20,4) NOT NULL,
INACTIVEUSERS_ST varchar(32) NOT NULL,
NVRLOGUSER DECIMAL(20,4) NOT NULL,
NVRLOGUSER_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOUsersTest ON SBOUsersTest(MSMT_TIME);
ALTER TABLE SBOUsersTest ADD constraint PK_SBOUsersTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOUsersTest_TREND;
CREATE TABLE SBOUsersTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTALUSERS_MIN DECIMAL(20,4) NOT NULL,
TOTALUSERS_MAX DECIMAL(20,4) NOT NULL,
TOTALUSERS_STCNT varchar(32) NOT NULL,
UNASSIGNED_MIN DECIMAL(20,4) NOT NULL,
UNASSIGNED_MAX DECIMAL(20,4) NOT NULL,
UNASSIGNED_STCNT varchar(32) NOT NULL,
DIALUPCONF_MIN DECIMAL(20,4) NOT NULL,
DIALUPCONF_MAX DECIMAL(20,4) NOT NULL,
DIALUPCONF_STCNT varchar(32) NOT NULL,
CREATEDUSERS_MIN DECIMAL(20,4) NOT NULL,
CREATEDUSERS_MAX DECIMAL(20,4) NOT NULL,
CREATEDUSERS_STCNT varchar(32) NOT NULL,
MODIFIEDUSERS_MIN DECIMAL(20,4) NOT NULL,
MODIFIEDUSERS_MAX DECIMAL(20,4) NOT NULL,
MODIFIEDUSERS_STCNT varchar(32) NOT NULL,
SOFTDELETEUSERS_MIN DECIMAL(20,4) NOT NULL,
SOFTDELETEUSERS_MAX DECIMAL(20,4) NOT NULL,
SOFTDELETEUSERS_STCNT varchar(32) NOT NULL,
ACTIVEUSERS_MIN DECIMAL(20,4) NOT NULL,
ACTIVEUSERS_MAX DECIMAL(20,4) NOT NULL,
ACTIVEUSERS_STCNT varchar(32) NOT NULL,
INACTIVEUSERS_MIN DECIMAL(20,4) NOT NULL,
INACTIVEUSERS_MAX DECIMAL(20,4) NOT NULL,
INACTIVEUSERS_STCNT varchar(32) NOT NULL,
NVRLOGUSER_MIN DECIMAL(20,4) NOT NULL,
NVRLOGUSER_MAX DECIMAL(20,4) NOT NULL,
NVRLOGUSER_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOUsersTest_TREND ADD constraint PK_SBOUsersTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOUsersTest_THRESH;
CREATE TABLE SBOUsersTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTALUSERS_MIN VARCHAR(256) NOT NULL,
TOTALUSERS_MAX VARCHAR(256) NOT NULL,
UNASSIGNED_MIN VARCHAR(256) NOT NULL,
UNASSIGNED_MAX VARCHAR(256) NOT NULL,
DIALUPCONF_MIN VARCHAR(256) NOT NULL,
DIALUPCONF_MAX VARCHAR(256) NOT NULL,
CREATEDUSERS_MIN VARCHAR(256) NOT NULL,
CREATEDUSERS_MAX VARCHAR(256) NOT NULL,
MODIFIEDUSERS_MIN VARCHAR(256) NOT NULL,
MODIFIEDUSERS_MAX VARCHAR(256) NOT NULL,
SOFTDELETEUSERS_MIN VARCHAR(256) NOT NULL,
SOFTDELETEUSERS_MAX VARCHAR(256) NOT NULL,
ACTIVEUSERS_MIN VARCHAR(256) NOT NULL,
ACTIVEUSERS_MAX VARCHAR(256) NOT NULL,
INACTIVEUSERS_MIN VARCHAR(256) NOT NULL,
INACTIVEUSERS_MAX VARCHAR(256) NOT NULL,
NVRLOGUSER_MIN VARCHAR(256) NOT NULL,
NVRLOGUSER_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOUsersTest_THRESH ADD constraint PK_SBOUsersTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOUsersTest_THRESH ON SBOUsersTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOUsersTest ON SBOUsersTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOUsersTest ON SBOUsersTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSrvPrvStats;
CREATE TABLE SBOSrvPrvStats(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PNDING_ACTVTION DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_ST VARCHAR(32) NOT NULL,
PNDING_PRVISION DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_ST VARCHAR(32) NOT NULL,
PNDING_INPUT DECIMAL(20,4) NOT NULL,
PNDING_INPUT_ST VARCHAR(32) NOT NULL,
SUCCESS DECIMAL(20,4) NOT NULL,
SUCCESS_ST VARCHAR(32) NOT NULL,
DISABLED DECIMAL(20,4) NOT NULL,
DISABLED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_SBOSrvPrvStats ON SBOSrvPrvStats(MSMT_TIME);
ALTER TABLE SBOSrvPrvStats ADD CONSTRAINT PK_SBOSrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSrvPrvStats_TREND;
CREATE TABLE SBOSrvPrvStats_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
PNDING_ACTVTION_MIN DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_MAX DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_STCNT VARCHAR(32) NOT NULL,
PNDING_PRVISION_MIN DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_MAX DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_STCNT VARCHAR(32) NOT NULL,
PNDING_INPUT_MIN DECIMAL(20,4) NOT NULL,
PNDING_INPUT_MAX DECIMAL(20,4) NOT NULL,
PNDING_INPUT_STCNT VARCHAR(32) NOT NULL,
SUCCESS_MIN DECIMAL(20,4) NOT NULL,
SUCCESS_MAX DECIMAL(20,4) NOT NULL,
SUCCESS_STCNT VARCHAR(32) NOT NULL,
DISABLED_MIN DECIMAL(20,4) NOT NULL,
DISABLED_MAX DECIMAL(20,4) NOT NULL,
DISABLED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE SBOSrvPrvStats_TREND ADD CONSTRAINT PK_SBOSrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSrvPrvStats_THRESH;
CREATE TABLE SBOSrvPrvStats_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
PNDING_ACTVTION_MIN VARCHAR(256) NOT NULL,
PNDING_ACTVTION_MAX VARCHAR(256) NOT NULL,
PNDING_PRVISION_MIN VARCHAR(256) NOT NULL,
PNDING_PRVISION_MAX VARCHAR(256) NOT NULL,
PNDING_INPUT_MIN VARCHAR(256) NOT NULL,
PNDING_INPUT_MAX VARCHAR(256) NOT NULL,
SUCCESS_MIN VARCHAR(256) NOT NULL,
SUCCESS_MAX VARCHAR(256) NOT NULL,
DISABLED_MIN VARCHAR(256) NOT NULL,
DISABLED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOSrvPrvStats_THRESH ADD CONSTRAINT PK_SBOSrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSrvPrvStats_THRESH ON SBOSrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSrvPrvStats ON SBOSrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSrvPrvStats ON SBOSrvPrvStats_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOFeedBackTest;
CREATE TABLE SBOFeedBackTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_FEEDBACK DECIMAL(20,4) NOT NULL,
TOTAL_FEEDBACK_ST varchar(32) NOT NULL,
TOTAL_GOODFEEDBACK DECIMAL(20,4) NOT NULL,
TOTAL_GOODFEEDBACK_ST varchar(32) NOT NULL,
TOTAL_POORFEEDBACK DECIMAL(20,4) NOT NULL,
TOTAL_POORFEEDBACK_ST varchar(32) NOT NULL,
TOTAL_AVOIDFEEDBACK DECIMAL(20,4) NOT NULL,
TOTAL_AVOIDFEEDBACK_ST varchar(32) NOT NULL,
PER_OF_GOODFB DECIMAL(20,4) NOT NULL,
PER_OF_GOODFB_ST varchar(32) NOT NULL,
PER_OF_POODFB DECIMAL(20,4) NOT NULL,
PER_OF_POODFB_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOFeedBackTest ON SBOFeedBackTest(MSMT_TIME);
ALTER TABLE SBOFeedBackTest ADD constraint PK_SBOFeedBackTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOFeedBackTest_TREND;
CREATE TABLE SBOFeedBackTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_FEEDBACK_MIN DECIMAL(20,4) NOT NULL,
TOTAL_FEEDBACK_MAX DECIMAL(20,4) NOT NULL,
TOTAL_FEEDBACK_STCNT varchar(32) NOT NULL,
TOTAL_GOODFEEDBACK_MIN DECIMAL(20,4) NOT NULL,
TOTAL_GOODFEEDBACK_MAX DECIMAL(20,4) NOT NULL,
TOTAL_GOODFEEDBACK_STCNT varchar(32) NOT NULL,
TOTAL_POORFEEDBACK_MIN DECIMAL(20,4) NOT NULL,
TOTAL_POORFEEDBACK_MAX DECIMAL(20,4) NOT NULL,
TOTAL_POORFEEDBACK_STCNT varchar(32) NOT NULL,
TOTAL_AVOIDFEEDBACK_MIN DECIMAL(20,4) NOT NULL,
TOTAL_AVOIDFEEDBACK_MAX DECIMAL(20,4) NOT NULL,
TOTAL_AVOIDFEEDBACK_STCNT varchar(32) NOT NULL,
PER_OF_GOODFB_MIN DECIMAL(20,4) NOT NULL,
PER_OF_GOODFB_MAX DECIMAL(20,4) NOT NULL,
PER_OF_GOODFB_STCNT varchar(32) NOT NULL,
PER_OF_POODFB_MIN DECIMAL(20,4) NOT NULL,
PER_OF_POODFB_MAX DECIMAL(20,4) NOT NULL,
PER_OF_POODFB_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOFeedBackTest_TREND ADD constraint PK_SBOFeedBackTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOFeedBackTest_THRESH;
CREATE TABLE SBOFeedBackTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_FEEDBACK_MIN VARCHAR(256) NOT NULL,
TOTAL_FEEDBACK_MAX VARCHAR(256) NOT NULL,
TOTAL_GOODFEEDBACK_MIN VARCHAR(256) NOT NULL,
TOTAL_GOODFEEDBACK_MAX VARCHAR(256) NOT NULL,
TOTAL_POORFEEDBACK_MIN VARCHAR(256) NOT NULL,
TOTAL_POORFEEDBACK_MAX VARCHAR(256) NOT NULL,
TOTAL_AVOIDFEEDBACK_MIN VARCHAR(256) NOT NULL,
TOTAL_AVOIDFEEDBACK_MAX VARCHAR(256) NOT NULL,
PER_OF_GOODFB_MIN VARCHAR(256) NOT NULL,
PER_OF_GOODFB_MAX VARCHAR(256) NOT NULL,
PER_OF_POODFB_MIN VARCHAR(256) NOT NULL,
PER_OF_POODFB_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOFeedBackTest_THRESH ADD constraint PK_SBOFeedBackTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOFeedBackTest_THRESH ON SBOFeedBackTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOFeedBackTest ON SBOFeedBackTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOFeedBackTest ON SBOFeedBackTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOCallConnTest;
CREATE TABLE SBOCallConnTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CALLS_INITIATED DECIMAL(20,4) NOT NULL,
CALLS_INITIATED_ST varchar(32) NOT NULL,
CALLS_COMPLETED DECIMAL(20,4) NOT NULL,
CALLS_COMPLETED_ST varchar(32) NOT NULL,
CALLS_FAILED DECIMAL(20,4) NOT NULL,
CALLS_FAILED_ST varchar(32) NOT NULL,
CONN_CHECKS_STATUS DECIMAL(20,4) NOT NULL,
CONN_CHECKS_STATUS_ST varchar(32) NOT NULL,
PACKT_LOSS_RATE DECIMAL(20,4) NOT NULL,
PACKT_LOSS_RATE_ST varchar(32) NOT NULL,
RTT_LATENCY DECIMAL(20,4) NOT NULL,
RTT_LATENCY_ST varchar(32) NOT NULL,
JITTER DECIMAL(20,4) NOT NULL,
JITTER_ST varchar(32) NOT NULL,
PACKT_REORDER_RATIO DECIMAL(20,4) NOT NULL,
PACKT_REORDER_RATIO_ST varchar(32) NOT NULL,
MOS_SCORE DECIMAL(20,4) NOT NULL,
MOS_SCORE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOCallConnTest ON SBOCallConnTest(MSMT_TIME);
ALTER TABLE SBOCallConnTest ADD constraint PK_SBOCallConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOCallConnTest_TREND;
CREATE TABLE SBOCallConnTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CALLS_INITIATED_MIN DECIMAL(20,4) NOT NULL,
CALLS_INITIATED_MAX DECIMAL(20,4) NOT NULL,
CALLS_INITIATED_STCNT varchar(32) NOT NULL,
CALLS_COMPLETED_MIN DECIMAL(20,4) NOT NULL,
CALLS_COMPLETED_MAX DECIMAL(20,4) NOT NULL,
CALLS_COMPLETED_STCNT varchar(32) NOT NULL,
CALLS_FAILED_MIN DECIMAL(20,4) NOT NULL,
CALLS_FAILED_MAX DECIMAL(20,4) NOT NULL,
CALLS_FAILED_STCNT varchar(32) NOT NULL,
CONN_CHECKS_STATUS_MIN DECIMAL(20,4) NOT NULL,
CONN_CHECKS_STATUS_MAX DECIMAL(20,4) NOT NULL,
CONN_CHECKS_STATUS_STCNT varchar(32) NOT NULL,
PACKT_LOSS_RATE_MIN DECIMAL(20,4) NOT NULL,
PACKT_LOSS_RATE_MAX DECIMAL(20,4) NOT NULL,
PACKT_LOSS_RATE_STCNT varchar(32) NOT NULL,
RTT_LATENCY_MIN DECIMAL(20,4) NOT NULL,
RTT_LATENCY_MAX DECIMAL(20,4) NOT NULL,
RTT_LATENCY_STCNT varchar(32) NOT NULL,
JITTER_MIN DECIMAL(20,4) NOT NULL,
JITTER_MAX DECIMAL(20,4) NOT NULL,
JITTER_STCNT varchar(32) NOT NULL,
PACKT_REORDER_RATIO_MIN DECIMAL(20,4) NOT NULL,
PACKT_REORDER_RATIO_MAX DECIMAL(20,4) NOT NULL,
PACKT_REORDER_RATIO_STCNT varchar(32) NOT NULL,
MOS_SCORE_MIN DECIMAL(20,4) NOT NULL,
MOS_SCORE_MAX DECIMAL(20,4) NOT NULL,
MOS_SCORE_STCNT varchar(32) NOT NULL);


ALTER TABLE SBOCallConnTest_TREND ADD constraint PK_SBOCallConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOCallConnTest_THRESH;
CREATE TABLE SBOCallConnTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CALLS_INITIATED_MIN VARCHAR(256) NOT NULL,
CALLS_INITIATED_MAX VARCHAR(256) NOT NULL,
CALLS_COMPLETED_MIN VARCHAR(256) NOT NULL,
CALLS_COMPLETED_MAX VARCHAR(256) NOT NULL,
CALLS_FAILED_MIN VARCHAR(256) NOT NULL,
CALLS_FAILED_MAX VARCHAR(256) NOT NULL,
CONN_CHECKS_STATUS_MIN VARCHAR(256) NOT NULL,
CONN_CHECKS_STATUS_MAX VARCHAR(256) NOT NULL,
PACKT_LOSS_RATE_MIN VARCHAR(256) NOT NULL,
PACKT_LOSS_RATE_MAX VARCHAR(256) NOT NULL,
RTT_LATENCY_MIN VARCHAR(256) NOT NULL,
RTT_LATENCY_MAX VARCHAR(256) NOT NULL,
JITTER_MIN VARCHAR(256) NOT NULL,
JITTER_MAX VARCHAR(256) NOT NULL,
PACKT_REORDER_RATIO_MIN VARCHAR(256) NOT NULL,
PACKT_REORDER_RATIO_MAX VARCHAR(256) NOT NULL,
MOS_SCORE_MIN VARCHAR(256) NOT NULL,
MOS_SCORE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOCallConnTest_THRESH ADD constraint PK_SBOCallCnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOCallCnTest_THRESH ON SBOCallConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOCallCnTest ON SBOCallConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOCallCnTest ON SBOCallConnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSesDomainsTest;
CREATE TABLE SBOSesDomainsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
domaincnt DECIMAL(20,4) NOT NULL,
domaincnt_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOSesDomainsTest ON SBOSesDomainsTest(MSMT_TIME);
ALTER TABLE SBOSesDomainsTest ADD constraint PK_SBOSesDomainsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSesDomainsTest_TREND;
CREATE TABLE SBOSesDomainsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
domaincnt_MIN DECIMAL(20,4) NOT NULL,
domaincnt_MAX DECIMAL(20,4) NOT NULL,
domaincnt_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOSesDomainsTest_TREND ADD constraint PK_SBOSesDomainsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSesDomainsTest_THRESH;
CREATE TABLE SBOSesDomainsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
domaincnt_MIN VARCHAR(256) NOT NULL,
domaincnt_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOSesDomainsTest_THRESH ADD constraint PK_SBOSesDomainsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSesDomainsTest_THRESH ON SBOSesDomainsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSesDomainsTest ON SBOSesDomainsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSesDomainsTest ON SBOSesDomainsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOAppshrngQltyTest;
CREATE TABLE SBOAppshrngQltyTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
totalclsCnt DECIMAL(20,4) NOT NULL,
totalclsCnt_ST varchar(32) NOT NULL,
Currentcals DECIMAL(20,4) NOT NULL,
Currentcals_ST varchar(32) NOT NULL,
poorCalsCnt DECIMAL(20,4) NOT NULL,
poorCalsCnt_ST varchar(32) NOT NULL,
poorCalsPerc DECIMAL(20,4) NOT NULL,
poorCalsPerc_ST varchar(32) NOT NULL,
failedCalsCnt DECIMAL(20,4) NOT NULL,
failedCalsCnt_ST varchar(32) NOT NULL,
failedClsPerct DECIMAL(20,4) NOT NULL,
failedClsPerct_ST varchar(32) NOT NULL,
longCalsCnt DECIMAL(20,4) NOT NULL,
longCalsCnt_ST varchar(32) NOT NULL,
totaldurtn DECIMAL(20,4) NOT NULL,
totaldurtn_ST varchar(32) NOT NULL,
totalcnfcals DECIMAL(20,4) NOT NULL,
totalcnfcals_ST varchar(32) NOT NULL,
CnfOrgUsrCnt DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar(32) NOT NULL,
CnfPartUsrCnt DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar(32) NOT NULL,
BandWdUsage DECIMAL(20,4) NOT NULL,
BandWdUsage_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOAppshrngQltyTest ON SBOAppshrngQltyTest(MSMT_TIME);
ALTER TABLE SBOAppshrngQltyTest ADD constraint PK_SBOAppshrngQltyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOAppshrngQltyTest_TREND;
CREATE TABLE SBOAppshrngQltyTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
totalclsCnt_MIN DECIMAL(20,4) NOT NULL,
totalclsCnt_MAX DECIMAL(20,4) NOT NULL,
totalclsCnt_STCNT varchar(32) NOT NULL,
Currentcals_MIN DECIMAL(20,4) NOT NULL,
Currentcals_MAX DECIMAL(20,4) NOT NULL,
Currentcals_STCNT varchar(32) NOT NULL,
poorCalsCnt_MIN DECIMAL(20,4) NOT NULL,
poorCalsCnt_MAX DECIMAL(20,4) NOT NULL,
poorCalsCnt_STCNT varchar(32) NOT NULL,
poorCalsPerc_MIN DECIMAL(20,4) NOT NULL,
poorCalsPerc_MAX DECIMAL(20,4) NOT NULL,
poorCalsPerc_STCNT varchar(32) NOT NULL,
failedCalsCnt_MIN DECIMAL(20,4) NOT NULL,
failedCalsCnt_MAX DECIMAL(20,4) NOT NULL,
failedCalsCnt_STCNT varchar(32) NOT NULL,
failedClsPerct_MIN DECIMAL(20,4) NOT NULL,
failedClsPerct_MAX DECIMAL(20,4) NOT NULL,
failedClsPerct_STCNT varchar(32) NOT NULL,
longCalsCnt_MIN DECIMAL(20,4) NOT NULL,
longCalsCnt_MAX DECIMAL(20,4) NOT NULL,
longCalsCnt_STCNT varchar(32) NOT NULL,
totaldurtn_MIN DECIMAL(20,4) NOT NULL,
totaldurtn_MAX DECIMAL(20,4) NOT NULL,
totaldurtn_STCNT varchar(32) NOT NULL,
totalcnfcals_MIN DECIMAL(20,4) NOT NULL,
totalcnfcals_MAX DECIMAL(20,4) NOT NULL,
totalcnfcals_STCNT varchar(32) NOT NULL,
CnfOrgUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar(32) NOT NULL,
CnfPartUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar(32) NOT NULL,
BandWdUsage_MIN DECIMAL(20,4) NOT NULL,
BandWdUsage_MAX DECIMAL(20,4) NOT NULL,
BandWdUsage_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOAppshrngQltyTest_TREND ADD constraint PK_SBOAppshrngQltyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOAppshrngQltyTest_THRESH;
CREATE TABLE SBOAppshrngQltyTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
totalclsCnt_MIN VARCHAR(256) NOT NULL,
totalclsCnt_MAX VARCHAR(256) NOT NULL,
Currentcals_MIN VARCHAR(256) NOT NULL,
Currentcals_MAX VARCHAR(256) NOT NULL,
poorCalsCnt_MIN VARCHAR(256) NOT NULL,
poorCalsCnt_MAX VARCHAR(256) NOT NULL,
poorCalsPerc_MIN VARCHAR(256) NOT NULL,
poorCalsPerc_MAX VARCHAR(256) NOT NULL,
failedCalsCnt_MIN VARCHAR(256) NOT NULL,
failedCalsCnt_MAX VARCHAR(256) NOT NULL,
failedClsPerct_MIN VARCHAR(256) NOT NULL,
failedClsPerct_MAX VARCHAR(256) NOT NULL,
longCalsCnt_MIN VARCHAR(256) NOT NULL,
longCalsCnt_MAX VARCHAR(256) NOT NULL,
totaldurtn_MIN VARCHAR(256) NOT NULL,
totaldurtn_MAX VARCHAR(256) NOT NULL,
totalcnfcals_MIN VARCHAR(256) NOT NULL,
totalcnfcals_MAX VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR(256) NOT NULL,
BandWdUsage_MIN VARCHAR(256) NOT NULL,
BandWdUsage_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOAppshrngQltyTest_THRESH ADD constraint PK_SBOAppshrngQltyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOAppshrngQltyTest_THRESH ON SBOAppshrngQltyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOAppshrngQltyTest ON SBOAppshrngQltyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOAppshrngQltyTest ON SBOAppshrngQltyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOusersbydevsTest;
CREATE TABLE SBOusersbydevsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Uniq_user DECIMAL(20,4) NOT NULL,
Uniq_user_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOusersbydevsTest ON SBOusersbydevsTest(MSMT_TIME);
ALTER TABLE SBOusersbydevsTest ADD constraint PK_SBOusersbydevsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOusersbydevsTest_TREND;
CREATE TABLE SBOusersbydevsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Uniq_user_MIN DECIMAL(20,4) NOT NULL,
Uniq_user_MAX DECIMAL(20,4) NOT NULL,
Uniq_user_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOusersbydevsTest_TREND ADD constraint PK_SBOusersbydevsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOusersbydevsTest_THRESH;
CREATE TABLE SBOusersbydevsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Uniq_user_MIN VARCHAR(256) NOT NULL,
Uniq_user_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOusersbydevsTest_THRESH ADD constraint PK_SBOusersbydevsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOusersbydevsTest_THRESH ON SBOusersbydevsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOusersbydevsTest ON SBOusersbydevsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOusersbydevsTest ON SBOusersbydevsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOImFileSesnTest;
CREATE TABLE SBOImFileSesnTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
totalclsCnt DECIMAL(20,4) NOT NULL,
totalclsCnt_ST varchar(32) NOT NULL,
Currentcals DECIMAL(20,4) NOT NULL,
Currentcals_ST varchar(32) NOT NULL,
totaldurtn DECIMAL(20,4) NOT NULL,
totaldurtn_ST varchar(32) NOT NULL,
totalcnfcals DECIMAL(20,4) NOT NULL,
totalcnfcals_ST varchar(32) NOT NULL,
CnfOrgUsrCnt DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar(32) NOT NULL,
CnfPartUsrCnt DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar(32) NOT NULL,
filetransfers DECIMAL(20,4) NOT NULL,
filetransfers_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOImFileSesnTest ON SBOImFileSesnTest(MSMT_TIME);
ALTER TABLE SBOImFileSesnTest ADD constraint PK_SBOImFileSesnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOImFileSesnTest_TREND;
CREATE TABLE SBOImFileSesnTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
totalclsCnt_MIN DECIMAL(20,4) NOT NULL,
totalclsCnt_MAX DECIMAL(20,4) NOT NULL,
totalclsCnt_STCNT varchar(32) NOT NULL,
Currentcals_MIN DECIMAL(20,4) NOT NULL,
Currentcals_MAX DECIMAL(20,4) NOT NULL,
Currentcals_STCNT varchar(32) NOT NULL,
totaldurtn_MIN DECIMAL(20,4) NOT NULL,
totaldurtn_MAX DECIMAL(20,4) NOT NULL,
totaldurtn_STCNT varchar(32) NOT NULL,
totalcnfcals_MIN DECIMAL(20,4) NOT NULL,
totalcnfcals_MAX DECIMAL(20,4) NOT NULL,
totalcnfcals_STCNT varchar(32) NOT NULL,
CnfOrgUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar(32) NOT NULL,
CnfPartUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar(32) NOT NULL,
filetransfers_MIN DECIMAL(20,4) NOT NULL,
filetransfers_MAX DECIMAL(20,4) NOT NULL,
filetransfers_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOImFileSesnTest_TREND ADD constraint PK_SBOImFileSesnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOImFileSesnTest_THRESH;
CREATE TABLE SBOImFileSesnTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
totalclsCnt_MIN VARCHAR(256) NOT NULL,
totalclsCnt_MAX VARCHAR(256) NOT NULL,
Currentcals_MIN VARCHAR(256) NOT NULL,
Currentcals_MAX VARCHAR(256) NOT NULL,
totaldurtn_MIN VARCHAR(256) NOT NULL,
totaldurtn_MAX VARCHAR(256) NOT NULL,
totalcnfcals_MIN VARCHAR(256) NOT NULL,
totalcnfcals_MAX VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR(256) NOT NULL,
filetransfers_MIN VARCHAR(256) NOT NULL,
filetransfers_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOImFileSesnTest_THRESH ADD constraint PK_SBOImFileSesnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOImFileSesnTest_THRESH ON SBOImFileSesnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOImFileSesnTest ON SBOImFileSesnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOImFileSesnTest ON SBOImFileSesnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOVidCalQlityTest;
CREATE TABLE SBOVidCalQlityTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
totalclsCnt DECIMAL(20,4) NOT NULL,
totalclsCnt_ST varchar(32) NOT NULL,
Currentcals DECIMAL(20,4) NOT NULL,
Currentcals_ST varchar(32) NOT NULL,
poorCalsCnt DECIMAL(20,4) NOT NULL,
poorCalsCnt_ST varchar(32) NOT NULL,
poorCalsPerc DECIMAL(20,4) NOT NULL,
poorCalsPerc_ST varchar(32) NOT NULL,
failedCalsCnt DECIMAL(20,4) NOT NULL,
failedCalsCnt_ST varchar(32) NOT NULL,
failedClsPerct DECIMAL(20,4) NOT NULL,
failedClsPerct_ST varchar(32) NOT NULL,
longCalsCnt DECIMAL(20,4) NOT NULL,
longCalsCnt_ST varchar(32) NOT NULL,
totaldurtn DECIMAL(20,4) NOT NULL,
totaldurtn_ST varchar(32) NOT NULL,
totalcnfcals DECIMAL(20,4) NOT NULL,
totalcnfcals_ST varchar(32) NOT NULL,
CnfOrgUsrCnt DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar(32) NOT NULL,
CnfPartUsrCnt DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar(32) NOT NULL,
BandWdUsage DECIMAL(20,4) NOT NULL,
BandWdUsage_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOVidCalQlityTest ON SBOVidCalQlityTest(MSMT_TIME);
ALTER TABLE SBOVidCalQlityTest ADD constraint PK_SBOVidCalQlityTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOVidCalQlityTest_TREND;
CREATE TABLE SBOVidCalQlityTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
totalclsCnt_MIN DECIMAL(20,4) NOT NULL,
totalclsCnt_MAX DECIMAL(20,4) NOT NULL,
totalclsCnt_STCNT varchar(32) NOT NULL,
Currentcals_MIN DECIMAL(20,4) NOT NULL,
Currentcals_MAX DECIMAL(20,4) NOT NULL,
Currentcals_STCNT varchar(32) NOT NULL,
poorCalsCnt_MIN DECIMAL(20,4) NOT NULL,
poorCalsCnt_MAX DECIMAL(20,4) NOT NULL,
poorCalsCnt_STCNT varchar(32) NOT NULL,
poorCalsPerc_MIN DECIMAL(20,4) NOT NULL,
poorCalsPerc_MAX DECIMAL(20,4) NOT NULL,
poorCalsPerc_STCNT varchar(32) NOT NULL,
failedCalsCnt_MIN DECIMAL(20,4) NOT NULL,
failedCalsCnt_MAX DECIMAL(20,4) NOT NULL,
failedCalsCnt_STCNT varchar(32) NOT NULL,
failedClsPerct_MIN DECIMAL(20,4) NOT NULL,
failedClsPerct_MAX DECIMAL(20,4) NOT NULL,
failedClsPerct_STCNT varchar(32) NOT NULL,
longCalsCnt_MIN DECIMAL(20,4) NOT NULL,
longCalsCnt_MAX DECIMAL(20,4) NOT NULL,
longCalsCnt_STCNT varchar(32) NOT NULL,
totaldurtn_MIN DECIMAL(20,4) NOT NULL,
totaldurtn_MAX DECIMAL(20,4) NOT NULL,
totaldurtn_STCNT varchar(32) NOT NULL,
totalcnfcals_MIN DECIMAL(20,4) NOT NULL,
totalcnfcals_MAX DECIMAL(20,4) NOT NULL,
totalcnfcals_STCNT varchar(32) NOT NULL,
CnfOrgUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar(32) NOT NULL,
CnfPartUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar(32) NOT NULL,
BandWdUsage_MIN DECIMAL(20,4) NOT NULL,
BandWdUsage_MAX DECIMAL(20,4) NOT NULL,
BandWdUsage_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOVidCalQlityTest_TREND ADD constraint PK_SBOVidCalQlityTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOVidCalQlityTest_THRESH;
CREATE TABLE SBOVidCalQlityTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
totalclsCnt_MIN VARCHAR(256) NOT NULL,
totalclsCnt_MAX VARCHAR(256) NOT NULL,
Currentcals_MIN VARCHAR(256) NOT NULL,
Currentcals_MAX VARCHAR(256) NOT NULL,
poorCalsCnt_MIN VARCHAR(256) NOT NULL,
poorCalsCnt_MAX VARCHAR(256) NOT NULL,
poorCalsPerc_MIN VARCHAR(256) NOT NULL,
poorCalsPerc_MAX VARCHAR(256) NOT NULL,
failedCalsCnt_MIN VARCHAR(256) NOT NULL,
failedCalsCnt_MAX VARCHAR(256) NOT NULL,
failedClsPerct_MIN VARCHAR(256) NOT NULL,
failedClsPerct_MAX VARCHAR(256) NOT NULL,
longCalsCnt_MIN VARCHAR(256) NOT NULL,
longCalsCnt_MAX VARCHAR(256) NOT NULL,
totaldurtn_MIN VARCHAR(256) NOT NULL,
totaldurtn_MAX VARCHAR(256) NOT NULL,
totalcnfcals_MIN VARCHAR(256) NOT NULL,
totalcnfcals_MAX VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR(256) NOT NULL,
BandWdUsage_MIN VARCHAR(256) NOT NULL,
BandWdUsage_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOVidCalQlityTest_THRESH ADD constraint PK_SBOVidCalQlityTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOVidCalQlityTest_THRESH ON SBOVidCalQlityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOVidCalQlityTest ON SBOVidCalQlityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOVidCalQlityTest ON SBOVidCalQlityTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE SBOAudCalQltyTest;
CREATE TABLE SBOAudCalQltyTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
totalclsCnt DECIMAL(20,4) NOT NULL,
totalclsCnt_ST varchar(32) NOT NULL,
Currentcals DECIMAL(20,4) NOT NULL,
Currentcals_ST varchar(32) NOT NULL,
poorCalsCnt DECIMAL(20,4) NOT NULL,
poorCalsCnt_ST varchar(32) NOT NULL,
poorCalsPerc DECIMAL(20,4) NOT NULL,
poorCalsPerc_ST varchar(32) NOT NULL,
failedCalsCnt DECIMAL(20,4) NOT NULL,
failedCalsCnt_ST varchar(32) NOT NULL,
failedClsPerct DECIMAL(20,4) NOT NULL,
failedClsPerct_ST varchar(32) NOT NULL,
longCalsCnt DECIMAL(20,4) NOT NULL,
longCalsCnt_ST varchar(32) NOT NULL,
totaldurtn DECIMAL(20,4) NOT NULL,
totaldurtn_ST varchar(32) NOT NULL,
totalcnfcals DECIMAL(20,4) NOT NULL,
totalcnfcals_ST varchar(32) NOT NULL,
CnfOrgUsrCnt DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar(32) NOT NULL,
CnfPartUsrCnt DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar(32) NOT NULL,
BandWdUsage DECIMAL(20,4) NOT NULL,
BandWdUsage_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOAudCalQltyTest ON SBOAudCalQltyTest(MSMT_TIME);
ALTER TABLE SBOAudCalQltyTest ADD constraint PK_SBOAudCalQltyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOAudCalQltyTest_TREND;
CREATE TABLE SBOAudCalQltyTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
totalclsCnt_MIN DECIMAL(20,4) NOT NULL,
totalclsCnt_MAX DECIMAL(20,4) NOT NULL,
totalclsCnt_STCNT varchar(32) NOT NULL,
Currentcals_MIN DECIMAL(20,4) NOT NULL,
Currentcals_MAX DECIMAL(20,4) NOT NULL,
Currentcals_STCNT varchar(32) NOT NULL,
poorCalsCnt_MIN DECIMAL(20,4) NOT NULL,
poorCalsCnt_MAX DECIMAL(20,4) NOT NULL,
poorCalsCnt_STCNT varchar(32) NOT NULL,
poorCalsPerc_MIN DECIMAL(20,4) NOT NULL,
poorCalsPerc_MAX DECIMAL(20,4) NOT NULL,
poorCalsPerc_STCNT varchar(32) NOT NULL,
failedCalsCnt_MIN DECIMAL(20,4) NOT NULL,
failedCalsCnt_MAX DECIMAL(20,4) NOT NULL,
failedCalsCnt_STCNT varchar(32) NOT NULL,
failedClsPerct_MIN DECIMAL(20,4) NOT NULL,
failedClsPerct_MAX DECIMAL(20,4) NOT NULL,
failedClsPerct_STCNT varchar(32) NOT NULL,
longCalsCnt_MIN DECIMAL(20,4) NOT NULL,
longCalsCnt_MAX DECIMAL(20,4) NOT NULL,
longCalsCnt_STCNT varchar(32) NOT NULL,
totaldurtn_MIN DECIMAL(20,4) NOT NULL,
totaldurtn_MAX DECIMAL(20,4) NOT NULL,
totaldurtn_STCNT varchar(32) NOT NULL,
totalcnfcals_MIN DECIMAL(20,4) NOT NULL,
totalcnfcals_MAX DECIMAL(20,4) NOT NULL,
totalcnfcals_STCNT varchar(32) NOT NULL,
CnfOrgUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar(32) NOT NULL,
CnfPartUsrCnt_MIN DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_MAX DECIMAL(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar(32) NOT NULL,
BandWdUsage_MIN DECIMAL(20,4) NOT NULL,
BandWdUsage_MAX DECIMAL(20,4) NOT NULL,
BandWdUsage_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOAudCalQltyTest_TREND ADD constraint PK_SBOAudCalQltyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOAudCalQltyTest_THRESH;
CREATE TABLE SBOAudCalQltyTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
totalclsCnt_MIN VARCHAR(256) NOT NULL,
totalclsCnt_MAX VARCHAR(256) NOT NULL,
Currentcals_MIN VARCHAR(256) NOT NULL,
Currentcals_MAX VARCHAR(256) NOT NULL,
poorCalsCnt_MIN VARCHAR(256) NOT NULL,
poorCalsCnt_MAX VARCHAR(256) NOT NULL,
poorCalsPerc_MIN VARCHAR(256) NOT NULL,
poorCalsPerc_MAX VARCHAR(256) NOT NULL,
failedCalsCnt_MIN VARCHAR(256) NOT NULL,
failedCalsCnt_MAX VARCHAR(256) NOT NULL,
failedClsPerct_MIN VARCHAR(256) NOT NULL,
failedClsPerct_MAX VARCHAR(256) NOT NULL,
longCalsCnt_MIN VARCHAR(256) NOT NULL,
longCalsCnt_MAX VARCHAR(256) NOT NULL,
totaldurtn_MIN VARCHAR(256) NOT NULL,
totaldurtn_MAX VARCHAR(256) NOT NULL,
totalcnfcals_MIN VARCHAR(256) NOT NULL,
totalcnfcals_MAX VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR(256) NOT NULL,
BandWdUsage_MIN VARCHAR(256) NOT NULL,
BandWdUsage_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOAudCalQltyTest_THRESH ADD constraint PK_SBOAudCalQltyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOAudCalQltyTest_THRESH ON SBOAudCalQltyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOAudCalQltyTest ON SBOAudCalQltyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOAudCalQltyTest ON SBOAudCalQltyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOMsgCentTest;
CREATE TABLE SBOMsgCentTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MsgCenterCommunication DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOMsgCentTest ON SBOMsgCentTest(MSMT_TIME);
ALTER TABLE SBOMsgCentTest ADD constraint PK_SBOMsgCentTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOMsgCentTest_TREND;
CREATE TABLE SBOMsgCentTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MsgCenterCommunication_MIN DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_MAX DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOMsgCentTest_TREND ADD constraint PK_SBOMsgCentTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOMsgCentTest_THRESH;
CREATE TABLE SBOMsgCentTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MsgCenterCommunication_MIN VARCHAR(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOMsgCentTest_THRESH ADD constraint PK_SBOMsgCentTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOMsgCentTest_THRESH ON SBOMsgCentTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOMsgCentTest ON SBOMsgCentTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOMsgCentTest ON SBOMsgCentTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOConcStatusTest;
CREATE TABLE SBOConcStatusTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
status DECIMAL(20,4) NOT NULL,
status_ST varchar(32) NOT NULL,
pblmtcServ DECIMAL(20,4) NOT NULL,
pblmtcServ_ST varchar(32) NOT NULL,
reslvedSrvc DECIMAL(20,4) NOT NULL,
reslvedSrvc_ST varchar(32) NOT NULL);
CREATE INDEX IDX_SBOConcStatusTest ON SBOConcStatusTest(MSMT_TIME);
ALTER TABLE SBOConcStatusTest ADD constraint PK_SBOConcStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOConcStatusTest_TREND;
CREATE TABLE SBOConcStatusTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
status_MIN DECIMAL(20,4) NOT NULL,
status_MAX DECIMAL(20,4) NOT NULL,
status_STCNT varchar(32) NOT NULL,
pblmtcServ_MIN DECIMAL(20,4) NOT NULL,
pblmtcServ_MAX DECIMAL(20,4) NOT NULL,
pblmtcServ_STCNT varchar(32) NOT NULL,
reslvedSrvc_MIN DECIMAL(20,4) NOT NULL,
reslvedSrvc_MAX DECIMAL(20,4) NOT NULL,
reslvedSrvc_STCNT varchar(32) NOT NULL);
ALTER TABLE SBOConcStatusTest_TREND ADD constraint PK_SBOConcStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOConcStatusTest_THRESH;
CREATE TABLE SBOConcStatusTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
status_MIN VARCHAR(256) NOT NULL,
status_MAX VARCHAR(256) NOT NULL,
pblmtcServ_MIN VARCHAR(256) NOT NULL,
pblmtcServ_MAX VARCHAR(256) NOT NULL,
reslvedSrvc_MIN VARCHAR(256) NOT NULL,
reslvedSrvc_MAX VARCHAR(256) NOT NULL);
ALTER TABLE SBOConcStatusTest_THRESH ADD constraint PK_SBOConcStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOConcStatusTest_THRESH ON SBOConcStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOConcStatusTest ON SBOConcStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOConcStatusTest ON SBOConcStatusTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOConneChecksTest;
CREATE TABLE SBOConneChecksTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Connection_Status DECIMAL(20,4) NOT NULL,
Connection_Status_ST varchar(32) NOT NULL,
Time_taken_to_connect DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SBOConneChecksTest ON SBOConneChecksTest(MSMT_TIME);
ALTER TABLE SBOConneChecksTest ADD constraint PK_SBOConneChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOConneChecksTest_TREND;
CREATE TABLE SBOConneChecksTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Connection_Status_MIN DECIMAL(20,4) NOT NULL,
Connection_Status_MAX DECIMAL(20,4) NOT NULL,
Connection_Status_STCNT varchar(32) NOT NULL,
Time_taken_to_connect_MIN DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_MAX DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar(32) NOT NULL);

ALTER TABLE SBOConneChecksTest_TREND ADD constraint PK_SBOConneChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOConneChecksTest_THRESH;
CREATE TABLE SBOConneChecksTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Connection_Status_MIN VARCHAR(256) NOT NULL,
Connection_Status_MAX VARCHAR(256) NOT NULL,
Time_taken_to_connect_MIN VARCHAR(256) NOT NULL,
Time_taken_to_connect_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SBOConneChecksTest_THRESH ADD constraint PK_SBOConneChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOConneChecksTest_THRESH ON SBOConneChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOConneChecksTest ON SBOConneChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOConneChecksTest ON SBOConneChecksTest_TREND (MSMT_TIME,PERIOD);


 DROP TABLE SBOSrvcHlhTest;
 CREATE TABLE SBOSrvcHlhTest(
 TRGT_HOST       varchar(32) NOT NULL,
 PORT_NO         varchar(32) NOT NULL,
 SITE_NAME       varchar(64) NOT NULL,
 INFO            varchar(128) NOT NULL,
 MSMT_HOST       varchar(32) NOT NULL,
 MSMT_TIME       datetime NOT NULL,
 SERVICE_INCIDENTS DECIMAL(20,4) NOT NULL,
 SERVICE_INCIDENTS_ST varchar(32) NOT NULL,
 MAINTENANCE_EVENTS DECIMAL(20,4) NOT NULL,
 MAINTENANCE_EVENTS_ST varchar(32) NOT NULL,
 SERVICE_STATUS DECIMAL(20,4) NOT NULL,
 SERVICE_STATUS_ST varchar(32) NOT NULL);
 CREATE INDEX IDX_SBOSrvcHlhTest ON SBOSrvcHlhTest(MSMT_TIME);
 ALTER TABLE SBOSrvcHlhTest ADD constraint PK_SBOSrvcHlhTest PRIMARY KEY(
 TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
 DROP TABLE SBOSrvcHlhTest_TREND;
 CREATE TABLE SBOSrvcHlhTest_TREND(
 TRGT_HOST       varchar(32) NOT NULL,
 PORT_NO         varchar(32) NOT NULL,
 SITE_NAME       varchar(64) NOT NULL,
 INFO            varchar(128) NOT NULL,
 MSMT_HOST       varchar(32) NOT NULL,
 MSMT_TIME       datetime NOT NULL,
 PERIOD       	varchar(32) NOT NULL,
 SERVICE_INCIDENTS_MIN DECIMAL(20,4) NOT NULL,
 SERVICE_INCIDENTS_MAX DECIMAL(20,4) NOT NULL,
 SERVICE_INCIDENTS_STCNT varchar(32) NOT NULL,
 MAINTENANCE_EVENTS_MIN DECIMAL(20,4) NOT NULL,
 MAINTENANCE_EVENTS_MAX DECIMAL(20,4) NOT NULL,
 MAINTENANCE_EVENTS_STCNT varchar(32) NOT NULL,
 SERVICE_STATUS_MIN DECIMAL(20,4) NOT NULL,
 SERVICE_STATUS_MAX DECIMAL(20,4) NOT NULL,
 SERVICE_STATUS_STCNT varchar(32) NOT NULL);
 ALTER TABLE SBOSrvcHlhTest_TREND ADD constraint PK_SBOSrvcHlhTest_TREND PRIMARY KEY(
 TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
 DROP TABLE SBOSrvcHlhTest_THRESH;
 CREATE TABLE SBOSrvcHlhTest_THRESH(
 TRGT_HOST       varchar(32) NOT NULL,
 PORT_NO         varchar(32) NOT NULL,
 SITE_NAME       varchar(64) NOT NULL,
 INFO            varchar(128) NOT NULL,
 MSMT_HOST       varchar(32) NOT NULL,
 MSMT_TIME_START datetime NOT NULL,
 MSMT_TIME_END   datetime NOT NULL,
 SERVICE_INCIDENTS_MIN VARCHAR(256) NOT NULL,
 SERVICE_INCIDENTS_MAX VARCHAR(256) NOT NULL,
 MAINTENANCE_EVENTS_MIN VARCHAR(256) NOT NULL,
 MAINTENANCE_EVENTS_MAX VARCHAR(256) NOT NULL,
 SERVICE_STATUS_MIN VARCHAR(256) NOT NULL,
 SERVICE_STATUS_MAX VARCHAR(256) NOT NULL);
 ALTER TABLE SBOSrvcHlhTest_THRESH ADD constraint PK_SBOSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
 CREATE INDEX IDX_SBOSrvcHlhTest_THRESH ON SBOSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
 CREATE INDEX IDX_TH_SBOSrvcHlhTest ON SBOSrvcHlhTest_THRESH (MSMT_TIME_START);
 CREATE INDEX IDX_TR_SBOSrvcHlhTest ON SBOSrvcHlhTest_TREND (MSMT_TIME,PERIOD);
 
 
 DROP TABLE NginxZOPCacheTest;
CREATE TABLE NginxZOPCacheTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
OPCODE_CACHING DECIMAL(20,4) NOT NULL,
OPCODE_CACHING_ST varchar(32) NOT NULL,
OPTIMIZATION DECIMAL(20,4) NOT NULL,
OPTIMIZATION_ST varchar(32) NOT NULL,
CACHE_HITS DECIMAL(20,4) NOT NULL,
CACHE_HITS_ST varchar(32) NOT NULL,
CACHE_MISSES DECIMAL(20,4) NOT NULL,
CACHE_MISSES_ST varchar(32) NOT NULL,
CACHE_HIT_RATE DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATE_ST varchar(32) NOT NULL,
MISSES_RATIO DECIMAL(20,4) NOT NULL,
MISSES_RATIO_ST varchar(32) NOT NULL,
USED_MEMORY DECIMAL(20,4) NOT NULL,
USED_MEMORY_ST varchar(32) NOT NULL,
FREE_MEMORY DECIMAL(20,4) NOT NULL,
FREE_MEMORY_ST varchar(32) NOT NULL,
WASTED_MEMORY DECIMAL(20,4) NOT NULL,
WASTED_MEMORY_ST varchar(32) NOT NULL,
WASTED_MEM_PERC DECIMAL(20,4) NOT NULL,
WASTED_MEM_PERC_ST varchar(32) NOT NULL,
INTRN_STR_USEDMEM DECIMAL(20,4) NOT NULL,
INTRN_STR_USEDMEM_ST varchar(32) NOT NULL,
INTRN_STR_FREEMEM DECIMAL(20,4) NOT NULL,
INTRN_STR_FREEMEM_ST varchar(32) NOT NULL,
CACHED_SCRIPTS DECIMAL(20,4) NOT NULL,
CACHED_SCRIPTS_ST varchar(32) NOT NULL,
CACHED_KEYS DECIMAL(20,4) NOT NULL,
CACHED_KEYS_ST varchar(32) NOT NULL,
MAX_KEYS DECIMAL(20,4) NOT NULL,
MAX_KEYS_ST varchar(32) NOT NULL,
OOM_RESTARTS DECIMAL(20,4) NOT NULL,
OOM_RESTARTS_ST varchar(32) NOT NULL,
HASH_KEYS_RESTARTS DECIMAL(20,4) NOT NULL,
HASH_KEYS_RESTARTS_ST varchar(32) NOT NULL,
MANUAL_RESTARTS DECIMAL(20,4) NOT NULL,
MANUAL_RESTARTS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_NginxZOPCacheTest ON NginxZOPCacheTest(MSMT_TIME);
ALTER TABLE NginxZOPCacheTest ADD constraint PK_NginxZOPCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE NginxZOPCacheTest_TREND;
CREATE TABLE NginxZOPCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
OPCODE_CACHING_MIN DECIMAL(20,4) NOT NULL,
OPCODE_CACHING_MAX DECIMAL(20,4) NOT NULL,
OPCODE_CACHING_STCNT varchar(32) NOT NULL,
OPTIMIZATION_MIN DECIMAL(20,4) NOT NULL,
OPTIMIZATION_MAX DECIMAL(20,4) NOT NULL,
OPTIMIZATION_STCNT varchar(32) NOT NULL,
CACHE_HITS_MIN DECIMAL(20,4) NOT NULL,
CACHE_HITS_MAX DECIMAL(20,4) NOT NULL,
CACHE_HITS_STCNT varchar(32) NOT NULL,
CACHE_MISSES_MIN DECIMAL(20,4) NOT NULL,
CACHE_MISSES_MAX DECIMAL(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar(32) NOT NULL,
CACHE_HIT_RATE_MIN DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATE_MAX DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATE_STCNT varchar(32) NOT NULL,
MISSES_RATIO_MIN DECIMAL(20,4) NOT NULL,
MISSES_RATIO_MAX DECIMAL(20,4) NOT NULL,
MISSES_RATIO_STCNT varchar(32) NOT NULL,
USED_MEMORY_MIN DECIMAL(20,4) NOT NULL,
USED_MEMORY_MAX DECIMAL(20,4) NOT NULL,
USED_MEMORY_STCNT varchar(32) NOT NULL,
FREE_MEMORY_MIN DECIMAL(20,4) NOT NULL,
FREE_MEMORY_MAX DECIMAL(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar(32) NOT NULL,
WASTED_MEMORY_MIN DECIMAL(20,4) NOT NULL,
WASTED_MEMORY_MAX DECIMAL(20,4) NOT NULL,
WASTED_MEMORY_STCNT varchar(32) NOT NULL,
WASTED_MEM_PERC_MIN DECIMAL(20,4) NOT NULL,
WASTED_MEM_PERC_MAX DECIMAL(20,4) NOT NULL,
WASTED_MEM_PERC_STCNT varchar(32) NOT NULL,
INTRN_STR_USEDMEM_MIN DECIMAL(20,4) NOT NULL,
INTRN_STR_USEDMEM_MAX DECIMAL(20,4) NOT NULL,
INTRN_STR_USEDMEM_STCNT varchar(32) NOT NULL,
INTRN_STR_FREEMEM_MIN DECIMAL(20,4) NOT NULL,
INTRN_STR_FREEMEM_MAX DECIMAL(20,4) NOT NULL,
INTRN_STR_FREEMEM_STCNT varchar(32) NOT NULL,
CACHED_SCRIPTS_MIN DECIMAL(20,4) NOT NULL,
CACHED_SCRIPTS_MAX DECIMAL(20,4) NOT NULL,
CACHED_SCRIPTS_STCNT varchar(32) NOT NULL,
CACHED_KEYS_MIN DECIMAL(20,4) NOT NULL,
CACHED_KEYS_MAX DECIMAL(20,4) NOT NULL,
CACHED_KEYS_STCNT varchar(32) NOT NULL,
MAX_KEYS_MIN DECIMAL(20,4) NOT NULL,
MAX_KEYS_MAX DECIMAL(20,4) NOT NULL,
MAX_KEYS_STCNT varchar(32) NOT NULL,
OOM_RESTARTS_MIN DECIMAL(20,4) NOT NULL,
OOM_RESTARTS_MAX DECIMAL(20,4) NOT NULL,
OOM_RESTARTS_STCNT varchar(32) NOT NULL,
HASH_KEYS_RESTARTS_MIN DECIMAL(20,4) NOT NULL,
HASH_KEYS_RESTARTS_MAX DECIMAL(20,4) NOT NULL,
HASH_KEYS_RESTARTS_STCNT varchar(32) NOT NULL,
MANUAL_RESTARTS_MIN DECIMAL(20,4) NOT NULL,
MANUAL_RESTARTS_MAX DECIMAL(20,4) NOT NULL,
MANUAL_RESTARTS_STCNT varchar(32) NOT NULL);


ALTER TABLE NginxZOPCacheTest_TREND ADD constraint PK_NgZOPCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE NginxZOPCacheTest_THRESH;
CREATE TABLE NginxZOPCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
OPCODE_CACHING_MIN VARCHAR(256) NOT NULL,
OPCODE_CACHING_MAX VARCHAR(256) NOT NULL,
OPTIMIZATION_MIN VARCHAR(256) NOT NULL,
OPTIMIZATION_MAX VARCHAR(256) NOT NULL,
CACHE_HITS_MIN VARCHAR(256) NOT NULL,
CACHE_HITS_MAX VARCHAR(256) NOT NULL,
CACHE_MISSES_MIN VARCHAR(256) NOT NULL,
CACHE_MISSES_MAX VARCHAR(256) NOT NULL,
CACHE_HIT_RATE_MIN VARCHAR(256) NOT NULL,
CACHE_HIT_RATE_MAX VARCHAR(256) NOT NULL,
MISSES_RATIO_MIN VARCHAR(256) NOT NULL,
MISSES_RATIO_MAX VARCHAR(256) NOT NULL,
USED_MEMORY_MIN VARCHAR(256) NOT NULL,
USED_MEMORY_MAX VARCHAR(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR(256) NOT NULL,
WASTED_MEMORY_MIN VARCHAR(256) NOT NULL,
WASTED_MEMORY_MAX VARCHAR(256) NOT NULL,
WASTED_MEM_PERC_MIN VARCHAR(256) NOT NULL,
WASTED_MEM_PERC_MAX VARCHAR(256) NOT NULL,
INTRN_STR_USEDMEM_MIN VARCHAR(256) NOT NULL,
INTRN_STR_USEDMEM_MAX VARCHAR(256) NOT NULL,
INTRN_STR_FREEMEM_MIN VARCHAR(256) NOT NULL,
INTRN_STR_FREEMEM_MAX VARCHAR(256) NOT NULL,
CACHED_SCRIPTS_MIN VARCHAR(256) NOT NULL,
CACHED_SCRIPTS_MAX VARCHAR(256) NOT NULL,
CACHED_KEYS_MIN VARCHAR(256) NOT NULL,
CACHED_KEYS_MAX VARCHAR(256) NOT NULL,
MAX_KEYS_MIN VARCHAR(256) NOT NULL,
MAX_KEYS_MAX VARCHAR(256) NOT NULL,
OOM_RESTARTS_MIN VARCHAR(256) NOT NULL,
OOM_RESTARTS_MAX VARCHAR(256) NOT NULL,
HASH_KEYS_RESTARTS_MIN VARCHAR(256) NOT NULL,
HASH_KEYS_RESTARTS_MAX VARCHAR(256) NOT NULL,
MANUAL_RESTARTS_MIN VARCHAR(256) NOT NULL,
MANUAL_RESTARTS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE NginxZOPCacheTest_THRESH ADD constraint PK_NgZOPCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NgZOPCachTest_THRESH ON NginxZOPCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NginxZOPCacheTest ON NginxZOPCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NginxZOPCacheTest ON NginxZOPCacheTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE NginxPHPFPMTest;
CREATE TABLE NginxPHPFPMTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PRCS_MANAGER DECIMAL(20,4) NOT NULL,
PRCS_MANAGER_ST varchar(32) NOT NULL,
REQ_ACCPT DECIMAL(20,4) NOT NULL,
REQ_ACCPT_ST varchar(32) NOT NULL,
LISTEN_QUE DECIMAL(20,4) NOT NULL,
LISTEN_QUE_ST varchar(32) NOT NULL,
MAX_LISTN_QUE DECIMAL(20,4) NOT NULL,
MAX_LISTN_QUE_ST varchar(32) NOT NULL,
LISTN_QUE_LEN DECIMAL(20,4) NOT NULL,
LISTN_QUE_LEN_ST varchar(32) NOT NULL,
PCNT_LISTN_QUE_USG DECIMAL(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_ST varchar(32) NOT NULL,
IDLE_PROCS DECIMAL(20,4) NOT NULL,
IDLE_PROCS_ST varchar(32) NOT NULL,
ACTIV_PROCS DECIMAL(20,4) NOT NULL,
ACTIV_PROCS_ST varchar(32) NOT NULL,
TOT_PROCS DECIMAL(20,4) NOT NULL,
TOT_PROCS_ST varchar(32) NOT NULL,
PCNT_ACTIV_PROC DECIMAL(20,4) NOT NULL,
PCNT_ACTIV_PROC_ST varchar(32) NOT NULL,
MAX_ACTIV_PROC DECIMAL(20,4) NOT NULL,
MAX_ACTIV_PROC_ST varchar(32) NOT NULL,
MAX_CHILD_RCH DECIMAL(20,4) NOT NULL,
MAX_CHILD_RCH_ST varchar(32) NOT NULL,
SLOW_REQ DECIMAL(20,4) NOT NULL,
SLOW_REQ_ST varchar(32) NOT NULL);

CREATE INDEX IDX_NginxPHPFPMTest ON NginxPHPFPMTest(MSMT_TIME);
ALTER TABLE NginxPHPFPMTest ADD constraint PK_NginxPHPFPMTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE NginxPHPFPMTest_TREND;
CREATE TABLE NginxPHPFPMTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
PRCS_MANAGER_MIN DECIMAL(20,4) NOT NULL,
PRCS_MANAGER_MAX DECIMAL(20,4) NOT NULL,
PRCS_MANAGER_STCNT varchar(32) NOT NULL,
REQ_ACCPT_MIN DECIMAL(20,4) NOT NULL,
REQ_ACCPT_MAX DECIMAL(20,4) NOT NULL,
REQ_ACCPT_STCNT varchar(32) NOT NULL,
LISTEN_QUE_MIN DECIMAL(20,4) NOT NULL,
LISTEN_QUE_MAX DECIMAL(20,4) NOT NULL,
LISTEN_QUE_STCNT varchar(32) NOT NULL,
MAX_LISTN_QUE_MIN DECIMAL(20,4) NOT NULL,
MAX_LISTN_QUE_MAX DECIMAL(20,4) NOT NULL,
MAX_LISTN_QUE_STCNT varchar(32) NOT NULL,
LISTN_QUE_LEN_MIN DECIMAL(20,4) NOT NULL,
LISTN_QUE_LEN_MAX DECIMAL(20,4) NOT NULL,
LISTN_QUE_LEN_STCNT varchar(32) NOT NULL,
PCNT_LISTN_QUE_USG_MIN DECIMAL(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_MAX DECIMAL(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_STCNT varchar(32) NOT NULL,
IDLE_PROCS_MIN DECIMAL(20,4) NOT NULL,
IDLE_PROCS_MAX DECIMAL(20,4) NOT NULL,
IDLE_PROCS_STCNT varchar(32) NOT NULL,
ACTIV_PROCS_MIN DECIMAL(20,4) NOT NULL,
ACTIV_PROCS_MAX DECIMAL(20,4) NOT NULL,
ACTIV_PROCS_STCNT varchar(32) NOT NULL,
TOT_PROCS_MIN DECIMAL(20,4) NOT NULL,
TOT_PROCS_MAX DECIMAL(20,4) NOT NULL,
TOT_PROCS_STCNT varchar(32) NOT NULL,
PCNT_ACTIV_PROC_MIN DECIMAL(20,4) NOT NULL,
PCNT_ACTIV_PROC_MAX DECIMAL(20,4) NOT NULL,
PCNT_ACTIV_PROC_STCNT varchar(32) NOT NULL,
MAX_ACTIV_PROC_MIN DECIMAL(20,4) NOT NULL,
MAX_ACTIV_PROC_MAX DECIMAL(20,4) NOT NULL,
MAX_ACTIV_PROC_STCNT varchar(32) NOT NULL,
MAX_CHILD_RCH_MIN DECIMAL(20,4) NOT NULL,
MAX_CHILD_RCH_MAX DECIMAL(20,4) NOT NULL,
MAX_CHILD_RCH_STCNT varchar(32) NOT NULL,
SLOW_REQ_MIN DECIMAL(20,4) NOT NULL,
SLOW_REQ_MAX DECIMAL(20,4) NOT NULL,
SLOW_REQ_STCNT varchar(32) NOT NULL);

ALTER TABLE NginxPHPFPMTest_TREND ADD constraint PK_NginxPHPFPMTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE NginxPHPFPMTest_THRESH;
CREATE TABLE NginxPHPFPMTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
PRCS_MANAGER_MIN VARCHAR(256) NOT NULL,
PRCS_MANAGER_MAX VARCHAR(256) NOT NULL,
REQ_ACCPT_MIN VARCHAR(256) NOT NULL,
REQ_ACCPT_MAX VARCHAR(256) NOT NULL,
LISTEN_QUE_MIN VARCHAR(256) NOT NULL,
LISTEN_QUE_MAX VARCHAR(256) NOT NULL,
MAX_LISTN_QUE_MIN VARCHAR(256) NOT NULL,
MAX_LISTN_QUE_MAX VARCHAR(256) NOT NULL,
LISTN_QUE_LEN_MIN VARCHAR(256) NOT NULL,
LISTN_QUE_LEN_MAX VARCHAR(256) NOT NULL,
PCNT_LISTN_QUE_USG_MIN VARCHAR(256) NOT NULL,
PCNT_LISTN_QUE_USG_MAX VARCHAR(256) NOT NULL,
IDLE_PROCS_MIN VARCHAR(256) NOT NULL,
IDLE_PROCS_MAX VARCHAR(256) NOT NULL,
ACTIV_PROCS_MIN VARCHAR(256) NOT NULL,
ACTIV_PROCS_MAX VARCHAR(256) NOT NULL,
TOT_PROCS_MIN VARCHAR(256) NOT NULL,
TOT_PROCS_MAX VARCHAR(256) NOT NULL,
PCNT_ACTIV_PROC_MIN VARCHAR(256) NOT NULL,
PCNT_ACTIV_PROC_MAX VARCHAR(256) NOT NULL,
MAX_ACTIV_PROC_MIN VARCHAR(256) NOT NULL,
MAX_ACTIV_PROC_MAX VARCHAR(256) NOT NULL,
MAX_CHILD_RCH_MIN VARCHAR(256) NOT NULL,
MAX_CHILD_RCH_MAX VARCHAR(256) NOT NULL,
SLOW_REQ_MIN VARCHAR(256) NOT NULL,
SLOW_REQ_MAX VARCHAR(256) NOT NULL);

ALTER TABLE NginxPHPFPMTest_THRESH ADD constraint PK_NginxPHPFPMTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NginxPHPFPMTest_THRESH ON NginxPHPFPMTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NginxPHPFPMTest ON NginxPHPFPMTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NginxPHPFPMTest ON NginxPHPFPMTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SaaSNetworkTest;
CREATE TABLE SaaSNetworkTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AVG_DELAY DECIMAL(20,4) NOT NULL,
AVG_DELAY_ST varchar(32) NOT NULL,
MIN_DELAY DECIMAL(20,4) NOT NULL,
MIN_DELAY_ST varchar(32) NOT NULL,
PKT_LOSS_PCT DECIMAL(20,4) NOT NULL,
PKT_LOSS_PCT_ST varchar(32) NOT NULL,
AVAILABILITY DECIMAL(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SaaSNetworkTest ON SaaSNetworkTest(MSMT_TIME);
ALTER TABLE SaaSNetworkTest ADD constraint PK_SaaSNetworkTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SaaSNetworkTest_TREND;
CREATE TABLE SaaSNetworkTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVG_DELAY_MIN DECIMAL(20,4) NOT NULL,
AVG_DELAY_MAX DECIMAL(20,4) NOT NULL,
AVG_DELAY_STCNT varchar(32) NOT NULL,
MIN_DELAY_MIN DECIMAL(20,4) NOT NULL,
MIN_DELAY_MAX DECIMAL(20,4) NOT NULL,
MIN_DELAY_STCNT varchar(32) NOT NULL,
PKT_LOSS_PCT_MIN DECIMAL(20,4) NOT NULL,
PKT_LOSS_PCT_MAX DECIMAL(20,4) NOT NULL,
PKT_LOSS_PCT_STCNT varchar(32) NOT NULL,
AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL);

ALTER TABLE SaaSNetworkTest_TREND ADD constraint PK_SaaSNetworkTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SaaSNetworkTest_THRESH;
CREATE TABLE SaaSNetworkTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AVG_DELAY_MIN VARCHAR(256) NOT NULL,
AVG_DELAY_MAX VARCHAR(256) NOT NULL,
MIN_DELAY_MIN VARCHAR(256) NOT NULL,
MIN_DELAY_MAX VARCHAR(256) NOT NULL,
PKT_LOSS_PCT_MIN VARCHAR(256) NOT NULL,
PKT_LOSS_PCT_MAX VARCHAR(256) NOT NULL,
AVAILABILITY_MIN VARCHAR(256) NOT NULL,
AVAILABILITY_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SaaSNetworkTest_THRESH ADD constraint PK_SaaSNetworkTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SaaSNetworkTest_THRESH ON SaaSNetworkTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SaaSNetworkTest ON SaaSNetworkTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SaaSNetworkTest ON SaaSNetworkTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE O365SecurityGrpsTest;
CREATE TABLE O365SecurityGrpsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NEWLY_CREATED_GROUPS DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST varchar(32) NOT NULL,
SOFT_DELETED_GROUPS DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST varchar(32) NOT NULL,
TOTAL_GROUPS DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_ST varchar(32) NOT NULL,
ORPHANED_GROUPS DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_ST varchar(32) NOT NULL,
EMPTY_GROUPS DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365SecrtyGrpsTest ON O365SecurityGrpsTest(MSMT_TIME);
ALTER TABLE O365SecurityGrpsTest ADD constraint PK_O365SecrtyGrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SecurityGrpsTest_TREND;
CREATE TABLE O365SecurityGrpsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NEWLY_CREATED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT varchar(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT varchar(32) NOT NULL,
TOTAL_GROUPS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_STCNT varchar(32) NOT NULL,
ORPHANED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT varchar(32) NOT NULL,
EMPTY_GROUPS_MIN DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_MAX DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_STCNT varchar(32) NOT NULL);

ALTER TABLE O365SecurityGrpsTest_TREND ADD constraint PK_O365SecrtyGrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SecurityGrpsTest_THRESH;
CREATE TABLE O365SecurityGrpsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NEWLY_CREATED_GROUPS_MIN VARCHAR(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365SecurityGrpsTest_THRESH ADD constraint PK_O365SecrtyGrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SecrtyGrpsTest_THRESH ON O365SecurityGrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SecurityGrpsTest ON O365SecurityGrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SecurityGrpsTest ON O365SecurityGrpsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSiteConnectivityTest;
CREATE TABLE SPOSiteConnectivityTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
WEB_AVAILABILITY DECIMAL(20,4) NOT NULL,
WEB_AVAILABILITY_ST varchar(32) NOT NULL,
RESPONSE_CODE DECIMAL(20,4) NOT NULL,
RESPONSE_CODE_ST varchar(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL,
CONTENT_VALIDITY DECIMAL(20,4) NOT NULL,
CONTENT_VALIDITY_ST varchar(32) NOT NULL,
CONTENT_LENGTH DECIMAL(20,4) NOT NULL,
CONTENT_LENGTH_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOSiteConnTest ON SPOSiteConnectivityTest(MSMT_TIME);
ALTER TABLE SPOSiteConnectivityTest ADD constraint PK_SPOSiteConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteConnectivityTest_TREND;
CREATE TABLE SPOSiteConnectivityTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
WEB_AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
WEB_AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
WEB_AVAILABILITY_STCNT varchar(32) NOT NULL,
RESPONSE_CODE_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_CODE_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_CODE_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL,
CONTENT_VALIDITY_MIN DECIMAL(20,4) NOT NULL,
CONTENT_VALIDITY_MAX DECIMAL(20,4) NOT NULL,
CONTENT_VALIDITY_STCNT varchar(32) NOT NULL,
CONTENT_LENGTH_MIN DECIMAL(20,4) NOT NULL,
CONTENT_LENGTH_MAX DECIMAL(20,4) NOT NULL,
CONTENT_LENGTH_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOSiteConnectivityTest_TREND ADD constraint PK_SPOSiteConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteConnectivityTest_THRESH;
CREATE TABLE SPOSiteConnectivityTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
WEB_AVAILABILITY_MIN VARCHAR(256) NOT NULL,
WEB_AVAILABILITY_MAX VARCHAR(256) NOT NULL,
RESPONSE_CODE_MIN VARCHAR(256) NOT NULL,
RESPONSE_CODE_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL,
CONTENT_VALIDITY_MIN VARCHAR(256) NOT NULL,
CONTENT_VALIDITY_MAX VARCHAR(256) NOT NULL,
CONTENT_LENGTH_MIN VARCHAR(256) NOT NULL,
CONTENT_LENGTH_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOSiteConnectivityTest_THRESH ADD constraint PK_SPOSiteConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSiteConnTest_THRESH ON SPOSiteConnectivityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteConnTest ON SPOSiteConnectivityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteConnTest ON SPOSiteConnectivityTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365LoginTest;
CREATE TABLE O365LoginTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AUTHENTICATION_STATUS DECIMAL(20,4) NOT NULL,
AUTHENTICATION_STATUS_ST varchar(32) NOT NULL,
AUTHENTICATION_TIME DECIMAL(20,4) NOT NULL,
AUTHENTICATION_TIME_ST varchar(32) NOT NULL,
LOGIN_STATUS DECIMAL(20,4) NOT NULL,
LOGIN_STATUS_ST varchar(32) NOT NULL,
LOGIN_TIME DECIMAL(20,4) NOT NULL,
LOGIN_TIME_ST varchar(32) NOT NULL,
TOTAL_LOGIN_TIME DECIMAL(20,4) NOT NULL,
TOTAL_LOGIN_TIME_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365LoginTest ON O365LoginTest(MSMT_TIME);
ALTER TABLE O365LoginTest ADD constraint PK_O365LoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365LoginTest_TREND;
CREATE TABLE O365LoginTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AUTHENTICATION_STATUS_MIN DECIMAL(20,4) NOT NULL,
AUTHENTICATION_STATUS_MAX DECIMAL(20,4) NOT NULL,
AUTHENTICATION_STATUS_STCNT varchar(32) NOT NULL,
AUTHENTICATION_TIME_MIN DECIMAL(20,4) NOT NULL,
AUTHENTICATION_TIME_MAX DECIMAL(20,4) NOT NULL,
AUTHENTICATION_TIME_STCNT varchar(32) NOT NULL,
LOGIN_STATUS_MIN DECIMAL(20,4) NOT NULL,
LOGIN_STATUS_MAX DECIMAL(20,4) NOT NULL,
LOGIN_STATUS_STCNT varchar(32) NOT NULL,
LOGIN_TIME_MIN DECIMAL(20,4) NOT NULL,
LOGIN_TIME_MAX DECIMAL(20,4) NOT NULL,
LOGIN_TIME_STCNT varchar(32) NOT NULL,
TOTAL_LOGIN_TIME_MIN DECIMAL(20,4) NOT NULL,
TOTAL_LOGIN_TIME_MAX DECIMAL(20,4) NOT NULL,
TOTAL_LOGIN_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE O365LoginTest_TREND ADD constraint PK_O365LoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365LoginTest_THRESH;
CREATE TABLE O365LoginTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AUTHENTICATION_STATUS_MIN VARCHAR(256) NOT NULL,
AUTHENTICATION_STATUS_MAX VARCHAR(256) NOT NULL,
AUTHENTICATION_TIME_MIN VARCHAR(256) NOT NULL,
AUTHENTICATION_TIME_MAX VARCHAR(256) NOT NULL,
LOGIN_STATUS_MIN VARCHAR(256) NOT NULL,
LOGIN_STATUS_MAX VARCHAR(256) NOT NULL,
LOGIN_TIME_MIN VARCHAR(256) NOT NULL,
LOGIN_TIME_MAX VARCHAR(256) NOT NULL,
TOTAL_LOGIN_TIME_MIN VARCHAR(256) NOT NULL,
TOTAL_LOGIN_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365LoginTest_THRESH ADD constraint PK_O365LoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365LoginTest_THRESH ON O365LoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365LoginTest ON O365LoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365LoginTest ON O365LoginTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365DomainTest;
CREATE TABLE O365DomainTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AUTHENT DECIMAL(20,4) NOT NULL,
AUTHENT_ST varchar(32) NOT NULL,
CAP_CNT DECIMAL(20,4) NOT NULL,
CAP_CNT_ST varchar(32) NOT NULL,
ISDEFAULT DECIMAL(20,4) NOT NULL,
ISDEFAULT_ST varchar(32) NOT NULL,
ISINITIAL DECIMAL(20,4) NOT NULL,
ISINITIAL_ST varchar(32) NOT NULL,
STAT DECIMAL(20,4) NOT NULL,
STAT_ST varchar(32) NOT NULL,
VERIFMETHOD DECIMAL(20,4) NOT NULL,
VERIFMETHOD_ST varchar(32) NOT NULL,
ROOTDOM_CNT DECIMAL(20,4) NOT NULL,
ROOTDOM_CNT_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365DomainTest ON O365DomainTest(MSMT_TIME);
ALTER TABLE O365DomainTest ADD constraint PK_O365DomainTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DomainTest_TREND;
CREATE TABLE O365DomainTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AUTHENT_MIN DECIMAL(20,4) NOT NULL,
AUTHENT_MAX DECIMAL(20,4) NOT NULL,
AUTHENT_STCNT varchar(32) NOT NULL,
CAP_CNT_MIN DECIMAL(20,4) NOT NULL,
CAP_CNT_MAX DECIMAL(20,4) NOT NULL,
CAP_CNT_STCNT varchar(32) NOT NULL,
ISDEFAULT_MIN DECIMAL(20,4) NOT NULL,
ISDEFAULT_MAX DECIMAL(20,4) NOT NULL,
ISDEFAULT_STCNT varchar(32) NOT NULL,
ISINITIAL_MIN DECIMAL(20,4) NOT NULL,
ISINITIAL_MAX DECIMAL(20,4) NOT NULL,
ISINITIAL_STCNT varchar(32) NOT NULL,
STAT_MIN DECIMAL(20,4) NOT NULL,
STAT_MAX DECIMAL(20,4) NOT NULL,
STAT_STCNT varchar(32) NOT NULL,
VERIFMETHOD_MIN DECIMAL(20,4) NOT NULL,
VERIFMETHOD_MAX DECIMAL(20,4) NOT NULL,
VERIFMETHOD_STCNT varchar(32) NOT NULL,
ROOTDOM_CNT_MIN DECIMAL(20,4) NOT NULL,
ROOTDOM_CNT_MAX DECIMAL(20,4) NOT NULL,
ROOTDOM_CNT_STCNT varchar(32) NOT NULL);

ALTER TABLE O365DomainTest_TREND ADD constraint PK_O365DomainTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DomainTest_THRESH;
CREATE TABLE O365DomainTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AUTHENT_MIN VARCHAR(256) NOT NULL,
AUTHENT_MAX VARCHAR(256) NOT NULL,
CAP_CNT_MIN VARCHAR(256) NOT NULL,
CAP_CNT_MAX VARCHAR(256) NOT NULL,
ISDEFAULT_MIN VARCHAR(256) NOT NULL,
ISDEFAULT_MAX VARCHAR(256) NOT NULL,
ISINITIAL_MIN VARCHAR(256) NOT NULL,
ISINITIAL_MAX VARCHAR(256) NOT NULL,
STAT_MIN VARCHAR(256) NOT NULL,
STAT_MAX VARCHAR(256) NOT NULL,
VERIFMETHOD_MIN VARCHAR(256) NOT NULL,
VERIFMETHOD_MAX VARCHAR(256) NOT NULL,
ROOTDOM_CNT_MIN VARCHAR(256) NOT NULL,
ROOTDOM_CNT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365DomainTest_THRESH ADD constraint PK_O365DomainTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DomainTest_THRESH ON O365DomainTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DomainTest ON O365DomainTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DomainTest ON O365DomainTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE O365SRVPRVSTATS;
CREATE TABLE O365SRVPRVSTATS(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PNDING_ACTVTION DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_ST VARCHAR(32) NOT NULL,
PNDING_PRVISION DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_ST VARCHAR(32) NOT NULL,
PNDING_INPUT DECIMAL(20,4) NOT NULL,
PNDING_INPUT_ST VARCHAR(32) NOT NULL,
SUCCESS DECIMAL(20,4) NOT NULL,
SUCCESS_ST VARCHAR(32) NOT NULL,
DISABLED DECIMAL(20,4) NOT NULL,
DISABLED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_O365SRVPRVSTATS ON O365SRVPRVSTATS(MSMT_TIME);
ALTER TABLE O365SRVPRVSTATS ADD CONSTRAINT PK_O365SRVPRVSTATS PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SRVPRVSTATS_TREND;
CREATE TABLE O365SRVPRVSTATS_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
PNDING_ACTVTION_MIN DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_MAX DECIMAL(20,4) NOT NULL,
PNDING_ACTVTION_STCNT VARCHAR(32) NOT NULL,
PNDING_PRVISION_MIN DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_MAX DECIMAL(20,4) NOT NULL,
PNDING_PRVISION_STCNT VARCHAR(32) NOT NULL,
PNDING_INPUT_MIN DECIMAL(20,4) NOT NULL,
PNDING_INPUT_MAX DECIMAL(20,4) NOT NULL,
PNDING_INPUT_STCNT VARCHAR(32) NOT NULL,
SUCCESS_MIN DECIMAL(20,4) NOT NULL,
SUCCESS_MAX DECIMAL(20,4) NOT NULL,
SUCCESS_STCNT VARCHAR(32) NOT NULL,
DISABLED_MIN DECIMAL(20,4) NOT NULL,
DISABLED_MAX DECIMAL(20,4) NOT NULL,
DISABLED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE O365SRVPRVSTATS_TREND ADD CONSTRAINT PK_O365SRVPRVSTATS_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SRVPRVSTATS_THRESH;
CREATE TABLE O365SRVPRVSTATS_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
PNDING_ACTVTION_MIN VARCHAR(256) NOT NULL,
PNDING_ACTVTION_MAX VARCHAR(256) NOT NULL,
PNDING_PRVISION_MIN VARCHAR(256) NOT NULL,
PNDING_PRVISION_MAX VARCHAR(256) NOT NULL,
PNDING_INPUT_MIN VARCHAR(256) NOT NULL,
PNDING_INPUT_MAX VARCHAR(256) NOT NULL,
SUCCESS_MIN VARCHAR(256) NOT NULL,
SUCCESS_MAX VARCHAR(256) NOT NULL,
DISABLED_MIN VARCHAR(256) NOT NULL,
DISABLED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365SRVPRVSTATS_THRESH ADD CONSTRAINT PK_O365SRVPRVSTATS_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SRVPRVSTATS_THRESH ON O365SRVPRVSTATS_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SRVPRVSTATS ON O365SRVPRVSTATS_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SRVPRVSTATS ON O365SRVPRVSTATS_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UserActivTest;
CREATE TABLE O365UserActivTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
OPERATIONS DECIMAL(20,4) NOT NULL,
OPERATIONS_ST varchar(32) NOT NULL, 
Unique_oprs DECIMAL(20,4) NOT NULL,
Unique_oprs_ST varchar(32) NOT NULL,
Unique_users DECIMAL(20,4) NOT NULL,
Unique_users_ST varchar(32) NOT NULL, 
Unique_client_IPs DECIMAL(20,4) NOT NULL,
Unique_client_IPs_ST varchar(32) NOT NULL);
CREATE INDEX IDX_O365UserActivTest ON O365UserActivTest(MSMT_TIME);
ALTER TABLE O365UserActivTest ADD constraint PK_O365UserActivTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UserActivTest_TREND;
CREATE TABLE O365UserActivTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
OPERATIONS_STCNT varchar(32) NOT NULL,
Unique_oprs_MIN DECIMAL(20,4) NOT NULL,
Unique_oprs_MAX DECIMAL(20,4) NOT NULL,
Unique_oprs_STCNT varchar(32) NOT NULL,
Unique_users_MIN DECIMAL(20,4) NOT NULL,
Unique_users_MAX DECIMAL(20,4) NOT NULL,
Unique_users_STCNT varchar(32) NOT NULL,
Unique_client_IPs_MIN DECIMAL(20,4) NOT NULL,
Unique_client_IPs_MAX DECIMAL(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar(32) NOT NULL);
ALTER TABLE O365UserActivTest_TREND ADD constraint PK_O365UserActivTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UserActivTest_THRESH;
CREATE TABLE O365UserActivTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
OPERATIONS_MIN VARCHAR(256) NOT NULL,
OPERATIONS_MAX VARCHAR(256) NOT NULL,
Unique_oprs_MIN VARCHAR(256) NOT NULL,
Unique_oprs_MAX VARCHAR(256) NOT NULL,
Unique_users_MIN VARCHAR(256) NOT NULL,
Unique_users_MAX VARCHAR(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR(256) NOT NULL);
ALTER TABLE O365UserActivTest_THRESH ADD constraint PK_O365UserActivTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UserActivTest_THRESH ON O365UserActivTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UserActivTest ON O365UserActivTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UserActivTest ON O365UserActivTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UserLogtest;
CREATE TABLE O365UserLogtest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
UNLICENSED_USERS DECIMAL(20,4) NOT NULL,
UNLICENSED_USERS_ST varchar(32) NOT NULL,
DELETED_USERS DECIMAL(20,4) NOT NULL,
DELETED_USERS_ST varchar(32) NOT NULL,
PASSWORD_EXP DECIMAL(20,4) NOT NULL,
PASSWORD_EXP_ST varchar(32) NOT NULL,
ALLOWED_USERS DECIMAL(20,4) NOT NULL,
ALLOWED_USERS_ST varchar(32) NOT NULL,
BLOCKED_USERS DECIMAL(20,4) NOT NULL,
BLOCKED_USERS_ST varchar(32) NOT NULL,
USER_PWDEXPIRE DECIMAL(20,4) NOT NULL,
USER_PWDEXPIRE_ST varchar(32) NOT NULL,
TOTAL_USERS DECIMAL(20,4) NOT NULL,
TOTAL_USERS_ST varchar(32) NOT NULL,
LICENSED_USERS DECIMAL(20,4) NOT NULL,
LICENSED_USERS_ST varchar(32) NOT NULL,
MFA_ENABLED_USERS DECIMAL(20,4) NOT NULL,
MFA_ENABLED_USERS_ST varchar(32) NOT NULL,
MFA_ENFORCED_USERS DECIMAL(20,4) NOT NULL,
MFA_ENFORCED_USERS_ST varchar(32) NOT NULL,
MFA_DISABLED_USERS DECIMAL(20,4) NOT NULL,
MFA_DISABLED_USERS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365UserLogtest ON O365UserLogtest(MSMT_TIME);
ALTER TABLE O365UserLogtest ADD constraint PK_O365UserLogtest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UserLogtest_TREND;
CREATE TABLE O365UserLogtest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
UNLICENSED_USERS_MIN DECIMAL(20,4) NOT NULL,
UNLICENSED_USERS_MAX DECIMAL(20,4) NOT NULL,
UNLICENSED_USERS_STCNT varchar(32) NOT NULL,
DELETED_USERS_MIN DECIMAL(20,4) NOT NULL,
DELETED_USERS_MAX DECIMAL(20,4) NOT NULL,
DELETED_USERS_STCNT varchar(32) NOT NULL,
PASSWORD_EXP_MIN DECIMAL(20,4) NOT NULL,
PASSWORD_EXP_MAX DECIMAL(20,4) NOT NULL,
PASSWORD_EXP_STCNT varchar(32) NOT NULL,
ALLOWED_USERS_MIN DECIMAL(20,4) NOT NULL,
ALLOWED_USERS_MAX DECIMAL(20,4) NOT NULL,
ALLOWED_USERS_STCNT varchar(32) NOT NULL,
BLOCKED_USERS_MIN DECIMAL(20,4) NOT NULL,
BLOCKED_USERS_MAX DECIMAL(20,4) NOT NULL,
BLOCKED_USERS_STCNT varchar(32) NOT NULL,
USER_PWDEXPIRE_MIN DECIMAL(20,4) NOT NULL,
USER_PWDEXPIRE_MAX DECIMAL(20,4) NOT NULL,
USER_PWDEXPIRE_STCNT varchar(32) NOT NULL,
TOTAL_USERS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_USERS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_USERS_STCNT varchar(32) NOT NULL,
LICENSED_USERS_MIN DECIMAL(20,4) NOT NULL,
LICENSED_USERS_MAX DECIMAL(20,4) NOT NULL,
LICENSED_USERS_STCNT varchar(32) NOT NULL,
MFA_ENABLED_USERS_MIN DECIMAL(20,4) NOT NULL,
MFA_ENABLED_USERS_MAX DECIMAL(20,4) NOT NULL,
MFA_ENABLED_USERS_STCNT varchar(32) NOT NULL,
MFA_ENFORCED_USERS_MIN DECIMAL(20,4) NOT NULL,
MFA_ENFORCED_USERS_MAX DECIMAL(20,4) NOT NULL,
MFA_ENFORCED_USERS_STCNT varchar(32) NOT NULL,
MFA_DISABLED_USERS_MIN DECIMAL(20,4) NOT NULL,
MFA_DISABLED_USERS_MAX DECIMAL(20,4) NOT NULL,
MFA_DISABLED_USERS_STCNT varchar(32) NOT NULL);

ALTER TABLE O365UserLogtest_TREND ADD constraint PK_O365UserLogtest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UserLogtest_THRESH;
CREATE TABLE O365UserLogtest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
UNLICENSED_USERS_MIN VARCHAR(256) NOT NULL,
UNLICENSED_USERS_MAX VARCHAR(256) NOT NULL,
DELETED_USERS_MIN VARCHAR(256) NOT NULL,
DELETED_USERS_MAX VARCHAR(256) NOT NULL,
PASSWORD_EXP_MIN VARCHAR(256) NOT NULL,
PASSWORD_EXP_MAX VARCHAR(256) NOT NULL,
ALLOWED_USERS_MIN VARCHAR(256) NOT NULL,
ALLOWED_USERS_MAX VARCHAR(256) NOT NULL,
BLOCKED_USERS_MIN VARCHAR(256) NOT NULL,
BLOCKED_USERS_MAX VARCHAR(256) NOT NULL,
USER_PWDEXPIRE_MIN VARCHAR(256) NOT NULL,
USER_PWDEXPIRE_MAX VARCHAR(256) NOT NULL,
TOTAL_USERS_MIN VARCHAR(256) NOT NULL,
TOTAL_USERS_MAX VARCHAR(256) NOT NULL,
LICENSED_USERS_MIN VARCHAR(256) NOT NULL,
LICENSED_USERS_MAX VARCHAR(256) NOT NULL,
MFA_ENABLED_USERS_MIN VARCHAR(256) NOT NULL,
MFA_ENABLED_USERS_MAX VARCHAR(256) NOT NULL,
MFA_ENFORCED_USERS_MIN VARCHAR(256) NOT NULL,
MFA_ENFORCED_USERS_MAX VARCHAR(256) NOT NULL,
MFA_DISABLED_USERS_MIN VARCHAR(256) NOT NULL,
MFA_DISABLED_USERS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365UserLogtest_THRESH ADD constraint PK_O365UserLogtest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UserLogtest_THRESH ON O365UserLogtest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UserLogtest ON O365UserLogtest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UserLogtest ON O365UserLogtest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365LicnsUsgTest;
CREATE TABLE O365LicnsUsgTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
LICENSED_USERS DECIMAL(20,4) NOT NULL,
LICENSED_USERS_ST varchar(32) NOT NULL,
ACTIVE_UNITS DECIMAL(20,4) NOT NULL,
ACTIVE_UNITS_ST varchar(32) NOT NULL,
WARNING_UNITS DECIMAL(20,4) NOT NULL,
WARNING_UNITS_ST varchar(32) NOT NULL,
STATUS DECIMAL(20,4) NOT NULL,
STATUS_ST varchar(32) NOT NULL,
TRAIL DECIMAL(20,4) NOT NULL,
TRAIL_ST varchar(32) NOT NULL,
TOTAL_LICENSE DECIMAL(20,4) NOT NULL,
TOTAL_LICENSE_ST varchar(32) NOT NULL,
DAYS_TO_EXPIRE DECIMAL(20,4) NOT NULL,
DAYS_TO_EXPIRE_ST varchar(32) NOT NULL,
LICENSE_USAGE DECIMAL(20,4) NOT NULL,
LICENSE_USAGE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365LicnsUsgTest ON O365LicnsUsgTest(MSMT_TIME);
ALTER TABLE O365LicnsUsgTest ADD constraint PK_O365LicnsUsgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365LicnsUsgTest_TREND;
CREATE TABLE O365LicnsUsgTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
LICENSED_USERS_MIN DECIMAL(20,4) NOT NULL,
LICENSED_USERS_MAX DECIMAL(20,4) NOT NULL,
LICENSED_USERS_STCNT varchar(32) NOT NULL,
ACTIVE_UNITS_MIN DECIMAL(20,4) NOT NULL,
ACTIVE_UNITS_MAX DECIMAL(20,4) NOT NULL,
ACTIVE_UNITS_STCNT varchar(32) NOT NULL,
WARNING_UNITS_MIN DECIMAL(20,4) NOT NULL,
WARNING_UNITS_MAX DECIMAL(20,4) NOT NULL,
WARNING_UNITS_STCNT varchar(32) NOT NULL,
STATUS_MIN DECIMAL(20,4) NOT NULL,
STATUS_MAX DECIMAL(20,4) NOT NULL,
STATUS_STCNT varchar(32) NOT NULL,
TRAIL_MIN DECIMAL(20,4) NOT NULL,
TRAIL_MAX DECIMAL(20,4) NOT NULL,
TRAIL_STCNT varchar(32) NOT NULL,
TOTAL_LICENSE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_LICENSE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_LICENSE_STCNT varchar(32) NOT NULL,
DAYS_TO_EXPIRE_MIN DECIMAL(20,4) NOT NULL,
DAYS_TO_EXPIRE_MAX DECIMAL(20,4) NOT NULL,
DAYS_TO_EXPIRE_STCNT varchar(32) NOT NULL,
LICENSE_USAGE_MIN DECIMAL(20,4) NOT NULL,
LICENSE_USAGE_MAX DECIMAL(20,4) NOT NULL,
LICENSE_USAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE O365LicnsUsgTest_TREND ADD constraint PK_O365LicnsUsgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365LicnsUsgTest_THRESH;
CREATE TABLE O365LicnsUsgTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
LICENSED_USERS_MIN VARCHAR(256) NOT NULL,
LICENSED_USERS_MAX VARCHAR(256) NOT NULL,
ACTIVE_UNITS_MIN VARCHAR(256) NOT NULL,
ACTIVE_UNITS_MAX VARCHAR(256) NOT NULL,
WARNING_UNITS_MIN VARCHAR(256) NOT NULL,
WARNING_UNITS_MAX VARCHAR(256) NOT NULL,
STATUS_MIN VARCHAR(256) NOT NULL,
STATUS_MAX VARCHAR(256) NOT NULL,
TRAIL_MIN VARCHAR(256) NOT NULL,
TRAIL_MAX VARCHAR(256) NOT NULL,
TOTAL_LICENSE_MIN VARCHAR(256) NOT NULL,
TOTAL_LICENSE_MAX VARCHAR(256) NOT NULL,
DAYS_TO_EXPIRE_MIN VARCHAR(256) NOT NULL,
DAYS_TO_EXPIRE_MAX VARCHAR(256) NOT NULL,
LICENSE_USAGE_MIN VARCHAR(256) NOT NULL,
LICENSE_USAGE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365LicnsUsgTest_THRESH ADD constraint PK_O365LicnsUsgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365LicnsUsgTest_THRESH ON O365LicnsUsgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365LicnsUsgTest ON O365LicnsUsgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365LicnsUsgTest ON O365LicnsUsgTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365SpfAdtLgTest;
CREATE TABLE O365SpfAdtLgTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Operation_Cnt DECIMAL(20,4) NOT NULL,
Operation_Cnt_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365SpfAdtLgTest ON O365SpfAdtLgTest(MSMT_TIME);
ALTER TABLE O365SpfAdtLgTest ADD constraint PK_O365SpfAdtLgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SpfAdtLgTest_TREND;
CREATE TABLE O365SpfAdtLgTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Operation_Cnt_MIN DECIMAL(20,4) NOT NULL,
Operation_Cnt_MAX DECIMAL(20,4) NOT NULL,
Operation_Cnt_STCNT varchar(32) NOT NULL);

ALTER TABLE O365SpfAdtLgTest_TREND ADD constraint PK_O365SpfAdtLgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SpfAdtLgTest_THRESH;
CREATE TABLE O365SpfAdtLgTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Operation_Cnt_MIN VARCHAR(256) NOT NULL,
Operation_Cnt_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365SpfAdtLgTest_THRESH ADD constraint PK_O365SpfAdtLgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SpfAdtLgTest_THRESH ON O365SpfAdtLgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SpfAdtLgTest ON O365SpfAdtLgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SpfAdtLgTest ON O365SpfAdtLgTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365ConecChecksTest;
CREATE TABLE O365ConecChecksTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Connection_Status DECIMAL(20,4) NOT NULL,
Connection_Status_ST varchar(32) NOT NULL,
Time_taken_to_connect DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365ConecChecksTest ON O365ConecChecksTest(MSMT_TIME);
ALTER TABLE O365ConecChecksTest ADD constraint PK_O365ConecChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365ConecChecksTest_TREND;
CREATE TABLE O365ConecChecksTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Connection_Status_MIN DECIMAL(20,4) NOT NULL,
Connection_Status_MAX DECIMAL(20,4) NOT NULL,
Connection_Status_STCNT varchar(32) NOT NULL,
Time_taken_to_connect_MIN DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_MAX DECIMAL(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar(32) NOT NULL);

ALTER TABLE O365ConecChecksTest_TREND ADD constraint PK_O365ConecChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365ConecChecksTest_THRESH;
CREATE TABLE O365ConecChecksTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Connection_Status_MIN VARCHAR(256) NOT NULL,
Connection_Status_MAX VARCHAR(256) NOT NULL,
Time_taken_to_connect_MIN VARCHAR(256) NOT NULL,
Time_taken_to_connect_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365ConecChecksTest_THRESH ADD constraint PK_O365ConecChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365ConecChecksTest_THRESH ON O365ConecChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365ConecChecksTest ON O365ConecChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365ConecChecksTest ON O365ConecChecksTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UnfiedgrpsTest;
CREATE TABLE O365UnfiedgrpsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MODIFIED_GROUPS DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_ST varchar(32) NOT NULL,
NEWLY_CREATED_GROUPS DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST varchar(32) NOT NULL,
SOFT_DELETED_GROUPS DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST varchar(32) NOT NULL,
TOTAL_GROUPS DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_ST varchar(32) NOT NULL,
PUBLIC_GROUPS DECIMAL(20,4) NOT NULL,
PUBLIC_GROUPS_ST varchar(32) NOT NULL,
PRIVATE_GROUPS DECIMAL(20,4) NOT NULL,
PRIVATE_GROUPS_ST varchar(32) NOT NULL,
ORPHANED_GROUPS DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_ST varchar(32) NOT NULL,
EMPTY_GROUPS DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_ST varchar(32) NOT NULL,
GROUPS_EXTERNAL DECIMAL(20,4) NOT NULL,
GROUPS_EXTERNAL_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365UnfiedgrpsTest ON O365UnfiedgrpsTest(MSMT_TIME);
ALTER TABLE O365UnfiedgrpsTest ADD constraint PK_O365UnfiedgrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UnfiedgrpsTest_TREND;
CREATE TABLE O365UnfiedgrpsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MODIFIED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_STCNT varchar(32) NOT NULL,
NEWLY_CREATED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT varchar(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT varchar(32) NOT NULL,
TOTAL_GROUPS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_STCNT varchar(32) NOT NULL,
PUBLIC_GROUPS_MIN DECIMAL(20,4) NOT NULL,
PUBLIC_GROUPS_MAX DECIMAL(20,4) NOT NULL,
PUBLIC_GROUPS_STCNT varchar(32) NOT NULL,
PRIVATE_GROUPS_MIN DECIMAL(20,4) NOT NULL,
PRIVATE_GROUPS_MAX DECIMAL(20,4) NOT NULL,
PRIVATE_GROUPS_STCNT varchar(32) NOT NULL,
ORPHANED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT varchar(32) NOT NULL,
EMPTY_GROUPS_MIN DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_MAX DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_STCNT varchar(32) NOT NULL,
GROUPS_EXTERNAL_MIN DECIMAL(20,4) NOT NULL,
GROUPS_EXTERNAL_MAX DECIMAL(20,4) NOT NULL,
GROUPS_EXTERNAL_STCNT varchar(32) NOT NULL);

ALTER TABLE O365UnfiedgrpsTest_TREND ADD constraint PK_O365UnfiedgrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UnfiedgrpsTest_THRESH;
CREATE TABLE O365UnfiedgrpsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MODIFIED_GROUPS_MIN VARCHAR(256) NOT NULL,
MODIFIED_GROUPS_MAX VARCHAR(256) NOT NULL,
NEWLY_CREATED_GROUPS_MIN VARCHAR(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR(256) NOT NULL,
PUBLIC_GROUPS_MIN VARCHAR(256) NOT NULL,
PUBLIC_GROUPS_MAX VARCHAR(256) NOT NULL,
PRIVATE_GROUPS_MIN VARCHAR(256) NOT NULL,
PRIVATE_GROUPS_MAX VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR(256) NOT NULL,
GROUPS_EXTERNAL_MIN VARCHAR(256) NOT NULL,
GROUPS_EXTERNAL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365UnfiedgrpsTest_THRESH ADD constraint PK_O365UnfiedgrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UnfiedgrpsTest_THRESH ON O365UnfiedgrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UnfiedgrpsTest ON O365UnfiedgrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UnfiedgrpsTest ON O365UnfiedgrpsTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE O365DycDistbGrpTest;
CREATE TABLE O365DycDistbGrpTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MODIFIED_GROUPS DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_ST varchar(32) NOT NULL,
NEWLY_CREATED_GROUPS DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST varchar(32) NOT NULL,
SOFT_DELETED_GROUPS DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST varchar(32) NOT NULL,
TOTAL_GROUPS DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_ST varchar(32) NOT NULL,
ORPHANED_GROUPS DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_ST varchar(32) NOT NULL,
EMPTY_GROUPS DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365DycDistbGrpTest ON O365DycDistbGrpTest(MSMT_TIME);
ALTER TABLE O365DycDistbGrpTest ADD constraint PK_O365DycDistbGrpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DycDistbGrpTest_TREND;
CREATE TABLE O365DycDistbGrpTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MODIFIED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_STCNT varchar(32) NOT NULL,
NEWLY_CREATED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT varchar(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT varchar(32) NOT NULL,
TOTAL_GROUPS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_STCNT varchar(32) NOT NULL,
ORPHANED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT varchar(32) NOT NULL,
EMPTY_GROUPS_MIN DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_MAX DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_STCNT varchar(32) NOT NULL);

ALTER TABLE O365DycDistbGrpTest_TREND ADD constraint PK_O365DycDistbGrpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DycDistbGrpTest_THRESH;
CREATE TABLE O365DycDistbGrpTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MODIFIED_GROUPS_MIN VARCHAR(256) NOT NULL,
MODIFIED_GROUPS_MAX VARCHAR(256) NOT NULL,
NEWLY_CREATED_GROUPS_MIN VARCHAR(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365DycDistbGrpTest_THRESH ADD constraint PK_O365DycDistbGrpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DycDistbGrpTest_THRESH ON O365DycDistbGrpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DycDistbGrpTest ON O365DycDistbGrpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DycDistbGrpTest ON O365DycDistbGrpTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365DistbnGrpsTest;
CREATE TABLE O365DistbnGrpsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MODIFIED_GROUPS DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_ST varchar(32) NOT NULL,
NEWLY_CREATED_GROUPS DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST varchar(32) NOT NULL,
SOFT_DELETED_GROUPS DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST varchar(32) NOT NULL,
TOTAL_GROUPS DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_ST varchar(32) NOT NULL,
ORPHANED_GROUPS DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_ST varchar(32) NOT NULL,
EMPTY_GROUPS DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365DistbnGrpsTest ON O365DistbnGrpsTest(MSMT_TIME);
ALTER TABLE O365DistbnGrpsTest ADD constraint PK_O365DistbnGrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DistbnGrpsTest_TREND;
CREATE TABLE O365DistbnGrpsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MODIFIED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
MODIFIED_GROUPS_STCNT varchar(32) NOT NULL,
NEWLY_CREATED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT varchar(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT varchar(32) NOT NULL,
TOTAL_GROUPS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_GROUPS_STCNT varchar(32) NOT NULL,
ORPHANED_GROUPS_MIN DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_MAX DECIMAL(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT varchar(32) NOT NULL,
EMPTY_GROUPS_MIN DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_MAX DECIMAL(20,4) NOT NULL,
EMPTY_GROUPS_STCNT varchar(32) NOT NULL);

ALTER TABLE O365DistbnGrpsTest_TREND ADD constraint PK_O365DistbnGrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DistbnGrpsTest_THRESH;
CREATE TABLE O365DistbnGrpsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MODIFIED_GROUPS_MIN VARCHAR(256) NOT NULL,
MODIFIED_GROUPS_MAX VARCHAR(256) NOT NULL,
NEWLY_CREATED_GROUPS_MIN VARCHAR(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365DistbnGrpsTest_THRESH ADD constraint PK_O365DistbnGrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DistbnGrpsTest_THRESH ON O365DistbnGrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DistbnGrpsTest ON O365DistbnGrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DistbnGrpsTest ON O365DistbnGrpsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365MsgCenTest;
CREATE TABLE O365MsgCenTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MSGCENTERCOMMUNICATION DECIMAL(20,4) NOT NULL,
MSGCENTERCOMMUNICATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365MsgCenTest ON O365MsgCenTest(MSMT_TIME);
ALTER TABLE O365MsgCenTest ADD constraint PK_O365MsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365MsgCenTest_TREND;
CREATE TABLE O365MsgCenTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MSGCENTERCOMMUNICATION_MIN DECIMAL(20,4) NOT NULL,
MSGCENTERCOMMUNICATION_MAX DECIMAL(20,4) NOT NULL,
MSGCENTERCOMMUNICATION_STCNT varchar(32) NOT NULL);

ALTER TABLE O365MsgCenTest_TREND ADD constraint PK_O365MsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365MsgCenTest_THRESH;
CREATE TABLE O365MsgCenTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MSGCENTERCOMMUNICATION_MIN VARCHAR(256) NOT NULL,
MSGCENTERCOMMUNICATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365MsgCenTest_THRESH ADD constraint PK_O365MsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365MsgCenTest_THRESH ON O365MsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365MsgCenTest ON O365MsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365MsgCenTest ON O365MsgCenTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365SrvHealTest;
CREATE TABLE O365SrvHealTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVICE_INCIDENTS DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar(32) NOT NULL,
MAINTENANCE_EVENTS DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar(32) NOT NULL,
SERVICE_STATUS DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_O365SrvHealTest ON O365SrvHealTest(MSMT_TIME);
ALTER TABLE O365SrvHealTest ADD constraint PK_O365SrvHealTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SrvHealTest_TREND;
CREATE TABLE O365SrvHealTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVICE_INCIDENTS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar(32) NOT NULL,
MAINTENANCE_EVENTS_MIN DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar(32) NOT NULL,
SERVICE_STATUS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar(32) NOT NULL);

ALTER TABLE O365SrvHealTest_TREND ADD constraint PK_O365SrvHealTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SrvHealTest_THRESH;
CREATE TABLE O365SrvHealTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVICE_INCIDENTS_MIN VARCHAR(256) NOT NULL,
SERVICE_INCIDENTS_MAX VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MIN VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MAX VARCHAR(256) NOT NULL,
SERVICE_STATUS_MIN VARCHAR(256) NOT NULL,
SERVICE_STATUS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE O365SrvHealTest_THRESH ADD constraint PK_O365SrvHealTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SrvHealTest_THRESH ON O365SrvHealTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SrvHealTest ON O365SrvHealTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SrvHealTest ON O365SrvHealTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSiteTest;
CREATE TABLE SPOSiteTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
STATUS DECIMAL(20,4) NOT NULL,
STATUS_ST varchar(32) NOT NULL,
WEBS_COUNT DECIMAL(20,4) NOT NULL,
WEBS_COUNT_ST varchar(32) NOT NULL,
STORAGE_QUOTA DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_ST varchar(32) NOT NULL,
CURRENT_STORAGE_USAGE DECIMAL(20,4) NOT NULL,
CURRENT_STORAGE_USAGE_ST varchar(32) NOT NULL,
STORAGE_USAGE_PERCENT DECIMAL(20,4) NOT NULL,
STORAGE_USAGE_PERCENT_ST varchar(32) NOT NULL,
CURRENT_RESOURCE_USAGE DECIMAL(20,4) NOT NULL,
CURRENT_RESOURCE_USAGE_ST varchar(32) NOT NULL,
AVERAGE_RESOURCE_USAGE DECIMAL(20,4) NOT NULL,
AVERAGE_RESOURCE_USAGE_ST varchar(32) NOT NULL,
RESOURCE_QUOTA DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_ST varchar(32) NOT NULL,
RSQUOTAWARNINGLEVEL DECIMAL(20,4) NOT NULL,
RSQUOTAWARNINGLEVEL_ST varchar(32) NOT NULL,
LOCKED DECIMAL(20,4) NOT NULL,
LOCKED_ST varchar(32) NOT NULL,
LASTCONTENTMODIFIEDDATE DECIMAL(20,4) NOT NULL,
LASTCONTENTMODIFIEDDATE_ST varchar(32) NOT NULL,
External_users DECIMAL(20,4) NOT NULL,
External_users_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOSiteTest ON SPOSiteTest(MSMT_TIME);
ALTER TABLE SPOSiteTest ADD constraint PK_SPOSiteTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteTest_TREND;
CREATE TABLE SPOSiteTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
STATUS_MIN DECIMAL(20,4) NOT NULL,
STATUS_MAX DECIMAL(20,4) NOT NULL,
STATUS_STCNT varchar(32) NOT NULL,
WEBS_COUNT_MIN DECIMAL(20,4) NOT NULL,
WEBS_COUNT_MAX DECIMAL(20,4) NOT NULL,
WEBS_COUNT_STCNT varchar(32) NOT NULL,
STORAGE_QUOTA_MIN DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_MAX DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_STCNT varchar(32) NOT NULL,
CURRENT_STORAGE_USAGE_MIN DECIMAL(20,4) NOT NULL,
CURRENT_STORAGE_USAGE_MAX DECIMAL(20,4) NOT NULL,
CURRENT_STORAGE_USAGE_STCNT varchar(32) NOT NULL,
STORAGE_USAGE_PERCENT_MIN DECIMAL(20,4) NOT NULL,
STORAGE_USAGE_PERCENT_MAX DECIMAL(20,4) NOT NULL,
STORAGE_USAGE_PERCENT_STCNT varchar(32) NOT NULL,
CURRENT_RESOURCE_USAGE_MIN DECIMAL(20,4) NOT NULL,
CURRENT_RESOURCE_USAGE_MAX DECIMAL(20,4) NOT NULL,
CURRENT_RESOURCE_USAGE_STCNT varchar(32) NOT NULL,
AVERAGE_RESOURCE_USAGE_MIN DECIMAL(20,4) NOT NULL,
AVERAGE_RESOURCE_USAGE_MAX DECIMAL(20,4) NOT NULL,
AVERAGE_RESOURCE_USAGE_STCNT varchar(32) NOT NULL,
RESOURCE_QUOTA_MIN DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_MAX DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_STCNT varchar(32) NOT NULL,
RSQUOTAWARNINGLEVEL_MIN DECIMAL(20,4) NOT NULL,
RSQUOTAWARNINGLEVEL_MAX DECIMAL(20,4) NOT NULL,
RSQUOTAWARNINGLEVEL_STCNT varchar(32) NOT NULL,
LOCKED_MIN DECIMAL(20,4) NOT NULL,
LOCKED_MAX DECIMAL(20,4) NOT NULL,
LOCKED_STCNT varchar(32) NOT NULL,
LASTCONTENTMODIFIEDDATE_MIN DECIMAL(20,4) NOT NULL,
LASTCONTENTMODIFIEDDATE_MAX DECIMAL(20,4) NOT NULL,
LASTCONTENTMODIFIEDDATE_STCNT varchar(32) NOT NULL,
External_users_MIN DECIMAL(20,4) NOT NULL,
External_users_MAX DECIMAL(20,4) NOT NULL,
External_users_STCNT varchar(32) NOT NULL
);

ALTER TABLE SPOSiteTest_TREND ADD constraint PK_SPOSiteTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteTest_THRESH;
CREATE TABLE SPOSiteTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
STATUS_MIN VARCHAR(256) NOT NULL,
STATUS_MAX VARCHAR(256) NOT NULL,
WEBS_COUNT_MIN VARCHAR(256) NOT NULL,
WEBS_COUNT_MAX VARCHAR(256) NOT NULL,
STORAGE_QUOTA_MIN VARCHAR(256) NOT NULL,
STORAGE_QUOTA_MAX VARCHAR(256) NOT NULL,
CURRENT_STORAGE_USAGE_MIN VARCHAR(256) NOT NULL,
CURRENT_STORAGE_USAGE_MAX VARCHAR(256) NOT NULL,
STORAGE_USAGE_PERCENT_MIN VARCHAR(256) NOT NULL,
STORAGE_USAGE_PERCENT_MAX VARCHAR(256) NOT NULL,
CURRENT_RESOURCE_USAGE_MIN VARCHAR(256) NOT NULL,
CURRENT_RESOURCE_USAGE_MAX VARCHAR(256) NOT NULL,
AVERAGE_RESOURCE_USAGE_MIN VARCHAR(256) NOT NULL,
AVERAGE_RESOURCE_USAGE_MAX VARCHAR(256) NOT NULL,
RESOURCE_QUOTA_MIN VARCHAR(256) NOT NULL,
RESOURCE_QUOTA_MAX VARCHAR(256) NOT NULL,
RSQUOTAWARNINGLEVEL_MIN VARCHAR(256) NOT NULL,
RSQUOTAWARNINGLEVEL_MAX VARCHAR(256) NOT NULL,
LOCKED_MIN VARCHAR(256) NOT NULL,
LOCKED_MAX VARCHAR(256) NOT NULL,
LASTCONTENTMODIFIEDDATE_MIN VARCHAR(256) NOT NULL,
LASTCONTENTMODIFIEDDATE_MAX VARCHAR(256) NOT NULL,
External_users_MIN VARCHAR(256) NOT NULL,
External_users_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOSiteTest_THRESH ADD constraint PK_SPOSiteTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSiteTest_THRESH ON SPOSiteTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteTest ON SPOSiteTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteTest ON SPOSiteTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE SPOTenantTest;
CREATE TABLE SPOTenantTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
ONEDRIVE_STORAGE_QUOTA DECIMAL(20,4) NOT NULL,
ONEDRIVE_STORAGE_QUOTA_ST varchar(32) NOT NULL,
RESOURCE_QUOTA DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_ST varchar(32) NOT NULL,
RESOURCE_QUOTA_ALLOCATED DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_ALLOCATED_ST varchar(32) NOT NULL,
STORAGE_QUOTA DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_ST varchar(32) NOT NULL,
STORAGE_QUOTA_ALLOCATED DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_ALLOCATED_ST varchar(32) NOT NULL,
DELETED_SITES DECIMAL(20,4) NOT NULL,
DELETED_SITES_ST varchar(32) NOT NULL,
APPLICATIONS DECIMAL(20,4) NOT NULL,
APPLICATIONS_ST varchar(32) NOT NULL,
WEB_TEMPLATES DECIMAL(20,4) NOT NULL,
WEB_TEMPLATES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOTenantTest ON SPOTenantTest(MSMT_TIME);
ALTER TABLE SPOTenantTest ADD constraint PK_SPOTenantTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOTenantTest_TREND;
CREATE TABLE SPOTenantTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ONEDRIVE_STORAGE_QUOTA_MIN DECIMAL(20,4) NOT NULL,
ONEDRIVE_STORAGE_QUOTA_MAX DECIMAL(20,4) NOT NULL,
ONEDRIVE_STORAGE_QUOTA_STCNT varchar(32) NOT NULL,
RESOURCE_QUOTA_MIN DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_MAX DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_STCNT varchar(32) NOT NULL,
RESOURCE_QUOTA_ALLOCATED_MIN DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_ALLOCATED_MAX DECIMAL(20,4) NOT NULL,
RESOURCE_QUOTA_ALLOCATED_STCNT varchar(32) NOT NULL,
STORAGE_QUOTA_MIN DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_MAX DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_STCNT varchar(32) NOT NULL,
STORAGE_QUOTA_ALLOCATED_MIN DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_ALLOCATED_MAX DECIMAL(20,4) NOT NULL,
STORAGE_QUOTA_ALLOCATED_STCNT varchar(32) NOT NULL,
DELETED_SITES_MIN DECIMAL(20,4) NOT NULL,
DELETED_SITES_MAX DECIMAL(20,4) NOT NULL,
DELETED_SITES_STCNT varchar(32) NOT NULL,
APPLICATIONS_MIN DECIMAL(20,4) NOT NULL,
APPLICATIONS_MAX DECIMAL(20,4) NOT NULL,
APPLICATIONS_STCNT varchar(32) NOT NULL,
WEB_TEMPLATES_MIN DECIMAL(20,4) NOT NULL,
WEB_TEMPLATES_MAX DECIMAL(20,4) NOT NULL,
WEB_TEMPLATES_STCNT varchar(32) NOT NULL);


ALTER TABLE SPOTenantTest_TREND ADD constraint PK_SPOTenantTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOTenantTest_THRESH;
CREATE TABLE SPOTenantTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ONEDRIVE_STORAGE_QUOTA_MIN VARCHAR(256) NOT NULL,
ONEDRIVE_STORAGE_QUOTA_MAX VARCHAR(256) NOT NULL,
RESOURCE_QUOTA_MIN VARCHAR(256) NOT NULL,
RESOURCE_QUOTA_MAX VARCHAR(256) NOT NULL,
RESOURCE_QUOTA_ALLOCATED_MIN VARCHAR(256) NOT NULL,
RESOURCE_QUOTA_ALLOCATED_MAX VARCHAR(256) NOT NULL,
STORAGE_QUOTA_MIN VARCHAR(256) NOT NULL,
STORAGE_QUOTA_MAX VARCHAR(256) NOT NULL,
STORAGE_QUOTA_ALLOCATED_MIN VARCHAR(256) NOT NULL,
STORAGE_QUOTA_ALLOCATED_MAX VARCHAR(256) NOT NULL,
DELETED_SITES_MIN VARCHAR(256) NOT NULL,
DELETED_SITES_MAX VARCHAR(256) NOT NULL,
APPLICATIONS_MIN VARCHAR(256) NOT NULL,
APPLICATIONS_MAX VARCHAR(256) NOT NULL,
WEB_TEMPLATES_MIN VARCHAR(256) NOT NULL,
WEB_TEMPLATES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOTenantTest_THRESH ADD constraint PK_SPOTenantTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOTenantTest_THRESH ON SPOTenantTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOTenantTest ON SPOTenantTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOTenantTest ON SPOTenantTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE SPOFILEFIELDSTEST;
CREATE TABLE SPOFILEFIELDSTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
FILE_UPLOAD_STATUS DECIMAL(20,4) NOT NULL,
FILE_UPLOAD_STATUS_ST VARCHAR(32) NOT NULL,
FILE_UPLOAD_TIME DECIMAL(20,4) NOT NULL,
FILE_UPLOAD_TIME_ST VARCHAR(32) NOT NULL,

FILE_DOWNLOAD_STATUS DECIMAL(20,4) NOT NULL,
FILE_DOWNLOAD_STATUS_ST VARCHAR(32) NOT NULL,
FILE_DOWNLOAD_TIME DECIMAL(20,4) NOT NULL,
FILE_DOWNLOAD_TIME_ST VARCHAR(32) NOT NULL,

FILE_CHECKOUT_STATUS DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_STATUS_ST VARCHAR(32) NOT NULL,
FILE_CHECKOUT_TIME DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_TIME_ST VARCHAR(32) NOT NULL,


FILE_CHECKIN_STATUS DECIMAL(20,4) NOT NULL,
FILE_CHECKIN_STATUS_ST VARCHAR(32) NOT NULL,
FILE_CHECKIN_TIME DECIMAL(20,4) NOT NULL,
FILE_CHECKIN_TIME_ST VARCHAR(32) NOT NULL,


FILE_DELETION_STATUS DECIMAL(20,4) NOT NULL,
FILE_DELETION_STATUS_ST VARCHAR(32) NOT NULL,
FILE_DELETION_TIME DECIMAL(20,4) NOT NULL,
FILE_DELETION_TIME_ST VARCHAR(32) NOT NULL
);

CREATE INDEX IDX_SPOFILEFIELDSTEST ON SPOFILEFIELDSTEST(MSMT_TIME);
ALTER TABLE SPOFILEFIELDSTEST ADD CONSTRAINT PK_SPOFILEFIELDSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFILEFIELDSTEST_TREND;
CREATE TABLE SPOFILEFIELDSTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
FILE_UPLOAD_STATUS_MIN DECIMAL(20,4) NOT NULL,
FILE_UPLOAD_STATUS_MAX DECIMAL(20,4) NOT NULL,
FILE_UPLOAD_STATUS_STCNT VARCHAR(32) NOT NULL,
FILE_UPLOAD_TIME_MIN DECIMAL(20,4) NOT NULL,
FILE_UPLOAD_TIME_MAX DECIMAL(20,4) NOT NULL,
FILE_UPLOAD_TIME_STCNT VARCHAR(32) NOT NULL,

FILE_DOWNLOAD_STATUS_MIN DECIMAL(20,4) NOT NULL,
FILE_DOWNLOAD_STATUS_MAX DECIMAL(20,4) NOT NULL,
FILE_DOWNLOAD_STATUS_STCNT VARCHAR(32) NOT NULL,
FILE_DOWNLOAD_TIME_MIN DECIMAL(20,4) NOT NULL,
FILE_DOWNLOAD_TIME_MAX DECIMAL(20,4) NOT NULL,
FILE_DOWNLOAD_TIME_STCNT VARCHAR(32) NOT NULL,



FILE_CHECKOUT_STATUS_MIN DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_STATUS_MAX DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_STATUS_STCNT VARCHAR(32) NOT NULL,
FILE_CHECKOUT_TIME_MIN DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_TIME_MAX DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_TIME_STCNT VARCHAR(32) NOT NULL,

FILE_CHECKIN_STATUS_MIN DECIMAL(20,4) NOT NULL,
FILE_CHECKIN_STATUS_MAX DECIMAL(20,4) NOT NULL,
FILE_CHECKIN_STATUS_STCNT VARCHAR(32) NOT NULL,
FILE_CHECKIN_TIME_MIN DECIMAL(20,4) NOT NULL,
FILE_CHECKIN_TIME_MAX DECIMAL(20,4) NOT NULL,
FILE_CHECKIN_TIME_STCNT VARCHAR(32) NOT NULL,


FILE_DELETION_STATUS_MIN DECIMAL(20,4) NOT NULL,
FILE_DELETION_STATUS_MAX DECIMAL(20,4) NOT NULL,
FILE_DELETION_STATUS_STCNT VARCHAR(32) NOT NULL,
FILE_DELETION_TIME_MIN DECIMAL(20,4) NOT NULL,
FILE_DELETION_TIME_MAX DECIMAL(20,4) NOT NULL,
FILE_DELETION_TIME_STCNT VARCHAR(32) NOT NULL
);

ALTER TABLE SPOFILEFIELDSTEST_TREND ADD CONSTRAINT PK_SPOFILEFIELDSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFILEFIELDSTEST_THRESH;
CREATE TABLE SPOFILEFIELDSTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
FILE_UPLOAD_STATUS_MIN VARCHAR(256) NOT NULL,
FILE_UPLOAD_STATUS_MAX VARCHAR(256) NOT NULL,
FILE_UPLOAD_TIME_MIN VARCHAR(256) NOT NULL,
FILE_UPLOAD_TIME_MAX VARCHAR(256) NOT NULL,

FILE_DOWNLOAD_STATUS_MIN VARCHAR(256) NOT NULL,
FILE_DOWNLOAD_STATUS_MAX VARCHAR(256) NOT NULL,
FILE_DOWNLOAD_TIME_MIN VARCHAR(256) NOT NULL,
FILE_DOWNLOAD_TIME_MAX VARCHAR(256) NOT NULL,


FILE_CHECKOUT_STATUS_MIN VARCHAR(256) NOT NULL,
FILE_CHECKOUT_STATUS_MAX VARCHAR(256) NOT NULL,
FILE_CHECKOUT_TIME_MIN VARCHAR(256) NOT NULL,
FILE_CHECKOUT_TIME_MAX VARCHAR(256) NOT NULL,

FILE_CHECKIN_STATUS_MIN VARCHAR(256) NOT NULL,
FILE_CHECKIN_STATUS_MAX VARCHAR(256) NOT NULL,
FILE_CHECKIN_TIME_MIN VARCHAR(256) NOT NULL,
FILE_CHECKIN_TIME_MAX VARCHAR(256) NOT NULL,


FILE_DELETION_STATUS_MIN VARCHAR(256) NOT NULL,
FILE_DELETION_STATUS_MAX VARCHAR(256) NOT NULL,
FILE_DELETION_TIME_MIN VARCHAR(256) NOT NULL,
FILE_DELETION_TIME_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE SPOFILEFIELDSTEST_THRESH ADD CONSTRAINT PK_SPOFILEFIELDSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFILEFIELDSTEST_THRESH ON SPOFILEFIELDSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFILEFIELDSTEST ON SPOFILEFIELDSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFILEFIELDSTEST ON SPOFILEFIELDSTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOLoginTest;
CREATE TABLE SPOLoginTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Authentication_status DECIMAL(20,4) NOT NULL,
Authentication_status_ST varchar(32) NOT NULL,
Authentication_time DECIMAL(20,4) NOT NULL,
Authentication_time_ST varchar(32) NOT NULL,
Login_status DECIMAL(20,4) NOT NULL,
Login_status_ST varchar(32) NOT NULL,
Login_time DECIMAL(20,4) NOT NULL,
Login_time_ST varchar(32) NOT NULL,
Total_login_time DECIMAL(20,4) NOT NULL,
Total_login_time_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOLoginTest ON SPOLoginTest(MSMT_TIME);
ALTER TABLE SPOLoginTest ADD constraint PK_SPOLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOLoginTest_TREND;
CREATE TABLE SPOLoginTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Authentication_status_MIN DECIMAL(20,4) NOT NULL,
Authentication_status_MAX DECIMAL(20,4) NOT NULL,
Authentication_status_STCNT varchar(32) NOT NULL,
Authentication_time_MIN DECIMAL(20,4) NOT NULL,
Authentication_time_MAX DECIMAL(20,4) NOT NULL,
Authentication_time_STCNT varchar(32) NOT NULL,
Login_status_MIN DECIMAL(20,4) NOT NULL,
Login_status_MAX DECIMAL(20,4) NOT NULL,
Login_status_STCNT varchar(32) NOT NULL,
Login_time_MIN DECIMAL(20,4) NOT NULL,
Login_time_MAX DECIMAL(20,4) NOT NULL,
Login_time_STCNT varchar(32) NOT NULL,
Total_login_time_MIN DECIMAL(20,4) NOT NULL,
Total_login_time_MAX DECIMAL(20,4) NOT NULL,
Total_login_time_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOLoginTest_TREND ADD constraint PK_SPOLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOLoginTest_THRESH;
CREATE TABLE SPOLoginTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Authentication_status_MIN VARCHAR(256) NOT NULL,
Authentication_status_MAX VARCHAR(256) NOT NULL,
Authentication_time_MIN VARCHAR(256) NOT NULL,
Authentication_time_MAX VARCHAR(256) NOT NULL,
Login_status_MIN VARCHAR(256) NOT NULL,
Login_status_MAX VARCHAR(256) NOT NULL,
Login_time_MIN VARCHAR(256) NOT NULL,
Login_time_MAX VARCHAR(256) NOT NULL,
Total_login_time_MIN VARCHAR(256) NOT NULL,
Total_login_time_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOLoginTest_THRESH ADD constraint PK_SPOLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOLoginTest_THRESH ON SPOLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOLoginTest ON SPOLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOLoginTest ON SPOLoginTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOHealthStatusTest;
CREATE TABLE SPOHealthStatusTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SP_health_score DECIMAL(20,4) NOT NULL,
SP_health_score_ST varchar(32) NOT NULL,
SP_request_duration DECIMAL(20,4) NOT NULL,
SP_request_duration_ST varchar(32) NOT NULL,
SP_iis_latency DECIMAL(20,4) NOT NULL,
SP_iis_latency_ST varchar(32) NOT NULL
);

CREATE INDEX IDX_SPOHealthStatusTest ON SPOHealthStatusTest(MSMT_TIME);
ALTER TABLE SPOHealthStatusTest ADD constraint PK_SPOHealthStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOHealthStatusTest_TREND;
CREATE TABLE SPOHealthStatusTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SP_health_score_MIN DECIMAL(20,4) NOT NULL,
SP_health_score_MAX DECIMAL(20,4) NOT NULL,
SP_health_score_STCNT varchar(32) NOT NULL,

SP_request_duration_MIN DECIMAL(20,4) NOT NULL,
SP_request_duration_MAX DECIMAL(20,4) NOT NULL,
SP_request_duration_STCNT varchar(32) NOT NULL,


SP_iis_latency_MIN DECIMAL(20,4) NOT NULL,
SP_iis_latency_MAX DECIMAL(20,4) NOT NULL,
SP_iis_latency_STCNT varchar(32) NOT NULL

);

ALTER TABLE SPOHealthStatusTest_TREND ADD constraint PK_SPOHealthStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOHealthStatusTest_THRESH;
CREATE TABLE SPOHealthStatusTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,

SP_health_score_MIN VARCHAR(256) NOT NULL,
SP_health_score_MAX VARCHAR(256) NOT NULL,
SP_request_duration_MIN VARCHAR(256) NOT NULL,
SP_request_duration_MAX VARCHAR(256) NOT NULL,

SP_iis_latency_MIN VARCHAR(256) NOT NULL,
SP_iis_latency_MAX VARCHAR(256) NOT NULL
);

ALTER TABLE SPOHealthStatusTest_THRESH ADD constraint PK_SPOHealthStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOHealthStatusTest_THRESH ON SPOHealthStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOHealthStatusTest ON SPOHealthStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOHealthStatusTest ON SPOHealthStatusTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOSiteHealthCheckTest;
CREATE TABLE SPOSiteHealthCheckTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PASSED DECIMAL(20,4) NOT NULL,
PASSED_ST varchar(32) NOT NULL,
FAILED_WARNINGS DECIMAL(20,4) NOT NULL,
FAILED_WARNINGS_ST varchar(32) NOT NULL,
FAILED_ERRORS DECIMAL(20,4) NOT NULL,
FAILED_ERRORS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest(MSMT_TIME);
ALTER TABLE SPOSiteHealthCheckTest ADD constraint PK_SPOSiteHealthCheckTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteHealthCheckTest_TREND;
CREATE TABLE SPOSiteHealthCheckTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
PASSED_MIN DECIMAL(20,4) NOT NULL,
PASSED_MAX DECIMAL(20,4) NOT NULL,
PASSED_STCNT varchar(32) NOT NULL,
FAILED_WARNINGS_MIN DECIMAL(20,4) NOT NULL,
FAILED_WARNINGS_MAX DECIMAL(20,4) NOT NULL,
FAILED_WARNINGS_STCNT varchar(32) NOT NULL,
FAILED_ERRORS_MIN DECIMAL(20,4) NOT NULL,
FAILED_ERRORS_MAX DECIMAL(20,4) NOT NULL,
FAILED_ERRORS_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOSiteHealthCheckTest_TREND ADD constraint PK_SPOSitHlthChckTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteHealthCheckTest_THRESH;
CREATE TABLE SPOSiteHealthCheckTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
PASSED_MIN VARCHAR(256) NOT NULL,
PASSED_MAX VARCHAR(256) NOT NULL,
FAILED_WARNINGS_MIN VARCHAR(256) NOT NULL,
FAILED_WARNINGS_MAX VARCHAR(256) NOT NULL,
FAILED_ERRORS_MIN VARCHAR(256) NOT NULL,
FAILED_ERRORS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOSiteHealthCheckTest_THRESH ADD constraint PK_SPOSitHlthChckTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSitHlthChkTest_THRESH ON SPOSiteHealthCheckTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE SPOMsgCommTest;
CREATE TABLE SPOMsgCommTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MSGCENTERCOMMUNICATION DECIMAL(20,4) NOT NULL,
MSGCENTERCOMMUNICATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOMsgCommTest ON SPOMsgCommTest(MSMT_TIME);
ALTER TABLE SPOMsgCommTest ADD constraint PK_SPOMsgCommTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOMsgCommTest_TREND;
CREATE TABLE SPOMsgCommTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MSGCENTERCOMMUNICATION_MIN DECIMAL(20,4) NOT NULL,
MSGCENTERCOMMUNICATION_MAX DECIMAL(20,4) NOT NULL,
MSGCENTERCOMMUNICATION_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOMsgCommTest_TREND ADD constraint PK_SPOMsgCommTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOMsgCommTest_THRESH;
CREATE TABLE SPOMsgCommTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MSGCENTERCOMMUNICATION_MIN VARCHAR(256) NOT NULL,
MSGCENTERCOMMUNICATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOMsgCommTest_THRESH ADD constraint PK_SPOMsgCommTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOMsgCommTest_THRESH ON SPOMsgCommTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOMsgCommTest ON SPOMsgCommTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOMsgCommTest ON SPOMsgCommTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE SPOServiceTest;
CREATE TABLE SPOServiceTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVICE_INCIDENTS DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar(32) NOT NULL,
MAINTENANCE_EVENTS DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar(32) NOT NULL,
SERVICE_STATUS DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOServiceTest ON SPOServiceTest(MSMT_TIME);
ALTER TABLE SPOServiceTest ADD constraint PK_SPOServiceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOServiceTest_TREND;
CREATE TABLE SPOServiceTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVICE_INCIDENTS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar(32) NOT NULL,
MAINTENANCE_EVENTS_MIN DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar(32) NOT NULL,
SERVICE_STATUS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOServiceTest_TREND ADD constraint PK_SPOServiceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOServiceTest_THRESH;
CREATE TABLE SPOServiceTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVICE_INCIDENTS_MIN VARCHAR(256) NOT NULL,
SERVICE_INCIDENTS_MAX VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MIN VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MAX VARCHAR(256) NOT NULL,
SERVICE_STATUS_MIN VARCHAR(256) NOT NULL,
SERVICE_STATUS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOServiceTest_THRESH ADD constraint PK_SPOServiceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOServiceTest_THRESH ON SPOServiceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOServiceTest ON SPOServiceTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOServiceTest ON SPOServiceTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOFolderActTest;
CREATE TABLE SPOFolderActTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_USERS DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_ST varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
UNIQUE_SITES DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_ST varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
FOLDER_COPIES DECIMAL(20,4) NOT NULL,
FOLDER_COPIES_ST varchar(32) NOT NULL,
FOLDER_CREATIONS DECIMAL(20,4) NOT NULL,
FOLDER_CREATIONS_ST varchar(32) NOT NULL,
FOLDER_DELETIONS DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_ST varchar(32) NOT NULL,
FOLDER_DELETIONS_I_BIN DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_I_BIN_ST varchar(32) NOT NULL,
FOLDER_DELETIONS_II_BIN DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_II_BIN_ST varchar(32) NOT NULL,
FOLDER_MODIFICATIONS DECIMAL(20,4) NOT NULL,
FOLDER_MODIFICATIONS_ST varchar(32) NOT NULL,
FOLDER_MOVES DECIMAL(20,4) NOT NULL,
FOLDER_MOVES_ST varchar(32) NOT NULL,
FOLDER_RENAMES DECIMAL(20,4) NOT NULL,
FOLDER_RENAMES_ST varchar(32) NOT NULL,
FOLDER_RESTORES DECIMAL(20,4) NOT NULL,
FOLDER_RESTORES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOFolderActTest ON SPOFolderActTest(MSMT_TIME);
ALTER TABLE SPOFolderActTest ADD constraint PK_SPOFolderActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFolderActTest_TREND;
CREATE TABLE SPOFolderActTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_STCNT varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_STCNT varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
FOLDER_COPIES_MIN DECIMAL(20,4) NOT NULL,
FOLDER_COPIES_MAX DECIMAL(20,4) NOT NULL,
FOLDER_COPIES_STCNT varchar(32) NOT NULL,
FOLDER_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
FOLDER_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
FOLDER_CREATIONS_STCNT varchar(32) NOT NULL,
FOLDER_DELETIONS_MIN DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_MAX DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_STCNT varchar(32) NOT NULL,
FOLDER_DELETIONS_I_BIN_MIN DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_I_BIN_MAX DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_I_BIN_STCNT varchar(32) NOT NULL,
FOLDER_DELETIONS_II_BIN_MIN DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_II_BIN_MAX DECIMAL(20,4) NOT NULL,
FOLDER_DELETIONS_II_BIN_STCNT varchar(32) NOT NULL,
FOLDER_MODIFICATIONS_MIN DECIMAL(20,4) NOT NULL,
FOLDER_MODIFICATIONS_MAX DECIMAL(20,4) NOT NULL,
FOLDER_MODIFICATIONS_STCNT varchar(32) NOT NULL,
FOLDER_MOVES_MIN DECIMAL(20,4) NOT NULL,
FOLDER_MOVES_MAX DECIMAL(20,4) NOT NULL,
FOLDER_MOVES_STCNT varchar(32) NOT NULL,
FOLDER_RENAMES_MIN DECIMAL(20,4) NOT NULL,
FOLDER_RENAMES_MAX DECIMAL(20,4) NOT NULL,
FOLDER_RENAMES_STCNT varchar(32) NOT NULL,
FOLDER_RESTORES_MIN DECIMAL(20,4) NOT NULL,
FOLDER_RESTORES_MAX DECIMAL(20,4) NOT NULL,
FOLDER_RESTORES_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOFolderActTest_TREND ADD constraint PK_SPOFolderActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFolderActTest_THRESH;
CREATE TABLE SPOFolderActTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
FOLDER_COPIES_MIN VARCHAR(256) NOT NULL,
FOLDER_COPIES_MAX VARCHAR(256) NOT NULL,
FOLDER_CREATIONS_MIN VARCHAR(256) NOT NULL,
FOLDER_CREATIONS_MAX VARCHAR(256) NOT NULL,
FOLDER_DELETIONS_MIN VARCHAR(256) NOT NULL,
FOLDER_DELETIONS_MAX VARCHAR(256) NOT NULL,
FOLDER_DELETIONS_I_BIN_MIN VARCHAR(256) NOT NULL,
FOLDER_DELETIONS_I_BIN_MAX VARCHAR(256) NOT NULL,
FOLDER_DELETIONS_II_BIN_MIN VARCHAR(256) NOT NULL,
FOLDER_DELETIONS_II_BIN_MAX VARCHAR(256) NOT NULL,
FOLDER_MODIFICATIONS_MIN VARCHAR(256) NOT NULL,
FOLDER_MODIFICATIONS_MAX VARCHAR(256) NOT NULL,
FOLDER_MOVES_MIN VARCHAR(256) NOT NULL,
FOLDER_MOVES_MAX VARCHAR(256) NOT NULL,
FOLDER_RENAMES_MIN VARCHAR(256) NOT NULL,
FOLDER_RENAMES_MAX VARCHAR(256) NOT NULL,
FOLDER_RESTORES_MIN VARCHAR(256) NOT NULL,
FOLDER_RESTORES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOFolderActTest_THRESH ADD constraint PK_SPOFolderActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFolderActTest_THRESH ON SPOFolderActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFolderActTest ON SPOFolderActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFolderActTest ON SPOFolderActTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOFileActTest;
CREATE TABLE SPOFileActTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_USERS DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_ST varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
UNIQUE_SITES DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_ST varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
FILE_ACCESSES DECIMAL(20,4) NOT NULL,
FILE_ACCESSES_ST varchar(32) NOT NULL,
FILE_CHECK_INS DECIMAL(20,4) NOT NULL,
FILE_CHECK_INS_ST varchar(32) NOT NULL,
FILE_CHECKOUTS DECIMAL(20,4) NOT NULL,
FILE_CHECKOUTS_ST varchar(32) NOT NULL,
FILE_COPIES DECIMAL(20,4) NOT NULL,
FILE_COPIES_ST varchar(32) NOT NULL,
FILE_DELETES DECIMAL(20,4) NOT NULL,
FILE_DELETES_ST varchar(32) NOT NULL,
FILE_DELETES_FRM_I_STAGE DECIMAL(20,4) NOT NULL,
FILE_DELETES_FRM_I_STAGE_ST varchar(32) NOT NULL,
FILE_DELETES_FRM_II_STAG DECIMAL(20,4) NOT NULL,
FILE_DELETES_FRM_II_STAG_ST varchar(32) NOT NULL,
FILE_CHECKOUT_DISCARDS DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_DISCARDS_ST varchar(32) NOT NULL,
FILE_DOWNLOADS DECIMAL(20,4) NOT NULL,
FILE_DOWNLOADS_ST varchar(32) NOT NULL,
FILE_MODIFICATIONS DECIMAL(20,4) NOT NULL,
FILE_MODIFICATIONS_ST varchar(32) NOT NULL,
FILE_MOVES DECIMAL(20,4) NOT NULL,
FILE_MOVES_ST varchar(32) NOT NULL,
FILE_RENAMES DECIMAL(20,4) NOT NULL,
FILE_RENAMES_ST varchar(32) NOT NULL,
FILE_RESTORES DECIMAL(20,4) NOT NULL,
FILE_RESTORES_ST varchar(32) NOT NULL,
FILE_UPLOADS DECIMAL(20,4) NOT NULL,
FILE_UPLOADS_ST varchar(32) NOT NULL,
PAGE_VIEWS DECIMAL(20,4) NOT NULL,
PAGE_VIEWS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOFileActTest ON SPOFileActTest(MSMT_TIME);
ALTER TABLE SPOFileActTest ADD constraint PK_SPOFileActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFileActTest_TREND;
CREATE TABLE SPOFileActTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_STCNT varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_STCNT varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
FILE_ACCESSES_MIN DECIMAL(20,4) NOT NULL,
FILE_ACCESSES_MAX DECIMAL(20,4) NOT NULL,
FILE_ACCESSES_STCNT varchar(32) NOT NULL,
FILE_CHECK_INS_MIN DECIMAL(20,4) NOT NULL,
FILE_CHECK_INS_MAX DECIMAL(20,4) NOT NULL,
FILE_CHECK_INS_STCNT varchar(32) NOT NULL,
FILE_CHECKOUTS_MIN DECIMAL(20,4) NOT NULL,
FILE_CHECKOUTS_MAX DECIMAL(20,4) NOT NULL,
FILE_CHECKOUTS_STCNT varchar(32) NOT NULL,
FILE_COPIES_MIN DECIMAL(20,4) NOT NULL,
FILE_COPIES_MAX DECIMAL(20,4) NOT NULL,
FILE_COPIES_STCNT varchar(32) NOT NULL,
FILE_DELETES_MIN DECIMAL(20,4) NOT NULL,
FILE_DELETES_MAX DECIMAL(20,4) NOT NULL,
FILE_DELETES_STCNT varchar(32) NOT NULL,
FILE_DELETES_FRM_I_STAGE_MIN DECIMAL(20,4) NOT NULL,
FILE_DELETES_FRM_I_STAGE_MAX DECIMAL(20,4) NOT NULL,
FILE_DELETES_FRM_I_STAGE_STCNT varchar(32) NOT NULL,
FILE_DELETES_FRM_II_STAG_MIN DECIMAL(20,4) NOT NULL,
FILE_DELETES_FRM_II_STAG_MAX DECIMAL(20,4) NOT NULL,
FILE_DELETES_FRM_II_STAG_STCNT varchar(32) NOT NULL,
FILE_CHECKOUT_DISCARDS_MIN DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_DISCARDS_MAX DECIMAL(20,4) NOT NULL,
FILE_CHECKOUT_DISCARDS_STCNT varchar(32) NOT NULL,
FILE_DOWNLOADS_MIN DECIMAL(20,4) NOT NULL,
FILE_DOWNLOADS_MAX DECIMAL(20,4) NOT NULL,
FILE_DOWNLOADS_STCNT varchar(32) NOT NULL,
FILE_MODIFICATIONS_MIN DECIMAL(20,4) NOT NULL,
FILE_MODIFICATIONS_MAX DECIMAL(20,4) NOT NULL,
FILE_MODIFICATIONS_STCNT varchar(32) NOT NULL,
FILE_MOVES_MIN DECIMAL(20,4) NOT NULL,
FILE_MOVES_MAX DECIMAL(20,4) NOT NULL,
FILE_MOVES_STCNT varchar(32) NOT NULL,
FILE_RENAMES_MIN DECIMAL(20,4) NOT NULL,
FILE_RENAMES_MAX DECIMAL(20,4) NOT NULL,
FILE_RENAMES_STCNT varchar(32) NOT NULL,
FILE_RESTORES_MIN DECIMAL(20,4) NOT NULL,
FILE_RESTORES_MAX DECIMAL(20,4) NOT NULL,
FILE_RESTORES_STCNT varchar(32) NOT NULL,
FILE_UPLOADS_MIN DECIMAL(20,4) NOT NULL,
FILE_UPLOADS_MAX DECIMAL(20,4) NOT NULL,
FILE_UPLOADS_STCNT varchar(32) NOT NULL,
PAGE_VIEWS_MIN DECIMAL(20,4) NOT NULL,
PAGE_VIEWS_MAX DECIMAL(20,4) NOT NULL,
PAGE_VIEWS_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOFileActTest_TREND ADD constraint PK_SPOFileActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFileActTest_THRESH;
CREATE TABLE SPOFileActTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
FILE_ACCESSES_MIN VARCHAR(256) NOT NULL,
FILE_ACCESSES_MAX VARCHAR(256) NOT NULL,
FILE_CHECK_INS_MIN VARCHAR(256) NOT NULL,
FILE_CHECK_INS_MAX VARCHAR(256) NOT NULL,
FILE_CHECKOUTS_MIN VARCHAR(256) NOT NULL,
FILE_CHECKOUTS_MAX VARCHAR(256) NOT NULL,
FILE_COPIES_MIN VARCHAR(256) NOT NULL,
FILE_COPIES_MAX VARCHAR(256) NOT NULL,
FILE_DELETES_MIN VARCHAR(256) NOT NULL,
FILE_DELETES_MAX VARCHAR(256) NOT NULL,
FILE_DELETES_FRM_I_STAGE_MIN VARCHAR(256) NOT NULL,
FILE_DELETES_FRM_I_STAGE_MAX VARCHAR(256) NOT NULL,
FILE_DELETES_FRM_II_STAG_MIN VARCHAR(256) NOT NULL,
FILE_DELETES_FRM_II_STAG_MAX VARCHAR(256) NOT NULL,
FILE_CHECKOUT_DISCARDS_MIN VARCHAR(256) NOT NULL,
FILE_CHECKOUT_DISCARDS_MAX VARCHAR(256) NOT NULL,
FILE_DOWNLOADS_MIN VARCHAR(256) NOT NULL,
FILE_DOWNLOADS_MAX VARCHAR(256) NOT NULL,
FILE_MODIFICATIONS_MIN VARCHAR(256) NOT NULL,
FILE_MODIFICATIONS_MAX VARCHAR(256) NOT NULL,
FILE_MOVES_MIN VARCHAR(256) NOT NULL,
FILE_MOVES_MAX VARCHAR(256) NOT NULL,
FILE_RENAMES_MIN VARCHAR(256) NOT NULL,
FILE_RENAMES_MAX VARCHAR(256) NOT NULL,
FILE_RESTORES_MIN VARCHAR(256) NOT NULL,
FILE_RESTORES_MAX VARCHAR(256) NOT NULL,
FILE_UPLOADS_MIN VARCHAR(256) NOT NULL,
FILE_UPLOADS_MAX VARCHAR(256) NOT NULL,
PAGE_VIEWS_MIN VARCHAR(256) NOT NULL,
PAGE_VIEWS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOFileActTest_THRESH ADD constraint PK_SPOFileActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFileActTest_THRESH ON SPOFileActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFileActTest ON SPOFileActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFileActTest ON SPOFileActTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOSharngActTest;
CREATE TABLE SPOSharngActTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_USERS DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_ST varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
UNIQUE_SITES DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_ST varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
ACCESS_REQ_ACCEPTANCE DECIMAL(20,4) NOT NULL,
ACCESS_REQ_ACCEPTANCE_ST varchar(32) NOT NULL,
SHARNG_INVITATN_ACCEPTNC DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_ACCEPTNC_ST varchar(32) NOT NULL,
SHARNG_INVITATN_BLOCKED DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_BLOCKED_ST varchar(32) NOT NULL,
COMPANY_LINK_CREATIONS DECIMAL(20,4) NOT NULL,
COMPANY_LINK_CREATIONS_ST varchar(32) NOT NULL,
ACCESS_REQUEST_CREATIONS DECIMAL(20,4) NOT NULL,
ACCESS_REQUEST_CREATIONS_ST varchar(32) NOT NULL,
ANONYMOUS_LINK_CREATIONS DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_CREATIONS_ST varchar(32) NOT NULL,
SHARNG_INVITATN_CREATION DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_CREATION_ST varchar(32) NOT NULL,
ACCESS_REQUEST_DENIALS DECIMAL(20,4) NOT NULL,
ACCESS_REQUEST_DENIALS_ST varchar(32) NOT NULL,
COMPANY_LINK_REMOVALS DECIMAL(20,4) NOT NULL,
COMPANY_LINK_REMOVALS_ST varchar(32) NOT NULL,
ANONYMOUS_LINK_REMOVALS DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_REMOVALS_ST varchar(32) NOT NULL,
FILE_FOLDER_SITE_SHARE DECIMAL(20,4) NOT NULL,
FILE_FOLDER_SITE_SHARE_ST varchar(32) NOT NULL,
ANONYMOUS_LINK_UPDATES DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_UPDATES_ST varchar(32) NOT NULL,
ANONYMOUS_LINK_USAGE DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_USAGE_ST varchar(32) NOT NULL,
SHARING_REVOKES DECIMAL(20,4) NOT NULL,
SHARING_REVOKES_ST varchar(32) NOT NULL,
COMPANY_LINK_USAGE DECIMAL(20,4) NOT NULL,
COMPANY_LINK_USAGE_ST varchar(32) NOT NULL,
SHARNG_INVITATN_WITHDRW DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_WITHDRW_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOSharngActTest ON SPOSharngActTest(MSMT_TIME);
ALTER TABLE SPOSharngActTest ADD constraint PK_SPOSharngActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSharngActTest_TREND;
CREATE TABLE SPOSharngActTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_STCNT varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_STCNT varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
ACCESS_REQ_ACCEPTANCE_MIN DECIMAL(20,4) NOT NULL,
ACCESS_REQ_ACCEPTANCE_MAX DECIMAL(20,4) NOT NULL,
ACCESS_REQ_ACCEPTANCE_STCNT varchar(32) NOT NULL,
SHARNG_INVITATN_ACCEPTNC_MIN DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_ACCEPTNC_MAX DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_ACCEPTNC_STCNT varchar(32) NOT NULL,
SHARNG_INVITATN_BLOCKED_MIN DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_BLOCKED_MAX DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_BLOCKED_STCNT varchar(32) NOT NULL,
COMPANY_LINK_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
COMPANY_LINK_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
COMPANY_LINK_CREATIONS_STCNT varchar(32) NOT NULL,
ACCESS_REQUEST_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
ACCESS_REQUEST_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
ACCESS_REQUEST_CREATIONS_STCNT varchar(32) NOT NULL,
ANONYMOUS_LINK_CREATIONS_MIN DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_CREATIONS_MAX DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_CREATIONS_STCNT varchar(32) NOT NULL,
SHARNG_INVITATN_CREATION_MIN DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_CREATION_MAX DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_CREATION_STCNT varchar(32) NOT NULL,
ACCESS_REQUEST_DENIALS_MIN DECIMAL(20,4) NOT NULL,
ACCESS_REQUEST_DENIALS_MAX DECIMAL(20,4) NOT NULL,
ACCESS_REQUEST_DENIALS_STCNT varchar(32) NOT NULL,
COMPANY_LINK_REMOVALS_MIN DECIMAL(20,4) NOT NULL,
COMPANY_LINK_REMOVALS_MAX DECIMAL(20,4) NOT NULL,
COMPANY_LINK_REMOVALS_STCNT varchar(32) NOT NULL,
ANONYMOUS_LINK_REMOVALS_MIN DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_REMOVALS_MAX DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_REMOVALS_STCNT varchar(32) NOT NULL,
FILE_FOLDER_SITE_SHARE_MIN DECIMAL(20,4) NOT NULL,
FILE_FOLDER_SITE_SHARE_MAX DECIMAL(20,4) NOT NULL,
FILE_FOLDER_SITE_SHARE_STCNT varchar(32) NOT NULL,
ANONYMOUS_LINK_UPDATES_MIN DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_UPDATES_MAX DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_UPDATES_STCNT varchar(32) NOT NULL,
ANONYMOUS_LINK_USAGE_MIN DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_USAGE_MAX DECIMAL(20,4) NOT NULL,
ANONYMOUS_LINK_USAGE_STCNT varchar(32) NOT NULL,
SHARING_REVOKES_MIN DECIMAL(20,4) NOT NULL,
SHARING_REVOKES_MAX DECIMAL(20,4) NOT NULL,
SHARING_REVOKES_STCNT varchar(32) NOT NULL,
COMPANY_LINK_USAGE_MIN DECIMAL(20,4) NOT NULL,
COMPANY_LINK_USAGE_MAX DECIMAL(20,4) NOT NULL,
COMPANY_LINK_USAGE_STCNT varchar(32) NOT NULL,
SHARNG_INVITATN_WITHDRW_MIN DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_WITHDRW_MAX DECIMAL(20,4) NOT NULL,
SHARNG_INVITATN_WITHDRW_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOSharngActTest_TREND ADD constraint PK_SPOSharngActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSharngActTest_THRESH;
CREATE TABLE SPOSharngActTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
ACCESS_REQ_ACCEPTANCE_MIN VARCHAR(256) NOT NULL,
ACCESS_REQ_ACCEPTANCE_MAX VARCHAR(256) NOT NULL,
SHARNG_INVITATN_ACCEPTNC_MIN VARCHAR(256) NOT NULL,
SHARNG_INVITATN_ACCEPTNC_MAX VARCHAR(256) NOT NULL,
SHARNG_INVITATN_BLOCKED_MIN VARCHAR(256) NOT NULL,
SHARNG_INVITATN_BLOCKED_MAX VARCHAR(256) NOT NULL,
COMPANY_LINK_CREATIONS_MIN VARCHAR(256) NOT NULL,
COMPANY_LINK_CREATIONS_MAX VARCHAR(256) NOT NULL,
ACCESS_REQUEST_CREATIONS_MIN VARCHAR(256) NOT NULL,
ACCESS_REQUEST_CREATIONS_MAX VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_CREATIONS_MIN VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_CREATIONS_MAX VARCHAR(256) NOT NULL,
SHARNG_INVITATN_CREATION_MIN VARCHAR(256) NOT NULL,
SHARNG_INVITATN_CREATION_MAX VARCHAR(256) NOT NULL,
ACCESS_REQUEST_DENIALS_MIN VARCHAR(256) NOT NULL,
ACCESS_REQUEST_DENIALS_MAX VARCHAR(256) NOT NULL,
COMPANY_LINK_REMOVALS_MIN VARCHAR(256) NOT NULL,
COMPANY_LINK_REMOVALS_MAX VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_REMOVALS_MIN VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_REMOVALS_MAX VARCHAR(256) NOT NULL,
FILE_FOLDER_SITE_SHARE_MIN VARCHAR(256) NOT NULL,
FILE_FOLDER_SITE_SHARE_MAX VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_UPDATES_MIN VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_UPDATES_MAX VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_USAGE_MIN VARCHAR(256) NOT NULL,
ANONYMOUS_LINK_USAGE_MAX VARCHAR(256) NOT NULL,
SHARING_REVOKES_MIN VARCHAR(256) NOT NULL,
SHARING_REVOKES_MAX VARCHAR(256) NOT NULL,
COMPANY_LINK_USAGE_MIN VARCHAR(256) NOT NULL,
COMPANY_LINK_USAGE_MAX VARCHAR(256) NOT NULL,
SHARNG_INVITATN_WITHDRW_MIN VARCHAR(256) NOT NULL,
SHARNG_INVITATN_WITHDRW_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOSharngActTest_THRESH ADD constraint PK_SPOSharngActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSharngActTest_THRESH ON SPOSharngActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSharngActTest ON SPOSharngActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSharngActTest ON SPOSharngActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSyncActTest;
CREATE TABLE SPOSyncActTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_USERS DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_ST varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
UNIQUE_SITES DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_ST varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
FILE_SYNC_PERMITS DECIMAL(20,4) NOT NULL,
FILE_SYNC_PERMITS_ST varchar(32) NOT NULL,
FILE_SYNC_BLOCKS DECIMAL(20,4) NOT NULL,
FILE_SYNC_BLOCKS_ST varchar(32) NOT NULL,
FILE_DOWNLOADS DECIMAL(20,4) NOT NULL,
FILE_DOWNLOADS_ST varchar(32) NOT NULL,
FILE_CHANGES_DOWNLOADS DECIMAL(20,4) NOT NULL,
FILE_CHANGES_DOWNLOADS_ST varchar(32) NOT NULL,
FILE_UPLOADS DECIMAL(20,4) NOT NULL,
FILE_UPLOADS_ST varchar(32) NOT NULL,
FILE_CHANGES_UPLOADS DECIMAL(20,4) NOT NULL,
FILE_CHANGES_UPLOADS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOSyncActTest ON SPOSyncActTest(MSMT_TIME);
ALTER TABLE SPOSyncActTest ADD constraint PK_SPOSyncActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSyncActTest_TREND;
CREATE TABLE SPOSyncActTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_STCNT varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_STCNT varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
FILE_SYNC_PERMITS_MIN DECIMAL(20,4) NOT NULL,
FILE_SYNC_PERMITS_MAX DECIMAL(20,4) NOT NULL,
FILE_SYNC_PERMITS_STCNT varchar(32) NOT NULL,
FILE_SYNC_BLOCKS_MIN DECIMAL(20,4) NOT NULL,
FILE_SYNC_BLOCKS_MAX DECIMAL(20,4) NOT NULL,
FILE_SYNC_BLOCKS_STCNT varchar(32) NOT NULL,
FILE_DOWNLOADS_MIN DECIMAL(20,4) NOT NULL,
FILE_DOWNLOADS_MAX DECIMAL(20,4) NOT NULL,
FILE_DOWNLOADS_STCNT varchar(32) NOT NULL,
FILE_CHANGES_DOWNLOADS_MIN DECIMAL(20,4) NOT NULL,
FILE_CHANGES_DOWNLOADS_MAX DECIMAL(20,4) NOT NULL,
FILE_CHANGES_DOWNLOADS_STCNT varchar(32) NOT NULL,
FILE_UPLOADS_MIN DECIMAL(20,4) NOT NULL,
FILE_UPLOADS_MAX DECIMAL(20,4) NOT NULL,
FILE_UPLOADS_STCNT varchar(32) NOT NULL,
FILE_CHANGES_UPLOADS_MIN DECIMAL(20,4) NOT NULL,
FILE_CHANGES_UPLOADS_MAX DECIMAL(20,4) NOT NULL,
FILE_CHANGES_UPLOADS_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOSyncActTest_TREND ADD constraint PK_SPOSyncActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSyncActTest_THRESH;
CREATE TABLE SPOSyncActTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
FILE_SYNC_PERMITS_MIN VARCHAR(256) NOT NULL,
FILE_SYNC_PERMITS_MAX VARCHAR(256) NOT NULL,
FILE_SYNC_BLOCKS_MIN VARCHAR(256) NOT NULL,
FILE_SYNC_BLOCKS_MAX VARCHAR(256) NOT NULL,
FILE_DOWNLOADS_MIN VARCHAR(256) NOT NULL,
FILE_DOWNLOADS_MAX VARCHAR(256) NOT NULL,
FILE_CHANGES_DOWNLOADS_MIN VARCHAR(256) NOT NULL,
FILE_CHANGES_DOWNLOADS_MAX VARCHAR(256) NOT NULL,
FILE_UPLOADS_MIN VARCHAR(256) NOT NULL,
FILE_UPLOADS_MAX VARCHAR(256) NOT NULL,
FILE_CHANGES_UPLOADS_MIN VARCHAR(256) NOT NULL,
FILE_CHANGES_UPLOADS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOSyncActTest_THRESH ADD constraint PK_SPOSyncActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSyncActTest_THRESH ON SPOSyncActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSyncActTest ON SPOSyncActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSyncActTest ON SPOSyncActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSAdminActTest;
CREATE TABLE SPOSAdminActTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_OPERATIONS DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_OPERATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_ST varchar(32) NOT NULL,
UNIQUE_USERS DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_ST varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_ST varchar(32) NOT NULL,
UNIQUE_SITES DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_ST varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_ST varchar(32) NOT NULL,
UNIQUE_DESTINATIONS DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_ST varchar(32) NOT NULL,
UNIQUE_USER_AGENTS DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_ST varchar(32) NOT NULL,
USR_AGENT_EXMPT_ADDITION DECIMAL(20,4) NOT NULL,
USR_AGENT_EXMPT_ADDITION_ST varchar(32) NOT NULL,
USR_AGENT_EXMPT_MODIFITN DECIMAL(20,4) NOT NULL,
USR_AGENT_EXMPT_MODIFITN_ST varchar(32) NOT NULL,
SIT_COLLECTN_ADMIN_ADDTN DECIMAL(20,4) NOT NULL,
SIT_COLLECTN_ADMIN_ADDTN_ST varchar(32) NOT NULL,
USER_GROUP_ADDITIONS DECIMAL(20,4) NOT NULL,
USER_GROUP_ADDITIONS_ST varchar(32) NOT NULL,
ADD_USERGROUP_PERMITS DECIMAL(20,4) NOT NULL,
ADD_USERGROUP_PERMITS_ST varchar(32) NOT NULL,
SHARING_POLICY_MODIFCTN DECIMAL(20,4) NOT NULL,
SHARING_POLICY_MODIFCTN_ST varchar(32) NOT NULL,
GROUP_ADDITIONS DECIMAL(20,4) NOT NULL,
GROUP_ADDITIONS_ST varchar(32) NOT NULL,
SEND_TO_CONN_CREATION DECIMAL(20,4) NOT NULL,
SEND_TO_CONN_CREATION_ST varchar(32) NOT NULL,
SITE_COLLECTION_CREATION DECIMAL(20,4) NOT NULL,
SITE_COLLECTION_CREATION_ST varchar(32) NOT NULL,
GROUP_DELETES DECIMAL(20,4) NOT NULL,
GROUP_DELETES_ST varchar(32) NOT NULL,
SEND_TO_CONN_DELETES DECIMAL(20,4) NOT NULL,
SEND_TO_CONN_DELETES_ST varchar(32) NOT NULL,
SITE_DELETES DECIMAL(20,4) NOT NULL,
SITE_DELETES_ST varchar(32) NOT NULL,
DOCUMENT_PREVIEW_PERMITS DECIMAL(20,4) NOT NULL,
DOCUMENT_PREVIEW_PERMITS_ST varchar(32) NOT NULL,
WORKFLOW_TASK_CONTNT DECIMAL(20,4) NOT NULL,
WORKFLOW_TASK_CONTNT_ST varchar(32) NOT NULL,
OFFICE_ONDEMAND_PERMITS DECIMAL(20,4) NOT NULL,
OFFICE_ONDEMAND_PERMITS_ST varchar(32) NOT NULL,
NEWS_FEED_PERMITS DECIMAL(20,4) NOT NULL,
NEWS_FEED_PERMITS_ST varchar(32) NOT NULL,
SITE_PERMISSN_MODIFICTN DECIMAL(20,4) NOT NULL,
SITE_PERMISSN_MODIFICTN_ST varchar(32) NOT NULL,
REMOVALS_FROM_GROUP DECIMAL(20,4) NOT NULL,
REMOVALS_FROM_GROUP_ST varchar(32) NOT NULL,
SITE_RENAMES DECIMAL(20,4) NOT NULL,
SITE_RENAMES_ST varchar(32) NOT NULL,
SITE_ADMIN_REQUESTS DECIMAL(20,4) NOT NULL,
SITE_ADMIN_REQUESTS_ST varchar(32) NOT NULL,
HOST_SITE_CHANGES DECIMAL(20,4) NOT NULL,
HOST_SITE_CHANGES_ST varchar(32) NOT NULL,
GROUP_SETTINGS_CHANGES DECIMAL(20,4) NOT NULL,
GROUP_SETTINGS_CHANGES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_SPOSAdminActTest ON SPOSAdminActTest(MSMT_TIME);
ALTER TABLE SPOSAdminActTest ADD constraint PK_SPOSAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSAdminActTest_TREND;
CREATE TABLE SPOSAdminActTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_OPERATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_OPERATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USERS_STCNT varchar(32) NOT NULL,
UNIQUE_CLIENT_IPS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_CLIENT_IPS_STCNT varchar(32) NOT NULL,
UNIQUE_SITES_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SITES_STCNT varchar(32) NOT NULL,
AFFECTED_ITEM_TYPES_MIN DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_MAX DECIMAL(20,4) NOT NULL,
AFFECTED_ITEM_TYPES_STCNT varchar(32) NOT NULL,
UNIQUE_DESTINATIONS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_DESTINATIONS_STCNT varchar(32) NOT NULL,
UNIQUE_USER_AGENTS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_USER_AGENTS_STCNT varchar(32) NOT NULL,
USR_AGENT_EXMPT_ADDITION_MIN DECIMAL(20,4) NOT NULL,
USR_AGENT_EXMPT_ADDITION_MAX DECIMAL(20,4) NOT NULL,
USR_AGENT_EXMPT_ADDITION_STCNT varchar(32) NOT NULL,
USR_AGENT_EXMPT_MODIFITN_MIN DECIMAL(20,4) NOT NULL,
USR_AGENT_EXMPT_MODIFITN_MAX DECIMAL(20,4) NOT NULL,
USR_AGENT_EXMPT_MODIFITN_STCNT varchar(32) NOT NULL,
SIT_COLLECTN_ADMIN_ADDTN_MIN DECIMAL(20,4) NOT NULL,
SIT_COLLECTN_ADMIN_ADDTN_MAX DECIMAL(20,4) NOT NULL,
SIT_COLLECTN_ADMIN_ADDTN_STCNT varchar(32) NOT NULL,
USER_GROUP_ADDITIONS_MIN DECIMAL(20,4) NOT NULL,
USER_GROUP_ADDITIONS_MAX DECIMAL(20,4) NOT NULL,
USER_GROUP_ADDITIONS_STCNT varchar(32) NOT NULL,
ADD_USERGROUP_PERMITS_MIN DECIMAL(20,4) NOT NULL,
ADD_USERGROUP_PERMITS_MAX DECIMAL(20,4) NOT NULL,
ADD_USERGROUP_PERMITS_STCNT varchar(32) NOT NULL,
SHARING_POLICY_MODIFCTN_MIN DECIMAL(20,4) NOT NULL,
SHARING_POLICY_MODIFCTN_MAX DECIMAL(20,4) NOT NULL,
SHARING_POLICY_MODIFCTN_STCNT varchar(32) NOT NULL,
GROUP_ADDITIONS_MIN DECIMAL(20,4) NOT NULL,
GROUP_ADDITIONS_MAX DECIMAL(20,4) NOT NULL,
GROUP_ADDITIONS_STCNT varchar(32) NOT NULL,
SEND_TO_CONN_CREATION_MIN DECIMAL(20,4) NOT NULL,
SEND_TO_CONN_CREATION_MAX DECIMAL(20,4) NOT NULL,
SEND_TO_CONN_CREATION_STCNT varchar(32) NOT NULL,
SITE_COLLECTION_CREATION_MIN DECIMAL(20,4) NOT NULL,
SITE_COLLECTION_CREATION_MAX DECIMAL(20,4) NOT NULL,
SITE_COLLECTION_CREATION_STCNT varchar(32) NOT NULL,
GROUP_DELETES_MIN DECIMAL(20,4) NOT NULL,
GROUP_DELETES_MAX DECIMAL(20,4) NOT NULL,
GROUP_DELETES_STCNT varchar(32) NOT NULL,
SEND_TO_CONN_DELETES_MIN DECIMAL(20,4) NOT NULL,
SEND_TO_CONN_DELETES_MAX DECIMAL(20,4) NOT NULL,
SEND_TO_CONN_DELETES_STCNT varchar(32) NOT NULL,
SITE_DELETES_MIN DECIMAL(20,4) NOT NULL,
SITE_DELETES_MAX DECIMAL(20,4) NOT NULL,
SITE_DELETES_STCNT varchar(32) NOT NULL,
DOCUMENT_PREVIEW_PERMITS_MIN DECIMAL(20,4) NOT NULL,
DOCUMENT_PREVIEW_PERMITS_MAX DECIMAL(20,4) NOT NULL,
DOCUMENT_PREVIEW_PERMITS_STCNT varchar(32) NOT NULL,
WORKFLOW_TASK_CONTNT_MIN DECIMAL(20,4) NOT NULL,
WORKFLOW_TASK_CONTNT_MAX DECIMAL(20,4) NOT NULL,
WORKFLOW_TASK_CONTNT_STCNT varchar(32) NOT NULL,
OFFICE_ONDEMAND_PERMITS_MIN DECIMAL(20,4) NOT NULL,
OFFICE_ONDEMAND_PERMITS_MAX DECIMAL(20,4) NOT NULL,
OFFICE_ONDEMAND_PERMITS_STCNT varchar(32) NOT NULL,
NEWS_FEED_PERMITS_MIN DECIMAL(20,4) NOT NULL,
NEWS_FEED_PERMITS_MAX DECIMAL(20,4) NOT NULL,
NEWS_FEED_PERMITS_STCNT varchar(32) NOT NULL,
SITE_PERMISSN_MODIFICTN_MIN DECIMAL(20,4) NOT NULL,
SITE_PERMISSN_MODIFICTN_MAX DECIMAL(20,4) NOT NULL,
SITE_PERMISSN_MODIFICTN_STCNT varchar(32) NOT NULL,
REMOVALS_FROM_GROUP_MIN DECIMAL(20,4) NOT NULL,
REMOVALS_FROM_GROUP_MAX DECIMAL(20,4) NOT NULL,
REMOVALS_FROM_GROUP_STCNT varchar(32) NOT NULL,
SITE_RENAMES_MIN DECIMAL(20,4) NOT NULL,
SITE_RENAMES_MAX DECIMAL(20,4) NOT NULL,
SITE_RENAMES_STCNT varchar(32) NOT NULL,
SITE_ADMIN_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
SITE_ADMIN_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
SITE_ADMIN_REQUESTS_STCNT varchar(32) NOT NULL,
HOST_SITE_CHANGES_MIN DECIMAL(20,4) NOT NULL,
HOST_SITE_CHANGES_MAX DECIMAL(20,4) NOT NULL,
HOST_SITE_CHANGES_STCNT varchar(32) NOT NULL,
GROUP_SETTINGS_CHANGES_MIN DECIMAL(20,4) NOT NULL,
GROUP_SETTINGS_CHANGES_MAX DECIMAL(20,4) NOT NULL,
GROUP_SETTINGS_CHANGES_STCNT varchar(32) NOT NULL);

ALTER TABLE SPOSAdminActTest_TREND ADD constraint PK_SPOSAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSAdminActTest_THRESH;
CREATE TABLE SPOSAdminActTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_OPERATIONS_MIN VARCHAR(256) NOT NULL,
TOTAL_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_OPERATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USERS_MAX VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MIN VARCHAR(256) NOT NULL,
UNIQUE_CLIENT_IPS_MAX VARCHAR(256) NOT NULL,
UNIQUE_SITES_MIN VARCHAR(256) NOT NULL,
UNIQUE_SITES_MAX VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MIN VARCHAR(256) NOT NULL,
AFFECTED_ITEM_TYPES_MAX VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MIN VARCHAR(256) NOT NULL,
UNIQUE_DESTINATIONS_MAX VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MIN VARCHAR(256) NOT NULL,
UNIQUE_USER_AGENTS_MAX VARCHAR(256) NOT NULL,
USR_AGENT_EXMPT_ADDITION_MIN VARCHAR(256) NOT NULL,
USR_AGENT_EXMPT_ADDITION_MAX VARCHAR(256) NOT NULL,
USR_AGENT_EXMPT_MODIFITN_MIN VARCHAR(256) NOT NULL,
USR_AGENT_EXMPT_MODIFITN_MAX VARCHAR(256) NOT NULL,
SIT_COLLECTN_ADMIN_ADDTN_MIN VARCHAR(256) NOT NULL,
SIT_COLLECTN_ADMIN_ADDTN_MAX VARCHAR(256) NOT NULL,
USER_GROUP_ADDITIONS_MIN VARCHAR(256) NOT NULL,
USER_GROUP_ADDITIONS_MAX VARCHAR(256) NOT NULL,
ADD_USERGROUP_PERMITS_MIN VARCHAR(256) NOT NULL,
ADD_USERGROUP_PERMITS_MAX VARCHAR(256) NOT NULL,
SHARING_POLICY_MODIFCTN_MIN VARCHAR(256) NOT NULL,
SHARING_POLICY_MODIFCTN_MAX VARCHAR(256) NOT NULL,
GROUP_ADDITIONS_MIN VARCHAR(256) NOT NULL,
GROUP_ADDITIONS_MAX VARCHAR(256) NOT NULL,
SEND_TO_CONN_CREATION_MIN VARCHAR(256) NOT NULL,
SEND_TO_CONN_CREATION_MAX VARCHAR(256) NOT NULL,
SITE_COLLECTION_CREATION_MIN VARCHAR(256) NOT NULL,
SITE_COLLECTION_CREATION_MAX VARCHAR(256) NOT NULL,
GROUP_DELETES_MIN VARCHAR(256) NOT NULL,
GROUP_DELETES_MAX VARCHAR(256) NOT NULL,
SEND_TO_CONN_DELETES_MIN VARCHAR(256) NOT NULL,
SEND_TO_CONN_DELETES_MAX VARCHAR(256) NOT NULL,
SITE_DELETES_MIN VARCHAR(256) NOT NULL,
SITE_DELETES_MAX VARCHAR(256) NOT NULL,
DOCUMENT_PREVIEW_PERMITS_MIN VARCHAR(256) NOT NULL,
DOCUMENT_PREVIEW_PERMITS_MAX VARCHAR(256) NOT NULL,
WORKFLOW_TASK_CONTNT_MIN VARCHAR(256) NOT NULL,
WORKFLOW_TASK_CONTNT_MAX VARCHAR(256) NOT NULL,
OFFICE_ONDEMAND_PERMITS_MIN VARCHAR(256) NOT NULL,
OFFICE_ONDEMAND_PERMITS_MAX VARCHAR(256) NOT NULL,
NEWS_FEED_PERMITS_MIN VARCHAR(256) NOT NULL,
NEWS_FEED_PERMITS_MAX VARCHAR(256) NOT NULL,
SITE_PERMISSN_MODIFICTN_MIN VARCHAR(256) NOT NULL,
SITE_PERMISSN_MODIFICTN_MAX VARCHAR(256) NOT NULL,
REMOVALS_FROM_GROUP_MIN VARCHAR(256) NOT NULL,
REMOVALS_FROM_GROUP_MAX VARCHAR(256) NOT NULL,
SITE_RENAMES_MIN VARCHAR(256) NOT NULL,
SITE_RENAMES_MAX VARCHAR(256) NOT NULL,
SITE_ADMIN_REQUESTS_MIN VARCHAR(256) NOT NULL,
SITE_ADMIN_REQUESTS_MAX VARCHAR(256) NOT NULL,
HOST_SITE_CHANGES_MIN VARCHAR(256) NOT NULL,
HOST_SITE_CHANGES_MAX VARCHAR(256) NOT NULL,
GROUP_SETTINGS_CHANGES_MIN VARCHAR(256) NOT NULL,
GROUP_SETTINGS_CHANGES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SPOSAdminActTest_THRESH ADD constraint PK_SPOSAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSAdminActTest_THRESH ON SPOSAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSAdminActTest ON SPOSAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSAdminActTest ON SPOSAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailBoxTest;
CREATE TABLE EXOMailBoxTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_MAILBOXES DECIMAL(20,4) NOT NULL,
TOTAL_MAILBOXES_ST varchar(32) NOT NULL,
FRWDMAILBX DECIMAL(20,4) NOT NULL,
FRWDMAILBX_ST varchar(32) NOT NULL,
LITIGATION_HOLD DECIMAL(20,4) NOT NULL,
LITIGATION_HOLD_ST varchar(32) NOT NULL,
INPLACE_HOLD DECIMAL(20,4) NOT NULL,
INPLACE_HOLD_ST varchar(32) NOT NULL,
ALLMAILBOX_HOLD DECIMAL(20,4) NOT NULL,
ALLMAILBOX_HOLD_ST varchar(32) NOT NULL,
SHRDMAILBX DECIMAL(20,4) NOT NULL,
SHRDMAILBX_ST varchar(32) NOT NULL,
NEWLYCREATEMAILBX DECIMAL(20,4) NOT NULL,
NEWLYCREATEMAILBX_ST varchar(32) NOT NULL,
RECNTMODIFYMAILBX DECIMAL(20,4) NOT NULL,
RECNTMODIFYMAILBX_ST varchar(32) NOT NULL,
SOFTDELETEMAILBX DECIMAL(20,4) NOT NULL,
SOFTDELETEMAILBX_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOMailBoxTest ON EXOMailBoxTest(MSMT_TIME);
ALTER TABLE EXOMailBoxTest ADD constraint PK_EXOMailBoxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxTest_TREND;
CREATE TABLE EXOMailBoxTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_MAILBOXES_MIN DECIMAL(20,4) NOT NULL,
TOTAL_MAILBOXES_MAX DECIMAL(20,4) NOT NULL,
TOTAL_MAILBOXES_STCNT varchar(32) NOT NULL,
FRWDMAILBX_MIN DECIMAL(20,4) NOT NULL,
FRWDMAILBX_MAX DECIMAL(20,4) NOT NULL,
FRWDMAILBX_STCNT varchar(32) NOT NULL,
LITIGATION_HOLD_MIN DECIMAL(20,4) NOT NULL,
LITIGATION_HOLD_MAX DECIMAL(20,4) NOT NULL,
LITIGATION_HOLD_STCNT varchar(32) NOT NULL,
INPLACE_HOLD_MIN DECIMAL(20,4) NOT NULL,
INPLACE_HOLD_MAX DECIMAL(20,4) NOT NULL,
INPLACE_HOLD_STCNT varchar(32) NOT NULL,
ALLMAILBOX_HOLD_MIN DECIMAL(20,4) NOT NULL,
ALLMAILBOX_HOLD_MAX DECIMAL(20,4) NOT NULL,
ALLMAILBOX_HOLD_STCNT varchar(32) NOT NULL,
SHRDMAILBX_MIN DECIMAL(20,4) NOT NULL,
SHRDMAILBX_MAX DECIMAL(20,4) NOT NULL,
SHRDMAILBX_STCNT varchar(32) NOT NULL,
NEWLYCREATEMAILBX_MIN DECIMAL(20,4) NOT NULL,
NEWLYCREATEMAILBX_MAX DECIMAL(20,4) NOT NULL,
NEWLYCREATEMAILBX_STCNT varchar(32) NOT NULL,
RECNTMODIFYMAILBX_MIN DECIMAL(20,4) NOT NULL,
RECNTMODIFYMAILBX_MAX DECIMAL(20,4) NOT NULL,
RECNTMODIFYMAILBX_STCNT varchar(32) NOT NULL,
SOFTDELETEMAILBX_MIN DECIMAL(20,4) NOT NULL,
SOFTDELETEMAILBX_MAX DECIMAL(20,4) NOT NULL,
SOFTDELETEMAILBX_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOMailBoxTest_TREND ADD constraint PK_EXOMailBoxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxTest_THRESH;
CREATE TABLE EXOMailBoxTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_MAILBOXES_MIN VARCHAR(256) NOT NULL,
TOTAL_MAILBOXES_MAX VARCHAR(256) NOT NULL,
FRWDMAILBX_MIN VARCHAR(256) NOT NULL,
FRWDMAILBX_MAX VARCHAR(256) NOT NULL,
LITIGATION_HOLD_MIN VARCHAR(256) NOT NULL,
LITIGATION_HOLD_MAX VARCHAR(256) NOT NULL,
INPLACE_HOLD_MIN VARCHAR(256) NOT NULL,
INPLACE_HOLD_MAX VARCHAR(256) NOT NULL,
ALLMAILBOX_HOLD_MIN VARCHAR(256) NOT NULL,
ALLMAILBOX_HOLD_MAX VARCHAR(256) NOT NULL,
SHRDMAILBX_MIN VARCHAR(256) NOT NULL,
SHRDMAILBX_MAX VARCHAR(256) NOT NULL,
NEWLYCREATEMAILBX_MIN VARCHAR(256) NOT NULL,
NEWLYCREATEMAILBX_MAX VARCHAR(256) NOT NULL,
RECNTMODIFYMAILBX_MIN VARCHAR(256) NOT NULL,
RECNTMODIFYMAILBX_MAX VARCHAR(256) NOT NULL,
SOFTDELETEMAILBX_MIN VARCHAR(256) NOT NULL,
SOFTDELETEMAILBX_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOMailBoxTest_THRESH ADD constraint PK_EXOMailBoxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxTest_THRESH ON EXOMailBoxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxTest ON EXOMailBoxTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxTest ON EXOMailBoxTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailBoxStatsTest;
CREATE TABLE EXOMailBoxStatsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_MAILBOX_SIZE DECIMAL(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_ST varchar(32) NOT NULL,
MAILBOXES_GROWTH_RATE DECIMAL(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_ST varchar(32) NOT NULL,
MAILBOXES_OVER_QUOTA DECIMAL(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_ST varchar(32) NOT NULL,
INACTIVE_MAILBOXES DECIMAL(20,4) NOT NULL,
INACTIVE_MAILBOXES_ST varchar(32) NOT NULL,
INACTIVE_MAILBOXES_SIZE DECIMAL(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_ST varchar(32) NOT NULL,
ARCHIVE_MAILBOXES DECIMAL(20,4) NOT NULL,
ARCHIVE_MAILBOXES_ST varchar(32) NOT NULL,
ARCHIVE_MAILBOXES_SIZE DECIMAL(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_ST varchar(32) NOT NULL,
CLUTTER_ENABLED_MAILBOX DECIMAL(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_ST varchar(32) NOT NULL,
CLUTTER_DISABLED_MAILBOX DECIMAL(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_ST varchar(32) NOT NULL,
DBSNDQTE DECIMAL(20,4) NOT NULL,
DBSNDQTE_ST varchar(32) NOT NULL,
DBSNDRECQTE DECIMAL(20,4) NOT NULL,
DBSNDRECQTE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOMailBoxStatsTest ON EXOMailBoxStatsTest(MSMT_TIME);
ALTER TABLE EXOMailBoxStatsTest ADD constraint PK_EXOMailBoxStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxStatsTest_TREND;
CREATE TABLE EXOMailBoxStatsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_MAILBOX_SIZE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_STCNT varchar(32) NOT NULL,
MAILBOXES_GROWTH_RATE_MIN DECIMAL(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_MAX DECIMAL(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_STCNT varchar(32) NOT NULL,
MAILBOXES_OVER_QUOTA_MIN DECIMAL(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_MAX DECIMAL(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_STCNT varchar(32) NOT NULL,
INACTIVE_MAILBOXES_MIN DECIMAL(20,4) NOT NULL,
INACTIVE_MAILBOXES_MAX DECIMAL(20,4) NOT NULL,
INACTIVE_MAILBOXES_STCNT varchar(32) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MIN DECIMAL(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MAX DECIMAL(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_STCNT varchar(32) NOT NULL,
ARCHIVE_MAILBOXES_MIN DECIMAL(20,4) NOT NULL,
ARCHIVE_MAILBOXES_MAX DECIMAL(20,4) NOT NULL,
ARCHIVE_MAILBOXES_STCNT varchar(32) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MIN DECIMAL(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MAX DECIMAL(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_STCNT varchar(32) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MIN DECIMAL(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MAX DECIMAL(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_STCNT varchar(32) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MIN DECIMAL(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MAX DECIMAL(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_STCNT varchar(32) NOT NULL,
DBSNDQTE_MIN DECIMAL(20,4) NOT NULL,
DBSNDQTE_MAX DECIMAL(20,4) NOT NULL,
DBSNDQTE_STCNT varchar(32) NOT NULL,
DBSNDRECQTE_MIN DECIMAL(20,4) NOT NULL,
DBSNDRECQTE_MAX DECIMAL(20,4) NOT NULL,
DBSNDRECQTE_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOMailBoxStatsTest_TREND ADD constraint PK_EXOMailBoxStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxStatsTest_THRESH;
CREATE TABLE EXOMailBoxStatsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_MAILBOX_SIZE_MIN VARCHAR(256) NOT NULL,
TOTAL_MAILBOX_SIZE_MAX VARCHAR(256) NOT NULL,
MAILBOXES_GROWTH_RATE_MIN VARCHAR(256) NOT NULL,
MAILBOXES_GROWTH_RATE_MAX VARCHAR(256) NOT NULL,
MAILBOXES_OVER_QUOTA_MIN VARCHAR(256) NOT NULL,
MAILBOXES_OVER_QUOTA_MAX VARCHAR(256) NOT NULL,
INACTIVE_MAILBOXES_MIN VARCHAR(256) NOT NULL,
INACTIVE_MAILBOXES_MAX VARCHAR(256) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MIN VARCHAR(256) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MAX VARCHAR(256) NOT NULL,
ARCHIVE_MAILBOXES_MIN VARCHAR(256) NOT NULL,
ARCHIVE_MAILBOXES_MAX VARCHAR(256) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MIN VARCHAR(256) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MAX VARCHAR(256) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MIN VARCHAR(256) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MAX VARCHAR(256) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MIN VARCHAR(256) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MAX VARCHAR(256) NOT NULL,
DBSNDQTE_MIN VARCHAR(256) NOT NULL,
DBSNDQTE_MAX VARCHAR(256) NOT NULL,
DBSNDRECQTE_MIN VARCHAR(256) NOT NULL,
DBSNDRECQTE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOMailBoxStatsTest_THRESH ADD constraint PK_EXOMailBoxStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxStatsTest_THRESH ON EXOMailBoxStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxStatsTest ON EXOMailBoxStatsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxStatsTest ON EXOMailBoxStatsTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOUsersTest;
CREATE TABLE EXOUsersTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Activesync DECIMAL(20,4) NOT NULL,
Activesync_ST varchar(32) NOT NULL,
Non_Activesync DECIMAL(20,4) NOT NULL,
Non_Activesync_ST varchar(32) NOT NULL,
SendAsUsers DECIMAL(20,4) NOT NULL,
SendAsUsers_ST varchar(32) NOT NULL,
SendOnBehlfUsers DECIMAL(20,4) NOT NULL,
SendOnBehlfUsers_ST varchar(32) NOT NULL,
AdminUsers DECIMAL(20,4) NOT NULL,
AdminUsers_ST varchar(32) NOT NULL,
ActvUser DECIMAL(20,4) NOT NULL,
ActvUser_ST varchar(32) NOT NULL,
InActvUser DECIMAL(20,4) NOT NULL,
InActvUser_ST varchar(32) NOT NULL,
NvrLogUser DECIMAL(20,4) NOT NULL,
NvrLogUser_ST varchar(32) NOT NULL,
PassExpUsers DECIMAL(20,4) NOT NULL,
PassExpUsers_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOUsersTest ON EXOUsersTest(MSMT_TIME);
ALTER TABLE EXOUsersTest ADD constraint PK_EXOUsersTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsersTest_TREND;
CREATE TABLE EXOUsersTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Activesync_MIN DECIMAL(20,4) NOT NULL,
Activesync_MAX DECIMAL(20,4) NOT NULL,
Activesync_STCNT varchar(32) NOT NULL,
Non_Activesync_MIN DECIMAL(20,4) NOT NULL,
Non_Activesync_MAX DECIMAL(20,4) NOT NULL,
Non_Activesync_STCNT varchar(32) NOT NULL,
SendAsUsers_MIN DECIMAL(20,4) NOT NULL,
SendAsUsers_MAX DECIMAL(20,4) NOT NULL,
SendAsUsers_STCNT varchar(32) NOT NULL,
SendOnBehlfUsers_MIN DECIMAL(20,4) NOT NULL,
SendOnBehlfUsers_MAX DECIMAL(20,4) NOT NULL,
SendOnBehlfUsers_STCNT varchar(32) NOT NULL,
AdminUsers_MIN DECIMAL(20,4) NOT NULL,
AdminUsers_MAX DECIMAL(20,4) NOT NULL,
AdminUsers_STCNT varchar(32) NOT NULL,
ActvUser_MIN DECIMAL(20,4) NOT NULL,
ActvUser_MAX DECIMAL(20,4) NOT NULL,
ActvUser_STCNT varchar(32) NOT NULL,
InActvUser_MIN DECIMAL(20,4) NOT NULL,
InActvUser_MAX DECIMAL(20,4) NOT NULL,
InActvUser_STCNT varchar(32) NOT NULL,
NvrLogUser_MIN DECIMAL(20,4) NOT NULL,
NvrLogUser_MAX DECIMAL(20,4) NOT NULL,
NvrLogUser_STCNT varchar(32) NOT NULL,
PassExpUsers_MIN DECIMAL(20,4) NOT NULL,
PassExpUsers_MAX DECIMAL(20,4) NOT NULL,
PassExpUsers_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOUsersTest_TREND ADD constraint PK_EXOUsersTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsersTest_THRESH;
CREATE TABLE EXOUsersTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Activesync_MIN VARCHAR(256) NOT NULL,
Activesync_MAX VARCHAR(256) NOT NULL,
Non_Activesync_MIN VARCHAR(256) NOT NULL,
Non_Activesync_MAX VARCHAR(256) NOT NULL,
SendAsUsers_MIN VARCHAR(256) NOT NULL,
SendAsUsers_MAX VARCHAR(256) NOT NULL,
SendOnBehlfUsers_MIN VARCHAR(256) NOT NULL,
SendOnBehlfUsers_MAX VARCHAR(256) NOT NULL,
AdminUsers_MIN VARCHAR(256) NOT NULL,
AdminUsers_MAX VARCHAR(256) NOT NULL,
ActvUser_MIN VARCHAR(256) NOT NULL,
ActvUser_MAX VARCHAR(256) NOT NULL,
InActvUser_MIN VARCHAR(256) NOT NULL,
InActvUser_MAX VARCHAR(256) NOT NULL,
NvrLogUser_MIN VARCHAR(256) NOT NULL,
NvrLogUser_MAX VARCHAR(256) NOT NULL,
PassExpUsers_MIN VARCHAR(256) NOT NULL,
PassExpUsers_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOUsersTest_THRESH ADD constraint PK_EXOUsersTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsersTest_THRESH ON EXOUsersTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsersTest ON EXOUsersTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsersTest ON EXOUsersTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOReciTypeTest;
CREATE TABLE EXOReciTypeTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Count DECIMAL(20,4) NOT NULL,
Count_ST varchar(32) NOT NULL,
Mailboxes_Size DECIMAL(20,4) NOT NULL,
Mailboxes_Size_ST varchar(32) NOT NULL,
Item_Count DECIMAL(20,4) NOT NULL,
Item_Count_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOReciTypeTest ON EXOReciTypeTest(MSMT_TIME);
ALTER TABLE EXOReciTypeTest ADD constraint PK_EXOReciTypeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOReciTypeTest_TREND;
CREATE TABLE EXOReciTypeTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Count_MIN DECIMAL(20,4) NOT NULL,
Count_MAX DECIMAL(20,4) NOT NULL,
Count_STCNT varchar(32) NOT NULL,
Mailboxes_Size_MIN DECIMAL(20,4) NOT NULL,
Mailboxes_Size_MAX DECIMAL(20,4) NOT NULL,
Mailboxes_Size_STCNT varchar(32) NOT NULL,
Item_Count_MIN DECIMAL(20,4) NOT NULL,
Item_Count_MAX DECIMAL(20,4) NOT NULL,
Item_Count_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOReciTypeTest_TREND ADD constraint PK_EXOReciTypeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOReciTypeTest_THRESH;
CREATE TABLE EXOReciTypeTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Count_MIN VARCHAR(256) NOT NULL,
Count_MAX VARCHAR(256) NOT NULL,
Mailboxes_Size_MIN VARCHAR(256) NOT NULL,
Mailboxes_Size_MAX VARCHAR(256) NOT NULL,
Item_Count_MIN VARCHAR(256) NOT NULL,
Item_Count_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOReciTypeTest_THRESH ADD constraint PK_EXOReciTypeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOReciTypeTest_THRESH ON EXOReciTypeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOReciTypeTest ON EXOReciTypeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOReciTypeTest ON EXOReciTypeTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailTrfcStatisTest;
CREATE TABLE EXOMailTrfcStatisTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Unique_Senders DECIMAL(20,4) NOT NULL,
Unique_Senders_ST varchar(32) NOT NULL,
Unique_Receivers DECIMAL(20,4) NOT NULL,
Unique_Receivers_ST varchar(32) NOT NULL,
Unique_Sender_IPs DECIMAL(20,4) NOT NULL,
Unique_Sender_IPs_ST varchar(32) NOT NULL,
Inbound_Mail_Items DECIMAL(20,4) NOT NULL,
Inbound_Mail_Items_ST varchar(32) NOT NULL,
Inbound_Mails_Size DECIMAL(20,4) NOT NULL,
Inbound_Mails_Size_ST varchar(32) NOT NULL,
Outbound_Mail_Items DECIMAL(20,4) NOT NULL,
Outbound_Mail_Items_ST varchar(32) NOT NULL,
Outbound_Mails_Size DECIMAL(20,4) NOT NULL,
Outbound_Mails_Size_ST varchar(32) NOT NULL,
Total_Mail_Items DECIMAL(20,4) NOT NULL,
Total_Mail_Items_ST varchar(32) NOT NULL,
Total_Mails_Size DECIMAL(20,4) NOT NULL,
Total_Mails_Size_ST varchar(32) NOT NULL,
Internal_emails_sent DECIMAL(20,4) NOT NULL,
Internal_emails_sent_ST varchar(32) NOT NULL,
Size_Intl_mailsent DECIMAL(20,4) NOT NULL,
Size_Intl_mailsent_ST varchar(32) NOT NULL,
Internal_emails_recvd DECIMAL(20,4) NOT NULL,
Internal_emails_recvd_ST varchar(32) NOT NULL,
Size_Intl_mailrecvd DECIMAL(20,4) NOT NULL,
Size_Intl_mailrecvd_ST varchar(32) NOT NULL,
External_emails_sent DECIMAL(20,4) NOT NULL,
External_emails_sent_ST varchar(32) NOT NULL,
Size_exrtl_mailsent DECIMAL(20,4) NOT NULL,
Size_exrtl_mailsent_ST varchar(32) NOT NULL,
External_emails_recvd DECIMAL(20,4) NOT NULL,
External_emails_recvd_ST varchar(32) NOT NULL,
Size_extl_mailrecvd DECIMAL(20,4) NOT NULL,
Size_extl_mailrecvd_ST varchar(32) NOT NULL,
Nonecnt DECIMAL(20,4) NOT NULL,
Nonecnt_ST varchar(32) NOT NULL,
Failedcnt DECIMAL(20,4) NOT NULL,
Failedcnt_ST varchar(32) NOT NULL,
Pendingcnt DECIMAL(20,4) NOT NULL,
Pendingcnt_ST varchar(32) NOT NULL,
Delvrycnt DECIMAL(20,4) NOT NULL,
Delvrycnt_ST varchar(32) NOT NULL,
Expandcnt DECIMAL(20,4) NOT NULL,
Expandcnt_ST varchar(32) NOT NULL,
Unq_outbud_doms DECIMAL(20,4) NOT NULL,
Unq_outbud_doms_ST varchar(32) NOT NULL,
Unq_innbud_doms DECIMAL(20,4) NOT NULL,
Unq_innbud_doms_ST varchar(32) NOT NULL,
Resloved DECIMAL(20,4) NOT NULL,
Resloved_ST varchar(32) NOT NULL,
Filtered_as_spam DECIMAL(20,4) NOT NULL,
Filtered_as_spam_ST varchar(32) NOT NULL,
Getting_status DECIMAL(20,4) NOT NULL,
Getting_status_ST varchar(32) NOT NULL,
Quarantined DECIMAL(20,4) NOT NULL,
Quarantined_ST varchar(32) NOT NULL,
Unknown DECIMAL(20,4) NOT NULL,
Unknown_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest(MSMT_TIME);
ALTER TABLE EXOMailTrfcStatisTest ADD constraint PK_EXOMailTrfcStatisTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailTrfcStatisTest_TREND;
CREATE TABLE EXOMailTrfcStatisTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Unique_Senders_MIN DECIMAL(20,4) NOT NULL,
Unique_Senders_MAX DECIMAL(20,4) NOT NULL,
Unique_Senders_STCNT varchar(32) NOT NULL,
Unique_Receivers_MIN DECIMAL(20,4) NOT NULL,
Unique_Receivers_MAX DECIMAL(20,4) NOT NULL,
Unique_Receivers_STCNT varchar(32) NOT NULL,
Unique_Sender_IPs_MIN DECIMAL(20,4) NOT NULL,
Unique_Sender_IPs_MAX DECIMAL(20,4) NOT NULL,
Unique_Sender_IPs_STCNT varchar(32) NOT NULL,
Inbound_Mail_Items_MIN DECIMAL(20,4) NOT NULL,
Inbound_Mail_Items_MAX DECIMAL(20,4) NOT NULL,
Inbound_Mail_Items_STCNT varchar(32) NOT NULL,
Inbound_Mails_Size_MIN DECIMAL(20,4) NOT NULL,
Inbound_Mails_Size_MAX DECIMAL(20,4) NOT NULL,
Inbound_Mails_Size_STCNT varchar(32) NOT NULL,
Outbound_Mail_Items_MIN DECIMAL(20,4) NOT NULL,
Outbound_Mail_Items_MAX DECIMAL(20,4) NOT NULL,
Outbound_Mail_Items_STCNT varchar(32) NOT NULL,
Outbound_Mails_Size_MIN DECIMAL(20,4) NOT NULL,
Outbound_Mails_Size_MAX DECIMAL(20,4) NOT NULL,
Outbound_Mails_Size_STCNT varchar(32) NOT NULL,
Total_Mail_Items_MIN DECIMAL(20,4) NOT NULL,
Total_Mail_Items_MAX DECIMAL(20,4) NOT NULL,
Total_Mail_Items_STCNT varchar(32) NOT NULL,
Total_Mails_Size_MIN DECIMAL(20,4) NOT NULL,
Total_Mails_Size_MAX DECIMAL(20,4) NOT NULL,
Total_Mails_Size_STCNT varchar(32) NOT NULL,
Internal_emails_sent_MIN DECIMAL(20,4) NOT NULL,
Internal_emails_sent_MAX DECIMAL(20,4) NOT NULL,
Internal_emails_sent_STCNT varchar(32) NOT NULL,
Size_Intl_mailsent_MIN DECIMAL(20,4) NOT NULL,
Size_Intl_mailsent_MAX DECIMAL(20,4) NOT NULL,
Size_Intl_mailsent_STCNT varchar(32) NOT NULL,
Internal_emails_recvd_MIN DECIMAL(20,4) NOT NULL,
Internal_emails_recvd_MAX DECIMAL(20,4) NOT NULL,
Internal_emails_recvd_STCNT varchar(32) NOT NULL,
Size_Intl_mailrecvd_MIN DECIMAL(20,4) NOT NULL,
Size_Intl_mailrecvd_MAX DECIMAL(20,4) NOT NULL,
Size_Intl_mailrecvd_STCNT varchar(32) NOT NULL,
External_emails_sent_MIN DECIMAL(20,4) NOT NULL,
External_emails_sent_MAX DECIMAL(20,4) NOT NULL,
External_emails_sent_STCNT varchar(32) NOT NULL,
Size_exrtl_mailsent_MIN DECIMAL(20,4) NOT NULL,
Size_exrtl_mailsent_MAX DECIMAL(20,4) NOT NULL,
Size_exrtl_mailsent_STCNT varchar(32) NOT NULL,
External_emails_recvd_MIN DECIMAL(20,4) NOT NULL,
External_emails_recvd_MAX DECIMAL(20,4) NOT NULL,
External_emails_recvd_STCNT varchar(32) NOT NULL,
Size_extl_mailrecvd_MIN DECIMAL(20,4) NOT NULL,
Size_extl_mailrecvd_MAX DECIMAL(20,4) NOT NULL,
Size_extl_mailrecvd_STCNT varchar(32) NOT NULL,
Nonecnt_MIN DECIMAL(20,4) NOT NULL,
Nonecnt_MAX DECIMAL(20,4) NOT NULL,
Nonecnt_STCNT varchar(32) NOT NULL,
Failedcnt_MIN DECIMAL(20,4) NOT NULL,
Failedcnt_MAX DECIMAL(20,4) NOT NULL,
Failedcnt_STCNT varchar(32) NOT NULL,
Pendingcnt_MIN DECIMAL(20,4) NOT NULL,
Pendingcnt_MAX DECIMAL(20,4) NOT NULL,
Pendingcnt_STCNT varchar(32) NOT NULL,
Delvrycnt_MIN DECIMAL(20,4) NOT NULL,
Delvrycnt_MAX DECIMAL(20,4) NOT NULL,
Delvrycnt_STCNT varchar(32) NOT NULL,
Expandcnt_MIN DECIMAL(20,4) NOT NULL,
Expandcnt_MAX DECIMAL(20,4) NOT NULL,
Expandcnt_STCNT varchar(32) NOT NULL,
Unq_outbud_doms_MIN DECIMAL(20,4) NOT NULL,
Unq_outbud_doms_MAX DECIMAL(20,4) NOT NULL,
Unq_outbud_doms_STCNT varchar(32) NOT NULL,
Unq_innbud_doms_MIN DECIMAL(20,4) NOT NULL,
Unq_innbud_doms_MAX DECIMAL(20,4) NOT NULL,
Unq_innbud_doms_STCNT varchar(32) NOT NULL,
Resloved_MIN DECIMAL(20,4) NOT NULL,
Resloved_MAX DECIMAL(20,4) NOT NULL,
Resloved_STCNT varchar(32) NOT NULL,
Filtered_as_spam_MIN DECIMAL(20,4) NOT NULL,
Filtered_as_spam_MAX DECIMAL(20,4) NOT NULL,
Filtered_as_spam_STCNT varchar(32) NOT NULL,
Getting_status_MIN DECIMAL(20,4) NOT NULL,
Getting_status_MAX DECIMAL(20,4) NOT NULL,
Getting_status_STCNT varchar(32) NOT NULL,
Quarantined_MIN DECIMAL(20,4) NOT NULL,
Quarantined_MAX DECIMAL(20,4) NOT NULL,
Quarantined_STCNT varchar(32) NOT NULL,
Unknown_MIN DECIMAL(20,4) NOT NULL,
Unknown_MAX DECIMAL(20,4) NOT NULL,
Unknown_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOMailTrfcStatisTest_TREND ADD constraint PK_EXOMailTrfcStatisTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailTrfcStatisTest_THRESH;
CREATE TABLE EXOMailTrfcStatisTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Unique_Senders_MIN VARCHAR(256) NOT NULL,
Unique_Senders_MAX VARCHAR(256) NOT NULL,
Unique_Receivers_MIN VARCHAR(256) NOT NULL,
Unique_Receivers_MAX VARCHAR(256) NOT NULL,
Unique_Sender_IPs_MIN VARCHAR(256) NOT NULL,
Unique_Sender_IPs_MAX VARCHAR(256) NOT NULL,
Inbound_Mail_Items_MIN VARCHAR(256) NOT NULL,
Inbound_Mail_Items_MAX VARCHAR(256) NOT NULL,
Inbound_Mails_Size_MIN VARCHAR(256) NOT NULL,
Inbound_Mails_Size_MAX VARCHAR(256) NOT NULL,
Outbound_Mail_Items_MIN VARCHAR(256) NOT NULL,
Outbound_Mail_Items_MAX VARCHAR(256) NOT NULL,
Outbound_Mails_Size_MIN VARCHAR(256) NOT NULL,
Outbound_Mails_Size_MAX VARCHAR(256) NOT NULL,
Total_Mail_Items_MIN VARCHAR(256) NOT NULL,
Total_Mail_Items_MAX VARCHAR(256) NOT NULL,
Total_Mails_Size_MIN VARCHAR(256) NOT NULL,
Total_Mails_Size_MAX VARCHAR(256) NOT NULL,
Internal_emails_sent_MIN VARCHAR(256) NOT NULL,
Internal_emails_sent_MAX VARCHAR(256) NOT NULL,
Size_Intl_mailsent_MIN VARCHAR(256) NOT NULL,
Size_Intl_mailsent_MAX VARCHAR(256) NOT NULL,
Internal_emails_recvd_MIN VARCHAR(256) NOT NULL,
Internal_emails_recvd_MAX VARCHAR(256) NOT NULL,
Size_Intl_mailrecvd_MIN VARCHAR(256) NOT NULL,
Size_Intl_mailrecvd_MAX VARCHAR(256) NOT NULL,
External_emails_sent_MIN VARCHAR(256) NOT NULL,
External_emails_sent_MAX VARCHAR(256) NOT NULL,
Size_exrtl_mailsent_MIN VARCHAR(256) NOT NULL,
Size_exrtl_mailsent_MAX VARCHAR(256) NOT NULL,
External_emails_recvd_MIN VARCHAR(256) NOT NULL,
External_emails_recvd_MAX VARCHAR(256) NOT NULL,
Size_extl_mailrecvd_MIN VARCHAR(256) NOT NULL,
Size_extl_mailrecvd_MAX VARCHAR(256) NOT NULL,
Nonecnt_MIN VARCHAR(256) NOT NULL,
Nonecnt_MAX VARCHAR(256) NOT NULL,
Failedcnt_MIN VARCHAR(256) NOT NULL,
Failedcnt_MAX VARCHAR(256) NOT NULL,
Pendingcnt_MIN VARCHAR(256) NOT NULL,
Pendingcnt_MAX VARCHAR(256) NOT NULL,
Delvrycnt_MIN VARCHAR(256) NOT NULL,
Delvrycnt_MAX VARCHAR(256) NOT NULL,
Expandcnt_MIN VARCHAR(256) NOT NULL,
Expandcnt_MAX VARCHAR(256) NOT NULL,
Unq_outbud_doms_MIN VARCHAR(256) NOT NULL,
Unq_outbud_doms_MAX VARCHAR(256) NOT NULL,
Unq_innbud_doms_MIN VARCHAR(256) NOT NULL,
Unq_innbud_doms_MAX VARCHAR(256) NOT NULL,
Resloved_MIN VARCHAR(256) NOT NULL,
Resloved_MAX VARCHAR(256) NOT NULL,
Filtered_as_spam_MIN VARCHAR(256) NOT NULL,
Filtered_as_spam_MAX VARCHAR(256) NOT NULL,
Getting_status_MIN VARCHAR(256) NOT NULL,
Getting_status_MAX VARCHAR(256) NOT NULL,
Quarantined_MIN VARCHAR(256) NOT NULL,
Quarantined_MAX VARCHAR(256) NOT NULL,
Unknown_MIN VARCHAR(256) NOT NULL,
Unknown_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOMailTrfcStatisTest_THRESH ADD constraint PK_EXOMalTrfcStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMalTrfStatTest_THRESH ON EXOMailTrfcStatisTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOUserMAPIConTest;
CREATE TABLE EXOUserMAPIConTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Status DECIMAL(20,4) NOT NULL,
Status_ST varchar(32) NOT NULL,
Connect_time DECIMAL(20,4) NOT NULL,
Connect_time_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOUserMAPIConTest ON EXOUserMAPIConTest(MSMT_TIME);
ALTER TABLE EXOUserMAPIConTest ADD constraint PK_EXOUserMAPIConTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUserMAPIConTest_TREND;
CREATE TABLE EXOUserMAPIConTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Status_MIN DECIMAL(20,4) NOT NULL,
Status_MAX DECIMAL(20,4) NOT NULL,
Status_STCNT varchar(32) NOT NULL,
Connect_time_MIN DECIMAL(20,4) NOT NULL,
Connect_time_MAX DECIMAL(20,4) NOT NULL,
Connect_time_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOUserMAPIConTest_TREND ADD constraint PK_EXOUserMAPIConTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUserMAPIConTest_THRESH;
CREATE TABLE EXOUserMAPIConTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Status_MIN VARCHAR(256) NOT NULL,
Status_MAX VARCHAR(256) NOT NULL,
Connect_time_MIN VARCHAR(256) NOT NULL,
Connect_time_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOUserMAPIConTest_THRESH ADD constraint PK_EXOUserMAPIConTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUserMAPIConTest_THRESH ON EXOUserMAPIConTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUserMAPIConTest ON EXOUserMAPIConTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUserMAPIConTest ON EXOUserMAPIConTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXODevicConTest;
CREATE TABLE EXODevicConTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Unique_user_agents DECIMAL(20,4) NOT NULL,
Unique_user_agents_ST varchar(32) NOT NULL,
Unique_device_types DECIMAL(20,4) NOT NULL,
Unique_device_types_ST varchar(32) NOT NULL,
Unique_OS DECIMAL(20,4) NOT NULL,
Unique_OS_ST varchar(32) NOT NULL,
Unique_clients DECIMAL(20,4) NOT NULL,
Unique_clients_ST varchar(32) NOT NULL,
Unique_dev_OS_lang DECIMAL(20,4) NOT NULL,
Unique_dev_OS_lang_ST varchar(32) NOT NULL,
Synchronized_devices DECIMAL(20,4) NOT NULL,
Synchronized_devices_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXODevicConTest ON EXODevicConTest(MSMT_TIME);
ALTER TABLE EXODevicConTest ADD constraint PK_EXODevicConTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXODevicConTest_TREND;
CREATE TABLE EXODevicConTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Unique_user_agents_MIN DECIMAL(20,4) NOT NULL,
Unique_user_agents_MAX DECIMAL(20,4) NOT NULL,
Unique_user_agents_STCNT varchar(32) NOT NULL,
Unique_device_types_MIN DECIMAL(20,4) NOT NULL,
Unique_device_types_MAX DECIMAL(20,4) NOT NULL,
Unique_device_types_STCNT varchar(32) NOT NULL,
Unique_OS_MIN DECIMAL(20,4) NOT NULL,
Unique_OS_MAX DECIMAL(20,4) NOT NULL,
Unique_OS_STCNT varchar(32) NOT NULL,
Unique_clients_MIN DECIMAL(20,4) NOT NULL,
Unique_clients_MAX DECIMAL(20,4) NOT NULL,
Unique_clients_STCNT varchar(32) NOT NULL,
Unique_dev_OS_lang_MIN DECIMAL(20,4) NOT NULL,
Unique_dev_OS_lang_MAX DECIMAL(20,4) NOT NULL,
Unique_dev_OS_lang_STCNT varchar(32) NOT NULL,
Synchronized_devices_MIN DECIMAL(20,4) NOT NULL,
Synchronized_devices_MAX DECIMAL(20,4) NOT NULL,
Synchronized_devices_STCNT varchar(32) NOT NULL);

ALTER TABLE EXODevicConTest_TREND ADD constraint PK_EXODevicConTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXODevicConTest_THRESH;
CREATE TABLE EXODevicConTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Unique_user_agents_MIN VARCHAR(256) NOT NULL,
Unique_user_agents_MAX VARCHAR(256) NOT NULL,
Unique_device_types_MIN VARCHAR(256) NOT NULL,
Unique_device_types_MAX VARCHAR(256) NOT NULL,
Unique_OS_MIN VARCHAR(256) NOT NULL,
Unique_OS_MAX VARCHAR(256) NOT NULL,
Unique_clients_MIN VARCHAR(256) NOT NULL,
Unique_clients_MAX VARCHAR(256) NOT NULL,
Unique_dev_OS_lang_MIN VARCHAR(256) NOT NULL,
Unique_dev_OS_lang_MAX VARCHAR(256) NOT NULL,
Synchronized_devices_MIN VARCHAR(256) NOT NULL,
Synchronized_devices_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXODevicConTest_THRESH ADD constraint PK_EXODevicConTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXODevicConTest_THRESH ON EXODevicConTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXODevicConTest ON EXODevicConTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXODevicConTest ON EXODevicConTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOSrvcHlhTest;
CREATE TABLE EXOSrvcHlhTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVICE_INCIDENTS DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar(32) NOT NULL,
MAINTENANCE_EVENTS DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar(32) NOT NULL,
SERVICE_STATUS DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOSrvcHlhTest ON EXOSrvcHlhTest(MSMT_TIME);
ALTER TABLE EXOSrvcHlhTest ADD constraint PK_EXOSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOSrvcHlhTest_TREND;
CREATE TABLE EXOSrvcHlhTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVICE_INCIDENTS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar(32) NOT NULL,
MAINTENANCE_EVENTS_MIN DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX DECIMAL(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar(32) NOT NULL,
SERVICE_STATUS_MIN DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_MAX DECIMAL(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOSrvcHlhTest_TREND ADD constraint PK_EXOSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOSrvcHlhTest_THRESH;
CREATE TABLE EXOSrvcHlhTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVICE_INCIDENTS_MIN VARCHAR(256) NOT NULL,
SERVICE_INCIDENTS_MAX VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MIN VARCHAR(256) NOT NULL,
MAINTENANCE_EVENTS_MAX VARCHAR(256) NOT NULL,
SERVICE_STATUS_MIN VARCHAR(256) NOT NULL,
SERVICE_STATUS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOSrvcHlhTest_THRESH ADD constraint PK_EXOSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOSrvcHlhTest_THRESH ON EXOSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOSrvcHlhTest ON EXOSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOSrvcHlhTest ON EXOSrvcHlhTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOLicenseTest;
CREATE TABLE EXOLicenseTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NON_TRIAL_ENTITLEMENTS DECIMAL(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_ST varchar(32) NOT NULL,
TRIAL_ENTITLEMENTS DECIMAL(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_ST varchar(32) NOT NULL,
ACTIVE_USERS DECIMAL(20,4) NOT NULL,
ACTIVE_USERS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOLicenseTest ON EXOLicenseTest(MSMT_TIME);
ALTER TABLE EXOLicenseTest ADD constraint PK_EXOLicenseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOLicenseTest_TREND;
CREATE TABLE EXOLicenseTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MIN DECIMAL(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MAX DECIMAL(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_STCNT varchar(32) NOT NULL,
TRIAL_ENTITLEMENTS_MIN DECIMAL(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_MAX DECIMAL(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_STCNT varchar(32) NOT NULL,
ACTIVE_USERS_MIN DECIMAL(20,4) NOT NULL,
ACTIVE_USERS_MAX DECIMAL(20,4) NOT NULL,
ACTIVE_USERS_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOLicenseTest_TREND ADD constraint PK_EXOLicenseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOLicenseTest_THRESH;
CREATE TABLE EXOLicenseTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NON_TRIAL_ENTITLEMENTS_MIN VARCHAR(256) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MAX VARCHAR(256) NOT NULL,
TRIAL_ENTITLEMENTS_MIN VARCHAR(256) NOT NULL,
TRIAL_ENTITLEMENTS_MAX VARCHAR(256) NOT NULL,
ACTIVE_USERS_MIN VARCHAR(256) NOT NULL,
ACTIVE_USERS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOLicenseTest_THRESH ADD constraint PK_EXOLicenseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOLicenseTest_THRESH ON EXOLicenseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOLicenseTest ON EXOLicenseTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOLicenseTest ON EXOLicenseTest_TREND (MSMT_TIME,PERIOD);







DROP TABLE EXOLoginTest;
CREATE TABLE EXOLoginTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AUTHENTICATION_STATUS DECIMAL(20,4) NOT NULL,
AUTHENTICATION_STATUS_ST varchar(32) NOT NULL,
AUTHENTICATION_TIME DECIMAL(20,4) NOT NULL,
AUTHENTICATION_TIME_ST varchar(32) NOT NULL,
LOGIN_STATUS DECIMAL(20,4) NOT NULL,
LOGIN_STATUS_ST varchar(32) NOT NULL,
LOGIN_TIME DECIMAL(20,4) NOT NULL,
LOGIN_TIME_ST varchar(32) NOT NULL,
TOTAL_LOGIN_TIME DECIMAL(20,4) NOT NULL,
TOTAL_LOGIN_TIME_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOLoginTest ON EXOLoginTest(MSMT_TIME);
ALTER TABLE EXOLoginTest ADD constraint PK_EXOLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOLoginTest_TREND;
CREATE TABLE EXOLoginTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AUTHENTICATION_STATUS_MIN DECIMAL(20,4) NOT NULL,
AUTHENTICATION_STATUS_MAX DECIMAL(20,4) NOT NULL,
AUTHENTICATION_STATUS_STCNT varchar(32) NOT NULL,
AUTHENTICATION_TIME_MIN DECIMAL(20,4) NOT NULL,
AUTHENTICATION_TIME_MAX DECIMAL(20,4) NOT NULL,
AUTHENTICATION_TIME_STCNT varchar(32) NOT NULL,
LOGIN_STATUS_MIN DECIMAL(20,4) NOT NULL,
LOGIN_STATUS_MAX DECIMAL(20,4) NOT NULL,
LOGIN_STATUS_STCNT varchar(32) NOT NULL,
LOGIN_TIME_MIN DECIMAL(20,4) NOT NULL,
LOGIN_TIME_MAX DECIMAL(20,4) NOT NULL,
LOGIN_TIME_STCNT varchar(32) NOT NULL,
TOTAL_LOGIN_TIME_MIN DECIMAL(20,4) NOT NULL,
TOTAL_LOGIN_TIME_MAX DECIMAL(20,4) NOT NULL,
TOTAL_LOGIN_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOLoginTest_TREND ADD constraint PK_EXOLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOLoginTest_THRESH;
CREATE TABLE EXOLoginTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AUTHENTICATION_STATUS_MIN VARCHAR(256) NOT NULL,
AUTHENTICATION_STATUS_MAX VARCHAR(256) NOT NULL,
AUTHENTICATION_TIME_MIN VARCHAR(256) NOT NULL,
AUTHENTICATION_TIME_MAX VARCHAR(256) NOT NULL,
LOGIN_STATUS_MIN VARCHAR(256) NOT NULL,
LOGIN_STATUS_MAX VARCHAR(256) NOT NULL,
LOGIN_TIME_MIN VARCHAR(256) NOT NULL,
LOGIN_TIME_MAX VARCHAR(256) NOT NULL,
TOTAL_LOGIN_TIME_MIN VARCHAR(256) NOT NULL,
TOTAL_LOGIN_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOLoginTest_THRESH ADD constraint PK_EXOLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOLoginTest_THRESH ON EXOLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOLoginTest ON EXOLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOLoginTest ON EXOLoginTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOAdminActTest;
CREATE TABLE EXOAdminActTest( 
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Total_Operations DECIMAL(20,4) NOT NULL,
Total_Operations_ST varchar(32) NOT NULL,
Unique_Operations DECIMAL(20,4) NOT NULL,
Unique_Operations_ST varchar(32) NOT NULL,
Unique_Users DECIMAL(20,4) NOT NULL,
Unique_Users_ST varchar(32) NOT NULL,
Unique_ClientIP DECIMAL(20,4) NOT NULL,
Unique_ClientIP_ST varchar(32) NOT NULL,
Ms_AdminOperation DECIMAL(20,4) NOT NULL,
Ms_AdminOperation_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOAdminActTest ON EXOAdminActTest(MSMT_TIME);
ALTER TABLE EXOAdminActTest ADD constraint PK_EXOAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOAdminActTest_TREND;
CREATE TABLE EXOAdminActTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Total_Operations_MIN DECIMAL(20,4) NOT NULL,
Total_Operations_MAX DECIMAL(20,4) NOT NULL,
Total_Operations_STCNT varchar(32) NOT NULL,
Unique_Operations_MIN DECIMAL(20,4) NOT NULL,
Unique_Operations_MAX DECIMAL(20,4) NOT NULL,
Unique_Operations_STCNT varchar(32) NOT NULL,
Unique_Users_MIN DECIMAL(20,4) NOT NULL,
Unique_Users_MAX DECIMAL(20,4) NOT NULL,
Unique_Users_STCNT varchar(32) NOT NULL,
Unique_ClientIP_MIN DECIMAL(20,4) NOT NULL,
Unique_ClientIP_MAX DECIMAL(20,4) NOT NULL,
Unique_ClientIP_STCNT varchar(32) NOT NULL,
Ms_AdminOperation_MIN DECIMAL(20,4) NOT NULL,
Ms_AdminOperation_MAX DECIMAL(20,4) NOT NULL,
Ms_AdminOperation_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOAdminActTest_TREND ADD constraint PK_EXOAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOAdminActTest_THRESH;
CREATE TABLE EXOAdminActTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Total_Operations_MIN VARCHAR(256) NOT NULL,
Total_Operations_MAX VARCHAR(256) NOT NULL,
Unique_Operations_MIN VARCHAR(256) NOT NULL,
Unique_Operations_MAX VARCHAR(256) NOT NULL,
Unique_Users_MIN VARCHAR(256) NOT NULL,
Unique_Users_MAX VARCHAR(256) NOT NULL,
Unique_ClientIP_MIN VARCHAR(256) NOT NULL,
Unique_ClientIP_MAX VARCHAR(256) NOT NULL,
Ms_AdminOperation_MIN VARCHAR(256) NOT NULL,
Ms_AdminOperation_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOAdminActTest_THRESH ADD constraint PK_EXOAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOAdminActTest_THRESH ON EXOAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOAdminActTest ON EXOAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOAdminActTest ON EXOAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailBoxLocTest;
CREATE TABLE EXOMailBoxLocTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOT_DATCENT DECIMAL(20,4) NOT NULL,
TOT_DATCENT_ST varchar(32) NOT NULL,
UNIQ_LOC DECIMAL(20,4) NOT NULL,
UNIQ_LOC_ST varchar(32) NOT NULL,
UNIQ_USR_LOC DECIMAL(20,4) NOT NULL,
UNIQ_USR_LOC_ST varchar(32) NOT NULL);
CREATE INDEX IDX_EXOMailBoxLocTest ON EXOMailBoxLocTest(MSMT_TIME);
ALTER TABLE EXOMailBoxLocTest ADD constraint PK_EXOMailBoxLocTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxLocTest_TREND;
CREATE TABLE EXOMailBoxLocTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOT_DATCENT_MIN DECIMAL(20,4) NOT NULL,
TOT_DATCENT_MAX DECIMAL(20,4) NOT NULL,
TOT_DATCENT_STCNT varchar(32) NOT NULL,
UNIQ_LOC_MIN DECIMAL(20,4) NOT NULL,
UNIQ_LOC_MAX DECIMAL(20,4) NOT NULL,
UNIQ_LOC_STCNT varchar(32) NOT NULL,
UNIQ_USR_LOC_MIN DECIMAL(20,4) NOT NULL,
UNIQ_USR_LOC_MAX DECIMAL(20,4) NOT NULL,
UNIQ_USR_LOC_STCNT varchar(32) NOT NULL);
ALTER TABLE EXOMailBoxLocTest_TREND ADD constraint PK_EXOMailBoxLocTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxLocTest_THRESH;
CREATE TABLE EXOMailBoxLocTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOT_DATCENT_MIN VARCHAR(256) NOT NULL,
TOT_DATCENT_MAX VARCHAR(256) NOT NULL,
UNIQ_LOC_MIN VARCHAR(256) NOT NULL,
UNIQ_LOC_MAX VARCHAR(256) NOT NULL,
UNIQ_USR_LOC_MIN VARCHAR(256) NOT NULL,
UNIQ_USR_LOC_MAX VARCHAR(256) NOT NULL);
ALTER TABLE EXOMailBoxLocTest_THRESH ADD constraint PK_EXOMailBoxLocTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxLocTest_THRESH ON EXOMailBoxLocTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxLocTest ON EXOMailBoxLocTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxLocTest ON EXOMailBoxLocTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE EXOSpamTest;
CREATE TABLE EXOSpamTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
INBOUND_SPAM DECIMAL(20,4) NOT NULL,
INBOUND_SPAM_ST varchar(32) NOT NULL,
OUTBOUND_SPAM DECIMAL(20,4) NOT NULL,
OUTBOUND_SPAM_ST varchar(32) NOT NULL,
INBOUND_SIZE DECIMAL(20,4) NOT NULL,
INBOUND_SIZE_ST varchar(32) NOT NULL,
OUTBOUND_SIZE DECIMAL(20,4) NOT NULL,
OUTBOUND_SIZE_ST varchar(32) NOT NULL,
UNIQUE_SND DECIMAL(20,4) NOT NULL,
UNIQUE_SND_ST varchar(32) NOT NULL,
UNIQUE_REC DECIMAL(20,4) NOT NULL,
UNIQUE_REC_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOSpamTest ON EXOSpamTest(MSMT_TIME);
ALTER TABLE EXOSpamTest ADD constraint PK_EXOSpamTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOSpamTest_TREND;
CREATE TABLE EXOSpamTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
INBOUND_SPAM_MIN DECIMAL(20,4) NOT NULL,
INBOUND_SPAM_MAX DECIMAL(20,4) NOT NULL,
INBOUND_SPAM_STCNT varchar(32) NOT NULL,
OUTBOUND_SPAM_MIN DECIMAL(20,4) NOT NULL,
OUTBOUND_SPAM_MAX DECIMAL(20,4) NOT NULL,
OUTBOUND_SPAM_STCNT varchar(32) NOT NULL,
INBOUND_SIZE_MIN DECIMAL(20,4) NOT NULL,
INBOUND_SIZE_MAX DECIMAL(20,4) NOT NULL,
INBOUND_SIZE_STCNT varchar(32) NOT NULL,
OUTBOUND_SIZE_MIN DECIMAL(20,4) NOT NULL,
OUTBOUND_SIZE_MAX DECIMAL(20,4) NOT NULL,
OUTBOUND_SIZE_STCNT varchar(32) NOT NULL,
UNIQUE_SND_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SND_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SND_STCNT varchar(32) NOT NULL,
UNIQUE_REC_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_REC_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_REC_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOSpamTest_TREND ADD constraint PK_EXOSpamTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOSpamTest_THRESH;
CREATE TABLE EXOSpamTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
INBOUND_SPAM_MIN VARCHAR(256) NOT NULL,
INBOUND_SPAM_MAX VARCHAR(256) NOT NULL,
OUTBOUND_SPAM_MIN VARCHAR(256) NOT NULL,
OUTBOUND_SPAM_MAX VARCHAR(256) NOT NULL,
INBOUND_SIZE_MIN VARCHAR(256) NOT NULL,
INBOUND_SIZE_MAX VARCHAR(256) NOT NULL,
OUTBOUND_SIZE_MIN VARCHAR(256) NOT NULL,
OUTBOUND_SIZE_MAX VARCHAR(256) NOT NULL,
UNIQUE_SND_MIN VARCHAR(256) NOT NULL,
UNIQUE_SND_MAX VARCHAR(256) NOT NULL,
UNIQUE_REC_MIN VARCHAR(256) NOT NULL,
UNIQUE_REC_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOSpamTest_THRESH ADD constraint PK_EXOSpamTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOSpamTest_THRESH ON EXOSpamTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOSpamTest ON EXOSpamTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOSpamTest ON EXOSpamTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOMalwareTest;
CREATE TABLE EXOMalwareTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Inbound_malware DECIMAL(20,4) NOT NULL,
Inbound_malware_ST varchar(32) NOT NULL,
Outbound_malware DECIMAL(20,4) NOT NULL,
Outbound_malware_ST varchar(32) NOT NULL,
INBOUND_SIZE DECIMAL(20,4) NOT NULL,
INBOUND_SIZE_ST varchar(32) NOT NULL,
OUTBOUND_SIZE DECIMAL(20,4) NOT NULL,
OUTBOUND_SIZE_ST varchar(32) NOT NULL,
UNIQUE_SND DECIMAL(20,4) NOT NULL,
UNIQUE_SND_ST varchar(32) NOT NULL,
UNIQUE_REC DECIMAL(20,4) NOT NULL,
UNIQUE_REC_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOMalwareTest ON EXOMalwareTest(MSMT_TIME);
ALTER TABLE EXOMalwareTest ADD constraint PK_EXOMalwareTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMalwareTest_TREND;
CREATE TABLE EXOMalwareTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Inbound_malware_MIN DECIMAL(20,4) NOT NULL,
Inbound_malware_MAX DECIMAL(20,4) NOT NULL,
Inbound_malware_STCNT varchar(32) NOT NULL,
Outbound_malware_MIN DECIMAL(20,4) NOT NULL,
Outbound_malware_MAX DECIMAL(20,4) NOT NULL,
Outbound_malware_STCNT varchar(32) NOT NULL,
INBOUND_SIZE_MIN DECIMAL(20,4) NOT NULL,
INBOUND_SIZE_MAX DECIMAL(20,4) NOT NULL,
INBOUND_SIZE_STCNT varchar(32) NOT NULL,
OUTBOUND_SIZE_MIN DECIMAL(20,4) NOT NULL,
OUTBOUND_SIZE_MAX DECIMAL(20,4) NOT NULL,
OUTBOUND_SIZE_STCNT varchar(32) NOT NULL,
UNIQUE_SND_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SND_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SND_STCNT varchar(32) NOT NULL,
UNIQUE_REC_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_REC_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_REC_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOMalwareTest_TREND ADD constraint PK_EXOMalwareTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMalwareTest_THRESH;
CREATE TABLE EXOMalwareTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Inbound_malware_MIN VARCHAR(256) NOT NULL,
Inbound_malware_MAX VARCHAR(256) NOT NULL,
Outbound_malware_MIN VARCHAR(256) NOT NULL,
Outbound_malware_MAX VARCHAR(256) NOT NULL,
INBOUND_SIZE_MIN DECIMAL(20,4) NOT NULL,
INBOUND_SIZE_MAX varchar(32) NOT NULL,
OUTBOUND_SIZE_MIN DECIMAL(20,4) NOT NULL,
OUTBOUND_SIZE_MAX varchar(32) NOT NULL,
UNIQUE_SND_MIN VARCHAR(256) NOT NULL,
UNIQUE_SND_MAX VARCHAR(256) NOT NULL,
UNIQUE_REC_MIN VARCHAR(256) NOT NULL,
UNIQUE_REC_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOMalwareTest_THRESH ADD constraint PK_EXOMalwareTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMalwareTest_THRESH ON EXOMalwareTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMalwareTest ON EXOMalwareTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMalwareTest ON EXOMalwareTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOTranRuleTest;
CREATE TABLE EXOTranRuleTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_HIT DECIMAL(20,4) NOT NULL,
TOTAL_HIT_ST varchar(32) NOT NULL,
INBOUND_RULE DECIMAL(20,4) NOT NULL,
INBOUND_RULE_ST varchar(32) NOT NULL,
OUTBOUND_RULE DECIMAL(20,4) NOT NULL,
OUTBOUND_RULE_ST varchar(32) NOT NULL,
UNIQUE_SENDERS DECIMAL(20,4) NOT NULL,
UNIQUE_SENDERS_ST varchar(32) NOT NULL,
UNIQUE_RECEIVERS DECIMAL(20,4) NOT NULL,
UNIQUE_RECEIVERS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOTranRuleTest ON EXOTranRuleTest(MSMT_TIME);
ALTER TABLE EXOTranRuleTest ADD constraint PK_EXOTranRuleTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOTranRuleTest_TREND;
CREATE TABLE EXOTranRuleTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_HIT_MIN DECIMAL(20,4) NOT NULL,
TOTAL_HIT_MAX DECIMAL(20,4) NOT NULL,
TOTAL_HIT_STCNT varchar(32) NOT NULL,
INBOUND_RULE_MIN DECIMAL(20,4) NOT NULL,
INBOUND_RULE_MAX DECIMAL(20,4) NOT NULL,
INBOUND_RULE_STCNT varchar(32) NOT NULL,
OUTBOUND_RULE_MIN DECIMAL(20,4) NOT NULL,
OUTBOUND_RULE_MAX DECIMAL(20,4) NOT NULL,
OUTBOUND_RULE_STCNT varchar(32) NOT NULL,
UNIQUE_SENDERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SENDERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SENDERS_STCNT varchar(32) NOT NULL,
UNIQUE_RECEIVERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_RECEIVERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_RECEIVERS_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOTranRuleTest_TREND ADD constraint PK_EXOTranRuleTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOTranRuleTest_THRESH;
CREATE TABLE EXOTranRuleTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_HIT_MIN VARCHAR(256) NOT NULL,
TOTAL_HIT_MAX VARCHAR(256) NOT NULL,
INBOUND_RULE_MIN VARCHAR(256) NOT NULL,
INBOUND_RULE_MAX VARCHAR(256) NOT NULL,
OUTBOUND_RULE_MIN VARCHAR(256) NOT NULL,
OUTBOUND_RULE_MAX VARCHAR(256) NOT NULL,
UNIQUE_SENDERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_SENDERS_MAX VARCHAR(256) NOT NULL,
UNIQUE_RECEIVERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_RECEIVERS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOTranRuleTest_THRESH ADD constraint PK_EXOTranRuleTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOTranRuleTest_THRESH ON EXOTranRuleTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOTranRuleTest ON EXOTranRuleTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOTranRuleTest ON EXOTranRuleTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXODlpTest;
CREATE TABLE EXODlpTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
DLP_DETECT DECIMAL(20,4) NOT NULL,
DLP_DETECT_ST varchar(32) NOT NULL,
UNIQUE_SENDERS DECIMAL(20,4) NOT NULL,
UNIQUE_SENDERS_ST varchar(32) NOT NULL,
UNIQUE_RECEIVER DECIMAL(20,4) NOT NULL,
UNIQUE_RECEIVER_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXODlpTest ON EXODlpTest(MSMT_TIME);
ALTER TABLE EXODlpTest ADD constraint PK_EXODlpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXODlpTest_TREND;
CREATE TABLE EXODlpTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
DLP_DETECT_MIN DECIMAL(20,4) NOT NULL,
DLP_DETECT_MAX DECIMAL(20,4) NOT NULL,
DLP_DETECT_STCNT varchar(32) NOT NULL,
UNIQUE_SENDERS_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_SENDERS_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_SENDERS_STCNT varchar(32) NOT NULL,
UNIQUE_RECEIVER_MIN DECIMAL(20,4) NOT NULL,
UNIQUE_RECEIVER_MAX DECIMAL(20,4) NOT NULL,
UNIQUE_RECEIVER_STCNT varchar(32) NOT NULL);

ALTER TABLE EXODlpTest_TREND ADD constraint PK_EXODlpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXODlpTest_THRESH;
CREATE TABLE EXODlpTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
DLP_DETECT_MIN VARCHAR(256) NOT NULL,
DLP_DETECT_MAX VARCHAR(256) NOT NULL,
UNIQUE_SENDERS_MIN VARCHAR(256) NOT NULL,
UNIQUE_SENDERS_MAX VARCHAR(256) NOT NULL,
UNIQUE_RECEIVER_MIN VARCHAR(256) NOT NULL,
UNIQUE_RECEIVER_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXODlpTest_THRESH ADD constraint PK_EXODlpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXODlpTest_THRESH ON EXODlpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXODlpTest ON EXODlpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXODlpTest ON EXODlpTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXONonOwnerActivtsTest;
CREATE TABLE EXONonOwnerActivtsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Total_Operations DECIMAL(20,4) NOT NULL,
Total_Operations_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest(MSMT_TIME);
ALTER TABLE EXONonOwnerActivtsTest ADD constraint PK_EXONonOwnerActivtsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXONonOwnerActivtsTest_TREND;
CREATE TABLE EXONonOwnerActivtsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Total_Operations_MIN DECIMAL(20,4) NOT NULL,
Total_Operations_MAX DECIMAL(20,4) NOT NULL,
Total_Operations_STCNT varchar(32) NOT NULL);

ALTER TABLE EXONonOwnerActivtsTest_TREND ADD constraint PK_EXONonOwnerActiTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXONonOwnerActivtsTest_THRESH;
CREATE TABLE EXONonOwnerActivtsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Total_Operations_MIN VARCHAR(256) NOT NULL,
Total_Operations_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXONonOwnerActivtsTest_THRESH ADD constraint PK_EXONonOwnerActiTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXONonOwnerActiTest_THRESH ON EXONonOwnerActivtsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOownerActivtsTest;
CREATE TABLE EXOownerActivtsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Total_Operations DECIMAL(20,4) NOT NULL,
Total_Operations_ST varchar(32) NOT NULL,
Unique_Users DECIMAL(20,4) NOT NULL,
Unique_Users_ST varchar(32) NOT NULL,
Unique_Client_IPs DECIMAL(20,4) NOT NULL,
Unique_Client_IPs_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOownerActivtsTest ON EXOownerActivtsTest(MSMT_TIME);
ALTER TABLE EXOownerActivtsTest ADD constraint PK_EXOownerActivtsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOownerActivtsTest_TREND;
CREATE TABLE EXOownerActivtsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Total_Operations_MIN DECIMAL(20,4) NOT NULL,
Total_Operations_MAX DECIMAL(20,4) NOT NULL,
Total_Operations_STCNT varchar(32) NOT NULL,
Unique_Users_MIN DECIMAL(20,4) NOT NULL,
Unique_Users_MAX DECIMAL(20,4) NOT NULL,
Unique_Users_STCNT varchar(32) NOT NULL,
Unique_Client_IPs_MIN DECIMAL(20,4) NOT NULL,
Unique_Client_IPs_MAX DECIMAL(20,4) NOT NULL,
Unique_Client_IPs_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOownerActivtsTest_TREND ADD constraint PK_EXOownerActivtsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOownerActivtsTest_THRESH;
CREATE TABLE EXOownerActivtsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Total_Operations_MIN VARCHAR(256) NOT NULL,
Total_Operations_MAX VARCHAR(256) NOT NULL,
Unique_Users_MIN VARCHAR(256) NOT NULL,
Unique_Users_MAX VARCHAR(256) NOT NULL,
Unique_Client_IPs_MIN VARCHAR(256) NOT NULL,
Unique_Client_IPs_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOownerActivtsTest_THRESH ADD constraint PK_EXOownerActivtsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOownerActivtsTest_THRESH ON EXOownerActivtsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOownerActivtsTest ON EXOownerActivtsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOownerActivtsTest ON EXOownerActivtsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOMsgCenTest;
CREATE TABLE EXOMsgCenTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
MsgCenterCommunication DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EXOMsgCenTest ON EXOMsgCenTest(MSMT_TIME);
ALTER TABLE EXOMsgCenTest ADD constraint PK_EXOMsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMsgCenTest_TREND;
CREATE TABLE EXOMsgCenTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
MsgCenterCommunication_MIN DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_MAX DECIMAL(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar(32) NOT NULL);

ALTER TABLE EXOMsgCenTest_TREND ADD constraint PK_EXOMsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMsgCenTest_THRESH;
CREATE TABLE EXOMsgCenTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
MsgCenterCommunication_MIN VARCHAR(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EXOMsgCenTest_THRESH ADD constraint PK_EXOMsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMsgCenTest_THRESH ON EXOMsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMsgCenTest ON EXOMsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMsgCenTest ON EXOMsgCenTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE AsSysDBBkUpTest;
CREATE TABLE AsSysDBBkUpTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
BKUP DECIMAL(20,4) NOT NULL,
BKUP_ST varchar(32) NOT NULL);

CREATE INDEX IDX_AsSysDBBkUpTest ON AsSysDBBkUpTest(MSMT_TIME);
ALTER TABLE AsSysDBBkUpTest ADD constraint PK_AsSysDBBkUpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsSysDBBkUpTest_TREND;
CREATE TABLE AsSysDBBkUpTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
BKUP_MIN DECIMAL(20,4) NOT NULL,
BKUP_MAX DECIMAL(20,4) NOT NULL,
BKUP_STCNT varchar(32) NOT NULL);

ALTER TABLE AsSysDBBkUpTest_TREND ADD constraint PK_AsSysDBBkUpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsSysDBBkUpTest_THRESH;
CREATE TABLE AsSysDBBkUpTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
BKUP_MIN VARCHAR(256) NOT NULL,
BKUP_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AsSysDBBkUpTest_THRESH ADD constraint PK_AsSysDBBkUpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsSysDBBkUpTest_THRESH ON AsSysDBBkUpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsSysDBBkUpTest ON AsSysDBBkUpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsSysDBBkUpTest ON AsSysDBBkUpTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE AsSysDBSpaTest;
CREATE TABLE AsSysDBSpaTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
USED_SPACE DECIMAL(20,4) NOT NULL,
USED_SPACE_ST varchar(32) NOT NULL,
FREE_SPACE DECIMAL(20,4) NOT NULL,
FREE_SPACE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_AsSysDBSpaTest ON AsSysDBSpaTest(MSMT_TIME);
ALTER TABLE AsSysDBSpaTest ADD constraint PK_AsSysDBSpaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsSysDBSpaTest_TREND;
CREATE TABLE AsSysDBSpaTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
USED_SPACE_MIN DECIMAL(20,4) NOT NULL,
USED_SPACE_MAX DECIMAL(20,4) NOT NULL,
USED_SPACE_STCNT varchar(32) NOT NULL,
FREE_SPACE_MIN DECIMAL(20,4) NOT NULL,
FREE_SPACE_MAX DECIMAL(20,4) NOT NULL,
FREE_SPACE_STCNT varchar(32) NOT NULL);

ALTER TABLE AsSysDBSpaTest_TREND ADD constraint PK_AsSysDBSpaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsSysDBSpaTest_THRESH;
CREATE TABLE AsSysDBSpaTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
USED_SPACE_MIN VARCHAR(256) NOT NULL,
USED_SPACE_MAX VARCHAR(256) NOT NULL,
FREE_SPACE_MIN VARCHAR(256) NOT NULL,
FREE_SPACE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AsSysDBSpaTest_THRESH ADD constraint PK_AsSysDBSpaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsSysDBSpaTest_THRESH ON AsSysDBSpaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsSysDBSpaTest ON AsSysDBSpaTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsSysDBSpaTest ON AsSysDBSpaTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE XMAppNameTest;
CREATE TABLE XMAppNameTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SUCCESSFUL_APPLICATION DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar(32) NOT NULL,
FAILED_APPLICATION DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_XMAppNameTest ON XMAppNameTest(MSMT_TIME);
ALTER TABLE XMAppNameTest ADD constraint PK_XMAppNameTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppNameTest_TREND;
CREATE TABLE XMAppNameTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar(32) NOT NULL,
FAILED_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar(32) NOT NULL);

ALTER TABLE XMAppNameTest_TREND ADD constraint PK_XMAppNameTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppNameTest_THRESH;
CREATE TABLE XMAppNameTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SUCCESSFUL_APPLICATION_MIN VARCHAR(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MIN VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE XMAppNameTest_THRESH ADD constraint PK_XMAppNameTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppNameTest_THRESH ON XMAppNameTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppNameTest ON XMAppNameTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppNameTest ON XMAppNameTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE XMAppLaunchTest;
CREATE TABLE XMAppLaunchTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SUCCESSFUL_APPLICATION DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar(32) NOT NULL,
FAILED_APPLICATION DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_XMAppLaunchTest ON XMAppLaunchTest(MSMT_TIME);
ALTER TABLE XMAppLaunchTest ADD constraint PK_XMAppLaunchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppLaunchTest_TREND;
CREATE TABLE XMAppLaunchTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar(32) NOT NULL,
FAILED_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar(32) NOT NULL);

ALTER TABLE XMAppLaunchTest_TREND ADD constraint PK_XMAppLaunchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppLaunchTest_THRESH;
CREATE TABLE XMAppLaunchTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SUCCESSFUL_APPLICATION_MIN VARCHAR(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MIN VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE XMAppLaunchTest_THRESH ADD constraint PK_XMAppLaunchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppLaunchTest_THRESH ON XMAppLaunchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppLaunchTest ON XMAppLaunchTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppLaunchTest ON XMAppLaunchTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE TOPSOURCETEST;
CREATE TABLE TOPSOURCETEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS	DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST	VARCHAR(32) NOT NULL,
OUT_OCTETS	DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST	VARCHAR(32) NOT NULL,
BYTES		DECIMAL(20,4) NOT NULL,
BYTES_ST	VARCHAR(32) NOT NULL,
IN_PACKETS	DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST	VARCHAR(32) NOT NULL,
OUT_PACKETS	DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST	VARCHAR(32) NOT NULL,
PACKETS		DECIMAL(20,4) NOT NULL,
PACKETS_ST	VARCHAR(32) NOT NULL,
in_OCTETSRATE	DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
in_PACKETSRATE		DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_OCTETSRATE		DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_PACKETSRATE		DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
BYTESPERSEC		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST		VARCHAR(32) NOT NULL,
PACKETSPERSEC		DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST	VARCHAR(32) NOT NULL,
IN_TRAFFIC		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST		VARCHAR(32) NOT NULL,
OUT_TRAFFIC		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST		VARCHAR(32) NOT NULL,
TRAFFICRATE		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST		VARCHAR(32) NOT NULL,
IN_BW			DECIMAL(20,4) NOT NULL,
IN_BW_ST		VARCHAR(32) NOT NULL,
OUT_BW			DECIMAL(20,4) NOT NULL,
OUT_BW_ST		VARCHAR(32) NOT NULL,
BWUTILIZED		DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST		VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPSOURCETEST ON TOPSOURCETEST(MSMT_TIME);
ALTER TABLE TOPSOURCETEST ADD CONSTRAINT PK_TOPSOURCETEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPSOURCETEST_TREND;
CREATE TABLE TOPSOURCETEST_TREND(
TRGT_HOST		VARCHAR(32) NOT NULL,
PORT_NO			VARCHAR(32) NOT NULL,
SITE_NAME		VARCHAR(64) NOT NULL,
INFO			VARCHAR(128) NOT NULL,
MSMT_HOST		VARCHAR(32) NOT NULL,
MSMT_TIME		DATETIME NOT NULL,
PERIOD       		VARCHAR(32) NOT NULL,
IN_OCTETS_MIN		DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX		DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT		VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN		DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX		DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT	VARCHAR(32) NOT NULL,
BYTES_MIN		DECIMAL(20,4) NOT NULL,
BYTES_MAX		DECIMAL(20,4) NOT NULL,
BYTES_STCNT		VARCHAR(32) NOT NULL,
IN_PACKETS_MIN		DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX		DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT	VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN		DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX		DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT	VARCHAR(32) NOT NULL,
PACKETS_MIN		DECIMAL(20,4) NOT NULL,
PACKETS_MAX		DECIMAL(20,4) NOT NULL,
PACKETS_STCNT		VARCHAR(32) NOT NULL,
in_OCTETSRATE_MIN	DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_MAX	DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_STCNT	VARCHAR(32) NOT NULL,
in_PACKETSRATE_MIN	DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_MAX	DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_STCNT	VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN	DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX	DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT	VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN	DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX	DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT	VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT	VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN	DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX	DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT	VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT	VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT	VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT	VARCHAR(32) NOT NULL,
IN_BW_MIN		DECIMAL(20,4) NOT NULL,
IN_BW_MAX		DECIMAL(20,4) NOT NULL,
IN_BW_STCNT		VARCHAR(32) NOT NULL,
OUT_BW_MIN		DECIMAL(20,4) NOT NULL,
OUT_BW_MAX		DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT		VARCHAR(32) NOT NULL,
BWUTILIZED_MIN		DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX		DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT	VARCHAR(32) NOT NULL);

ALTER TABLE TOPSOURCETEST_TREND ADD CONSTRAINT PK_TOPSOURCETEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPSOURCETEST_THRESH;
CREATE TABLE TOPSOURCETEST_THRESH(
TRGT_HOST		VARCHAR(32) NOT NULL,
PORT_NO			VARCHAR(32) NOT NULL,
SITE_NAME		VARCHAR(64) NOT NULL,
INFO			VARCHAR(128) NOT NULL
,MSMT_HOST		VARCHAR(32) NOT NULL,
MSMT_TIME_START		DATETIME NOT NULL,
MSMT_TIME_END		DATETIME NOT NULL,
IN_OCTETS_MIN		VARCHAR(256) NOT NULL,
IN_OCTETS_MAX		VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN		VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX		VARCHAR(256) NOT NULL,
BYTES_MIN		VARCHAR(256) NOT NULL,
BYTES_MAX		VARCHAR(256) NOT NULL,
IN_PACKETS_MIN		VARCHAR(256) NOT NULL,
IN_PACKETS_MAX		VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN		VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX		VARCHAR(256) NOT NULL,
PACKETS_MIN		VARCHAR(256) NOT NULL,
PACKETS_MAX		VARCHAR(256) NOT NULL,
in_OCTETSRATE_MIN	VARCHAR(256) NOT NULL,
in_OCTETSRATE_MAX	VARCHAR(256) NOT NULL,
in_PACKETSRATE_MIN	VARCHAR(256) NOT NULL,
in_PACKETSRATE_MAX	VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN	VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX	VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN	VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX	VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN		VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX		VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN	VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX	VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN		VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX		VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN		VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX		VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN		VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX		VARCHAR(256) NOT NULL,
IN_BW_MIN		VARCHAR(256) NOT NULL,
IN_BW_MAX		VARCHAR(256) NOT NULL,
OUT_BW_MIN		VARCHAR(256) NOT NULL,
OUT_BW_MAX		VARCHAR(256) NOT NULL,
BWUTILIZED_MIN		VARCHAR(256) NOT NULL,
BWUTILIZED_MAX		VARCHAR(256) NOT NULL);

ALTER TABLE TOPSOURCETEST_THRESH ADD CONSTRAINT PK_TOPSOURCETEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPSOURCETEST_THRESH ON TOPSOURCETEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPSOURCETEST ON TOPSOURCETEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPSOURCETEST ON TOPSOURCETEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPDESTTEST;
CREATE TABLE TOPDESTTEST( 
TRGT_HOST		VARCHAR(32) NOT NULL,
PORT_NO			VARCHAR(32) NOT NULL,
SITE_NAME		VARCHAR(64) NOT NULL,
INFO			VARCHAR(128) NOT NULL,
MSMT_HOST		VARCHAR(32) NOT NULL,
MSMT_TIME		DATETIME NOT NULL,
IN_OCTETS		DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST		VARCHAR(32) NOT NULL,
OUT_OCTETS		DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST		VARCHAR(32) NOT NULL,
BYTES			DECIMAL(20,4) NOT NULL,
BYTES_ST		VARCHAR(32) NOT NULL,
IN_PACKETS		DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST		VARCHAR(32) NOT NULL,
OUT_PACKETS		DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST		VARCHAR(32) NOT NULL,
PACKETS			DECIMAL(20,4) NOT NULL,
PACKETS_ST		VARCHAR(32) NOT NULL,
in_OCTETSRATE		DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
in_PACKETSRATE		DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_OCTETSRATE		DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_PACKETSRATE		DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
BYTESPERSEC		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST		VARCHAR(32) NOT NULL,
PACKETSPERSEC		DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST	VARCHAR(32) NOT NULL,
IN_TRAFFIC		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST		VARCHAR(32) NOT NULL,
OUT_TRAFFIC		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST		VARCHAR(32) NOT NULL,
TRAFFICRATE		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST		VARCHAR(32) NOT NULL,
IN_BW			DECIMAL(20,4) NOT NULL,
IN_BW_ST		VARCHAR(32) NOT NULL,
OUT_BW			DECIMAL(20,4) NOT NULL,
OUT_BW_ST		VARCHAR(32) NOT NULL,
BWUTILIZED		DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST		VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPDESTTEST ON TOPDESTTEST(MSMT_TIME);
ALTER TABLE TOPDESTTEST ADD CONSTRAINT PK_TOPDESTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPDESTTEST_TREND;
CREATE TABLE TOPDESTTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
in_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
in_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPDESTTEST_TREND ADD CONSTRAINT PK_TOPDESTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPDESTTEST_THRESH;
CREATE TABLE TOPDESTTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
in_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
in_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
in_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
in_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPDESTTEST_THRESH ADD CONSTRAINT PK_TOPDESTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPDESTTEST_THRESH ON TOPDESTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPDESTTEST ON TOPDESTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPDESTTEST ON TOPDESTTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPCONVERTEST;
CREATE TABLE TOPCONVERTEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL,
protocol DECIMAL(20,4) NOT NULL,
protocol_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPCONVERTEST ON TOPCONVERTEST(MSMT_TIME);
ALTER TABLE TOPCONVERTEST ADD CONSTRAINT PK_TOPCONVERTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPCONVERTEST_TREND;
CREATE TABLE TOPCONVERTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL,
protocol_MIN DECIMAL(20,4) NOT NULL,
protocol_MAX DECIMAL(20,4) NOT NULL,
protocol_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPCONVERTEST_TREND ADD CONSTRAINT PK_TOPCONVERTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPCONVERTEST_THRESH;
CREATE TABLE TOPCONVERTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL,
protocol_MIN VARCHAR(256) NOT NULL,
protocol_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPCONVERTEST_THRESH ADD CONSTRAINT PK_TOPCONVERTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPCONVERTEST_THRESH ON TOPCONVERTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPCONVERTEST ON TOPCONVERTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPCONVERTEST ON TOPCONVERTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE TOPAPPLICATIONTEST;
CREATE TABLE TOPAPPLICATIONTEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST(MSMT_TIME);
ALTER TABLE TOPAPPLICATIONTEST ADD CONSTRAINT PK_TOPAPPLICATIONTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPAPPLICATIONTEST_TREND;
CREATE TABLE TOPAPPLICATIONTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPAPPLICATIONTEST_TREND ADD CONSTRAINT PK_TOPAPPLICATIONTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPAPPLICATIONTEST_THRESH;
CREATE TABLE TOPAPPLICATIONTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPAPPLICATIONTEST_THRESH ADD CONSTRAINT PK_TOPAPPLICATIONTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPAPPLICATIONTEST_THRESH ON TOPAPPLICATIONTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPSITESTEST;
CREATE TABLE TOPSITESTEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPSITESTEST ON TOPSITESTEST(MSMT_TIME);
ALTER TABLE TOPSITESTEST ADD CONSTRAINT PK_TOPSITESTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPSITESTEST_TREND;
CREATE TABLE TOPSITESTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPSITESTEST_TREND ADD CONSTRAINT PK_TOPSITESTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPSITESTEST_THRESH;
CREATE TABLE TOPSITESTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPSITESTEST_THRESH ADD CONSTRAINT PK_TOPSITESTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPSITESTEST_THRESH ON TOPSITESTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPSITESTEST ON TOPSITESTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPSITESTEST ON TOPSITESTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE SpecificSrcTest;
CREATE TABLE SpecificSrcTest( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_SpecificSrcTest ON SpecificSrcTest(MSMT_TIME);
ALTER TABLE SpecificSrcTest ADD CONSTRAINT PK_SpecificSrcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SpecificSrcTest_TREND;
CREATE TABLE SpecificSrcTest_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE SpecificSrcTest_TREND ADD CONSTRAINT PK_SpecificSrcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SpecificSrcTest_THRESH;
CREATE TABLE SpecificSrcTest_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SpecificSrcTest_THRESH ADD CONSTRAINT PK_SpecificSrcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SpecificSrcTest_THRESH ON SpecificSrcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SpecificSrcTest ON SpecificSrcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SpecificSrcTest ON SpecificSrcTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SpecificDestTest;
CREATE TABLE SpecificDestTest( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_SpecificDestTest ON SpecificDestTest(MSMT_TIME);
ALTER TABLE SpecificDestTest ADD CONSTRAINT PK_SpecificDestTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SpecificDestTest_TREND;
CREATE TABLE SpecificDestTest_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE SpecificDestTest_TREND ADD CONSTRAINT PK_SpecificDestTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SpecificDestTest_THRESH;
CREATE TABLE SpecificDestTest_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SpecificDestTest_THRESH ADD CONSTRAINT PK_SpecificDestTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SpecificDestTest_THRESH ON SpecificDestTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SpecificDestTest ON SpecificDestTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SpecificDestTest ON SpecificDestTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SapWasUserSessTest;
CREATE TABLE SapWasUserSessTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO			varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL,
	MSMT_TIME 		datetime NOT NULL,
	LoggedInUsers			decimal(20,4) NOT NULL,
	LoggedInUsers_ST			varchar(32) NOT NULL,
	OpenedSessions			decimal(20,4) NOT NULL,
	OpenedSessions_ST			varchar(32) NOT NULL,
	ActiveSessions			decimal(20,4) NOT NULL,
	ActiveSessions_ST			varchar(32) NOT NULL,
	SecuritySessions			decimal(20,4) NOT NULL,
	SecuritySessions_ST			varchar(32) NOT NULL,
	EjbSessions			decimal(20,4) NOT NULL,
	EjbSessions_ST			varchar(32) NOT NULL
);
CREATE INDEX IDX_SapWasUserSessTest ON SapWasUserSessTest(MSMT_TIME);
ALTER TABLE SapWasUserSessTest ADD constraint PK_SapWasUserSessTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SapWasUserSessTest_TREND;
CREATE TABLE SapWasUserSessTest_TREND
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	LoggedInUsers_MIN			decimal(20,4) NOT NULL,
	LoggedInUsers_MAX			decimal(20,4) NOT NULL,
	LoggedInUsers_STCNT			varchar(32) NOT NULL,
	OpenedSessions_MIN			decimal(20,4) NOT NULL,
	OpenedSessions_MAX			decimal(20,4) NOT NULL,
	OpenedSessions_STCNT			varchar(32) NOT NULL,
	ActiveSessions_MIN			decimal(20,4) NOT NULL,
	ActiveSessions_MAX			decimal(20,4) NOT NULL,
	ActiveSessions_STCNT			varchar(32) NOT NULL,
	SecuritySessions_MIN			decimal(20,4) NOT NULL,
	SecuritySessions_MAX			decimal(20,4) NOT NULL,
	SecuritySessions_STCNT			varchar(32) NOT NULL,
	EjbSessions_MIN			decimal(20,4) NOT NULL,
	EjbSessions_MAX			decimal(20,4) NOT NULL,
	EjbSessions_STCNT			varchar(32) NOT NULL
);
ALTER TABLE SapWasUserSessTest_TREND ADD constraint PK_SapWasUserSessTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SapWasUserSessTest_THRESH;
CREATE TABLE SapWasUserSessTest_THRESH 
(
	TRGT_HOST 			varchar(32)  NOT NULL,
	PORT_NO         		varchar(32)  NOT NULL,
	SITE_NAME        		varchar(64)  NOT NULL,
	INFO            		varchar(128)  NOT NULL,
	MSMT_HOST 			varchar(32)  NOT NULL,
	MSMT_TIME_START			datetime  NOT NULL,
	MSMT_TIME_END   		datetime  NOT NULL,
	LoggedInUsers_MIN			varchar(256)	 NOT NULL,
	LoggedInUsers_MAX	varchar(256)	 NOT NULL,
	OpenedSessions_MIN			varchar(256)	 NOT NULL,
	OpenedSessions_MAX	varchar(256)	 NOT NULL,
	ActiveSessions_MIN			varchar(256)	 NOT NULL,
	ActiveSessions_MAX	varchar(256)	 NOT NULL,
	SecuritySessions_MIN			varchar(256)	 NOT NULL,
	SecuritySessions_MAX	varchar(256)	 NOT NULL,
	EjbSessions_MIN			varchar(256)	 NOT NULL,
	EjbSessions_MAX	varchar(256)	 NOT NULL
);
ALTER TABLE SapWasUserSessTest_THRESH ADD constraint PK_SapWasUserSessTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SapWasUserSessTest_THRESH ON SapWasUserSessTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SapWasUserSessTest ON SapWasUserSessTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SapWasUserSessTest ON SapWasUserSessTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HttpResponsesTest;
CREATE TABLE HttpResponsesTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
RESPONSES decimal(20,4) NOT NULL,
RESPONSES_ST varchar(32) NOT NULL,
RESPONSERATE decimal(20,4) NOT NULL,
RESPONSERATE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_HttpResponsesTest ON HttpResponsesTest(MSMT_TIME);
ALTER TABLE HttpResponsesTest ADD constraint PK_HttpResponsesTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HttpResponsesTest_TREND;
CREATE TABLE HttpResponsesTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
RESPONSES_MIN decimal(20,4) NOT NULL,
RESPONSES_MAX decimal(20,4) NOT NULL,
RESPONSES_STCNT varchar(32) NOT NULL,
RESPONSERATE_MIN decimal(20,4) NOT NULL,
RESPONSERATE_MAX decimal(20,4) NOT NULL,
RESPONSERATE_STCNT varchar(32) NOT NULL);

ALTER TABLE HttpResponsesTest_TREND ADD constraint PK_HttpResponsesTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HttpResponsesTest_THRESH;
CREATE TABLE HttpResponsesTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
RESPONSES_MIN VARCHAR(256) NOT NULL,
RESPONSES_MAX VARCHAR(256) NOT NULL,
RESPONSERATE_MIN VARCHAR(256) NOT NULL,
RESPONSERATE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE HttpResponsesTest_THRESH ADD constraint PK_HttpResponsesTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HttpResponsesTest_THRESH ON HttpResponsesTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HttpResponsesTest ON HttpResponsesTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HttpResponsesTest ON HttpResponsesTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE AsAbapCenProcTest;
CREATE TABLE AsAbapCenProcTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Display_Status DECIMAL(20,4) NOT NULL,
Display_Status_ST varchar(32) NOT NULL,
Process_Status DECIMAL(20,4) NOT NULL,
Process_Status_ST varchar(32) NOT NULL,
is_Restarted DECIMAL(20,4) NOT NULL,
is_Restarted_ST varchar(32) NOT NULL,
Total_uptime DECIMAL(20,4) NOT NULL,
Total_uptime_ST varchar(32) NOT NULL);

CREATE INDEX IDX_AsAbapCenProcTest ON AsAbapCenProcTest(MSMT_TIME);
ALTER TABLE AsAbapCenProcTest ADD constraint PK_AsAbapCenProcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsAbapCenProcTest_TREND;
CREATE TABLE AsAbapCenProcTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Display_Status_MIN DECIMAL(20,4) NOT NULL,
Display_Status_MAX DECIMAL(20,4) NOT NULL,
Display_Status_STCNT varchar(32) NOT NULL,
Process_Status_MIN DECIMAL(20,4) NOT NULL,
Process_Status_MAX DECIMAL(20,4) NOT NULL,
Process_Status_STCNT varchar(32) NOT NULL,
is_Restarted_MIN DECIMAL(20,4) NOT NULL,
is_Restarted_MAX DECIMAL(20,4) NOT NULL,
is_Restarted_STCNT varchar(32) NOT NULL,
Total_uptime_MIN DECIMAL(20,4) NOT NULL,
Total_uptime_MAX DECIMAL(20,4) NOT NULL,
Total_uptime_STCNT varchar(32) NOT NULL);

ALTER TABLE AsAbapCenProcTest_TREND ADD constraint PK_AsAbapCenProcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsAbapCenProcTest_THRESH;
CREATE TABLE AsAbapCenProcTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Display_Status_MIN VARCHAR(256) NOT NULL,
Display_Status_MAX VARCHAR(256) NOT NULL,
Process_Status_MIN VARCHAR(256) NOT NULL,
Process_Status_MAX VARCHAR(256) NOT NULL,
is_Restarted_MIN VARCHAR(256) NOT NULL,
is_Restarted_MAX VARCHAR(256) NOT NULL,
Total_uptime_MIN VARCHAR(256) NOT NULL,
Total_uptime_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AsAbapCenProcTest_THRESH ADD constraint PK_AsAbapCenProcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsAbapCenProcTest_THRESH ON AsAbapCenProcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsAbapCenProcTest ON AsAbapCenProcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsAbapCenProcTest ON AsAbapCenProcTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SAPLocksTest;
CREATE TABLE SAPLocksTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO			varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL,
	MSMT_TIME 		datetime NOT NULL,
	exclusiveLocks			decimal(20,4) NOT NULL,
	exclusiveLocks_ST			varchar(32) NOT NULL,
	exclNonCumLocks			decimal(20,4) NOT NULL,
	exclNonCumLocks_ST			varchar(32) NOT NULL,
	otherLocks			decimal(20,4) NOT NULL,
	otherLocks_ST			varchar(32) NOT NULL,
	allLocks			decimal(20,4) NOT NULL,
	allLocks_ST			varchar(32) NOT NULL,
	maxLocks			decimal(20,4) NOT NULL,
	maxLocks_ST			varchar(32) NOT NULL,
	currLockUtil			decimal(20,4) NOT NULL,
	currLockUtil_ST			varchar(32) NOT NULL,
	highLocks			decimal(20,4) NOT NULL,
	highLocks_ST			varchar(32) NOT NULL,
	highLockUtil			decimal(20,4) NOT NULL,
	highLockUtil_ST			varchar(32) NOT NULL,
	currOwners			decimal(20,4) NOT NULL,
	currOwners_ST			varchar(32) NOT NULL,
	currOwnerUtil			decimal(20,4) NOT NULL,
	currOwnerUtil_ST			varchar(32) NOT NULL,
	currArgs			decimal(20,4) NOT NULL,
	currArgs_ST			varchar(32) NOT NULL,
	currArgUtil			decimal(20,4) NOT NULL,
	currArgUtil_ST			varchar(32) NOT NULL,
	enqReqs			decimal(20,4) NOT NULL,
	enqReqs_ST			varchar(32) NOT NULL,
	enqReqRate			decimal(20,4) NOT NULL,
	enqReqRate_ST			varchar(32) NOT NULL,
	enqReqRej			decimal(20,4) NOT NULL,
	enqReqRej_ST			varchar(32) NOT NULL,
	enqReqRejRate			decimal(20,4) NOT NULL,
	enqReqRejRate_ST			varchar(32) NOT NULL,
	pctEnqReqRej			decimal(20,4) NOT NULL,
	pctEnqReqRej_ST			varchar(32) NOT NULL,
	enqErrs			decimal(20,4) NOT NULL,
	enqErrs_ST			varchar(32) NOT NULL,
	enqErrRate			decimal(20,4) NOT NULL,
	enqErrRate_ST			varchar(32) NOT NULL,
	deqReqs			decimal(20,4) NOT NULL,
	deqReqs_ST			varchar(32) NOT NULL,
	deqReqRate			decimal(20,4) NOT NULL,
	deqReqRate_ST			varchar(32) NOT NULL,
	deqErrs			decimal(20,4) NOT NULL,
	deqErrs_ST			varchar(32) NOT NULL,
	deqErrRate			decimal(20,4) NOT NULL,
	deqErrRate_ST			varchar(32) NOT NULL,
	UpdReqRate			decimal(20,4) NOT NULL,
	UpdReqRate_ST			varchar(32) NOT NULL,
	lckTblTime			decimal(20,4) NOT NULL,
	lckTblTime_ST			varchar(32) NOT NULL,
	lckTblWaitTime			decimal(20,4) NOT NULL,
	lckTblWaitTime_ST			varchar(32) NOT NULL,
	lckSrvTime			decimal(20,4) NOT NULL,
	lckSrvTime_ST			varchar(32) NOT NULL
);
CREATE INDEX IDX_SAPLocksTest ON SAPLocksTest(MSMT_TIME);
ALTER TABLE SAPLocksTest ADD constraint PK_SAPLocksTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPLocksTest_TREND;
CREATE TABLE SAPLocksTest_TREND
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	exclusiveLocks_MIN			decimal(20,4) NOT NULL,
	exclusiveLocks_MAX			decimal(20,4) NOT NULL,
	exclusiveLocks_STCNT			varchar(32) NOT NULL,
	exclNonCumLocks_MIN			decimal(20,4) NOT NULL,
	exclNonCumLocks_MAX			decimal(20,4) NOT NULL,
	exclNonCumLocks_STCNT			varchar(32) NOT NULL,
	otherLocks_MIN			decimal(20,4) NOT NULL,
	otherLocks_MAX			decimal(20,4) NOT NULL,
	otherLocks_STCNT			varchar(32) NOT NULL,
	allLocks_MIN			decimal(20,4) NOT NULL,
	allLocks_MAX			decimal(20,4) NOT NULL,
	allLocks_STCNT			varchar(32) NOT NULL,
	maxLocks_MIN			decimal(20,4) NOT NULL,
	maxLocks_MAX			decimal(20,4) NOT NULL,
	maxLocks_STCNT			varchar(32) NOT NULL,
	currLockUtil_MIN			decimal(20,4) NOT NULL,
	currLockUtil_MAX			decimal(20,4) NOT NULL,
	currLockUtil_STCNT			varchar(32) NOT NULL,
	highLocks_MIN			decimal(20,4) NOT NULL,
	highLocks_MAX			decimal(20,4) NOT NULL,
	highLocks_STCNT			varchar(32) NOT NULL,
	highLockUtil_MIN			decimal(20,4) NOT NULL,
	highLockUtil_MAX			decimal(20,4) NOT NULL,
	highLockUtil_STCNT			varchar(32) NOT NULL,
	currOwners_MIN			decimal(20,4) NOT NULL,
	currOwners_MAX			decimal(20,4) NOT NULL,
	currOwners_STCNT			varchar(32) NOT NULL,
	currOwnerUtil_MIN			decimal(20,4) NOT NULL,
	currOwnerUtil_MAX			decimal(20,4) NOT NULL,
	currOwnerUtil_STCNT			varchar(32) NOT NULL,
	currArgs_MIN			decimal(20,4) NOT NULL,
	currArgs_MAX			decimal(20,4) NOT NULL,
	currArgs_STCNT			varchar(32) NOT NULL,
	currArgUtil_MIN			decimal(20,4) NOT NULL,
	currArgUtil_MAX			decimal(20,4) NOT NULL,
	currArgUtil_STCNT			varchar(32) NOT NULL,
	enqReqs_MIN			decimal(20,4) NOT NULL,
	enqReqs_MAX			decimal(20,4) NOT NULL,
	enqReqs_STCNT			varchar(32) NOT NULL,
	enqReqRate_MIN			decimal(20,4) NOT NULL,
	enqReqRate_MAX			decimal(20,4) NOT NULL,
	enqReqRate_STCNT			varchar(32) NOT NULL,
	enqReqRej_MIN			decimal(20,4) NOT NULL,
	enqReqRej_MAX			decimal(20,4) NOT NULL,
	enqReqRej_STCNT			varchar(32) NOT NULL,
	enqReqRejRate_MIN			decimal(20,4) NOT NULL,
	enqReqRejRate_MAX			decimal(20,4) NOT NULL,
	enqReqRejRate_STCNT			varchar(32) NOT NULL,
	pctEnqReqRej_MIN			decimal(20,4) NOT NULL,
	pctEnqReqRej_MAX			decimal(20,4) NOT NULL,
	pctEnqReqRej_STCNT			varchar(32) NOT NULL,
	enqErrs_MIN			decimal(20,4) NOT NULL,
	enqErrs_MAX			decimal(20,4) NOT NULL,
	enqErrs_STCNT			varchar(32) NOT NULL,
	enqErrRate_MIN			decimal(20,4) NOT NULL,
	enqErrRate_MAX			decimal(20,4) NOT NULL,
	enqErrRate_STCNT			varchar(32) NOT NULL,
	deqReqs_MIN			decimal(20,4) NOT NULL,
	deqReqs_MAX			decimal(20,4) NOT NULL,
	deqReqs_STCNT			varchar(32) NOT NULL,
	deqReqRate_MIN			decimal(20,4) NOT NULL,
	deqReqRate_MAX			decimal(20,4) NOT NULL,
	deqReqRate_STCNT			varchar(32) NOT NULL,
	deqErrs_MIN			decimal(20,4) NOT NULL,
	deqErrs_MAX			decimal(20,4) NOT NULL,
	deqErrs_STCNT			varchar(32) NOT NULL,
	deqErrRate_MIN			decimal(20,4) NOT NULL,
	deqErrRate_MAX			decimal(20,4) NOT NULL,
	deqErrRate_STCNT			varchar(32) NOT NULL,
	UpdReqRate_MIN			decimal(20,4) NOT NULL,
	UpdReqRate_MAX			decimal(20,4) NOT NULL,
	UpdReqRate_STCNT			varchar(32) NOT NULL,
	lckTblTime_MIN			decimal(20,4) NOT NULL,
	lckTblTime_MAX			decimal(20,4) NOT NULL,
	lckTblTime_STCNT			varchar(32) NOT NULL,
	lckTblWaitTime_MIN			decimal(20,4) NOT NULL,
	lckTblWaitTime_MAX			decimal(20,4) NOT NULL,
	lckTblWaitTime_STCNT			varchar(32) NOT NULL,
	lckSrvTime_MIN			decimal(20,4) NOT NULL,
	lckSrvTime_MAX			decimal(20,4) NOT NULL,
	lckSrvTime_STCNT			varchar(32) NOT NULL
);
ALTER TABLE SAPLocksTest_TREND ADD constraint PK_SAPLocksTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPLocksTest_THRESH;
CREATE TABLE SAPLocksTest_THRESH 
(
	TRGT_HOST 			varchar(32)  NOT NULL,
	PORT_NO         		varchar(32)  NOT NULL,
	SITE_NAME        		varchar(64)  NOT NULL,
	INFO            		varchar(128)  NOT NULL,
	MSMT_HOST 			varchar(32)  NOT NULL,
	MSMT_TIME_START			datetime  NOT NULL,
	MSMT_TIME_END   		datetime  NOT NULL,
	exclusiveLocks_MIN			varchar(256)	 NOT NULL,
	exclusiveLocks_MAX	varchar(256)	 NOT NULL,
	exclNonCumLocks_MIN			varchar(256)	 NOT NULL,
	exclNonCumLocks_MAX	varchar(256)	 NOT NULL,
	otherLocks_MIN			varchar(256)	 NOT NULL,
	otherLocks_MAX	varchar(256)	 NOT NULL,
	allLocks_MIN			varchar(256)	 NOT NULL,
	allLocks_MAX	varchar(256)	 NOT NULL,
	maxLocks_MIN			varchar(256)	 NOT NULL,
	maxLocks_MAX	varchar(256)	 NOT NULL,
	currLockUtil_MIN			varchar(256)	 NOT NULL,
	currLockUtil_MAX	varchar(256)	 NOT NULL,
	highLocks_MIN			varchar(256)	 NOT NULL,
	highLocks_MAX	varchar(256)	 NOT NULL,
	highLockUtil_MIN			varchar(256)	 NOT NULL,
	highLockUtil_MAX	varchar(256)	 NOT NULL,
	currOwners_MIN			varchar(256)	 NOT NULL,
	currOwners_MAX	varchar(256)	 NOT NULL,
	currOwnerUtil_MIN			varchar(256)	 NOT NULL,
	currOwnerUtil_MAX	varchar(256)	 NOT NULL,
	currArgs_MIN			varchar(256)	 NOT NULL,
	currArgs_MAX	varchar(256)	 NOT NULL,
	currArgUtil_MIN			varchar(256)	 NOT NULL,
	currArgUtil_MAX	varchar(256)	 NOT NULL,
	enqReqs_MIN			varchar(256)	 NOT NULL,
	enqReqs_MAX	varchar(256)	 NOT NULL,
	enqReqRate_MIN			varchar(256)	 NOT NULL,
	enqReqRate_MAX	varchar(256)	 NOT NULL,
	enqReqRej_MIN			varchar(256)	 NOT NULL,
	enqReqRej_MAX	varchar(256)	 NOT NULL,
	enqReqRejRate_MIN			varchar(256)	 NOT NULL,
	enqReqRejRate_MAX	varchar(256)	 NOT NULL,
	pctEnqReqRej_MIN			varchar(256)	 NOT NULL,
	pctEnqReqRej_MAX	varchar(256)	 NOT NULL,
	enqErrs_MIN			varchar(256)	 NOT NULL,
	enqErrs_MAX	varchar(256)	 NOT NULL,
	enqErrRate_MIN			varchar(256)	 NOT NULL,
	enqErrRate_MAX	varchar(256)	 NOT NULL,
	deqReqs_MIN			varchar(256)	 NOT NULL,
	deqReqs_MAX	varchar(256)	 NOT NULL,
	deqReqRate_MIN			varchar(256)	 NOT NULL,
	deqReqRate_MAX	varchar(256)	 NOT NULL,
	deqErrs_MIN			varchar(256)	 NOT NULL,
	deqErrs_MAX	varchar(256)	 NOT NULL,
	deqErrRate_MIN			varchar(256)	 NOT NULL,
	deqErrRate_MAX	varchar(256)	 NOT NULL,
	UpdReqRate_MIN			varchar(256)	 NOT NULL,
	UpdReqRate_MAX	varchar(256)	 NOT NULL,
	lckTblTime_MIN			varchar(256)	 NOT NULL,
	lckTblTime_MAX	varchar(256)	 NOT NULL,
	lckTblWaitTime_MIN			varchar(256)	 NOT NULL,
	lckTblWaitTime_MAX	varchar(256)	 NOT NULL,
	lckSrvTime_MIN			varchar(256)	 NOT NULL,
	lckSrvTime_MAX	varchar(256)	 NOT NULL
);
ALTER TABLE SAPLocksTest_THRESH ADD constraint PK_SAPLocksTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPLocksTest_THRESH ON SAPLocksTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SAPLocksTest ON SAPLocksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SAPLocksTest ON SAPLocksTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SAPICMTest;
CREATE TABLE SAPICMTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO			varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL,
	MSMT_TIME 		datetime NOT NULL,
	RUNTHRD			decimal(20,4) NOT NULL,
	RUNTHRD_ST			varchar(32) NOT NULL,
	IDLTHRD			decimal(20,4) NOT NULL,
	IDLTHRD_ST			varchar(32) NOT NULL,
	USDTHRD			decimal(20,4) NOT NULL,
	USDTHRD_ST			varchar(32) NOT NULL,
	MAXTHRD			decimal(20,4) NOT NULL,
	MAXTHRD_ST			varchar(32) NOT NULL,
	USDTHRDPCT			decimal(20,4) NOT NULL,
	USDTHRDPCT_ST			varchar(32) NOT NULL,
	RUNTHRDPCT			decimal(20,4) NOT NULL,
	RUNTHRDPCT_ST			varchar(32) NOT NULL,
	RUNCRTTHRDPCT			decimal(20,4) NOT NULL,
	RUNCRTTHRDPCT_ST			varchar(32) NOT NULL,
	USDCONNS			decimal(20,4) NOT NULL,
	USDCONNS_ST			varchar(32) NOT NULL,
	USDCONNSPCT			decimal(20,4) NOT NULL,
	USDCONNSPCT_ST			varchar(32) NOT NULL,
	MAXCONNS			decimal(20,4) NOT NULL,
	MAXCONNS_ST			varchar(32) NOT NULL,
	QUENOW			decimal(20,4) NOT NULL,
	QUENOW_ST			varchar(32) NOT NULL,
	USDQUESPCT			decimal(20,4) NOT NULL,
	USDQUESPCT_ST			varchar(32) NOT NULL,
	MAXQUES			decimal(20,4) NOT NULL,
	MAXQUES_ST			varchar(32) NOT NULL
);
CREATE INDEX IDX_SAPICMTest ON SAPICMTest(MSMT_TIME);
ALTER TABLE SAPICMTest ADD constraint PK_SAPICMTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPICMTest_TREND;
CREATE TABLE SAPICMTest_TREND
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	RUNTHRD_MIN			decimal(20,4) NOT NULL,
	RUNTHRD_MAX			decimal(20,4) NOT NULL,
	RUNTHRD_STCNT			varchar(32) NOT NULL,
	IDLTHRD_MIN			decimal(20,4) NOT NULL,
	IDLTHRD_MAX			decimal(20,4) NOT NULL,
	IDLTHRD_STCNT			varchar(32) NOT NULL,
	USDTHRD_MIN			decimal(20,4) NOT NULL,
	USDTHRD_MAX			decimal(20,4) NOT NULL,
	USDTHRD_STCNT			varchar(32) NOT NULL,
	MAXTHRD_MIN			decimal(20,4) NOT NULL,
	MAXTHRD_MAX			decimal(20,4) NOT NULL,
	MAXTHRD_STCNT			varchar(32) NOT NULL,
	USDTHRDPCT_MIN			decimal(20,4) NOT NULL,
	USDTHRDPCT_MAX			decimal(20,4) NOT NULL,
	USDTHRDPCT_STCNT			varchar(32) NOT NULL,
	RUNTHRDPCT_MIN			decimal(20,4) NOT NULL,
	RUNTHRDPCT_MAX			decimal(20,4) NOT NULL,
	RUNTHRDPCT_STCNT			varchar(32) NOT NULL,
	RUNCRTTHRDPCT_MIN			decimal(20,4) NOT NULL,
	RUNCRTTHRDPCT_MAX			decimal(20,4) NOT NULL,
	RUNCRTTHRDPCT_STCNT			varchar(32) NOT NULL,
	USDCONNS_MIN			decimal(20,4) NOT NULL,
	USDCONNS_MAX			decimal(20,4) NOT NULL,
	USDCONNS_STCNT			varchar(32) NOT NULL,
	USDCONNSPCT_MIN			decimal(20,4) NOT NULL,
	USDCONNSPCT_MAX			decimal(20,4) NOT NULL,
	USDCONNSPCT_STCNT			varchar(32) NOT NULL,
	MAXCONNS_MIN			decimal(20,4) NOT NULL,
	MAXCONNS_MAX			decimal(20,4) NOT NULL,
	MAXCONNS_STCNT			varchar(32) NOT NULL,
	QUENOW_MIN			decimal(20,4) NOT NULL,
	QUENOW_MAX			decimal(20,4) NOT NULL,
	QUENOW_STCNT			varchar(32) NOT NULL,
	USDQUESPCT_MIN			decimal(20,4) NOT NULL,
	USDQUESPCT_MAX			decimal(20,4) NOT NULL,
	USDQUESPCT_STCNT			varchar(32) NOT NULL,
	MAXQUES_MIN			decimal(20,4) NOT NULL,
	MAXQUES_MAX			decimal(20,4) NOT NULL,
	MAXQUES_STCNT			varchar(32) NOT NULL
);
ALTER TABLE SAPICMTest_TREND ADD constraint PK_SAPICMTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPICMTest_THRESH;
CREATE TABLE SAPICMTest_THRESH 
(
	TRGT_HOST 			varchar(32)  NOT NULL,
	PORT_NO         		varchar(32)  NOT NULL,
	SITE_NAME        		varchar(64)  NOT NULL,
	INFO            		varchar(128)  NOT NULL,
	MSMT_HOST 			varchar(32)  NOT NULL,
	MSMT_TIME_START			datetime  NOT NULL,
	MSMT_TIME_END   		datetime  NOT NULL,
	RUNTHRD_MIN			varchar(256)	 NOT NULL,
	RUNTHRD_MAX	varchar(256)	 NOT NULL,
	IDLTHRD_MIN			varchar(256)	 NOT NULL,
	IDLTHRD_MAX	varchar(256)	 NOT NULL,
	USDTHRD_MIN			varchar(256)	 NOT NULL,
	USDTHRD_MAX	varchar(256)	 NOT NULL,
	MAXTHRD_MIN			varchar(256)	 NOT NULL,
	MAXTHRD_MAX	varchar(256)	 NOT NULL,
	USDTHRDPCT_MIN			varchar(256)	 NOT NULL,
	USDTHRDPCT_MAX	varchar(256)	 NOT NULL,
	RUNTHRDPCT_MIN			varchar(256)	 NOT NULL,
	RUNTHRDPCT_MAX	varchar(256)	 NOT NULL,
	RUNCRTTHRDPCT_MIN			varchar(256)	 NOT NULL,
	RUNCRTTHRDPCT_MAX	varchar(256)	 NOT NULL,
	USDCONNS_MIN			varchar(256)	 NOT NULL,
	USDCONNS_MAX	varchar(256)	 NOT NULL,
	USDCONNSPCT_MIN			varchar(256)	 NOT NULL,
	USDCONNSPCT_MAX	varchar(256)	 NOT NULL,
	MAXCONNS_MIN			varchar(256)	 NOT NULL,
	MAXCONNS_MAX	varchar(256)	 NOT NULL,
	QUENOW_MIN			varchar(256)	 NOT NULL,
	QUENOW_MAX	varchar(256)	 NOT NULL,
	USDQUESPCT_MIN			varchar(256)	 NOT NULL,
	USDQUESPCT_MAX	varchar(256)	 NOT NULL,
	MAXQUES_MIN			varchar(256)	 NOT NULL,
	MAXQUES_MAX	varchar(256)	 NOT NULL
);
ALTER TABLE SAPICMTest_THRESH ADD constraint PK_SAPICMTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPICMTest_THRESH ON SAPICMTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SAPICMTest ON SAPICMTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SAPICMTest ON SAPICMTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSysLogSvrTest;
CREATE TABLE EgSysLogSvrTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES decimal(20,4) NOT NULL,
NO_OF_MESSAGES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSysLogSvrTest ON EgSysLogSvrTest(MSMT_TIME);
ALTER TABLE EgSysLogSvrTest ADD constraint PK_EgSysLogSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogSvrTest_TREND;
CREATE TABLE EgSysLogSvrTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT varchar(32) NOT NULL);

ALTER TABLE EgSysLogSvrTest_TREND ADD constraint PK_EgSysLogSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogSvrTest_THRESH;
CREATE TABLE EgSysLogSvrTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSysLogSvrTest_THRESH ADD constraint PK_EgSysLogSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogSvrTest_THRESH ON EgSysLogSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogSvrTest ON EgSysLogSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogSvrTest ON EgSysLogSvrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EgSysLogAppTest;
CREATE TABLE EgSysLogAppTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES decimal(20,4) NOT NULL,
NO_OF_MESSAGES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSysLogAppTest ON EgSysLogAppTest(MSMT_TIME);
ALTER TABLE EgSysLogAppTest ADD constraint PK_EgSysLogAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogAppTest_TREND;
CREATE TABLE EgSysLogAppTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT varchar(32) NOT NULL);

ALTER TABLE EgSysLogAppTest_TREND ADD constraint PK_EgSysLogAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogAppTest_THRESH;
CREATE TABLE EgSysLogAppTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSysLogAppTest_THRESH ADD constraint PK_EgSysLogAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogAppTest_THRESH ON EgSysLogAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogAppTest ON EgSysLogAppTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogAppTest ON EgSysLogAppTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSyslogFilterTest;
CREATE TABLE EgSyslogFilterTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterTest ON EgSyslogFilterTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterTest ADD constraint PK_EgSyslogFilterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterTest_TREND;
CREATE TABLE EgSyslogFilterTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT varchar(32) NOT NULL);



ALTER TABLE EgSyslogFilterTest_TREND ADD constraint PK_EgSyslogFilterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterTest_THRESH;
CREATE TABLE EgSyslogFilterTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,	
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSyslogFilterTest_THRESH ADD constraint PK_EgSyslogFilterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslogFilterTest_THRESH ON EgSyslogFilterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterTest ON EgSyslogFilterTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterTest ON EgSyslogFilterTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EgSyslogFilterSvrTest;
CREATE TABLE EgSyslogFilterSvrTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterSvrTest ADD constraint PK_EgSyslogFilterSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterSvrTest_TREND;
CREATE TABLE EgSyslogFilterSvrTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT varchar(32) NOT NULL);



ALTER TABLE EgSyslogFilterSvrTest_TREND ADD constraint PK_EgSyslogFilterSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterSvrTest_THRESH;
CREATE TABLE EgSyslogFilterSvrTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,	
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSyslogFilterSvrTest_THRESH ADD constraint PK_EgSyslgFiltrSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslgFiltrSvrTest_THRESH ON EgSyslogFilterSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE   asset_info_custom;
DROP TABLE   asset_info_default;

create table asset_info_default (trgt_host varchar(256) not null,asset_name varchar(32),asset_desc varchar(1024),asset_type varchar(32),asset_state varchar(32),ip_address varchar(32),mac_address varchar(32),operating_system varchar(256),os_version varchar(32),os_servicepack varchar(32),memory varchar(32),disk_space varchar(32),cpu_speed varchar(32),cpu_corecount varchar(32),uuid varchar(32),manufacturer varchar(32),serial_number varchar(32),asm_expiry_date varchar(32),product varchar(32),vendor varchar(32),version varchar(32),domain varchar(32),cost varchar(32),license_validity varchar(32),license_key varchar(32),license_type varchar(32),license_serial_number varchar(32),installation_date varchar(32),installed_machine varchar(32),installation_path varchar(32),warranty varchar(32),acquisition_date varchar(32),license_expiry_date varchar(32),firmware varchar(32),firmware_version varchar(32),subnet_mask varchar(32),bandwidth varchar(32),network_range varchar(32),battery_status varchar(32),battery_voltage varchar(32),battery_current varchar(32),last_audit_date varchar(32),account varchar(32),region varchar(32),availability_zone varchar(32),asset_user varchar(32),location varchar(32),email_id varchar(32),phone_number varchar(32),asset_support_group varchar(32),asset_business_impact varchar(32),asset_busines_service varchar(32));
ALTER TABLE asset_info_default ADD constraint PK_asset_info_default PRIMARY KEY (trgt_host);

create table asset_info_custom (trgt_host varchar(256) not null);
alter table asset_info_custom add constraint FK_asset_info_custom foreign key(trgt_host) references asset_info_default(trgt_host) ON DELETE CASCADE;

DROP TABLE MYDASHBOARDTEMPLATES;
CREATE TABLE MYDASHBOARDTEMPLATES(USERID VARCHAR(256) NOT NULL,TEMPLATENAME VARCHAR(2000) NOT NULL,ACCESSTYPE VARCHAR(2048) NOT NULL);

DROP TABLE CUSTOMDASHBOARDTEMPLATES;
CREATE TABLE CUSTOMDASHBOARDTEMPLATES(USERID VARCHAR(256) NOT NULL,TEMPLATENAME VARCHAR(2000) NOT NULL,ACCESSTYPE VARCHAR(2048) NOT NULL);

DROP TABLE ALARM;
CREATE TABLE ALARM 
(
	COMP_NAME	    varchar(1024) NOT NULL,
	COMP_TYPE	    varchar(32) NOT NULL,
	LAYER_NAME	    varchar(64) NOT NULL,
	PROBLEM_DESC	    varchar(4000) NOT NULL, 
	PRIORITY	    varchar(32) NOT NULL,
        MSMT_TIME	    datetime NOT NULL,
	ALARM_ID            decimal(18) NOT NULL			
 );
CREATE NONCLUSTERED INDEX IDX_ALARM ON ALARM (PRIORITY,COMP_TYPE) INCLUDE ( COMP_NAME, LAYER_NAME, PROBLEM_DESC,MSMT_TIME, ALARM_ID);
alter table ALARM add constraint PK_ALARM
primary key (ALARM_ID);

DROP TABLE ATGTEST;
CREATE TABLE ATGTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PCT_MEM_USE 	decimal(20,4) 	NOT NULL,
	PCT_MEM_USE_ST 	varchar(32) 	NOT NULL,
	SESSION_RATE 	decimal(20,4) 	NOT NULL,
	SESSION_RATE_ST	varchar(32) 	NOT NULL,
	SESSION_COUNT 	decimal(20,4) 	NOT NULL,
	SESSION_COUNT_ST varchar(32) 	NOT NULL,
	DRP_REQUEST_RATE decimal(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_ST varchar(32) NOT NULL,
	DRP_RESP_RATE decimal(20,4) 	NOT NULL,
	DRP_RESP_RATE_ST varchar(32) 	NOT NULL
);

ALTER TABLE ATGTEST ADD constraint PK_ATG
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ATGTEST_TREND;

CREATE TABLE ATGTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	PCT_MEM_USE_MIN	        decimal(20,4) 	NOT NULL,
	PCT_MEM_USE_MAX	        decimal(20,4) 	NOT NULL,
	PCT_MEM_USE_STCNT 	varchar(32) 	NOT NULL,
	SESSION_RATE_MIN	decimal(20,4) 	NOT NULL,
	SESSION_RATE_MAX	decimal(20,4) 	NOT NULL,
	SESSION_RATE_STCNT 	varchar(32) 	NOT NULL,
	SESSION_COUNT_MIN	decimal(20,4) 	NOT NULL,
	SESSION_COUNT_MAX	decimal(20,4) 	NOT NULL,
	SESSION_COUNT_STCNT 	varchar(32) 	NOT NULL,
	DRP_REQUEST_RATE_MIN	decimal(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_MAX	decimal(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_STCNT 	varchar(32) 	NOT NULL,
	DRP_RESP_RATE_MIN	decimal(20,4) 	NOT NULL,
	DRP_RESP_RATE_MAX	decimal(20,4) 	NOT NULL,
	DRP_RESP_RATE_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE ATGTEST_TREND ADD constraint PK_ATG_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ATGTEST_THRESH;

CREATE TABLE ATGTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PCT_MEM_USE_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_MEM_USE_MAX	VARCHAR(256)	 	NOT NULL,
	SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	SESSION_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DRP_RESP_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DRP_RESP_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE ATGTEST_THRESH ADD constraint PK_ATG_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ATGTEST_THRESH ON ATGTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


CREATE  INDEX IDX_ATGTEST ON ATGTEST
(
	 MSMT_TIME
);


DROP TABLE ATGJDBCTEST;

CREATE TABLE ATGJDBCTEST
(
	TRGT_HOST 	varchar(32)	NOT NULL,
	PORT_NO         varchar(32)	NOT NULL,
	SITE_NAME       varchar(64)	NOT NULL,
	INFO            varchar(128)	NOT NULL,
	MSMT_HOST 	varchar(32)	NOT NULL, 
	MSMT_TIME 	datetime	NOT NULL,
	CONN_USE_PCT 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar(32) 	NOT NULL,
	IDLE_CONN_PCT 	decimal(20,4) 	NOT NULL,
	IDLE_CONN_PCT_ST varchar(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST ADD constraint PK_ATG_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE INDEX IDX_ATGJDBCTEST ON ATGJDBCTEST
(
	 MSMT_TIME
);

DROP TABLE ATGJDBCTEST_TREND;

CREATE TABLE ATGJDBCTEST_TREND 
(
	TRGT_HOST		varchar(32)	NOT NULL,
	PORT_NO         	varchar(32)	NOT NULL,
	SITE_NAME       	varchar(64)	NOT NULL,
	INFO            	varchar(128)	NOT NULL,
	MSMT_HOST 		varchar(32)	NOT NULL, 
	MSMT_TIME		datetime	NOT NULL,
	PERIOD 			varchar(32)	NOT NULL,
	CONN_USE_PCT_MIN 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar(32) 	NOT NULL,
	IDLE_CONN_PCT_MIN 	decimal(20,4) 	NOT NULL,
	IDLE_CONN_PCT_MAX 	decimal(20,4) 	NOT NULL,
	IDLE_CONN_PCT_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_TREND ADD constraint PK_ATG_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
 
DROP TABLE ATGJDBCTEST_THRESH ;

CREATE TABLE ATGJDBCTEST_THRESH 
(
	TRGT_HOST	 	varchar(32)	NOT NULL,
	PORT_NO  	       	varchar(32) 	NOT NULL,
	SITE_NAME	        varchar(64)	NOT NULL,
	INFO     	       	varchar(128)	NOT NULL,
	MSMT_HOST	 	varchar(32)	NOT NULL, 
	MSMT_TIME_START		datetime	NOT NULL,
        MSMT_TIME_END  		datetime 	NOT NULL,
	CONN_USE_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	IDLE_CONN_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	IDLE_CONN_PCT_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_THRESH ADD constraint PK_ATG_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ATGJDBCTEST_THRESH ON ATGJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE CHECKPOINTTEST;

CREATE TABLE CHECKPOINTTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
	PKT_PROCESSING_RATE 	decimal(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_ST 	varchar(32)    NOT NULL,
	PCT_ACC_PKTS 		decimal(20,4) 	NOT NULL,
	PCT_ACC_PKTS_ST 	varchar(32)    NOT NULL,
	PCT_REJ_PKTS 		decimal(20,4) 	NOT NULL,
	PCT_REJ_PKTS_ST 	varchar(32)    NOT NULL,
	PCT_DROP_PKTS 		decimal(20,4) 	NOT NULL,
	PCT_DROP_PKTS_ST 	varchar(32)    NOT NULL
);

ALTER TABLE CHECKPOINTTEST ADD CONSTRAINT PK_CHECK_POINT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_CHECKPOINTTEST ON CHECKPOINTTEST
(
	 MSMT_TIME
);

DROP TABLE CHECKPOINTTEST_TREND;
CREATE TABLE CHECKPOINTTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                 	varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
	PKT_PROCESSING_RATE_MIN 		decimal(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_MAX 		decimal(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_STCNT		varchar(32) NOT NULL,
	PCT_ACC_PKTS_MIN 		decimal(20,4) 	NOT NULL,
	PCT_ACC_PKTS_MAX 		decimal(20,4) 	NOT NULL,
	PCT_ACC_PKTS_STCNT		varchar(32) NOT NULL,
	PCT_REJ_PKTS_MIN 		decimal(20,4) 	NOT NULL,
	PCT_REJ_PKTS_MAX 		decimal(20,4) 	NOT NULL,
	PCT_REJ_PKTS_STCNT 		varchar(32) NOT NULL,
	PCT_DROP_PKTS_MIN 		decimal(20,4) 	NOT NULL,
	PCT_DROP_PKTS_MAX 		decimal(20,4) 	NOT NULL,
	PCT_DROP_PKTS_STCNT 		varchar(32) NOT NULL
);

ALTER TABLE CHECKPOINTTEST_TREND ADD CONSTRAINT PK_CHECK_POINT_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE CHECKPOINTTEST_THRESH;
CREATE TABLE CHECKPOINTTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
	PKT_PROCESSING_RATE_MIN	VARCHAR(256)		NOT NULL,
	PKT_PROCESSING_RATE_MAX	VARCHAR(256)		NOT NULL,
	PCT_ACC_PKTS_MIN	VARCHAR(256)		NOT NULL,
	PCT_ACC_PKTS_MAX	VARCHAR(256)		NOT NULL,
	PCT_REJ_PKTS_MIN	VARCHAR(256)		NOT NULL,
	PCT_REJ_PKTS_MAX	VARCHAR(256)		NOT NULL,
	PCT_DROP_PKTS_MIN	VARCHAR(256)		NOT NULL,
	PCT_DROP_PKTS_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE CHECKPOINTTEST_THRESH ADD CONSTRAINT PK_CHECK_POINT_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CHECKPOINTTEST_THRESH ON CHECKPOINTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CISCOCPUTEST;

CREATE TABLE CISCOCPUTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	UTIL_PCT 	decimal(20,4) 	NOT NULL,
	UTIL_PCT_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST ADD constraint PK_CISCO_CPU
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_CISCOCPUTEST ON CISCOCPUTEST (MSMT_TIME) INCLUDE (UTIL_PCT);

DROP TABLE CISCOCPUTEST_TREND;

CREATE TABLE CISCOCPUTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	UTIL_PCT_MIN 		decimal(20,4) 	NOT NULL,
	UTIL_PCT_MAX 		decimal(20,4) 	NOT NULL,
	UTIL_PCT_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_TREND ADD constraint PK_CISCO_CPU_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOCPUTEST_THRESH;

CREATE TABLE CISCOCPUTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	UTIL_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_THRESH ADD constraint PK_CISCO_CPU_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOCPUTEST_THRESH ON CISCOCPUTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CISCOMEMORYTEST;
CREATE TABLE CISCOMEMORYTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	USED_PCT 	decimal(20,4) 	NOT NULL,
	USED_PCT_ST 	varchar(32) 	NOT NULL,
	USED_MEMORY	decimal(20,4) 	NOT NULL,
	USED_MEMORY_ST	varchar(32) 	NOT NULL,
	FREE_MEMORY	decimal(20,4) 	NOT NULL,
	FREE_MEMORY_ST	varchar(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST ADD constraint PK_CISCO_MEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_CISCOMEMORYTEST ON CISCOMEMORYTEST (MSMT_TIME)INCLUDE (USED_PCT);

DROP TABLE CISCOMEMORYTEST_TREND;
CREATE TABLE CISCOMEMORYTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	USED_PCT_MIN 		decimal(20,4) 	NOT NULL,
	USED_PCT_MAX 		decimal(20,4) 	NOT NULL,
	USED_PCT_STCNT 		varchar(32) 	NOT NULL,
	USED_MEMORY_MIN		decimal(20,4) 	NOT NULL,
	USED_MEMORY_MAX		decimal(20,4) 	NOT NULL,
	USED_MEMORY_STCNT	varchar(32) 	NOT NULL,
	FREE_MEMORY_MIN		decimal(20,4) 	NOT NULL,
	FREE_MEMORY_MAX		decimal(20,4) 	NOT NULL,
	FREE_MEMORY_STCNT	varchar(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_TREND ADD constraint PK_CISCO_MEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOMEMORYTEST_THRESH;
CREATE TABLE CISCOMEMORYTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	USED_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	USED_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	USED_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	USED_MEMORY_MAX	VARCHAR(256)	 	NOT NULL,
	FREE_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	FREE_MEMORY_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_THRESH ADD constraint PK_CISCO_MEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOMEMORYTEST_THRESH ON CISCOMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE COLDFUSIONTEST ;

CREATE TABLE COLDFUSIONTEST
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(64) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        PAGE_HIT_RATE           decimal(20,4)    NOT NULL, 
	PAGE_HIT_RATE_ST       	varchar(32)  	NOT NULL,
        DB_HIT_RATE 		decimal(20,4)    NOT NULL,
        DB_HIT_RATE_ST 		varchar(32)  	NOT NULL,
        BYTES_IN_RATE           decimal(20,4)    NOT NULL, 
        BYTES_IN_RATE_ST        varchar(32)     NOT NULL,
        BYTES_OUT_RATE          decimal(20,4)    NOT NULL, 
        BYTES_OUT_RATE_ST       varchar(32)     NOT NULL,
        REQUESTS_QUEUED         decimal(20,4)    NOT NULL, 
        REQUESTS_QUEUED_ST      varchar(32)     NOT NULL,
        REQUESTS_RUNNING        decimal(20,4)    NOT NULL, 
       	REQUESTS_RUNNING_ST  	varchar(32)     NOT NULL,
	REQ_TOUT_RATE		decimal(20,4)   	NOT NULL,
	REQ_TOUT_RATE_ST	varchar(32)	NOT NULL,
	AVG_QUEUE_TIME		decimal(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_ST	varchar(32)	NOT NULL,
        AVG_REQ_TIME        	decimal(20,4)    NOT NULL, 
       	AVG_REQ_TIME_ST  	varchar(32)     NOT NULL,
        AVG_DB_TIME        	decimal(20,4)    NOT NULL, 
       	AVG_DB_TIME_ST  	varchar(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST ADD CONSTRAINT PK_CFTEST_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_COLDFUSIONTEST ON COLDFUSIONTEST
(
	 MSMT_TIME
);

DROP TABLE COLDFUSIONTEST_TREND;
CREATE TABLE COLDFUSIONTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(64) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD			varchar(32) NOT NULL, 
        PAGE_HIT_RATE_MIN       decimal(20,4)    NOT NULL, 
        PAGE_HIT_RATE_MAX       decimal(20,4)    NOT NULL,
	PAGE_HIT_RATE_STCNT	varchar(32)     NOT NULL, 
        DB_HIT_RATE_MIN 	decimal(20,4)    NOT NULL,
        DB_HIT_RATE_MAX 	decimal(20,4)    NOT NULL,
	DB_HIT_RATE_STCNT	varchar(32)     NOT NULL,
        BYTES_IN_RATE_MIN       decimal(20,4)    NOT NULL, 
        BYTES_IN_RATE_MAX       decimal(20,4)    NOT NULL, 
	BYTES_IN_RATE_STCNT	varchar(32)     NOT NULL,
        BYTES_OUT_RATE_MIN      decimal(20,4)    NOT NULL, 
        BYTES_OUT_RATE_MAX      decimal(20,4)    NOT NULL, 
	BYTES_OUT_RATE_STCNT	varchar(32)     NOT NULL,
        REQUESTS_QUEUED_MIN     decimal(20,4)    NOT NULL, 
        REQUESTS_QUEUED_MAX     decimal(20,4)    NOT NULL, 
	REQUESTS_QUEUED_STCNT	varchar(32)     NOT NULL,
        REQUESTS_RUNNING_MIN    decimal(20,4)    NOT NULL, 
        REQUESTS_RUNNING_MAX    decimal(20,4)    NOT NULL, 
	REQUESTS_RUNNING_STCNT	varchar(32)     NOT NULL,
	REQ_TOUT_RATE_MIN	decimal(20,4)   	NOT NULL,
	REQ_TOUT_RATE_MAX	decimal(20,4)   	NOT NULL,
	REQ_TOUT_RATE_STCNT	varchar(32)     NOT NULL,
	AVG_QUEUE_TIME_MIN	decimal(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_MAX	decimal(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_STCNT	varchar(32)     NOT NULL,
        AVG_REQ_TIME_MIN       	decimal(20,4)    NOT NULL, 
        AVG_REQ_TIME_MAX       	decimal(20,4)    NOT NULL, 
	AVG_REQ_TIME_STCNT	varchar(32)     NOT NULL,
        AVG_DB_TIME_MIN        	decimal(20,4)    NOT NULL, 
        AVG_DB_TIME_MAX        	decimal(20,4)    NOT NULL, 
	AVG_DB_TIME_STCNT	varchar(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST_TREND ADD CONSTRAINT PK_CFTEST_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE COLDFUSIONTEST_THRESH;
CREATE TABLE COLDFUSIONTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(64) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        PAGE_HIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        PAGE_HIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        DB_HIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        DB_HIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        BYTES_IN_RATE_MIN	VARCHAR(256)	    NOT NULL,
        BYTES_IN_RATE_MAX	VARCHAR(256)	    NOT NULL,
        BYTES_OUT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        BYTES_OUT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        REQUESTS_QUEUED_MIN	VARCHAR(256)	    NOT NULL,
        REQUESTS_QUEUED_MAX	VARCHAR(256)	    NOT NULL,
        REQUESTS_RUNNING_MIN	VARCHAR(256)	    NOT NULL,
        REQUESTS_RUNNING_MAX	VARCHAR(256)	    NOT NULL,
	REQ_TOUT_RATE_MIN	VARCHAR(256)	   	NOT NULL,
	REQ_TOUT_RATE_MAX	VARCHAR(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR(256)	   	NOT NULL,
        AVG_REQ_TIME_MIN	VARCHAR(256)	    NOT NULL,
        AVG_REQ_TIME_MAX	VARCHAR(256)	    NOT NULL,
        AVG_DB_TIME_MIN	VARCHAR(256)	    NOT NULL,
        AVG_DB_TIME_MAX	VARCHAR(256)	    NOT NULL
);

ALTER TABLE COLDFUSIONTEST_THRESH ADD CONSTRAINT PK_CFTEST_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_COLDFUSIONTEST_THRESH ON COLDFUSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE DISKTEST;
CREATE TABLE DISKTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	UTIL_PCT	decimal(20,4) 	NOT NULL,
	UTIL_PCT_ST	varchar(32)    NOT NULL,
	READ_RATE 	decimal(20,4) 	NOT NULL,
	READ_RATE_ST 	varchar(32)    NOT NULL,
	WRITE_RATE 	decimal(20,4) 	NOT NULL,
	WRITE_RATE_ST 	varchar(32)    NOT NULL,
	BYTES_READ_RATE 	decimal(20,4) 	NOT NULL,
	BYTES_READ_RATE_ST 	varchar(32)    NOT NULL,
	BYTES_WRITE_RATE 	decimal(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_ST 	varchar(32)    NOT NULL
);

ALTER TABLE DISKTEST ADD constraint PK_DISK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_DISKTEST ON DISKTEST
(
	 MSMT_TIME
);

DROP TABLE DISKTEST_TREND;

CREATE TABLE DISKTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	UTIL_PCT_MIN		decimal(20,4) 	NOT NULL,
	UTIL_PCT_MAX		decimal(20,4) 	NOT NULL,
	UTIL_PCT_STCNT		varchar(32)   	NOT NULL,
	READ_RATE_MIN 		decimal(20,4) 	NOT NULL,
	READ_RATE_MAX 		decimal(20,4) 	NOT NULL,
	READ_RATE_STCNT 	varchar(32)   	NOT NULL,
	WRITE_RATE_MIN 		decimal(20,4) 	NOT NULL,
	WRITE_RATE_MAX 		decimal(20,4) 	NOT NULL,
	WRITE_RATE_STCNT 	varchar(32)   	NOT NULL,
	BYTES_READ_RATE_MIN 		decimal(20,4) 	NOT NULL,
	BYTES_READ_RATE_MAX 		decimal(20,4) 	NOT NULL,
	BYTES_READ_RATE_STCNT 	varchar(32)   	NOT NULL,
	BYTES_WRITE_RATE_MIN 		decimal(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_MAX 		decimal(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_STCNT 	varchar(32)   	NOT NULL
);

ALTER TABLE DISKTEST_TREND ADD constraint PK_DISK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DISKTEST_THRESH;

CREATE TABLE DISKTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	UTIL_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	READ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	READ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	WRITE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	WRITE_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	BYTES_READ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	BYTES_READ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE DISKTEST_THRESH ADD constraint PK_DISK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DISKTEST_THRESH ON DISKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE DNSTEST;

CREATE TABLE DNSTEST 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO   	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	AVAILABLE 	decimal(3)  	NOT NULL,
	AVAILABLE_ST 	varchar(32)   	NOT NULL,
	RESP_TIME 	decimal(20,4) 	NOT NULL,
	RESP_TIME_ST	varchar(32) 	NOT NULL
);

alter table DNSTEST add constraint PK_DNS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DNSTEST ON DNSTEST
(
	 MSMT_TIME
);

DROP TABLE DNSTEST_TREND;

CREATE TABLE DNSTEST_TREND
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO   			varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD				varchar(32) NOT NULL,
	AVAILABLE_MIN 			decimal(20,4)  	NOT NULL,
	AVAILABLE_MAX 			decimal(20,4)  	NOT NULL,
	AVAILABLE_STCNT 		varchar(32)   	NOT NULL,
	RESP_TIME_MIN 			decimal(20,4) 	NOT NULL,
	RESP_TIME_MAX 			decimal(20,4) 	NOT NULL,
	RESP_TIME_STCNT			varchar(32) 	NOT NULL
);

alter table DNSTEST_TREND add constraint PK_DNS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DNSTEST_THRESH;

CREATE TABLE DNSTEST_THRESH
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO   	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL, 
	AVAILABLE_MIN	VARCHAR(256)	    NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	    NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	 NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	 NOT NULL
);

alter table DNSTEST_THRESH add constraint PK_DNS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DNSTEST_THRESH ON DNSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  



DROP TABLE EG_HELP_REF;

CREATE TABLE EG_HELP_REF 
(
        PAGE_REF      varchar(128) NOT NULL,
        ID            decimal
);

ALTER TABLE EG_HELP_REF ADD CONSTRAINT PK_EG_HELP_REF 
PRIMARY KEY (PAGE_REF) ;
DROP TABLE ERR_TBL;

CREATE TABLE ERR_TBL 
(
      TRGT_HOST            varchar(32) NOT NULL,
      PORT_NO              varchar(32) NOT NULL,
      SITE_NAME            varchar(64) NOT NULL,
      INFO                 varchar(128) NOT NULL,
      MSMT_TIME            datetime NOT NULL,
      TEST_NAME            varchar(128) NOT NULL,
      MSMT_NAME            varchar(128) NOT NULL,
      MSMT_HOST            varchar(32)  NOT NULL,
      STATE                varchar(32)  NOT NULL
);
      
alter table ERR_TBL add constraint PK_ERRTBLE
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO,TEST_NAME,MSMT_NAME,MSMT_HOST);
create index idx_err_tbl on err_tbl(site_name);

DROP TABLE FIXTABLE;

CREATE TABLE FIXTABLE 
(
        SITE_NAME            	varchar(64) NOT NULL,
        COMP_NAME            	varchar(64) NOT NULL,
        COMP_TYPE            	varchar(32) NOT NULL,
        INFO                 	varchar(128) NOT NULL,
        TEST_NAME           		varchar(64) NOT NULL,
        MEASURE            	varchar(64) NOT NULL,
	MSMT_TIME            	datetime NOT NULL,
	FIX_date            	datetime NOT NULL,
	PROB_REASON            	varchar(4000)    NOT NULL,
	PROB_FIX            	varchar(4000)    NOT NULL,
	PROB_FIXED_BY           varchar(600)    NOT NULL
);

ALTER TABLE FIXTABLE ADD CONSTRAINT PK_FIXTABLE 
PRIMARY KEY (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME) ;
create index idx_fixtable on fixtable (site_name);
DROP TABLE FTPTEST;

CREATE TABLE FTPTEST
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	AVAILABILITY			decimal(3)	      NOT NULL,
	AVAILABILITY_ST			varchar(32)	NOT NULL,
	TOT_RESPONSE_TIME 		decimal(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_ST 		varchar(32)	NOT NULL,
	TCP_AVAIL			decimal(3)		NOT NULL,
	TCP_AVAIL_ST			varchar(32)	NOT NULL,
	TCP_CONN_TIME			decimal(20,4)		NOT NULL,
	TCP_CONN_TIME_ST 		varchar(23)	NOT NULL,
	AUTHENTICATE_STATUS		decimal(3)		NOT NULL,
	AUTHENTICATE_STATUS_ST  	varchar(32)	NOT NULL,
	AUTHENTICATE_TIME		decimal(20,4)		NOT NULL,
	AUTHENTICATE_TIME_ST		varchar(32)	NOT NULL
);

ALTER TABLE FTPTEST ADD constraint PK_FTP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_FTPTEST ON FTPTEST
(
	 MSMT_TIME
);

DROP TABLE FTPTEST_TREND;

CREATE TABLE FTPTEST_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	AVAILABILITY_MIN		decimal(20,4)		NOT NULL,	
	AVAILABILITY_MAX		decimal(20,4)		NOT NULL,
	AVAILABILITY_STCNT		varchar(32)	NOT NULL,
	TOT_RESPONSE_TIME_MIN	decimal(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_MAX	decimal(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_STCNT	varchar(32)	NOT NULL,
	TCP_AVAIL_MIN		decimal(20,4)		NOT NULL,
	TCP_AVAIL_MAX		decimal(20,4)		NOT NULL,
	TCP_AVAIL_STCNT		varchar(32)	NOT NULL,
	TCP_CONN_TIME_MIN		decimal(20,4)		NOT NULL,
	TCP_CONN_TIME_MAX	decimal(20,4)		NOT NULL,
	TCP_CONN_TIME_STCNT		varchar(32)	NOT NULL,
	AUTHENTICATE_STATUS_MIN	decimal(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_MAX	decimal(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_STCNT varchar(32)    NOT NULL,
	AUTHENTICATE_TIME_MIN	decimal(20,4)		NOT NULL,
	AUTHENTICATE_TIME_MAX	decimal(20,4)		NOT NULL,
	AUTHENTICATE_TIME_STCNT varchar(32)	NOT NULL
);

ALTER TABLE FTPTEST_TREND ADD constraint PK_FTP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE FTPTEST_THRESH;

CREATE TABLE FTPTEST_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)			NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)			NOT NULL,
	TOT_RESPONSE_TIME_MIN	VARCHAR(256)			NOT NULL,
	TOT_RESPONSE_TIME_MAX	VARCHAR(256)			NOT NULL,
	TCP_AVAIL_MIN	VARCHAR(256)			NOT NULL,
	TCP_AVAIL_MAX	VARCHAR(256)			NOT NULL,
	TCP_CONN_TIME_MIN	VARCHAR(256)			NOT NULL,
	TCP_CONN_TIME_MAX	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_STATUS_MIN	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_STATUS_MAX	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_TIME_MIN	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_TIME_MAX	VARCHAR(256)			NOT NULL
);

ALTER TABLE FTPTEST_THRESH ADD constraint PK_FTP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_FTPTEST_THRESH ON FTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE HTTPTEST;
CREATE TABLE HTTPTEST 
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	AVAILABLE       	decimal(3)     	NOT NULL,
	AVAILABLE_ST       	varchar(32)     	NOT NULL,
	RESP_TIME       	decimal(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL  	decimal(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar(32)     	NOT NULL,
	TCP_CONN_TIME   	decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar(32)  	NOT NULL,
	SVR_RESP_TIME   	decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar(32)  	NOT NULL,
	CONTENT_VAL   		decimal(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar(32)  	NOT NULL,
	RESP_CODE   		decimal(3)  	NOT NULL,
	RESP_CODE_ST   		varchar(32)  	NOT NULL,
	CONTENT_LEN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar(32)  	NOT NULL,
	DATA_XFER_TIME   	decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar(32)  	NOT NULL,
	DNS_AVAILABILITY   	decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar(32)  	NOT NULL
);

alter table HTTPTEST add constraint PK_HTTP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_HTTPTEST ON HTTPTEST (MSMT_TIME) INCLUDE (AVAILABLE,RESP_TIME);

DROP TABLE HTTPTEST_TREND;
CREATE TABLE HTTPTEST_TREND
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME              		varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL, 
	AVAILABLE_MIN       		decimal(20,4)     	NOT NULL,
	AVAILABLE_MAX       		decimal(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar(32)    NOT NULL,
	RESP_TIME_MIN       		decimal(20,4)  	NOT NULL,
	RESP_TIME_MAX       		decimal(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		decimal(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		decimal(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_VAL_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar(32)  	NOT NULL,
	RESP_CODE_MIN  			decimal(20,4)  	NOT NULL,
	RESP_CODE_MAX  			decimal(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_LEN_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_MAX  		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT 	  	varchar(32)  	NOT NULL,
	DATA_XFER_TIME_MIN		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX  		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT 		varchar(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX  		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT 	  	varchar(32)  	NOT NULL
);

alter table HTTPTEST_TREND add constraint PK_HTTP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPTEST_THRESH;
CREATE TABLE HTTPTEST_THRESH
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START       	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABLE_MIN	VARCHAR(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
	CONTENT_VAL_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_VAL_MAX	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MIN	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MAX	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MAX	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MAX	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MAX	VARCHAR(256)	  	NOT NULL
	
);

alter table HTTPTEST_THRESH add constraint PK_HTTP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_HTTPTEST_THRESH ON HTTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE HTTPPOSTTEST;
CREATE TABLE HTTPPOSTTEST 
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	AVAILABLE       	decimal(3)     	NOT NULL,
	AVAILABLE_ST       	varchar(32)     	NOT NULL,
	RESP_TIME       	decimal(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL  	decimal(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar(32)     	NOT NULL,
	TCP_CONN_TIME   	decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar(32)  	NOT NULL,
	SVR_RESP_TIME   	decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar(32)  	NOT NULL,
	CONTENT_VAL   		decimal(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar(32)  	NOT NULL,
	RESP_CODE   		decimal(3)  	NOT NULL,
	RESP_CODE_ST   		varchar(32)  	NOT NULL,
	CONTENT_LEN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar(32)  	NOT NULL,
	DATA_XFER_TIME   	decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar(32)  	NOT NULL,
	DNS_AVAILABILITY   	decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar(32)  	NOT NULL
);

alter table HTTPPOSTTEST add constraint PK_HTTPPOST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_HTTPPOSTTEST ON HTTPPOSTTEST
(
	 MSMT_TIME
);

DROP TABLE HTTPPOSTTEST_TREND;
CREATE TABLE HTTPPOSTTEST_TREND
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME              		varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL, 
	AVAILABLE_MIN       		decimal(20,4)     	NOT NULL,
	AVAILABLE_MAX       		decimal(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar(32)    NOT NULL,
	RESP_TIME_MIN       		decimal(20,4)  	NOT NULL,
	RESP_TIME_MAX       		decimal(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		decimal(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		decimal(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_VAL_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar(32)  	NOT NULL,
	RESP_CODE_MIN  			decimal(20,4)  	NOT NULL,
	RESP_CODE_MAX  			decimal(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_LEN_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_MAX  		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT 	  	varchar(32)  	NOT NULL,
	DATA_XFER_TIME_MIN		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX  		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT 		varchar(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX  		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT 	  	varchar(32)  	NOT NULL
);

alter table HTTPPOSTTEST_TREND add constraint PK_HTTPPOST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPPOSTTEST_THRESH;

CREATE TABLE HTTPPOSTTEST_THRESH
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START       	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABLE_MIN	VARCHAR(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
	CONTENT_VAL_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_VAL_MAX	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MIN	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MAX	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MAX	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MAX	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MAX	VARCHAR(256)	  	NOT NULL
);

alter table HTTPPOSTTEST_THRESH add constraint PK_HTTPPOST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_HTTPPOSTTEST_THRESH ON HTTPPOSTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE LDAPTEST;
CREATE TABLE LDAPTEST
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	AVAILABLE       	decimal(3)     	NOT NULL,
	AVAILABLE_ST       	varchar(32)     	NOT NULL,
	RESP_TIME       	decimal(20,4)  	NOT NULL,
	RESP_TIME_ST       	varchar(32)  	NOT NULL,
	TCP_AVAIL       	decimal(3)  	NOT NULL,
	TCP_AVAIL_ST       	varchar(32)  	NOT NULL,
	CURR_CONN		decimal(20,4)    	NOT NULL,
	CURR_CONN_ST		varchar(32)    	NOT NULL,
	CONN_RATE 		decimal(20,4)  	NOT NULL,
	CONN_RATE_ST 		varchar(32)  	NOT NULL,
	BYTE_RATE_OUT   	decimal(20,4)  	NOT NULL,
	BYTE_RATE_OUT_ST   	varchar(32)  	NOT NULL,
	OUT_STND_OPNS		decimal(20,4)    	NOT NULL,
	OUT_STND_OPNS_ST	varchar(32)    	NOT NULL
);

alter table LDAPTEST add constraint PK_LDAP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_LDAPTEST ON LDAPTEST
(
	 MSMT_TIME
);

DROP TABLE LDAPTEST_TREND;

CREATE TABLE LDAPTEST_TREND
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 	
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL, 
	AVAILABLE_MIN       		decimal(20,4)     	NOT NULL,
	AVAILABLE_MAX       		decimal(20,4)     	NOT NULL,
	AVAILABLE_STCNT   		varchar(32)    NOT NULL,
	RESP_TIME_MIN       		decimal(20,4)  	NOT NULL,
	RESP_TIME_MAX       		decimal(20,4)  	NOT NULL,
	RESP_TIME_STCNT       		varchar(32)  	NOT NULL,
	TCP_AVAIL_MIN		       	decimal(20,4)  	NOT NULL,
	TCP_AVAIL_MAX			decimal(20,4)	NOT NULL,
	TCP_AVAIL_STCNT       		varchar(32)  	NOT NULL,
	CURR_CONN_MIN			decimal(20,4)    	NOT NULL,
	CURR_CONN_MAX			decimal(20,4)    	NOT NULL,
	CURR_CONN_STCNT			varchar(32)    NOT NULL,
	CONN_RATE_MIN	 		decimal(20,4)  	NOT NULL,
	CONN_RATE_MAX 			decimal(20,4)  	NOT NULL,
	CONN_RATE_STCNT 		varchar(32)  	NOT NULL,
	BYTE_RATE_OUT_MIN   		decimal(20,4)  	NOT NULL,
	BYTE_RATE_OUT_MAX   		decimal(20,4)  	NOT NULL,
	BYTE_RATE_OUT_STCNT   		varchar(32)  	NOT NULL,
	OUT_STND_OPNS_MIN		decimal(20,4)    	NOT NULL,
	OUT_STND_OPNS_MAX		decimal(20,4)    	NOT NULL,
	OUT_STND_OPNS_STCNT		varchar(32)    NOT NULL
);

alter table LDAPTEST_TREND add constraint PK_LDAP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDAPTEST_THRESH;

CREATE TABLE LDAPTEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABLE_MIN	VARCHAR(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
        TCP_AVAIL_MIN	VARCHAR(256)	  NOT NULL,
        TCP_AVAIL_MAX	VARCHAR(256)	  NOT NULL,
        CURR_CONN_MIN	VARCHAR(256)	    NOT NULL,
        CURR_CONN_MAX	VARCHAR(256)	    NOT NULL,
        CONN_RATE_MIN	VARCHAR(256)	  NOT NULL,
        CONN_RATE_MAX	VARCHAR(256)	  NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	  NOT NULL,
        BYTE_RATE_OUT_MAX	VARCHAR(256)	  NOT NULL,
        OUT_STND_OPNS_MIN	VARCHAR(256)	    NOT NULL,
        OUT_STND_OPNS_MAX	VARCHAR(256)	    NOT NULL
);

alter table LDAPTEST_THRESH add constraint PK_LDAP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDAPTEST_THRESH ON LDAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       
DROP TABLE LDREALSERVERTEST;

CREATE TABLE LDREALSERVERTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	STATE		decimal(20,4) 	NOT NULL,
	STATE_ST	varchar(32)    NOT NULL,
	CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	DATA_RATE 	decimal(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar(32)    NOT NULL
);

ALTER TABLE LDREALSERVERTEST ADD constraint PK_REAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_LDREALSERVERTEST ON LDREALSERVERTEST
(
	 MSMT_TIME
);


DROP TABLE LDREALSERVERTEST_TREND;

CREATE TABLE LDREALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	STATE_MIN		decimal(20,4) 	NOT NULL,
	STATE_MAX		decimal(20,4) 	NOT NULL,
	STATE_STCNT		varchar(32)   	NOT NULL,
	CONN_RATE_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar(32)   	NOT NULL,
	DATA_RATE_MIN 		decimal(20,4) 	NOT NULL,
	DATA_RATE_MAX 		decimal(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar(32)   	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_TREND ADD constraint PK_REAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDREALSERVERTEST_THRESH;

CREATE TABLE LDREALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	STATE_MIN	VARCHAR(256)	 	NOT NULL,
	STATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_THRESH ADD constraint PK_REAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDREALSERVERTEST_THRESH ON LDREALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE LDVIRTUALSERVERTEST;

CREATE TABLE LDVIRTUALSERVERTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	STATE		decimal(20,4) 	NOT NULL,
	STATE_ST	varchar(32)    NOT NULL,
	CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	DATA_RATE 	decimal(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar(32)    NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST ADD constraint PK_VIRTUAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_LDVIRTUALSERVERTEST ON LDVIRTUALSERVERTEST
(
	 MSMT_TIME
);


DROP TABLE LDVIRTUALSERVERTEST_TREND;

CREATE TABLE LDVIRTUALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	STATE_MIN		decimal(20,4) 	NOT NULL,
	STATE_MAX		decimal(20,4) 	NOT NULL,
	STATE_STCNT		varchar(32)   	NOT NULL,
	CONN_RATE_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar(32)   	NOT NULL,
	DATA_RATE_MIN 		decimal(20,4) 	NOT NULL,
	DATA_RATE_MAX 		decimal(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar(32)   	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_TREND ADD constraint PK_VIRTUAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDVIRTUALSERVERTEST_THRESH;

CREATE TABLE LDVIRTUALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	STATE_MIN	VARCHAR(256)	 	NOT NULL,
	STATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_THRESH ADD constraint PK_VIRTUAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDVIRTUALSERVERTEST_THRESH ON LDVIRTUALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);        
DROP TABLE MAILTEST;

CREATE TABLE MAILTEST 
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        SMTP_AVAIL           decimal(3)    NOT NULL,
        SMTP_AVAIL_ST        varchar(32)    NOT NULL,
        POP3_AVAIL           decimal(3)    NOT NULL,
        POP3_AVAIL_ST        varchar(32)    NOT NULL,
        OUT_MAIL             decimal(20,4)    NOT NULL,
        OUT_MAIL_ST          varchar(32)    NOT NULL,
        RT_DELAY             decimal(20,4)    NOT NULL,
        RT_DELAY_ST          varchar(32)    NOT NULL
);

alter table MAILTEST add constraint PK_MAILTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MAILTEST ON MAILTEST
(
	 MSMT_TIME
);

DROP TABLE MAILTEST_TREND;

CREATE TABLE MAILTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
        SMTP_AVAIL_MIN           	decimal(20,4)    NOT NULL,
        SMTP_AVAIL_MAX           	decimal(20,4)    NOT NULL,
        SMTP_AVAIL_STCNT        	varchar(32)    NOT NULL,
        POP3_AVAIL_MIN          	decimal(20,4)    NOT NULL,
        POP3_AVAIL_MAX           	decimal(20,4)    NOT NULL,
        POP3_AVAIL_STCNT        	varchar(32)    NOT NULL,
        OUT_MAIL_MIN                    decimal(20,4)    NOT NULL,
        OUT_MAIL_MAX             	decimal(20,4)    NOT NULL,
        OUT_MAIL_STCNT          	varchar(32)    NOT NULL,
        RT_DELAY_MIN              	decimal(20,4)    NOT NULL,
        RT_DELAY_MAX             	decimal(20,4)    NOT NULL,
        RT_DELAY_STCNT          	varchar(32)    NOT NULL
);


alter table MAILTEST_TREND add constraint PK_MAILTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MAILTEST_THRESH;

CREATE TABLE MAILTEST_THRESH 
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        SMTP_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
        SMTP_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
        POP3_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
        POP3_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
        OUT_MAIL_MIN	VARCHAR(256)	    NOT NULL,
        OUT_MAIL_MAX	VARCHAR(256)	    NOT NULL,
        RT_DELAY_MIN	VARCHAR(256)	    NOT NULL,
        RT_DELAY_MAX	VARCHAR(256)	    NOT NULL
);

alter table MAILTEST_THRESH add constraint PK_MAILTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MAILTEST_THRESH ON MAILTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE METATEST ;
CREATE TABLE METATEST 
(
        COMP_NAME          varchar(64) NOT NULL,
	COMP_TYPE		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST		varchar(64) NOT NULL,
        TEST_NAME               varchar(128) NOT NULL,
        MSMT_TIME 		datetime
);
 	
ALTER TABLE METATEST ADD CONSTRAINT PK_METATEST
PRIMARY KEY (COMP_NAME,COMP_TYPE,SITE_NAME,INFO,MSMT_HOST,TEST_NAME);

CREATE INDEX IDX_METATEST ON METATEST(SITE_NAME,INFO);  
CREATE NONCLUSTERED INDEX IDX1_METATEST ON METATEST ( TEST_NAME ) INCLUDE ( COMP_NAME, COMP_TYPE, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE MSMQTEST;

CREATE TABLE MSMQTEST
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	IN_MSG_RATE		decimal(20,4)	NOT NULL,	
	IN_MSG_RATE_ST		varchar(32)	NOT NULL,	
	OUT_MSG_RATE		decimal(20,4)	NOT NULL,
	OUT_MSG_RATE_ST		varchar(32)	NOT NULL,
	CURRENT_SESSIONS	decimal(20,4)	NOT NULL,
	CURRENT_SESSIONS_ST	varchar(32)	NOT NULL,
	ERROR_MSG_CNT		decimal(20,4)	NOT NULL,
	ERROR_MSG_CNT_ST	varchar(32)	NOT NULL,
	TOTAL_NO_MSGS		decimal(20,4)	NOT NULL,
	TOTAL_NO_MSGS_ST	varchar(32)	NOT NULL,
	GROWTH_RATE		decimal(20,4)	NOT NULL,
	GROWTH_RATE_ST		varchar(32)	NOT NULL,
	IP_SESSION	decimal(20,4)	NOT NULL,
	IP_SESSION_ST	varchar(32)	NOT NULL,
	IN_MULTICAST_SESSION	decimal(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_ST	VARCHAR(32)	NOT NULL,
	MSMQ_IN_MSG	decimal(20,4)	NOT NULL,
	MSMQ_IN_MSG_ST VARCHAR(32)	NOT NULL,
	MSMQ_OUT_MSG	decimal(20,4)	NOT NULL,
	MSMQ_OUT_MSG_ST	VARCHAR(32)	NOT NULL,
	OUT_HTTP_SESSION	decimal(20,4)	NOT NULL,
	OUT_HTTP_SESSION_ST	VARCHAR(32)	NOT NULL,
	OUT_MULTICAST_SESSION decimal(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_ST VARCHAR(32)	NOT NULL,
	TOT_BYTES	decimal(20,4)	NOT NULL,
	TOT_BYTES_ST VARCHAR(32)	NOT NULL
);

ALTER TABLE MSMQTEST ADD constraint PK_MSMQ
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MSMQTEST ON MSMQTEST
(
	 MSMT_TIME
);

DROP TABLE MSMQTEST_TREND;

CREATE TABLE MSMQTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	IN_MSG_RATE_MIN		decimal(20,4)	NOT NULL,	
	IN_MSG_RATE_MAX		decimal(20,4)	NOT NULL,	
	IN_MSG_RATE_STCNT	varchar(32)	NOT NULL,	
	OUT_MSG_RATE_MIN	decimal(20,4)	NOT NULL,
	OUT_MSG_RATE_MAX	decimal(20,4)	NOT NULL,
	OUT_MSG_RATE_STCNT	varchar(32)	NOT NULL,
	CURRENT_SESSIONS_MIN	decimal(20,4)	NOT NULL,
	CURRENT_SESSIONS_MAX	decimal(20,4)	NOT NULL,
	CURRENT_SESSIONS_STCNT	varchar(32)	NOT NULL,
	ERROR_MSG_CNT_MIN	decimal(20,4)	NOT NULL,
	ERROR_MSG_CNT_MAX	decimal(20,4)	NOT NULL,
	ERROR_MSG_CNT_STCNT	varchar(32)	NOT NULL,
	TOTAL_NO_MSGS_MIN	decimal(20,4)	NOT NULL,
	TOTAL_NO_MSGS_MAX	decimal(20,4)	NOT NULL,
	TOTAL_NO_MSGS_STCNT	varchar(32)	NOT NULL,
	GROWTH_RATE_MIN		decimal(20,4)	NOT NULL,
	GROWTH_RATE_MAX		decimal(20,4)	NOT NULL,
	GROWTH_RATE_STCNT	varchar(32)	NOT NULL,
	IP_SESSION_MIN	decimal(20,4)	NOT NULL,
	IP_SESSION_MAX	decimal(20,4)	NOT NULL,
	IP_SESSION_STCNT	varchar(32)	NOT NULL,
	IN_MULTICAST_SESSION_MIN	decimal(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_MAX	decimal(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_STCNT	VARCHAR(32)	NOT NULL,
	MSMQ_IN_MSG_MIN	decimal(20,4)	NOT NULL,
	MSMQ_IN_MSG_MAX	decimal(20,4)	NOT NULL,
	MSMQ_IN_MSG_STCNT VARCHAR(32)	NOT NULL,
	MSMQ_OUT_MSG_MIN	decimal(20,4)	NOT NULL,
	MSMQ_OUT_MSG_MAX	decimal(20,4)	NOT NULL,
	MSMQ_OUT_MSG_STCNT	VARCHAR(32)	NOT NULL,
	OUT_HTTP_SESSION_MIN	decimal(20,4)	NOT NULL,
	OUT_HTTP_SESSION_MAX	decimal(20,4)	NOT NULL,
	OUT_HTTP_SESSION_STCNT	VARCHAR(32)	NOT NULL,
	OUT_MULTICAST_SESSION_MIN decimal(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_MAX decimal(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_STCNT VARCHAR(32)	NOT NULL,
	TOT_BYTES_MIN	decimal(20,4)	NOT NULL,
	TOT_BYTES_MAX	decimal(20,4)	NOT NULL,
	TOT_BYTES_STCNT VARCHAR(32)	NOT NULL
);

ALTER TABLE MSMQTEST_TREND ADD constraint PK_MSMQ_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSMQTEST_THRESH;

CREATE TABLE MSMQTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME        	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
      	MSMT_TIME_END   	datetime NOT NULL,
	IN_MSG_RATE_MIN	VARCHAR(256)		NOT NULL,
	IN_MSG_RATE_MAX	VARCHAR(256)		NOT NULL,
	OUT_MSG_RATE_MIN	VARCHAR(256)		NOT NULL,
	OUT_MSG_RATE_MAX	VARCHAR(256)		NOT NULL,
	CURRENT_SESSIONS_MIN	VARCHAR(256)		NOT NULL,
	CURRENT_SESSIONS_MAX	VARCHAR(256)		NOT NULL,
	ERROR_MSG_CNT_MIN	VARCHAR(256)		NOT NULL,
	ERROR_MSG_CNT_MAX	VARCHAR(256)		NOT NULL,
	TOTAL_NO_MSGS_MIN	VARCHAR(256)		NOT NULL,
	TOTAL_NO_MSGS_MAX	VARCHAR(256)		NOT NULL,
	GROWTH_RATE_MIN	VARCHAR(256)		NOT NULL,
	GROWTH_RATE_MAX	VARCHAR(256)		NOT NULL,
	IP_SESSION_MIN	VARCHAR(256)		NOT NULL,
	IP_SESSION_MAX	VARCHAR(256)		NOT NULL,
	IN_MULTICAST_SESSION_MIN	VARCHAR(256)		NOT NULL,
	IN_MULTICAST_SESSION_MAX	VARCHAR(256)		NOT NULL,
	MSMQ_IN_MSG_MIN	VARCHAR(256)		NOT NULL,
	MSMQ_IN_MSG_MAX	VARCHAR(256)		NOT NULL,
	MSMQ_OUT_MSG_MIN	VARCHAR(256)		NOT NULL,
	MSMQ_OUT_MSG_MAX	VARCHAR(256)		NOT NULL,
	OUT_HTTP_SESSION_MIN	VARCHAR(256)		NOT NULL,
	OUT_HTTP_SESSION_MAX	VARCHAR(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MIN VARCHAR(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MAX VARCHAR(256)		NOT NULL,
	TOT_BYTES_MIN	VARCHAR(256)		NOT NULL,
	TOT_BYTES_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE MSMQTEST_THRESH ADD constraint PK_MSMQ_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSMQTEST_THRESH ON MSMQTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);                  
DROP TABLE MSSQLBUFFERTEST;

CREATE TABLE MSSQLBUFFERTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	BUFFER_CHEHIT_RT	decimal(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_ST	varchar(32)    NOT NULL,
	PAGE_RD			decimal(20,4)    NOT NULL,	
	PAGE_RD_ST		varchar(32)    NOT NULL,
	PAGE_WRT_RT		decimal(20,4)    NOT NULL,	
	PAGE_WRT_RT_ST		varchar(32)    NOT NULL,
	CACHE_HTRT		decimal(20,4)    NOT NULL,	
	CACHE_HTRT_ST		varchar(32)    NOT NULL,
	CACHE_OBJCT		decimal(20,4)    NOT NULL,	
	CACHE_OBJCT_ST		varchar(32)    NOT NULL,
	LOG_CACHITRT		decimal(20,4)    NOT NULL,	
	LOG_CACHITRT_ST		varchar(32)    NOT NULL
	);
												
alter table MSSQLBUFFERTEST add constraint PK_MSSQLBUFFERTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MSSQLBUFFERTEST ON MSSQLBUFFERTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLBUFFERTEST_TREND;

CREATE TABLE MSSQLBUFFERTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	BUFFER_CHEHIT_RT_MIN	decimal(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_MAX	decimal(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_STCNT	varchar(32)    NOT NULL,
	PAGE_RD_MIN		decimal(20,4)    NOT NULL,	
	PAGE_RD_MAX		decimal(20,4)    NOT NULL,	
	PAGE_RD_STCNT		varchar(32)    NOT NULL,
	PAGE_WRT_RT_MIN		decimal(20,4)    NOT NULL,	
	PAGE_WRT_RT_MAX		decimal(20,4)    NOT NULL,	
	PAGE_WRT_RT_STCNT	varchar(32)    NOT NULL,
	CACHE_HTRT_MIN		decimal(20,4)    NOT NULL,	
	CACHE_HTRT_MAX		decimal(20,4)    NOT NULL,	
	CACHE_HTRT_STCNT	varchar(32)    NOT NULL,
	CACHE_OBJCT_MIN		decimal(20,4)    NOT NULL,	
	CACHE_OBJCT_MAX		decimal(20,4)    NOT NULL,	
	CACHE_OBJCT_STCNT	varchar(32)    NOT NULL,
	LOG_CACHITRT_MIN	decimal(20,4)    NOT NULL,	
	LOG_CACHITRT_MAX	decimal(20,4)    NOT NULL,	
	LOG_CACHITRT_STCNT	varchar(32)    NOT NULL
);

alter table MSSQLBUFFERTEST_TREND add constraint PK_MSSQLBUFFERTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLBUFFERTEST_THRESH;

CREATE TABLE MSSQLBUFFERTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        BUFFER_CHEHIT_RT_MIN	VARCHAR(256)	    NOT NULL,
	BUFFER_CHEHIT_RT_MAX	VARCHAR(256)	    NOT NULL,
	PAGE_RD_MIN	VARCHAR(256)	    NOT NULL,
	PAGE_RD_MAX	VARCHAR(256)	    NOT NULL,
	PAGE_WRT_RT_MIN	VARCHAR(256)	    NOT NULL,
	PAGE_WRT_RT_MAX	VARCHAR(256)	    NOT NULL,
	CACHE_HTRT_MIN	VARCHAR(256)	    NOT NULL,
	CACHE_HTRT_MAX	VARCHAR(256)	    NOT NULL,
	CACHE_OBJCT_MIN	VARCHAR(256)	    NOT NULL,
	CACHE_OBJCT_MAX	VARCHAR(256)	    NOT NULL,
	LOG_CACHITRT_MIN	VARCHAR(256)	    NOT NULL,
	LOG_CACHITRT_MAX	VARCHAR(256)	    NOT NULL
	);

alter table MSSQLBUFFERTEST_THRESH add constraint PK_MSSQLBUFFERTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MSSQLBUFFERTEST_THRESH ON MSSQLBUFFERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE MSSQLLOCKTEST;
CREATE TABLE MSSQLLOCKTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	AVG_WTTIME		decimal(20,4) NOT NULL,	
	AVG_WTTIME_ST		varchar(32) NOT NULL,
	LOCK_REQ		decimal(20,4) NOT NULL,	
	LOCK_REQ_ST		varchar(32) NOT NULL,
	LOCK_WAIT		decimal(20,4) NOT NULL,	
	LOCK_WAIT_ST		varchar(32) NOT NULL,
	NUM_DEADLOCK		decimal(20,4) NOT NULL,	
	NUM_DEADLOCK_ST		varchar(32) NOT NULL,
	LOCK_TIMEOUTS		decimal(20,4) NOT NULL,	
	LOCK_TIMEOUTS_ST	varchar(32) NOT NULL	);

alter table MSSQLLOCKTEST add constraint PK_MSSQLLOCKTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MSSQLLOCKTEST ON MSSQLLOCKTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLLOCKTEST_TREND;

CREATE TABLE MSSQLLOCKTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	AVG_WTTIME_MIN			decimal(20,4) NOT NULL,
	AVG_WTTIME_MAX			decimal(20,4) NOT NULL,
	AVG_WTTIME_STCNT		varchar(32) NOT NULL,
	LOCK_REQ_MIN			decimal(20,4) NOT NULL,
	LOCK_REQ_MAX			decimal(20,4) NOT NULL,
	LOCK_REQ_STCNT			varchar(32) NOT NULL,
	LOCK_WAIT_MIN			decimal(20,4) NOT NULL,
	LOCK_WAIT_MAX			decimal(20,4) NOT NULL,
	LOCK_WAIT_STCNT			varchar(32) NOT NULL,
	NUM_DEADLOCK_MIN		decimal(20,4) NOT NULL,
	NUM_DEADLOCK_MAX		decimal(20,4) NOT NULL,
	NUM_DEADLOCK_STCNT		varchar(32) NOT NULL,
	LOCK_TIMEOUTS_MIN		decimal(20,4) NOT NULL,
	LOCK_TIMEOUTS_MAX		decimal(20,4) NOT NULL,
	LOCK_TIMEOUTS_STCNT		varchar(32) NOT NULL);


alter table MSSQLLOCKTEST_TREND add constraint PK_MSSQLLOCKTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLLOCKTEST_THRESH;
CREATE TABLE MSSQLLOCKTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        AVG_WTTIME_MIN			VARCHAR(256) NOT NULL,
	AVG_WTTIME_MAX			VARCHAR(256) NOT NULL,
	LOCK_REQ_MIN			VARCHAR(256) NOT NULL,
	LOCK_REQ_MAX			VARCHAR(256) NOT NULL,
	LOCK_WAIT_MIN			VARCHAR(256) NOT NULL,
	LOCK_WAIT_MAX			VARCHAR(256) NOT NULL,
	NUM_DEADLOCK_MIN		VARCHAR(256) NOT NULL,
	NUM_DEADLOCK_MAX		VARCHAR(256) NOT NULL,
	LOCK_TIMEOUTS_MIN		VARCHAR(256) NOT NULL,
	LOCK_TIMEOUTS_MAX		VARCHAR(256) NOT NULL);

alter table MSSQLLOCKTEST_THRESH add constraint PK_MSSQLLOCKTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLLOCKTEST_THRESH ON MSSQLLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MSSQLMEMORYTEST;
CREATE TABLE MSSQLMEMORYTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	TOT_SERVMEM			decimal(20,4)    NOT NULL,	
	TOT_SERVMEM_ST			varchar(32)    NOT NULL,
	TGT_SERVMEM			decimal(20,4)    NOT NULL,	
	TGT_SERVMEM_ST			varchar(32)    NOT NULL,
	SQL_CACHEMEM			decimal(20,4)    NOT NULL,	
	SQL_CACHEMEM_ST			varchar(32)    NOT NULL,
	OPTZ_MEM			decimal(20,4)    NOT NULL,	
	OPTZ_MEM_ST			varchar(32)    NOT NULL,
	MAX_WORKSPMEM			decimal(20,4)    NOT NULL,	
	MAX_WORKSPMEM_ST		varchar(32)    NOT NULL,
	LOCK_MEM			decimal(20,4)    NOT NULL,	
	LOCK_MEM_ST			varchar(32)    NOT NULL,
	GRANT_WKSPACEMEM		decimal(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_ST		varchar(32)    NOT NULL,
	CONNEC_MEM			decimal(20,4)    NOT NULL,	
	CONNEC_MEM_ST			varchar(32)    NOT NULL,
	MEMORY_GRANTS_PENDING		decimal(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_ST	varchar(32)    NOT NULL
	);

ALTER TABLE MSSQLMEMORYTEST add constraint PK_MSSQLMEMORYTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MSSQLMEMORYTEST ON MSSQLMEMORYTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLMEMORYTEST_TREND;

CREATE TABLE MSSQLMEMORYTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	TOT_SERVMEM_MIN			decimal(20,4)    NOT NULL,	
	TOT_SERVMEM_MAX			decimal(20,4)    NOT NULL,	
	TOT_SERVMEM_STCNT		varchar(32)    NOT NULL,
	TGT_SERVMEM_MIN			decimal(20,4)    NOT NULL,	
	TGT_SERVMEM_MAX			decimal(20,4)    NOT NULL,	
	TGT_SERVMEM_STCNT		varchar(32)    NOT NULL,
	SQL_CACHEMEM_MIN		decimal(20,4)    NOT NULL,	
	SQL_CACHEMEM_MAX		decimal(20,4)    NOT NULL,	
	SQL_CACHEMEM_STCNT		varchar(32)    NOT NULL,
	OPTZ_MEM_MIN			decimal(20,4)    NOT NULL,	
	OPTZ_MEM_MAX			decimal(20,4)    NOT NULL,	
	OPTZ_MEM_STCNT			varchar(32)    NOT NULL,
	MAX_WORKSPMEM_MIN		decimal(20,4)    NOT NULL,	
	MAX_WORKSPMEM_MAX		decimal(20,4)    NOT NULL,	
	MAX_WORKSPMEM_STCNT		varchar(32)    NOT NULL,
	LOCK_MEM_MIN			decimal(20,4)    NOT NULL,	
	LOCK_MEM_MAX			decimal(20,4)    NOT NULL,	
	LOCK_MEM_STCNT			varchar(32)    NOT NULL,
	GRANT_WKSPACEMEM_MIN		decimal(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_MAX		decimal(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_STCNT		varchar(32)    NOT NULL,
	CONNEC_MEM_MIN			decimal(20,4)    NOT NULL,	
	CONNEC_MEM_MAX			decimal(20,4)    NOT NULL,	
	CONNEC_MEM_STCNT		varchar(32)    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	decimal(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_MAX	decimal(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_STCNT	varchar(32)    NOT NULL
);


ALTER TABLE MSSQLMEMORYTEST_TREND add constraint PK_MSSQLMEMORYTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLMEMORYTEST_THRESH;

CREATE TABLE MSSQLMEMORYTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL,         
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        TOT_SERVMEM_MIN			VARCHAR(256)	    NOT NULL,
	TOT_SERVMEM_MAX			VARCHAR(256)	    NOT NULL,
	TGT_SERVMEM_MIN			VARCHAR(256)	    NOT NULL,
	TGT_SERVMEM_MAX			VARCHAR(256)	    NOT NULL,
	SQL_CACHEMEM_MIN		VARCHAR(256)	    NOT NULL,
	SQL_CACHEMEM_MAX		VARCHAR(256)	    NOT NULL,
	OPTZ_MEM_MIN			VARCHAR(256)	    NOT NULL,
	OPTZ_MEM_MAX			VARCHAR(256)	    NOT NULL,
	MAX_WORKSPMEM_MIN		VARCHAR(256)	    NOT NULL,
	MAX_WORKSPMEM_MAX		VARCHAR(256)	    NOT NULL,
	LOCK_MEM_MIN			VARCHAR(256)	    NOT NULL,
	LOCK_MEM_MAX			VARCHAR(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MIN		VARCHAR(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MAX		VARCHAR(256)	    NOT NULL,
	CONNEC_MEM_MIN			VARCHAR(256)	    NOT NULL,
	CONNEC_MEM_MAX			VARCHAR(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	VARCHAR(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MAX	VARCHAR(256)	    NOT NULL
	);

ALTER TABLE MSSQLMEMORYTEST_THRESH add constraint PK_MSSQLMEMORYTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLMEMORYTEST_THRESH ON MSSQLMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MSSQLSESSIONTEST;
CREATE TABLE MSSQLSESSIONTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	LOGIN_COUNTER		decimal(20,4)    NOT NULL,
	LOGIN_COUNTER_ST	varchar(32)    NOT NULL,
	LOGOUT_COUNTER		decimal(20,4)    NOT NULL,
	LOGOUT_COUNTER_ST	varchar(32)    NOT NULL,	
	USER_CONNECTION		decimal(20,4)     NOT NULL,
	USER_CONNECTION_ST	varchar(32)    NOT NULL,
	LOGICAL_CONNECTIONS	decimal(20,4)     NOT NULL,
	LOGICAL_CONNECTIONS_ST	varchar(32)    NOT NULL
	);

ALTER TABLE MSSQLSESSIONTEST add constraint PK_MSSQLSESSIONTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_MSSQLSESSIONTEST ON MSSQLSESSIONTEST (MSMT_TIME) INCLUDE (USER_CONNECTION);

DROP TABLE MSSQLSESSIONTEST_TREND;

CREATE TABLE MSSQLSESSIONTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	LOGIN_COUNTER_MIN		decimal(20,4)    NOT NULL,
	LOGIN_COUNTER_MAX		decimal(20,4)    NOT NULL,
	LOGIN_COUNTER_STCNT		varchar(32)    NOT NULL,
	LOGOUT_COUNTER_MIN		decimal(20,4)    NOT NULL,
	LOGOUT_COUNTER_MAX		decimal(20,4)    NOT NULL,
	LOGOUT_COUNTER_STCNT		varchar(32)    NOT NULL,
	USER_CONNECTION_MIN		decimal(20,4)    NOT NULL,
	USER_CONNECTION_MAX		decimal(20,4)    NOT NULL,
	USER_CONNECTION_STCNT		varchar(32)    NOT NULL,
	LOGICAL_CONNECTIONS_MIN		decimal(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_MAX		decimal(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_STCNT	varchar(32)    NOT NULL
);
ALTER TABLE MSSQLSESSIONTEST_TREND add constraint PK_MSSQLSESSIONTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLSESSIONTEST_THRESH;
CREATE TABLE MSSQLSESSIONTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        LOGIN_COUNTER_MIN		VARCHAR(256)	    NOT NULL,
	LOGIN_COUNTER_MAX		VARCHAR(256)	    NOT NULL,
	LOGOUT_COUNTER_MIN		VARCHAR(256)	    NOT NULL,
	LOGOUT_COUNTER_MAX		VARCHAR(256)	    NOT NULL,
	USER_CONNECTION_MIN		VARCHAR(256)	    NOT NULL,
	USER_CONNECTION_MAX		VARCHAR(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MIN		VARCHAR(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MAX		VARCHAR(256)	    NOT NULL
);

ALTER TABLE MSSQLSESSIONTEST_THRESH add constraint PK_MSSQLSESSIONTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLSESSIONTEST_THRESH ON MSSQLSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE MSSQLTRANSACTIONTEST;
CREATE TABLE MSSQLTRANSACTIONTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	ACTIVE_TRAN		decimal(20,4)    NOT NULL,	
	ACTIVE_TRAN_ST		varchar(32)    NOT NULL,
	LOG_FLUSHWT		decimal(20,4)    NOT NULL,	
	LOG_FLUSHWT_ST		varchar(32)    NOT NULL,
	REPL_PNDXACTS		decimal(20,4)    NOT NULL,	
	REPL_PNDXACTS_ST	varchar(32)    NOT NULL,
	REPL_TRANRT		decimal(20,4)    NOT NULL,	
	REPL_TRANRT_ST		varchar(32)    NOT NULL,
	NUM_TRANSACT		decimal(20,4)    NOT NULL,	
	NUM_TRANSACT_ST		varchar(32)    NOT NULL
	);

alter table MSSQLTRANSACTIONTEST add constraint PK_MSSQLTRANSACTIONTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MSSQLTRANSACTIONTEST ON MSSQLTRANSACTIONTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLTRANSACTIONTEST_TREND;

CREATE TABLE MSSQLTRANSACTIONTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	
	ACTIVE_TRAN_MIN		decimal(20,4)    NOT NULL,	
	ACTIVE_TRAN_MAX		decimal(20,4)    NOT NULL,	
	ACTIVE_TRAN_STCNT	varchar(32)    NOT NULL,
	LOG_FLUSHWT_MIN		decimal(20,4)    NOT NULL,	
	LOG_FLUSHWT_MAX		decimal(20,4)    NOT NULL,	
	LOG_FLUSHWT_STCNT	varchar(32)    NOT NULL,
	REPL_PNDXACTS_MIN	decimal(20,4)    NOT NULL,	
	REPL_PNDXACTS_MAX	decimal(20,4)    NOT NULL,	
	REPL_PNDXACTS_STCNT	varchar(32)    NOT NULL,
	REPL_TRANRT_MIN		decimal(20,4)    NOT NULL,	
	REPL_TRANRT_MAX		decimal(20,4)    NOT NULL,	
	REPL_TRANRT_STCNT	varchar(32)    NOT NULL,
	NUM_TRANSACT_MIN	decimal(20,4)    NOT NULL,	
	NUM_TRANSACT_MAX	decimal(20,4)    NOT NULL,	
	NUM_TRANSACT_STCNT	varchar(32)    NOT NULL
	);


alter table MSSQLTRANSACTIONTEST_TREND add constraint PK_MSSQLTRANSACTIONTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLTRANSACTIONTEST_THRESH;

CREATE TABLE MSSQLTRANSACTIONTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        ACTIVE_TRAN_MIN	VARCHAR(256)	    NOT NULL,
	ACTIVE_TRAN_MAX	VARCHAR(256)	    NOT NULL,
	LOG_FLUSHWT_MIN	VARCHAR(256)	    NOT NULL,
	LOG_FLUSHWT_MAX	VARCHAR(256)	    NOT NULL,
	REPL_PNDXACTS_MIN	VARCHAR(256)	    NOT NULL,
	REPL_PNDXACTS_MAX	VARCHAR(256)	    NOT NULL,
	REPL_TRANRT_MIN	VARCHAR(256)	    NOT NULL,
	REPL_TRANRT_MAX	VARCHAR(256)	    NOT NULL,
	NUM_TRANSACT_MIN	VARCHAR(256)	    NOT NULL,
	NUM_TRANSACT_MAX	VARCHAR(256)	    NOT NULL

	);

alter table MSSQLTRANSACTIONTEST_THRESH add constraint PK_MSSQLTRANSACTIONTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSSQLTRANSTEST_THRESH ON MSSQLTRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   
DROP TABLE MTSPROCESSTEST;

CREATE TABLE MTSPROCESSTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	NUM_PROC	decimal(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar(32)    NOT NULL,
	CPU_UTIL 	decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar(32)    NOT NULL,
	MEM_UTIL 	decimal(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar(32)    NOT NULL
);

ALTER TABLE MTSPROCESSTEST ADD constraint PK_MTSPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  NONCLUSTERED INDEX IDX_MTSPROCESSTEST ON MTSPROCESSTEST (MSMT_TIME) INCLUDE (NUM_PROC);

DROP TABLE MTSPROCESSTEST_TREND;

CREATE TABLE MTSPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	NUM_PROC_MIN		decimal(20,4) 	NOT NULL,
	NUM_PROC_MAX		decimal(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar(32)   	NOT NULL,
	CPU_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar(32)   	NOT NULL,
	MEM_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar(32)   	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_TREND ADD constraint PK_MTSPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSPROCESSTEST_THRESH;

CREATE TABLE MTSPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	NUM_PROC_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_THRESH ADD constraint PK_MTSPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MTSPROCESSTEST_THRESH ON MTSPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE MTSTEST;

CREATE TABLE MTSTEST
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	TOTAL_PACKAGES_COUNT		decimal(4)	NOT NULL, 	
	TOTAL_PACKAGES_COUNT_ST		varchar(32)	NOT NULL,
	TOTAL_COMPONENTS_COUNT		decimal(6)	NOT NULL,
	TOTAL_COMPONENTS_COUNT_ST	varchar(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT	decimal(4)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_ST 	varchar(32)	NOT NULL
);

ALTER TABLE MTSTEST ADD constraint PK_MTS	
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MTSTEST ON MTSTEST
(
	 MSMT_TIME
);

DROP TABLE MTSTEST_TREND;

CREATE TABLE MTSTEST_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	TOTAL_PACKAGES_COUNT_MIN	decimal(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_MAX	decimal(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_STCNT	varchar(32)	NOT NULL, 	
	TOTAL_COMPONENTS_COUNT_MIN	decimal(6)		NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	decimal(6)		NOT NULL,	
	TOTAL_COMPONENTS_COUNT_STCNT	varchar(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	decimal(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	decimal(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_STCNT	varchar(32)	NOT NULL
);

ALTER TABLE MTSTEST_TREND ADD constraint PK_MTS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSTEST_THRESH;

CREATE TABLE MTSTEST_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
	TOTAL_PACKAGES_COUNT_MIN	VARCHAR(256)			NOT NULL,
	TOTAL_PACKAGES_COUNT_MAX	VARCHAR(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MIN	VARCHAR(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	VARCHAR(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	VARCHAR(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	VARCHAR(256)			NOT NULL
);

ALTER TABLE MTSTEST_THRESH ADD constraint PK_MTS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MTSTEST_THRESH ON MTSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE NASSNMPTEST ;

CREATE TABLE NASSNMPTEST 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                         varchar(32) NOT NULL,
        SITE_NAME                       varchar(64) NOT NULL,
        INFO                            varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	REQ_RATE 			decimal(20,4)	NOT NULL,
	REQ_RATE_ST 			varchar(32)		NOT NULL,
	RESP_TIME 			decimal(20,4)	NOT NULL,
	RESP_TIME_ST 			varchar(32)		NOT NULL,
	PCT_ACTIVE_THREADS		decimal(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_ST		varchar(32)		NOT NULL,
	DATA_RATE_OUT 			decimal(20,4)	NOT NULL,
	DATA_RATE_OUT_ST 		varchar(32)		NOT NULL,
	DATA_RATE_IN 			decimal(20,4)	NOT NULL,
	DATA_RATE_IN_ST 		varchar(32)		NOT NULL
);

ALTER TABLE NASSNMPTEST ADD CONSTRAINT PK_NAS_SNMP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NASSNMPTEST ON NASSNMPTEST
(
	 MSMT_TIME
);

DROP TABLE NASSNMPTEST_TREND;

CREATE TABLE NASSNMPTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                         varchar(32) NOT NULL,
        SITE_NAME                       varchar(64) NOT NULL,
        INFO                            varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
	REQ_RATE_MIN 			decimal(20,4)	NOT NULL,
	REQ_RATE_MAX 			decimal(20,4)	NOT NULL,
	REQ_RATE_STCNT		 	varchar(32)	NOT NULL,
	RESP_TIME_MIN 			decimal(20,4)	NOT NULL,
	RESP_TIME_MAX 			decimal(20,4)	NOT NULL,
	RESP_TIME_STCNT 		varchar(32)	NOT NULL,
	PCT_ACTIVE_THREADS_MIN		decimal(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_MAX		decimal(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_STCNT 	varchar(32)	NOT NULL,
	DATA_RATE_OUT_MIN 		decimal(20,4)	NOT NULL,
	DATA_RATE_OUT_MAX 		decimal(20,4)	NOT NULL,
	DATA_RATE_OUT_STCNT 		varchar(32)	NOT NULL,
	DATA_RATE_IN_MIN 		decimal(20,4)	NOT NULL,
	DATA_RATE_IN_MAX 		decimal(20,4)	NOT NULL,
	DATA_RATE_IN_STCNT 		varchar(32)	NOT NULL
);

ALTER TABLE NASSNMPTEST_TREND ADD CONSTRAINT PK_NAS_SNMP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE NASSNMPTEST_THRESH;

CREATE TABLE NASSNMPTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
	REQ_RATE_MIN	VARCHAR(256)		NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)		NOT NULL,
	RESP_TIME_MIN	VARCHAR(256)		NOT NULL,
	RESP_TIME_MAX	VARCHAR(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MIN	VARCHAR(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MAX	VARCHAR(256)		NOT NULL,
	DATA_RATE_OUT_MIN	VARCHAR(256)		NOT NULL,
	DATA_RATE_OUT_MAX	VARCHAR(256)		NOT NULL,
	DATA_RATE_IN_MIN	VARCHAR(256)		NOT NULL,
	DATA_RATE_IN_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE NASSNMPTEST_THRESH ADD CONSTRAINT PK_NAS_SNMP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NASSNMPTEST_THRESH ON NASSNMPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE NETWORKBANDWIDTHTEST;

CREATE TABLE NETWORKBANDWIDTHTEST 
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        RCVD_RATE           	decimal(20,4)    NOT NULL,
        RCVD_RATE_ST        varchar(32)    NOT NULL,
        XMIT_RATE           decimal(20,4)    NOT NULL,
        XMIT_RATE_ST        varchar(32)    NOT NULL,
        PCT_BANDW             decimal(20,4)    NOT NULL,
        PCT_BANDW_ST          varchar(32)    NOT NULL
);

alter table NETWORKBANDWIDTHTEST add constraint PK_NETWORKBANDWIDTHTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NETWORKBANDWIDTHTEST ON NETWORKBANDWIDTHTEST
(
	 MSMT_TIME
);

DROP TABLE NETWORKBANDWIDTHTEST_TREND;

CREATE TABLE NETWORKBANDWIDTHTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
        RCVD_RATE_MIN           	decimal(20,4)    NOT NULL,
        RCVD_RATE_MAX           	decimal(20,4)    NOT NULL,
        RCVD_RATE_STCNT        	varchar(32)    NOT NULL,
        XMIT_RATE_MIN          	decimal(20,4)    NOT NULL,
        XMIT_RATE_MAX           	decimal(20,4)    NOT NULL,
        XMIT_RATE_STCNT        	varchar(32)    NOT NULL,
        PCT_BANDW_MIN                    decimal(20,4)    NOT NULL,
        PCT_BANDW_MAX             	decimal(20,4)    NOT NULL,
        PCT_BANDW_STCNT          	varchar(32)    NOT NULL
);


alter table NETWORKBANDWIDTHTEST_TREND add constraint PK_NETWORKBANDWIDTHTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKBANDWIDTHTEST_THRESH;

CREATE TABLE NETWORKBANDWIDTHTEST_THRESH 
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        RCVD_RATE_MIN	VARCHAR(256)	    NOT NULL,
        RCVD_RATE_MAX	VARCHAR(256)	    NOT NULL,
        XMIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        XMIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        PCT_BANDW_MIN	VARCHAR(256)	    NOT NULL,
        PCT_BANDW_MAX	VARCHAR(256)	    NOT NULL
);

alter table NETWORKBANDWIDTHTEST_THRESH add constraint PK_NETWORKBANDWIDTHTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETBANDWIDTHTEST_THRESH ON NETWORKBANDWIDTHTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE NETWORKTEST;

CREATE TABLE NETWORKTEST 
(
	TRGT_HOST            varchar(32) NOT NULL,
    PORT_NO              varchar(32) NOT NULL,
    SITE_NAME            varchar(64) NOT NULL,
    INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
    MSMT_TIME            datetime NOT NULL,
	AVG_RND_TRIP	     decimal(20,4)    NOT NULL,
	AVG_RND_TRIP_ST      varchar(32)      NOT NULL,
	MIN_RND_TRIP	     decimal(20,4)    NOT NULL,
	MIN_RND_TRIP_ST	     varchar(32)      NOT NULL,
	PKT_LOSS_PCT	     decimal(20,4)     NOT NULL,
	PKT_LOSS_PCT_ST	     varchar(32)      NOT NULL,
	AVAILABILITY			decimal(3)	  NOT NULL,
	AVAILABILITY_ST			varchar(32)   NOT NULL
);

alter table NETWORKTEST add constraint PK_NETWORK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_NETWORKTEST ON NETWORKTEST (MSMT_TIME) INCLUDE (TRGT_HOST, PORT_NO, INFO, MSMT_HOST, PKT_LOSS_PCT,AVAILABILITY,AVG_RND_TRIP);

DROP TABLE NETWORKTEST_TREND;

CREATE TABLE NETWORKTEST_TREND 
(
	TRGT_HOST            		varchar(32) NOT NULL,
    PORT_NO              		varchar(32) NOT NULL,
    SITE_NAME            		varchar(64) NOT NULL,
    INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 		        	varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD	             		varchar(32) NOT NULL, 
	AVG_RND_TRIP_MIN		    decimal(20,4)      NOT NULL,
	AVG_RND_TRIP_MAX	 	    decimal(20,4)      NOT NULL,
	AVG_RND_TRIP_STCNT 		    varchar(32)        NOT NULL,
	MIN_RND_TRIP_MIN     		decimal(20,4)      NOT NULL,
	MIN_RND_TRIP_MAX     		decimal(20,4)      NOT NULL,
	MIN_RND_TRIP_STCNT 		    varchar(32)        NOT NULL,
	PKT_LOSS_PCT_MIN		    decimal(20,4)       NOT NULL,
	PKT_LOSS_PCT_MAX		    decimal(20,4)       NOT NULL,
	PKT_LOSS_PCT_STCNT 		    varchar(32)        NOT NULL,
	AVAILABILITY_MIN		decimal(20,4)		NOT NULL,	
	AVAILABILITY_MAX		decimal(20,4)		NOT NULL,
	AVAILABILITY_STCNT		varchar(32)	NOT NULL
	
);

alter table NETWORKTEST_TREND add constraint PK_NETWORK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTEST_THRESH;

CREATE TABLE NETWORKTEST_THRESH 
(
	TRGT_HOST               varchar(32) NOT NULL,
    PORT_NO                 varchar(32) NOT NULL,
    SITE_NAME               varchar(64) NOT NULL,
    INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
    MSMT_TIME_END           datetime NOT NULL,
	AVG_RND_TRIP_MIN	VARCHAR(256)	 NOT NULL,
	AVG_RND_TRIP_MAX	VARCHAR(256)	 NOT NULL,
	MIN_RND_TRIP_MIN	VARCHAR(256)	 NOT NULL,
	MIN_RND_TRIP_MAX	VARCHAR(256)	 NOT NULL,
	PKT_LOSS_PCT_MIN	VARCHAR(256)	  NOT NULL,
	PKT_LOSS_PCT_MAX	VARCHAR(256)	  NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)			NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)			NOT NULL
	
);

alter table NETWORKTEST_THRESH add constraint PK_NETWORK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTEST_THRESH ON NETWORKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE NETWORKTRAFFICTEST ;

CREATE TABLE NETWORKTRAFFICTEST 
(
	TRGT_HOST       varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME       datetime NOT NULL,
	INP_PKT_RATE	decimal(20,4) NOT NULL,
	INP_PKT_RATE_ST	varchar(32)      NOT NULL,
	OUT_PKT_RATE 	decimal(20,4) NOT NULL,
	OUT_PKT_RATE_ST	varchar(32)      NOT NULL
);

alter table NETWORKTRAFFICTEST add constraint PK_NETWORK_TRAFFIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NETWORKTRAFFICTEST ON NETWORKTRAFFICTEST
(
	 MSMT_TIME
);

DROP TABLE NETWORKTRAFFICTEST_TREND;

CREATE TABLE NETWORKTRAFFICTEST_TREND 
(
	TRGT_HOST       		varchar(32) NOT NULL,
        PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	INP_PKT_RATE_MIN		decimal(20,4) NOT NULL,
	INP_PKT_RATE_MAX		decimal(20,4) NOT NULL,
	INP_PKT_RATE_STCNT 		varchar(32) NOT NULL,
	OUT_PKT_RATE_MIN 		decimal(20,4) NOT NULL,
	OUT_PKT_RATE_MAX 		decimal(20,4) NOT NULL,
	OUT_PKT_RATE_STCNT 		varchar(32) NOT NULL
);

alter table NETWORKTRAFFICTEST_TREND add constraint PK_NETWORK_TRAFFIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTRAFFICTEST_THRESH;

CREATE TABLE NETWORKTRAFFICTEST_THRESH
(
	TRGT_HOST       varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	INP_PKT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	INP_PKT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_PKT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_PKT_RATE_MAX	VARCHAR(256)	 NOT NULL
);

alter table NETWORKTRAFFICTEST_THRESH add constraint PK_NET_TRAFFIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTRAFFICTEST_THRESH ON NETWORKTRAFFICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE ORADATAFILETEST;

CREATE TABLE ORADATAFILETEST
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        PHY_BLKRDS_RATE	     decimal(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_ST   varchar(32)    NOT NULL, 
        PHY_BLKWRTS_RATE     decimal(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_ST  varchar(32)    NOT NULL,
        PCT_USAGE	     decimal(20,4)	NOT NULL,
        PCT_USAGE_ST		varchar(32)	NOT NULL
);

alter table ORADATAFILETEST add constraint PK_ORA_DATAFILE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORADATAFILETEST ON ORADATAFILETEST
(
	 MSMT_TIME
);
DROP TABLE ORADATAFILETEST_TREND;

CREATE TABLE ORADATAFILETEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD            		varchar(32) NOT NULL, 
        PHY_BLKRDS_RATE_MIN	        decimal(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_MAX	        decimal(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_STCNT   	varchar(32)    NOT NULL, 
        PHY_BLKWRTS_RATE_MIN     	decimal(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_MAX     	decimal(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_STCNT  	varchar(32)    NOT NULL,
        PCT_USAGE_MIN			decimal(20,4)	NOT NULL,
        PCT_USAGE_MAX			decimal(20,4) 	NOT NULL,
        PCT_USAGE_STCNT			varchar(32)	NOT NULL
);


alter table ORADATAFILETEST_TREND add constraint PK_ORA_DATAFILE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORADATAFILETEST_THRESH;

CREATE TABLE ORADATAFILETEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        PHY_BLKRDS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_BLKRDS_RATE_MAX	VARCHAR(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MAX	VARCHAR(256)	  NOT NULL,
        PCT_USAGE_MIN	VARCHAR(256)	  NOT NULL,
        PCT_USAGE_MAX	VARCHAR(256)	  NOT NULL
);

alter table ORADATAFILETEST_THRESH add constraint PK_ORA_DATAFILE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORADATAFILETEST_THRESH ON ORADATAFILETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     


DROP TABLE ORALOCKTEST;

CREATE TABLE ORALOCKTEST 
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        CURR_LOCK            decimal(20,4)    NOT NULL,
        CURR_LOCK_ST         varchar(32)    NOT NULL,
        AVG_LOCK_TIME        decimal(20,4)    NOT NULL,
        AVG_LOCK_TIME_ST     varchar(32)    NOT NULL 
);

alter table ORALOCKTEST add constraint PK_ORA_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORALOCKTEST ON ORALOCKTEST
(
	 MSMT_TIME
);

DROP TABLE ORALOCKTEST_TREND;

CREATE TABLE ORALOCKTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
        CURR_LOCK_MIN           	decimal(20,4)    NOT NULL,
        CURR_LOCK_MAX           	decimal(20,4)    NOT NULL,
        CURR_LOCK_STCNT         	varchar(32)    NOT NULL,
        AVG_LOCK_TIME_MIN        	decimal(20,4)    NOT NULL,
        AVG_LOCK_TIME_MAX        	decimal(20,4)    NOT NULL,
        AVG_LOCK_TIME_STCNT     	varchar(32)    NOT NULL 
);


alter table ORALOCKTEST_TREND add constraint PK_ORA_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORALOCKTEST_THRESH;

CREATE TABLE ORALOCKTEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        CURR_LOCK_MIN	VARCHAR(256)	  NOT NULL,
        CURR_LOCK_MAX	VARCHAR(256)	  NOT NULL,
        AVG_LOCK_TIME_MIN	VARCHAR(256)	  NOT NULL,
        AVG_LOCK_TIME_MAX	VARCHAR(256)	  NOT NULL
);

alter table ORALOCKTEST_THRESH add constraint PK_ORA_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORALOCKTEST_THRESH ON ORALOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);         
DROP TABLE ORAPROCESSTEST;

CREATE TABLE ORAPROCESSTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	NUM_PROC	decimal(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar(32)     	NOT NULL,
	CPU_UTIL 	decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar(32)     	NOT NULL,
	MEM_UTIL 	decimal(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar(32)     	NOT NULL
);

ALTER TABLE ORAPROCESSTEST ADD constraint PK_ORAPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORAPROCESSTEST ON ORAPROCESSTEST
(
	 MSMT_TIME
);

DROP TABLE ORAPROCESSTEST_TREND;

CREATE TABLE ORAPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL, 
	NUM_PROC_MIN		decimal(20,4) 	NOT NULL,
	NUM_PROC_MAX		decimal(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar(32)   	NOT NULL,
	CPU_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar(32)   	NOT NULL,
	MEM_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar(32)   	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_TREND ADD constraint PK_ORAPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAPROCESSTEST_THRESH;

CREATE TABLE ORAPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	NUM_PROC_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_THRESH ADD constraint PK_ORAPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORAPROCESSTEST_THRESH ON ORAPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE ORAROLLBACKTEST;

CREATE TABLE ORAROLLBACKTEST
(
        TRGT_HOST                 varchar(32) NOT NULL,
        PORT_NO                   varchar(32) NOT NULL,
        SITE_NAME                 varchar(64) NOT NULL,
        INFO                      varchar(128) NOT NULL,
	MSMT_HOST 		  varchar(32) NOT NULL, 
	MSMT_TIME                 datetime NOT NULL,
	PCT_SYS_SEG_WAIT       	  decimal(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_ST       varchar(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT      decimal(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_ST   varchar(32)    NOT NULL
);

alter table ORAROLLBACKTEST add constraint PK_ORA_ROLLBACK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORAROLLBACKTEST ON ORAROLLBACKTEST
(
	 MSMT_TIME
);

DROP TABLE ORAROLLBACKTEST_TREND;

CREATE TABLE ORAROLLBACKTEST_TREND
(
        TRGT_HOST                 		varchar(32) NOT NULL,
        PORT_NO                   		varchar(32) NOT NULL,
        SITE_NAME                 		varchar(64) NOT NULL,
        INFO                      		varchar(128) NOT NULL,
	MSMT_HOST 				varchar(32) NOT NULL, 
	MSMT_TIME                 		datetime NOT NULL,
	PERIOD                 			varchar(32) NOT NULL, 
	PCT_SYS_SEG_WAIT_MIN        		decimal(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX        		decimal(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_STCNT       		varchar(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN      		decimal(20,4)     NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MAX      		decimal(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_STCNT   		varchar(32)    NOT NULL
);


alter table ORAROLLBACKTEST_TREND add constraint PK_ORA_ROLL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAROLLBACKTEST_THRESH;

CREATE TABLE ORAROLLBACKTEST_THRESH
(
        TRGT_HOST                  varchar(32) NOT NULL,
        PORT_NO                    varchar(32) NOT NULL,
        SITE_NAME                  varchar(64) NOT NULL,
        INFO                       varchar(128) NOT NULL,
	MSMT_HOST 		   varchar(32) NOT NULL, 
	MSMT_TIME_START            datetime NOT NULL,
        MSMT_TIME_END              datetime NOT NULL,
	PCT_SYS_SEG_WAIT_MIN	VARCHAR(256)	     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX	VARCHAR(256)		   NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN	VARCHAR(256)	     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_MAX	VARCHAR(256)		   NOT NULL
);

alter table ORAROLLBACKTEST_THRESH add constraint PK_ORA_ROLL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ORAROLLBACKTEST_THRESH ON ORAROLLBACKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE ORASESSIONTEST;

CREATE TABLE ORASESSIONTEST 
(
        TRGT_HOST              varchar(32) NOT NULL,
        PORT_NO                varchar(32) NOT NULL,
        SITE_NAME              varchar(64) NOT NULL,
        INFO                   varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME              datetime NOT NULL,
        CURR_SESSIONS           decimal(20,4)    NOT NULL,
        CURR_SESSIONS_ST        varchar(32)    NOT NULL,
        CURR_ACT_SESSION       decimal(20,4)    NOT NULL,
        CURR_ACT_SESSION_ST    varchar(32)    NOT NULL,
        BACKGROUND_SESSION     decimal(20,4)    NOT NULL,
        BACKGROUND_SESSION_ST  varchar(32)    NOT NULL,
        INACTIVE_SESSION       decimal(20,4)    NOT NULL,
        INACTIVE_SESSION_ST    varchar(32)    NOT NULL,
        KILLED_SESSION         decimal(20,4)    NOT NULL,
        KILLED_SESSION_ST      varchar(32)    NOT NULL,
        CACHED_SESSION         decimal(20,4)    NOT NULL,
        CACHED_SESSION_ST      varchar(32)    NOT NULL,
        SNIPED_SESSION         decimal(20,4)    NOT NULL,
        SNIPED_SESSION_ST      varchar(32)    NOT NULL,
        BLOCKED_SESSION        decimal(20,4)    NOT NULL,
        BLOCKED_SESSION_ST     varchar(32)    NOT NULL
);

alter table ORASESSIONTEST add constraint PK_ORA_SESSION
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_ORASESSIONTEST ON ORASESSIONTEST (MSMT_TIME) INCLUDE (CURR_ACT_SESSION);


DROP TABLE ORASESSIONTEST_TREND;

CREATE TABLE ORASESSIONTEST_TREND
(
        TRGT_HOST              		varchar(32) NOT NULL,
        PORT_NO                		varchar(32) NOT NULL,
        SITE_NAME              		varchar(64) NOT NULL,
        INFO                   		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME              		datetime NOT NULL,
	PERIOD              		varchar(32) NOT NULL, 
        CURR_SESSIONS_MIN      		decimal(20,4)    NOT NULL,
        CURR_SESSIONS_MAX      		decimal(20,4)    NOT NULL,
        CURR_SESSIONS_STCNT       	varchar(32)    NOT NULL,
        CURR_ACT_SESSION_MIN            decimal(20,4)    NOT NULL,
        CURR_ACT_SESSION_MAX            decimal(20,4)    NOT NULL,
        CURR_ACT_SESSION_STCNT    	varchar(32)    NOT NULL,
        BACKGROUND_SESSION_MIN          decimal(20,4)  NOT NULL,
        BACKGROUND_SESSION_MAX          decimal(20,4)  NOT NULL,
        BACKGROUND_SESSION_STCNT        varchar(32)    NOT NULL,
        INACTIVE_SESSION_MIN            decimal(20,4)  NOT NULL,
        INACTIVE_SESSION_MAX            decimal(20,4)  NOT NULL,
        INACTIVE_SESSION_STCNT          varchar(32)    NOT NULL,
        KILLED_SESSION_MIN              decimal(20,4)  NOT NULL,
        KILLED_SESSION_MAX              decimal(20,4)  NOT NULL,
        KILLED_SESSION_STCNT            varchar(32)    NOT NULL,
        CACHED_SESSION_MIN              decimal(20,4)  NOT NULL,
        CACHED_SESSION_MAX              decimal(20,4)  NOT NULL,
        CACHED_SESSION_STCNT            varchar(32)    NOT NULL,
        SNIPED_SESSION_MIN              decimal(20,4)  NOT NULL,
        SNIPED_SESSION_MAX              decimal(20,4)  NOT NULL,
        SNIPED_SESSION_STCNT            varchar(32)    NOT NULL,
        BLOCKED_SESSION_MIN             decimal(20,4)  NOT NULL,
        BLOCKED_SESSION_MAX             decimal(20,4)  NOT NULL,
        BLOCKED_SESSION_STCNT           varchar(32)    NOT NULL
);


alter table ORASESSIONTEST_TREND add constraint PK_ORA_SESSION_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASESSIONTEST_THRESH;

CREATE TABLE ORASESSIONTEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        CURR_SESSIONS_MIN	VARCHAR(256) NOT NULL,
        CURR_SESSIONS_MAX	VARCHAR(256) NOT NULL,
        CURR_ACT_SESSION_MIN	VARCHAR(256) NOT NULL,
        CURR_ACT_SESSION_MAX	VARCHAR(256) NOT NULL,
        BACKGROUND_SESSION_MIN  VARCHAR(256) NOT NULL,
        BACKGROUND_SESSION_MAX  VARCHAR(256) NOT NULL,
        INACTIVE_SESSION_MIN    VARCHAR(256) NOT NULL,
        INACTIVE_SESSION_MAX    VARCHAR(256) NOT NULL,
        KILLED_SESSION_MIN      VARCHAR(256) NOT NULL,
        KILLED_SESSION_MAX      VARCHAR(256) NOT NULL,
        CACHED_SESSION_MIN      VARCHAR(256) NOT NULL,
        CACHED_SESSION_MAX      VARCHAR(256) NOT NULL,
        SNIPED_SESSION_MIN      VARCHAR(256) NOT NULL,
        SNIPED_SESSION_MAX      VARCHAR(256) NOT NULL,
        BLOCKED_SESSION_MIN     VARCHAR(256) NOT NULL,
        BLOCKED_SESSION_MAX     VARCHAR(256) NOT NULL
);

alter table ORASESSIONTEST_THRESH add constraint PK_ORA_SESSION_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASESSIONTEST_THRESH ON ORASESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE ORASGATEST;
CREATE TABLE ORASGATEST
(
        TRGT_HOST                 varchar(32) NOT NULL,
        PORT_NO                   varchar(32) NOT NULL,
        SITE_NAME                 varchar(64) NOT NULL,
        INFO                      varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME                 datetime NOT NULL,
	PCT_LIBCACHE_RATIO        decimal(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_ST     varchar(32)     NOT NULL,
	PCT_DICTCACHE_RATIO       decimal(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_ST    varchar(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO     decimal(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_ST  varchar(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO    decimal(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_ST varchar(32)   NOT NULL,
	PCT_SORTS_DISK            decimal(20,4)      NOT NULL,
        PCT_SORTS_DISK_ST         varchar(32)     NOT NULL,
	SGA_CURR_USAGE           decimal(20,4)     NOT NULL,
        SGA_CURR_USAGE_ST         varchar(32)     NOT NULL,
	BUFFER_NOWAIT_PCT            decimal(20,4)     NOT NULL,
        BUFFER_NOWAIT_PCT_ST         varchar(32)     NOT NULL,
	SOFT_PARSE_RATIO            decimal(20,4)     NOT NULL,
        SOFT_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	EXECUTE_PARSE_RATIO            decimal(20,4)     NOT NULL,
        EXECUTE_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	CPU_PARSE_RATIO            decimal(20,4)     NOT NULL,
        CPU_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	NON_PARSE_CPU_RATIO            decimal(20,4)     NOT NULL,
        NON_PARSE_CPU_RATIO_ST         varchar(32)     NOT NULL,
	HARD_PARSE_RATIO            decimal(20,4)     NOT NULL,
        HARD_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	TARGET_SIZE_PCT            decimal(20,4)     NOT NULL,
        TARGET_SIZE_PCT_ST         varchar(32)     NOT NULL
);

alter table ORASGATEST add constraint PK_ORA_SGA
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORASGATEST ON ORASGATEST
(
	 MSMT_TIME
);

DROP TABLE ORASGATEST_TREND;
CREATE TABLE ORASGATEST_TREND
(
        TRGT_HOST                 		varchar(32) NOT NULL,
        PORT_NO                   		varchar(32) NOT NULL,
        SITE_NAME                 		varchar(64) NOT NULL,
        INFO                      		varchar(128) NOT NULL,
	MSMT_HOST 				varchar(32) NOT NULL, 
	MSMT_TIME                 		datetime NOT NULL,
	PERIOD                 			varchar(32) NOT NULL, 
	PCT_LIBCACHE_RATIO_MIN        		decimal(20,4)      NOT NULL,
	PCT_LIBCACHE_RATIO_MAX        		decimal(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_STCNT           	varchar(32)     NOT NULL,
	PCT_DICTCACHE_RATIO_MIN                 decimal(20,4)      NOT NULL,
	PCT_DICTCACHE_RATIO_MAX                 decimal(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_STCNT          	varchar(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MIN               decimal(20,4)      NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX               decimal(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_STCNT        	varchar(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN              decimal(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX              decimal(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_STCNT       	varchar(32)   NOT NULL,
	PCT_SORTS_DISK_MIN                      decimal(20,4)      NOT NULL,
	PCT_SORTS_DISK_MAX                      decimal(20,4)      NOT NULL,
        PCT_SORTS_DISK_STCNT               	varchar(32)     NOT NULL,
	SGA_CURR_USAGE_MIN	 decimal(20,4)     NOT NULL,
	SGA_CURR_USAGE_MAX                      decimal(20,4)     NOT NULL,
        SGA_CURR_USAGE_STCNT               	varchar(32)     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN                      decimal(20,4)     NOT NULL,
	BUFFER_NOWAIT_PCT_MAX                      decimal(20,4)     NOT NULL,
        BUFFER_NOWAIT_PCT_STCNT               	varchar(32)     NOT NULL,
	SOFT_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	SOFT_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        SOFT_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	EXECUTE_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        EXECUTE_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	CPU_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	CPU_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        CPU_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN                      decimal(20,4)     NOT NULL,
	NON_PARSE_CPU_RATIO_MAX                      decimal(20,4)     NOT NULL,
        NON_PARSE_CPU_RATIO_STCNT               	varchar(32)     NOT NULL,
	HARD_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	HARD_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        HARD_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	TARGET_SIZE_PCT_MIN                      decimal(20,4)     NOT NULL,
	TARGET_SIZE_PCT_MAX                      decimal(20,4)     NOT NULL,
        TARGET_SIZE_PCT_STCNT               	varchar(32)      NOT NULL
);

alter table ORASGATEST_TREND add constraint PK_ORA_SGA_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASGATEST_THRESH;
CREATE TABLE ORASGATEST_THRESH
(
        TRGT_HOST                  varchar(32) NOT NULL,
        PORT_NO                    varchar(32) NOT NULL,
        SITE_NAME                  varchar(64) NOT NULL,
        INFO                       varchar(128) NOT NULL,
	MSMT_HOST 		   varchar(32) NOT NULL, 
	MSMT_TIME_START            datetime NOT NULL,
        MSMT_TIME_END              datetime NOT NULL,
        PCT_LIBCACHE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	PCT_LIBCACHE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
        PCT_DICTCACHE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	PCT_DICTCACHE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
        PCT_DBBUFFCACHE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN	VARCHAR(256)	    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX	VARCHAR(256)	    NOT NULL,
        PCT_SORTS_DISK_MIN	VARCHAR(256)	     NOT NULL,
	PCT_SORTS_DISK_MAX	VARCHAR(256)	     NOT NULL,
	SGA_CURR_USAGE_MIN	VARCHAR(256)	     NOT NULL,
	SGA_CURR_USAGE_MAX	VARCHAR(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN  	VARCHAR(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MAX 	VARCHAR(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MIN 	VARCHAR(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MAX 	VARCHAR(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN VARCHAR(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MAX VARCHAR(256)	     NOT NULL,
	CPU_PARSE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	CPU_PARSE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	HARD_PARSE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	HARD_PARSE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	TARGET_SIZE_PCT_MIN	VARCHAR(256)	     NOT NULL,
	TARGET_SIZE_PCT_MAX	VARCHAR(256)	     NOT NULL
);

alter table ORASGATEST_THRESH add constraint PK_ORA_SGA_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASGATEST_THRESH ON ORASGATEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   

DROP TABLE ORATABLESPACETEST;
CREATE TABLE ORATABLESPACETEST
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 	     varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
	PCT_SPACE_USED       decimal(20,4)     NOT NULL,
        PCT_SPACE_USED_ST    varchar(32)     NOT NULL,
        PHY_RDS_RATE	     decimal(20,4)    NOT NULL,
        PHY_RDS_RATE_ST      varchar(32)    NOT NULL, 
        PHY_WRTS_RATE        decimal(20,4)    NOT NULL,
        PHY_WRTS_RATE_ST     varchar(32)    NOT NULL       
);

alter table ORATABLESPACETEST add constraint PK_ORA_TABLESPACE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORATABLESPACETEST ON ORATABLESPACETEST
(
	 MSMT_TIME
);

DROP TABLE ORATABLESPACETEST_TREND;

CREATE TABLE ORATABLESPACETEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	PCT_SPACE_USED_MIN     		decimal(20,4)     NOT NULL,
	PCT_SPACE_USED_MAX     		decimal(20,4)     NOT NULL,
        PCT_SPACE_USED_STCNT    	varchar(32)     NOT NULL,
        PHY_RDS_RATE_MIN	     	decimal(20,4)    NOT NULL,
        PHY_RDS_RATE_MAX	     	decimal(20,4)    NOT NULL,
        PHY_RDS_RATE_STCNT      	varchar(32)    NOT NULL, 
        PHY_WRTS_RATE_MIN        	decimal(20,4)    NOT NULL,
        PHY_WRTS_RATE_MAX        	decimal(20,4)    NOT NULL,
        PHY_WRTS_RATE_STCNT     	varchar(32)    NOT NULL       
);


alter table ORATABLESPACETEST_TREND add constraint PK_ORA_TABLESPACE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORATABLESPACETEST_THRESH;

CREATE TABLE ORATABLESPACETEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        PCT_SPACE_USED_MIN	VARCHAR(256)	   NOT NULL,
        PCT_SPACE_USED_MAX	VARCHAR(256)	   NOT NULL,
        PHY_RDS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_RDS_RATE_MAX	VARCHAR(256)	  NOT NULL,
        PHY_WRTS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_WRTS_RATE_MAX	VARCHAR(256)	  NOT NULL
);

alter table ORATABLESPACETEST_THRESH add constraint PK_ORA_TABLESPACE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORATABLESPACETEST_THRESH ON ORATABLESPACETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE PROCESSTEST;

CREATE TABLE PROCESSTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	NUM_PROC	decimal(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar(32)     	NOT NULL,
	CPU_UTIL 	decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar(32)     	NOT NULL,
	MEM_UTIL 	decimal(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar(32)     	NOT NULL
);

ALTER TABLE PROCESSTEST ADD constraint PK_PROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_PROCESSTEST ON PROCESSTEST (MSMT_TIME) INCLUDE (NUM_PROC);

DROP TABLE PROCESSTEST_TREND;

CREATE TABLE PROCESSTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	NUM_PROC_MIN		decimal(20,4) 	NOT NULL,
	NUM_PROC_MAX		decimal(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar(32)   	NOT NULL,
	CPU_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar(32)   	NOT NULL,
	MEM_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar(32)   	NOT NULL
);

ALTER TABLE PROCESSTEST_TREND ADD constraint PK_PROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE PROCESSTEST_THRESH;

CREATE TABLE PROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	NUM_PROC_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE PROCESSTEST_THRESH ADD constraint PK_PROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_PROCESSTEST_THRESH ON PROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE REPORT;

CREATE TABLE REPORT 
(
	SITE_NAME           	    varchar(64) not null,
	COMP_NAME 	    varchar(64) not null,
	COMP_TYPE      	    varchar(32) not null,
	INFO                varchar(128) not null,
	LAYER_NAME		    varchar(64) not null,	
	TEST_NAME		    varchar(64) not null,	
	MEASURE             varchar(64) not null, 
	MSMT_HOST           varchar(32) not null,
        STATE               varchar(32)
    );    
CREATE NONCLUSTERED INDEX IDX1_REPORT ON REPORT (COMP_TYPE) INCLUDE (SITE_NAME, COMP_NAME, INFO, LAYER_NAME, TEST_NAME, MEASURE, MSMT_HOST,STATE);
CREATE NONCLUSTERED INDEX IDX2_REPORT ON REPORT (COMP_TYPE, TEST_NAME ) INCLUDE (COMP_NAME, MEASURE);
CREATE NONCLUSTERED INDEX IDX3_REPORT ON REPORT (SITE_NAME, LAYER_NAME) INCLUDE (TEST_NAME, COMP_NAME, INFO, MSMT_HOST, STATE);
alter table REPORT add constraint PK_REPORT
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,LAYER_NAME,TEST_NAME,MEASURE,MSMT_HOST);
create index idx_report on report(site_name);

DROP TABLE EVENT_HIST;

CREATE TABLE EVENT_HIST
(
	SITE_NAME		varchar(64) NOT NULL,	
	COMP_NAME	varchar(64) NOT NULL,
	COMP_TYPE	varchar(32) NOT NULL,
	INFO		varchar(128) NOT NULL,
	TEST_NAME		varchar(64) NOT NULL,
	MEASURE		varchar(64) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END 	datetime NOT NULL,
	MSMT_HOST	varchar(32) not null,
	EVENT_ID		decimal(16),
    EVENT_SVRTY varchar(32) NOT NULL
);
	

alter table EVENT_HIST add constraint PK_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);

create unique index IDX_EVENT_HIST  on EVENT_HIST(EVENT_ID,MSMT_TIME_START);


DROP TABLE UD_EVENT_HIST;

CREATE TABLE UD_EVENT_HIST
(
	SITE_NAME		varchar(64) NOT NULL,	
	COMP_NAME	varchar(64) NOT NULL,
	COMP_TYPE	varchar(32) NOT NULL,
	INFO		varchar(128) NOT NULL,
	TEST_NAME		varchar(64) NOT NULL,
	MEASURE		varchar(64) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END 	datetime NOT NULL,
	MSMT_HOST	varchar(32) not null,
	EVENT_ID		decimal(16),
    EVENT_SVRTY varchar(32) NOT NULL
);
	

alter table UD_EVENT_HIST add constraint PK_UD_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);

create unique index IDX_UD_EVENT_HIST  on UD_EVENT_HIST(EVENT_ID,MSMT_TIME_START);



DROP TABLE UNKNOWN_HISTORY;

CREATE TABLE UNKNOWN_HISTORY
(
	SITE_NAME	varchar(64) NOT NULL,	
	COMP_NAME	varchar(64) NOT NULL,
	COMP_TYPE	varchar(32) NOT NULL,
	INFO		varchar(128) NOT NULL,
	TEST_NAME	varchar(64) NOT NULL,
	MEASURE		varchar(64) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END 	datetime NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	EVENT_ID	decimal(16)
);

alter table UNKNOWN_HISTORY add constraint PK_UNKNOWN_HISTORY
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST);
create unique index IDX_UNKNOWN_HISTORY on UNKNOWN_HISTORY(EVENT_ID);

DROP TABLE EG_UD_MEASURE;


CREATE TABLE EG_UD_MEASURE
(
	SITE_NAME  VARCHAR(64) NOT NULL,
	TRGT_HOST    VARCHAR(32) NOT NULL,
	PORT_NO      VARCHAR(32)NOT NULL,
	TEST_NAME    VARCHAR(64) NOT NULL,
	MEASURE      VARCHAR(64) NOT NULL,
	INFO         VARCHAR(128) NOT NULL,
	STATE        VARCHAR(32) NOT NULL,
	INDX_MEAS    DECIMAL(16) NOT NULL,
	MSMT_HOST    VARCHAR(32) NOT NULL,
	MSMT_TIME    DATETIME NOT NULL,
	DETL_MEAS    VARCHAR(2000)
);


ALTER TABLE EG_UD_MEASURE ADD constraint PK_EG_UD_MEASURE 
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);

CREATE  INDEX IDX_EG_UD_MEASURE ON EG_UD_MEASURE
(
	MSMT_TIME
);


DROP TABLE REGISTERED_DESKTOPS;
CREATE TABLE REGISTERED_DESKTOPS(HOST_NAME varchar(256) NOT NULL, REGISTERED_TIME DATETIME);
ALTER TABLE REGISTERED_DESKTOPS ADD CONSTRAINT PK_REGISTERED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_REGISTERED_DESKTOPS ON REGISTERED_DESKTOPS(REGISTERED_TIME);

DROP TABLE ALLOWED_DESKTOPS;
CREATE TABLE ALLOWED_DESKTOPS(HOST_NAME varchar(256) NOT NULL, ALLOWED_TIME DATETIME);
ALTER TABLE ALLOWED_DESKTOPS ADD CONSTRAINT PK_ALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_ALLOWED_DESKTOPS ON ALLOWED_DESKTOPS(ALLOWED_TIME);

DROP TABLE DISALLOWED_DESKTOPS;
CREATE TABLE DISALLOWED_DESKTOPS(HOST_NAME varchar(256) NOT NULL, DISALLOWED_TIME DATETIME);
ALTER TABLE DISALLOWED_DESKTOPS ADD CONSTRAINT PK_DISALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_DISALLOWED_DESKTOPS ON DISALLOWED_DESKTOPS(DISALLOWED_TIME);


DROP TABLE EG_UD_UD_MEASURE;
CREATE TABLE EG_UD_UD_MEASURE
(
	SITE_NAME  VARCHAR(64) NOT NULL,
	TRGT_HOST    VARCHAR(32) NOT NULL,
	PORT_NO      VARCHAR(32)NOT NULL,
	TEST_NAME    VARCHAR(64) NOT NULL,
	MEASURE      VARCHAR(64) NOT NULL,
	INFO         VARCHAR(128) NOT NULL,
	STATE        VARCHAR(32) NOT NULL,
	INDX_MEAS    DECIMAL(16) NOT NULL,
	MSMT_HOST    VARCHAR(32) NOT NULL,
	MSMT_TIME    DATETIME NOT NULL,
	DETL_MEAS    VARCHAR(2000)
);
ALTER TABLE EG_UD_UD_MEASURE ADD constraint PK_EG_UD_UD_MEASURE 
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_EG_UD_UD_MEASURE ON EG_UD_UD_MEASURE
(
	MSMT_TIME
);


DROP TABLE SYSTEMTEST; 

CREATE TABLE SYSTEMTEST 
(
	TRGT_HOST           varchar(32) NOT NULL,
        PORT_NO             varchar(32) NOT NULL,
        SITE_NAME           varchar(64) NOT NULL,
        INFO                varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME           datetime NOT NULL,
	CPU_UTIL	    decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST	    varchar(32)        NOT NULL,
	SYS_CPU_UTIL	    decimal(20,4)         NOT NULL,
	SYS_CPU_UTIL_ST	    varchar(32)     	NOT NULL,
	RUNNING_PROC	    decimal(20,4)  	NOT NULL,
	RUNNING_PROC_ST	    varchar(32)     	NOT NULL,
	BLOCKED_PROC	    decimal(20,4)  	NOT NULL,
	BLOCKED_PROC_ST	    varchar(32)     	NOT NULL,
	SWAP_AVAIL	    decimal(20,4)  	NOT NULL,
	SWAP_AVAIL_ST	    varchar(32)        NOT NULL,
	FREE_MEM_AVAIL	    decimal(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_ST   varchar(32)        NOT NULL,
	MEM_SCAN_RATE 	    decimal(20,4)  	NOT NULL,
	MEM_SCAN_RATE_ST    varchar(32)        NOT NULL,
	STEAL_TIME 	    decimal(20,4)  	NOT NULL,
	STEAL_TIME_ST    varchar(32)        NOT NULL
);

alter table SYSTEMTEST add constraint PK_SYSTEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_SYSTEMTEST ON SYSTEMTEST (MSMT_TIME) INCLUDE (CPU_UTIL,FREE_MEM_AVAIL,RUNNING_PROC);
CREATE NONCLUSTERED INDEX IDX1_SYSTEMTEST ON SYSTEMTEST(TRGT_HOST , MSMT_TIME) INCLUDE (CPU_UTIL);

DROP TABLE SYSTEMTEST_TREND; 

CREATE TABLE SYSTEMTEST_TREND 
(
	TRGT_HOST           		varchar(32) NOT NULL,
        PORT_NO             		varchar(32) NOT NULL,
        SITE_NAME           		varchar(64) NOT NULL,
        INFO                		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME           		datetime NOT NULL,
	PERIOD              		varchar(32) NOT NULL,
	CPU_UTIL_MIN	    		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX	    		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT    		varchar(32)    NOT NULL,
	SYS_CPU_UTIL_MIN    		decimal(20,4)     NOT NULL,
	SYS_CPU_UTIL_MAX    		decimal(20,4)     NOT NULL,
	SYS_CPU_UTIL_STCNT	    	varchar(32)   	NOT NULL,
	RUNNING_PROC_MIN	    	decimal(20,4)  	NOT NULL,
	RUNNING_PROC_MAX	    	decimal(20,4)  	NOT NULL,
	RUNNING_PROC_STCNT	    	varchar(32)   	NOT NULL,
	BLOCKED_PROC_MIN	    	decimal(20,4)  	NOT NULL,
	BLOCKED_PROC_MAX	    	decimal(20,4)  	NOT NULL,
	BLOCKED_PROC_STCNT	    	varchar(32)   	NOT NULL,
	SWAP_AVAIL_MIN	    		decimal(20,4)  	NOT NULL,
	SWAP_AVAIL_MAX	    		decimal(20,4)  	NOT NULL,
	SWAP_AVAIL_STCNT	 	varchar(32)    NOT NULL,
	FREE_MEM_AVAIL_MIN	    	decimal(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_MAX	    	decimal(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_STCNT   		varchar(32)    NOT NULL,
	MEM_SCAN_RATE_MIN 	    	decimal(20,4)  	NOT NULL,
	MEM_SCAN_RATE_MAX 	    	decimal(20,4)  	NOT NULL,
	MEM_SCAN_RATE_STCNT		varchar(32)    NOT NULL,
	STEAL_TIME_MIN 	    	decimal(20,4)  	NOT NULL,
	STEAL_TIME_MAX 	    	decimal(20,4)  	NOT NULL,
	STEAL_TIME_STCNT		varchar(32)    NOT NULL
);

alter table SYSTEMTEST_TREND add constraint PK_SYSTEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE SYSTEMTEST_THRESH; 
CREATE TABLE SYSTEMTEST_THRESH 
(
	TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,  
	CPU_UTIL_MIN	VARCHAR(256)	   NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	   NOT NULL,
	SYS_CPU_UTIL_MIN	VARCHAR(256)	   NOT NULL,
	SYS_CPU_UTIL_MAX	VARCHAR(256)	   NOT NULL,
	RUNNING_PROC_MIN	VARCHAR(256)	    NOT NULL,
	RUNNING_PROC_MAX	VARCHAR(256)	    NOT NULL,
	BLOCKED_PROC_MIN	VARCHAR(256)	    NOT NULL,
	BLOCKED_PROC_MAX	VARCHAR(256)	    NOT NULL,
	SWAP_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
	SWAP_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
	FREE_MEM_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
	FREE_MEM_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
	MEM_SCAN_RATE_MIN	VARCHAR(256)	    NOT NULL,
	MEM_SCAN_RATE_MAX	VARCHAR(256)	    NOT NULL,
	STEAL_TIME_MIN	VARCHAR(256)	    NOT NULL,
	STEAL_TIME_MAX	VARCHAR(256)	    NOT NULL
);

alter table SYSTEMTEST_THRESH add constraint PK_SYSTEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SYSTEMTEST_THRESH ON SYSTEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE TCPTEST ;

CREATE TABLE TCPTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
	CONN_RATE_IN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_IN_ST 	varchar(32)    NOT NULL,
	CONN_RATE_OUT 		decimal(20,4) 	NOT NULL,
	CONN_RATE_OUT_ST 	varchar(32)    NOT NULL,
	CURR_CONN 		decimal(20,4) 	NOT NULL,
	CURR_CONN_ST 		varchar(32)    NOT NULL,
	COMP_CONN_DROPS 	decimal(20,4) 	NOT NULL,
	COMP_CONN_DROPS_ST 	varchar(32)    NOT NULL,
	HALF_CONN_DROPS 	decimal(20,4) 	NOT NULL,
	HALF_CONN_DROPS_ST 	varchar(32)    NOT NULL
);

ALTER TABLE TCPTEST ADD CONSTRAINT PK_TCP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_TCPTEST ON TCPTEST (MSMT_TIME) INCLUDE (CURR_CONN);

DROP TABLE TCPTEST_TREND;
CREATE TABLE TCPTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                 	varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
	CONN_RATE_IN_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_IN_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_IN_STCNT 		varchar(32)    NOT NULL,
	CONN_RATE_OUT_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_OUT_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_OUT_STCNT 		varchar(32)    NOT NULL,
	CURR_CONN_MIN 			decimal(20,4) 	NOT NULL,
	CURR_CONN_MAX 			decimal(20,4) 	NOT NULL,
	CURR_CONN_STCNT 		varchar(32)    NOT NULL,
	COMP_CONN_DROPS_MIN 		decimal(20,4) 	NOT NULL,
	COMP_CONN_DROPS_MAX 		decimal(20,4) 	NOT NULL,
	COMP_CONN_DROPS_STCNT 		varchar(32)    NOT NULL,
	HALF_CONN_DROPS_MIN 		decimal(20,4) 	NOT NULL,
	HALF_CONN_DROPS_MAX 		decimal(20,4) 	NOT NULL,
	HALF_CONN_DROPS_STCNT 		varchar(32)    NOT NULL
);

ALTER TABLE TCPTEST_TREND ADD CONSTRAINT PK_TCP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE TCPTEST_THRESH;
CREATE TABLE TCPTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
	CONN_RATE_IN_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_IN_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
	CURR_CONN_MIN	VARCHAR(256)	 	NOT NULL,
	CURR_CONN_MAX	VARCHAR(256)	 	NOT NULL,
	COMP_CONN_DROPS_MIN	VARCHAR(256)	 	NOT NULL,
	COMP_CONN_DROPS_MAX	VARCHAR(256)	 	NOT NULL,
	HALF_CONN_DROPS_MIN	VARCHAR(256)	 	NOT NULL,
	HALF_CONN_DROPS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE TCPTEST_THRESH ADD CONSTRAINT PK_TCP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_TCPTEST_THRESH ON TCPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TESTMEASURE ;
DROP TABLE TESTDESC ;
CREATE TABLE TESTDESC 
(
	TEST_NAME 		varchar(64) NOT NULL,
	TEST_SDESC 		varchar(1000) NOT NULL,
	TEST_LDESC 		varchar(2048)
);

ALTER TABLE TESTDESC ADD CONSTRAINT PK_TESTDESC
PRIMARY KEY (TEST_NAME); 


CREATE TABLE TESTMEASURE
(
        TEST_NAME               varchar(64) NOT NULL,
        MSMT_NAME               varchar(64) NOT NULL,
        MSMT_DESC               varchar(1000)
);

ALTER TABLE TESTMEASURE ADD CONSTRAINT PK_TESTMEASURE
PRIMARY KEY (TEST_NAME);

     

DROP TABLE topology;

CREATE TABLE TOPOLOGY
(
	COMP_TYPE 	    varchar(32) NOT NULL,
	COMP_NAME   	    varchar(64) NOT NULL,
        DEPD                varchar(64)  NOT NULL,
        DIRCT               varchar(32)  NOT NULL
);
	
alter table TOPOLOGY add constraint PK_TOPOLOGY
primary key (COMP_TYPE,COMP_NAME,DEPD);

DROP TABLE EGTRANSACTION;

CREATE TABLE EGTRANSACTION 
(
	TRANS_NAME 	          varchar(64)NOT NULL,
	SITE_NAME   	                  varchar(64) NOT NULL,
	USER_ID   		varchar(256) NOT NULL,
        IMG                     varchar(64)
);    
	
alter table EGTRANSACTION add constraint PK_EGTRANSACTION
primary key (TRANS_NAME,SITE_NAME,USER_ID);

DROP TABLE UDPTEST;

CREATE TABLE UDPTEST
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	PKT_RATE_IN 		decimal(20,4)  	NOT NULL,
	PKT_RATE_IN_ST 		varchar(32)  	NOT NULL,
	PKT_RATE_OUT    	decimal(20,4)  	NOT NULL,
	PKT_RATE_OUT_ST    	varchar(32)  	NOT NULL,
	PKT_OFLOW_RATE    	decimal(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_ST   	varchar(32)  	NOT NULL
);

alter table UDPTEST add constraint PK_UDP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_UDPTEST ON UDPTEST
(
	 MSMT_TIME
);

DROP TABLE UDPTEST_TREND;

CREATE TABLE UDPTEST_TREND
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	PERIOD       		varchar(32) NOT NULL, 
	PKT_RATE_IN_MIN 	decimal(20,4)  	NOT NULL,
	PKT_RATE_IN_MAX 	decimal(20,4)  	NOT NULL,
	PKT_RATE_IN_STCNT 	varchar(32)  	NOT NULL,
	PKT_RATE_OUT_MIN    	decimal(20,4)  	NOT NULL,
	PKT_RATE_OUT_MAX    	decimal(20,4)  	NOT NULL,
	PKT_RATE_OUT_STCNT	varchar(32)  	NOT NULL,
	PKT_OFLOW_RATE_MIN    	decimal(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_MAX    	decimal(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_STCNT	varchar(32)  	NOT NULL
);

alter table UDPTEST_TREND add constraint PK_UDP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE UDPTEST_THRESH;

CREATE TABLE UDPTEST_THRESH
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START       	datetime NOT NULL,
	MSMT_TIME_END          	datetime NOT NULL,
	PKT_RATE_IN_MIN	VARCHAR(256)	  	NOT NULL,
	PKT_RATE_IN_MAX	VARCHAR(256)	  	NOT NULL,
	PKT_RATE_OUT_MIN	VARCHAR(256)	  	NOT NULL,
	PKT_RATE_OUT_MAX	VARCHAR(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MIN	VARCHAR(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MAX	VARCHAR(256)	  	NOT NULL
);

alter table UDPTEST_THRESH add constraint PK_UDP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_UDPTEST_THRESH ON UDPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);            

DROP TABLE report_share;
DROP TABLE report_info;


DROP table USER_SERV;
DROP table USER_ELEMENTS;
DROP table USER_SITE;
DROP table USER_SERVICEGROUP;
DROP TABLE USER_SEG;
DROP TABLE USER_GROUP;
DROP TABLE USER_VM;
DROP TABLE USER_PREF;
DROP TABLE USER_INFO;
DROP TABLE CLOUD_USER_INFO;
DROP TABLE USER_ROLE;

create table USER_ROLE
(
	role_name varchar(32) primary key,
	admin_perm decimal(20) not null,
	monitor_perm decimal(20) not null,
	reporter_perm decimal(20) not null,
	admin_action decimal(20) not null,
	monitor_action decimal(20) not null,
	reporter_action decimal(20) not null,
	all_components char(1) not null,
	config_perm decimal(20) not null,
	config_action decimal(20) not null
);

insert into user_role values('Admin',9223372036854775807, 9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('ServerAdmin',9223372036854775806,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Supermonitor',0,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Monitor',0,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('SupermonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'y',0,0);
insert into user_role values('MonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('AlarmViewer',0,9223372036854775807,0,0,7,0,'n',0,0);
insert into user_role values('SuperAlarmViewer',0,9223372036854775807,0,0,7,0,'y',0,0);
insert into user_role values('egsm',0,9223372036854775807, 9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdmin',772,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdminNoConfig',772,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('OrgAdmin',619492,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('OrgAdminNoConfig',619492,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('OrgAdminWithUserMgmt',619493,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('OrgAdminWithUserMgmtNoConfig',619493,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);



CREATE TABLE USER_INFO 
(
	USER_ID 	    varchar(256) NOT NULL,
	USER_PASS   	    varchar(1024)  NOT NULL,
        USER_TYPE           varchar(32)  NOT NULL,
	USER_MAILID	    varchar(2000),
	USER_ALARM_TYPE	    varchar(32),
	USER_ALARM_PREF	    varchar(32),
	USER_ALARM_MODE     varchar(32),
	USER_VALID_TILL	    datetime,
	USER_REG_DATE	    datetime,
	USER_SERV_TYPE     varchar(1024),
	CA_ENABLED         varchar(16),
	REPT_TIMELINE	   varchar(16)
 );
	
alter table USER_INFO add constraint PK_USER_INFO
primary key (USER_ID);

CREATE TABLE CLOUD_USER_INFO 
(
	EMAIL_ID		varchar(256) NOT NULL,
	FIRST_NAME		varchar(256),
	LAST_NAME		varchar(256),
	PWD			varchar(1024) NOT NULL,
	COMPANY			varchar(256),
	CONTACT_NO		varchar(256),
	TIMEZONE		varchar(256),
	REG_DATE		datetime,  
	ACT_DATE		datetime,
	UUID			varchar(1024),
	ACCT_EXPIRY_DATE	datetime,
	INFO1			varchar(256),
	INFO2			varchar(256)
 );
	
alter table CLOUD_USER_INFO add constraint PK_CLOUD_USER_INFO
primary key (EMAIL_ID);

CREATE TABLE USER_SITE
(
	USER_ID 		varchar(256) not null,
	SITE_NAME		varchar(128) not null
);

alter table USER_SITE add constraint PK_USER_SITE
primary key (USER_ID,SITE_NAME);

alter table USER_SITE add constraint FK_USER_SITE
foreign key(USER_ID) references USER_INFO(USER_ID) ;

CREATE TABLE USER_SERVICEGROUP
(
	USER_ID			varchar(256) not null,
	SERVICEGROUP_NAME	varchar(128) not null
);
 
alter table USER_SERVICEGROUP add constraint PK_USER_SERVICEGROUP
primary key (USER_ID,SERVICEGROUP_NAME);
 
alter table USER_SERVICEGROUP add constraint FK_USER_SERVICEGROUP
foreign key(USER_ID) references USER_INFO(USER_ID);

CREATE TABLE USER_SEG
(
        USER_ID         varchar(256) not null,
        SEG_NAME        varchar(128) not null
);

alter table USER_SEG add constraint PK_USER_SEG
primary key (USER_ID,SEG_NAME);

alter table USER_SEG add constraint FK_USER_SEG
foreign key(USER_ID) references USER_INFO(USER_ID) ;

CREATE TABLE USER_GROUP
(
        USER_ID         varchar(256) not null,
        GROUP_NAME        varchar(128) not null
);

alter table USER_GROUP add constraint PK_USER_GROUP
primary key (USER_ID,GROUP_NAME);

alter table USER_GROUP add constraint FK_USER_GROUP
foreign key(USER_ID) references USER_INFO(USER_ID) ;

CREATE TABLE USER_SERV
(
	USER_ID 		varchar(256) not null,
	SERV_NAME		varchar(128) not null,
	SERV_TYPE		varchar(128) not null
);

alter table USER_SERV add constraint PK_USER_SERV
primary key (
	USER_ID,
	SERV_NAME,
	SERV_TYPE);
alter table USER_SERV add constraint FK_USER_SERV
foreign key(USER_ID) references USER_INFO(USER_ID);


CREATE TABLE USER_ELEMENTS
(
	USER_ID			varchar(256) not null,
	ELEMENT_TYPE		varchar(128) not null,
	ELEMENT_NAME		varchar(128) not null
);

alter table USER_ELEMENTS add constraint PK_USER_ELEMENTS
primary key (
	USER_ID,
	ELEMENT_TYPE,
	ELEMENT_NAME);
alter table USER_ELEMENTS add constraint FK_USER_ELEMENTS
foreign key(USER_ID) references USER_INFO(USER_ID);

CREATE TABLE USER_VM 
( 
	USER_ID			 varchar(256) not null, 
	SERV_NAME		 varchar(128) not null, 
	SERV_TYPE		 varchar(128) not null, 
	VM_NAME			 varchar(128) not null 
); 

alter table USER_VM add constraint PK_USER_VM 
primary key ( 
	USER_ID, 
	SERV_NAME, 
	SERV_TYPE, 
	VM_NAME); 
alter table USER_VM add constraint FK_USER_VM 
foreign key(USER_ID) references USER_INFO(USER_ID); 
create index IDX_USER_VM on USER_VM (VM_NAME);   

insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('admin','D0F28DD6B50F3D807B4CE61454A4365B','Admin','true#true','-1');
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('supermonitor','A8FCB53008C9B77047288D0C58B71BD2','Supermonitor','true#true','-1');
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('egsm','5989FC09AFAAC1B733EB12115CFD48A9','egsm','false','-1');
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('egenterprise','70F8D62C2CE2BCECF8D7C2F0AAA703BE','Admin','true#true','-1');

DROP TABLE QINSIGHT_DETAILS;
DROP TABLE QINSIGHT_REPORT;

CREATE TABLE QINSIGHT_REPORT(
	user_id varchar(512) primary key ,
	No_of_tiers decimal(2),
	No_of_servers_per_tier decimal(2),
	No_of_metrics_per_server decimal(2),
	refresh_rate decimal(5)
);


CREATE TABLE QINSIGHT_DETAILS(
	user_id varchar(512),
	tier_name varchar(128),
	tier_index decimal(2),
	server_name varchar(128),
	server_index decimal(2),
	component varchar(256),
	metric_name varchar(128),
	metric_index decimal(2),
	test varchar(31),
	measure varchar(31),
	info varchar(128),
	site varchar(64),
	type char(1)
);

DROP TABLE USER_REPORT_DETAILS;
DROP TABLE USER_REPORTS;

CREATE TABLE USER_REPORTS(
	rept_id decimal(16)NOT NULL,
	user_id varchar(256),
	rept_name varchar(128),
	unique(user_id,rept_name)
);

ALTER TABLE USER_REPORTS ADD constraint PK_USER_REPORTS
PRIMARY KEY (rept_id);

INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(1,'admin','USER_PREF');
INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(2,'supermonitor','USER_PREF');

CREATE TABLE USER_REPORT_DETAILS(
	rept_id decimal(16) NOT NULL,
	rept_param varchar(128),
	rept_value varchar(1024)
);


alter table USER_REPORT_DETAILS add constraint FK_USER_REPORT_DETAILS
foreign key(rept_id) references user_reports(rept_id) ON DELETE CASCADE;

INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(1,'ALARM_WINDOW','HIL');
INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(2,'ALARM_WINDOW','HIL');

DROP TABLE WAPTEST ;

CREATE TABLE WAPTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        AVAILABILITY            decimal(20,4)    NOT NULL,
        AVAILABILITY_ST        	varchar(32)  	NOT NULL,
        CONN_AVAILABILITY 	decimal(20,4)    NOT NULL,
        CONN_AVAILABILITY_ST 	varchar(32)  	NOT NULL,
        RESPONSE_TIME           decimal(20,4)    NOT NULL, 
        RESPONSE_TIME_ST        varchar(32)     NOT NULL 
);

ALTER TABLE WAPTEST ADD CONSTRAINT PK_WAP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WAPTEST ON WAPTEST
(
	 MSMT_TIME
);

DROP TABLE WAPTEST_TREND;
CREATE TABLE WAPTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                 	varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
        AVAILABILITY_MIN            	decimal(20,4)    NOT NULL,
        AVAILABILITY_MAX            	decimal(20,4)    NOT NULL,
        AVAILABILITY_STCNT        	varchar(32)  	NOT NULL,
        CONN_AVAILABILITY_MIN 		decimal(20,4)    NOT NULL,
        CONN_AVAILABILITY_MAX 		decimal(20,4)    NOT NULL,
        CONN_AVAILABILITY_STCNT 	varchar(32)  	NOT NULL,
        RESPONSE_TIME_MIN           	decimal(20,4)    NOT NULL, 
        RESPONSE_TIME_MAX           	decimal(20,4)    NOT NULL, 
        RESPONSE_TIME_STCNT       	varchar(32)     NOT NULL 
);

ALTER TABLE WAPTEST_TREND ADD CONSTRAINT PK_WAP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE WAPTEST_THRESH;
CREATE TABLE WAPTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABILITY_MIN	VARCHAR(256)	    NOT NULL,
        AVAILABILITY_MAX	VARCHAR(256)	    NOT NULL,
        CONN_AVAILABILITY_MIN	VARCHAR(256)	    NOT NULL,
        CONN_AVAILABILITY_MAX	VARCHAR(256)	    NOT NULL,
        RESPONSE_TIME_MIN	VARCHAR(256)	    NOT NULL,
        RESPONSE_TIME_MAX	VARCHAR(256)	    NOT NULL
);

ALTER TABLE WAPTEST_THRESH ADD CONSTRAINT PK_WAP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WAPTEST_THRESH ON WAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WEBLOGICEJBTEST;

CREATE TABLE WEBLOGICEJBTEST
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	TX_COMMIT_RATE			decimal(20,4)	NOT NULL,
	TX_COMMIT_RATE_ST		varchar(32)	NOT NULL,
	TX_ROLLBACK_RATE 		decimal(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_ST 		varchar(32)	NOT NULL,
	TX_INFLIGHT			decimal(8)	NOT NULL,
	TX_INFLIGHT_ST			varchar(32)	NOT NULL,
	NUM_WAITING_RATE		decimal(20,4)	NOT NULL,
	NUM_WAITING_RATE_ST 		varchar(23)	NOT NULL,
	TIME_OUT_RATE			decimal(20,4)	NOT NULL,
	TIME_OUT_RATE_ST  		varchar(32)	NOT NULL,
	IDLE_BEAN_PCT			decimal(20,4)	NOT NULL,
	IDLE_BEAN_PCT_ST		varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST ADD constraint PK_WLEJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBLOGICEJBTEST ON WEBLOGICEJBTEST
(
	 MSMT_TIME
);


DROP TABLE WEBLOGICEJBTEST_TREND;

CREATE TABLE WEBLOGICEJBTEST_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	TX_COMMIT_RATE_MIN		decimal(20,4)	NOT NULL,	
	TX_COMMIT_RATE_MAX		decimal(20,4)	NOT NULL,
	TX_COMMIT_RATE_STCNT		varchar(32)	NOT NULL,
	TX_ROLLBACK_RATE_MIN		decimal(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_MAX		decimal(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_STCNT		varchar(32)	NOT NULL,
	TX_INFLIGHT_MIN			decimal(8)	NOT NULL,
	TX_INFLIGHT_MAX			decimal(8)	NOT NULL,
	TX_INFLIGHT_STCNT		varchar(32)	NOT NULL,
	NUM_WAITING_RATE_MIN		decimal(20,4)	NOT NULL,
	NUM_WAITING_RATE_MAX		decimal(20,4)	NOT NULL,
	NUM_WAITING_RATE_STCNT		varchar(32)	NOT NULL,
	TIME_OUT_RATE_MIN		decimal(20,4)	NOT NULL,
	TIME_OUT_RATE_MAX		decimal(20,4)	NOT NULL,
	TIME_OUT_RATE_STCNT 		varchar(32)    NOT NULL,
	IDLE_BEAN_PCT_MIN		decimal(20,4)	NOT NULL,
	IDLE_BEAN_PCT_MAX		decimal(20,4)	NOT NULL,
	IDLE_BEAN_PCT_STCNT 		varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_TREND ADD constraint PK_WLEJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICEJBTEST_THRESH;

CREATE TABLE WEBLOGICEJBTEST_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
	TX_COMMIT_RATE_MIN	VARCHAR(256)			NOT NULL,
	TX_COMMIT_RATE_MAX	VARCHAR(256)			NOT NULL,
	TX_ROLLBACK_RATE_MIN	VARCHAR(256)			NOT NULL,
	TX_ROLLBACK_RATE_MAX	VARCHAR(256)			NOT NULL,
	TX_INFLIGHT_MIN	VARCHAR(256)			NOT NULL,
	TX_INFLIGHT_MAX	VARCHAR(256)			NOT NULL,
	NUM_WAITING_RATE_MIN	VARCHAR(256)			NOT NULL,
	NUM_WAITING_RATE_MAX	VARCHAR(256)			NOT NULL,
	TIME_OUT_RATE_MIN	VARCHAR(256)			NOT NULL,
	TIME_OUT_RATE_MAX	VARCHAR(256)			NOT NULL,
	IDLE_BEAN_PCT_MIN	VARCHAR(256)			NOT NULL,
	IDLE_BEAN_PCT_MAX	VARCHAR(256)			NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_THRESH ADD constraint PK_WLEJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICEJBTEST_THRESH ON WEBLOGICEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBLOGICJDBCTEST;

CREATE TABLE WEBLOGICJDBCTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	CONN_USE_PCT 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar(32) 	NOT NULL,
	CONN_PENDING 	decimal(20,4) 	NOT NULL,
	CONN_PENDING_ST varchar(32) 	NOT NULL,
	MAX_CONNS		decimal(20,4)		NOT NULL,
	MAX_CONNS_ST	varchar(32) 	NOT NULL,
	CURR_CONNS		decimal(20,4)		NOT NULL,
	CURR_CONNS_ST	varchar(32)	NOT NULL,
	POOL_STATE		decimal(20,4)	NOT NULL,
	POOL_STATE_ST	varchar(32)	NOT NULL,
	FAIL_RECONNS	decimal(20,4)	NOT NULL,
	FAIL_RECONNS_ST	varchar(32)	NOT NULL,
	CONNS_COUNT	decimal(20,4)	NOT NULL,
	CONNS_COUNT_ST	varchar(32)	NOT NULL,
	CONNS_DELAY		decimal(20,4)	NOT NULL,
	CONNS_DELAY_ST	varchar(32)	NOT NULL,
	LEAK_CONNS		decimal(20,4)	NOT NULL,
	LEAK_CONNS_ST	varchar(32)	NOT NULL,
	ACTIVE_HIGH		decimal(20,4)	NOT NULL,
	ACTIVE_HIGH_ST	varchar(32)	NOT NULL,
	WAIT_HIGH		decimal(20,4)	NOT NULL,
	WAIT_HIGH_ST	varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST ADD constraint PK_WEBLOGIC_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBLOGICJDBCTEST ON WEBLOGICJDBCTEST
(
	 MSMT_TIME
);

DROP TABLE WEBLOGICJDBCTEST_TREND;

CREATE TABLE WEBLOGICJDBCTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	CONN_USE_PCT_MIN 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar(32) 	NOT NULL,
	CONN_PENDING_MIN 	decimal(20,4) 	NOT NULL,
	CONN_PENDING_MAX 	decimal(20,4) 	NOT NULL,
	CONN_PENDING_STCNT 	varchar(32) 	NOT NULL,
	MAX_CONNS_MIN		decimal(20,4)		NOT NULL,
	MAX_CONNS_MAX		decimal(20,4)		NOT NULL,
	MAX_CONNS_STCNT		varchar(32)		NOT NULL,
	CURR_CONNS_MIN		decimal(20,4)		NOT NULL,
	CURR_CONNS_MAX		decimal(20,4)		NOT NULL,
	CURR_CONNS_STCNT	varchar(32)			NOT NULL,
	POOL_STATE_MIN		decimal(20,4)	NOT NULL,
	POOL_STATE_MAX		decimal(20,4)	NOT NULL,
	POOL_STATE_STCNT	varchar(32)	NOT NULL,
	FAIL_RECONNS_MIN	decimal(20,4)	NOT NULL,
	FAIL_RECONNS_MAX	decimal(20,4)	NOT NULL,
	FAIL_RECONNS_STCNT	varchar(32)	NOT NULL,
	CONNS_COUNT_MIN		decimal(20,4)	NOT NULL,
	CONNS_COUNT_MAX		decimal(20,4)	NOT NULL,
	CONNS_COUNT_STCNT	varchar(32)	NOT NULL,
	CONNS_DELAY_MIN		decimal(20,4)	NOT NULL,
	CONNS_DELAY_MAX		decimal(20,4)	NOT NULL,
	CONNS_DELAY_STCNT	varchar(32)	NOT NULL,
	LEAK_CONNS_MIN		decimal(20,4)	NOT NULL,
	LEAK_CONNS_MAX		decimal(20,4)	NOT NULL,
	LEAK_CONNS_STCNT	varchar(32)	NOT NULL,
	ACTIVE_HIGH_MIN		decimal(20,4)	NOT NULL,
	ACTIVE_HIGH_MAX		decimal(20,4)	NOT NULL,
	ACTIVE_HIGH_STCNT	varchar(32)	NOT NULL,
	WAIT_HIGH_MIN		decimal(20,4)	NOT NULL,
	WAIT_HIGH_MAX		decimal(20,4)	NOT NULL,
	WAIT_HIGH_STCNT		varchar(32)	NOT NULL

);

ALTER TABLE WEBLOGICJDBCTEST_TREND ADD constraint PK_WEBLOGIC_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICJDBCTEST_THRESH;

CREATE TABLE WEBLOGICJDBCTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	CONN_USE_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_PENDING_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_PENDING_MAX	VARCHAR(256)	 	NOT NULL,
	MAX_CONNS_MIN	VARCHAR(256)			NOT NULL,
	MAX_CONNS_MAX	VARCHAR(256)			NOT NULL,
	CURR_CONNS_MIN	VARCHAR(256)			NOT NULL,
	CURR_CONNS_MAX	VARCHAR(256)			NOT NULL,
	POOL_STATE_MIN	VARCHAR(256)			NOT NULL,
	POOL_STATE_MAX	VARCHAR(256)			NOT NULL,
	FAIL_RECONNS_MIN	VARCHAR(256)		NOT NULL,
	FAIL_RECONNS_MAX	VARCHAR(256)		NOT NULL,
	CONNS_COUNT_MIN	VARCHAR(256)		NOT NULL,
	CONNS_COUNT_MAX	VARCHAR(256)		NOT NULL,
	CONNS_DELAY_MIN	VARCHAR(256)		NOT NULL,
	CONNS_DELAY_MAX	VARCHAR(256)		NOT NULL,
	LEAK_CONNS_MIN	VARCHAR(256)		NOT NULL,
	LEAK_CONNS_MAX	VARCHAR(256)		NOT NULL,
	ACTIVE_HIGH_MIN	VARCHAR(256)		NOT NULL,
	ACTIVE_HIGH_MAX	VARCHAR(256)		NOT NULL,
	WAIT_HIGH_MIN	VARCHAR(256)		NOT NULL,
	WAIT_HIGH_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST_THRESH ADD constraint PK_WEBLOGIC_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICJDBCTEST_THRESH ON WEBLOGICJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE WEBLOGICTEST;

CREATE TABLE WEBLOGICTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	THROUGHPUT 	decimal(20,4) 	NOT NULL,
	THROUGHPUT_ST 	varchar(32) 	NOT NULL,
	PCT_HEAP_USE 	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar(32) 	NOT NULL,
	EXECUTE_Q_LEN 	decimal(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_ST varchar(32) 	NOT NULL,
	TOTAL_HEAP		decimal(20,4) 	NOT NULL,
	TOTAL_HEAP_ST	varchar(32)	NOT NULL,
	FREE_HEAP		decimal(20,4)	NOT NULL,	
	FREE_HEAP_ST	varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICTEST ADD constraint PK_WEB_LOGIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBLOGICTEST ON WEBLOGICTEST
(
	 MSMT_TIME
);

DROP TABLE WEBLOGICTEST_TREND;

CREATE TABLE WEBLOGICTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	THROUGHPUT_MIN	        decimal(20,4) 	NOT NULL,
	THROUGHPUT_MAX	        decimal(20,4) 	NOT NULL,
	THROUGHPUT_STCNT 	varchar(32) 	NOT NULL,
	PCT_HEAP_USE_MIN	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar(32) 	NOT NULL,
	EXECUTE_Q_LEN_MIN	decimal(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_MAX	decimal(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_STCNT 	varchar(32) 	NOT NULL,
	TOTAL_HEAP_MIN		decimal(20,4) 	NOT NULL,
	TOTAL_HEAP_MAX	decimal(20,4) 	NOT NULL,
	TOTAL_HEAP_STCNT 	varchar(32) 	NOT NULL,
	FREE_HEAP_MIN		decimal(20,4) 	NOT NULL,
	FREE_HEAP_MAX		decimal(20,4) 	NOT NULL,
	FREE_HEAP_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_TREND ADD constraint PK_WEB_LOGIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICTEST_THRESH;

CREATE TABLE WEBLOGICTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	THROUGHPUT_MIN	VARCHAR(256)	 	NOT NULL,
	THROUGHPUT_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_HEAP_USE_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MIN	VARCHAR(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_HEAP_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_HEAP_MAX	VARCHAR(256)	 	NOT NULL,
	FREE_HEAP_MIN	VARCHAR(256)	 	NOT NULL,
	FREE_HEAP_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_THRESH ADD constraint PK_WEB_LOGIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICTEST_THRESH ON WEBLOGICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBSERVERTEST;

CREATE TABLE WEBSERVERTEST 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO 	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,  
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
        MSMT_TIME 	datetime NOT NULL,
        CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	REQ_RATE 	decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar(32)    NOT NULL,
	BYTE_RATE_IN 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar(32)    NOT NULL,
	PCT_ERR 	decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar(32)    NOT NULL,
	PCT_ABORT 	decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar(32)    NOT NULL,
	PCT_300_ERR 	decimal(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar(32)    NOT NULL,
	PCT_400_ERR 	decimal(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar(32)    NOT NULL,
	PCT_500_ERR 	decimal(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar(32)    NOT NULL,
        CURR_REQ 	decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar(32)    NOT NULL
	);

ALTER TABLE WEBSERVERTEST ADD CONSTRAINT PK_WEBMON_SERVER 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  NONCLUSTERED INDEX IDX_WEBSERVERTEST ON WEBSERVERTEST (MSMT_TIME) INCLUDE (REQ_RATE,PCT_ERR);

DROP TABLE WEBSERVERTEST_TREND;

CREATE TABLE WEBSERVERTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO 			varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,  
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD	 			varchar(32) NOT NULL, 
        CONN_RATE_MIN 			decimal(20,4) 	NOT NULL,
        CONN_RATE_MAX 			decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar(32)    NOT NULL,
	REQ_RATE_MIN 			decimal(20,4) 	NOT NULL,
	REQ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		decimal(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar(32)    NOT NULL,
	BYTE_RATE_IN_MIN    		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX    		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar(32)    NOT NULL,
	PCT_ERR_MIN 			decimal(20,4) 	NOT NULL,
	PCT_ERR_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar(32)    NOT NULL,
	PCT_ABORT_MIN    		decimal(20,4) 	NOT NULL,
	PCT_ABORT_MAX    		decimal(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar(32)    NOT NULL,
	PCT_300_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT 		varchar(32)    NOT NULL,
	PCT_400_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar(32)    NOT NULL,
	PCT_500_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar(32)    NOT NULL,
        CURR_REQ_MIN     		decimal(20,4) 	NOT NULL,
        CURR_REQ_MAX     		decimal(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar(32)    NOT NULL
);

ALTER TABLE WEBSERVERTEST_TREND ADD CONSTRAINT PK_WEBMON_SERVER_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSERVERTEST_THRESH;

CREATE TABLE WEBSERVERTEST_THRESH
(
	TRGT_HOST 	  varchar(32) NOT NULL,
	PORT_NO 	  varchar(32) NOT NULL,
        SITE_NAME         varchar(64) NOT NULL,  
        INFO              varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	  datetime NOT NULL,
        MSMT_TIME_END     datetime NOT NULL,
        CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR(256)	  NOT NULL
     );
ALTER TABLE WEBSERVERTEST_THRESH ADD CONSTRAINT PK_WEBMON_SERVER_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSERVERTEST_THRESH ON WEBSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBSITETEST;

CREATE TABLE WEBSITETEST 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO 	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,  
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
        MSMT_TIME 	datetime NOT NULL,
        CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	REQ_RATE 	decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar(32)    NOT NULL,
	BYTE_RATE_IN 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar(32)    NOT NULL,
	PCT_ERR 	decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar(32)    NOT NULL,
	PCT_ABORT 	decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar(32)    NOT NULL,
	PCT_300_ERR 	decimal(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar(32)    NOT NULL,
	PCT_400_ERR 	decimal(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar(32)    NOT NULL,
	PCT_500_ERR 	decimal(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar(32)    NOT NULL,
        CURR_REQ 	decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar(32)    NOT NULL
	);

ALTER TABLE WEBSITETEST ADD CONSTRAINT PK_WEBSITE 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_WEBSITETEST ON WEBSITETEST (MSMT_TIME) INCLUDE (REQ_RATE,BYTE_RATE_OUT,BYTE_RATE_IN,PCT_ERR);
create index idx1_websitetest on websitetest(site_name);
DROP TABLE WEBSITETEST_TREND;

CREATE TABLE WEBSITETEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO 			varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,  
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD  			varchar(32) NOT NULL, 
        CONN_RATE_MIN 			decimal(20,4) 	NOT NULL,
        CONN_RATE_MAX 			decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar(32)    NOT NULL,
	REQ_RATE_MIN 			decimal(20,4) 	NOT NULL,
	REQ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		decimal(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT 		varchar(32)    NOT NULL,
	BYTE_RATE_IN_MIN 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar(32)    NOT NULL,
	PCT_ERR_MIN 			decimal(20,4) 	NOT NULL,
	PCT_ERR_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar(32)    NOT NULL,
	PCT_ABORT_MIN 			decimal(20,4) 	NOT NULL,
	PCT_ABORT_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar(32)    NOT NULL,
	PCT_300_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT		varchar(32)    NOT NULL,
	PCT_400_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar(32)    NOT NULL,
	PCT_500_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar(32)    NOT NULL,
        CURR_REQ_MIN 			decimal(20,4) 	NOT NULL,
        CURR_REQ_MAX 			decimal(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar(32)    NOT NULL
);

ALTER TABLE WEBSITETEST_TREND ADD CONSTRAINT PK_WEBSITE_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETEST_THRESH;

CREATE TABLE WEBSITETEST_THRESH
(
	TRGT_HOST 	  varchar(32) NOT NULL,
	PORT_NO 	  varchar(32) NOT NULL,
        SITE_NAME         varchar(64) NOT NULL,  
        INFO              varchar(128) NOT NULL,
	MSMT_HOST 	  varchar(32) NOT NULL, 
	MSMT_TIME_START	  datetime NOT NULL,
        MSMT_TIME_END     datetime NOT NULL,
        CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR(256)	  NOT NULL
     );
ALTER TABLE WEBSITETEST_THRESH ADD CONSTRAINT PK_WEBSITE_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETEST_THRESH ON WEBSITETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       

DROP TABLE   WEBSITETRANSACTIONTEST;

CREATE TABLE WEBSITETRANSACTIONTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO 		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,  
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        REQ_RATE 		decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar(32)    NOT NULL,
        PCT_ERR 		decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar(32)    NOT NULL,
        PCT_ABORT 		decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	        decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar(32)    NOT NULL,
        AVG_RESP_TIME 	        decimal(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar(32) 	NOT NULL,
        CURR_REQ 		decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST ADD CONSTRAINT PK_WEBSITE_TRAN 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBSITETRANSACTIONTEST ON WEBSITETRANSACTIONTEST
(
	 MSMT_TIME
);
create index idx1_WebSiteTransactionTest on WebSiteTransactionTest(site_name);

DROP TABLE   WEBSITETRANSACTIONTEST_TREND;

CREATE TABLE WEBSITETRANSACTIONTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO 			varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,  
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
        REQ_RATE_MIN 			decimal(20,4) 	NOT NULL,
        REQ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	REQ_RATE_STCNT 	       		varchar(32)    NOT NULL,
        PCT_ERR_MIN 			decimal(20,4) 	NOT NULL,
        PCT_ERR_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar(32)    NOT NULL,
        PCT_ABORT_MIN 			decimal(20,4) 	NOT NULL,
        PCT_ABORT_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 	       	varchar(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 	       	decimal(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 	       	decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar(32)    NOT NULL,
        AVG_RESP_TIME_MIN 	       	decimal(20,4) 	NOT NULL,
        AVG_RESP_TIME_MAX 	       	decimal(20,4) 	NOT NULL,
	AVG_RESP_TIME_STCNT        	varchar(32) 	NOT NULL,
        CURR_REQ_MIN 			decimal(20,4) 	NOT NULL,
        CURR_REQ_MAX 			decimal(20,4) 	NOT NULL,
	CURR_REQ_STCNT 	       		varchar(32)    NOT NULL
      );
ALTER TABLE WEBSITETRANSACTIONTEST_TREND ADD CONSTRAINT PK_WEBSITE_TRAN_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETRANSACTIONTEST_THRESH;
CREATE TABLE WEBSITETRANSACTIONTEST_THRESH
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO 		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,  
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        REQ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
        PCT_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR(256)	 	NOT NULL,
        PCT_ABORT_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
        AVG_RESP_TIME_MIN	VARCHAR(256)	    NOT NULL,
        AVG_RESP_TIME_MAX	VARCHAR(256)	    NOT NULL,
        CURR_REQ_MIN	VARCHAR(256)	    NOT NULL,
        CURR_REQ_MAX	VARCHAR(256)	    NOT NULL
     );
ALTER TABLE WEBSITETRANSACTIONTEST_THRESH ADD CONSTRAINT PK_WEBSITE_TRAN_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETRANSTEST_THRESH ON WEBSITETRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE   WEBSITETRANSACTIONTEST_LAST;

CREATE TABLE WEBSITETRANSACTIONTEST_LAST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO 		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,  
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        REQ_RATE 		decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar(32)    NOT NULL,
        PCT_ERR 		decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar(32)    NOT NULL,
        PCT_ABORT 		decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	        decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar(32)    NOT NULL,
        AVG_RESP_TIME 	        decimal(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar(32) 	NOT NULL,
        CURR_REQ 		decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST_LAST ADD CONSTRAINT PK_WEBSITE_TRAN_LAST 
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO);
create index idx_websitetranstest_last on websitetransactiontest_last(site_name);

DROP TABLE WINSERVICETEST;

CREATE TABLE WINSERVICETEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	AVAIL		decimal(3) 	NOT NULL,
	AVAIL_ST	varchar(32)    NOT NULL,
	SERVICE_STATE	decimal(3) 	NOT NULL,
	SERVICE_STATE_ST	varchar(32)    NOT NULL
);

ALTER TABLE WINSERVICETEST ADD constraint PK_WINSERVICE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WINSERVICETEST ON WINSERVICETEST
(
	 MSMT_TIME
);

DROP TABLE WINSERVICETEST_TREND;

CREATE TABLE WINSERVICETEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	AVAIL_MIN		decimal(20,4) 	NOT NULL,
	AVAIL_MAX		decimal(20,4) 	NOT NULL,
	AVAIL_STCNT		varchar(32)   	NOT NULL,
	SERVICE_STATE_MIN		decimal(20,4) 	NOT NULL,
	SERVICE_STATE_MAX		decimal(20,4) 	NOT NULL,
	SERVICE_STATE_STCNT		varchar(32)   	NOT NULL
);

ALTER TABLE WINSERVICETEST_TREND ADD constraint PK_WINSERVICE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WINSERVICETEST_THRESH;

CREATE TABLE WINSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	AVAIL_MIN	VARCHAR(256)	 	NOT NULL,
	AVAIL_MAX	VARCHAR(256)	 	NOT NULL,
	SERVICE_STATE_MIN	VARCHAR(256)	 	NOT NULL,
	SERVICE_STATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WINSERVICETEST_THRESH ADD constraint PK_WINSERVICE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WINSERVICETEST_THRESH ON WINSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      

DROP TABLE MEASURE_LAST ;

CREATE TABLE MEASURE_LAST
(
	TEST_NAME 	varchar(64) not null,
	TRGT_HOST 	varchar(32) not null,
	PORT_NO 	varchar(32) not null,
        SITE_NAME       varchar(64) not null,    
        INFO            varchar(128) not null,
	MSMT_HOST 	varchar(32) not null, 
        MSMT_TIME 	datetime not null
);

alter table MEASURE_LAST add constraint PK_MEASURE_LAST 
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST);
create index idx_measure_last on measure_last (site_name);
create index idx1_measure_last on measure_last(trgt_host) include (test_name,msmt_host);  
CREATE NONCLUSTERED INDEX IDX2_MEASURE_LAST ON MEASURE_LAST (TEST_NAME, PORT_NO) INCLUDE (TRGT_HOST, INFO, SITE_NAME,MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX3_MEASURE_LAST ON MEASURE_LAST ( INFO, MSMT_TIME) INCLUDE (TRGT_HOST, PORT_NO);
Create index idx4_measure_last on measure_last(msmt_time);
CREATE NONCLUSTERED INDEX idx5_measure_last ON MEASURE_LAST (PORT_NO, TEST_NAME, MSMT_TIME ) INCLUDE  (TRGT_HOST, INFO, MSMT_HOST );

DROP TABLE SILVERSTREAMTEST  ;
CREATE TABLE SILVERSTREAMTEST 
(
	TRGT_HOST 		varchar(32) not null,
        PORT_NO                 varchar(32) not null,
        SITE_NAME               varchar(64) not null,  
        INFO                    varchar(128) not null,
	MSMT_HOST 		varchar(32) not null, 
        MSMT_TIME 		datetime not null,
	SERVER_USAGE_METRIC	decimal(20,4) 	NOT NULL,
	SERVER_USAGE_METRIC_ST	varchar(32)    NOT NULL,
	USED_THREAD_PCT 	decimal(20,4) 	NOT NULL,
	USED_THREAD_PCT_ST 	varchar(32)    NOT NULL,
	IDLE_THREAD_PCT 	decimal(20,4) 	NOT NULL,
	IDLE_THREAD_PCT_ST 	varchar(32)    NOT NULL,
	REQUEST_RATE            decimal(20,4)    NOT NULL,
	REQUEST_RATE_ST         varchar(32)    NOT NULL,
	MEAN_RESPONSE_TIME      decimal(20,4)      NOT NULL,
	MEAN_RESPONSE_TIME_ST   varchar(32)    NOT NULL,
	MAX_RESPONSE_TIME       decimal(20,4)      NOT NULL,
        MAX_RESPONSE_TIME_ST    varchar(32)    NOT NULL,
	DATA_XMIT_RATE    	decimal(20,4)    NOT NULL,
	DATA_XMIT_RATE_ST 	varchar(32)    NOT NULL,
	MEMORY_UTIL         	decimal(20,4)     NOT NULL,
	MEMORY_UTIL_ST      	varchar(32)    NOT NULL,
	TOTAL_SESS_COUNT        decimal(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_ST     varchar(32)    NOT NULL,
	IDLE_SESS_COUNT         decimal(20,4)      NOT NULL,
	IDLE_SESS_COUNT_ST      varchar(32)    NOT NULL
);

ALTER TABLE SILVERSTREAMTEST ADD CONSTRAINT PK_SILVER_STREAM PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SILVERSTREAMTEST ON SILVERSTREAMTEST
(
	 MSMT_TIME
);
DROP TABLE SILVERSTREAMTEST_TREND ;
CREATE TABLE SILVERSTREAMTEST_TREND 
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                 	varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	PERIOD 				varchar(32) not null, 
	SERVER_USAGE_METRIC_MIN		decimal(20,4)     NOT NULL,
	SERVER_USAGE_METRIC_MAX		decimal(20,4)     NOT NULL,
 	SERVER_USAGE_METRIC_STCNT	varchar(32)    NOT NULL,
 	USED_THREAD_PCT_MIN		decimal(20,4)      NOT NULL,
 	USED_THREAD_PCT_MAX		decimal(20,4)      NOT NULL,
 	USED_THREAD_PCT_STCNT    	varchar(32)    NOT NULL,
        IDLE_THREAD_PCT_MIN		decimal(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_MAX		decimal(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_STCNT    	varchar(32)    NOT NULL,
 	REQUEST_RATE_MIN		decimal(20,4)    NOT NULL,
 	REQUEST_RATE_MAX		decimal(20,4)    NOT NULL,
 	REQUEST_RATE_STCNT		varchar(32)    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN		decimal(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX		decimal(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_STCNT	varchar(32)    NOT NULL,
 	MAX_RESPONSE_TIME_MIN		decimal(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_MAX		decimal(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_STCNT		varchar(32)    NOT NULL,
 	DATA_XMIT_RATE_MIN    		decimal(20,4)    NOT NULL,
 	DATA_XMIT_RATE_MAX    		decimal(20,4)    NOT NULL,
        DATA_XMIT_RATE_STCNT 		varchar(32)    NOT NULL,
        MEMORY_UTIL_MIN         	decimal(20,4)     NOT NULL,
        MEMORY_UTIL_MAX         	decimal(20,4)     NOT NULL,
        MEMORY_UTIL_STCNT      		varchar(32)    NOT NULL,
 	TOTAL_SESS_COUNT_MIN		decimal(20,4)      NOT NULL,
 	TOTAL_SESS_COUNT_MAX		decimal(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_STCNT		varchar(32)    NOT NULL,
        IDLE_SESS_COUNT_MIN            	decimal(20,4)      NOT NULL,
        IDLE_SESS_COUNT_MAX            	decimal(20,4)      NOT NULL,
	IDLE_SESS_COUNT_STCNT		varchar(32)    NOT NULL

);

ALTER TABLE SILVERSTREAMTEST_TREND ADD CONSTRAINT PK_SILVER_STREAM_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE SILVERSTREAMTEST_THRESH ;
CREATE TABLE SILVERSTREAMTEST_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                 	varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START 		datetime not null,
        MSMT_TIME_END           	datetime not null,
	SERVER_USAGE_METRIC_MIN	VARCHAR(256)	     NOT NULL,
	SERVER_USAGE_METRIC_MAX	VARCHAR(256)	     NOT NULL,
 	USED_THREAD_PCT_MIN	VARCHAR(256)	      NOT NULL,
 	USED_THREAD_PCT_MAX	VARCHAR(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MIN	VARCHAR(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MAX	VARCHAR(256)	      NOT NULL,
 	REQUEST_RATE_MIN	VARCHAR(256)	    NOT NULL,
 	REQUEST_RATE_MAX	VARCHAR(256)	    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN	VARCHAR(256)	      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX	VARCHAR(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MIN	VARCHAR(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MAX	VARCHAR(256)	      NOT NULL,
 	DATA_XMIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
 	DATA_XMIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        MEMORY_UTIL_MIN	VARCHAR(256)	     NOT NULL,
        MEMORY_UTIL_MAX	VARCHAR(256)	     NOT NULL,
 	TOTAL_SESS_COUNT_MIN	VARCHAR(256)	      NOT NULL,
 	TOTAL_SESS_COUNT_MAX	VARCHAR(256)	      NOT NULL,
        IDLE_SESS_COUNT_MIN	VARCHAR(256)	      NOT NULL,
        IDLE_SESS_COUNT_MAX	VARCHAR(256)	      NOT NULL
);

ALTER TABLE SILVERSTREAMTEST_THRESH ADD CONSTRAINT PK_SILVER_STREAM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SILVERSTREAMTEST_THRESH ON SILVERSTREAMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DB2LOCKANDDEADLOCKTEST  ;

CREATE TABLE DB2LOCKANDDEADLOCKTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	TOTAL_DEADLOCKS 		decimal(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_ST 		varchar(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL	 	decimal(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_ST 	varchar(32) 	NOT NULL,
	LOCKS_HELD        		decimal(20,4)	NOT NULL,
	LOCKS_HELD_ST   		varchar(32)	NOT NULL,
	LOCK_TIMEOUTS	 		decimal(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_ST 		varchar(32)  	NOT NULL,
	LOCK_ESCALATIONS 		decimal(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_ST 		varchar(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT  		decimal(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_ST 	varchar(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST ADD CONSTRAINT PK_DB2_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2LOCKANDDEADLOCKTEST ON DB2LOCKANDDEADLOCKTEST
(
	 MSMT_TIME
);
DROP TABLE DB2LOCKANDDEADLOCKTEST_TREND ;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	TOTAL_DEADLOCKS_MIN 			decimal(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_MAX 			decimal(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_STCNT 			varchar(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN		decimal(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX		decimal(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_STCNT		varchar(32) 	NOT NULL,
	LOCKS_HELD_MIN        			decimal(20,4)	NOT NULL,
	LOCKS_HELD_MAX        			decimal(20,4)	NOT NULL,
	LOCKS_HELD_STCNT   			varchar(32)	NOT NULL,
	LOCK_TIMEOUTS_MIN	 		decimal(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_MAX	 		decimal(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_STCNT 			varchar(32)  	NOT NULL,
	LOCK_ESCALATIONS_MIN 			decimal(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_MAX 			decimal(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_STCNT 			varchar(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN  		decimal(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX  		decimal(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_STCNT 		varchar(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_TREND ADD CONSTRAINT PK_DB2_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2LOCKANDDEADLOCKTEST_THRESH ;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	TOTAL_DEADLOCKS_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_DEADLOCKS_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX	VARCHAR(256)	 	NOT NULL,
	LOCKS_HELD_MIN	VARCHAR(256)		NOT NULL,
	LOCKS_HELD_MAX	VARCHAR(256)		NOT NULL,
	LOCK_TIMEOUTS_MIN	VARCHAR(256)	 	NOT NULL,
	LOCK_TIMEOUTS_MAX	VARCHAR(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MIN	VARCHAR(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN	VARCHAR(256)		NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_THRESH ADD CONSTRAINT PK_DB2_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2LOCKTEST_THRESH ON DB2LOCKANDDEADLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2SORTTEST  ;

CREATE TABLE DB2SORTTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	AVG_SORT_TIME	 		decimal(20,4) 	NOT NULL,
	AVG_SORT_TIME_ST	 	varchar(32)  	NOT NULL,
	PCT_SORT_OVERFLOW	 	decimal(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST ADD CONSTRAINT PK_DB2SORTTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2SORTTEST ON DB2SORTTEST
(
	 MSMT_TIME
);
DROP TABLE DB2SORTTEST_TREND ;
CREATE TABLE DB2SORTTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	AVG_SORT_TIME_MIN 			decimal(20,4) 	NOT NULL,
	AVG_SORT_TIME_MAX 			decimal(20,4) 	NOT NULL,
	AVG_SORT_TIME_STCNT			varchar(32) 	NOT NULL,
	PCT_SORT_OVERFLOW_MIN 			decimal(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_MAX 			decimal(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST_TREND ADD CONSTRAINT PK_DB2SORTTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SORTTEST_THRESH ;
CREATE TABLE DB2SORTTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	AVG_SORT_TIME_MIN	VARCHAR(256)		NOT NULL,
	AVG_SORT_TIME_MAX	VARCHAR(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MIN	VARCHAR(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2SORTTEST_THRESH ADD CONSTRAINT PK_DB2SORTTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2SORTTEST_THRESH ON DB2SORTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2BUFFERPOOLTEST  ;

CREATE TABLE DB2BUFFERPOOLTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	PCT_POOL_HIT_RATIO 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_ST 		varchar(32)  	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_ST 	varchar(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO         decimal(20,4)	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_ST      varchar(32)	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST ADD CONSTRAINT PK_DB2BUFFERPOOLTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2BUFFERPOOLTEST ON DB2BUFFERPOOLTEST
(
	 MSMT_TIME
);

DROP TABLE DB2BUFFERPOOLTEST_TREND ;
CREATE TABLE DB2BUFFERPOOLTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	PCT_POOL_HIT_RATIO_MIN 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_MAX 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_STCNT		varchar(32) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_STCNT		varchar(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN 		decimal(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX 		decimal(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_TREND ADD CONSTRAINT PK_DB2BUFFER_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2BUFFERPOOLTEST_THRESH ;
CREATE TABLE DB2BUFFERPOOLTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	PCT_POOL_HIT_RATIO_MIN	VARCHAR(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_MAX	VARCHAR(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN	VARCHAR(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX	VARCHAR(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN	VARCHAR(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_THRESH ADD CONSTRAINT PK_DB2_BUFFER_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2BUFFERPOOLTEST_THRESH ON DB2BUFFERPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DB2INSTANCETEST ;

CREATE TABLE DB2INSTANCETEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	PCT_AGENTS_WAITING	 	decimal(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_ST 		varchar(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED 	decimal(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_ST 	varchar(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED 	decimal(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_ST	varchar(32)	NOT NULL,
	AGENTS_REGISTERED		decimal(20,4) 	NOT NULL,
	AGENTS_REGISTERED_ST 		varchar(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL		decimal(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_ST	varchar(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST ADD CONSTRAINT PK_DB2_INSTANCE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2INSTANCETEST ON DB2INSTANCETEST
(
	 MSMT_TIME
);

DROP TABLE DB2INSTANCETEST_TREND ;
CREATE TABLE DB2INSTANCETEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	PCT_AGENTS_WAITING_MIN	 		decimal(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	 		decimal(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_STCNT 		varchar(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN 		decimal(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX 		decimal(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_STCNT 		varchar(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN 		decimal(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX 		decimal(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_STCNT		varchar(32)	NOT NULL,
	AGENTS_REGISTERED_MIN			decimal(20,4) 	NOT NULL,
	AGENTS_REGISTERED_MAX			decimal(20,4) 	NOT NULL,
	AGENTS_REGISTERED_STCNT 		varchar(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN		decimal(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX		decimal(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_TREND ADD CONSTRAINT PK_DB2_INSTANCE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2INSTANCETEST_THRESH ;
CREATE TABLE DB2INSTANCETEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	PCT_AGENTS_WAITING_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN	VARCHAR(256)		NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX	VARCHAR(256)		NOT NULL,
	AGENTS_REGISTERED_MIN	VARCHAR(256)	 	NOT NULL,
	AGENTS_REGISTERED_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_THRESH ADD CONSTRAINT PK_DB2_INSTANCE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2INSTANCETEST_THRESH ON DB2INSTANCETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2IOTEST  ;

CREATE TABLE DB2IOTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	DIRECT_READ_RATE 		decimal(20,4) 	NOT NULL,
	DIRECT_READ_RATE_ST 		varchar(32)  	NOT NULL,
	DIRECT_WRITE_RATE 		decimal(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_ST 		varchar(32)  	NOT NULL,
	BUF_POOL_IO_RATE         	decimal(20,4)	NOT NULL,
	BUF_POOL_IO_RATE_ST         	varchar(32)	NOT NULL
);

ALTER TABLE DB2IOTEST ADD CONSTRAINT PK_DB2IOTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2IOTEST ON DB2IOTEST
(
	 MSMT_TIME
);

DROP TABLE DB2IOTEST_TREND ;
CREATE TABLE DB2IOTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	DIRECT_READ_RATE_MIN 			decimal(20,4) 	NOT NULL,
	DIRECT_READ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	DIRECT_READ_RATE_STCNT			varchar(32) 	NOT NULL,
	DIRECT_WRITE_RATE_MIN 			decimal(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_STCNT			varchar(32) 	NOT NULL,
	BUF_POOL_IO_RATE_MIN 			decimal(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_MAX 			decimal(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DB2IOTEST_TREND ADD CONSTRAINT PK_DB2IOTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2IOTEST_THRESH ;
CREATE TABLE DB2IOTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	DIRECT_READ_RATE_MIN	VARCHAR(256)		NOT NULL,
	DIRECT_READ_RATE_MAX	VARCHAR(256)		NOT NULL,
	DIRECT_WRITE_RATE_MIN	VARCHAR(256)		NOT NULL,
	DIRECT_WRITE_RATE_MAX	VARCHAR(256)		NOT NULL,
	BUF_POOL_IO_RATE_MIN	VARCHAR(256)		NOT NULL,
	BUF_POOL_IO_RATE_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2IOTEST_THRESH ADD CONSTRAINT PK_DB2IOTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2IOTEST_THRESH ON DB2IOTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);



DROP TABLE DB2SQLACTIVITYTEST ;

CREATE TABLE DB2SQLACTIVITYTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	DYNAMIC_SQL_RATE	 	decimal(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_ST 		varchar(32)  	NOT NULL,
	SELECT_SQL_RATE		 	decimal(20,4) 	NOT NULL,
	SELECT_SQL_RATE_ST	 	varchar(32) 	NOT NULL,
	FAILED_SQL_RATE        		decimal(20,4)	NOT NULL,
	FAILED_SQL_RATE_ST   		varchar(32)	NOT NULL,
	UID_SQL_RATE	 		decimal(20,4) 	NOT NULL,
	UID_SQL_RATE_ST 		varchar(32)  	NOT NULL,
	PCT_FAILED_SQL	 		decimal(20,4) 	NOT NULL,
	PCT_FAILED_SQL_ST 		varchar(32) 	NOT NULL,
	PCT_DDL_SQL  			decimal(20,4)	NOT NULL,
	PCT_DDL_SQL_ST			varchar(32)	NOT NULL,
	PCT_UID_SQL  			decimal(20,4)	NOT NULL,
	PCT_UID_SQL_ST	 		varchar(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST ADD CONSTRAINT PK_DB2_SQLACTIVITY
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_DB2SQLACTIVITYTEST ON DB2SQLACTIVITYTEST
(
	 MSMT_TIME
);

DROP TABLE DB2SQLACTIVITYTEST_TREND ;
CREATE TABLE DB2SQLACTIVITYTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	DYNAMIC_SQL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_STCNT 			varchar(32)  	NOT NULL,
	SELECT_SQL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	SELECT_SQL_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	SELECT_SQL_RATE_STCNT	 		varchar(32) 	NOT NULL,
	FAILED_SQL_RATE_MIN        		decimal(20,4)	NOT NULL,
	FAILED_SQL_RATE_MAX        		decimal(20,4)	NOT NULL,
	FAILED_SQL_RATE_STCNT   		varchar(32)	NOT NULL,
	UID_SQL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	UID_SQL_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	UID_SQL_RATE_STCNT 			varchar(32)  	NOT NULL,
	PCT_FAILED_SQL_MIN	 		decimal(20,4) 	NOT NULL,
	PCT_FAILED_SQL_MAX	 		decimal(20,4) 	NOT NULL,
	PCT_FAILED_SQL_STCNT 			varchar(32) 	NOT NULL,
	PCT_DDL_SQL_MIN  			decimal(20,4)	NOT NULL,
	PCT_DDL_SQL_MAX  			decimal(20,4)	NOT NULL,
	PCT_DDL_SQL_STCNT			varchar(32)	NOT NULL,
	PCT_UID_SQL_MIN  			decimal(20,4)	NOT NULL,
	PCT_UID_SQL_MAX  			decimal(20,4)	NOT NULL,
	PCT_UID_SQL_STCNT	 		varchar(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_TREND ADD CONSTRAINT PK_DB2_SQLACTIVITY_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SQLACTIVITYTEST_THRESH ;
CREATE TABLE DB2SQLACTIVITYTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	DYNAMIC_SQL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	SELECT_SQL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	SELECT_SQL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	FAILED_SQL_RATE_MIN	VARCHAR(256)		NOT NULL,
	FAILED_SQL_RATE_MAX	VARCHAR(256)		NOT NULL,
	UID_SQL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	UID_SQL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_FAILED_SQL_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_FAILED_SQL_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_DDL_SQL_MIN	VARCHAR(256)		NOT NULL,
	PCT_DDL_SQL_MAX	VARCHAR(256)		NOT NULL,
	PCT_UID_SQL_MIN	VARCHAR(256)		NOT NULL,
	PCT_UID_SQL_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_THRESH ADD CONSTRAINT PK_DB2_SQLACTIVITY_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2SQLACTIVITYTEST_THRESH ON DB2SQLACTIVITYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DB2TRANSACTIONTEST  ;

CREATE TABLE DB2TRANSACTIONTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	COMM_STMT_RATE	 		decimal(20,4) 	NOT NULL,
	COMM_STMT_RATE_ST 		varchar(32)  	NOT NULL,
	ROLLBACK_RATE		 	decimal(20,4) 	NOT NULL,
	ROLLBACK_RATE_ST	 	varchar(32) 	NOT NULL,
	TRANSACTION_RATE 	        decimal(20,4)	NOT NULL,
	TRANSACTION_RATE_ST     	 varchar(32)	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST ADD CONSTRAINT PK_DB2TRANSACTIONTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2TRANSACTIONTEST ON DB2TRANSACTIONTEST
(
	 MSMT_TIME
);

DROP TABLE DB2TRANSACTIONTEST_TREND ;
CREATE TABLE DB2TRANSACTIONTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	COMM_STMT_RATE_MIN 			decimal(20,4) 	NOT NULL,
	COMM_STMT_RATE_MAX 			decimal(20,4) 	NOT NULL,
	COMM_STMT_RATE_STCNT			varchar(32) 	NOT NULL,
	ROLLBACK_RATE_MIN 			decimal(20,4) 	NOT NULL,
	ROLLBACK_RATE_MAX 			decimal(20,4) 	NOT NULL,
	ROLLBACK_RATE_STCNT			varchar(32) 	NOT NULL,
	TRANSACTION_RATE_MIN 			decimal(20,4) 	NOT NULL,
	TRANSACTION_RATE_MAX 			decimal(20,4) 	NOT NULL,
	TRANSACTION_RATE_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_TREND ADD CONSTRAINT PK_DB2TRANSACTIONTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2TRANSACTIONTEST_THRESH ;
CREATE TABLE DB2TRANSACTIONTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	COMM_STMT_RATE_MIN	VARCHAR(256)		NOT NULL,
	COMM_STMT_RATE_MAX	VARCHAR(256)		NOT NULL,
	ROLLBACK_RATE_MIN	VARCHAR(256)		NOT NULL,
	ROLLBACK_RATE_MAX	VARCHAR(256)		NOT NULL,
	TRANSACTION_RATE_MIN	VARCHAR(256)		NOT NULL,
	TRANSACTION_RATE_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_THRESH ADD CONSTRAINT PK_DB2TRANSACTIONTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2TRANSACTIONTEST_THRESH ON DB2TRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybDataCacheTest;
CREATE TABLE SybDataCacheTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
UTILIZATION DECIMAL(20,4) NOT NULL,
UTILIZATION_ST varchar(32) NOT NULL,
CACHE_HIT_RATIO DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar(32) NOT NULL,
SPINLOCK_CONTENTION DECIMAL(20,4) NOT NULL,
SPINLOCK_CONTENTION_ST varchar(32) NOT NULL,
BUFFERS_GRABBED DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_ST varchar(32) NOT NULL,
BUFFERS_GRABBED_DIRTY DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_ST varchar(32) NOT NULL,
PCT_LARGE_IO_DENIED DECIMAL(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_ST varchar(32) NOT NULL,
LARGE_IO_EFFECTIVENESS DECIMAL(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_ST varchar(32) NOT NULL);

ALTER TABLE SybDataCacheTest ADD constraint PK_SybDataCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybDataCacheTest ON SybDataCacheTest
(
	 MSMT_TIME
);

DROP TABLE SybDataCacheTest_TREND;
CREATE TABLE SybDataCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
UTILIZATION_STCNT varchar(32) NOT NULL,
CACHE_HIT_RATIO_MIN DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar(32) NOT NULL,
SPINLOCK_CONTENTION_MIN DECIMAL(20,4) NOT NULL,
SPINLOCK_CONTENTION_MAX DECIMAL(20,4) NOT NULL,
SPINLOCK_CONTENTION_STCNT varchar(32) NOT NULL,
BUFFERS_GRABBED_MIN DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_MAX DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_STCNT varchar(32) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_STCNT varchar(32) NOT NULL,
PCT_LARGE_IO_DENIED_MIN DECIMAL(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_MAX DECIMAL(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_STCNT varchar(32) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN DECIMAL(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX DECIMAL(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_STCNT varchar(32) NOT NULL);

ALTER TABLE SybDataCacheTest_TREND ADD constraint PK_SybDataCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDataCacheTest_THRESH;
CREATE TABLE SybDataCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
UTILIZATION_MIN VARCHAR(256) NOT NULL,
UTILIZATION_MAX VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR(256) NOT NULL,
SPINLOCK_CONTENTION_MIN VARCHAR(256) NOT NULL,
SPINLOCK_CONTENTION_MAX VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_MIN VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_MAX VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX VARCHAR(256) NOT NULL,
PCT_LARGE_IO_DENIED_MIN VARCHAR(256) NOT NULL,
PCT_LARGE_IO_DENIED_MAX VARCHAR(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN VARCHAR(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybDataCacheTest_THRESH ADD constraint PK_SybDataCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDataCacheTest_THRESH ON SybDataCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybDeviceTest;
CREATE TABLE SybDeviceTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IO_REQUESTS DECIMAL(20,4) NOT NULL,
IO_REQUESTS_ST varchar(32) NOT NULL,
PHY_READ_RATE DECIMAL(20,4) NOT NULL,
PHY_READ_RATE_ST varchar(32) NOT NULL,
PHY_WRITE_RATE DECIMAL(20,4) NOT NULL,
PHY_WRITE_RATE_ST varchar(32) NOT NULL,
IO_ERRORS DECIMAL(20,4) NOT NULL,
IO_ERRORS_ST varchar(32) NOT NULL,
IO_WAITS DECIMAL(20,4) NOT NULL,
IO_WAITS_ST varchar(32) NOT NULL);

ALTER TABLE SybDeviceTest ADD constraint PK_SybDeviceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybDeviceTest ON SybDeviceTest
(
	 MSMT_TIME
);
DROP TABLE SybDeviceTest_TREND;
CREATE TABLE SybDeviceTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IO_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
IO_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar(32) NOT NULL,
PHY_READ_RATE_MIN DECIMAL(20,4) NOT NULL,
PHY_READ_RATE_MAX DECIMAL(20,4) NOT NULL,
PHY_READ_RATE_STCNT varchar(32) NOT NULL,
PHY_WRITE_RATE_MIN DECIMAL(20,4) NOT NULL,
PHY_WRITE_RATE_MAX DECIMAL(20,4) NOT NULL,
PHY_WRITE_RATE_STCNT varchar(32) NOT NULL,
IO_ERRORS_MIN DECIMAL(20,4) NOT NULL,
IO_ERRORS_MAX DECIMAL(20,4) NOT NULL,
IO_ERRORS_STCNT varchar(32) NOT NULL,
IO_WAITS_MIN DECIMAL(20,4) NOT NULL,
IO_WAITS_MAX DECIMAL(20,4) NOT NULL,
IO_WAITS_STCNT varchar(32) NOT NULL);

ALTER TABLE SybDeviceTest_TREND ADD constraint PK_SybDeviceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDeviceTest_THRESH;
CREATE TABLE SybDeviceTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IO_REQUESTS_MIN VARCHAR(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR(256) NOT NULL,
PHY_READ_RATE_MIN VARCHAR(256) NOT NULL,
PHY_READ_RATE_MAX VARCHAR(256) NOT NULL,
PHY_WRITE_RATE_MIN VARCHAR(256) NOT NULL,
PHY_WRITE_RATE_MAX VARCHAR(256) NOT NULL,
IO_ERRORS_MIN VARCHAR(256) NOT NULL,
IO_ERRORS_MAX VARCHAR(256) NOT NULL,
IO_WAITS_MIN VARCHAR(256) NOT NULL,
IO_WAITS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybDeviceTest_THRESH ADD constraint PK_SybDeviceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDeviceTest_THRESH ON SybDeviceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybLockTest;
CREATE TABLE SybLockTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
LOCK_REQUESTS DECIMAL(20,4) NOT NULL,
LOCK_REQUESTS_ST varchar(32) NOT NULL,
LOCK_WAITS DECIMAL(20,4) NOT NULL,
LOCK_WAITS_ST varchar(32) NOT NULL,
AVG_LOCK_WAIT_TIME DECIMAL(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_ST varchar(32) NOT NULL,
LOCK_TIMEOUTS DECIMAL(20,4) NOT NULL,
LOCK_TIMEOUTS_ST varchar(32) NOT NULL,
DEAD_LOCKS DECIMAL(20,4) NOT NULL,
DEAD_LOCKS_ST varchar(32) NOT NULL);

ALTER TABLE SybLockTest ADD constraint PK_SybLockTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybLockTest ON SybLockTest
(
	 MSMT_TIME
);
DROP TABLE SybLockTest_TREND;
CREATE TABLE SybLockTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
LOCK_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
LOCK_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
LOCK_REQUESTS_STCNT varchar(32) NOT NULL,
LOCK_WAITS_MIN DECIMAL(20,4) NOT NULL,
LOCK_WAITS_MAX DECIMAL(20,4) NOT NULL,
LOCK_WAITS_STCNT varchar(32) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_STCNT varchar(32) NOT NULL,
LOCK_TIMEOUTS_MIN DECIMAL(20,4) NOT NULL,
LOCK_TIMEOUTS_MAX DECIMAL(20,4) NOT NULL,
LOCK_TIMEOUTS_STCNT varchar(32) NOT NULL,
DEAD_LOCKS_MIN DECIMAL(20,4) NOT NULL,
DEAD_LOCKS_MAX DECIMAL(20,4) NOT NULL,
DEAD_LOCKS_STCNT varchar(32) NOT NULL);

ALTER TABLE SybLockTest_TREND ADD constraint PK_SybLockTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockTest_THRESH;
CREATE TABLE SybLockTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
LOCK_REQUESTS_MIN VARCHAR(256) NOT NULL,
LOCK_REQUESTS_MAX VARCHAR(256) NOT NULL,
LOCK_WAITS_MIN VARCHAR(256) NOT NULL,
LOCK_WAITS_MAX VARCHAR(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN VARCHAR(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX VARCHAR(256) NOT NULL,
LOCK_TIMEOUTS_MIN VARCHAR(256) NOT NULL,
LOCK_TIMEOUTS_MAX VARCHAR(256) NOT NULL,
DEAD_LOCKS_MIN VARCHAR(256) NOT NULL,
DEAD_LOCKS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybLockTest_THRESH ADD constraint PK_SybLockTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockTest_THRESH ON SybLockTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE SybLockStatsTest;
CREATE TABLE SybLockStatsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NUM_OF_LOCKS DECIMAL(20,4) NOT NULL,
NUM_OF_LOCKS_ST varchar(32) NOT NULL,
AVG_BLOCK_TIME DECIMAL(20,4) NOT NULL,
AVG_BLOCK_TIME_ST varchar(32) NOT NULL);

CREATE  INDEX IDX_SybLockStatsTest ON SybLockStatsTest(MSMT_TIME);
ALTER TABLE SybLockStatsTest ADD constraint PK_SybLockStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybLockStatsTest_TREND;
CREATE TABLE SybLockStatsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUM_OF_LOCKS_MIN DECIMAL(20,4) NOT NULL,
NUM_OF_LOCKS_MAX DECIMAL(20,4) NOT NULL,
NUM_OF_LOCKS_STCNT varchar(32) NOT NULL,
AVG_BLOCK_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_BLOCK_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_BLOCK_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE SybLockStatsTest_TREND ADD constraint PK_SybLockStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockStatsTest_THRESH;
CREATE TABLE SybLockStatsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NUM_OF_LOCKS_MIN VARCHAR(256) NOT NULL,
NUM_OF_LOCKS_MAX VARCHAR(256) NOT NULL,
AVG_BLOCK_TIME_MIN VARCHAR(256) NOT NULL,
AVG_BLOCK_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybLockStatsTest_THRESH ADD constraint PK_SybLockStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockStatsTest_THRESH ON SybLockStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);



DROP TABLE SybNetworkTest;
CREATE TABLE SybNetworkTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IO_REQUESTS DECIMAL(20,4) NOT NULL,
IO_REQUESTS_ST varchar(32) NOT NULL,
IO_DELAY DECIMAL(20,4) NOT NULL,
IO_DELAY_ST varchar(32) NOT NULL,
DATA_RECVD_RATE DECIMAL(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar(32) NOT NULL,
DATA_SENT_RATE DECIMAL(20,4) NOT NULL,
DATA_SENT_RATE_ST varchar(32) NOT NULL,
AVG_PACKET_SIZE DECIMAL(20,4) NOT NULL,
AVG_PACKET_SIZE_ST varchar(32) NOT NULL);

CREATE  INDEX IDX_SybNetworkTest ON SybNetworkTest
(
	 MSMT_TIME
);

ALTER TABLE SybNetworkTest ADD constraint PK_SybNetworkTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybNetworkTest_TREND;
CREATE TABLE SybNetworkTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IO_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
IO_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar(32) NOT NULL,
IO_DELAY_MIN DECIMAL(20,4) NOT NULL,
IO_DELAY_MAX DECIMAL(20,4) NOT NULL,
IO_DELAY_STCNT varchar(32) NOT NULL,
DATA_RECVD_RATE_MIN DECIMAL(20,4) NOT NULL,
DATA_RECVD_RATE_MAX DECIMAL(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar(32) NOT NULL,
DATA_SENT_RATE_MIN DECIMAL(20,4) NOT NULL,
DATA_SENT_RATE_MAX DECIMAL(20,4) NOT NULL,
DATA_SENT_RATE_STCNT varchar(32) NOT NULL,
AVG_PACKET_SIZE_MIN DECIMAL(20,4) NOT NULL,
AVG_PACKET_SIZE_MAX DECIMAL(20,4) NOT NULL,
AVG_PACKET_SIZE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybNetworkTest_TREND ADD constraint PK_SybNetworkTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybNetworkTest_THRESH;
CREATE TABLE SybNetworkTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IO_REQUESTS_MIN VARCHAR(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR(256) NOT NULL,
IO_DELAY_MIN VARCHAR(256) NOT NULL,
IO_DELAY_MAX VARCHAR(256) NOT NULL,
DATA_RECVD_RATE_MIN VARCHAR(256) NOT NULL,
DATA_RECVD_RATE_MAX VARCHAR(256) NOT NULL,
DATA_SENT_RATE_MIN VARCHAR(256) NOT NULL,
DATA_SENT_RATE_MAX VARCHAR(256) NOT NULL,
AVG_PACKET_SIZE_MIN VARCHAR(256) NOT NULL,
AVG_PACKET_SIZE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybNetworkTest_THRESH ADD constraint PK_SybNetworkTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybNetworkTest_THRESH ON SybNetworkTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybProcCacheTest;
CREATE TABLE SybProcCacheTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PROCEDURE_REQUESTS DECIMAL(20,4) NOT NULL,
PROCEDURE_REQUESTS_ST varchar(32) NOT NULL,
DISK_READS DECIMAL(20,4) NOT NULL,
DISK_READS_ST varchar(32) NOT NULL,
CACHE_HIT_RATIO DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar(32) NOT NULL,
PROCEDURES_CREATED DECIMAL(20,4) NOT NULL,
PROCEDURES_CREATED_ST varchar(32) NOT NULL,
PROCEDURES_AGED_OUT DECIMAL(20,4) NOT NULL,
PROCEDURES_AGED_OUT_ST varchar(32) NOT NULL);

ALTER TABLE SybProcCacheTest ADD constraint PK_SybProcCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybProcCacheTest ON SybProcCacheTest
(
	 MSMT_TIME
);
DROP TABLE SybProcCacheTest_TREND;
CREATE TABLE SybProcCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
PROCEDURE_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
PROCEDURE_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
PROCEDURE_REQUESTS_STCNT varchar(32) NOT NULL,
DISK_READS_MIN DECIMAL(20,4) NOT NULL,
DISK_READS_MAX DECIMAL(20,4) NOT NULL,
DISK_READS_STCNT varchar(32) NOT NULL,
CACHE_HIT_RATIO_MIN DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar(32) NOT NULL,
PROCEDURES_CREATED_MIN DECIMAL(20,4) NOT NULL,
PROCEDURES_CREATED_MAX DECIMAL(20,4) NOT NULL,
PROCEDURES_CREATED_STCNT varchar(32) NOT NULL,
PROCEDURES_AGED_OUT_MIN DECIMAL(20,4) NOT NULL,
PROCEDURES_AGED_OUT_MAX DECIMAL(20,4) NOT NULL,
PROCEDURES_AGED_OUT_STCNT varchar(32) NOT NULL);

ALTER TABLE SybProcCacheTest_TREND ADD constraint PK_SybProcCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybProcCacheTest_THRESH;
CREATE TABLE SybProcCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
PROCEDURE_REQUESTS_MIN VARCHAR(256) NOT NULL,
PROCEDURE_REQUESTS_MAX VARCHAR(256) NOT NULL,
DISK_READS_MIN VARCHAR(256) NOT NULL,
DISK_READS_MAX VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR(256) NOT NULL,
PROCEDURES_CREATED_MIN VARCHAR(256) NOT NULL,
PROCEDURES_CREATED_MAX VARCHAR(256) NOT NULL,
PROCEDURES_AGED_OUT_MIN VARCHAR(256) NOT NULL,
PROCEDURES_AGED_OUT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybProcCacheTest_THRESH ADD constraint PK_SybProcCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybProcCacheTest_THRESH ON SybProcCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSpaceTest;
CREATE TABLE SybSpaceTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_SIZE DECIMAL(20,4) NOT NULL,
TOTAL_SIZE_ST varchar(32) NOT NULL,
PCT_RESERVED DECIMAL(20,4) NOT NULL,
PCT_RESERVED_ST varchar(32) NOT NULL,
RESERVED_SPACE DECIMAL(20,4) NOT NULL,
RESERVED_SPACE_ST varchar(32) NOT NULL,
DATA_SPACE DECIMAL(20,4) NOT NULL,
DATA_SPACE_ST varchar(32) NOT NULL,
INDEX_SPACE DECIMAL(20,4) NOT NULL,
INDEX_SPACE_ST varchar(32) NOT NULL,
UNUSED_SPACE DECIMAL(20,4) NOT NULL,
UNUSED_SPACE_ST varchar(32) NOT NULL);
ALTER TABLE SybSpaceTest ADD constraint PK_SybSpaceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybSpaceTest ON SybSpaceTest
(
	 MSMT_TIME
);
DROP TABLE SybSpaceTest_TREND;
CREATE TABLE SybSpaceTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_SIZE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_SIZE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_SIZE_STCNT varchar(32) NOT NULL,
PCT_RESERVED_MIN DECIMAL(20,4) NOT NULL,
PCT_RESERVED_MAX DECIMAL(20,4) NOT NULL,
PCT_RESERVED_STCNT varchar(32) NOT NULL,
RESERVED_SPACE_MIN DECIMAL(20,4) NOT NULL,
RESERVED_SPACE_MAX DECIMAL(20,4) NOT NULL,
RESERVED_SPACE_STCNT varchar(32) NOT NULL,
DATA_SPACE_MIN DECIMAL(20,4) NOT NULL,
DATA_SPACE_MAX DECIMAL(20,4) NOT NULL,
DATA_SPACE_STCNT varchar(32) NOT NULL,
INDEX_SPACE_MIN DECIMAL(20,4) NOT NULL,
INDEX_SPACE_MAX DECIMAL(20,4) NOT NULL,
INDEX_SPACE_STCNT varchar(32) NOT NULL,
UNUSED_SPACE_MIN DECIMAL(20,4) NOT NULL,
UNUSED_SPACE_MAX DECIMAL(20,4) NOT NULL,
UNUSED_SPACE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybSpaceTest_TREND ADD constraint PK_SybSpaceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSpaceTest_THRESH;
CREATE TABLE SybSpaceTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_SIZE_MIN VARCHAR(256) NOT NULL,
TOTAL_SIZE_MAX VARCHAR(256) NOT NULL,
PCT_RESERVED_MIN VARCHAR(256) NOT NULL,
PCT_RESERVED_MAX VARCHAR(256) NOT NULL,
RESERVED_SPACE_MIN VARCHAR(256) NOT NULL,
RESERVED_SPACE_MAX VARCHAR(256) NOT NULL,
DATA_SPACE_MIN VARCHAR(256) NOT NULL,
DATA_SPACE_MAX VARCHAR(256) NOT NULL,
INDEX_SPACE_MIN VARCHAR(256) NOT NULL,
INDEX_SPACE_MAX VARCHAR(256) NOT NULL,
UNUSED_SPACE_MIN VARCHAR(256) NOT NULL,
UNUSED_SPACE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybSpaceTest_THRESH ADD constraint PK_SybSpaceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSpaceTest_THRESH ON SybSpaceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTasksTest;
CREATE TABLE SybTasksTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CONNECTION_OPEN_RATE DECIMAL(20,4) NOT NULL,
CONNECTION_OPEN_RATE_ST varchar(32) NOT NULL,
TASK_SWITCH_RATE DECIMAL(20,4) NOT NULL,
TASK_SWITCH_RATE_ST varchar(32) NOT NULL);

ALTER TABLE SybTasksTest ADD constraint PK_SybTasksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybTasksTest ON SybTasksTest
(
	 MSMT_TIME
);

DROP TABLE SybTasksTest_TREND;
CREATE TABLE SybTasksTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CONNECTION_OPEN_RATE_MIN DECIMAL(20,4) NOT NULL,
CONNECTION_OPEN_RATE_MAX DECIMAL(20,4) NOT NULL,
CONNECTION_OPEN_RATE_STCNT varchar(32) NOT NULL,
TASK_SWITCH_RATE_MIN DECIMAL(20,4) NOT NULL,
TASK_SWITCH_RATE_MAX DECIMAL(20,4) NOT NULL,
TASK_SWITCH_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybTasksTest_TREND ADD constraint PK_SybTasksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTasksTest_THRESH;
CREATE TABLE SybTasksTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CONNECTION_OPEN_RATE_MIN VARCHAR(256) NOT NULL,
CONNECTION_OPEN_RATE_MAX VARCHAR(256) NOT NULL,
TASK_SWITCH_RATE_MIN VARCHAR(256) NOT NULL,
TASK_SWITCH_RATE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybTasksTest_THRESH ADD constraint PK_SybTasksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTasksTest_THRESH ON SybTasksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxLogTest;
CREATE TABLE SybTxLogTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
ULC_LOG_WRITES DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITES_ST varchar(32) NOT NULL,
ULC_LOG_WRITE_WAITS DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_ST varchar(32) NOT NULL,
ULC_FLUSHES DECIMAL(20,4) NOT NULL,
ULC_FLUSHES_ST varchar(32) NOT NULL,
ULC_FLUSH_WAITS DECIMAL(20,4) NOT NULL,
ULC_FLUSH_WAITS_ST varchar(32) NOT NULL,
MAX_ULC_SIZE DECIMAL(20,4) NOT NULL,
MAX_ULC_SIZE_ST varchar(32) NOT NULL,
LOG_ALLOCATIONS DECIMAL(20,4) NOT NULL,
LOG_ALLOCATIONS_ST varchar(32) NOT NULL,
TRANSACTION_LOG_WRITES DECIMAL(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_ST varchar(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE DECIMAL(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_ST varchar(32) NOT NULL);

ALTER TABLE SybTxLogTest ADD constraint PK_SybTxLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybTxLogTest ON SybTxLogTest
(
	 MSMT_TIME
);
DROP TABLE SybTxLogTest_TREND;
CREATE TABLE SybTxLogTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ULC_LOG_WRITES_MIN DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITES_MAX DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITES_STCNT varchar(32) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_STCNT varchar(32) NOT NULL,
ULC_FLUSHES_MIN DECIMAL(20,4) NOT NULL,
ULC_FLUSHES_MAX DECIMAL(20,4) NOT NULL,
ULC_FLUSHES_STCNT varchar(32) NOT NULL,
ULC_FLUSH_WAITS_MIN DECIMAL(20,4) NOT NULL,
ULC_FLUSH_WAITS_MAX DECIMAL(20,4) NOT NULL,
ULC_FLUSH_WAITS_STCNT varchar(32) NOT NULL,
MAX_ULC_SIZE_MIN DECIMAL(20,4) NOT NULL,
MAX_ULC_SIZE_MAX DECIMAL(20,4) NOT NULL,
MAX_ULC_SIZE_STCNT varchar(32) NOT NULL,
LOG_ALLOCATIONS_MIN DECIMAL(20,4) NOT NULL,
LOG_ALLOCATIONS_MAX DECIMAL(20,4) NOT NULL,
LOG_ALLOCATIONS_STCNT varchar(32) NOT NULL,
TRANSACTION_LOG_WRITES_MIN DECIMAL(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_MAX DECIMAL(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_STCNT varchar(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN DECIMAL(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX DECIMAL(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybTxLogTest_TREND ADD constraint PK_SybTxLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxLogTest_THRESH;
CREATE TABLE SybTxLogTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ULC_LOG_WRITES_MIN VARCHAR(256) NOT NULL,
ULC_LOG_WRITES_MAX VARCHAR(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN VARCHAR(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX VARCHAR(256) NOT NULL,
ULC_FLUSHES_MIN VARCHAR(256) NOT NULL,
ULC_FLUSHES_MAX VARCHAR(256) NOT NULL,
ULC_FLUSH_WAITS_MIN VARCHAR(256) NOT NULL,
ULC_FLUSH_WAITS_MAX VARCHAR(256) NOT NULL,
MAX_ULC_SIZE_MIN VARCHAR(256) NOT NULL,
MAX_ULC_SIZE_MAX VARCHAR(256) NOT NULL,
LOG_ALLOCATIONS_MIN VARCHAR(256) NOT NULL,
LOG_ALLOCATIONS_MAX VARCHAR(256) NOT NULL,
TRANSACTION_LOG_WRITES_MIN VARCHAR(256) NOT NULL,
TRANSACTION_LOG_WRITES_MAX VARCHAR(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN VARCHAR(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybTxLogTest_THRESH ADD constraint PK_SybTxLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxLogTest_THRESH ON SybTxLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxTest;
CREATE TABLE SybTxTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
COMMITTED_TRANSACTIONS DECIMAL(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_ST varchar(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS DECIMAL(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_ST varchar(32) NOT NULL,
INSERTS DECIMAL(20,4) NOT NULL,
INSERTS_ST varchar(32) NOT NULL,
UPDATES DECIMAL(20,4) NOT NULL,
UPDATES_ST varchar(32) NOT NULL,
DELETES DECIMAL(20,4) NOT NULL,
DELETES_ST varchar(32) NOT NULL);

ALTER TABLE SybTxTest ADD constraint PK_SybTxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybTxTest ON SybTxTest
(
	 MSMT_TIME
);
DROP TABLE SybTxTest_TREND;
CREATE TABLE SybTxTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
COMMITTED_TRANSACTIONS_MIN DECIMAL(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_MAX DECIMAL(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_STCNT varchar(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN DECIMAL(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX DECIMAL(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_STCNT varchar(32) NOT NULL,
INSERTS_MIN DECIMAL(20,4) NOT NULL,
INSERTS_MAX DECIMAL(20,4) NOT NULL,
INSERTS_STCNT varchar(32) NOT NULL,
UPDATES_MIN DECIMAL(20,4) NOT NULL,
UPDATES_MAX DECIMAL(20,4) NOT NULL,
UPDATES_STCNT varchar(32) NOT NULL,
DELETES_MIN DECIMAL(20,4) NOT NULL,
DELETES_MAX DECIMAL(20,4) NOT NULL,
DELETES_STCNT varchar(32) NOT NULL);

ALTER TABLE SybTxTest_TREND ADD constraint PK_SybTxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxTest_THRESH;
CREATE TABLE SybTxTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
COMMITTED_TRANSACTIONS_MIN VARCHAR(256) NOT NULL,
COMMITTED_TRANSACTIONS_MAX VARCHAR(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN VARCHAR(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX VARCHAR(256) NOT NULL,
INSERTS_MIN VARCHAR(256) NOT NULL,
INSERTS_MAX VARCHAR(256) NOT NULL,
UPDATES_MIN VARCHAR(256) NOT NULL,
UPDATES_MAX VARCHAR(256) NOT NULL,
DELETES_MIN VARCHAR(256) NOT NULL,
DELETES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybTxTest_THRESH ADD constraint PK_SybTxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxTest_THRESH ON SybTxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSysProcessTest;
CREATE TABLE SybSysProcessTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_PROCESSES decimal(20,4) NOT NULL,
TOTAL_PROCESSES_ST varchar(32) NOT NULL,
BACKGROUND_PROCESSES decimal(20,4) NOT NULL,
BACKGROUND_PROCESSES_ST varchar(32) NOT NULL,
RUNNING_PROCESSES decimal(20,4) NOT NULL,
RUNNING_PROCESSES_ST varchar(32) NOT NULL,
SLEEPING_PROCESSES decimal(20,4) NOT NULL,
SLEEPING_PROCESSES_ST varchar(32) NOT NULL,
INFECTED_PROCESSES decimal(20,4) NOT NULL,
INFECTED_PROCESSES_ST varchar(32) NOT NULL,
BLOCKED_PROCESSES decimal(20,4) NOT NULL,
BLOCKED_PROCESSES_ST varchar(32) NOT NULL,
REMOTE_PROCESSES decimal(20,4) NOT NULL,
REMOTE_PROCESSES_ST varchar(32) NOT NULL,
STOPPED_PROCESSES decimal(20,4) NOT NULL,
STOPPED_PROCESSES_ST varchar(32) NOT NULL);

ALTER TABLE SybSysProcessTest ADD constraint PK_SybSysProcessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybSysProcessTest ON SybSysProcessTest
(
	 MSMT_TIME
);
DROP TABLE SybSysProcessTest_TREND;
CREATE TABLE SybSysProcessTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_PROCESSES_MIN decimal(20,4) NOT NULL,
TOTAL_PROCESSES_MAX decimal(20,4) NOT NULL,
TOTAL_PROCESSES_STCNT varchar(32) NOT NULL,
BACKGROUND_PROCESSES_MIN decimal(20,4) NOT NULL,
BACKGROUND_PROCESSES_MAX decimal(20,4) NOT NULL,
BACKGROUND_PROCESSES_STCNT varchar(32) NOT NULL,
RUNNING_PROCESSES_MIN decimal(20,4) NOT NULL,
RUNNING_PROCESSES_MAX decimal(20,4) NOT NULL,
RUNNING_PROCESSES_STCNT varchar(32) NOT NULL,
SLEEPING_PROCESSES_MIN decimal(20,4) NOT NULL,
SLEEPING_PROCESSES_MAX decimal(20,4) NOT NULL,
SLEEPING_PROCESSES_STCNT varchar(32) NOT NULL,
INFECTED_PROCESSES_MIN decimal(20,4) NOT NULL,
INFECTED_PROCESSES_MAX decimal(20,4) NOT NULL,
INFECTED_PROCESSES_STCNT varchar(32) NOT NULL,
BLOCKED_PROCESSES_MIN decimal(20,4) NOT NULL,
BLOCKED_PROCESSES_MAX decimal(20,4) NOT NULL,
BLOCKED_PROCESSES_STCNT varchar(32) NOT NULL,
REMOTE_PROCESSES_MIN decimal(20,4) NOT NULL,
REMOTE_PROCESSES_MAX decimal(20,4) NOT NULL,
REMOTE_PROCESSES_STCNT varchar(32) NOT NULL,
STOPPED_PROCESSES_MIN decimal(20,4) NOT NULL,
STOPPED_PROCESSES_MAX decimal(20,4) NOT NULL,
STOPPED_PROCESSES_STCNT varchar(32) NOT NULL);

ALTER TABLE SybSysProcessTest_TREND ADD constraint PK_SybSysProcessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSysProcessTest_THRESH;
CREATE TABLE SybSysProcessTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_PROCESSES_MIN VARCHAR(256) NOT NULL,
TOTAL_PROCESSES_MAX VARCHAR(256) NOT NULL,
BACKGROUND_PROCESSES_MIN VARCHAR(256) NOT NULL,
BACKGROUND_PROCESSES_MAX VARCHAR(256) NOT NULL,
RUNNING_PROCESSES_MIN VARCHAR(256) NOT NULL,
RUNNING_PROCESSES_MAX VARCHAR(256) NOT NULL,
SLEEPING_PROCESSES_MIN VARCHAR(256) NOT NULL,
SLEEPING_PROCESSES_MAX VARCHAR(256) NOT NULL,
INFECTED_PROCESSES_MIN VARCHAR(256) NOT NULL,
INFECTED_PROCESSES_MAX VARCHAR(256) NOT NULL,
BLOCKED_PROCESSES_MIN VARCHAR(256) NOT NULL,
BLOCKED_PROCESSES_MAX VARCHAR(256) NOT NULL,
REMOTE_PROCESSES_MIN VARCHAR(256) NOT NULL,
REMOTE_PROCESSES_MAX VARCHAR(256) NOT NULL,
STOPPED_PROCESSES_MIN VARCHAR(256) NOT NULL,
STOPPED_PROCESSES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybSysProcessTest_THRESH ADD constraint PK_SybSysProcessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSysProcessTest_THRESH ON SybSysProcessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ActiveDirectoryTest ;

CREATE TABLE ActiveDirectoryTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	schemaCacheHitRatio		decimal(20,4) NOT NULL,
	schemaCacheHitRatio_ST		varchar(32) NOT NULL,
	notifyQSize			decimal(20,4) not null,
	notifyQSize_ST			varchar(32) not null,
	currThreads			decimal(20,4) not null,
	currThreads_ST			varchar(32) not null,
	directoryWrites			decimal(20,4) not null,
	directoryWrites_ST		varchar(32) not null,
	kerberosAuth			decimal(20,4) not null,
	kerberosAuth_ST			varchar(32) not null,
	ntlmAuth			decimal(20,4) not null,
	ntlmAuth_ST			varchar(32) not null,
	ticketReq			decimal(20,4) not null,
	ticketReq_ST			varchar(32) not null,
	authSrvReq			decimal(20,4) not null,
	authSrvReq_ST			varchar(32) not null,
	ldapSessions			decimal(20,4) not null,
	ldapSessions_ST			varchar(32) not null
);

ALTER TABLE ActiveDirectoryTest ADD constraint PK_ActiveDirectory
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ActiveDirectoryTest ON ActiveDirectoryTest
(
	 MSMT_TIME
);
DROP TABLE   ActiveDirectoryTest_TREND ;

CREATE TABLE ActiveDirectoryTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	schemaCacheHitRatio_MIN		decimal(20,4) NOT NULL,
	schemaCacheHitRatio_MAX		decimal(20,4) NOT NULL,
	schemaCacheHitRatio_STCNT	varchar(32) NOT NULL,
	notifyQSize_MIN			decimal(20,4) not null,
	notifyQSize_MAX			decimal(20,4) not null,
	notifyQSize_STCNT		varchar(32) not null,
	currThreads_MIN			decimal(20,4) not null,
	currThreads_MAX			decimal(20,4) not null,
	currThreads_STCNT		varchar(32) not null,
	directoryWrites_MIN		decimal(20,4) not null,
	directoryWrites_MAX		decimal(20,4) not null,
	directoryWrites_STCNT		varchar(32) not null,
	kerberosAuth_MIN		decimal(20,4) not null,
	kerberosAuth_MAX		decimal(20,4) not null,
	kerberosAuth_STCNT		varchar(32) not null,
	ntlmAuth_MIN			decimal(20,4) not null,
	ntlmAuth_MAX			decimal(20,4) not null,
	ntlmAuth_STCNT			varchar(32) not null,
	ticketReq_MIN			decimal(20,4) not null,
	ticketReq_MAX			decimal(20,4) not null,
	ticketReq_STCNT			varchar(32) not null,
	authSrvReq_MIN			decimal(20,4) not null,
	authSrvReq_MAX			decimal(20,4) not null,
	authSrvReq_STCNT		varchar(32) not null,
	ldapSessions_MIN		decimal(20,4) not null,
	ldapSessions_MAX		decimal(20,4) not null,
	ldapSessions_STCNT		varchar(32) not null
	
);

ALTER TABLE ActiveDirectoryTest_TREND ADD constraint PK_ActiveDirectoryTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ActiveDirectoryTest_THRESH ;

CREATE TABLE ActiveDirectoryTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	SCHEMACACHEHITRATIO_MIN	VARCHAR(256)	 NOT NULL,
	SCHEMACACHEHITRATIO_MAX	VARCHAR(256)	 NOT NULL,
	NOTIFYQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	NOTIFYQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	CURRTHREADS_MIN	VARCHAR(256)	 NOT NULL,
	CURRTHREADS_MAX	VARCHAR(256)	 NOT NULL,
	DIRECTORYWRITES_MIN	VARCHAR(256)	 NOT NULL,
	DIRECTORYWRITES_MAX	VARCHAR(256)	 NOT NULL,
	KERBEROSAUTH_MIN	VARCHAR(256)	 NOT NULL,
	KERBEROSAUTH_MAX	VARCHAR(256)	 NOT NULL,
	NTLMAUTH_MIN	VARCHAR(256)	 NOT NULL,
	NTLMAUTH_MAX	VARCHAR(256)	 NOT NULL,
	TICKETREQ_MIN	VARCHAR(256)	 NOT NULL,
	TICKETREQ_MAX	VARCHAR(256)	 NOT NULL,
	AUTHSRVREQ_MIN	VARCHAR(256)	 NOT NULL,
	AUTHSRVREQ_MAX	VARCHAR(256)	 NOT NULL,
	LDAPSESSIONS_MIN	VARCHAR(256)	 NOT NULL,
	LDAPSESSIONS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ActiveDirectoryTest_THRESH ADD constraint PK_ActiveDirectoryTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ActiveDirectoryTest_THRESH ON ActiveDirectoryTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE ReplicationTest ;

CREATE TABLE ReplicationTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	in_Obj_Appld_rate		decimal(20,4) NOT NULL,
	in_Obj_Appld_rate_ST		varchar(32) NOT NULL,
	in_Prop_Appld_rate		decimal(20,4) not null,
	in_Prop_Appld_rate_ST		varchar(32) not null,
	in_Obj_Filtrd_rate		decimal(20,4) not null,
	in_Obj_Filtrd_rate_ST		varchar(32) not null,
	in_Prop_Filtrd_rate		decimal(20,4) not null,
	in_Prop_Filtrd_rate_ST		varchar(32) not null,
	out_Obj_Filtrd_rate		decimal(20,4) not null,
	out_Obj_Filtrd_rate_ST		varchar(32) not null,
	pending_Rep_Sync		decimal(20,4) not null,
	pending_Rep_Sync_ST		varchar(32) not null
);

ALTER TABLE ReplicationTest ADD constraint PK_Replication
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ReplicationTest ON ReplicationTest
(
	 MSMT_TIME
);
DROP TABLE   ReplicationTest_TREND ;

CREATE TABLE ReplicationTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	in_Obj_Appld_rate_MIN		decimal(20,4) NOT NULL,
	in_Obj_Appld_rate_MAX		decimal(20,4) NOT NULL,
	in_Obj_Appld_rate_STCNT		varchar(32) NOT NULL,
	in_Prop_Appld_rate_MIN		decimal(20,4) not null,
	in_Prop_Appld_rate_MAX		decimal(20,4) not null,
	in_Prop_Appld_rate_STCNT	varchar(32) not null,
	in_Obj_Filtrd_rate_MIN		decimal(20,4) not null,
	in_Obj_Filtrd_rate_MAX		decimal(20,4) not null,
	in_Obj_Filtrd_rate_STCNT	varchar(32) not null,
	in_Prop_Filtrd_rate_MIN		decimal(20,4) not null,
	in_Prop_Filtrd_rate_MAX		decimal(20,4) not null,
	in_Prop_Filtrd_rate_STCNT	varchar(32) not null,
	out_Obj_Filtrd_rate_MIN		decimal(20,4) not null,
	out_Obj_Filtrd_rate_MAX		decimal(20,4) not null,
	out_Obj_Filtrd_rate_STCNT	varchar(32) not null,
	pending_Rep_Sync_MIN		decimal(20,4) not null,
	pending_Rep_Sync_MAX		decimal(20,4) not null,
	pending_Rep_Sync_STCNT		varchar(32) not null
	
);

ALTER TABLE ReplicationTest_TREND ADD constraint PK_ReplicationTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ReplicationTest_THRESH ;

CREATE TABLE ReplicationTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	IN_OBJ_APPLD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_OBJ_APPLD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	PENDING_REP_SYNC_MIN	VARCHAR(256)	 NOT NULL,
	PENDING_REP_SYNC_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ReplicationTest_THRESH ADD constraint PK_ReplicationTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ReplicationTest_THRESH ON ReplicationTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE IntraSiteReplTest ;

CREATE TABLE IntraSiteReplTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	in_rate			decimal(20,4) NOT NULL,
	in_rate_ST			varchar(32) NOT NULL,
	out_rate			decimal(20,4) not null,
	out_rate_ST			varchar(32) not null
);

ALTER TABLE IntraSiteReplTest ADD constraint PK_IntraSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_IntraSiteReplTest ON IntraSiteReplTest
(
	 MSMT_TIME
);
DROP TABLE   IntraSiteReplTest_TREND ;

CREATE TABLE IntraSiteReplTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	in_rate_MIN			decimal(20,4) NOT NULL,
	in_rate_MAX			decimal(20,4) NOT NULL,
	in_rate_STCNT		varchar(32) NOT NULL,
	out_rate_MIN		decimal(20,4) not null,
	out_rate_MAX		decimal(20,4) not null,
	out_rate_STCNT		varchar(32) not null
	
);

ALTER TABLE IntraSiteReplTest_TREND ADD constraint PK_IntraSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IntraSiteReplTest_THRESH ;

CREATE TABLE IntraSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	IN_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE IntraSiteReplTest_THRESH ADD constraint PK_IntraSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IntraSiteReplTest_THRESH ON IntraSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE InterSiteReplTest ;

CREATE TABLE InterSiteReplTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	in_rate				decimal(20,4) NOT NULL,
	in_rate_ST			varchar(32) NOT NULL,
	out_rate			decimal(20,4) not null,
	out_rate_ST			varchar(32) not null
);

ALTER TABLE InterSiteReplTest ADD constraint PK_InterSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_InterSiteReplTest ON InterSiteReplTest
(
	 MSMT_TIME
);
DROP TABLE   InterSiteReplTest_TREND ;

CREATE TABLE InterSiteReplTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	in_rate_MIN			decimal(20,4) NOT NULL,
	in_rate_MAX			decimal(20,4) NOT NULL,
	in_rate_STCNT		varchar(32) NOT NULL,
	out_rate_MIN		decimal(20,4) not null,
	out_rate_MAX		decimal(20,4) not null,
	out_rate_STCNT		varchar(32) not null
	
);

ALTER TABLE InterSiteReplTest_TREND ADD constraint PK_InterSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterSiteReplTest_THRESH ;

CREATE TABLE InterSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	IN_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE InterSiteReplTest_THRESH ADD constraint PK_InterSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterSiteReplTest_THRESH ON InterSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          


DROP TABLE DocSubmitTest ;

CREATE TABLE DocSubmitTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	submit_Rate			decimal(20,4) NOT NULL,
	submit_Rate_ST			varchar(32) NOT NULL,
	mapped_Rate			decimal(20,4) NOT NULL,
	mapped_Rate_ST			varchar(32) NOT NULL,
	parsed_Rate			decimal(20,4) NOT NULL,
	parsed_Rate_ST			varchar(32) NOT NULL,
	process_Rate			decimal(20,4) NOT NULL,
	process_Rate_ST			varchar(32) NOT NULL
	
);

ALTER TABLE DocSubmitTest ADD constraint PK_DOCSUBMIT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DocSubmitTest ON DocSubmitTest
(
	 MSMT_TIME
);
DROP TABLE   DocSubmitTest_TREND ;

CREATE TABLE DocSubmitTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	submit_Rate_MIN			decimal(20,4) NOT NULL,
	submit_Rate_MAX			decimal(20,4) NOT NULL,
	submit_Rate_STCNT		varchar(32) NOT NULL,
	mapped_Rate_MIN		decimal(20,4) NOT NULL,
	mapped_Rate_MAX		decimal(20,4) NOT NULL,
	mapped_Rate_STCNT		varchar(32) NOT NULL,
	parsed_Rate_MIN		decimal(20,4) NOT NULL,
	parsed_Rate_MAX		decimal(20,4) NOT NULL,
	parsed_Rate_STCNT		varchar(32) NOT NULL,
	process_Rate_MIN		decimal(20,4) NOT NULL,
	process_Rate_MAX		decimal(20,4) NOT NULL,
	process_Rate_STCNT		varchar(32) NOT NULL
	
);

ALTER TABLE DocSubmitTest_TREND ADD constraint PK_DocSubmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocSubmitTest_THRESH ;

CREATE TABLE DocSubmitTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	SUBMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	SUBMIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	MAPPED_RATE_MIN	VARCHAR(256)	 NOT NULL,
	MAPPED_RATE_MAX	VARCHAR(256)	 NOT NULL,
	PARSED_RATE_MIN	VARCHAR(256)	 NOT NULL,
	PARSED_RATE_MAX	VARCHAR(256)	 NOT NULL,
	PROCESS_RATE_MIN	VARCHAR(256)	 NOT NULL,
	PROCESS_RATE_MAX	VARCHAR(256)	 NOT NULL
	
		
);

ALTER TABLE DocSubmitTest_THRESH ADD constraint PK_DocSubmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocSubmitTest_THRESH ON DocSubmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE   DocReceiveTest ;

CREATE TABLE DocReceiveTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	receive_Rate			decimal(20,4) NOT NULL,
	receive_Rate_ST			varchar(32) NOT NULL
	
);

ALTER TABLE  DocReceiveTest ADD constraint PK_DocReceiveTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DocReceiveTest ON DocReceiveTest
(
	 MSMT_TIME
);
DROP TABLE   DocReceiveTest_TREND ;

CREATE TABLE DocReceiveTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	receive_Rate_MIN		decimal(20,4) NOT NULL,
	receive_Rate_MAX		decimal(20,4) NOT NULL,
	receive_Rate_STCNT		varchar(32) NOT NULL
	
);

ALTER TABLE DocReceiveTest_TREND ADD constraint PK_DocReceiveTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocReceiveTest_THRESH ;

CREATE TABLE DocReceiveTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	RECEIVE_RATE_MIN	VARCHAR(256)	 NOT NULL,
      	RECEIVE_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE DocReceiveTest_THRESH ADD constraint PK_DocReceiveTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocReceiveTest_THRESH ON DocReceiveTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          


DROP TABLE XChgMailRetrvlTest ;

CREATE TABLE XChgMailRetrvlTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	currPop3Conn			decimal(20,4) not null,
	currPop3Conn_st			varchar(32) not null,
	currImapConn			decimal(20,4) not null,
	currImapConn_st			varchar(32) not null,
	pop3AuthFailures		decimal(20,4) not null,
	pop3AuthFailures_st		varchar(32) not null,
	imapAuthFailures		decimal(20,4) not null,
	imapAuthFailures_st		varchar(32) not null
);

ALTER TABLE XChgMailRetrvlTest ADD constraint PK_XChgMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgMailRetrvlTest ON XChgMailRetrvlTest
(
	 MSMT_TIME
);
DROP TABLE   XChgMailRetrvlTest_TREND ;

CREATE TABLE XChgMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	currPop3Conn_min		decimal(20,4) not null,
	currPop3Conn_max		decimal(20,4) not null,
	currPop3Conn_stcnt		varchar(32) not null,
	currImapConn_min		decimal(20,4) not null,
	currImapConn_max		decimal(20,4) not null,
	currImapConn_stcnt		varchar(32) not null,
	pop3AuthFailures_min		decimal(20,4) not null,
	pop3AuthFailures_max		decimal(20,4) not null,
	pop3AuthFailures_stcnt		varchar(32) not null,
	imapAuthFailures_min		decimal(20,4) not null,
	imapAuthFailures_max		decimal(20,4) not null,
	imapAuthFailures_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgMailRetrvlTest_TREND ADD constraint PK_XChgMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailRetrvlTest_THRESH ;

CREATE TABLE XChgMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	CURRPOP3CONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR(256)	 NOT NULL,
	POP3AUTHFAILURES_MIN	VARCHAR(256)	 NOT NULL,
	POP3AUTHFAILURES_MAX	VARCHAR(256)	 NOT NULL,
	IMAPAUTHFAILURES_MIN	VARCHAR(256)	 NOT NULL,
	IMAPAUTHFAILURES_MAX	VARCHAR(256)	 NOT NULL
	
	
);

ALTER TABLE XChgMailRetrvlTest_THRESH ADD constraint PK_XChgMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailRetrvlTest_THRESH ON XChgMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE IISXChgLayerTest ;

CREATE TABLE IISXChgLayerTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	clientQSize			decimal(20,4) not null,
	clientQSize_st		varchar(32) not null,
	rpcOperationsRate		decimal(20,4) not null,
	rpcOperationsRate_st		varchar(32) not null
	
);

ALTER TABLE IISXChgLayerTest ADD constraint PK_IISXChgLayerTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_IISXChgLayerTest ON IISXChgLayerTest
(
	 MSMT_TIME
);
DROP TABLE   IISXChgLayerTest_TREND ;

CREATE TABLE IISXChgLayerTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	clientQSize_min		decimal(20,4) not null,
	clientQSize_max		decimal(20,4) not null,
	clientQSize_stcnt		varchar(32) not null,
	rpcOperationsRate_min		decimal(20,4) not null,
	rpcOperationsRate_max		decimal(20,4) not null,
	rpcOperationsRate_stcnt		varchar(32) not null
	
);

ALTER TABLE IISXChgLayerTest_TREND ADD constraint PK_IISXChgLayerTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IISXChgLayerTest_THRESH ;

CREATE TABLE IISXChgLayerTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	CLIENTQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	CLIENTQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	RPCOPERATIONSRATE_MIN	VARCHAR(256)	 NOT NULL,
	RPCOPERATIONSRATE_MAX	VARCHAR(256)	 NOT NULL
	
	
	
);

ALTER TABLE IISXChgLayerTest_THRESH ADD constraint PK_IISXChgLayerTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IISXChgLayerTest_THRESH ON IISXChgLayerTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);           

DROP TABLE XChgDBTest ;

CREATE TABLE XChgDBTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	dbCacheHit			decimal(20,4) not null,
	dbCacheHit_ST			varchar(32) not null,
	dbTablesCacheHit		decimal(20,4) not null,
	dbTablesCacheHit_st		varchar(32) not null,
	logRecrdWaitingRate		decimal(20,4) not null,
	logRecrdWaitingRate_st		varchar(32) not null,
	logThreadWaiting		decimal(20,4) not null,
	logThreadWaiting_st		varchar(32) not null
);

ALTER TABLE XChgDBTest ADD constraint PK_XChgDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgDBTest ON XChgDBTest
(
	 MSMT_TIME
);
DROP TABLE   XChgDBTest_TREND ;

CREATE TABLE XChgDBTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	dbCacheHit_min			decimal(20,4) not null,
	dbCacheHit_max			decimal(20,4) not null,
	dbCacheHit_stcnt		varchar(32) not null,
	dbTablesCacheHit_min		decimal(20,4) not null,
	dbTablesCacheHit_max		decimal(20,4) not null,
	dbTablesCacheHit_stcnt		varchar(32) not null,
	logRecrdWaitingRate_min		decimal(20,4) not null,
	logRecrdWaitingRate_max		decimal(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar(32) not null,
	logThreadWaiting_min		decimal(20,4) not null,
	logThreadWaiting_max		decimal(20,4) not null,
	logThreadWaiting_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgDBTest_TREND ADD constraint PK_XChgDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgDBTest_THRESH ;

CREATE TABLE XChgDBTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	DBCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgDBTest_THRESH ADD constraint PK_XChgDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgDBTest_THRESH ON XChgDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE XChgMailXferTest ;

CREATE TABLE XChgMailXferTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	localQSize			decimal(20,4) not null,
	localQSize_st			varchar(32) not null,
	remoteQSize			decimal(20,4) not null,
	remoteQSize_st			varchar(32) not null,
	currSmtpConn			decimal(20,4) not null,
	currSmtpConn_st			varchar(32) not null,
	badMailMsgs			decimal(20,4) not null,
	badMailMsgs_st			varchar(32) not null,
	dataRcvdRate			decimal(20,4) not null,
	dataRcvdRate_st			varchar(32) not null,
	dataSentRate			decimal(20,4) not null,
	dataSentRate_st			varchar(32) not null,
	avgRetryMsgDelvry		decimal(20,4) not null,
	avgRetryMsgDelvry_st		varchar(32) not null,
	avgRetryMsgSent			decimal(20,4) not null,
	avgRetryMsgSent_st		varchar(32) not null
	
);

ALTER TABLE XChgMailXferTest ADD constraint PK_XChgMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgMailXferTest ON XChgMailXferTest
(
	 MSMT_TIME
);
DROP TABLE   XChgMailXferTest_TREND ;

CREATE TABLE XChgMailXferTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	localQSize_min			decimal(20,4) not null,
	localQSize_max			decimal(20,4) not null,
	localQSize_stcnt		varchar(32) not null,
	remoteQSize_min			decimal(20,4) not null,
	remoteQSize_max			decimal(20,4) not null,
	remoteQSize_stcnt		varchar(32) not null,
	currSmtpConn_min		decimal(20,4) not null,
	currSmtpConn_max		decimal(20,4) not null,
	currSmtpConn_stcnt		varchar(32) not null,
	badMailMsgs_min			decimal(20,4) not null,
	badMailMsgs_max			decimal(20,4) not null,
	badMailMsgs_stcnt		varchar(32) not null,
	dataRcvdRate_min		decimal(20,4) not null,
	dataRcvdRate_max		decimal(20,4) not null,
	dataRcvdRate_stcnt		varchar(32) not null,
	dataSentRate_min		decimal(20,4) not null,
	dataSentRate_max		decimal(20,4) not null,
	dataSentRate_stcnt		varchar(32) not null,
	avgRetryMsgDelvry_min		decimal(20,4) not null,
	avgRetryMsgDelvry_max		decimal(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar(32) not null,
	avgRetryMsgSent_min		decimal(20,4) not null,
	avgRetryMsgSent_max		decimal(20,4) not null,
	avgRetryMsgSent_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgMailXferTest_TREND ADD constraint PK_XChgMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailXferTest_THRESH ;

CREATE TABLE XChgMailXferTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	LOCALQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR(256)	 NOT NULL,
	BADMAILMSGS_MIN	VARCHAR(256)	 NOT NULL,
	BADMAILMSGS_MAX	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgMailXferTest_THRESH ADD constraint PK_XChgMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailXferTest_THRESH ON XChgMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE NewsGroupTest ;

CREATE TABLE NewsGroupTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	logonFailureRate		decimal(20,4) not null,
	logonFailureRate_st		varchar(32) not null,
	dataRcvdRate			decimal(20,4) not null,
	dataRcvdRate_st			varchar(32) not null,
	dataSentRate			decimal(20,4) not null,
	dataSentRate_st			varchar(32) not null
	
);

ALTER TABLE NewsGroupTest ADD constraint PK_NewsGroupTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NewsGroupTest ON NewsGroupTest
(
	 MSMT_TIME
);
DROP TABLE   NewsGroupTest_TREND ;

CREATE TABLE NewsGroupTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	logonFailureRate_min		decimal(20,4) not null,
	logonFailureRate_max		decimal(20,4) not null,
	logonFailureRate_stcnt		varchar(32) not null,
	dataRcvdRate_min		decimal(20,4) not null,
	dataRcvdRate_max		decimal(20,4) not null,
	dataRcvdRate_stcnt		varchar(32) not null,
	dataSentRate_min		decimal(20,4) not null,
	dataSentRate_max		decimal(20,4) not null,
	dataSentRate_stcnt		varchar(32) not null
	
	
);

ALTER TABLE NewsGroupTest_TREND ADD constraint PK_NewsGroupTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   NewsGroupTest_THRESH ;

CREATE TABLE NewsGroupTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	LOGONFAILURERATE_MIN	VARCHAR(256)	 NOT NULL,
	LOGONFAILURERATE_MAX	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE NewsGroupTest_THRESH ADD constraint PK_NewsGroupTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_NewsGroupTest_THRESH ON NewsGroupTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          


DROP TABLE XChgCacheTest;

CREATE TABLE XChgCacheTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	cacheHitRatio		decimal(20,4) not null,
	cacheHitRatio_ST	varchar(32) not null
	
	
);

ALTER TABLE XChgCacheTest ADD constraint PK_XChgCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgCacheTest ON XChgCacheTest
(
	 MSMT_TIME
);
	
DROP TABLE   XChgCacheTest_TREND;

CREATE TABLE XChgCacheTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	cacheHitRatio_min		decimal(20,4) not null,
	cacheHitRatio_max		decimal(20,4) not null,
	cacheHitRatio_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgCacheTest_TREND ADD constraint PK_XChgCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgCacheTest_THRESH;

CREATE TABLE XChgCacheTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CACHEHITRATIO_MIN	VARCHAR(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgCacheTest_THRESH ADD constraint PK_XChgCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgCacheTest_THRESH ON XChgCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE XChgStoreTest;

CREATE TABLE XChgStoreTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	currUsers			decimal(20,4) not null,
	currUsers_st		varchar(32) not null,
	mailSendQSize		decimal(20,4) not null,
	mailSendQSize_st	varchar(32) not null,
	mailRcvdQSize		decimal(20,4) not null,
	mailRcvdQSize_st	varchar(32) not null,
	mailSentRate		decimal(20,4) not null,
	mailSentRate_st		varchar(32) not null,
	mailOpensRate		decimal(20,4) not null,
	mailOpensRate_st	varchar(32) not null,
	folderOpensRate		decimal(20,4) not null,
	folderOpensRate_st	varchar(32) not null,
	avgMailDelvryTime	decimal(20,4) not null,
	avgMailDelvryTime_st	varchar(32) not null,
	avgMailLocalDelvryTime		decimal(20,4) not null,
	avgMailLocalDelvryTime_st		varchar(32) not null
	
);

ALTER TABLE XChgStoreTest ADD constraint PK_XChgStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgStoreTest ON XChgStoreTest
(
	 MSMT_TIME
);
	
DROP TABLE   XChgStoreTest_TREND;

CREATE TABLE XChgStoreTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	currUsers_min			decimal(20,4) not null,
	currUsers_max			decimal(20,4) not null,
	currUsers_stcnt			varchar(32) not null,
	mailSendQSize_min		decimal(20,4) not null,
	mailSendQSize_max		decimal(20,4) not null,
	mailSendQSize_stcnt		varchar(32) not null,
	mailRcvdQSize_min		decimal(20,4) not null,
	mailRcvdQSize_max		decimal(20,4) not null,
	mailRcvdQSize_stcnt		varchar(32) not null,
	mailSentRate_min		decimal(20,4) not null,
	mailSentRate_max		decimal(20,4) not null,
	mailSentRate_stcnt		varchar(32) not null,
	mailOpensRate_min		decimal(20,4) not null,
	mailOpensRate_max		decimal(20,4) not null,
	mailOpensRate_stcnt		varchar(32) not null,
	folderOpensRate_min		decimal(20,4) not null,
	folderOpensRate_max		decimal(20,4) not null,
	folderOpensRate_stcnt	varchar(32) not null,
	avgMailDelvryTime_min	decimal(20,4) not null,
	avgMailDelvryTime_max	decimal(20,4) not null,
	avgMailDelvryTime_stcnt	 varchar(32) not null,
	avgMailLocalDelvryTime_min		decimal(20,4) not null,
	avgMailLocalDelvryTime_max		decimal(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar(32) not null
	
);

ALTER TABLE XChgStoreTest_TREND ADD constraint PK_XChgStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgStoreTest_THRESH;

CREATE TABLE XChgStoreTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CURRUSERS_MIN	VARCHAR(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgStoreTest_THRESH ADD constraint PK_XChgStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgStoreTest_THRESH ON XChgStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE DOMINONETTEST;

CREATE TABLE DOMINONETTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	DATA_RCVD_RATE	 			decimal(20,4) 	NOT NULL,
	DATA_RCVD_RATE_ST 			varchar(32) 	NOT NULL,
	DATA_SENT_RATE		 		decimal(20,4) 	NOT NULL,
	DATA_SENT_RATE_ST 			varchar(32) 	NOT NULL,
	IN_SESSION_RATE 		 	decimal(20,4) 	NOT NULL,
	IN_SESSION_RATE_ST 			varchar(32) 	NOT NULL,
	OUT_SESSION_RATE			decimal(20,4) 	NOT NULL,
	OUT_SESSION_RATE_ST 		varchar(32) 	NOT NULL,
	DROP_SESSION_RATE			decimal(20,4) 	NOT NULL,
	DROP_SESSION_RATE_ST 		varchar(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT		decimal(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST ADD CONSTRAINT PK_DOMINONETTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DOMINONETTEST ON DOMINONETTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINONETTEST_TREND;
CREATE TABLE DOMINONETTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	DATA_RCVD_RATE_MIN	 			decimal(20,4) 	NOT NULL,
	DATA_RCVD_RATE_MAX 				varchar(32) 	NOT NULL,
	DATA_RCVD_RATE_STCNT			varchar(32) 	NOT NULL,
	DATA_SENT_RATE_MIN	 			decimal(20,4) 	NOT NULL,
	DATA_SENT_RATE_MAX 				varchar(32) 	NOT NULL,
	DATA_SENT_RATE_STCNT			varchar(32) 	NOT NULL,
	IN_SESSION_RATE_MIN	 			decimal(20,4) 	NOT NULL,
	IN_SESSION_RATE_MAX 			varchar(32) 	NOT NULL,
	IN_SESSION_RATE_STCNT			varchar(32) 	NOT NULL,
	OUT_SESSION_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	OUT_SESSION_RATE_MAX 			varchar(32) 	NOT NULL,
	OUT_SESSION_RATE_STCNT			varchar(32) 	NOT NULL,
	DROP_SESSION_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	DROP_SESSION_RATE_MAX 			varchar(32) 	NOT NULL,
	DROP_SESSION_RATE_STCNT			varchar(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN	 	decimal(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX 		varchar(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST_TREND ADD CONSTRAINT PK_DOMINONETTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINONETTEST_THRESH;
CREATE TABLE DOMINONETTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	DATA_RCVD_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_RCVD_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_SENT_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_SENT_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	IN_SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	IN_SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	OUT_SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	OUT_SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DROP_SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DROP_SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN	VARCHAR(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINONETTEST_THRESH ADD CONSTRAINT PK_DOMINONETTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINONETTEST_THRESH ON DOMINONETTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DOMINOMEMTEST;
CREATE TABLE DOMINOMEMTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	TOTAL_MEM_ALLOCATED	 		decimal(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_ST 		varchar(32) 	NOT NULL,
	MEM_ALLOC_PROCESS		 	decimal(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_ST 		varchar(32) 	NOT NULL,
	MEM_ALLOC_SHARED		 	decimal(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST ADD CONSTRAINT PK_DOMINOMEMTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX_DOMINOMEMTEST ON DOMINOMEMTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINOMEMTEST_TREND;
CREATE TABLE DOMINOMEMTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	TOTAL_MEM_ALLOCATED_MIN	 		decimal(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX 		varchar(32) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_STCNT		varchar(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	 		decimal(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX 			varchar(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_STCNT			varchar(32) 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	 		decimal(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_MAX 			varchar(32) 	NOT NULL,
	MEM_ALLOC_SHARED_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST_TREND ADD CONSTRAINT PK_DOMINOMEMTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMEMTEST_THRESH;
CREATE TABLE DOMINOMEMTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	TOTAL_MEM_ALLOCATED_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINOMEMTEST_THRESH ADD CONSTRAINT PK_DOMINOMEMTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMEMTEST_THRESH ON DOMINOMEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DOMINODBTEST;

CREATE TABLE DOMINODBTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	CACHE_CURR_ENTRIES	 		decimal(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_ST 		varchar(32) 	NOT NULL,
	CACHE_MAX_ENTRIES		 	decimal(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_ST 		varchar(32) 	NOT NULL,
	CACHE_HT_RATIO		 		decimal(20,4) 	NOT NULL,
	CACHE_HT_RATIO_ST 			varchar(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST ADD CONSTRAINT PK_DOMINODBTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DOMINODBTEST ON DOMINODBTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINODBTEST_TREND;
CREATE TABLE DOMINODBTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	CACHE_CURR_ENTRIES_MIN	 		decimal(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX 			varchar(32) 	NOT NULL,
	CACHE_CURR_ENTRIES_STCNT		varchar(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	 		decimal(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX 			varchar(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_STCNT			varchar(32) 	NOT NULL,
	CACHE_HT_RATIO_MIN	 			decimal(20,4) 	NOT NULL,
	CACHE_HT_RATIO_MAX 				varchar(32) 	NOT NULL,
	CACHE_HT_RATIO_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST_TREND ADD CONSTRAINT PK_DOMINODBTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINODBTEST_THRESH;
CREATE TABLE DOMINODBTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	CACHE_CURR_ENTRIES_MIN	VARCHAR(256)	 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX	VARCHAR(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	VARCHAR(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX	VARCHAR(256)	 	NOT NULL,
	CACHE_HT_RATIO_MIN	VARCHAR(256)	 	NOT NULL,
	CACHE_HT_RATIO_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINODBTEST_THRESH ADD CONSTRAINT PK_DOMINODBTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINODBTEST_THRESH ON DOMINODBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DOMINOMAILSTATSTEST;

CREATE TABLE DOMINOMAILSTATSTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	DELIVERED_MAIL_RATE	 		decimal(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_ST 		varchar(32) 	NOT NULL,
	PCT_DEAD_MAILS		 		decimal(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_ST 			varchar(32) 	NOT NULL,
	NUM_MAIL_WAITING 		 	decimal(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_ST 		varchar(32) 	NOT NULL,
	MAIL_DELIVERY_TIME			decimal(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_ST 		varchar(32) 	NOT NULL,
	PCT_TRANSFER_FAIL 			decimal(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_ST 		varchar(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV		decimal(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST ADD CONSTRAINT PK_DOMINOMAILSTATSTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_DOMINOMAILSTATSTEST ON DOMINOMAILSTATSTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINOMAILSTATSTEST_TREND;
CREATE TABLE DOMINOMAILSTATSTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	DELIVERED_MAIL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX 		varchar(32) 	NOT NULL,
	DELIVERED_MAIL_RATE_STCNT		varchar(32) 	NOT NULL,
	PCT_DEAD_MAILS_MIN	 			decimal(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_MAX 				varchar(32) 	NOT NULL,
	PCT_DEAD_MAILS_STCNT			varchar(32) 	NOT NULL,
	NUM_MAIL_WAITING_MIN	 		decimal(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_MAX 			varchar(32) 	NOT NULL,
	NUM_MAIL_WAITING_STCNT			varchar(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	 		decimal(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX 			varchar(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_STCNT		varchar(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	 		decimal(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX 			varchar(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_STCNT			varchar(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	 		decimal(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX 		varchar(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST_TREND ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMAILSTATSTEST_THRESH;
CREATE TABLE DOMINOMAILSTATSTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	DELIVERED_MAIL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MAX	VARCHAR(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX	VARCHAR(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	VARCHAR(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINOMAILSTATSTEST_THRESH ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMAILSTATSTEST_THRESH ON DOMINOMAILSTATSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE InterChangeRcvdTest;

CREATE TABLE InterChangeRcvdTest
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	decode_Rate		decimal(20,4) not null,
	decode_Rate_ST		varchar(32) not null,
	decrypt_Rate		decimal(20,4) not null,
	decrypt_Rate_ST		varchar(32) not null,
	receive_Rate		decimal(20,4) not null,
	receive_Rate_ST		varchar(32) not null
);

ALTER TABLE InterChangeRcvdTest ADD constraint PK_InterChangeRcvdTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_InterChangeRcvdTest ON InterChangeRcvdTest
(
	 MSMT_TIME
);
DROP TABLE InterChangeRcvdTest_TREND;

CREATE TABLE InterChangeRcvdTest_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	decode_Rate_MIN		decimal(20,4) not null,
	decode_Rate_MAX		decimal(20,4) not null,
	decode_Rate_STCNT	varchar(32) not null,
	decrypt_Rate_MIN	decimal(20,4) not null,
	decrypt_Rate_MAX	decimal(20,4) not null,
	decrypt_Rate_STCNT	varchar(32) not null,
	receive_Rate_MIN	decimal(20,4) not null,
	receive_Rate_MAX	decimal(20,4) not null,
	receive_Rate_STCNT	varchar(32) not null
);

ALTER TABLE InterChangeRcvdTest_TREND ADD constraint PK_InterChangeRcvdTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE InterChangeRcvdTest_THRESH;

CREATE TABLE InterChangeRcvdTest_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME        	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
      	MSMT_TIME_END   	datetime NOT NULL,
      	DECODE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DECODE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	DECRYPT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DECRYPT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	RECEIVE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	RECEIVE_RATE_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE InterChangeRcvdTest_THRESH ADD constraint PK_InterChangeRcvdTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_InterChangeRcvdTest_THRESH ON InterChangeRcvdTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);                  

DROP TABLE  InterChangeXmitTest;

CREATE TABLE InterChangeXmitTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	encode_Rate			decimal(20,4) NOT NULL,
	encode_Rate_ST			varchar(32) NOT NULL,
	encrypt_Rate			decimal(20,4) NOT NULL,
	encrypt_Rate_ST			varchar(32) NOT NULL,
	serialize_Rate			decimal(20,4) NOT NULL,
	serialize_Rate_ST		varchar(32) NOT NULL,
	xmit_Rate			decimal(20,4) NOT NULL,
	xmit_Rate_ST			varchar(32) NOT NULL
);

ALTER TABLE InterChangeXmitTest ADD constraint PK_InterChangeXmitTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_InterChangeXmitTest ON InterChangeXmitTest
(
	 MSMT_TIME
);
DROP TABLE  InterChangeXmitTest_TREND;

CREATE TABLE InterChangeXmitTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	encode_Rate_MIN			decimal(20,4) NOT NULL,
	encode_Rate_MAX			decimal(20,4) NOT NULL,
	encode_Rate_STCNT		varchar(32) NOT NULL,
	encrypt_Rate_MIN		decimal(20,4) NOT NULL,
	encrypt_Rate_MAX		decimal(20,4) NOT NULL,
	encrypt_Rate_STCNT		varchar(32) NOT NULL,
	serialize_Rate_MIN		decimal(20,4) NOT NULL,
	serialize_Rate_MAX		decimal(20,4) NOT NULL,
	serialize_Rate_STCNT		varchar(32) NOT NULL,
	xmit_Rate_MIN			decimal(20,4) NOT NULL,
	xmit_Rate_MAX			decimal(20,4) NOT NULL,
	xmit_Rate_STCNT			varchar(32) NOT NULL
	
);

ALTER TABLE InterChangeXmitTest_TREND ADD constraint PK_InterChangeXmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterChangeXmitTest_THRESH;

CREATE TABLE InterChangeXmitTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	ENCODE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	ENCODE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	ENCRYPT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	ENCRYPT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	SERIALIZE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	SERIALIZE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	XMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	XMIT_RATE_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE InterChangeXmitTest_THRESH ADD constraint PK_InterChangeXmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterChangeXmitTest_THRESH ON InterChangeXmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE WSJDBCTEST;

CREATE TABLE WSJDBCTEST
(
	TRGT_HOST 		varchar(32)	NOT NULL,
	PORT_NO         	varchar(32)	NOT NULL,
	SITE_NAME       	varchar(64)	NOT NULL,
	INFO            	varchar(128)	NOT NULL,
	MSMT_HOST 		varchar(32)	NOT NULL, 
	MSMT_TIME 		datetime	NOT NULL,
	CREATION_RATE		decimal(20,4) 	NOT NULL,
	CREATION_RATE_ST	varchar(32) 	NOT NULL,
	DESTROY_RATE		decimal(20,4) 	NOT NULL,
	DESTROY_RATE_ST		varchar(32) 	NOT NULL,
	RETURN_RATE		decimal(20,4) 	NOT NULL,
	RETURN_RATE_ST		varchar(32) 	NOT NULL,
	ALLOCATE_RATE		decimal(20,4) 	NOT NULL,
	ALLOCATE_RATE_ST	varchar(32) 	NOT NULL,
	POOL_SIZE		decimal(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar(32) 	NOT NULL,
	CONCUR_WAITERS		decimal(20,4) 	NOT NULL,
	CONCUR_WAITERS_ST	varchar(32) 	NOT NULL,
	AVG_WAIT_TIME		decimal(20,4) 	NOT NULL,
	AVG_WAIT_TIME_ST	varchar(32) 	NOT NULL,
	FAULTS			decimal(20,4) 	NOT NULL,
	FAULTS_ST		varchar(32) 	NOT NULL,
	PCT_USED		decimal(20,4) 	NOT NULL,
	PCT_USED_ST		varchar(32) 	NOT NULL,
	PCT_MAXED		decimal(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS	decimal(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST ADD constraint PK_WS_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_WSJDBCTEST ON WSJDBCTEST (MSMT_TIME) INCLUDE (CONCUR_WAITERS,AVG_WAIT_TIME,PCT_USED);

DROP TABLE WSJDBCTEST_TREND;

CREATE TABLE WSJDBCTEST_TREND 
(
	TRGT_HOST		varchar(32)	 NOT NULL,
	PORT_NO         	varchar(32)	 NOT NULL,
	SITE_NAME       	varchar(64)	 NOT NULL,
	INFO            	varchar(128)	 NOT NULL,
	MSMT_HOST 		varchar(32) 	NOT NULL, 
	MSMT_TIME		datetime 	NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	CREATION_RATE_MIN	decimal(20,4) 	NOT NULL,
	CREATION_RATE_MAX	decimal(20,4) 	NOT NULL,
	CREATION_RATE_STCNT	varchar(32) 	NOT NULL,
	DESTROY_RATE_MIN	decimal(20,4) 	NOT NULL,
	DESTROY_RATE_MAX	decimal(20,4) 	NOT NULL,
	DESTROY_RATE_STCNT	varchar(32) 	NOT NULL,
	RETURN_RATE_MIN		decimal(20,4) 	NOT NULL,
	RETURN_RATE_MAX		decimal(20,4) 	NOT NULL,
	RETURN_RATE_STCNT	varchar(32) 	NOT NULL,
	ALLOCATE_RATE_MIN	decimal(20,4) 	NOT NULL,
	ALLOCATE_RATE_MAX	decimal(20,4) 	NOT NULL,
	ALLOCATE_RATE_STCNT	varchar(32) 	NOT NULL,
	POOL_SIZE_MIN		decimal(20,4) 	NOT NULL,
	POOL_SIZE_MAX		decimal(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar(32) 	NOT NULL,
	CONCUR_WAITERS_MIN	decimal(20,4) 	NOT NULL,
	CONCUR_WAITERS_MAX	decimal(20,4) 	NOT NULL,
	CONCUR_WAITERS_STCNT	varchar(32) 	NOT NULL,
	AVG_WAIT_TIME_MIN	decimal(20,4) 	NOT NULL,
	AVG_WAIT_TIME_MAX	decimal(20,4) 	NOT NULL,
	AVG_WAIT_TIME_STCNT	varchar(32) 	NOT NULL,
	FAULTS_MIN		decimal(20,4) 	NOT NULL,
	FAULTS_MAX		decimal(20,4) 	NOT NULL,
	FAULTS_STCNT		varchar(32) 	NOT NULL,
	PCT_USED_MIN		decimal(20,4) 	NOT NULL,
	PCT_USED_MAX		decimal(20,4) 	NOT NULL,
	PCT_USED_STCNT		varchar(32) 	NOT NULL,
	PCT_MAXED_MIN		decimal(20,4) 	NOT NULL,
	PCT_MAXED_MAX		decimal(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	decimal(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	decimal(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_STCNT	varchar(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST_TREND ADD constraint PK_WS_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSJDBCTEST_THRESH;

CREATE TABLE WSJDBCTEST_THRESH 
(
	TRGT_HOST 			varchar(32)	NOT NULL,
	PORT_NO         		varchar(32)	NOT NULL,
	SITE_NAME        		varchar(64)	NOT NULL,
	INFO            		varchar(128)	NOT NULL,
	MSMT_HOST 			varchar(32)	NOT NULL, 
	MSMT_TIME_START			datetime 	NOT NULL,
        MSMT_TIME_END   		datetime	NOT NULL,
	CREATION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CREATION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DESTROY_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DESTROY_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	RETURN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	RETURN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	ALLOCATE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	ALLOCATE_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR(256)	 	NOT NULL,
	CONCUR_WAITERS_MIN	VARCHAR(256)	 	NOT NULL,
	CONCUR_WAITERS_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_WAIT_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_WAIT_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	FAULTS_MIN	VARCHAR(256)	 	NOT NULL,
	FAULTS_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_USED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_USED_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	VARCHAR(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSJDBCTEST_THRESH ADD constraint PK_WS_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSJDBCTEST_THRESH ON WSJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  


DROP TABLE WSGLOBALTXTEST;

CREATE TABLE WSGLOBALTXTEST
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	GLOBAL_TX_BEGUN			decimal(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_ST		varchar(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX		decimal(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_DURATION		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_ST		varchar(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION		decimal(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_ST	varchar(32) 	NOT NULL,
	NUM_OPTIMIZATION		decimal(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_ST	varchar(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_ST		varchar(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION		decimal(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSGLOBALTXTEST ADD constraint PK_WS_GL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSGLOBALTXTEST ON WSGLOBALTXTEST
(
	 MSMT_TIME
);
DROP TABLE WSGLOBALTXTEST_TREND;

CREATE TABLE WSGLOBALTXTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	GLOBAL_TX_BEGUN_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_STCNT		varchar(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN		decimal(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX		decimal(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_STCNT		varchar(32) 	NOT NULL,
	GLOBAL_TX_DURATION_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	decimal(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	decimal(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_STCNT	varchar(32) 	NOT NULL,
	NUM_OPTIMIZATION_MIN		decimal(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_MAX		decimal(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_STCNT		varchar(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	decimal(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	decimal(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_STCNT		varchar(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	decimal(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	decimal(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_STCNT	varchar(32) 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_TREND ADD constraint PK_WS_GL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSGLOBALTXTEST_THRESH;

CREATE TABLE WSGLOBALTXTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	GLOBAL_TX_BEGUN_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	VARCHAR(256)	 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_THRESH ADD constraint PK_WS_GL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSGLOBALTXTEST_THRESH ON WSGLOBALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSEJBTEST;

CREATE TABLE WSEJBTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime 	NOT NULL,
	INSTANTIATES		decimal(20,4) 	NOT NULL,
	INSTANTIATES_ST		varchar(32) 	NOT NULL,
	DESTROYS		decimal(20,4) 	NOT NULL,
	DESTROYS_ST		varchar(32) 	NOT NULL,
	TOT_METHOD_CALLS	decimal(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_ST	varchar(32) 	NOT NULL,
	AVG_METHOD_RT		decimal(20,4) 	NOT NULL,
	AVG_METHOD_RT_ST	varchar(32) 	NOT NULL,
	AVG_CREATE_TIME		decimal(20,4) 	NOT NULL,
	AVG_CREATE_TIME_ST	varchar(32) 	NOT NULL,
	POOL_SIZE		decimal(20,4) 	NOT NULL,
	POOl_SIZE_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST ADD constraint PK_WS_EJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSEJBTEST ON WSEJBTEST
(
	 MSMT_TIME
);
DROP TABLE WSEJBTEST_TREND;

CREATE TABLE WSEJBTEST_TREND 
(
	TRGT_HOST		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	INSTANTIATES_MIN	decimal(20,4) 	NOT NULL,
	INSTANTIATES_MAX	decimal(20,4) 	NOT NULL,
	INSTANTIATES_STCNT	varchar(32) 	NOT NULL,
	DESTROYS_MIN		decimal(20,4) 	NOT NULL,
	DESTROYS_MAX		decimal(20,4) 	NOT NULL,
	DESTROYS_STCNT		varchar(32) 	NOT NULL,
	TOT_METHOD_CALLS_MIN	decimal(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_MAX	decimal(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_STCNT	varchar(32) 	NOT NULL,
	AVG_METHOD_RT_MIN	decimal(20,4) 	NOT NULL,
	AVG_METHOD_RT_MAX	decimal(20,4) 	NOT NULL,
	AVG_METHOD_RT_STCNT	varchar(32) 	NOT NULL,
	AVG_CREATE_TIME_MIN	decimal(20,4) 	NOT NULL,
	AVG_CREATE_TIME_MAX	decimal(20,4) 	NOT NULL,
	AVG_CREATE_TIME_STCNT	varchar(32) 	NOT NULL,
	POOL_SIZE_MIN		decimal(20,4) 	NOT NULL,
	POOL_SIZE_MAX		decimal(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST_TREND ADD constraint PK_WS_EJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSEJBTEST_THRESH;

CREATE TABLE WSEJBTEST_THRESH 
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME        	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
        MSMT_TIME_END   	datetime NOT NULL,
	INSTANTIATES_MIN	VARCHAR(256)	 	NOT NULL,
	INSTANTIATES_MAX	VARCHAR(256)	 	NOT NULL,
	DESTROYS_MIN	VARCHAR(256)	 	NOT NULL,
	DESTROYS_MAX	VARCHAR(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MIN	VARCHAR(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_METHOD_RT_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_METHOD_RT_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_CREATE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_CREATE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSEJBTEST_THRESH ADD constraint PK_WS_EJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSEJBTEST_THRESH ON WSEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSLOCALTXTEST;

CREATE TABLE WSLOCALTXTEST
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	LOCAL_TX_BEGUN			decimal(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_ST		varchar(32) 	NOT NULL,
	ACTIVE_LOCAL_TX			decimal(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_ST		varchar(32) 	NOT NULL,
	LOCAL_TX_DURA		decimal(20,4) 	NOT NULL,
	LOCAL_TX_DURA_ST		varchar(32) 	NOT NULL,
	LOCAL_COMMIT_DURA		decimal(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_ST	varchar(32) 	NOT NULL,
	LOCAL_TX_COMMITTED		decimal(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_ST		varchar(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK		decimal(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_ST		varchar(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT		decimal(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSLOCALTXTEST ADD constraint PK_WS_LOCAL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX_WSLOCALTXTEST ON WSLOCALTXTEST
(
	 MSMT_TIME
);
DROP TABLE WSLOCALTXTEST_TREND;

CREATE TABLE WSLOCALTXTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	LOCAL_TX_BEGUN_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_STCNT		varchar(32) 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN		decimal(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX		decimal(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_STCNT		varchar(32) 	NOT NULL,
	LOCAL_TX_DURA_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_DURA_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_DURA_STCNT		varchar(32) 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	decimal(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	decimal(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_STCNT	varchar(32) 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_STCNT	varchar(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	decimal(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	decimal(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_STCNT	varchar(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_STCNT		varchar(32) 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_TREND ADD constraint PK_WS_LOCAL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSLOCALTXTEST_THRESH;

CREATE TABLE WSLOCALTXTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	LOCAL_TX_BEGUN_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_BEGUN_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_DURA_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_DURA_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX	VARCHAR(256)	 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_THRESH ADD constraint PK_WS_LOCAL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSLOCALTXTEST_THRESH ON WSLOCALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSSRVLTSESSIONTEST;

CREATE TABLE WSSRVLTSESSIONTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	SESSION_CREATION_RATE	decimal(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_ST	varchar(32) 	NOT NULL,
	INVALIDATED_SESSIONS	decimal(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_ST	varchar(32) 	NOT NULL,
	SESSION_LIFE_TIME	decimal(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_ST	varchar(32) 	NOT NULL,
	ACTIVE_SESSIONS		decimal(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_ST	varchar(32) 	NOT NULL,
	LIVE_SESSIONS		decimal(20,4) 	NOT NULL,
	LIVE_SESSIONS_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST ADD constraint PK_WS_SS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSSRVLTSESSIONTEST ON WSSRVLTSESSIONTEST
(
	 MSMT_TIME
);
DROP TABLE WSSRVLTSESSIONTEST_TREND;

CREATE TABLE WSSRVLTSESSIONTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	SESSION_CREATION_RATE_MIN		decimal(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_MAX		decimal(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_STCNT		varchar(32) 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	decimal(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	decimal(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_STCNT	varchar(32) 	NOT NULL,
	SESSION_LIFE_TIME_MIN		decimal(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_MAX		decimal(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_STCNT		varchar(32) 	NOT NULL,
	ACTIVE_SESSIONS_MIN		decimal(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_MAX		decimal(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_STCNT		varchar(32) 	NOT NULL,
	LIVE_SESSIONS_MIN		decimal(20,4) 	NOT NULL,
	LIVE_SESSIONS_MAX		decimal(20,4) 	NOT NULL,
	LIVE_SESSIONS_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_TREND ADD constraint PK_WS_SS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSSRVLTSESSIONTEST_THRESH;

CREATE TABLE WSSRVLTSESSIONTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	SESSION_CREATION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_CREATION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL,
	LIVE_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	LIVE_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_THRESH ADD constraint PK_WS_SS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSSRVLTSESSIONTEST_THRESH ON WSSRVLTSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSTEST;

CREATE TABLE WSTEST
(
	TRGT_HOST 	varchar(32)    NOT NULL,
	PORT_NO         varchar(32)    NOT NULL,
	SITE_NAME       varchar(64)    NOT NULL,
	INFO            varchar(128)    NOT NULL,
	MSMT_HOST 	varchar(32)    NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PCT_HEAP_USE 	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar(32) 	NOT NULL,
	AVAILABILITY 	decimal(20,4) 	NOT NULL,
	AVAILABILITY_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSTEST ADD constraint PK_WS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_WSTEST ON WSTEST (MSMT_TIME) INCLUDE (PCT_HEAP_USE);
DROP TABLE WSTEST_TREND;

CREATE TABLE WSTEST_TREND 
(
	TRGT_HOST		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	PCT_HEAP_USE_MIN	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar(32) 	NOT NULL,
	AVAILABILITY_MIN	decimal(20,4) 	NOT NULL,
	AVAILABILITY_MAX	decimal(20,4) 	NOT NULL,
	AVAILABILITY_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE WSTEST_TREND ADD constraint PK_WS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTEST_THRESH;

CREATE TABLE WSTEST_THRESH 
(
	TRGT_HOST 	varchar(32)    NOT NULL,
	PORT_NO         varchar(32)    NOT NULL,
	SITE_NAME        varchar(64)    NOT NULL,
	INFO            varchar(128)    NOT NULL,
	MSMT_HOST 	varchar(32)    NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PCT_HEAP_USE_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR(256)	 	NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSTEST_THRESH ADD constraint PK_WS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTEST_THRESH ON WSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSTHREADPOOLTEST;

CREATE TABLE WSTHREADPOOLTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	THREAD_CREATION_RATE 	decimal(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_ST	varchar(32) 	NOT NULL,
	THREAD_DESTROY_RATE 	decimal(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_ST	varchar(32) 	NOT NULL,
	ACTIVE_THREADS 		decimal(20,4) 	NOT NULL,
	ACTIVE_THREADS_ST	varchar(32) 	NOT NULL,
	POOL_SIZE 		decimal(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar(32) 	NOT NULL,
	PCT_MAXED		decimal(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST ADD constraint PK_WSTHREAD_POOL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_WSTHREADPOOLTEST ON WSTHREADPOOLTEST (MSMT_TIME) INCLUDE (ACTIVE_THREADS);

DROP TABLE WSTHREADPOOLTEST_TREND;

CREATE TABLE WSTHREADPOOLTEST_TREND 
(
	TRGT_HOST		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	THREAD_CREATION_RATE_MIN	decimal(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_MAX	decimal(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_STCNT 	varchar(32) 	NOT NULL,
	THREAD_DESTROY_RATE_MIN		decimal(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_MAX		decimal(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_STCNT	varchar(32) 	NOT NULL,
	ACTIVE_THREADS_MIN	decimal(20,4) 	NOT NULL,
	ACTIVE_THREADS_MAX	decimal(20,4) 	NOT NULL,
	ACTIVE_THREADS_STCNT	varchar(32) 	NOT NULL,
	POOL_SIZE_MIN		decimal(20,4) 	NOT NULL,
	POOL_SIZE_MAX		decimal(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar(32) 	NOT NULL,
	PCT_MAXED_MIN		decimal(20,4) 	NOT NULL,
	PCT_MAXED_MAX		decimal(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_TREND ADD constraint PK_WSTHREAD_POOL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTHREADPOOLTEST_THRESH;

CREATE TABLE WSTHREADPOOLTEST_THRESH 
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME      		varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
        MSMT_TIME_END   	datetime NOT NULL,
	THREAD_CREATION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	THREAD_CREATION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_THREADS_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_THREADS_MAX	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_THRESH ADD constraint PK_WSTHREAD_POOL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTHREADPOOLTEST_THRESH ON WSTHREADPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSWEBAPPSTEST;

CREATE TABLE WSWEBAPPSTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	NUM_LOADED_SERVLETS	decimal(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_ST	varchar(32) 	NOT NULL,
	NUM_RELOADS		decimal(20,4) 	NOT NULL,
	NUM_RELOADS_ST		varchar(32) 	NOT NULL,
	REQUEST_RATE		decimal(20,4) 	NOT NULL,
	REQUEST_RATE_ST		varchar(32) 	NOT NULL,
	CONCURRENT_REQUESTS	decimal(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_ST	varchar(32) 	NOT NULL,
	RESPONSE_TIME		decimal(20,4) 	NOT NULL,
	RESPONSE_TIME_ST	varchar(32) 	NOT NULL,
	NUM_ERRORS		decimal(20,4) 	NOT NULL,
	NUM_ERRORS_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST ADD constraint PK_WS_WEB_APPS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSWEBAPPSTEST ON WSWEBAPPSTEST
(
	 MSMT_TIME
);
DROP TABLE WSWEBAPPSTEST_TREND;

CREATE TABLE WSWEBAPPSTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	NUM_LOADED_SERVLETS_MIN		decimal(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX		decimal(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_STCNT	varchar(32) 	NOT NULL,
	NUM_RELOADS_MIN			decimal(20,4) 	NOT NULL,
	NUM_RELOADS_MAX			decimal(20,4) 	NOT NULL,
	NUM_RELOADS_STCNT		varchar(32) 	NOT NULL,
	REQUEST_RATE_MIN		decimal(20,4) 	NOT NULL,
	REQUEST_RATE_MAX		decimal(20,4) 	NOT NULL,
	REQUEST_RATE_STCNT		varchar(32) 	NOT NULL,
	CONCURRENT_REQUESTS_MIN		decimal(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_MAX		decimal(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_STCNT	varchar(32) 	NOT NULL,
	RESPONSE_TIME_MIN		decimal(20,4) 	NOT NULL,
	RESPONSE_TIME_MAX		decimal(20,4) 	NOT NULL,
	RESPONSE_TIME_STCNT		varchar(32) 	NOT NULL,
	NUM_ERRORS_MIN			decimal(20,4) 	NOT NULL,
	NUM_ERRORS_MAX			decimal(20,4) 	NOT NULL,
	NUM_ERRORS_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_TREND ADD constraint PK_WS_WEB_APPS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSWEBAPPSTEST_THRESH;

CREATE TABLE WSWEBAPPSTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	NUM_LOADED_SERVLETS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_RELOADS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_RELOADS_MAX	VARCHAR(256)	 	NOT NULL,
	REQUEST_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQUEST_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MIN	VARCHAR(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MAX	VARCHAR(256)	 	NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_ERRORS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_ERRORS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_THRESH ADD constraint PK_WS_WEB_APPS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSWEBAPPSTEST_THRESH ON WSWEBAPPSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MsXCacheTest;

CREATE TABLE MsXCacheTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	cacheHitRatio			decimal(20,4) not null,
	cacheHitRatio_ST		varchar(32) not null
);

ALTER TABLE MsXCacheTest ADD constraint PK_MsXCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXCacheTest ON MsXCacheTest
(
	 MSMT_TIME
);
DROP TABLE   MsXCacheTest_TREND;

CREATE TABLE MsXCacheTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	cacheHitRatio_min		decimal(20,4) not null,
	cacheHitRatio_max		decimal(20,4) not null,
	cacheHitRatio_stcnt		varchar(32) not null
);

ALTER TABLE MsXCacheTest_TREND ADD constraint PK_MsXCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXCacheTest_THRESH;

CREATE TABLE MsXCacheTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
 	MSMT_TIME_END   		datetime NOT NULL,
 	CACHEHITRATIO_MIN	VARCHAR(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsXCacheTest_THRESH ADD constraint PK_MsXCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXCacheTest_THRESH ON MsXCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXDBTest; 

CREATE TABLE MsXDBTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	dbCacheHit			decimal(20,4) not null,
	dbCacheHit_ST			varchar(32) not null,
	dbTablesCacheHit		decimal(20,4) not null,
	dbTablesCacheHit_st		varchar(32) not null,
	logRecrdWaitingRate		decimal(20,4) not null,
	logRecrdWaitingRate_st		varchar(32) not null,
	logThreadWaiting		decimal(20,4) not null,
	logThreadWaiting_st		varchar(32) not null
);

ALTER TABLE MsXDBTest ADD constraint PK_MsXDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXDBTest ON MsXDBTest
(
	 MSMT_TIME
);
DROP TABLE   MsXDBTest_TREND;

CREATE TABLE MsXDBTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	dbCacheHit_min			decimal(20,4) not null,
	dbCacheHit_max			decimal(20,4) not null,
	dbCacheHit_stcnt		varchar(32) not null,
	dbTablesCacheHit_min		decimal(20,4) not null,
	dbTablesCacheHit_max		decimal(20,4) not null,
	dbTablesCacheHit_stcnt		varchar(32) not null,
	logRecrdWaitingRate_min		decimal(20,4) not null,
	logRecrdWaitingRate_max		decimal(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar(32) not null,
	logThreadWaiting_min		decimal(20,4) not null,
	logThreadWaiting_max		decimal(20,4) not null,
	logThreadWaiting_stcnt		varchar(32) not null
);

ALTER TABLE MsXDBTest_TREND ADD constraint PK_MsXDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXDBTest_THRESH;

CREATE TABLE MsXDBTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
  MSMT_TIME_END   		datetime NOT NULL,
  DBCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsXDBTest_THRESH ADD constraint PK_MsXDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXDBTest_THRESH ON MsXDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXMailRetrvlTest;

CREATE TABLE MsXMailRetrvlTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	currPop3Conn			decimal(20,4) not null,
	currPop3Conn_st			varchar(32) not null,
	currImapConn			decimal(20,4) not null,
	currImapConn_st			varchar(32) not null,
	pop3ClientWaitingReq		decimal(20,4) not null,
	pop3ClientWaitingReq_st		varchar(32) not null,
	imapClientWaitingReq		decimal(20,4) not null,
	imapClientWaitingReq_st		varchar(32) not null
);

ALTER TABLE MsXMailRetrvlTest ADD constraint PK_MsXMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXMailRetrvlTest ON MsXMailRetrvlTest
(
	 MSMT_TIME
);
DROP TABLE   MsXMailRetrvlTest_TREND;

CREATE TABLE MsXMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	currPop3Conn_min		decimal(20,4) not null,
	currPop3Conn_max		decimal(20,4) not null,
	currPop3Conn_stcnt		varchar(32) not null,
	currImapConn_min		decimal(20,4) not null,
	currImapConn_max		decimal(20,4) not null,
	currImapConn_stcnt		varchar(32) not null,
	pop3ClientWaitingReq_min		decimal(20,4) not null,
	pop3ClientWaitingReq_max		decimal(20,4) not null,
	pop3ClientWaitingReq_stcnt		varchar(32) not null,
	imapClientWaitingReq_min		decimal(20,4) not null,
	imapClientWaitingReq_max		decimal(20,4) not null,
	imapClientWaitingReq_stcnt		varchar(32) not null
);

ALTER TABLE MsXMailRetrvlTest_TREND ADD constraint PK_MsXMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailRetrvlTest_THRESH;

CREATE TABLE MsXMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CURRPOP3CONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MIN	VARCHAR(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MAX	VARCHAR(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MIN	VARCHAR(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsXMailRetrvlTest_THRESH ADD constraint PK_MsXMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailRetrvlTest_THRESH ON MsXMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXMailSvcTest;
CREATE TABLE MsXMailSvcTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
INBOUND_QSIZE DECIMAL(20,4) NOT NULL,
INBOUND_QSIZE_ST varchar(32) NOT NULL,
OUTBOUND_QSIZE DECIMAL(20,4) NOT NULL,
OUTBOUND_QSIZE_ST varchar(32) NOT NULL,
MTS_IN_QSIZE DECIMAL(20,4) NOT NULL,
MTS_IN_QSIZE_ST varchar(32) NOT NULL,
MTS_OUT_QSIZE DECIMAL(20,4) NOT NULL,
MTS_OUT_QSIZE_ST varchar(32) NOT NULL,
IN_CONNS DECIMAL(20,4) NOT NULL,
IN_CONNS_ST varchar(32) NOT NULL,
OUT_CONNS DECIMAL(20,4) NOT NULL,
OUT_CONNS_ST varchar(32) NOT NULL,
CONNS_FAILED DECIMAL(20,4) NOT NULL,
CONNS_FAILED_ST varchar(32) NOT NULL,
CONNS_REJECTED DECIMAL(20,4) NOT NULL,
CONNS_REJECTED_ST varchar(32) NOT NULL,
IN_MSGS DECIMAL(20,4) NOT NULL,
IN_MSGS_ST varchar(32) NOT NULL,
OUT_MSGS DECIMAL(20,4) NOT NULL,
OUT_MSGS_ST varchar(32) NOT NULL);

ALTER TABLE MsXMailSvcTest ADD constraint PK_MsXMailSvcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXMailSvcTest ON MsXMailSvcTest
(
	 MSMT_TIME
);
DROP TABLE MsXMailSvcTest_TREND;
CREATE TABLE MsXMailSvcTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
INBOUND_QSIZE_MIN DECIMAL(20,4) NOT NULL,
INBOUND_QSIZE_MAX DECIMAL(20,4) NOT NULL,
INBOUND_QSIZE_STCNT varchar(32) NOT NULL,
OUTBOUND_QSIZE_MIN DECIMAL(20,4) NOT NULL,
OUTBOUND_QSIZE_MAX DECIMAL(20,4) NOT NULL,
OUTBOUND_QSIZE_STCNT varchar(32) NOT NULL,
MTS_IN_QSIZE_MIN DECIMAL(20,4) NOT NULL,
MTS_IN_QSIZE_MAX DECIMAL(20,4) NOT NULL,
MTS_IN_QSIZE_STCNT varchar(32) NOT NULL,
MTS_OUT_QSIZE_MIN DECIMAL(20,4) NOT NULL,
MTS_OUT_QSIZE_MAX DECIMAL(20,4) NOT NULL,
MTS_OUT_QSIZE_STCNT varchar(32) NOT NULL,
IN_CONNS_MIN DECIMAL(20,4) NOT NULL,
IN_CONNS_MAX DECIMAL(20,4) NOT NULL,
IN_CONNS_STCNT varchar(32) NOT NULL,
OUT_CONNS_MIN DECIMAL(20,4) NOT NULL,
OUT_CONNS_MAX DECIMAL(20,4) NOT NULL,
OUT_CONNS_STCNT varchar(32) NOT NULL,
CONNS_FAILED_MIN DECIMAL(20,4) NOT NULL,
CONNS_FAILED_MAX DECIMAL(20,4) NOT NULL,
CONNS_FAILED_STCNT varchar(32) NOT NULL,
CONNS_REJECTED_MIN DECIMAL(20,4) NOT NULL,
CONNS_REJECTED_MAX DECIMAL(20,4) NOT NULL,
CONNS_REJECTED_STCNT varchar(32) NOT NULL,
IN_MSGS_MIN DECIMAL(20,4) NOT NULL,
IN_MSGS_MAX DECIMAL(20,4) NOT NULL,
IN_MSGS_STCNT varchar(32) NOT NULL,
OUT_MSGS_MIN DECIMAL(20,4) NOT NULL,
OUT_MSGS_MAX DECIMAL(20,4) NOT NULL,
OUT_MSGS_STCNT varchar(32) NOT NULL);

ALTER TABLE MsXMailSvcTest_TREND ADD constraint PK_MsXMailSvcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsXMailSvcTest_THRESH;
CREATE TABLE MsXMailSvcTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
INBOUND_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
INBOUND_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
OUTBOUND_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
OUTBOUND_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
MTS_IN_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
MTS_IN_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
MTS_OUT_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
MTS_OUT_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
IN_CONNS_MIN	VARCHAR(256)	 NOT NULL,
IN_CONNS_MAX	VARCHAR(256)	 NOT NULL,
OUT_CONNS_MIN	VARCHAR(256)	 NOT NULL,
OUT_CONNS_MAX	VARCHAR(256)	 NOT NULL,
CONNS_FAILED_MIN	VARCHAR(256)	 NOT NULL,
CONNS_FAILED_MAX	VARCHAR(256)	 NOT NULL,
CONNS_REJECTED_MIN	VARCHAR(256)	 NOT NULL,
CONNS_REJECTED_MAX	VARCHAR(256)	 NOT NULL,
IN_MSGS_MIN	VARCHAR(256)	 NOT NULL,
IN_MSGS_MAX	VARCHAR(256)	 NOT NULL,
OUT_MSGS_MIN	VARCHAR(256)	 NOT NULL,
OUT_MSGS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MsXMailSvcTest_THRESH ADD constraint PK_MsXMailSvcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsXMailSvcTest_THRESH ON MsXMailSvcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MsXMailXferTest;

CREATE TABLE MsXMailXferTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	localQSize			decimal(20,4) not null,
	localQSize_st			varchar(32) not null,
	remoteQSize			decimal(20,4) not null,
	remoteQSize_st			varchar(32) not null,
	currSmtpConn			decimal(20,4) not null,
	currSmtpConn_st			varchar(32) not null,
	dataRcvdRate			decimal(20,4) not null,
	dataRcvdRate_st			varchar(32) not null,
	dataSentRate			decimal(20,4) not null,
	dataSentRate_st			varchar(32) not null,
	avgRetryMsgDelvry		decimal(20,4) not null,
	avgRetryMsgDelvry_st		varchar(32) not null,
	avgRetryMsgSent			decimal(20,4) not null,
	avgRetryMsgSent_st		varchar(32) not null
	
);

ALTER TABLE MsXMailXferTest ADD constraint PK_MsXMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXMailXferTest ON MsXMailXferTest
(
	 MSMT_TIME
);
DROP TABLE   MsXMailXferTest_TREND;

CREATE TABLE MsXMailXferTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	localQSize_min			decimal(20,4) not null,
	localQSize_max			decimal(20,4) not null,
	localQSize_stcnt		varchar(32) not null,
	remoteQSize_min			decimal(20,4) not null,
	remoteQSize_max			decimal(20,4) not null,
	remoteQSize_stcnt		varchar(32) not null,
	currSmtpConn_min		decimal(20,4) not null,
	currSmtpConn_max		decimal(20,4) not null,
	currSmtpConn_stcnt		varchar(32) not null,
	dataRcvdRate_min		decimal(20,4) not null,
	dataRcvdRate_max		decimal(20,4) not null,
	dataRcvdRate_stcnt		varchar(32) not null,
	dataSentRate_min		decimal(20,4) not null,
	dataSentRate_max		decimal(20,4) not null,
	dataSentRate_stcnt		varchar(32) not null,
	avgRetryMsgDelvry_min		decimal(20,4) not null,
	avgRetryMsgDelvry_max		decimal(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar(32) not null,
	avgRetryMsgSent_min		decimal(20,4) not null,
	avgRetryMsgSent_max		decimal(20,4) not null,
	avgRetryMsgSent_stcnt		varchar(32) not null
	
);

ALTER TABLE MsXMailXferTest_TREND ADD constraint PK_MsXMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailXferTest_THRESH;

CREATE TABLE MsXMailXferTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	LOCALQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE MsXMailXferTest_THRESH ADD constraint PK_MsXMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailXferTest_THRESH ON MsXMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MsXStoreTest;

CREATE TABLE MsXStoreTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	currUsers			decimal(20,4) not null,
	currUsers_st			varchar(32) not null,
	mailSendQSize			decimal(20,4) not null,
	mailSendQSize_st		varchar(32) not null,
	mailRcvdQSize			decimal(20,4) not null,
	mailRcvdQSize_st		varchar(32) not null,
	mailSentRate			decimal(20,4) not null,
	mailSentRate_st			varchar(32) not null,
	mailOpensRate			decimal(20,4) not null,
	mailOpensRate_st		varchar(32) not null,
	folderOpensRate			decimal(20,4) not null,
	folderOpensRate_st		varchar(32) not null,
	avgMailDelvryTime			decimal(20,4) not null,
	avgMailDelvryTime_st		varchar(32) not null,
	avgMailLocalDelvryTime		decimal(20,4) not null,
	avgMailLocalDelvryTime_st		varchar(32) not null
	
);

ALTER TABLE MsXStoreTest ADD constraint PK_MsXStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXStoreTest ON MsXStoreTest
(
	 MSMT_TIME
);
DROP TABLE   MsXStoreTest_TREND;

CREATE TABLE MsXStoreTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	currUsers_min			decimal(20,4) not null,
	currUsers_max			decimal(20,4) not null,
	currUsers_stcnt			varchar(32) not null,
	mailSendQSize_min		decimal(20,4) not null,
	mailSendQSize_max		decimal(20,4) not null,
	mailSendQSize_stcnt		varchar(32) not null,
	mailRcvdQSize_min		decimal(20,4) not null,
	mailRcvdQSize_max		decimal(20,4) not null,
	mailRcvdQSize_stcnt		varchar(32) not null,
	mailSentRate_min		decimal(20,4) not null,
	mailSentRate_max		decimal(20,4) not null,
	mailSentRate_stcnt		varchar(32) not null,
	mailOpensRate_min		decimal(20,4) not null,
	mailOpensRate_max		decimal(20,4) not null,
	mailOpensRate_stcnt		varchar(32) not null,
	folderOpensRate_min		decimal(20,4) not null,
	folderOpensRate_max		decimal(20,4) not null,
	folderOpensRate_stcnt		varchar(32) not null,
	avgMailDelvryTime_min		decimal(20,4) not null,
	avgMailDelvryTime_max		decimal(20,4) not null,
	avgMailDelvryTime_stcnt		varchar(32) not null,
	avgMailLocalDelvryTime_min		decimal(20,4) not null,
	avgMailLocalDelvryTime_max		decimal(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar(32) not null
	
);

ALTER TABLE MsXStoreTest_TREND ADD constraint PK_MsXStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXStoreTest_THRESH;

CREATE TABLE MsXStoreTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CURRUSERS_MIN	VARCHAR(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE MsXStoreTest_THRESH ADD constraint PK_MsXStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXStoreTest_THRESH ON MsXStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE EJBNAMES;

CREATE TABLE EJBNAMES
(
        TEST_NAME       varchar(64) not null,
        TRGT_HOST       varchar(32) not null,
        PORT_NO         varchar(32) not null,
        EJB             varchar(256) not null
);
ALTER TABLE EJBNAMES ADD CONSTRAINT PK_EJBNAMES
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,EJB);

DROP TABLE PrinterTest;

CREATE TABLE PrinterTest
( 	
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO 	           	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime 	NOT NULL,
	PRINTER_AVAILABILITY	 	decimal(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE PrinterTest ADD constraint PK_PrinterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterTest ON PrinterTest
(
	 MSMT_TIME
);
DROP TABLE PrinterTest_TREND;

CREATE TABLE PrinterTest_TREND 
( 	
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO 	           	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime 	NOT NULL,
	PERIOD       				varchar(32)			NOT NULL,
	PRINTER_AVAILABILITY_MIN 		decimal(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_MAX 		decimal(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterTest_TREND ADD constraint PK_PrinterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterTest_THRESH ;

CREATE TABLE PrinterTest_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
		PORT_NO         varchar(32) NOT NULL,
		SITE_NAME        varchar(64) NOT NULL,
		INFO            varchar(128) NOT NULL,
		MSMT_HOST 	varchar(32) NOT NULL, 
		MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PRINTER_AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	PRINTER_AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE PrinterTest_THRESH ADD constraint PK_PrinterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterTest_THRESH ON PrinterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterCoverTest;

CREATE TABLE PrinterCoverTest 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	COVER_CLOSED 			decimal(20,4) 	NOT NULL,
	COVER_CLOSED_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest ADD constraint PK_PrinterCoverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterCoverTest ON PrinterCoverTest
(
	 MSMT_TIME
);
DROP TABLE PrinterCoverTest_TREND;

CREATE TABLE PrinterCoverTest_TREND 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)		NOT NULL,
	COVER_CLOSED_MIN 		decimal(20,4) 	NOT NULL,
	COVER_CLOSED_MAX 		decimal(20,4) 	NOT NULL,
	COVER_CLOSED_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest_TREND ADD constraint PK_PrinterCoverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterCoverTest_THRESH ;

CREATE TABLE PrinterCoverTest_THRESH 
( 		
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	COVER_CLOSED_MIN	VARCHAR(256)	 	NOT NULL,
	COVER_CLOSED_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE PrinterCoverTest_THRESH ADD constraint PK_PrinterCoverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterCoverTest_THRESH ON PrinterCoverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterErrorTest;

CREATE TABLE PrinterErrorTest
( 
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PAPER_AVAILABILITY 	decimal(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_ST varchar(32) 	NOT NULL,
	TONER_CAPACITY 		decimal(20,4) 	NOT NULL,
	TONER_CAPACITY_ST 	varchar(32) 	NOT NULL,
	TONER_AVAILABILITY 	decimal(20,4) 	NOT NULL,
	TONER_AVAILABILITY_ST varchar(32) 	NOT NULL,
	PAPER_FLOW 			decimal(20,4) 	NOT NULL,
	PAPER_FLOW_ST 		varchar(32) 	NOT NULL,
	ON_LINE 				decimal(20,4) 	NOT NULL,
	ON_LINE_ST 			varchar(32) 	NOT NULL,
	DOOR_CLOSED 		decimal(20,4) 	NOT NULL,
	DOOR_CLOSED_ST 		varchar(32) NOT NULL
);
	
ALTER TABLE PrinterErrorTest ADD constraint PK_PrinterErrorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterErrorTest ON PrinterErrorTest
(
	 MSMT_TIME
);
DROP TABLE PrinterErrorTest_TREND;

CREATE TABLE PrinterErrorTest_TREND
( 
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       				varchar(32)	NOT NULL,
	PAPER_AVAILABILITY_MIN 	decimal(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_MAX 	decimal(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_STCNT 	varchar(32) 	NOT NULL,
	TONER_CAPACITY_MIN 		decimal(20,4) 	NOT NULL,
	TONER_CAPACITY_MAX 		decimal(20,4) 	NOT NULL,
	TONER_CAPACITY_STCNT 	varchar(32) 	NOT NULL,
	TONER_AVAILABILITY_MIN 	decimal(20,4) 	NOT NULL,
	TONER_AVAILABILITY_MAX 	decimal(20,4) 	NOT NULL,
	TONER_AVAILABILITY_STCNT 	varchar(32)	NOT NULL,
	PAPER_FLOW_MIN 			decimal(20,4) 	NOT NULL,
	PAPER_FLOW_MAX 			decimal(20,4) 	NOT NULL,
	PAPER_FLOW_STCNT 		varchar(32) 	NOT NULL,
	ON_LINE_MIN 				decimal(20,4) 	NOT NULL,
	ON_LINE_MAX 				decimal(20,4) 	NOT NULL,
	ON_LINE_STCNT 			varchar(32) 	NOT NULL,
	DOOR_CLOSED_MIN 		decimal(20,4) 	NOT NULL,
	DOOR_CLOSED_MAX 		decimal(20,4) 	NOT NULL,
	DOOR_CLOSED_STCNT 		varchar(32) 	NOT NULL
);
	
ALTER TABLE PrinterErrorTest_TREND ADD constraint PK_PrinterErrorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterErrorTest_THRESH;

CREATE TABLE PrinterErrorTest_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PAPER_AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	PAPER_AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL,
	TONER_CAPACITY_MIN	VARCHAR(256)	 	NOT NULL,
	TONER_CAPACITY_MAX	VARCHAR(256)		NOT NULL,
	TONER_AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	TONER_AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL,
	PAPER_FLOW_MIN	VARCHAR(256)	 	NOT NULL,
	PAPER_FLOW_MAX	VARCHAR(256)	 	NOT NULL,
	ON_LINE_MIN	VARCHAR(256)	 	NOT NULL,
	ON_LINE_MAX	VARCHAR(256)	 	NOT NULL,
	DOOR_CLOSED_MIN	VARCHAR(256)	 	NOT NULL,
	DOOR_CLOSED_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE PrinterErrorTest_THRESH ADD constraint PK_PrinterErrorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterErrorTest_THRESH ON PrinterErrorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterInputTest;

CREATE TABLE PrinterInputTest
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	TRAY_AVAILABILITY 		decimal(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_ST		varchar(32) 	NOT NULL,
	TRAY_IDLE 			decimal(20,4) 	NOT NULL,
	TRAY_IDLE_ST 			varchar(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY 	decimal(20,4)	NOT NULL,
	TRAY_PAPER_AVAILABILITY_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest ADD constraint PK_PrinterInputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterInputTest ON PrinterInputTest
(
	 MSMT_TIME
);
DROP TABLE PrinterInputTest_TREND;

CREATE TABLE PrinterInputTest_TREND 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)			NOT NULL,
	TRAY_AVAILABILITY_MIN 		decimal(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_MAX		decimal(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_STCNT 	varchar(32)	NOT NULL,
	TRAY_IDLE_MIN 			decimal(20,4) 	NOT NULL,
	TRAY_IDLE_MAX 			decimal(20,4) 	NOT NULL,
	TRAY_IDLE_STCNT 		varchar(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN 	decimal(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX 	decimal(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest_TREND ADD constraint PK_PrinterInputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterInputTest_THRESH;

CREATE TABLE PrinterInputTest_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	TRAY_AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	TRAY_AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	TRAY_IDLE_MIN	VARCHAR(256)	 NOT NULL,
	TRAY_IDLE_MAX	VARCHAR(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE PrinterInputTest_THRESH ADD constraint PK_PrinterInputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterInputTest_THRESH ON PrinterInputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterOutputTest;

CREATE TABLE PrinterOutputTest
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	OUTPUT_BIN_AVAILABLE 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_ST 	varchar(32) 	NOT NULL,
	OUTPUT_BIN_IDLE 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest ADD constraint PK_PrinterOutputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterOutputTest ON PrinterOutputTest
(
	 MSMT_TIME
);
DROP TABLE PrinterOutputTest_TREND;

CREATE TABLE PrinterOutputTest_TREND
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)			NOT NULL,
	OUTPUT_BIN_AVAILABLE_MIN 	decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX 	decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_STCNT	varchar(32) 	NOT NULL,
	OUTPUT_BIN_IDLE_MIN 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_MAX 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest_TREND ADD constraint PK_PrinterOutputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterOutputTest_THRESH;

CREATE TABLE PrinterOutputTest_THRESH
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	OUTPUT_BIN_AVAILABLE_MIN	VARCHAR(256)	 NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX	VARCHAR(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MIN	VARCHAR(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE PrinterOutputTest_THRESH ADD constraint PK_PrinterOutputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterOutputTest_THRESH ON PrinterOutputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterPageCount;

CREATE TABLE PrinterPageCount
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PAGES_PRINTED decimal(20,4) NOT NULL,
	PAGES_PRINTED_ST varchar(32) NOT NULL
);

ALTER TABLE PrinterPageCount ADD constraint PK_PrinterPageCount PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterPageCount ON PrinterPageCount
(
	 MSMT_TIME
);
DROP TABLE PrinterPageCount_TREND;

CREATE TABLE PrinterPageCount_TREND 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)		NOT NULL,
	PAGES_PRINTED_MIN 		decimal(20,4) 	NOT NULL,
	PAGES_PRINTED_MAX 		decimal(20,4) 	NOT NULL,
	PAGES_PRINTED_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterPageCount_TREND ADD constraint PK_PrinterPageCount_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterPageCount_THRESH;

CREATE TABLE PrinterPageCount_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PAGES_PRINTED_MIN	VARCHAR(256)	 NOT NULL,
	PAGES_PRINTED_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE PrinterPageCount_THRESH ADD constraint PK_PrinterPageCount_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterPageCount_THRESH ON PrinterPageCount_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNTHREADTEST;
CREATE TABLE JRUNTHREADTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	Pct_threads_utilized 		decimal(20,4) 	NOT NULL,
	Pct_threads_utilized_st 	varchar(32) 	NOT NULL,
	Waiting_thread_count 		decimal(20,4) 	NOT NULL,
	Waiting_thread_count_st		varchar(32) 	NOT NULL,
	Total_threads_count	 	decimal(20,4) 	NOT NULL,
	Total_threads_count_st		 varchar(32) 	NOT NULL
);

ALTER TABLE JRUNTHREADTEST ADD constraint PK_JRUNTHREADTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 
CREATE  INDEX IDX_JRUNTHREADTEST ON JRUNTHREADTEST
(
	 MSMT_TIME
);
DROP TABLE JRUNTHREADTEST_TREND;

CREATE TABLE JRUNTHREADTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	Pct_threads_utilized_MIN	        decimal(20,4) 	NOT NULL,
	Pct_threads_utilized_MAX	        decimal(20,4) 	NOT NULL,
	Pct_threads_utilized_STCNT 	varchar(32) 	NOT NULL,
	Waiting_thread_count_MIN	decimal(20,4) 	NOT NULL,
	Waiting_thread_count_MAX	decimal(20,4) 	NOT NULL,
	Waiting_thread_count_STCNT 	varchar(32) 	NOT NULL,
	Total_threads_count_MIN		decimal(20,4) 	NOT NULL,
	Total_threads_count_MAX		decimal(20,4) 	NOT NULL,
	Total_threads_count_STCNT 	varchar(32) 	NOT NULL
	
);


ALTER TABLE JRUNTHREADTEST_TREND ADD constraint PK_JRUNTHREADTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNTHREADTEST_THRESH;

CREATE TABLE JRUNTHREADTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PCT_THREADS_UTILIZED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_THREADS_UTILIZED_MAX	VARCHAR(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MAX	VARCHAR(256)	 	NOT NULL
	
);

ALTER TABLE JRUNTHREADTEST_THRESH ADD constraint PK_JRUNTHREADTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNTHREADTEST_THRESH ON JRUNTHREADTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNSERVERTEST;

CREATE TABLE JRUNSERVERTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	Total_serv_memory 		decimal(20,4) 	NOT NULL,
	Total_serv_memory_st 	varchar(32) 	NOT NULL,
	Free_serv_memory 		decimal(20,4) 	NOT NULL,
	Free_serv_memory_st		varchar(32) 	NOT NULL,
	Num_active_sessions	 	decimal(20,4) 	NOT NULL,
	Num_active_sessions_st		 varchar(32) 	NOT NULL,
	Num_mem_sessions	 	decimal(20,4) 	NOT NULL,
	Num_mem_sessions_st		 varchar(32) 	NOT NULL

);

ALTER TABLE JRUNSERVERTEST ADD constraint PK_JRUNSERVERTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 
CREATE  INDEX IDX_JRUNSERVERTEST ON JRUNSERVERTEST
(
	 MSMT_TIME
);
DROP TABLE JRUNSERVERTEST_TREND;

CREATE TABLE JRUNSERVERTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	Total_serv_memory_MIN	        decimal(20,4) 	NOT NULL,
	Total_serv_memory_MAX	        decimal(20,4) 	NOT NULL,
	Total_serv_memory_STCNT 	varchar(32) 	NOT NULL,
	Free_serv_memory_MIN		decimal(20,4) 	NOT NULL,
	Free_serv_memory_MAX		decimal(20,4) 	NOT NULL,
	Free_serv_memory_STCNT 		varchar(32) 	NOT NULL,
	Num_active_sessions_MIN		decimal(20,4) 	NOT NULL,
	Num_active_sessions_MAX		decimal(20,4) 	NOT NULL,
	Num_active_sessions_STCNT 	varchar(32) 	NOT NULL,
	Num_mem_sessions_MIN		decimal(20,4) 	NOT NULL,
	Num_mem_sessions_MAX		decimal(20,4) 	NOT NULL,
	Num_mem_sessions_STCNT 		varchar(32) 	NOT NULL	
	
);


ALTER TABLE JRUNSERVERTEST_TREND ADD constraint PK_JRUNSERVERTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVERTEST_THRESH;

CREATE TABLE JRUNSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	TOTAL_SERV_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_SERV_MEMORY_MAX	VARCHAR(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL
	
);

ALTER TABLE JRUNSERVERTEST_THRESH ADD constraint PK_JRUNSERVERTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVERTEST_THRESH ON JRUNSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JRUNSERVICETEST;

CREATE TABLE JRUNSERVICETEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	Request_rate 		decimal(20,4) 	NOT NULL,
	Request_rate_st 	varchar(32) 	NOT NULL,
	Avg_queue_time 		decimal(20,4) 	NOT NULL,
	Avg_queue_time_st 	varchar(32) 	NOT NULL,
	Avg_proc_time 		decimal(20,4) 	NOT NULL,
	Avg_proc_time_st		varchar(32) 	NOT NULL,
	Avg_response_time	 	decimal(20,4) 	NOT NULL,
	Avg_response_time_st		 varchar(32) 	NOT NULL,
	Data_read_rate	 		decimal(20,4) 	NOT NULL,
	Data_read_rate_st		 varchar(32) 	NOT NULL,
	Data_write_rate	 		decimal(20,4) 	NOT NULL,
	Data_write_rate_st		 varchar(32) 	NOT NULL,
	Delayed_request_count	 	decimal(20,4) 	NOT NULL,
	Delayed_request_count_st	 varchar(32) 	NOT NULL,
	Dropped_request_count	 	decimal(20,4) 	NOT NULL,
	Dropped_request_count_st	 varchar(32) 	NOT NULL
);

ALTER TABLE JRUNSERVICETEST ADD constraint PK_JRUNSERVICETEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 
CREATE  INDEX IDX_JRUNSERVICETEST ON JRUNSERVICETEST
(
	 MSMT_TIME
);
DROP TABLE JRUNSERVICETEST_TREND;

CREATE TABLE JRUNSERVICETEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	Request_rate_MIN	decimal(20,4) NOT NULL,
	Request_rate_MAX	decimal(20,4) NOT NULL,
	Request_rate_STCNT	varchar(32) NOT NULL,
	Avg_queue_time_MIN	        decimal(20,4) 	NOT NULL,
	Avg_queue_time_MAX	        decimal(20,4) 	NOT NULL,
	Avg_queue_time_STCNT 		varchar(32) 	NOT NULL,
	Avg_proc_time_MIN		decimal(20,4) 	NOT NULL,
	Avg_proc_time_MAX		decimal(20,4) 	NOT NULL,
	Avg_proc_time_STCNT 		varchar(32) 	NOT NULL,
	Avg_response_time_MIN		decimal(20,4) 	NOT NULL,
	Avg_response_time_MAX		decimal(20,4) 	NOT NULL,
	Avg_response_time_STCNT 	varchar(32) 	NOT NULL,
	Data_read_rate_MIN		decimal(20,4) 	NOT NULL,
	Data_read_rate_MAX		decimal(20,4) 	NOT NULL,
	Data_read_rate_STCNT 		varchar(32) 	NOT NULL,	
	Data_write_rate_MIN		decimal(20,4) 	NOT NULL,
	Data_write_rate_MAX		decimal(20,4) 	NOT NULL,
	Data_write_rate_STCNT 		varchar(32) 	NOT NULL,	
	Delayed_request_count_MIN		decimal(20,4) 	NOT NULL,
	Delayed_request_count_MAX		decimal(20,4) 	NOT NULL,
	Delayed_request_count_STCNT 		varchar(32) 	NOT NULL,
	Dropped_request_count_MIN		decimal(20,4) 	NOT NULL,
	Dropped_request_count_MAX		decimal(20,4) 	NOT NULL,
	Dropped_request_count_STCNT 		varchar(32) 	NOT NULL	
	
);


ALTER TABLE JRUNSERVICETEST_TREND ADD constraint PK_JRUNSERVICETEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVICETEST_THRESH;

CREATE TABLE JRUNSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	REQUEST_RATE_MIN	VARCHAR(256)	 NOT NULL,
	REQUEST_RATE_MAX	VARCHAR(256)	 NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_PROC_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_PROC_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_READ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_READ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_WRITE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_WRITE_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MAX	VARCHAR(256)	 	NOT NULL
	
);

ALTER TABLE JRUNSERVICETEST_THRESH ADD constraint PK_JRUNSERVICETEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVICETEST_THRESH ON JRUNSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE BackupJobsTest;

CREATE TABLE BackupJobsTest
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO            	varchar(128)	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	ACTIVE_JOB_COUNT 	DECIMAL(20,4)   NOT NULL,
	ACTIVE_JOB_COUNT_ST 	varchar(32) 	NOT NULL,
	FAILED_JOBS_COUNT 	DECIMAL(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_ST 	varchar(32) 	NOT NULL,
	SUCCESSFUL_JOBS 	DECIMAL(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_ST 	varchar(32) 	NOT NULL,
	TOTAL_BYTES 		DECIMAL(20,4) 	NOT NULL,
	TOTAL_BYTES_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest ADD constraint PK_BackupJobsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_BackupJobsTest ON BackupJobsTest
(
	 MSMT_TIME
);
DROP TABLE BackupJobsTest_TREND;

CREATE TABLE BackupJobsTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO           		varchar(128)	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       		varchar(32) 	NOT NULL,
	ACTIVE_JOB_COUNT_MIN 	DECIMAL(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX 	DECIMAL(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_STCNT 	varchar(32) 	NOT NULL,
	FAILED_JOBS_COUNT_MIN 	DECIMAL(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_MAX 	DECIMAL(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_STCNT varchar(32) 	NOT NULL,
	SUCCESSFUL_JOBS_MIN 	DECIMAL(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_MAX 	DECIMAL(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_STCNT 	varchar(32) 	NOT NULL,
	TOTAL_BYTES_MIN 	DECIMAL(20,4) 	NOT NULL,
	TOTAL_BYTES_MAX 	DECIMAL(20,4) 	NOT NULL,
	TOTAL_BYTES_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest_TREND ADD constraint PK_BackupJobsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BackupJobsTest_THRESH;

CREATE TABLE BackupJobsTest_THRESH 
( 	
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64)	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	ACTIVE_JOB_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MIN	VARCHAR(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_BYTES_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_BYTES_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE BackupJobsTest_THRESH ADD constraint PK_BackupJobsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_BackupJobsTest_THRESH ON BackupJobsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE VeritasStatsTest;

CREATE TABLE VeritasStatsTest
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO       	  	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	ABORTED_JOBS 		DECIMAL(20,4) 	NOT NULL,
	ABORTED_JOBS_ST 	varchar(32) 	NOT NULL,
	CORRUPTED_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_ST 	varchar(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_ST varchar(32) 	NOT NULL,
	FAILED_VERIFY_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	FAILED_VERIFY_OBJECTS_ST varchar(32) 	NOT NULL,
	SKIPPED_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest ADD constraint PK_VeritasStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_VeritasStatsTest ON VeritasStatsTest
(
	 MSMT_TIME
);
DROP TABLE VeritasStatsTest_TREND;

CREATE TABLE VeritasStatsTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME      	 	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       		varchar(32) 	NOT NULL,
	ABORTED_JOBS_MIN 	DECIMAL(20,4) 	NOT NULL,
	ABORTED_JOBS_MAX 	DECIMAL(20,4) 	NOT NULL,
	ABORTED_JOBS_STCNT 	varchar(32) 	NOT NULL,
	CORRUPTED_OBJECTS_MIN 	DECIMAL(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_MAX 	DECIMAL(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_STCNT varchar(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN DECIMAL(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX DECIMAL(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_STCNT varchar(32) NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN DECIMAL(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX DECIMAL(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_STCNT varchar(32) NOT NULL,
	SKIPPED_OBJECTS_MIN 	DECIMAL(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_MAX 	DECIMAL(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest_TREND ADD constraint PK_VeritasStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE VeritasStatsTest_THRESH;

CREATE TABLE VeritasStatsTest_THRESH
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	ABORTED_JOBS_MIN	VARCHAR(256)	 	NOT NULL,
	ABORTED_JOBS_MAX	VARCHAR(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MIN	VARCHAR(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MAX	VARCHAR(256)	 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN	VARCHAR(256)	 NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX	VARCHAR(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN	VARCHAR(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX	VARCHAR(256)	 NOT NULL,
	SKIPPED_OBJECTS_MIN	VARCHAR(256)	 	NOT NULL,
	SKIPPED_OBJECTS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE VeritasStatsTest_THRESH ADD constraint PK_VeritasStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_VeritasStatsTest_THRESH ON VeritasStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE EventLogTest;

CREATE TABLE EventLogTest
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO       	  	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	APP_ERROR_CNT		DECIMAL(20,4)	NOT NULL,
	APP_ERROR_CNT_ST	varchar(32)	NOT NULL,
	APP_INFRM_CNT		DECIMAL(20,4)	NOT NULL,
	APP_INFRM_CNT_ST	varchar(32)	NOT NULL,
	APP_WARNING_CNT		DECIMAL(20,4)	NOT NULL,
	APP_WARNING_CNT_ST	varchar(32)	NOT NULL,
	SYS_ERROR_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_ERROR_CNT_ST	varchar(32)	NOT NULL,
	SYS_INFRM_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_INFRM_CNT_ST	varchar(32)	NOT NULL,
	SYS_WARNING_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_WARNING_CNT_ST	varchar(32)	NOT NULL,
	APP_CRITICAL_CNT	DECIMAL(20,4)	NOT NULL,
	APP_CRITICAL_CNT_ST	varchar(32)	NOT NULL,
	APP_VERBOSE_CNT		DECIMAL(20,4)	NOT NULL,
	APP_VERBOSE_CNT_ST	varchar(32)	NOT NULL,
	SYS_CRITICAL_CNT	DECIMAL(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_ST	varchar(32)	NOT NULL,
	SYS_VERBOSE_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_ST	varchar(32)	NOT NULL
	
);

ALTER TABLE EventLogTest ADD constraint PK_EventLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_EventLogTest ON EventLogTest
(
	 MSMT_TIME
);
DROP TABLE EventLogTest_TREND;

CREATE TABLE EventLogTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME      	 	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       		varchar(32) 	NOT NULL,
	APP_ERROR_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_ERROR_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_ERROR_CNT_STCNT	varchar(32)	NOT NULL,
	APP_INFRM_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_INFRM_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_INFRM_CNT_STCNT	varchar(32)	NOT NULL,
	APP_WARNING_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_WARNING_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_WARNING_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_ERROR_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_ERROR_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_ERROR_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_INFRM_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_INFRM_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_INFRM_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_WARNING_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_WARNING_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_WARNING_CNT_STCNT	varchar(32)	NOT NULL,
	APP_CRITICAL_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_CRITICAL_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_CRITICAL_CNT_STCNT	varchar(32)	NOT NULL,
	APP_VERBOSE_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_VERBOSE_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_VERBOSE_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_CRITICAL_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_VERBOSE_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_STCNT	varchar(32)	NOT NULL
);

ALTER TABLE EventLogTest_TREND ADD constraint PK_EventLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE EventLogTest_THRESH;

CREATE TABLE EventLogTest_THRESH
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	APP_ERROR_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_ERROR_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_INFRM_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_INFRM_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_WARNING_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_WARNING_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_ERROR_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_ERROR_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_INFRM_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_INFRM_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_WARNING_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_WARNING_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_CRITICAL_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_CRITICAL_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_VERBOSE_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_VERBOSE_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_CRITICAL_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_CRITICAL_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_VERBOSE_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_VERBOSE_CNT_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE EventLogTest_THRESH ADD constraint PK_EventLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_EventLogTest_THRESH ON EventLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JavaServerTest;

CREATE TABLE JavaServerTest
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO                	varchar(32) 	NOT NULL,
	SITE_NAME        	varchar(64) 	NOT NULL,
	INFO       	  	        varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	ACTIVE_THREAD_CNT	DECIMAL(20,4)	NOT NULL,
	ACTIVE_THREAD_CNT_ST	varchar(32)	NOT NULL,
	TOTAL_MEMORY		        DECIMAL(20,4)	NOT NULL,
	TOTAl_MEMORY_ST	        varchar(32)	NOT NULL,
	FREE_MEMORY		        DECIMAL(20,4)	NOT NULL,
	FREE_MEMORY_ST	        varchar(32)	NOT NULL
);

ALTER TABLE JavaServerTest ADD constraint PK_JavaServerTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE INDEX IDX_JavaServerTest ON JavaServerTest
(
	 MSMT_TIME
);
DROP TABLE JavaServerTest_TREND;

CREATE TABLE JavaServerTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO              	varchar(32) 	NOT NULL,
	SITE_NAME      	 	varchar(64) 	NOT NULL,
	INFO            	        varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       	        varchar(32) NOT NULL,
	ACTIVE_THREAD_CNT_MIN	        DECIMAL(20,4)	NOT NULL,
	ACTIVE_THREAD_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	ACTIVE_THREAD_CNT_STCNT	varchar(32)	NOT NULL,
	TOTAL_MEMORY_MIN	        DECIMAL(20,4)	NOT NULL,
	TOTAL_MEMORY_MAX	        DECIMAL(20,4)	NOT NULL,
	TOTAL_MEMORY_STCNT	varchar(32)	NOT NULL,
	FREE_MEMORY_MIN	        DECIMAL(20,4)	NOT NULL,
	FREE_MEMORY_MAX    	DECIMAL(20,4)	NOT NULL,
	FREE_MEMORY_STCNT	varchar(32)	NOT NULL
);

ALTER TABLE JavaServerTest_TREND ADD constraint PK_JavaServerTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JavaServerTest_THRESH;

CREATE TABLE JavaServerTest_THRESH
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO               	varchar(32) 	NOT NULL,
	SITE_NAME       	        varchar(64) 	NOT NULL,
	INFO            	        varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	ACTIVE_THREAD_CNT_MIN	VARCHAR(256)		NOT NULL,
	ACTIVE_THREAD_CNT_MAX	VARCHAR(256)		NOT NULL,
	TOTAL_MEMORY_MIN	VARCHAR(256)		NOT NULL,
	TOTAL_MEMORY_MAX	VARCHAR(256)		NOT NULL,
	FREE_MEMORY_MIN	VARCHAR(256)		NOT NULL,
	FREE_MEMORY_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE JavaServerTest_THRESH ADD constraint PK_JavaServerTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_JavaServerTest_THRESH ON JavaServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TcpConnectionTest;

CREATE TABLE TcpConnectionTest
( 
	TRGT_HOST      varchar(32) NOT NULL, 
	PORT_NO          varchar(32) NOT NULL,  
	SITE_NAME       varchar(64) NOT NULL,    
	INFO                 varchar(128) NOT NULL,	
	MSMT_HOST      varchar(32) NOT NULL,	
	MSMT_TIME       datetime NOT NULL,
	AVAILABILITY          DECIMAL(20,4) NOT NULL,
	AVAILABILITY_ST     varchar(32) NOT NULL,
	RESPONSETIME        DECIMAL(20,4) NOT NULL,
	RESPONSETIME_ST  varchar(32) NOT NULL
);

ALTER TABLE TcpConnectionTest ADD constraint PK_TcpConnectionTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_TcpConnectionTest ON TcpConnectionTest
(
	 MSMT_TIME
);
DROP TABLE TcpConnectionTest_TREND;

CREATE TABLE TcpConnectionTest_TREND
(
	TRGT_HOST       varchar(32) NOT NULL,  
	PORT_NO           varchar(32) NOT NULL,  
	SITE_NAME        varchar(64) NOT NULL,
	INFO                  varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,	
	PERIOD       	varchar(32) NOT NULL,
	AVAILABILITY_MIN        DECIMAL(20,4) NOT NULL,
	AVAILABILITY_MAX       DECIMAL(20,4) NOT NULL,
	AVAILABILITY_STCNT    varchar(32) NOT NULL,
	RESPONSETIME_MIN      DECIMAL(20,4) NOT NULL,
	RESPONSETIME_MAX     DECIMAL(20,4) NOT NULL,
	RESPONSETIME_STCNT varchar(32) NOT NULL
);

ALTER TABLE TcpConnectionTest_TREND ADD constraint PK_TcpConnectionTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE TcpConnectionTest_THRESH;

CREATE TABLE TcpConnectionTest_THRESH 
( 
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO           varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL, 
	INFO                  varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,	
	MSMT_TIME_START  datetime NOT NULL,
	MSMT_TIME_END     datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MIN	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE TcpConnectionTest_THRESH ADD constraint PK_TcpConnectionTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TcpConnectionTest_THRESH ON TcpConnectionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TcpPortStatusTest;

CREATE TABLE TcpPortStatusTest( 
	TRGT_HOST       varchar(32) NOT NULL, 
	PORT_NO         varchar(32) NOT NULL,  
	SITE_NAME       varchar(64) NOT NULL,    
	INFO            varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,	
	MSMT_TIME       datetime NOT NULL,
	AVAILABILITY    DECIMAL(20,4) NOT NULL,
	AVAILABILITY_ST varchar(32) NOT NULL,
	RESPONSETIME    DECIMAL(20,4) NOT NULL,
	RESPONSETIME_ST varchar(32) NOT NULL);

ALTER TABLE TcpPortStatusTest ADD constraint PK_TcpPortStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_TcpPortStatusTest ON TcpPortStatusTest (MSMT_TIME) INCLUDE(AVAILABILITY);

DROP TABLE TcpPortStatusTest_TREND;

CREATE TABLE TcpPortStatusTest_TREND(
	TRGT_HOST          varchar(32) NOT NULL,  
	PORT_NO            varchar(32) NOT NULL,  
	SITE_NAME          varchar(64) NOT NULL,
	INFO               varchar(128) NOT NULL,	
	MSMT_HOST          varchar(32) NOT NULL,
	MSMT_TIME          datetime NOT NULL,	
	PERIOD       	   varchar(32) NOT NULL,
	AVAILABILITY_MIN   DECIMAL(20,4) NOT NULL,
	AVAILABILITY_MAX   DECIMAL(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar(32) NOT NULL,
	RESPONSETIME_MIN   DECIMAL(20,4) NOT NULL,
	RESPONSETIME_MAX   DECIMAL(20,4) NOT NULL,
	RESPONSETIME_STCNT varchar(32) NOT NULL);

ALTER TABLE TcpPortStatusTest_TREND ADD constraint PK_TcpPortStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE TcpPortStatusTest_THRESH;

CREATE TABLE TcpPortStatusTest_THRESH( 
	TRGT_HOST           varchar(32) NOT NULL,
	PORT_NO             varchar(32) NOT NULL,
	SITE_NAME           varchar(64) NOT NULL, 
	INFO                varchar(128) NOT NULL,	
	MSMT_HOST           varchar(32) NOT NULL,	
	MSMT_TIME_START     datetime NOT NULL,
	MSMT_TIME_END       datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MIN	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TcpPortStatusTest_THRESH ADD constraint PK_TcpPortStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TcpPortStatusTest_THRESH ON TcpPortStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE ProcessPoolTest;

CREATE TABLE ProcessPoolTest
(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO           varchar(32) NOT NULL, 
	SITE_NAME        varchar(64) NOT NULL,  
	INFO                  varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME        datetime NOT NULL,
	NUMBER_OF_PROCESSES        DECIMAL(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_ST   varchar(32) NOT NULL,
	PERCENTAGE_CPU_UTIL          DECIMAL(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_ST     varchar(32) NOT NULL,
	PERCENTAGE_MEM_UTIL          DECIMAL(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_ST     varchar(32) NOT NULL
);

ALTER TABLE ProcessPoolTest ADD constraint PK_ProcessPoolTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_ProcessPoolTest ON ProcessPoolTest
(
	 MSMT_TIME
);
DROP TABLE ProcessPoolTest_TREND;

CREATE TABLE ProcessPoolTest_TREND
( 
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO           varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO                 varchar(128) NOT NULL,	
	MSMT_HOST      varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	NUMBER_OF_PROCESSES_MIN        DECIMAL(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_MAX       DECIMAL(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_STCNT   varchar(32) NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN         DECIMAL(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX        DECIMAL(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_STCNT    varchar(32) NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN        DECIMAL(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX       DECIMAL(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_STCNT   varchar(32) NOT NULL
);

ALTER TABLE ProcessPoolTest_TREND ADD constraint PK_ProcessPoolTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ProcessPoolTest_THRESH;

CREATE TABLE ProcessPoolTest_THRESH
(
	TRGT_HOST      varchar(32) NOT NULL, 
	PORT_NO          varchar(32) NOT NULL, 
	SITE_NAME        varchar(64) NOT NULL,
	INFO                  varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,	
	MSMT_TIME_START  datetime NOT NULL,
	MSMT_TIME_END     datetime NOT NULL,
	NUMBER_OF_PROCESSES_MIN	VARCHAR(256)	 NOT NULL,
	NUMBER_OF_PROCESSES_MAX	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ProcessPoolTest_THRESH ADD constraint PK_ProcessPoolTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProcessPoolTest_THRESH ON ProcessPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ErrorLogTest;

CREATE TABLE ErrorLogTest
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL,    
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar(32) NOT NULL
);

ALTER TABLE ErrorLogTest ADD constraint PK_ErrorLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_ErrorLogTest ON ErrorLogTest
(
	 MSMT_TIME
);
DROP TABLE ErrorLogTest_TREND;

CREATE TABLE ErrorLogTest_TREND
(
 	TRGT_HOST       varchar(32) NOT NULL,   
    PORT_NO         varchar(32) NOT NULL,  
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL
);

ALTER TABLE ErrorLogTest_TREND ADD constraint PK_ErrorLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ErrorLogTest_THRESH;

CREATE TABLE ErrorLogTest_THRESH
( 
	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL, 
    SITE_NAME       varchar(64) NOT NULL, 
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ErrorLogTest_THRESH ADD constraint PK_ErrorLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ErrorLogTest_THRESH ON ErrorLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsgLogTest;

CREATE TABLE MsgLogTest
(
 	TRGT_HOST       varchar(32) NOT NULL,  
    PORT_NO         varchar(32) NOT NULL,   
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar(32) NOT NULL
);

ALTER TABLE MsgLogTest ADD constraint PK_MsgLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_MsgLogTest ON MsgLogTest
(
	 MSMT_TIME
);
DROP TABLE MsgLogTest_TREND;

CREATE TABLE MsgLogTest_TREND
(
 	TRGT_HOST       varchar(32) NOT NULL,   
    PORT_NO         varchar(32) NOT NULL,
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL
);

ALTER TABLE MsgLogTest_TREND ADD constraint PK_MsgLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MsgLogTest_THRESH;
CREATE TABLE MsgLogTest_THRESH
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL, 
    SITE_NAME       varchar(64) NOT NULL, 
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsgLogTest_THRESH ADD constraint PK_MsgLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsgLogTest_THRESH ON MsgLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE XceptionLogTest;

CREATE TABLE XceptionLogTest
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL,  
    SITE_NAME       varchar(64) NOT NULL, 
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar(32) NOT NULL
);

ALTER TABLE XceptionLogTest ADD constraint PK_XceptionLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_XceptionLogTest ON XceptionLogTest
(
	 MSMT_TIME
);
DROP TABLE XceptionLogTest_TREND;

CREATE TABLE XceptionLogTest_TREND 
( 
	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL,  
    SITE_NAME       varchar(64) NOT NULL,   
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL, 
    LOW_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL
);

ALTER TABLE XceptionLogTest_TREND ADD constraint PK_XceptionLogTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE XceptionLogTest_THRESH;

CREATE TABLE XceptionLogTest_THRESH
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL, 
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,  
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE XceptionLogTest_THRESH ADD constraint PK_XceptionLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XceptionLogTest_THRESH ON XceptionLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE CiscoCatalystTest;

CREATE TABLE CiscoCatalystTest (
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
DATA_RECVD_RATE decimal(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar(32) NOT NULL,
DATA_XMIT_RATE decimal(20,4) NOT NULL,
DATA_XMIT_RATE_ST varchar(32) NOT NULL,
PCT_BANDWIDTH_USED decimal(20,4) NOT NULL,
PCT_BANDWIDTH_USED_ST varchar(32) NOT NULL);

ALTER TABLE CiscoCatalystTest ADD constraint PK_CiscoCatalystTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_CiscoCatalystTest ON CiscoCatalystTest
(
	 MSMT_TIME
);
DROP TABLE CiscoCatalystTest_TREND;

CREATE TABLE CiscoCatalystTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,       
PORT_NO         varchar(32) NOT NULL,       
SITE_NAME       varchar(64) NOT NULL,       
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       datetime NOT NULL,	
PERIOD       	varchar(32) NOT NULL,
DATA_RECVD_RATE_MIN decimal(20,4) NOT NULL,
DATA_RECVD_RATE_MAX decimal(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar(32) NOT NULL,
DATA_XMIT_RATE_MIN decimal(20,4) NOT NULL,
DATA_XMIT_RATE_MAX decimal(20,4) NOT NULL,
DATA_XMIT_RATE_STCNT varchar(32) NOT NULL,
PCT_BANDWIDTH_USED_MIN decimal(20,4) NOT NULL,
PCT_BANDWIDTH_USED_MAX decimal(20,4) NOT NULL,
PCT_BANDWIDTH_USED_STCNT varchar(32) NOT NULL);

ALTER TABLE CiscoCatalystTest_TREND ADD constraint PK_CiscoCatalystTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CiscoCatalystTest_THRESH;

CREATE TABLE CiscoCatalystTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,       
PORT_NO         varchar(32) NOT NULL,       
SITE_NAME       varchar(64) NOT NULL,       
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START datetime NOT NULL,	
MSMT_TIME_END   datetime NOT NULL,
DATA_RECVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
DATA_RECVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
DATA_XMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
DATA_XMIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MIN	VARCHAR(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CiscoCatalystTest_THRESH ADD constraint PK_CiscoCatalystTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_CiscoCatalystTest_THRESH ON CiscoCatalystTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxARTimeTest;

CREATE TABLE TuxARTimeTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AVAILABILITY DECIMAL(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL,
RESPONSE_TIME decimal(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE TuxARTimeTest ADD constraint PK_TuxARTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxARTimeTest ON TuxARTimeTest
(
	 MSMT_TIME
);
DROP TABLE TuxARTimeTest_TREND;

CREATE TABLE TuxARTimeTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN decimal(20,4) NOT NULL,
RESPONSE_TIME_MAX decimal(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxARTimeTest_TREND ADD constraint PK_TuxARTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxARTimeTest_THRESH;

CREATE TABLE TuxARTimeTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxARTimeTest_THRESH ADD constraint PK_TuxARTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxARTimeTest_THRESH ON TuxARTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxBridgeTest;

CREATE TABLE TuxBridgeTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
BRIDGE_STATE decimal(20,4) NOT NULL,
BRIDGE_STATE_ST varchar(32) NOT NULL,
BYT_RCVD_RATE DECIMAL(20,4) NOT NULL,
BYT_RCVD_RATE_ST varchar(32) NOT NULL,
BYT_SENT_RATE DECIMAL(20,4) NOT NULL,
BYT_SENT_RATE_ST varchar(32) NOT NULL,
MSG_RCVD_RATE DECIMAL(20,4) NOT NULL,
MSG_RCVD_RATE_ST varchar(32) NOT NULL,
MSG_SENT_RATE DECIMAL(20,4) NOT NULL,
MSG_SENT_RATE_ST varchar(32) NOT NULL);

ALTER TABLE TuxBridgeTest ADD constraint PK_TuxBridgeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxBridgeTest ON TuxBridgeTest
(
	 MSMT_TIME
);
DROP TABLE TuxBridgeTest_TREND;

CREATE TABLE TuxBridgeTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
BRIDGE_STATE_MIN decimal(20,4) NOT NULL,
BRIDGE_STATE_MAX decimal(20,4) NOT NULL,
BRIDGE_STATE_STCNT varchar(32) NOT NULL,
BYT_RCVD_RATE_MIN DECIMAL(20,4) NOT NULL,
BYT_RCVD_RATE_MAX DECIMAL(20,4) NOT NULL,
BYT_RCVD_RATE_STCNT varchar(32) NOT NULL,
BYT_SENT_RATE_MIN DECIMAL(20,4) NOT NULL,
BYT_SENT_RATE_MAX DECIMAL(20,4) NOT NULL,
BYT_SENT_RATE_STCNT varchar(32) NOT NULL,
MSG_RCVD_RATE_MIN DECIMAL(20,4) NOT NULL,
MSG_RCVD_RATE_MAX DECIMAL(20,4) NOT NULL,
MSG_RCVD_RATE_STCNT varchar(32) NOT NULL,
MSG_SENT_RATE_MIN DECIMAL(20,4) NOT NULL,
MSG_SENT_RATE_MAX DECIMAL(20,4) NOT NULL,
MSG_SENT_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxBridgeTest_TREND ADD constraint PK_TuxBridgeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxBridgeTest_THRESH;

CREATE TABLE TuxBridgeTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
BRIDGE_STATE_MIN	VARCHAR(256)	 NOT NULL,
BRIDGE_STATE_MAX	VARCHAR(256)	 NOT NULL,
BYT_RCVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
BYT_RCVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
BYT_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
BYT_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL,
MSG_RCVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
MSG_RCVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
MSG_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
MSG_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxBridgeTest_THRESH ADD constraint PK_TuxBridgeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxBridgeTest_THRESH ON TuxBridgeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxDomainTest;

CREATE TABLE TuxDomainTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CURR_MACS decimal(20,4) NOT NULL,
CURR_MACS_ST varchar(32) NOT NULL,
CURR_SERVERS decimal(20,4) NOT NULL,
CURR_SERVERS_ST varchar(32) NOT NULL,
CURR_QS decimal(20,4) NOT NULL,
CURR_QS_ST varchar(32) NOT NULL,
CURR_SERVICES decimal(20,4) NOT NULL,
CURR_SERVICES_ST varchar(32) NOT NULL,
MAC_PCT_UTIL DECIMAL(20,4) NOT NULL,
MAC_PCT_UTIL_ST varchar(32) NOT NULL,
SERVER_PCT_UTIL DECIMAL(20,4) NOT NULL,
SERVER_PCT_UTIL_ST varchar(32) NOT NULL,
Q_PCT_UTIL DECIMAL(20,4) NOT NULL,
Q_PCT_UTIL_ST varchar(32) NOT NULL,
SERVICE_PCT_UTIL DECIMAL(20,4) NOT NULL,
SERVICE_PCT_UTIL_ST varchar(32) NOT NULL);

ALTER TABLE TuxDomainTest ADD constraint PK_TuxDomainTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxDomainTest ON TuxDomainTest
(
	 MSMT_TIME
);
DROP TABLE TuxDomainTest_TREND;

CREATE TABLE TuxDomainTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURR_MACS_MIN decimal(20,4) NOT NULL,
CURR_MACS_MAX decimal(20,4) NOT NULL,
CURR_MACS_STCNT varchar(32) NOT NULL,
CURR_SERVERS_MIN decimal(20,4) NOT NULL,
CURR_SERVERS_MAX decimal(20,4) NOT NULL,
CURR_SERVERS_STCNT varchar(32) NOT NULL,
CURR_QS_MIN decimal(20,4) NOT NULL,
CURR_QS_MAX decimal(20,4) NOT NULL,
CURR_QS_STCNT varchar(32) NOT NULL,
CURR_SERVICES_MIN decimal(20,4) NOT NULL,
CURR_SERVICES_MAX decimal(20,4) NOT NULL,
CURR_SERVICES_STCNT varchar(32) NOT NULL,
MAC_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
MAC_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
MAC_PCT_UTIL_STCNT varchar(32) NOT NULL,
SERVER_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
SERVER_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
SERVER_PCT_UTIL_STCNT varchar(32) NOT NULL,
Q_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
Q_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
Q_PCT_UTIL_STCNT varchar(32) NOT NULL,
SERVICE_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
SERVICE_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
SERVICE_PCT_UTIL_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxDomainTest_TREND ADD constraint PK_TuxDomainTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxDomainTest_THRESH;

CREATE TABLE TuxDomainTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CURR_MACS_MIN	VARCHAR(256)	 NOT NULL,
CURR_MACS_MAX	VARCHAR(256)	 NOT NULL,
CURR_SERVERS_MIN	VARCHAR(256)	 NOT NULL,
CURR_SERVERS_MAX	VARCHAR(256)	 NOT NULL,
CURR_QS_MIN	VARCHAR(256)	 NOT NULL,
CURR_QS_MAX	VARCHAR(256)	 NOT NULL,
CURR_SERVICES_MIN	VARCHAR(256)	 NOT NULL,
CURR_SERVICES_MAX	VARCHAR(256)	 NOT NULL,
MAC_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
MAC_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL,
SERVER_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
SERVER_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL,
Q_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
Q_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL,
SERVICE_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
SERVICE_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxDomainTest_THRESH ADD constraint PK_TuxDomainTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxDomainTest_THRESH ON TuxDomainTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxProcsTest;

CREATE TABLE TuxProcsTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NUM_OF_PROCS decimal(20,4) NOT NULL,
NUM_OF_PROCS_ST varchar(32) NOT NULL,
CPU_UTIL_PCT DECIMAL(20,4) NOT NULL,
CPU_UTIL_PCT_ST varchar(32) NOT NULL,
MEM_UTIL_PCT DECIMAL(20,4) NOT NULL,
MEM_UTIL_PCT_ST varchar(32) NOT NULL);

ALTER TABLE TuxProcsTest ADD constraint PK_TuxProcsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxProcsTest ON TuxProcsTest
(
	 MSMT_TIME
);
DROP TABLE TuxProcsTest_TREND;

CREATE TABLE TuxProcsTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUM_OF_PROCS_MIN decimal(20,4) NOT NULL,
NUM_OF_PROCS_MAX decimal(20,4) NOT NULL,
NUM_OF_PROCS_STCNT varchar(32) NOT NULL,
CPU_UTIL_PCT_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_PCT_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_PCT_STCNT varchar(32) NOT NULL,
MEM_UTIL_PCT_MIN DECIMAL(20,4) NOT NULL,
MEM_UTIL_PCT_MAX DECIMAL(20,4) NOT NULL,
MEM_UTIL_PCT_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxProcsTest_TREND ADD constraint PK_TuxProcsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxProcsTest_THRESH;

CREATE TABLE TuxProcsTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NUM_OF_PROCS_MIN	VARCHAR(256)	 NOT NULL,
NUM_OF_PROCS_MAX	VARCHAR(256)	 NOT NULL,
CPU_UTIL_PCT_MIN	VARCHAR(256)	 NOT NULL,
CPU_UTIL_PCT_MAX	VARCHAR(256)	 NOT NULL,
MEM_UTIL_PCT_MIN	VARCHAR(256)	 NOT NULL,
MEM_UTIL_PCT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxProcsTest_THRESH ADD constraint PK_TuxProcsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxProcsTest_THRESH ON TuxProcsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServerTest;

CREATE TABLE TuxServerTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVER_STATE decimal(20,4) NOT NULL,
SERVER_STATE_ST varchar(32) NOT NULL,
TOTWRKLC_RATE DECIMAL(20,4) NOT NULL,
TOTWRKLC_RATE_ST varchar(32) NOT NULL,
TOTAL_CONV decimal(20,4) NOT NULL,
TOTAL_CONV_ST varchar(32) NOT NULL,
CURR_ACTIVE_CONV decimal(20,4) NOT NULL,
CURR_ACTIVE_CONV_ST varchar(32) NOT NULL,
TOTAL_REQ decimal(20,4) NOT NULL,
TOTAL_REQ_ST varchar(32) NOT NULL,
CURR_ACTIVE_REQ decimal(20,4) NOT NULL,
CURR_ACTIVE_REQ_ST varchar(32) NOT NULL,
TRAN_INIT_RATE DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar(32) NOT NULL,
TRAN_ABT_RATE DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar(32) NOT NULL,
TRAN_CMT_RATE DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar(32) NOT NULL,
TOTREQC_RATE DECIMAL(20,4) NOT NULL,
TOTREQC_RATE_ST varchar(32) NOT NULL);

ALTER TABLE TuxServerTest ADD constraint PK_TuxServerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxServerTest ON TuxServerTest
(
	 MSMT_TIME
);
DROP TABLE TuxServerTest_TREND;

CREATE TABLE TuxServerTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVER_STATE_MIN decimal(20,4) NOT NULL,
SERVER_STATE_MAX decimal(20,4) NOT NULL,
SERVER_STATE_STCNT varchar(32) NOT NULL,
TOTWRKLC_RATE_MIN DECIMAL(20,4) NOT NULL,
TOTWRKLC_RATE_MAX DECIMAL(20,4) NOT NULL,
TOTWRKLC_RATE_STCNT varchar(32) NOT NULL,
TOTAL_CONV_MIN decimal(20,4) NOT NULL,
TOTAL_CONV_MAX decimal(20,4) NOT NULL,
TOTAL_CONV_STCNT varchar(32) NOT NULL,
CURR_ACTIVE_CONV_MIN decimal(20,4) NOT NULL,
CURR_ACTIVE_CONV_MAX decimal(20,4) NOT NULL,
CURR_ACTIVE_CONV_STCNT varchar(32) NOT NULL,
TOTAL_REQ_MIN decimal(20,4) NOT NULL,
TOTAL_REQ_MAX decimal(20,4) NOT NULL,
TOTAL_REQ_STCNT varchar(32) NOT NULL,
CURR_ACTIVE_REQ_MIN decimal(20,4) NOT NULL,
CURR_ACTIVE_REQ_MAX decimal(20,4) NOT NULL,
CURR_ACTIVE_REQ_STCNT varchar(32) NOT NULL,
TRAN_INIT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar(32) NOT NULL,
TRAN_ABT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar(32) NOT NULL,
TRAN_CMT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar(32) NOT NULL,
TOTREQC_RATE_MIN DECIMAL(20,4) NOT NULL,
TOTREQC_RATE_MAX DECIMAL(20,4) NOT NULL,
TOTREQC_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxServerTest_TREND ADD constraint PK_TuxServerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServerTest_THRESH;

CREATE TABLE TuxServerTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVER_STATE_MIN	VARCHAR(256)	 NOT NULL,
SERVER_STATE_MAX	VARCHAR(256)	 NOT NULL,
TOTWRKLC_RATE_MIN	VARCHAR(256)	 NOT NULL,
TOTWRKLC_RATE_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_CONV_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_CONV_MAX	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_CONV_MIN	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_CONV_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_REQ_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_REQ_MAX	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_REQ_MIN	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_REQ_MAX	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TOTREQC_RATE_MIN	VARCHAR(256)	 NOT NULL,
TOTREQC_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxServerTest_THRESH ADD constraint PK_TuxServerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServerTest_THRESH ON TuxServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServiceTest;

CREATE TABLE TuxServiceTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVICE_STATE decimal(20,4) NOT NULL,
SERVICE_STATE_ST varchar(32) NOT NULL,
LD_IMPOSED decimal(20,4) NOT NULL,
LD_IMPOSED_ST varchar(32) NOT NULL,
REQ_COMPLTD_RATE DECIMAL(20,4) NOT NULL,
REQ_COMPLTD_RATE_ST varchar(32) NOT NULL,
REQ_CURR_QUD decimal(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar(32) NOT NULL);

ALTER TABLE TuxServiceTest ADD constraint PK_TuxServiceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxServiceTest ON TuxServiceTest
(
	 MSMT_TIME
);
DROP TABLE TuxServiceTest_TREND;

CREATE TABLE TuxServiceTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVICE_STATE_MIN decimal(20,4) NOT NULL,
SERVICE_STATE_MAX decimal(20,4) NOT NULL,
SERVICE_STATE_STCNT varchar(32) NOT NULL,
LD_IMPOSED_MIN decimal(20,4) NOT NULL,
LD_IMPOSED_MAX decimal(20,4) NOT NULL,
LD_IMPOSED_STCNT varchar(32) NOT NULL,
REQ_COMPLTD_RATE_MIN DECIMAL(20,4) NOT NULL,
REQ_COMPLTD_RATE_MAX DECIMAL(20,4) NOT NULL,
REQ_COMPLTD_RATE_STCNT varchar(32) NOT NULL,
REQ_CURR_QUD_MIN decimal(20,4) NOT NULL,
REQ_CURR_QUD_MAX decimal(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxServiceTest_TREND ADD constraint PK_TuxServiceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServiceTest_THRESH;

CREATE TABLE TuxServiceTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVICE_STATE_MIN	VARCHAR(256)	 NOT NULL,
SERVICE_STATE_MAX	VARCHAR(256)	 NOT NULL,
LD_IMPOSED_MIN	VARCHAR(256)	 NOT NULL,
LD_IMPOSED_MAX	VARCHAR(256)	 NOT NULL,
REQ_COMPLTD_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_COMPLTD_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxServiceTest_THRESH ADD constraint PK_TuxServiceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServiceTest_THRESH ON TuxServiceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxSiteTest;

CREATE TABLE TuxSiteTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SITE_STATE decimal(20,4) NOT NULL,
SITE_STATE_ST varchar(32) NOT NULL,
TRAN_ABT_RATE DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar(32) NOT NULL,
TRAN_CMT_RATE DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar(32) NOT NULL,
TLISTEN_STATE decimal(20,4) NOT NULL,
TLISTEN_STATE_ST varchar(32) NOT NULL,
CURR_CLTS decimal(20,4) NOT NULL,
CURR_CLTS_ST varchar(32) NOT NULL,
CUR_WS_CLTS decimal(20,4) NOT NULL,
CUR_WS_CLTS_ST varchar(32) NOT NULL,
CURR_CONV decimal(20,4) NOT NULL,
CURR_CONV_ST varchar(32) NOT NULL,
CURR_GT decimal(20,4) NOT NULL,
CURR_GT_ST varchar(32) NOT NULL,
CURR_LOAD_RATE DECIMAL(20,4) NOT NULL,
CURR_LOAD_RATE_ST varchar(32) NOT NULL,
WK_COMPLETED_RATE DECIMAL(20,4) NOT NULL,
WK_COMPLETED_RATE_ST varchar(32) NOT NULL,
WK_INIT_RATE DECIMAL(20,4) NOT NULL,
WK_INIT_RATE_ST varchar(32) NOT NULL,
TRAN_INIT_RATE DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar(32) NOT NULL);

ALTER TABLE TuxSiteTest ADD constraint PK_TuxSiteTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxSiteTest ON TuxSiteTest
(
	 MSMT_TIME
);
DROP TABLE TuxSiteTest_TREND;

CREATE TABLE TuxSiteTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SITE_STATE_MIN decimal(20,4) NOT NULL,
SITE_STATE_MAX decimal(20,4) NOT NULL,
SITE_STATE_STCNT varchar(32) NOT NULL,
TRAN_ABT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar(32) NOT NULL,
TRAN_CMT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar(32) NOT NULL,
TLISTEN_STATE_MIN decimal(20,4) NOT NULL,
TLISTEN_STATE_MAX decimal(20,4) NOT NULL,
TLISTEN_STATE_STCNT varchar(32) NOT NULL,
CURR_CLTS_MIN decimal(20,4) NOT NULL,
CURR_CLTS_MAX decimal(20,4) NOT NULL,
CURR_CLTS_STCNT varchar(32) NOT NULL,
CUR_WS_CLTS_MIN decimal(20,4) NOT NULL,
CUR_WS_CLTS_MAX decimal(20,4) NOT NULL,
CUR_WS_CLTS_STCNT varchar(32) NOT NULL,
CURR_CONV_MIN decimal(20,4) NOT NULL,
CURR_CONV_MAX decimal(20,4) NOT NULL,
CURR_CONV_STCNT varchar(32) NOT NULL,
CURR_GT_MIN decimal(20,4) NOT NULL,
CURR_GT_MAX decimal(20,4) NOT NULL,
CURR_GT_STCNT varchar(32) NOT NULL,
CURR_LOAD_RATE_MIN DECIMAL(20,4) NOT NULL,
CURR_LOAD_RATE_MAX DECIMAL(20,4) NOT NULL,
CURR_LOAD_RATE_STCNT varchar(32) NOT NULL,
WK_COMPLETED_RATE_MIN DECIMAL(20,4) NOT NULL,
WK_COMPLETED_RATE_MAX DECIMAL(20,4) NOT NULL,
WK_COMPLETED_RATE_STCNT varchar(32) NOT NULL,
WK_INIT_RATE_MIN DECIMAL(20,4) NOT NULL,
WK_INIT_RATE_MAX DECIMAL(20,4) NOT NULL,
WK_INIT_RATE_STCNT varchar(32) NOT NULL,
TRAN_INIT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxSiteTest_TREND ADD constraint PK_TuxSiteTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxSiteTest_THRESH;

CREATE TABLE TuxSiteTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SITE_STATE_MIN	VARCHAR(256)	 NOT NULL,
SITE_STATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TLISTEN_STATE_MIN	VARCHAR(256)	 NOT NULL,
TLISTEN_STATE_MAX	VARCHAR(256)	 NOT NULL,
CURR_CLTS_MIN	VARCHAR(256)	 NOT NULL,
CURR_CLTS_MAX	VARCHAR(256)	 NOT NULL,
CUR_WS_CLTS_MIN	VARCHAR(256)	 NOT NULL,
CUR_WS_CLTS_MAX	VARCHAR(256)	 NOT NULL,
CURR_CONV_MIN	VARCHAR(256)	 NOT NULL,
CURR_CONV_MAX	VARCHAR(256)	 NOT NULL,
CURR_GT_MIN	VARCHAR(256)	 NOT NULL,
CURR_GT_MAX	VARCHAR(256)	 NOT NULL,
CURR_LOAD_RATE_MIN	VARCHAR(256)	 NOT NULL,
CURR_LOAD_RATE_MAX	VARCHAR(256)	 NOT NULL,
WK_COMPLETED_RATE_MIN	VARCHAR(256)	 NOT NULL,
WK_COMPLETED_RATE_MAX	VARCHAR(256)	 NOT NULL,
WK_INIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
WK_INIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxSiteTest_THRESH ADD constraint PK_TuxSiteTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxSiteTest_THRESH ON TuxSiteTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxTQueueTest;

CREATE TABLE TuxTQueueTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Q_STATE decimal(20,4) NOT NULL,
Q_STATE_ST varchar(32) NOT NULL,
SERVER_CNT decimal(20,4) NOT NULL,
SERVER_CNT_ST varchar(32) NOT NULL,
REQ_CURR_QUD decimal(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar(32) NOT NULL,
WKL_CURR_QUD decimal(20,4) NOT NULL,
WKL_CURR_QUD_ST varchar(32) NOT NULL);

ALTER TABLE TuxTQueueTest ADD constraint PK_TuxTQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxTQueueTest ON TuxTQueueTest
(
	 MSMT_TIME
);
DROP TABLE TuxTQueueTest_TREND;

CREATE TABLE TuxTQueueTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Q_STATE_MIN decimal(20,4) NOT NULL,
Q_STATE_MAX decimal(20,4) NOT NULL,
Q_STATE_STCNT varchar(32) NOT NULL,
SERVER_CNT_MIN decimal(20,4) NOT NULL,
SERVER_CNT_MAX decimal(20,4) NOT NULL,
SERVER_CNT_STCNT varchar(32) NOT NULL,
REQ_CURR_QUD_MIN decimal(20,4) NOT NULL,
REQ_CURR_QUD_MAX decimal(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar(32) NOT NULL,
WKL_CURR_QUD_MIN decimal(20,4) NOT NULL,
WKL_CURR_QUD_MAX decimal(20,4) NOT NULL,
WKL_CURR_QUD_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxTQueueTest_TREND ADD constraint PK_TuxTQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxTQueueTest_THRESH;

CREATE TABLE TuxTQueueTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Q_STATE_MIN	VARCHAR(256)	 NOT NULL,
Q_STATE_MAX	VARCHAR(256)	 NOT NULL,
SERVER_CNT_MIN	VARCHAR(256)	 NOT NULL,
SERVER_CNT_MAX	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR(256)	 NOT NULL,
WKL_CURR_QUD_MIN	VARCHAR(256)	 NOT NULL,
WKL_CURR_QUD_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxTQueueTest_THRESH ADD constraint PK_TuxTQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxTQueueTest_THRESH ON TuxTQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQManagerTest;

CREATE TABLE MQManagerTest (
TRGT_HOST varchar(32) NOT NULL,
PORT_NO varchar(32) NOT NULL, 
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
AVAILABILITY decimal(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL);

ALTER TABLE MQManagerTest ADD constraint PK_MQManagerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_MQManagerTest ON MQManagerTest
(
	 MSMT_TIME
);
DROP TABLE MQManagerTest_TREND;

CREATE TABLE MQManagerTest_TREND (
TRGT_HOST varchar(32) NOT NULL,
PORT_NO  varchar(32) NOT NULL,
SITE_NAME varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       dateTime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVAILABILITY_MIN decimal(20,4) NOT NULL,
AVAILABILITY_MAX decimal(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL);

ALTER TABLE MQManagerTest_TREND ADD constraint PK_MQManagerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MQManagerTest_THRESH;

CREATE TABLE MQManagerTest_THRESH (
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,  
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START dateTime NOT NULL,	
MSMT_TIME_END   dateTime NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MQManagerTest_THRESH ADD constraint PK_MQManagerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQManagerTest_THRESH ON MQManagerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQLocalQueueTest; 

CREATE TABLE MQLocalQueueTest ( 
TRGT_HOST       varchar(32) NOT NULL, 
PORT_NO         varchar(32) NOT NULL, 
SITE_NAME       varchar(64) NOT NULL,  
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
CURRENT_QUEUE_DEPTH decimal(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_ST varchar(32) NOT NULL,
QUEUE_FILL_PCT DECIMAL(20,4) NOT NULL,
QUEUE_FILL_PCT_ST varchar(32) NOT NULL);

ALTER TABLE MQLocalQueueTest ADD constraint PK_MQLocalQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MQLocalQueueTest ON MQLocalQueueTest
(
	 MSMT_TIME
);
DROP TABLE MQLocalQueueTest_TREND;

CREATE TABLE MQLocalQueueTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,     
PORT_NO         varchar(32) NOT NULL,       
SITE_NAME       varchar(64) NOT NULL,  
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURRENT_QUEUE_DEPTH_MIN decimal(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_MAX decimal(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_STCNT varchar(32) NOT NULL,
QUEUE_FILL_PCT_MIN DECIMAL(20,4) NOT NULL,
QUEUE_FILL_PCT_MAX DECIMAL(20,4) NOT NULL,
QUEUE_FILL_PCT_STCNT varchar(32) NOT NULL);

ALTER TABLE MQLocalQueueTest_TREND ADD constraint PK_MQLocalQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQLocalQueueTest_THRESH;

CREATE TABLE MQLocalQueueTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,   
PORT_NO         varchar(32) NOT NULL, 
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START dateTime NOT NULL,	
MSMT_TIME_END   dateTime NOT NULL,
CURRENT_QUEUE_DEPTH_MIN	VARCHAR(256)	 NOT NULL,
CURRENT_QUEUE_DEPTH_MAX	VARCHAR(256)	 NOT NULL,
QUEUE_FILL_PCT_MIN	VARCHAR(256)	 NOT NULL,
QUEUE_FILL_PCT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MQLocalQueueTest_THRESH ADD constraint PK_MQLocalQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQLocalQueueTest_THRESH ON MQLocalQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQChannelTest;

CREATE TABLE MQChannelTest ( 
TRGT_HOST       varchar(32) NOT NULL, 
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,       
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
KBYTES_RECD_RATE decimal(20,4) NOT NULL,
KBYTES_RECD_RATE_ST varchar(32) NOT NULL,
KBYTES_SENT_RATE decimal(20,4) NOT NULL,
KBYTES_SENT_RATE_ST varchar(32) NOT NULL,
BUFFERS_RECD_RATE decimal(20,4) NOT NULL,
BUFFERS_RECD_RATE_ST varchar(32) NOT NULL,
BUFFERS_SENT_RATE decimal(20,4) NOT NULL,
BUFFERS_SENT_RATE_ST varchar(32) NOT NULL,
AVAILABILITY decimal(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL);

ALTER TABLE MQChannelTest ADD constraint PK_MQChannelTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MQChannelTest ON MQChannelTest
(
	 MSMT_TIME
);
DROP TABLE MQChannelTest_TREND;

CREATE TABLE MQChannelTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,   
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
KBYTES_RECD_RATE_MIN decimal(20,4) NOT NULL,
KBYTES_RECD_RATE_MAX decimal(20,4) NOT NULL,
KBYTES_RECD_RATE_STCNT varchar(32) NOT NULL,
KBYTES_SENT_RATE_MIN decimal(20,4) NOT NULL,
KBYTES_SENT_RATE_MAX decimal(20,4) NOT NULL,
KBYTES_SENT_RATE_STCNT varchar(32) NOT NULL,
BUFFERS_RECD_RATE_MIN decimal(20,4) NOT NULL,
BUFFERS_RECD_RATE_MAX decimal(20,4) NOT NULL,
BUFFERS_RECD_RATE_STCNT varchar(32) NOT NULL,
BUFFERS_SENT_RATE_MIN decimal(20,4) NOT NULL,
BUFFERS_SENT_RATE_MAX decimal(20,4) NOT NULL,
BUFFERS_SENT_RATE_STCNT varchar(32) NOT NULL,
AVAILABILITY_MIN decimal(20,4) NOT NULL,
AVAILABILITY_MAX decimal(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL);

ALTER TABLE MQChannelTest_TREND ADD constraint PK_MQChannelTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQChannelTest_THRESH;

CREATE TABLE MQChannelTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,      
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START dateTime NOT NULL,
MSMT_TIME_END   dateTime NOT NULL,
KBYTES_RECD_RATE_MIN	VARCHAR(256)	 NOT NULL,
KBYTES_RECD_RATE_MAX	VARCHAR(256)	 NOT NULL,
KBYTES_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
KBYTES_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL,
BUFFERS_RECD_RATE_MIN	VARCHAR(256)	 NOT NULL,
BUFFERS_RECD_RATE_MAX	VARCHAR(256)	 NOT NULL,
BUFFERS_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
BUFFERS_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MQChannelTest_THRESH ADD constraint PK_MQChannelTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQChannelTest_THRESH ON MQChannelTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpPerfTest;

CREATE TABLE DhcpPerfTest ( 
TRGT_HOST       		varchar(32) NOT NULL, 
PORT_NO         		varchar(32) NOT NULL,     
SITE_NAME       		varchar(64) NOT NULL,       
INFO            		varchar(128) NOT NULL,	
MSMT_HOST       		varchar(32) NOT NULL,	
MSMT_TIME       		datetime NOT NULL,
AVG_PKTS_RATE			DECIMAL(20,4) NOT NULL,
AVG_PKTS_RATE_ST		varchar(32) NOT NULL,
CURR_MSG_QUEUE_LEN 		DECIMAL(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_ST 	Varchar(32) NOT NULL,
REQ_RATE 				DECIMAL(20,4) NOT NULL,
REQ_RATE_ST				varchar(32) NOT NULL,
REQ_ACKS_RATE			DECIMAL(20,4) NOT NULL,
REQ_ACKS_RATE_ST 		varchar(32) NOT NULL,
REQ_NACKS_RATE 			DECIMAL(20,4) NOT NULL,
REQ_NACKS_RATE_ST 		varchar(32) NOT NULL,
REQ_DECLINES_RATE 		DECIMAL(20,4) NOT NULL,
REQ_DECLINES_RATE_ST	varchar(32) NOT NULL,
PKTS_EXPD_RATE 			DECIMAL(20,4) NOT NULL,
PKTS_EXPD_RATE_ST 		varchar(32) NOT NULL,
PKTS_DROPPED_RATE 		DECIMAL(20,4) NOT NULL,
PKTS_DROPPED_RATE_ST 	varchar(32) NOT NULL,
REQ_RELEASE_RATE 		DECIMAL(20,4) NOT NULL,
REQ_RELEASE_RATE_ST 	varchar(32) NOT NULL,
PKTS_RECEIVE 			DECIMAL(20,4) NOT NULL,
PKTS_RECEIVE_ST 		varchar(32) NOT NULL,
CONFLICT_CHECK 		DECIMAL(20,4) NOT NULL,
CONFLICT_CHECK_ST	varchar(32) NOT NULL,
DISCOVER_SEC 			DECIMAL(20,4) NOT NULL,
DISCOVER_SEC_ST 		varchar(32) NOT NULL,
OFFERS_SEC 		DECIMAL(20,4) NOT NULL,
OFFERS_SEC_ST 	varchar(32) NOT NULL,
INFO_SEC 		DECIMAL(20,4) NOT NULL,
INFO_SEC_ST 	varchar(32) NOT NULL);

ALTER TABLE DhcpPerfTest ADD constraint PK_DhcpPerfTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DhcpPerfTest ON DhcpPerfTest
(
	 MSMT_TIME
);
DROP TABLE DhcpPerfTest_TREND;

CREATE TABLE DhcpPerfTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,   
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVG_PKTS_RATE_MIN			DECIMAL(20,4) NOT NULL,
AVG_PKTS_RATE_MAX			DECIMAL(20,4) NOT NULL,
AVG_PKTS_RATE_STCNT			varchar(32) NOT NULL,
CURR_MSG_QUEUE_LEN_MIN		DECIMAL(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_MAX		DECIMAL(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_STCNT 	Varchar(32) NOT NULL,
REQ_RATE_MIN 				DECIMAL(20,4) NOT NULL,
REQ_RATE_MAX 				DECIMAL(20,4) NOT NULL,
REQ_RATE_STCNT				varchar(32) NOT NULL,
REQ_ACKS_RATE_MIN			DECIMAL(20,4) NOT NULL,
REQ_ACKS_RATE_MAX			DECIMAL(20,4) NOT NULL,
REQ_ACKS_RATE_STCNT 		varchar(32) NOT NULL,
REQ_NACKS_RATE_MIN 			DECIMAL(20,4) NOT NULL,
REQ_NACKS_RATE_MAX 			DECIMAL(20,4) NOT NULL,
REQ_NACKS_RATE_STCNT 		varchar(32) NOT NULL,
REQ_DECLINES_RATE_MIN 		DECIMAL(20,4) NOT NULL,
REQ_DECLINES_RATE_MAX 		DECIMAL(20,4) NOT NULL,
REQ_DECLINES_RATE_STCNT		varchar(32) NOT NULL,
PKTS_EXPD_RATE_MIN 			DECIMAL(20,4) NOT NULL,
PKTS_EXPD_RATE_MAX 			DECIMAL(20,4) NOT NULL,
PKTS_EXPD_RATE_STCNT 		varchar(32) NOT NULL,
PKTS_DROPPED_RATE_MIN 		DECIMAL(20,4) NOT NULL,
PKTS_DROPPED_RATE_MAX 		DECIMAL(20,4) NOT NULL,
PKTS_DROPPED_RATE_STCNT 	varchar(32) NOT NULL,
REQ_RELEASE_RATE_MIN 		DECIMAL(20,4) NOT NULL,
REQ_RELEASE_RATE_MAX 		DECIMAL(20,4) NOT NULL,
REQ_RELEASE_RATE_STCNT	 	varchar(32) NOT NULL,
PKTS_RECEIVE_MIN 			DECIMAL(20,4) NOT NULL,
PKTS_RECEIVE_MAX 			DECIMAL(20,4) NOT NULL,
PKTS_RECEIVE_STCNT 		varchar(32) NOT NULL,
CONFLICT_CHECK_MIN 		DECIMAL(20,4) NOT NULL,
CONFLICT_CHECK_MAX 		DECIMAL(20,4) NOT NULL,
CONFLICT_CHECK_STCNT		varchar(32) NOT NULL,
DISCOVER_SEC_MIN 			DECIMAL(20,4) NOT NULL,
DISCOVER_SEC_MAX 			DECIMAL(20,4) NOT NULL,
DISCOVER_SEC_STCNT 		varchar(32) NOT NULL,
OFFERS_SEC_MIN 		DECIMAL(20,4) NOT NULL,
OFFERS_SEC_MAX 		DECIMAL(20,4) NOT NULL,
OFFERS_SEC_STCNT 	varchar(32) NOT NULL,
INFO_SEC_MIN 		DECIMAL(20,4) NOT NULL,
INFO_SEC_MAX 		DECIMAL(20,4) NOT NULL,
INFO_SEC_STCNT	 	varchar(32) NOT NULL);

ALTER TABLE DhcpPerfTest_TREND ADD constraint PK_DhcpPerfTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpPerfTest_THRESH;

CREATE TABLE DhcpPerfTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,      
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AVG_PKTS_RATE_MIN	VARCHAR(256)	 NOT NULL,
AVG_PKTS_RATE_MAX	VARCHAR(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MIN	VARCHAR(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MAX	VARCHAR(256)	 NOT NULL,
REQ_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_ACKS_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_ACKS_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_NACKS_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_NACKS_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_DECLINES_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_DECLINES_RATE_MAX	VARCHAR(256)	 NOT NULL,
PKTS_EXPD_RATE_MIN	VARCHAR(256)	 NOT NULL,
PKTS_EXPD_RATE_MAX	VARCHAR(256)	 NOT NULL,
PKTS_DROPPED_RATE_MIN	VARCHAR(256)	 NOT NULL,
PKTS_DROPPED_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_RELEASE_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_RELEASE_RATE_MAX	VARCHAR(256)	 NOT NULL,
PKTS_RECEIVE_MIN	VARCHAR(256)	 NOT NULL,
PKTS_RECEIVE_MAX	VARCHAR(256)	 NOT NULL,
CONFLICT_CHECK_MIN	VARCHAR(256)	 NOT NULL,
CONFLICT_CHECK_MAX	VARCHAR(256)	 NOT NULL,
DISCOVER_SEC_MIN	VARCHAR(256)	 NOT NULL,
DISCOVER_SEC_MAX	VARCHAR(256)	 NOT NULL,
OFFERS_SEC_MIN	VARCHAR(256)	 NOT NULL,
OFFERS_SEC_MAX	VARCHAR(256)	 NOT NULL,
INFO_SEC_MIN	VARCHAR(256)	 NOT NULL,
INFO_SEC_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE DhcpPerfTest_THRESH ADD constraint PK_DhcpPerfTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpPerfTest_THRESH ON DhcpPerfTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpUtilTest;

CREATE TABLE DhcpUtilTest ( 
TRGT_HOST       		varchar(32) NOT NULL, 
PORT_NO         		varchar(32) NOT NULL,     
SITE_NAME       		varchar(64) NOT NULL,       
INFO            		varchar(128) NOT NULL,	
MSMT_HOST       		varchar(32) NOT NULL,	
MSMT_TIME       		datetime NOT NULL,
CURR_ADDR_USAGE_CNT		decimal(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_ST	VARCHAR(32) NOT NULL,
FREE_ADDR_USAGE_CNT		decimal(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_ST	VARCHAR(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT		decimal(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_ST	VARCHAR(32) NOT NULL,
USAGE		decimal(20,4) NOT NULL,
USAGE_ST	VARCHAR(32) NOT NULL,
Status		decimal(20,4) NOT NULL,
Status_ST	VARCHAR(32) NOT NULL);


ALTER TABLE DhcpUtilTest ADD constraint PK_DhcpUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DhcpUtilTest ON DhcpUtilTest
(
	 MSMT_TIME
);
DROP TABLE DhcpUtilTest_TREND;

CREATE TABLE DhcpUtilTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,   
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURR_ADDR_USAGE_CNT_MIN		decimal(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_MAX		decimal(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_STCNT	VARCHAR(32) NOT NULL,
FREE_ADDR_USAGE_CNT_MIN		decimal(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_MAX		decimal(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_STCNT	VARCHAR(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN	decimal(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX	decimal(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_STCNT	VARCHAR(32) NOT NULL,
USAGE_MIN			decimal(20,4) NOT NULL,
USAGE_MAX			decimal(20,4) NOT NULL,
USAGE_STCNT			VARCHAR(32) NOT NULL,
Status_MIN			decimal(20,4) NOT NULL,
Status_MAX			decimal(20,4) NOT NULL,
Status_STCNT		VARCHAR(32) NOT NULL);

ALTER TABLE DhcpUtilTest_TREND ADD constraint PK_DhcpUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpUtilTest_THRESH;

CREATE TABLE DhcpUtilTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,      
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CURR_ADDR_USAGE_CNT_MIN	VARCHAR(256)	 NOT NULL,
CURR_ADDR_USAGE_CNT_MAX	VARCHAR(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MIN	VARCHAR(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN VARCHAR(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX VARCHAR(256)	 NOT NULL,
USAGE_MIN		VARCHAR(256)	 NOT NULL,
USAGE_MAX		VARCHAR(256)	 NOT NULL,
Status_MIN		VARCHAR(256)	 NOT NULL,
Status_MAX		VARCHAR(256)	 NOT NULL);

ALTER TABLE DhcpUtilTest_THRESH ADD constraint PK_DhcpUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpUtilTest_THRESH ON DhcpUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLThreadTest;

CREATE TABLE WLThreadTest 
(
	TRGT_HOST       		varchar(32) NOT NULL, 
	PORT_NO         		varchar(32) NOT NULL, 
	SITE_NAME       		varchar(64) NOT NULL,  
	INFO            		varchar(128) NOT NULL,  
	MSMT_HOST       		varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	IDLE_THREADS    		decimal(20,4) NOT NULL,
	IDLE_THREADS_ST 		varchar(32) NOT NULL,
	PCT_THREAD_UTILIZATION  	decimal(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_ST 	varchar(32) NOT NULL,
	PENDING_REQUESTS 		decimal(20,4) NOT NULL,
	PENDING_REQUESTS_ST 		varchar(32) NOT NULL,
	REQUEST_RATE			decimal(20,4) NOT NULL,
	REQUEST_RATE_ST 		varchar(32) NOT NULL
);

ALTER TABLE WLThreadTest ADD constraint PK_WLThreadTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WLThreadTest ON WLThreadTest
(
	 MSMT_TIME
);
DROP TABLE WLThreadTest_TREND;

CREATE TABLE WLThreadTest_TREND 
(
	TRGT_HOST      			varchar(32) NOT NULL, 
	PORT_NO    		        varchar(32) NOT NULL,
	SITE_NAME    			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL, 
	MSMT_HOST   			varchar(32) NOT NULL, 
	MSMT_TIME    			datetime NOT NULL,
	PERIOD      		        varchar(32) NOT NULL,
	IDLE_THREADS_MIN 		decimal(20,4) NOT NULL,
	IDLE_THREADS_MAX 		decimal(20,4) NOT NULL,
	IDLE_THREADS_STCNT 		varchar(32) NOT NULL,
	PCT_THREAD_UTILIZATION_MIN 	decimal(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_MAX 	decimal(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_STCNT    varchar(32) NOT NULL,
	PENDING_REQUESTS_MIN 		decimal(20,4) NOT NULL,
	PENDING_REQUESTS_MAX 		decimal(20,4) NOT NULL,
	PENDING_REQUESTS_STCNT 		varchar(32) NOT NULL,
	REQUEST_RATE_MIN 		decimal(20,4) NOT NULL,
	REQUEST_RATE_MAX 		decimal(20,4) NOT NULL,
	REQUEST_RATE_STCNT 		varchar(32) NOT NULL
);

ALTER TABLE WLThreadTest_TREND ADD constraint PK_WLThreadTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WLThreadTest_THRESH;

CREATE TABLE WLThreadTest_THRESH
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO			        varchar(32) NOT NULL,
	SITE_NAME    			varchar(64) NOT NULL,
	INFO			        varchar(128) NOT NULL,      
	MSMT_HOST		        varchar(32) NOT NULL,   
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END  			datetime NOT NULL,
	IDLE_THREADS_MIN	VARCHAR(256)	 NOT NULL,
	IDLE_THREADS_MAX	VARCHAR(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MIN	VARCHAR(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MAX	VARCHAR(256)	 NOT NULL,
	PENDING_REQUESTS_MIN	VARCHAR(256)	 NOT NULL,
	PENDING_REQUESTS_MAX	VARCHAR(256)	 NOT NULL,
	REQUEST_RATE_MIN	VARCHAR(256)	 NOT NULL,
	REQUEST_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE WLThreadTest_THRESH ADD constraint PK_WLThreadTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WLThreadTest_THRESH ON WLThreadTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);


DROP TABLE WLClusterTest;

CREATE TABLE WLClusterTest
(
		TRGT_HOST       			varchar(32)		NOT NULL,
		PORT_NO         			varchar(32)		NOT NULL,
		SITE_NAME       			varchar(64)		NOT NULL,
		INFO            			varchar(128)	NOT NULL,
		MSMT_HOST       			varchar(32)		NOT NULL,
		MSMT_TIME       			datetime		NOT NULL,
		ALIVE_SERVERS_COUNT 		decimal(20,4) 	NOT NULL,
		ALIVE_SERVERS_COUNT_ST 		varchar(32) 	NOT NULL,
		FRAGMENTS_SENT_RT 			Decimal(20,4)	NOT NULL,
		FRAGMENTS_SENT_RT_ST 		varchar(32) 	NOT NULL,
		FRAGMENTS_RECEIVED_RT 		Decimal(20,4)	NOT NULL,
		FRAGMENTS_RECEIVED_RT_ST 	varchar(32) 	NOT NULL,
		FRAGMENTS_DROPPED_RT 		Decimal(20,4)	NOT NULL,
		FRAGMENTS_DROPPED_RT_ST 	varchar(32) 	NOT NULL,
		MSGS_LOST_RT 				Decimal(20,4) 	NOT NULL,
		MSGS_LOST_RT_ST 			varchar(32) 	NOT NULL,
		RESEND_REQUESTS_RT 			Decimal(20,4) 	NOT NULL,
		RESEND_REQUESTS_RT_ST 		varchar(32) 	NOT NULL,
		PRIMARY_COUNT 				decimal(20,4) 	NOT NULL,
		PRIMARY_COUNT_ST 			varchar(32) 	NOT NULL
);

ALTER TABLE WLClusterTest ADD constraint PK_WLClusterTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLClusterTest ON WLClusterTest
(
	 MSMT_TIME
);
DROP TABLE WLClusterTest_TREND ;

CREATE TABLE WLClusterTest_TREND
(
	TRGT_HOST       			varchar(32) 	NOT NULL,
	PORT_NO         			varchar(32) 	NOT NULL,
	SITE_NAME       			varchar(64) 	NOT NULL,
	INFO            			varchar(128) 	NOT NULL,
	MSMT_HOST       			varchar(32) 	NOT NULL,
	MSMT_TIME       			datetime 		NOT NULL,
	PERIOD       				varchar(32) 	NOT NULL,
	ALIVE_SERVERS_COUNT_MIN 	decimal(20,4) 	NOT NULL,
	ALIVE_SERVERS_COUNT_MAX 	decimal(20,4) 	NOT NULL,
	ALIVE_SERVERS_COUNT_STCNT 	varchar(32)		NOT NULL,
	FRAGMENTS_SENT_RT_MIN 		Decimal(20,4)	NOT NULL,
	FRAGMENTS_SENT_RT_MAX 		Decimal(20,4) 	NOT NULL,
	FRAGMENTS_SENT_RT_STCNT 	varchar(32) 	NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_RECEIVED_RT_STCNT varchar(32) 	NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_DROPPED_RT_STCNT 	varchar(32) 	NOT NULL,
	MSGS_LOST_RT_MIN 			Decimal(20,4) 	NOT NULL,
	MSGS_LOST_RT_MAX 			Decimal(20,4) 	NOT NULL,
	MSGS_LOST_RT_STCNT 			varchar(32) 	NOT NULL,
	RESEND_REQUESTS_RT_MIN 		Decimal(20,4) 	NOT NULL,
	RESEND_REQUESTS_RT_MAX 		Decimal(20,4) 	NOT NULL,
	RESEND_REQUESTS_RT_STCNT 	varchar(32) 	NOT NULL,
	PRIMARY_COUNT_MIN 			decimal(20,4) 	NOT NULL,
	PRIMARY_COUNT_MAX 			decimal(20,4) 	NOT NULL,
	PRIMARY_COUNT_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE WLClusterTest_TREND ADD constraint PK_WLClusterTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLClusterTest_THRESH ;

CREATE TABLE WLClusterTest_THRESH
(
	TRGT_HOST       varchar(32)				  NOT NULL,
	PORT_NO         varchar(32)				  NOT NULL,
	SITE_NAME       varchar(64)				  NOT NULL,
	INFO            varchar(128)			  NOT NULL,
	MSMT_HOST       varchar(32)				  NOT NULL,
	MSMT_TIME_START datetime				  NOT NULL,
	MSMT_TIME_END   datetime				  NOT NULL,
	ALIVE_SERVERS_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	ALIVE_SERVERS_COUNT_MAX	VARCHAR(256)		  NOT NULL,
	FRAGMENTS_SENT_RT_MIN	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_SENT_RT_MAX	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX	VARCHAR(256)	 NOT NULL,
	MSGS_LOST_RT_MIN	VARCHAR(256)	 NOT NULL,
	MSGS_LOST_RT_MAX	VARCHAR(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MIN	VARCHAR(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MAX	VARCHAR(256)	 NOT NULL,
	PRIMARY_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	PRIMARY_COUNT_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLClusterTest_THRESH ADD constraint PK_WLClusterTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLClusterTest_THRESH ON WLClusterTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);


DROP TABLE WLConnectorTest;

CREATE TABLE WLConnectorTest
(
	TRGT_HOST       			varchar(32)   	NOT NULL,
	PORT_NO         			varchar(32)   	NOT NULL,
	SITE_NAME       			varchar(64)   	NOT NULL,
	INFO            			varchar(128)  	NOT NULL,
	MSMT_HOST      				varchar(32)	  	NOT NULL,
	MSMT_TIME       			datetime	  	NOT NULL,
	TOTAL_CONNS_CREATED_RT 		Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_CREATED_RT_ST 	varchar(32)		NOT NULL,
	TOTAL_CONNS_DESTROYED_RT 	Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_ST varchar(32) 	NOT NULL,
	TOTAL_CONNS_MATCHED_RT 		Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_MATCHED_RT_ST 	varchar(32) 	NOT NULL,
	TOTAL_CONNS_REJECTED_RT 	Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_REJECTED_RT_ST 	varchar(32) 	NOT NULL,
	TOTAL_CONNS_RECYCLED_RT 	Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_ST 	varchar(32) 	NOT NULL,
	CURRENT_ACTIVE_CONNS 		decimal(20,4) 	NOT NULL,
	CURRENT_ACTIVE_CONNS_ST 	varchar(32) 	NOT NULL,
	ACTIVE_CONNS_HWM 			decimal(20,4) 	NOT NULL,
	ACTIVE_CONNS_HWM_ST 		varchar(32) 	NOT NULL,
	CURRENT_FREE_CONNS 			decimal(20,4) 	NOT NULL,
	CURRENT_FREE_CONNS_ST 		varchar(32) 	NOT NULL,
	FREE_CONNS_HWM 				decimal(20,4) 	NOT NULL,
	FREE_CONNS_HWM_ST 			varchar(32) 	NOT NULL,
	MAX_CAPACITY 				decimal(20,4) 	NOT NULL,
	MAX_CAPACITY_ST 			varchar(32) 	NOT NULL
);

ALTER TABLE WLConnectorTest ADD constraint PK_WLConnectorTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLConnectorTest ON WLConnectorTest
(
	 MSMT_TIME
);
DROP TABLE WLConnectorTest_TREND ;

CREATE TABLE WLConnectorTest_TREND
(
	TRGT_HOST       				varchar(32)   NOT NULL,
	PORT_NO         				varchar(32)   NOT NULL,
	SITE_NAME      					varchar(64)   NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	TOTAL_CONNS_CREATED_RT_MIN 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_STCNT 	varchar(32)   NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN 		decimal(20,4)   NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX 		decimal(20,4)   NOT NULL,
	CURRENT_ACTIVE_CONNS_STCNT 		varchar(32)   NOT NULL,
	ACTIVE_CONNS_HWM_MIN 			decimal(20,4)   NOT NULL,
	ACTIVE_CONNS_HWM_MAX 			decimal(20,4)   NOT NULL,
	ACTIVE_CONNS_HWM_STCNT 			varchar(32)   NOT NULL,
	CURRENT_FREE_CONNS_MIN 			decimal(20,4)   NOT NULL,
	CURRENT_FREE_CONNS_MAX 			decimal(20,4)   NOT NULL,
	CURRENT_FREE_CONNS_STCNT 		varchar(32)   NOT NULL,
	FREE_CONNS_HWM_MIN 				decimal(20,4)   NOT NULL,
	FREE_CONNS_HWM_MAX 				decimal(20,4)   NOT NULL,
	FREE_CONNS_HWM_STCNT 			varchar(32)   NOT NULL,
	MAX_CAPACITY_MIN 				decimal(20,4)   NOT NULL,
	MAX_CAPACITY_MAX 				decimal(20,4)   NOT NULL,
	MAX_CAPACITY_STCNT 				varchar(32)   NOT NULL
);

ALTER TABLE WLConnectorTest_TREND ADD constraint PK_WLConnectorTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLConnectorTest_THRESH ;

CREATE TABLE WLConnectorTest_THRESH
(
	TRGT_HOST       varchar(32)				   NOT NULL,
	PORT_NO         varchar(32)				   NOT NULL,
	SITE_NAME       varchar(64)				   NOT NULL,
	INFO            varchar(128)			   NOT NULL,
	MSMT_HOST       varchar(32)				   NOT NULL,
	MSMT_TIME_START datetime				   NOT NULL,
	MSMT_TIME_END   datetime				   NOT NULL,
	TOTAL_CONNS_CREATED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX	VARCHAR(256)	 NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN	VARCHAR(256)	   NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX	VARCHAR(256)	   NOT NULL,
	ACTIVE_CONNS_HWM_MIN	VARCHAR(256)	   NOT NULL,
	ACTIVE_CONNS_HWM_MAX	VARCHAR(256)	   NOT NULL,
	CURRENT_FREE_CONNS_MIN	VARCHAR(256)	   NOT NULL,
	CURRENT_FREE_CONNS_MAX	VARCHAR(256)	   NOT NULL,
	FREE_CONNS_HWM_MIN	VARCHAR(256)	   NOT NULL,
	FREE_CONNS_HWM_MAX	VARCHAR(256)	   NOT NULL,
	MAX_CAPACITY_MIN	VARCHAR(256)	   NOT NULL,
	MAX_CAPACITY_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLConnectorTest_THRESH ADD constraint PK_WLConnectorTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLConnectorTest_THRESH ON WLConnectorTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLJMSTest;

CREATE TABLE WLJMSTest
(
	TRGT_HOST       			varchar(32)	  NOT NULL,
	PORT_NO         			varchar(32)	  NOT NULL,
	SITE_NAME       			varchar(64)	  NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST      				varchar(32)	  NOT NULL,
	MSMT_TIME       			datetime	  NOT NULL,
	BYTES_RECEIVED_RT 			Decimal(20,4) NOT NULL,
	BYTES_RECEIVED_RT_ST 		varchar(32)	  NOT NULL,
	MSGS_RECEIVED_RT 			Decimal(20,4) NOT NULL,
	MSGS_RECEIVED_RT_ST 		varchar(32)   NOT NULL,
	BYTES_CURRENT_COUNT 		decimal(20,4)   NOT NULL,
	BYTES_CURRENT_COUNT_ST 		varchar(32)   NOT NULL,
	BYTES_PENDING_COUNT 		decimal(20,4)   NOT NULL,
	BYTES_PENDING_COUNT_ST 		varchar(32)   NOT NULL,
	BYTES_COUNT_HWM 			decimal(20,4)   NOT NULL,
	BYTES_COUNT_HWM_ST 			varchar(32)   NOT NULL,
	MSGS_CURRENT_COUNT 			decimal(20,4)   NOT NULL,
	MSGS_CURRENT_COUNT_ST 		varchar(32)   NOT NULL,
	MSGS_PENDING_COUNT 			decimal(20,4)   NOT NULL,
	MSGS_PENDING_COUNT_ST 		varchar(32)   NOT NULL,
	MSGS_COUNT_HWM 				decimal(20,4)   NOT NULL,
	MSGS_COUNT_HWM_ST 			varchar(32)   NOT NULL,
	DEST_CURRENT_COUNT 			decimal(20,4)   NOT NULL,
	DEST_CURRENT_COUNT_ST 		varchar(32)   NOT NULL,
	DEST_COUNT_HWM 				decimal(20,4)   NOT NULL,
	DEST_COUNT_HWM_ST 			varchar(32)   NOT NULL,
	SESS_POOL_CURRENT_COUNT 	decimal(20,4)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_ST 	varchar(32)   NOT NULL,
	SESSION_POOL_HWM 			decimal(20,4)   NOT NULL,
	SESSION_POOL_HWM_ST 		varchar(32)   NOT NULL
);

ALTER TABLE WLJMSTest ADD constraint PK_WLJMSTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLJMSTest ON WLJMSTest
(
	 MSMT_TIME
);
DROP TABLE WLJMSTest_TREND ;

CREATE TABLE WLJMSTest_TREND
(
	TRGT_HOST       				varchar(32)	  NOT NULL,
	PORT_NO         				varchar(32)	  NOT NULL,
	SITE_NAME       				varchar(64)	  NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	BYTES_RECEIVED_RT_MIN 			Decimal(20,4) NOT NULL,
	BYTES_RECEIVED_RT_MAX 			Decimal(20,4) NOT NULL,
	BYTES_RECEIVED_RT_STCNT 		varchar(32)   NOT NULL,
	MSGS_RECEIVED_RT_MIN 			Decimal(20,4) NOT NULL,
	MSGS_RECEIVED_RT_MAX 			Decimal(20,4) NOT NULL,
	MSGS_RECEIVED_RT_STCNT 			varchar(32)   NOT NULL,
	BYTES_CURRENT_COUNT_MIN 		decimal(20,4)   NOT NULL,
	BYTES_CURRENT_COUNT_MAX 		decimal(20,4)   NOT NULL,
	BYTES_CURRENT_COUNT_STCNT 		varchar(32)   NOT NULL,
	BYTES_PENDING_COUNT_MIN 		decimal(20,4)   NOT NULL,
	BYTES_PENDING_COUNT_MAX 		decimal(20,4)   NOT NULL,
	BYTES_PENDING_COUNT_STCNT 		varchar(32)   NOT NULL,
	BYTES_COUNT_HWM_MIN 			decimal(20,4)   NOT NULL,
	BYTES_COUNT_HWM_MAX 			decimal(20,4)   NOT NULL,
	BYTES_COUNT_HWM_STCNT 			varchar(32)   NOT NULL,
	MSGS_CURRENT_COUNT_MIN 			decimal(20,4)   NOT NULL,
	MSGS_CURRENT_COUNT_MAX 			decimal(20,4)   NOT NULL,
	MSGS_CURRENT_COUNT_STCNT 		varchar(32)   NOT NULL,
	MSGS_PENDING_COUNT_MIN 			decimal(20,4)   NOT NULL,
	MSGS_PENDING_COUNT_MAX 			decimal(20,4)   NOT NULL,
	MSGS_PENDING_COUNT_STCNT 		varchar(32)   NOT NULL,
	MSGS_COUNT_HWM_MIN 				decimal(20,4)   NOT NULL,
	MSGS_COUNT_HWM_MAX 				decimal(20,4)   NOT NULL,
	MSGS_COUNT_HWM_STCNT 			varchar(32)   NOT NULL,
	DEST_CURRENT_COUNT_MIN 			decimal(20,4)   NOT NULL,
	DEST_CURRENT_COUNT_MAX 			decimal(20,4)   NOT NULL,
	DEST_CURRENT_COUNT_STCNT 		varchar(32)   NOT NULL,
	DEST_COUNT_HWM_MIN 				decimal(20,4)   NOT NULL,
	DEST_COUNT_HWM_MAX 				decimal(20,4)   NOT NULL,
	DEST_COUNT_HWM_STCNT 			varchar(32)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN 	decimal(20,4)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX 	decimal(20,4)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_STCNT 	varchar(32)   NOT NULL,
	SESSION_POOL_HWM_MIN 			decimal(20,4)   NOT NULL,
	SESSION_POOL_HWM_MAX 			decimal(20,4)   NOT NULL,
	SESSION_POOL_HWM_STCNT 			varchar(32)   NOT NULL
);

ALTER TABLE WLJMSTest_TREND ADD constraint PK_WLJMSTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLJMSTest_THRESH ;

CREATE TABLE WLJMSTest_THRESH
(
	TRGT_HOST       			varchar(32)	  NOT NULL,
	PORT_NO         			varchar(32)	  NOT NULL,
	SITE_NAME       			varchar(64)	  NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST       			varchar(32)	  NOT NULL,
	MSMT_TIME_START 			datetime	  NOT NULL,
	MSMT_TIME_END   			datetime	  NOT NULL,
	BYTES_RECEIVED_RT_MIN	VARCHAR(256)	 NOT NULL,
	BYTES_RECEIVED_RT_MAX	VARCHAR(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MIN	VARCHAR(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MAX	VARCHAR(256)	 NOT NULL,
	BYTES_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	BYTES_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	BYTES_PENDING_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	BYTES_PENDING_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	BYTES_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	BYTES_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	MSGS_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	MSGS_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	MSGS_PENDING_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	MSGS_PENDING_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	MSGS_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	MSGS_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	DEST_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	DEST_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	DEST_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	DEST_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	SESSION_POOL_HWM_MIN	VARCHAR(256)	   NOT NULL,
	SESSION_POOL_HWM_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLJMSTest_THRESH ADD constraint PK_WLJMSTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJMSTest_THRESH ON WLJMSTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLJTATest;

CREATE TABLE WLJTATest
(
	TRGT_HOST       			varchar(32)	  NOT NULL,
	PORT_NO         			varchar(32)	  NOT NULL,
	SITE_NAME       			varchar(64)	  NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST       			varchar(32)	  NOT NULL,
	MSMT_TIME       			datetime	  NOT NULL,
	TOTAL_ACTIVE_TX 			decimal(20,4)   NOT NULL,
	TOTAL_ACTIVE_TX_ST 			varchar(32)   NOT NULL,
	ABANDONED_TX_RT 			Decimal(20,4) NOT NULL,
	ABANDONED_TX_RT_ST 			varchar(32)   NOT NULL,
	APP_ROLLEDBACK_TX_RT 		Decimal(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_ST 	varchar(32)   NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT 	Decimal(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_ST varchar(32)   NOT NULL,
	SYS_ROLLEDBACK_TX_RT 		Decimal(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_ST 	varchar(32)   NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT 	Decimal(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_ST varchar(32)   NOT NULL,
	COMMITTED_TX_RT 			Decimal(20,4) NOT NULL,
	COMMITTED_TX_RT_ST 			varchar(32)   NOT NULL,
	HEURISTICS_TX_RT 			Decimal(20,4) NOT NULL,
	HEURISTICS_TX_RT_ST 		varchar(32)   NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT 		Decimal(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_ST 	varchar(32)   NOT NULL,
	TOTAL_TX_RT 				Decimal(20,4) NOT NULL,
	TOTAL_TX_RT_ST 				varchar(32)   NOT NULL
);

ALTER TABLE WLJTATest ADD constraint PK_WLJTATest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLJTATest ON WLJTATest
(
	 MSMT_TIME
);
DROP TABLE WLJTATest_TREND;

CREATE TABLE WLJTATest_TREND
(
	TRGT_HOST       				varchar(32)	  NOT NULL,
	PORT_NO         				varchar(32)	  NOT NULL,
	SITE_NAME       				varchar(64)	  NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	TOTAL_ACTIVE_TX_MIN 			decimal(20,4)   NOT NULL,
	TOTAL_ACTIVE_TX_MAX 			decimal(20,4)   NOT NULL,
	TOTAL_ACTIVE_TX_STCNT 			varchar(32)   NOT NULL,
	ABANDONED_TX_RT_MIN 			Decimal(20,4) NOT NULL,
	ABANDONED_TX_RT_MAX 			Decimal(20,4) NOT NULL,
	ABANDONED_TX_RT_STCNT 			varchar(32)   NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN 		Decimal(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX 		Decimal(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_STCNT 		varchar(32)   NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN 	Decimal(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX 	Decimal(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_STCNT 	varchar(32)   NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN 		Decimal(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX 		Decimal(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_STCNT 		varchar(32)   NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN 	Decimal(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX 	Decimal(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_STCNT 	varchar(32)   NOT NULL,
	COMMITTED_TX_RT_MIN 			Decimal(20,4) NOT NULL,
	COMMITTED_TX_RT_MAX 			Decimal(20,4) NOT NULL,
	COMMITTED_TX_RT_STCNT 			varchar(32)   NOT NULL,
	HEURISTICS_TX_RT_MIN 			Decimal(20,4) NOT NULL,
	HEURISTICS_TX_RT_MAX 			Decimal(20,4) NOT NULL,
	HEURISTICS_TX_RT_STCNT 			varchar(32)   NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN 		Decimal(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX 		Decimal(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_TX_RT_MIN 				Decimal(20,4) NOT NULL,
	TOTAL_TX_RT_MAX 				Decimal(20,4) NOT NULL,
	TOTAL_TX_RT_STCNT 				varchar(32)   NOT NULL
);

ALTER TABLE WLJTATest_TREND ADD constraint PK_WLJTATest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLJTATest_THRESH;

CREATE TABLE WLJTATest_THRESH
(
	TRGT_HOST      				 varchar(32)   NOT NULL,
	PORT_NO         			 varchar(32)   NOT NULL,
	SITE_NAME       		 	 varchar(64)   NOT NULL,
	INFO            			 varchar(128)  NOT NULL,
	MSMT_HOST       			 varchar(32)   NOT NULL,
	MSMT_TIME_START 			 datetime	   NOT NULL,
	MSMT_TIME_END   			 datetime	   NOT NULL,
	TOTAL_ACTIVE_TX_MIN	VARCHAR(256)	   NOT NULL,
	TOTAL_ACTIVE_TX_MAX	VARCHAR(256)	   NOT NULL,
	ABANDONED_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	ABANDONED_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	COMMITTED_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	COMMITTED_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	HEURISTICS_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	HEURISTICS_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_TX_RT_MAX	VARCHAR(256)	 NOT NULL
); 

ALTER TABLE WLJTATest_THRESH ADD constraint PK_WLJTATest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJTATest_THRESH ON WLJTATest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLSecurityTest ;

CREATE TABLE WLSecurityTest
(
	TRGT_HOST       			varchar(32)   NOT NULL,
	PORT_NO         			varchar(32)   NOT NULL,
	SITE_NAME       			varchar(64)   NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST       			varchar(32)   NOT NULL,
	MSMT_TIME       			datetime	  NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT 	Decimal(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_ST varchar(32)   NOT NULL,
	INVALID_USERS_COUNT_HWM 	decimal(20,4)   NOT NULL,
	INVALID_USERS_COUNT_HWM_ST 	varchar(32)   NOT NULL,
	CURR_LOCKED_USERS_COUNT 	decimal(20,4)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_ST 	varchar(32)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD 	decimal(20,4)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_ST varchar(32)   NOT NULL,
	TOTAL_UNLOCKED_USERS 		decimal(20,4)   NOT NULL,
	TOTAL_UNLOCKED_USERS_ST 	varchar(32)   NOT NULL,
	USER_LOCKOUT_COUNT 			decimal(20,4)   NOT NULL,
	USER_LOCKOUT_COUNT_ST 		varchar(32)   NOT NULL
);

ALTER TABLE WLSecurityTest ADD constraint PK_WLSecurityTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLSecurityTest ON WLSecurityTest
(
	 MSMT_TIME
);
DROP TABLE WLSecurityTest_TREND ;

CREATE TABLE WLSecurityTest_TREND
(
	TRGT_HOST       				varchar(32)	  NOT NULL,
	PORT_NO         				varchar(32)	  NOT NULL,
	SITE_NAME       				varchar(64)	  NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MIN 	Decimal(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX 	Decimal(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_STCNT 	varchar(32)	  NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN 	decimal(20,4)   NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX 	decimal(20,4)   NOT NULL,
	INVALID_USERS_COUNT_HWM_STCNT 	varchar(32)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN 	decimal(20,4)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX 	decimal(20,4)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_STCNT 	varchar(32)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN 	decimal(20,4)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX 	decimal(20,4)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_STCNT 	varchar(32)   NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN 		decimal(20,4)   NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX 		decimal(20,4)   NOT NULL,
	TOTAL_UNLOCKED_USERS_STCNT 		varchar(32)   NOT NULL,
	USER_LOCKOUT_COUNT_MIN 			decimal(20,4)   NOT NULL,
	USER_LOCKOUT_COUNT_MAX		 	decimal(20,4)   NOT NULL,
	USER_LOCKOUT_COUNT_STCNT 		varchar(32)   NOT NULL
);

ALTER TABLE WLSecurityTest_TREND ADD constraint PK_WLSecurityTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLSecurityTest_THRESH ;

CREATE TABLE WLSecurityTest_THRESH
(
	TRGT_HOST       			 varchar(32)   NOT NULL,
	PORT_NO         			 varchar(32)   NOT NULL,
	SITE_NAME       			 varchar(64)   NOT NULL,
	INFO            			 varchar(128)  NOT NULL,
	MSMT_HOST       			 varchar(32)   NOT NULL,
	MSMT_TIME_START 			 datetime	   NOT NULL,
	MSMT_TIME_END   			 datetime	   NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MIN	VARCHAR(256)	 NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX	VARCHAR(256)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN	VARCHAR(256)	   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX	VARCHAR(256)	   NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN	VARCHAR(256)	   NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX	VARCHAR(256)	   NOT NULL,
	USER_LOCKOUT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	USER_LOCKOUT_COUNT_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLSecurityTest_THRESH ADD constraint PK_WLSecurityTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLSecurityTest_THRESH ON WLSecurityTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE TcpPortTest;

CREATE TABLE TcpPortTest
( 
	TRGT_HOST      		 varchar(32) NOT NULL,
    PORT_NO        		 varchar(32) NOT NULL,
    SITE_NAME      		 varchar(64) NOT NULL,
    INFO           		 varchar(128) NOT NULL,
	MSMT_HOST      		 varchar(32) NOT NULL,
	MSMT_TIME      		 datetime NOT NULL,
	SYN_SENT			 decimal(20,4) NOT NULL,
	SYN_SENT_ST 	 	 varchar(32) NOT NULL,
	SYN_RECEIVED 		 decimal(20,4) NOT NULL,
	SYN_RECEIVED_ST 	 varchar(32) NOT NULL,
	ESTABLISHED 		 decimal(20,4) NOT NULL,
	ESTABLISHED_ST 		 varchar(32) NOT NULL,
	CLOSE_WAIT 			 decimal(20,4) NOT NULL,
	CLOSE_WAIT_ST 		 varchar(32) NOT NULL,
	FIN_WAIT_1 			 decimal(20,4) NOT NULL,
	FIN_WAIT_1_ST 		 varchar(32) NOT NULL,
	FIN_WAIT_2			 decimal(20,4) NOT NULL,
	FIN_WAIT_2_ST 		 varchar(32) NOT NULL,
	TIME_WAIT 			 decimal(20,4) NOT NULL,
	TIME_WAIT_ST 		 varchar(32) NOT NULL,
	SEND_QUEUE 			 decimal(20,4) NOT NULL,
	SEND_QUEUE_ST 		 varchar(32) NOT NULL,
	RECEIVE_QUEUE 		 decimal(20,4) NOT NULL,
	RECEIVE_QUEUE_ST 	 varchar(32) NOT NULL
);

ALTER TABLE TcpPortTest ADD constraint PK_TcpPortTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TcpPortTest ON TcpPortTest
(
	 MSMT_TIME
);
DROP TABLE TcpPortTest_TREND;

CREATE TABLE TcpPortTest_TREND
( 
	TRGT_HOST      		 varchar(32) NOT NULL,
    PORT_NO         	 varchar(32) NOT NULL,
    SITE_NAME      		 varchar(64) NOT NULL, 
    INFO        		 varchar(128) NOT NULL,
	MSMT_HOST     		 varchar(32) NOT NULL,
	MSMT_TIME      		 datetime NOT NULL,
	PERIOD       	     varchar(32) NOT NULL,
	SYN_SENT_MIN   		 decimal(20,4) NOT NULL,
	SYN_SENT_MAX 		 decimal(20,4) NOT NULL,
	SYN_SENT_STCNT 		 varchar(32) NOT NULL,
	SYN_RECEIVED_MIN 	 decimal(20,4) NOT NULL,
	SYN_RECEIVED_MAX 	 decimal(20,4) NOT NULL,
	SYN_RECEIVED_STCNT 	 varchar(32) NOT NULL,
	ESTABLISHED_MIN		 decimal(20,4) NOT NULL,
	ESTABLISHED_MAX 	 decimal(20,4) NOT NULL,
	ESTABLISHED_STCNT 	 varchar(32) NOT NULL,
	CLOSE_WAIT_MIN 		 decimal(20,4) NOT NULL,
	CLOSE_WAIT_MAX 		 decimal(20,4) NOT NULL,
	CLOSE_WAIT_STCNT 	 varchar(32) NOT NULL,
	FIN_WAIT_1_MIN 		 decimal(20,4) NOT NULL,
	FIN_WAIT_1_MAX 		 decimal(20,4) NOT NULL,
	FIN_WAIT_1_STCNT	 varchar(32) NOT NULL,
	FIN_WAIT_2_MIN 		 decimal(20,4) NOT NULL,
	FIN_WAIT_2_MAX 		 decimal(20,4) NOT NULL,
	FIN_WAIT_2_STCNT 	 varchar(32) NOT NULL,
	TIME_WAIT_MIN 		 decimal(20,4) NOT NULL,
	TIME_WAIT_MAX 		 decimal(20,4) NOT NULL,
	TIME_WAIT_STCNT 	 varchar(32) NOT NULL,
	SEND_QUEUE_MIN 		 decimal(20,4) NOT NULL,
	SEND_QUEUE_MAX 		 decimal(20,4) NOT NULL,
	SEND_QUEUE_STCNT 	 varchar(32) NOT NULL,
	RECEIVE_QUEUE_MIN 	 decimal(20,4) NOT NULL,
	RECEIVE_QUEUE_MAX 	 decimal(20,4) NOT NULL,
	RECEIVE_QUEUE_STCNT  varchar(32) NOT NULL
);

ALTER TABLE TcpPortTest_TREND ADD constraint PK_TcpPortTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TcpPortTest_THRESH;

CREATE TABLE TcpPortTest_THRESH 
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO        			varchar(32) NOT NULL, 
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	SYN_SENT_MIN	VARCHAR(256)	 NOT NULL,
	SYN_SENT_MAX	VARCHAR(256)	 NOT NULL,
	SYN_RECEIVED_MIN	VARCHAR(256)	 NOT NULL,
	SYN_RECEIVED_MAX	VARCHAR(256)	 NOT NULL,
	ESTABLISHED_MIN	VARCHAR(256)	 NOT NULL,
	ESTABLISHED_MAX	VARCHAR(256)	 NOT NULL,
	CLOSE_WAIT_MIN	VARCHAR(256)	 NOT NULL,
	CLOSE_WAIT_MAX	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_1_MIN	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_1_MAX	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_2_MIN	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_2_MAX	VARCHAR(256)	 NOT NULL,
	TIME_WAIT_MIN	VARCHAR(256)	 NOT NULL,
	TIME_WAIT_MAX	VARCHAR(256)	 NOT NULL,
	SEND_QUEUE_MIN	VARCHAR(256)	 NOT NULL,
	SEND_QUEUE_MAX	VARCHAR(256)	 NOT NULL,
	RECEIVE_QUEUE_MIN	VARCHAR(256)	 NOT NULL,
	RECEIVE_QUEUE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE TcpPortTest_THRESH ADD constraint PK_TcpPortTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TcpPortTest_THRESH ON TcpPortTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE FileTest;

CREATE TABLE FileTest
( 	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	CDUMPCNT 				decimal(20,4) NOT NULL,
	CDUMPCNT_ST 			varchar(32) NOT NULL,
	RECENTCDUMPCNT 			decimal(20,4) NOT NULL,
	RECENTCDUMPCNT_ST 		varchar(32) NOT NULL
);

ALTER TABLE FileTest ADD constraint PK_FileTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_FileTest ON FileTest
(
	 MSMT_TIME
);
DROP TABLE FileTest_TREND;

CREATE TABLE FileTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	CDUMPCNT_MIN 			decimal(20,4) NOT NULL,
	CDUMPCNT_MAX 			decimal(20,4) NOT NULL,
	CDUMPCNT_STCNT 			varchar(32) NOT NULL,
	RECENTCDUMPCNT_MIN		decimal(20,4) NOT NULL,
	RECENTCDUMPCNT_MAX 		decimal(20,4) NOT NULL,
	RECENTCDUMPCNT_STCNT 	varchar(32) NOT NULL
);


ALTER TABLE FileTest_TREND ADD constraint PK_FileTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE FileTest_THRESH;

CREATE TABLE FileTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	CDUMPCNT_MIN	VARCHAR(256)	 NOT NULL,
	CDUMPCNT_MAX	VARCHAR(256)	 NOT NULL,
	RECENTCDUMPCNT_MIN	VARCHAR(256)	 NOT NULL,
	RECENTCDUMPCNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE FileTest_THRESH ADD constraint PK_FileTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_FileTest_THRESH ON FileTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraArchiveTest;

CREATE TABLE OraArchiveTest
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	ARCHIVE_LOG_MODE 		decimal(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_ST 	varchar(32) NOT NULL
);

ALTER TABLE OraArchiveTest ADD constraint PK_OraArchiveTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraArchiveTest ON OraArchiveTest
(
	 MSMT_TIME
);
DROP TABLE OraArchiveTest_TREND;

CREATE TABLE OraArchiveTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,	
	MSMT_TIME       		datetime NOT NULL,	
	PERIOD       			varchar(32) NOT NULL,
	ARCHIVE_LOG_MODE_MIN 	decimal(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_MAX 	decimal(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_STCNT	varchar(32) NOT NULL
);

ALTER TABLE OraArchiveTest_TREND ADD constraint PK_OraArchiveTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraArchiveTest_THRESH;

CREATE TABLE OraArchiveTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL, 
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	ARCHIVE_LOG_MODE_MIN	VARCHAR(256)	 NOT NULL,
	ARCHIVE_LOG_MODE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraArchiveTest_THRESH ADD constraint PK_OraArchiveTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraArchiveTest_THRESH ON OraArchiveTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraUserTsTest;

CREATE TABLE OraUserTsTest
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	SYSTEM_TS_USERS 		decimal(20,4) NOT NULL,
	SYSTEM_TS_USERS_ST 		varchar(32) NOT NULL
);

ALTER TABLE OraUserTsTest ADD constraint PK_OraUserTsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraUserTsTest ON OraUserTsTest
(
	 MSMT_TIME
);
DROP TABLE OraUserTsTest_TREND;

CREATE TABLE OraUserTsTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST      			varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	SYSTEM_TS_USERS_MIN 	decimal(20,4) NOT NULL,
	SYSTEM_TS_USERS_MAX 	decimal(20,4) NOT NULL,
	SYSTEM_TS_USERS_STCNT 	varchar(32) NOT NULL
);

ALTER TABLE OraUserTsTest_TREND ADD constraint PK_OraUserTsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraUserTsTest_THRESH;

CREATE TABLE OraUserTsTest_THRESH
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	SYSTEM_TS_USERS_MIN	VARCHAR(256)	 NOT NULL,
	SYSTEM_TS_USERS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraUserTsTest_THRESH ADD constraint PK_OraUserTsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraUserTsTest_THRESH ON OraUserTsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraParamsTest;

CREATE TABLE OraParamsTest
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	NON_ORACLE_PARAMS	    decimal(20,4) NOT NULL,
	NON_ORACLE_PARAMS_ST 	varchar(32) NOT NULL
);

ALTER TABLE OraParamsTest ADD constraint PK_OraParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraParamsTest ON OraParamsTest
(
	 MSMT_TIME
);
DROP TABLE OraParamsTest_TREND;

CREATE TABLE OraParamsTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL, 
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	NON_ORACLE_PARAMS_MIN 	decimal(20,4) NOT NULL,
	NON_ORACLE_PARAMS_MAX 	decimal(20,4) NOT NULL,
	NON_ORACLE_PARAMS_STCNT varchar(32) NOT NULL
);

ALTER TABLE OraParamsTest_TREND ADD constraint PK_OraParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraParamsTest_THRESH;

CREATE TABLE OraParamsTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO        			varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	NON_ORACLE_PARAMS_MIN	VARCHAR(256)	 NOT NULL,
	NON_ORACLE_PARAMS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraParamsTest_THRESH ADD constraint PK_OraParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraParamsTest_THRESH ON OraParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraAlertTest;
CREATE TABLE OraAlertTest
( 
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO        			varchar(32) NOT NULL,      
	SITE_NAME       		varchar(64) NOT NULL, 
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	BDUMPERRORCNT 			decimal(20,4) NOT NULL,
	BDUMPERRORCNT_ST 		varchar(32) NOT NULL,
	FILE_SIZE 			decimal(20,4) NOT NULL,
	FILE_SIZE_ST 		varchar(32) NOT NULL,
	GROWTH_RATE			decimal(20,4) NOT NULL,
	GROWTH_RATE_ST			varchar(32) NOT NULL
);
ALTER TABLE OraAlertTest ADD constraint PK_OraAlertTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraAlertTest ON OraAlertTest
(
	 MSMT_TIME
);
DROP TABLE OraAlertTest_TREND;
CREATE TABLE OraAlertTest_TREND 
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME      	 		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	BDUMPERRORCNT_MIN 		decimal(20,4) NOT NULL,
	BDUMPERRORCNT_MAX 		decimal(20,4) NOT NULL,
	BDUMPERRORCNT_STCNT 		varchar(32) NOT NULL,
	FILE_SIZE_MIN 			decimal(20,4) NOT NULL,
	FILE_SIZE_MAX 			decimal(20,4) NOT NULL,
	FILE_SIZE_STCNT 		varchar(32) NOT NULL,
	GROWTH_RATE_MIN 		decimal(20,4) NOT NULL,
	GROWTH_RATE_MAX 		decimal(20,4) NOT NULL,
	GROWTH_RATE_STCNT 		varchar(32) NOT NULL
);
ALTER TABLE OraAlertTest_TREND ADD constraint PK_OraAlertTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraAlertTest_THRESH;
CREATE TABLE OraAlertTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END  	 		datetime NOT NULL,
	BDUMPERRORCNT_MIN		VARCHAR(256)	 NOT NULL,
	BDUMPERRORCNT_MAX		VARCHAR(256)	 NOT NULL,
	FILE_SIZE_MIN			VARCHAR(256)	 NOT NULL,
	FILE_SIZE_MAX			VARCHAR(256)	 NOT NULL,
	GROWTH_RATE_MIN			VARCHAR(256)	 NOT NULL,
	GROWTH_RATE_MAX			VARCHAR(256)	 NOT NULL
);
ALTER TABLE OraAlertTest_THRESH ADD constraint PK_OraAlertTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraAlertTest_THRESH ON OraAlertTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraTsParamsTest;

CREATE TABLE OraTsParamsTest
( 	
	TRGT_HOST       			varchar(32) NOT NULL,
   	PORT_NO         			varchar(32) NOT NULL,
	SITE_NAME       			varchar(64) NOT NULL,  
	INFO            			varchar(128) NOT NULL,	
	MSMT_HOST       			varchar(32) NOT NULL,
	MSMT_TIME       			datetime NOT NULL,
	NON_LOCALLY_MANAGED_TS 			decimal(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_ST 		varchar(32) NOT NULL
);

ALTER TABLE OraTsParamsTest ADD constraint PK_OraTsParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraTsParamsTest ON OraTsParamsTest
(
	 MSMT_TIME
);
DROP TABLE OraTsParamsTest_TREND;

CREATE TABLE OraTsParamsTest_TREND
( 	
	TRGT_HOST      					varchar(32) NOT NULL,
    PORT_NO         				varchar(32) NOT NULL,
    SITE_NAME       				varchar(64) NOT NULL,
    INFO            				varchar(128) NOT NULL,
	MSMT_HOST       				varchar(32) NOT NULL,	
	MSMT_TIME       				datetime NOT NULL,
	PERIOD       					varchar(32) NOT NULL,
	NON_LOCALLY_MANAGED_TS_MIN 		decimal(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX 		decimal(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_STCNT 	varchar(32) NOT NULL
);

ALTER TABLE OraTsParamsTest_TREND ADD constraint PK_OraTsParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraTsParamsTest_THRESH;

CREATE TABLE OraTsParamsTest_THRESH
( 	
	TRGT_HOST       			varchar(32) NOT NULL,
    PORT_NO         			varchar(32) NOT NULL,
    SITE_NAME       			varchar(64) NOT NULL,
    INFO            			varchar(128) NOT NULL,
	MSMT_HOST       			varchar(32) NOT NULL,
	MSMT_TIME_START 			datetime NOT NULL,
	MSMT_TIME_END   			datetime NOT NULL,
	NON_LOCALLY_MANAGED_TS_MIN	VARCHAR(256)	 NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraTsParamsTest_THRESH ADD constraint PK_OraTsParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraTsParamsTest_THRESH ON OraTsParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbCacheTest;
CREATE TABLE Sun1EjbCacheTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
RESIZE_QUANTITY decimal(20,4) NOT NULL,
RESIZE_QUANTITY_ST varchar(32) NOT NULL,
CACHE_MISSES decimal(20,4) NOT NULL,
CACHE_MISSES_ST varchar(32) NOT NULL,
IDLE_TIMEOUT decimal(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar(32) NOT NULL,
NUM_PASSIVS decimal(20,4) NOT NULL,
NUM_PASSIVS_ST varchar(32) NOT NULL,
CACHE_HITS decimal(20,4) NOT NULL,
CACHE_HITS_ST varchar(32) NOT NULL,
NUM_PASSIV_ERRORS decimal(20,4) NOT NULL,
NUM_PASSIV_ERRORS_ST varchar(32) NOT NULL,
BEANS_IN_CACHE decimal(20,4) NOT NULL,
BEANS_IN_CACHE_ST varchar(32) NOT NULL,
EXPIRED_SESS_REMOVED decimal(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_ST varchar(32) NOT NULL,
MAX_BEANS_IN_CACHE decimal(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_ST varchar(32) NOT NULL,
NUM_PASSIV_SUCCESS decimal(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_ST varchar(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest ADD constraint PK_Sun1EjbCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1EjbCacheTest ON Sun1EjbCacheTest
(
	 MSMT_TIME
);
DROP TABLE Sun1EjbCacheTest_TREND;
CREATE TABLE Sun1EjbCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
RESIZE_QUANTITY_MIN decimal(20,4) NOT NULL,
RESIZE_QUANTITY_MAX decimal(20,4) NOT NULL,
RESIZE_QUANTITY_STCNT varchar(32) NOT NULL,
CACHE_MISSES_MIN decimal(20,4) NOT NULL,
CACHE_MISSES_MAX decimal(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar(32) NOT NULL,
IDLE_TIMEOUT_MIN decimal(20,4) NOT NULL,
IDLE_TIMEOUT_MAX decimal(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar(32) NOT NULL,
NUM_PASSIVS_MIN decimal(20,4) NOT NULL,
NUM_PASSIVS_MAX decimal(20,4) NOT NULL,
NUM_PASSIVS_STCNT varchar(32) NOT NULL,
CACHE_HITS_MIN decimal(20,4) NOT NULL,
CACHE_HITS_MAX decimal(20,4) NOT NULL,
CACHE_HITS_STCNT varchar(32) NOT NULL,
NUM_PASSIV_ERRORS_MIN decimal(20,4) NOT NULL,
NUM_PASSIV_ERRORS_MAX decimal(20,4) NOT NULL,
NUM_PASSIV_ERRORS_STCNT varchar(32) NOT NULL,
BEANS_IN_CACHE_MIN decimal(20,4) NOT NULL,
BEANS_IN_CACHE_MAX decimal(20,4) NOT NULL,
BEANS_IN_CACHE_STCNT varchar(32) NOT NULL,
EXPIRED_SESS_REMOVED_MIN decimal(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_MAX decimal(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_STCNT varchar(32) NOT NULL,
MAX_BEANS_IN_CACHE_MIN decimal(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_MAX decimal(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_STCNT varchar(32) NOT NULL,
NUM_PASSIV_SUCCESS_MIN decimal(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_MAX decimal(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest_TREND ADD constraint PK_Sun1EjbCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbCacheTest_THRESH;
CREATE TABLE Sun1EjbCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
RESIZE_QUANTITY_MIN	VARCHAR(256)	 NOT NULL,
RESIZE_QUANTITY_MAX	VARCHAR(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR(256)	 NOT NULL,
IDLE_TIMEOUT_MIN	VARCHAR(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR(256)	 NOT NULL,
NUM_PASSIVS_MIN	VARCHAR(256)	 NOT NULL,
NUM_PASSIVS_MAX	VARCHAR(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
BEANS_IN_CACHE_MIN	VARCHAR(256)	 NOT NULL,
BEANS_IN_CACHE_MAX	VARCHAR(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MIN	VARCHAR(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MAX	VARCHAR(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MIN	VARCHAR(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MAX	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MIN	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1EjbCacheTest_THRESH ADD constraint PK_Sun1EjbCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbCacheTest_THRESH ON Sun1EjbCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbPoolTest;
CREATE TABLE Sun1EjbPoolTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
IDLE_TIMEOUT decimal(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar(32) NOT NULL,
STEADY_POOL_SIZE decimal(20,4) NOT NULL,
STEADY_POOL_SIZE_ST varchar(32) NOT NULL,
TOTAL_BEANS_DESTROYED decimal(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_ST varchar(32) NOT NULL,
NUM_THREADS_WAITING decimal(20,4) NOT NULL,
NUM_THREADS_WAITING_ST varchar(32) NOT NULL,
NUM_BEANS_IN_POOL decimal(20,4) NOT NULL,
NUM_BEANS_IN_POOL_ST varchar(32) NOT NULL,
MAX_POOL_SIZE decimal(20,4) NOT NULL,
MAX_POOL_SIZE_ST varchar(32) NOT NULL,
POOL_RESIZE_QUANTITY decimal(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_ST varchar(32) NOT NULL,
TOTAL_BEANS_CREATED decimal(20,4) NOT NULL,
TOTAL_BEANS_CREATED_ST varchar(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest ADD constraint PK_Sun1EjbPoolTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1EjbPoolTest ON Sun1EjbPoolTest
(
	 MSMT_TIME
);
DROP TABLE Sun1EjbPoolTest_TREND;
CREATE TABLE Sun1EjbPoolTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IDLE_TIMEOUT_MIN decimal(20,4) NOT NULL,
IDLE_TIMEOUT_MAX decimal(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar(32) NOT NULL,
STEADY_POOL_SIZE_MIN decimal(20,4) NOT NULL,
STEADY_POOL_SIZE_MAX decimal(20,4) NOT NULL,
STEADY_POOL_SIZE_STCNT varchar(32) NOT NULL,
TOTAL_BEANS_DESTROYED_MIN decimal(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_MAX decimal(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_STCNT varchar(32) NOT NULL,
NUM_THREADS_WAITING_MIN decimal(20,4) NOT NULL,
NUM_THREADS_WAITING_MAX decimal(20,4) NOT NULL,
NUM_THREADS_WAITING_STCNT varchar(32) NOT NULL,
NUM_BEANS_IN_POOL_MIN decimal(20,4) NOT NULL,
NUM_BEANS_IN_POOL_MAX decimal(20,4) NOT NULL,
NUM_BEANS_IN_POOL_STCNT varchar(32) NOT NULL,
MAX_POOL_SIZE_MIN decimal(20,4) NOT NULL,
MAX_POOL_SIZE_MAX decimal(20,4) NOT NULL,
MAX_POOL_SIZE_STCNT varchar(32) NOT NULL,
POOL_RESIZE_QUANTITY_MIN decimal(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_MAX decimal(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_STCNT varchar(32) NOT NULL,
TOTAL_BEANS_CREATED_MIN decimal(20,4) NOT NULL,
TOTAL_BEANS_CREATED_MAX decimal(20,4) NOT NULL,
TOTAL_BEANS_CREATED_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest_TREND ADD constraint PK_Sun1EjbPoolTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbPoolTest_THRESH;
CREATE TABLE Sun1EjbPoolTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IDLE_TIMEOUT_MIN	VARCHAR(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR(256)	 NOT NULL,
STEADY_POOL_SIZE_MIN	VARCHAR(256)	 NOT NULL,
STEADY_POOL_SIZE_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MAX	VARCHAR(256)	 NOT NULL,
NUM_THREADS_WAITING_MIN	VARCHAR(256)	 NOT NULL,
NUM_THREADS_WAITING_MAX	VARCHAR(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MIN	VARCHAR(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MAX	VARCHAR(256)	 NOT NULL,
MAX_POOL_SIZE_MIN	VARCHAR(256)	 NOT NULL,
MAX_POOL_SIZE_MAX	VARCHAR(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MIN	VARCHAR(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1EjbPoolTest_THRESH ADD constraint PK_Sun1EjbPoolTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbPoolTest_THRESH ON Sun1EjbPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1HttpTest;
CREATE TABLE Sun1HttpTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
REQUESTS_COUNT DECIMAL(20,4) NOT NULL,
REQUESTS_COUNT_ST varchar(32) NOT NULL,
KB_RECEIVED_COUNT DECIMAL(20,4) NOT NULL,
KB_RECEIVED_COUNT_ST varchar(32) NOT NULL,
KB_TRANSMITTED_COUNT DECIMAL(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_ST varchar(32) NOT NULL,
MAX_TRANS_RATE_HWM decimal(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_ST varchar(32) NOT NULL,
OPEN_CONNECTIONS_COUNT decimal(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_ST varchar(32) NOT NULL,
MAX_OPEN_CONNS_HWM decimal(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_ST varchar(32) NOT NULL,
COUNT_2XX DECIMAL(20,4) NOT NULL,
COUNT_2XX_ST varchar(32) NOT NULL,
COUNT_3XX DECIMAL(20,4) NOT NULL,
COUNT_3XX_ST varchar(32) NOT NULL,
COUNT_4XX DECIMAL(20,4) NOT NULL,
COUNT_4XX_ST varchar(32) NOT NULL,
COUNT_5XX DECIMAL(20,4) NOT NULL,
COUNT_5XX_ST varchar(32) NOT NULL,
OTHER_RESPONSES_COUNT DECIMAL(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_ST varchar(32) NOT NULL);

ALTER TABLE Sun1HttpTest ADD constraint PK_Sun1HttpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1HttpTest ON Sun1HttpTest
(
	 MSMT_TIME
);
DROP TABLE Sun1HttpTest_TREND;
CREATE TABLE Sun1HttpTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
REQUESTS_COUNT_MIN DECIMAL(20,4) NOT NULL,
REQUESTS_COUNT_MAX DECIMAL(20,4) NOT NULL,
REQUESTS_COUNT_STCNT varchar(32) NOT NULL,
KB_RECEIVED_COUNT_MIN DECIMAL(20,4) NOT NULL,
KB_RECEIVED_COUNT_MAX DECIMAL(20,4) NOT NULL,
KB_RECEIVED_COUNT_STCNT varchar(32) NOT NULL,
KB_TRANSMITTED_COUNT_MIN DECIMAL(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_MAX DECIMAL(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_STCNT varchar(32) NOT NULL,
MAX_TRANS_RATE_HWM_MIN decimal(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_MAX decimal(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_STCNT varchar(32) NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN decimal(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX decimal(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_STCNT varchar(32) NOT NULL,
MAX_OPEN_CONNS_HWM_MIN decimal(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_MAX decimal(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_STCNT varchar(32) NOT NULL,
COUNT_2XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_2XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_2XX_STCNT varchar(32) NOT NULL,
COUNT_3XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_3XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_3XX_STCNT varchar(32) NOT NULL,
COUNT_4XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_4XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_4XX_STCNT varchar(32) NOT NULL,
COUNT_5XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_5XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_5XX_STCNT varchar(32) NOT NULL,
OTHER_RESPONSES_COUNT_MIN DECIMAL(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_MAX DECIMAL(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1HttpTest_TREND ADD constraint PK_Sun1HttpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1HttpTest_THRESH;
CREATE TABLE Sun1HttpTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
REQUESTS_COUNT_MIN	VARCHAR(256)	 NOT NULL,
REQUESTS_COUNT_MAX	VARCHAR(256)	 NOT NULL,
KB_RECEIVED_COUNT_MIN	VARCHAR(256)	 NOT NULL,
KB_RECEIVED_COUNT_MAX	VARCHAR(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MIN	VARCHAR(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MAX	VARCHAR(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MIN	VARCHAR(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MAX	VARCHAR(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN	VARCHAR(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX	VARCHAR(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MIN	VARCHAR(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MAX	VARCHAR(256)	 NOT NULL,
COUNT_2XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_2XX_MAX	VARCHAR(256)	 NOT NULL,
COUNT_3XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_3XX_MAX	VARCHAR(256)	 NOT NULL,
COUNT_4XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_4XX_MAX	VARCHAR(256)	 NOT NULL,
COUNT_5XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_5XX_MAX	VARCHAR(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MIN	VARCHAR(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1HttpTest_THRESH ADD constraint PK_Sun1HttpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1HttpTest_THRESH ON Sun1HttpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1JdbcTest;
CREATE TABLE Sun1JdbcTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
TOTAL_THREADS_WAITING decimal(20,4) NOT NULL,
TOTAL_THREADS_WAITING_ST varchar(32) NOT NULL,
TOTAL_CONNS_FAILED decimal(20,4) NOT NULL,
TOTAL_CONNS_FAILED_ST varchar(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT decimal(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_ST varchar(32) NOT NULL);

ALTER TABLE Sun1JdbcTest ADD constraint PK_Sun1JdbcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1JdbcTest ON Sun1JdbcTest
(
	 MSMT_TIME
);
DROP TABLE Sun1JdbcTest_TREND;
CREATE TABLE Sun1JdbcTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_THREADS_WAITING_MIN decimal(20,4) NOT NULL,
TOTAL_THREADS_WAITING_MAX decimal(20,4) NOT NULL,
TOTAL_THREADS_WAITING_STCNT varchar(32) NOT NULL,
TOTAL_CONNS_FAILED_MIN decimal(20,4) NOT NULL,
TOTAL_CONNS_FAILED_MAX decimal(20,4) NOT NULL,
TOTAL_CONNS_FAILED_STCNT varchar(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN decimal(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX decimal(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1JdbcTest_TREND ADD constraint PK_Sun1JdbcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1JdbcTest_THRESH;
CREATE TABLE Sun1JdbcTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_THREADS_WAITING_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_THREADS_WAITING_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1JdbcTest_THRESH ADD constraint PK_Sun1JdbcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1JdbcTest_THRESH ON Sun1JdbcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1TxTest;
CREATE TABLE Sun1TxTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
TOTAL_TX_COMPLETED decimal(20,4) NOT NULL,
TOTAL_TX_COMPLETED_ST varchar(32) NOT NULL,
TOTAL_TX_ROLLED_BACK decimal(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_ST varchar(32) NOT NULL,
TOTAL_TX_INFLIGHT decimal(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_ST varchar(32) NOT NULL);

ALTER TABLE Sun1TxTest ADD constraint PK_Sun1TxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1TxTest ON Sun1TxTest
(
	 MSMT_TIME
);
DROP TABLE Sun1TxTest_TREND;
CREATE TABLE Sun1TxTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_TX_COMPLETED_MIN decimal(20,4) NOT NULL,
TOTAL_TX_COMPLETED_MAX decimal(20,4) NOT NULL,
TOTAL_TX_COMPLETED_STCNT varchar(32) NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN decimal(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX decimal(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_STCNT varchar(32) NOT NULL,
TOTAL_TX_INFLIGHT_MIN decimal(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_MAX decimal(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1TxTest_TREND ADD constraint PK_Sun1TxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1TxTest_THRESH;
CREATE TABLE Sun1TxTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_TX_COMPLETED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_TX_COMPLETED_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1TxTest_THRESH ADD constraint PK_Sun1TxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1TxTest_THRESH ON Sun1TxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAppTest;
CREATE TABLE CtxAppTest (
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
NUMBER_OF_PROCESSES decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_ST varchar(32) NOT NULL,
CPU_USAGE DECIMAL(20,4) NOT NULL,
CPU_USAGE_ST varchar(32) NOT NULL,
MEMORY_USAGE DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_ST varchar(32) NOT NULL,
HANDLE_COUNT decimal(20,4) NOT NULL,
HANDLE_COUNT_ST varchar(32) NOT NULL,
NO_OF_THREADS decimal(20,4) NOT NULL,
NO_OF_THREADS_ST varchar(32) NOT NULL,
IO_DATA_RATE DECIMAL(20,4) NOT NULL,
IO_DATA_RATE_ST varchar(32) NOT NULL,
IO_DATA_OPER_RATE DECIMAL(20,4) NOT NULL,
IO_DATA_OPER_RATE_ST varchar(32) NOT NULL,
IO_READ_DATA_RATE DECIMAL(20,4) NOT NULL,
IO_READ_DATA_RATE_ST varchar(32) NOT NULL,
IO_WRITE_DATA_RATE DECIMAL(20,4) NOT NULL,
IO_WRITE_DATA_RATE_ST varchar(32) NOT NULL,
PAGE_FAULT_RATE DECIMAL(20,4) NOT NULL,
PAGE_FAULT_RATE_ST varchar(32) NOT NULL,
VIRTUAL_MEMORY_USED DECIMAL(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_ST varchar(32) NOT NULL,
MEMORY_USED DECIMAL(20,4) NOT NULL,
MEMORY_USED_ST varchar(32) NOT NULL);

ALTER TABLE CtxAppTest ADD constraint PK_CtxAppTest  PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_CtxAppTest ON CtxAppTest (MSMT_TIME) INCLUDE (NUMBER_OF_PROCESSES,CPU_USAGE,MEMORY_USAGE);
DROP TABLE CtxAppTest_TREND;
CREATE TABLE CtxAppTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUMBER_OF_PROCESSES_MIN decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_MAX decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_STCNT varchar(32) NOT NULL,
CPU_USAGE_MIN DECIMAL(20,4) NOT NULL,
CPU_USAGE_MAX DECIMAL(20,4) NOT NULL,
CPU_USAGE_STCNT varchar(32) NOT NULL,
MEMORY_USAGE_MIN DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_MAX DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_STCNT varchar(32) NOT NULL,
HANDLE_COUNT_MIN decimal(20,4) NOT NULL,
HANDLE_COUNT_MAX decimal(20,4) NOT NULL,
HANDLE_COUNT_STCNT varchar(32) NOT NULL,
NO_OF_THREADS_MIN decimal(20,4) NOT NULL,
NO_OF_THREADS_MAX decimal(20,4) NOT NULL,
NO_OF_THREADS_STCNT varchar(32) NOT NULL,
IO_DATA_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_DATA_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_DATA_RATE_STCNT varchar(32) NOT NULL,
IO_DATA_OPER_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_DATA_OPER_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_DATA_OPER_RATE_STCNT varchar(32) NOT NULL,
IO_READ_DATA_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_READ_DATA_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_READ_DATA_RATE_STCNT varchar(32) NOT NULL,
IO_WRITE_DATA_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_WRITE_DATA_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_WRITE_DATA_RATE_STCNT varchar(32) NOT NULL,
PAGE_FAULT_RATE_MIN DECIMAL(20,4) NOT NULL,
PAGE_FAULT_RATE_MAX DECIMAL(20,4) NOT NULL,
PAGE_FAULT_RATE_STCNT varchar(32) NOT NULL,
VIRTUAL_MEMORY_USED_MIN DECIMAL(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_MAX DECIMAL(20,4) NOT N