#!/bin/bash

#Reads the PHP binary location from the arguments 
phpProgram="php"
configpath="/opt/egurkha/"
extensionpath=""
if [ "$1" != "" ] ; then
        phpProgram=$1

else
        phpProgram="php"
fi

#Reads the PHPBTM log & configuration file location from the arguments
if [ "$2" != "" ] ; then
        configpath=$2
else
        configpath="/opt/egurkha/"
fi

#Get the PHP extension based on the system architecture
is64=`uname -m | grep "64" | wc -l`
if [[ $is64 -eq 1 ]]; then
   	extensionpath="${configpath}/lib/lib64/phpBTM/"
else
	extensionpath="${configpath}/lib/phpBTM/"
fi  

#Get the PHP version
phpversn=$(${phpProgram} -dagent.cli_enabled=0 -r 'print PHP_VERSION_ID; print "\n";' 2>/dev/null)
phpversn=(${phpversn[@]})

versn=50600
__versn=$($${phpProgram} -v 2> /dev/null)
if [ -n "$__versn" ] ; then
    	fatal_error "*** PHP Installation NOT FOUND ***"
    	echo "Setup Aborted"
    	exit
elif [ $phpversn -ge $versn ] 
then
phpvno=$(${phpProgram} -dagent.cli_enabled=0 -r 'print phpversion(); print "\n";' 2>/dev/null)
phpvno=(${phpvno[@]})

echo ".... PHP version "$phpvno" Found ...."

__threadsfty=$($${phpProgram} -i 2> /dev/null | grep "Thread Safety => enabled")
__debugbld=$($${phpProgram} -i 2> /dev/null | grep "Debug Build => yes")
if [ "$__threadsfty" != "" ] ; then
    	fatal_error "*** Disable Thread Safety and run the Script again ***"
    	echo "Setup Aborted"
    	exit
fi
if [ "$__debugbld" != "" ] ; then
   	fatal_error "*** PHP as Debug build is not Supported ***"
    	echo "Setup Aborted"
    	exit
else
# Getting additional .ini files location
  additnlIniDir=$(${phpProgram} -dagent.cli_enabled=0 -r 'print PHP_CONFIG_FILE_SCAN_DIR; print "\n";' 2>/dev/null)
  additnlIniDir=(${additnlIniDir[@]})
  majorversion=$(php -dagent.cli_enabled=0 -r 'print PHP_MAJOR_VERSION; print "\n";' 2>/dev/null)
  majorversion=(${majorversion[@]})
  minorversion=$(php -dagent.cli_enabled=0 -r 'print PHP_MINOR_VERSION; print "\n";' 2>/dev/null)
  minorversion=(${minorversion[@]})
  egextension="${extensionpath}eG_phpBTM_${majorversion}.${minorversion}.so"
  echo ""
  if [  "$additnlIniDir" != "" ]; then
        eginifile="/eG_phpBTM.ini"
	file="$additnlIniDir$eginifile"
	echo "	Creating eG_phpBTM.ini in ""${additnlIniDir}/"
	rm -f "$file"
        echo "extension=eG_phpBTM.so" >> "$file"
	echo "egagent.configpath=""$configpath" >> "$file"
  else
#Get the (php.ini) location
	iniPath=$(${phpProgram} -dagent.cli_enabled=0 -r 'print PHP_CONFIG_FILE_PATH; print "\n";' 2>/dev/null)
        iniPath=(${iniPath[@]})
	phpinifile="/php.ini"
	file="$iniPath$phpinifile"
	if [ ! -f "$file" ]
	then
	  	echo "*** PHP Configuration file not found ($file) ***"
		echo "Setup Aborted"
		exit;
	else
		echo "	Adding extension in ""${file}"
		sed -i "/\b\(.*eG_phpBTM\)\b/d" "${file}"
		sed -i "/\b\(egagent.configpath*\)\b/d" "${file}"
		echo "egagent.configpath=""$configpath" >> "$file"
		echo "extension=eG_phpBTM.so" >> "$file"
	fi
  fi
#Get the extension directory location
  	extDir=$(${phpProgram} -dagent.cli_enabled=0 -r 'print ini_get("extension_dir"); print "\n";' 2>/dev/null)
  	extDir=(${extDir[@]})
  	echo "	Copying the PHP BTM module to ""${extDir}/"
	  
  	if cp -f "$egextension" "$extDir/eG_phpBTM.so"
  	then
   		echo ""
   		echo "-----------------------------------------------------"
   		echo "	eG PHP BTM Installed Successfully"
   		echo "-----------------------------------------------------"
	else
		echo "Setup Aborted"
	fi
  
fi
else
 echo "*** PHP version not supported *** "
 echo $phpversn 
fi



