#!/bin/sh

# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -----------------------------------------------------------------------------
#  Set JAVA_HOME or JRE_HOME if not already set, ensure any provided settings
#  are valid and consistent with the selected start-up options and set up the
#  endorsed directory.
# -----------------------------------------------------------------------------

# Make sure prerequisite environment variables are set
if [ -z "$JAVA_HOME" ] && [ -z "$JRE_HOME" ]; then
  if $darwin; then
    # Bugzilla 54390
    if [ -x '/usr/libexec/java_home' ] ; then
      export JAVA_HOME=`/usr/libexec/java_home`
    # Bugzilla 37284 (reviewed).
    elif [ -d "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home" ]; then
      export JAVA_HOME="/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home"
    fi
  else
    JAVA_PATH=`which java 2>/dev/null`
    if [ "x$JAVA_PATH" != "x" ]; then
      JAVA_PATH=`dirname "$JAVA_PATH" 2>/dev/null`
      JRE_HOME=`dirname "$JAVA_PATH" 2>/dev/null`
    fi
    if [ "x$JRE_HOME" = "x" ]; then
      # XXX: Should we try other locations?
      if [ -x /usr/bin/java ]; then
        JRE_HOME=/usr
      fi
    fi
  fi
  if [ -z "$JAVA_HOME" ] && [ -z "$JRE_HOME" ]; then
    echo "Neither the JAVA_HOME nor the JRE_HOME environment variable is defined"
    echo "At least one of these environment variable is needed to run this program"
    exit 1
  fi
fi
if [ -z "$JAVA_HOME" ] && [ "$1" = "debug" ]; then
  echo "JAVA_HOME should point to a JDK in order to run in debug mode."
  exit 1
fi
if [ -z "$JRE_HOME" ]; then
  JRE_HOME="$JAVA_HOME"
fi

# If we're running under jdb, we need a full jdk.
if [ "$1" = "debug" ] ; then
  if [ "$os400" = "true" ]; then
    if [ ! -x "$JAVA_HOME"/bin/java ] || [ ! -x "$JAVA_HOME"/bin/javac ]; then
      echo "The JAVA_HOME environment variable is not defined correctly"
      echo "This environment variable is needed to run this program"
      echo "NB: JAVA_HOME should point to a JDK not a JRE"
      exit 1
    fi
  else
    if [ ! -x "$JAVA_HOME"/bin/java ] || [ ! -x "$JAVA_HOME"/bin/jdb ] || [ ! -x "$JAVA_HOME"/bin/javac ]; then
      echo "The JAVA_HOME environment variable is not defined correctly"
      echo "This environment variable is needed to run this program"
      echo "NB: JAVA_HOME should point to a JDK not a JRE"
      exit 1
    fi
  fi
fi

# Don't override the endorsed dir if the user has set it previously
if [ -z "$JAVA_ENDORSED_DIRS" ]; then
  # Java 9 no longer supports the java.endorsed.dirs
  # system property. Only try to use it if
  # CATALINA_HOME/endorsed exists.
  if [ -d "$CATALINA_HOME"/endorsed ]; then
    JAVA_ENDORSED_DIRS="$CATALINA_HOME"/endorsed
  fi
fi

# Set standard commands for invoking Java, if not already set.
if [ -z "$_RUNJAVA" ]; then
  _RUNJAVA="$JRE_HOME"/bin/java
fi
if [ "$os400" != "true" ]; then
  if [ -z "$_RUNJDB" ]; then
    _RUNJDB="$JAVA_HOME"/bin/jdb
  fi
fi


EG_HOME=/opt/egurkha
export EG_HOME

EGURKHA_INSTALL_DIR=$EG_HOME
CATALINA_HOME=$EG_HOME/manager/tomcat
EG_LIB=$EG_HOME/lib
PJA_HOME=$EG_HOME/manager/pja

export EGURKHA_INSTALL_DIR CATALINA_HOME EG_LIB PJA_HOME

LD_LIBRARY_PATH=$EG_HOME/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

CLASSPATH=.:$CATALINA_HOME/bin/bootstrap.jar:$EG_HOME/lib/httpcore.jar:$CATALINA_HOME/bin/tomcat-juli.jar:$CATALINA_HOME/lib/tomcat-util.jar:$CATALINA_HOME/lib/tomcat-api.jar:$CATALINA_HOME/lib/catalina.jar:$CATALINA_HOME/lib/servlet-api.jar:$CATALINA_HOME/lib/jsp-api.jar:$CATALINA_HOME/bin/commons-daemon.jar:$CATALINA_HOME/lib/catalina-ant.jar:$CATALINA_HOME/lib/annotations-api.jar:$CATALINA_HOME/lib/catalina-ha.jar:$CATALINA_HOME/lib/catalina-tribes.jar:$CATALINA_HOME/lib/el-api.jar:$CATALINA_HOME/lib/ecj-4.6.1.jar:$CATALINA_HOME/lib/jasper.jar:$CATALINA_HOME/lib/jasper-el.jar:$CATALINA_HOME/lib/tomcat-coyote.jar:$CATALINA_HOME/lib/tomcat-dbcp.jar:$CATALINA_HOME/webapps/final/WEB-INF/classes:$EG_HOME/lib/eg_manager.jar:$EG_HOME/lib/eg_util.jar:$EG_HOME/lib/pd4ml.jar:$EG_HOME/lib/pdfbox-app.jar:$EG_HOME/lib/ss_css2.jar:$EG_HOME/lib/java-ssh.jar:$EG_HOME/lib/fcexporter.jar:$EG_HOME/lib/dnsjava.jar:$EG_HOME/lib/spark.jar:$EG_HOME/lib/font.jar:$EG_HOME/lib/pop3.jar:$EG_HOME/lib/ireasoningsnmp.jar:$EG_HOME/lib/jakarta-regexp-1.2.jar:$EG_HOME/lib/NCSO.jar:$EG_HOME/lib/Notes.jar:$EG_HOME/lib/eg_ttclient.jar:$EG_HOME/lib/indexer-taglib.jar:$EG_HOME/lib/GSMEngine.jar:$EG_HOME/lib/eg_troubleticket.jar:$EG_HOME/lib/ThinTds.jar:$EG_HOME/lib/mail.jar:$EG_HOME/lib/:$PJA_HOME/pja.jar:$EG_HOME/lib/Acme.jar:$EG_HOME/lib/eg_jvmdemo.jar:$EG_HOME/lib/jdom.jar:$EG_HOME/lib/jaxen-jdom.jar:$EG_HOME/lib/OpenForecast-0.4.0.jar:$EG_HOME/lib/aws-java-sdk.jar:$EG_HOME/lib/commons-codec.jar:$EG_HOME/lib/commons-httpclient.jar:$PJA_HOME/rtgraphics.jar:$EG_HOME/lib/log4j.jar:$EG_HOME/lib/activation.jar:$EG_LIB/itext.jar:$EG_LIB/jasperreports.jar:$EG_LIB/jce.jar:$EG_LIB/jcert.jar:$EG_LIB/jnet.jar:$EG_LIB/jsse.jar:$EG_LIB/jtds.jar:$EG_LIB/parser.jar:$EG_LIB/xml-apis.jar:$EG_LIB/xercesImpl.jar:$EG_LIB/classes111.zip:$EG_LIB/chart.jar:$EG_LIB/chart.ext.jar:$EG_LIB/chartServer.jar:$CATALINA_HOME/lib/commons-beanutils.jar:$JAVA_LIB/tools.jar:$JAVA_LIB/dt.jar:$JAVA_LIB/rt.jar:$CATALINA_HOME/lib/tomcat-util-scan.jar:$CATALINA_HOME/lib/jaspic-api.jar:$CATALINA_HOME/lib/tomcat-jni.jar:$CLASSPATH:$EG_LIB/rest-api-schemas.jar:$EG_LIB/vcloud-java-sdk.jar:$EG_HOME/manager/lib/ServiceDesk.jar:$EG_HOME/manager/lib/json-lib-2.2.3.jar:$EG_LIB/xalan.jar:$EG_LIB/sapjco.jar::$EG_HOME/lib/eg_subscribermanagement.jar:$EG_HOME/lib/jackson-databind.jar:$EG_HOME/lib/maxmind-db.jar:$EG_HOME/manager/lib/json-simple-1.1.1.jar:$EG_HOME/lib/jackson-annotations.jar:$EG_HOME/lib/jackson-core.jar:$EG_HOME/lib/commons-configuration.jar
export CLASSPATH


