Ext.define('SLAHome.controller.Main', {
	extend: 'Ext.app.Controller',
	views:['SLAHome.view.Main','SLAHome.view.SLATree','SLAHome.view.SLAOverview'],
	refs:[{
		ref:'treePanel',
		selector:'slatree treepanel'
	},{
		ref:'slatabpanel',
		selector:'slatabpanel'
	},{
		ref:'slatree',
		selector:'slatree'
	},{
		ref:'sladashboardsettings',
		selector:'sladashboardsettings'
	},{
		ref:'treePanel',
		selector:'slatree treepanel'
	}],
	refreshFlag:false,
	init: function() {
		setInterval("execute()",refreshFreq);
		this.control({
			'slatree treepanel':{
				afterrender : function(){
					var selectednode_Id  = requestParams.selectedTreeId;
					//console.log("selectedTreeId"+selectednode_Id);
					if(selectednode_Id!=='null' && selectednode_Id!==null)
					{
						var treePanel=this.getTreePanel();
						var record = treePanel.getStore().getNodeById(selectednode_Id);
						treePanel.getSelectionModel().select(record);
						
						var selectedNodeDepth=record.getDepth();
						var selected=record;

						for(var i=0; i < selectedNodeDepth; i++){
							if(selected.isLeaf()){
								selected.parentNode.expand();
							}
							else{
								selected.expand();
							}
							selected=selected.parentNode;
						}
						
					}
				},
				itemclick:{
					fn:function(view, record, item, index, event)
					{
						var treePanel=this.getTreePanel();
						nodeId = record.data.text;
						var node_id = record.data.id;
						this.getTreePanel().expandNode(record);
						var myLink=record.raw.link;
						//console.log("myLink"+myLink+"\n"+"selectedId"+node_id);
						if ( !Ext.isEmpty(myLink) && myLink != 'undifined' )
						{
							localStorage.setItem( 'top10Tab',"top10slapanel" );
							//refreshLink=myLink+"&selectedId="+node_id+"&treeOpen=true";
							//console.log(">>>>refreshLink????"+refreshLink);
							document.location=myLink+"&selectedId="+node_id+"&treeOpen=true";
						}
						
						
					}
				}
			},
			'slatree':{
				
			},
			'sladashboardsettings':{
				'afterrender':this.slaDashboardSetting
			},
			'sladashboardsettings button[id="settingsupdateButton"]':
			{
				'click': this.updateSettings
			}
			
		});
	},
	refreshData : function(){
		
		var slaTreeObj = Ext.getCmp('slaTreeID');
		slaTreeObj.loadSLATree();
		
		var slaOverviewObj = Ext.getCmp('slaoverviewpanel');
		slaOverviewObj.loadSLAOverview();
	},
	slaDashboardSetting: function(){
		var me = this;
		var url = '/final/SLA/scripts/SLAHome/data/eGSLASettings.jsp';
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var listForSlaView = jsonData['slabaseviewList'];
				var listForIgnoreVal = jsonData['yesornoComboList'];
				var selectedForSlaView = jsonData['slabasecViewSelected'];
				var selectedForIgnoreVal = jsonData['ignorevalueSelected'];
				var selectedForIgnoreUnkn = jsonData['ignoreunknownSelected'];
				var refreshFreq = jsonData['refreshFrequency'];

				var refFreqTextField = Ext.getCmp('refreshFreq');
				refFreqTextField.setValue(refreshFreq);

				var slaviewCombo = Ext.getCmp('slaViewBasedCombo');
				me.setValueForCombo(slaviewCombo,listForSlaView,selectedForSlaView);

				var ingnoreValueCombo = Ext.getCmp('ignoreValueCombo');
				me.setValueForCombo(ingnoreValueCombo,listForIgnoreVal,selectedForIgnoreVal);

				var ignoreUnknown = Ext.getCmp('ignoreUnknownCombo');
				me.setValueForCombo(ignoreUnknown,listForIgnoreVal,selectedForIgnoreUnkn);
				
			},
			failure : function(){
				//alert("failure");
			}
		});
		var dashboardsettingpanel = Ext.getCmp('sladashboardsettings');
	},
	setValueForCombo: function(comboObj,list,selected){
		comboObj.getStore().loadRawData(list);
		if ( selected != null &&  selected != "")
		{
			comboObj.setValue(selected);
		}
		else
			comboObj.setValue(list[0]['valueField']);
	},
	updateSettings:function()
	{
		var me = this;
		var url = '/final/SLA/eGSLASettingsp.jsp?';

		var dashboardObj = Ext.getCmp('sladashboardsettings');
		var slaviewCombo = Ext.getCmp('slaViewBasedCombo').getValue();
		var refFreqTextField = Ext.getCmp('refreshFreq').getValue();
		var ingnoreValueCombo = Ext.getCmp('ignoreValueCombo').getValue();
		var ignoreUnknown = Ext.getCmp('ignoreUnknownCombo').getValue();
		url+= '&viewMode='+slaviewCombo+'&refreshFrequency='+refFreqTextField+'&ignoreNAValues='+ingnoreValueCombo+'&ignoreUnknownValues='+ignoreUnknown+'&cacheCurrent='+(new Date().getTime());
		//dashboardObj.hide();
		window.location.href = url;
	}
});
