Ext.define('SLAHome.view.CurrentStatus', {
	extend : 'utilities.CommonPanel',
	alias : 'widget.currentstatus',
	title:currentStatusTitle,
	rootComponent : null,
	margin:'5',
	bodyPadding:'0',
	layout : 'hbox',
	id:'currentstatuspanel',
	width :180,
	flex:0.6,
	initComponent : function() {		
		var me = this;
		this.callParent();
		var chartHtml = me.returnChartHtml(me.rootComponent);
		var slaStatesHtml = me.returnSLAStates(me.rootComponent);
		var chartPanel ={
				xtype:'container',
				border:false,
				html : chartHtml,
				cls : 'header-image',
				itemId:'chartPanel',
				flex:1,
				maxWidth :180,
				height: 200
		};
		var slaStatePanel = {
				xtype:'container',
				border:false,
				html : slaStatesHtml,
				cls : 'header-image',
				itemId:'statePanel',
				flex:1,
				pack:'center',
				maxWidth :200,
				height: 200
		}
		me.add(chartPanel);
		me.add(slaStatePanel);
		me.doLayout();		
	},	
	returnChartHtml : function(data){
		var htmlstring = '<div style=" width:100%; height:100%;margin-top:3px !important" class="systemTab-bg">'
			+'<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="100%" height="100%" id="objTagBottomId" flashVars="&dataXML='+ data["XMLData"] +'&chartWidth= "100%" &chartHeight= "100%"  align="center" valign="middle">'
			+'<param name="FlashVars" value="&dataXML='+ data["XMLData"]+'&chartWidth= "100%" &chartHeight= "100%"/>'
			+'<param name="quality" value="high" />'
			+'<param name="WMode" value="Transparent"/>'
			+'<param name="movie" value="/final/FusionCharts/swf/'+data["chartFile"]+'" />'
			+'<embed wmode="transparent" src="/final/FusionCharts/swf/'+data["chartFile"]+'" flashVars="&dataXML='+data["XMLData"]+'&chartWidth= "100%" &chartHeight= "100%" quality="high" width="100%" height="100%" align="center" valign="middle" name="'+ data["chartFile"] +'Name" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer"/>'
		+'</object>'
			+'</div>';
		return  htmlstring;
	},
	returnSLAStates : function(data){
		var marginTop=60;
		var htmlString = '<table border="0" cellspacing="0" cellpadding="0" style="padding:4px;vertical-align: middle !important;" width="100%" valign="middle">'+
					'<col width="2%"><col width="97%"><col width="1%"><tr><td style="padding:4px"><div class = "iconConfigUser" > </div></td><td nowrap><b>'+configuredSLA+'</b></td>'+
							'<td ><b>'+data["totalSla"]+'</b></td></tr><tr><td colspan="3"><div style="clear:both;width:100%;height:2px;margin:0px 0px 0px 0px;" class="slaSeparatorHorizontalLight">&nbsp;</div></td></tr>';
		if(data["successCount"]>0){
				htmlString=htmlString+'<tr><td style="padding:4px"><div style="float:left;margin-right:4px;" class="state_GOOD" > </div></td><td nowrap>'+inCompliance+'</td><td><b>'+data["successCount"]+'</b></td></tr><tr><td colspan="3"><div style="clear:both;width:100%;height:2px;margin:0px 0px 0px 0px;" class="slaSeparatorHorizontalLight">&nbsp;</div></td></tr>';
				marginTop=marginTop-10;
		}
		if(data["failureCount"]>0){
			htmlString=htmlString+'<tr><td style="padding:4px"><div style="float:left;margin-right:4px;" class="state_HIGH" > </div></td><td nowrap>'+outCompliance+'</td><td><b>'+data["failureCount"]+'</b></td></tr><tr><td colspan="3"><div style="clear:both;width:100%;height:2px;margin:0px 0px 0px 0px;" class="slaSeparatorHorizontalLight">&nbsp;</div></td></tr>';
			marginTop=marginTop-10;
		}
		if(data["unknownCount"]>0){
			htmlString=htmlString+'<tr><td style="padding:4px"><div style="float:left;margin-right:4px;" class="state_UNKNOWN" > </div></td><td nowrap>'+unknown+'</td><td><b>'+data["unknownCount"]+'</b></td></tr><tr><td colspan="3"><div style="clear:both;width:100%;height:2px;margin:0px 0px 0px 0px;" class="slaSeparatorHorizontalLight">&nbsp;</div></td></tr>';
			marginTop=marginTop-10;
		}
		htmlString='<div style="float:left;width:90%;margin-top:'+marginTop+'px !important">'+htmlString+'</table></div>';
		return htmlString;
	}
});