Ext.define('SLAHome.view.SLAOverview', {
	extend : 'utilities.CommonPanel',
	requires : ['SLAHome.view.CurrentComplaince',
				'SLAHome.view.CurrentStatus',
				'SLAHome.view.Top10SLA',
				'SLAHome.view.Top10Components',
				'utilities.ScrollCombo',
				'SLAHome.view.SLAProblems'],
	alias : 'widget.slaoverview',
	cls : 'outerpanel',
	layout:{
		type:'vbox',
		align:'stretch'
	},
	url : null,
	mask:null,
	id:'slaoverviewpanel',
	initComponent : function(){
		this.loadSLAOverview();
		this.callParent();
	},
	loadSLAOverview:function(){
		var me = this;
		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				if ( !Ext.isEmpty(jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					var currentStatus = jsonData['currentStatus'];
					var inAndOutSlaListArray = jsonData['inAndOutCompliance1'];
					var top10SLAs = jsonData['top10SlaArray'];
					var componentView = jsonData['componentView'];
					//console.log("componentView???"+componentView);
					var overviewPanels =
					{
						xtype:'container',
						items:[
							{
								xtype:'container',
								layout: {
									type: 'hbox',
									align: 'stretch'
								},
								items: [
								{
									xtype: 'currentstatus',
									
									rootComponent : currentStatus
								},
								{
									xtype: 'currentcomplaince',
									rootComponent : inAndOutSlaListArray
								}]
							},
							{
								xtype:'tabpanel',
									id:'top10TabPanel',
									name:'top10TabPanel',
								layout: 'fit',
									
									padding: '0px 0px 0px 0px',
									style: {
										background: 'none'
									},
									plain: false,
									cls: 'tablayout',
									border: false,
									frame: false,
									activeTab:0,
									items: [{
										title: top10Title,
										autoScroll: true,
											
										//items: [{
											xtype: 'top10sla',
											tabinfo:top10SLAs
										//}]
									},{
										title: top10CompTitle,
										autoScroll:true,
											
										//items: [{
											xtype: 'top10components',
											tabinfo:componentView
										//}]
									}],
									listeners:{
										beforerender:function(){
											if( top10Activetab.indexOf("top10slapanel")>-1){
												Ext.getCmp('top10TabPanel').setActiveTab(0);
										
											}else if(top10Activetab.indexOf("top10componentspanel")>-1){
												Ext.getCmp('top10TabPanel').setActiveTab(1);
											}
											
										},
										render:function(){
											this.tabBar.add({xtype:'tbfill'},{
												xtype: 'scrollcombo',
												labelWidth:70,
												fieldLabel:filterBy,
												cls:'dropdown',
												margin:'3 20 0 0',
												labelStyle: 'white-space: nowrap;',
												name:'',
												hidden:true,
												labelAlign:'left',
												labelSeparator:''
											})
										},
										tabchange: function(panel, tab){
											top10Activetab = panel.getActiveTab().id;
											
											localStorage.setItem( 'top10Tab',top10Activetab );
										}
									
									}
							}
						]
					};
					me.removeAll();
					me.add(overviewPanels);
					me.doLayout();
				}
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
			},
			failure : function(){
				//alert("failure");
			}
		});
	}
});
