Ext.define('SLAHome.view.SLATree',{
	extend:'Ext.panel.Panel',
	alias:'widget.slatree',
	layout:'fit',
	requires:['SLAHome.view.SLADashboardSettings','utilities.ScrollableTreePanel'],
	//cls:'treePanelDesignWithoutHeader',
	id:'slatreepanel',
	cls:'outerpanel',
	margin:false,
	border:false,
	initComponent : function(){
		this.loadSLATree();
		this.callParent();
	},
	loadSLATree:function(){
		var me = this;
		var treePanelStore ="";
		//console.log("url>>>>>>>>"+me.url);
		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				if( !Ext.isEmpty(jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					//jsonData["expanded"] = true;
					//jsonData["cls"] = "list-tree-root-expand-collapse";
					//console.log("tree data:"+jsonText);
					var MyTree = {
					xtype:'scrollabletreepanel',
					title: treeTitle,
					cls:'treePanelDesign',
					height:450,
					useArrows:true,
					border:false,
					store: new Ext.data.TreeStore({
					root : jsonData
					}),
					rootVisible: false,
					tools:[{
							xtype:'toolbar',
							border:0,
							style:{
								border:'0px !important'
							},
							margin:0,
							padding:0,
							items:[{
								xtype:'button',
								iconCls:'iconService',
								border:0,
								margin:0,
								padding:0,
								tooltip:'<b>'+dashboardSettings+'</b>',
								style:{
									'background':'none', 'border':'0'
								},
								handler:function (){
									var win = Ext.widget('sladashboardsettings').show();
								}
							}]
						}]
					};
							
					//me.removeAll();
					
					me.add(MyTree);
					me.doLayout();
				}
			},
			failure : function(response, opts){
				//alert("Failure");
			}
		});
	}
});
