Ext.define('SLAHome.view.Top10Components', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.top10components',
	bodyPadding:'0',
	id: 'top10componentspanel',
	border: false,
	initComponent:function()
	{
		var me = this;
		
		if(me.tabinfo!=null)
		{
			
			if(me.tabinfo=="No measures available")
			{
				
				me.html = '<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconExclamation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>';
			}
			else
			{
				me.items = this.getGridData(me.tabinfo);
			}
		}
		this.doLayout();
		me.callParent();
	},
	getGridData : function(vals)
	{
		var store = new Ext.data.Store({
			storeId: 'employeeStore',
			fields: ['stat', 'view', 'sla', 'exp', 'cur','cont','data','meet','breach'],
			data: vals
		});
		var itemsPerPage = 2;
		store.load({
			params: {
				starts: 0,
				limit: itemsPerPage
			}
		});
		var grids =
		{
			xtype: 'gridpanel',
			id:'top10ComponentViewGrid',
			name: 'top10ComponentViewGrid',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'stat',
				header: 'Status',
				flex: 1,
				height:20,
				style:{'padding':'0 0 0 0','margin':'0'},
				renderer: function(val){
					var status = val['status'];
					var link = val['link'];
					return '<b style="width:20px;padding:10px 0px"><a href="'+link+'"><div style="position:absolute;" class="state_'+status+'"></div></a></b>';
				}
			}, {
				dataIndex: 'view',
				header: 'Component',
				flex: 2
			},{
				dataIndex: 'sla',
				header: 'SLA',
				flex: 2,
				renderer: function( val)
				{
					var link =val.link;
					var text = val.text;
					return '<a href="'+link+'">'+text+'</a>';
				}
			}, {
				dataIndex: 'exp',
				header: 'Compliance Goal',
				flex: 1.5
			}, {
				dataIndex: 'cur',
				header: 'SLA Achieved',
				flex: 1.5
			}, {
				dataIndex: 'cont',
				header: 'Contract Period',
				flex: 1.5
			}, {
				dataIndex: 'data',
				header: 'Last 24 Hours',
				flex: 2,
				renderer: function(val, obj, col, row){
					var data = val['xmlData'];
					var html = '';
					if ( data == '-' )
					{
						html = '-';
					}
					var chartData = vals;
					for ( var i = 0; i < chartData.length; i++ )
					{
						var getVal = chartData[row]['data']['xmlData'];
						if ( !Ext.isEmpty(getVal) && getVal!='-')
						{
							if ( FusionCharts('sparkchart1_'+row) )
							{
								FusionCharts('sparkchart1_'+row).dispose();
							}
							var chartPath = chartData[row]['data']['chartPath'];
							var myChart = new  FusionCharts(chartPath,'sparkchart1_'+row, "100%", "100%","0","1");
							myChart.setXMLData(getVal);
							myChart.setTransparent(true);
							Ext.defer(function(){myChart.render('fusionChart1'+row);},10);							
						}
					}
					return '<div id="fusionChart1'+row+'"  style="border:0px solid red;height:20px;">'+html+'</div>';
				}
			}, {
				dataIndex: 'meet',
				header: 'Can SLA Meet Success?',
				flex:1.5
			}, {
				dataIndex: 'breach',
				header: 'Earliest SLA breach time',
				flex: 2
			}],
			hideHeaders: false
		};
		return grids;
	}
});