Ext.define('SLAHome.view.Top10SLA', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.top10sla',
	bodyPadding:'0',
	layout:'fit',
	id: 'top10slapanel',
	border: false,
	initComponent:function(){
		var me = this;
		if(me.tabinfo!=null)
		{
			if(me.tabinfo==noMeasure)
			{
				me.html = '<div style="text-align:center""><div class="iconExclamation" ></div><div>'+me.tabinfo+'</div></div>';
			}
			else
			{
				me.items = this.getGridData(me.tabinfo);
			}
		}
		me.callParent();
	},
	getGridData : function(vals)
	{
		var store = new Ext.data.Store({
			storeId: 'employeeStore',
			fields: ['stat', 'sla', 'exp', 'cur', 'cont','last','meet','breach'],
			data: vals
		});
		var itemsPerPage = 2;
		store.load({
			params: {
				starts: 0,
				limit: itemsPerPage
			}
		});
		var grids =
		{
			xtype: 'gridpanel',
			id:'top10SlaGrid',
			name: 'top10SlaGrid',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			
			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'stat',
				header: statuslbl,
				flex: 1,
				height:20,
				style:{'padding':'0 0 0 0','margin':'0'},
				renderer: function(val){
					var status = val['status'];
					var link = val['link'];
					return '<b style="width:20px;padding:10px 0px"><a href="'+link+'"><div style="position:absolute;" class="state_'+status+'"></div></a></b>';
				}
			}, {
				dataIndex: 'sla',
				header: slaColHeader,
				flex: 2,
					
				renderer: function( val)
				{
					var link =val.link;
					var text = val.text;
					return '<a href="'+link+'">'+text+'</a>';
				}
			}, {
				dataIndex: 'exp',
				header: expectedCompliance,
				flex: 1.5
			}, {
				dataIndex: 'cur',
				header: 'SLA Achieved',
				flex: 1.5
			}, {
				dataIndex: 'cont',
				header: contractPeriod,
				flex: 1.5
			}, {
				dataIndex: 'last',
				header: last24Hours,
				flex: 2,
				renderer: function(val, obj, col, row){
					var data = val['xmlData'];
					var html = '';
					if ( data == '-' )
					{
						html = '-';
					}
					var chartData = vals;	
					var getVal = chartData[row]['last']['xmlData'];
					if ( !Ext.isEmpty(getVal) && getVal!='-')
					{
						if ( FusionCharts('sparkchart_'+row) )
						{
							FusionCharts('sparkchart_'+row).dispose();
						}
						var chartPath = chartData[row]['last']['chartPath'];
						var myChart = new  FusionCharts(chartPath,'sparkchart_'+row, "100%", "100%","0","1");
						myChart.setXMLData(getVal);
						myChart.setTransparent(true);
						Ext.defer(function(){myChart.render('fusionChart'+row);},10);						
					}					
					return '<div id="fusionChart'+row+'"  style="border:0px solid red;height:20px">'+html+'</div>';
				}
			}, {
				dataIndex: 'meet',
				header: SLAMeetSuccesslbl,
				flex:1.5
			}, {
				dataIndex: 'breach',
				header: SLABreachTime,
				flex: 2
			}],
			hideHeaders: false
		};
		return grids;
	}
});