
Ext.define('SLANotification.controller.Main', {
	extend: 'Ext.app.Controller',
	views:['Main','OutCompliance','NearingCompliance','SLAProblems'],
	requires:['SLANotification.view.Main',
		'SLANotification.view.OutCompliance',
		'SLANotification.view.NearingCompliance',
		'SLANotification.view.SLAProblems'
	],
	
	refs:[
	{selector:'main', ref:'main'},
	{
		ref:'slaproblems',
		selector:'slaproblems'
	},
	{
		ref:'outCompliance',
		selector:'outCompliance'
	},
	{
		ref:'nearingCompliance',
		selector:'nearingCompliance'
	}],
	refreshFlag:false,
	init: function() {
		this.control({
		'main':{
				'afterrender':this.getSlaProblem
			}
		});
	},
		
	getSlaProblem: function(){
		var me =this;
		var probUrl = "/final/SLA/eGSLAProblems.jsp";
		Ext.Ajax.request({
			url :probUrl,
			method : 'POST',
				success : function(response, opts){
				var slaProbPanelObj = Ext.getCmp('slaProblems');
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText)
				var outComplianceArray = jsonData['outCompliance'];
				var nearingComplianceArray = jsonData['nearingCompliance'];
				var nearingCompliancePanel = '';
				var outComliancePanel = '';
				//console.log(">>>>>>>>"+compHeight+"?????????");
				if ( !Ext.isEmpty(outComplianceArray))
				{
					var store = Ext.create('Ext.data.Store', {
						storeId: 'employeeStore',
						fields: ['slaName', 'expected', 'achieved', 'probTime'],
						data:outComplianceArray
					 });
					var gridData = me.getGridDataFrSLAOutCom(store);
					outComliancePanel = Ext.create('SLANotification.view.OutCompliance',{
						xtype:'panel',
						alias: 'widget.outcompliance',
						bodyPadding:'10',
						layout:'fit',
						id: 'outcompliance',
						margin:10,
						cls:'block1',
						height: compHeight,
					
						title:'Out Compliance SLAs',
						border: false,
						items:[gridData]
					
					});
				}
				else
				{
					outComliancePanel = Ext.create('SLANotification.view.OutCompliance',{
						xtype:'panel',
						alias: 'widget.outcompliance',
						bodyPadding:'10',
						layout:'fit',
						id: 'outcompliance',
						margin:10,
						cls:'block1',
						height: compHeight,
						
						title:'Out Compliance SLAs',
						border: false,
						html: '<center><p><div class="iconExclamation"></div>No SLA Available!</p></center>'
					});
				}
				if ( !Ext.isEmpty(nearingComplianceArray))
				{
					var store = Ext.create('Ext.data.Store', {
						storeId: 'employeeStore',
						fields: ['status','slaName', 'expected', 'achieved', 'notAchived'],
						data:nearingComplianceArray
					 });
					var gridData = me.getGridDataFrSLAnearingCom(store);
					nearingCompliancePanel = Ext.create('SLANotification.view.NearingCompliance',{
						xtype:'panel',
						alias: 'widget.nearingcompliance',
						bodyPadding:'10',
						layout:'fit',
						id: 'nearingcompliance',
						margin:10,
						cls:'block1',
						height: compHeight,
						
						title:'SLAs Nearing Compliance',
						border: false,
						items:[gridData]
					
					});
				}
				else
				{
					nearingCompliancePanel = Ext.create('SLANotification.view.NearingCompliance',{
						xtype:'panel',
						alias: 'widget.nearingcompliance',
						bodyPadding:'10',
						layout:'fit',
						id: 'nearingcompliance',
						margin:10,
						cls:'block1',
						height: compHeight,
						
						title:'SLAs Nearing Compliance',
						border: false,
						html:'<center><p><div class="iconExclamation"></div>No SLA Available!</p></center>'
					});
				}
				slaProbPanelObj.removeAll();
				slaProbPanelObj.add(outComliancePanel);
				slaProbPanelObj.add(nearingCompliancePanel);
				slaProbPanelObj.show();
		},
			failure: function(){
				//alert("failure");
			}
		});
	},
	getGridDataFrSLAOutCom:function (store)
	{
		var gridsData = Ext.create('Ext.grid.Panel', {
			id: 'gri2',
			name: 'gri',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			width: '100%',

			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'slaName',
				header: 'SLA Name',
				flex: 2,
			}, {
				dataIndex: 'expected',
				header: 'Expected',
				flex: 2
			}, {
				dataIndex: 'achieved',
				header: 'Achieved',
				flex: 1
			}, {
				dataIndex: 'probTime',
				header: problemTime,
				flex: 1
			}],
			hideHeaders: false
		});
		return gridsData;
	},
	getGridDataFrSLAnearingCom:function (store)
	{
		var gridsData = Ext.create('Ext.grid.Panel', {
			id: 'gri2',
			name: 'gri',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			width: '100%',

			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'status',
				header: statusLbl,
				flex: 2,
				renderer: function(val){
					return '<b style="position:relative;width:20px;padding:10px 0px"><div style="position:absolute;top:-3px" class="state_'+val+'"></div></b>';
				}
			}, {
				dataIndex: 'slaName',
				header: SLAName,
				flex: 2,
			},{
				dataIndex: 'expected',
				header: expectedLbl,
				flex: 2
			}, {
				dataIndex: 'achieved',
				header: achieveLbl,
				flex: 1
			}, {
				dataIndex: 'notAchived',
				header: 'Not Achieved',
				flex: 1
			}],
			hideHeaders: false
		});
		return gridsData;
	},
	
	
});
