var allSummaryGrpId = new Array();
Ext.define('SLAView.controller.Main', {
	extend: 'Ext.app.Controller',
	requires:['SLAView.view.FullView','SLAView.view.SLATree'],
	views:['SLAView.view.Main',
		'SLAView.view.SLATree',
		'SLAView.view.SLAViewTab',
		'SLAView.view.SLASummary',
		'SLAView.view.MeasureGraph'],
	refs:[{
		ref:'treePanel',
		selector:'slatree treepanel'
	},{
		ref:'slaviewtab',
		selector:'slaviewtab'
	},{
		ref:'slasummary',
		selector:'slasummary'
	},{
		ref:'historyview',
		selector:'historyview'
	},{
		ref:'sladashboardsettings',
		selector:'sladashboardsettings'
	},{
		ref:'treePanel',
		selector:'slatree treepanel'
	},{
		ref:'slaproblems',
		selector:'slaproblems'
	},{
		ref:'slatree',
		selector:'slatree'
	},
	{
		ref:'fullview',
		selector:'fullview'
	},
	{
		ref:'measuregraph',
		selector:'measuregraph' 
	}],
	refreshFlag:false,
	init: function() {
		var me=this;
		setInterval("execute()",refreshFreq);
		//this.setViewTab();
		this.control({
			'slatree treepanel':{
				afterrender : function(){
					var selectednode_Id  = requestParams.selectedTreeId;
					if(selectednode_Id!=='null' && selectednode_Id!==null)
					{
						var treePanel=this.getTreePanel();
						var record = treePanel.getStore().getNodeById(selectednode_Id);
						treePanel.getSelectionModel().select(record);

						var selectedNodeDepth=record.getDepth();
						var selected=record;

						for(var i=0; i < selectedNodeDepth; i++){
							if(selected.isLeaf()){
								selected.parentNode.expand();
							}
							else{
								selected.expand();
							}
							selected=selected.parentNode;
						}
						
					}
				},
				itemclick:{
					fn:function(view, record, item, index, event)
					{
						var treePanel=this.getTreePanel();
						nodeId = record.data.text;
						var node_id = record.data.id;
						this.getTreePanel().expandNode(record);
						var myLink=record.raw.link;
						console.log(">>>>>slaview mylink"+myLink);
						if ( !Ext.isEmpty(myLink) && myLink != 'undefined' )
						{
							localStorage.setItem( 'detailsTab',"ruledetailspanel" );
							document.location=myLink+"&currentTab=details&selectedId="+node_id+"&treeOpen=true";
							
						}
						
					}
				}
			},
			
			'slasummary':{
			
				'afterrender':this.getSlaSummaryData
			},
			/*'historyview  scrollcombo[id="historyTimeLine"]':{
			
				'afterrender':this.loadTimeLineCombo
			},*/
			
			'historyview scrollcombo[id="historyTimeLine"]':
			{
				'select': this.changeSummaryGraph
			},
			'sladashboardsettings':{
				'afterrender':this.slaDashboardSetting
			},
			'sladashboardsettings button[id="settingsupdateButton"]':
			{
				'click': this.updateSettings
			},
			'historyview button[id="showAllGraphId"]':
			{
				'click': this.getLoadAllSummaryGraph
			},
			'historyview button[id="showAllServersId"]':
			{
				'click': this.loadAllServersSummaryGraph
			},
			'slaviewtab button[id="slaProblemId"]':
			{
				'click': this.getSlaProblem
			},
			'slaviewtab':
			{
				'boxready': this.loadTabUI
			},
			
			'fullview':
			{
				'boxready': this.loadFullViewPanel
			}
		});
	},
	loadTabUI : function(){
				//console.log("requestParams.currentTab????"+requestParams.currentTab);
				var lastTab = Ext.getCmp('slaviewtab').getActiveTab();
				//console.log("lastTab--->  "+lastTab);
			if(requestParams.currentTab.indexOf('details') > -1  ){
				Ext.getCmp('slaviewtab').setActiveTab(0);
				var detailsPanelObj = Ext.getCmp('DetailsPanel');
				detailsPanelObj.getDetailsView();
				
			}
			else if(requestParams.currentTab.indexOf('history') > -1  ){
				Ext.getCmp('slaviewtab').setActiveTab(1);
				var historyObj = Ext.getCmp('HistoryPanel');
				historyObj.loadSummaryGraph();
				
			}
			else if(requestParams.currentTab.indexOf('configuration') > -1  ){
				Ext.getCmp('slaviewtab').setActiveTab(2);
				var configurationPanelObj = Ext.getCmp('configurationPanel');
				configurationPanelObj.loadConfigurationDetails();
				
			}
	},
	refreshData : function(){
		
		var slaTreeObj = Ext.getCmp('slaTreeID');
		slaTreeObj.loadSLATree();
		
		if ( slaViewActiveTab.indexOf('detailspanel') > -1 ){
			Ext.getCmp('slaviewtab').setActiveTab(0);
			var detailsPanelObj = Ext.getCmp('DetailsPanel');
			detailsPanelObj.getDetailsView();
		}
		if ( slaViewActiveTab.indexOf('historypanel') > -1  ){
			var graphPanel = Ext.getCmp('measureGraphPanel');
			graphPanel.removeAll();
			var timlineComboObj = Ext.getCmp('historyTimeLine');
			this.changeSummaryGraph(timlineComboObj);
		}
		else if ( slaViewActiveTab.indexOf('configurationpanel') > -1 ){
			var configurationPanelObj = Ext.getCmp('configurationPanel');
			configurationPanelObj.loadConfigurationDetails();
		}
	},
	
	/*validateSettings :  function()
	{
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
	},*/
	
	getSlaSummaryData : function(){
		var me = this;
		var summaryDataPanelObj = Ext.getCmp('slaSummaryId');
		var hourDataUrl = summaryDataPanelObj.url;
		//console.log("hourDataUrl"+hourDataUrl);
		Ext.Ajax.request({
			url : hourDataUrl,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var tableData = jsonData['hourlydata']['hourlyDataArry'];
				var store = Ext.create('Ext.data.Store', {
					storeId: 'employeeStore',
					fields: ['startDate', 'endDate', 'achieved', 'expected'],
					data:tableData
				 });
				var gridData = me.getGridDataForSummary(store);
				summaryDataPanelObj.removeAll();
				summaryDataPanelObj.add({
					xtype:'panel',
					bodyPadding:'0',
					scroll:true,
					autoScroll:true,
					layout:'fit',
					id: '',
					border: false,
					items: [gridData]
				}); 
			},
			failure : function(){
				//alert("failure");
			}
		});
	},
	getGridDataForSummary:function (store)
	{
		//var gridsData = Ext.create('Ext.grid.Panel', {
		var gridsData = Ext.create('utilities.CustomGrid', {
			id: 'gri2',
			name: 'gri',
			cls: 'gridSkin',
			border: false,
			width: '100%',
			height:460,
			store: store,
			columns: [{
				dataIndex: 'startDate',
				header: 'Start Time',
				flex: 2,
			}, {
				dataIndex: 'endDate',
				header: 'End Time',
				flex: 2
			}, {
				dataIndex: 'achieved',
				header: 'Achieved',
				flex: 1
			}, {
				dataIndex: 'expected',
				header: 'Expected',
				flex: 1
			}],
			hideHeaders: false
		});
		return gridsData;
	},
	/*loadTimeLineCombo:function(){	
		console.log("conmin"+publicJSON);
		var comboList = publicJSON['timeLineList'];
		console.log("ggggg-------"+comboList);
		var selectedPeriod = publicJSON['dispPeriod'];
		//console.log("hello..");
		var timlineComboObj = Ext.getCmp('historyTimeLine');
					
		if ( !Ext.isEmpty(comboList))
		{
			this.setValueForCombo(timlineComboObj,comboList,selectedPeriod);
		}
		var startDateObj =  Ext.getCmp("er_stdate");
		var endDateObj =  Ext.getCmp("er_enddate");
		var stHrObj =  Ext.getCmp("er_sthr");
		var endHrObj =  Ext.getCmp("er_endhr");

		if(startDateObj!=null && startDateObj!="undefined")
		{
			var startDateAsJson = publicJSON['startDateAsJson'];
			//alert("startDateAsJson"+startDateAsJson);
			startDateObj.setValue(startDateAsJson);
			
		}
		if(endDateObj!=null && endDateObj!="undefined")
		{
			var endDateAsJson = publicJSON['endDateAsJson'];
			endDateObj.setValue(endDateAsJson);
		}

		if(stHrObj!=null && stHrObj!="undefined")
		{
			var startHrAsJson = publicJSON['startHrAsJson'];
			stHrObj.setValue(startHrAsJson);
		}

		if(endHrObj!=null && endHrObj!="undefined")
		{
			var endHrAsJson = publicJSON['endHrAsJson'];
			endHrObj.setValue(endHrAsJson);
		}
	},*/
	setValueForCombo: function(comboObj,list,selectedPeriod){
		//alert("setting combo"+selectedPeriod);
		comboObj.getStore().loadRawData(list);
		if ( selectedPeriod != null &&  selectedPeriod != "")
		{
			comboObj.setValue(selectedPeriod);
		}
		else
		{			
			comboObj.setValue(list[0]['valuefield']);
		}
	},
	changeSummaryGraphForAny : function()
	{	
		var chartUrl =  publicJSON['charturl'];
		
		var selectedPeriod = Ext.getCmp("historyTimeLine").getValue();	
		
		var stDate = Ext.getCmp('er_stdate').getValue();
		var startDateVal = stDate;
		var enDate = Ext.getCmp('er_enddate').getValue();
		var endDateVal = enDate;
		var s_sthr = Ext.getCmp('er_sthr').getValue();
		var s_endhr= Ext.getCmp('er_endhr').getValue();
		//stDate.setHours(sthr);
		//enDate.setHours(s_endhr);
		//stDate.setMinutes(00);
		//enDate.setMinutes(00);
	
		/*if(!checkDateTime(stDate,enDate))
		{
			return;
		}*/
		var startdate = Ext.Date.dateFormat(startDateVal, 'm/d/Y');
		var enddate = Ext.Date.dateFormat(endDateVal, 'm/d/Y');
		
		if(startdate==""|| startdate==null){
		startdate=startDateVal;
		
		}
		if(enddate==""|| enddate==null){
		enddate=endDateVal;
		}
		chartUrl = chartUrl+'&displayPeriod='+encodeURIComponent(selectedPeriod+"#"+startdate+" "+s_sthr+":00#"+enddate+" "+s_endhr+":00");
		var singlechartid = Ext.getCmp('singleSummaryChartId');
		//if (singlechartid.isHidden()){
		if(isAllSummaryClicked){
			Ext.getCmp('showAllGraphId').mode = 'all';
			var ruleAndServerViewUrl =  publicJSON['ruleAndServerViewUrl'];
			ruleAndServerViewUrl = ruleAndServerViewUrl+'&displayPeriod='+encodeURIComponent(selectedPeriod+"#"+startdate+" "+s_sthr+":00#"+enddate+" "+s_endhr+":00");
			//console.log("ruleAndServerViewUrl>>yesssssssssss"+ruleAndServerViewUrl);
			this.getLoadAllSummaryGraph(ruleAndServerViewUrl);
		}
		else{
			Ext.getCmp('showAllGraphId').mode = 'single';
			this.summaryChartLoad(chartUrl);
			//console.log("chartUrl>>"+chartUrl);
		}
	},
	changeSummaryGraph: function(combo){
		
		var chartUrl =  publicJSON['charturl'];
		var selectedPeriod = combo.getValue();
		chartUrl = chartUrl+'&displayPeriod='+selectedPeriod;
	
		var singlechartid = Ext.getCmp('singleSummaryChartId');				
		if(selectedPeriod=="Any")
		{
			Ext.getCmp('settingsBtn').show();
			//var timelineDivObj = Ext.getCmp('timelineDivObj');
			//timelineDivObj.show();
			
			this.setTimelineDefaultData();
			
		}
		else
		{
			Ext.getCmp('settingsBtn').hide();
		}
			//if (singlechartid.isHidden()){
			if(isAllSummaryClicked){
			//console.log("right method");
				Ext.getCmp('showAllGraphId').mode = 'all';
				var ruleAndServerViewUrl =  publicJSON['ruleAndServerViewUrl'];
				ruleAndServerViewUrl = ruleAndServerViewUrl+'&displayPeriod='+selectedPeriod;
				//console.log("diffrent method"+ruleAndServerViewUrl);
				this.getLoadAllSummaryGraph(ruleAndServerViewUrl);
			}
			else{
			
				Ext.getCmp('showAllGraphId').mode = 'single';
				this.summaryChartLoad(chartUrl);
			}
				
	},
	setTimelineDefaultData:function(){
	
		var timelineDivObj = Ext.getCmp('timelineDivObj');
		timelineDivObj.show();
		var stDate = Ext.getCmp('er_stdate').getValue();
		
		var enDate = Ext.getCmp('er_enddate').getValue();
		
		var s_sthr = Ext.getCmp('er_sthr').getValue();
		var s_endhr= Ext.getCmp('er_endhr').getValue();
		
		if( stDate==null || stDate==" " ){
		var dateVal=publicJSON['timelineStartDate'];
		
		Ext.getCmp("er_stdate").setRawValue(dateVal);
		}
		
		if( s_sthr==null || s_sthr==" " ){
		var dateVal=publicJSON['timelineStHr'];
		//alert(dateVal);
		//console.log("dateVal>>st"+dateVal);
		Ext.getCmp("er_sthr").setRawValue(dateVal);
		}
		
		if( enDate==null || enDate==" " ){
		var dateVal=publicJSON['timelineEndDate'];
		
		Ext.getCmp("er_enddate").setRawValue(dateVal);
		}
		
		if( s_endhr==null || s_endhr==" " ){
		var dateVal=publicJSON['timelineEdHr'];
		//console.log("dateVal>>en"+dateVal);
		Ext.getCmp("er_endhr").setRawValue(dateVal);
		}
		timelineDivObj.show();
	},
	summaryChartLoad: function(url){	
		//console.log("yes");
		Ext.getCmp('showAllGraphId').mode = 'all';
		var historyObj = Ext.getCmp('measureGraphPanel');
		var id='';
		if(historyObj==null || historyObj==undefined)
		{
			Ext.getCmp('HistoryPanel').add({
				xtype:'container',
				id:'measureGraphPanel',
				border: true,
				frame:true,
				padding:false,
				margin:'10',
				height:600,
				width:800,
			});
			historyObj = Ext.getCmp('measureGraphPanel');
			id= historyObj.id;
		}
		else
		{
			id= historyObj.id;
		}
		//console.log("historyObj",historyObj);
		var me = this;
		//console.log("hhhhhhh"+url);
		Ext.Ajax.request({
			url :url,
			method : 'GET',
			success : function(response, opts){
				var jsonText = response.responseText;
				//console.log("jsonText single",jsonText);
				var jsonData = Ext.decode(jsonText);
				var getVal = jsonData['xmlData'];
				//var headerTitle = me.returnHeaderData(jsonData);
				var headerTitle = jsonData['dispTitle']+jsonData['name']+"-"+jsonData['dispPeriod'];
				Ext.getCmp('HistoryPanel').setTitle(headerTitle);	
				//Ext.get('summaryContentId').update(headerTitle);
				if ( !Ext.isEmpty(getVal))
				{					
					if(fusionChartsApiEnabled)
					{
						var chartPath = '/final/FusionCharts/swf/StackedColumn3D.swf';
						var myChart = new  FusionCharts(chartPath,'StackedColumn3DChart', "650px", "350px","0","1");
						myChart.setXMLData(getVal);
						myChart.setTransparent(true);
						myChart.render('StackedColumn3D');
					}
					else
					{
						try
						{							
							var barChart = {};
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance(id, 400, 900), barChart);
							barChart.setData(getVal, currentDateFormat,'','stackedColumn');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
					}
				}
				else
				{
				/*var errPanel=Ext.getCmp(id);
				errPanel.update({
					xtype : 'panel',
					html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">' + noMeasure
							+ '!</div></div></div>'
					
				});*/
				
					Ext.getCmp(id).update('<table width="100%" height="250px"><tr><td valign="middle" align="center"><div class="iconExclamation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
				}
			},
			failure: function(){
				//alert("failure");
			}
		});
	},
	returnHeaderData : function(vals){
		
		var htmlString = '<center><br/><b>Current compliance is  '+vals['currentCompliance']+' , the goal is '+vals['expectedCompliance']+'</br>'+vals['dispTitle']+' '+vals['name']+' - '+vals['dispPeriod']+'<br/><br/>';
		return htmlString;
	},
	slaDashboardSetting: function(){
		var me = this;
		var url = '/final/SLA/scripts/SLAHome/data/eGSLASettings.jsp';
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var listForSlaView = jsonData['slabaseviewList'];
				var listForIgnoreVal = jsonData['yesornoComboList'];
				var selectedForSlaView = jsonData['slabasecViewSelected'];
				var selectedForIgnoreVal = jsonData['ignorevalueSelected'];
				var selectedForIgnoreUnkn = jsonData['ignoreunknownSelected'];
				var refreshFreq = jsonData['refreshFrequency'];

				var refFreqTextField = Ext.getCmp('refreshFreq');
				refFreqTextField.setValue(refreshFreq);

				var slaviewCombo = Ext.getCmp('slaViewBasedCombo');
				me.setValueForCombo(slaviewCombo,listForSlaView,selectedForSlaView);

				var ingnoreValueCombo = Ext.getCmp('ignoreValueCombo');
				me.setValueForCombo(ingnoreValueCombo,listForIgnoreVal,selectedForIgnoreVal);

				var ignoreUnknown = Ext.getCmp('ignoreUnknownCombo');
				me.setValueForCombo(ignoreUnknown,listForIgnoreVal,selectedForIgnoreUnkn);
				
			},
			failure : function(){
				//alert("failure");
			}
		});
		var dashboardsettingpanel = Ext.getCmp('sladashboardsettings');
	},
	updateSettings:function()
	{
		var me = this;
		var url = '/final/SLA/eGSLASettingsp.jsp?';

		var dashboardObj = Ext.getCmp('sladashboardsettings');
		var slaviewCombo = Ext.getCmp('slaViewBasedCombo').getValue();
		var refFreqTextField = Ext.getCmp('refreshFreq').getValue();
		var ingnoreValueCombo = Ext.getCmp('ignoreValueCombo').getValue();
		var ignoreUnknown = Ext.getCmp('ignoreUnknownCombo').getValue();
		url+= '&viewMode='+slaviewCombo+'&refreshFrequency='+refFreqTextField+'&ignoreNAValues='+ingnoreValueCombo+'&ignoreUnknownValues='+ignoreUnknown+'&cacheCurrent='+(new Date().getTime());
		//dashboardObj.hide();
		window.location.href = url;
	},
	showAllGraph:function(){
		var allchartid = Ext.getCmp('allSummaryChartId');
		var singlechartid = Ext.getCmp('singleSummaryChartId');
		if (singlechartid.isHidden())
		{
			singlechartid.show();
			allchartid.hide();
		}
		else{
			singlechartid.hide();
			allchartid.show();
		}
	},
	getLoadAllSummaryGraph:function(url)
	{	
		var me = this;
	//console.log("}}}}}}}}}"+url);
		//console.log("this is right");
		var mode = Ext.getCmp('showAllGraphId').mode;		
		
		var selectedPeriod = Ext.getCmp('historyTimeLine').getValue();
		if(selectedPeriod=="Any")
		{
			
			Ext.getCmp('settingsBtn').show();
			var timelineDivObj = Ext.getCmp('timelineDivObj');
			
			this.setTimelineDefaultData();
			timelineDivObj.show();
		}
		else
		{
			Ext.getCmp('settingsBtn').hide();
		}
		var ruleAndServerViewUrl=url;
		
		if(mode=='all')
		{		
			isAllSummaryClicked = true;
			
			//console.log("url show all btn",url);
			if(url instanceof Object)
			{
			ruleAndServerViewUrl =  publicJSON['ruleAndServerViewUrl'];
			
			ruleAndServerViewUrl = ruleAndServerViewUrl+'&displayPeriod='+selectedPeriod;
			}
			//alert("ruleAndServerViewUrl???"+ruleAndServerViewUrl);			
			Ext.Ajax.request({
				url :ruleAndServerViewUrl,
				method : 'POST',
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					console.log(" to all mea"+jsonText);
					var headerTitle = jsonData['dispTitle']+jsonData['name']+"-"+jsonData['dispPeriod'];
					Ext.getCmp('HistoryPanel').setTitle(headerTitle);
					me.loadMeasureGraph(jsonData);
				},
				failure: function()
				{
				}
			});
		}
		else
		{
			isAllSummaryClicked = false;	
			var chartUrl = publicJSON['charturl'];				
			chartUrl = chartUrl+'&displayPeriod='+selectedPeriod;
			this.summaryChartLoad(chartUrl);
		}
	},
	loadMeasureGraph:function(jsonData)
	{
		
		Ext.getCmp('showAllGraphId').mode = 'single';
		var MeasureGraphObj = Ext.create('SLAView.view.MeasureGraph');
		var chartArray = jsonData['chartArray'];		
		var chartArrayPanel = new Array();
				//var headerTitle = me.returnHeaderData(jsonData);
				//Ext.get('allSummaryContentId').update(headerTitle);
			if ( !Ext.isEmpty(chartArray))
			{					
				var chartPath = '/final/FusionCharts/swf/StackedColumn3D.swf';
				for ( var k = 0 ; k < chartArray.length ; k++)
				{
					allSummaryGrpId.push('showAllMeasureGraph_'+k);
					chartArrayPanel.push({
						xtype:'container',
						margin:'10 0 20 0',
						highGChartId : 'showAllMeasureGraph_'+k,
						xmlData:chartArray[k]['xmlData'],	
						chartCnt : k,
						id:'showAllGrpCnt_'+k,
						html:'<div style="text-align:center;font-size:12px"><b>'+chartArray[k]['title']+'</b></div><div id="showAllMeasureGraph_'+k+'" ></div>',
						height:390,
						width:900,
						listeners:
						{
							afterrender: function(obj)
							{
								var getVals = this.xmlData;								
								if ( !Ext.isEmpty(getVals))
								{
									if(fusionChartsApiEnabled)
									{
										var myChart = new  FusionCharts(chartPath,'StackedColumn3DChart_'+k, "300px", "150px","0","1");
										myChart.setXMLData(getVals);
										myChart.setTransparent(true);
										myChart.render('summarychartID_'+k);
									}
									else
									{
										try
										{
											var barChart = {};
											barChart = jQuery.extend(true, {}, getHighChartsBarInstance('showAllMeasureGraph_'+this.chartCnt, 380, 900), barChart);
											barChart.setData(getVals, currentDateFormat,'','stackedColumn');
											barChart.drawChart();
										}
										catch (barChartEx)
										{
											console.log(barChartEx);
										}
									}
								}
								else
								{
									Ext.get('showAllMeasureGraph_'+this.chartCnt).update('<table width="100%" height="300px"><tr><td valign="middle" align="center"><div class="iconExclamation"></div><div>No Measure available</div></td></tr></table>');
								}
							}
						}
					});
				}
			}			
			//Ext.widget('msrpanel',{items:chartArrayPanel});
			Ext.getCmp('HistoryPanel').remove('measureGraphPanel');
			Ext.getCmp('HistoryPanel').remove('measureGraphId');
			Ext.getCmp('HistoryPanel').add(MeasureGraphObj);
			MeasureGraphObj.add(chartArrayPanel);
			MeasureGraphObj.doLayout();
	},
	getSlaProblem: function(){
		var me =this;
		var probUrl = "/final/SLA/eGSLAProblems.jsp";
		Ext.Ajax.request({
			url :probUrl,
			method : 'POST',
			success : function(response, opts){
				var slaProbPanelObj = Ext.getCmp('slaProblems');
				var jsonText = response.responseText;
				console.log(jsonText);
				var jsonData = Ext.decode(jsonText)
				var outComplianceArray = jsonData['outCompliance'];
				var nearingComplianceArray = jsonData['nearingCompliance'];
				var nearingCompliancePanel = '';
				var outComliancePanel = '';
					var itemsArray = new Array();
				if ( !Ext.isEmpty(outComplianceArray))
				{
					var store = Ext.create('Ext.data.Store', {
						storeId: 'employeeStore',
						fields: ['slaName', 'expected', 'achieved', 'probTime'],
						data:outComplianceArray
					 });
					var gridData = me.getGridDataFrSLAOutCom(store);
					outComliancePanel = {
						xtype:'panel',
						//alias: 'widget.outcompliance',
						bodyPadding:'10',
						layout:'fit',
						
						margin:10,
						cls:'block1',
						title:'Out Compliance SLAs',
						border: false,
						items:[gridData]
					
					};
				}
				else
				{
					outComliancePanel = {
						xtype:'panel',
						//alias: 'widget.outcompliance',
						bodyPadding:'10',
						layout:'fit',
						
						margin:10,
						cls:'block1',
						title:'Out Compliance SLAs',
						border: false,
						html: '<center><p><div class="iconExclamation"></div>No SLA Available!</p></center>'
					};
				}
				if ( !Ext.isEmpty(nearingComplianceArray))
				{
					var store = Ext.create('Ext.data.Store', {
						storeId: 'employeeStore',
						fields: ['status','slaName', 'expected', 'achieved', 'notAchived'],
						data:nearingComplianceArray
					 });
					var gridData = me.getGridDataFrSLAnearingCom(store);
					nearingCompliancePanel = {
						xtype:'panel',
						//alias: 'widget.nearingcompliance',
						bodyPadding:'10',
						layout:'fit',
						
						margin:10,
						cls:'block1',
						title:'SLAs Nearing Compliance',
						border: false,
						items:[gridData]
					
					};
				}
				else
				{
					nearingCompliancePanel = {
						xtype:'panel',
						//alias: 'widget.nearingcompliance',
						bodyPadding:'10',
						layout:'fit',
						
						margin:10,
						cls:'block1',
						title:'SLAs Nearing Compliance',
						border: false,
						html:'<center><p><div class="iconExclamation"></div>No SLA Available!</p></center>'
					};
				}
				
				itemsArray.push(nearingCompliancePanel);
				itemsArray.push(outComliancePanel);
				slaProbPanelObj.removeAll();
				slaProbPanelObj.add({
					
					xtype:'container',
					
					items: itemsArray
				
				});
				//slaProbPanelObj.items = {outComliancePanel,nearingCompliancePanel};
				//slaProbPanelObj.removeAll();
				//slaProbPanelObj.add(itemsArray);
				//slaProbPanelObj.add(nearingCompliancePanel);
				/*var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var outComplianceArray = jsonData['outCompliance'];
				var nearingComplianceArray = jsonData['nearingCompliance'];
				if ( !Ext.isEmpty(outComplianceArray))
				{
					var outcomplPanel = Ext.getCmp('outcompliance');
					var store = Ext.create('Ext.data.Store', {
						storeId: 'employeeStore',
						fields: ['slaName', 'expected', 'achieved', 'probTime'],
						data:outComplianceArray
					 });
					var gridData = me.getGridDataFrSLAOutCom(store);
					outcomplPanel.removeAll();
					outcomplPanel.add({
						xtype:'panel',
						bodyPadding:'0',
						layout:'fit',
						id: '',
						border: false,
						items: [gridData]
					});
				}
				else
				{
					var outcomplPanel = Ext.getCmp('outcompliance');
				}
				if ( !Ext.isEmpty(nearingComplianceArray))
				{
					var nearinglPanel = Ext.getCmp('nearingcompliance');
				}
				else
				{
					var nearinglPanel = Ext.getCmp('nearingcompliance');
					nearinglPanel.removeAll();
					nearinglPanel.add({
						xtype:'panel',
						bodyPadding:'0',
						layout:'fit',
						id: '',
						border: false,
						html: '<center><p><div class="iconExclamation"></div>No SLA Available</p></center>'
					});
				}*/
			},
			failure: function(){
				//alert("failure");
			}
		});
	},
	getGridDataFrSLAnearingCom:function (store)
	{
		var gridsData = Ext.create('Ext.grid.Panel', {
			id: 'gri2',
			name: 'gri',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			width: '100%',

			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'status',
				header: 'Status',
				flex: 1,
				renderer: function(val){
					return '<b style="position:relative;width:20px;padding:10px 0px"><div style="position:absolute;top:-3px" class="state_'+val+'"></div></b>';
				}
			}, {
				dataIndex: 'slaName',
				header: 'SLA Name',
				flex: 2,
			}, {
				dataIndex: 'expected',
				header: 'Expected',
				flex: 1
			}, {
				dataIndex: 'achieved',
				header: 'Achieved',
				flex: 1
			}, {
				dataIndex: 'notAchived',
				header: 'Not Achieved',
				flex: 1
			}],
			hideHeaders: false
		});
		return gridsData;
	},
		getGridDataFrSLAOutCom:function (store)
	{
		var gridsData = Ext.create('Ext.grid.Panel', {
			id: 'gri3',
			name: 'gri',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			width: '100%',

			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'slaName',
				header: 'SLA Name',
				flex: 2,
			},{
				dataIndex: 'expected',
				header: 'Expected',
				flex: 1
			}, {
				dataIndex: 'achieved',
				header: 'Achieved',
				flex: 1
			}, {
				dataIndex: 'probTime',
				header: 'Violation Time',
				flex: 2
			}],
			hideHeaders: false
		});
		return gridsData;
	},
	MeasureGraphOnClick: function(urlData)
	{
		//alert("fffffffff");
		var wobj = Ext.getCmp('print');
		Ext.getCmp('tablesPanelID').hide();
		Ext.getCmp('graphsPanelID').hide();
		var fullviewObj = Ext.create('SLAView.view.FullView',{			
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:urlData,
			viewType:'measureGraph',
			gtype:'measure',
			submitBtnChangeURL:'',
		});
		
		if(!Ext.isEmpty(fullviewObj)){
			wobj.remove(fullviewObj);
			wobj.add(fullviewObj);
			wobj.doLayout();
		}
		
	},
	loadFullViewPanel: function()
	{
		var me =this;
		var fullViewPanelObj = Ext.getCmp('fullviewId');
		var urlData = fullViewPanelObj.Dataurl;	
		
		urlData += '&componentChange=true';
		//console.log("urlData fullview",urlData);
		//urlData = urlData.replace(/(comptype=)[^\&]+/, '$1' + 'Windows_server');
		//urlData += '&compType=Windows_server';
		//console.log("urlData",urlData);
		Ext.Ajax.request({
			url:urlData,
			scope:this,
			method: 'GET',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var fullviewData = jsonData['fullViewObj'];
					var title = fullviewData['measureDisplayName'];
					
					var timelineObj = Ext.getCmp('high_er_timeline');
					this.setValueForCombo(timelineObj,jsonData['displayPeriodArr'],'');
					var dateArrayValues = jsonData['dateArrayValues'];
					Ext.getCmp("high_er_stdate").setValue(dateArrayValues[0]);
					Ext.getCmp("high_er_enddate").setValue(dateArrayValues[1]);
					Ext.getCmp("high_er_sthr").setValue(dateArrayValues[2]);
					Ext.getCmp("high_er_endhr").setValue(dateArrayValues[3]);
					var MeasureGraphUrl = fullviewData['measureGraphUrl'];
					fullViewPanelObj.setTitle(title);
					fullViewPanelObj.submitBtnChangeURL = MeasureGraphUrl;
					var isAxisTimeReq = false;
					var legendPos = "bottom";	
					if(fusionChartsApiEnabled)
					{
						fullViewPanelObj.update('<img src="'+MeasureGraphUrl+'&height='+fullviewData['measGraphDivHeight']+'&width='+fullviewData['measGraphDivWidth']+'&mode=2D" />');
					}
					else
					{
						//alert("hello");
						setHighChart(MeasureGraphUrl,fullViewPanelObj.body.id,fullviewData['measGraphDivHeight'],750,'',isAxisTimeReq,legendPos,true,"line");
					}
				}
			},
			failure: function()
			{
				//alert("failure");
			}
		});
	},
	dateDiff: function( fromDate,toDate )
    {
    	var oneDay=24*60*60*1000;   //hours*mins*seconds*millisecs
		var fromDate=new Date(fromDate);
		var toDate=new Date(toDate);
		var diffDays = Math.round(Math.abs(fromDate.getTime()-toDate.getTime())/(oneDay));
		return diffDays;
    },
	submitBtnOnClick: function()
	{
		//console.log("submittered");
		var timelineVal = Ext.getCmp('high_er_timeline').getValue();

		var stDateObj=Ext.getCmp('high_er_stdate');
		var fromValue = formatDate(stDateObj.getValue(), mgrDisplayDateFormat);

		var enDateObj=Ext.getCmp('high_er_enddate');
		var ToValue = formatDate(enDateObj.getValue(), mgrDisplayDateFormat);

		var stHourVal=Ext.getCmp('high_er_sthr').getValue();
		var enHourVal=Ext.getCmp('high_er_endhr').getValue();

		var today = new Date();
		var diffDays = this.dateDiff(new Date(fromValue),new Date(ToValue));
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(timelineVal!=null && timelineVal.toLowerCase() == 'any')
		{		
			if(new Date(fromValue) > new Date(ToValue))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: "Start date should be lesser than end date",
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			
				return false;
			}
			if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
			{	
				if(stHourVal > enHourVal)
				{
					Ext.MessageBox.show({
					title: 'Alert',
					msg: "Start date should be lesser than end date",
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
				
					return false;
				}
			}			
			if(today < new Date(fromValue) )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: "From date should be lesser than Current date",
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
			}
		}
		var isHighcharts = true;
		if(diffDays>14)
		{
			isHighcharts =false;
		}
		var fullViewPanelObj = Ext.getCmp('fullviewId');
		var urlData = fullViewPanelObj.submitBtnChangeURL;		
		//console.log("urlData before submit",urlData);
		if(urlData.indexOf("CustomTimelineMeasures")>0)
		{					
			if(urlData.indexOf("time_line")>0)
			{				
				urlData = urlData.replace(/(time_line=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));
			}
			else
			{				
				urlData += '&time_line='+timelineVal;
			}
			fromValue = formatDate(stDateObj.getValue(), 'MM/dd/yyyy')+" "+stHourVal+":00:00";
			ToValue = formatDate(enDateObj.getValue(), 'MM/dd/yyyy')+" "+enHourVal+":00:00";
			urlData = urlData.replace(/(starttime=)[^\&]+/, '$1' + encodeURIComponent(fromValue));
			urlData = urlData.replace(/(endtime=)[^\&]+/, '$1' + encodeURIComponent(ToValue));
			urlData = urlData.replace(/(starthr=)[^\&]+/, '$1' + encodeURIComponent(stHourVal));
			urlData = urlData.replace(/(endhr=)[^\&]+/, '$1' + encodeURIComponent(enHourVal));
		}
		else
		{		
			if(urlData.indexOf("timeline")>0)
			{
				urlData = urlData.replace(/(timeline=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));
			}
			else
			{
				urlData += '&timeline='+timelineVal;
			} 
			if(urlData.indexOf("timeLine")>0)
			{
				urlData = urlData.replace(/(timeLine=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));
			}
			else
			{
				urlData += '&timeLine='+timelineVal;
			}
			fromValue = formatDate(stDateObj.getValue(), 'dd/MM/yyyy')+" "+stHourVal+":00:00";
			ToValue = formatDate(enDateObj.getValue(), 'dd/MM/yyyy')+" "+enHourVal+":00:00";

			urlData = urlData.replace(/(starttime=)[^\&]+/, '$1' + encodeURIComponent(fromValue));
			urlData = urlData.replace(/(endtime=)[^\&]+/, '$1' + encodeURIComponent(ToValue));
			urlData = urlData.replace(/(starthr=)[^\&]+/, '$1' + encodeURIComponent(stHourVal));
			urlData = urlData.replace(/(endhr=)[^\&]+/, '$1' + encodeURIComponent(enHourVal));
		}	
		//console.log("fromValue",fromValue);
		//console.log("ToValue",ToValue);
		//console.log("stHourVal",stHourVal);
		//console.log("enHourVal",enHourVal);
					
		var isAxisTimeReq = false;
		var legendPos = "bottom";		
		//console.log("urlData submit",urlData);
		if(fusionChartsApiEnabled)
		{
			fullViewPanelObj.update('<img src="'+urlData+'&height=400&width=750&mode=2D" />');
		}
		else
		{
			
			if(isHighcharts)
			{
				setHighChart(urlData,fullViewPanelObj.body.id,400,750,'',isAxisTimeReq,legendPos,true,"line");
			}
			else
			{
				fullViewPanelObj.removeAll();
				fullViewPanelObj.update('<img src="'+urlData+'&height=400&width=750&mode=2D" />');	
			}
		}			
	},
	loadAllServersSummaryGraph: function(){
		var me=this;
		ruleAndServerViewUrl =  publicJSON['serverViewUrl'];
				var selectedPeriod = Ext.getCmp('historyTimeLine').getValue();
			ruleAndServerViewUrl = ruleAndServerViewUrl+'&displayPeriod='+selectedPeriod;
			
			//alert("ruleAndServerViewUrl???"+ruleAndServerViewUrl);			
			Ext.Ajax.request({
				url :ruleAndServerViewUrl,
				method : 'POST',
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					console.log(" to all mea"+jsonText);
					var headerTitle = jsonData['dispTitle']+jsonData['name']+"-"+jsonData['dispPeriod'];
					Ext.getCmp('HistoryPanel').setTitle(headerTitle);
					me.loadMeasureGraph(jsonData);
				},
				failure: function()
				{
				}
			});
	}
});