Ext.define('SLAView.view.AssociatedServers', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.associatedservers',
	bodyPadding:'0',
	layout:'fit',
	id: 'associatedserverspanel',
	border: false,
	initComponent:function(){
		var me = this;
		me.items = this.getGridData(me.tabinfo);
		me.doLayout();
		me.callParent();
	},
	getGridData : function(vals)
	{
		var store = new Ext.data.Store({
			storeId: 'ruleDetailsDataStore',
			fields: ['stat','server','expected','achieve','graph'],
			data: vals
		});
		var itemsPerPage = 2;
		store.load({
			params: {
				starts: 0,
				limit: itemsPerPage
			}
		});
		var grids = {
			xtype:'gridpanel',
			id:'assServers_top10SlaGrid',
			name: 'assServers_top10SlaGrid',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'stat',
				header: statusLbl,
				flex: 1,
				height:20,
				style:{'padding':'0 0 0 0','margin':'0'},
				renderer: function(val){
					return '<b style="width:20px;padding:10px 0px"><div style="position:absolute;" class="state_'+val+'"></div></b>';
				}
			}, {
				dataIndex: 'server',
				header: serverLbl,
				flex: 3,
				renderer : function(value, metaData, record, row, col, store, gridView) {
					var column = gridView.getHeaderAtIndex(col);
					var dataIndexVal = column.dataIndex;
					var serverWthType = value.serverWithType;
					var link = value.link;
					return '<a href="javascript:void(0);" onclick="javascript:showPopup(\''+link+'\');">'+serverWthType+'</a>';
				}
			}, {
				dataIndex: 'expected',
				header: expectedLbl,
				flex: 1
			}, {
				dataIndex: 'achieve',
				header: achieveLbl,
				flex: 1,
			}, {
				dataIndex: 'graph',
				header: graphLbl,
				flex:1,
				renderer: function(val){
					return '<b style="width:20px;padding:10px 0px"><a href="javascript:void(0);" onclick="javascript:showPopup(\''+val+'\');"><div style="position:absolute;" class="iconLineChart"></div></a></b>';
				}
			}],
			hideHeaders: false
		};
		return grids;
	}
});