Ext.define('SLAView.view.ConfigurationView', {
	extend : 'Ext.panel.Panel',
	requires : ['SLAView.view.SLAViewConfig',
		'SLAView.view.SLAConfiguredRules',
		'SLAView.view.SLACompliance',
		'SLAView.view.AssociatedElements',
		'SLAView.view.ExcludedDescriptorsDetails'],
	alias : 'widget.configurationview',
	layout:{
		type:'vbox',
		align:'stretch'
	},
	url : null,
	id:'configurationPanel',
	border: false,
	frame: false,
	mask:null,
	initComponent : function(){
		
		this.loadConfigurationDetails();
		this.callParent();
	},
	loadConfigurationDetails : function(){
		
		var me = this;
		console.log("url>>>>}}}}}"+me.url);
		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				
				var viewslaPanel = {
					xtype:'slaviewconfig',
					rootComponent : jsonData['viewsla']
				};
				var slaConfiguredRulesPanel ={
					xtype:'slaconfiguredrules',
					rootComponent : jsonData.configureslarulesArray
				};
				var slaCompliancePanel ={
					xtype:'slacompliance',
					rootComponent : jsonData['slaComplianceAtrribute']
				};
				var associatedElementsPanel = {
					xtype:'associatedelements',
					rootComponent : jsonData['assosiateelementsArray']
				};
				var excludedDescriptorsDetailsPanel ={
					xtype:'excludeddescriptorsdetails',
					rootComponent : jsonData['excludedDescriptorsArray']
				};
				me.removeAll();
				me.add(viewslaPanel);
				me.add(slaConfiguredRulesPanel);
				me.add(slaCompliancePanel);
				me.add(associatedElementsPanel);
				var  jsonArr = jsonData['excludedDescriptorsArray'];
				if(jsonArr!=null && jsonArr.length>0){
					me.add(excludedDescriptorsDetailsPanel);
				}
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
			},
			failure : function(){
				//alert("failure");
			}
		});		

	}
});