Ext.define('SLAView.view.DetailsView', {
	extend : 'Ext.panel.Panel',
	requires : ['SLAView.view.DetailsGraph',
				'SLAView.view.RuleDetails',
				'SLAView.view.AssociatedServers'],
	alias : 'widget.detailsview',
	layout:'auto',
	border:false,
	url : null,
	id:'DetailsPanel',
	margin:'0',
	frame:false,
	padding:'0',
	mask:null,
	html:'',
	initComponent : function(){
		
		this.getDetailsView();

		this.callParent();
	},
	getDetailsView:function(){
		
		var me = this;
		
		//console.log("me.url details",me.url);
		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				
				me.removeAll();
				var jsonText = response.responseText;
				//console.log("details response",jsonText);
				var jsonData = Ext.decode(jsonText);
				if ( !Ext.isEmpty(jsonData.sladata))
				{
					var isInnerviewNeed = jsonData['innertabView'];
					var DetailsGraphPanel = {
						xtype:'detailsgraph',
						margin:'10',
						padding:'0',
						bodyPadding:'0',
						frame:false,
						border:false,
						title:jsonData['sladata']['title'],
						rootComponent : jsonData['sladata']
					};
					
					me.add(DetailsGraphPanel);
					var tabPanel ='';
					if ( isInnerviewNeed == 'true')
					{
						tabPanel = {
							xtype:'tabpanel',
							id:'detailsTabPanel',
							name:'detailsTabPanel',
							layout: 'fit',
							padding: '0px 0px 0px 0px',
							style: {
								background: 'none'
							},
							plain: false,
							cls: 'tablayout',
							//activeTab: 0, 
							border: false,
							frame: false,
							items: [{
								xtype: 'ruledetails',
								
								title: ruleDetails,
								autoScroll: true,
								tabinfo:jsonData.RuleViewDetailsArray								
							},{
								xtype: 'associatedservers',
								
								title: associatedServers,
								autoScroll:true,
								tabinfo:jsonData.serverViewDetailsArray
							}],
							listeners:{
								beforerender:function(){
									if( detailsActivetab.indexOf("ruledetailspanel")>-1){
										Ext.getCmp('detailsTabPanel').setActiveTab(0);
										
									}else if(detailsActivetab.indexOf("associatedserverspanel")>-1){
										Ext.getCmp('detailsTabPanel').setActiveTab(1);
										
									}
								},

								render:function(){
									this.tabBar.add({xtype:'tbfill'},{
										xtype: 'scrollcombo',
										labelWidth:70,
										fieldLabel:filterBy,
										cls:'dropdown',
										margin:'3 20 0 0',
										labelStyle: 'white-space: nowrap;',
										name:'',
										hidden:true,
										labelAlign:'left',
										labelSeparator:''
									})
								},
								'tabchange': function(panel, tab){
									detailsActivetab = Ext.getCmp('detailsTabPanel').getActiveTab().id;
									localStorage.setItem( 'detailsTab',detailsActivetab );
								}
							}
						};
						
 					}
					else
					{
						tabPanel = {
							xtype:'tabpanel',
							id:'detailsTabPanel',
							name:'detailsTabPanel',
							layout: 'fit',
							padding: '0px 0px 0px 0px',
							style: {
								background: 'none'
							},
							plain: false,
							cls: 'tablayout',
							border: false,
							frame: false,
							items: [ 
								{
									xtype: 'associatedservers',
									title: associatedServers,
									autoScroll:true,
									tabinfo:jsonData.serverViewDetailsArray								
								}]
						};						
					}
					
					me.add(tabPanel);
				}
				else
				{
					var errorMsg = jsonData['errorMsg'];
					me.removeAll();
					me.add({
						xtype:'container',
						border:false,						
						frame:false,
						html:'<table width="100%" height="450px"><tr><td valign="middle" align="center"><div class="iconExclamation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>'
					});
				}
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
			},
			failure : function(){
				//alert("failure");
			}
		});

	}
});