Ext.define('SLAView.view.HistoryView', {
	extend :'utilities.CommonPanel',
	requires : ['SLAView.view.SLASummary','SLAView.view.SLASummaryChart', 'utilities.CommonPanel'],
	alias : 'widget.historyview',
	bodyPadding:'0',
	margin:'10',
	layout:{
		type:'vbox',
		align:'stretch'
	},
	style:{'border':'0px solid red'},
	id: 'HistoryPanel',
	autoScroll: true,
	scroll: true,
	border: true,
	frame:true,
	url : null,
	mask:null,
	tools: [{
			xtype:'button',
			iconCls:'service20_HIGH',
			id:'showAllServersId',
			tooltip:'<b>All Servers</b>',
			style:{
					background:'none',border:'0px'
			},
			mode:'all'
		},{
		xtype:'toolbar',
		border:0,
		style:{
			border:'0px !important'
		},
		margin:'0 20px 0 1px',
		dock: 'right',
		padding:0,
		items:[{
			xtype:'button',
			iconCls:'iconBarChart',
			id:'showAllGraphId',
			tooltip:'<b>All Rules</b>',
			style:{
					background:'none',border:'0px'
			},
			mode:'all'
		}]
	},{
		xtype: 'scrollcombo',
		labelWidth:60,
		fieldLabel:'',
		margin:'0 40 0 0',
		cls:'dropdown',
		width:120,
		id:'historyTimeLine',
		labelStyle: 'white-space: nowrap;',
		name:'historyTimeLine',
		labelAlign:'left',
		labelSeparator:'',
		displayField: 'displayField',
		valueField:'valueField',
		store:new Ext.data.Store({
			fields:['displayField','valueField'],
			data:[]
		}),
		queryMode: 'local'
	},
	{
		xtype: 'toolbar',
		width:27,
		height:21,
		dock: 'right',
		cls:'iconBg',
		hidden : true,
		id:'settingsBtn',
		name:'settingsBtn',
		margin:'0 1px 0 1px',
		items:[{
			xtype:'button',
			iconCls:'iconSettings',
			tooltip:'<b>'+settings+'</b>',
			style:{
				background:'none',border:'0px'
			},
			handler:function(e){
				Ext.get('configMod_summary').animate({to: {'top': '84px'},listeners:{ afteranimate:function(){  Ext.get('configMod_summary').setStyle('left', '');}}}).show();
			}
		}]
	},
	{
		xtype: 'toolbar',
		width:27,
		height:21,
		dock: 'right',
		cls:'iconBg',
		margin:'0 1px 0 1px',
		items:[{
			xtype:'button',
			iconCls:'iconData',
			tooltip:'<b>'+hourlyData+'</b>',
			style:{
					background:'none',border:'0px'
			},
			handler: function (){
				var win = Ext.widget('window',{
				title: SLAHistory,
				autoScroll:false,
				closeAction: 'destory',
				width:800,
				resizable:false,
				height:500,
				modal:true,
				items:[{
						xtype:'slasummary',
						frame:false,
						border:false,
						id:'slaSummaryId',
						itemId:'slaSummaryId',
						url:publicJSON['hourlyDataUrl']
					}]
				}).show()
			}
		}]
	}],
	listeners:
	{
		afterrender: function(c)
		{
			this.showConfigDropdown();
			 Ext.get('closeSettings')
			  .on('click', function () {
					Ext.get('configMod_summary').animate({duration: 500,to: {y: -600}});
		   });
			Ext.get('timelineChangedBtn')
			  .on('click', function () {
					goTimeline();
		   });
		}
	},
	showConfigDropdown:function(){
			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px;color:#f7f7f7" class="settingsfontone"><b>SETTINGS</b></div><div class="iconBg"><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:590,
			padding:5,
			id:'configMod_summary',
			name : 'configMod_summary',
			cls:'configMode_popup',
			//html:tpl.apply(),
			items:[{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'521px'}
				},{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype :'panel',
					id : 'timelineDivObj',
					cls:'configMode_popup_inner',
					name : 'timelineDivObj',
					layout:'column',
					header: false,
					border: false,
					frame: false,
					defaults: {
						labelAlign: "top",
						margin: "10 10 10 10",
						labelSeparator: "",
						editable: false
					},
					items : [
						{
							xtype: 'datepicker',
							id: 'er_stdate',
							name: 'er_stdate',
							format: mgrDateFormat,
							fieldLabel:fromLbl,
							cls: 'datepicker',
							width: 115,
							disabled : false,
							dataArray: null,
							/*listeners: {
								'select': function (obj) {
									var timeline = Ext.getCmp("historyTimeLine").getValue();
									var strtdt = Ext.getCmp("er_stdate").getValue();
									var enddt = Ext.getCmp("er_enddate").getValue();
									var strthour = Ext.getCmp("er_sthr").getValue();
									var endhr = Ext.getCmp("er_endhr").getValue();
									//var erModeObj=Ext.getCmp('sys-modeID');										

									if(timeline=="Any")
									{
										strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
										enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
									}
									else
									{
										strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
										enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
									}

									var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]";											
									
									no_params +="&F=getTime";
									
									var param = "C=id" + no_params;
									Ext.Ajax.request({
										url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
										params: param,
										scope: this,
										method: 'POST',
										success: function (response) {
											var jsontext = response.responseText;
											var jsonData = Ext.decode(jsontext);
											if (!Ext.isEmpty(jsonData)) {
												
												var timedata = jsonData.timeline;
												
												Ext.getCmp("er_stdate").dataArray = timedata[0];
												Ext.getCmp("er_enddate").setValue(timedata[7]);
												Ext.getCmp("er_stdate").setValue(timedata[6]);
												Ext.getCmp("er_enddate").dataArray = timedata[1];
												Ext.getCmp("er_sthr").setValue(timedata[8]);
												Ext.getCmp("er_sthr").dataArray = timedata[2];
												Ext.getCmp("er_endhr").setValue(timedata[9]);
												Ext.getCmp("er_endhr").dataArray = timedata[3];
												stmin = timedata[10];
												enmin = timedata[11];
												mgr_stmin = timedata[4];
												mgr_enmin = timedata[5];
											}
										}
									});
								}
							}*/
						},
						{
							xtype:'scrollcombo',
							width:50,
							id: 'er_sthr',
							name:'er_sthr',
							defaultListConfig: {
												loadingHeight: 70,
												minWidth: 50,
												maxHeight: 300,
												shadow: 'sides'
											},
							store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23'],
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							fieldLabel:hrLbl,
							cls: 'dropdown',
							dataArray: null,							
							/*listeners: {
								'select': function (combo) {
									formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(),mgrDateFormat);
									if(mgr_stmin==null || mgr_stmin=="undefined" || mgr_stmin=='')
										mgr_stmin="00"
									var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";
									var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
									Ext.Ajax.request({
										url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
										params: param,
										scope: this,
										method: 'POST',
										success: function (response) {													
											var responseText = response.responseText;
											responseText = Ext.String.trim(responseText);
											var dt = responseText.substring(0, responseText.lastIndexOf(" "));
											var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
											
											if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
											   Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
											} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
												Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
												
											}
										   
										}
									});
								}							
							}*/
						},
						{
							xtype: 'datepicker',
							id: 'er_enddate',
							name: 'er_enddate',
							format: mgrDateFormat,
							fieldLabel:toLbl,
							cls: 'datepicker',
							width: 115,
							disabled : false,
							dataArray: null,
							/*listeners: {
								'select': function (obj) {									
									var timeline = Ext.getCmp("historyTimeLine").getValue();
									var strtdt = Ext.getCmp("er_stdate").getValue();
									var enddt = Ext.getCmp("er_enddate").getValue();
									var strthour = Ext.getCmp("er_sthr").getValue();
									var endhr = Ext.getCmp("er_endhr").getValue();
									//var erModeObj=Ext.getCmp('sys-modeID');										
									if(timeline=="Any")
									{
										strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
										enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
									}
									else
									{
										strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
										enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
									}
									var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]";
									
									
									no_params +="&F=getTime";
									
									var param = "C=id" + no_params;
									Ext.Ajax.request({
										url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
										params: param,
										scope: this,
										method: 'POST',
										success: function (response) {
											var jsontext = response.responseText;
											var jsonData = Ext.decode(jsontext);
											if (!Ext.isEmpty(jsonData)) {
												var timedata = jsonData.timeline;
												Ext.getCmp("er_stdate").setValue(timedata[6]);
												Ext.getCmp("er_stdate").dataArray = timedata[0];
												Ext.getCmp("er_enddate").setValue(timedata[7]);
												Ext.getCmp("er_enddate").dataArray = timedata[1];
											
												Ext.getCmp("er_sthr").setValue(timedata[8]);
												Ext.getCmp("er_sthr").dataArray = timedata[2];
												Ext.getCmp("er_endhr").setValue(timedata[9]);
												Ext.getCmp("er_endhr").dataArray = timedata[3];
												stmin = timedata[10];							
												enmin = timedata[11];
												mgr_stmin = timedata[4];
												mgr_enmin = timedata[5];
											}
										}
									});
								}
							}*/
						},
						{
							xtype:'scrollcombo',
							width:50,
							defaultListConfig: {
								loadingHeight: 70,
								minWidth: 50,
								maxHeight: 300,
								shadow: 'sides'
							},
							fieldLabel:hrLbl,
							cls: 'dropdown',
							id: 'er_endhr',
							name:'er_endhr',
							store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23'],
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							dataArray: null,
							/*listeners: {
								'select': function (combo) {
									formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
									if(mgr_enmin==null || mgr_enmin=="undefined" ||mgr_enmin=='')
										mgr_enmin="00"
									var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
									var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
									Ext.Ajax.request({
										url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
										params: param,
										scope: this,
										method: 'POST',
										success: function (response) {
											var responseText = response.responseText;
											responseText = Ext.String.trim(responseText);
											var dt = responseText.substring(0, responseText.lastIndexOf(" "));
											var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
											if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
												Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
											} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
												Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
											}
											
										}
									});
								}									   
							}*/
						},
						{
							xtype :'button',
							cls:'button20',
							margin:'20 0 0 10',
							id : 'timelineChangedBtn',
							name : 'timelineChangedBtn',
							text : submitLbl
						}
			]},/*{
				xtype : 'container',
				dock : 'bottom',
				layout: {                        
					type: 'hbox',
					align: 'center',
					pack:'center'
				},
				cls:"loop",
				style:{'background-color':'rgb(83, 83, 83)'},
				items : [	
				{
					xtype:'button',
					text: 'Submit',
					id:'gobtnnew',
					cls: 'quickMenuWhiteButton',
					margin:'0 0 0 0',
				}]	
			}*/
			],
			renderTo:'HistoryPanel-body'
			});
	},
	initComponent : function(){
		
		this.loadSummaryGraph();
		
		this.callParent();

	},
	loadSummaryGraph : function(){
		
		var me = this;
		
		//console.log("url\\\\history url"+this.url);
		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
			
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				//console.log("jsonData????hhhhhh"+jsonText);
				var chartUrl = jsonData['charturl'];
				var allChartJsonData = '';
				var allDivForChart  = '';
				var chartArray = '';
				chartUrl = chartUrl+'&displayPeriod='+jsonData['dispPeriod'];
				//console.log("chartUrl",chartUrl);
				var ruleAndServerViewUrl =  jsonData['ruleAndServerViewUrl'];
				ruleAndServerViewUrl = ruleAndServerViewUrl+'&displayPeriod='+jsonData['dispPeriod'];
				console.log("ruleAndServerViewUrl default",ruleAndServerViewUrl);
				Ext.Ajax.request({
					url :ruleAndServerViewUrl,
					method : 'POST',
					success : function(res, opt){
						var jsonText1 = res.responseText;
						console.log("jsonText1 111",jsonText1);
						allChartJsonData = Ext.decode(jsonText1);
						chartArray = allChartJsonData['chartArray'];
						allDivForChart = '<div id="allSummaryContentId" >'+me.returnChartData(allChartJsonData)+'</div>';
						/*for ( var j = 0 ; j < chartArray.length; j++ )
						{
							allDivForChart+='<div style="float:left;height:200px;margin:6px;background-color:#f2f2f2"><div id="summarychartTitleID_'+j+'" style="padding:4px;width:300px;">'+allChartJsonData['chartArray'][j]['title']+'</div><table cellpadding="0" cellspacing="0" width="100%" height="100%"><tr><td align="center" valign="middle"><div style="border:0px solid red" id="summarychartID_'+j+'"></div></td></tr></table></div>';
						}*/
						me.removeAll();
						me.getHistoryPanelData(chartUrl,chartArray,allDivForChart);
					},
					failure: function(){
						//alert("failure");
					}
				});
				publicJSON = jsonData;
				me.loadTimeLineCombo();
				//console.log("publicJSON????"+publicJSON);
			},
			failure : function(){
				//alert("failure");
			}
		});
	},
	loadTimeLineCombo:function(){	
		//console.log("conmin"+publicJSON);
		var comboList = publicJSON['timeLineList'];
		//console.log("ggggg-------"+comboList);
		var selectedPeriod = publicJSON['dispPeriod'];
		//console.log("hello..");
		var timlineComboObj = Ext.getCmp('historyTimeLine');
					
		if ( !Ext.isEmpty(comboList))
		{
			this.setValueForCombo(timlineComboObj,comboList,selectedPeriod);
		}
		var startDateObj =  Ext.getCmp("er_stdate");
		var endDateObj =  Ext.getCmp("er_enddate");
		var stHrObj =  Ext.getCmp("er_sthr");
		var endHrObj =  Ext.getCmp("er_endhr");

		if(startDateObj!=null && startDateObj!="undefined")
		{
			var startDateAsJson = publicJSON['timelineStartDate'];
			//alert("startDateAsJson"+startDateAsJson);
			startDateObj.setValue(startDateAsJson);
			
		}
		if(endDateObj!=null && endDateObj!="undefined")
		{
			var endDateAsJson = publicJSON['timelineEndDate'];
			endDateObj.setValue(endDateAsJson);
		}

		if(stHrObj!=null && stHrObj!="undefined")
		{
			var startHrAsJson = publicJSON['timelineStHr'];
			stHrObj.setValue(startHrAsJson);
		}

		if(endHrObj!=null && endHrObj!="undefined")
		{
			var endHrAsJson = publicJSON['timelineEdHr'];
			endHrObj.setValue(endHrAsJson);
		}
	},
		setValueForCombo: function(comboObj,list,selectedPeriod){
		//alert("setting combo"+selectedPeriod);
		Ext.getCmp('historyTimeLine').getStore().loadRawData(list);
		if ( selectedPeriod != null &&  selectedPeriod != "")
		{
			comboObj.setValue(selectedPeriod);
		}
		else
		{			
			comboObj.setValue(list[0]['valuefield']);
		}
	},
	returnChartData : function(vals)
	{
		var htmlString = '<center><b>Current compliance is  '+vals['currentCompliance']+' , the goal is '+vals['expectedCompliance']+'</br>'+vals['dispTitle']+' '+vals['name']+' - '+vals['dispPeriod']+'';
		return htmlString;
	},
	getHistoryPanelData: function(url,chartArray,allDivForChart){
		var me = this;
		var summartChartPanel ='';
		//console.log("url>>>"+url);
		Ext.Ajax.request({
			url :url,
			method : 'POST',
			success : function(responseFrSummary, optsFrSmmary){
				var jsonTextFrSummary = responseFrSummary.responseText;
				//console.log("jsonTextFrSummary",jsonTextFrSummary);
				var jsonDataFrSummary = Ext.decode(jsonTextFrSummary);
				var title = jsonDataFrSummary['dispTitle']+" ' "+jsonDataFrSummary['name']+" ' -"+jsonDataFrSummary['dispPeriod'];
				Ext.getCmp('HistoryPanel').setTitle(title);
				var summartChartPanel = {
					//xtype:'commonPanel',
					xtype:'container',
					id:'measureGraphPanel',
					//title:jsonDataFrSummary['dispTitle']+" "+jsonDataFrSummary['name']+"-"+jsonDataFrSummary['dispPeriod'],
					border: true,
					frame:true,
					padding:false,
					margin:'10',
					//cls:'block1',
					height:600,
					width:800,
					/*items:[{
						xtype: 'container',
						border: false,
						frame:false,
						padding:false,
						margin:'0',
						style:{'border':'0px solid green'},
						padding:'10',
						id:'singleSummaryChartId',
						//html:'<div id="summaryContentId" >'+me.returnChartData(jsonDataFrSummary)+'</div><table width="100%" cellpadding="0" cellspacing="0"><tr><td align="center" valign="middle"><div id="StackedColumn3D" style="margin-top:3px !important"></div></td></tr></table>',
						hidden:false
					},{
						xtype: 'container',
						border: false,
						frame:false,
						padding:false,
						id:'allSummaryChartId',
						html:allDivForChart,
						hidden:true
					}],*/
					listeners:
					{
						afterrender: function(c)
						{
							var getVal = jsonDataFrSummary['xmlData'];
							console.log("getVal????????"+getVal);
							if ( !Ext.isEmpty(getVal))
							{
								if(fusionChartsApiEnabled)
								{
									var chartPath = '/final/FusionCharts/swf/StackedColumn3D.swf';
									var myChart = new  FusionCharts(chartPath,'StackedColumn3DChart', "650px", "380px","0","1");
									myChart.setXMLData(getVal);
									myChart.setTransparent(true);
									myChart.render('StackedColumn3D');
								}
								else
								{
									try
									{
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance(c.id, 400, 900), barChart);
										barChart.setData(getVal, currentDateFormat,'','stackedColumn');
										barChart.drawChart();
										
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
								}
							}
							else
							{
								c.update('<table width="100%" height="450px"><tr><td valign="middle" align="center"><div class="iconExclamation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');

							}
						}
					}
				};
				me.removeAll();
				me.add(summartChartPanel);
			}
		});
		//return summartChartPanel;
	}

	/*getHistoryPanelData: function(url,chartArray,allDivForChart){
		var me = this;

		Ext.Ajax.request({
					url :url,
					method : 'POST',
					success : function(responseFrSummary, optsFrSmmary){
						var jsonTextFrSummary = responseFrSummary.responseText;
						console.log("jsonTextFrSummary",jsonTextFrSummary);
						var jsonDataFrSummary = Ext.decode(jsonTextFrSummary);
						var summartChartPanel = {
							xtype:'commonPanel',
							id:'measureGraphPanel',
							title:jsonDataFrSummary['dispTitle']+" "+jsonDataFrSummary['name']+"-"+jsonDataFrSummary['dispPeriod'],
							layout:{
								type:'vbox',
								align:'stretch'
							},
							border: true,
							frame:true,
							padding:false,
							margin:'10',
							autoScroll:true,
							cls:'block1',
							height:600,
							width:800,
							items:[{
								xtype: 'container',
								border: false,
								frame:false,
								padding:false,
								margin:'0',
								style:{'border':'0px solid green'},
								padding:'10',
								id:'singleSummaryChartId',
								//html:'<div id="summaryContentId" >'+me.returnChartData(jsonDataFrSummary)+'</div><table width="100%" cellpadding="0" cellspacing="0"><tr><td align="center" valign="middle"><div id="StackedColumn3D" style="margin-top:3px !important"></div></td></tr></table>',
								hidden:true
							},{
								xtype: 'container',
								border: false,
								frame:false,
								padding:false,
								id:'allSummaryChartId',
								html:allDivForChart,
								hidden:false
							}],
							tools: [{
								xtype: 'toolbar',
								width:27,
								height:21,
								dock: 'right',
								cls:'iconBg',
								margin:'0 20px 0 1px',
								items:[{
										xtype:'button',
										iconCls:'iconBarGraph',
										id:'showAllGraphId',
										tooltip:'<b>Show All Graphs</b>',
										style:{
												background:'none',border:'0px'
											},
										//handler: function (){
												//alert("your condition here");
										//}
								}]
							},{
									xtype: 'scrollcombo',
									labelWidth:60,
									fieldLabel:'',
									margin:'0 40 0 0',
									cls:'dropdown',
									width:120,
									id:'historyTimeLine',
									labelStyle: 'white-space: nowrap;',
									name:'historyTimeLine',
									labelAlign:'left',
									labelSeparator:'',
									displayField: 'displayField',
									valueField:'valueField',
									store:new Ext.data.Store({
										fields:['displayField','valueField'],
										data:[]
									}),
									queryMode: 'local'
							},
							{
								xtype: 'toolbar',
								width:27,
								height:21,
								dock: 'right',
								cls:'iconBg',
								hidden : true,
								id:'settingsBtn',
								name:'settingsBtn',
								margin:'0 1px 0 1px',
								items:[{
									xtype:'button',
									iconCls:'iconConfig',
									tooltip:'<b>Settings</b>',
									style:{
										background:'none',border:'0px'
									},
									handler:function(e){
										Ext.get('configMod_summary').animate({to: {'top': -5},listeners:{ afteranimate:function(){  Ext.get('configMod_summary').setStyle('left', '');}}}).show();
									}
								}]
							},
							{
								xtype: 'toolbar',
								width:27,
								height:21,
								dock: 'right',
								cls:'iconBg',
								margin:'0 1px 0 1px',
								items:[{
									xtype:'button',
									iconCls:'iconData',
									tooltip:'<b>hourly data</b>',
									style:{
											background:'none',border:'0px'
									},
									handler: function (){
										var win = Ext.widget('window',{
										title: 'SLA Hourly Data',
										autoScroll:false,
										closeAction: 'destory',
										width:800,
										resizable:false,
										height:500,
										items:[{
												xtype:'slasummary',
												frame:false,
												border:false,
												id:'slaSummaryId',
												itemId:'slaSummaryId',
												url:publicJSON['hourlyDataUrl']
											}]
										}).show()
									}
								}]
							}],
							listeners:
							{
								afterrender: function(c)
								{
									this.showConfigDropdown();
									 Ext.get('closeSettings')
									  .on('click', function () {
											Ext.get('configMod_summary').animate({duration: 500,to: {y: -500}});
								   });
								    Ext.get('timelineChangedBtn')
									  .on('click', function () {
											goTimeline();
								   });
									var getVal = jsonDataFrSummary['xmlData'];

									if ( !Ext.isEmpty(getVal))
									{
										if(fusionChartsApiEnabled)
										{
											var chartPath = '/final/FusionCharts/swf/StackedColumn3D.swf';
											var myChart = new  FusionCharts(chartPath,'StackedColumn3DChart', "650px", "380px","0","1");
											myChart.setXMLData(getVal);
											myChart.setTransparent(true);
											myChart.render('StackedColumn3D');
										}
										else
										{
											try
											{

												var barChart = {};
												barChart = jQuery.extend(true, {}, getHighChartsBarInstance(c.body.id, 350, 750), barChart);
												barChart.setData(getVal, currentDateFormat,'','stackedColumn');
												barChart.drawChart();
											}
											catch (barChartEx)
											{
												console.log(barChartEx);
											}
										}
									}
									else{
										Ext.get('StackedColumn3D').update("No Measure available");

									}
									/*if ( !Ext.isEmpty(chartArray))
									{
										var chartPath = '/final/FusionCharts/swf/StackedColumn3D.swf';
										for ( var k = 0 ; k < chartArray.length ; k++)
										{
											var getVals = chartArray[k]['xmlData'];
											if ( !Ext.isEmpty(getVals))
											{
												if(fusionChartsApiEnabled)
												{
													var myChart = new  FusionCharts(chartPath,'StackedColumn3DChart_'+k, "300px", "150px","0","1");
													myChart.setXMLData(getVals);
													myChart.setTransparent(true);
													myChart.render('summarychartID_'+k);
												}
												else
												{
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(c.body.id, 380, 700), barChart);
														barChart.setData(getVals, currentDateFormat,'','stackedColumn');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
											else
											{
												Ext.get('summarychartID_'+k).update('<div class="iconExclamation"></div><div>No Measure available</div>');
											}
										}
									}
								}
							},
							showConfigDropdown:function(){
									var tpl = new Ext.XTemplate('<div style="text-align:right;float:right"><div class="iconBg"><div class="iconWrong" id="closeSettings"></div></div></div>');
									//config dropdown mode
									Ext.create('Ext.container.Container',{
									width:590,
									padding:5,
									id:'configMod_summary',
									name : 'configMod_summary',
									cls:'configMode_popup',
									html:tpl.apply(),
									items:[
										{
											xtype :'fieldcontainer',
											id : 'timelineDivObj',
											name : 'timelineDivObj',
											layout:'column',
											width :500,
											defaults:{
												labelAlign: 'top',
												margin:'0 0 0 10',
												labelSeparator:'',
												editable:false
											},
											items : [
												{
													xtype: 'datepicker',
													id: 'er_stdate',
													name: 'er_stdate',
													format: mgrDateFormat,
													fieldLabel:'From',
													cls: 'datepicker',
													width: 115,
													disabled : false,
												},
												{
													xtype:'scrollcombo',
													width:50,
													id: 'er_sthr',
													name:'er_sthr',
													defaultListConfig: {
																		loadingHeight: 70,
																		minWidth: 50,
																		maxHeight: 300,
																		shadow: 'sides'
																	},
													store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23'],
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local',
													fieldLabel:'Hr',
													cls: 'dropdown',
												},
												{
													xtype: 'datepicker',
													id: 'er_enddate',
													name: 'er_enddate',
													format: mgrDateFormat,
													fieldLabel:'To',
													cls: 'datepicker',
													width: 115,
													disabled : false,

													listeners:{
														scopr:this,
														'focus':function(){
															//Ext.select('.x-css-shadow').hide();

														}
													}
												},
												{
													xtype:'scrollcombo',
													width:50,
													defaultListConfig: {
																		loadingHeight: 70,
																		minWidth: 50,
																		maxHeight: 300,
																		shadow: 'sides'
																	},
													fieldLabel:'Hr',
													cls: 'dropdown',
													id: 'er_endhr',
													name:'er_endhr',
													store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23'],
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local',

												},
												{
													xtype :'button',
													cls:'button20',
													margin:'20 0 0 10',
													id : 'timelineChangedBtn',
													name : 'timelineChangedBtn',
													text : 'Go'
												}
									]
									} ],
									renderTo:'HistoryPanel-body'
									});

							}
						};

						me.add(summartChartPanel);
					},
					failure: function(){
						alert("failure");
					}
				});
	}*/
});