Ext.define('SLAView.view.Print',{
	extend:'Ext.window.Window',
	alias:'widget.print',
	modal:true,
	id:'print',
	name:'print',
	ghost:false,
	closeAction:'destroy',
	constrain:true,
	title: operationLbl,
	width:1000,
	height:550,
	autoScroll:true,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	defaults:{
			margin:'0 0 0 0'
	},
	JSONDATA:'',
	listeners: {
		show: function(win) {
		if (this.modal) {
				  var dom = Ext.get(Ext.getBody().id).select('.x-mask');
				  dom.addCls('windowModal');
				 }
		}
		
	},
	initComponent : function()
	{
		//console.log("entered");
		var me =this;
		me.callParent();
		var tabPanelID = Ext.getCmp('detailsTabPanel').getActiveTab().id;
		var isRulesPanelVisible =false;
		var isAssPanelVisible =false;
		if(tabPanelID.toLowerCase() == 'ruledetailspanel')
			isRulesPanelVisible = true;
		else if(tabPanelID.toLowerCase() == 'associatedserverspanel')
			isAssPanelVisible = true;
		var jsonData = me.JSONDATA;
		var tableDatas = this.tableData(jsonData);
		var measureGraphUrl = jsonData['MeasureGraphURL'];
		var fullViewURL ='';
		var fullViewTitle ='';
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var tablesPanel = {
			xtype:'panel',
			id:'tablesPanelID',
			cls:'outerpanel',
			margin:10,
			title:jsonData['winTitle'],
			html:tableDatas
		};		
		var graphsPanel = new Array();
		var ui = Ext.create('Ext.panel.Panel',{
		margin:10,
		//height:200,
		cls:'outerpanel',
		id:'graphsPanelID'});
		//alert("measureGraphUrl"+measureGraphUrl);
		console.log("measureGraphUrl*****************"+measureGraphUrl);
		Ext.Ajax.request({
			url : measureGraphUrl,
			method : 'GET',
			scope : this,
			success : function(response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
				//console.log("hello");
					var tmpJsonTxt = response.responseText;
					
					console.log("tmpJsonTxt****************}}"+tmpJsonTxt);
					var jsonDATA = Ext.decode(tmpJsonTxt);
					var title =jsonDATA['title'];
					//alert(title);
					var graphData = jsonDATA['fullViewArray'];
					//console.log("graphData====="+graphData);
					if(graphData!=null && !Ext.isEmpty(graphData) && graphData!=undefined)
					{
						for(var i=0;i<graphData.length;i++)
						{
							var measure = graphData[i]['measureDisplayName'];
							var measureGrpUrl = graphData[i]['measureGraphUrl'];
							//console.log("measureGrpUrl????"+measureGrpUrl);
							var fullViewUrl = graphData[i]['fullViewGraphURL'];
							//console.log("fullViewUrl????"+fullViewUrl);

							//var ty = Ext.create('Ext.container.Container',{html:'ss'+i});
							var ty = {
								xtype:'container',
								cls:'datapanel',
								items:[
									{
										xtype:'container',
										width:'100%',
										html:'<div style="text-align:center;padding:0px 0px 0px 0px">'+measure+'</div>'
									},
									{
										xtype:'container',
										width:'100%',
										flex:1,
										height:450,
										id:'measureGraph_'+i,
										listeners:{
											afterrender: function(c)
											{
												if(fusionChartsApiEnabled)
												{
													this.update('<img src="'+measureGrpUrl+'&height=300&width=450&mode=2D" />');
												}
												else
												{
													setHighChart(measureGrpUrl,c.id,380,750,fullViewUrl,isAxisTimeReq,legendPos,true,"line");
												}
											}
										}
									}
								]
							};
							ui.setTitle(title);
							ui.add(ty);
							//var graphDiv=document.getElementById("graphsPanelID");
							//graphDiv.style.width=measGraphWidth;
							//graphDiv.style.height=200;
							//ui.style.height=200;
						}
					}
					else
					{
						var ErrorMsg = jsonDATA['ERRORMSG'];
						var ty = {
							xtype:'container',
							width:'100%',
							height:270,
							html:'<table cellpadding="0" cellspacing="0" border="0" width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconExclamation" style="text-align:center"></div>'+ErrorMsg+'</td></tr></table>'
						};
						ui.setTitle(title);
						ui.add(ty);
					}
				}
			}
		});
		me.add(tablesPanel,ui);
	},
	tableData : function(jsonData)
	{
		var headers = jsonData['headerJSON'];
		var tableValues = jsonData['TableDatas'];
		var htmlString = '<div style="height:125px">'+
			'<table cellpadding="4" cellspacing="0" width="100%" border="1" >'+
				'<thead>'+
					'<tr>'+
						'<th valign="middle" style="padding:4px;text-align:center;"><b>'+headers['column_0']+'</b></th>'+
						'<th class="table_header"><b>'+headers['column_1']+'</b></th>'+
						'<th class="table_header"><b>'+headers['column_2']+'</b></th>'+
						'<th class="table_header"><b>'+headers['column_3']+'</b></th>'+
						'<th class="table_header"><b>'+headers['column_4']+'</b></th>'+
						//'<th class="table_header"><b>'+headers['column_5']+'</b></th>'+
					'</tr>'+
				'</thead>'+
		'<tbody>';
		for(var j = 0 ; j < tableValues.length ; j++)
		{
			htmlString+='<tr>'+
				'<td  align="center" valign="middle" style="padding:4px;">'+tableValues[j]['RuleName']+'</td>'+
				//'<td>'+tableValues[j]['RuleName']+'</td>'+
				'<td>'+tableValues[j]['Test']+'</td>'+
				'<td>'+tableValues[j]['Measure']+' ('+tableValues[j]['Unit']+')</td>'+
				'<td>'+tableValues[j]['ConditionDisp']+'</td>'+
				//'<td>'+tableValues[j]['Value']+'</td>'+
				'<td>'+tableValues[j]['Weight']+'</td>'+
			'</tr>';
		}
		htmlString+='</tbody></table></div>';
		return htmlString;
	}
});