Ext.define('SLAView.view.RuleDetails', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.ruledetails',
	bodyPadding:'0',
	layout:'fit',
	id: 'ruledetailspanel',
	border: false,
	initComponent:function(){
		var me = this;
		//console.log("me.tabinfo"+me.tabinfo);
		
		
		me.items = this.getGridData(me.tabinfo);
		me.doLayout();
		me.callParent();
	},
	getGridData : function(vals)
	{
		var store = new Ext.data.Store({
			storeId: 'ruleDetailsDataStore',
			fields: ['stat', 'rule', 'test', 'measure', 'expected','achieve','graph'],
			data: vals
		});
		var itemsPerPage = 2;
		store.load({
			params: {
				starts: 0,
				limit: itemsPerPage
			}
		});
		var grids ={
			xtype:'gridpanel',
			id:'rule_top10SlaGrid',
			name: 'rule_top10SlaGrid',
			cls: 'gridSkin',
			border: false,
			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'stat',
				header: statusLbl,
				flex: 1,
				height:20,
				style:{'padding':'0 0 0 0','margin':'0'},
				renderer: function(val){
					return '<b style="width:20px;padding:10px 0px"><div style="position:absolute;" class="state_'+val+'"></div></b>';
				}
			}, {
				dataIndex: 'rule',
				header: ruleName,
				flex: 2,
				renderer: function(val){
					var ruleName = val.ruleName;
					var link = val.link;
					return '<a href="'+link+'">'+ruleName+'</a>';
				}
			}, {
				dataIndex: 'test',
				header: testLbl,
				flex: 2
			}, {
				dataIndex: 'measure',
				header: measureLbl,
				flex: 3
			}, {
				dataIndex: 'expected',
				header: expectedLbl,
				flex: 1
			}, {
				dataIndex: 'achieve',
				header: achieveLbl,
				flex: 1
			}, {
				dataIndex: 'graph',
				header: graphLbl,
				flex:1,
				renderer: function(val){
					//console.log("val??"+val);
					return '<b style="width:20px;padding:10px 0px"><a href="javascript:void(0);" onclick="javascript:showPopup(\''+val+'\');"><div style="position:absolute;" class="iconLineChart"></div></a></b>';
				}
			}],
			hideHeaders: false
		};
		return grids;
	}
});
