Ext.define('SLAView.view.SLAConfiguredRules', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.slaconfiguredrules',
	bodyPadding:'0',
	cls:'block1',
	layout:'fit',
	title: configuredSLA,
	id: 'slaconfiguredrules',
	margin:10,
	border: false,
	items: [],
	initComponent:function(){
		var me = this;
		me.items = this.getGridData(me.rootComponent);
		this.callParent();		
	},
	getGridData : function(vals)
	{
		var store = new Ext.data.Store({
			storeId: 'ruleDetailsDataStore',
			//fields: ['rulename', 'test', 'measure', 'expectedcondition', 'expectedvalue','weight'],
			fields: ['rulename', 'test', 'measure', 'expectedcondition','weight'],
			data: vals
		});
		var itemsPerPage = 2;
		store.load({
			params: {
				starts: 0,
				limit: itemsPerPage
			}
		});
		var grids = {
			xtype:'gridpanel',
			id:'viewslaGrid',
			name: 'viewslaGrid',
			cls: 'gridSkin',
			layout: 'fit',
			border: false,
			style: 'padding-bottom: 5px;',
			store: store,
			columns: [{
				dataIndex: 'rulename',
				header: ruleName,
				flex: 3
			}, {
				dataIndex: 'test',
				header: testLbl,
				flex: 3
			}, {
				dataIndex: 'measure',
				header: measureLbl,
				flex: 3
			}, {
				dataIndex: 'expectedcondition',
				header: expectedCond,
				flex: 2
			}, /*{
				dataIndex: 'expectedvalue',
				header: 'Expected value',
				flex: 2
			},*/
			{
				dataIndex: 'weight',
				header: weightLbl,
				flex: 2
			}],
			hideHeaders: false
		};
		return grids;
	}
});