
Ext.define('ADUserReports.controller.Main',{
	extend:'Ext.app.Controller',

	views:[
		'Main',
		'DomainForm',
		'EgDomainGroupTree',
		'EgDomainOUTree'
	],

	requires : ['Ext.ux.form.MultiSelect'],

	refs:[
		{selector:'main', ref:'main'},
		{selector:'viewport', ref:'viewport'},
		{selector:'main #deleteAllDomain', ref:'deleteBtn'},
		{selector:'main grid[id="domainGrid"]', ref:'domainGridView'},
		{selector:'domainform', ref:'domainform'},
		{selector:'domainform button[id="backButton"]', ref:'backButton'},
	],

	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready': this.afterMainRender
			},
			'main button[id="addNewDomain"]':
			{
				'click':this.addNewDomain
			},
			'main toolbar > #btnSetting':
			{
				'click':this.updateSettings
			},
			'domainform button[id="backButton"]':
			{
				'click':this.loadMainView
			},
			'domainform #update':
			{
				'click':this.updateDomainDetails
			},
			'domainform button[id="validate"]':
			{
				'click':this.validateADServerCredentials
			},
			'domainform #domnam':
			{
				//'blur':this.changeToUpperCase
			},
			'egdomainoutree':
			{
				'afterrender':this.setURLforIframe
			}
		});
	},
	setURLforIframe: function()
	{
		var ListGroupTreeObj = Ext.select("#ListGroupView");
		ListGroupTreeObj.set({
			src : publicOUJson.defaultURL+"&date="+new Date().getTime()
		});
		//document.getElementById('iframeCenter').src = publicOUJson.defaultURL+"&date="+new Date().getTime();
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url: 'ADUserReports/data/ADUserReportsJson.jsp',
			method: 'POST',
			async : false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	loadMainView : function()
	{
		var viewContainer = this.getViewport();
		viewContainer.removeAll();
		viewContainer.add({xtype:'main'});
	},
	loadDomains : function()
	{
		this.updateDomainInfo("ADUserReports/data/ADUserReportsJson.jsp");
		var viewContainer = this.getViewport();
		viewContainer.removeAll();
		viewContainer.add({xtype:'main'});
	},
	updateADSettings : function()
	{
		var isDiscoveryEnabled = 'No';
		var isDebugEnabled = 'No';
		var entityFormat = 'descriptive';
		if (Ext.getCmp('discoverGroups1').getValue())
		{
			isDiscoveryEnabled = 'Yes';
		}
		if (Ext.getCmp('debug1').getValue())
		{
			isDebugEnabled = 'Yes';
		}
		if (Ext.getCmp('entityformat2').getValue())
		{
			entityFormat = 'concise';
		}
		var frequency = Ext.getCmp('frequency').getValue();
		var timeFrom = Ext.Date.format(Ext.getCmp('timeFrom').getValue(),"H");
		var timeTo = Ext.Date.format(Ext.getCmp('timeTo').getValue(),"H");
		timeFrom = timeFrom+"-"+ timeTo;

		if (this.validateSettings())
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			Ext.Ajax.request({
				url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=Settings&isDiscoveryEnabled="+isDiscoveryEnabled+"&isDebugEnabled="+isDebugEnabled+"&frequency="+frequency+"&timeFrom="+encodeURIComponent(timeFrom)+"&entityFormat="+encodeURIComponent(entityFormat),
				method: 'POST',
				timeout : 7200000,
				success: function(response)
				{
					myMask.hide();
					var resultObj = Ext.decode(response.responseText);
					Ext.Msg.show({
						title: pageTitle,
						msg: resultObj.result.message1+".",
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
					delete resultObj;
				},
				failure: function()
				{
					myMask.hide();
				}
			});
		}
	},
	validateSettings : function()
	{
		var frequency = Ext.getCmp('frequency').getValue();
		var timeFrom = Ext.Date.format(Ext.getCmp('timeFrom').getValue(),"H");
		var timeTo = Ext.Date.format(Ext.getCmp('timeTo').getValue(),"H");

		if(Ext.isEmpty(frequency))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl42,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if (frequency <= 0 || frequency > 7)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: discoveryS1 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if (parseInt(timeFrom) > parseInt(timeTo))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: discoveryS2 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		else if (parseInt(timeTo) < parseInt(timeFrom))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: discoveryS2 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		return true;
	},
	updateSettings : function()
	{
		var me = this;
		Ext.widget("window",{
			alias:'widget.customsettings',
			title : pageIntnl18,
			width: 550,
			modal : true,
			resizable : false,
			border : false,
			layout : 'fit',
			padding:'5 10 10 10',
			closeAction: 'destory',
			doClose : function()
			{
				this.destroy();
			},
			//buttonAlign : 'center',
			//buttons : [
				//{
					//text: 'Update',
					//id: 'btnSettings',
					//width: 80,
					//cls:'button20',
					//handler : function(obj)
					//{
						//me.updateADSettings();
					//}
				//}
			//],
			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					border:false,
					padding : '10 10 5 10',
					items: [
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							text: pageIntnl30,
							width: 80,
							id: 'btnSettings',
							handler : function(obj)
							{
								me.updateADSettings();
							}
						}
					]
				}
			],
			items:[
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						align: 'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 8,
						width: 450,
						labelWidth: 220
					},
					items : [
						{
							xtype: 'radiogroup',
							fieldLabel: pageIntnl31,
							cls: 'radiobt',
							columns: 2,
							vertical: false,
							items: [
								{ boxLabel: pageIntnl15,name: 'discoverGroups',id:'discoverGroups1',inputValue: 'Yes'},
								{ boxLabel: pageIntnl16,name: 'discoverGroups',id:'discoverGroups2',inputValue: 'No',checked: true}
							]
						},
						{
							xtype:'numberfield',
							fieldLabel : pageIntnl32,
							minValue: 1,
							maxValue: 7,
							id : 'frequency',
							cls: 'textbox'
						},
						{
							xtype : 'fieldcontainer',
							fieldLabel : pageIntnl71,
							layout : 'hbox',
							items : [
								{
									xtype: 'timefield',
									name: 'timeFrom',
									id: 'timeFrom',
									format : 'H',
									width : 90,
									editable : false,
									cls : 'dropdown',
									//fieldLabel: 'Start',
									value : '00',
									minValue: '00:00',
									maxValue: '23:00',
									increment: 60
								},
								{
									xtype: 'timefield',
									name: 'timeTo',
									id: 'timeTo',
									format : 'H',
									width : 90,
									value : '00',
									editable : false,
									margin : '0 0 0 10',
									cls : 'dropdown',
									//fieldLabel: 'End',
									minValue: '00:00',
									maxValue: '23:00',
									increment: 60
								}
							]
						},
						{
							xtype: 'radiogroup',
							fieldLabel: pageIntnl72,
							cls: 'radiobt',
							columns: 2,
							vertical: false,
							items: [
								{ boxLabel: pageIntnl15,name: 'debug',id: 'debug1',inputValue: 'Yes'},
								{ boxLabel: pageIntnl16,name: 'debug',id : 'debug2',inputValue: 'No',checked: true}
							]
						},
						{
							xtype: 'radiogroup',
							fieldLabel: 'Entity (OU or SG) format',
							cls: 'radiobt',
							columns: 2,
							vertical: false,
							items: [
								{ boxLabel: 'Descriptive',name: 'entityFormat',id:'entityformat1',inputValue: 'Yes'},
								{ boxLabel: 'Concise',name: 'entityFormat',id:'entityformat2',inputValue: 'No',checked: true}
							]
						},
					]
				}
			],
			listeners : {
				'afterrender' : function() {
					Ext.Ajax.request({
						url : "ADUserReports/data/ADUserReportsJson.jsp?operationType=Settings",
						method: 'POST',
						//async: false,
						success: function(response)
						{
							var jsonText = Ext.decode(response.responseText);
							if (jsonText.settingsObject.isDiscoveryEnabled.toLowerCase() == "yes")
							{
								Ext.getCmp('discoverGroups1').setValue(true);
							}
							else
							{
								Ext.getCmp('discoverGroups2').setValue(true);
							}
							Ext.getCmp('frequency').setValue(jsonText.settingsObject.frequency);
							Ext.getCmp('timeFrom').setValue(jsonText.settingsObject.timeFrom);
							Ext.getCmp('timeTo').setValue(jsonText.settingsObject.timeTo);
							if (jsonText.settingsObject.isDebugEnabled.toLowerCase() == "yes")
							{
								Ext.getCmp('debug1').setValue(true);
							}
							else
							{
								Ext.getCmp('debug2').setValue(true);
							}

							if (jsonText.settingsObject.entityFormat.toLowerCase() == "descriptive")
							{
								Ext.getCmp('entityformat1').setValue(true);
							}
							else
							{
								Ext.getCmp('entityformat2').setValue(true);
							}
						}
					});
				}
			}
		}).show();
	},
	updateDomainDetails : function()
	{
		var me = this;
		var validationResult = me.validateDomainForm();
		if (validationResult == true)
		{
			var urlString = "";
			if (this.getDomainform().viewType == "add")
			{
				urlString = 'ADUserReports/data/ADUserReportsJsonp.jsp?ctype=Add';
			}
			else if (this.getDomainform().viewType == "modify")
			{
				urlString = "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=Modify";
			}

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			var domainForm = this.getDomainform().getForm();
			if (domainForm.isValid())
			{
				this.getDomainform().submit({
					url: urlString,
					method: 'POST',
					success: function(form, action){

						myMask.hide();
						var resultJSON = Ext.decode(action.response.responseText);
						var requestStatus = resultJSON['requestStatus'];
						if (requestStatus == "success")
						{
							var resultObj = resultJSON['result'];
							if (me.getDomainform().viewType == "add")
							{
								Ext.Msg.show({
									title: pageTitle,
									msg: resultObj.message1 + ".",
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
							else
							{
								if (resultObj.message2 == null || resultObj.message2 == 'undefined')
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: resultObj.message1+".",
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
								else
								{
									Ext.Msg.show({
										title: resultObj.title,
										msg: resultObj.message1+". "+resultObj.message2+".",
										width : 400,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
							}
							me.loadDomains();
						}
						else
						{
							var resultObj = resultJSON['errors'];
							if (resultObj.type == null || resultObj.type == 'undefined')
							{
								Ext.Msg.show({
									title: pageTitle,
									msg: resultObj.message1+".",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
							else
							{
								var errorMessageTemplate = me.getErrorMessageTemplate();
								me.showResultWindow(pageTitle,errorMessageTemplate.apply(resultObj));
							}
						}
					},
					failure: function(form, action) // if result page doest not return success:true, this method fires
					{
						switch (action.failureType) {
							case Ext.form.action.Action.CLIENT_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: "Form fields may be submitted with invalid values.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.CONNECT_FAILURE:
								Ext.Msg.show({
									title: "Failure",
									msg: "Ajax communication failed.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.SERVER_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: action.result.msg+".",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
						}
						myMask.hide();
					}
				});
			}
		}
	},
	handleDeleteSelected : function()
	{
		var me = this;
		var domainGrid = me.getDomainGridView();
		if (domainGrid.getSelectionModel().getCount() == 0)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: "No items selected.",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var selectedItems = "";
		var tmpRecords = domainGrid.getSelectionModel().getSelection();
		for (var i=0;i<domainGrid.getSelectionModel().getCount();i++)
		{
			selectedItems = selectedItems + tmpRecords[i].get("DomainName") + ",";
		}
		if (selectedItems.indexOf(",") != -1)
			selectedItems = selectedItems.substring(0,selectedItems.length-1);

		Ext.MessageBox.confirm({
			title : pageTitle,
			msg: confirmMsg,
			icon : 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			width : 400,
			fn : function(btn){
				if (btn == 'yes')
				{
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Deleting...'});
					myMask.show();
					Ext.Ajax.request({
						url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=Delete&selectedItems="+encodeURIComponent(selectedItems),
						method: 'POST',
						success: function(response)
						{
							myMask.hide();
							var jsonText = response.responseText;
							publicJSON = Ext.decode(jsonText);
							var resultObj = Ext.decode(response.responseText);
							Ext.Msg.show({
								title: pageTitle,
								msg: resultObj.result.message1+".",
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
							me.updateDomainInfo("ADUserReports/data/ADUserReportsJson.jsp");
							me.getDomainGridView().getStore().loadRawData(publicJSON.domainsStore);
						},
						failure: function()
						{
							myMask.hide();
						}
					});
				}
				else
				{
					domainGrid.getSelectionModel().deselectAll()
				}
			}
		});
	},
	configureSecurityGroups : function(grid, rowIndex, colIndex)
	{
		var me = this;
		Ext.Ajax.request({
			url : "ADUserReports/data/ADUserReportsJson.jsp?operationType=initADGroups&actDomain="+encodeURIComponent(grid.getStore().getAt(rowIndex).get("DomainName")),
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = Ext.decode(response.responseText);
				highlightGrpNode = jsonText.domainNameForGrp;
				me.loadDomainTree(grid, rowIndex, colIndex);
			}
		});
	},
	configureOUs : function(grid, rowIndex, colIndex)
	{
		var me = this;
		Ext.Ajax.request({
			url : "ADUserReports/data/ADUserReportsJson.jsp?operationType=initADOUs&actDomain="+encodeURIComponent(grid.getStore().getAt(rowIndex).get("DomainName")),
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = Ext.decode(response.responseText);
				publicOUJson = jsonText;
				highlightGrpNode = jsonText.domainNameForGrp;
				me.loadDomainOUTree(grid, rowIndex, colIndex);
			}
		});
	},
	deleteSelectedGroups : function(obj)
	{
		var me = this;
		var sgroups = Ext.getCmp('securityGrpList').getValue();
		if (Ext.isEmpty(sgroups) || Ext.getCmp('securityGrpList').getStore().getCount() == 0)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: "No items selected.",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var selectedItem = '';
		for (i=0;i<sgroups.length;i++)
		{
			if (sgroups[i] != null && sgroups[i] != "undefined")
			{
				selectedItem = selectedItem + sgroups[i] +"~$~";
			}
		}
		if (selectedItem.indexOf("~$~") != -1)
			selectedItem = selectedItem.substring(0,selectedItem.length-3);

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Deleting...'});
		myMask.show();
		Ext.Ajax.request({
			//url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=DeleteSecurityGroups&selectedItems="+encodeURIComponent(selectedItem)+"&subjectypes="+encodeURIComponent(obj.gridInstance.getStore().getAt(obj.selectedIndex).get("DomainName")),
			url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=DeleteSecurityGroups&subjectypes="+encodeURIComponent(obj.gridInstance.getStore().getAt(obj.selectedIndex).get("DomainName")),
			method: 'POST',
			timeout: 6000000,
			params: {
				'selectedItems':selectedItem,
			},
			success: function(response)
			{
				myMask.hide();
				var jsonText = Ext.decode(response.responseText);
				Ext.Msg.show({
					title: pageTitle,
					msg: jsonText.result.message1+".",
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});
				Ext.getCmp('securityGrpList').getStore().remove(Ext.getCmp('securityGrpList').getSelected());
				me.updateDomainInfo("ADUserReports/data/ADUserReportsJson.jsp");
				me.getDomainGridView().getStore().loadRawData(publicJSON.domainsStore);
				if (Ext.getCmp('securityGrpList').getStore().getCount() == 0)
				{
					Ext.getCmp('securityGrpList').hide()
					Ext.getCmp('errorDiv').show();
					Ext.getCmp('btnDelete').setDisabled(true);
					Ext.getCmp('cfgsecuritygroup').center();
				}
			},
			failure: function()
			{
				myMask.hide();
			}
		});
	},
	viewDomainDetails : function(grid, rowIndex, colIndex)
	{
		var me =this;
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.cfgsecuritygroup',
			id : 'cfgsecuritygroup',
			title : pageIntnl91,
			modal : true,
			border : false,
			floatable:true,
			floating :true,
			autoScroll:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			width: 500,
			//height: 450,
			padding:'5 10 10 10',
			//buttonAlign : 'center',
			//buttons : [
				//{
					//text: 'Delete',
					//id: 'btnDelete',
					//selectedIndex : rowIndex,
					//gridInstance : grid,
					//width: 80,
					//cls: 'quickMenuWhiteButton',
					//disabled : true,
					//handler : function(obj)
					//{
						//me.deleteSelectedGroups(obj);
					//}
				//}
			//],
			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					border:false,
					padding : '10 10 5 10',
					items: [
						{
							xtype: 'button',
							text: pageIntnl73,
							id: 'btnDelete',
							selectedIndex : rowIndex,
							gridInstance : grid,
							width: 80,
							cls: 'quickMenuWhiteButton',
							disabled : true,
							handler : function(obj)
							{
								me.deleteSelectedGroups(obj);
							}
						}
					]
				}
			],
			items:[
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items : [
						{
							xtype: 'multiselectfield',
							flex : 1,
							height: 350,
							margin: 5,
							cls:'multiselect',
							id: 'securityGrpList',
							autoScroll : true,
							scroll : true,
							hidden : true,
							store: Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							}),
							//listConfig:{
							//	tpl : '<tpl for="."><div class="x-boundlist-item" data-qtip={valueField}><span>{displayField}</span></div></tpl>'
								//tpl : '<tpl for="."><div class="x-boundlist-item" data-qtip={valueField}><img src="/final/images/clear.png" class="iconOU"/><span>{displayField}</span></div></tpl>'
							//},
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local'
						},
						{
							xtype : 'component',
							id : 'errorDiv',
							border : false,
							hidden : true,
							style : {'text-align':'center'},
							html : '<div class = "iconExclamation" style="margin:28% auto auto auto"></div><div style="margin-bottom:28%">'+pageIntnl89+'.</b></div>'
						}
					]
				}
			],
			listeners : {
				'afterrender' : function() {
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
					myMask.show();
					var me = this;
					var gridDisplayName = grid.getStore().getAt(rowIndex).get("DomainName");
					Ext.Ajax.request({
						url : "ADUserReports/data/ADUserReportsJson.jsp?operationType=getADGroups&actDomain="+encodeURIComponent(grid.getStore().getAt(rowIndex).get("DomainName")),
						method: 'POST',
						async: false,
						success: function(response)
						{
							myMask.hide();

							Ext.getCmp('cfgsecuritygroup').setTitle(pageIntnl91 +" "+gridDisplayName)
							var jsonText = Ext.decode(response.responseText);
							if (!Ext.isEmpty(jsonText.securityGrpList))
							{
								Ext.getCmp('securityGrpList').getStore().loadRawData(jsonText.securityGrpList);
								Ext.getCmp('securityGrpList').show()
								Ext.getCmp('errorDiv').hide();
								Ext.getCmp('btnDelete').setDisabled(false);
							}
							else
							{
								Ext.getCmp('securityGrpList').hide()
								Ext.getCmp('errorDiv').show();
								Ext.getCmp('btnDelete').setDisabled(true);
							}
						},
						failure : function()
						{
							myMask.hide();
						}
					});
				}
			}
		}).show();
	},
	viewSelected : function()
	{
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.viewSelections',
			title : pageIntnl2,
			id:'viewWindow',
			width: 350,
			height: 470,
			modal : true,
			resizable : false,
			border : false,
			floatable:true,
			floating :true,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					var isGroupsAvaibale = false;
					var htmlInput = "<div class='x-table' style='width:100%'><table width='100%' align='left' class='x-grid-table' cellpadding='5' cellspacing='0' style='border:1px solid #c3c3c3'>";
					for (i=0;i<groupArray.length;i++)
					{
						if (groupArray[i] != null && groupArray[i] != "undefined")
						{
							isGroupsAvaibale = true;
							htmlInput = htmlInput + "<tr class='x-grid-row'><td align='left' class='x-grid-cell x-grid-cell-first' ><div class='x-grid-cell-inner' >"+groupArray[i].replace(/</g,"&lt;").replace(/>/g,"&gt;")+"<div></td></tr>";
						}
					}
					htmlInput = htmlInput +"</table></div>";
					if (isGroupsAvaibale)
					{
						Ext.getCmp('baseContainer').update(htmlInput);
					}
				}
			},
			items:[{
				xtype : 'panel',
				id : 'baseContainer',
				border : false,
				style : {'text-align':'center'},
				html : '<div class = "iconExclamation" style="margin:50% auto auto auto"></div><div style="text-align:center">'+pageIntnl28+'.</b></div>'
			}]
		}).show();
	},
	viewSelectedOUAndSG : function()
	{
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.viewSelections',
			title : pageIntnl2,
			id:'viewWindow',
			width: 500,
			height: 460,
			modal : true,
			resizable : false,
			border : false,
			floatable:true,
			floating :true,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					var isGroupsAvaibale = false;
					var htmlInput = "<div class='x-table' style='width:100%'><table width='100%' align='left' class='x-grid-table' cellpadding='5' cellspacing='0' style='border:1px solid #c3c3c3'>";
					for (i=0;i<groupArray.length;i++)
					{
						if (groupArray[i] != null && groupArray[i] != "undefined")
						{
							var strDispVal = groupArray[i];
							var strDescriptiveVal = groupArray[i];
							if (strDispVal.indexOf(",") != -1)
							{
								strDispVal = strDispVal.substring(0,strDispVal.indexOf(","));
								strDispVal = strDispVal.substring(strDispVal.indexOf("=")+1);
							}

							if (publicOUJson.isShowConciseFormat)
							{
								strDescriptiveVal = strDispVal;
							}
							else
							{
								strDescriptiveVal = strDescriptiveVal.substring(0,strDescriptiveVal.indexOf(",DC"));
								strDescriptiveVal = strDispVal+" ("+strDescriptiveVal+")";
							}

							isGroupsAvaibale = true;
							htmlInput = htmlInput + "<tr class='x-grid-row'><td align='left' class='x-grid-cell x-grid-cell-first' ><div class='x-grid-cell-inner' title="+groupArray[i]+">"+strDescriptiveVal.replace(/</g,"&lt;").replace(/>/g,"&gt;")+"<div></td></tr>";
						}
					}
					htmlInput = htmlInput +"</table></div>";
					if (isGroupsAvaibale)
					{
						Ext.getCmp('baseContainer').update(htmlInput);
					}
				}
			},
			items:[{
				xtype : 'panel',
				id : 'baseContainer',
				border : false,
				style : {'text-align':'center'},
				html : '<div class = "iconExclamation" style="margin:40% auto auto auto"></div><div style="text-align:center">'+pageIntnl28+'.</b></div>'
			}]
		}).show();
	},
	loadDomainTree : function(grid, rowIndex, colIndex)
	{
		var me = this;
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.groupWindow',
			title : pageIntnl5,
			id:'groupWindow',
			padding : '5px 10px 10px 10px',
			modal : true,
			border : false,
			floatable:true,
			floating :true,
			autoScroll:false,
			closeAction: 'destory',
			doClose: function() {
				groupArray = new Array();
				this.destroy();
			},
			layout:{
				type:'auto',
			},
			items:[{
				width: 900,
				height: 450,
				xtype : 'egdomaingrouptree',
				selectedDomainDisplayName : grid.getStore().getAt(rowIndex).get("DomainName")
			},
			{
				xtype: 'button',
				text: pageIntnl6,
				id: 'viewSelect',
				width: 100,
				cls:'button20',
				margin: '2 0 10 360',
				handler: me.viewSelected
			},
			{
				xtype: 'button',
				text: pageIntnl30,
				gridIns : grid,
				rowIndex : rowIndex,
				id: 'applyBtn',
				width: 80,
				cls:'button20',
				margin: '2 0 10 20',
				handler: me.saveGrpNames
			}]
		}).show();
	},
	loadDomainOUTree : function(grid, rowIndex, colIndex)
	{
		var me = this;
		Ext.widget("window",{
			extend:'Ext.container.Container',
			alias:'widget.groupWindow',
			title : pageIntnl5,
			id:'groupWindow',
			padding : '5px 10px 10px 10px',
			modal : true,
			border : false,
			floatable:true,
			floating :true,
			autoHeight: true,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				groupArray = new Array();
				this.destroy();
			},
			layout:{
				type:'auto',
			},
			items:[{
				width: 900,
				height: 450,
				xtype : 'egdomainoutree',
				selectedDomainDisplayName : grid.getStore().getAt(rowIndex).get("DomainName")
			},
			{
				xtype: 'button',
				text: pageIntnl6,
				id: 'viewSelect',
				width: 100,
				cls:'button20',
				margin: '2 0 10 360',
				handler: me.viewSelectedOUAndSG
			},
			{
				xtype: 'button',
				text: pageIntnl30,
				gridIns : grid,
				rowIndex : rowIndex,
				id: 'applyBtn',
				width: 80,
				cls:'button20',
				margin: '2 0 10 20',
				handler: me.saveOUNames
			}]
		}).show();
		//document.getElementById('iframeCenter').src = publicOUJson.defaultURL+"&date="+new Date().getTime();
	},
	saveGrpNames : function(obj)
	{
		var me = this;
		var displayItem = "";
		for (i=0;i<groupArray.length;i++)
		{
			if (groupArray[i] != null && groupArray[i] != "undefined")
			{
				displayItem = displayItem + groupArray[i] +",";
			}
		}
		if (displayItem.indexOf(",") != -1)
			displayItem = displayItem.substring(0,displayItem.length-1);

		if (Ext.isEmpty(displayItem))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: "No items selected.",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=SaveSecurityGroups&selectedItems="+encodeURIComponent(displayItem)+"&subjectypes="+encodeURIComponent(obj.gridIns.getStore().getAt(obj.rowIndex).get("DomainName")),
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = Ext.decode(response.responseText);
				Ext.Msg.show({
					title: pageTitle,
					msg: jsonText.result.message1+".",
					buttons: Ext.Msg.OK,
					fn : function(btn){
						if (btn == 'ok')
						{
							groupArray = new Array();
							Ext.getCmp('groupWindow').destroy();
							appCnt.updateDomainInfo("ADUserReports/data/ADUserReportsJson.jsp");
							appCnt.getDomainGridView().getStore().loadRawData(publicJSON.domainsStore);
						}
					},
					icon: 'iconInformation'
				});
			},
			failure: function()
			{
				myMask.hide();
			}
		});
	},
	saveOUNames : function(obj)
	{
		var me = this;
		var displayItem = "";
		var selectedItems = '';
		for (i=0;i<groupArray.length;i++)
		{
			if (groupArray[i] != null && groupArray[i] != "undefined")
			{
				var tmpItem = groupArray[i];
				displayItem = displayItem + groupArray[i] +"~$~";
				
				if (tmpItem != null && tmpItem != "undefined" && tmpItem.indexOf(",") != -1)
				{
					tmpItem = tmpItem.substring(0,tmpItem.indexOf(','));
				}
				selectedItems = selectedItems + tmpItem +",";
			}
		}
		if (displayItem.indexOf("~$~") != -1)
			displayItem = displayItem.substring(0,displayItem.length-3);
		if (selectedItems.indexOf(",") != -1)
			selectedItems = selectedItems.substring(0,selectedItems.length-1);

		if (Ext.isEmpty(displayItem))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: "No items selected.",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			//url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=SaveSecurityGroups&selectedItems="+encodeURIComponent(selectedItems)+"&selectedHierarchyItems="+encodeURIComponent(displayItem)+"&subjectypes="+encodeURIComponent(obj.gridIns.getStore().getAt(obj.rowIndex).get("DomainName")),
			url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=SaveSecurityGroups&subjectypes="+encodeURIComponent(obj.gridIns.getStore().getAt(obj.rowIndex).get("DomainName")),
			method: 'POST',
			timeout:120000,
			params: {
				'selectedItems' : selectedItems,
				'selectedHierarchyItems' : displayItem
			},
			success: function(response)
			{
				myMask.hide();
				var jsonText = Ext.decode(response.responseText);
				Ext.Msg.show({
					title: pageTitle,
					msg: jsonText.result.message1+".",
					buttons: Ext.Msg.OK,
					fn : function(btn){
						if (btn == 'ok')
						{
							groupArray = new Array();
							Ext.getCmp('groupWindow').destroy();
							appCnt.updateDomainInfo("ADUserReports/data/ADUserReportsJson.jsp");
							appCnt.getDomainGridView().getStore().loadRawData(publicJSON.domainsStore);
						}
					},
					icon: 'iconInformation'
				});
			},
			failure: function()
			{
				myMask.hide();
			}
		});
	},
	saveAllOUNames : function(obj,isSelectText)
	{
		var me = this;
		var displayItem = "";
		var selectedItems = isSelectText;

		if (selectedItems.indexOf(",") != -1)
			selectedItems = selectedItems.substring(0,selectedItems.length-1);

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			url : "ADUserReports/data/ADUserReportsJsonp.jsp?ctype=SaveSecurityGroups&subjectypes="+encodeURIComponent(obj.gridIns.getStore().getAt(obj.rowIndex).get("DomainName")),
			method: 'POST',
			timeout:120000,
			params: {
				'selectedItems' : selectedItems,
			},
			success: function(response)
			{
				myMask.hide();
				var jsonText = Ext.decode(response.responseText);
				Ext.Msg.show({
					title: pageTitle,
					msg: jsonText.result.message1+".",
					buttons: Ext.Msg.OK,
					fn : function(btn){
						if (btn == 'ok')
						{
							groupArray = new Array();
							Ext.getCmp('groupWindow').destroy();
							appCnt.updateDomainInfo("ADUserReports/data/ADUserReportsJson.jsp");
							appCnt.getDomainGridView().getStore().loadRawData(publicJSON.domainsStore);
						}
					},
					icon: 'iconInformation'
				});
			},
			failure: function()
			{
				myMask.hide();
			}
		});
	},
	updateDomainInfo : function(domainURL)
	{
		Ext.Ajax.request({
			url : domainURL,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	showResultWindow : function(title,resultText)
	{
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			bodyPadding : 20,
			scroll: true,
			width : 700,
			modal : true,
			autoScroll: true,
			doClose: function() {
				this.destroy();
			},
			html: resultText
		}).show();
	},
	validateADServerCredentials : function(obj)
	{
		var me = this;
		obj.setDisabled(true);
		var validationResult = this.validateDomainForm();
		if (validationResult == true)
		{
			var validationLoadingMsg = "<table width='670' border='0' height='170px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top>Validating domain server credentials...<br>This may take a few minutes...</td></tr></table>";
			var winObj = Ext.getCmp('validateAdServer');
			Ext.create('EgConfigureDomains.view.Mywindow',{
				title:'Validating AD server credentials', 
				closeAction: 'destory',
				id : 'validateAdServer',
				html:validationLoadingMsg,
				height:250,
				align : 'center',
				width:700,
				padding:'5 10 10 10',
				modal: true,
				autoScroll : true,
				listeners : {
					'afterrender': function()
					{
						me.validateDomainCredentials();
					}
				},
				scroll : true,
				doClose: function() {
					obj.setDisabled(false);
					this.destroy();
				},
			}).show();
			//this.validateDomainCredentials();
		}
		else
		{
			obj.setDisabled(false);
		}
	},
	validateDomainCredentials : function()
	{
		var me = this;
		var frmAddDomain = this.getDomainform().getForm();
		var url = "EgConfigureDomains/data/validateADServerCredentials.jsp?";
		var displayName = Ext.getCmp("subjectypes").getValue();
		var domain_Name = Ext.getCmp("domnam").getValue();
		var domain_User = Ext.getCmp("duser").getValue();
		var domain_Pwd = Ext.getCmp("newpwd").getValue();
		var dnsMode = '';
		var ssl = '';
		var serverIP = '';
		var port = '';
		if (frmAddDomain.findField('dns').getValue())
		{
			dnsMode = "Yes";
		}
		else
		{
			serverIP = Ext.getCmp("dmnip").getValue();
			port = Ext.getCmp("prtno").getValue();
			dnsMode = "no";
		}
		if (frmAddDomain.findField('sslEnabled').getValue())
		{
			ssl = "Yes";
		}
		else
		{
			ssl = "no";
		}
		var params = "domainDisName="+displayName+"&domainName="+domain_Name+"&domain_User="+encodeURIComponent(domain_User)+"&domain_Pwd="+encodeURIComponent(domain_Pwd)+"&ssl="+ssl+"&dnsMode="+dnsMode+"&serverIP="+serverIP+"&port="+port+"&opt="+c_type;
		url = url + params;

		Ext.Ajax.request({
			url : url,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				Ext.getCmp('validateAdServer').update(jsonText);
			}
		});
	},
	afterMainRender : function(obj)
	{
		var me = this;
		if (publicJSON.hasDomains)
		{
			me.getDomainGridView().getStore().loadRawData(publicJSON.domainsStore);
		}
	},
	getHiddenFields : function()
	{
		hiddenQstr = "";
		var hiddenFields = publicJSON['hiddenFields'];
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	changeToUpperCase : function(obj)
	{
		var domName = Ext.getCmp('domnam').getValue();
		var domName = domName.toUpperCase();
		Ext.getCmp('domnam').setValue(domName);
	},
	modifyDomainDetails : function(grid, rowIndex, colIndex)
	{
		var record = grid.getStore().getAt(rowIndex);
		var viewContainer = this.getViewport();
		viewContainer.removeAll();
		viewContainer.add({
			xtype:'domainform',
			viewType : 'modify'
		});

		Ext.getCmp('subjectypes').setReadOnly(true);
		Ext.getCmp('subjectypes').setValue(record.get("DomainName"));

		Ext.getCmp('domnam').setValue(record.get("FQDomainName"));
		Ext.getCmp('duser').setValue(record.get("DomainUser"));
		Ext.getCmp('newpwd').setValue(record.get("DomainPwd"));
		Ext.getCmp('prtno').setValue(record.get("PortNo"));

		if (record.get("SSL").toLowerCase() == "true" || record.get("SSL").toLowerCase() == "yes")
		{
			Ext.getCmp('sslEnabled').setValue(true);
		}
		else
		{
			Ext.getCmp('sslEnabled1').setValue(true);
		}
	},
	getErrorMessageTemplate :function()
	{
		 var tabledata = new Ext.XTemplate(
			'<div class="x-table" style="width:100%">',
			'<table cellspacing="0" width="100%" cellpadding="5" border="0" align="center" class="x-grid-table" style="border:1px solid #c3c3c3"><col width="20%"><col width="70%">',
				'<thead>',
					'<tr class="x-grid-row">',
						'<th colspan="2" class=" x-grid-cell">',
							'<div class="x-grid-cell-inner">Error : '+pageIntnl75+'</div>',
						'</th>',
					'</tr>',
				'</thead>',
			'<tbody>',
			'<tpl for=".">',
				'<tr class="x-grid-row">',
					'<td class=" x-grid-cell x-grid-cell-first">',
						'<div class="x-grid-cell-inner" ><b>'+pageIntnl76+'</b></div>',
					'</td>',
					'<td class="x-grid-cell x-grid-cell-first">',
						'<div class="x-grid-cell-inner" >{ERROR}</div>',
					'</td>',
				'</tr>',
				'<tr class="x-grid-row">', 
					'<td class="x-grid-cell">', 
						'<div class="x-grid-cell-inner"><b>'+pageIntnl77+'</b></div>', 
					'</td>', 
					'<td class="x-grid-cell">', 
						'<div class="x-grid-cell-inner" >{DESCRIPTION}</div>', 
					'</td>', 
				'</tr>',
				'<tr class="x-grid-row">', 
					'<td class="x-grid-cell">', 
						'<div class="x-grid-cell-inner"><b>'+pageIntnl78+'</b></div>', 
					'</td>', 
					'<td class="x-grid-cell">', 
						'<div class="x-grid-cell-inner" >{RESOLUTION}</div>', 
					'</td>', 
				'</tr>', 
			'</tpl>', 
			'</tbody>', 
			'</table>', 
			'</div>'
		);
		return tabledata;
	},
	addNewDomain : function()
	{
		var viewContainer = this.getViewport();
		viewContainer.removeAll();
		viewContainer.add({
			xtype:'domainform',
			viewType : 'add'
		});
	},
	validateDomainForm : function()
	{
		var splChar3 = " `~!#$%^&*()+=[]{}|\\:;\"\'<>,?\/.@";
		var d_name = Ext.getCmp('domnam').getValue();
		var subjectypes = Ext.getCmp('subjectypes');
		var domnam = Ext.getCmp('domnam');
		var duser = Ext.getCmp('duser');
		var newpwd = Ext.getCmp('newpwd');
		var prtno = Ext.getCmp('prtno');

		if(!checkblank(subjectypes.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl33 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(subjectypes.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl34 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecialnomess(subjectypes.getValue(),splChar3))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl35 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if (parseInt(subjectypes.getValue()) < 0)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl36 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if(!checkblank(domnam.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl37 + ".",
				buttons: Ext.Msg.OK,
				//width : 300,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(domnam.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl38 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecialnomess(domnam.getValue()," !\"#$&()*+\':;<=>?@[\]^'{|}~,"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl39 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if ((domnam.getValue()).charAt((domnam.getValue()).length-1) == ".")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _domainPeriod + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if(d_name.indexOf(".") == -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl40 + ".",
				buttons: Ext.Msg.OK,
				width : 300,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if (!checkNonNumericals(domnam.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _aplhabets + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
				else if(!checkblank(prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl48 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false;
		}
		else if(!checknumber("+",prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl49 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false;
		}
		else if(!checkfordecimal(prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl50 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false
		}
		else if(prtno.getValue() == "0")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl51 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false
		}
		else if(!checkspace(prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl52 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false
		}
		else if(!checkblank(duser.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl41 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecial(duser.getValue(),"@*+=|:;\"\'<>\/[]?,"))
		{
			duser.focus(true);
			return false;
		}
		else if(trim(duser.getValue()) == "")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl42 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(duser.getValue().indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkdots + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if ((duser.getValue()).indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkSpaces + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(duser.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl43 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(newpwd.getValue() == "")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl44 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		else if(!checkblank(newpwd.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl44 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecialnomess(newpwd.getValue(),"\"|"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _notAllowCharInPwd + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(newpwd.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl45 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		return true;
	}
});

function setWindowTitle(title)
{
	Ext.getCmp('rightPane').setTitle(title);
}

function setSelectedGroupName(grpName)
{
}



