Ext.define('AdvanceSearch.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Firstpanel'],
	views:['TotalResultGrid'],
	requires : ['AdvanceSearch.view.TotalResultGrid'],
	refs:[
		{selector:'firstpanel', ref:'firstpanel'},
		{selector:'totalResult', ref:'totalResult'},
		
	],
	init:function(){
		appCtn = this;
		temp=0;
		displayOnly='yes';
		this.buildFieldData()
		this.control({
			
			'firstpanel':
			{
				'afterrender': this.afterMainRender,
			},
			'firstpanel button[id="setRefreshon"]':
			{
				'click': this.setRefreshOn
			},
			'firstpanel button[id="Clear"]':
			{
				'click': this.Clear
			},
			'firstpanel button[id="Search"]':
			{
				'click': this.Search
			},
			'firstpanel combo[id="searchCriteria"]':
			{
				'select': this.changeSearchOption
			},
			'firstpanel button[id="csv"]':
			{
				'click': this.saveInCSVFormat
			},
			'firstpanel combo[id="compType"]':
			{
				'select': this.changeCompType
			}
		});
	},
	changeSearchOption: function(obj) {
		var selectedValue = obj.value;

		if (!Ext.isEmpty(selectedValue) && selectedValue != undefined && selectedValue == 'Component/Agent Type')
		{
			Ext.getCmp('fetchIPContainer').hide();
			Ext.getCmp('fetchCompContainer').show();
			Ext.getCmp('comp_Name').reset();
			Ext.getCmp('compType').reset();
			Ext.getCmp('compType').setValue('all');
			Ext.getCmp('status').reset();
			Ext.getCmp('status').setValue('All');
			Ext.getCmp('agent_version').reset(); //fix
			Ext.getCmp('agent_version').setValue('All'); //fix
		}
		else if (!Ext.isEmpty(selectedValue) && selectedValue != undefined && selectedValue == 'IP Address')
		{
			Ext.getCmp('fetchCompContainer').hide();
			Ext.getCmp('fetchIPContainer').show();
			Ext.getCmp('Rangefrom').reset();
			Ext.getCmp('RangeTo').reset();
		}

		var SetRefreshOn = publicJSON['screenLabels']['Set Refresh On'];
		Ext.getCmp('setRefreshon').setText(SetRefreshOn);
		var resultContainerObj = Ext.getCmp('resultContainer');
		if (!Ext.isEmpty(resultContainerObj) && resultContainerObj != undefined )
		{
			Ext.getCmp("labelContainer1").hide();
			resultContainerObj.removeAll();
			resultContainerObj.hide();
		}

	},
	buildFieldData: function(){

		Ext.Ajax.request(
		{
			url:'/final/admin/AdvanceSearch/data/AdvanceSearchJSON.jsp',
			params : 'sessionId='+sessionId,
			method:'POST',
			timeout: 300000,
			async:false,
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		this.loadFields();
		var selectedAgentIDs = "";
		var selected_indices="";
		var SetRefreshOn = publicJSON['screenLabels']['Set Refresh On'];
		var SetRefreshOff = publicJSON['screenLabels']['Set Refresh Off'];
		var Search = publicJSON['screenLabels']['Search'];
		var Clear = publicJSON['screenLabels']['Clear'];
		temp =  publicJSON['screenLabels']['refreshTime'];
		
		Ext.getCmp('compGroup').hide();
		Ext.getCmp('status').setValue('All');
		Ext.getCmp('Search').setText(Search);
		Ext.getCmp('Clear').setText(Clear);
		Ext.getCmp('setRefreshon').setText(SetRefreshOn);
	},
	saveInCSVFormat: function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language=en_US";//+trackerLanguage;
	},
	loadFields:function()
	{
		
		var me=this;
		var isGroupCreated = publicJSON['groupListArr'] && publicJSON['groupListArr'].length >0;
		var selectedServerType = publicJSON['cmpt_type'];
		var executiveForm = this.getFirstpanel().getForm();
		if (selectedServerType == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['cmpt_type'],'');
			me.setValueWithOptionInList(executiveForm, 'agent_version', publicJSON['versionArr'],'');
			if(isGroupCreated)
				me.setValueWithOptionInList(executiveForm, 'compGroup', publicJSON['groupListArr'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['cmpt_type'],'');
			me.setValueWithOptionInList(executiveForm, 'agent_version', publicJSON['versionArr'],'');
			if(isGroupCreated)
				me.setValueWithOptionInList(executiveForm, 'compGroup', publicJSON['groupListArr'],'');
		}
		Ext.getCmp('status').getStore().loadRawData(publicJSON['statusVal']);
	},
	setValueWithOptionInList : function(form, fieldName, list, value){
		
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
		
	},
	changeCompType: function()
	{
		var compTypeValue = Ext.getCmp('compType').getValue();
		if(compTypeValue == 'Component_Groups')
		{
			Ext.getCmp('compGroup').show();
		}
		else
		{
			Ext.getCmp('compGroup').hide();
		}
	},
	Clear: function()
	{
		//window.location.reload();
		this.changeSearchOption(Ext.getCmp('searchCriteria'));
	},
	Search: function()
	{
		displayOnly='yes';
		fieldsValidate('search');
	},
	setRefreshOn:function(obj)
	{
		displayOnly='yes';
		fieldsValidate('refresh');
	},
	setAutoUpgrade: function(label)
	{
		displayOnly='no';
		this.update(label);
	},
	resetAutoUpgrade:function(label)
	{
		displayOnly='no';
		this.update(label);
	},
	upgradenow:function(label)
	{
		displayOnly='no';
		this.update(label);
	},
	cancel_upgrade_now: function(label)
	{
		displayOnly='no';
		this.update(label);
	},
	update: function(label)
	{
		var id="";
		var grid_id="";
		var values="";
		var grid="";
		g_label=label;
		selectedAgentIDs="";
		default_upgrade_now_enabled="";
		selected_indices="";
		var array=new Array();
		grid=Ext.getCmp('TotalGridValues').getSelectionModel().getSelection();
		if(grid=="")
		{
			Ext.MessageBox.alert(pageTitle,agentNotSelected);
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('id');
			if(id!=null)
			{
				array.push(id);
			}
		}
		var alertUser = false;
		var selectedObj = Ext.getCmp('TotalGridValues').getSelectionModel();
		var gridStore = Ext.getCmp('TotalGridValues').getStore();
		for(var i = 0;i<gridStore.getCount();i++)
		{
			if(selectedObj.isSelected(gridStore.getAt(i)) )
			{
				var autoUpgrade_str = gridStore.getAt(i).get('autoUpgrade').trim();
				var upgradeNow_str = gridStore.getAt(i).get('upgradeNow').trim();
				if(autoUpgrade_str=='Disabled' && upgradeNow_str=='Disabled')
				{
					alertUser = true;
					break;
				}
			}
		}

		for(var j=0; j < array.length; j++)
		{
			selectedAgentIDs +=array[j]+"$";
		}
		if(selectedAgentIDs.length>0)
		{
			if(label=='upgradeNow' && alertUser)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: agent_msg,
					buttons: Ext.Msg.YESNO,
					icon: 'iconConfirmation',
					fn: function(buttonText)
					{
						if(buttonText == "yes")
						{
							selectedAgentIDs = selectedAgentIDs.substring(0,selectedAgentIDs.lastIndexOf("$"));
							g_label = label;
							default_upgrade_now_enabled = "Yes";
							goes('update');
						}
						else if(buttonText=="no")
						{
							selectedAgentIDs = selectedAgentIDs.substring(0,selectedAgentIDs.lastIndexOf("$"));
							g_label = label;
							default_upgrade_now_enabled = "No";
							goes('update');
						}
					}
				});
			}
			else
			{
				selectedAgentIDs = selectedAgentIDs.substring(0,selectedAgentIDs.lastIndexOf("$"));
				g_label = label;
				goes('update');
			}
		}
	}
});


//var temp = tmpStr;
var timerID = 0;
var tStart  = null;
var isStarted = "false";
function displayTime()
{
	isStarted = "true";
	num = parseInt(temp);
	var hour = 0;
	var min = 0;
	var sec = 0;
	tseconds = parseInt(num/1000);
	if(parseInt(tseconds)>=3600)
	hour = parseInt(tseconds /3600);
	tseconds = parseInt(tseconds) - parseInt(hour) * 3600 ;
	if(parseInt(tseconds)>=60)
	min = parseInt(tseconds /60);

	sec = tseconds % 60;

	var timeString="";

	if(parseInt(hour)>0)
	{
		if(parseInt(hour)<2)
		{
			timeString = '0' + hour + " "+hourLabel+" ";
		}
		else if(parseInt(hour)<10)
		{
			timeString = '0' + hour + " "+hoursLabel+" ";
		}
		else
		{
			timeString = hour + " "+hoursLabel+" ";
		}
	}

	if(parseInt(min)>0)
	{
		if(parseInt(min)<2)
		{
			timeString += '0' + min + " "+minLabel+" ";
		}
		else if(parseInt(min)<10)
		{
			timeString += '0' + min + " "+minsLabel+" ";
		}
		else
		{
			timeString += min + " "+minsLabel+" ";
		}
	}

	if(parseInt(sec)>0)
	{
		if(parseInt(sec)<2)
		{
			timeString += '0' + sec + " "+secLabel;
		}
		else if(parseInt(sec)<10)
		{
			timeString += '0' + sec + " "+secsLabel;
		}
		else
		{
			timeString += sec + " "+secsLabel;
		}
	}
	Ext.getCmp('setTime').setValue(setTimeLabel+timeString);
	if(num==0)
	{
		temp =  publicJSON['screenLabels']['refreshTime'];
		num = parseInt(temp);
	}
	temp = (parseInt(temp)-1000);
	setTimeout('displayTime()', 1000);
	if(timeString =="")
	{
		UpdateTimer();
	}
}

function fieldsValidate(buttonFrom,obj)
{
	var SetRefreshOn = publicJSON['screenLabels']['Set Refresh On'];
	var SetRefreshOff = publicJSON['screenLabels']['Set Refresh Off'];
	var button_val =Ext.getCmp('setRefreshon').value;
	var searchCriteria_val = Ext.getCmp('searchCriteria').value;
	if(buttonFrom == "refresh"  && button_val == "0")
	{
		Ext.getCmp('setRefreshon').setText(SetRefreshOn);
		Ext.getCmp('setRefreshon').value="1";
		Ext.getCmp("labelContainer1").hide();
	}
	else
	{
		var ipRangeFromField=Ext.getCmp('Rangefrom').getValue();
		var ipRangeToField=Ext.getCmp('RangeTo').getValue();
		if(ipRangeFromField == "" && ipRangeToField =="")
		{
			if (!Ext.isEmpty(searchCriteria_val) && searchCriteria_val == 'IP Address')
			{
				Ext.MessageBox.alert(pageTitle,Empty_fields);
			}
			else
			{
				//alert('else part of ip address goes method...');
				goes(buttonFrom);
			}
		}
		else if(ipRangeFromField !="" && ipRangeToField=="" )
		{
			var checkIP=isValidIPAddress(ipRangeFromField);
			if(checkIP==true)
			{
				goes(buttonFrom);
			}
			else
			{
				Ext.MessageBox.alert(pageTitle,FromIP_notValid);
			}
		}
		else if(ipRangeFromField!="" && ipRangeToField !="")
		{
			var checkFromIP=isValidIPAddress(ipRangeFromField);
			var checkToIP=isValidIPAddress(ipRangeToField);
			var FromIPArray = new Array();
			var ToIPArray = new Array();
			var fromIP="";
			var toIP="";			
			FromIPArray = ipRangeFromField.split(".");
			ToIPArray = ipRangeToField.split(".");
			for(var m=0; m < FromIPArray.length; m++) 
			{
				fromIP = parseInt(FromIPArray[m],10);
				toIP = parseInt(ToIPArray[m],10);
				if(toIP > fromIP)
				{
					break;
				}
				else if(toIP < fromIP)
				{
					Ext.MessageBox.alert(pageTitle,Invalid_range);
					return;
				}
			}
			if(checkFromIP == true && checkToIP==true)
			{
				goes(buttonFrom);
			}
			else 
			{
				if(checkToIP == false)
				{
					Ext.MessageBox.alert(pageTitle,ToIP_notValid);
				}
				if(checkFromIP == false)
				{
					Ext.MessageBox.alert(pageTitle,FromIP_notValid);
				}
			}
		}
		else if(ipRangeFromField=="" && ipRangeToField!="")
		{
			var checkToIP=isValidIPAddress(ipRangeToField);			
			if(checkToIP == false)
			{
				Ext.MessageBox.alert(pageTitle,ToIP_notValid);
			}
			Ext.MessageBox.alert(pageTitle,Empty_fields);
		}
	}
	
}
function goes(fromFunction)
{
	var to_result = "true";
	var from_result = "true";
	var groupName = null;
	var nickname =  Ext.getCmp('comp_Name').getValue();
	var to = '';//Ext.getCmp('RangeTo').getValue();
	var from = '';//Ext.getCmp('Rangefrom').getValue();
	if(Ext.getCmp('searchCriteria').value=='IP Address')
	{
		to = Ext.getCmp('RangeTo').getValue();
		from =  Ext.getCmp('Rangefrom').getValue();
	}
	var servertype=Ext.getCmp('compType').getValue();
	if(servertype == 'Component_Groups')
	{
		groupName = Ext.getCmp('compGroup').getValue();
	}
	var status = Ext.getCmp('status').getValue();
	var s_agent_version = Ext.getCmp('agent_version').getValue();
	var choice ="Range";
	var SetRefreshOn = publicJSON['screenLabels']['Set Refresh On'];
	var SetRefreshOff = publicJSON['screenLabels']['Set Refresh Off'];
	if(from.length == 0 && to.length==0)
	{
		choice="Single";
	}
	if(from.length > 0 && to.length==0)
	{
		choice="Single";
	}
	if(from.length > 0 && to.length > 0)
	{
		choice="Range";
	}
	if(from.length > 0 && !isValidIPAddress(from))
	{
		from_result = "false";
		Ext.MessageBox.alert(pageTitle,FromIP_notValid);
	}
	if(to.length > 0 && !isValidIPAddress(to))
	{
		to_result = "false";
		Ext.MessageBox.alert(pageTitle,ToIP_notValid);
	}
	if(from_result=="true" && to_result=="true" )
	{
		if(from.length >0)
		{
			nickname = '';
			servertype = 'all';
			status = 'all';
		}
		//alert("nickname = "+nickname+"\n"+"to = "+to+"\n"+"from  ="+from+"\n"+"choice ="+choice+"\n"+"status ="+status+"\n"+"option="+g_label+"\n"+"sai  ="+selectedAgentIDs+"\n"+"default_upgrade_now_enabled="+default_upgrade_now_enabled+"\n"+"&sessionId="+sessionId);
		Ext.getCmp("csv").setDisabled(true);
		var param= "servertype="+servertype+"&status="+status+"&choice="+choice+"&from="+from+"&to="+to+"&nickname="+nickname+"&option="+g_label+"&sai="+selectedAgentIDs+"&default_upgrade_now_enabled="+default_upgrade_now_enabled+"&sessionId="+sessionId+"&gridrequest=ok&s_agent_version="+s_agent_version+"&displayOnly="+displayOnly;
		if(groupName != null)
		{
			param += "&groupName="+groupName;
		}
		Ext.Ajax.request(
		{	
			url:'../admin/AdvanceSearch/data/AdvanceSearchJSON.jsp',
			params:param,
			method: 'POST',
			timeout: 300000,
			success: function(response)
			{
				if(response.status == 200 & !Ext.isEmpty(response.responseText))
				{
					var button_val=Ext.getCmp('setRefreshon').value;
					var jsonText=response.responseText;
					publicJSON=Ext.decode(jsonText);
					var resultsData = publicJSON['gridValues'];
					var totalresult=  publicJSON['total_Result'];
					if (Ext.isEmpty(resultsData))	
					{	
						if(fromFunction == "search") 
						{
							Ext.getCmp("labelContainer1").hide();
						}
						if(button_val == "0"  && fromFunction == "refresh" )
						{
							Ext.getCmp('setRefreshon').setText(SetRefreshOn);
							Ext.getCmp('setRefreshon').value="1";
							Ext.getCmp("labelContainer1").hide();
						}
						else
						{
							if (fromFunction == "refresh" || fromFunction == "refreshAgain")
							{
								if(button_val=="1")
								{
									refresh_this_page("refresh");
									Ext.getCmp("labelContainer1").hide();
								}
							}
							var resultContainer = Ext.getCmp('resultContainer');
							resultContainer.removeAll();
							resultContainer.add({
						
							xtype:'component',
							height:170,
							width:900,
							margin:'0 60 0 60',
							padding:10,
							border: false,
							style:{'text-align':'center'},
							html:"<div style='margin:7% auto auto auto'><table border='0' height='250' width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+noAgents+".</div></td></tr></table></div>"
							});
							resultContainer.show();
						}
					}
					else 
					{
						if(fromFunction == "update")
						{
							if(g_label=='setAutoUpgrade')
							{
								Ext.MessageBox.show({
									title : pageTitle,
									msg : setAutoUpgradeResult,
									buttons : Ext.Msg.OK,
									icon : 'iconInformation'
								});
							}
							else if(g_label=='resetAutoUpgrade')
							{
								Ext.MessageBox.show({
									title : pageTitle,
									msg : disableAutoUpgradeResult,
									buttons : Ext.Msg.OK,
									icon : 'iconInformation'
								});
							}
							else if(g_label=='upgradeNow')
							{
								Ext.MessageBox.show({
									title : pageTitle,
									msg : upgradeNowResult,
									buttons : Ext.Msg.OK,
									icon : 'iconInformation'
								});
							}
							else if(g_label=='cancelUpgradeNow')
							{
								Ext.MessageBox.show({
									title : pageTitle,
									msg : cancelUpgradeNowResult,
									buttons : Ext.Msg.OK,
									icon : 'iconInformation'
								});
							}
						}

						if(button_val =="0"  && fromFunction == "refresh" )
						{
							Ext.getCmp('setRefreshon').setText(SetRefreshOn);
							Ext.getCmp('setRefreshon').value="1";
							Ext.getCmp("labelContainer1").hide();
							return;
						}
						if (fromFunction == "refresh" || fromFunction == "refreshAgain")
						{
							
							refresh_this_page(fromFunction);
							var resultContainer = Ext.getCmp('resultContainer');
							resultContainer.removeAll();
							resultContainer.add({
								xtype : 'totalResult',
								arrayStore : resultsData,
								pageLimit : 15
							});
							resultContainer.show();
							//if(totalresult > 15)
							//{
								//Ext.getCmp('TotalGridValues').addDocked(
								//{
									//xtype: 'toolbar',
									//dock: 'bottom',
									//items: [
										//{
											//xtype: 'tbfill'
										//},
										//{
											//xtype: 'button',
											//text:setAutoUpgradeLabel,
											//handler : function()
											//{
												//appCtn.setAutoUpgrade('setAutoUpgrade');
											//}
										//},
										//{
											//xtype: 'button',
											//text:disableAutoUpgradeLabel,
											//handler : function()
											//{
												//appCtn.resetAutoUpgrade('resetAutoUpgrade');
											//}
										//},
										//{
											//xtype: 'button',
											//text:upgradeNowLabel,
											//handler : function()
											//{
												//appCtn.upgradenow('upgradeNow');
											//}
										//},
										//{
											//xtype: 'button',
											//text:cancelUpgradeNowLabel,
											//handler : function()
											//{
												//appCtn.cancel_upgrade_now('cancelUpgradeNow');
											//}
										//}
									//]
								//});
							//}
						}
						if(fromFunction == "search" && button_val=="0")
						{
							Ext.getCmp("labelContainer1").show();
						}
						if(fromFunction != "refresh" || fromFunction != "refreshAgain")
						{
							Ext.getCmp("csv").setDisabled(false);
							var resultContainer = Ext.getCmp('resultContainer');
							resultContainer.removeAll();
							resultContainer.add({
								xtype : 'totalResult',
								arrayStore : resultsData,
								pageLimit : 15
							});
							resultContainer.show();
							//if(totalresult > 15)
							//{
								//Ext.getCmp('TotalGridValues').addDocked(
								//{
									//xtype: 'toolbar',
									//dock: 'bottom',
									//items: [
										//{
											//xtype: 'tbfill'
										//},
										//{
											//xtype: 'button',
											//text:setAutoUpgradeLabel,
											//handler : function()
											//{
												//appCtn.setAutoUpgrade('setAutoUpgrade');
											//}
										//},
										//{
											//xtype: 'button',
											//text:disableAutoUpgradeLabel,
											//handler : function()
											//{
												//appCtn.resetAutoUpgrade('resetAutoUpgrade');
											//}
										//},
										//{
											//xtype: 'button',
											//text:upgradeNowLabel,
											//handler : function()
											//{
												//appCtn.upgradenow('upgradeNow');
											//}
										//},
										//{
											//xtype: 'button',
											//text:cancelUpgradeNowLabel,
											//handler : function()
											//{
												//appCtn.cancel_upgrade_now('cancelUpgradeNow');
											//}
										//}
									//]
								//});
							//}
						}
					}
				}
			}
		});
	}
	//appCtn.getMain().doLayout();
}

function isValidIPAddress(ipAddress)
{
	var a = ipAddress.split(".");
	if(a.length!=4)
		return false;

	for(i=0;i<a.length;i++)
	{
		if(parseInt(a[i]) > 255 || parseInt(a[i]) < 0 )
			return false;
	}
	return this.checkNumber(a);
}

function checkNumber(a)
{
	var numbers = ".0123456789";
	var result = true;
	for( i=0; i<a.length; i++)
	{
		for(j=0;j<a[i].length;j++)
		{
			cha = numbers.indexOf(a[i].substring(j,1));
			if(cha == -1)
			{
				result = false;
				break;
			}
		}
	}
	return result;
	
}
function justcall(s_val)
{
	if(s_val=="on")
	{
		displayTime();
	}
}

function refresh_this_page(myStr)
{
	var SetRefreshOn = publicJSON['screenLabels']['Set Refresh On'];
	var SetRefreshOff = publicJSON['screenLabels']['Set Refresh Off'];
	var button_val =Ext.getCmp('setRefreshon').value;
	if(button_val=="1")
	{
		if(isStarted=="true")
		{
			temp =  publicJSON['screenLabels']['refreshTime'];
			Ext.getCmp('setRefreshon').setText(SetRefreshOff);
			Ext.getCmp('setRefreshon').value="0";
			Ext.getCmp("labelContainer1").show();
			return;
		}
		else
		{
			justcall('on');
			Ext.getCmp('setRefreshon').setText(SetRefreshOff);
			Ext.getCmp('setRefreshon').value="0";
			Ext.getCmp("labelContainer1").show();
		}
	}
	else
	{
		if(myStr=='refreshAgain')
		{
			Ext.getCmp("labelContainer1").show();
			Ext.getCmp('setRefreshon').setText(SetRefreshOff);
			Ext.getCmp('setRefreshon').value="0";
		}
		else
		{
			Ext.getCmp('setRefreshon').setText(SetRefreshOn);
			Ext.getCmp('setRefreshon').value="1";
			Ext.getCmp("labelContainer1").hide();
		}
	}
}

function UpdateTimer()
{
	var SetRefreshOff = publicJSON['screenLabels']['Set Refresh Off'];
	var button_val =Ext.getCmp('setRefreshon').value;
	if(button_val=="0")
	{
		goes('refreshAgain');
	}
}



