Ext.define('AdvanceSearch.view.TotalResultGrid', {
	extend : 'utilities.CustomGrid',
	alias : 'widget.totalResult',
	cls:'adminGridskin gridSkin horizontal-scroll',
	requires: [
		'Ext.ux.data.PagingMemoryProxy'
	],

	margin:'0 10 10 10',
	//columnLines: true,
	id:'TotalGridValues',
	arrayStore : null,

	flex: 1,

	tools: [
		{
			xtype: 'button',
			cls:'button20',
			text:setAutoUpgradeLabel,
			handler : function()
			{
				appCtn.setAutoUpgrade('setAutoUpgrade');
			}
		},
		{
			xtype: 'button',
			cls:'button20',
			text:disableAutoUpgradeLabel,
			margin:'0 0 0 10',
			handler : function()
			{
				appCtn.resetAutoUpgrade('resetAutoUpgrade');
			}
		},
		{
			xtype: 'button',
			cls:'button20',
			text:upgradeNowLabel,
			margin:'0 0 0 10',
			handler : function()
			{
				appCtn.upgradenow('upgradeNow');
			}
		},
		{
			xtype: 'button',
			cls:'button20',
			text:cancelUpgradeNowLabel,
			margin:'0 0 0 10',
			handler : function()
			{
				appCtn.cancel_upgrade_now('cancelUpgradeNow');
			}
		}
	],

	initComponent : function()
	{
		this.selModel  = new Ext.selection.CheckboxModel({
			checkOnly: true,
			width:45,
			injectCheckbox: 'first'
		});

		this.store = Ext.create('Ext.data.Store', {
			id:'simpsonsStore',
			fields:['id','componentName', 'componentType', 'agentName', 'autoUpgrade','upgradeNow','version','operatingSystem','lastUpgradepack',//'lastupgradeTime'
			{name: 'lastupgradeTime', type: 'date', dateFormat: extjsDateFormat}
			],
			data : this.arrayStore,
			pageSize:this.pageLimit,
			proxy: {
				type: 'pagingmemory',
				reader:
				{
					type: 'json'
				}
			},
			remoteSort: true
		});

		this.columns = [
			{
				header : componentNameLabel,
				dataIndex : 'componentName',
				flex: 1
			},
			{
				header : componentTypeLabel,
				dataIndex : 'componentType',
				flex: 1
			},
			{
				header : agentNameLabel,
				dataIndex : 'agentName',
				renderer : function(val)
				{
					var array = val.split('@');
					return "<a class='eg_monlink' href='/final/admin/EgServerList.jsp?from=upgradeAdvancedSearchPage&agentIp="+array[1]+"' >"+array[0]+"</a>";
				},
				flex: 1
			},
			{
				header : autoUpgradeLabel,
				dataIndex : 'autoUpgrade',
				flex: 1
			},
			{
				header : upgradeNowLabel,
				dataIndex : 'upgradeNow',
				flex: 1
			},
			{
				header :versionLabel,
				dataIndex : 'version',
				flex: 1
			},
			{
				header : operatingSystemLabel,
				dataIndex : 'operatingSystem',
				flex: 1
			},
			{
				header : lastUpgradePackageLabel,
				dataIndex : 'lastUpgradepack',
				flex: 1
			},
			{
				header : lastUpgradeTimeLabel,
				dataIndex : 'lastupgradeTime',
				flex: 1,
				sortable : true,
				renderer: renderLast
			}
		];

		this.dockedItems = [
			{
				xtype:'pagingtoolbar',
				cls:'pagingtoolbar',
				dock: 'bottom',
				displayInfo: true,
				beforePageText : pageLabel,
				afterPageText  : ofLabel+' {0}',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: topicsLabel+' {0} - {1} '+ofLabel+' {2}',
				emptyMsg: emptyLabel
			}
		]

		this.callParent();
	}

});

function renderLast(value, p, r) 
{
	var date = "";
	if (value != undefined)
	{
		date = Ext.String.format('{0} {1}', Ext.Date.dateFormat(value, extjsDateFormat+'|'), r.get('lastupgradeTime'));
		date = date.substring(0,date.indexOf('|'));
	}
	else
	{
		date = "None";
	}
	return date;
}


