Ext.define('AgentSettings.controller.DetailedDiagnosisCtrl',{
	extend: 'Ext.app.Controller',

	views: ['DetailedDiagnosis'],

	refs: [
		{
			selector: 'detaileddiagnosis',
			ref: 'detaileddiagnosis'
		},
	],

	init: function(){
		this.control({
			'detaileddiagnosis': {
				'afterrender': this.afterMainRender
			}
		})
	},

	buildData: function(btn) {
		Ext.Ajax.request({
			url: 'AgentSettings/data/EgDiagSettingsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	initializeFields : function() {
		var me=this;
		var executiveForm = this.getDetaileddiagnosis().getForm();
		me.setValueWithOptionInList(executiveForm, 'normal', publicJSON['normal operation'],publicJSON['selectedNormVal']['selectedNormVal']);
		me.setValueWithOptionInList(executiveForm, 'abnormal', publicJSON['Abnormal operation'],publicJSON['selectedAbnormVal']['selectedAbnormVal']);
	},

	setValueWithOptionInList : function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && value != null && !Ext.isEmpty(value) ){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender: function() {
		this.initializeFields();
		Ext.getCmp('normal').setFieldLabel(publicJSON['screenLabels']['Normal operation']);
		Ext.getCmp('abnormal').setFieldLabel(publicJSON['screenLabels']['Abnormal operation']);
		Ext.getCmp('updateBtn').setText(publicJSON['screenLabels']['Update']);
	}

});



