Ext.define('AgentSettings.controller.Main',{
	extend:'Ext.app.Controller',

	views: ['MainPane','DetailedDiagnosis','ManagerAgentCommunication','SettingList','RemoteControlCommand','VcenterTasks','VcenterEvents'],
	requires: ['AgentSettings.view.MainPane','AgentSettings.view.SettingList'],

	refs: [
		{selector:'mainpane',ref:'mainpane'},
		{selector:'settinglist',ref:'settinglist'},
		{selector:'manageragentcommunication',ref:'manageragentcommunication'},
		{selector:'remotecontrolcommand',ref:'remotecontrolcommand'},
		{selector:'vcentertasks',ref:'vcentertasks'},
		{selector:'vcenterevents',ref:'vcenterevents'},
		{selector:'detaileddiagnosis',ref:'detaileddiagnosis'}
	],

	init: function(){
		this.control({
			'mainpane': {
				'afterrender': this.afterMainRender
			},
			'settinglist': {
				'itemclick': this.loadServerAgentSettingsPage
			},
			'manageragentcommunication button[id="UpdateBTN"]': {
				'click' : this.updateComm
			},
			'remotecontrolcommand button[id="AddBtn"]': {
				'click' : this.addRC
			},
			'remotecontrolcommand button[id="UpdateBtn"]': {
				'click' : this.updateRC
			},
			'remotecontrolcommand button[id="DeleteBtn"]': {
				'click' : this.deletingRC
			},
			'remotecontrolcommand combo[id="OperatingSystem"]': {
				'select': this.comboLoad
			},
			'remotecontrolcommand combo[id="ExistOperatingSystem"]': {
				'select': this.comboExistLoad
			},
			'remotecontrolcommand combo[id="ExistingCommand"]': {
				'select': this.LoadData
			},
			'remotecontrolcommand combo[id="DelOperatingSystem"]': {
				'select': this.comboDelLoad
			},
			'remotecontrolcommand > tabpanel': {
				'tabchange': this.tabchange
			},
			'vcentertasks combo[id="vCTask"]': {
				'select': this.vCTaskComboLoad
			},
			'vcentertasks button[id="UpdateBTN"]': {
				'click': this.updatevCTasks
			},
			'vcentertasks button[id="backbutton"]': {
				'click': this.backbutton
			},
			'vcenterevents combo[id="vCEvents"]': {
				'select': this.vCEventcomboLoad
			},
			'vcenterevents button[id="UpdateBTN"]': {
				'click': this.updatevCEvents
			},
			'vcenterevents button[id="backevtbutton"]': {
				'click': this.backEvtbutton
			},
			'detaileddiagnosis button[id="updateBtn"]': {
				'click': this.updateDD
			}
		});
	},

	tabchange: function(){
		var activeTabId = Ext.getCmp('remotecontrolcommand').getActiveTab().getId();

		if (activeTabId == 'addTab' && selectedValue != "")
		{
			Ext.getCmp('OperatingSystem').setValue(selectedValue);
			this.comboLoad();
			Ext.getCmp('ExistOperatingSystem').setValue(selectedValue);
			this.comboExistLoad();
			Ext.getCmp('DelOperatingSystem').setValue(selectedValue);
			this.comboDelLoad();
		}
		if (activeTabId == 'modifyTab' && selectedValue != "")
		{
			Ext.getCmp('OperatingSystem').setValue(selectedValue);
			this.comboLoad();
			Ext.getCmp('ExistOperatingSystem').setValue(selectedValue);
			this.comboExistLoad();
			Ext.getCmp('DelOperatingSystem').setValue(selectedValue);
			this.comboDelLoad();
		}
		if (activeTabId == 'deleteTab' && selectedValue != "")
		{
			Ext.getCmp('OperatingSystem').setValue(selectedValue);
			this.comboLoad();
			Ext.getCmp('ExistOperatingSystem').setValue(selectedValue);
			this.comboExistLoad();
			Ext.getCmp('DelOperatingSystem').setValue(selectedValue);
			this.comboDelLoad();
		}
		Ext.Ajax.request({
			url: 'AgentSettings/data/agentsettingshelpJson.jsp?selectTab='+activeTabId,
			method: 'POST',
			async: false
		});
	},

	updateComm : function(btn){
		var AuthenYes = Ext.getCmp('authenticateyes').getValue();
		var AuthenNo = Ext.getCmp('authenticateno').getValue();
		var EncryptYes = Ext.getCmp('encryptyes').getValue();
		var EncryptNo = Ext.getCmp('encryptno').getValue();

		var authenticate= publicJSON['authenticate'];
		var encript = publicJSON['encript'];

		var agents= "";
		var reports= "";
		if (AuthenYes)
		{
			agents = "Yes";
		}
		else
		{
			agents = "No";
		}
		if (EncryptYes)
		{
			reports = "Yes";
		}
		else
		{
			reports = "No";
		}
		var myMgrMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMgrMask.show();

		var updateURL = publicJSON['UpdateURLLink'];
		var qrString = "authenticate="+authenticate+"&encript="+encript+"&agents="+agents+"&reports="+reports;

		Ext.Ajax.request({
		url: 'AgentSettings/data/EgcommsettingspJson.jsp?'+qrString,
		method: 'POST',
		success: function( response )
		{
			myMgrMask.hide();
			var jsonText = response.responseText;
			publicJSON = Ext.decode(jsonText);
			if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
			{
				var resultStatus = publicJSON['requestStatus'];
				if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
				{
					var resultStatus = publicJSON['result'];
					Ext.MessageBox.show(
					{
						title :resultStatus['title'],
						msg : resultStatus['message1'],
						icon : 'iconInformation',
						buttons : Ext.Msg.OK
					});
				}
			}
		}
		});
	},

	validationForAddRC: function(selOS,nickNameTxt,commandTxt) {
		var cmdExist = '';
		Ext.Ajax.request({
		url: 'AgentSettings/data/EgManageCommandsRCJson.jsp?osName='+selOS+"&nickNameTxt="+nickNameTxt,
		method: 'POST',
		async: false,
		success: function( response )
		{
			var jsonText = response.responseText;
			jjpublic = Ext.decode(jsonText);
			if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
			{
				cmdExist = jjpublic['cmdExist'];
			}
		}
		});
		if (cmdExist == "true")
		{
			Ext.Msg.show(
			{
				title : rcPageTitle,
				msg : checkCmdExist+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			Ext.getCmp('CommandDisplayName').focus();
			return false;
		}

		var commandSynt = Ext.getCmp('CommandSyntax').getValue();
		var cmd_Desc=true;
		if(isDouble == "false")
			cmd_Desc = validateSingleByte(commandSynt);

		var checkSpl = checkSpecialExtjs(nickNameTxt,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?/");

		if (selOS == -1)
		{
			Ext.Msg.show(
			{
				title : rcPageTitle,
				msg : checkOS + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else if (nickNameTxt == "")
		{
			Ext.Msg.show(
			{
				title : rcPageTitle,
				msg : checkDispName + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else if (commandTxt == "")
		{
			Ext.Msg.show({
				title : rcPageTitle,
				msg :checkCmdSynt +'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else if(checkSpl == '7')
		{
			Ext.Msg.show({
				title : rcPageTitle,
				msg : _checkspecial + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			Ext.getCmp('CommandDisplayName').focus();
		}
		else if (!cmd_Desc)
		{
			Ext.Msg.show({
				title : rcPageTitle,
				msg : checkDBL + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			Ext.getCmp('CommandDisplayName').focus();
		}
		else
		{
			return true;
		}
	},

	addRC: function() {
		var selOS = Ext.getCmp('OperatingSystem').getValue();
		var nickNameTxt = Ext.getCmp('CommandDisplayName').getValue();
		var commandTxt = Ext.getCmp('CommandSyntax').getValue();
		var cmdExist = '';
		var jjpublic = '';

		var me = this;
		var validateAddRC = me.validationForAddRC(selOS,nickNameTxt,commandTxt);

		if (validateAddRC)
		{
			var myAddRCMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myAddRCMask.show();

			var cmds = publicJSON['cmds'];

			//var qrString = "mode=add&processRad=add&nickNameTxt="+nickNameTxt+"&commandTxt="+commandTxt+"&selOS="+selOS+"&cmds="+cmds;
			commandTxt = encodeURIComponent(parent.filterEncode(commandTxt));
			var qrString = "mode=add&processRad=add&nickNameTxt="+nickNameTxt+"&commandTxt="+commandTxt+"&selOS="+selOS;

			Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCpJson.jsp?'+qrString,
			method: 'POST',
			success: function( response )
			{
				myAddRCMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show(
						{
							title : resultStatus['title'],
							msg : resultStatus['message1'],
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								Ext.getCmp('CommandDisplayName').reset();
								Ext.getCmp('CommandSyntax').reset();
							}
						});
					}
				}
			}
			});
		}
	},

	updateRC: function() {
		var exComboLoad = this;
		var selOS = Ext.getCmp('ExistOperatingSystem').getValue();
		var nickNameTxt = Ext.getCmp('ExistingCommand').getValue();
		var commandTxt = Ext.getCmp('ExistCommandSyntax').getValue();
		var cmd_Desc=true;
		if(isDouble == "false")
		{
			cmd_Desc = validateSingleByte(commandTxt);
		}
		if (selOS == -1)
		{
			Ext.Msg.show(
			{
				title : rcPageTitle,
				msg : publicJSON['screenLabels']['admin.remote.Please select an operating system']+'.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
		}
		else if (nickNameTxt == 'Choose a command')
		{
			Ext.Msg.show(
			{
				title : rcPageTitle,
				msg : publicJSON['screenLabels']['admin.remote.Please select a command']+'.',
				buttons : Ext.Msg.OK,
				icon : 'iconExclamation'
			});
		}
		else if (commandTxt == "")
		{
			Ext.Msg.show({
				title : rcPageTitle,
				msg :checkCmdSynt +'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else if (!cmd_Desc)
		{
			Ext.Msg.show({
				title : rcPageTitle,
				msg : checkDBL + '.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
			Ext.getCmp('ExistCommandSyntax').focus();
		}
		else
		{
			var myUpdateRCMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myUpdateRCMask.show();
			var cmds = publicJSON['cmds'];

			var previousSelCmd = publicJSON['commandSynt'];

			//var qrString = "mode=modify&processRad=edit&nickNameTxt="+nickNameTxt+"&commandTxt="+commandTxt+"&selOS="+selOS+'&cmds='+cmds+"&selCmd="+previousSelCmd+"&previousCmdDesc="+previousSelCmd;

			previousSelCmd = encodeURIComponent(parent.filterEncode(previousSelCmd));
			nickNameTxt = encodeURIComponent(parent.filterEncode(nickNameTxt));
			commandTxt = encodeURIComponent(parent.filterEncode(commandTxt));
			
			var qrString = "mode=modify&processRad=edit&nickNameTxt="+nickNameTxt+"&commandTxt="+commandTxt+"&selOS="+selOS+"&selCmd="+previousSelCmd+"&previousCmdDesc="+previousSelCmd;

			Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCpJson.jsp?'+qrString,
			method: 'POST',
			success: function( response )
			{
				myUpdateRCMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show(
						{
							title : resultStatus['title'],
							msg : resultStatus['message1']+'.',
							icon : 'iconInformation',
							buttons : Ext.Msg.OK,
							fn : function(btn){
								exComboLoad.comboExistLoad();
							}
						});
					}
				}
			}
			});
		}
	},

	deletingRC: function() {
		var selOS = Ext.getCmp('DelOperatingSystem').getValue();
		var nickNameTxt = Ext.getCmp('DelExistCommand').getValue();
		if (selOS == -1)
		{
			Ext.Msg.show(
			{
				title : rcPageTitle,
				msg : publicJSON['screenLabels']['admin.remote.Please select an operating system']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else if (nickNameTxt == "")
		{
			Ext.Msg.show(
			{
				title : rcPageTitle,
				msg : cmdToDel+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK
			});
		}
		else
		{
			Ext.MessageBox.show(
			{
				title : 'DELETE REMOTE COMMANDS',
				msg : deleteMsg,
				fn : this.deletingRCFn,
				scope :this,
				buttons : Ext.Msg.YESNO,
				icon : 'iconConfirmation'
			});
		}
	},

	deletingRCFn: function(btn) {
		var delData = this;
		if (btn == 'yes')
		{
			var myDelRCMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myDelRCMask.show();

			var selOS = Ext.getCmp('DelOperatingSystem').getValue();
			var nickNameTxt = Ext.getCmp('DelExistCommand').getValue();
			var cmds = publicJSON['cmds'];
			//var qrString = "mode=delete&processRad=delete&nickNameTxt=&commandTxt=&selCmd="+nickNameTxt+"&selOS="+selOS+"&cmds="+cmds;
			try
			{
				for (var a in nickNameTxt)
					nickNameTxt[a]= encodeURIComponent(parent.filterEncode(nickNameTxt[a]));
			}
			catch (e)
			{
				nickNameTxt = encodeURIComponent(parent.filterEncode(nickNameTxt));
			}
			
			var qrString = "mode=delete&processRad=delete&nickNameTxt=&commandTxt=&selCmd="+nickNameTxt+"&selOS="+selOS;
			
			Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCpJson.jsp?'+qrString,
			method: 'POST',
			success: function( response )
			{
				myDelRCMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
				{
					var resultStatus = publicJSON['requestStatus'];
					if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
					{
						var resultStatus = publicJSON['result'];
						Ext.MessageBox.show(
						{
							title : resultStatus['title'],
							msg : resultStatus['message1']+'.',
							icon : 'iconInformation',
							buttons:Ext.Msg.OK,
							fn : function(btn){
								delData.comboDelLoad();
							}
						});
					}
				}
			}
			});
		}
	},

	comboLoad: function(combo) {
		var operatingSystem = Ext.getCmp('OperatingSystem').getValue();
		selectedValue = operatingSystem;
		Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCJson.jsp?process=add&osName='+operatingSystem,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});

		var activeTabId = Ext.getCmp('remotecontrolcommand').getActiveTab().getId();
		Ext.Ajax.request({
			url: 'AgentSettings/data/agentsettingshelpJson.jsp?selectTab='+activeTabId,
			method: 'POST',
			async: false
		});

	},

	comboExistLoad: function(combo) {
		this.getController('AgentSettings.controller.RemoteControlCmdCtrl').loadRemoteData();
		Ext.getCmp('ExistingCommand').setValue(publicJSON['screenLabels']['admin.remote.Choose a command']);
		Ext.getCmp('ExistCommandSyntax').setValue("");
		var operatingSystem = Ext.getCmp('ExistOperatingSystem').getValue();
		selectedValue = operatingSystem;
		Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCJson.jsp?process=modify&osName='+operatingSystem,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if (!Ext.isEmpty(publicJSON))
				{
					var zoneComboRawData = publicJSON['existingCommandArray'];
					Ext.getCmp('ExistingCommand').getStore().loadRawData(zoneComboRawData);
					Ext.getCmp('ExistingCommand').setValue(publicJSON.existingCommandArray[0].valueField); // fix
				}
			}
		});

		var activeTabId = Ext.getCmp('remotecontrolcommand').getActiveTab().getId();
		Ext.Ajax.request({
			url: 'AgentSettings/data/agentsettingshelpJson.jsp?selectTab='+activeTabId,
			method: 'POST',
			async: false
		});
	},

	LoadData: function(combo) {
		var operatingSystem = Ext.getCmp('ExistOperatingSystem').getValue();
		var existVal = Ext.getCmp('ExistingCommand').getRawValue();
		if (existVal != null && existVal.length>0)
		{
			existVal = encodeURIComponent(parent.filterEncode(existVal));
			Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCJson.jsp?process=modify&osName='+operatingSystem+"&existingcommand="+existVal,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if (!Ext.isEmpty(publicJSON))
				{
					var CommandSyntax = publicJSON['commandSynt'];
					Ext.getCmp('ExistCommandSyntax').setValue(CommandSyntax);
				}
			}
			});
		}

		var activeTabId = Ext.getCmp('remotecontrolcommand').getActiveTab().getId();
		Ext.Ajax.request({
			url: 'AgentSettings/data/agentsettingshelpJson.jsp?selectTab='+activeTabId,
			method: 'POST',
			async: false
		});
	},

	comboDelLoad: function(combo) {
		var operatingSystem = Ext.getCmp('DelOperatingSystem').getValue();
		selectedValue = operatingSystem;
		Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCJson.jsp?process=modify&osName='+operatingSystem,
			method: 'POST',
			success: function ( response )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				if (!Ext.isEmpty(publicJSON))
				{
					var zoneComboRawData = publicJSON['existingCmdtodeleteArray'];
					Ext.getCmp('DelExistCommand').getStore().loadRawData(zoneComboRawData);
				}
			}
		});
		var activeTabId = Ext.getCmp('remotecontrolcommand').getActiveTab().getId();
		Ext.Ajax.request({
			url: 'AgentSettings/data/agentsettingshelpJson.jsp?selectTab='+activeTabId,
			method: 'POST',
			async: false
		});
	},

	vCTaskComboLoad: function() {
		var descriptor = Ext.getCmp('vCTask').getValue();
		urlComboLink = "AgentSettings/data/EgConfigureVCTasksJson.jsp?descriptor="+descriptor;

		Ext.Ajax.request({
		url: urlComboLink,
		method: 'POST',
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode( jsonText );
			}
			Ext.getCmp('itemselect').getStore().removeAll();
			if (Ext.getCmp('itemselect').fromField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselect').fromField.store.removeAll();
			}
			if (Ext.getCmp('itemselect').toField.store.getCount() >= 1)
			{
				Ext.getCmp('itemselect').toField.store.removeAll();
			}
			Ext.getCmp('itemselect').fromField.store.add(publicJSON['includedArray']);
			Ext.getCmp('itemselect').toField.store.add(publicJSON['excludedArray']);
		}
	});
	},

	updatevCTasks: function(btn) {
		var descr = Ext.getCmp('vCTask').getValue();
		if (descr == '-1')
		{
			Ext.Msg.show(
			{
				title : vCTaskspageTitle,
				msg : publicJSON['screenLabels']['admin.vctask.Please choose a task category']+'.',
				icon:'iconExclamation',
				buttons:Ext.Msg.OK
			});
		}
		else
		{
			var previncludedTasks = publicJSON['prevIncludedArray'];
			var prevexcludedTasks = publicJSON['prevExcludedArray'];
			var updateUrrl = publicJSON['updateURLLink'];

			var noOfIncTasks = Ext.getCmp('itemselect').fromField.store.getCount();
			var allValueIncTasks = new Array();
			for (var i=0;i < noOfIncTasks;i++)
			{
				allValueIncTasks[allValueIncTasks.length]=Ext.getCmp('itemselect').fromField.store.getAt(i).get('valueField');
			}
			var strIncludedTasks = allValueIncTasks;
			if (strIncludedTasks.length == 0)
			{
				strIncludedTasks = "";
			}

			var noOfExcTasks = Ext.getCmp('itemselect').toField.store.getCount();
			var allValueExcTasks = new Array();
			for (var i=0;i < noOfExcTasks;i++)
			{
				allValueExcTasks[allValueExcTasks.length]=Ext.getCmp('itemselect').toField.store.getAt(i).get('valueField');
			}
			var strExcludedTasks = allValueExcTasks;
			if (strExcludedTasks.length == 0)
			{
				strExcludedTasks = "";
			}

			var hiddenObj = Ext.getCmp('hiddencontainer');
			urlLink = "AgentSettings/data/EgConfigureVCTaskspJson.jsp?descriptor="+descr;
			var temp = {
				xtype: 'hiddenfield',
				name: 'prevIncludedTasks',
				value: previncludedTasks,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'prevExcludedTasks',
				value: prevexcludedTasks,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'strIncludedTasks',
				value: strIncludedTasks,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'strExcludedTasks',
				value: strExcludedTasks,
			};
			hiddenObj.add(temp);
			
			var vcTaskObj = Ext.getCmp('vcentertasks').getForm();
			vcTaskObj.submit({
			url: urlLink,
			method: 'POST',
			standardSubmit: false,
			success: function( action )
			{
				var urlDataLink = "AgentSettings/data/EgConfigureVCTasksJson.jsp?descriptor="+descr;
				Ext.Ajax.request({
				url: urlDataLink,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					if (Ext.getCmp('itemselect').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselect').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselect').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselect').toField.store.removeAll();
					}
					Ext.getCmp('itemselect').fromField.store.add(publicJSON['includedArray']);
					Ext.getCmp('itemselect').toField.store.add(publicJSON['excludedArray']);
					Ext.Msg.show(
					{
						title : vCTaskspageTitle,
						msg : publicJSON['screenLabels']['admin.vctask.Task have been included/excluded sucessfully']+'.',
						icon:'iconInformation',
						buttons:Ext.Msg.OK
					});
				}
				});
				hiddenObj.removeAll();
			},
			failure: function()
			{
				hiddenObj.removeAll();
			}
			});
		}
	},

	backbutton: function() {
		if (fromPage != null && fromPage == "TestConfiguration")
		{
			Ext.getCmp('backbutton').show();
			Ext.getCmp('vcentertasks').setTitle(vCTaskspageTitle);
			window.location.href = backBtnUrl;
		}
	},

	vCEventcomboLoad: function() {
		var descriptor = Ext.getCmp('vCEvents').getValue();
		Ext.Ajax.request({
				url: 'AgentSettings/data/EgConfigureVCEventsJson.jsp?descriptor='+descriptor,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					if (Ext.getCmp('itemselect').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselect').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselect').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselect').toField.store.removeAll();
					}
					Ext.getCmp('itemselect').fromField.store.add(publicJSON['includedEventsArray']);
					Ext.getCmp('itemselect').toField.store.add(publicJSON['excludedEventsArray']);
				}
			});
			
	},

	updatevCEvents: function(btn) {
		var descr = Ext.getCmp('vCEvents').getValue();
		if (descr == '-1')
		{
			Ext.Msg.show(
			{
				title : vCEventspageTitle,
				msg : publicJSON['screenLabels']['admin.vcevent.Please choose an event category']+'.',
				icon : 'iconExclamation',
				buttons:Ext.Msg.OK
			});
		}
		else
		{
			var previncludedEvents = publicJSON['prevIncludedEvents'];
			var prevexcludedEvents = publicJSON['prevExcludedEvents'];
			var updateUrrl = publicJSON['updateURLLink'];

			var noOfIncAry = Ext.getCmp('itemselect').fromField.store.getCount();
			var allValue = new Array();
			for (var i=0;i < noOfIncAry;i++)
			{
				allValue[allValue.length]=Ext.getCmp('itemselect').fromField.store.getAt(i).get('valueField');
			}
			var strIncludedEvents = allValue;
			if (strIncludedEvents.length == 0)
			{
				strIncludedEvents = "";
			}

			var noOfExcAry = Ext.getCmp('itemselect').toField.store.getCount();
			var allExValue = new Array();
			for (var i=0;i < noOfExcAry;i++)
			{
				allExValue[allExValue.length]=Ext.getCmp('itemselect').toField.store.getAt(i).get('valueField');
			}
			var strExcludedEvents = allExValue;
			if (strExcludedEvents.length == 0)
			{
				strExcludedEvents = "";
			}

			var hiddenObj = Ext.getCmp('hiddencontainer');
			urlLink = "AgentSettings/data/EgConfigureVCEventspJson.jsp?descriptor="+descr;
			var temp = {
				xtype: 'hiddenfield',
				name: 'prevIncludedEvents',
				value: previncludedEvents,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'prevExcludedEvents',
				value: prevexcludedEvents,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'strIncludedEvents',
				value: strIncludedEvents,
			};
			hiddenObj.add(temp);

			temp = {
				xtype: 'hiddenfield',
				name: 'strExcludedEvents',
				value: strExcludedEvents,
			};
			hiddenObj.add(temp);
			
			var vcEventObj = Ext.getCmp('vcenterevents').getForm();
			vcEventObj.submit({
			url: urlLink,
			method: 'POST',
			standardSubmit: false,
			success: function( action )
			{
				var urlDataLink = "AgentSettings/data/EgConfigureVCEventsJson.jsp?descriptor="+descr;
				Ext.Ajax.request({
				url: urlDataLink,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
					}
					if (Ext.getCmp('itemselect').fromField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselect').fromField.store.removeAll();
					}
					if (Ext.getCmp('itemselect').toField.store.getCount() >= 1)
					{
						Ext.getCmp('itemselect').toField.store.removeAll();
					}
					Ext.getCmp('itemselect').fromField.store.add(publicJSON['includedEventsArray']);
					Ext.getCmp('itemselect').toField.store.add(publicJSON['excludedEventsArray']);

					Ext.Msg.show(
					{
						title : vCEventspageTitle,
						msg : publicJSON['screenLabels']['admin.vcevent.Events have been included/excluded sucessfully']+'.',
						icon : 'iconInformation',
						buttons:Ext.Msg.OK
					});
				}
				});
				hiddenObj.removeAll();
			},
			failure: function()
			{
				hiddenObj.removeAll();
			}
			});
		}
	},

	backEvtbutton: function() {
		if (fromPage != null && fromPage == "TestConfiguration")
		{
			Ext.getCmp('backevtbutton').show();
			Ext.getCmp('vcenterevents').setTitle(vCEventspageTitle);
			window.location.href = backBtnUrl;
		}
	},

	updateDD: function(btn) {
		this.getController('AgentSettings.controller.DetailedDiagnosisCtrl').buildData();
		var updateUrl = publicJSON['updateLink'];
		var normal = Ext.getCmp('normal').getValue();
		var bad = Ext.getCmp('abnormal').getValue();
		var previousNorm = publicJSON['previousNormal'];
		var previousBad = publicJSON['previousBad'];
		var qrString = "normal="+normal+"&bad="+bad+"&previous_normal="+previousNorm+"&previous_bad="+previousBad;

		var myDDMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myDDMask.show();

		Ext.Ajax.request({
		url: 'AgentSettings/data/EgdiagsettingspJson.jsp?'+qrString,
		method: 'POST',
		success: function( response )
		{
			myDDMask.hide();
			var jsonText = response.responseText;
			publicJSON = Ext.decode(jsonText);
			if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
			{
				var resultStatus = publicJSON['requestStatus'];
				if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
				{
					var resultStatus = publicJSON['result'];
					Ext.MessageBox.show(
					{
						title : resultStatus['title'],
						msg : resultStatus['message1'],
						icon : 'iconInformation',
						buttons:Ext.Msg.OK
					});
				}
			}
		}
		});
	},

	afterMainRender : function() {
		var disObject = Ext.getCmp('AgentSettingsRightPane');
		disObject.removeAll();

		if (fromPage != null && fromPage == "TestConfiguration")
		{
			if (fromVc != null && fromVc == 'VcTasks')
			{
				var treePanel = Ext.getCmp('settingList');
				var record = treePanel.getStore().getNodeById('vcentertasks');
				treePanel.getSelectionModel().select(record);

				this.getController('AgentSettings.controller.VcenterTasksCtrl').buildVcenterData();
				disObject.add({xtype:'vcentertasks'});
				this.getController('AgentSettings.controller.VcenterTasksCtrl').afterMainRender();
				Ext.getCmp('vcentertasks').setTitle(vCTaskspageTitle);
			}
			else if (fromVc != null && fromVc == 'VcEvents')
			{
				var treePanel = Ext.getCmp('settingList');
				var record = treePanel.getStore().getNodeById('vcenterevents');
				treePanel.getSelectionModel().select(record);

				this.getController('AgentSettings.controller.VcenterEventsCtrl').buildVEventData();
				disObject.add({xtype:'vcenterevents'});
				this.getController('AgentSettings.controller.VcenterEventsCtrl').afterMainRender();
				Ext.getCmp('vcenterevents').setTitle(vCEventspageTitle);
			}
		}
		else
		{
			var treePanel = Ext.getCmp('settingList');
			var record = treePanel.getStore().getNodeById('mgragntcommunication');
			treePanel.getSelectionModel().select(record);

			this.getController('AgentSettings.controller.MgrAgntCommCtrl').buildCommunicationData();
			disObject.add({xtype:'manageragentcommunication'});
			this.getController('AgentSettings.controller.MgrAgntCommCtrl').afterMainRender();
			Ext.getCmp('AgentSettingsRightPane').setTitle(mgrAgntpageTitle);
			Ext.getCmp('AgentSettingsRightPane').getHeader().show();
		}
	},

	loadServerAgentSettingsPage : function(view, record, item, index, event) {
		selectedNodeId = record.data.id;
		var disObject = Ext.getCmp('AgentSettingsRightPane');
		disObject.removeAll();

		if (selectedNodeId == 'mgragntcommunication')
		{
			this.getController('AgentSettings.controller.MgrAgntCommCtrl').buildCommunicationData();
			disObject.add({xtype:'manageragentcommunication'});
			this.getController('AgentSettings.controller.MgrAgntCommCtrl').afterMainRender();
			Ext.getCmp('AgentSettingsRightPane').setTitle(mgrAgntpageTitle);
			Ext.getCmp('AgentSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'remotecontrol')
		{
			this.getController('AgentSettings.controller.RemoteControlCmdCtrl').loadRemoteData();
			disObject.add({xtype:'remotecontrolcommand'});
			this.getController('AgentSettings.controller.RemoteControlCmdCtrl').afterMainRender();
			Ext.getCmp('AgentSettingsRightPane').setTitle(rcPageTitle);
			Ext.getCmp('AgentSettingsRightPane').getHeader().show();
		}
		else if (selectedNodeId == 'vcentertasks')
		{
			this.getController('AgentSettings.controller.VcenterTasksCtrl').buildVcenterData();
			disObject.add({xtype:'vcentertasks'});
			this.getController('AgentSettings.controller.VcenterTasksCtrl').afterMainRender();
			Ext.getCmp('backbutton').hide();
			Ext.getCmp('AgentSettingsRightPane').setTitle(vCTaskspageTitle);
			Ext.getCmp('AgentSettingsRightPane').getHeader().show();
			Ext.getCmp('vcentertasks').getHeader().hide();
		}
		else if (selectedNodeId == 'vcenterevents')
		{
			this.getController('AgentSettings.controller.VcenterEventsCtrl').buildVEventData();
			disObject.add({xtype:'vcenterevents'});
			this.getController('AgentSettings.controller.VcenterEventsCtrl').afterMainRender();
			Ext.getCmp('backevtbutton').hide();
			Ext.getCmp('AgentSettingsRightPane').setTitle(vCEventspageTitle);
			Ext.getCmp('AgentSettingsRightPane').getHeader().show();
			Ext.getCmp('vcenterevents').getHeader().hide();
		}
		else if (selectedNodeId == 'detaileddiagnosis')
		{

			this.getController('AgentSettings.controller.DetailedDiagnosisCtrl').buildData();
			if (publicJSON.isddEnabled == true)
			{
				disObject.add({xtype:'detaileddiagnosis'});
				this.getController('AgentSettings.controller.DetailedDiagnosisCtrl').afterMainRender();
				Ext.getCmp('AgentSettingsRightPane').setTitle(ddPageTitle);
				Ext.getCmp('AgentSettingsRightPane').getHeader().show();
			}
			else
			{
				Ext.getCmp('AgentSettingsRightPane').setTitle(ddPageTitle);
				Ext.getCmp('AgentSettingsRightPane').getHeader().show();
				var msg = '';
				var ddErrorMsg = publicJSON.DDLicenseDisabled;
				for (var key in ddErrorMsg)
				{
					msg+=ddErrorMsg[key];
				}
				disObject.add({
					xtype:'panel',
					padding: '160 0 0 0',
					style: {
						'text-align': 'center',
					},
					border: false,
					html: msg
				});
			}
		}
	}

});



