Ext.define('AgentSettings.controller.MgrAgntCommCtrl',{
	extend: 'Ext.app.Controller',

	view: ['ManagerAgentCommunication'],

	refs: [
		{
			selector: 'manageragentcommunication',
			ref: 'manageragentcommunication'
		},
	],

	init: function(){
		this.control({
			'manageragentcommunication': {
				'afterrender' : this.afterMainRender
			}
		});
	},

	buildCommunicationData: function(){
		Ext.Ajax.request({
			url: 'AgentSettings/data/CommunicateJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender : function() {
		Ext.getCmp('Authen').setFieldLabel(publicJSON['screenLabels']['admin.comm.Authenticate']);
		Ext.getCmp('encryypt').setFieldLabel(publicJSON['screenLabels']['admin.comm.Encrypt']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.Update']);

		var strAgen = publicJSON['strAgents'];
		if (strAgen == "Yes")
		{
			Ext.getCmp('authenticateyes').setValue(true);
		}
		else
		{
			Ext.getCmp('authenticateno').setValue(true);
		}
		var strRep = publicJSON['strReports'];
		if (strRep == "Yes")
		{
			Ext.getCmp('encryptyes').setValue(true);
		}
		else
		{
			Ext.getCmp('encryptno').setValue(true);
		}
	}

});



