Ext.define('AgentSettings.controller.RemoteControlCmdCtrl',{
	extend: 'Ext.app.Controller',

	view: ['RemoteControlCommand'],

	refs: [
		{
			selector: 'remotecontrolcommand',
			ref: 'remotecontrolcommand'
		},
	],

	init: function(){
		this.control({
			'remotecontrolcommand': {
				'afterrender' : this.afterMainRender
			}
		});
	},

	loadRemoteData: function() {
		Ext.Ajax.request({
			url: 'AgentSettings/data/EgManageCommandsRCJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	initializeFields : function() {
		var me=this;
		var executiveForm = this.getRemotecontrolcommand().getForm();
		var existingOperaSystem =  publicJSON['operaCommandArray'];
		me.setValueWithOptionInList(executiveForm, 'OperatingSystem', publicJSON['operaCommandArray'],publicJSON['screenLabels']['admin.remote.Choose an operating system']);

		me.setValueWithOptionInList(executiveForm, 'ExistOperatingSystem', publicJSON['operaCommandArray'],publicJSON['screenLabels']['admin.remote.Choose an operating system']);
		Ext.getCmp('ExistingCommand').setValue(publicJSON['screenLabels']['admin.remote.Choose a command']);

		me.setValueWithOptionInList(executiveForm, 'DelOperatingSystem', publicJSON['operaCommandArray'],publicJSON['screenLabels']['admin.remote.Choose an operating system']);
	},

	setValueWithOptionInList : function(form, fieldName, list, value) {
		Ext.getCmp(fieldName).getStore().loadRawData(list);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && value != null && !Ext.isEmpty(value) ){
				Ext.getCmp(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		if(!valueAssigned){
			Ext.getCmp(fieldName).setValue(list[0].valueField);
		}
		Ext.getCmp(fieldName).resumeEvents();
	},

	afterMainRender : function() {
		this.initializeFields();
		Ext.getCmp('OperatingSystem').setFieldLabel(publicJSON['screenLabels']['admin.remote.Operating system']);
		Ext.getCmp('CommandDisplayName').setFieldLabel(publicJSON['screenLabels']['admin.remote.Command display name']);
		Ext.getCmp('CommandSyntax').setFieldLabel(publicJSON['screenLabels']['admin.remote.Command syntax']);
		Ext.getCmp('AddBtn').setText(publicJSON['screenLabels']['admin.common.Add']);

		Ext.getCmp('ExistOperatingSystem').setFieldLabel(publicJSON['screenLabels']['admin.remote.Operating system']);
		Ext.getCmp('ExistingCommand').setFieldLabel(publicJSON['screenLabels']['admin.remote.Existing commands']);
		Ext.getCmp('ExistCommandSyntax').setFieldLabel(publicJSON['screenLabels']['admin.remote.Command syntax']);
		Ext.getCmp('UpdateBtn').setText(publicJSON['screenLabels']['admin.common.Update']);

		Ext.getCmp('DelOperatingSystem').setFieldLabel(publicJSON['screenLabels']['admin.remote.Operating system']);
		Ext.getCmp('DelExistCommand').setFieldLabel(publicJSON['screenLabels']['admin.remote.Existing commands']);
		Ext.getCmp('DeleteBtn').setText(publicJSON['screenLabels']['admin.common.Delete']);

		if (process != null && osName != null && process.length > 0 && osName.length > 0 && process != "" && process != "null" && osName != "" && osName != "null")
		{
			if (process == 'Add')
			{
				Ext.getCmp('addTab').setVisible(true);
				Ext.getCmp('OperatingSystem').setValue(osName);
			}
			else if (process == 'Modify')
			{
				Ext.getCmp('modifyTab').setVisible(true);
				Ext.getCmp('ExistOperatingSystem').setValue(osName);
				//this.comboExistLoad();
				this.getController('AgentSettings.controller.Main').comboExistLoad();  //fix
			}
			else
			{
				Ext.getCmp('deleteTab').setVisible(true);
				Ext.getCmp('DelOperatingSystem').setValue(osName);
				//this.comboDelLoad();
				this.getController('AgentSettings.controller.Main').comboDelLoad();  //fix
			}
		}
	}

});



