Ext.define('AgentSettings.controller.VcenterEventsCtrl',{
	extend:'Ext.app.Controller',

	views:['VcenterEvents'],

	refs:[
		{
			selector:'vcenterevents',
			ref:'vcenterevents'
		},
	],

	init:function(){
		this.control({
			'vcenterevents': {
				'afterrender': this.afterMainRender
			}
		});
	},

	buildVEventData: function() {
		Ext.Ajax.request({
			url: 'AgentSettings/data/EgConfigureVCEventsJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	initializeFields : function() {
		var me=this;
		var executiveForm = this.getVcenterevents().getForm();
		if (descript == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'vCEvents', publicJSON['comboValue'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'vCEvents', publicJSON['comboValue'],descript);
		}
	},

	setValueWithOptionInList : function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function() {
		this.initializeFields();
		Ext.getCmp('vCEvents').setFieldLabel(publicJSON['screenLabels']['admin.vcevent.Event category']);
		Ext.getCmp('itemselect').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.vcevent.Included Events']);
		Ext.getCmp('itemselect').toField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.vcevent.Excluded Events']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.Update']);

			Ext.Ajax.request({
			url: 'AgentSettings/data/EgConfigureVCEventsJson.jsp?descriptor='+descript,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselect').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselect').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselect').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselect').toField.store.removeAll();
				}
				Ext.getCmp('itemselect').fromField.store.add(publicJSON['includedEventsArray']);
				Ext.getCmp('itemselect').toField.store.add(publicJSON['excludedEventsArray']);
			}
		});
	}

});



