Ext.define('AgentSettings.controller.VcenterTasksCtrl',{
	extend:'Ext.app.Controller',

	views:['VcenterTasks'],

	refs:[
		{
			selector:'vcentertasks',
			ref:'vcentertasks'
		},
	],

	init:function(){
		this.control({
			'vcentertasks': {
				'afterrender': this.afterMainRender
			}
		});
	},

	buildVcenterData: function() {
		Ext.Ajax.request({
			url: 'AgentSettings/data/EgConfigureVCTasksJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	initializeFields : function() {
		var me=this;
		var executiveForm = this.getVcentertasks().getForm();
		if (descript == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'vCTask', publicJSON['comboValue'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'vCTask', publicJSON['comboValue'],descript);
		}
	},

	setValueWithOptionInList : function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function() {
		this.initializeFields();
		Ext.getCmp('vCTask').setFieldLabel(publicJSON['screenLabels']['admin.vctask.Task category']);
		Ext.getCmp('itemselect').fromField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.vctask.Included Tasks']);
		Ext.getCmp('itemselect').toField.getComponent(0).setTitle(publicJSON['screenLabels']['admin.vctask.Excluded Tasks']);
		Ext.getCmp('UpdateBTN').setText(publicJSON['screenLabels']['admin.common.Update']);

		if (fromPage == "TestConfiguration")
		{
			urlLink = "AgentSettings/data/EgConfigureVCTasksJson.jsp?descriptor="+descript+"&fromPage=TestConfiguration";
		}
		else
		{
			urlLink = "AgentSettings/data/EgConfigureVCTasksJson.jsp?descriptor="+descript;
		}
			Ext.Ajax.request({
			url: urlLink,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				if (Ext.getCmp('itemselect').fromField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselect').fromField.store.removeAll();
				}
				if (Ext.getCmp('itemselect').toField.store.getCount() >= 1)
				{
					Ext.getCmp('itemselect').toField.store.removeAll();
				}
				Ext.getCmp('itemselect').fromField.store.add(publicJSON['includedArray']);
				Ext.getCmp('itemselect').toField.store.add(publicJSON['excludedArray']);
			}
		});
	}

});



