Ext.define('AgentSettings.view.VcenterEvents', {
	extend: 'Ext.form.Panel',
	alias: 'widget.vcenterevents',
	cls:'outerpanel',
	border: false,
	id: 'vcenterevents',
	requires: [
		'utilities.ScrollCombo'
	],
	fieldDefaults: {
		labelSeparator: ' ',
	},

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+vCEventsPageDesc+'.</center>',
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '20 0 10 0',
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					id : 'vCEvents',
					name: 'vCEvents',
					fieldLabel: 'EventCategory',
					fieldName : 'EventCategory',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					editable: false,
					width: 350,
					parent:this,
					store:new Ext.data.Store ({
						fields: ['displayField','valueField'],
						data: []
					})
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: 10,
			items: [
				{
					xtype: 'itemselector',
					cls:'multiselect',
					name: 'itemselect',
					fieldName: 'itemselect',
					id: 'itemselect',
					buttons: ['add','remove'],
					buttonsText: {
						add: "Add to Excluded",
						remove: "Remove from Excluded"
					},
					store: new Ext.data.Store ({
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					height: 380,
					width: 700,
					fromTitle: 'INCLUDED EVENTS',
					toTitle: 'EXCLUDED EVENTS'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 20 0',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: 'Update',
					id: 'UpdateBTN',
					width: 80
				}
			]
		},
		{
			xtype: 'container',
			id: 'hiddencontainer',
			hidden: true
		}
	],

	tools: [
		{
			xtype : 'button',
			cls:'backbutton',
			iconCls:'iconBack',
			id : 'backevtbutton',
			text : bckText
		}
	]

});



