Ext.define('AgentSettings.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',

	requires: [
		'AgentSettings.view.SettingList',
		'AgentSettings.view.MainPane',
		'AgentSettings.view.ManagerAgentCommunication',
		'AgentSettings.view.RemoteControlCommand',
		'AgentSettings.view.VcenterTasks',
		'AgentSettings.view.VcenterEvents',
		'AgentSettings.view.DetailedDiagnosis',
		'Ext.ux.form.ItemSelectorSI',
		'Ext.ux.form.MultiSelectSI'
	],

	initComponent: function() {

		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}

		this.items = [
			{
				//xtype: 'panel',
				//cls:'outerpanel',
				bodyPadding:0,
				padding:0,
				frame:false,
				border:false,
				layout: 'border',
				items: [
					{
						region: 'west',
						xtype: 'settinglist',
						width:250,
						margin :'8 0 0 8',
						layout:{type:'vbox',align:'stretch'},
						collapsible:true,
						hideCollapseTool:true,
						scroll:false,
						autoScroll:false,
						split: true,
						collapsed:false,
						collapseMode :'mini',
						collapsed:(Ext.isEmpty(sessionStorage.getItem("borderCollapse"))?false:sessionStorage.getItem("borderCollapse")=='true'?true:false),
					},
					{
						region: 'center',
						cls:'outerpanel',
						xtype: 'mainpane',
						margin :'8 8 0 0',
						layout: 'fit',
						flex: 1,
						frame:true,
						hideCollapseTool:true,
						id: 'AgentSettingsRightPane'
					}
				]
			}
		];

		this.callParent();
	}
});



