Ext.define('AgentStatus.controller.AgentInfoCtrler',{
	extend:'Ext.app.Controller',
	views:['AgentInformation'],
	requires:['AgentStatus.view.AgentInformation'],
	refs:[
		{selector:'agentinformation', ref:'agentinformation'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'agentinformation':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildMainData: function(agentIP,debug)
	{
		Ext.Ajax.request(
		{
			url: "AgentStatus/data/EgAgentInfoJson.jsp?agentIp="+encodeURI(agentIP)+"&debug="+debug,
			method: 'POST',
			async:false,
			timeout: timeOut,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function(isAgentShared)
	{
		Ext.getCmp('agentIP').setValue(publicJSON.AgentIP);
		Ext.getCmp('autoUpgrade').setValue(publicJSON.AutoUpgrade);
		Ext.getCmp('lastUpgradePkg').setValue(publicJSON.LastUpgradedPackage);
		Ext.getCmp('lastUpgradeTime').setValue(publicJSON.LastUpgradedTime);
		Ext.getCmp('hostName').setValue(publicJSON.HostName);
		Ext.getCmp('os').setValue(publicJSON.OS);
		Ext.getCmp('version').setValue(publicJSON.Version);
		Ext.getCmp('jreVersion').setValue(publicJSON.JREVersion);
		Ext.getCmp('lastUpdate').setValue(publicJSON.LastUpdatedTime);
		Ext.getCmp('debugMode').setValue(publicJSON.DebugMode);
		Ext.getCmp('agentRestart').setValue(publicJSON.AgentRestartedTime);
		if (publicJSON.agentLogView)
		{
			Ext.getCmp('showLogs').show();
		}
		if(isAgentShared == "true")
		{
			Ext.getCmp('restartAgent').setDisabled(true);
			Ext.getCmp('showLogs').setDisabled(true);
		}
	}
});



