Ext.define('AgentStatus.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AgentStatusView'],
	requires:['AgentStatus.view.AgentStatusView'],
	refs:[
		{selector:'agentstatusview', ref:'agentstatusview'},
		{selector:'agentinformation', ref:'agentinformation'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'agentstatusview':
			{
				'afterrender': this.afterMainRender
			},
			//'agentstatusview trigger[id="searchBox"]':
			//{
				//'change': this.searchAgent
			//},
			'agentstatusview combo[id="agentType"]':
			{
				'select': this.agentTypeChange
			},
			'agentstatusview combo[id="agentStatus"]':
			{
				'select': this.agentStatusChange
			},
			'agentstatusview button[id="upgradeStatus"]':
			{
				'click':this.showUpgradeStatus
			},
			'agentstatusview button[id="restartAll"]':
			{
				'click':this.restartAllAgents
			},
			'agentstatusview button[id="homeBack"]':
			{
				'click': this.goHome
			},
			'agentstatusview  button[id="saveCSV"]':
			{
				'click': this.saveInCSVFormat
			},
			'agentinformation button[id="backbutton"]':
			{
				'click': this.goBack
			},
			'agentinformation button[id="restartAgent"]':
			{
				'click': this.restartAgentFrmAgentInfo
			},
			'agentinformation button[id="resetAgent"]':
			{
				'click': this.resetAgentFrmAgentInfo
			},
			'agentinformation button[id="showLogs"]':
			{
				'click': this.showLogsFrmAgentInfo
			},
			'agentinformation button[id="StopAgent"]':
			{
				'click': this.stopAgentButton
			},
			'agentinformation button[id="showXmx"]':
			{
				'click': this.showXmxFrmAgentInfo
			},
			'agentstatusview button[id="RemoteControl"]':
			{
				'click': this.callMonitorRemoteControl
			}
		});
	},
	buildMainData: function()
	{
		var agentType = 'PremiumAgents';
		var agentStatus = 'All';
		if (from == 'AdminHome' || from == 'AgentAssign')
		{
			agentType = selAgentType;
			agentStatus = selAgentStatus;
		}
		Ext.Ajax.request(
		{
			url: 'AgentStatus/data/EgServerListJson.jsp?agent='+agentType+'&status='+agentStatus,
			method: 'POST',
			async:false,
			timeout: timeOut*1000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		jsonDataHolder = publicJSON;
	},
	afterMainRender: function()
	{
		var me = this;
		var agentType = publicJSON.agentType;
		var agentStatus = publicJSON.agentState;
		var urlStr = 'AgentStatus/data/EgServerListJson.jsp?agent='+agentType+'&status='+agentStatus;

		if (showAgentInformationView == 'true')
		{
			var debug = "no";
			Ext.getCmp('agentstatusviewport').removeAll();
			this.getController('AgentStatus.controller.AgentInfoCtrler').buildMainData(selectedAgentIP,debug);
			Ext.getCmp('agentstatusviewport').add({ xtype: 'agentinformation' });
			this.getController('AgentStatus.controller.AgentInfoCtrler').afterMainRender();
			Ext.getCmp('agentIP').setValue(selectedAgentIP);
		}
		else
		{
			Ext.getCmp('agentType').getStore().loadRawData(publicJSON.agentTypes);
			Ext.getCmp('agentType').setValue(publicJSON.agentType);
			Ext.getCmp('agentStatus').getStore().loadRawData(publicJSON.agentStatus);
			Ext.getCmp('agentStatus').setValue(publicJSON.agentState);

			var noAgentsFound = publicJSON.noManagedHostsFound
			if (from == 'AdminHome')
			{
				noAgentsFound = !publicJSON.managedHostsFoundForSearch;
				Ext.getCmp('homeBack').show();
			}
			else if (from == 'AgentAssign')
			{
				var idx = backHref.indexOf('EgLicenseInfo.jsp');
				if(idx > -1)
				{
					Ext.getCmp('homeBack').show();
				}
			}
			else if (from == 'licenseoverview')
			{
				var idx = backHref.indexOf('EgLicenseInfo.jsp');
				if(idx > -1)
				{
					Ext.getCmp('homeBack').show();
				}
			}
			else
			{
				Ext.getCmp('homeBack').hide();
			}

			var getElObj = Ext.getCmp('agentStatusView').getEl();
			var getPanelObj = Ext.getCmp('resultpanel');
			getElObj.mask("Loading...","maskCenter");

			if ( publicJSON.enableSearch )
			{
				Ext.getCmp('saveCSV').enable();
				Ext.getCmp('resultpanel').show();
				Ext.getCmp('resultpanel').removeAll();


				var allUsersDataArr = publicJSON.agentDetails;
				if ( !Ext.isEmpty(allUsersDataArr))
				{
					Ext.define('GridModel', {
						extend: 'Ext.data.Model',
						fields: ['AgentIP', 'Installed', 'Status', 'Output', 'Restart', 'Logs', 'AssignedHosts','StopAgent', 'Xmx','isAgentShared','RemoteControl'],
					});

					 // create the Data Store
					var store = Ext.create('Ext.data.Store', {
						pageSize: 50,
						model: 'GridModel',
						proxy: {
							type: 'ajax',
							url: urlStr,
							reader: {
								type: 'json',
								root: 'agentDetails',
								totalProperty: 'totalProperty',
							},
							encodeFilters: function(filters) {
								return filters[0].value;
							}
						},
						storeId: 'store',
						remoteFilter: true,
						remoteSort: false
					});

					getPanelObj.add({
						xtype: 'customgrid',
						cls:'gridSkin',
						id:'agentInfoGrid',
						margin: 10,
						flex:1,
						//loadMask: true,
						scroll: true,
						height: 380,
						autoScroll: true,
						store: store,
						dockedItems:[{
							xtype: 'pagingtoolbar',
							id:'pagingtoolbarid',
							store: store,
							dock: 'bottom',
							cls:'pagingtoolbar',
							displayInfo: true
						}],
						requires : [
							'Ext.ux.CheckColumn',
							'Ext.ux.RowExpander',
						],
						columns: [
							{
								text: agentIPNick,
								dataIndex: 'AgentIP',
								flex: 1,
								renderer : function(value, metaData, record, row, store, gridView) {
									var agentNick = value.substring(0,value.indexOf('~'));
									var installed = value.substring(value.indexOf('~')+1);
									var result = "";
									if (installed == 'Yes')
									{
										result = '<a class="eg_monlink" href="javascript:ctrler.showAgentInfo('+row+',\'agentInfoGrid\')">'+agentNick+'</a>';
									}
									else
									{
										result = agentNick;
									}
									return result;
								}
							},
							{
								text: installed,
								dataIndex: 'Installed',
								width: 80,
								renderer : function(value) {
									var result = "";
									if (value == "Yes")
									{
										result='<center><div class="iconAgentInstalled" data-qtip="Agent Installed" data-qclass="yellowTip"></div></center>'
									}
									else
									{
										result='<center><div class="iconAgentNotInstalled" data-qtip="Agent Not Installed" data-qclass="yellowTip"></div></center>'
									}
									return result;
								}
							},
							{
								text: status,
								dataIndex: 'Status',
								width: 90,
								renderer : function(value) {
									var result = "";
									if (value == "Running")
									{
										result = '<center><img src="/final/images/'+theme+'/agentRunning.gif" border="0" vspace="0" data-qtip="Agent Running" data-qclass="yellowTip" valign="middle"></center>';
									}
									else
									{
										result = '<center><img src="/final/images/'+theme+'/agentNotRunning.gif" border="0" vspace="0" data-qtip="Agent Not Running" data-qclass="yellowTip" valign="middle"></center>';
									}
									return result;
								}
							},
							{
								xtype: 'checkcolumn',
								text: opLog,
								dataIndex: 'Output',
								width: 190,
								listeners: {
									checkchange: function (column, row, checked) {
										var rowObj = Ext.getCmp('agentInfoGrid').getStore().getAt(row);
										var installed = rowObj.get('Installed');
										if (rowObj.get('Status')=='Running' && installed == 'Yes' && !ctrler.disableAgentDebug(rowObj.get('AgentIP')))
										{
											ctrler.outputLoggingChange(checked,row,'agentInfoGrid')
										}
										else
										{
											if (checked)
											{
												rowObj.set('Output',false);
											}
											else
											{
												rowObj.set('Output',true);
											}
											return false;
										}
									}
								},
								renderer:function(value, metaData, record)
								{
									var agentSharedValue = record.get('isAgentShared');
									var setDisableOutputLogging = agentSharedValue.substring(agentSharedValue.indexOf('~')+1);
									if(ctrler.disableAgentDebug(record.get('AgentIP')))
									{
										var ccObj = new Ext.ux.CheckColumn().renderer(value);
										metaData.tdCls += ' '+'x-item-disabled';
										metaData.tdAttr = 'data-qtip= "' + 'Output logging has been manully enabled' + '" data-qclass="tipCls" data-qwidth=215';
										return ccObj;
									}
									if (setDisableOutputLogging == "true")
									{
										var ccObj = new Ext.ux.CheckColumn().renderer(value);
										metaData.tdCls += ' '+'x-item-disabled';
										return ccObj;
										//return '<div class="custom-form-checkbox" style="margin:-5px 0 0 86px;padding:10px;"></div>';
									}
									else
									{
										var ccObj = new Ext.ux.CheckColumn().renderer(value);
										return ccObj;
									}
								}
							},
							{
								text: logs,
								dataIndex: 'Logs',
								width: 50,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									if (value == "Show")
									{
										result = '<center><a href="javascript:ctrler.showLogs('+row+',\'agentInfoGrid\');"><div class="iconData" data-qtip="Agent Logs" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result='<center><div class="iconData" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Logs" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text: restart,
								dataIndex: 'Restart',
								width: 80,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									var opt = value.substring(0,value.indexOf('~'));
									var nick = value.substring(value.indexOf('~')+1);
									if (opt == "Yes")
									{
										result = '<center><a href="javascript:ctrler.restartAgent('+row+',\'agentInfoGrid\');"><div class="iconRestart"  data-qtip="Agent Restart" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result = '<center><div class="iconRestart"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Restart" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text: stopAgent,
								dataIndex: 'StopAgent',
								width: 50,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									var opt = value.substring(0,value.indexOf('~'));
									var nick = value.substring(value.indexOf('~')+1);
									if (opt == "Yes")
									{
										result = '<center><a href="javascript:ctrler.stopAgentButton('+row+',\'agentInfoGrid\');"><div class="iconStop"  data-qtip="Agent Stop" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result = '<center><div class="iconStop"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Stop Agent" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text: xmx,
								dataIndex: 'Xmx',
								width: 50,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									if (value == "Show")
									{
										result = '<center><a href="javascript:ctrler.showXmx('+row+',\'agentInfoGrid\');"><div class="iconSettings" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result='<center><div class="iconSettings" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							},
							{
								text:assoHosts,
								dataIndex: 'AssignHostsLink',
								width: 125,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									result = "";
									var result = '<center><a href="javascript:ctrler.showAssignHosts('+row+',\'agentInfoGrid\');"><div class="iconShowAssociates"  data-qtip="Associate hosts" data-qclass="yellowTip"></div></a></center>';
									return result;
								}
							},
							{
								text: agentShared,
								dataIndex: 'isAgentShared',
								hidden: true,
								width: 125,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var isAgentShared = value.substring(0,value.indexOf('~'));
									var setDisableOutputLogging = value.substring(value.indexOf('~')+1);
									result = "";
									var result = '<center>'+isAgentShared+'</center>';
									return result;
								}
							},
							{
								text: remotecontrol,
								dataIndex: 'RemoteControl',
								width: 120,
								sortable: false,
								renderer : function(value, metaData, record, row, store, gridView) {
									var result = "";
									var idx = value.indexOf('~');
									var last_idx = value.lastIndexOf('~');
									var opt = value.substring(0,idx);
									var nick = value.substring(idx+1,last_idx);
									var mode = value.substring(last_idx+1);
									if (opt == "Yes")
									{
										result = '<center><a href="javascript:ctrler.callMonitorRemoteControl('+row+',\'agentInfoGrid\',\''+mode+'\');"><div class="iconRemoteControl"  data-qtip="Remote Control" data-qclass="yellowTip"></div></a></center>';
									}
									else
									{
										result = '<center><div class="iconRemoteControl"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Remote Control" data-qclass="yellowTip"></div></center>';
									}
									return result;
								}
							}
						],
						plugins: [
							{
								ptype: 'rowexpander',
								expandOnDblClick: false,
								id:'rowExp',
								rowBodyTpl : [
									'{[this.getRowView(values)]}',
									{
										getRowView : function(values)
										{
											var viewStr = '<div><p><i>Assigned hosts</i></p></div>';
											var agentNames = values.AssignedHosts;
											if (agentNames.indexOf('-') == 0)
											{
												viewStr += agentNames;
											}
											else
											{
												var vals = agentNames.split(',');
												var valsLen = vals.length;
												var rem = valsLen%3;
												if (rem != 0)
												{
													var tmp = 3 - rem;
													for (var t=0; t<tmp; t++)
													{
														agentNames +=', ';
													}
													vals = agentNames.split(',');
												}
												viewStr = '<div><p><i>Assigned hosts ('+valsLen+')</i></p></div>';
												viewStr += "<table border='0' width='100%'>";
												for (var v=0; v < vals.length; v=v+3)
												{
													viewStr += "<tr><td>"+vals[v]+"</td><td>"+vals[v+1]+"</td><td>"+vals[v+2]+"</td></tr>";
												}
												viewStr += "</table>";
											}
											return viewStr;
										}
									}
								]
							}
						],
						tbar: [
							{
								xtype:'displayfield',
								fieldLabel:numberOfAgents,
								labelSeparator: ' :',
								id:'totalAgents',
								height:20,
								labelWidth:150
							},
							{
								xtype:'tbfill',
							},
							{
								xtype: 'trigger',
								cls:'whitedropdown_search',
								trigger1Cls: 'x-form-clear-trigger',
								trigger2Cls: 'x-form-search-trigger',
								emptyText: 'Search',
								padding: '2 6 2 0',
								disabled:true,
								onTrigger1Click: function() {
									this.reset();
								},
								onTrigger2Click: function() {
									ctrler.onSearchAction(this);
									//ctrler.searchAgent();
								},
								listeners:{
									specialkey: function(field, e){
										if (e.getKey() == e.ENTER) {
											ctrler.onSearchAction(this);
										}
									}
								},
								id: 'searchBox',
								itemId: 'searchTrigger',
								getTriggerMarkup: function() {
									var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
									// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
									// single triggerCls config. Should rethink this, perhaps something more structured like a list of
									// trigger config objects that hold cls, handler, etc.
									// triggerCls is a synonym for trigger1Cls, so copy it.
									if (!me.trigger1Cls) {
										me.trigger1Cls = me.triggerCls;
									}
									// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
									for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
										if (i == 0)
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style + "display:none;",
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
										else
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style,
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
									}
									triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
									return Ext.DomHelper.markup(triggerConfigs);
								}
							}
						]
					});
					store.load();
				}

				var totalAgent = publicJSON.totalProperty;
				if (!Ext.isEmpty(totalAgent))
				{
					Ext.getCmp('totalAgents').show();
					Ext.getCmp('totalAgents').setValue(totalAgent);
				}
				else
				{
					Ext.getCmp('totalAgents').hide();
				}

				if (isLimitedAdmin == "true")
				{
					Ext.getCmp('restartAll').hide();
				}
				else
				{
					Ext.getCmp('restartAll').show();
				}

				Ext.getCmp('saveCSV').show();
				if (publicJSON.enableSearch)
				{
					if (me.getAgentstatusview().down('#searchTrigger'))
					{
						me.getAgentstatusview().down('#searchTrigger').enable();
					}
					Ext.getCmp('totalAgents').enable();
				}

				if (publicJSON.agentType=='ExternalAgents' || publicJSON.agentType=='RemoteAgents')
				{
					Ext.getCmp('agentInfoGrid').columns[0].setVisible(true);
					if(isLimitedAdmin == "false")
					{
						Ext.getCmp('agentInfoGrid').columns[9].setVisible(true);
					}
				}
				else
				{
					Ext.getCmp('agentInfoGrid').columns[0].setVisible(false);
					Ext.getCmp('agentInfoGrid').columns[9].setVisible(false);
				}
			}
			else
			{
				Ext.getCmp('resultpanel').hide();
				Ext.getCmp('resultpanel').removeAll();
				if (me.getAgentstatusview().down('#searchTrigger'))
				{
					me.getAgentstatusview().down('#searchTrigger').disable();
				}

				Ext.getCmp('restartAll').hide();
				Ext.getCmp('saveCSV').disable();
			//	Ext.getCmp('totalAgents').hide();
				Ext.getCmp('NoUserAvailable').show();
			}

			getPanelObj.doLayout();
			getElObj.unmask();
		}
		if(isFromRemoteControlPage=='yes' || isFromRemoteControlPage=='true')
		{
			Ext.getCmp('agentType').setValue(sel_agent_type);
			Ext.getCmp('agentStatus').setValue('All');
			this.agentTypeChange();
		}
	},

	onSearchAction: function(obj)
	{
		var store = Ext.getStore("store");
		if (Ext.isEmpty(obj))
		{
			value = Ext.getCmp('searchBox').getValue();
		}
		else
		{
			value = obj.getValue();
		}

		Ext.getCmp('totalAgents').hide();
		Ext.getCmp('saveCSV').disable();

		store.clearFilter(true);
		if(value)
		{
			store.filter('AgentIP', value);
		}
		//store.load();
		var getElObj = Ext.getCmp('agentStatusView').getEl();
		var getPanelObj = Ext.getCmp('resultpanel');
		getElObj.mask("Loading...","maskCenter");

		store.load(
				function(records, operation, success) {
				// the operation object
				// contains all of the details of the load operation
				if (success)
				{
					var emptyMsg = "No data found";
					var jsonTxt = operation.response.responseText;
					var jsonObj = Ext.decode(jsonTxt);
					jsonDataHolder = jsonObj;
					var resultMsg = jsonObj.totalProperty;

					if (!Ext.isEmpty(resultMsg))
					{
						Ext.getCmp('totalAgents').show();
						Ext.getCmp('totalAgents').setValue(resultMsg);
					}

					if (jsonObj.totalProperty == 0)
					{
						Ext.getCmp('saveCSV').disable();
						Ext.getCmp('restartAll').hide();
						Ext.getCmp('totalAgents').hide();

						Ext.getCmp('agentInfoGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="250"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noAgentsFound+'.</td></tr></table></td></tr></table>';
					}
					else
					{
						Ext.getCmp('saveCSV').enable();
						Ext.getCmp('totalAgents').show();

						if (isLimitedAdmin == "true")
						{
							Ext.getCmp('restartAll').hide();
						}
						else
						{
							Ext.getCmp('restartAll').show();
						}
						Ext.getCmp('agentInfoGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="250"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noAgentsFound+'.</td></tr></table></td></tr></table>';
					}

					Ext.getCmp('agentInfoGrid').getView().refresh();
				}
			}
		);

		getPanelObj.doLayout();
		getElObj.unmask();

    },
	searchAgent: function()
	{
		var agentType = Ext.getCmp('agentType').getValue();
		var agentStatus = Ext.getCmp('agentStatus').getValue();
		var searchStr = Ext.getCmp('searchBox').getValue();
		searchStr = encodeURIComponent(searchStr);
		var urlStr = 'AgentStatus/data/EgServerListJson.jsp?search=true&agent='+agentType+'&status='+agentStatus;
		if (searchStr != '')
		{
			urlStr += '&hostname='+searchStr;
		}
		if (searchStr == "" || searchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
       if (jsonDataHolder.search=='true')
		{
			var gridObj = Ext.getCmp('agentInfoGrid');
			//Setting the value of Number of agent field if Search result is true.
			var totalAgent=jsonDataHolder.totalNoAgent;
			Ext.getCmp('totalAgents').setValue(totalAgent);
			if (jsonDataHolder.managedHostsFoundForSearch)
			{
				if (isLimitedAdmin == "true")
				{
					Ext.getCmp('restartAll').hide();
				}
				else
				{
					Ext.getCmp('restartAll').show();
				}
				Ext.getCmp('saveCSV').show();
				Ext.getCmp('totalAgents').enable();
				gridObj.show();
				gridObj.getStore().removeAll();
				gridObj.getStore().loadRawData(jsonDataHolder.agentDetails);
				if (jsonDataHolder.agentType=='ExternalAgents' || jsonDataHolder.agentType=='RemoteAgents')
				{
					gridObj.columns[0].setVisible(true);
					if(isLimitedAdmin == "false")
					{
						gridObj.columns[9].setVisible(true);
					}
				}
				else
				{
					gridObj.columns[0].setVisible(false);
					gridObj.columns[9].setVisible(false);
				}
			}
			else 
			{
				Ext.getCmp('restartAll').hide();
				Ext.getCmp('saveCSV').hide();
				//Disabling the Total number of Agent field if Search result is false.
				Ext.getCmp('totalAgents').disable();
				gridObj.show();
				gridObj.getStore().removeAll();
				Ext.get('noAgentAlrtDiv').update(noAgentsFound+'.');
			}
		}
	},
	agentTypeChange: function()
	{
		var me = this;
		var agentType = Ext.getCmp('agentType').getValue();
		var agentStatus = Ext.getCmp('agentStatus').getValue();
		var urlStr = 'AgentStatus/data/EgServerListJson.jsp?agent='+agentType+'&status='+agentStatus;
		var srcBoxObj = Ext.getCmp('searchBox');
		var srcStr = '';
		if (srcBoxObj != null)
		{
			srcStr = srcBoxObj.getValue();
			srcStr = encodeURIComponent(srcStr);
			if (srcStr != '')
			{
				urlStr += '&search=true&hostname='+srcStr;
			}
		}
		
		var getElObj = Ext.getCmp('agentStatusView').getEl();
		var getPanelObj = Ext.getCmp('resultpanel');
		getElObj.mask("Loading...","maskCenter");

		Ext.getCmp('resultpanel').hide();
		Ext.getCmp('NoUserAvailable').hide();


		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			//async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);

				//Ext.getCmp('agentType').getStore().loadRawData(jsonDataHolder.agentTypes);
				//Ext.getCmp('agentType').setValue(jsonDataHolder.agentType);
				//Ext.getCmp('agentStatus').getStore().loadRawData(jsonDataHolder.agentStatus);
				//Ext.getCmp('agentStatus').setValue(jsonDataHolder.agentState);
				//Setting the value for number of Agents field If Agents for Particular Agent Type is displayed.


				if (jsonDataHolder.enableSearch)
				{
					Ext.getCmp('saveCSV').enable();
					Ext.getCmp('resultpanel').show();
					Ext.getCmp('resultpanel').removeAll();
					Ext.getCmp('NoUserAvailable').hide();

					var allUsersDataArr = jsonDataHolder.agentDetails;
					if ( !Ext.isEmpty(allUsersDataArr))
					{
						Ext.define('GridModel', {
							extend: 'Ext.data.Model',
							fields: ['AgentIP', 'Installed', 'Status', 'Output', 'Restart', 'Logs', 'AssignedHosts','StopAgent', 'Xmx','isAgentShared','RemoteControl'],
						});

						 // create the Data Store
						var store = Ext.create('Ext.data.Store', {
							pageSize: 50,
							model: 'GridModel',
							proxy: {
								type: 'ajax',
								url: urlStr,
								reader: {
									type: 'json',
									root: 'agentDetails',
									totalProperty: 'totalProperty',
								},
								encodeFilters: function(filters) {
									return filters[0].value;
								}
							},
							storeId: 'store',
							remoteFilter: true,
							remoteSort: false
						});

						getPanelObj.add({
							xtype: 'customgrid',
							cls:'gridSkin',
							id:'agentInfoGrid',
							margin: 10,
							flex:1,
							//loadMask: true,
							scroll: true,
							height: 380,
							autoScroll: true,
							store: store,
							dockedItems:[{
								xtype: 'pagingtoolbar',
								id:'pagingtoolbarid',
								store: store,
								dock: 'bottom',
								cls:'pagingtoolbar',
								displayInfo: true
							}],
							requires : [
								'Ext.ux.CheckColumn',
								'Ext.ux.RowExpander',
							],
							plugins: [
								{
									ptype: 'rowexpander',
									expandOnDblClick: false,
									id:'rowExp',
									rowBodyTpl : [
									//	'<p><b>Assigned hosts</b><br>{AssignedHosts}</p>'
										'{[this.getRowView(values)]}',
										{
											getRowView : function(values)
											{
												var viewStr = '<div><p><i>Assigned hosts</i></p></div>';
												var agentNames = values.AssignedHosts;
												if (agentNames.indexOf('-') == 0)
												{
													viewStr += agentNames;
												}
												else
												{
													var vals = agentNames.split(',');
													var valsLen = vals.length;
													var rem = valsLen%3;
													if (rem != 0)
													{
														var tmp = 3 - rem;
														for (var t=0; t<tmp; t++)
														{
															agentNames +=', ';
														}
														vals = agentNames.split(',');
													}
													viewStr = '<div><p><i>Assigned hosts ('+valsLen+')</i></p></div>';
													viewStr += "<table border='0' width='100%'>";
													for (var v=0; v < vals.length; v=v+3)
													{
														viewStr += "<tr><td>"+vals[v]+"</td><td>"+vals[v+1]+"</td><td>"+vals[v+2]+"</td></tr>";
													}
													viewStr += "</table>";
												}
												return viewStr;
											}
										}
									]
								}
							],
							columns: [
								{
									text: agentIPNick,
									dataIndex: 'AgentIP',
									flex: 1,
									renderer : function(value, metaData, record, row, store, gridView) {
										var agentNick = value.substring(0,value.indexOf('~'));
										var installed = value.substring(value.indexOf('~')+1);
										var result = "";
										if (installed == 'Yes')
										{
											result = '<a class="eg_monlink" href="javascript:ctrler.showAgentInfo('+row+',\'agentInfoGrid\')">'+agentNick+'</a>';
										}
										else
										{
											result = agentNick;
										}
										return result;
									}
								},
								{
									text: installed,
									dataIndex: 'Installed',
									width: 80,
									renderer : function(value) {
										var result = "";
										if (value == "Yes")
										{
											result='<center><div class="iconAgentInstalled" data-qtip="Agent Installed" data-qclass="yellowTip"></div></center>'
										}
										else
										{
											result='<center><div class="iconAgentNotInstalled" data-qtip="Agent Not Installed" data-qclass="yellowTip"></div></center>'
										}
										return result;
									}
								},
								{
									text: status,
									dataIndex: 'Status',
									width: 90,
									renderer : function(value) {
										var result = "";
										if (value == "Running")
										{
											result = '<center><img src="/final/images/'+theme+'/agentRunning.gif" border="0" vspace="0" data-qtip="Agent Running" data-qclass="yellowTip" valign="middle"></center>';
										}
										else
										{
											result = '<center><img src="/final/images/'+theme+'/agentNotRunning.gif" border="0" vspace="0" data-qtip="Agent Not Running" data-qclass="yellowTip" valign="middle"></center>';
										}
										return result;
									}
								},
								{
									xtype: 'checkcolumn',
									text: opLog,
									dataIndex: 'Output',
									width: 190,
									listeners: {
										checkchange: function (column, row, checked) {
											var rowObj = Ext.getCmp('agentInfoGrid').getStore().getAt(row);
											var installed = rowObj.get('Installed');
											if (rowObj.get('Status')=='Running' && installed == 'Yes' && !ctrler.disableAgentDebug(rowObj.get('AgentIP')))
											{
												ctrler.outputLoggingChange(checked,row,'agentInfoGrid')
											}
											else
											{
												if (checked)
												{
													rowObj.set('Output',false);
												}
												else
												{
													rowObj.set('Output',true);
												}
												return false;
											}
										}
									},
									renderer:function(value, metaData, record)
									{
										var agentSharedValue = record.get('isAgentShared');
										var setDisableOutputLogging = agentSharedValue.substring(agentSharedValue.indexOf('~')+1);
										if(ctrler.disableAgentDebug(record.get('AgentIP')))
										{
											var ccObj = new Ext.ux.CheckColumn().renderer(value);
											metaData.tdCls += ' '+'x-item-disabled';
											metaData.tdAttr = 'data-qtip= "' + 'Output logging has been manully enabled' + '" data-qclass="tipCls" data-qwidth=215';
											return ccObj;
										}
										if (setDisableOutputLogging == "true")
										{
											var ccObj = new Ext.ux.CheckColumn().renderer(value);
											metaData.tdCls += ' '+'x-item-disabled';
											return ccObj;
										}
										else
										{
											var ccObj = new Ext.ux.CheckColumn().renderer(value);
											return ccObj;
										}
									}
								},
								{
									text: logs,
									dataIndex: 'Logs',
									width: 50,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										if (value == "Show")
										{
											result = '<center><a href="javascript:ctrler.showLogs('+row+',\'agentInfoGrid\');"><div class="iconData" data-qtip="Agent Logs" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result='<center><div class="iconData" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Logs" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text: restart,
									dataIndex: 'Restart',
									width: 80,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										var opt = value.substring(0,value.indexOf('~'));
										var nick = value.substring(value.indexOf('~')+1);
										if (opt == "Yes")
										{
											result = '<center><a href="javascript:ctrler.restartAgent('+row+',\'agentInfoGrid\');"><div class="iconRestart"  data-qtip="Agent Restart" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result = '<center><div class="iconRestart"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Restart" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text: stopAgent,
									dataIndex: 'StopAgent',
									width: 50,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										var opt = value.substring(0,value.indexOf('~'));
										var nick = value.substring(value.indexOf('~')+1);
										if (opt == "Yes")
										{
											result = '<center><a href="javascript:ctrler.stopAgentButton('+row+',\'agentInfoGrid\');"><div class="iconStop"  data-qtip="Agent Stop" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result = '<center><div class="iconStop"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Stop Agent" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text: xmx,
									dataIndex: 'Xmx',
									width: 50,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										if (value == "Show")
										{
											result = '<center><a href="javascript:ctrler.showXmx('+row+',\'agentInfoGrid\');"><div class="iconSettings" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result='<center><div class="iconSettings" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								},
								{
									text:assoHosts,
									dataIndex: 'AssignHostsLink',
									width: 125,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										result = "";
										var result = '<center><a href="javascript:ctrler.showAssignHosts('+row+',\'agentInfoGrid\');"><div class="iconShowAssociates"  data-qtip="Associate hosts" data-qclass="yellowTip"></div></a></center>';
										return result;
									}
								},
								{
									text: agentShared,
									dataIndex: 'isAgentShared',
									hidden: true,
									width: 125,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var isAgentShared = value.substring(0,value.indexOf('~'));
										var setDisableOutputLogging = value.substring(value.indexOf('~')+1);
										result = "";
										var result = '<center>'+isAgentShared+'</center>';
										return result;
									}
								},
								{
									text: remotecontrol,
									dataIndex: 'RemoteControl',
									width: 120,
									sortable: false,
									renderer : function(value, metaData, record, row, store, gridView) {
										var result = "";
										var idx = value.indexOf('~');
										var last_idx = value.lastIndexOf('~');
										var opt = value.substring(0,idx);
										var nick = value.substring(idx+1,last_idx);
										var mode = value.substring(last_idx+1);
										if (opt == "Yes")
										{
											result = '<center><a href="javascript:ctrler.callMonitorRemoteControl('+row+',\'agentInfoGrid\',\''+mode+'\');"><div class="iconRemoteControl"  data-qtip="Remote Control" data-qclass="yellowTip"></div></a></center>';
										}
										else
										{
											result = '<center><div class="iconRemoteControl"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Remote Control" data-qclass="yellowTip"></div></center>';
										}
										return result;
									}
								}
							],
							tbar: [
								{
									xtype:'displayfield',
									fieldLabel:numberOfAgents,
									labelSeparator: ' :',
									id:'totalAgents',
									height:20,
									labelWidth:150
								},
								{
									xtype:'tbfill',
								},
								{
									xtype: 'trigger',
									cls:'whitedropdown_search',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger',
									emptyText: 'Search',
									padding: '2 6 2 0',
									disabled:true,
									onTrigger1Click: function() {
										this.reset();
									},
									onTrigger2Click: function() {
										ctrler.onSearchAction(this);
										//ctrler.searchAgent();
									},
									listeners:{
										specialkey: function(field, e){
											if (e.getKey() == e.ENTER) {
												ctrler.onSearchAction(this);
											}
										}
									},
									id: 'searchBox',
									itemId: 'searchTrigger',
									getTriggerMarkup: function() {
										var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
										// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
										// single triggerCls config. Should rethink this, perhaps something more structured like a list of
										// trigger config objects that hold cls, handler, etc.
										// triggerCls is a synonym for trigger1Cls, so copy it.
										if (!me.trigger1Cls) {
											me.trigger1Cls = me.triggerCls;
										}
										// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
										for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
											if (i == 0)
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style + "display:none;",
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
											else
											{
												triggerConfigs.push({
													tag: 'td',
													role: 'presentation',
													valign: 'top',
													cls: cls,
													id : 'MyTrigger_'+i,
													style: style,
													cn: {
														cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
														role: 'presentation'
													}
												});
											}
										}
										triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
										return Ext.DomHelper.markup(triggerConfigs);
									}
								}
							]
						});
						store.load();
					}

					var totalAgent=jsonDataHolder.totalProperty;
					Ext.getCmp('totalAgents').setValue(totalAgent);

					if (isLimitedAdmin == "true")
					{
						Ext.getCmp('restartAll').hide();
					}
					else
					{
						Ext.getCmp('restartAll').show();
					}

					Ext.getCmp('saveCSV').show();
					if (jsonDataHolder.enableSearch)
					{
						if (me.getAgentstatusview().down('#searchTrigger'))
						{
							me.getAgentstatusview().down('#searchTrigger').enable();
						}
						Ext.getCmp('totalAgents').enable();
					}

					if (jsonDataHolder.agentType=='ExternalAgents' || jsonDataHolder.agentType=='RemoteAgents')
					{
						Ext.getCmp('agentInfoGrid').columns[0].setVisible(true);
						if(isLimitedAdmin == "false")
						{
							Ext.getCmp('agentInfoGrid').columns[9].setVisible(true);
						}
					}
					else
					{
						Ext.getCmp('agentInfoGrid').columns[0].setVisible(false);
						Ext.getCmp('agentInfoGrid').columns[9].setVisible(false);
					}
				}
				else
				{
					if (me.getAgentstatusview().down('#searchTrigger'))
					{
						me.getAgentstatusview().down('#searchTrigger').disable();
					}

					Ext.getCmp('restartAll').hide();
					Ext.getCmp('saveCSV').disable();
					Ext.getCmp('NoUserAvailable').show();
				}

				getPanelObj.doLayout();
				getElObj.unmask();

			},
			failure : function(response)
			{
				getPanelObj.doLayout();
				getElObj.unmask();
			}
		});
	},
	agentStatusChange: function()
	{
		this.agentTypeChange();
	},
	showUpgradeStatus:function()
	{
		window.location.href="/final/admin/EgUpgradeStatus.jsp?fromPage=AgentStatus";
	},
	restartAllAgents:function()
	{
		Ext.Msg.show({
			title: restartAll,
			msg: confirmMsg3,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var urlStr = "AgentStatus/data/EgAllAgentsRestartJson.jsp";
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							
							if (resultJSON.ResultAlert)
							{
								Ext.Msg.show({
									title:resultJSON.ResultTitle,
									msg:resultJSON.ResultMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
						}
					});
				}
			}
		});
	},
	restartAgent: function(row,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		Ext.Msg.show({
			title: restartAgent,
			msg: confirmMsg1+" '"+agentNick+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'This process will take few minutes. Please wait...'});
					tmpMask.show();
					var urlStr = "AgentStatus/data/EgAgentRestartJson.jsp?mode=main&agentIp="+encodeURI(agentNick)+"&agentOs=";
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							var requestStatus = resultJSON.requestStatus;
							var msgStr = resultJSON.Msg;
							if (requestStatus=='Success')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}else if (requestStatus=='Failure')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						},
						failure: function( response )
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	showAgentInfo : function(row,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var output = obj.get('Output');
		var isAgentShared = obj.get('isAgentShared');
		isAgentShared = isAgentShared.substring(0,isAgentShared.indexOf('~'));
		var debug = "no";
		if (output)
		{
			debug = "yes";
		}
		Ext.getCmp('agentstatusviewport').removeAll();
		Ext.getCmp('agentstatusviewport').add({
			xtype: 'agentinformation'
		});
		this.getController('AgentStatus.controller.AgentInfoCtrler').buildMainData(agentNick,debug);
		this.getController('AgentStatus.controller.AgentInfoCtrler').afterMainRender(isAgentShared); 
	},
	goBack : function()
	{
		if(showAgentInformationView=='true')
		{
			window.location.href="/final/admin/AdvanceSearch.jsp";
		}
		else
		{
			Ext.getCmp('agentstatusviewport').removeAll();
			this.getController('AgentStatus.controller.Main').buildMainData();
			Ext.getCmp('agentstatusviewport').add(
				{
					xtype: 'agentstatusview'
				});
			this.getController('AgentStatus.controller.Main').afterMainRender();
		}
	},
	goHome : function()
	{
		window.location.href = backHref;
	},
	saveInCSVFormat: function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage;
	},
	restartAgentFrmAgentInfo : function()
	{
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		Ext.Msg.show({
			title: restartAgent,
			msg: confirmMsg1+" '"+publicJSON.AgentIP+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Please wait...'});
					tmpMask.show();
					var urlStr = "AgentStatus/data/EgAgentRestartJson.jsp?mode=info&agentIp="+encodeURI(publicJSON.AgentIP)+"&agentOs="+publicJSON.OS;
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							var requestStatus = resultJSON.requestStatus;
							var msgStr = resultJSON.Msg;
							if (requestStatus=='Success')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
							else if (requestStatus=='Failure')
							{
								Ext.Msg.show({
									title:restartAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						},
						failure: function(response)
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	resetAgentFrmAgentInfo : function()
	{
		var urlStr = "AgentStatus/data/EgagentinfopJson.jsp?agentIp="+encodeURI(publicJSON.AgentIP);
		Ext.Ajax.request({
			url: urlStr,
			method: 'POST',
			timeout: timeOut*1000,
			success: function( response )
			{
				var jsonText = response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if (resultJSON.ResultAlert)
				{
					Ext.Msg.show({
						title:resultJSON.ResultTitle,
						msg:resultJSON.ResultMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				}
			}
		});
	},
	showLogsFrmAgentInfo:function()
	{
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title:pageTitle2,
				msg:agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else if(showAgentInformationView=='true')
		{
			window.location.href="/final/admin/EgAgentLogView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug+'&showAgentInformationView=true';
		}
		else
		{
			window.location.href="/final/admin/EgAgentLogView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug;
		}
	},
	showLogs:function(rowIdx,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		window.location.href="/final/admin/EgAgentLogView.jsp?componentName="+encodeURI(agentNick);
	},
	showXmxFrmAgentInfo:function()
	{
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title:pageTitle2,
				msg:agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}
		else if(showAgentInformationView=='true')
		{
			window.location.href="/final/admin/EgAgentXmxView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug+'&showAgentInformationView=true';
		}
		else
		{
			window.location.href="/final/admin/EgAgentXmxView.jsp?componentName="+encodeURI(publicJSON.AgentIP)+"&debug="+publicJSON.debug;
		}
	},
	showXmx:function(rowIdx,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		window.location.href="/final/admin/EgAgentXmxView.jsp?componentName="+encodeURI(agentNick);
	},
	showAssignHosts: function(rowIdx,gridID)
	{
		var agentType = Ext.getCmp('agentType').getValue();
		var  grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));

		if (agentType=='RemoteAgents')
		{
			window.location.href="/final/admin/EgRemoteAgents.jsp?from=AgentStatus&fromAssignRem=true&eagent="+agentNick;
		}
		else
		{
			window.location.href="/final/admin/EgExternalAgents.jsp?from=AgentStatus&fromAssignExt=true&eagent="+agentNick;
		}
	},
	outputLoggingChange: function(checked, rowIdx, gridID)
	{
		var grid = Ext.getCmp(gridID);
		var row = grid.getStore().getAt(rowIdx);
		var agentNick = row.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var agentType = jsonDataHolder.agentType;
		var agentIP = jsonDataHolder[agentNick+"_IP"];		
		var outputNeeded = "No";
		if (checked)
		{
			outputNeeded = "Yes";
		}
		var me = this;
		Ext.Msg.show({
			title: agentLogEnable,
			msg: confirmMsg2+"   '"+agentNick+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var loadingMsg = loadingMsg1 +' '+ plsWait;
					if (checked)
					{
						loadingMsg = loadingMsg2 +' '+ plsWait;
					}
					var urlStr = "AgentStatus/data/changeAgentOutputFileJson.jsp?agentID="+encodeURI(agentNick)+"&s_output="+outputNeeded+"&agentType="+agentType+"&agent_ip_address="+agentIP;
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: loadingMsg});
					tmpMask.show();
					me.getAgentstatusview().submit({
						url: urlStr,
						method: 'POST',
						timeout: timeOut,
						success: function(form, action)
						{
							tmpMask.hide();
							var jsonText = action.response.responseText;
							var resultJSON = Ext.decode(jsonText);
							if(resultJSON.ResultAlert)
							{
								Ext.Msg.show({
									title:resultJSON.ResultTitle,
									msg:resultJSON.ResultMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function(response) 
									{
										if(response == 'ok')
										{
											//me.buildMainData();
											//me.afterMainRender();
											me.agentTypeChange();
										}
									}
								});
							}
						},
						failure: function(form, action)
						{
							 tmpMask.hide();
						}
					});
				}
				else if (response == 'no' || response == 'cancel')
				{
					if (checked)
					{
						row.set('Output',false);
					}
					else
					{
						row.set('Output',true);
					}
				}
			}
		});
	},
	stopAgentButton : function(row,gridID)
	{
		var  grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		if(agentRunningStatus=='notrunning')
		{
			Ext.Msg.show({
				title: pageTitle2,
				msg: agentNotReporting,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		Ext.Msg.show({
			title: stopAgent,
			msg: confirmMsg_stop+" '"+agentNick+"'"+"?",
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) 
			{
				if(response == 'yes')
				{
					var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Please wait...'});
					tmpMask.show();
					var urlStr = "AgentStatus/data/stopAgentJson.jsp?agentIp="+encodeURI(agentNick);
					Ext.Ajax.request({
						url: urlStr,
						method: 'POST',
						timeout: timeOut*1000,
						success: function( response )
						{
							tmpMask.hide();
							var jsonText = response.responseText;
							var resultJSON = Ext.decode(jsonText);
							var requestStatus = resultJSON.requestStatus;
							var msgStr = resultJSON.Msg;
							if (requestStatus=='Success')
							{
								Ext.Msg.show({
									title:stopAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
							}
							else if (requestStatus=='Failure')
							{
								Ext.Msg.show({
									title:stopAlrtTitle,
									msg:msgStr,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						},
						failure: function(response)
						{
							tmpMask.hide();
						}
					});
				}
			}
		});
	},
	callMonitorRemoteControl:function(row,gridID,mode)
	{
		var agent_type = Ext.getCmp('agentType').getValue();
		var grid = Ext.getCmp(gridID);
		var obj = grid.getStore().getAt(row);
		var agentNick = obj.get('AgentIP');
		agentNick = agentNick.substring(0,agentNick.indexOf('~'));
		var rcLoadMask = new Ext.LoadMask(Ext.getBody(), {
			msg : "Agent (" + agentNick + ") is changing to control mode. Please wait for few minutes."
		});
		rcLoadMask.show();
		Ext.Ajax.request({
			url : "AgentStatus/data/controlMode.jsp?agentIP="+encodeURI(agentNick),
			method : 'POST',
			timeout:timeOut*1000,
			scope:this,
			success: function(response)
			{
				rcLoadMask.hide();
				var jsonData=Ext.decode(response.responseText);
				if(jsonData.agentStatus=='CONTROL_MODE')
				{
					window.location.href='/final/admin/remoteControl.jsp?agentIP='+encodeURI(agentNick)+'&agentMode=CONTROL_MODE&agent_type='+agent_type;
				}
				else
				{
					Ext.Msg.show({
						title:'Remote Control',
						msg:'Please try again.',
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
				}
			},
			failure: function(response)
			{
				rcLoadMask.hide();
				Ext.Msg.show({
					title:'Remote Control',
					msg:'Please try again.',
					buttons: Ext.Msg.OK,
					icon: 'iconInformation'
				});
			}
		});
	},
	disableAgentDebug: function(ip)
	{
		ip = ip.indexOf("~Yes") >-1 ? ip.substring(0,ip.indexOf("~Yes")) : ip;
		var disableIPList = publicJSON.disabledIpList;
		if(!Ext.isEmpty(disableIPList) && Ext.Array.contains(disableIPList,ip))
		{
			return true;
		}
		return false;
	}
});




