Ext.define('AgentStatus.view.AgentStatusView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.agentstatusview',
	cls:'outerpanel',
	title: pageTitle,
	margin:'8 8 0 8',
	header:{cls:'textUpper'},
	//frame: true,
	id:'agentStatusView',
	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	tools: [
		{
			xtype:'button',
			id: 'saveCSV',
			iconCls:'iconCsv',
			style:{
				background:'none',border:'0px'
			},
			listeners:{
				afterrender:function(){
					Ext.create("Ext.tip.ToolTip",{
						target:this.id,
						anchor:"top",
						cls:"yellowTip",
						trackMouse:true,
						html:"CSV"
					});
				}
			}
		},
		{
			xtype : 'button',
			text : back,
			cls:'backbutton',
			id : 'homeBack',
			iconCls:'iconBack',
			hidden : true,
			margin: '0 0 0 5'
		}
	],

	dockedItems: [
		{
			xtype: 'toolbar',
			cls:'adminHeadInfoText',
			dock: 'top',
			layout:{pack:'center'},
			width:'100%',
			height: 25,
			padding: 3,
			items: [
				{
					xtype: 'component',
					html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+'.</center>'
				}
			]
		}
	],

	items: [
		{
			xtype:'container',
			layout : {
				type : 'vbox',
				align : 'center',
				pack : 'center'
			},
			items:[
					{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					cls:'formOuter',
					padding: '10 0 10 10',
					margin: '10 10 10 10',
					items: [
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: agentType,
							labelAlign: 'top',
							labelSeparator: ' ',
							width: 250,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							id: 'agentType',
							editable: false
						},
						{
							xtype: 'scrollcombo',
							cls:'dropdown',
							fieldLabel: agentStatus,
							labelAlign: 'top',
							labelSeparator: ' ',
							width: 120,
							margin: '0 0 0 20',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							id: 'agentStatus',
							editable: false
						},
						{
							xtype: 'button',
							cls:'button20',
							id:'restartAll',
							text: restartAll,
							margin:'20 0 0 200'
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'NoUserAvailable',
			hidden : true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table border="0" height="400" width="100%"><tr><td align=center valign=middle><div class="iconInformation"></div><div class="commonErrorMsgText">'+noAgentsAlert+'.</div></td></tr></table>'
				}
			]
		},
		{
			xtype: 'container',
			id : 'resultpanel',
			ui:'simplePanel simplePanelHeaderBorder',
			margin: '0 10 0 0',
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			flex: 1
		}
		//{
			//xtype: 'customgrid',
			//cls:'gridSkin',
			//id:'agentInfoGrid',
			//flex:1,
			//border:false,
			//autoScroll: true,
			//store: new Ext.data.Store({
				//fields: ['AgentIP', 'Installed', 'Status', 'Output', 'Restart', 'Logs', 'AssignedHosts','StopAgent', 'Xmx','isAgentShared','RemoteControl'],
				//data : []
			//}),
			//plugins: [
				//{
					//ptype: 'rowexpander',
					//expandOnDblClick: false,
					//id:'rowExp',
					//rowBodyTpl : [
					////	'<p><b>Assigned hosts</b><br>{AssignedHosts}</p>'
						//'{[this.getRowView(values)]}',
						//{
							//getRowView : function(values)
							//{
								//var viewStr = '<div><p><i>Assigned hosts</i></p></div>';
								//var agentNames = values.AssignedHosts;
								//if (agentNames.indexOf('-') == 0)
								//{
									//viewStr += agentNames;
								//}
								//else
								//{
									//var vals = agentNames.split(',');
									//var valsLen = vals.length;
									//var rem = valsLen%3;
									//if (rem != 0)
									//{
										//var tmp = 3 - rem;
										//for (var t=0; t<tmp; t++)
										//{
											//agentNames +=', ';
										//}
										//vals = agentNames.split(',');
									//}
									//viewStr = '<div><p><i>Assigned hosts ('+valsLen+')</i></p></div>';
									//viewStr += "<table border='0' width='100%'>";
									//for (var v=0; v < vals.length; v=v+3)
									//{
										//viewStr += "<tr><td>"+vals[v]+"</td><td>"+vals[v+1]+"</td><td>"+vals[v+2]+"</td></tr>";
									//}
									//viewStr += "</table>";
								//}
								//return viewStr;
							//}
						//}
					//]
				//}
			//],
			//columns: {
				//defaults: {
					//sortable: true,
					//hideable: false,
					//menuDisabled: true,
					//draggable: false,
					//resizable: false
				//},
				//items: [
					//{
						//text: agentIPNick,
						//dataIndex: 'AgentIP',
						//flex: 1,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//var agentNick = value.substring(0,value.indexOf('~'));
							//var installed = value.substring(value.indexOf('~')+1);
							//var result = "";
							//if (installed == 'Yes')
							//{
								//result = '<a class="eg_monlink" href="javascript:ctrler.showAgentInfo('+row+',\'agentInfoGrid\')">'+agentNick+'</a>';
							//}
							//else
							//{
								//result = agentNick;
							//}
							//return result;
						//}
					//},
					//{
						//text: installed,
						//dataIndex: 'Installed',
						//width: 80,
						//renderer : function(value) {
							//var result = "";
							//if (value == "Yes")
							//{
								////result = '<img src="../../../../admin/eg_images/Installed-Running.gif" border="0" vspace="0" title="Agent Installed" height="14">';
								//result='<center><div class="iconAgentInstalled" data-qtip="Agent Installed" data-qclass="yellowTip"></div></center>'
							//}
							//else
							//{
								////result = '<img src="../../../../admin/eg_images/Installed-Not.gif" border="0" vspace="0" title="Agent Not Installed" height="14">';
								//result='<center><div class="iconAgentNotInstalled" data-qtip="Agent Not Installed" data-qclass="yellowTip"></div></center>'
							//}
							//return result;
						//}
					//},
					//{
						//text: status,
						//dataIndex: 'Status',
						//width: 90,
						//renderer : function(value) {
							//var result = "";
							//if (value == "Running")
							//{
								//result = '<center><img src="/final/images/'+theme+'/agentRunning.gif" border="0" vspace="0" data-qtip="Agent Running" data-qclass="yellowTip" valign="middle"></center>';
							//}
							//else
							//{
								//result = '<center><img src="/final/images/'+theme+'/agentNotRunning.gif" border="0" vspace="0" data-qtip="Agent Not Running" data-qclass="yellowTip" valign="middle"></center>';
							//}
							//return result;
						//}
					//},
					//{
						//xtype: 'checkcolumn',
						//text: opLog,
						//dataIndex: 'Output',
						//width: 190,
						//listeners: {
							//checkchange: function (column, row, checked) {
								//var rowObj = Ext.getCmp('agentInfoGrid').getStore().getAt(row);
								//var installed = rowObj.get('Installed');
								//if (rowObj.get('Status')=='Running' && installed == 'Yes')
								//{
									//ctrler.outputLoggingChange(checked,row,'agentInfoGrid')
								//}
								//else
								//{
									//if (checked)
									//{
										//rowObj.set('Output',false);
									//}
									//else
									//{
										//rowObj.set('Output',true);
									//}
									//return false;
								//}
							//}
						//},
						//renderer:function(value, metaData, record)
						//{
							//var agentSharedValue = record.get('isAgentShared');
							//var setDisableOutputLogging = agentSharedValue.substring(agentSharedValue.indexOf('~')+1);
							//if (setDisableOutputLogging == "true")
							//{
								//var ccObj = new Ext.ux.CheckColumn().renderer(value);
								//metaData.tdCls += ' '+'x-item-disabled';
								//return ccObj;
								////return '<div class="custom-form-checkbox" style="margin:-5px 0 0 86px;padding:10px;"></div>';
							//}
							//else
							//{
								//var ccObj = new Ext.ux.CheckColumn().renderer(value);
								//return ccObj;
							//}
						//}
					//},
					//{
						//text: logs,
						//dataIndex: 'Logs',
						//width: 50,
						//sortable: false,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//var result = "";
							//if (value == "Show")
							//{
								////result = '<a href="javascript:ctrler.showLogs('+row+',\'agentInfoGrid\');"><img src="../../../../reporter/images/data.gif" border="0" vspace="0" title="" height="14"></a>';
								//result = '<center><a href="javascript:ctrler.showLogs('+row+',\'agentInfoGrid\');"><div class="iconData" data-qtip="Agent Logs" data-qclass="yellowTip"></div></a></center>';
							//}
							//else
							//{
								////result = '<img src="../../../../reporter/images/data.gif" border="0" vspace="0" title="" height="14">';
								//result='<center><div class="iconData" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Logs" data-qclass="yellowTip"></div></center>';
							//}
							//return result;
						//}
					//},
					//{
						//text: restart,
						//dataIndex: 'Restart',
						//width: 80,
						//sortable: false,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//var result = "";
							//var opt = value.substring(0,value.indexOf('~'));
							//var nick = value.substring(value.indexOf('~')+1);
							//if (opt == "Yes")
							//{
								////result = '<a href="javascript:ctrler.restartAgent('+row+',\'agentInfoGrid\');"><img src="../../../../admin/eg_images/a_restart.jpg" border="0" vspace="0" title="" height="14"></a>';
								//result = '<center><a href="javascript:ctrler.restartAgent('+row+',\'agentInfoGrid\');"><div class="iconRestart"  data-qtip="Agent Restart" data-qclass="yellowTip"></div></a></center>';
							//}
							//else
							//{
								////result = '<img src="../../../../admin/eg_images/a_restart.jpg" border="0" vspace="0" title="" height="14">';
								//result = '<center><div class="iconRestart"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Restart" data-qclass="yellowTip"></div></center>';
							//}
							//return result;
						//}
					//},
					//{
						//text: stopAgent,
						//dataIndex: 'StopAgent',
						//width: 50,
						//sortable: false,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//var result = "";
							//var opt = value.substring(0,value.indexOf('~'));
							//var nick = value.substring(value.indexOf('~')+1);
							//if (opt == "Yes")
							//{
								//result = '<center><a href="javascript:ctrler.stopAgentButton('+row+',\'agentInfoGrid\');"><div class="iconStop"  data-qtip="Agent Stop" data-qclass="yellowTip"></div></a></center>';
							//}
							//else
							//{
								//result = '<center><div class="iconStop"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Stop Agent" data-qclass="yellowTip"></div></center>';
							//}
							//return result;
						//}
					//},
					//{
						//text: xmx,
						//dataIndex: 'Xmx',
						//width: 50,
						//sortable: false,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//var result = "";
							//if (value == "Show")
							//{
								//result = '<center><a href="javascript:ctrler.showXmx('+row+',\'agentInfoGrid\');"><div class="iconSettings" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></a></center>';
							//}
							//else
							//{
								//result='<center><div class="iconSettings" style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Agent Xmx Setting" data-qclass="yellowTip"></div></center>';
							//}
							//return result;
						//}
					//},
					//{
						//text:assoHosts,
						//dataIndex: 'AssignHostsLink',
						//width: 125,
						//sortable: false,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//result = "";
							//var result = '<center><a href="javascript:ctrler.showAssignHosts('+row+',\'agentInfoGrid\');"><div class="iconShowAssociates"  data-qtip="Associate hosts" data-qclass="yellowTip"></div></a></center>';
							//return result;
						//}
					//},
					//{
						//text: agentShared,
						//dataIndex: 'isAgentShared',
						//hidden: true,
						//width: 125,
						//sortable: false,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//var isAgentShared = value.substring(0,value.indexOf('~'));
							//var setDisableOutputLogging = value.substring(value.indexOf('~')+1);
							//result = "";
							//var result = '<center>'+isAgentShared+'</center>';
							//return result;
						//}
					//},
					//{
						//text: remotecontrol,
						//dataIndex: 'RemoteControl',
						//width: 120,
						//sortable: false,
						//renderer : function(value, metaData, record, row, store, gridView) {
							//var result = "";
							//var idx = value.indexOf('~');
							//var last_idx = value.lastIndexOf('~');
							//var opt = value.substring(0,idx);
							//var nick = value.substring(idx+1,last_idx);
							//var mode = value.substring(last_idx+1);
							//if (opt == "Yes")
							//{
								//result = '<center><a href="javascript:ctrler.callMonitorRemoteControl('+row+',\'agentInfoGrid\',\''+mode+'\');"><div class="iconRemoteControl"  data-qtip="Remote Control" data-qclass="yellowTip"></div></a></center>';
							//}
							//else
							//{
								//result = '<center><div class="iconRemoteControl"  style="opacity: 0.3;filter: alpha(opacity=30);" data-qtip="Remote Control" data-qclass="yellowTip"></div></center>';
							//}
							//return result;
						//}
					//}
				//]
			//},
			//margin: 10,
			//emptyText: '<table border="0" width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noAgentAlrtDiv">'+noAgentsAlert+'.</div></td></tr></table>',
			//viewConfig: {
				//deferEmptyText: false
			//},
			//tbar: [
				////  This field is to display the Number of agents in the Agent Status Page.
				//{
					//xtype:'displayfield',
					//fieldLabel:numberOfAgents,
					//labelSeparator: ' :',
					//id:'totalAgents',
					//height:20,
					//labelWidth:150
				//},
				//{
					//xtype:'tbfill',
				//},
				//{
					//xtype: 'trigger',
					//cls:'whitedropdown_search',
					//trigger1Cls: 'x-form-clear-trigger',
					//trigger2Cls: 'x-form-search-trigger',
					//emptyText: 'Search',
					//padding: '2 6 2 0',
					//disabled:true,
					//onTrigger1Click: function() {
						//this.reset();
					//},
					//onTrigger2Click: function() {
						//ctrler.searchAgent();
					//},
					//id: 'searchBox',
					//getTriggerMarkup: function() {
						//var me = this,
						//i = 0,
						//hideTrigger = (me.readOnly || me.hideTrigger),
						//triggerCls,
						//triggerBaseCls = me.triggerBaseCls,
						//triggerConfigs = [],
						//unselectableCls = Ext.dom.Element.unselectableCls,
						//style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						//cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						//// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						//// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						//// trigger config objects that hold cls, handler, etc.
						//// triggerCls is a synonym for trigger1Cls, so copy it.
						//if (!me.trigger1Cls) {
							//me.trigger1Cls = me.triggerCls;
						//}
						//// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						//for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							//if (i == 0)
							//{
								//triggerConfigs.push({
									//tag: 'td',
									//role: 'presentation',
									//valign: 'top',
									//cls: cls,
									//id : 'MyTrigger_'+i,
									//style: style + "display:none;",
									//cn: {
										//cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										//role: 'presentation'
									//}
								//});
							//}
							//else
							//{
								//triggerConfigs.push({
									//tag: 'td',
									//role: 'presentation',
									//valign: 'top',
									//cls: cls,
									//id : 'MyTrigger_'+i,
									//style: style,
									//cn: {
										//cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										//role: 'presentation'
									//}
								//});
							//}
						//}
						//triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						//return Ext.DomHelper.markup(triggerConfigs);
					//}
				//}
			//]
		//}
	]
});



