Ext.define('AgentUpgrade.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AgentUpgradeView'],
	requires:['AgentUpgrade.view.AgentUpgradeView'],
	refs:[
		{selector:'agentupgradeview', ref:'agentupgradeview'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'agentupgradeview':
			{
				'boxready': this.afterMainRender
			},
			'agentupgradeview button[id="updateTab1"]' :
			{
				'click': this.updateAutoUpgrade
			},
			'agentupgradeview button[id="updateTab2"]' :
			{
				'click': this.updateAgentSettings
			},
			'agentupgradeview button[id="updateTab3"]' :
			{
				'click': this.updateUpgradeNow
			},
			
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'AgentUpgrade/data/EgManageAgentsJson.jsp?node=tab1',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		initialLoad = 'false';
	},
	afterMainRender: function()
	{
		var itemSelObj = Ext.getCmp('autoUpgrade');
		itemSelObj.fromField.store.removeAll();
		itemSelObj.toField.store.removeAll();
		
		if (publicJSON.leftEntries != null)
		{
			itemSelObj.fromField.store.add(publicJSON.leftEntries);
		}
		
		if (publicJSON.rightEntries != null)
		{
			itemSelObj.toField.store.add(publicJSON.rightEntries);
		}

		if (publicJSON.leftEntries == null && publicJSON.rightEntries == null)
		{
			Ext.getCmp('updateTab1').hide();
		}
		Ext.getCmp("searchFieldContainer").show();
	},
	loadThisTab: function(tab)
	{
		if (tab == 'tab1')
		{
			this.loadTab1();
		}
		else if (tab == 'tab2')
		{
			this.loadTab2();
		}
		else if (tab == 'tab3')
		{
			this.loadTab3();
		}
	},
	loadTab1 :function()
	{
		if (initialLoad == 'false')
		{
			ctrler.buildMainData();
			ctrler.afterMainRender();
		}
		initialLoad = 'false';
	},
	loadTab2 :function()
	{
		Ext.Ajax.request(
		{
			url: 'AgentUpgrade/data/EgManageAgentsJson.jsp?optvalue=interval&node=tab2',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});

		Ext.getCmp('upgradeCheckInts').getStore().removeAll();
		Ext.getCmp('upgradeStatus').getStore().removeAll();
		Ext.getCmp('upgradeCheckInts').getStore().loadRawData(publicJSON.timeIntervals);
		Ext.getCmp('upgradeCheckInts').setValue(publicJSON.selectedInterval);
		Ext.getCmp('upgradeStatus').getStore().loadRawData(publicJSON.upgradeModes);
		Ext.getCmp('upgradeStatus').setValue(publicJSON.selectedUpgradeMode);
	},
	loadTab3 :function()
	{
		Ext.Ajax.request(
		{
			url: 'AgentUpgrade/data/EgManageAgentsJson.jsp?optvalue=now&node=tab3',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});


		var itemSelObj = Ext.getCmp('upgradeNowItemSel');
		itemSelObj.fromField.store.removeAll();
		itemSelObj.toField.store.removeAll();
		
		if (publicJSON.leftEntries != null)
		{
			itemSelObj.show();
			itemSelObj.fromField.store.add(publicJSON.leftEntries);
			Ext.getCmp('updateTab3').show();
		}
		
		if (publicJSON.rightEntries != null)
		{
			itemSelObj.show();
			itemSelObj.toField.store.add(publicJSON.rightEntries);
			Ext.getCmp('updateTab3').show();
		}

		if (publicJSON.leftEntries == null && publicJSON.rightEntries == null)
		{
			Ext.getCmp('updateTab3').hide();
			itemSelObj.hide();
		}
		if (publicJSON.leftEntries == null)
		{
			Ext.getCmp('wlcNote').show();
			Ext.getCmp('wlcNote').update('<center><b>'+publicJSON.upgradeNowMainMsg+'</b><center>');
		}else if(publicJSON.leftEntries != null && publicJSON.rightEntries == null)
		{
			Ext.getCmp('wlcNote').hide();
		}
	},
	updateAutoUpgrade: function()
	{
		var itemSelObj = Ext.getCmp('autoUpgrade');
	
		var newlyDisociated = '';
		var storeObj = itemSelObj.toField.store;
		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			var found = false;
			for (var key in publicJSON.rightEntries)
			{
				var obj =  publicJSON.rightEntries[key];
				var oldVal = obj.valueField;
				if (oldVal == newVal)
				{
					found = true;
					break;
				}
			}
			if (!found)
			{
				newlyDisociated += newVal+'$$';
			}
		}

		var newlyAssociated = '';
		storeObj = itemSelObj.fromField.store;
		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			var found = false;
			for (var key in publicJSON.leftEntries)
			{
				var obj =  publicJSON.leftEntries[key];
				var oldVal = obj.valueField;
				if (oldVal == newVal)
				{
					found = true;
					break;
				}
			}
			if (!found)
			{
				newlyAssociated += newVal+'$$';
			}
		}
		if (newlyAssociated == '' &&  newlyDisociated == '')
		{
			Ext.Msg.show({
				title: tab1Titlle,
				msg: alert1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		var urlStr = "AgentUpgrade/data/EgmanageagentspJson.jsp?node=tab1";
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		var hiddenParams = publicJSON.hiddenVals;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		me.add({
					xtype: 'hidden',
					name: 'fmanage',
					value: newlyAssociated
				});
		me.add({
					xtype: 'hidden',
					name: 'funmanage',
					value: newlyDisociated
				});

		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAgentupgradeview().submit({
			url: urlStr,
			//async:false,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if(resultJSON.ResultAlert)
				{
					Ext.Msg.show({
						title: resultJSON.ResultTitle,
						msg: resultJSON.ResultMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function(response) {
							if(response == 'ok') {
								ctrler.loadTab1();
							}
						}
					});
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	},
	updateAgentSettings :function()
	{
		var intVal = Ext.getCmp('upgradeCheckInts').getValue();
		if (intVal == 0)
		{
			Ext.Msg.show({
				title: tab2Title,
				msg: alert2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		var upgradeVal = Ext.getCmp('upgradeStatus').getValue();
		var urlStr = "AgentUpgrade/data/EgmanageagentspJson.jsp?node=tab2";
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		var hiddenParams = publicJSON.hiddenVals;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		this.getAgentupgradeview().submit({
			url: urlStr,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if(resultJSON.ResultAlert)
				{
					Ext.Msg.show({
						title:resultJSON.ResultTitle,
						msg:resultJSON.ResultMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
					//ctrler.buildMainData();
					//ctrler.afterMainRender();
				}

			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});	
		//ctrler.loadTab2();
	},
	updateUpgradeNow :function()
	{
		var itemSelObj = Ext.getCmp('upgradeNowItemSel');
		
		var newlyDisociated = '';
		var storeObj = itemSelObj.toField.store;
		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			var found = false;
			for (var key in publicJSON.rightEntries)
			{
				var obj =  publicJSON.rightEntries[key];
				var oldVal = obj.valueField;
				if (oldVal == newVal)
				{
					found = true;
					break;
				}
			}
			if (!found)
			{
				newlyDisociated += newVal+'$$';
			}
		}
		
		var newlyAssociated = '';
		storeObj = itemSelObj.fromField.store;
		for (var s=0; s < storeObj.getCount();s++)
		{
			var newVal = storeObj.getAt(s).get('valueField');
			var found = false;
			for (var key in publicJSON.leftEntries)
			{
				var obj =  publicJSON.leftEntries[key];
				var oldVal = obj.valueField;
				if (oldVal == newVal)
				{
					found = true;
					break;
				}
			}
			if (!found)
			{
				newlyAssociated += newVal+'$$';
			}
		}
		if (newlyAssociated == '' &&  newlyDisociated == '')
		{
			Ext.Msg.show({
				title: tab3Title,
				msg: alert1,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		var urlStr = "AgentUpgrade/data/EgmanageagentspJson.jsp?";
		var me = Ext.getCmp('hiddenContnr');
		me.removeAll();
		var hiddenParams = publicJSON.hiddenVals;
		for (var param in hiddenParams) {
				me.add({
					xtype: 'hidden',
					name: param,
					value: hiddenParams[param]
				});
		}
		me.add({
					xtype: 'hidden',
					name: 'fmanage',
					value: newlyAssociated
				});
		me.add({
					xtype: 'hidden',
					name: 'funmanage',
					value: newlyDisociated
				});
		
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: updating+'...'});
		tmpMask.show();
		//var currentObj = this;
		this.getAgentupgradeview().submit({
			url: urlStr,
			method: 'POST',
			success: function(form, action)
			{
				tmpMask.hide();
				var jsonText = action.response.responseText;
				var resultJSON = Ext.decode(jsonText);
				if(resultJSON.ResultAlert)
				{
					Ext.Msg.show({
						title: resultJSON.ResultTitle,
						msg: resultJSON.ResultMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
					ctrler.buildMainData();
					ctrler.afterMainRender();
					ctrler.loadTab3()
				}
			},
			failure: function(form, action)
			{
				 tmpMask.hide();
			}
		});
	},
	searchAgents : function(upgrade_status,searchVal)
	{
		var me = this , id;
		if (upgrade_status == "managed")
		{
			id = "managedSeacrchBox";
		}
		else
		{
			id = "unmanagedSeacrchBox";
		}
		if (searchVal == "" || searchVal.length == 0)
		{
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','block');
		}
		var searchURL = '';
		if (searchVal.length == 0 || searchVal == "Search" )
		{
			searchURL = "AgentUpgrade/data/EgManageAgentsJson.jsp?node=tab1&upgrade_status="+upgrade_status;
		}
		else
		{
			searchURL = "AgentUpgrade/data/EgManageAgentsJson.jsp?node=tab1&strSearch="+searchVal+"&upgrade_status="+upgrade_status;
		}
		Ext.Ajax.request({
			url: searchURL,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					var itemSelObj = Ext.getCmp('autoUpgrade');
					itemSelObj.fromField.store.removeAll();
					itemSelObj.toField.store.removeAll();

					if (publicJSON.leftEntries != null)
					{
						itemSelObj.fromField.store.add(publicJSON.leftEntries);
					}
					if (publicJSON.rightEntries != null)
					{
						itemSelObj.toField.store.add(publicJSON.rightEntries);
					}
					if (publicJSON.leftEntries == null && publicJSON.rightEntries == null)
					{
						Ext.getCmp('updateTab1').hide();
					}
					Ext.getCmp("searchFieldContainer").show();
				}
			}
		});
	}
});



