Ext.define('AgentUpgrade.view.AgentUpgradeView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.agentupgradeview',
	id:'agentupgradeview',
	cls:'outerpanel',
	requires: [
		'Ext.ux.form.ItemSelectorSI',
		'utilities.ScrollCombo'
	],

	title: pageTitle,
	margin:'8 8 0 8',
	//frame: true,

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+'.</center>',
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'container',
			id:'hiddenContnr',
			hidden:true
		},
		{
			xtype: 'tabpanel',
			border:false,
			//style:{'box-shadow': 'none','-webkit-box-shadow': 'none','-moz-box-shadow': 'none'},
			cls:'tablayout',
			listeners: {
				'tabchange': function(tabPanel, newCard, oldCard, eOpts ) {
					ctrler.loadThisTab(newCard.itemId);
				}
			},
			plain: true,
			tabPosition: 'top',
			flex: 1,
			margin: 10,
			items: [
				{
					title: tab1Titlle,
					itemId: 'tab1',
					layout: {
						type: 'vbox',
						align: 'center'
					},
					items: [
						{
							xtype: 'container',
							id : 'searchFieldContainer',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							hidden: true,
							width: 800,
							margin: '20 10 0 10',
							items: [
								{
									xtype: 'container',
									layout: {
										type: 'hbox',
										pack: 'center'
									},
									flex: 1,
									items: [
										{
											xtype: 'trigger',
											id : 'managedSeacrchBox',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											cls: 'whitedropdown_search',
											emptyText: 'Search Auto Upgrade Enabled',
											width: 250,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}

												// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function() {
												this.reset();
											},
											onTrigger2Click: function() {
												ctrler.searchAgents("upgrade_enabled",this.getValue());
											},
											listeners :
											{
												change : function(obj)
												{
													ctrler.searchAgents("upgrade_enabled",obj.getValue());
												},
												specialkey: function(field, e){
													// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
													// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
													if (e.getKey() == e.ENTER) {
														ctrler.searchAgents("upgrade_enabled",field.getValue());
													}
												}
											}
										}
									]
								},
								{
									xtype: 'tbspacer',
									width: 30
								},
								{
									xtype: 'container',
									layout: {
										type: 'hbox',
										pack: 'center'
									},
									flex: 1,
									items: [
										{
											xtype: 'trigger',
											id : 'unmanagedSeacrchBox',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											cls: 'whitedropdown_search',
											emptyText: 'Search Auto Upgrade Disabled',
											width: 250,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}

												// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function() {
												this.reset();
											},
											onTrigger2Click: function() {
												ctrler.searchAgents("upgrade_disabled",this.getValue());
											},
											listeners :
											{
												change : function(obj)
												{
													ctrler.searchAgents("upgrade_disabled",obj.getValue());
												},
												specialkey: function(field, e){
													// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
													// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
													if (e.getKey() == e.ENTER) {
														ctrler.searchAgents("upgrade_disabled",field.getValue());
													}
												}
											}
										}
									]
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center',
								align: 'stretch'
							},
							flex: 1,
							margin: '10 0 0 0',
							items: [
								{
									xtype: 'itemselector',
									cls:'multiselect',
									id: 'autoUpgrade',
									buttons: ['add','remove'],
									buttonsText: {
										add: tab1ToolTip1,
										remove: tab1ToolTip2
									},
									store: new Ext.data.Store({
										fields: ['displayField','valueField'],
										data: []
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									height: 280,
									width: 800,
									fromTitle: tab1Left,
									toTitle: tab1Right
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '20 0 20 0',
							items: [
								{
									xtype: 'button',
									cls:'button20',
									id: 'updateTab1',
									text: update,
									width: 80
								}
							]
						}
					]
				},
				{
					title: tab2Title,
					itemId: 'tab2',
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 550,
								labelWidth: 350
							},
							margin: '20 0 0 0',
							items: [
								{
									xtype: 'scrollcombo',
									cls:'dropdown',
									id:'upgradeCheckInts',
									name:'upgradeCheckInts',
									fieldLabel: tab2Combo1,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									editable: false
								},
								{
									xtype: 'scrollcombo',
									cls:'dropdown',
									id:'upgradeStatus',
									name:'upgradeStatus',
									fieldLabel: tab2Combo2,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									editable: false
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '20 0 20 0',
							items: [
								{
									xtype: 'button',
									cls:'button20',
									id:'updateTab2',
									text: update,
									width: 80
								}
							]
						}
					]
				},
				{
					title: tab3Title,
					itemId: 'tab3',
					layout: {
						type: 'vbox',
						align: 'center'
					},
					items: [
						{
							xtype: 'component',
							id: 'wlcNote',
							html: '',
							margin: '15 0 0 0',
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center',
								align: 'stretch'
							},
							flex: 1,
							margin: '10 0 0 0',
							items: [
								{
									xtype: 'itemselector',
									cls:'multiselect',
									id: 'upgradeNowItemSel',
									buttons: ['add','remove'],
									buttonsText: {
										add: tab3ToolTip1,
										remove: tab3ToolTip2
									},
									store: new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: []
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									height: 380,
									width: 800,
									fromTitle: tab3Left,
									toTitle: tab3Right
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '20 0 20 0',
							items: [
								{
									xtype: 'button',
									cls:'button20',
									text: update,
									id: 'updateTab3',
									width: 80
								}
							]
						}
					]
				}
			]
		}
	]

});



