Ext.define('AgentUpgradeStatus.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AgentUpgradeStatusView','EgInfraDownloader','Print'],
	requires:['AgentUpgradeStatus.view.AgentUpgradeStatusView'],
	refs:[
		{selector:'agentupgradestatusview', ref:'agentupgradestatusview'}
	],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'agentupgradestatusview':
			{
				'afterrender': this.afterMainRender
			},
			'agentupgradestatusview combo[id="filterBy"]':
			{
				'select':this.filterByChange
			},
			'agentupgradestatusview button[id="submit"]':
			{
				'click':this.submitPage
			},
			'agentupgradestatusview button[id="backButton"]':
			{
				'click':this.goBack
			},
			'agentupgradestatusview > tabpanel': {
				'tabchange': this.tabchange
			},
			'agentupgradestatusview button[id="save"]':
			{
				'click': this.savePdf
			},
			'agentupgradestatusview button[id="print"]':
			{
				'click': this.printData
			},
			'agentupgradestatusview button[id="csv"]':
			{
				'click': this.saveInCSVFormat
			}
		});
	},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'AgentUpgradeStatus/data/EgUpgradeStatusJson.jsp?firstTime=true',
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	tabchange : function()
	{
		var selectTab = Ext.getCmp('tabformitems').getActiveTab().getId();
		Ext.Ajax.request({
			url: 'AgentUpgradeStatus/data/agentupgradestatushelpJson.jsp?selectTab='+selectTab,
			method: 'POST',
			async: false,
		});
	},
	afterMainRender: function()
	{
		var filterByObj = Ext.getCmp('filterBy');
		filterByObj.getStore().removeAll();
		filterByObj.getStore().loadRawData(publicJSON.filterBy);
		filterByObj.setValue(publicJSON.filterBySelected);

		var filterCrtObj = Ext.getCmp('filterCritra');
		if (publicJSON.filterCriteriaOption)
		{
			filterCrtObj.show();
			filterCrtObj.enable();
			filterCrtObj.getStore().removeAll();
			filterCrtObj.getStore().loadRawData(publicJSON.filterCriteria);
			filterCrtObj.setValue(publicJSON.filterCriteriaSelected);
		}
		else
		{
			filterCrtObj.hide();
			filterCrtObj.disable();
		}

		if (publicJSON.noAgentsFound)
		{
			Ext.getCmp('agentInfoGrid').hide();
			//Ext.getCmp('currAgentsCount').hide();
			Ext.getCmp('noAgentsAvail').show();

			Ext.getCmp("save").setDisabled(true);
			Ext.getCmp("print").setDisabled(true);
			Ext.getCmp("csv").setDisabled(true);
		}
		else
		{
			Ext.getCmp("save").setDisabled(false);
			Ext.getCmp("print").setDisabled(false);
			Ext.getCmp("csv").setDisabled(false);

			Ext.getCmp('noAgentsAvail').hide();
			Ext.getCmp('noAgentsConfiguredTab1').hide();
			Ext.getCmp('agentInfoGrid').show();
			Ext.getCmp('agentInfoGrid').setTitle('<span class="font_bold">'+grid1Title+'  ('+publicJSON.selectedAgentsCount+')</span>');
			Ext.getCmp('agentInfoGrid').getStore().loadRawData(publicJSON.agentInfoGrid);
		}

		if (publicJSON.noAgentsConfigured)
		{
			Ext.getCmp('noAgentsConfigured').show();
			Ext.getCmp('noAgentsConfiguredTab1').show();
			Ext.getCmp('totalAgentsGrid').hide();
			Ext.getCmp('comboCntnr').hide();
			Ext.getCmp('buttonCntnr').hide();
			Ext.getCmp('agentInfoGrid').hide();
			Ext.getCmp('noAgentsAvail').hide();
		}
		else
		{
			Ext.getCmp('noAgentsConfigured').hide();
			Ext.getCmp('noAgentsConfiguredTab1').hide();
			Ext.getCmp('totalAgentsGrid').show();
			Ext.getCmp('comboCntnr').show();
			Ext.getCmp('buttonCntnr').show();
			//Ext.getCmp('totalAgentsGrid').setTitle(grid2Title);
			Ext.getCmp('totalAgentsGrid').getStore().loadRawData(publicJSON.totalAgentsGrid);
		}

		if (publicJSON.gridStatusCol)
		{
			Ext.getCmp('statusCol').show();
		}
		else
		{
			Ext.getCmp('statusCol').hide();
		}
		if (publicJSON.gridOsCol)
		{
			Ext.getCmp('osCol').show();
		}
		else
		{
			Ext.getCmp('osCol').hide();
		}
		if (publicJSON.gridVersionCol)
		{
			Ext.getCmp('verCol').show();
		}
		else
		{
			Ext.getCmp('verCol').hide();
		}
		if (publicJSON.gridJreVersionCol)
		{
			Ext.getCmp('jreVerCol').show();
		}
		else
		{
			Ext.getCmp('jreVerCol').hide();
		}
		if (publicJSON.gridUpgrade)
		{
			Ext.getCmp('lastUpgrdPkg').show();
		}
		else
		{
			Ext.getCmp('lastUpgrdPkg').hide();
		}
		if (fromPage == 'AgentStatus'|| fromPage == 'CheckForUpdates')
		{
			Ext.getCmp('backButton').show();
		}else
		{
			Ext.getCmp('backButton').hide();
		}
	},
	goBack: function()
	{
		window.location.href=backHref;
	},
	filterByChange: function()
	{
		var filterBy = Ext.getCmp('filterBy').getValue();
		Ext.Ajax.request(
		{
			url: 'AgentUpgradeStatus/data/EgUpgradeStatusJson.jsp?reqFrom=thisPage&filterBy='+filterBy,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		ctrler.afterMainRender();
	},
	submitPage: function()
	{
		var filterBy = Ext.getCmp('filterBy').getValue();
		var filerCrtra = Ext.getCmp('filterCritra');
		var filterCritra = "";
		if (filerCrtra !=null)
		{
			filterCritra = Ext.getCmp('filterCritra').getValue();
		}

		Ext.Ajax.request(
		{
			url: 'AgentUpgradeStatus/data/EgUpgradeStatusJson.jsp?reqFrom=thisPage&filterBy='+filterBy+'&filterCriteria='+filterCritra,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
		ctrler.afterMainRender();
	},	
	savePdf: function()
	{
		var selectTab = Ext.getCmp('tabformitems').getActiveTab().getId();
		var getSaveObj = Ext.widget('savepdf');
		getSaveObj.savePDF(pdfURLString+'?selectTab='+selectTab);
	},
	saveInCSVFormat: function()
	{
		var selectTab = Ext.getCmp('tabformitems').getActiveTab().getId();
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+trackerLanguage+'&selectTab='+selectTab;
	},
	printData: function()
	{
		var selectTab = Ext.getCmp('tabformitems').getActiveTab().getId();
		var printPage = "/final/admin/AgentUpgradeStatus/data/upgradeAgentStatusPrint.jsp?printpage=true&title=Agent Upgrade Status&com.eg.CSRF_NONCE="+csrfToken+'&selectTab='+selectTab;
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	}
});





