Ext.define('AgentUpgradeStatus.view.AgentUpgradeStatusView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.agentupgradestatusview',
	cls:'outerpanel',
	title: pageTitle,
	margin:'8 8 0 8',
	header:{cls:'textUpper'},
	requires: [
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	tools: [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'saveTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconPdf',
					id: 'save',
					disabled: true,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Save'
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},
		{xtype:'tbseparator'},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'printTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconPrinter',
					id: 'print',
					disabled: true,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Print'
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},
		{xtype:'tbseparator'},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'csvTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconCsv',
					id: 'csv',
					disabled: true,
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'CSV'
							});
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},
		{
			xtype : 'button',
			cls:'backbutton',
			text : back,
			iconCls:'iconBack',
			id : 'backButton',
			hidden : true
		}
	],
	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+'.</center>',
			width:'100%',
			height: 25,
			padding: 3
		},
		{
			xtype: 'tabpanel',
			border:false,
			style:{'border': '0px solid #c3c3c3 !important'},
			cls:'tablayout',
			plain: true,
			tabPosition: 'top',
			flex: 1,
			margin: 10,
			id: 'tabformitems',
			items: [
				{
					title: tab1Title,
					id:'tab1',
					cls:'tabLayoutInnerBorder',
					style:{'border-top':'0px'},
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'container',
							id: 'comboCntnr',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '10 0 0 0',
							items: [
								{
									xtype: 'scrollcombo',
									cls:'dropdown',
									id: 'filterBy',
									fieldLabel: filterBy,
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 250,
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									editable: false
								},
								{
									xtype: 'scrollcombo',
									cls:'dropdown',
									id: 'filterCritra',
									fieldLabel: filterCritra,
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 250,
									margin: '0 0 0 20',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									editable: false
								}
							]
						},
						{
							xtype: 'container',
							id: 'buttonCntnr',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: '20 0 20 0',
							items: [
								{
									xtype: 'button',
									cls:'button20',
									id:'submit',
									text: submit,
									width: 80
								}
							]
						},
						{
							xtype: 'container',
							id:'noAgentsAvail',
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							margin: 15,
							hidden: true,
							items: [
								{
									xtype: 'label',
									html: '<table><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+alrtMsg1+'.</td></tr></table></td></tr></table>'
								}
							]
						},
						{
							xtype: 'container',
							id:'noAgentsConfiguredTab1',
							layout: {
								type: 'hbox',
								pack: 'center',
								align: 'center'
							},
							margin: 15,
							hidden: true,
							items: [
								{
									xtype: 'label',
									html: '<table><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+alrtMSg2+'.</td></tr></table></td></tr></table>'
								}
							]
						},
						{
							xtype: 'customgrid',
							cls:'gridSkin',
							title: '',
							id:'agentInfoGrid',
							store: new Ext.data.Store({
								fields: ['AgentID', 'LastUpgradedPackageID', 'LastUpgradedTime', 'Status', 'OS', 'Version', 'JREVersion'],
								data : []
							}),
							flex: 1,
							autoScroll: true,
							scroll: true,
							columns: {
								defaults: {
									sortable: true,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: true
								},
								items: [
									{
										text: agentId,
										dataIndex: 'AgentID',
										flex: 1
									},
									{
										text: lastUpgrdPkg,
										id:'lastUpgrdPkg',
										dataIndex: 'LastUpgradedPackageID',
										flex: 1,
										hidden:true
									},
									{
										text: lastUpgTime,
										dataIndex: 'LastUpgradedTime',
										flex: 1
									},
									{
										text: status,
										dataIndex: 'Status',
										id:'statusCol',
										hidden:true,
										width: 80
									},
									{
										text: os,
										dataIndex: 'OS',
										id:'osCol',
										hidden:true,
										flex: 1
									},
									{
										text: version,
										dataIndex: 'Version',
										id:'verCol',
										hidden:true,
										width: 80
									},
									{
										text: jreVer,
										dataIndex: 'JREVersion',
										id:'jreVerCol',
										hidden:true,
										width: 100
									}
								]
							},
							margin: '0 10 10 10'
						}
					]
				},
				{
					title: tab2Title,
					id:'tab2',
					cls:'tabLayoutInnerBorder',
					style:{'border-top':'0px'},
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'customgrid',
							cls:'gridSkin',
							flex:1,
							id:'totalAgentsGrid',
							store: new Ext.data.Store({
								fields: ['OS', 'Agents'],
								data : []
							}),
							autoScroll: true,
							scroll: true,
							columns: {
								defaults: {
									sortable: true,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: opSys,
										dataIndex: 'OS',
										flex: 1
									},
									{
										text: agents,
										dataIndex: 'Agents',
										flex: 1
									}
								]
							},
							margin: 10
						},
						{
							xtype: 'container',
							id:'noAgentsConfigured',
							layout: {
								type: 'hbox',
								pack: 'center',
								align: 'center'
							},
							margin: 15,
							hidden: true,
							items: [
								{
									xtype: 'label',
									html: '<table><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+alrtMSg2+'.</td></tr></table></td></tr></table>'
								}
							]
						}
					]
				}
			]
		}
	]
});



