Ext.define('AgentXmx.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AgentXmxView'],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function(){
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main button[id="updateBtn"]':
			{
				'click': this.update
			},
			'main button[action=goback]':
			{
				'click': this.BackButtonOnClick
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('agentName').setValue(componentName);
		var loader = new Ext.LoadMask(Ext.getBody(), {msg: pleaseAlert});
		loader.show();
		loading = true;
		var param = "componentName="+encodeURI(componentName);
		Ext.Ajax.request(
		{
			url: 'AgentXmx/data/getXmx.jsp',
			params : param,
			method:'GET',
			timeout:300000,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					xmxJson = Ext.decode(jsonText);
					Ext.getCmp('updateBtn').setVisible(false);
					Ext.getCmp('currentXmx').setVisible(false);
					Ext.getCmp('newXmxValue').setVisible(false);
					if(xmxJson.timedout)
					{
						Ext.Msg.alert(pageName,timeoutAlert);
					}
					else
					{
						var displayXmx = xmxJson.XmxValue;
						if(displayXmx.toLowerCase().charAt(displayXmx.length-1)=='m')
						{
							xmxUnit = displayXmx.substring(displayXmx.length-1);
							displayXmx = displayXmx.substring(0,displayXmx.length-1);
						}
						Ext.getCmp('currentXmx').setValue(displayXmx);
						Ext.getCmp('currentXmx').setVisible(true);
						Ext.getCmp('newXmxValue').setVisible(true);
						Ext.getCmp('updateBtn').setVisible(true);
					}
					loader.hide();
					loading = false;
				}
			},
			failure : function(response)
			{
				loader.hide();
				loading = false;
			}
		});
	},
	BackButtonOnClick: function()
	{
		if(showAgentInformationView=='true')
		{
			window.location.href = '/final/admin/EgServerList.jsp?from=upgradeAdvancedSearchPage&agentIp='+encodeURI(agentID);
		}
		else
		{
			window.location.href = '/final/admin/EgServerList.jsp';
		}
	},
	update:function()
	{
		var currentXmx = Ext.getCmp('currentXmx').getValue().trim();
		var newXmx = Ext.getCmp('newXmxValue').getValue().trim();
		if(!checkblank(newXmx))
		{
			Ext.MessageBox.alert(pageName,emptyAlert);
		}
		else if(newXmx.indexOf(' ')>-1)
		{
			Ext.MessageBox.alert(pageName,spaceAlert);
		}
		else if(invalidCharsFound(newXmx))
		{
			Ext.MessageBox.alert(pageName,numberAlert);
		}
		else if(currentXmx==newXmx)
		{
			Ext.MessageBox.alert(pageName,sameValueAlert);
		}
		else if(parseInt(newXmx)<256)
		{
			Ext.MessageBox.alert(pageName,negativeAlert);
		}
		else
		{
			Ext.Msg.show({
				title: pageName,
				msg: restartAlert,
				buttons: Ext.Msg.YESNO,
				icon: 'iconConfirmation',
				fn: function(buttonText) {
					if(buttonText == "yes")
					{
						newXmx+=xmxUnit;
						var loader = new Ext.LoadMask(Ext.getBody(), {msg: pleaseAlert});
						loader.show();
						loading = true;
						var param = "componentName="+encodeURI(componentName)+'&currentXmxValue='+currentXmx+'&newXmxValue='+newXmx;
						Ext.Ajax.request(
						{
							url: 'AgentXmx/data/setXmx.jsp',
							params : param,
							method:'GET',
							timeout:300000,
							success: function(response)
							{
								if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
								{
									var jsonText = response.responseText;
									xmxJson = Ext.decode(jsonText);
									var thisAlert = '';
									if(xmxJson.timedout)
									{
										thisAlert = timeoutAlert;
									}
									else if(xmxJson.XmxValue.toLowerCase()=='done')
									{
										thisAlert = updatedMessage;
									}
									else
									{
										thisAlert = xmxJson.XmxValue;
									}
									Ext.Msg.show({
										title: pageName,
										msg: thisAlert,
										buttons: Ext.Msg.YES,
										icon: 'iconConfirmation',
										fn: function(buttonText) {
											if(buttonText == "yes")
											{
												loader.hide();
												loading = false;
												window.location.href = '/final/admin/EgServerList.jsp';
											}
										}
									});
									loader.hide();
									loading = false;
								}
							},
							failure : function(response)
							{
								loader.hide();
								loading = false;
							}
						});
					}
					else if(buttonText=="no"){
					}
				}
			});
		}
	}
});

function invalidCharsFound(val)
{
	var validChars = "0123456789";
	for (var i = 0; i < val.length; i++)
	{
		if (validChars.indexOf(val.charAt(i)) == -1)
		{
			return true;
		}
	}
	return false;
}
