Ext.define('Agentlog.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AgentLogView'],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function(){
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main combo[id="logdir"]':
			{
				'select': this.dirNameOnChange
			},
			'main combo[id="logfiles"]':
			{
				'select': this.fileNameOnChange
			},
			'main button[action=goback]':
			{
				'click': this.BackButtonOnClick
			},
			'main button[action=refresh]':
			{
				'click': this.RefreshOnchange
			},
			'main button[action=download]':
			{
				'click': this.DownloadOnchange
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('logdir').select(Ext.getCmp('logdir').getStore().getAt(0));
		var param = "componentName="+encodeURI(componentName);
		loading = false;
		Ext.getCmp('refresh').setDisabled(true);
		Ext.getCmp('download').setDisabled(true);
		Ext.select('.iconRefresh').elements[0].style = "opacity: 0.3;filter: alpha(opacity=30);";
		Ext.select('.iconDownload').elements[0].style = "opacity: 0.3;filter: alpha(opacity=30);";
		Ext.Ajax.request(
		{
			url: 'Agentlog/data/agentLogJson.jsp',
			params : param,
			method:'GET',
			timeout:180000,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					Ext.getCmp('logdir').getStore().suspendEvents(true);
					Ext.getCmp('logdir').getStore().loadRawData(publicJSON['logDirectoryList']);
					Ext.getCmp('logdir').getStore().resumeEvents();
					Ext.getCmp('logdir').select(Ext.getCmp('logdir').getStore().getAt(0));

					Ext.getCmp('logfiles').getStore().suspendEvents(true);
					Ext.getCmp('logfiles').getStore().loadRawData(publicJSON['logFileList']);
					Ext.getCmp('logfiles').getStore().resumeEvents();
					Ext.getCmp('logfiles').select(Ext.getCmp('logfiles').getStore().getAt(0));
				}
			},
			failure : function(respons)
			{
			}
		});
	},
	dirNameOnChange: function()
	{
		Ext.getCmp('resultTexts').reset();
		var dirname = Ext.getCmp('logdir').getValue();
		if(dirname == null || dirname == "-1")
		{
			Ext.MessageBox.alert(pageName,"Please choose a valid log directory");
			this.afterMainRender();
		}
		else
		{
			var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading... Please wait.'});
			loader.show();
			loading = true;
			var param = "componentName="+encodeURI(componentName)+"&dirname="+dirname+"&download=false";
			Ext.Ajax.request(
			{
				url: 'Agentlog/data/agentLogJson.jsp',
				params : param,
				method:'GET',
				timeout:180000,
				success: function(response)
				{
					if(response.status  == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						Ext.getCmp('logfiles').getStore().suspendEvents(true);
						Ext.getCmp('logfiles').getStore().loadRawData(publicJSON['logFileList']);
						Ext.getCmp('logfiles').select(Ext.getCmp('logfiles').getStore().getAt(0));
						Ext.getCmp('logfiles').getStore().resumeEvents();
						loader.hide();
						loading = false;
					}
				},
				failure : function(respons)
				{
					loader.hide();
					loading = false;
				}
			});
		}
	},
	fileNameOnChange: function()
	{
		Ext.getCmp('resultTexts').reset();
		var filename = Ext.getCmp('logfiles').getValue();
		if(filename == null || filename == "-1")
		{
			Ext.MessageBox.alert(pageName,"Please choose a valid log file.");
			this.afterMainRender();
		}
		else
		{
			var loader = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			loader.show();
			loading = true;
			Ext.getCmp('refresh').setDisabled(true);
			Ext.getCmp('download').setDisabled(true);
			Ext.select('.iconRefresh').elements[0].style = "opacity: 0.3;filter: alpha(opacity=30);";
			Ext.select('.iconDownload').elements[0].style = "opacity: 0.3;filter: alpha(opacity=30);";
			var param = "componentName="+encodeURI(componentName)+"&file="+filename+"&download=false";
			Ext.Ajax.request(
			{
				url: 'Agentlog/data/agentLogp.jsp',
				params : param,
				method:'GET',
				timeout:180000,
				success: function(response)
				{
					if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						if(jsonText.indexOf("~@~")>0 && jsonText.indexOf("&^&")>0)
						{
							var nick = jsonText.substring(0,jsonText.indexOf("~@~"));
							var logData = jsonText.substring(jsonText.indexOf("&^&")+3);
							Ext.Msg.alert(pageName,logData);
							Ext.getCmp('resultTexts').setValue("");
						}
						else
						{
							var nick = jsonText.substring(0,jsonText.indexOf("~@~"));
							var logData = jsonText.substring(jsonText.indexOf("~@~")+3);
							Ext.getCmp('resultTexts').setValue(logData);
							Ext.getCmp('refresh').setDisabled(false);
							Ext.getCmp('download').setDisabled(false);
							Ext.select('.iconRefresh').elements[0].style = "";
							Ext.select('.iconDownload').elements[0].style = "";
						}
						Ext.getCmp('ipnick').setTitle(nick);
						loader.hide();
						loading = false;
					}
				},
				failure : function(response)
				{
					loader.hide();
					loading = false;
				}
			});
		}
	},
	BackButtonOnClick: function()
	{
		if(showAgentInformationView=='true')
		{
			window.location.href = '/final/admin/EgServerList.jsp?from=upgradeAdvancedSearchPage&agentIp='+encodeURI(agentID);
		}
		else
		{
			window.location.href = '/final/admin/EgServerList.jsp';
		}
	},
	RefreshOnchange: function()
	{
		if(loading)
			Ext.Msg.alert(pageName,'Already Loading a file');
		else
		{
			Ext.getCmp('resultTexts').reset();
			this.fileNameOnChange();
		}
	},
	DownloadOnchange: function()
	{
		if(loading)
			Ext.Msg.alert(pageName,'Already Loading a file');
		else
		{
			var filename = Ext.getCmp('logfiles').getValue();
			window.location.href = 'Agentlog/data/agentLogp.jsp?componentName='+encodeURI(componentName)+'&file='+encodeURI(filename)+'&download=true&com.eg.CSRF_NONCE='+csrfToken;
		}
	}
});



