Ext.define('AggregateAddAllComponents.controller.Main',{
	extend:'Ext.app.Controller',
	views:['FormPanel'],

	init:function(){
		this.control({
				'formPanel':
				{
					'afterrender': this.afterMainRender,
				},
				'formPanel button[id="addAllButton"]':
				{
					'click': this.callAddAll
				},
				'formPanel button[id="backbutton"]' :
				{
					'click': this.back
				}
			});
		},
		afterMainRender: function()
		{
			Ext.Ajax.request(
			{
				url:'/final/admin/AggregateAddAllComponents/data/aggAddAllJSON.jsp',
				params : 'elementType='+elementType+'&elementName='+elementName,
				method:'POST',
				async:false,
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty( response.responseText ))
					{
						publicJSON = Ext.decode(response.responseText);
						if(publicJSON.externalAgentRunsAllAggTests)
						{
							Ext.getCmp('resultGrid').columns[2].setText(publicJSON.AgentLabel);
							Ext.getCmp('resultGrid').getStore().loadRawData(publicJSON['gridValues']);
							var externalAgents = publicJSON['externalAgents'];
							var defaultExternalAgent = publicJSON['defaultExternalAgents'];
							var resultGridObj = Ext.getCmp('resultGrid');
							var gridEditor = resultGridObj.columns[2].getEditor();
							gridEditor.getStore().loadRawData(externalAgents);
							gridEditor.setValue(defaultExternalAgent);
						}
						else
						{
							Ext.getCmp('resultGrid').columns[2].setText(publicJSON.AgentLabel);
							Ext.getCmp('resultGrid').getStore().loadRawData(publicJSON['gridValues']);
							var remoteAgents = publicJSON['remoteAgents'];
							var defaultRemoteAgent = publicJSON['defaultRemoteAgents'];
							var resultGridObj = Ext.getCmp('resultGrid');
							var gridEditor = resultGridObj.columns[2].getEditor();
							gridEditor.getStore().loadRawData(remoteAgents);
							gridEditor.setValue(defaultRemoteAgent);
						}
						if(elementType=='zone')
						{
							Ext.getCmp('allowedId').show();
						}
					}
				}
			});
		},
		callAddAll: function()
		{
			addAllComponents();
		},
		back: function()
		{
			window.location.href="/final/admin/aggShowTypes.jsp?operation=add&name="+elementName+"&element="+elementType;
		}
});

function addAllComponents()
{
	if(!hostnameCheck())
	{
		return;
	}
	if(searchDuplicateNicknamesInThisForm())
	{
		return;
	}
	else if(iseGReservedWord())
	{
		return;
	}
	else
	{
		var hostName="";
		var remote="";
		var tempVal_1="";
		var aggComponent="";
		var automatic_zone_association="";
		if(elementType=='zone')
		{
			automatic_zone_association=Ext.getCmp('yes').getValue();
		}
		var gridcount =Ext.getCmp('resultGrid').getStore().getCount();
		for(var i=0;i < gridcount;i++)
		{
			tempVal = Ext.getCmp('resultGrid').getStore().getAt(i).get('nickname');
			tempVal_1 = Ext.getCmp('resultGrid').getStore().getAt(i).get('remoteAgent');
			tempVal_2 = Ext.getCmp('resultGrid').getStore().getAt(i).get('componentType');

			if(gridcount == 1)
			{
				hostName=hostName+tempVal;
				remote = remote + tempVal_1;
				aggComponent = aggComponent+tempVal_2;
			}
			else
			{
				hostName=hostName+tempVal+",";
				remote = remote + tempVal_1+",";
				aggComponent = aggComponent+tempVal_2+",";
			}
		}
		var char_check = hostName.indexOf(",");
		var host="";
		var remoteAgent="";
		var agg_comp="";
		if(char_check > -1)
		{
			host = hostName.substring(0,hostName.lastIndexOf(","));
			remoteAgent = remote.substring(0,remote.lastIndexOf(","));
			agg_comp = aggComponent.substring(0,aggComponent.lastIndexOf(","));
		}
		else
		{
			host = hostName;
			remoteAgent = remote;
			agg_comp = aggComponent;
		}
		var formObj = Ext.getCmp("formpanel").getForm();
		if(formObj.isValid())
		{
			Ext.getCmp('selected_host_names').setValue(host);
			Ext.getCmp('selected_remote_agents').setValue(remoteAgent);

			formObj.submit({
				url:'/final/admin/aggAddAllp.jsp?elementName='+elementName+'&elementType='+elementType+'&automatic_zone_association='+automatic_zone_association,
				method: 'POST',
				standardSubmit: true,
				success: function(form, action){
				}
			})
		}
		else
		{
			Ext.MessageBox.alert(pageLabel,invalid_form);
		}
	}
}
function isHostnameAlreadyAssigned(idx, s_val)
{
	var existingNicks = publicJSON['existing_agg_nicks'];
	if(existingNicks == null || existingNicks == 'undefined')
	{
		return false;
	}
	var existingNicksArr = existingNicks.split(",");
	var gridObj = Ext.getCmp("resultGrid");
	var gridPlugin = gridObj.getPlugin("editableComoGrid");
	var temp = s_val.toLowerCase();
	for(var i=0;i<existingNicksArr.length;i++)
	{
		if(existingNicksArr[i]==temp)
		{
			//don't use Ext.MessageBox.alert
			alert('\'' + s_val + '\' ' + hostname_already_used);
			gridPlugin.startEditByPosition({row: idx,column: 1});
			return true;
		}
	}
	return false;
}

function searchDuplicateNicknamesInThisForm()
{
	var gridObj = Ext.getCmp("resultGrid");
	var gridPlugin = gridObj.getPlugin("editableComoGrid");

	var array_upper = new Array();
	var selectedObj_upper = Ext.getCmp('resultGrid').getSelectionModel();
	var gridStore_upper = Ext.getCmp('resultGrid').getStore();
	var upperMeasuresCount = gridStore_upper.getCount();
	for(var i=0;i<upperMeasuresCount;i++)
	{
		array_upper.push(gridStore_upper.getAt(i).get('nickname').toLowerCase());
	}
	for(var i=0;i<upperMeasuresCount;i++)
	{
		var s_desc = gridStore_upper.getAt(i).get('nickname');
		var temp = s_desc.toLowerCase();
		for(var j=0;j<upperMeasuresCount;j++)
		{
			if(i != j && temp==array_upper[j])
			{
				//don't use Ext.MessageBox.alert
				alert('\'' + s_desc + '\' ' + duplicate_nick_name);
				gridPlugin.startEditByPosition({row: j,column: 1});
				return true;
			}
		}
	}
	return false;
}
function iseGReservedWord()
{
	var resereved_arr=new Array();
	var temp=publicJSON['reservedWord'];
	var gridcount=Ext.getCmp('resultGrid').getStore().getCount();
	for(var i=0; i<temp.length; i++)
	{
		for(var j=0; j<gridcount; j++)
		{
			var tempVal = Ext.getCmp('resultGrid').getStore().getAt(j).get('nickname');
			if(tempVal == temp[i])
			{
				alert("\'"+tempVal+"\' "+reservedWord_alert);
				Ext.getCmp("resultGrid").getPlugin("editableComoGrid").startEditByPosition({row: j,column: 1});
				return true;
			}
		}
	}
	return false;
}

function hostnameCheck()
{
	var gridcount =Ext.getCmp('resultGrid').getStore().getCount();
	for(var i=0;i < gridcount;i++)
	{
		tempVal = Ext.getCmp('resultGrid').getStore().getAt(i).get('nickname');
		if(!validateHostname(i, tempVal))
		{
			return false;
		}
	}
	return true;
}

function validateHostname(idx, tempVal)
{
	var stype = "";
	var singleByteSupport=true;
	if(doubleByteEnabled=='false')
	{
		singleByteSupport = validateSingleByte(tempVal);
	}
	if(!checkblank(tempVal))
	{
		Ext.Msg.show({
			title: 'Error',
			msg: checkblank_alert,
			icon: 'iconExclamation',
			buttons: Ext.Msg.OK,
			fn : function(response){
				Ext.getCmp("resultGrid").getPlugin("editableComoGrid").startEditByPosition({row: idx,column: 1});
			}
		});
		return false;
	}
	else if(!checkspace(tempVal))
	{
		Ext.getCmp("resultGrid").getPlugin("editableComoGrid").startEditByPosition({row: idx,column: 1});
		return false;
	}
	else if(!checkspecial_(tempVal,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?/"))
	{
		Ext.getCmp("resultGrid").getPlugin("editableComoGrid").startEditByPosition({row: idx,column: 1});
		return false;
	}
	else if(!checkForHostType(tempVal))
	{
		Ext.Msg.show({
			title: 'Error',
			msg: internal_name_of_comp_type,
			icon: 'iconExclamation',
			buttons: Ext.Msg.OK,
			fn : function(response){
				Ext.getCmp("resultGrid").getPlugin("editableComoGrid").startEditByPosition({row: idx,column: 1});
			}
		});
		return false;
	}
	else if(!singleByteSupport)
	{
		Ext.Msg.show({
			title: 'Error',
			msg: singleByteSupport_alert,
			icon: 'iconExclamation',
			buttons: Ext.Msg.OK,
			fn : function(response){
				Ext.getCmp("resultGrid").getPlugin("editableComoGrid").startEditByPosition({row: idx,column: 1});
			}
		});
		return false;
	}
	else if(isHostnameAlreadyAssigned(idx, tempVal))
	{
		return false;
	}
	else if(doubleByteEnabled=='true')
	{
		if(!checkdots(tempVal))
		{
			Ext.getCmp("resultGrid").getPlugin("editableComoGrid").startEditByPosition({row: idx,column: 1});
			return false;
		}
	}
	return true;
}
function checkForHostType(tempVal)
{
	var srvTypes = publicJSON['server_types_internal_names'];
	for(var i=0; i < srvTypes.length; i++)
	{
		if(tempVal.toLowerCase()== srvTypes[i].toLowerCase())
		return false;
	}
	return true;
}
function checkdots(tempVal)
{
	var val = tempVal;
	if(val.charAt(0) == '.' || val.charAt(val.length - 1) == '.')
	{
		Ext.Msg.alert('Error',checkDot_alert);
		return false;
	}
	else
	{
		for(var k=0;k < val.length;k++)
		{
			if(val.charAt(k) == '.' && val.charAt(k + 1) == '.')
			{
				Ext.Msg.alert('Error',checkDot_consicutive_alert);
				return false;
			}
			else
			{
				continue;
			}
		}
	}
	return true;
}
function checkspace(tempVal)
{
	var s_val = tempVal;
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			Ext.Msg.alert('Error',_checkblank);
			return false;
		}
	}
	return true;
}
function checkspecial_(tempVal,s_spl)
{
	var obj_val = tempVal;
	for(var i=0; i<obj_val.length; i++)
	{
		var check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			Ext.Msg.alert('Error',_checkspecial);
			return false;
		}
	}
	return true;
}
function validateSingleByte(tempVal)
{
	for(var i=0;i<tempVal.length;i++)
	{
		var charValue=tempVal.charCodeAt(i);
		if(charValue>255)
			return false;
	}
	return true;
}