Ext.define('AggregateAddAllComponentsp.controller.Main',{
	extend:'Ext.app.Controller',
	views:['FormPanel'],

	init:function(){
			this.control({
				'formPanel':
				{
					'afterrender': this.afterMainRender,
				},
				'formPanel button[id="backbutton"]' :
				{
					'click': this.back
				}
			});
		},
		afterMainRender: function()
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
			myMask.show();
			Ext.Ajax.request(
			{
				url:'/final/admin/AggregateAddAllComponentsp/data/aggAddallpJSON.jsp',
				method:'POST',
				timeout: 300000,
				success: function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if(publicJSON['errorReported'] != null)
						{
							Ext.getCmp('errorMessage').update('<table><tr><td align="center" height="450"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+publicJSON['errorReported']['errorMessage']+'.</div></td></tr></table></td></tr></table>');
							Ext.getCmp('errorMessage_container').show();
						}
						else
						{
							if(publicJSON['addedComponents'] != null)
							{
								Ext.getCmp('resultGrid').getStore().loadRawData(publicJSON['addedComponents']);
								Ext.getCmp('resultGrid').show();
							}
							if(publicJSON['notAddedComponents'] != null)
							{
								Ext.getCmp('erro_resultGrid').getStore().loadRawData(publicJSON['notAddedComponents']);
								Ext.getCmp('erro_resultGrid').show();
							}
						}
					}
					myMask.hide();
				},
				failure : function(response)
				{
					myMask.hide();
				}
			});
		},
		back: function()
		{
			window.location.href="/final/admin/aggShowTypes.jsp?operation=add&name="+elementName+"&element="+elementType;
		}
});

